import os
import sys

from subprocess import check_output

def get_legion_var():
    """
    Get Legion values
    """

    v = {}
    v['cli_path'] = os.path.dirname(os.path.abspath(__file__ + '/../../'))
    v['legion_path'] = os.path.abspath(v['cli_path'] + '/../')
    v['tmp_server_path'] = '/tmp/legion-server'

    return v


def get_repo_var(workers=0):
    """
    Get values about current repo (the one that will be legionized)
    """
    v = {}
    v['repo'] = os.path.basename(check_output(['git', 'rev-parse', '--show-toplevel'])).strip()
    v['heroku_name'] = v['repo']

    v['workers'] = []
    for i in range(0, workers):
        v['workers'].append('%s-legion-%s' % (v['heroku_name'], i))

    return v


def check_legion_created(heroku_name):
    apps = check_output(['heroku', 'apps'])
    if heroku_name not in apps:
        sys.exit("Please run `legion create` before scaling up.")
