#!/usr/bin/env python
import sys

from subprocess import check_output, CalledProcessError

from legion.commands.create import create
from legion.commands.scale import scale
from legion.commands.destroy import destroy

def check_validity():
    """
    Check call originates from git repo
    """

    try:
        check_output(['git', 'status'])
    except CalledProcessError:
        sys.exit("Not a git repository")


def main(args):
    """
    Dispatch command to correct function
    """

    check_validity()

    commands = {
        'create': create,
        'scale': scale,
        'destroy': destroy
    }

    if len(args) < 2 or args[1] not in commands.keys():
        all_commands = ", ".join(commands.keys())
        sys.exit("Specify a command in %s" % all_commands)

    # Run actual command with remaining arguments
    commands[args[1]](args[2:])

if __name__ == '__main__':
    main(sys.argv)
