<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 * @ingroup SMWLanguage
 */

$aliases = array();

/** English */
$aliases['en'] = array(
	'Ask' => array( 'Ask' ),
	'Browse' => array( 'Browse' ),
	'ExportRDF' => array( 'ExportRDF' ),
	'PageProperty' => array( 'PageProperty' ),
	'Properties' => array( 'Properties' ),
	'SMWAdmin' => array( 'SMWAdmin' ),
	'SearchByProperty' => array( 'SearchByProperty' ),
	'SemanticStatistics' => array( 'SemanticStatistics' ),
	'Types' => array( 'Types' ),
	'URIResolver' => array( 'URIResolver' ),
	'UnusedProperties' => array( 'UnusedProperties' ),
	'WantedProperties' => array( 'WantedProperties' ),
);

/** Afrikaans (Afrikaans) */
$aliases['af'] = array(
	'Ask' => array( 'Vra' ),
	'Types' => array( 'Tipes' ),
);

/** Arabic (العربية) */
$aliases['ar'] = array(
	'Ask' => array( 'سؤال' ),
	'Browse' => array( 'تصفح' ),
	'ExportRDF' => array( 'تصدير_آر_دي_إف' ),
	'PageProperty' => array( 'خاصية_الصفحة' ),
	'Properties' => array( 'خصائص' ),
	'SMWAdmin' => array( 'إداري_سمو' ),
	'SearchByProperty' => array( 'بحث_بواسطة_الخاصية' ),
	'SemanticStatistics' => array( 'إحصاءات_سيمانتيك' ),
	'Types' => array( 'أنواع' ),
	'URIResolver' => array( 'محلل_يو_آر_آي' ),
	'UnusedProperties' => array( 'خصائص_غير_مستخدمة' ),
	'WantedProperties' => array( 'خصائص_مطلوبة' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$aliases['arz'] = array(
	'Ask' => array( 'سؤال' ),
	'Browse' => array( 'براوز' ),
	'ExportRDF' => array( 'تصدير_RDF' ),
	'PageProperty' => array( 'خاصية_الصفحه' ),
	'Properties' => array( 'خصايص' ),
	'SMWAdmin' => array( 'ادارى_SMW' ),
	'SearchByProperty' => array( 'دوّر_بالخاصيه' ),
	'SemanticStatistics' => array( 'إحصائيات_Semantic' ),
	'Types' => array( 'انواع' ),
	'URIResolver' => array( 'URI_Resolver' ),
	'UnusedProperties' => array( 'خصايص_مش_مستعمله' ),
	'WantedProperties' => array( 'خصايص_مطلوبه' ),
);

/** Breton (Brezhoneg) */
$aliases['br'] = array(
	'Ask' => array( 'Goulenn' ),
	'Browse' => array( 'Furchal' ),
	'ExportRDF' => array( 'EzorzhiañRDF' ),
	'PageProperty' => array( 'PerzhioùPajenn' ),
	'Properties' => array( 'Perzhioù' ),
	'Types' => array( 'Seurtoù' ),
);

/** Bosnian (Bosanski) */
$aliases['bs'] = array(
	'Ask' => array( 'Upit' ),
	'Browse' => array( 'Pregledanje' ),
	'ExportRDF' => array( 'IzvozRDF' ),
	'Properties' => array( 'Svojstva' ),
);

/** German (Deutsch) */
$aliases['de'] = array(
	'Ask' => array( 'Semantische Suche' ),
	'ExportRDF' => array( 'Exportiere RDF' ),
	'PageProperty' => array( 'Seitenattribut' ),
	'Properties' => array( 'Attribute' ),
	'SMWAdmin' => array( 'SMW-Einrichtung' ),
	'SearchByProperty' => array( 'Suche mittels Attribut' ),
	'SemanticStatistics' => array( 'Semantische Statistik' ),
	'Types' => array( 'Datentypen' ),
	'UnusedProperties' => array( 'Verwaiste Attribute' ),
	'WantedProperties' => array( 'Gewünschte Attribute' ),
);

/** Lower Sorbian (Dolnoserbski) */
$aliases['dsb'] = array(
	'Ask' => array( 'Semantiske pytanhje' ),
	'Browse' => array( 'Pśepytaś' ),
	'ExportRDF' => array( 'RDF eksportěrowaś' ),
	'PageProperty' => array( 'Bokowa kakosć' ),
	'Properties' => array( 'Kakosći' ),
	'SearchByProperty' => array( 'Z kakosću pytaś' ),
	'SemanticStatistics' => array( 'Semantiska statistika' ),
	'Types' => array( 'Datowe typy' ),
	'UnusedProperties' => array( 'Njewužywane kakosći' ),
	'WantedProperties' => array( 'Póžedane kakosći' ),
);

/** Divehi (ދިވެހިބަސް) */
$aliases['dv'] = array(
	'Ask' => array( 'އައްސަވާ' ),
);

/** Finnish (Suomi) */
$aliases['fi'] = array(
	'Ask' => array( 'Kysy' ),
	'Browse' => array( 'Selaa' ),
);

/** Galician (Galego) */
$aliases['gl'] = array(
	'Ask' => array( 'Preguntar' ),
	'Browse' => array( 'Navegar' ),
	'ExportRDF' => array( 'Exportar RDF' ),
	'PageProperty' => array( 'Propiedades da páxina' ),
	'Properties' => array( 'Propiedades' ),
	'SearchByProperty' => array( 'Procurar por propiedades' ),
	'SemanticStatistics' => array( 'Estatísticas semánticas' ),
	'Types' => array( 'Tipos' ),
	'UnusedProperties' => array( 'Propiedades sen uso' ),
	'WantedProperties' => array( 'Propiedades requiridas' ),
);

/** Swiss German (Alemannisch) */
$aliases['gsw'] = array(
	'Ask' => array( 'Semantischi Suech' ),
	'ExportRDF' => array( 'Exportier ADF' ),
	'PageProperty' => array( 'Syteattribut' ),
	'Properties' => array( 'Attribut' ),
	'SMWAdmin' => array( 'SMW-Yyrichtig' ),
	'SearchByProperty' => array( 'Suech no Attribut' ),
	'SemanticStatistics' => array( 'Semantischi Statischtik' ),
	'Types' => array( 'Datetype' ),
	'UnusedProperties' => array( 'Verwaisti Attribut' ),
	'WantedProperties' => array( 'Gwinschti Attribut' ),
);

/** Upper Sorbian (Hornjoserbsce) */
$aliases['hsb'] = array(
	'Ask' => array( 'Semantiske pytanje' ),
	'Browse' => array( 'Přepytać' ),
	'ExportRDF' => array( 'RDF eksportować' ),
	'PageProperty' => array( 'Kajkosć strony' ),
	'Properties' => array( 'Kajkosće' ),
	'SearchByProperty' => array( 'Pytanje po kajkosći' ),
	'SemanticStatistics' => array( 'Semantiska statistika' ),
	'Types' => array( 'Datowe typy' ),
	'UnusedProperties' => array( 'Njewužiwane kajkosće' ),
	'WantedProperties' => array( 'Falowace kajkosće' ),
);

/** Hungarian (Magyar) */
$aliases['hu'] = array(
	'Ask' => array( 'Kérdez' ),
	'Browse' => array( 'Böngészés' ),
	'Properties' => array( 'Tulajdonságok' ),
	'SemanticStatistics' => array( 'Szemantikus statisztika' ),
	'Types' => array( 'Típusok' ),
	'URIResolver' => array( 'URI-feloldó' ),
	'UnusedProperties' => array( 'Nem használt tulajdonságok' ),
	'WantedProperties' => array( 'Keresett tulajdonságok' ),
);

/** Interlingua (Interlingua) */
$aliases['ia'] = array(
	'Ask' => array( 'Consultar' ),
	'Browse' => array( 'Percurrer' ),
	'ExportRDF' => array( 'Exportar RDF' ),
	'PageProperty' => array( 'Proprietate de pagina' ),
	'Properties' => array( 'Proprietates' ),
	'SMWAdmin' => array( 'Admin SMW' ),
	'SearchByProperty' => array( 'Cercar per proprietate' ),
	'SemanticStatistics' => array( 'Statisticas semantic' ),
	'Types' => array( 'Typos' ),
	'URIResolver' => array( 'Resolvitor de URIs' ),
	'UnusedProperties' => array( 'Proprietates non usate' ),
	'WantedProperties' => array( 'Proprietates dsesirate' ),
);

/** Indonesian (Bahasa Indonesia) */
$aliases['id'] = array(
	'Ask' => array( 'Tanya' ),
	'Browse' => array( 'Jelajahi' ),
	'ExportRDF' => array( 'EksporRDF' ),
	'PageProperty' => array( 'PropertiHalaman' ),
	'Properties' => array( 'Properti' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'PencarianProperti' ),
	'SemanticStatistics' => array( 'StatistikSemantik' ),
	'Types' => array( 'Tipe' ),
	'URIResolver' => array( 'PenguraiURI' ),
	'UnusedProperties' => array( 'PropertiTakDigunakan' ),
	'WantedProperties' => array( 'PropertiDiinginkan' ),
);

/** Italian (Italiano) */
$aliases['it'] = array(
	'Ask' => array( 'Chiedi' ),
	'Browse' => array( 'Esplora' ),
	'ExportRDF' => array( 'EsportaRDF' ),
	'PageProperty' => array( 'ProprietàPagina' ),
	'Properties' => array( 'Proprietà' ),
	'SearchByProperty' => array( 'CercaPerProprietà' ),
	'SemanticStatistics' => array( 'StatisticheSemantiche' ),
	'Types' => array( 'Tipi' ),
	'UnusedProperties' => array( 'ProprietàNonUtilizzate' ),
	'WantedProperties' => array( 'ProprietàRichieste' ),
);

/** Japanese (日本語) */
$aliases['ja'] = array(
	'Ask' => array( '問い合わせ', '意味的検索' ),
	'Browse' => array( '閲覧' ),
	'ExportRDF' => array( 'RDFエクスポート', 'ＲＤＦエクスポート' ),
	'PageProperty' => array( 'ページプロパティ' ),
	'Properties' => array( 'プロパティ一覧' ),
	'SMWAdmin' => array( 'SMW管理' ),
	'SearchByProperty' => array( 'プロパティによる検索' ),
	'SemanticStatistics' => array( '意味的統計' ),
	'Types' => array( '型一覧' ),
	'URIResolver' => array( 'URIリゾルバー', 'ＵＲＩリゾルバー' ),
	'UnusedProperties' => array( '使われていないプロパティ' ),
	'WantedProperties' => array( '望まれているプロパティ' ),
);

/** Khmer (ភាសាខ្មែរ) */
$aliases['km'] = array(
	'Browse' => array( 'រាវរក' ),
	'Properties' => array( 'លក្ខណៈ' ),
	'Types' => array( 'ប្រភេទ' ),
);

/** Colognian (Ripoarisch) */
$aliases['ksh'] = array(
	'Ask' => array( 'Froore' ),
	'Browse' => array( 'Bläddere' ),
	'ExportRDF' => array( 'RDF', 'RDF Äxpotteere' ),
	'PageProperty' => array( 'Eijeschaffte vun Sigge' ),
	'Properties' => array( 'Eijeschaffte' ),
	'SMWAdmin' => array( 'Semantesch MediaWiki Ennreschte' ),
	'SearchByProperty' => array( 'Noh Eijeschaffte söke' ),
	'SemanticStatistics' => array( 'Semantesch Shtatistike' ),
	'Types' => array( 'Zoote vun Daate' ),
	'UnusedProperties' => array( 'Eijeschaffte di nit jebruch wääde' ),
	'WantedProperties' => array( 'Eijeschaffte di noch jebruch wääde' ),
);

/** Cornish (Kernewek) */
$aliases['kw'] = array(
	'Ask' => array( 'Govyn' ),
	'Browse' => array( 'Peuri' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$aliases['lb'] = array(
	'Ask' => array( 'Froen' ),
	'ExportRDF' => array( 'RDF exportéieren' ),
	'PageProperty' => array( 'Säiten-Eegeschaften' ),
	'Properties' => array( 'Eegeschaften' ),
	'SearchByProperty' => array( 'No Eegeschaft sichen' ),
	'SemanticStatistics' => array( 'Semantesch Statistiken' ),
	'Types' => array( 'Datentypen' ),
	'UnusedProperties' => array( 'Netbenotzten Eegeschaften' ),
	'WantedProperties' => array( 'Gewënschten Eegeschaften' ),
);

/** Lumbaart (Lumbaart) */
$aliases['lmo'] = array(
	'Ask' => array( 'Ciama' ),
);

/** Macedonian (Македонски) */
$aliases['mk'] = array(
	'Ask' => array( 'Прашај' ),
	'Browse' => array( 'Прелистај' ),
	'ExportRDF' => array( 'ИзвезиRDF' ),
	'PageProperty' => array( 'СвојстваНаСтраница' ),
	'Properties' => array( 'Својства' ),
	'Types' => array( 'Типови' ),
	'UnusedProperties' => array( 'НекористениСвојства' ),
	'WantedProperties' => array( 'БараниСвојства' ),
);

/** Malayalam (മലയാളം) */
$aliases['ml'] = array(
	'Ask' => array( 'ചോദിക്കുക' ),
	'Browse' => array( 'ബ്രൗസ്' ),
	'Types' => array( 'തരങ്ങൾ' ),
);

/** Marathi (मराठी) */
$aliases['mr'] = array(
	'Ask' => array( 'विचारा' ),
	'Browse' => array( 'न्याहाळा' ),
	'ExportRDF' => array( 'आरडीएफनिर्यात' ),
	'PageProperty' => array( 'पानवैशिष्ट्ये' ),
	'Properties' => array( 'वैशिष्ट्ये' ),
	'SMWAdmin' => array( 'एसएमडब्ल्यूप्रचालक' ),
	'SearchByProperty' => array( 'वैशिष्ट्येनुसारशोध' ),
	'SemanticStatistics' => array( 'सिमॅंटीकसांख्यिकी' ),
	'Types' => array( 'प्रकार' ),
	'URIResolver' => array( 'यूआरायरिझॉल्व्हर' ),
	'UnusedProperties' => array( 'नवापरलेलीवैशिष्ट्ये' ),
	'WantedProperties' => array( 'हवीअसलेलीवैशिष्ट्ये' ),
);

/** Maltese (Malti) */
$aliases['mt'] = array(
	'Ask' => array( 'Staqsi' ),
	'Browse' => array( 'Esplora' ),
);

/** Nedersaksisch (Nedersaksisch) */
$aliases['nds-nl'] = array(
	'Browse' => array( 'Bekieken' ),
	'ExportRDF' => array( 'RDF_uutvoeren' ),
	'PageProperty' => array( 'Pagina-eigenschap' ),
	'SMWAdmin' => array( 'SMW-beheer' ),
	'SearchByProperty' => array( 'Op_eigenschap_zeuken' ),
	'SemanticStatistics' => array( 'Semantische_staotestieken' ),
	'UnusedProperties' => array( 'Ongebruken_eigenschappen' ),
	'WantedProperties' => array( 'Gewunste_eigenschappen' ),
);

/** Dutch (Nederlands) */
$aliases['nl'] = array(
	'Ask' => array( 'Vragen' ),
	'Browse' => array( 'Bekijken' ),
	'ExportRDF' => array( 'RDFExporteren' ),
	'PageProperty' => array( 'Paginaeigenschap' ),
	'Properties' => array( 'Eigenschappen' ),
	'SMWAdmin' => array( 'SMWBeheer' ),
	'SearchByProperty' => array( 'OpEigenschapZoeken' ),
	'SemanticStatistics' => array( 'SemantischeStatistieken' ),
	'Types' => array( 'Typen' ),
	'UnusedProperties' => array( 'OngebruikteEigenschappen' ),
	'WantedProperties' => array( 'GewensteEigenschappen' ),
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬) */
$aliases['no'] = array(
	'Ask' => array( 'Spør' ),
	'Browse' => array( 'Se gjennom' ),
	'ExportRDF' => array( 'Eksporter RDF' ),
	'PageProperty' => array( 'Sideegenskaper' ),
	'Properties' => array( 'Egenskaper' ),
	'SMWAdmin' => array( 'SMW-administrasjon' ),
	'SearchByProperty' => array( 'Søk etter egenskap' ),
	'SemanticStatistics' => array( 'Semantisk statistikk' ),
	'Types' => array( 'Typer' ),
	'UnusedProperties' => array( 'Ubrukte egenskaper' ),
	'WantedProperties' => array( 'Ønskede egenskaper' ),
);

/** Occitan (Occitan) */
$aliases['oc'] = array(
	'Browse' => array( 'Percórrer' ),
	'Properties' => array( 'Proprietats' ),
	'Types' => array( 'Tipes' ),
	'UnusedProperties' => array( 'Proprietats inutilizadas', 'ProprietatsInutilizadas' ),
	'WantedProperties' => array( 'Proprietats demandadas', 'ProprietatsDemandadas' ),
);

/** Polish (Polski) */
$aliases['pl'] = array(
	'Ask' => array( 'Pytanie' ),
	'Browse' => array( 'Przegląd' ),
	'ExportRDF' => array( 'EksportRDF' ),
	'PageProperty' => array( 'WłasnośćStrony' ),
	'Properties' => array( 'Własności' ),
	'SMWAdmin' => array( 'AdminSMW' ),
	'SearchByProperty' => array( 'SzukanieWgWłasności' ),
	'SemanticStatistics' => array( 'StatystykiSemantyczne' ),
	'Types' => array( 'Typy' ),
	'URIResolver' => array( 'ResolverURI' ),
	'UnusedProperties' => array( 'NieużywaneWłasności' ),
	'WantedProperties' => array( 'PotrzebneWłasności' ),
);

/** Pashto (پښتو) */
$aliases['ps'] = array(
	'Ask' => array( 'پوښتل' ),
	'Browse' => array( 'سپړل' ),
	'PageProperty' => array( 'د مخ ځانتياوې' ),
	'Properties' => array( 'ځانتياوې' ),
	'Types' => array( 'ډولونه' ),
	'UnusedProperties' => array( 'ناکارېدلې ځانتياوې' ),
);

/** Portuguese (Português) */
$aliases['pt'] = array(
	'Ask' => array( 'Pedir' ),
	'Browse' => array( 'Navegar' ),
	'ExportRDF' => array( 'Exportar RDF' ),
	'PageProperty' => array( 'Propriedade de página' ),
	'Properties' => array( 'Propriedades' ),
	'SearchByProperty' => array( 'Pesquisar propriedade' ),
	'SemanticStatistics' => array( 'Estatísticas de semântica' ),
	'Types' => array( 'Tipos' ),
	'UnusedProperties' => array( 'Propriedades não utilizadas' ),
	'WantedProperties' => array( 'Propriedades desejadas' ),
);

/** Romanian (Română) */
$aliases['ro'] = array(
	'Browse' => array( 'Răsfoieşte' ),
);

/** Slovak (Slovenčina) */
$aliases['sk'] = array(
	'Ask' => array( 'SpýtaťSa' ),
	'Browse' => array( 'Prehliadať' ),
	'PageProperty' => array( 'VlastnostiStránky' ),
	'Properties' => array( 'Vlastnosti' ),
	'SMWAdmin' => array( 'SprávcaSMW' ),
	'SearchByProperty' => array( 'HľadaniePodľaVlastností' ),
	'SemanticStatistics' => array( 'SémantickéŠtatistiky' ),
	'Types' => array( 'Typy' ),
	'URIResolver' => array( 'PrekladURI' ),
	'UnusedProperties' => array( 'NepoužívanéVlastnosti' ),
	'WantedProperties' => array( 'ŽiadanéVlastnosti' ),
);

/** Albanian (Shqip) */
$aliases['sq'] = array(
	'Ask' => array( 'Pyet' ),
	'Browse' => array( 'Sille' ),
);

/** Swahili (Kiswahili) */
$aliases['sw'] = array(
	'Ask' => array( 'Uliza' ),
	'Browse' => array( 'Fungua' ),
	'Types' => array( 'Aina' ),
);

/** Telugu (తెలుగు) */
$aliases['te'] = array(
	'Ask' => array( 'అడుగు' ),
);

/** Tagalog (Tagalog) */
$aliases['tl'] = array(
	'Ask' => array( 'Magtanong' ),
	'Browse' => array( 'Tumingin-tingin' ),
	'ExportRDF' => array( 'Iluwas ang RDF' ),
	'PageProperty' => array( 'Pag-aari ng pahina' ),
	'Properties' => array( 'Mga pag-aari' ),
	'SMWAdmin' => array( 'Tagapangasiwa ng SMW' ),
	'SearchByProperty' => array( 'Maghanap ayon sa pag-aari' ),
	'SemanticStatistics' => array( 'Mga estadistika ng semantiko' ),
	'Types' => array( 'Mga uri' ),
	'URIResolver' => array( 'Tagapaglutas ng URI' ),
	'UnusedProperties' => array( 'Mga pag-aaring hindi ginagamit' ),
	'WantedProperties' => array( 'Mga pag-aaring ninanais' ),
);

/** Turkish (Türkçe) */
$aliases['tr'] = array(
	'Ask' => array( 'Sor' ),
	'Browse' => array( 'Gezin' ),
	'ExportRDF' => array( 'RDFAktar' ),
	'PageProperty' => array( 'SayfaÖzelliği' ),
	'Properties' => array( 'Özellikler' ),
	'SMWAdmin' => array( 'SMWHizmetlisi' ),
	'SearchByProperty' => array( 'ÖzelliğeGöreAra' ),
	'SemanticStatistics' => array( 'Anlamİstatistikleri' ),
	'Types' => array( 'Türler', 'Tipler' ),
	'URIResolver' => array( 'URIÇözücü' ),
	'UnusedProperties' => array( 'KullanılmayanÖzellikler' ),
	'WantedProperties' => array( 'İstenenÖzellikler' ),
);

/** Vèneto (Vèneto) */
$aliases['vec'] = array(
	'Browse' => array( 'Sfója' ),
	'Properties' => array( 'Proprietà' ),
	'Types' => array( 'Tipi' ),
);

