<?php

/**
 * File holding the SMWSpecialOWLExport class for the Special:ExportRDF page.
 *
 * @file SMW_SpecialOWLExport.php
 *
 * @ingroup SMWSpecialPage
 * @ingroup SpecialPage
 *
 * @author Markus Krötzsch
 * @author Jeroen De Dauw
 */

if ( !defined( 'MEDIAWIKI' ) ) {
	die( 'Not an entry point.' );
}

/**
 * This special page for MediaWiki implements an OWL-export of semantic data,
 * gathered both from the annotations in articles, and from metadata already
 * present in the database.
 *
 * @ingroup SMWSpecialPage
 * @ingroup SpecialPage
 *
 * @author Markus Krötzsch
 */
class SMWSpecialOWLExport extends SpecialPage {

	public function __construct() {
		parent::__construct( 'ExportRDF' );
	}

	public function execute( $page = '' ) {
		global $wgOut, $wgRequest, $wgUser, $smwgAllowRecursiveExport, $smwgExportBacklinks, $smwgExportAll;

		$wgOut->setPageTitle( wfMsg( 'exportrdf' ) );

		$recursive = 0;  // default, no recursion
		$backlinks = $smwgExportBacklinks; // default

		// Check whether we already know what to export.
		if ( $page == '' ) {
			// Try to get GET parameter; simple way of calling the export.
			$page = $wgRequest->getVal( 'page' );
		} else {
			// This is needed since MediaWiki 1.8, but it is wrong for 1.7.
			$page = rawurldecode( $page );
		}

		if ( $page == '' ) { 
			// Try to get POST list; some settings are only available via POST.
			$pageblob = $wgRequest->getText( 'pages' );
			
			if ( $pageblob != '' ) {
				$pages = explode( "\n", $pageblob );
			}
		} else {
			$pages = array( $page );
		}

		if ( isset( $pages ) ) {  // export to RDF
			$wgOut->disable();
			ob_start();

			// Only use rdf+xml mimetype if explicitly requested
			// TODO: should the see also links in the exported RDF then have this parameter as well?
			if ( $wgRequest->getVal( 'xmlmime' ) == 'rdf' ) {
				header( "Content-type: application/rdf+xml; charset=UTF-8" );
			} else {
				header( "Content-type: application/xml; charset=UTF-8" );
			}

			// Effect: assume "no" from missing parameters generated by checkboxes.
			$postform = $wgRequest->getText( 'postform' ) == 1;

			$rec = $wgRequest->getText( 'recursive' );
			
			if ( $rec == '' ) $rec = $wgRequest->getVal( 'recursive' );
			
			if ( ( $rec == '1' ) && ( $smwgAllowRecursiveExport || $wgUser->isAllowed( 'delete' ) ) ) {
				$recursive = 1; // users may be allowed to switch it on
			}
			
			$bl = $wgRequest->getText( 'backlinks' );
			
			if ( $bl == '' ) $bl = $wgRequest->getVal( 'backlinks' );
			
			if ( ( $bl == '1' ) && ( $wgUser->isAllowed( 'delete' ) ) ) {
				$backlinks = true; // admins can always switch on backlinks
			} elseif ( ( $bl == '0' ) || ( '' == $bl && $postform ) ) {
				$backlinks = false; // everybody can explicitly switch off backlinks
			}
			
			$date = $wgRequest->getText( 'date' );
			
			if ( $date == '' ) $date = $wgRequest->getVal( 'date' );

			$exp = new SMWOWLExport();
			
			if ( $date != '' ) $exp->setDate( $date );
			
			$exp->printPages( $pages, $recursive, $backlinks );
			
			return;
		} else {
			$offset = $wgRequest->getVal( 'offset' );
			
			if ( isset( $offset ) ) {
				$wgOut->disable();
				
				ob_start();
				header( "Content-type: application/xml; charset=UTF-8" );
				
				$exp = new SMWOWLExport();
				$exp->printPageList( $offset );
				
				return;
			} else {
				$stats = $wgRequest->getVal( 'stats' );
				
				if ( isset( $stats ) ) {
					$wgOut->disable();
					
					ob_start();
					header( "Content-type: application/xml; charset=UTF-8" );
					
					$exp = new SMWOWLExport();
					$exp->printWikiInfo();
				}
			}
		}

		smwfLoadExtensionMessages( 'SemanticMediaWiki' );

		// nothing exported yet; show user interface:
		$html = '<form name="tripleSearch" action="" method="POST">' . "\n" .
		        '<p>' . wfMsg( 'smw_exportrdf_docu' ) . "</p>\n" .
		        '<input type="hidden" name="postform" value="1"/>' . "\n" .
		        '<textarea name="pages" cols="40" rows="10"></textarea><br />' . "\n";
		
		if ( $wgUser->isAllowed( 'delete' ) || $smwgAllowRecursiveExport ) {
			$html .= '<input type="checkbox" name="recursive" value="1" id="rec">&#160;<label for="rec">' . wfMsg( 'smw_exportrdf_recursive' ) . '</label></input><br />' . "\n";
		}
		
		if ( $wgUser->isAllowed( 'delete' ) || $smwgExportBacklinks ) {
			$html .= '<input type="checkbox" name="backlinks" value="1" default="true" id="bl">&#160;<label for="bl">' . wfMsg( 'smw_exportrdf_backlinks' ) . '</label></input><br />' . "\n";
		}
		
		if ( $wgUser->isAllowed( 'delete' ) || $smwgExportAll ) {
			$html .= '<br />';
			$html .= '<input type="text" name="date" value="' . date( DATE_W3C, mktime( 0, 0, 0, 1, 1, 2000 ) ) . '" id="date">&#160;<label for="ea">' . wfMsg( 'smw_exportrdf_lastdate' ) . '</label></input><br />' . "\n";
		}
		
		$html .= "<br /><input type=\"submit\"  value=\"" . wfMsg( 'smw_exportrdf_submit' ) . "\"/>\n</form>";
		
		$wgOut->addHTML( $html );
	}

}