<?php
/**
 * Internationalization file for Semantic MediaWiki
 *
 * @file
 * @ingroup Language
 * @ingroup I18n
 * @ingroup SMWLanguage
 */

// FIXME: Can be enabled when new style magic words are used (introduced in r52503)
// require_once( dirname( __FILE__ ) . '/SMW_Magic.php' );

$messages = array();

/** English
 *  @author Markus Krötzsch
 */
$messages['en'] = array(
	'smw-desc'              => 'Making your wiki more accessible - for machines \'\'and\'\' humans ([http://semantic-mediawiki.org/wiki/Help:User_manual online documentation])',
	'smw_edithelp'          => 'Editing help on properties',
	'smw_viewasrdf'         => 'RDF feed',
	'smw_finallistconjunct' => ', and', // used in "A, B, and C"
	'smw_factbox_head'      => 'Facts about $1',
	'smw_isspecprop'        => 'This property is a special property in this wiki.',
	'smw_isknowntype'       => 'This type is among the standard datatypes of this wiki.',
	'smw_isaliastype'       => 'This type is an alias for the datatype "$1".',
	'smw_isnotype'          => 'This type "$1" is not a standard datatype in the wiki, and has not been given a user definition either.',
	'smw_concept_description' => 'Description of concept "$1"', // used in the namespace "Concept:"
	'smw_no_concept_namespace' => 'Concepts can only be defined on pages in the Concept: namespace.',
	'smw_multiple_concepts'   => 'Each concept page can have only one concept definition.',
	'smw_concept_cache_miss'  => 'The concept "$1" can not be used at the moment, since the wiki configuration requires it to be computed off-line.
If the problem does not go away after some time, ask your site administrator to make this concept available.',
	'smw_noinvannot'        => 'Values cannot be assigned to inverse properties.',

	// URIs that should not be used in objects in cases where users can provide URIs
	'smw_uri_blacklist' => " http://www.w3.org/1999/02/22-rdf-syntax-ns#\n http://www.w3.org/2000/01/rdf-schema#\n http://www.w3.org/2002/07/owl#",
	'smw_baduri'        => 'URIs of the form "$1" are not allowed.',

	// Link to RSS feeds
	'smw_rss_link' => 'RSS',
	// Link to CSV feeds
	'smw_csv_link' => 'CSV',
	// Link to JSON feeds
	'smw_json_link' => 'JSON',

	// Names for result formats:
	'smw_printername_auto' => 'Automatic',
	'smw_printername_count' => 'Count results',
	'smw_printername_csv' => 'CSV export',
	'smw_printername_debug' => 'Debug query (for experts)',
	'smw_printername_embedded' => 'Embed page contents',
	'smw_printername_json' => 'JSON export',
	'smw_printername_list' => 'List',
	'smw_printername_ol' => 'Enumeration',
	'smw_printername_ul' => 'Itemization',
	'smw_printername_rss' => 'RSS export',
	'smw_printername_table' => 'Table',
	'smw_printername_broadtable' => 'Broad table',
	'smw_printername_template' => 'Template',

	// Messages for query parameter descriptions
	'smw_paramdesc_limit'	=> 'The maximum number of results to return',
	'smw_paramdesc_headers'	=> 'Display the headers/property names',
	'smw_paramdesc_mainlabel'	=> 'The label to give to the main page name',
	'smw_paramdesc_link'	=> 'Show values as links',
	'smw_paramdesc_intro'	=> 'The text to display before the query results, if there are any',
	'smw_paramdesc_outro'	=> 'The text to display after the query results, if there are any',
	'smw_paramdesc_default'	=> 'The text to display if there are no query results',
	'smw_paramdesc_searchlabel'	=> 'The text in the link to results',
	'smw_paramdesc_sep'	=> 'The separator for values',
	'smw_paramdesc_template'	=> 'The name of a template with which to display the printouts',
	'smw_paramdesc_columns'	=> 'The number of columns in which to display results (default is $1)',
	'smw_paramdesc_embedformat'	=> 'The HTML tag used to define headings',
	'smw_paramdesc_embedonly'	=> 'Display no headings',
	'smw_paramdesc_rsstitle'	=> 'The text to be used as the title of the feed',
	'smw_paramdesc_rssdescription'	=> 'The text to be used as the description of the feed',

	// Messages and strings for inline queries
	'smw_iq_disabled'    => "Semantic queries have been disabled for this wiki.",
	'smw_iq_moreresults' => '… further results',
	'smw_iq_nojs'        => 'Use a JavaScript-enabled browser to view this element.',
	'smw_iq_altresults'  => 'Browse the result list directly.', // available link when JS is disabled

	// Messages and strings for ontology resued (import)
	'smw_unknown_importns'    => 'Import functions are not available for namespace "$1".',
	'smw_nonright_importtype' => '$1 can only be used for pages with namespace "$2".',
	'smw_wrong_importtype'    => '$1 can not be used for pages in the namespace "$2".',
	'smw_no_importelement'    => 'Element "$1" not available for import.',

	// Messages and strings for basic datatype processing
	'smw_parseerror'    => 'The given value was not understood.', // generic error, "something" went wrong
	'smw_decseparator'  => '.',
	'smw_kiloseparator' => ',',
	'smw_notitle'       => '"$1" cannot be used as a page name in this wiki.',
	'smw_wrong_namespace' => 'Only pages in namespace "$1" are allowed here.',
	'smw_unknowntype'   => 'Unsupported type "$1" defined for property.',
	'smw_manytypes'     => 'More than one type defined for property.',
	'smw_emptystring'   => 'Empty strings are not accepted.',
	'smw_maxstring'     => 'String representation $1 is too long.',
	'smw_notinenum'     => '"$1" is not in the list of possible values ($2) for this property.',
	'smw_noboolean'     => '"$1" is not recognized as a Boolean (true/false) value.',
	'smw_true_words'    => 'true,t,yes,y', // comma-separated synonyms for Boolean TRUE besides '1', primary value first
	'smw_false_words'   => 'false,f,no,n', // comma-separated synonyms for Boolean FALSE besides '0', primary value first
	'smw_nofloat'       => '"$1" is not a number.',
	'smw_infinite'      => 'Numbers as large as "$1" are not supported.',
	'smw_infinite_unit' => 'Conversion into unit "$1" resulted in a number that is too large.',
	'smw_novalues'		=> 'No values specified.',

	// Currently unused, floats silently store units.  'smw_unexpectedunit' => 'this property supports no unit conversion',
	'smw_unsupportedprefix' => 'Prefixes for numbers ("$1") are not supported.',
	'smw_unsupportedunit'   => 'Unit conversion for unit "$1" not supported.',

	// some links for online maps; can be translated to different language versions of services, but need not
	'smw_service_online_maps' => " Find&nbsp;online&nbsp;maps|http://tools.wikimedia.de/~magnus/geo/geohack.php?params=\$9_\$7_\$10_\$8\n Google&nbsp;maps|http://maps.google.com/maps?ll=\$11\$9,\$12\$10&spn=0.1,0.1&t=k\n Mapquest|http://www.mapquest.com/maps/map.adp?searchtype=address&formtype=latlong&latlongtype=degrees&latdeg=\$11\$1&latmin=\$3&latsec=\$5&longdeg=\$12\$2&longmin=\$4&longsec=\$6&zoom=6",

	// Messages for datetime parsing
	'smw_nodatetime' => 'The date "$1" was not understood.',

	// Errors and notices related to queries
	'smw_toomanyclosing'    => 'There appear to be too many occurrences of "$1" in the query.',
	'smw_noclosingbrackets' => 'Some use of "<nowiki>[[</nowiki>" in your query was not closed by a matching "]]".',
	'smw_misplacedsymbol'   => 'The symbol "$1" was used in a place where it is not useful.',
	'smw_unexpectedpart'    => 'The part "$1" of the query was not understood.
Results might not be as expected.',
	'smw_emptysubquery'     => 'Some subquery has no valid condition.',
	'smw_misplacedsubquery' => 'Some subquery was used in a place where no subqueries are allowed.',
	'smw_valuesubquery'     => 'Subqueries not supported for values of property "$1".',
	'smw_overprintoutlimit' => 'The query contains too many printout requests.',
	'smw_badprintout'       => 'Some print statement in the query was misshaped.',
	'smw_badtitle'          => '"$1" is no valid page title.',
	'smw_badqueryatom'      => 'Some part "<nowiki>[[…]]</nowiki>" of the query was not understood.',
	'smw_propvalueproblem'  => 'The value of property "$1" was not understood.',
	'smw_noqueryfeature'    => 'Some query feature was not supported in this wiki and part of the query was dropped ($1).',
	'smw_noconjunctions'    => 'Conjunctions in queries are not supported in this wiki and part of the query was dropped ($1).',
	'smw_nodisjunctions'    => 'Disjunctions in queries are not supported in this wiki and part of the query was dropped ($1).',
	'smw_querytoolarge'     => 'The following query conditions could not be considered due to the wikis restrictions in query size or depth: $1.',
	'smw_devel_warning'     => 'This feature is currently under development, and might not be fully functional.
Backup your data before using it.',
	'smw_notemplategiven'   => 'Provide a value for the parameter "template" for this query format to work.',

	// Messages for pages of types and properties
	'smw_type_header'             => 'Properties of type "$1"',
	'smw_typearticlecount'        => 'Showing $1 {{PLURAL:$1|property|properties}} using this type.',
	'smw_attribute_header'        => 'Pages using the property "$1"',
	'smw_attributearticlecount'   => 'Showing $1 {{PLURAL:$1|page|pages}} using this property.',
	'smw_subproperty_header'      => 'Subproperties',
	'smw_subpropertyarticlecount' => 'This property has the following $1 {{PLURAL:$1|subproperty|subproperties}}:',
	'smw_concept_header'          => 'Pages of concept "$1"',
	'smw_conceptarticlecount'     => 'Showing $1 {{PLURAL:$1|page|pages}} belonging to that concept.',

	// Messages used in RSS feeds
	'smw_rss_description' => '$1 RSS feed',

	// Group name for SMW special pages
	'specialpages-group-smw_group' => 'Semantic MediaWiki',

	// Messages for Export RDF Special
	'exportrdf'               => 'Export pages to RDF', // name of this special
	'smw_exportrdf_docu'      => 'This page allows you to obtain data from a page in RDF format.
To export pages, enter the titles in the text box below, one title per line.',
	'smw_exportrdf_recursive' => 'Recursively export all related pages.
Note that the result could be large!',
	'smw_exportrdf_backlinks' => 'Also export all pages that refer to the exported pages.
Generates browsable RDF.',
	'smw_exportrdf_lastdate'  => 'Do not export pages that were not changed since the given point in time.',
	'smw_exportrdf_submit'  => 'Export',

	// Messages for Properties Special
	'properties'             => 'Properties',
	'smw_properties_docu'    => 'The following properties are used in the wiki.',
	'smw_property_template'  => '$1 of type $2 ($3)', // <propname> of type <type> (<count>)
	'smw_propertylackspage'  => 'All properties should be described by a page!',
	'smw_propertylackstype'  => 'No type was specified for this property (assuming type $1 for now).',
	'smw_propertyhardlyused' => 'This property is hardly used within the wiki!',

	// Messages for Unused Properties Special
	'unusedproperties' => 'Unused properties',
	'smw_unusedproperties_docu' => 'The following properties exist although no other page makes use of them.',
	'smw_unusedproperty_template' => '$1 of type $2', // <propname> of type <type>

	// Messages for Wanted Properties Special
	'wantedproperties'            => 'Wanted properties',
	'smw_wantedproperties_docu'   => 'The following properties are used in the wiki but do not yet have a page for describing them.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|use|uses}})', // <propname> (<count> uses)

	// Messages for the refresh button
	'tooltip-purge' => 'Click here to refresh all queries and templates on this page',
	'smw_purge'     => 'Refresh',

	// Messages for (data)Types Special
	'types'          => 'Types',
	'smw_types_docu' => 'The following is a list of all datatypes that can be assigned to properties.
Each datatype has a page where additional information can be provided.',
	'smw_typeunits'  => 'Units of measurement of type "$1": $2',

	/*Messages for SemanticStatistics Special*/
	'semanticstatistics' => 'Semantic statistics',
	'smw_semstats_text'  => 'This wiki contains \'\'\'$1\'\'\' property {{PLURAL:$1|value|values}} for a total of \'\'\'$2\'\'\' [[Special:Properties|{{PLURAL:$2|property|different properties}}]].
\'\'\'$3\'\'\' {{PLURAL:$3|property has|properties have}} an own page, and the intended datatype is specified for \'\'\'$4\'\'\' of those.
Some of the existing properties might be [[Special:UnusedProperties|unused properties]].
Properties that still lack a page are found on the [[Special:WantedProperties|list of wanted properties]].',

	// Name of the URI Resolver Special (no content)
	'uriresolver' => 'URI resolver',
	'smw_uri_doc' => 'The URI resolver implements the <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>.
It takes care that humans do not turn into websites.',

	// Messages for ask Special
	'ask'                   => 'Semantic search',
	'smw_ask_doculink'      => 'http://semantic-mediawiki.org/wiki/Help:Semantic_search',
	'smw_ask_sortby'        => 'Sort by column (optional)',
	'smw_ask_ascorder'      => 'Ascending',
	'smw_ask_descorder'     => 'Descending',
	'smw_ask_submit'        => 'Find results',
	'smw_ask_editquery'     => '[Edit query]',
	'smw_add_sortcondition' => '[Add sorting condition]',
	'smw_ask_hidequery'     => 'Hide query',
	'smw_ask_help'          => 'Querying help',
	'smw_ask_queryhead'     => 'Query',
	'smw_ask_printhead'     => 'Additional data to display',
	'smw_ask_printdesc'     => '(add one property name per line)',
	'smw_ask_format_as'	=> 'Format as:',
	'smw_ask_defaultformat'	=> 'default',
	'smw_ask_otheroptions'  => 'Other options',
	'smw_ask_show_embed'	=> 'Show embed code',
	'smw_ask_hide_embed'	=> 'Hide embed code',
	'smw_ask_embed_instr'	=> 'To embed this query inline into a wiki page use the code below.',

	// Messages for the search by property special
	'searchbyproperty'      => 'Search by property',
	'smw_sbv_docu'          => 'Search for all pages that have a given property and value.',
	# unused / Siebrand 2009-04-25
	# 'smw_sbv_noproperty'    => 'Enter a property.',
	'smw_sbv_novalue'       => 'Enter a valid value for the property, or view all property values for "$1".',
	'smw_sbv_displayresult' => 'A list of all pages that have property "$1" with value "$2"',
	'smw_sbv_displayresultfuzzy' => 'A list of all pages that have property "$1" with value "$2".
Since there have been only a few results, also nearby values are displayed.',
	'smw_sbv_property'      => 'Property:',
	'smw_sbv_value'         => 'Value:',
	'smw_sbv_submit'        => 'Find results',

	// Messages for the browsing special
	'browse'                     => 'Browse wiki',
	'smw_browselink'             => 'Browse properties',
	'smw_browse_article'         => 'Enter the name of the page to start browsing from.',
	'smw_browse_go'              => 'Go',
	'smw_browse_more'            => '…',
	'smw_browse_show_incoming'   => 'show properties that link here',
	'smw_browse_hide_incoming'   => 'hide properties that link here',
	'smw_browse_no_outgoing'     => 'This page has no properties.',
	'smw_browse_no_incoming'     => 'No properties link to this page.',
	'smw_inverse_label_default'  => '$1 of',
	'smw_inverse_label_property' => 'Inverse property label', # this is the name of a special property

	// Messages for the page property special
	'pageproperty'  => 'Page property search',
	'smw_pp_docu'   => 'Search for all the values of a property on a given page.
Enter both a page and a property.',
	'smw_pp_from'   => 'From page',
	'smw_pp_type'   => 'Property',
	'smw_pp_submit' => 'Find results',

	// Generic messages for result navigation in all kinds of search pages
	'smw_result_prev'      => 'Previous',
	'smw_result_next'      => 'Next',
	'smw_result_results'   => 'Results',
	'smw_result_noresults' => 'No results.',

	// Messages for SMWAdmin
	'smwadmin' => 'Admin functions for Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Setting up storage for Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'The storage engine was set up successfully.',
	'smw_smwadmin_return' => 'Return to $1',
	'smw_smwadmin_updatestarted' => 'A new update process for refreshing the semantic data was started.
All stored data will be rebuilt or repaired where needed.
You can follow the progress of the update on this special page.',
	'smw_smwadmin_updatenotstarted' => 'There is already an update process running.
Not creating another one.',
	'smw_smwadmin_updatestopped' => 'All existing update processes have been stopped.',
	'smw_smwadmin_updatenotstopped' => 'To stop the running update process, you must activate the checkbox to indicate that you are really sure.',
	'smw_smwadmin_docu' => 'This special page helps you during installation and upgrade of <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Remember to back up valuable data before executing administrative functions.',
	'smw_smwadmin_db' => 'Database installation and upgrade',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki requires some extensions to the MediaWiki database in order to store the semantic data.
The below function ensures that your database is set up properly.
The changes made in this step do not affect the rest of the MediaWiki database, and can easily be undone if desired.
This setup function can be executed multiple times without doing any harm, but it is needed only once on installation or upgrade.',
	'smw_smwadmin_permissionswarn' => 'If the operation fails with SQL errors, the database user employed by your wiki (check your LocalSettings.php) probably does not have sufficient permissions.
Either grant this user additional pemissions to create and delete tables, temporarily enter the login of your database root in LocalSettings.php, or use the maintenance script <tt>SMW_setup.php</tt> which can use the credentials of AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Initialise or upgrade tables',
	'smw_smwadmin_announce' => 'Announce your wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki has a web service for announcing new semantic wiki sites.
This is used to maintain a list of public sites that use Semantic MediaWiki, mainly to help the <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki project</a> to get an overview of typical uses of Semantic MediaWiki.
See the Semantic MediaWiki homepage for <a href="http://semantic-mediawiki.org/wiki/Registry">further information about this service</a>.',
	'smw_smwadmin_announcebutton' => 'Press the following button to submit your wiki URL to that service.
The service will not register wikis that are not publicly accessible, and it will only store publicly accessible information.',
	'smw_smwadmin_datarefresh' => 'Data repair and upgrade',
	'smw_smwadmin_datarefreshdocu' => 'It is possible to restore all Semantic MediaWiki data based on the current contents of the wiki.
This can be useful to repair broken data or to refresh the data if the internal format has changed due to some software upgrade.
The update is executed page by page and will not be completed immediately.
The following shows if an update is in progress and allows you to start or stop updates (unless this feature was disabled by the site administrator).',
	'smw_smwadmin_datarefreshprogress' => '<strong>An update is already in progress.</strong>
It is normal that the update progresses only slowly since it only refreshes data in small chunks each time a user accesses the wiki.
To finish this update more quickly, you can invoke the MediaWiki maintenance script <tt>runJobs.php</tt> (use the option <tt>--maxjobs 1000</tt> to restrict the number of updates done in one batch).
Estimated progress of current update:',
	'smw_smwadmin_datarefreshbutton' => 'Start updating data',
	'smw_smwadmin_datarefreshstop' => 'Stop this update',
	'smw_smwadmin_datarefreshstopconfirm' => 'Yes, I am sure.',
	'smw_smwadmin_support' => 'Getting support',
	'smw_smwadmin_supportdocu' => 'Various resources might help you in case of problems:',
	'smw_smwadmin_installfile' => 'If you experience problems with your installation, start by checking the guidelines in the <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL file</a>.',
	'smw_smwadmin_smwhomepage' => 'The complete user documentation to Semantic MediaWiki is at <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Bugs can be reported to <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'If you have further questions or suggestions, join the discussion on <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki user forum</a>.',

	// Messages for Admin Links page
	'smw_adminlinks_datastructure' => 'Data structure',
	'smw_adminlinks_displayingdata' => 'Displaying data',
	'smw_adminlinks_inlinequerieshelp' => 'Inline queries help',
);

/** Message documentation (Message documentation)
 * @author EugeneZelenko
 * @author Fryed-peach
 * @author Helix84
 * @author Jon Harald Søby
 * @author Markus Krötzsch
 * @author Meno25
 * @author Pietrodn
 * @author Purodha
 */
$messages['qqq'] = array(
	'smw-desc' => '{{desc}}',
	'smw_finallistconjunct' => 'The last separator in a list. For example a list could look like this: "A, B, and C". The comma might not be appropriate in your language.

{{Identical|And}}',
	'smw_rss_link' => '{{optional}}',
	'smw_csv_link' => '{{optional}}',
	'smw_printername_auto' => '{{Identical|Automatic}}',
	'smw_printername_table' => '{{Identical|Table}}',
	'smw_printername_template' => '{{Identical|Template}}',
	'smw_paramdesc_limit' => 'A description of the "limit" parameter for inline queries',
	'smw_paramdesc_headers' => 'A description of the "headers" parameter for inline queries',
	'smw_paramdesc_mainlabel' => 'A description of the "mainlabel" parameter for inline queries',
	'smw_paramdesc_link' => 'A description of the "link" parameter for inline queries',
	'smw_paramdesc_intro' => 'A description of the "intro" parameter for inline queries',
	'smw_paramdesc_outro' => 'A description of the "outro" parameter for inline queries',
	'smw_paramdesc_default' => 'A description of the "default" parameter for inline queries',
	'smw_paramdesc_searchlabel' => 'A description of the "searchlabel" parameter for inline queries',
	'smw_paramdesc_sep' => 'A description of the "sep" (value separator) parameter for inline queries',
	'smw_paramdesc_template' => 'A description of the "template" parameter for inline queries',
	'smw_paramdesc_columns' => 'A description of the "columns" parameter for inline queries',
	'smw_paramdesc_embedformat' => 'A description of the "embedformat" parameter for the "embedded" format inline queries',
	'smw_paramdesc_embedonly' => 'A description of the "embedonly" parameter for the "embedded" format for inline queries',
	'smw_paramdesc_rsstitle' => 'A description of the "title" parameter for the "rss" format for inline queries',
	'smw_paramdesc_rssdescription' => 'A description of the "description" parameter for the "rss" format for inline queries',
	'smw_decseparator' => "This message is as a separator symbol for decimal digits in numbers, like \".\" in English 1,234.23. It is used for formatting number output '''and''' for reading user input. Therefore it should be carefully considered whether to change an existing value, since existing installations may depend on this value for their content to be read properly.

Note that spaces and space-like HTML entities are always ignored when reading numbers.",
	'smw_kiloseparator' => "This message is as a separator symbol for thousands in numbers, like \",\" in English 1,234.23. It is used for formatting number output '''and''' for reading user input. Therefore it should be carefully considered whether to change an existing value, since existing installations may depend on this value for their content to be read properly.

Note that spaces and space-like HTML entities are always ignored when reading numbers, whether or not a space symbol is used here.",
	'smw_subpropertyarticlecount' => '[[bugzilla:15207|Bug on Bugzilla about this message]] has been fixed at [[mw:Special:Code/MediaWiki/40793|r40793]].',
	'specialpages-group-smw_group' => '{{optional}}',
	'smw_exportrdf_submit' => '{{Identical|Export}}',
	'properties' => 'This is the title of the special page showing all properties.
{{Identical|Property}}',
	'smw_property_template' => 'Used to display information about properties on Special:Properties. The parameters have the following meaning:
* $1: the property name
* $2: the name of the type of the property
* $3: the number of occurrences of this property in the wiki',
	'smw_typeunits' => 'This message is used in the tooltip on Special:Types when a property supports custom units of measurement. The parameter $1 then is the type name, and $2 is a list of unit names.',
	'smw_uri_doc' => "This message sketches the (very technical) function of this unlisted special page.
It probably does not need translation in most cases. The special page as such is used in all URIs used by Semantic MediaWiki.
When somebody resolves such a URI, the special page will redirect to the according wiki page or to the according metadata export (OWL/RDF/XML).
This is controlled by the HTTP request header. Semantic Web crawlers and browsers can thus request more metadata on a particular subject, while humans are referred to readable pages.
This method is called ''content negotiation''.",
	'smw_ask_submit' => '{{Identical|Find results}}',
	'smw_ask_defaultformat' => '{{Identical|Default}}',
	'smw_sbv_property' => '{{Identical|Property}}',
	'smw_sbv_value' => '{{Identical|Value}}',
	'smw_sbv_submit' => '{{Identical|Find results}}',
	'smw_browse_go' => '{{Identical|Go}}',
	'smw_inverse_label_property' => 'Can as well be translated as "Name of", or "Denomination of the inverse propery". The inverse property is one having both its direction, and its source/target sets inverted. For example, the property "is child of" is the inverse propery of "is parent of".',
	'smw_pp_docu' => '"fillers" can be translated as "values", if you so wish.',
	'smw_pp_type' => '{{Identical|Property}}',
	'smw_pp_submit' => '{{Identical|Find results}}',
	'smw_result_prev' => '{{Identical|Previous}}',
	'smw_result_next' => '{{identical|Next}}',
	'smw_result_results' => '{{Identical|Result}}',
	'smw_result_noresults' => '{{Identical|Sorry, no results}}',
	'smw_smwadmin_announcedocu' => 'Do not alter or translate link targets',
);

/** Niuean (ko e vagahau Niuē)
 * @author Jose77
 */
$messages['niu'] = array(
	'smw_browse_go' => 'Fano',
);

/** Afrikaans (Afrikaans)
 * @author Arnobarnard
 * @author Naudefj
 */
$messages['af'] = array(
	'smw_finallistconjunct' => ', en',
	'smw_factbox_head' => 'Feite oor $1',
	'smw_isspecprop' => "Hierdie eienskap is 'n spesiale eienskap van hierdie wiki.",
	'smw_printername_auto' => 'Outomaties',
	'smw_printername_template' => 'Sjabloon',
	'smw_parseerror' => 'Die gegewe waarde is onverstaanbaar.',
	'smw_unknowntype' => 'Onondersteunde tipe "$1" gedefinieer vir eienskap.',
	'smw_manytypes' => 'Meer as een tipe gedefinieer vir eienskap.',
	'smw_emptystring' => 'Leë stringe word nie aanvaar nie.',
	'smw_true_words' => 'waar,w,ja,j',
	'smw_false_words' => 'vals,v,nee,n',
	'smw_nofloat' => '"$1" is nie \'n nommer nie.',
	'smw_unsupportedprefix' => 'Voorvoegsels vir nommers ("$1") word nie ondersteun nie.',
	'smw_nodatetime' => 'Die datum "$1" kon nie verwerk word nie.',
	'smw_emptysubquery' => "'n Sub-navraag het geen geldige kondisie.",
	'smw_exportrdf_submit' => 'Eksporteer',
	'smw_propertyhardlyused' => 'Hierdie eienskap word skaars gebruik in hierdie wiki!',
	'smw_unusedproperty_template' => '$1 van tipe $2',
	'smw_wantedproperty_template' => '$1 ($2 gebruike)',
	'smw_purge' => 'Verfris',
	'types' => 'Tipes',
	'smw_ask_sortby' => 'Sorteer volgens kolom (optioneel)',
	'smw_ask_ascorder' => 'Toenemend',
	'smw_ask_descorder' => 'Afnemend',
	'smw_ask_submit' => 'Vind resultate',
	'smw_ask_editquery' => '[Wysig navraag]',
	'smw_ask_hidequery' => 'Versteek navraag',
	'smw_ask_help' => 'Navraag hulp',
	'smw_ask_queryhead' => 'Navraag',
	'smw_ask_printhead' => 'Addisionele uitdrukke (optioneel)',
	'smw_ask_defaultformat' => 'standaard',
	'searchbyproperty' => 'Soek volgens eienskap',
	'smw_sbv_property' => 'Eienskap:',
	'smw_sbv_value' => 'Waarde:',
	'smw_sbv_submit' => 'Vind resultate',
	'smw_browse_go' => 'Laat waai',
	'smw_pp_from' => 'Vanaf bladsy',
	'smw_pp_type' => 'Eienskap',
	'smw_pp_submit' => 'Vind resultate',
	'smw_result_prev' => 'Vorige',
	'smw_result_next' => 'Volgende',
	'smw_result_results' => 'Resultate',
	'smw_result_noresults' => 'Geen resultate.',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'smw_isspecprop' => 'Kjo pronë është një veti të veçantë në këtë wiki.',
	'smw_isknowntype' => 'Ky lloj është midis tipit të të dhënave të këtij standardi wiki.',
	'smw_isaliastype' => 'Ky lloj është një pseudonim për dhënave "$1".',
	'smw_isnotype' => 'Ky lloj "$1" nuk është një standard të dhënave në wiki, dhe nuk është dhënë një përkufizim ose përdorues.',
	'smw_concept_description' => 'Përshkrimi i konceptit "$1"',
	'smw_no_concept_namespace' => 'Konceptet mund të përcaktohet në faqet në Konceptin: hapësira.',
	'smw_multiple_concepts' => 'Çdo faqe koncept mund të ketë vetëm një përkufizim koncept.',
	'smw_concept_cache_miss' => 'Koncepti "$1" nuk mund të përdoret në këtë moment, që nga konfigurimi Wiki kërkon që ajo të jetë llogaritur off-line. Nëse problemi nuk zhduken pas disa kohë, pyesni administratorin e faqes tuaj për të bërë këtë koncept në dispozicion.',
	'smw_noinvannot' => 'Vlerat nuk mund të vendoset në pronat e anasjelltas.',
	'smw_baduri' => 'URI e formës "$1" nuk lejohen.',
	'smw_printername_auto' => 'Automatik',
	'smw_printername_count' => 'Rezultatet Count',
	'smw_printername_csv' => 'eksport CSV',
	'smw_printername_debug' => 'query Debug (për ekspertët)',
	'smw_printername_embedded' => 'Embed faqe Përmbajtja',
	'smw_printername_json' => 'eksport JSON',
	'smw_printername_list' => 'Listë',
	'smw_printername_ol' => 'Renditje',
	'smw_printername_ul' => 'Itemization',
	'smw_printername_rss' => 'eksport RSS',
	'smw_printername_table' => 'Tryezë',
	'smw_printername_broadtable' => 'Tabela Broad',
	'smw_printername_template' => 'Shabllon',
	'smw_paramdesc_limit' => 'Numri maksimal i rezultateve të kthehen',
	'smw_paramdesc_headers' => 'Afisho e titullit / emrat e pronës',
	'smw_paramdesc_mainlabel' => 'Etiketë për të dhënë për emrin kryesore faqe',
	'smw_paramdesc_link' => 'Show vlerat si link',
	'smw_paramdesc_intro' => 'Teksti që do shfaqet para se rezultatet e pyetjes, nëse ka ndonjë',
	'smw_paramdesc_outro' => 'Teksti që do shfaqet pas rezultatet e pyetjes, nëse ka ndonjë',
	'smw_paramdesc_default' => 'Teksti që do shfaqet në qoftë se nuk ka rezultate query',
	'smw_paramdesc_searchlabel' => 'Teksti në lidhje me rezultatet e',
	'smw_paramdesc_sep' => 'Ndarës për vlerat e',
	'smw_paramdesc_template' => 'Emri i një template me të cilin për të shfaqur shkresat e',
	'smw_paramdesc_columns' => 'Numri i rreshtave në të cilat për të shfaqur rezultate (default është $1)',
	'smw_paramdesc_embedformat' => 'HTML tag përdoret për të definuar tituj',
	'smw_paramdesc_embedonly' => 'Afisho nuk ka tituj',
	'smw_paramdesc_rsstitle' => "Teksti për t'u përdorur si titulli i feed",
	'smw_paramdesc_rssdescription' => 'Teksti që do të përdoret si përshkrim i feed',
	'smw_iq_disabled' => 'pyetje Semantic kanë qenë të paaftë për këtë wiki.',
	'smw_iq_moreresults' => 'Rezultatet e ... më tej',
	'smw_iq_nojs' => 'Përdorni një shfletues të aktivizoni Java skriptet për të parë, ky element.',
	'smw_iq_altresults' => 'Browse rezultat lista direkt.',
	'smw_unknown_importns' => 'Funksionet e importit nuk janë në dispozicion për namespace "$1".',
	'smw_nonright_importtype' => '$1 mund të përdoren vetëm për faqet me hapësira "$2".',
	'smw_wrong_importtype' => '$1 nuk mund të përdoret për faqet në hapësirën "$2".',
	'smw_no_importelement' => 'Elementi "$1" nuk dispozicion për import.',
	'smw_parseerror' => 'Vlera e dhënë nuk është kuptuar.',
	'smw_notitle' => '"$1" nuk mund të përdoret si një emër faqe në këtë wiki.',
	'smw_wrong_namespace' => 'Vetëm faqet në hapësirën "$1" lejohen këtu.',
	'smw_unknowntype' => 'Lloj i pasuportuar "$1" të përcaktuara për pronën.',
);

/** Amharic (አማርኛ)
 * @author Codex Sinaiticus
 */
$messages['am'] = array(
	'smw_result_next' => 'ቀጥሎ',
);

/** Aragonese (Aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'smw_printername_template' => 'Plantilla',
	'smw_nodatetime' => 'No s\'ha entendito a calendata "$1".',
);

/** Arabic (العربية)
 * @author Mahmoud Zouari  mahmoudzouari@yahoo.fr http://www.cri.ensmp.fr
 * @author Meno25
 * @author OsamaK
 * @author Ouda
 */
$messages['ar'] = array(
	'smw-desc' => "جعل الويكي الخاص بك أكثر قابلية للوصول - للآلات ''و'' البشر ([http://semantic-mediawiki.org/wiki/Help:User_manual توثيق على الإنترنت])",
	'smw_edithelp' => 'تعديل المساعدة على الخصائص',
	'smw_viewasrdf' => 'تلقيم RDF',
	'smw_finallistconjunct' => '، و',
	'smw_factbox_head' => 'حقائق عن $1',
	'smw_isspecprop' => 'هذه الخاصية هى خاصية خاصة في هذا الويكي.',
	'smw_isknowntype' => 'هذا النوع هو من بين أنواع البيانات الموحدة من هذا الويكي.',
	'smw_isaliastype' => 'هذا النوع هو الاسم المستعار لنوع البيانات "$1".',
	'smw_isnotype' => 'هذا النوع "$1" هو ليس معيار البيانات في الويكي، ولم يعط تعريفا من قبل المستخدمين.',
	'smw_concept_description' => 'وصف المبدأ "$1"',
	'smw_no_concept_namespace' => 'المبادئ يمكن تعريفها فقط في الصفحات في نطاق Concept:',
	'smw_multiple_concepts' => 'كل صفحة مبدأ يمكن أن تحتوي على تعريف مبدأ واحد.',
	'smw_concept_cache_miss' => 'المبدأ "$1" لا يمكن استخدامه حاليا، بما أن ضبط الويكي يحتاجه إلى أن يتم حسابه خارجيا. لو أن المشكلة لم تنته بعد بعض الوقت، سل إداري موقعك ليجعل هذا المبدأ متوفرا.',
	'smw_noinvannot' => 'القيم لا يمكن تعيينها لخصائص معكوسة.',
	'smw_baduri' => 'URIs من النوع "$1" غير مسموح بها.',
	'smw_rss_link' => 'آر إس إس',
	'smw_csv_link' => 'سي في إس',
	'smw_json_link' => 'جسون',
	'smw_printername_auto' => 'تلقائي',
	'smw_printername_count' => 'عد النتائج',
	'smw_printername_csv' => 'تصدير CSV',
	'smw_printername_debug' => 'استعلام التصليح (للخبراء)',
	'smw_printername_embedded' => 'تضمين محتويات الصفحة',
	'smw_printername_json' => 'تصدير JSON',
	'smw_printername_list' => 'قائمة',
	'smw_printername_ol' => 'ترقيم',
	'smw_printername_ul' => 'ترتيب في عناصر',
	'smw_printername_rss' => 'تصدير RSS',
	'smw_printername_table' => 'جدول',
	'smw_printername_broadtable' => 'جدول عريض',
	'smw_printername_template' => 'قالب',
	'smw_paramdesc_limit' => 'الرقم الأقصى للعناصر المُرجعة',
	'smw_paramdesc_headers' => 'اعرض العناوين/أسماء الخصائص',
	'smw_paramdesc_mainlabel' => 'العلامة للإعطاء لاسم الصفحة الرئيسية',
	'smw_paramdesc_link' => 'أظهر القيم كوصلات',
	'smw_paramdesc_intro' => 'النص للعرض قبل نتائج الاستعلام، لو كانت هناك أي',
	'smw_paramdesc_outro' => 'النص المطلوب عرضه بعد نتائج الاستعلام، إن وُجدت',
	'smw_paramdesc_default' => 'النص المطلوب عرضه إذا لم تتوفر نتائج للاستعلام',
	'smw_paramdesc_searchlabel' => 'نص وصلة النتائج',
	'smw_paramdesc_sep' => 'فاصل القيم',
	'smw_paramdesc_template' => 'اسم القالب لعرض الخرج به',
	'smw_paramdesc_columns' => 'رقم الأعمدة لعرض النتائج بها (افتراضيا $1)',
	'smw_paramdesc_embedformat' => 'وسم HTML المستخدم لتعريف الترويسة',
	'smw_paramdesc_embedonly' => 'لا تظهر الترويسات',
	'smw_paramdesc_rsstitle' => 'النص المستخدم كعنوان للتغذية',
	'smw_paramdesc_rssdescription' => 'النص المستخدم لوصف التغذية',
	'smw_iq_disabled' => 'استعلامات السيمانتيك تم تعطيلها في هذا الويكي.',
	'smw_iq_moreresults' => '… مزيد من النتائج',
	'smw_iq_nojs' => 'استخدم متصفحا يُمكّن جافاسكربت لرؤية هذا العنصر.',
	'smw_iq_altresults' => 'استعرض قائمة النتائج مباشرة.',
	'smw_unknown_importns' => 'إمكانية استيراد ليست متوفرة للنطاق "$1".',
	'smw_nonright_importtype' => '$1 لا يمكن أن تستخدم إلا لصفحات مع النطاق "$2".',
	'smw_wrong_importtype' => '$1 لا يمكن استخدامها للصفحات في النطاق "$2".',
	'smw_no_importelement' => 'العنصر "$1" غير متوفر للاستيراد.',
	'smw_parseerror' => 'القيمة المعطاة لم يتم فهمها.',
	'smw_kiloseparator' => '،',
	'smw_notitle' => '"$1" لا يمكن أن تستخدم مثل هذا الاسم في صفحة ويكي.',
	'smw_wrong_namespace' => 'فقط الصفحات في النطاق "$1" مسموح بها هنا.',
	'smw_unknowntype' => 'نوع غير مدعوم "$1" لتعريف الممتلكات.',
	'smw_manytypes' => 'أكثر من نوع واحد لتعريف الخاصية.',
	'smw_emptystring' => 'السلاسل الفارغة غير مقبولة.',
	'smw_maxstring' => 'تمثيل السلسلة $1 طويل جدا.',
	'smw_notinenum' => '"$1" ليس ضمن قائمة القيم الممكنة ($2) لهذه الخاصية.',
	'smw_noboolean' => '"$1" غير متعرف عليها كقيمة بووليان (صواب/خطأ).',
	'smw_true_words' => 'صحيح،ص،نعم،ن',
	'smw_false_words' => 'خطأ،خ،لا،ل',
	'smw_nofloat' => 'ليس عددا "$1".',
	'smw_infinite' => 'الأرقام الكبيرة مثل "$1" غير مدعومة.',
	'smw_infinite_unit' => 'التحويل إلى الوحدة "$1" نتج عنه رقم كبير جدا.',
	'smw_unsupportedprefix' => 'غير مدعوم ("$1") البادئات لأرقام.',
	'smw_unsupportedunit' => 'غير مدعوم "$1" تحويل الوحدة للوحدة.',
	'smw_nodatetime' => 'التاريخ "$1" لم يتم فهمه.',
	'smw_toomanyclosing' => 'يبدو أنه هناك الكثير من "$1" في الاستعلام.',
	'smw_noclosingbrackets' => '"]]" في استعلامك لم تكن مغلقة باستخدام "<nowiki>[[</nowiki>" بعض استخدام',
	'smw_misplacedsymbol' => 'الرمز "$1" تم استخدامه في مكان حيث هو ليس مفيدا.',
	'smw_unexpectedpart' => 'الجزء "$1" من الاستعلام لم يفهم.
النتائج قد لا تكون كما هو متوقع.',
	'smw_emptysubquery' => 'بعض الاستعلامات الفرعية ليس لها شرط صحيح.',
	'smw_misplacedsubquery' => 'بعض الاستعلامات الفرعية تم استخدمها في مكان غير مسموح فيه بالاستعلامات الفرعية.',
	'smw_valuesubquery' => 'الاستعلامات الفرعية غير مدعومة لقيم الخاصية "$1".',
	'smw_overprintoutlimit' => 'هذا الاستعلام يحتوي على عدد كبير جدا من طلبات الطبع.',
	'smw_badprintout' => 'بعض المطبوعات في الاستعلام لم تتشكل بصورة صحيحة.',
	'smw_badtitle' => '"$1" ليس عنوان صفحة صحيحا.',
	'smw_badqueryatom' => 'جزء ما "<nowiki>[[…]]</nowiki>" من الاستعلام لم يتم فهمه.',
	'smw_propvalueproblem' => 'قيمة الخاصية "$1" لم يتم فهمها.',
	'smw_noqueryfeature' => 'ميزة استعلام ما لم يتم دعمها في هذا الويكي وجزء من الاستعلام تم إسقاطه ($1).',
	'smw_noconjunctions' => 'الوقوفات في الاستعلامات غير مدعومة في هذا الويكي وجزء من الاستعلام تم إسقاطه ($1).',
	'smw_nodisjunctions' => 'المفارق في استعلامات ليست مدعومة في هذا الويكي وجزء من الاستعلام رفض $1.',
	'smw_querytoolarge' => 'شروط الاستفسار التالية لم يمكن اعتبارها نتيجة لقيود الويكي في حجم أو عمق الاستعلام: $1.',
	'smw_devel_warning' => 'هذه الخاصية حاليا قيد التطوير، وربما لا تعمل بشكل كامل.
احفظ بياناتك قبل استخدامها.',
	'smw_notemplategiven' => 'وفر قيمة للمحدد "template" لتعمل صيغة الاستعلام هذه.',
	'smw_type_header' => 'خصائص النوع "$1"',
	'smw_typearticlecount' => 'عرض {{PLURAL:$1||خاصية واحدة تستخدم|خاصيتين تستخدمان|$1 خصائص تستخدم|$1 خاصية تستخدم}} هذا النوع.',
	'smw_attribute_header' => 'الصفحات التي تستخدم الخاصية "$1"',
	'smw_attributearticlecount' => 'عرض {{PLURAL:$1||الصفحة التي تستخدم|الصفحتين اللتين تستخدمان|الصفحات التي تستخدم}} هذه الخاصية.',
	'smw_subproperty_header' => 'خواص فرعية',
	'smw_subpropertyarticlecount' => 'لهذه الخاصية {{PLURAL:$1||الخاصية الفرعية التالية|الخاصيتين الفرعيتين التاليتين|الخصائص الفرعية التالية}}:',
	'smw_concept_header' => 'صفحات المبدأ "$1"',
	'smw_conceptarticlecount' => 'عرض {{PLURAL:$1||صفحة واحدة تنتمي|صفحتين تنتميان|$1 صفحات تنتمي|$1 صفحة تنتمي}} إلى هذا المبدأ.',
	'smw_rss_description' => '$1 تلقيم آر إس إس',
	'specialpages-group-smw_group' => 'سيمانتيك ميدياويكي',
	'exportrdf' => 'آر دی‌ إف إلى صفحات تصدير',
	'smw_exportrdf_docu' => ' هذه الصفحة تتيح لك الحصول على بيانات من صفحة في شكل آر دی‌ إف.
التصدير إلى صفحات، أدخل العناوين في مربع النص أدناه، عنوان واحد لكل سطر.',
	'smw_exportrdf_recursive' => 'تصدير جميع الصفحات ذات الصلة بشكل تكراري.
علما أنه يمكن أن تكون النتيجة كبيرة!',
	'smw_exportrdf_backlinks' => 'أيضا تصدير كل الصفحات التي تشير إلى الصفحات تم تصديرها.
يولد آر دي إف قابل للتصفح.',
	'smw_exportrdf_lastdate' => 'لا تصدر الصفحات التي لم تتغير منذ نقطة زمنية محددة.',
	'smw_exportrdf_submit' => 'تصدير',
	'properties' => 'الخصائص',
	'smw_properties_docu' => 'الخصائص التالية تستخدم في الويكي.',
	'smw_property_template' => '$1 من نوع $2 ($3)',
	'smw_propertylackspage' => 'جميع الخصائص ينبغي أن توصف بصفحة!',
	'smw_propertylackstype' => 'لا نوع تم تحديده لهذه الخاصية (افتراض النوع $1 حاليا).',
	'smw_propertyhardlyused' => 'هذه الخاصية لا تكاد تستخدم داخل الويكي!',
	'unusedproperties' => 'خصائص غير مستخدمة',
	'smw_unusedproperties_docu' => 'الخصائص التالية موجودة على الرغم من أنه لا صفحة أخرى تستخدمها.',
	'smw_unusedproperty_template' => '$1 من نوع $2',
	'wantedproperties' => 'خصائص مطلوبة',
	'smw_wantedproperties_docu' => 'الخصائص التالية مستخدمة في الويكي ولكن ليس لديها حتى الآن صفحة لوصفها.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|استخدام|استخدام}})',
	'tooltip-purge' => 'اضغط هنا لتحديث كافة الاستفسارات والقوالب على هذه الصفحة',
	'smw_purge' => 'تحديث',
	'types' => 'أنواع',
	'smw_types_docu' => 'التالي قائمة بجميع أنواع البيانات التي يمكن أن تسند إلى الخصائص.
كل نوع بيانات له صفحة حيث يمكن توفير معلومات إضافية.',
	'smw_typeunits' => 'وحدات القياس من النوع "$1": $2',
	'semanticstatistics' => 'إحصاءات سيمانتيك',
	'smw_semstats_text' => "هذا الويكي يحتوي على '''$1''' {{PLURAL:$1|قيمة|قيمة}} خاصية بإجمالي '''$2''' [[Special:Properties|{{PLURAL:$2|خاصية|خاصية مختلفة}}]].
'''$3''' {{PLURAL:$3|خاصية تمتلك|خاصية تمتلك}} صفحتها الخاصة، ونوع البيانات المقصود محدد ل'''$4''' من هؤلاء.
بعض الخواص الموجودة ربما تكون [[Special:UnusedProperties|خواص غير مستخدمة]].
الخواص التي مازالت تفتقد صفحة موجودة في [[Special:WantedProperties|قائمة الخواص المطلوبة]].",
	'uriresolver' => 'محلل URI',
	'smw_uri_doc' => 'محلل URI ينفذ <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C على httpRange-14</a>. إنه يتأكد من أن البشر لا يتحولون إلى مواقع ويب.',
	'ask' => 'بحث سيمانتيك',
	'smw_ask_sortby' => 'الترتيب حسب العمود (اختياري)',
	'smw_ask_ascorder' => 'تصاعدي',
	'smw_ask_descorder' => 'تنازلي',
	'smw_ask_submit' => 'جِد نتائجًا',
	'smw_ask_editquery' => '[عدل الاستعلام]',
	'smw_add_sortcondition' => '[أضف شرط ترتيب]',
	'smw_ask_hidequery' => 'إخفاء الاستعلام',
	'smw_ask_help' => 'مساعدة الاستعلام',
	'smw_ask_queryhead' => 'استعلام',
	'smw_ask_printhead' => 'بيانات إضافية للعرض',
	'smw_ask_printdesc' => '(أضف اسمًا مناسبًا واحدًا في كل سطر)',
	'smw_ask_format_as' => 'صياغة ك:',
	'smw_ask_defaultformat' => 'افتراضي',
	'smw_ask_otheroptions' => 'خيارات أخرى',
	'smw_ask_show_embed' => 'عرض الكود المضمن',
	'smw_ask_hide_embed' => 'إخفاء الكود المضمن',
	'smw_ask_embed_instr' => 'لتضمين هذا الاستعلام في صفحة ويكي، استخدم الكود أدناه',
	'searchbyproperty' => 'البحث حسب الخصائص',
	'smw_sbv_docu' => 'البحث عن كل الصفحات التي لها خصائص معينة وقيمة',
	'smw_sbv_novalue' => 'أدخل قيمة صحيحة للخاصية، أو انظر كل قيم الخصائص ل"$1"',
	'smw_sbv_displayresult' => 'قائمة بكل الصفحات التي بها الخاصية "$1" بالقيمة "$2"',
	'smw_sbv_displayresultfuzzy' => 'قائمة بكل الصفحات التي لديها الخاصية "$1" بالقيمة "$2".
بما أنه كانت هناك فقط عدة نتائج، فالقيم المقاربة معروضة أيضا.',
	'smw_sbv_property' => 'خاصية:',
	'smw_sbv_value' => 'قيمة:',
	'smw_sbv_submit' => 'جِد نتائجًا',
	'browse' => 'استعرض يكي',
	'smw_browselink' => 'خصائص التصفح',
	'smw_browse_article' => 'أدخل اسم الصفحة لبدء التصفح منها.',
	'smw_browse_go' => 'اذهب',
	'smw_browse_show_incoming' => 'أظهر الخواص التي تصل هنا',
	'smw_browse_hide_incoming' => 'أخفِ الخواص التي تصل هنا',
	'smw_browse_no_outgoing' => 'هذه الصفحة ليس لديها خصائص.',
	'smw_browse_no_incoming' => 'لا خصائص تصل إلى هذه الصفحة.',
	'smw_inverse_label_default' => '$1 من',
	'smw_inverse_label_property' => 'اعكس علامة الخاصية',
	'pageproperty' => 'بحث خصائص الصفحة',
	'smw_pp_docu' => 'البحث عن جميع قيم خاصية على صفحة معينة.
أدخل صفحة وخاصية.',
	'smw_pp_from' => 'من صفحة',
	'smw_pp_type' => 'الخاصية',
	'smw_pp_submit' => 'جِد نتائجًا',
	'smw_result_prev' => 'السابق',
	'smw_result_next' => 'التالي',
	'smw_result_results' => 'النتائج',
	'smw_result_noresults' => 'لا توجد نتائج.',
	'smwadmin' => 'وظائف إدارية لسيمانتيك ميدياويكي',
	'smw_smwadmin_settingup' => 'ضبط التخزين لسيمانتيك ميدياويكي',
	'smw_smwadmin_setupsuccess' => 'تم تنصيب محرك التخزين بنجاح',
	'smw_smwadmin_return' => 'أرجع إلى $1',
	'smw_smwadmin_updatestarted' => 'عملية تحديث جديدة لتحديث بيانات سيمانتيك بدأت.
كل البيانات المخزنة ستتم إعادة بنائها أو إصلاحها عند الحاجة.
أنت يمكنك متابعة تطور التحديث على هذه الصفحة الخاصة.',
	'smw_smwadmin_updatenotstarted' => 'يوجد بالفعل عملية تحديث جارية.
لا تنشئ واحدة أخرى.',
	'smw_smwadmin_updatestopped' => 'كل عمليات التحديث الموجودة تم إيقافها',
	'smw_smwadmin_updatenotstopped' => 'لوقف عملية التحديث الجارية، يجب عليك تفعيل الصندوق لتعبر عن أنك متأكد حقا.',
	'smw_smwadmin_docu' => 'هذه الصفحة الخاصة تساعدك خلال تنصيب وترقية <a href="http://semantic-mediawiki.org">سيمانتيك ميدياويكي</a>.
تذكر أن تخزن احتياطيا البيانات القيمة قبل تنفيذ وظائف إدارية.',
	'smw_smwadmin_db' => 'تثبيت و تحديث قاعدة البيانات',
	'smw_smwadmin_dbdocu' => 'سيمانتيك ميدياويكي يتطلب بعض الامتدادات لقاعدة بيانات ميدياويكي حتى يخزن البيانات السيمانتيك.
الوظيفة التالية تؤكد أن قاعدة بياناتك منصبة بشكل صحيح.
التغييرات المعمولة في هذه الخطوة لا تؤثر على بقية قاعدة بيانات ميدياويكي، ويمكن استرجاعها بسهولة في حالة الرغبة في ذلك.
وظيفة التنصيب هذه يمكن تنفيذها عدة مرات بدون عمل أي ضرر، لكنها مطلوبة مرة واحدة عند التنصيب أو الترقية.',
	'smw_smwadmin_permissionswarn' => 'لو أن العملية فشلت مع أخطاء SQL، فقاعدة البيانات التي طبقها المستخدم بواسطة الويكي الخاص بك (تحقق من LocalSettings.php الخاص بك) على الأرجح لا تمتلك سماحات كافية.
إما أن تمنح هذا المستخدم سماحات إضافية لإنشاء وحذف الجداول، مؤقتا أدخل تسجيل الدخول للroot الخاص بقاعدة بياناتك في LocalSettings.php، أو استخدم سكريبت الصيانة <tt>SMW_setup.php</tt> الذي يمكنه استخدام تأكيدات AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'جداول البدء أو الترقية',
	'smw_smwadmin_announce' => 'أعلن عن الويكي الخاص بك',
	'smw_smwadmin_announcedocu' => 'سيمانتيك ميدياويكي لديه خدمة وب لإعلان مواقع الويكي السيمانتيك الجديدة.
هذا يستخدم للاعتناء بقائمة من المواقع العلنية التي تستخدم سيمانتيك ميدياويكي، أساسا لمساعدة <a href="http://semantic-mediawiki.org/wiki/SMW_Project">مشروع سيمانتيك ميدياويكي</a> للحصول على عرض عام للاستخدامات النمطية لسيمانتيك ميدياويكي.
انظر الصفحة الرئيسية لسيمانتيك ميدياويكي ل<a href="http://semantic-mediawiki.org/wiki/Registry">مزيد من المعلومات حول هذه الخدمة</a>.',
	'smw_smwadmin_announcebutton' => 'اضغط على الزر التالي لإرسال مسار الويكي الخاص بك إلى تلك الخدمة.
الخدمة لن تسجل الويكيات التي لا يمكن الوصول إليها بشكل علني، وستخزن فقط البيانات التي يمكن الوصول إليها بشكل علني.',
	'smw_smwadmin_datarefresh' => 'إصلاح البيانات وتحديثها',
	'smw_smwadmin_datarefreshdocu' => 'من الممكن استرجاع كل بيانات سيمانتيك ميدياويكي بناء على المحتويات الحالية للويكي.
هذا يمكن أن يكون مفيدا لإصلاح البيانات المكسورة أو لتحديث البيانات لو أن الصيغة الداخلية تغيرت بسبب ترقية برنامج.
التحديث يتم تنفيذه صفحة بصفحة ولن يتم إكماله حالا.
التالي يعرض ما إذا كان التحديث يجري ويسمح لك ببدء أو إنهاء التحديثات (إلا لو كانت هذه الخاصية تم تعطيلها بواسطة إداري الموقع).',
	'smw_smwadmin_datarefreshprogress' => '<strong>تحديث يجري بالفعل.</strong>
من الطبيعي أن تتقدم عمليات التحديث ببطء فقط بما أنها تحدث البيانات فقط في كميات صغيرة كل مرة مستخدم ما يصل إلى الويكي.
للانتهاء من هذا التحديث سريعا، يمكنك تشغيل سكريبت صيانة ميدياويكي <tt>runJobs.php</tt> (استخدم الخيار <tt>--maxjobs 1000</tt> لتحديد عدد التحديثات المعمولة كل مرة).
التقدم المقدر للتحديث الحالي:',
	'smw_smwadmin_datarefreshbutton' => 'أبدا تحديث البيانات',
	'smw_smwadmin_datarefreshstop' => 'أوقف هذا التحديث',
	'smw_smwadmin_datarefreshstopconfirm' => 'نعم، أنا متأكد',
	'smw_smwadmin_support' => 'أحصل على دعم',
	'smw_smwadmin_supportdocu' => ':مصادر متعددة يمكن أن تساعدة في حالة مشاكل',
	'smw_smwadmin_installfile' => 'لو أنك تواجه مشاكل مع تنصيبك، ابدأ بالتحقق من الإرشادات في <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">ملف INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'وثائق المستخدم الكاملة لسيمانتيك ميدياويكي موجودة في <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'العلل يمكن إبلاغها إلى <a href="https://bugzilla.wikimedia.org/">ميديازيللا</a>.',
	'smw_smwadmin_questions' => 'لو لديك أسئلة أو اقتراحات أخرى، انضم إلى النقاش في <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">منتدى مستخدمي سيمانتيك ميدياويكي</a>.',
	'smw_adminlinks_datastructure' => 'هيكل البيانات',
	'smw_adminlinks_displayingdata' => 'عرض البيانات',
	'smw_adminlinks_inlinequerieshelp' => 'مساعدة الاستعلامات الداخلية',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'smw_printername_auto' => 'ܝܬܐܝܬ',
	'smw_printername_table' => 'ܠܘܚܝܬܐ',
	'smw_printername_template' => 'ܩܠܒܐ',
	'smw_true_words' => 'ܬܪܝܨܐ,ܬ,ܐܝܢ,ܐ',
	'smw_false_words' => 'ܦܘܕܐ,ܦ,ܠܐ,ܠ',
	'exportrdf' => 'ܐܦܩ ܦܐܬܬ̈ܐ ܠ RDF',
	'smw_exportrdf_submit' => 'ܐܦܩ',
	'types' => 'ܐܕܫ̈ܐ',
	'smw_sbv_value' => 'ܛܝܡܐ:',
	'smw_result_results' => 'ܦܠܛ̈ܐ',
	'smw_result_noresults' => 'ܠܐ ܦܠܛ̈ܐ.',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Ghaly
 * @author Meno25
 * @author Ouda
 * @author Ramsis II
 */
$messages['arz'] = array(
	'smw-desc' => "جعل الويكى الخاص بك أكثر قابليه للوصول - للآلات ''و'' البشر ([http://semantic-mediawiki.org/wiki/Help:User_manual توثيق على الإنترنت])",
	'smw_edithelp' => 'تعديل المساعده على الخصائص',
	'smw_viewasrdf' => 'تلقيم RDF',
	'smw_finallistconjunct' => '، و',
	'smw_factbox_head' => 'حقائق عن $1',
	'smw_isspecprop' => 'هذه الخاصيه هى خاصيه خاصه فى هذا الويكى.',
	'smw_isknowntype' => 'هذا النوع هو من بين أنواع البيانات الموحده من هذا الويكى.',
	'smw_isaliastype' => 'هذا النوع هو الاسم المستعار لنوع البيانات "$1".',
	'smw_isnotype' => 'هذا النوع "$1" هو ليس معيار البيانات فى الويكى، ولم يعط تعريفا من قبل المستخدمين.',
	'smw_concept_description' => 'وصف المبدأ "$1"',
	'smw_no_concept_namespace' => 'المبادئ يمكن تعريفها فقط فى الصفحات فى نطاق Concept:',
	'smw_multiple_concepts' => 'كل صفحه مبدأ يمكن أن تحتوى على تعريف مبدأ واحد.',
	'smw_concept_cache_miss' => 'المبدأ "$1" لا يمكن استخدامه حاليا، بما أن ضبط الويكى يحتاجه إلى أن يتم حسابه خارجيا. لو أن المشكله لم تنته بعد بعض الوقت، سل إدارى موقعك ليجعل هذا المبدأ متوفرا.',
	'smw_noinvannot' => 'القيم لا يمكن تعيينها لخصائص معكوسه.',
	'smw_baduri' => 'URIs من النوع "$1" غير مسموح بها.',
	'smw_rss_link' => 'آر إس إس',
	'smw_csv_link' => 'سى فى إس',
	'smw_printername_auto' => 'تلقائي',
	'smw_printername_count' => 'عد النتائج',
	'smw_printername_csv' => 'تصدير CSV',
	'smw_printername_debug' => 'استعلام التصليح (للخبراء)',
	'smw_printername_embedded' => 'تضمين محتويات الصفحة',
	'smw_printername_json' => 'تصدير JSON',
	'smw_printername_list' => 'قائمة',
	'smw_printername_ol' => 'ترقيم',
	'smw_printername_ul' => 'ترتيب فى عناصر',
	'smw_printername_rss' => 'تصدير RSS',
	'smw_printername_table' => 'جدول',
	'smw_printername_broadtable' => 'جدول عريض',
	'smw_printername_template' => 'قالب',
	'smw_paramdesc_limit' => 'الرقم الأقصى للعناصر المُرجعة',
	'smw_paramdesc_headers' => 'اعرض العناوين/أسماء الخصائص',
	'smw_paramdesc_mainlabel' => 'العلامه للإعطاء لاسم الصفحه الرئيسية',
	'smw_paramdesc_link' => 'أظهر القيم كوصلات',
	'smw_paramdesc_intro' => 'النص للعرض قبل نتائج الاستعلام، لو كانت هناك أي',
	'smw_paramdesc_outro' => 'النص المطلوب عرضه بعد نتائج الاستعلام، إن وُجدت',
	'smw_paramdesc_default' => 'النص المطلوب عرضه إذا لم تتوفر نتائج للاستعلام',
	'smw_paramdesc_searchlabel' => 'نص وصله النتائج',
	'smw_paramdesc_sep' => 'فاصل القيم',
	'smw_paramdesc_template' => 'اسم القالب لعرض الخرج به',
	'smw_paramdesc_columns' => 'رقم الأعمده لعرض النتائج بها (افتراضيا $1)',
	'smw_paramdesc_embedformat' => 'وسم HTML المستخدم لتعريف الترويسة',
	'smw_paramdesc_embedonly' => 'لا تظهر الترويسات',
	'smw_paramdesc_rsstitle' => 'النص المستخدم كعنوان للتغذية',
	'smw_paramdesc_rssdescription' => 'النص المستخدم لوصف التغذية',
	'smw_iq_disabled' => 'استعلامات السيمانتيك تم تعطيلها فى هذا الويكى.',
	'smw_iq_moreresults' => '… مزيد من النتائج',
	'smw_iq_nojs' => 'استخدم متصفحا يُمكّن جافاسكربت لرؤيه هذا العنصر.',
	'smw_iq_altresults' => 'استعرض قائمه النتائج مباشره.',
	'smw_unknown_importns' => 'إمكانيه استيراد ليست متوفره للنطاق "$1".',
	'smw_nonright_importtype' => '$1 لا يمكن أن تستخدم إلا لصفحات مع النطاق "$2".',
	'smw_wrong_importtype' => '$1 لا يمكن استخدامها للصفحات فى النطاق "$2".',
	'smw_no_importelement' => 'العنصر "$1" غير متوفر للاستيراد.',
	'smw_parseerror' => 'القيمه المعطاه لم يتم فهمها.',
	'smw_kiloseparator' => '،',
	'smw_notitle' => '"$1" لا يمكن أن تستخدم مثل هذا الاسم فى صفحه ويكى.',
	'smw_wrong_namespace' => 'فقط الصفحات فى النطاق "$1" مسموح بها هنا.',
	'smw_unknowntype' => 'نوع غير مدعوم "$1" لتعريف الممتلكات.',
	'smw_manytypes' => 'أكثر من نوع واحد لتعريف الخاصيه.',
	'smw_emptystring' => 'السلاسل الفارغه غير مقبوله.',
	'smw_maxstring' => 'تمثيل السلسله $1 طويل جدا.',
	'smw_notinenum' => '"$1" ليس ضمن قائمه القيم الممكنه ($2) لهذه الخاصيه.',
	'smw_noboolean' => '"$1" غير متعرف عليها كقيمه بووليان (صواب/خطأ).',
	'smw_true_words' => 'صحيح،ص،نعم،ن',
	'smw_false_words' => 'خطأ،خ،لا،ل',
	'smw_nofloat' => 'ليس عددا "$1".',
	'smw_infinite' => 'الأرقام الكبيره مثل "$1" غير مدعومه.',
	'smw_infinite_unit' => 'التحويل إلى الوحده "$1" نتج عنه رقم كبير جدا.',
	'smw_unsupportedprefix' => 'غير مدعوم ("$1") البادئات لأرقام.',
	'smw_unsupportedunit' => 'غير مدعوم "$1" تحويل الوحده للوحده.',
	'smw_nodatetime' => 'التاريخ "$1" لم يتم فهمه.',
	'smw_toomanyclosing' => 'يبدو أنه هناك الكثير من "$1" فى الاستعلام.',
	'smw_noclosingbrackets' => '"]]" فى استعلامك لم تكن مغلقه باستخدام "<nowiki>[[</nowiki>" بعض استخدام',
	'smw_misplacedsymbol' => 'الرمز "$1" تم استخدامه فى مكان حيث هو ليس مفيدا.',
	'smw_unexpectedpart' => 'الجزء "$1" من الاستعلام لم يفهم.
النتائج قد لا تكون كما هو متوقع.',
	'smw_emptysubquery' => 'بعض الاستعلامات الفرعيه ليس لها شرط صحيح.',
	'smw_misplacedsubquery' => 'بعض الاستعلامات الفرعيه تم استخدمها فى مكان غير مسموح فيه بالاستعلامات الفرعيه.',
	'smw_valuesubquery' => 'الاستعلامات الفرعيه غير مدعومه لقيم الخاصيه "$1".',
	'smw_overprintoutlimit' => 'هذا الاستعلام يحتوى على عدد كبير جدا من طلبات الطبع.',
	'smw_badprintout' => 'بعض المطبوعات فى الاستعلام لم تتشكل بصوره صحيحه.',
	'smw_badtitle' => '"$1" ليس عنوان صفحه صحيحا.',
	'smw_badqueryatom' => 'جزء ما "<nowiki>[[…]]</nowiki>" من الاستعلام لم يتم فهمه.',
	'smw_propvalueproblem' => 'قيمه الخاصيه "$1" لم يتم فهمها.',
	'smw_noqueryfeature' => 'ميزه استعلام ما لم يتم دعمها فى هذا الويكى وجزء من الاستعلام تم إسقاطه ($1).',
	'smw_noconjunctions' => 'الوقوفات فى الاستعلامات غير مدعومه فى هذا الويكى وجزء من الاستعلام تم إسقاطه ($1).',
	'smw_nodisjunctions' => 'المفارق فى استعلامات ليست مدعومه فى هذا الويكى وجزء من الاستعلام رفض $1.',
	'smw_querytoolarge' => 'شروط الاستفسار التاليه لم يمكن اعتبارها نتيجه لقيود الويكى فى حجم أو عمق الاستعلام: $1.',
	'smw_devel_warning' => 'هذه الخاصيه حاليا قيد التطوير، وربما لا تعمل بشكل كامل.
احفظ بياناتك قبل استخدامها.',
	'smw_notemplategiven' => 'وفر قيمه للمحدد "template" لتعمل صيغه الاستعلام هذه.',
	'smw_type_header' => 'خصائص النوع "$1"',
	'smw_typearticlecount' => 'عرض {{PLURAL:$1||خاصيه واحده تستخدم|خاصيتين تستخدمان|$1 خصائص تستخدم|$1 خاصيه تستخدم}} هذا النوع.',
	'smw_attribute_header' => 'الصفحات التى تستخدم الخاصيه "$1"',
	'smw_attributearticlecount' => 'عرض {{PLURAL:$1||الصفحه التى تستخدم|الصفحتين اللتين تستخدمان|الصفحات التى تستخدم}} هذه الخاصيه.',
	'smw_subproperty_header' => 'خواص فرعية',
	'smw_subpropertyarticlecount' => 'لهذه الخاصيه {{PLURAL:$1||الخاصيه الفرعيه التالية|الخاصيتين الفرعيتين التاليتين|الخصائص الفرعيه التالية}}:',
	'smw_concept_header' => 'صفحات المبدأ "$1"',
	'smw_conceptarticlecount' => 'عرض {{PLURAL:$1||صفحه واحده تنتمي|صفحتين تنتميان|$1 صفحات تنتمي|$1 صفحه تنتمي}} إلى هذا المبدأ.',
	'smw_rss_description' => '$1 تلقيم آر إس إس',
	'specialpages-group-smw_group' => 'سيمانتيك ميدياويكى',
	'exportrdf' => 'آر دی‌ إف إلى صفحات تصدير',
	'smw_exportrdf_docu' => ' هذه الصفحه تتيح لك الحصول على بيانات من صفحه فى شكل آر دی‌ إف.
التصدير إلى صفحات، أدخل العناوين فى مربع النص أدناه، عنوان واحد لكل سطر.',
	'smw_exportrdf_recursive' => 'تصدير جميع الصفحات ذات الصله بشكل تكرارى.
علما أنه يمكن أن تكون النتيجه كبيرة!',
	'smw_exportrdf_backlinks' => 'أيضا تصدير كل الصفحات التى تشير إلى الصفحات تم تصديرها.
يولد آر دى إف قابل للتصفح.',
	'smw_exportrdf_lastdate' => 'لا تصدر الصفحات التى لم تتغير منذ نقطه زمنيه محدده.',
	'smw_exportrdf_submit' => 'تصدير',
	'properties' => 'الخصائص',
	'smw_properties_docu' => 'الخصائص التاليه تستخدم فى الويكى.',
	'smw_property_template' => '$1 من نوع $2 ($3)',
	'smw_propertylackspage' => 'جميع الخصائص ينبغى أن توصف بصفحة!',
	'smw_propertylackstype' => 'لا نوع تم تحديده لهذه الخاصيه (افتراض النوع $1 حاليا).',
	'smw_propertyhardlyused' => 'هذه الخاصيه لا تكاد تستخدم داخل الويكي!',
	'unusedproperties' => 'خصائص غير مستخدمة',
	'smw_unusedproperties_docu' => 'الخصائص التاليه موجوده على الرغم من أنه لا صفحه أخرى تستخدمها.',
	'smw_unusedproperty_template' => '$1 من نوع $2',
	'wantedproperties' => 'خصائص مطلوبة',
	'smw_wantedproperties_docu' => 'الخصائص التاليه مستخدمه فى الويكى ولكن ليس لديها حتى الآن صفحه لوصفها.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|استخدام|استخدام}})',
	'tooltip-purge' => 'اضغط هنا لتحديث كافه الاستفسارات والقوالب على هذه الصفحة',
	'smw_purge' => 'تحديث',
	'types' => 'أنواع',
	'smw_types_docu' => 'التالى قائمه بجميع أنواع البيانات التى يمكن أن تسند إلى الخصائص.
كل نوع بيانات له صفحه حيث يمكن توفير معلومات إضافيه.',
	'smw_typeunits' => 'وحدات القياس من النوع "$1": $2',
	'semanticstatistics' => 'إحصاءات سيمانتيك',
	'smw_semstats_text' => "هذا الويكى يحتوى على '''$1''' {{PLURAL:$1|قيمة|قيمة}} خاصيه بإجمالى '''$2''' [[Special:Properties|{{PLURAL:$2|خاصية|خاصيه مختلفة}}]].
'''$3''' {{PLURAL:$3|خاصيه تمتلك|خاصيه تمتلك}} صفحتها الخاصه، ونوع البيانات المقصود محدد ل'''$4''' من هؤلاء.
بعض الخواص الموجوده ربما تكون [[Special:UnusedProperties|خواص غير مستخدمة]].
الخواص التى مازالت تفتقد صفحه موجوده فى [[Special:WantedProperties|قائمه الخواص المطلوبة]].",
	'uriresolver' => 'محلل URI',
	'smw_uri_doc' => 'محلل URI ينفذ <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C على httpRange-14</a>. إنه يتأكد من أن البشر لا يتحولون إلى مواقع ويب.',
	'ask' => 'بحث سيمانتيك',
	'smw_ask_sortby' => 'الترتيب حسب العمود (اختياري)',
	'smw_ask_ascorder' => 'تصاعدي',
	'smw_ask_descorder' => 'تنازلي',
	'smw_ask_submit' => 'جِد نتائجًا',
	'smw_ask_editquery' => '[عدل الاستعلام]',
	'smw_add_sortcondition' => '[أضف شرط ترتيب]',
	'smw_ask_hidequery' => 'إخفاء الاستعلام',
	'smw_ask_help' => 'مساعده الاستعلام',
	'smw_ask_queryhead' => 'استعلام',
	'smw_ask_printhead' => 'بيانات إضافيه للعرض',
	'smw_ask_printdesc' => '(أضف اسمًا مناسبًا واحدًا فى كل سطر)',
	'smw_ask_format_as' => 'صياغه ك:',
	'smw_ask_defaultformat' => 'افتراضي',
	'smw_ask_otheroptions' => 'خيارات أخرى',
	'smw_ask_show_embed' => 'عرض الكود المضمن',
	'smw_ask_hide_embed' => 'إخفاء الكود المضمن',
	'smw_ask_embed_instr' => 'لتضمين هذا الاستعلام فى صفحه ويكى، استخدم الكود أدناه',
	'searchbyproperty' => 'البحث حسب الخصائص',
	'smw_sbv_docu' => 'البحث عن كل الصفحات التى لها خصائص معينه وقيمة',
	'smw_sbv_novalue' => 'أدخل قيمه صحيحه للخاصيه، أو انظر كل قيم الخصائص ل"$1"',
	'smw_sbv_displayresult' => 'قائمه بكل الصفحات التى بها الخاصيه "$1" بالقيمه "$2"',
	'smw_sbv_displayresultfuzzy' => 'قائمه بكل الصفحات التى لديها الخاصيه "$1" بالقيمه "$2".
بما أنه كانت هناك فقط عده نتائج، فالقيم المقاربه معروضه أيضا.',
	'smw_sbv_property' => 'خاصية:',
	'smw_sbv_value' => 'قيمة:',
	'smw_sbv_submit' => 'جِد نتائجًا',
	'browse' => 'استعرض يكي',
	'smw_browselink' => 'خصائص التصفح',
	'smw_browse_article' => 'أدخل اسم الصفحه لبدء التصفح منها.',
	'smw_browse_go' => 'اذهب',
	'smw_browse_show_incoming' => 'أظهر الخواص التى تصل هنا',
	'smw_browse_hide_incoming' => 'أخفِ الخواص التى تصل هنا',
	'smw_browse_no_outgoing' => 'هذه الصفحه ليس لديها خصائص.',
	'smw_browse_no_incoming' => 'لا خصائص تصل إلى هذه الصفحه.',
	'smw_inverse_label_default' => '$1 من',
	'smw_inverse_label_property' => 'اعكس علامه الخاصية',
	'pageproperty' => 'بحث خصائص الصفحة',
	'smw_pp_docu' => 'البحث عن جميع قيم خاصيه على صفحه معينه.
أدخل صفحه وخاصيه.',
	'smw_pp_from' => 'من صفحة',
	'smw_pp_type' => 'الخاصية',
	'smw_pp_submit' => 'جِد نتائجًا',
	'smw_result_prev' => 'السابق',
	'smw_result_next' => 'التالي',
	'smw_result_results' => 'النتائج',
	'smw_result_noresults' => 'لا توجد نتائج.',
	'smwadmin' => 'وظائف إداريه لسيمانتيك ميدياويكي',
	'smw_smwadmin_settingup' => 'ضبط التخزين لسيمانتيك ميدياويكي',
	'smw_smwadmin_setupsuccess' => 'تم تنصيب محرك التخزين بنجاح',
	'smw_smwadmin_return' => 'أرجع إلى $1',
	'smw_smwadmin_updatestarted' => 'عمليه تحديث جديده لتحديث بيانات سيمانتيك بدأت.
كل البيانات المخزنه ستتم إعاده بنائها أو إصلاحها عند الحاجه.
أنت يمكنك متابعه تطور التحديث على هذه الصفحه الخاصه.',
	'smw_smwadmin_updatenotstarted' => 'يوجد بالفعل عمليه تحديث جاريه.
لا تنشئ واحده أخرى.',
	'smw_smwadmin_updatestopped' => 'كل عمليات التحديث الموجوده تم إيقافها',
	'smw_smwadmin_updatenotstopped' => 'لوقف عمليه التحديث الجاريه، يجب عليك تفعيل الصندوق لتعبر عن أنك متأكد حقا.',
	'smw_smwadmin_docu' => 'هذه الصفحه الخاصه تساعدك خلال تنصيب وترقيه <a href="http://semantic-mediawiki.org">سيمانتيك ميدياويكي</a>.
تذكر أن تخزن احتياطيا البيانات القيمه قبل تنفيذ وظائف إداريه.',
	'smw_smwadmin_db' => 'تثبيت و تحديث قاعده البيانات',
	'smw_smwadmin_dbdocu' => 'سيمانتيك ميدياويكى يتطلب بعض الامتدادات لقاعده بيانات ميدياويكى حتى يخزن البيانات السيمانتيك.
الوظيفه التاليه تؤكد أن قاعده بياناتك منصبه بشكل صحيح.
التغييرات المعموله فى هذه الخطوه لا تؤثر على بقيه قاعده بيانات ميدياويكى، ويمكن استرجاعها بسهوله فى حاله الرغبه فى ذلك.
وظيفه التنصيب هذه يمكن تنفيذها عده مرات بدون عمل أى ضرر، لكنها مطلوبه مره واحده عند التنصيب أو الترقيه.',
	'smw_smwadmin_permissionswarn' => 'لو أن العمليه فشلت مع أخطاء SQL، فقاعده البيانات التى طبقها المستخدم بواسطه الويكى الخاص بك (تحقق من LocalSettings.php الخاص بك) على الأرجح لا تمتلك سماحات كافيه.
إما أن تمنح هذا المستخدم سماحات إضافيه لإنشاء وحذف الجداول، مؤقتا أدخل تسجيل الدخول للroot الخاص بقاعده بياناتك فى LocalSettings.php، أو استخدم سكريبت الصيانه <tt>SMW_setup.php</tt> الذى يمكنه استخدام تأكيدات AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'جداول البدء أو الترقية',
	'smw_smwadmin_announce' => 'أعلن عن الويكى الخاص بك',
	'smw_smwadmin_announcedocu' => 'سيمانتيك ميدياويكى لديه خدمه وب لإعلان مواقع الويكى السيمانتيك الجديده.
هذا يستخدم للاعتناء بقائمه من المواقع العلنيه التى تستخدم سيمانتيك ميدياويكى، أساسا لمساعده <a href="http://semantic-mediawiki.org/wiki/SMW_Project">مشروع سيمانتيك ميدياويكي</a> للحصول على عرض عام للاستخدامات النمطيه لسيمانتيك ميدياويكى.
انظر الصفحه الرئيسيه لسيمانتيك ميدياويكى ل<a href="http://semantic-mediawiki.org/wiki/Registry">مزيد من المعلومات حول هذه الخدمة</a>.',
	'smw_smwadmin_announcebutton' => 'اضغط على الزر التالى لإرسال مسار الويكى الخاص بك إلى تلك الخدمه.
الخدمه لن تسجل الويكيات التى لا يمكن الوصول إليها بشكل علنى، وستخزن فقط البيانات التى يمكن الوصول إليها بشكل علنى.',
	'smw_smwadmin_datarefresh' => 'إصلاح البيانات وتحديثها',
	'smw_smwadmin_datarefreshdocu' => 'من الممكن استرجاع كل بيانات سيمانتيك ميدياويكى بناء على المحتويات الحاليه للويكى.
هذا يمكن أن يكون مفيدا لإصلاح البيانات المكسوره أو لتحديث البيانات لو أن الصيغه الداخليه تغيرت بسبب ترقيه برنامج.
التحديث يتم تنفيذه صفحه بصفحه ولن يتم إكماله حالا.
التالى يعرض ما إذا كان التحديث يجرى ويسمح لك ببدء أو إنهاء التحديثات (إلا لو كانت هذه الخاصيه تم تعطيلها بواسطه إدارى الموقع).',
	'smw_smwadmin_datarefreshprogress' => '<strong>تحديث يجرى بالفعل.</strong>
من الطبيعى أن تتقدم عمليات التحديث ببطء فقط بما أنها تحدث البيانات فقط فى كميات صغيره كل مره مستخدم ما يصل إلى الويكى.
للانتهاء من هذا التحديث سريعا، يمكنك تشغيل سكريبت صيانه ميدياويكى <tt>runJobs.php</tt> (استخدم الخيار <tt>--maxjobs 1000</tt> لتحديد عدد التحديثات المعموله كل مرة).
التقدم المقدر للتحديث الحالي:',
	'smw_smwadmin_datarefreshbutton' => 'أبدا تحديث البيانات',
	'smw_smwadmin_datarefreshstop' => 'أوقف هذا التحديث',
	'smw_smwadmin_datarefreshstopconfirm' => 'نعم، أنا متأكد',
	'smw_smwadmin_support' => 'أحصل على دعم',
	'smw_smwadmin_supportdocu' => ':مصادر متعدده يمكن أن تساعده فى حاله مشاكل',
	'smw_smwadmin_installfile' => 'لو أنك تواجه مشاكل مع تنصيبك، ابدأ بالتحقق من الإرشادات فى <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">ملف INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'وثائق المستخدم الكامله لسيمانتيك ميدياويكى موجوده فى <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'العلل يمكن إبلاغها إلى <a href="https://bugzilla.wikimedia.org/">ميديازيللا</a>.',
	'smw_smwadmin_questions' => 'لو لديك أسئله أو اقتراحات أخرى، انضم إلى النقاش فى <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">منتدى مستخدمى سيمانتيك ميدياويكي</a>.',
	'smw_adminlinks_datastructure' => 'هيكل البيانات',
	'smw_adminlinks_displayingdata' => 'عرض البيانات',
	'smw_adminlinks_inlinequerieshelp' => 'مساعده الاستعلامات الداخلية',
);

/** Belarusian (Taraškievica orthography) (Беларуская (тарашкевіца))
 * @author EugeneZelenko
 * @author Jim-by
 * @author Red Winged Duck
 */
$messages['be-tarask'] = array(
	'smw-desc' => "Робіць {{GRAMMAR:вінавальны|{{SITENAME}}}} больш зручнай для кампутараў ''і'' людзей ([http://semantic-mediawiki.org/wiki/Help:User_manual дакумэнтацыя])",
	'smw_edithelp' => 'Рэдагаваць дапамогу па ўласьцівасьцях',
	'smw_viewasrdf' => 'RDF-крыніца',
	'smw_finallistconjunct' => ' і',
	'smw_factbox_head' => 'Факты аб $1',
	'smw_isspecprop' => 'Гэтая ўласьцівасьць зьяўляецца спэцыяльнай у {{GRAMMAR:месны|{{SITENAME}}}}.',
	'smw_isknowntype' => 'Гэты тып належыць да стандартных тыпаў зьвестак у {{GRAMMAR:месны|{{SITENAME}}}}.',
	'smw_isaliastype' => 'Гэты тып зьяўляецца псэўданімам для тыпаў зьвестак «$1».',
	'smw_isnotype' => 'Гэты тып «$1» не зьяўляецца стандартным тыпам зьвестак у {{GRAMMAR:месны|{{SITENAME}}}}, і ня быў вызначаны ўдзельнікам.',
	'smw_concept_description' => 'Апісаньне канцэпцыі «$1»',
	'smw_no_concept_namespace' => 'Канцэпцыі могуць быць вызначаныя толькі на старонках прасторы назваў «Канцэпцыя:».',
	'smw_multiple_concepts' => 'Кожная старонка канцэпцыі можа мець толькі адно вызначэньне канцэпцыі.',
	'smw_concept_cache_miss' => 'Канцэпцыя «$1» ня можа быць выкарыстаная ў гэты момант, таму што канфігурацыя {{GRAMMAR:родны|{{SITENAME}}}} патрабуе, каб яна вылічалася аф-лайн. Калі гэта праблема ня зьнікне празь некаторы час, запытайце Вашага адміністратара сайта ўключыць гэтую канцэпцыю.',
	'smw_noinvannot' => 'Значэньні ня можа быць прызначаныя ў адваротныя уласьцівасьці.',
	'smw_baduri' => 'Спасылкі на форму «$1» не дазволеныя.',
	'smw_printername_auto' => 'Аўтаматычна',
	'smw_printername_count' => 'Падлік вынікаў',
	'smw_printername_csv' => 'экспарт у фармаце CSV',
	'smw_printername_debug' => 'Запыт для наладкі (для экспэртаў)',
	'smw_printername_embedded' => 'Устаўляць зьмест старонак',
	'smw_printername_json' => 'экспарт у фармаце JSON',
	'smw_printername_list' => 'Сьпіс',
	'smw_printername_ol' => 'Пералік',
	'smw_printername_ul' => 'Дэталізацыя',
	'smw_printername_rss' => 'экспарт у фармаце RSS',
	'smw_printername_table' => 'Табліца',
	'smw_printername_broadtable' => 'Шырокая табліца',
	'smw_printername_template' => 'Шаблён',
	'smw_paramdesc_limit' => 'Максымальная колькасьць вынікаў для вяртаньня',
	'smw_paramdesc_headers' => 'Паказваць назвы загалоўкаў/уласьцівасьцяў',
	'smw_paramdesc_mainlabel' => 'Метка для назвы галоўнай старонкі',
	'smw_paramdesc_link' => 'Паказваць значэньні як спасылкі',
	'smw_paramdesc_intro' => 'Тэкст для паказу перад вынікамі запыту, калі яны ёсьць',
	'smw_paramdesc_outro' => 'Тэкст для паказу пасьля вынікаў запыту, калі яны ёсьць',
	'smw_paramdesc_default' => 'Тэкст для паказу ў выпадку адсутнасьці вынікаў',
	'smw_paramdesc_searchlabel' => 'Тэкст спасылкі на вынікі',
	'smw_paramdesc_sep' => 'Разьдзяляльнік значэньняў',
	'smw_paramdesc_template' => 'Назва шаблёну, які будзе выкарыстоўвацца для вываду вынікаў',
	'smw_paramdesc_columns' => 'Колькасьць слупкоў у якіх будуць паказвацца вынікі (па змоўчваньні — $1)',
	'smw_paramdesc_embedformat' => 'Тэг HTML, які выкарыстоўваецца для вызначэньня загалоўкаў',
	'smw_paramdesc_embedonly' => 'Не паказваць загалоўкі',
	'smw_paramdesc_rsstitle' => 'Тэкст, які будзе выкарыстоўвацца як назва стужкі',
	'smw_paramdesc_rssdescription' => 'Тэкст, які будзе выкарыстоўвацца як апісаньне стужкі',
	'smw_iq_disabled' => 'Сэмантычныя запыты былі выключаны ў {{GRAMMAR:месны|{{SITENAME}}}}.',
	'smw_iq_moreresults' => '… наступныя вынікі',
	'smw_iq_nojs' => 'Карыстайцеся браўзэрам з падтрымкай JavaScript, каб паглядзець гэты элемэнт.',
	'smw_iq_altresults' => 'Праглядзець непасрэдны сьпіс вынікаў.',
	'smw_unknown_importns' => 'Функцыі імпарту не даступныя для прасторы назваў «$1».',
	'smw_nonright_importtype' => '$1 можа выкарыстоўвацца выключна для старонак з прасторы назваў «$2».',
	'smw_wrong_importtype' => '$1 ня можа выкарыстоўвацца для старонак з прасторы назваў «$2».',
	'smw_no_importelement' => 'Элемэнт «$1» ня можа быць імпартаваны.',
	'smw_parseerror' => 'Пададзенае значэньне не было распазнанае.',
	'smw_notitle' => '«$1» ня можа выкарыстоўвацца як назва старонкі ў {{GRAMMAR:месны|{{SITENAME}}}}.',
	'smw_wrong_namespace' => 'Тут дазволены толькі старонкі з прасторы назваў «$1».',
	'smw_unknowntype' => 'Тып «$1» не падтрымліваецца для гэтай уласьцівасьці.',
	'smw_manytypes' => 'Для ўласьцівасьці вызначана болей аднаго тыпу.',
	'smw_emptystring' => 'Пустыя радкі не дазволены.',
	'smw_maxstring' => 'Радковае прадстаўленьне «$1» занадта доўгае.',
	'smw_notinenum' => '«$1» не ўваходзіць у сьпіс магчымых значэньняў ($2) для гэтай уласьцівасьці.',
	'smw_noboolean' => '«$1» не зьяўляецца лягічным значэньнем (праўда/няпраўда).',
	'smw_true_words' => 'праўда,п,так,т',
	'smw_false_words' => 'няпраўда,н,не',
	'smw_nofloat' => '«$1» не зьяўляецца лікам.',
	'smw_infinite' => 'Лікі, большыя за «$1», не падтрымліваюцца.',
	'smw_infinite_unit' => 'Пераўтварэньне ў адзінку «$1» стварыла лік, які зьяўляецца занадта вялікім.',
	'smw_novalues' => 'Значэньні не пазначаныя',
	'smw_unsupportedprefix' => 'Прэфіксы для лікаў («$1») не падтрымліваюцца.',
	'smw_unsupportedunit' => 'Пераўтварэньне адзінак для адзінкі «$1» не падтрымліваецца.',
	'smw_nodatetime' => 'Дата «$1» не была распазнаная.',
	'smw_toomanyclosing' => 'Зашмат уваходжаньняў «$1» у запыце.',
	'smw_noclosingbrackets' => 'Выкарыстаныя дужкі «<nowiki>[[</nowiki>» у Вашым запыце не былі зачынены адпаведнымі дужкамі «]]».',
	'smw_misplacedsymbol' => 'Сымбаль «$1» быў выкарыстаны ў месцы, дзе ён ня мае сэнсу.',
	'smw_unexpectedpart' => 'Частка запыту «$1» не была распазнаная.
Вынікі могуць быць нечаканымі.',
	'smw_emptysubquery' => 'Нейкі падзапыт ня мае слушных умоваў.',
	'smw_misplacedsubquery' => 'Нейкі падзапыт быў выкарыстаны ў месцы, дзе выкарыстаньне падзапытаў не дазволена.',
	'smw_valuesubquery' => 'Падзапыты не падтрымліваюцца для значэньняў уласьцівасьці «$1».',
	'smw_overprintoutlimit' => 'Запыт утрымлівае зашмат патрабаваньняў вываду.',
	'smw_badprintout' => 'Некаторыя фармулёўкі вываду ў запыце маюць памылкі.',
	'smw_badtitle' => '«$1» зьяўляецца няслушнай назвай старонкі.',
	'smw_badqueryatom' => 'Частка запыту «<nowiki>[[…]]</nowiki>» не была распазнаная.',
	'smw_propvalueproblem' => 'Значэньне ўласьцівасьці «$1» не было распазнанае.',
	'smw_noqueryfeature' => 'Нейкая ўласьцівасьць не падтрымліваецца ў {{GRAMMAR:месны|{{SITENAME}}}}, і частка запыту была ігнараваная ($1).',
	'smw_noconjunctions' => 'Злучэньні ў запытах не падтрымліваюцца ў {{GRAMMAR:месны|{{SITENAME}}}}, і частка запыту была ігнараваная ($1).',
	'smw_nodisjunctions' => 'Падзяленьні ў запытах не падтрымліваюцца ў {{GRAMMAR:месны|{{SITENAME}}}}, і частка запыту была ігнараваная ($1).',
	'smw_querytoolarge' => 'Наступныя ўмовы запыту ня могуць улічвацца з-за абмежаваньняў {{GRAMMAR:родны|{{SITENAME}}}} на глыбіню і памер запыту: $1.',
	'smw_devel_warning' => 'Гэта магчымасьць знаходзіцца ў распрацоўцы і можа мець абмежаваньні ў функцыянальнасьці.
Зрабіце рэзэрвовую копію Вашы зьвестак перад яе выкарыстаньнем захавайце.',
	'smw_notemplategiven' => 'Для выкананьня гэтага запыту, неабходна ўвесьці значэньне парамэтру «template».',
	'smw_type_header' => 'Уласьцівасьці тыпу «$1»',
	'smw_typearticlecount' => '{{PLURAL:$1|Паказаная $1 уласьцівасьць, якая выкарыстоўвае|Паказаныя $1 уласьцівасьці, якія выкарыстоўваюць|Паказаныя $1 уласьцівасьцяў, якія выкарыстоўваюць}} гэты тып.',
	'smw_attribute_header' => 'Старонкі, якія выкарыстоўваюць уласьцівасьць «$1»',
	'smw_attributearticlecount' => '{{PLURAL:$1|Паказаная $1 старонка, якая выкарыстоўвае|Паказаныя $1 старонкі, якія выкарыстоўваюць|Паказаныя $1 старонак, якія выкарыстоўваюць}} гэтую ўласьцівасьць.',
	'smw_subproperty_header' => 'Падуласьцівасьці',
	'smw_subpropertyarticlecount' => 'Гэта ўласьцівасьць мае $1 {{PLURAL:$1|падуласьцівасьць|падуласьцівасьці|падуласьцівасьцяў}}:',
	'smw_concept_header' => 'Старонкі канцэпцыі «$1»',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Паказаная $1 старонка, якая належыць|Паказаныя $1 старонкі, якія належаць|Паказаныя $1 старонак, якія належаць}} гэтай канцэпцыі.',
	'exportrdf' => 'Экспарт старонак у фармаце RDF',
	'smw_exportrdf_docu' => 'Гэта старонка дазваляе Вам атрымліваць зьвесткі са старонкі ў фармаце RDF.
Каб экспартаваць старонкі, увядзіце іх назвы ніжэй у тэкставым полі, па адной назьве на радок.',
	'smw_exportrdf_recursive' => 'Рэкурсіўны экспарт усіх зьвязаных старонак.
Зьвярніце ўвагу на тое, што вынік можа быць вялікім!',
	'smw_exportrdf_backlinks' => 'Таксама экспартаваць усе старонкі, якія спасылаюцца на экспартаваныя старонкі.
Стварае RDF з поўнай навігацыяй.',
	'smw_exportrdf_lastdate' => 'Не экспартаваць старонкі, якія не зьмяняліся з пададзенага часу.',
	'smw_exportrdf_submit' => 'Экспартаваць',
	'properties' => 'Уласьцівасьці',
	'smw_properties_docu' => 'Наступныя ўласьцівасьці выкарыстоўваюцца ў {{GRAMMAR:месны|{{SITENAME}}}}.',
	'smw_property_template' => '$1 тыпу $2 ($3)',
	'smw_propertylackspage' => 'Усе ўласьцівасьці павінны мець старонку апісаньня!',
	'smw_propertylackstype' => 'Для гэтай уласьцівасьці не пазначаны ніякі тып (пакуль будзе выкарыстоўвацца тып $1).',
	'smw_propertyhardlyused' => 'Гэтая ўласьцівасьць наўрад ці выкарыстоўваецца ў {{GRAMMAR:месны|{{SITENAME}}}}!',
	'unusedproperties' => 'Уласьцівасьці, якія не выкарыстоўваюцца',
	'smw_unusedproperties_docu' => 'Наступныя ўласьцівасьці існуюць, але не выкарыстоўваюцца ніякімі старонкамі.',
	'smw_unusedproperty_template' => '$1 тыпу $2',
	'wantedproperties' => 'Запатрабаваныя ўласьцівасьці',
	'smw_wantedproperties_docu' => 'Наступныя ўласьцівасьці выкарыстоўваюцца ў {{GRAMMAR:месны|{{SITENAME}}}}, але пакуль ня маюць апісаньня.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|выкарыстаньне|выкарыстаньні|выкарыстаньняў}})',
	'tooltip-purge' => 'Націсьніце тут, каб абнавіць усе запыты і шаблёны на гэтай старонцы',
	'smw_purge' => 'Абнавіць',
	'types' => 'Тыпы',
	'smw_types_docu' => 'Ніжэй пададзены сьпіс усіх тыпаў зьвестак, якія можна выкарыстоўваць для ўласьцівасьцяў.
Кожны тып зьвестак мае старонку, дзе можа знаходзіцца дадатковая інфармацыя.',
	'smw_typeunits' => 'Адзінкі вымярэньня тыпу «$1»: $2',
	'semanticstatistics' => 'Сэмантычная статыстыка',
	'smw_semstats_text' => "{{SITENAME}} утрымлівае '''$1''' {{PLURAL:$1|значэньне|значэньні|значэньняў}} для '''$2''' [[Special:Properties|{{PLURAL:$1|уласьцівасьці|уласьцівасьцяў|ўласьцівасьцяў}}]].
<b>$3</b> {{PLURAL:$3|уласьцівасьць мае|уласьцівасьці маюць|уласьцівасьцяў маюць}} асабістыя старонкі, і пазначаны тып зьвестак падыходзіць для <b>$4</b> зь іх.
Некаторыя з існуючых уласьцівасьцяў могуць [[Special:UnusedProperties|не выкарыстоўвацца]].
Уласьцівасьці, якія яшчэ ня маюць асобных старонак, знаходзяцца ў [[Special:WantedProperties|сьпісе старонак, якія патрабуюць апісаньня]].",
	'uriresolver' => 'Пераўтваральнік URI',
	'smw_uri_doc' => 'Пераўтваральнік URI ажыцьцяўляе <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">пошук W3C TAG у httpRange-14</a>.
Гэта забясьпечвае ўпэўненасьць, што людзі не заходзяць на сайты.',
	'ask' => 'Сэмантычны пошук',
	'smw_ask_sortby' => 'Сартаваць па слупку (неабавязкова)',
	'smw_ask_ascorder' => 'Па павелічэньні',
	'smw_ask_descorder' => 'Па зьмяншэньні',
	'smw_ask_submit' => 'Шукаць',
	'smw_ask_editquery' => '[Рэдагаваць запыт]',
	'smw_add_sortcondition' => '[Дадаць умовы сартаваньня]',
	'smw_ask_hidequery' => 'Схаваць запыт',
	'smw_ask_help' => 'Дапамога па стварэньні запытаў',
	'smw_ask_queryhead' => 'Запыт',
	'smw_ask_printhead' => 'Паказваць дадатковыя зьвесткі',
	'smw_ask_printdesc' => '(дадавайце адну назву ўласьцівасьці на радок)',
	'smw_ask_format_as' => 'Фарматаваць як:',
	'smw_ask_defaultformat' => 'па змоўчваньні',
	'smw_ask_otheroptions' => 'Іншыя ўстаноўкі',
	'smw_ask_show_embed' => 'Паказаць убудаваны код',
	'smw_ask_hide_embed' => 'Схаваць убудаваны код',
	'smw_ask_embed_instr' => 'Каб убудаваць гэты запыт у старонку, выкарыстоўвайце код пададзены ніжэй.',
	'searchbyproperty' => 'Шукаць па ўласьцівасьцях',
	'smw_sbv_docu' => 'Шукаць усе старонкі, якія ўтрымліваюць пададзеную ўласьцівасьць і значэньне.',
	'smw_sbv_novalue' => 'Увядзіце значэньне для ўласьцівасьці, ці паглядзіце ўсе значэньні ўласьцівасьцяў для «$1».',
	'smw_sbv_displayresult' => 'Сьпіс усіх старонак, якія ўтрымліваюць уласьцівасьць «$1» са значэньнем «$2»',
	'smw_sbv_displayresultfuzzy' => 'Сьпіс усіх старонак, якія ўтрымліваюць уласьцівасьць «$1» са значэньнем «$2».
З-за таго, што супала толькі некалькі вынікаў, паказаны старонкі, якія маюць блізкія значэньні.',
	'smw_sbv_property' => 'Уласьцівасьць:',
	'smw_sbv_value' => 'Значэньне:',
	'smw_sbv_submit' => 'Знайсьці',
	'browse' => 'Праглядзець {{GRAMMAR:родны|{{SITENAME}}}}',
	'smw_browselink' => 'Праглядзець уласьцівасьці',
	'smw_browse_article' => 'Увядзіце назву старонкі для пачатку прагляду.',
	'smw_browse_go' => 'Перайсьці',
	'smw_browse_show_incoming' => 'паказаць уласьцівасьці, якія спасылаюцца сюды',
	'smw_browse_hide_incoming' => 'схаваць уласьцівасьці, якія спасылаюцца сюды',
	'smw_browse_no_outgoing' => 'Гэта старонка ня мае ўласьцівасьцяў.',
	'smw_browse_no_incoming' => 'На гэту старонку не спасылаюцца ніякія ўласьцівасьці.',
	'smw_inverse_label_default' => '$1 з',
	'smw_inverse_label_property' => 'Паметка адваротнай уласьцівасьці',
	'pageproperty' => 'Старонка пошуку ўласьцівасьцяў',
	'smw_pp_docu' => 'Пошук усіх значэньняў уласьцівасьцяў на пададзенай старонцы.
Увядзіце назвы старонкі і ўласьцівасьці.',
	'smw_pp_from' => 'Са старонкі',
	'smw_pp_type' => 'Уласьцівасьць',
	'smw_pp_submit' => 'Шукаць',
	'smw_result_prev' => 'Папярэднія',
	'smw_result_next' => 'Наступныя',
	'smw_result_results' => 'Вынікі',
	'smw_result_noresults' => 'Вынікаў няма.',
	'smwadmin' => 'Адміністраваньне Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Устаноўкі сховішча Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Сховішча было настроенае пасьпяхова.',
	'smw_smwadmin_return' => 'Вярнуцца да $1',
	'smw_smwadmin_updatestarted' => 'Быў распачаты новы працэс абнаўленьня сэмантычных зьвестак.
Усе зьвесткі будуць пераўтвораны, ці зьменены калі гэта будзе неабходна.
Вы можаце назіраць за працэсам абнаўленьня на гэтай спэцыяльнай старонцы.',
	'smw_smwadmin_updatenotstarted' => 'Працэс абнаўленьня ўжо распачаты.
Не стварайце новы.',
	'smw_smwadmin_updatestopped' => 'Усе існуючыя працэсы абнаўленьня былі спынены.',
	'smw_smwadmin_updatenotstopped' => 'Каб спыніць працэс абнаўленьня, Вам неабходна паставіць паметку ў полі, каб пацьвердзіць Вашыя намеры.',
	'smw_smwadmin_docu' => 'Гэта спэцыяльная старонка дапамагае Вам пад час усталяваньня і абнаўленьня <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Не забывайце захоўваць каштоўныя зьвесткі перад выкананьнем адміністратарскіх функцыяў.',
	'smw_smwadmin_db' => 'Усталяваньне і абнаўленьне базы зьвестак',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki патрабуе некаторыя пашырэньні, каб база зьвестак MediaWiki змагла захоўваць сэмантычныя зьвесткі.
Наступная функцыя гарантуе, што Вашая база зьвестак усталяваная правільна.
Зьмены, зробленыя на гэтым этапе, не паўплываюць на астатнія базы зьвестак MediaWiki, і могуць быць лёгка адмененыя па жаданьні.
Гэта ўсталёвачная функцыя можа быць выкананая некалькі разоў без аніякай шкоды, але для ўсталяваньня ці абнаўленьня дастаткова будзе аднаго разу.',
	'smw_smwadmin_permissionswarn' => 'Калі адбываюцца SQL-памылкі пад час выкананьня апэрацыі, то гэта азначае, што рахунак базы зьвестак, які выкарыстоўвае {{SITENAME}} (праверце Вашыя LocalSettings.php), магчыма ня мае адпаведных правоў.
Надайце рахунку дадатковыя правы на стварэньне і выдаленьне табліцаў, часова ўвядзіце рахунак адміністратара базы зьвестак у LocalSettings.php, ці карыстайцеся скрыптом падтрымкі <tt>SMW_setup.php</tt>, які можа выкарыстоўваць рахунак з AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Усталяваць ці абнавіць табліцы',
	'smw_smwadmin_announce' => 'Анансуйце {{GRAMMAR:вінавальны|{{SITENAME}}}}',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki мае сэрвіс для анансаваньня новых сэмантычных вікі-сайтаў.
Яна выкарыстоўваецца для падтрымкі сьпісу публічных сайтаў, якія выкарыстоўваюць Semantic MediaWiki, у асноўным для таго, каб дапамагчы <a href="http://semantic-mediawiki.org/wiki/SMW_Project">праекту Semantic MediaWiki</a> атрымаць агляд тыповых выкарыстаньняў Semantic MediaWiki.
Глядзіце хатнюю старонку Semantic MediaWiki для <a href="http://semantic-mediawiki.org/wiki/Registry">атрыманьня дадатковай інфармацыі пра гэты сэрвіс</a>.',
	'smw_smwadmin_announcebutton' => 'Націсьніце наступную кнопку, каб дадаць спасылку на {{GRAMMAR:вінавальны|{{SITENAME}}}} да гэтага сэрвісу.
Сэрвіс не рэгіструе вікі, якія ня маюць публічнага доступу, таму што ён захоўвае толькі агульнадаступную інфармацыю.',
	'smw_smwadmin_datarefresh' => 'Выпраўленьне і абнаўленьне зьвестак',
	'smw_smwadmin_datarefreshdocu' => 'Існуе магчымасьць аднаўленьня ўсіх зьвестак Semantic MediaWiki на аснове цяперашняга зьместу {{GRAMMAR:родны|{{SITENAME}}}}.
Гэта можа быць карысным для аднаўленьня парушаных зьвестак ці абнаўленьня зьвестак, калі ўнутраны фармат зьмяняецца пры абнаўленьні праграмнага забесьпячэньня.
Абнаўленьне будзе выконвацца старонка за старонкай і можа заняць пэўны час.
Ніжэй паказваецца інфармацыя, ці адбываецца абнаўленьне, якая дазваляе Вам пачынаць ці спыняць абнаўленьне (за выключэньнем выпадкаў, калі гэта магчымасьць забароненая адміністратарам сайта).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Ідзе працэс абнаўленьня.</strong>
Гэта нармальна, што працэс абнаўленьня запавольваецца, і зьвесткі абнаўляюцца невялікімі кавалкамі.
Каб скончыць абнаўленьне хутчэй, Вы можаце скарыстацца скрыптом падтрымкі МэдыяВікі <tt>runJobs.php</tt> (карыстайцеся ўстаноўкай <tt>--maxjobs 1000</tt>, каб абмежаваць колькасьць выкананых абнаўленьняў у адным пакеце).
Прыкладны час сканчэньня цяперашняга абнаўленьня:',
	'smw_smwadmin_datarefreshbutton' => 'Пачаць абнаўленьне зьвестак',
	'smw_smwadmin_datarefreshstop' => 'Спыніць гэта абнаўленьне',
	'smw_smwadmin_datarefreshstopconfirm' => 'Так, я ўпэўнены.',
	'smw_smwadmin_support' => 'Падтрымка',
	'smw_smwadmin_supportdocu' => 'Вы можаце знайсьці дапамогу ў розных крыніцах у выпадку праблемаў:',
	'smw_smwadmin_installfile' => 'Калі ўзьнікнуць выпадковыя праблемы з Вашым усталяваньнем, пачніце з рэкамэндацыяў у <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">файле INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Поўная дакумэнтацыя Semantic MediaWiki знаходзіцца на <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Можна паведамляць пра памылкі ў <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Калі Вы маеце пытаньні ці прапановы, далучайцеся да дыскусіі на <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">форуме карыстальнікаў Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Структура зьвестак',
	'smw_adminlinks_displayingdata' => 'Паказ зьвестак',
	'smw_adminlinks_inlinequerieshelp' => 'Дапамога па ўбудаваным запытам',
);

/** Bulgarian (Български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'smw_viewasrdf' => 'RDF емисия',
	'smw_factbox_head' => 'Факти за $1',
	'smw_printername_auto' => 'Автоматично',
	'smw_printername_template' => 'Шаблон',
	'smw_iq_disabled' => 'Съжаляваме. Семантичните заявки са изключени в това уики.',
	'smw_iq_nojs' => 'За преглед на този елемент е необходимо използването на браузър с включена поддръжка на Джаваскрипт.',
	'smw_iq_altresults' => 'Директно разглеждане на списъка с резултатите.',
	'smw_unknown_importns' => 'Функциите за внасяне са недостъпни за именно пространство „$1“.',
	'smw_nonright_importtype' => '$1 може да се използва само за страници от именното пространство „$2“.',
	'smw_wrong_importtype' => '$1 не може да се използва за страници от именното пространство „$2“.',
	'smw_no_importelement' => 'Елементът „$1“ не е наличен за внасяне.',
	'smw_notitle' => '„$1“ не може да се използва като име на страница в това уики.',
	'smw_wrong_namespace' => 'Тук са позволени само страници от именното пространство „$1“.',
	'smw_emptystring' => 'Празните низове са неприемливи.',
	'smw_nofloat' => '„$1“ не е число.',
	'smw_badtitle' => 'Съжаляваме, но „$1“ не е валидно заглавие на страница.',
	'smw_rss_description' => '$1 RSS емисия',
	'exportrdf' => 'Изнасяне на страниците към RDF',
	'smw_exportrdf_docu' => 'Тази страница позволява да се извлечат данните опт страница в RDF формат.
За изнасяне на страници, въведете заглавията в текстовата кутия по-долу (по едно заглавие на ред).',
	'smw_exportrdf_recursive' => 'Рекурсивно изнасяне на всички свързани страници.
Обърнете внимание, че резултатът може да е огромен!',
	'smw_exportrdf_lastdate' => 'Без изнасяне на страници, които не са променяни от посоченото време.',
	'smw_exportrdf_submit' => 'Изнасяне',
	'smw_property_template' => '$1 от типа $2 ($3)',
	'smw_unusedproperty_template' => '$1 от типа $2',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|използване|използвания}})',
	'smw_purge' => 'Опресняване',
	'types' => 'Типове',
	'semanticstatistics' => 'Семантични статистики',
	'ask' => 'Семантично търсене',
	'smw_ask_sortby' => 'Сортиране по колона (незадължително)',
	'smw_ask_ascorder' => 'Възходящ',
	'smw_ask_descorder' => 'Низходящ',
	'smw_ask_editquery' => '[Редактиране на заявката]',
	'smw_add_sortcondition' => '[Добавяне на условие за сортиране]',
	'smw_ask_hidequery' => 'Скриване на заявката',
	'smw_ask_queryhead' => 'Заявка',
	'smw_sbv_value' => 'Стойност:',
	'smw_browse_go' => 'Отваряне',
	'smw_pp_from' => 'От страница',
	'smw_result_prev' => 'Предишни',
	'smw_result_next' => 'Следващи',
	'smw_result_results' => 'Резултати',
	'smw_result_noresults' => 'Съжаляваме, няма резултати.',
	'smwadmin' => 'Администраторски функции за Semantic MediaWiki',
);

/** Breton (Brezhoneg)
 * @author Fohanno
 * @author Fulup
 * @author Y-M D
 */
$messages['br'] = array(
	'smw_edithelp' => 'Skoazell a ra evit skrivañ darempredoù ha perzhioù',
	'smw_viewasrdf' => 'Gwelet evel RDF',
	'smw_finallistconjunct' => ', ha',
	'smw_factbox_head' => 'Fedoù diwar-benn $1',
	'smw_isspecprop' => 'Ar perzh-mañ zo ur perzh arbennik er wiki-mañ',
	'smw_isaliastype' => 'Ar seurt-mañ zo un alias eus ar seurt roadennoù « $1 ».',
	'smw_concept_description' => 'Deskrivadur eus ar meizad « $1 »',
	'smw_baduri' => 'An URLoù er stumm « $1 » n"int ket aotreet.',
	'smw_printername_auto' => 'Emgefre',
	'smw_printername_count' => "Kontañ an disoc'hoù",
	'smw_printername_csv' => 'ezporzhiadur CSV',
	'smw_printername_debug' => 'Reked dizreinañ (evit an arbennigourien)',
	'smw_printername_embedded' => "Danvez ar pajennoù ensoc'het",
	'smw_printername_json' => 'ezporzhiadur JSON',
	'smw_printername_list' => 'Roll',
	'smw_printername_ol' => 'Niverenniñ',
	'smw_printername_ul' => 'Munudoù',
	'smw_printername_rss' => 'ezporzhiañ RSS',
	'smw_printername_table' => 'Taolenn',
	'smw_printername_broadtable' => 'Taolenn ledan',
	'smw_printername_template' => 'Patrom',
	'smw_paramdesc_limit' => "An niver uhelañ a zisoc'hoù da adkas",
	'smw_paramdesc_headers' => 'Diskwel an talbennoù / anvioù ar perzhioù',
	'smw_paramdesc_mainlabel' => 'Al label hag a ro anv ar bajenn degemer',
	'smw_paramdesc_link' => 'Diskouez an talvoudoù evel liammoù',
	'smw_paramdesc_default' => "An destenn da ziskwel ma n'eus disoc'h ebet d'ar reked",
	'smw_paramdesc_searchlabel' => "An destenn war al liamm davet an disoc'hoù",
	'smw_paramdesc_sep' => 'An disranner evit an talvoudoù',
	'smw_paramdesc_columns' => "An niver a golonennoù evit pere ez eus da ziskouez an disoc'hoù ($1 dre ziouer)",
	'smw_paramdesc_embedonly' => 'Na ziskwel talbenn ebet',
	'smw_paramdesc_rsstitle' => 'Testenn da implijout evel titl ar gwazhioù',
	'smw_iq_disabled' => 'Diweredekaet eo bet ar goulennoù semantek evit ar wiki-mañ.',
	'smw_iq_moreresults' => "... disoc'hoù all",
	'smw_iq_nojs' => 'Implijout ur merdeer a ra gant JavaScript evit gwelet an elfenn-mañ.',
	'smw_iq_altresults' => "Furchal ar roll disoc'hoù war-eeun.",
	'smw_nonright_importtype' => 'Ne c\'hell $1 bezañ implijet hepken evit pajennoù an esaouenn anv "$2".',
	'smw_wrong_importtype' => 'Ne c\'hell ket $1 bezañ implijet evit pajennoù en esaouenn anv "$2".',
	'smw_no_importelement' => "An elfenn « $1 » ne c'hall ket bezañ ezporzhiet.",
	'smw_parseerror' => "An talvoud merket n'eo ket bet komprenet.",
	'smw_notitle' => "« $1 » ne c'hall ket bezañ implijet da anv pajenn er wiki-mañ.",
	'smw_wrong_namespace' => 'N\'eo aotreet amañ nemet ar pajennoù eus an esaouenn "$1".',
	'smw_manytypes' => 'Ouzhpenn ur seurt zo bet termenet evit ar perzh.',
	'smw_emptystring' => 'Ne zegemerer ket an neudennadoù goullo.',
	'smw_maxstring' => 'Re hir eo an neudennad $1.',
	'smw_notinenum' => "« $1 » n'emañ ket er roll talvoudoù posupl ($2) evit ar perzh-mañ.",
	'smw_true_words' => 'gwir,g,ya,true',
	'smw_false_words' => 'gaou,g,nann,n,false',
	'smw_nofloat' => '"$1" n\'eo ket un niver.',
	'smw_infinite' => "Niveroù ken bras ha « $1 » n'int ket skoret.",
	'smw_novalues' => "N'eus bet diferet talvoudoù ebet.",
	'smw_unsupportedprefix' => "Ar rakgerioù evit an niveroù ( « $1 » ) n'int ket skoret.",
	'smw_nodatetime' => 'An deiziad « $1 » n’eo ket bet komprenet.',
	'smw_toomanyclosing' => 'Re a reveziadennoù eus « $1 » zo er reked.',
	'smw_noclosingbrackets' => 'Implijout \'zo eus "<nowiki>[[</nowiki>" en ho reked n\'int ket bet serret gant ar "]]" a glot.',
	'smw_misplacedsymbol' => "Implijet eo bet an arouezenn « $1 » en ul lec'h ma n'eo ket talvoudus.",
	'smw_unexpectedpart' => "Al lodenn « $1 » eus ar reked n'eo ket bet komprenet.
Dic'hortoz e c'hall bezañ an disoc'hoù.",
	'smw_valuesubquery' => "Isreked n'eo ket skoret evit talvoudoù ar perzh « $1 ».",
	'smw_overprintoutlimit' => "Re a c'houlennoù furmadiñ zo er reked.",
	'smw_badprintout' => 'Lod urzhiadoù moullañ er reked a oa stummet fall.',
	'smw_badtitle' => "« $1 » n'eo ket un titl pajenn reizh.",
	'smw_badqueryatom' => "Al lodennoù « <nowiki>[[…]]</nowiki> » eus ar reked n'int ket bet komprenet.",
	'smw_propvalueproblem' => "Talvoud ar perzh « $1 » n'eo ket bet komprenet.",
	'smw_type_header' => 'Perzhioù eus ar seurt « $1 »',
	'smw_typearticlecount' => 'Diskouez $1 {{PLURAL:$1|perzh|perzh}} a implij ar seurt-mañ.',
	'smw_attribute_header' => 'Pajennoù a implij ar perzh « $1 »',
	'smw_attributearticlecount' => 'Afficher {{PLURAL:$1|ar bajenn|an $1 pajenn}} a implij ar perzh-mañ.',
	'smw_subproperty_header' => 'Isperzhioù',
	'smw_subpropertyarticlecount' => 'Ar perzh he deus an {{PLURAL:$1||$1 }}is-perzh da-heul :',
	'smw_concept_header' => 'Pajennoù ar meizad « $1 »',
	'smw_conceptarticlecount' => 'Diskouez {{PLURAL:$1|ar bajenn|ar $1 pajenn}} diazezet war ar meizad-se',
	'exportrdf' => 'Ezporzhiañ pajennoù en RDF',
	'smw_exportrdf_lastdate' => "Arabat ezporzhiañ ar pajennoù n'int ket bet kemmet abaoe ar c'houlz merket.",
	'smw_exportrdf_submit' => 'Ezporzhiañ',
	'properties' => 'Perzhioù',
	'smw_properties_docu' => 'Ar perzhioù-mañ zo implijet er wiki.',
	'smw_property_template' => '$1 eus ar seurt $2 ($3)',
	'smw_propertylackspage' => 'An holl berzhioù a rank bezañ deskrivet gant ur bajenn !',
	'smw_propertyhardlyused' => 'Ar perzh-mañ a vez implijet a-boan er wiki !',
	'unusedproperties' => 'Perzhioù dizimplij',
	'smw_unusedproperties_docu' => 'Ar perzhioù-mañ zo anezho daoust ma ne vezont implijet gant pajenn all ebet.',
	'smw_unusedproperty_template' => '$1 eus ar seurt $2',
	'wantedproperties' => "Perzhioù c'hoantaet",
	'smw_wantedproperties_docu' => "Ar perzhioù-mañ zo implijet er wiki met n'eus pajenn ebet c'hoazh evit o deskrivañ.",
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|implij|implij}})',
	'tooltip-purge' => 'Klikit amañ da freskaat an holl rekedoù hag an holl batromoù war ar bajenn-mañ',
	'smw_purge' => 'Freskaat',
	'types' => 'Seurtoù roadennoù',
	'smw_typeunits' => 'Unanennoù muzuliañ eus ar seurt « $1 » : $2',
	'semanticstatistics' => 'Stadegoù semantek',
	'uriresolver' => 'Diskoulmer URI',
	'ask' => 'Klask semantek',
	'smw_ask_sortby' => 'Urzhiañ dre vannoù (diret)',
	'smw_ask_ascorder' => 'War gresk',
	'smw_ask_descorder' => 'War zigresk',
	'smw_ask_submit' => "Kavout disoc'hoù",
	'smw_ask_editquery' => '[Kemmañ ar reked]',
	'smw_add_sortcondition' => '[ouzhpennañ un diviz urzhiañ]',
	'smw_ask_hidequery' => 'Kuzhat ar reked',
	'smw_ask_help' => 'Skoazell evit ar rekedoù',
	'smw_ask_queryhead' => 'Reked',
	'smw_ask_printhead' => 'Roadennoù ouzhpenn da ziskwel',
	'smw_ask_printdesc' => '(ouzhpennañ un anv perzh dre linenn)',
	'smw_ask_format_as' => 'Furmadiñ evel :',
	'smw_ask_defaultformat' => 'dre ziouer',
	'smw_ask_otheroptions' => 'Dibarzhioù all',
	'smw_ask_show_embed' => "Diskouez ar c'hod enframmet",
	'smw_ask_hide_embed' => "Kuzhat ar c'hod enframmet",
	'smw_ask_embed_instr' => "Evit enklozañ ar reked-mañ enlinenn e-barzh ur bajenn wiki, implijit ar c'hod amañ dindan.",
	'searchbyproperty' => 'Klask dre berzh',
	'smw_sbv_novalue' => 'Ebarzhiñ un talvoud evit ar perzh, pe gwelet holl dalvoudoù ar perzhioù evit « $1 ».',
	'smw_sbv_displayresult' => 'Roll eus an holl bajennoù gant ar perzh « $1 » gant an talvoud « $2 ».',
	'smw_sbv_property' => 'Perzh :',
	'smw_sbv_value' => 'Talvoud :',
	'smw_sbv_submit' => "Kavout disoc'hoù",
	'browse' => 'Furchal ar wiki',
	'smw_browselink' => 'Furchal ar perzhioù',
	'smw_browse_article' => 'Ebarzhit anv ar bajenn da gregiñ da furchal ganti.',
	'smw_browse_go' => 'Mont',
	'smw_browse_show_incoming' => "diskouez ar perc'henniezhioù a gas betek amañ",
	'smw_browse_hide_incoming' => "kuzhat ar perc'henniezhioù a gas betek amañ",
	'smw_browse_no_outgoing' => "Ar bajenn-mañ n'he deus perzh ebet.",
	'smw_browse_no_incoming' => "Perc'henniezh ebet a gas betek ar bajenn-mañ.",
	'smw_inverse_label_default' => '$1 eus',
	'smw_inverse_label_property' => 'Label ar perzh eilpennet',
	'pageproperty' => 'Klask e perzhioù ar bajenn',
	'smw_pp_from' => 'Adalek ar bajenn',
	'smw_pp_type' => 'Perzh',
	'smw_pp_submit' => "Kavout disoc'hoù",
	'smw_result_prev' => 'Kent',
	'smw_result_next' => "War-lerc'h",
	'smw_result_results' => "Disoc'hoù",
	'smw_result_noresults' => "Disoc'h ebet.",
	'smwadmin' => "Arc'hwelioù merañ evit Semantic MediaWiki",
	'smw_smwadmin_setupsuccess' => "Staliet-mat eo ar c'heflusker stokañ.",
	'smw_smwadmin_return' => 'Distreiñ da $1',
	'smw_smwadmin_updatestopped' => 'Ehanet eo bet an holl argerzhoù hizivaat.',
	'smw_smwadmin_db' => 'Staliañ ha lakaat an diaz roadennoù a-live',
	'smw_smwadmin_dbbutton' => 'Deraouekaat pe lakaat taolennoù a-live',
	'smw_smwadmin_announce' => 'Brudañ ho wiki',
	'smw_smwadmin_datarefresh' => 'Dresañ ha lakaat ar roadennoù a-live',
	'smw_smwadmin_datarefreshbutton' => 'Kregiñ da hizivaat ar roadennoù',
	'smw_smwadmin_datarefreshstop' => 'Paouez gant an hizivadenn-mañ',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ya, sur on.',
	'smw_smwadmin_support' => 'Kaout skoazell',
	'smw_smwadmin_supportdocu' => "Dafar a bep seurt a c'hallfe ho skoazellañ ma vez kudennoù :",
	'smw_smwadmin_mediazilla' => 'An drein a c\'hall bezañ danevellet da <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_adminlinks_datastructure' => 'Framm ar roadennoù',
	'smw_adminlinks_displayingdata' => 'Diskwel roadennoù',
	'smw_adminlinks_inlinequerieshelp' => 'Skoazell evit ar rekedoù enlinenn',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'smw_edithelp' => 'Pomoć pri uređivanju svojstava',
	'smw_viewasrdf' => 'RDF fid',
	'smw_finallistconjunct' => ' i',
	'smw_factbox_head' => 'Činjenice o $1',
	'smw_isspecprop' => 'Ovo svojstvo je posebna osobina na ovoj wiki.',
	'smw_isknowntype' => 'Ovaj tip je u sklopu standardnih tipova podataka na ovoj wiki.',
	'smw_isaliastype' => 'Ovaj tip je nadimak za tip podataka "$1".',
	'smw_concept_description' => 'Opis koncepta "$1"',
	'smw_printername_auto' => 'Automatsko',
	'smw_printername_count' => 'Rezultati brojanja',
	'smw_printername_csv' => 'CSV izvoz',
	'smw_printername_json' => 'JSON izvoz',
	'smw_printername_list' => 'Spisak',
	'smw_printername_rss' => 'RSS izvoz',
	'smw_printername_table' => 'Tabela',
	'smw_printername_template' => 'Šablon',
	'smw_paramdesc_link' => 'Prikaži vrijednosti kao linkove',
	'smw_paramdesc_embedonly' => 'Ne prikazuj zaglavlja',
	'smw_iq_disabled' => 'Semantički upiti su onemogućeni na ovoj wiki.',
	'smw_iq_moreresults' => '...ostali rezultati',
	'smw_iq_altresults' => 'Pregledaj spisak rezultata direktno.',
	'smw_unknown_importns' => 'Funkcije uvoza nisu dostupne za imenski prostor "$1".',
	'smw_no_importelement' => 'Element "$1" nije dostupan za uvoz.',
	'smw_parseerror' => 'Navedena vrijednost nije razumljiva.',
	'smw_emptystring' => 'Prazni izrazi nisu prihvatljivi.',
	'smw_maxstring' => 'Prikazivanje izraza $1 je predugačko.',
	'smw_nofloat' => '"$1" nije broj.',
	'smw_nodatetime' => 'Datum "$1" nije razumljiv.',
	'smw_badtitle' => '"$1" nije validan naslov stranice.',
	'smw_exportrdf_submit' => 'Izvezi',
	'properties' => 'Svojstva',
	'unusedproperties' => 'Neiskorištene osobine',
	'smw_purge' => 'Osvježi',
	'types' => 'Tipovi',
	'semanticstatistics' => 'Statistike semantike',
	'smw_ask_hidequery' => 'Sakrij upit',
	'smw_sbv_property' => 'Svojstvo:',
	'smw_sbv_value' => 'Vrijednost:',
	'smw_browselink' => 'Pregled svojstava',
	'smw_browse_go' => 'Idi',
	'smw_inverse_label_default' => '$1 od',
	'smw_result_prev' => 'Prethodno',
	'smw_result_next' => 'Slijedeće',
	'smw_result_noresults' => 'Nema rezultata.',
	'smw_smwadmin_return' => 'Natrag na $1',
	'smw_smwadmin_datarefreshstopconfirm' => 'Da, siguran sam.',
);

/** Catalan (Català)
 * @author Dvdgmz
 * @author Loupeter
 * @author SMP
 * @author Solde
 * @author Toniher
 */
$messages['ca'] = array(
	'smw-desc' => 'Fent el vostre wiki més accessible - per a les màquines «i també» per als humans ([http://semantic-mediawiki.org/wiki/Help:User_manual documentació en línia])',
	'smw_edithelp' => "Ajuda d'edició en propietats",
	'smw_viewasrdf' => 'Canal RDF',
	'smw_finallistconjunct' => ', i',
	'smw_factbox_head' => 'Dades sobre $1',
	'smw_isspecprop' => 'Aquesta propietat és una propietat especial en aquest wiki',
	'smw_isknowntype' => "Aquest tipus està entre els els tipus de dades estàndards d'aquest wiki",
	'smw_isaliastype' => 'Aquest tipus és un àlies per al tipus de dada «$1».',
	'smw_isnotype' => "Aquest tipus «$1» no és un tipus de dada estàndard en el wiki, i tampoc no s'ha donat una definició d'usuari.",
	'smw_concept_description' => 'Descripció del concepte «$1».',
	'smw_no_concept_namespace' => "Els conceptes només poden ser definits en pàgines dins l'espai de noms (namespace) Concept:",
	'smw_multiple_concepts' => 'Cada pàgina de concepte només pot tenir una definició de concepte.',
	'smw_concept_cache_miss' => "El concepte «$1» no pot ser utilitzat per ara, atès que la configuració del wiki s'ha de computar fora de línia.
Si el problema persisteix passat cert temps, demaneu a l'administrador del vostre wiki que posi disponible aquest concepte.",
	'smw_noinvannot' => 'No es poden assignar valors a propietats inverses.',
	'smw_baduri' => 'Les URI del formulari «$1» no són permeses.',
	'smw_printername_auto' => 'Automàtic',
	'smw_printername_count' => 'Resultats del recompte',
	'smw_printername_csv' => 'exportació a CSV',
	'smw_printername_debug' => 'Consulta de depuració (per a experts)',
	'smw_printername_embedded' => 'Continguts de pàgina incrustada',
	'smw_printername_json' => 'exportació a JSON',
	'smw_printername_list' => 'Llista',
	'smw_printername_ol' => 'Enumeració',
	'smw_printername_ul' => 'Itemització',
	'smw_printername_rss' => 'exportació a RSS',
	'smw_printername_table' => 'Taula',
	'smw_printername_broadtable' => 'Taula ampla',
	'smw_printername_template' => 'Plantilla',
	'smw_paramdesc_limit' => 'El nombre màxim de resultats a retornar',
	'smw_paramdesc_headers' => 'Mostra les capçaleres / noms de les propietats',
	'smw_paramdesc_mainlabel' => "L'etiqueta que es donarà al nom de la pàgina principal",
	'smw_paramdesc_link' => 'Mostra els valors com a enllaços',
	'smw_paramdesc_intro' => "El text que apareixerà abans que el resultat de la consulta, si n'hi hagués",
	'smw_paramdesc_outro' => "El text que apareixerà després que els resultats de la consulta, si n'hi hagués",
	'smw_paramdesc_default' => 'El text que es mostrarà si no hi ha resultats de la consulta',
	'smw_paramdesc_searchlabel' => "El text a l'enllaç als resultts",
	'smw_paramdesc_sep' => 'El separador entre valors',
	'smw_paramdesc_template' => "El nom d'una plantilla amb la qual mostrar els llistats",
	'smw_paramdesc_columns' => 'El nombre de columnes amb les quals mostrar els resultats (per defecte és $1)',
	'smw_paramdesc_embedformat' => "L'etiqueta HTML que s'utilitza per a definir les capçaleres",
	'smw_paramdesc_embedonly' => 'No mostris capçaleres',
	'smw_paramdesc_rsstitle' => "El text que s'utilitzarà com a títol del canal",
	'smw_paramdesc_rssdescription' => "El text que s'utilitzarà com a descripció del canal",
	'smw_iq_disabled' => 'Les consultes semàntiques estan inhabilitades en aquest wiki.',
	'smw_iq_moreresults' => '... més resultats',
	'smw_iq_nojs' => 'Habilita JavaScript al teu navegador per veure aquest element.',
	'smw_iq_altresults' => 'Explora directament la llista de resultats.',
	'smw_unknown_importns' => "Les funcions d'importació no estan disponibles per a l'espai de noms «$1».",
	'smw_nonright_importtype' => '$1 només es pot utilitzar per pàgines en l\'espai de noms "$2".',
	'smw_wrong_importtype' => "$1 no es pot fer servir per a pàgines a l'espai de noms «$2».",
	'smw_no_importelement' => "L'element «$1» no està disponible per ser importat.",
	'smw_parseerror' => "El valor donat no s'ha entès.",
	'smw_notitle' => '"$1" no es pot fer servir com a nom de pàgina en aquest wiki.',
	'smw_wrong_namespace' => 'Aquí només es poden fer servir pàgines en l\'espai de noms "$1".',
	'smw_unknowntype' => "S'ha definit un tipus «$1» no permès per la propietat.",
	'smw_manytypes' => "S'ha definit més d'un tipus per la propietat.",
	'smw_emptystring' => "No s'accepten cadenes buides.",
	'smw_maxstring' => 'La representació de cadena $1 és massa llarga',
	'smw_notinenum' => "«$1» no està a la llista de valors possibles ($2) d'aquesta propietat.",
	'smw_noboolean' => '«$1» no es pot reconèixer com un valor booleà (cert/fals).',
	'smw_true_words' => 'verdader,vertader,veritat,cert,true,t,sí,s,yes,y',
	'smw_false_words' => 'fals,f,no,n,false',
	'smw_nofloat' => '"$1" no és un nombre.',
	'smw_infinite' => 'No es permeten nombres tan llargs com «$1».',
	'smw_infinite_unit' => 'La conversió a la unitat «$1» ha donat un nombre massa llarg.',
	'smw_novalues' => "No s'ha especificat cap valor.",
	'smw_unsupportedprefix' => 'No es permet prefixos («$1») en els nombres.',
	'smw_unsupportedunit' => 'La conversió d\'unitats per la unitat "$1" no està suportada.',
	'smw_nodatetime' => "No s'ha entès la data «$1».",
	'smw_toomanyclosing' => 'Sembla ser que «$1» apareix massa vegades a la consulta.',
	'smw_noclosingbrackets' => 'Algun ús de "<nowiki>[[</nowiki>" en la vostra consulta no es clou amb els "]]" corresponents.',
	'smw_misplacedsymbol' => 'El símbol «$1» es fa servir en un lloc on no és útil.',
	'smw_unexpectedpart' => "La part «$1» de la consulta no s'ha entès.
Els resultats podrien no ser els esperats.",
	'smw_emptysubquery' => 'Alguna subconsulta no té una condició vàlida.',
	'smw_misplacedsubquery' => 'Alguna subconsulta es fa servir en un lloc on les subconsultes no són permeses.',
	'smw_valuesubquery' => 'Subconsultes no suportades per valors de la propietat "$1".',
	'smw_overprintoutlimit' => 'La consulta conté massa requeriments de sortida.',
	'smw_badprintout' => 'Alguna declaració de sortida en la consulta està mal expressada.',
	'smw_badtitle' => '«$1» no és un títol de pàgina vàlid.',
	'smw_badqueryatom' => "Una part «<nowiki>[[…]]</nowiki>» de la consulta no s'ha pogut entendre.",
	'smw_propvalueproblem' => "El valor de la propietat «$1» no s'ha pogut entendre.",
	'smw_noqueryfeature' => "Algun aspecte d'aquesta consulta no està suportat en aquest wiki i part de la consulta no s'ha tingut en compte ($1).",
	'smw_noconjunctions' => "Les conjuncions en consultes no són suportades en aquest wiki i part de la consulta no s'ha tingut en compte ($1)",
	'smw_nodisjunctions' => "Les disjuncions en consultes no són suportades en aquest wiki i part de la consulta no s'ha tingut en compte ($1).",
	'smw_querytoolarge' => 'Les condicions de consulta següents podrien no ser considerades degut a les restriccions de mida o profunditat per consultes en el wiki: $1.',
	'smw_devel_warning' => 'Aquesta característica actualment està en desenvolupament i podria no ser plenament funcional.
Feu una còpia de seguretat de les vostres dades abans de fer-la servir.',
	'smw_notemplategiven' => 'Per fer que això funcioni, dóna un valor al paràmetre "template" (plantilla) per al format d\'aquesta consulta.',
	'smw_type_header' => 'Propietats de tipus "$1"',
	'smw_typearticlecount' => 'Es {{PLURAL:$1|mostra|mostren}} $1 {{PLURAL:$1|propietat que fa servir|propietats que fan servir}} aquesta propietat.',
	'smw_attribute_header' => 'Pàgines que fan servir la propietat "$1"',
	'smw_attributearticlecount' => 'Es {{PLURAL:$1|mostra|mostren}} $1 {{PLURAL:$1|pàgina que fa servir|pàgines que fan servir}} aquesta propietat.',
	'smw_subproperty_header' => 'Subpropietats',
	'smw_subpropertyarticlecount' => 'Aquesta propietat té {{PLURAL:$1|la subpropietat següent|les $1 subpropietats següents}}:',
	'smw_concept_header' => 'Pàgines del concepte "$1"',
	'smw_conceptarticlecount' => 'Es {{PLURAL:$1|mostra|mostren}} $1 {{PLURAL:$1|pàgina|pàgines}} que pertanyen a aquest concepte.',
	'exportrdf' => 'Exporta les pàgines a RDF',
	'smw_exportrdf_docu' => "Aquesta pàgina permet obtenir dades en format RDF d'una pàgina del wiki.
Per exportar pàgines, entra els títols a la caixa de text següent, un títol per línia.",
	'smw_exportrdf_recursive' => 'Exporta recursivament totes les pàgines relacionades.
Tingueu en compte que el resultat pot ser molt gran!',
	'smw_exportrdf_backlinks' => 'També exporta totes les pàgines que es refereixen a les pàgines exportades.
Genera un RDF que es pot navegar.',
	'smw_exportrdf_lastdate' => "No exportis pàgines que no s'han canviat des del punt donat  en el temps.",
	'smw_exportrdf_submit' => 'Exporta',
	'properties' => 'Propietats',
	'smw_properties_docu' => "S'utilitzen les propietats següents al wiki.",
	'smw_property_template' => '$1 de tipus $2 ($3)',
	'smw_propertylackspage' => 'Cal descriure totes les propietats amb una pàgina!',
	'smw_propertylackstype' => "No s'ha especificat cap tipus per a la propietat (s'assumeix el tipus $1 per ara).",
	'smw_propertyhardlyused' => 'Propietats pràcticament no utilitzades al llarg del wiki!',
	'unusedproperties' => 'Propietats no utilitzades',
	'smw_unusedproperties_docu' => 'Les propietats següents existeixen, tot i que cap altra pàgina les fa servir.',
	'smw_unusedproperty_template' => '$1 del tipus $2',
	'wantedproperties' => 'Propietats per definir',
	'smw_wantedproperties_docu' => "Les propietats següents s'utilitzen en el wiki però encara no tenen cap pàgina per a descriure-les.",
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|ús|usos}})',
	'tooltip-purge' => 'Feu clic ací per a actualitzar totes les consultes i plantilles de la pàgina.',
	'smw_purge' => 'Refresca',
	'types' => 'Tipus',
	'smw_types_docu' => 'La següent és una llista de tots els tipus de dades que poden assignar-se a les propietats.
Cada tipus de dades té una pàgina on es pot proporcionar informació addicional.',
	'smw_typeunits' => 'Unitats de mesura del tipus «$1»: $2',
	'semanticstatistics' => 'Estadístiques semàntiques',
	'smw_semstats_text' => "Aquest wiki conté '''$1''' {{PLURAL:$1|valor|valors}} de propietat d'un total de '''$2''' [[Special:Properties|{{PLURAL:$2|propietat|diferents propietats}}]].
'''$3''' {{PLURAL:$3|propietat té|propietats tenen}} una pàgina pròpia, i se n'especifica el tipus de dades amb sagnat per a '''$4'''.
Algunes de les propietats existents podrien ser [[Special:UnusedProperties|propietats no utilitzades]].
Les propietats que encara no tenen cap pàgina es poden trobar a la [[Special:WantedProperties|llista de propietats per definir]].",
	'uriresolver' => "Resolutor d'URI",
	'smw_uri_doc' => 'El resolutor d\'URI implementa la <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">cerca de W3C TAG en httpRange-14</a>.
Té cura que els humans no es tornin en llocs web.',
	'ask' => 'Cerca semàntica',
	'smw_ask_sortby' => 'Ordena per columna (opcional)',
	'smw_ask_ascorder' => 'Ascendent',
	'smw_ask_descorder' => 'Descendent',
	'smw_ask_submit' => "Cerca'n resultats",
	'smw_ask_editquery' => '[Edita la consulta]',
	'smw_add_sortcondition' => "Afegeix una condició d'ordenació",
	'smw_ask_hidequery' => 'Amaga la consulta',
	'smw_ask_help' => "Consulta de l'ajuda",
	'smw_ask_queryhead' => 'Consulta',
	'smw_ask_printhead' => 'Dades addicionals per mostrar',
	'smw_ask_printdesc' => '(afegeix un nom de propietat per línia)',
	'smw_ask_format_as' => 'Formata com:',
	'smw_ask_defaultformat' => 'per defecte',
	'smw_ask_otheroptions' => 'Altres opcions',
	'smw_ask_show_embed' => 'Mostra el codi incrustat',
	'smw_ask_hide_embed' => 'Amaga el codi incrustat',
	'smw_ask_embed_instr' => 'Per a incrustar aquesta consulta en línia a una pàgina wiki utilitzeu el codi a continuació.',
	'searchbyproperty' => 'Cerca per propietat',
	'smw_sbv_docu' => 'Cerca totes les pàgines que tenen una propietat i valor donats.',
	'smw_sbv_novalue' => 'Introduïu un valor vàlid per a la propietat, o vegeu tots els valors de la propietat «$1».',
	'smw_sbv_displayresult' => 'Una llista de totes les pàgines que tenen la propietat «$1» amb el valor «$2»',
	'smw_sbv_displayresultfuzzy' => 'Una llista de totes les pàgines que tenen la propietat «$1» amb el valor «$2».
Com hi ha hagut només uns pocs resultats, també es mostren valors propers.',
	'smw_sbv_property' => 'Propietat:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => 'Troba els resultats',
	'browse' => 'Explora el wiki',
	'smw_browselink' => 'Explora les propietats',
	'smw_browse_article' => "Introduïu el nom de la pàgina des d'on començar a navegar.",
	'smw_browse_go' => 'Vés-hi',
	'smw_browse_show_incoming' => 'mostra les propietats que hi enllacen',
	'smw_browse_hide_incoming' => 'amaga les propietats que hi enllacen',
	'smw_browse_no_outgoing' => 'La pàgina no té cap propietat.',
	'smw_browse_no_incoming' => 'No enllaça cap propietat a la pàgina.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Etiqueta de propietat inversa',
	'pageproperty' => 'Cerca de les propietats de la pàgina',
	'smw_pp_docu' => "Cerqueu tots els valors d'una propietat en una pàgina donada.
Introduïu tant la pàgina com la propietat.",
	'smw_pp_from' => 'De la pàgina',
	'smw_pp_type' => 'Propietat',
	'smw_pp_submit' => 'Troba els resultats',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Següent',
	'smw_result_results' => 'Resultats',
	'smw_result_noresults' => 'Sense resultats.',
	'smwadmin' => "Funcions d'administració del Semantic MediaWiki",
	'smw_smwadmin_settingup' => "Configuració de l'emmagatzematge del Semantic MediaWiki",
	'smw_smwadmin_setupsuccess' => "El motor d'emmagatzematge s'ha configurat amb èxit.",
	'smw_smwadmin_return' => 'Torna a $1',
	'smw_smwadmin_updatestarted' => "S'ha iniciat un nou procés d'actualització per a refrescar les dades semàntiques.
Es reconstruiran totes les dades emmagatzemades o bé es repararan quan calgui.
Podeu seguir el progrés de l'actualització en aquesta pàgina especial.",
	'smw_smwadmin_updatenotstarted' => "Ja hi ha un procés d'actualització executant-se.
No es crearà cap altre.",
	'smw_smwadmin_updatestopped' => "S'han aturat tots els processos d'actualització existents.",
	'smw_smwadmin_updatenotstopped' => "Per a aturar l'execució del procés d'actualització, heu de marcar la casella per tal d'indicar que n'esteu plenament segur.",
	'smw_smwadmin_docu' => 'Aquesta pàgina especial us ajuda durant la instal·lació i l\'actualització del <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Recordeu fer una còpia de seguretat de les dades importants abans d\'executar cap funció administrativa.',
	'smw_smwadmin_db' => 'Instal·lació de la base de dades i actualització',
	'smw_smwadmin_dbdocu' => "El Semantic MediaWiki necessita algunes extensions a la base de dades del MediaWiki per a poder emmagatzemar les dades semàntiques.
La funció a continuació garanteix que la vostra base de dades està configurada correctament.
Els canvis fets en aquest pas no afecten la resta de la base de dades del MediaWiki, i poden desfer-se fàcilment si així es vol.
La funció de configuració pot executar-se moltes vegades sense que es faci cap mal, però només cal una vegada per a la instal·lació o l'actualització.",
	'smw_smwadmin_permissionswarn' => "Si l'operació falla amb errors SQL, l'usuari de la base de dades que utilitza el vostre wiki (comproveu el LocalSettings.php) probablement no té suficients permisos.
Podeu atorgar l'usuari permisos addicionals per a crear o suprimir taules, introduïu temporalment les dades d'inici de l'administrador (root) de la base de dades al LocalSettings.php, o bé feu servir l'script de manteniment <tt>SMW_setup.php</tt>, que pot utilitzar les credencials de l'AdminSettings.php.",
	'smw_smwadmin_dbbutton' => 'Inicialitza o actualitza les taules',
	'smw_smwadmin_announce' => 'Feu conèixer el vostre wiki',
	'smw_smwadmin_announcedocu' => 'El Semantic MediaWiki té un servei web per a anunciar nous llocs wiki semàntics.
S\'utilitza per a mantenir una llista de llocs públics que utilitzen el Semantic MediaWiki, majoritàriament per a ajudar el <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projecte Semantic MediaWiki</a> a tenir una visió dels usos típics del Semantic MediaWiki.
Consulteu la pàgina inicial del Semantic MediaWiki per a <a href="http://semantic-mediawiki.org/wiki/Registry">obtenir més informació del servei</a>.',
	'smw_smwadmin_announcebutton' => "Premeu el botó següent per a trametre l'URL del vostre wiki al servei.
El servei no registrarà wikis que no són accessibles públicament, i només emmagatzemarà informació que és accessible de forma pública.",
	'smw_smwadmin_datarefresh' => 'Reparació de les dades i actualització',
	'smw_smwadmin_datarefreshdocu' => "És possible restaurar totes les dades del Semantic MediaWiki a partir dels continguts actuals del wiki.
Això pot ser útil per a reparar dades inconsistents o refrescar les dades si el format intern ha canviat per alguna actualització de programari.
L'actualització s'executa pàgina per pàgina i no es completarà immediatament.
A continuació és mostra si l'actualització és en curs i us permet iniciar o aturar les actualitzacions (a menys que aquesta característica estigui inhabilitada per l'administrador del lloc).",
	'smw_smwadmin_datarefreshprogress' => "<strong>Ja hi ha una actualització en curs.</strong>
És normal que l'actualització progressi només lentament perquè només refresca les dades en trossos petits cada vegada que l'usuari accedeix al wiki.
Per a finalitzar l'actualització més ràpidament, podeu cridar l'script de manteniment del MediaWiki <tt>runJobs.php</tt> (empreu l'opció <tt>--maxjobs 1000</tt> per a restringir el nombre d'actualitzacions en un lot).
Progrés estimat de l'actualització actual:",
	'smw_smwadmin_datarefreshbutton' => "Inicia l'actualització de dades",
	'smw_smwadmin_datarefreshstop' => "Atura l'actualització",
	'smw_smwadmin_datarefreshstopconfirm' => "Sí, n'estic segur.",
	'smw_smwadmin_support' => 'Com obtenir assistència',
	'smw_smwadmin_supportdocu' => 'Diferents recursos poden ajudar-vos en cas de problemes:',
	'smw_smwadmin_installfile' => 'Si us trobeu amb problemes amb la vostra instal·lació, comenceu comprovant les instruccions del <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">fitxer INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Podeu trobar la documentació d\'usuari completa del Semantic MediaWiki a <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Es poden enviar informes d\'error al <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Si teniu més preguntes o suggeriments, uniu-vos a la discussió al <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">fòrum d\'usuaris del Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Estructura de dades',
	'smw_adminlinks_displayingdata' => 'Visualització de les dades',
	'smw_adminlinks_inlinequerieshelp' => 'Ajuda de les consultes en línia',
);

/** Chamorro (Chamoru)
 * @author Jatrobat
 */
$messages['ch'] = array(
	'smw_browse_go' => 'Hånao',
);

/** Czech (Česky)
 * @author Kjbenes
 * @author Matěj Grabovský
 * @author Mormegil
 */
$messages['cs'] = array(
	'smw_edithelp' => 'Nápověda při upravování vztahů a vlastností',
	'smw_viewasrdf' => 'RDF kanál',
	'smw_finallistconjunct' => ' a',
	'smw_factbox_head' => 'Skutečnosti o $1 &mdash; kliknutím na <span class="smwsearchicon">+</span> vyhledáte podobné stránky.',
	'smw_isspecprop' => 'Tato vlastnost je speciální vlastnost na této wiki.',
	'smw_isknowntype' => 'Tento typ patří meti standardní datové typy na této wiki.',
	'smw_isaliastype' => 'Tento typ je alias datového typu „$1“.',
	'smw_isnotype' => 'Tento typ „$1“ není standardní datový typ na této wiki a nebyl ani definován uživatelem.',
	'smw_concept_description' => 'Popis pojmu „$1”',
	'smw_no_concept_namespace' => 'Pojmy je možné definovat pouze na stránkách ve jmenném prostoru Concept:',
	'smw_multiple_concepts' => 'Každá stránka konceptu může mít jen jednu definici.',
	'smw_concept_cache_miss' => 'Koncept „$1” není možné momentálně použít, protože konfigurace wiki vyžaduje, aby se vypočítal až dodatečně. Pokud problém přetrvává delší dobu, požádejte správce, aby tento koncept zpřístupnil.',
	'smw_baduri' => 'Promiňte, URI z rozsahu „$1“ na tomto místě nejsou dostupné.',
	'smw_iq_disabled' => 'Promiňtě, semantické dotazy byly pro tuto wiki zakázány.',
	'smw_iq_moreresults' => '…další výsledky',
	'smw_iq_nojs' => 'Pro zobrazení tohoto prvku prosím použijte prohlížeč se zapnutým JavaScriptem.',
	'smw_iq_altresults' => 'Prohlížet přímo seznam výsledků.',
	'smw_unknown_importns' => 'Funkce importu nejsou dostupné pro jmenný prostor „$1“.',
	'smw_nonright_importtype' => '$1 je možné použít jen pro stránky ve jmenném prostoru „$2“.',
	'smw_wrong_importtype' => '$1 není možné použít pro stránky ve jmenném prostoru „$2“.',
	'smw_no_importelement' => 'Prvek „$1“ není dostupný pro import.',
	'smw_parseerror' => 'Zadaná hodnota nebyla pochopená.',
	'smw_notitle' => '„$1“ není možné použít na této wiki jako název stránky.',
	'smw_wrong_namespace' => 'Zde jsou povoleny jen stránky ze jmenného prostoru "$1"',
	'smw_unknowntype' => 'Pro vlastnost je definován nepodporovaný typ „$1“.',
	'smw_manytypes' => 'Pro vlastnost byl definován více než jeden typ.',
	'smw_emptystring' => 'Prázdné řetězce nejsou povolené.',
	'smw_maxstring' => 'Reprezentace řetězce $1 je příliš dlouhá.',
	'smw_notinenum' => '„$1“ není v seznamu možných hodnot ($2) této vlastnosti.',
	'smw_noboolean' => '„$1“ nebylo rozpoznáno jako platná hodnota typu boolean (ano/ne).',
	'smw_nofloat' => '“$1” není číslem.',
	'smw_infinite' => 'Tak dlouhá čísla jako $1 nejsou podporována.',
	'smw_infinite_unit' => 'Konverze na jednotky $1 dala jako výsledek číslo, které je příliš dlouhé.',
	'smw_unsupportedprefix' => 'Předpony pro čísla („$1“) nejsou podporované.',
	'smw_unsupportedunit' => 'Konverze pro jednotku "$1" není podporována.',
	'smw_nodatetime' => 'Datum "$1" nedává smysl.',
	'smw_toomanyclosing' => 'Dotazovaný řetězec „$1“ má příliš mnoho výskytů.',
	'smw_noclosingbrackets' => 'Některý výskyt „<nowiki>[[</nowiki>“ ve vašem dotazu nebyl ukončen odpovídajícím „]]“.',
	'smw_misplacedsymbol' => 'Symbol „$1“ byl užitý na místě, kde nemá význam.',
	'smw_unexpectedpart' => 'Část dotazu „$1“ nedává smysl.
Výsledky pravděpodobně nesplní očekávání.',
	'smw_emptysubquery' => 'Některý poddotaz nemá platné podmínky.',
	'smw_misplacedsubquery' => 'Některý poddotaz byl použitý na místě, kde nejsou poddotazy povoleny.',
	'smw_valuesubquery' => 'Poddotazy nejsou podporovány pro hodnoty vlastnosti „$1“.',
	'smw_overprintoutlimit' => 'Obsah dotazu překračuje limity pro výpis.',
	'smw_badprintout' => 'Některý příkaz pro výpis byl v dotazu chybně utvořený.',
	'smw_badtitle' => 'Promiňte, ale „$1” není platný název stránky.',
	'smw_badqueryatom' => 'Některá část „<nowiki>[[…]]</nowiki>“ nebyla srozumitelná.',
	'smw_propvalueproblem' => 'Hodnota vlastnosti „$1“ nedávala smysl.',
	'smw_noqueryfeature' => 'Určitá část dotazu není na této wiki podporovaná a bude proto ignorována ($1).',
	'smw_noconjunctions' => 'Konjunkce v dotazu není na této wiki podporována a bude proto ignorována ($1).',
	'smw_nodisjunctions' => 'Disjunkce nejsou v dotazech na této wiki podporované a část dotazu byla ignorována ($1).',
	'smw_querytoolarge' => 'Následující podmínky dotazu nebudou zohledněné z důvodu omezení této wiki na délku nebo hĺoubku dotazu: $1.',
	'smw_devel_warning' => 'Tato vlastnost je momentálně ve vývoji a nemusí být zcela funkční. Předtím, než jí použijete si zazálohujte data.',
	'smw_notemplategiven' => 'Aby tento formát dotazu fungoval, uveďte hodnotu parametru „template”.',
	'smw_type_header' => 'Vlastností typu „$1“',
	'smw_typearticlecount' => 'Zobrazeno je $1 {{PLURAL:$1|vlastnost|vlastnosti|vlastností}} tohoto typu.',
	'smw_attribute_header' => 'Stránek používajících vlastnost „$1“',
	'smw_attributearticlecount' => 'Zobrazeno je $1 {{PLURAL:$1|stránka používající|stránky používající|stránek používajících}} tuto vlastnost.',
	'smw_subproperty_header' => 'Podvlastnosti',
	'smw_subpropertyarticlecount' => 'Této vlastnosti náleží $1 {{PLURAL:$1|podvlastnost|podvlastností}}.',
	'smw_concept_header' => 'Stran konceptu "$1"',
	'smw_conceptarticlecount' => '{{PLURAL:$1|zobrazena je|zobrazeny jsou|zobrazeno je}} $1 {{PLURAL:$1|stránka náležející|stránky náležející|stránek náležejících}} tomuto konceptu.',
	'exportrdf' => 'Export stránek do RDF',
	'smw_exportrdf_docu' => 'Tato stránka vám umožňuje exportovat části stránek do formátu RDF. Po zadaní názvů stránek do spodního textového pole (jeden název na řádek) můžete exportovat stránky.',
	'smw_exportrdf_recursive' => 'Rekurzívně exportovat všechny související stránky. Pozor, výsledek může být velmi rozsáhlý!',
	'smw_exportrdf_backlinks' => 'Exportovat také stránky, které odkazují na exportované stránky. Vytvoří přehledné RDF.',
	'smw_exportrdf_lastdate' => 'Neexportovat stránky, které nebyly změněné od zadaného času.',
	'properties' => 'Vlastnosti',
	'smw_properties_docu' => 'Na této wiki se používají následující vlastnosti.',
	'smw_property_template' => '$1 typu $2 ($3)',
	'smw_propertylackspage' => 'Všechny vlastnosti by měly mít stránku s popisem!',
	'smw_propertylackstype' => 'Této vlastnosti nebyl definován žádný typ (předpokládá se prozatím typ $1)',
	'smw_propertyhardlyused' => 'Tato vlastnost se na wiki téměř nepoužívá!',
	'unusedproperties' => 'Nepoužité vlastnosti',
	'smw_unusedproperties_docu' => 'Nasledující vlastnosti existují i když je nevyužívá žádná jiná stránka.',
	'smw_unusedproperty_template' => '$1 typu $2',
	'wantedproperties' => 'Požadované vlastnosti',
	'smw_wantedproperties_docu' => 'Následující vlastnosti, které existují na této wiki, zatím nemají popisnou stránku.',
	'smw_wantedproperty_template' => '$1 (užité $2-krát)',
	'tooltip-purge' => 'Kliknutím zde obnovíte všechny dotazy a šablony na této stránce',
	'smw_purge' => 'Obnovit',
	'types' => 'Typy',
	'smw_types_docu' => 'Následuje seznam všech údajových typů, které je možné přiřadit vlastnostem. Každý údajový typ má stránku, kde je možné uvést dodatečné informace.',
	'smw_typeunits' => 'Jednotky typu „$1“: $2',
	'semanticstatistics' => 'Statistika sémantik',
	'smw_semstats_text' => 'Tato wiki obsahuje <b>$1</b> hodnot vlastností celkem <b>$2</b> rozličných <a href="$3">vlastností</a>.
<b>$4</b> vlastností nemá vlastní stránku a zamýšlený datový typ má uvedený <b>$5</b> z nich.
Některé z existujících vlastností mohou být <a href="$6">nepoužívané</a>.
Vlastnosti, kterým stále chybí stránka se nacházejí na <a href="$7">seznamu požadovaných vlastností</a>.',
	'uriresolver' => 'Překladač URI',
	'smw_uri_doc' => 'URI resolver se stará o implementaci <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG hledání na httpRange-14</a>. Stará se o to, aby se lidé nestali webstránkami.',
	'ask' => 'Sémantické vyhledávání',
	'smw_ask_sortby' => 'Řadit podle sloupce',
	'smw_ask_ascorder' => 'Vzestupně',
	'smw_ask_descorder' => 'Sestupně',
	'smw_ask_submit' => 'Najdi výsledky',
	'smw_ask_editquery' => '[Upravit dotaz]',
	'smw_add_sortcondition' => '[Přidat podmínku na řazení]',
	'smw_ask_hidequery' => 'Skrýt dotaz',
	'smw_ask_help' => 'Pomocník pro dotazy',
	'smw_ask_queryhead' => 'Dotaz',
	'smw_ask_printhead' => 'Přídavné výpisy (volitelné)',
	'searchbyproperty' => 'Hledat podle hodnoty vlastnosti',
	'smw_sbv_docu' => 'Hledat na wiki článek, který má vlastnost s jistou hodnotou.',
	'smw_sbv_novalue' => 'Nebyla uvedena hodnota. Prosím, vložte jí ve formuláři nebo zobrazte všechny atributy typu $1',
	'smw_sbv_displayresult' => 'Seznam všech článků, které mají vlastnost $1 s hodnotou $2.',
	'smw_sbv_property' => 'Vlastnost:',
	'smw_sbv_value' => 'Hodnota:',
	'smw_sbv_submit' => 'Hledat výsledky',
	'browse' => 'Prohledat wiki',
	'smw_browselink' => 'Projít vlastnosti',
	'smw_browse_article' => 'Zadejte název stránky, od které chcete začít prohledávat.',
	'smw_browse_go' => 'Provést',
	'pageproperty' => 'Hledání vlastností stránky',
	'smw_pp_docu' => 'Hledání všech nositelů vlastnosti na zadané stránce.
Prosím, zadejte stránku i vlastnost.',
	'smw_pp_from' => 'Od stránky',
	'smw_pp_type' => 'Vlastnost',
	'smw_pp_submit' => 'Výsledky hledání',
	'smw_result_prev' => 'Zpět',
	'smw_result_next' => 'Dále',
	'smw_result_results' => 'Výsledky',
	'smw_result_noresults' => 'Bohužel nejsou žádné výsledky.',
	'smwadmin' => 'Funkce pro administraci Sémantické wiki',
	'smw_smwadmin_return' => 'Zpět na $1',
	'smw_smwadmin_updatestopped' => 'Všechny procesy aktualizace byly zastaveny.',
	'smw_smwadmin_updatenotstopped' => 'Abyste zastavili běžící proces aktualizace, musíte zaškrtnout políčko, čímž potvrdíte, že si jste jisti.',
);

/** German (Deutsch)
 * @author Als-Holder
 * @author DaSch
 * @author Denny
 * @author Imre
 * @author Jan Luca
 * @author Jens Liebenau
 * @author Kghbln
 * @author MF-Warburg
 * @author Markus Krötzsch
 * @author Melancholie
 * @author Michawiki
 * @author Omnipaedista
 * @author Pill
 * @author Purodha
 * @author Revolus
 * @author The Evil IP address
 * @author Umherirrender
 */
$messages['de'] = array(
	'smw-desc' => "Das Wiki zugänglicher machen - für Maschinen ''und'' Menschen ([http://semantic-mediawiki.org/wiki/Help:Bedienungsanleitung Online-Dokumentation])",
	'smw_edithelp' => 'Bearbeitungshilfe für Attribute',
	'smw_viewasrdf' => 'RDF-Feed',
	'smw_finallistconjunct' => ' und',
	'smw_factbox_head' => 'Fakten zu $1',
	'smw_isspecprop' => 'Dieses Attribut ist ein Spezialattribut in diesem Wiki.',
	'smw_isknowntype' => 'Dieser Datentyp gehört zu den Standarddatentypen in diesem Wiki.',
	'smw_isaliastype' => 'Dieser Datentyp ist ein Alias für den Typ „$1“.',
	'smw_isnotype' => 'Der Datentyp „$1“ ist kein Standarddatentyp in diesem Wiki und verfügt auch über keine ausreichende Definition auf seiner Seite.',
	'smw_concept_description' => 'Beschreibung des Konzepts „$1“',
	'smw_no_concept_namespace' => "Konzepte können nur im Konzeptnamensraum (''Konzept:'') erstellt werden.",
	'smw_multiple_concepts' => 'Jede Konzeptseite kann nur eine Konzeptdefinition beinhalten.',
	'smw_concept_cache_miss' => 'Das Konzept „$1“ kann im Moment nicht angewendet werden, da die Wiki-Konfiguration offline berechnet werden muss.
Falls sich das Problem nicht nach einiger Zeit von selbst erledigt, bitte Deinen Websiteadministrator, dieses Konzept zu ermöglichen.',
	'smw_noinvannot' => 'Inversen Attributen können keine Werte zugewiesen werden.',
	'smw_baduri' => 'URIs der Form „$1“ sind nicht zulässig.',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automatisch',
	'smw_printername_count' => 'Ergebnisse zählen',
	'smw_printername_csv' => 'CSV-Export',
	'smw_printername_debug' => 'Debug-Abfrage (für Experten)',
	'smw_printername_embedded' => 'Seiteninhalt einbetten',
	'smw_printername_json' => 'JSON-Export',
	'smw_printername_list' => 'Liste',
	'smw_printername_ol' => 'Aufzählung',
	'smw_printername_ul' => 'Aufzählung',
	'smw_printername_rss' => 'RSS-Export',
	'smw_printername_table' => 'Tabelle',
	'smw_printername_broadtable' => 'Breite Tabelle',
	'smw_printername_template' => 'Vorlage',
	'smw_paramdesc_limit' => 'Die maximale Anzahl der auszugebenden Ergebnisse',
	'smw_paramdesc_headers' => 'Zeige die Überschriften/ Attrributnamen an',
	'smw_paramdesc_mainlabel' => 'Das Label für den Namen der Hauptseite',
	'smw_paramdesc_link' => 'Werte als Links anzeigen',
	'smw_paramdesc_intro' => 'Der vor etwaigen Abfrageergebnissen anzuzeigende Text',
	'smw_paramdesc_outro' => 'Der nach etwaigen Abfrageergebnissen anzuzeigende Text',
	'smw_paramdesc_default' => 'Der anzuzeigende Text sofern keine Abfrageergebnisse vorhanden sind',
	'smw_paramdesc_searchlabel' => 'Der Text für den Link zu den Suchergebnissen',
	'smw_paramdesc_sep' => 'Das Trennzeichen für Werte',
	'smw_paramdesc_template' => 'Name der Vorlage mit der die Abfrageergebnisse angezeigt werden sollen',
	'smw_paramdesc_columns' => 'Die Anzahl der Spalten die für die Anzeige Suchergebnisse verwendet werden sollen (standardmäßig $1)',
	'smw_paramdesc_embedformat' => 'Das für die Festlegung der Überschriften genutzte HTML-Tag',
	'smw_paramdesc_embedonly' => 'Keine Überschriften anzeigen',
	'smw_paramdesc_rsstitle' => 'Der Text, der als Titel für den Feed benutzt wird',
	'smw_paramdesc_rssdescription' => 'Der Text, der als Beschreibung für den Feed benutzt wird',
	'smw_iq_disabled' => 'Semantische Anfragen sind in diesem Wiki zurzeit nicht möglich.',
	'smw_iq_moreresults' => '… weitere Ergebnisse',
	'smw_iq_nojs' => 'Der Inhalt dieses Elementes kann mit einem Browser mit JavaScript-Unterstützung betrachtet werden.',
	'smw_iq_altresults' => 'Suchergebnisse als Liste anzeigen.',
	'smw_unknown_importns' => 'Für den Namensraum „$1“ sind leider keine Importfunktionen verfügbar.',
	'smw_nonright_importtype' => 'Das Element „$1“ kann nur für Seiten im Namensraum „$2“ verwendet werden.',
	'smw_wrong_importtype' => 'Das Element „$1“ kann nicht für Seiten im Namensraum „$2“ verwendet werden.',
	'smw_no_importelement' => 'Das Element „$1“ steht leider nicht zum Importieren zur Verfügung.',
	'smw_parseerror' => 'Der eingegebene Wert wurde nicht verstanden.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '„$1“ kann nicht als Seitenname in diesem Wiki verwendet werden.',
	'smw_wrong_namespace' => 'Nur Seiten im Namensraum „$1“ sind hier zulässig.',
	'smw_unknowntype' => 'Dem Attribut wurde der unbekannte Datentyp „$1“ zugewiesen.',
	'smw_manytypes' => 'Dem Attribut wurden mehrere Datentypen zugewiesen.',
	'smw_emptystring' => 'Leere Zeichenfolgen werden nicht akzeptiert.',
	'smw_maxstring' => 'Die Zeichenkette „$1“ ist zu lang.',
	'smw_notinenum' => '„$1“ gehört nicht zu den möglichen Werten dieses Attributs ($2).',
	'smw_noboolean' => '„$1“ ist kein Wahrheitswert (wahr/falsch).',
	'smw_true_words' => 'wahr,ja,true',
	'smw_false_words' => 'falsch,nein,false',
	'smw_nofloat' => '„$1“ ist keine Zahl.',
	'smw_infinite' => 'Die Zahl „$1“ ist zu lang.',
	'smw_infinite_unit' => 'Die Umrechnung in Einheit „$1“ ist nicht möglich: die Zahl ist zu lang.',
	'smw_novalues' => 'Es wurden keine Werte angegeben.',
	'smw_unsupportedprefix' => 'Vorangestellte Zeichen bei Dezimalzahlen („$1“) werden nicht unterstützt.',
	'smw_unsupportedunit' => 'Umrechnung der Einheit „$1“ nicht unterstützt.',
	'smw_nodatetime' => 'Das Datum „$1“ wurde nicht verstanden.',
	'smw_toomanyclosing' => 'In der Anfrage kommen zu viele „$1“ vor.',
	'smw_noclosingbrackets' => 'Ein Vorkommen von „<nowiki>[[</nowiki>“ in der Anfrage wurde nicht durch ein entsprechendes „]]“ abgeschlossen.',
	'smw_misplacedsymbol' => 'Das Symbol „$1“ wurde an einer Stelle verwendet, an der es nicht sinnvoll ist.',
	'smw_unexpectedpart' => 'Der Teil „$1“ der Anfrage wurde nicht verstanden. Die Ergebnisse sind eventuell nicht wie erwartet.',
	'smw_emptysubquery' => 'Keine Bedingung in Teilanfrage.',
	'smw_misplacedsubquery' => 'Eine Teilanfrage wurde an einer Stelle verwendet, an der keine Teilanfragen vorkommen dürfen.',
	'smw_valuesubquery' => 'Teilanfragen werden für Werte des Attributs „$1“ nicht unterstützt.',
	'smw_overprintoutlimit' => 'Die Anfrage enhält zu viele Ausgabeanweisungen.',
	'smw_badprintout' => 'Eine Ausgabeanweisung wurde nicht verstanden.',
	'smw_badtitle' => 'Leider ist „$1“ als Seitentitel nicht zulässig.',
	'smw_badqueryatom' => 'Ein Teil „<nowiki>[[…]]</nowiki>“ der Anfrage wurde nicht verstanden.',
	'smw_propvalueproblem' => 'Der Wert des Attributs „$1“ wurde nicht verstanden.',
	'smw_noqueryfeature' => 'Einige Abfrage-Funktionen werden derzeit nicht von diesem Wiki unterstützt. Der entsprechende Teil der Abfrage wurde entfernt ($1).',
	'smw_noconjunctions' => 'UND-Verknüpfungen in den Anfragen werden von diesem Wiki nicht unterstützt und der entsprechende Teil der Anfrage wurde gelöscht ($1).',
	'smw_nodisjunctions' => 'Disjunktionen (ODER) in Anfragen sind in diesem Wiki nicht zulässig und ein Teil der Anfrage muss daher ignoriert werden ($1).',
	'smw_querytoolarge' => 'Die folgenden Abfragebedingungen konnten, wegen der auf diesem Wiki gültigen Beschränkungen, bezüglich Größe und Tiefe von Abfragen, nicht berücksichtigt werden: $1.',
	'smw_devel_warning' => 'Diese Funktion befindet sich zurzeit in Entwicklung und ist vielleicht noch nicht voll einsatzfähig. Eventuell ist es ratsam, den Inhalt des Wikis vor der Benutzung dieser Funktion zu sichern.',
	'smw_notemplategiven' => 'Der Parameter „template“ muss angegeben werden, damit diese Anfrage durchgeführt werden kann.',
	'smw_type_header' => 'Attribute mit dem Datentyp „$1“',
	'smw_typearticlecount' => 'Es {{PLURAL:$1|wird 1 Attribut|werden $1 Attribute}} mit diesem Datentyp angezeigt:',
	'smw_attribute_header' => 'Seiten mit dem Attribut „$1“',
	'smw_attributearticlecount' => 'Es {{PLURAL:$1|wird 1 Seiten|werden $1 Seiten}} angezeigt, die dieses Attribut {{PLURAL:$1|verwendet|verwenden}}:',
	'smw_subproperty_header' => 'Unterattribute',
	'smw_subpropertyarticlecount' => 'Dieses Attribut hat {{PLURAL:$1|folgendes Unterattribut|folgende $1 Unterattribute}}:',
	'smw_concept_header' => 'Seiten des Konzepts „$1“',
	'smw_conceptarticlecount' => 'Es {{PLURAL:$1|wird 1 Seite|werden $1 Seiten}} angezeigt, die zu diesem Konzept {{PLURAL:$1|gehört|gehören}}:',
	'smw_rss_description' => 'RSS-Feed von $1',
	'exportrdf' => 'Seite als RDF exportieren',
	'smw_exportrdf_docu' => 'Hier können Informationen über einzelne Seiten im RDF-Format abgerufen werden. Bitte gib die Namen der gewünschten Seiten <i>zeilenweise</i> ein.',
	'smw_exportrdf_recursive' => 'Exportiere auch alle relevanten Seiten rekursiv. Diese Einstellung kann zu sehr großen Ergebnissen führen!',
	'smw_exportrdf_backlinks' => 'Exportiere auch alle Seiten, die auf exportierte Seiten verweisen. Erzeugt RDF, das leichter durchsucht werden kann.',
	'smw_exportrdf_lastdate' => 'Exportiere keine Seiten, die seit dem angegebenen Zeitpunkt unverändert geblieben sind.',
	'smw_exportrdf_submit' => 'Exportieren',
	'properties' => 'Attribute',
	'smw_properties_docu' => 'In diesem Wiki gibt es die folgenden Attribute:',
	'smw_property_template' => '$1 mit Datentyp $2 ($3)',
	'smw_propertylackspage' => 'Alle Attribute sollten durch eine Seite beschrieben werden!',
	'smw_propertylackstype' => 'Für dieses Attribut wurde kein Datentyp angegeben ($1 wird vorläufig als Typ angenommen).',
	'smw_propertyhardlyused' => 'Dieses Attribut wird im Wiki kaum verwendet!',
	'unusedproperties' => 'Verwaiste Attribute',
	'smw_unusedproperties_docu' => 'Die folgenden Attributseiten existieren, obwohl sie nicht verwendet werden.',
	'smw_unusedproperty_template' => '$1 mit Datentyp $2',
	'wantedproperties' => 'Gewünschte Attribute',
	'smw_wantedproperties_docu' => 'Folgende Attribute haben bisher keine erläuterende Seite, obwohl sie bereits für die Beschreibung anderer Seiten verwendet werden.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|Vorkommen|Vorkommen}})',
	'tooltip-purge' => 'Alle Anfrageergebnisse und Vorlagen auf dieser Seite auf den neuesten Stand bringen.',
	'smw_purge' => 'Aktualisieren',
	'types' => 'Datentypen',
	'smw_types_docu' => 'Die folgenden Datentypen können Attributen zugewiesen werden. Jeder Datentyp hat eine eigene Seite, auf der genauere Informationen eingetragen werden können.',
	'smw_typeunits' => 'Maßeinheiten des Datentyps „$1“: $2',
	'semanticstatistics' => 'Statistik über semantische Daten',
	'smw_semstats_text' => "In diesem Wiki {{PLURAL:$1|wurde '''1''' Wert|wurden '''$1''' Werte}} für insgesamt '''$2''' [[Special:Properties|{{PLURAL:$2|Attribut|verschiedene Attribute}}]] eingegeben. '''$3''' {{PLURAL:$3|Attribut hat|Attribute haben}} eine eigene Seite und der gewünschte Datentyp ist für '''$4''' von diesen angegeben worden. Einige der existierenden Attribute können [[Special:UnusedProperties|verwaiste Attribute]] sein. Attribute, für die noch eine Seite angelegt werden sollte, sind in der [[Special:WantedProperties|Liste der gewünschten Attribute]] aufgeführt.",
	'uriresolver' => 'URI-Auflöser',
	'smw_uri_doc' => 'Der URI-Auflöser setzt die Empfehlungen „<a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>“ um. Er sorgt dafür, dass Menschen nicht zu Webseiten werden.',
	'ask' => 'Semantische Suche',
	'smw_ask_sortby' => 'Sortiere nach Spalte (optional)',
	'smw_ask_ascorder' => 'Aufsteigend',
	'smw_ask_descorder' => 'Absteigend',
	'smw_ask_submit' => 'Finde Ergebnisse',
	'smw_ask_editquery' => '[Anfrage bearbeiten]',
	'smw_add_sortcondition' => '[Sortieranweisung hinzufügen]',
	'smw_ask_hidequery' => 'Anfrage ausblenden',
	'smw_ask_help' => 'Hilfe',
	'smw_ask_queryhead' => 'Anfrage',
	'smw_ask_printhead' => 'Zusätzliche Daten zur Anzeige',
	'smw_ask_printdesc' => '(einen Eigenschaftsnamen pro Zeile hinzufügen)',
	'smw_ask_format_as' => 'Formatiert als:',
	'smw_ask_defaultformat' => 'Standard',
	'smw_ask_otheroptions' => 'Andere Optionen',
	'smw_ask_show_embed' => 'Eingebetteten Code zeigen',
	'smw_ask_hide_embed' => 'Eingebetteten Code verstecken',
	'smw_ask_embed_instr' => 'Um diese Abfrage in eine Wiki-Seite einzubauen, nutze den unten stehenden Code.',
	'searchbyproperty' => 'Suche mittels Attribut',
	'smw_sbv_docu' => 'Diese Spezialseite findet alle Seiten, die einen bestimmten Wert für das angegebene Attribut haben.',
	'smw_sbv_novalue' => 'Bitte den gewünschten Wert eingeben oder alle Werte für das Attribut $1 ansehen.',
	'smw_sbv_displayresult' => 'Eine Liste aller Seiten, die ein Attribut $1 mit dem Wert $2 haben.',
	'smw_sbv_displayresultfuzzy' => 'Eine Liste aller Seiten, die das Attribut „$1“ mit dem Wert „$2“ haben.
Weil nur wenige Ergebnisse gefunden wurden, werden auch ähnliche Werte aufgelistet.',
	'smw_sbv_property' => 'Attribut:',
	'smw_sbv_value' => 'Wert:',
	'smw_sbv_submit' => 'Finde Ergebnisse',
	'browse' => 'Wiki browsen',
	'smw_browselink' => 'Attribute anzeigen',
	'smw_browse_article' => 'Bitte gib den Titel einer Seite ein.',
	'smw_browse_go' => 'Los',
	'smw_browse_show_incoming' => 'zeige Attribute die hierhin verlinken',
	'smw_browse_hide_incoming' => 'verstecke Attribute die hierhin verlinken',
	'smw_browse_no_outgoing' => 'Diese Seite hat keine Attribute.',
	'smw_browse_no_incoming' => 'Keine Attribute verlinken auf diese Seite.',
	'smw_inverse_label_default' => '$1 von',
	'smw_inverse_label_property' => 'Umgekehrte Attributsbezeichnung',
	'pageproperty' => 'Attributswerte einer Seite',
	'smw_pp_docu' => 'Suche nach allen Werten, die ein bestimmtes Attribut für die angegebene Seite hat.',
	'smw_pp_from' => 'Seite',
	'smw_pp_type' => 'Attribut',
	'smw_pp_submit' => 'Ergebnisse anzeigen',
	'smw_result_prev' => 'Zurück',
	'smw_result_next' => 'Vorwärts',
	'smw_result_results' => 'Ergebnisse',
	'smw_result_noresults' => 'Keine Ergebnisse gefunden.',
	'smwadmin' => 'Admin-Funktionen für Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Speicherplatz für Semantic MediaWiki einstellen',
	'smw_smwadmin_setupsuccess' => 'Die Speichereinheit wurde erfolgreich eingerichtet.',
	'smw_smwadmin_return' => 'Zurück zu $1',
	'smw_smwadmin_updatestarted' => 'Ein neuer Update-Prozess zur Aktualisierung der semantischen Daten wurde gestartet.
Alle gespeicherten Daten werden neu erstellt oder repariert, sofern nötig.
Du kannst den Fortschritt des Updates auf dieser Spezialseite verfolgen.',
	'smw_smwadmin_updatenotstarted' => 'Es läuft bereits ein Update-Prozess.
Es wird kein Neuer begonnen.',
	'smw_smwadmin_updatestopped' => 'Alle existierenden Aktualisierungsprozesse wurden gestoppt.',
	'smw_smwadmin_updatenotstopped' => 'Um laufende Prozesse zu stoppen, musst du das Kontrollkästchen aktivieren, wenn du dir wirklich sicher bist.',
	'smw_smwadmin_docu' => 'Diese Spezialseite hilft während der Installation und dem Upgrade von <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Denke daran, wichtige Daten vor der Ausführung administrativer Funktionen zu sichern.',
	'smw_smwadmin_db' => 'Datenbankinstallation und -aktualisierung',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki benötigt einige Erweiterungen an der MediaWiki-Datenbank um die semantischen Daten zu speichern.
Die folgende Funktion gewährleistet, dass die Datenbank richtig eingerichtet ist.
Die Änderungen, die in diesem Schritt gemacht werden, beeinträchtigen den Rest der MediaWiki-Datenbank nicht und können einfach zurückgesetzt werden, wenn gewünscht.
Diese Setup-Funktion kann mehrere Male ausgeführt werden ohne Schaden zu verursachen, es ist aber nur einmal bei Installation oder Update nötig.',
	'smw_smwadmin_permissionswarn' => 'Wenn die Aktion mit einem SQL-Fehler abbricht, könnte es sein, dass der Datenbankbenutzer, durch den das Wiki auf die Datenbank zugreift (siehe die Datei LocalSettings.php), keine ausreichenden Rechte hat.
Um das Problem zu lösen, ist es möglich, dem Benutzer zusätzliche Rechte zur Erstellung und Löschung von Tabellen einzuräumen, den Datenbank-Administrator zeitweilig in die LocalSettings.php einzutragen, oder das Wartungsskript <tt>SMW_setup.php</tt> zu benutzen, das die Benutzerdaten aus AdminSettings.php benutzen kann.',
	'smw_smwadmin_dbbutton' => 'Tabellen initialisieren oder aktualiseren',
	'smw_smwadmin_announce' => 'Dein Wiki bekannt geben',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki hat einen Webservice für die Bekanntgabe neuer semantischer Wikiseiten.
Dieser Service wird benötigt um eine Liste zu erhalten, welche öffentlichen Seiten Semantic MediaWiki nutzen, hauptsächlich aber um dem <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic-MediaWiki-Projekt</a> einen Überbick über typische Anwendungen von Semantic MediaWiki zu geben.
Siehe die Semantic-MediaWiki-Homepage für <a href="http://semantic-mediawiki.org/wiki/Registry">weiterführende Informationen über diesen Service</a>.',
	'smw_smwadmin_announcebutton' => 'Drücke den folgenden Knopf um die URL deines Wikis zu diesem Dienst hinzuzufügen.
Dieser Dienst wird keine Wikis aufnehmen, die nicht öffentlich zugänglich sind und er wird nur öffentlich zugängliche Informationen speichern.',
	'smw_smwadmin_datarefresh' => 'Datenreparatur und -aktualisierung',
	'smw_smwadmin_datarefreshdocu' => 'Es ist möglich alle Datenbanken von Semantic MediaWiki auf Basis des aktuellen Inhalts des Wikis wiederherzustellen.
Dies kann hilfreich sein, um eine zerstörte Datenbank zu erneuern oder um Daten zu aktualisieren, wenn Aufgrund eines Softwareupgrade die Datenbankstruktur geändert wurde.
Das Update wird für jede Seite ausgeführt und wird einige Zeit in Anspruch nehmen.
Nachfolgend wird gezeigt, ob ein Update läuft und es wird dir erlaubt ein Update zu starten oder zu stoppen (außer wenn diese Funktion vom Seitenbetreiber deaktiviert wurde).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Ein Update läuft bereits.</strong>
Ein Update geht normalerweise nur langsam voran, da die Daten nur in kleinen Portionen aktualisiert werden, und zwar jedesmal, wenn jemand auf das Wiki zugreift.
Um dieses Update schneller zu beenden, kann man das MediaWiki-Wartungsskript <tt>runJobs.php</tt> (mit dem Parameter <tt>--maxjobs 1000</tt> kann die Anzahl der Updates, die in einem Rutsch durchgeführt werden, beschränkt werden) benutzen.
Geschätzter Fortschritt des laufenden Updates:',
	'smw_smwadmin_datarefreshbutton' => 'Datenaktualisierung beginnen',
	'smw_smwadmin_datarefreshstop' => 'Diese Aktualisierung beenden',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ja, ich bin mir sicher.',
	'smw_smwadmin_support' => 'Unterstützung erhalten',
	'smw_smwadmin_supportdocu' => 'Verschiedene Mittel/Quellen helfen dir vielleicht bei einem Problemfall:',
	'smw_smwadmin_installfile' => 'Wenn es Probleme mit der Installation gibt, könnte die Datei <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL</a> weiterhelfen.',
	'smw_smwadmin_smwhomepage' => 'Die komplette Benutzerdokumentation von Semantic MediaWiki findest du auf <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Fehler können bei <a href="https://bugzilla.wikimedia.org/">Bugzilla</a> berichtet werden.',
	'smw_smwadmin_questions' => 'Wenn du weitere Fragen oder Vorschläge hast, beteilige dich an der Diskussion im <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">„Semantic MediaWiki“-Benutzerforum</a>.',
	'smw_adminlinks_datastructure' => 'Datenstruktur',
	'smw_adminlinks_displayingdata' => 'Daten anzeigen',
	'smw_adminlinks_inlinequerieshelp' => 'Inline-Abfragen-Hilfe',
);

/** German (formal address) (Deutsch (Sie-Form))
 * @author Dst
 * @author Imre
 * @author Kghbln
 * @author Revolus
 */
$messages['de-formal'] = array(
	'smw_concept_cache_miss' => 'Das Konzept „$1“ kann im Moment nicht angewendet werden, da die Wiki-Konfiguration offline berechnet werden muss.
Falls sich das Problem nicht nach einiger Zeit von selbst erledigt, bitten Sie Ihren Websiteadministrator, dieses Konzept zu ermöglichen.',
	'smw_exportrdf_docu' => 'Hier können Informationen über einzelne Seiten im RDF-Format abgerufen werden. Bitte geben Sie die Namen der gewünschten Seiten <i>zeilenweise</i> ein.',
	'smw_ask_embed_instr' => 'Um diese Abfrage in eine Wiki-Seite einzubauen, nutzen Sie den unten stehenden Code.',
	'smw_browse_article' => 'Bitte geben Sie den Titel einer Seite ein.',
	'smw_smwadmin_updatestarted' => 'Ein neuer Update-Prozess zur Aktualisierung der semantischen Daten wurde gestartet.
Alle gespeicherten Daten werden, sofern nötig, neu erstellt oder repariert.
Sie können den Fortschritt des Updates auf dieser Spezialseite verfolgen.',
	'smw_smwadmin_updatenotstopped' => 'Um laufende Prozesse zu stoppen, müssen Sie das Kontrollkästchen aktivieren, um so anzugeben, dass Sie sich wirklich sicher sind.',
	'smw_smwadmin_docu' => 'Diese Spezialseite unterstützt Sie während der Installation und dem Upgrade von <a href="http://semantic-mediawiki.org/wiki/Semantic_MediaWiki_–_Startseite">Semantic MediaWiki</a>.
Denken Sie daran, wichtige Daten vor der Ausführung systemadministrativer Funktionen zu sichern.',
	'smw_smwadmin_announce' => 'Ihr Wiki bekannt geben',
	'smw_smwadmin_announcebutton' => 'Drücken Sie die folgende Schaltfläche, um die URL Ihres Wikis für diesem Dienst hinzuzufügen.
Dieser Dienst wird keine Wikis aufnehmen, die nicht öffentlich zugänglich sind. Zudem wird er nur öffentlich zugängliche Informationen speichern.',
	'smw_smwadmin_supportdocu' => 'Verschiedene Hinweise helfen Ihnen vielleicht im Fall eines Problems:',
	'smw_smwadmin_smwhomepage' => 'Die vollständige Nutzerdokumention von Semantic MediaWiki finden Sie auf <b><a href="http://semantic-mediawiki.org/wiki/Semantic_MediaWiki_–_Startseite">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_questions' => 'Sofern Sie weitere Fragen oder Vorschläge haben, beteiligen Sie sich bitte an der Diskussion im <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">„Semantic MediaWiki“-Nutzerforum</a>.',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'smw-desc' => "Twój wiki pśistupnjejšy cyniś - za mašiny ''a'' luźi
([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentacija online])",
	'smw_edithelp' => 'Wobźěłowańska pomoc za kakosći',
	'smw_viewasrdf' => 'Kanal RDF',
	'smw_finallistconjunct' => 'a',
	'smw_factbox_head' => 'Fakty wó $1',
	'smw_isspecprop' => 'Toś ta kakosć jo specialna kakosć w toś tom wikiju.',
	'smw_isknowntype' => 'Toś ten typ słuša k standardnym datowym typam toś togo wikija.',
	'smw_isaliastype' => 'Toś ten typ jo alias za datowy typ "$1".',
	'smw_isnotype' => 'Toś ten typ "$1" njejo standardny datowy typ we wikiju a njama ani wužywarsku definiciju.',
	'smw_concept_description' => 'Wopisanje koncepta "$1"',
	'smw_no_concept_namespace' => 'Koncepty daju se jano na bokach w mjenjowem rumje Concept: definěrowaś.',
	'smw_multiple_concepts' => 'Kuždy konceptowy bok móžo jano jadnu konceptowu definiciju měś.',
	'smw_concept_cache_miss' => 'Koncept "$1" njedajo se we wokugnuśu wužywaś, dokulaž wikijowa konfiguracija trjeba jón za pśeźěłowanje off-line.
Jolic problem se njezgubujo pó wěstem casu, pšos swójogo sedłowego administratora, aby wón toś ten koncept k dispoziciji stajił.',
	'smw_noinvannot' => 'Gódnoty njedaju se nawopacnym kakosćam pśipokazaś.',
	'smw_baduri' => 'URI formy "$1" njejsu dowólone.',
	'smw_printername_auto' => 'Awtomatiski',
	'smw_printername_count' => 'Wuslědki licyś',
	'smw_printername_csv' => 'Ako CSV eksportěrowaś',
	'smw_printername_debug' => 'Wótpšašanje za zmólkami pśepytaś (za ekspertow)',
	'smw_printername_embedded' => 'Bokowe wopśimjeśe zasajźiś',
	'smw_printername_json' => 'Ako JSON eksportěrowaś',
	'smw_printername_list' => 'Lisćina',
	'smw_printername_ol' => 'Nalicenje',
	'smw_printername_ul' => 'Nalistowanje',
	'smw_printername_rss' => 'Ako RSS eksportěrowaś',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Šyroka tabela',
	'smw_printername_template' => 'Pśedłoga',
	'smw_paramdesc_limit' => 'Maksimalna licba wuslědkow, kótarež maju se wrośiś',
	'smw_paramdesc_headers' => 'Mjenja głowow resp. atributow zwobrazniś',
	'smw_paramdesc_mainlabel' => 'Pomjenjenje, kótarež ma se głownemu bokoju daś',
	'smw_paramdesc_link' => 'Gódnoty ako wótkaze pokazaś',
	'smw_paramdesc_intro' => 'Tekst, kótaryž ma se pśed napšašowańskimi wuslědkami zwobrazniś, jolic take su',
	'smw_paramdesc_outro' => 'Tekst, kótaryž ma se za napšašowańskimi wuslědkami zwobrazniś, jolic take su',
	'smw_paramdesc_default' => 'Tekst, kótaryž ma se zwobrazniś, jolic napšašowańske wuslědki njejsu',
	'smw_paramdesc_searchlabel' => 'Tekst wótkaza do wuslědkow',
	'smw_paramdesc_sep' => 'Źěleńske znamuško za gódnoty',
	'smw_paramdesc_template' => 'Mjenja pśedłogi, z kótarejuž wuśišće maju se zwobrazniś',
	'smw_paramdesc_columns' => 'Licba słupow, w kótarychž maju se wuslědki zwobrazniś (standard jo $1)',
	'smw_paramdesc_embedformat' => 'HTML-toflicka, kótaraž wužywa se, aby definěrowała nadpisma',
	'smw_paramdesc_embedonly' => 'Žedne nadpisma zwobraznis',
	'smw_paramdesc_rsstitle' => 'Tekst, kótaryž ma se ako titel kanala wužywaś',
	'smw_paramdesc_rssdescription' => 'Tekst, kótaryž ma se ako wopisanje kanala wužywaś',
	'smw_iq_disabled' => 'Semantiske wótpšašanja su se znjemóžnili za toś ten wiki.',
	'smw_iq_moreresults' => '... dalšne wuslědki',
	'smw_iq_nojs' => 'Wužyj wobglědowak z pódperu za JavaScript, aby se toś ten element woglědał.',
	'smw_iq_altresults' => 'Lisćinu wuslědkow direktnje pśepytaś.',
	'smw_unknown_importns' => 'Importěrowańske funkcije njestoje k dispoziciji za mjenjowy rum "$1".',
	'smw_nonright_importtype' => '$1 dajo se jano za boki z mjenjowym rumom "$2" wužywaś.',
	'smw_wrong_importtype' => '$1 njedajo se za boki w mjenjowem rumje "$2" wužywaś.',
	'smw_no_importelement' => 'Element "$1" njestoj za importěrowanje k dispoziciji.',
	'smw_parseerror' => 'Zapódana gódnota njejo se rozměła.',
	'smw_notitle' => '"$1" njedajo se ako bokowe mě w toś tom wikiju wužywaś.',
	'smw_wrong_namespace' => 'Jano boki w mjenjowem rumje "$1" su how dowólone.',
	'smw_unknowntype' => 'Za kakosć jo se njepódpěrany typ "$1" definěrował.',
	'smw_manytypes' => 'Wěcej ako jaden typ za kakosć definěrowany.',
	'smw_emptystring' => 'Prozne znamješkowe rědy se njeakceptěruju.',
	'smw_maxstring' => 'Znamješkowy rěd $1 jo pśedłujki.',
	'smw_notinenum' => '"$1" njejo w lisćinje móžnych gódnotow ($2) za toś tu kakosć.',
	'smw_noboolean' => '"$1" njejo dowólona gódnota typa Boolean (wěrny/njewěrny).',
	'smw_true_words' => 'wěrny, w, jo, j',
	'smw_false_words' => 'njewěrny, ně, n',
	'smw_nofloat' => '"$1" njejo licba.',
	'smw_infinite' => 'Licby, kótarež su dłujke ako "$1", se njepódpěraju.',
	'smw_infinite_unit' => 'Konwertěrowanje do jadnotki "$1" jo pśinjasło licbu, kótaraž jo pśedłujka.',
	'smw_novalues' => 'Žedne gódnoty pódane',
	'smw_unsupportedprefix' => 'Prefikse za licby ("$1") se njepodpěraju.',
	'smw_unsupportedunit' => 'Konwertěrowanje jadnotki "$1" se njepódpěra.',
	'smw_nodatetime' => 'Datum "$1" njejo se rozměł.',
	'smw_toomanyclosing' => 'Zda se, až jo pśewjele wustupowanjow "$1" w napšašowanju.',
	'smw_noclosingbrackets' => 'Jadne wustupowanje "<nowiki>[[</nowiki>" w twójom napšašanju njejo se pśez wótpowědnej "]]" wótzamknuło.',
	'smw_misplacedsymbol' => 'Symbol "$1" jo se na městnje wužył, źož njejo wužytny,',
	'smw_unexpectedpart' => 'Źěl "$1" wótpšašanja njejo se rozměł.
Wuslědki snaź njejsu ako wócakowane.',
	'smw_emptysubquery' => 'Pódwótpšašanje njama płaśiwe wuměnjenje.',
	'smw_misplacedsubquery' => 'Pódwótpšašanje wužywa se na městnje, źož pódwótpšašanja njejsu dowólone.',
	'smw_valuesubquery' => 'Pódwótpšašanja njepódpěraju se za gódnoty kakosći "$1".',
	'smw_overprintoutlimit' => 'Napšašanje wopśimujo pśewjele śišćarskich nadawkow.',
	'smw_badprintout' => 'Někaki śišćarski pśikaz we wótpšašaanju jo skazony był.',
	'smw_badtitle' => '"$1" njejo płaśiwy bokowy titel.',
	'smw_badqueryatom' => 'Źěl wótpšašanja "<nowiki>[[…]]</nowiki>" njejo se rozměł.',
	'smw_propvalueproblem' => 'Gódnota kakosći "$1" njejo se rozměła.',
	'smw_noqueryfeature' => 'Někaka wótpšašowańska funkcije njejo se pódprěła a źěl wótpšašanja jo se wótpórał ($1).',
	'smw_noconjunctions' => 'Konjunkcije (zwězanja A) we wótpšašanjach njepódpěraju se w toś tom wikiju a źěl wótpšašanja jo se wótpórał ($1).',
	'smw_nodisjunctions' => 'Disjunkcije (zwězanja ABO) we wótpšašanjach njepódpěraju se w toś tom wikiju a źěl wótpšašanja jo se wótpórał ($1).',
	'smw_querytoolarge' => 'Dla wikijowych wobgranicowanjow we wjelikosći abo dłymokosći njejo było móžno slědujuce wótpšašańske wuměnjenja zapśimjeś: $1',
	'smw_devel_warning' => 'Toś ta funkcija se tuchylu hyšći wuwija a by było móžno, až hyšći połnje njefunkcioněrujo.
Zawěsćć swóje daty, nježli až ju wužywaš.',
	'smw_notemplategiven' => 'Pódaj gódnotu za parameter "template", aby napšašowański format funkcioněrował.',
	'smw_type_header' => 'Kakosći typa "$1"',
	'smw_typearticlecount' => '$1 {{PLURAL:$1|kakosć pokazujo|kakosći pokazujotej|kakosći pokazuju|kakosćow pokazujo}} se z pomocu toś togo typa.',
	'smw_attribute_header' => 'Boki, kótarež wužywaju kakosć "$1"',
	'smw_attributearticlecount' => '$1 {{PLURAL:$1|bok pokazujo|boka pokazujotej|boki pokazuju|bokow pokazujo}} se z pomocu toś teje kakosći.',
	'smw_subproperty_header' => 'Pódkakosći',
	'smw_subpropertyarticlecount' => 'Toś ta kakosć ma {{PLURAL:$1|slědujucu pódkakosć|slědujucej $1 pódkakosći|slědujuce $1 pódkakosći|slědujucych $1 pódkakosćow}}:',
	'smw_concept_header' => 'Boki koncepta "$1"',
	'smw_conceptarticlecount' => '$1 {{PLURAL:$|bok se pokazujo|boka se pokazujotej|boki se pokazuju|bokow se pokazujo}}, {{PLURAL:$1|kótaryž słuša|kótarejž słušatej|kótarež słušaju|kótarež słušaju}} k tomu konceptoju.',
	'exportrdf' => 'Boki ako RDF eksportěrowaś',
	'smw_exportrdf_docu' => 'Toś ten bok śi dowólujo, daty z boka w formaśe RDF dobyś.
Aby boki eksportěrował, zapódaj titele do slědujucego tekstowego póla, jaden titel na smužku.',
	'smw_exportrdf_recursive' => 'Wšykne pśiwuzne boki rekursiwnje eksportěrowaś.
Źiwaj na to, až wuslědk by mógł wjeliki byś!',
	'smw_exportrdf_backlinks' => 'Teke wšykne boki eksportěrowaś, kótarež póśěgaju se na eksportěrowane boki.
Napórajo RDF, kótaryž dajo se pśepytaś.',
	'smw_exportrdf_lastdate' => 'Boki njeeksportěrowaś, kótarež njejsu se změnili wót pódanego casa.',
	'smw_exportrdf_submit' => 'Eksportěrowaś',
	'properties' => 'Kakosći',
	'smw_properties_docu' => 'Slědujuce kakosći wužywaju se we wikiju.',
	'smw_property_template' => '$1 typa $2 ($3)',
	'smw_propertylackspage' => 'Wše kakosći měli se pśez bok wopisaś!',
	'smw_propertylackstype' => 'Za toś tu kakosć njejo se žeden typ pódał (mysli se tuchylu typ $1).',
	'smw_propertyhardlyused' => 'Toś ta kakosć se lěbda we wikiju wužywa!',
	'unusedproperties' => 'Njewužywane kakosći',
	'smw_unusedproperties_docu' => 'Slědujuce kakosći eksistěruju, lěcrownož žeden drugi bok je njewužywa.',
	'smw_unusedproperty_template' => '$1 typa $2',
	'wantedproperties' => 'Póžedane kakosći',
	'smw_wantedproperties_docu' => 'Slědujuce kakosći se we wikiju wužywaju, ale hyšći njamaju  bok, kótaryž je wopisujo.',
	'smw_wantedproperty_template' => '$1 ({{PLURAL:$2|raz|dwójcy|$2 raze|$2 raz}} wužyta)',
	'tooltip-purge' => 'Wše wótpšašanja a pśedłogi na toś tom boku aktualizěrowaś',
	'smw_purge' => 'Aktualizěrowaś',
	'types' => 'Typy',
	'smw_types_docu' => 'Slědujo lisćina wšych datowych typow, kótarež daju se kakosćam pśipokazaś.
Kuždy datowy typ ma bok, źož daju se pśidatne informacije pódaś.',
	'smw_typeunits' => 'Měrjeńske jadnotki typa "$1": $2',
	'semanticstatistics' => 'Semantiska statistika',
	'smw_semstats_text' => "Toś ten wiki wopśimujo '''$1''' {{PLURAL:$1|kakosćowu gódnotu|kakosćowej gódnośe|kakosćowe gódnoty|kakosćowych gódnotow}} za dogromady '''$2''' [[Special:Properties|{{PLURAL:$2|kakosć|rozdźělnej kakosći|rozdźělne kakosći|rozdźělnych kakosćow}}]].
'''$3''' {{PLURAL:$3|kakosć ma|kakosći matej|kakosći maju|kakosćow ma}} swójski bok a póžedany datowy typ je za '''$4''' z nich pódany.
Někotare eksistěrowacych kakosćow by mógli [[Special:UnusedProperties|njewužywane kakosći]] byś. Kakosći, kótarež njamaju bok, su se na [[Special:WantedProperties|lisćinje póžedanych kakosćow]] namakali.",
	'uriresolver' => 'Rezolwer URI',
	'smw_uri_doc' => 'Rezolwer URI implementěrujo <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>.
Stara se za to, až luźe njebudu websedła.',
	'ask' => 'Semantiske pytanje',
	'smw_ask_sortby' => 'Pó słupje sortěrowaś (opcionalny)',
	'smw_ask_ascorder' => 'Stupajucy',
	'smw_ask_descorder' => 'Spadujucy',
	'smw_ask_submit' => 'Wuslědki namakaś',
	'smw_ask_editquery' => '[Wótpšašanje wobźěłaś]',
	'smw_add_sortcondition' => '[Sortěrowańske wuměnjenje pśidaś]',
	'smw_ask_hidequery' => '[Wótpšašanje schowaś]',
	'smw_ask_help' => 'Wótpšašowańska pomoc',
	'smw_ask_queryhead' => 'Wótpšašanje',
	'smw_ask_printhead' => 'Pśidatne daty, kótarež maju se zwobrazniś',
	'smw_ask_printdesc' => '(pśidaj jadne atributowe mě na smužku)',
	'smw_ask_format_as' => 'Formatěrowaś ako:',
	'smw_ask_defaultformat' => 'standard',
	'smw_ask_otheroptions' => 'Druge opcije',
	'smw_ask_show_embed' => 'Zasajźony kod pokazaś',
	'smw_ask_hide_embed' => 'Zasajźony kod schowaś',
	'smw_ask_embed_instr' => 'Aby toś to wótpšašanje do wikiboka zasajźił, wužyj slědujucy kod.',
	'searchbyproperty' => 'Pó kakosći pytaś',
	'smw_sbv_docu' => 'Wšykne boki pytaś, kótarež maju wěstu kakosć a gódnotu.',
	'smw_sbv_novalue' => 'Zapódaj płaśiwu gódnotu za kakosć abo woglědaj se wšykne gódnoty za kakosć "$1".',
	'smw_sbv_displayresult' => 'Lisćina wšych bokow, kótarež maju kakosć "$1" z gódnotu "$2"',
	'smw_sbv_displayresultfuzzy' => 'Lisćina wšych bokow, kótarež maju kakosć "$1" z gódnotu "$2".
Dokulaž jo jano mało wuslědkow było, zwobraznjuju se pódobne gódnoty.',
	'smw_sbv_property' => 'Kakosć:',
	'smw_sbv_value' => 'Gódnota:',
	'smw_sbv_submit' => 'Wuslědki namakaś',
	'browse' => 'Wiki pśepytaś',
	'smw_browselink' => 'Kakosći pśepytaś',
	'smw_browse_article' => 'Zapódaj mě boka, wót kótaregož ma se pytaś.',
	'smw_browse_go' => 'Pytaś',
	'smw_browse_show_incoming' => 'Kakosći pokazaś, kótarež sem wótkazuju',
	'smw_browse_hide_incoming' => 'Kakosći schowaś, kótarež sem wótkazuju',
	'smw_browse_no_outgoing' => 'Toś ten bok njama kakosći.',
	'smw_browse_no_incoming' => 'Žedne kakosći njewótkazuju k toś tomu bokoju.',
	'smw_inverse_label_default' => '$1 wót',
	'smw_inverse_label_property' => 'Pomjenjenje nawopacneje kakosći',
	'pageproperty' => 'Pytanje za bokoweju kakosću',
	'smw_pp_docu' => 'Wše gódnoty kakosći na pódanem boku pytaś.
Zapódaj ako bok tak teke kakosć.',
	'smw_pp_from' => 'Wót boka',
	'smw_pp_type' => 'Kakosć',
	'smw_pp_submit' => 'Wuslědki namakaś',
	'smw_result_prev' => 'Slědk',
	'smw_result_next' => 'Pśiducy',
	'smw_result_results' => 'Wuslědki',
	'smw_result_noresults' => 'Žedne wuslědki.',
	'smwadmin' => 'Administratorowe funkcije za Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Składowański rum za Semantic MediaWiki nastajiś',
	'smw_smwadmin_setupsuccess' => 'Składowańska jadnotka jo se wuspěšnje nastajiła.',
	'smw_smwadmin_return' => 'Slědk k $1',
	'smw_smwadmin_updatestarted' => 'Nowy aktualizěrowański proces za wótnowjenje semantiskich datow jo se startował.
Wšykne skłaźone daty budu se znowego natwarjaś abo pórěźaś, źož trjeba.
Móžoš póstupoju aktualizacije na toś tom specialnem boku slědowaś.',
	'smw_smwadmin_updatenotstarted' => 'Proces aktualizacije južo běžy.
Nowy se njestartujo.',
	'smw_smwadmin_updatestopped' => 'Wše eksistěrujuce aktualizěrowańske procese su se zastajili.',
	'smw_smwadmin_updatenotstopped' => 'Aby běžecy proces zastajił, musyš kontrolowy kašćik aktiwěrowaś, aby pódał, až sy napšawdu wěsty.',
	'smw_smwadmin_docu' => 'Toś ten specialny bok śi pomaga za instalaciju a aktualizaciju a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>. Mysli se na zawěsćenje gódnotnych datow, nježli až wuwjeźoš administratiwne funkcije.',
	'smw_smwadmin_db' => 'Instalacija a aktualizacija datoweje banki',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki trjeba rozšyrjenja za datowu banku MediaWiki, aby semantiske daty składował. Slědujuca funkcija zawěsćijo, až twója datowa banka se pórědnje zarědujo.
Změny, kótarež cynje se w toś tom kšacu, njewobwliwuju zbytk datoweje banki MediaWiki a daju se lažko anulěrowaś, jolic póžedane.
Toś te zarědowańska funkcija móžo se někotare razy wugbaś, mimo až zawinuju škódu, ale jo trěbna jano jaden raz pśi instalaciji abo aktualizaciji.',
	'smw_smwadmin_permissionswarn' => 'Jolic operacija raźi se z SQL-zmólkami, wužywaŕ datoweje banki, kótaregož twój wiki wužywa (skontrolěruj twóju dataja LocalSettings.php), nejskerjej njama dosegajuce pšawa.
Pak zwól toś tomu wužywarjeju pśidatne pšawa za napóranje a lašowanje tabelow, zapódaj nachylu twójo admininistratorowe wužywarske mě w LocalSettings.php, pak wužyj wótglědowański skript <tt>SMW_setup.php</tt>, kótarež mógu wósobinske pódaśa z dataje AdminSettings.php wužywaś.',
	'smw_smwadmin_dbbutton' => 'Tabele inicializěrowaś abo aktualizěrowaś',
	'smw_smwadmin_announce' => 'Twój wiki pśipowěźeś',
	'smw_smwadmin_announcedocu' => 'Semantic Mediawiki ma websłužbu za wuzjawjenje nowych semantiskich wikisedłow.
To se wužywa, aby wuźaržowało lisćinu zjawnych sedłow, kótarež wužywaju Semantic MediaWiki, głownje aby  pomagało <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projektoju Semantic MediaWiki</a> pśeglěd typiskich wužywanjow Semantic MediaWiki daś.
Glědaj startowy bok Semantic MediaWiki za <a href="http://semantic-mediawiki.org/wiki/Registry">dalšne informacije wó toś tej słužbje</a>.',
	'smw_smwadmin_announcebutton' => 'Tłoc na slědujucy tłocašk, aby pósłał swój wikiijowy URL k tej słužbje.
Słužba njebuźo wikije registrěrowaś, kótarež njejsu zjawnje pśistupne a buźo pśistupne informacije jano zjawnje składowaś.',
	'smw_smwadmin_datarefresh' => 'Reparatura a aktualizacija datow',
	'smw_smwadmin_datarefreshdocu' => 'Jo móžno, wšykne daty Semantic MediaWiki wótnowiś, kótarež bazěruju na aktualnem wopśimjeśu wikija.
To móžo wužytne byś, aby se wobškóźone daty pórěźili abo daty aktualizěrowali, jolic interny format jo se změnił pśez aktualizaciju softwara.
Aktualizacija pśewjedujo se bok pó boku a njebuźo se ned kóńcyś.
Slědujuce pokazujo, lěc aktualizacija rowno wótběgujo a dowólujo śi aktualizacije startowaś abo zastajiś (snaźkuli toś ta funkcija jo se wót administratora sedła znjemóžniła).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Aktualizacija se rowno wótměwa.</strong>
Jo normalne, až aktualizacija jano pómałem póstupujo, dokulaž aktualizěrujo daty jano w małych porcijach kuždy raz, gaž wužywaŕ ma pśistup na wiki.
Aby skóńcył toś tu aktualizaciju malsnjeje, móžoš wótwardowański skript MediaWiki <tt>runJobs.php</tt> zawołaś (wužyj opciju <tt>--maxjobs 1000</tt>, aby wobgranicował licbu aktualizacijow, kótarež se naraz pśewjadu).
Licony póstup aktualneje aktualizacije:',
	'smw_smwadmin_datarefreshbutton' => 'Aktualizaciju datow zachopiś',
	'smw_smwadmin_datarefreshstop' => 'Toś tu aktualizaciju zastajiś',
	'smw_smwadmin_datarefreshstopconfirm' => 'Jo, som se wěsty.',
	'smw_smwadmin_support' => 'Pódpěru wobstaraś',
	'smw_smwadmin_supportdocu' => 'Wšake resurse mógli śi w paźe problemow pomagaś:',
	'smw_smwadmin_installfile' => 'Joli maš problemy ze swójeju instalaciju, pśecytaj směrnice w dataji <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Dopołna wužywarska dokumentacija za Semantic MediaWiki jo na <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Zmólki daju se na <a href="https://bugzilla.wikimedia.org/">Bugzilla</a> k wěsći daś.',
	'smw_smwadmin_questions' => 'Jolic maš dalšne pšašanja abo naraźenja, pśizamkni se diskusiji na <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">wužywarskem forumje Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Datowa struktura',
	'smw_adminlinks_displayingdata' => 'Daty zwobrazniś',
	'smw_adminlinks_inlinequerieshelp' => 'Pomoc k wótpšašanjam',
);

/** Greek (Ελληνικά)
 * @author Consta
 * @author Crazymadlover
 * @author Lou
 * @author Omnipaedista
 * @author ZaDiak
 */
$messages['el'] = array(
	'smw_edithelp' => 'Επεξεργασία βοήθειας στις ιδιότητες',
	'smw_viewasrdf' => 'Ροή RDF',
	'smw_finallistconjunct' => ', και',
	'smw_factbox_head' => 'Γεγονότα για $1',
	'smw_isspecprop' => 'Αυτή η ιδιότητα είναι μια ειδική ιδιότητα σε αυτό το βίκι.',
	'smw_concept_description' => 'Περιγραφή του κόνσεπτ "$1"',
	'smw_printername_auto' => 'Αυτόματα',
	'smw_printername_count' => 'Αποτελέσματα μέτρησης',
	'smw_printername_csv' => 'Εξαγωγή CSV',
	'smw_printername_debug' => 'Αίτημα εκσφαλμάτωσης (για ειδικούς)',
	'smw_printername_embedded' => 'Ενσωμάτωση περιεχομένων σελίδων',
	'smw_printername_json' => 'Εξαγωγή JSON',
	'smw_printername_list' => 'Λίστα',
	'smw_printername_ol' => 'Αριθμοποίηση',
	'smw_printername_ul' => 'Αντικειμενοποίηση',
	'smw_printername_rss' => 'Εξαγωγή RSS',
	'smw_printername_table' => 'Πίνακας',
	'smw_printername_broadtable' => 'Πίνακας Επιτροπής',
	'smw_printername_template' => 'Πρότυπο',
	'smw_paramdesc_embedonly' => 'Μη εμφάνιση επικεφαλίδων',
	'smw_iq_moreresults' => '... περισσότερα αποτελέσματα',
	'smw_emptystring' => 'Κενές συμβολοσειρές δεν γίνονται δεκτές.',
	'smw_true_words' => 'αλήθεια,α,ναι,ν',
	'smw_false_words' => 'σφάλμα,σ,όχι,ο',
	'smw_nofloat' => 'Το "$1" δεν είναι αριθμός',
	'smw_nodatetime' => 'Η ημερομηνία "$1" δεν έγινε κατανοητή.',
	'smw_badtitle' => 'Ο "$1" δεν είναι έγκυρος τίτλος σελίδας.',
	'smw_type_header' => 'Ιδιότητες του τύπου "$1"',
	'smw_attribute_header' => 'Σελίδες που χρησιμοποιούν την ιδιότητα "$1"',
	'smw_subproperty_header' => 'Υποϊδιότητες',
	'smw_concept_header' => 'Σελίδες του κόνσεπτ "$1"',
	'exportrdf' => 'Εξαγωγή σελίδων στο RDF',
	'smw_exportrdf_submit' => 'Εξαγωγή',
	'properties' => 'Ιδιότητες',
	'smw_property_template' => '$1 του τύπου $2 ($3)',
	'unusedproperties' => 'Αχρησιμοποίητες ιδιότητες',
	'smw_unusedproperty_template' => '$1 του τύπου $2',
	'wantedproperties' => 'Επιθυμητές ιδιότητες',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|χρήση|χρήσεις}})',
	'smw_purge' => 'Ανανέωση',
	'types' => 'Τύποι',
	'semanticstatistics' => 'Σημασιολογικά στατιστικά',
	'uriresolver' => 'Επιλύτης URI',
	'ask' => 'Σημασιολογική αναζήτηση',
	'smw_ask_sortby' => 'Κατάταξη βάσει στήλης (προαιρετικό)',
	'smw_ask_ascorder' => 'Αύξουσα',
	'smw_ask_descorder' => 'Φθίνουσα',
	'smw_ask_submit' => 'Αναζήτηση αποτελεσμάτων',
	'smw_ask_editquery' => '[Επεξεργασία αιτήματος]',
	'smw_add_sortcondition' => '[Προσθήκη κατατακτικού όρου]',
	'smw_ask_hidequery' => 'Απόκρυψη αιτήματος',
	'smw_ask_help' => 'Βοήθεια σχετικά με αίτημα',
	'smw_ask_queryhead' => 'Αίτημα',
	'smw_ask_printhead' => 'Πρόσθετα δεδομένα προς εμφάνιση',
	'smw_ask_format_as' => 'Μορφοποίηση ως:',
	'smw_ask_defaultformat' => 'Προεπιλογή',
	'smw_ask_otheroptions' => 'Άλλες επιλογές',
	'smw_ask_show_embed' => 'Εμφάνιση ενσωματωμένου κώδικα',
	'smw_ask_hide_embed' => 'Απόκρυψη ενσωματωμένου κώδικα',
	'searchbyproperty' => 'Αναζήτηση κατά ιδιότητα',
	'smw_sbv_property' => 'Ιδιότητα:',
	'smw_sbv_value' => 'Τιμή:',
	'smw_sbv_submit' => 'Αναζήτηση αποτελεσμάτων',
	'browse' => 'Πλοήγηση στο βίκι',
	'smw_browselink' => 'Πλοήγηση στις ιδιότητες',
	'smw_browse_go' => 'Πήγαινε',
	'smw_browse_show_incoming' => 'εμφάνιση ιδιοτήτων που συνδέουν εδώ',
	'smw_browse_hide_incoming' => 'απόκρυψη ιδιοτήτων που συνδέουν εδώ',
	'smw_inverse_label_default' => '$1 από',
	'pageproperty' => 'Αναζήτηση ιδιότητας σελίδας',
	'smw_pp_from' => 'Από τη σελίδα',
	'smw_pp_type' => 'Ιδιότητα',
	'smw_pp_submit' => 'Αναζήτηση αποτελεσμάτων',
	'smw_result_prev' => 'Προηγούμενος',
	'smw_result_next' => 'Επόμενο',
	'smw_result_results' => 'Αποτελέσματα',
	'smw_result_noresults' => 'Συγνώμη, δεν υπάρχουν αποτελέσματα.',
	'smw_smwadmin_return' => 'Επιστροφή στην $1',
	'smw_smwadmin_updatestopped' => 'Όλες οι υπάρχουσες εργασίες ενημέρωσης έχουν διακοπεί.',
	'smw_smwadmin_db' => 'Εγκατάσταση βάσεως δεδομένων και αναβάθμιση',
	'smw_smwadmin_dbbutton' => 'Αρχικοποίηση ή αναβάθμιση πινάκων',
	'smw_smwadmin_announce' => 'Ανακοίνωση του βίκι σας',
	'smw_smwadmin_datarefresh' => 'Επιδιόρθωση και αναβάθμιση δεδομένων',
	'smw_smwadmin_datarefreshbutton' => 'Έναρξη ενημέρωσης δεδομένων',
	'smw_smwadmin_datarefreshstop' => 'Σταμάτα αυτή την ενημέρωση',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ναι, είμαι σίγουρος.',
	'smw_smwadmin_support' => 'Παίρνοντας υποστήριξη',
	'smw_smwadmin_supportdocu' => 'Διάφορες πηγές ενδέχεται να σας βοηθήσουν σε περίπτωση που αντιμετωπίζετε προβλήματα:',
	'smw_adminlinks_datastructure' => 'Δομή δεδομένων',
	'smw_adminlinks_displayingdata' => 'Προβαλλόμενα δεδομένα',
	'smw_adminlinks_inlinequerieshelp' => 'Βοήθεια με τα αιτήματα',
);

/** British English (British English)
 * @author Reedy
 */
$messages['en-gb'] = array(
	'smw_printername_ul' => 'Itemisation',
	'smw_noboolean' => '"$1" is not recognised as a Boolean (true/false) value.',
);

/** Esperanto (Esperanto)
 * @author Michawiki
 * @author Yekrats
 */
$messages['eo'] = array(
	'smw_edithelp' => 'Helpo pri redaktado de ecoj',
	'smw_viewasrdf' => 'RDF-fonto',
	'smw_finallistconjunct' => ', kaj',
	'smw_factbox_head' => 'Faktoj pri $1',
	'smw_isspecprop' => 'Ĉi tiu eco estas speciala eco en ĉi tiu vikio.',
	'smw_isknowntype' => 'Ĉi tiu datumtipo estas inter la normaj datumtipoj de ĉi tiu vikio.',
	'smw_isaliastype' => 'Ĉi tiu datumtipo estas kromnomo por la datumtipo "$1".',
	'smw_isnotype' => 'Ĉi tiu datumtipo "$1" ne estas norma datumtipo en la vikio, kaj ne estis donita difino de uzanto.',
	'smw_concept_description' => 'Priskribo de koncepto "$1"',
	'smw_no_concept_namespace' => 'Konceptoj povas nur esti difinita en paĝoj en la nomspaco Concept:.',
	'smw_baduri' => 'Bedaŭrinde, URI-oj de la kamparo "$1" ne estas permesita.',
	'smw_printername_auto' => 'Aŭtomata',
	'smw_printername_csv' => 'CSV-eksporto',
	'smw_printername_list' => 'Listo',
	'smw_printername_rss' => 'RSS-eksporti',
	'smw_printername_table' => 'Tabelo',
	'smw_printername_broadtable' => 'Larĝa tabelo',
	'smw_printername_template' => 'Ŝablono',
	'smw_iq_disabled' => 'Bedaŭrinde, semantikaj informmendoj estis malebligitaj por ĉi tiu vikio.',
	'smw_iq_moreresults' => '… pluaj rezultoj',
	'smw_iq_nojs' => 'Bonvolu uzi retumilon kiu povas montri JavaScript-on por rigardi ĉi tiun elementon.',
	'smw_iq_altresults' => 'Rigardu la rezulto-liston rekte.',
	'smw_unknown_importns' => 'Import-funkcioj ne estas uzeblaj por nomspaco "$1".',
	'smw_nonright_importtype' => '$1 nur eblas esti uzata por paĝoj en nomspaco "$2".',
	'smw_wrong_importtype' => '$1 ne eblas esti uzata por paĝoj en nomspaco "$2".',
	'smw_no_importelement' => 'Elemento "$1" ne estas havebla por importi.',
	'smw_parseerror' => 'La donata valoro ne estas komprenita.',
	'smw_notitle' => '"$1" ne eblas esti uzata kiel paĝnomo en ĉi tiu vikio.',
	'smw_unknowntype' => 'Nesubtenita datumtipo "$1" difinita por eco.',
	'smw_manytypes' => 'Pli ol unu tipo estas difinita por atributo.',
	'smw_emptystring' => 'Malplenaj ĉenoj ne estas akceptitaj.',
	'smw_maxstring' => 'Ĉena reprezentado $1 estas tro longa.',
	'smw_notinenum' => '"$1" ne estas en la listo de eblaj valoroj ($2) por ĉi tiu atributo.',
	'smw_noboolean' => '"$1" ne estas agnoskita kiel Bulea (vera/falsa) valoro.',
	'smw_true_words' => 'vera,v,jes,j',
	'smw_false_words' => 'falsa,f,ne,n',
	'smw_nofloat' => '"$1" ne estas nombro.',
	'smw_unsupportedprefix' => 'Prefiksoj por nombroj ("$1") ne estas subtenata.',
	'smw_nodatetime' => 'La dato "$1" ne estis komprenita.',
	'smw_toomanyclosing' => 'Verŝajne estas tro da okazoj de "$1" en la mendo.',
	'smw_misplacedsymbol' => 'La signo "$1" estis uzita en loko kie ĝi ne estas utila.',
	'smw_emptysubquery' => 'Iu submendo havas neniun validan kondiĉon.',
	'smw_overprintoutlimit' => 'La mendo enhavas tro da printadajn petojn.',
	'smw_badtitle' => 'Bedaŭrinde, "$1" ne estas valida paĝa titolo.',
	'smw_propvalueproblem' => 'La valoro de atributo "$1" ne estas komprenita.',
	'smw_type_header' => 'Atributoj de tipo "$1"',
	'smw_typearticlecount' => 'Montrante $1 {{PLURAL:$1|atributon|atributojn}} uzante ĉi tiun tipon.',
	'smw_attribute_header' => 'Paĝoj uzantaj atrubuton "$1"',
	'smw_subproperty_header' => 'Subatributoj',
	'smw_subpropertyarticlecount' => 'Ĉi tiu atributo havas la $1 {{PLURAL:$1|jenan subatributon|jenajn subatributojn}}.',
	'smw_concept_header' => 'Paĝoj de koncepto "$1"',
	'exportrdf' => 'Eksportu paĝojn al RDF',
	'smw_exportrdf_submit' => 'Eksporti',
	'properties' => 'Ecoj',
	'smw_properties_docu' => 'La jenaj ecoj estas uzataj en la vikio.',
	'smw_property_template' => '$1 de datumtipo $2 ($3)',
	'unusedproperties' => 'Neuzitaj ecoj',
	'smw_unusedproperty_template' => '$1 de datumtipo $2',
	'wantedproperties' => 'Volitaj ecoj',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uzo|uzoj}})',
	'smw_purge' => 'Refreŝigu',
	'types' => 'Datumtipoj',
	'smw_types_docu' => 'Jen listo de ĉiuj datentipoj kiu povas esti asignitaj al ecoj.
Ĉiu datentipo havas paĝon kie plua informo povas esti aldonita.',
	'semanticstatistics' => 'Semantikaj Statistikoj',
	'ask' => 'Semantika serĉo',
	'smw_ask_sortby' => 'Ordigi laŭ kolumnoj (nedevige)',
	'smw_ask_submit' => 'Trovu rezultojn',
	'smw_ask_editquery' => '[Redaktu serĉomendo]',
	'smw_add_sortcondition' => '[Aldoni ordigan kondiĉon]',
	'smw_ask_hidequery' => 'Kaŝi serĉmendon',
	'smw_ask_help' => 'Helpo pri serĉomendoj',
	'smw_ask_queryhead' => 'Serĉomendo',
	'smw_ask_format_as' => 'Formati kiel:',
	'smw_ask_defaultformat' => 'defaŭlta',
	'smw_ask_otheroptions' => 'Aliaj opcioj',
	'smw_ask_show_embed' => 'Montri enkorpigitan kodon',
	'smw_ask_hide_embed' => 'Kaŝi enkorpigitan kodon',
	'searchbyproperty' => 'Serĉu laŭ eco',
	'smw_sbv_property' => 'Eco:',
	'smw_sbv_value' => 'Valoro:',
	'smw_sbv_submit' => 'Trovu rezultojn',
	'browse' => 'Foliumi vikion',
	'smw_browselink' => 'Trovidi atributojn',
	'smw_browse_article' => 'Enigi la nomon de la paĝo por komenci retumadon.',
	'smw_browse_go' => 'Ek',
	'smw_browse_show_incoming' => 'malkaŝi ecojn kiu enligiĝas ĉi tien',
	'smw_browse_hide_incoming' => 'kaŝi ecojn kiu enligiĝas ĉi tien',
	'smw_browse_no_outgoing' => 'Ĉi tiu paĝo havas neniujn atributojn.',
	'smw_browse_no_incoming' => 'Neniuj atributojn ligas al ĉi tiun paĝon.',
	'smw_inverse_label_default' => '$1 el',
	'smw_inverse_label_property' => 'Inversa atributa etikedo',
	'pageproperty' => 'Serĉo de paĝaj ecoj',
	'smw_pp_from' => 'De paĝo',
	'smw_pp_type' => 'Eco',
	'smw_pp_submit' => 'Trovu rezultojn',
	'smw_result_prev' => 'Antaŭe',
	'smw_result_next' => 'Sekve',
	'smw_result_results' => 'Rezultoj',
	'smw_result_noresults' => 'Bedaŭrinde, neniuj rezultoj',
	'smwadmin' => 'Administradaj funkcioj por Semantic MediaWiki',
	'smw_smwadmin_return' => 'Reiri al $1',
	'smw_smwadmin_db' => 'Datenbaza instalado kaj promociado',
	'smw_smwadmin_announce' => 'Anonci vian vikion',
	'smw_smwadmin_datarefreshstop' => 'Halti ĉi tiun ĝisdatigon',
	'smw_smwadmin_datarefreshstopconfirm' => 'Jes, mi certas.',
	'smw_smwadmin_support' => 'Teni subtenon',
	'smw_smwadmin_mediazilla' => 'Cimoj povas esti raportitaj al <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_adminlinks_datastructure' => 'Datumstrukturo',
);

/** Spanish (Español)
 * @author Antur
 * @author Carmen Jorge García-Reyes
 * @author Crazymadlover
 * @author Dvdgmz
 * @author Imre
 * @author Javier Calzada Prado
 * @author Locos epraix
 * @author Sanbec
 * @author Translationista
 */
$messages['es'] = array(
	'smw-desc' => "Haciendo tu wiki más accesible - para máquinas ''y'' humanos ([http://semantic-mediawiki.org/wiki/Help:User_manual documentación en línea])",
	'smw_edithelp' => 'Ayuda a la redacción de relaciones y atributos',
	'smw_viewasrdf' => 'Ver como RDF',
	'smw_finallistconjunct' => ' y',
	'smw_factbox_head' => 'Hechos relativos a à $1 — Búsqueda de páginas similares con <span class="smwsearchicon">+</span>.',
	'smw_isspecprop' => 'Esta propiedad en una propiedad especial en este wiki.',
	'smw_isknowntype' => 'Este tipo está entre los tipos de datos standar de este wiki.',
	'smw_isaliastype' => 'Este tipo es un alias para el tipo de datos "$1".',
	'smw_isnotype' => 'El tipo "$1" no es un tipo de datos estándar en el wiki y tampoco se le ha otorgado una definición de usuario.',
	'smw_concept_description' => 'Descripción del concepto "$1"',
	'smw_no_concept_namespace' => 'Conceptos solo pueden ser definidos en páginas en el Concept: espacio de nombre.',
	'smw_multiple_concepts' => 'Cada página de concepto solamente puede tener una definición de concepto.',
	'smw_concept_cache_miss' => 'El concepto "$1" no puede ser utilizado en este momento, ya que la configuración wiki exige que sea computado sin conexión.
Si el problema persiste después de pasado algún tiempo, solicita al administrador de tu sitio que haga este concepto disponible.',
	'smw_noinvannot' => 'Los valores no pueden asignarse a propiedades inversas.',
	'smw_baduri' => 'Lo sentimos. Las URIs del dominio $1 no están disponibles en este emplazamiento',
	'smw_printername_auto' => 'Automático',
	'smw_printername_count' => 'Contar resultados',
	'smw_printername_csv' => 'Exporta CSV',
	'smw_printername_debug' => 'Depura requerimiento (para expertos)',
	'smw_printername_embedded' => 'Incluye contenido de la página',
	'smw_printername_json' => 'Exportar JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'enumeración',
	'smw_printername_ul' => 'Itemización',
	'smw_printername_rss' => 'Exportar RSS',
	'smw_printername_table' => 'Tabla',
	'smw_printername_broadtable' => 'Tabla ancha',
	'smw_printername_template' => 'Plantilla',
	'smw_paramdesc_limit' => 'La cantidad máxima de resultados a devolver',
	'smw_paramdesc_headers' => 'Muestra los nombres de encabezados/propiedades',
	'smw_paramdesc_mainlabel' => 'La etiqueta a asignar al nombre de la página principal',
	'smw_paramdesc_link' => 'Mostrar los valores como vínculos',
	'smw_paramdesc_intro' => 'El texto a mostrar antes de los resultados de la consulta, si los hubiere',
	'smw_paramdesc_outro' => 'El texto a mostrar después de los resultados de la consulta, si los hubiere',
	'smw_paramdesc_default' => 'El texto a mostrar si no hay resultados de consulta',
	'smw_paramdesc_searchlabel' => 'El texto en el vínculo de los resultados',
	'smw_paramdesc_sep' => 'El separador para los valores',
	'smw_paramdesc_template' => 'El nombre de la plantilla con la que se mostrará la vista de impresión',
	'smw_paramdesc_columns' => 'El número de columnas donde se muestran los resultados (el predeterminado es $1)',
	'smw_paramdesc_embedformat' => 'La etiqueta HTML usada para definir encabezados',
	'smw_paramdesc_embedonly' => 'No mostrar encabezados',
	'smw_paramdesc_rsstitle' => 'Texto a ser usado como título del canal',
	'smw_paramdesc_rssdescription' => 'Texto a ser usado como descripción del canal',
	'smw_iq_disabled' => 'Lo sentimos. Las búsquedas en los artículos de este wiki no están autorizadas.',
	'smw_iq_moreresults' => '&hellip; siguientes resultados',
	'smw_iq_nojs' => 'Use un navegador con JavaScript habilitado para ver este elemento.',
	'smw_iq_altresults' => 'Explorar la lista de resultados directamente.',
	'smw_unknown_importns' => 'Ninguna función de importación está disponible para el espacio de nombres "$1".',
	'smw_nonright_importtype' => 'El elemento "$1" no puede ser empleado más que para los artículos del espacio de nombres "$2".',
	'smw_wrong_importtype' => 'El elemento "$1" no puede ser utilizado para los artículos del espacio de nombres dominio "$2".',
	'smw_no_importelement' => 'El elemento "$1" no está disponible para la importación.',
	'smw_parseerror' => 'El valor dado no fue entendido.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '"$1" no puede ser usada como nombre de página en este wiki.',
	'smw_wrong_namespace' => 'Solamente paginas en espacio de nombre "$1" estan permitidas aqui.',
	'smw_unknowntype' => 'El tipo de datos "$1" no soportado ha sido devuelto al atributo.',
	'smw_manytypes' => 'Demasiados tipos de datos han sido asignados al atributo.',
	'smw_emptystring' => 'No se aceptan cadenas vacías.',
	'smw_maxstring' => 'La representación de la cadena $1 es demasiado grande.',
	'smw_notinenum' => '"$1" no esta en la lista de posibles valores ($2) para este atributo.',
	'smw_noboolean' => '"$1" no es reconocido como un valor booleano (verdadero/falso).',
	'smw_true_words' => 'verdadero,t,si,s,true',
	'smw_false_words' => 'falso,f,no,n,false',
	'smw_nofloat' => '"$1" no es un número.',
	'smw_infinite' => 'números tan largos como $1 no son soportados.',
	'smw_infinite_unit' => 'La conversión en la unidad $1 resultó en un número que es demasiado largo.',
	'smw_novalues' => 'No se ha especificado valores.',
	'smw_unsupportedprefix' => 'prefijos ("$1") no esta soportados actualmente',
	'smw_unsupportedunit' => 'La conversión de la unidad "$1" no está soportada',
	'smw_nodatetime' => 'La fecha «$1» no ha sido comprendida.',
	'smw_toomanyclosing' => 'Parece haber demasiadas coincidencias de "$1" en la solicitud.',
	'smw_noclosingbrackets' => 'Algún uso de "<nowiki>[[</nowiki>" en su consulta no está cerrado por "]]" coincidentes.',
	'smw_misplacedsymbol' => 'El símbolo "$1" se ha usado en un lugar donde no es de utilidad.',
	'smw_unexpectedpart' => 'La parte "$1" de la consulta no fue entendida.
Los resultados podrían no ser como esperabas.',
	'smw_emptysubquery' => 'Alguna subconsulta no tiene condición válida.',
	'smw_misplacedsubquery' => 'Alguna subconsulta fue usada en un lugar donde las subconsultas no están permitidas.',
	'smw_valuesubquery' => 'Subconsultas no soportadas para valores de propiedad "$1".',
	'smw_overprintoutlimit' => 'La consulta contiene demasiados requerimientos de impresión.',
	'smw_badprintout' => 'Alguna declaración de impresión de la consulta se ha perdido.',
	'smw_badtitle' => '"$1" no es un título de página válido.',
	'smw_badqueryatom' => 'Alguna parte "<nowiki>[[…]]</nowiki>" de la interrogante no fue entendida.',
	'smw_propvalueproblem' => 'El valor de propiedad "$1" no fue entendida.',
	'smw_noqueryfeature' => 'Alguna característica de la consulta no tiene soporte en esta wiki, y parte de ella se ha eliminado ($1).',
	'smw_noconjunctions' => 'Las conjunciones no tienen soporte en esta wiki: parte de la consulta se ha eliminado ($1).',
	'smw_nodisjunctions' => 'Las disjunciones en consultas no tienen soporte en esta wiki: parte de la consulta se ha eliminado ($1).',
	'smw_querytoolarge' => 'Las siguientes condiciones de consulta no podrían ser consideradas debido a las restricciones de los wikia en tamaño o profundidad de consultas: $1.',
	'smw_devel_warning' => 'Esta función está aún en desarrollo y quizá aun no sea operativa. Es quizá recomendable hacer una copia de seguridad del wiki antes de utilizar esta función.',
	'smw_notemplategiven' => 'Proveer un valor para el parámetro "plantilla" para este formato de consulta para funcionar.',
	'smw_type_header' => 'Atributos de tipo “$1”',
	'smw_typearticlecount' => 'Mostrando {{PLURAL:$1|un atributo|$1 atributos}} usando este tipo.',
	'smw_attribute_header' => 'Paginas usando el atributo “$1”',
	'smw_attributearticlecount' => 'Mostrando {{PLURAL:$1|una página|$1 páginas}} que {{PLURAL:$1|usa|usan}} esta propiedad.',
	'smw_subproperty_header' => 'Subpropiedades',
	'smw_subpropertyarticlecount' => 'Esta propiedad tiene las siguientes $1 {{PLURAL:$1|subpropiedad|subpropiedades}}:',
	'smw_concept_header' => 'Páginas de concepto "$1"',
	'smw_conceptarticlecount' => 'Mostrando $1 {{PLURAL:$1|página|páginas}} pertenecientes al concepto.',
	'exportrdf' => 'Exportar el artículo como RDF',
	'smw_exportrdf_docu' => ' En esta página, las partes de contenido de un artículo pueden ser exportadas a formato RDF. Introduzca el nombre de las páginas deseadas en el cuadro de texto que se encuentra debajo, <i>un nombre por línea </i>.<p/>',
	'smw_exportrdf_recursive' => 'Exportar igualmente todas las páginas pertinentes de forma recurrente. Esta posibilidad puede conseguir un gran número de resultados !',
	'smw_exportrdf_backlinks' => 'Exportar igualmente todas las páginas que reenvían a páginas exportadas. Resulta un RDF en el que se facilita la navegación.',
	'smw_exportrdf_lastdate' => 'No exportar páginas que no fueron cambiadas desde el punto dado en el tiempo.',
	'smw_exportrdf_submit' => 'Exportar',
	'properties' => 'Propiedades',
	'smw_properties_docu' => 'Las siguientes propiedades son usadas en el Wiki.',
	'smw_property_template' => '$1 de tipo $2 ($3)',
	'smw_propertylackspage' => 'Todas las propiedades deberían ser descritas por una página!',
	'smw_propertylackstype' => 'Ningún tipo fue especificada para esta propiedad (asumiendo tipo $1 por ahora).',
	'smw_propertyhardlyused' => 'Esta propiedad es dificilmente usada dentro del wiki!',
	'unusedproperties' => 'Propiedades no usadas',
	'smw_unusedproperties_docu' => 'Las siguientes propiedades existen a pesar que ninguna otra página haga uso de ellas.',
	'smw_unusedproperty_template' => '$1 de tipo $2',
	'wantedproperties' => 'Propiedades no usadas',
	'smw_wantedproperties_docu' => 'Las siguientes propiedades son usadas en el wiki pero no tienen aún una página para describirlas.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uso|usos}})',
	'tooltip-purge' => 'Volver a actualizar todas las búsquedas y borradores de esta página.',
	'smw_purge' => 'Volver a actualizar',
	'types' => 'Tipos de datos',
	'smw_types_docu' => 'Los tipos de datos siguientes pueden ser asignados a los atributos. Cada tipo de datos tiene su propio artículo, en el que puede figurar información más precisa.',
	'smw_typeunits' => 'Unidades de medida de tipo "$1": $2',
	'semanticstatistics' => 'Estadísticas de semántica',
	'smw_semstats_text' => "Esta wiki contiene '''$1''' {{PLURAL:$1|valor de propiedad|valores de propiedades}} sobre un total de '''$2''' [[Special:Properties|{{PLURAL:$2|propiedad|propiedades diferentes}}]].
'''$3''' {{PLURAL:$3|propiedad tiene|propiedades tienen}} su propia página, y el tipo de datos previstos se ha especificado para '''$4''' de ellas.
Algunas de las propiedades existentes pueden estar [[Special:UnusedProperties|sin uso]].
Las propiedades faltantes pueden encontrarse en la [[Special:WantedProperties|lista de propiedades requeridas]].",
	'uriresolver' => 'Traductor de URI',
	'smw_uri_doc' => 'El traductor de URI implementa <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>. Esto se preocupa de cosas que los humanos no lo hacen en los sitios web..',
	'ask' => 'Búsqueda semántica',
	'smw_ask_sortby' => 'Ordenar por columna',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Buscar resultados',
	'smw_ask_editquery' => '[Editar consulta]',
	'smw_add_sortcondition' => '[Agregar condición de orden]',
	'smw_ask_hidequery' => 'Ocultar pregunta',
	'smw_ask_help' => 'Consultando ayuda',
	'smw_ask_queryhead' => 'consulta',
	'smw_ask_printhead' => 'Datos adicionales a mostrar',
	'smw_ask_printdesc' => '(añade un nombre de propiedad por línea)',
	'smw_ask_format_as' => 'Formatear como:',
	'smw_ask_defaultformat' => 'por defecto',
	'smw_ask_otheroptions' => 'Otras opciones',
	'smw_ask_show_embed' => 'Mostrar código embebido',
	'smw_ask_hide_embed' => 'Ocultar código embebido',
	'smw_ask_embed_instr' => 'Para incluír esta consulta en línea dentro de una wiki use el código siguiente:',
	'searchbyproperty' => 'Buscar por atributo',
	'smw_sbv_docu' => 'Buscar por todas las páginas que tiene un atributo y valor dado.',
	'smw_sbv_novalue' => 'Por favor introduzca un valor, o ver todos los valores de atributo para $1.',
	'smw_sbv_displayresult' => 'Una lista de todas las páginas que tienen un atributo $1 con el valor $2.',
	'smw_sbv_displayresultfuzzy' => 'Lista de todas las páginas que tienen la propiedad "$1" con valor "$2".
En el caso de existir muy pocos resultados, se muestran también los valores aproximados.',
	'smw_sbv_property' => 'Propiedad:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => 'Buscar resultados',
	'browse' => 'Explorar artículos',
	'smw_browselink' => 'Explorar propiedades',
	'smw_browse_article' => 'Introduzca el nombre de la página para empezar a explorar.',
	'smw_browse_go' => 'Ir',
	'smw_browse_show_incoming' => 'mostrar propiedades que vinculen aquí',
	'smw_browse_hide_incoming' => 'ocultar propiedades que vinculen aquí',
	'smw_browse_no_outgoing' => 'Esta pa´gina no tiene propiedades.',
	'smw_browse_no_incoming' => 'Ninguna propiedad vincula aquí.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Etiqueta de propiedad inversa',
	'pageproperty' => 'Página de búsqueda de propiedades',
	'smw_pp_docu' => 'Busca todos los valores de una propiedad en una determinada página.
Ingrese la página y la propiedad.',
	'smw_pp_from' => 'De página',
	'smw_pp_type' => 'Propiedad',
	'smw_pp_submit' => 'Encontrar resultados',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Siguiente',
	'smw_result_results' => 'Resultados',
	'smw_result_noresults' => 'Lo siento, no hay resultados.',
	'smwadmin' => 'Funciones de administración para Semantic Mediawiki',
	'smw_smwadmin_settingup' => 'Configurando almacenamiento para Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'El motor de almacenamiento fue configurado con éxito.',
	'smw_smwadmin_return' => 'Regresar a $1',
	'smw_smwadmin_updatestarted' => 'Se ha iniciado un nuevo proceso de actualización para volver a cargar los datos semánticos.
Todos los datos almacenados serán reconstruidos o reparados donde sea necesario.
Puedes hacer un seguimiento del progreso de la actualización en esta página especial.',
	'smw_smwadmin_updatenotstarted' => 'Ya hay un proceso de actualización ejecutándose.
No crear otro más.',
	'smw_smwadmin_updatestopped' => 'Todos los procesos de actualización existentes han sido detenidos.',
	'smw_smwadmin_updatenotstopped' => 'Para detener el proceso de actualización en ejecución, debes activar la tabla de verificación para indicar que estás realmente seguro.',
	'smw_smwadmin_docu' => 'Esta página especial te ayudará durante la instalación y actualización de <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Recuerda respaldar cualquier información importante antes de ejecutar funciones administrativas.',
	'smw_smwadmin_db' => 'Instalación de la base de datos y actualización',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki necesita algunas extensiones en la base de datos de MediaWiki para poder almacenar la información semántica.
La función indicada abajo asegura que tu base de datos está configurada correctamente.
Los cambios realizados en este paso no afectan el resto de la base de datos de MediaWiki y pueden ser revertidos fácilmente si así se desea.
Esta función de configuración puede ejecutarse varias veces sin hacer ningún daño, pero es necesaria sólo una vez para la instalación o actualización.',
	'smw_smwadmin_permissionswarn' => 'Si la operación falla con errores SQL, la base de datos de usuarios empleada por su wiki (revise LocalSettings.php) probablemente no tiene permisos suficientes.
Ud puede conceder estos permisos adicionales de usuario para crear y borrar tablas, ingresando temporariamente la clave de acceso de su base de datos raíz en LocalSettings.php, o bien usar el script de mantenimiento <tt>SMW_setup.php</tt>, que puede acceder a las credenciales de AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Inicializar o actualizar tablas',
	'smw_smwadmin_announce' => 'Anunciar tu wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki cuenta con un servicio Web para anunciar nuevos sitios wiki semánticos, que es usado para mantener un listado de sitios Web públicos que usan Semantic MediaWiki, principalmente para ayudar al <a href="http://semantic-mediawiki.org/wiki/SMW_Project">proyecto Semantic MediaWiki</a>, para tener una visión general de los usos típicos de Semantic MediaWiki.
See the Semantic MediaWiki homepage for <a href="http://semantic-mediawiki.org/wiki/Registry">further information about this service</a>.',
	'smw_smwadmin_announcebutton' => 'Presione el botón siguiente para enviar la URL de su wiki al servicio.
El servicio no registrará wikis que no sean de acceso público, y solamente guardará información públicamente accesible.',
	'smw_smwadmin_datarefresh' => 'Reparación de datos y actualización',
	'smw_smwadmin_datarefreshdocu' => 'Es posible restaurar toda la información de MediaWiki Semántica basándose en los contenidos actuales de la wiki.
Esto puede ser útil para reparar la información destruida o para volver a cargar la información si el formato interno ha cambiado a causa de alguna actualización de software.
La actualización se ejecuta página a página y no se completará de inmediato.
Lo siguiente muestra es hay una actualización en progreso y le permite iniciar o detener actualizaciones (a menos que esta característica haya sido inhabilitada por el administrador del sitio).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Actualización en progreso.</strong>
Es normal que el proceso de actualización se retrase ya que sólo actualiza datos en porciones pequeñas cada vez que un usuario ingresa a la wiki.
Para finalizar esta actualización en forma mas rápida, Ud. puede invocar el script de matenimiento MediaWiki <tt>runJobs.php</tt> (use la opción <tt>--maxjobs 1000</tt>  para restringir el número de actualizaciones hechas en cada paquete).
Progeso estimado de la actualización:',
	'smw_smwadmin_datarefreshbutton' => 'Comenzar actualización de datos',
	'smw_smwadmin_datarefreshstop' => 'Detener esta actualización',
	'smw_smwadmin_datarefreshstopconfirm' => 'Sí, estoy seguro.',
	'smw_smwadmin_support' => 'Obteniendo ayuda',
	'smw_smwadmin_supportdocu' => 'Varios recursos podrían ayudarlo en caso de problemas:',
	'smw_smwadmin_installfile' => 'Si experimentas problemas con tu instalación, comienza revisando las líneas guía en el <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">archivo de INSTALACION</a>.',
	'smw_smwadmin_smwhomepage' => 'La documentación de usuario completa a Semantic MediaWiki está en <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Los defectos pueden ser reportados a <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Si tienes preguntas o sugerencias adicionales, únete a la discusión en <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Foro de usuarios de Semantic MediaWiki
</a>.',
	'smw_adminlinks_datastructure' => 'Estructura de datos',
	'smw_adminlinks_displayingdata' => 'Mostrando datos',
	'smw_adminlinks_inlinequerieshelp' => 'Ayuda de consultas en línea',
);

/** Basque (Euskara)
 * @author An13sa
 * @author Kobazulo
 */
$messages['eu'] = array(
	'smw_viewasrdf' => 'RDF jarioa',
	'smw_finallistconjunct' => ', eta',
	'smw_printername_auto' => 'Automatikoa',
	'smw_true_words' => 'egia,e,bai,b',
	'smw_false_words' => 'gezurra,g,ez,e',
	'smw_nofloat' => '"$1" ez da zenbakia.',
	'smw_badtitle' => '"$1" ez da izenburu zuzena.',
	'smw_subproperty_header' => 'Azpipropietateak',
	'properties' => 'Propietateak',
	'unusedproperties' => 'Erabili gabeko propietateak',
	'wantedproperties' => 'Eskatutako propietateak',
	'smw_purge' => 'Freskatu',
	'types' => 'Motak',
	'smw_ask_sortby' => 'Zutabeka sailkatu (hautazkoa)',
	'smw_ask_ascorder' => 'Gorantz',
	'smw_ask_descorder' => 'Beherantz',
	'smw_ask_submit' => 'Emaitzak bilatu',
	'searchbyproperty' => 'Propietateen arabera bilatu',
	'smw_sbv_property' => 'Propietatea:',
	'smw_sbv_value' => 'Balioa:',
	'smw_sbv_submit' => 'Emaitzak bilatu',
	'smw_browse_go' => 'Joan',
	'smw_pp_type' => 'Propietatea',
	'smw_pp_submit' => 'Emaitzak bilatu',
	'smw_result_prev' => 'Aurrekoa',
	'smw_result_next' => 'Hurrengoa',
	'smw_result_results' => 'Emaitzak',
	'smw_result_noresults' => 'Ez dago emaitzarik.',
	'smw_smwadmin_return' => '$1-(e)ra itzuli',
	'smw_smwadmin_datarefreshstopconfirm' => 'Bai, ziur nago.',
);

/** Persian (فارسی)
 * @author Momeni
 */
$messages['fa'] = array(
	'smw_edithelp' => 'ویرایش راهنما روی ویژگی‌ها',
	'smw_finallistconjunct' => '، و',
	'smw_isspecprop' => 'این خصوصیت یک خصوصیت ویژه در این ویکی است.',
	'smw_isknowntype' => 'این نوع از جمله انواع داده استاندارد در این ویکی است.',
	'smw_isaliastype' => 'این نوع یک نام مستعار برای نوع داده "$1" است.',
	'smw_concept_description' => 'توصیف مفهوم "$1"',
	'smw_no_concept_namespace' => 'مفاهیم فقط می‌توانند در صفحات داخل فضای‌نام مفهوم: تعریف شوند.',
	'smw_multiple_concepts' => 'هر صفحه مفهوم فقط می‌تواند شامل یک تعریف مفهوم باشد.',
	'smw_concept_cache_miss' => 'مفهوم "$1" نمی‌تواند در حال حاضر استفاده شود، زیرا تنظیمات ویکی نیاز به محاسبه آن به‌صورت برون‌خط دارد.
اگر این مشکل پس از مدتی از بین نرفت، از مدیر سایت بخواهید تا این مفهوم را در دسترس قرار دهد.',
	'smw_subproperty_header' => 'زیرخصوصیت‌ها',
	'smw_concept_header' => 'صفحه‌های مفهوم "$1"',
	'exportrdf' => 'صفحه‌ها را به آر-دی-اف صادر کن.',
	'smw_exportrdf_recursive' => 'تمام صفحه‌های به هم مرتبط را به صورت بازگشتی صادر کن.
توجه کنید که نتیجه می‌تواند بزرگ شود.',
	'smw_exportrdf_backlinks' => 'همچنین تمام صفحه‌هایی را که به صفحه‌های صادر شده ارجاع دارند، صادر کن.
آر-دی-اف قابل مرور تولید می‌کند.',
	'smw_exportrdf_lastdate' => 'صفحه‌هایی را که از زمان داده شده تغییری نکرده‌اند، صادر نکنید.',
	'properties' => 'خصوصیت‌ها',
	'smw_properties_docu' => 'خصوصیت‌های زیر در این ویکی استفاده شده‌اند.',
	'smw_property_template' => '$1 از نوع $2 ($3)',
	'smw_propertylackspage' => 'تمام خصوصیت‌ها باید توسط یک صفحه توصیف شوند.',
	'smw_propertylackstype' => 'هیچ نوعی برای این خصوصیت مشخص نشده است (با فرض نوع $1 برای اکنون).',
	'smw_propertyhardlyused' => 'این خصوصیت به ندرت در این ویکی استفاده شده است.',
	'unusedproperties' => 'خصوصیت‌های استفاده نشده',
	'smw_unusedproperties_docu' => 'خصوصیت‌های زیر با وجود این‌که هیچ صفحه‌ای از آن‌ها استفاده نمی‌کند، وجود دارند.',
	'smw_unusedproperty_template' => '$1 از نوع $2',
	'wantedproperties' => 'خصوصیت‌های خواسته شده',
	'smw_wantedproperties_docu' => 'خصوصیت‌های زیر در این ویکی استفاده شده‌اند ولی هنوز صفحه‌ای برای توصیف آن‌ها وجود ندارد.',
	'smw_wantedproperty_template' => '$1 ($2 استفاده شده)',
	'tooltip-purge' => 'اینجا را برای بازخوانی تمام پرس‌وجوها و قالب‌های روی این صفحه کلیک کنید.',
	'smw_purge' => 'بازخوانی',
	'types' => 'نوع‌ها',
	'smw_types_docu' => 'در ذیل لیستی از تمام نوع‌داده‌هایی که می‌تواند به خصوصیت‌ها انتصاب شود، آمده است.
هر نوع‌داده یک صفحه دارد که اطلاعات اضافه می‌تواند در آن فراهم آورده شود.',
	'smw_typeunits' => 'واحدهای اندازه‌گیری از نوع "$1" : $2',
	'semanticstatistics' => 'آمار معنایی',
	'ask' => 'جستجوی معنایی',
	'smw_ask_sortby' => 'مرتب‌سازی با ستون (اختیاری)',
	'smw_ask_ascorder' => 'صعودی',
	'smw_ask_descorder' => 'نزولی',
	'smw_ask_submit' => 'نتایج را جستجو کن',
	'smw_ask_editquery' => '[ویرایش پرس‌وجو]',
	'smw_add_sortcondition' => '[افزودن شرایط مرتب‌سازی]',
	'smw_ask_hidequery' => 'مخفی‌کردن پرس‌و‌جو',
	'smw_ask_help' => 'پرس‌و‌جو از راهنما',
	'smw_browselink' => 'مرور خصوصیات',
	'smw_browse_article' => 'نام صفحه‌ای را که می‌خواهید مرور کردن را از آن شروع کنید، وارد کنید.',
	'smw_browse_go' => 'برو',
	'smw_browse_show_incoming' => 'خصوصیاتی که به اینجا پیوند دارند، نمایش بده',
	'smw_browse_hide_incoming' => 'خصوصیاتی که به اینجا پیوند دارند مخفی کن',
	'smw_browse_no_outgoing' => 'این صفحه هیچ خصوصیاتی ندارد',
	'smw_browse_no_incoming' => 'هیچ خصوصیتی به این صفحه پیوند ندارد',
	'smw_inverse_label_default' => '$1 از',
	'smw_inverse_label_property' => 'برچسب خصوصیت برعکس',
	'pageproperty' => 'جستجوی خصوصیت صفحه',
);

/** Finnish (Suomi)
 * @author Cimon Avaro
 * @author Crt
 * @author Nike
 * @author Silvonen
 * @author Str4nd
 */
$messages['fi'] = array(
	'smw_edithelp' => 'Muokkausohjeita ominaisuuksista',
	'smw_viewasrdf' => 'RDF-syöte',
	'smw_finallistconjunct' => ' ja',
	'smw_factbox_head' => 'Tietoja kohteesta $1',
	'smw_isknowntype' => 'Tämä kuuluu tämän wikin tavallisiin tietuelajeihin.',
	'smw_concept_description' => 'Käsitteen ”$1” kuvaus',
	'smw_multiple_concepts' => 'Kullakin käsitesivulla voi olla vain yksi käsitteen määritelmä.',
	'smw_printername_auto' => 'Automaattinen',
	'smw_printername_count' => 'Laskennan tulokset',
	'smw_printername_csv' => 'CSV-vienti',
	'smw_printername_json' => 'JSON-vienti',
	'smw_printername_list' => 'Luettelo',
	'smw_printername_ol' => 'Numerointi',
	'smw_printername_ul' => 'Kohteittainen esitys',
	'smw_printername_rss' => 'RSS-vienti',
	'smw_printername_table' => 'Taulukko',
	'smw_printername_broadtable' => 'Leveä taulukko',
	'smw_printername_template' => 'Malline',
	'smw_paramdesc_link' => 'Näytä arvot linkkeinä',
	'smw_iq_disabled' => 'Semanttiset hakukyselyt on estetty tässä wikissä.',
	'smw_iq_moreresults' => '… lisää tuloksia',
	'smw_iq_nojs' => 'Käytä tämän elementin näyttämiseen JavaScript-tuellista selainta.',
	'smw_iq_altresults' => 'Selaa tuloslistaa suoraan.',
	'smw_wrong_importtype' => 'Muotoa $1 ei voida käyttää nimiavaruuden ”$2” sivuille.',
	'smw_no_importelement' => 'Elementti ”$1” ei ole saatavissa tuontiin.',
	'smw_parseerror' => 'Tarjottua arvoa ei ymmärretty.',
	'smw_notitle' => 'Nimeä ”$1” ei voi käyttää sivun nimenä tässä wikissä.',
	'smw_wrong_namespace' => 'Vain nimiavaruuden "$1" sivut sallitaan tässä.',
	'smw_manytypes' => 'Ominaisuudelle on määritelty useampi kuin yksi tyyppi.',
	'smw_emptystring' => 'Tyhjiä merkkijonoja ei hyväksytä.',
	'smw_maxstring' => 'Merkkijonon esitysmuoto $1 on liian pitkä.',
	'smw_noboolean' => '”$1” ei ole tunnistettavissa totuusarvoksi.',
	'smw_true_words' => 'kyllä,k,y',
	'smw_false_words' => 'ei,e,n',
	'smw_nofloat' => '”$1” ei ole luku.',
	'smw_infinite' => 'Numeron "$1" kokoisia arvoja ei tueta.',
	'smw_infinite_unit' => 'Muuntaminen yksikköihin "$1" johti siihen, että numero kasvoi liian suureksi.',
	'smw_unsupportedprefix' => 'Lukujen etuliitteitä (”$1”) ei tueta.',
	'smw_unsupportedunit' => 'Yksikön ”$1” yksikkömuunnosta ei tueta.',
	'smw_nodatetime' => 'Päiväystä ”$1” ei tunnistettu.',
	'smw_toomanyclosing' => 'Hakukyselyssä tuntuisi olevan liian monta esiintymää "$1" termistä.',
	'smw_misplacedsymbol' => 'Symbolia "$1" käytettiin yhteydessä johon se ei soveltunut.',
	'smw_emptysubquery' => 'Jollakin alikyselyllä ei ole kelvollista ehtoa.',
	'smw_overprintoutlimit' => 'Hakukysely sisältää liian monta tulostuspyyntöä.',
	'smw_badprintout' => 'Jokin tulostuskäsky oli huonosti muotoiltu hakukyselyssä.',
	'smw_badtitle' => '”$1” ei ole kelvollinen sivun nimi.',
	'smw_devel_warning' => 'Tämä ominaisuutta kehitetään aktiivisesti, eikä välttämättä ole kaikin osin toimiva. Varmuuskopioi tietosi ennen käyttöä.',
	'smw_attribute_header' => 'Ominaisuutta ”$1” käyttävät sivut',
	'smw_subproperty_header' => 'Alaominaisuudet',
	'exportrdf' => 'Vie sivut RDF:nä',
	'smw_exportrdf_recursive' => 'Tee vienti rekursiivisesti kaikista liittyvistä sivuista.
Huomioi, että tulos saattaa olla suuri.',
	'smw_exportrdf_lastdate' => 'Älä vie sivuja, jotka eivät ole muuttuneet määrätyn ajankohdan jälkeen.',
	'smw_exportrdf_submit' => 'Vie',
	'properties' => 'Ominaisuudet',
	'smw_properties_docu' => 'Wikissä käytetään seuraavia ominaisuuksia.',
	'unusedproperties' => 'Käyttämättömät ominaisuudet',
	'smw_unusedproperties_docu' => 'Seuraavat ominaisuudet ovat olemassa, vaikka mikään muu sivu ei käytä niitä.',
	'wantedproperties' => 'Halutut ominaisuudet',
	'smw_purge' => 'Päivitä',
	'types' => 'Tyypit',
	'semanticstatistics' => 'Semanttiset tilastot',
	'ask' => 'Semanttinen haku',
	'smw_ask_sortby' => 'Järjestä sarakkeen mukaan (valinnainen)',
	'smw_ask_ascorder' => 'Nouseva',
	'smw_ask_descorder' => 'Laskeva',
	'smw_ask_submit' => 'Hae tuloksia',
	'smw_ask_editquery' => '[Muokkaa kyselyä]',
	'smw_add_sortcondition' => '[Lisää lajitteluehto]',
	'smw_ask_hidequery' => 'Piilota kysely',
	'smw_ask_help' => 'Hakukyselyn ohjeet',
	'smw_ask_queryhead' => 'Kysely',
	'smw_ask_printhead' => 'Valinnaiset näytettävät tiedot',
	'smw_ask_defaultformat' => 'oletus',
	'smw_ask_otheroptions' => 'Muut valinnat',
	'smw_ask_show_embed' => 'Näytä upotettava koodi',
	'smw_ask_hide_embed' => 'Piilota upotettava koodi',
	'smw_sbv_displayresult' => 'Lista kaikista sivuista, joilla ominaisuuden ”$1” arvona on ”$2”',
	'smw_sbv_displayresultfuzzy' => 'Lista kaikista sivuista, joilla ominaisuuden ”$1” arvona on ”$2”.
Koska tuloksia on vain vähän, myös lähellä olevat arvot näytetään.',
	'smw_sbv_property' => 'Ominaisuus:',
	'smw_sbv_value' => 'Arvo:',
	'smw_sbv_submit' => 'Etsi tuloksia',
	'browse' => 'Selaa wikiä',
	'smw_browselink' => 'Selaa ominaisuuksia',
	'smw_browse_go' => 'Siirry',
	'smw_browse_no_outgoing' => 'Tällä sivulla ei ole ominaisuuksia.',
	'smw_pp_from' => 'Sivulta',
	'smw_pp_type' => 'Ominaisuus',
	'smw_pp_submit' => 'Hae tulokset',
	'smw_result_prev' => 'Edellinen',
	'smw_result_next' => 'Seuraava',
	'smw_result_results' => 'Tulokset',
	'smw_result_noresults' => 'Ei hakutuloksia.',
	'smwadmin' => 'Ylläpitotoiminnot semanttiselle MediaWikille',
	'smw_smwadmin_return' => 'Palaa kohteeseen $1',
	'smw_smwadmin_updatenotstarted' => 'Päivitysprosessi on jo käynnissä.
Uutta ei käynnistetä.',
	'smw_smwadmin_updatestopped' => 'Kaikki käynnissä olevat päivitysprosessit on pysäytetty.',
	'smw_smwadmin_updatenotstopped' => 'Jos haluat pysäyttää käynnissä olevan päivitysprosessin, sinun täytyy aktivoida valintaruutu osoittaaksesi, että olet todella varma.',
	'smw_smwadmin_db' => 'Tietokannan asennus ja päivitys',
	'smw_smwadmin_dbbutton' => 'Alusta tai päivitä taulukot',
	'smw_smwadmin_announce' => 'Julkista wikisi',
	'smw_smwadmin_datarefresh' => 'Tietueiden korjaus ja päivitys',
	'smw_smwadmin_datarefreshbutton' => 'Aloita tietojen päivitys',
	'smw_smwadmin_datarefreshstop' => 'Lopeta tämä päivitys',
	'smw_smwadmin_datarefreshstopconfirm' => 'Kyllä, olen varma.',
	'smw_smwadmin_support' => 'Tuen hankkiminen',
	'smw_smwadmin_installfile' => 'Jos asennuksen kanssa on ongelmia, lue ensin <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL-tiedoston</a> ohjeet.',
	'smw_smwadmin_mediazilla' => 'Ohjelmistovirheet voi raportoida <a href="https://bugzilla.wikimedia.org/">Bugzillaan</a>.',
	'smw_smwadmin_questions' => 'Jos sinulla on kysymyksiä tai ehdotuksia, liity keskusteluun <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semanttisen MediaWikin käyttäjäfoorumilla</a>.',
	'smw_adminlinks_datastructure' => 'Tietorakenne',
);

/** French (Français)
 * @author Crochet.david
 * @author Grondin
 * @author IAlex
 * @author McDutchie
 * @author Meithal
 * @author PieRRoMaN
 * @author Pierre Matringe
 * @author Sherbrooke
 * @author Urhixidur
 * @author Verdy p
 * @author Zetud
 */
$messages['fr'] = array(
	'smw-desc' => "Rendre le wiki plus accessible - pour les machines ''et'' les humains ([http://semantic-mediawiki.org/wiki/Help:User_manual documentation en ligne])",
	'smw_edithelp' => 'Aide à la rédaction de relations et d’attributs',
	'smw_viewasrdf' => 'Voir comme RDF',
	'smw_finallistconjunct' => ' et',
	'smw_factbox_head' => 'Faits relatifs à $1 &mdash; Recherche de pages similaires avec <span class="smwsearchicon">+</span>.',
	'smw_isspecprop' => 'Cette propriété est spéciale sur ce wiki.',
	'smw_isknowntype' => 'Ce type fait partie des types de données standards de ce wiki.',
	'smw_isaliastype' => 'Ce type est un alias du type de données « $1 ».',
	'smw_isnotype' => 'Le type « $1 » n’est pas un type de données standard sur ce wiki, et n’a pas non plus été défini par un utilisateur.',
	'smw_concept_description' => 'Description du concept « $1 »',
	'smw_no_concept_namespace' => 'Les concepts peuvent uniquement être définis dans les pages dans l’espace de noms Concept:.',
	'smw_multiple_concepts' => 'Chaque page de concept ne peut avoir qu’une seule définition.',
	'smw_concept_cache_miss' => 'Le concept « $1 » ne peut être utilisé en ce moment, puisque la configuration du wiki requiert qu’il soit lancé hors-ligne. Si le problème persiste après quelques instants, demander à votre administrateur du site de rendre disponible ce concept.',
	'smw_noinvannot' => 'Les valeurs ne peuvent pas être allouées pour inverser des propriétés.',
	'smw_baduri' => 'Désolé. Les URIs du domaine « $1 » ne sont pas disponible à cet emplacement.',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automatique',
	'smw_printername_count' => 'Comptage des résultats',
	'smw_printername_csv' => 'export en CSV',
	'smw_printername_debug' => 'Requête de débogage (pour les experts)',
	'smw_printername_embedded' => 'Contenu des pages incrustées',
	'smw_printername_json' => 'export en JSON',
	'smw_printername_list' => 'Liste',
	'smw_printername_ol' => 'Énumération',
	'smw_printername_ul' => 'Détail',
	'smw_printername_rss' => 'export en RSS',
	'smw_printername_table' => 'Tableau',
	'smw_printername_broadtable' => 'Table large',
	'smw_printername_template' => 'Modèle',
	'smw_paramdesc_limit' => 'Le nombre maximal de résultats à renvoyer',
	'smw_paramdesc_headers' => 'Afficher les en-têtes / noms de propriétés',
	'smw_paramdesc_mainlabel' => 'L’étiquette de la page d’accueil',
	'smw_paramdesc_link' => 'Montrer les valeurs en tant que liens',
	'smw_paramdesc_intro' => 'Le texte à afficher avant les résultats de la requête, s’il y en a',
	'smw_paramdesc_outro' => 'Le texte à afficher après les résultats de la requête, s’il y en a',
	'smw_paramdesc_default' => 'Le texte à afficher s’il n’y a aucun résultat pour la requête',
	'smw_paramdesc_searchlabel' => 'Le texte sur le lien vers les résultats',
	'smw_paramdesc_sep' => 'Le séparateur des valeurs',
	'smw_paramdesc_template' => 'Le nom du modèle avec lequel il faut afficher les impressions',
	'smw_paramdesc_columns' => 'Le nombre de colonnes dans lesquelles il faut afficher les résultats (3 par défaut)',
	'smw_paramdesc_embedformat' => 'La balise HTML qui sert à définir les en-têtes',
	'smw_paramdesc_embedonly' => 'Ne pas afficher d’en-tête',
	'smw_paramdesc_rsstitle' => 'Texte à utiliser comme titre des flux',
	'smw_paramdesc_rssdescription' => 'Texte a utiliser comme description des flux',
	'smw_iq_disabled' => 'Désolé. Les recherches dans les pages de ce wiki ne sont pas autorisées.',
	'smw_iq_moreresults' => '&hellip; autres résultats',
	'smw_iq_nojs' => 'Utilisez un navigateur avec JavaScript activé pour voir cet élément.',
	'smw_iq_altresults' => 'Parcourir directement la liste des résultats.',
	'smw_unknown_importns' => 'Aucune fonction d’importation n’est disponible pour l’espace de noms « $1 ».',
	'smw_nonright_importtype' => 'L’élément « $1 » ne peut être employé que pour des pages de l’espace de noms « $2 ».',
	'smw_wrong_importtype' => '$1 ne peut pas être employé pour des pages dans l’espace de noms « $2 ».',
	'smw_no_importelement' => 'L’élément « $1 » n’est pas disponible pour l’importation.',
	'smw_parseerror' => 'La donnée indiquée n’a pas été comprise.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '&nbsp;',
	'smw_notitle' => '« $1 » ne peut être utilisé comme nom de page sur ce wiki.',
	'smw_wrong_namespace' => 'Seules les pages dans l’espace « $1 » sont autorisées ici.',
	'smw_unknowntype' => 'Le type de données « $1 » non supporté a été retourné à l’attribut.',
	'smw_manytypes' => 'Plusieurs types de données ont été assignés à l’attribut.',
	'smw_emptystring' => 'Les chaînes vides ne sont pas acceptées.',
	'smw_maxstring' => 'La chaîne de représentation $1 est trop grande.',
	'smw_notinenum' => '« $1 » ne fait pas partie des valeurs possibles ($2) pour cet attribut.',
	'smw_noboolean' => '« $1 » n’est pas reconnu comme valeur booléenne (vrai/faux).',
	'smw_true_words' => 'vrai,v,oui,true',
	'smw_false_words' => 'faux,f,non,false',
	'smw_nofloat' => '« $1 » n’est pas un nombre.',
	'smw_infinite' => 'Les nombres aussi grand que « $1 » ne sont pas supportés.',
	'smw_infinite_unit' => 'La conversion en l’unité « $1 » a donné un nombre trop grand.',
	'smw_novalues' => 'Aucune valeur spécifiée.',
	'smw_unsupportedprefix' => 'Des préfixes (« $1 ») ne sont pas supportés actuellement.',
	'smw_unsupportedunit' => 'La conversion de l’unité « $1 » n’est pas supportée.',
	'smw_nodatetime' => 'La date « $1 » n’a pas été comprise.',
	'smw_toomanyclosing' => 'Il semble y avoir trop d’occurences de « $1 » dans la requête.',
	'smw_noclosingbrackets' => 'Certains « <nowiki>[[</nowiki> » dans votre requête n’ont pas été clos par des « ]] » correspondants.',
	'smw_misplacedsymbol' => 'Le symbole « $1 » a été utilisé à un endroit où il n’est pas utile.',
	'smw_unexpectedpart' => 'La partie « $1 » de la requête n’a pas été comprise. Les résultats peuvent être inattendus.',
	'smw_emptysubquery' => 'Certaines sous-requêtes ont une condition invalide.',
	'smw_misplacedsubquery' => 'Certaines sous-requêtes ont été utilisées à un endroit où aucune sous-requête n’est permise.',
	'smw_valuesubquery' => 'Sous-requête non supportée pour les valeurs de la propriété « $1 ».',
	'smw_overprintoutlimit' => 'La requête contient trop d’instructions de formatage.',
	'smw_badprintout' => 'Certaines instructions de formatage dans la requête n’ont pas été comprises.',
	'smw_badtitle' => 'Désolé, mais « $1 » n’est pas un titre de page valable.',
	'smw_badqueryatom' => 'Les parties « <nowiki>[[…]]</nowiki> » de la requête n’ont pas été comprises.',
	'smw_propvalueproblem' => 'La valeur de la propriété « $1 » n’a pas été comprise.',
	'smw_noqueryfeature' => 'Quelques fonctionnalités de requêtes ne sont pas supportées sur ce wiki et une partie d’entre elles ont été retirées ($1).',
	'smw_noconjunctions' => 'Les conjonctions dans les requêtes ne sont pas supportées sur ce wiki et une parties d’entres elles ont été retirées ($1).',
	'smw_nodisjunctions' => 'Les disjonctions dans les requêtes ne sont pas supportées sur ce wiki et des parties de la requête ont été ignorées ($1).',
	'smw_querytoolarge' => 'Les conditions suivantes de la requête n’ont pu être évaluées en raison des restrictions de ce wiki à la taille ou à la profondeur des requêtes : $1.',
	'smw_devel_warning' => 'Cette fonction est encore en développement et n’est peut-être pas encore opérationnelle. Il est peut-être judicieux de faire une sauvegarde du contenu du wiki avant toute utilisation de cette fonction.',
	'smw_notemplategiven' => 'Veuillez fournir une valeur pour le paramètre « modèle » pour ce format de requête afin de travailler.',
	'smw_type_header' => 'Attributs de type « $1 »',
	'smw_typearticlecount' => 'Afficher {{PLURAL:$1|la propriété|les $1 propriétés}} utilisant ce type.',
	'smw_attribute_header' => 'Pages utilisant l’attribut « $1 »',
	'smw_attributearticlecount' => 'Afficher {{PLURAL:$1|la page|les $1 pages}} utilisant cette propriété.',
	'smw_subproperty_header' => 'Sous-propriétés',
	'smw_subpropertyarticlecount' => 'Cette propriété dispose {{PLURAL:$1|de la sous-propriété suivante|des $1 sous-propriétés suivantes}} :',
	'smw_concept_header' => 'Page du concept « $1 »',
	'smw_conceptarticlecount' => 'Afficher {{PLURAL:$1|la page|les $1 pages}} reposant sur ce concept',
	'smw_rss_description' => 'fil RSS $1',
	'specialpages-group-smw_group' => 'MediaWiki sémantique',
	'exportrdf' => 'Exporter des pages en RDF',
	'smw_exportrdf_docu' => 'Cette page permet d’obtenir des données d’une page au format RDF. Veuillez entrer le nom des pages souhaitées dans la boîte de texte ci-dessous, un nom par ligne.',
	'smw_exportrdf_recursive' => 'Exporter également toutes les pages pertinentes de manière récursive. Cette possibilité peut aboutir à un très grand nombre de résultats !',
	'smw_exportrdf_backlinks' => 'Exporter également toutes les pages qui renvoient à des pages exportées. Produit un RDF dans lequel la navigation est facilitée.',
	'smw_exportrdf_lastdate' => 'Ne pas exporter les pages non modifiées depuis le moment indiqué.',
	'smw_exportrdf_submit' => 'Exporter',
	'properties' => 'Propriétés',
	'smw_properties_docu' => 'Sur ce wiki, sont utilisées les propriétés suivantes.',
	'smw_property_template' => '$1 du type $2 ($3)',
	'smw_propertylackspage' => 'Toute propriété devrait être décrite par une page !',
	'smw_propertylackstype' => 'Aucun type n’a été spécifié pour cette propriété (type actuellement supposé : $1).',
	'smw_propertyhardlyused' => 'Cette propriété est à peine utilisée sur ce wiki !',
	'unusedproperties' => 'Propriétés inutilisées',
	'smw_unusedproperties_docu' => 'Les propriétés suivantes existent, bien qu’aucune page ne les utilise.',
	'smw_unusedproperty_template' => '$1 de type $2',
	'wantedproperties' => 'Propriétés demandées',
	'smw_wantedproperties_docu' => 'Les propriétés suivantes sont utilisées sur ce wiki mais n’ont pas encore de page pour les décrire.',
	'smw_wantedproperty_template' => '$1 ($2 utilisation{{PLURAL:$2||s}})',
	'tooltip-purge' => 'Réactualiser toutes les recherches et tous les brouillons de cette page.',
	'smw_purge' => 'Réactualiser',
	'types' => 'Types de données',
	'smw_types_docu' => 'Les types de données suivants peuvent être assignées aux attributs. Chaque type de données a sa propre page, dans laquelle peuvent figurer des informations plus précises.',
	'smw_typeunits' => 'Unités de mesure de type « $1 » : $2',
	'semanticstatistics' => 'Statistiques sémantiques',
	'smw_semstats_text' => "Ce wiki contient '''$1''' valeur{{PLURAL:$1||s}} de propriété pour un total de '''$2''' [[Special:Properties|{{PLURAL:$2|propriété différente|propriétés différentes}}]].
'''$3''' {{PLURAL:$3|propriété a sa|propriétés ont leur}} propre page, et le type de données voulu est spécifié pour '''$4''' de celles-ci.
Certaines des propriétés existantes peuvent en faite être [[Special:UnusedProperties|inutilisées]].
Les propriétés qui n’ont pas encore de page se trouvent dans la [[Special:WantedProperties|liste des propriétés demandées]].",
	'uriresolver' => 'Résolveur d’URI',
	'smw_uri_doc' => 'Le résolveur d’URI implémente la <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">Conclusion du TAG du W3C à propos du httpRange-14</a>. Il peut veiller à ce que les humains ne deviennent pas des sites web.',
	'ask' => 'Recherche sémantique',
	'smw_ask_sortby' => 'Trier par colonnes (optionnel)',
	'smw_ask_ascorder' => 'Croissant',
	'smw_ask_descorder' => 'Décroissant',
	'smw_ask_submit' => 'Trouver des résultats',
	'smw_ask_editquery' => '[Modifier la requête]',
	'smw_add_sortcondition' => '[Ajoute les conditions de tri]',
	'smw_ask_hidequery' => 'Masquer la requête',
	'smw_ask_help' => 'Aide à la requête',
	'smw_ask_queryhead' => 'Requête',
	'smw_ask_printhead' => 'Données supplémentaires à afficher',
	'smw_ask_printdesc' => '(ajouter un nom de propriété par ligne)',
	'smw_ask_format_as' => 'Formater en :',
	'smw_ask_defaultformat' => 'défaut',
	'smw_ask_otheroptions' => 'Autres options',
	'smw_ask_show_embed' => 'Montrer le code incrusté',
	'smw_ask_hide_embed' => 'Masquer le code incrusté',
	'smw_ask_embed_instr' => 'Pour incruster cette requête dans une page wiki, utilisez le code ci-dessous.',
	'searchbyproperty' => 'Rechercher par attribut',
	'smw_sbv_docu' => 'Rechercher toutes les pages qui ont un attribut donné avec un certaine valeur.',
	'smw_sbv_novalue' => 'Veuillez entrer une valeur ou consulter toutes les valeurs des attributs pour « $1 ».',
	'smw_sbv_displayresult' => 'Liste de toutes les pages qui ont un attribut « $1 » avec la valeur « $2 ».',
	'smw_sbv_displayresultfuzzy' => 'Une liste de toutes les pages qui ont la propriété « $1 » avec la valeur « $2 ». Puisqu’il n’y a que quelques résultats, les valeurs proches sont également affichées.',
	'smw_sbv_property' => 'Propriété :',
	'smw_sbv_value' => 'Valeur :',
	'smw_sbv_submit' => 'Trouver des résultats',
	'browse' => 'Parcourir le wiki',
	'smw_browselink' => 'Chercher les propriétés',
	'smw_browse_article' => 'Entrez le nom de la page à partir de laquelle commencer la navigation.',
	'smw_browse_go' => 'Démarrer',
	'smw_browse_show_incoming' => 'afficher les propriétés qui pointent ici',
	'smw_browse_hide_incoming' => 'cacher les propriétés qui pointent ici',
	'smw_browse_no_outgoing' => 'Cette page n’a aucune propriété.',
	'smw_browse_no_incoming' => 'Aucune propriété ne pointe vers cette page.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Label de la propriété inverse',
	'pageproperty' => 'Rechercher dans les propriétés de la page',
	'smw_pp_docu' => 'Rechercher toutes les valeurs d’une propriété dans une page donnée. Veuillez entrer la page et une propriété.',
	'smw_pp_from' => 'De la page',
	'smw_pp_type' => 'Propriété',
	'smw_pp_submit' => 'Afficher les résultats',
	'smw_result_prev' => 'Précédent',
	'smw_result_next' => 'Suivant',
	'smw_result_results' => 'Résultats',
	'smw_result_noresults' => 'Désolé, aucun résultat.',
	'smwadmin' => 'Fonctions administrateur pour Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Install le stockage pour Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Le moteur de stockage a été installé avec succès.',
	'smw_smwadmin_return' => 'Revenir vers $1',
	'smw_smwadmin_updatestarted' => 'Un nouveau processus pour le rafraîchissement des données sémantiques a commencé.
Toutes les données stockées seront reconstruites, voire réparées si nécessaire.
Vous pouvez suivre la progression de la mise à jour sur cette page spéciale.',
	'smw_smwadmin_updatenotstarted' => 'Un processus de mise à jour est déjà en cours d’exécution.
Ne pas en créer un autre.',
	'smw_smwadmin_updatestopped' => 'Tous les processus de mise à jour ont été arrêtés.',
	'smw_smwadmin_updatenotstopped' => 'Pour arrêter le processus en cours de mise à jour, vous devez cocher la case.',
	'smw_smwadmin_docu' => 'Cette page spéciale vous aide pendant l’installation et la mise à niveau de <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
N’oubliez pas de sauvegarder vos données avant d’exécuter les fonctions d’administration du site.',
	'smw_smwadmin_db' => 'Installation et mise à niveau de la base de données',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki doit étendre la base de données MediaWiki afin de stocker ses données sémantiques.
La fonction ci-dessous s’assure que votre base de données a été correctement installée.
Les modifications faites lors de cette étape n’affecteront pas le reste de la base de données Mediawiki, et peuvent être annulées si nécessaire.
Cette fonction d’installation peut être lancée plusieurs fois sans causer le moindre dégat, et n’est nécessaire qu’une fois par installation ou mise à niveau.',
	'smw_smwadmin_permissionswarn' => "Si l’opération échoue avec des erreurs SQL, l’utilisateur de la base de données utilisée par votre wiki, (regardez votre LocalSettings.php) n’a probablement pas les permissions suffisantes.
Il faut soit permettre à cet utilisateur de créer et supprimer les tables, soit entrer temporairement la connexion en ''root'' à votre base de données dans le LocalSettings.php, soit utiliser le script d’entretien <tt>SMW_setup.php</tt> (qui peut utiliser les accréditations de AdminSettings.php).",
	'smw_smwadmin_dbbutton' => 'Initialiser ou mettre à niveau les tables',
	'smw_smwadmin_announce' => 'Annoncer votre wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki dispose d’un service Internet pour annoncer de nouveaux sites wiki sémantiques.
Ce service maintient une liste des sites publics utilisant Semantic MediaWiki, principalement pour aider <a href="http://semantic-mediawiki.org/wiki/SMW_Project">le projet Semantic MediaWiki</a> à obtenir une vue d’ensemble de ses utilisations typiques.
Voyez la page d’accueil de Semantic MediaWiki pour <a href="http://semantic-mediawiki.org/wiki/Registry">de plus amples informations concernant ce service</a>.',
	'smw_smwadmin_announcebutton' => 'Appuyez sur le bouton suivant pour soumettre l’adresse Internet de votre wiki à ce service.
Le service n’enregistrera pas les wikis qui ne sont pas accessibles au public, et il ne stockera que les informations publiquement accessibles.',
	'smw_smwadmin_datarefresh' => 'Réparation et mise à niveau des données',
	'smw_smwadmin_datarefreshdocu' => 'Il est possible de restaurer toutes les données Semantic MediaWiki à partir du contenu courant de ce wiki.
Ceci peut être utile pour réparer des données corrompues ou pour rafraîchir les données si le format interne a changé lors des mises à niveau.
La mise à jour est exécutée page par page et se sera pas achevée immédiatement.
La page suivante spécifie si une mise à jour est en cours d’exécution et vous permet de commencer ou d’arrêter celle-ci (à moins que cette fonctionnalité n’ait été désactivée par l’administrateur du site).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Une mise à jour est en cours d’exécution.</strong>
Il est normal qu’une mise à jour progresse lentement parce qu’elle ne rafraîchit les données que par petits tronçons, au fur et à mesure qu’un utilisateur accède au wiki.
Pour terminer cette mise à jour plus rapidement, vous pouvez invoquer le script d’entretien Mediawiki <tt>runJobs.php</tt> (utilisez l’option <tt>--maxjobs 1000</tt> pour restreindre le nombre de mises à jour par script lancé).
Progression estimée de la mise à jour actuelle :',
	'smw_smwadmin_datarefreshbutton' => 'Commencer la mise à jour des données',
	'smw_smwadmin_datarefreshstop' => 'Arrêter cette mise à jour',
	'smw_smwadmin_datarefreshstopconfirm' => 'Oui, j’en suis sûr.',
	'smw_smwadmin_support' => 'Obtenir de l’aide',
	'smw_smwadmin_supportdocu' => 'Diverses ressources pourraient vous aider en cas de problèmes :',
	'smw_smwadmin_installfile' => 'Si vous rencontrez des problèmes lors de votre installation, commencez par regarder le guide en ligne dans le <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">fichier INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'La documentation complète de l’utilisateur de Semantic MediaWiki se trouve sur <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Les bogues peuvent être soumis sur <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Si vous avez d’autres questions ou des suggestions, joignez-vous à la discussion sur <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">le forum des utilisateurs de Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Structure des données',
	'smw_adminlinks_displayingdata' => 'Affichage des données',
	'smw_adminlinks_inlinequerieshelp' => 'Aide sur les requêtes',
);

/** Franco-Provençal (Arpetan)
 * @author Cedric31
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'smw_ask_defaultformat' => 'dèfôt',
	'smw_browse_go' => 'Dèmarrar',
	'smw_result_prev' => 'Devant',
	'smw_result_next' => 'Aprés',
	'smw_result_results' => 'Rèsultats',
	'smw_result_noresults' => 'Dèsolâ, gins de rèsultat.',
);

/** Irish (Gaeilge)
 * @author Alison
 */
$messages['ga'] = array(
	'smw_sbv_property' => 'Airí',
	'smw_pp_type' => 'Airí',
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'smw-desc' => "Fai o seu wiki máis accesible; para máquinas ''e'' humanos ([http://semantic-mediawiki.org/wiki/Help:User_manual documentación en liña])",
	'smw_edithelp' => 'Axuda de edición nas propiedades',
	'smw_viewasrdf' => 'Fonte de novas RDF',
	'smw_finallistconjunct' => 'e',
	'smw_factbox_head' => 'Feitos acerca de $1',
	'smw_isspecprop' => 'Esta propiedade é especial neste wiki.',
	'smw_isknowntype' => 'Este tipo está entre os tipos de datos deste wiki.',
	'smw_isaliastype' => 'Este tipo é un alias para o tipo de datos “$1”.',
	'smw_isnotype' => 'O tipo “$1” non é un tipo de datos estándar no wiki, e ningún usuario lle deu unha definición.',
	'smw_concept_description' => 'Descrición do concepto “$1”',
	'smw_no_concept_namespace' => 'O conceptos só poden ser definidos nas páxinas que están no espazo de nomes Concepto:.',
	'smw_multiple_concepts' => 'Cada páxina de conceptos só pode conter unha definición dun concepto.',
	'smw_concept_cache_miss' => 'O concepto "$1" non pode ser usado desde que a configuración do wiki o require para calcular a desconexión. Se o problema non se resolve en breve, pregúntelle ao administrador do wiki para que o concepto poida estar dispoñible.',
	'smw_noinvannot' => 'Non se poden asignar os valores para inverter as propiedades.',
	'smw_baduri' => 'Sentímolo, os URIs da forma “$1” non están permitidos.',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automático',
	'smw_printername_count' => 'Contador de resultados',
	'smw_printername_csv' => 'Exportación en CSV',
	'smw_printername_debug' => 'Depurar a pescuda (para expertos)',
	'smw_printername_embedded' => 'Incorporar os contidos da páxina',
	'smw_printername_json' => 'Exportación en JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumeración',
	'smw_printername_ul' => 'Detallar',
	'smw_printername_rss' => 'Exportación en RSS',
	'smw_printername_table' => 'Táboa',
	'smw_printername_broadtable' => 'Táboa ampla',
	'smw_printername_template' => 'Modelo',
	'smw_paramdesc_limit' => 'O número máximo de resultados a devolver',
	'smw_paramdesc_headers' => 'Mostrar as cabeceiras/os nomes de propiedade',
	'smw_paramdesc_mainlabel' => 'A lapela para dar nome á páxina principal',
	'smw_paramdesc_link' => 'Mostrar os valores como ligazóns',
	'smw_paramdesc_intro' => 'O texto a mostrar antes dos resultados da pescuda, se houbese algún',
	'smw_paramdesc_outro' => 'O texto a mostrar despois dos resultados da pescuda, se houbese algún',
	'smw_paramdesc_default' => 'O texto a mostrar se non hai resultados para a pescuda',
	'smw_paramdesc_searchlabel' => 'O texto na ligazón aos resultados',
	'smw_paramdesc_sep' => 'O separador dos valores',
	'smw_paramdesc_template' => 'O nome dun modelo co que mostrar as impresións',
	'smw_paramdesc_columns' => 'O número de columnas nas que mostrar os resultados (3 por defecto)',
	'smw_paramdesc_embedformat' => 'A etiqueta HTML utilizada para definir as cabeceiras',
	'smw_paramdesc_embedonly' => 'Non mostrar as cabeceiras',
	'smw_paramdesc_rsstitle' => 'O texto a usar como título da fonte de novas',
	'smw_paramdesc_rssdescription' => 'O texto a usar como descrición da fonte de novas',
	'smw_iq_disabled' => 'Sentímolo. As preguntas semánticas foron deshabilitadas para este wiki.',
	'smw_iq_moreresults' => '… máis resultados',
	'smw_iq_nojs' => 'Por favor, use un nevegador co JavaScript permitido para ver este elemento.',
	'smw_iq_altresults' => 'Procurar directamente pola lista de resultados.',
	'smw_unknown_importns' => 'As funcións de importación non están dispoñibles no espazo de nomes “$1”.',
	'smw_nonright_importtype' => '$1 só pode ser usado para as páxinas co espazo de nomes “$2”.',
	'smw_wrong_importtype' => '$1 non pode ser usado para as páxinas no espazo de nomes “$2”.',
	'smw_no_importelement' => 'O elemento “$1” non está dispoñible para importar.',
	'smw_parseerror' => 'O valor dado non foi entendido.',
	'smw_notitle' => '“$1” non pode ser usado como nome de páxina neste wiki.',
	'smw_wrong_namespace' => 'Aquí só están permitidas as páxinas no espazo de nomes "$1".',
	'smw_unknowntype' => 'Tipo “$1” non soportado definido para a propiedade.',
	'smw_manytypes' => 'Máis dun tipo definido para a propiedade.',
	'smw_emptystring' => 'As cordas baleiras non están aceptadas.',
	'smw_maxstring' => 'A representación da corda $1 é demasiado longa.',
	'smw_notinenum' => '“$1” non é a lista de posibles valores ($2) para esta propiedade.',
	'smw_noboolean' => '“$1” non é recoñecido como un valor booleano (verdadeiro/falso).',
	'smw_true_words' => 'verdadeiro,v,si,s',
	'smw_false_words' => 'falso,f,non,n',
	'smw_nofloat' => '“$1” non é un número.',
	'smw_infinite' => 'Os números tan longos como "$1" non están soportados.',
	'smw_infinite_unit' => 'A conversión na unidade "$1" deu como resultado un número que é demasiado grande.',
	'smw_novalues' => 'Non se especificou ningún valor.',
	'smw_unsupportedprefix' => 'Os prefixos para os números (“$1”) non están soportados.',
	'smw_unsupportedunit' => 'Non está soportada a unidade de conversión para a unidade “$1”.',
	'smw_nodatetime' => 'A data “$1” non foi entendida.',
	'smw_toomanyclosing' => 'Parece que hai demasiados acontecementos de “$1” na pregunta.',
	'smw_noclosingbrackets' => 'Algún uso de “<nowiki>[[</nowiki>” na súa pregunta non foi pechado polo seu “]]” correspondente.',
	'smw_misplacedsymbol' => 'O símbolo “$1” foi usado nun lugar no que non era útil.',
	'smw_unexpectedpart' => 'A parte “$1” da pregunta non foi entendida.
Pode que os resultados non sexan os agardados.',
	'smw_emptysubquery' => 'Algunha subcuestión non ten unha condición válida.',
	'smw_misplacedsubquery' => 'Algunha subcuestión foi usada nun lugar onde non están permitidas.',
	'smw_valuesubquery' => 'As subcuestións non están soportadas para os valores da propiedade “$1”.',
	'smw_overprintoutlimit' => 'A pregunta contén demasiadas solicitudes de copias impresas.',
	'smw_badprintout' => 'Algunha declaración imprimida da pregunta non foi entendida.',
	'smw_badtitle' => 'Sentímolo, pero “$1” non é un título de páxina válido.',
	'smw_badqueryatom' => 'Unha parte “<nowiki>[[…]]</nowiki>” da pregunta non foi entendida.',
	'smw_propvalueproblem' => 'O valor da propiedade “$1” non foi entendido.',
	'smw_noqueryfeature' => 'Algunha característica da pregunta non está soportada neste wiki, polo que unha parte foi excluída ($1).',
	'smw_noconjunctions' => 'As conxuncións nas preguntas non están soportadas neste wiki, polo que unha parte foi excluída ($1).',
	'smw_nodisjunctions' => 'Non están soportadas as disxuncións nas preguntas neste wiki e parte desta foi ignorada ($1).',
	'smw_querytoolarge' => 'As seguintes condicións da pregunta non poden ser consideradas debido ás restricións do wiki no tamaño ou profundidade desta: $1.',
	'smw_devel_warning' => 'Actualmente esta característica está en desenvolvemento e pode que non funcione en toda a súa totalidade.
Faga unha copia de seguridade dos seus datos antes de usala.',
	'smw_notemplategiven' => 'Por favor, proporcione un valor para o parámetro “modelo” do formato desta pregunta para poder funcionar.',
	'smw_type_header' => 'Propiedades do tipo “$1”',
	'smw_typearticlecount' => 'Amosando $1 {{PLURAL:$1|propiedade|propiedades}} que {{PLURAL:$1|usa|usan}} este tipo.',
	'smw_attribute_header' => 'Páxinas que usan a propiedade “$1”',
	'smw_attributearticlecount' => 'Amosando $1 {{PLURAL:$1|páxina|páxinas}} que {{PLURAL:$1|usa|usan}} esta propiedade.',
	'smw_subproperty_header' => 'Subpropiedades',
	'smw_subpropertyarticlecount' => 'Esta propiedade ten {{PLURAL:$1|a seguinte subpropiedade|as seguintes $1 subpropiedades}}:',
	'smw_concept_header' => 'Páxinas do concepto "$1"',
	'smw_conceptarticlecount' => 'Amosando $1 {{PLURAL:$1|páxina|páxinas}} que {{PLURAL:$1|pertence|pertencen}} a ese concepto.',
	'exportrdf' => 'Exportar páxinas a RDF',
	'smw_exportrdf_docu' => 'Esta páxina permítelle obter datos dunha páxina en formato RDF.
Para exportar páxinas, insira os títulos na caixa de embaixo (un título por liña).',
	'smw_exportrdf_recursive' => 'Exportar igualmente todas as páxinas relacionadas.
Déase conta de que o resultado pode ser longo!',
	'smw_exportrdf_backlinks' => 'Exportar tamén todas as páxinas que se refiren ás páxinas exportadas.
Xera un RDF que se pode navegar.',
	'smw_exportrdf_lastdate' => 'Non exportar páxina que non tiveron cambios desde a data dada.',
	'smw_exportrdf_submit' => 'Exportar',
	'properties' => 'Propiedades',
	'smw_properties_docu' => 'As seguintes propiedades son usadas neste wiki.',
	'smw_property_template' => '$1 de tipo $2 ($3)',
	'smw_propertylackspage' => 'Todas as propiedades deberían estar descritas nunha páxina!',
	'smw_propertylackstype' => 'Non foi especificado ningún tipo para esta propiedade (asúmese o tipo $1 polo de agora).',
	'smw_propertyhardlyused' => 'Esta propiedade apenas é usada neste wiki!',
	'unusedproperties' => 'Propiedades non usadas',
	'smw_unusedproperties_docu' => 'As seguintes propiedades existen aínda que ningunha páxina faga uso delas.',
	'smw_unusedproperty_template' => '$1 de tipo $2',
	'wantedproperties' => 'Propiedades requiridas',
	'smw_wantedproperties_docu' => 'As seguintes propiedades son usadas no wiki pero aínda non teñen ningunha páxina que as describa.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uso|usos}})',
	'tooltip-purge' => 'Faga clic aquí para refrescar todas as dúbidas e modelos desta páxina',
	'smw_purge' => 'Refrescar',
	'types' => 'Tipos',
	'smw_types_docu' => 'O que segue é unha lista de todos os tipos de datos que poden ser asignados ás propiedades.
Cada tipo de datos ten unha páxina onde vén proporcionada información adicional sobre el.',
	'smw_typeunits' => 'Unidades de medida do tipo “$1”: $2',
	'semanticstatistics' => 'Estatísticas semánticas',
	'smw_semstats_text' => "Este wiki contén '''$1''' {{PLURAL:$1|valor|valores}} de propiedade, dun total {{PLURAL:$2|'''dunha'''|de '''$2'''}} [[Special:Properties|{{PLURAL:$2|propiedade|propiedades diferentes}}]].
'''$3''' {{PLURAL:$3|propiedade ten|propiedades teñen}} unha páxina propia e o tipo de datos desexado está especificado para '''$4''' de elas.
Algunhas das propiedades existentes poden [[Special:UnusedProperties|non ser usadas]].
As propiedades ás que aínda lles falta unha páxina atópanse na [[Special:WantedProperties|lista de propiedades desexadas]].",
	'uriresolver' => 'Solucionador de URI',
	'smw_uri_doc' => 'O solucionador de URI pon en práctica o <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">descubrimento da ETIQUETA de W3C en httpRange-14</a>. Vixía que os humanos non entren en sitios web.',
	'ask' => 'Procura semántica',
	'smw_ask_sortby' => 'Ordenar por columnas (opcional)',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Atopar os resultados',
	'smw_ask_editquery' => '[Editar a pregunta]',
	'smw_add_sortcondition' => '[Engadir a condición da orde]',
	'smw_ask_hidequery' => 'Agochar a dúbida',
	'smw_ask_help' => 'Axuda sobre as dúbidas',
	'smw_ask_queryhead' => 'Dúbida',
	'smw_ask_printhead' => 'Datos adicionais a mostrar',
	'smw_ask_printdesc' => '(engada un nome de propiedade por liña)',
	'smw_ask_format_as' => 'Formato como:',
	'smw_ask_defaultformat' => 'por defecto',
	'smw_ask_otheroptions' => 'Outras opcións',
	'smw_ask_show_embed' => 'Mostrar o código incrustado',
	'smw_ask_hide_embed' => 'Agochar o código incrustado',
	'smw_ask_embed_instr' => 'Para incrustar esta pesquisa en liña nunha páxina wiki use o código de embaixo.',
	'searchbyproperty' => 'Procurar por propiedade',
	'smw_sbv_docu' => 'Procurar por todas as páxinas que teñen a propiedade e o valor dados.',
	'smw_sbv_novalue' => 'Por favor, insira un valor válido para a propiedade ou vexa todos os valores das propiedades para “$1”.',
	'smw_sbv_displayresult' => 'Unha lista de todas as páxinas que teñen a propiedade “$1” co valor “$2”',
	'smw_sbv_displayresultfuzzy' => 'Unha lista con todas as páxinas que teñen a propiedade "$1" co valor "$2".
Como houbo só uns poucos resultados, tamén os resultados próximos son amosados.',
	'smw_sbv_property' => 'Propiedades:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => 'Atopar os resultados',
	'browse' => 'Navegar polo wiki',
	'smw_browselink' => 'Propiedades de navegación',
	'smw_browse_article' => 'Insira o nome da páxina para comezar o formulario de procura.',
	'smw_browse_go' => 'Ir',
	'smw_browse_show_incoming' => 'amosar as propiedades que ligan cara a aquí',
	'smw_browse_hide_incoming' => 'agochar as propiedades que ligan cara a aquí',
	'smw_browse_no_outgoing' => 'Esta páxina non ten propiedades.',
	'smw_browse_no_incoming' => 'Ningunha propiedade liga con esta páxina.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Lapela da propiedade inversa',
	'pageproperty' => 'Procura de páxinas de propiedades',
	'smw_pp_docu' => 'Procurar por todos os filtros dunha propiedade nunha páxina dada.
Por favor, insira ambas, a páxina e mais a propiedade.',
	'smw_pp_from' => 'Da páxina',
	'smw_pp_type' => 'Propiedades',
	'smw_pp_submit' => 'Atopar os resultados',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Seguinte',
	'smw_result_results' => 'Resultados',
	'smw_result_noresults' => 'Sentímolo, non hai resultados.',
	'smwadmin' => 'Funcións do administrador Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Configurando o almacenamento para Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'O motor de almacenamento foi configurado con éxito.',
	'smw_smwadmin_return' => 'Volver a "$1"',
	'smw_smwadmin_updatestarted' => 'Comezou un novo proceso de actualización para refrescar os datos semánticos.
Todos os datos almacenados serán reconstruídos ou reparados onde sexa necesario.
Pode seguir o proceso da actualización nesta páxina especial.',
	'smw_smwadmin_updatenotstarted' => 'Xa hai un proceso de actualización en curso.
Non se pode crear outro.',
	'smw_smwadmin_updatestopped' => 'Todos os procesos de actualización existentes foron detidos.',
	'smw_smwadmin_updatenotstopped' => 'Para deter os procesos de actualización actuais, debe activar a caixa de verificación para indicar que está seguro de facelo.',
	'smw_smwadmin_docu' => 'Esta páxina especial axúdarao durante a instalación e actualización do <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Lembre facer unha copia de seguranza dos datos antes de executar funcións administrativas.',
	'smw_smwadmin_db' => 'Instalación e actualización da base de datos',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki require algunhas extensións da base de datos MediaWiki para almacenar os datos semánticos.
A función de embaixo asegúrase de que a súa base de datos está configurada apropiadamente.
Os cambios feitos neste paso non afectarán ao resto da base de datos MediaWiki, e poden ser desfeitos de xeito sinxelo se se desexa.
Esta función de configuración pode ser executada múltiples veces sen facer ningún dano, pero só é necesaria unha vez na instalación ou actualización.',
	'smw_smwadmin_permissionswarn' => 'Se a operación falla con erros SQL, probablemente a base de datos empregada polo seu wiki (comprobe o seu LocalSettings.php) non teña os permisos suficientes.
Fai falla conceder a este usuario os permisos para crear e eliminar táboas; temporalmente insira o rexistro da súa base de datos en LocalSettings.php ou use a escritura de mantemento <tt>SMW_setup.php</tt>, que pode usar os credenciais de AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Inicialice ou actualice as táboas',
	'smw_smwadmin_announce' => 'Anunciar o seu wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki ten un servizo web para anunciar novos wikis semánticos.
Isto é usado para manter unha lista de sitios públicos que usan Semantic MediaWiki, principalmente para axudar ao <a href="http://semantic-mediawiki.org/wiki/SMW_Project">proxecto Semantic MediaWiki</a> para obter unha vista xeral dos usos típicos de Semantic MediaWiki.
Vaia á páxina principal de Semantic MediaWiki para <a href="http://semantic-mediawiki.org/wiki/Registry">obter máis información acerca deste servizo</a>.',
	'smw_smwadmin_announcebutton' => 'Prema o seguinte botón para enviar o enderezo URL do seu wiki a ese servizo.
O servizo non rexistrará wikis que non sexan publicamente accesibles e só almacenará información publicamente accesible.',
	'smw_smwadmin_datarefresh' => 'Reparación e actualización dos datos',
	'smw_smwadmin_datarefreshdocu' => 'É posible restaurar todos os datos de Semantic MediaWiki baseados nos contidos actuais do wiki.
Isto pode ser útil para reparar datos rotos ou para refrescar os datos se o formato interno cambiou debido a actualizacións do software.
Esta actualización é executada páxina a páxina e non será completada inmediatamente.
O seguinte amosa se unha actualización está en curso e permítelle comezalas ou detelas (a non ser que esta característica fose deshabilitada polo administrador do sitio).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Xa hai unha actualización en curso.</strong>
É normal que os progresos de actualización vaian lentos, xa que só se refrescan os datos nos pequenos anacos nos que un usuario accede ao wiki.
Para finalizar esta actualización máis rápido, pode invocar a escritura <tt>runJobs.php</tt> de mantemento de MediaWiki (use a opción <tt>--maxjobs 1000</tt> para restrinxir o número de actualizacións feitas nunha quenda).
Progreso estimado da actualización actual:',
	'smw_smwadmin_datarefreshbutton' => 'Comezar a actualizar os datos',
	'smw_smwadmin_datarefreshstop' => 'Deter esta actualización',
	'smw_smwadmin_datarefreshstopconfirm' => 'Si, estou seguro.',
	'smw_smwadmin_support' => 'Obtendo asistencia',
	'smw_smwadmin_supportdocu' => 'Diversas fontes poden axudalo en caso de problemas:',
	'smw_smwadmin_installfile' => 'Se experimenta problemas durante a súa instalación, comece comprobando a guía no <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">ficheiro INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'A documentación do usuario completa de Semantic MediaWiki está en <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Pode informar dos erros en <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Se ten máis preguntas ou suxestións, únase á conversa no <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">foro de usuarios de Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Estrutura dos datos',
	'smw_adminlinks_displayingdata' => 'Mostrando os datos',
	'smw_adminlinks_inlinequerieshelp' => 'Axuda sobre as pescudas',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Crazymadlover
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'smw_finallistconjunct' => ', καὶ',
	'smw_printername_template' => 'Πρότυπον',
	'smw_nofloat' => 'Τὸ "$1" οὐκ ἔστιν ἀριθμός.',
	'smw_exportrdf_submit' => 'Ἐξάγειν',
	'properties' => 'Ἰδιότητες',
	'types' => 'Τύποι',
	'smw_ask_queryhead' => 'Πεῦσις',
	'smw_ask_format_as' => 'Μορφοποιεῖν ὡς:',
	'smw_ask_defaultformat' => 'προκαθωρισμένη',
	'smw_sbv_property' => 'Ἰδιότης:',
	'smw_sbv_value' => 'Τιμή:',
	'smw_browse_go' => 'Ἱέναι',
	'smw_inverse_label_default' => '$1 τοῦ',
	'smw_pp_type' => 'Ἰδιότης',
	'smw_result_prev' => 'Προηγουμέναι',
	'smw_result_next' => 'Ἑπόμεναι',
	'smw_result_noresults' => 'Οὐδὲν ἀποτέλεσμα.',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'smw-desc' => "Dyy Wiki zuegängliger mache - fir Maschine ''un'' Mänsche ([http://semantic-mediawiki.org/wiki/Help:User_manual online-Dokumäntation])",
	'smw_edithelp' => 'Bearbeitigshilf fir Eigeschafte',
	'smw_viewasrdf' => 'RDF-Feed',
	'smw_finallistconjunct' => ' un',
	'smw_factbox_head' => 'Fakte zue $1',
	'smw_isspecprop' => 'Die Eigeschaft isch e Spezialeigeschaft in däm Wiki.',
	'smw_isknowntype' => 'Dää Datentyp ghert zue dr Standardtype in däm Wiki.',
	'smw_isaliastype' => 'Dää Datetyp isch e Alias fir dr Typ „$1“.',
	'smw_isnotype' => 'Dr Datetyp „$1“ isch kei Standardtyp in däm Wiki un het au kei Definition uf syynere Syte, wu tet länge.',
	'smw_concept_description' => 'Bschryybig vum Konzäpt „$1“',
	'smw_no_concept_namespace' => "Konzäpt chenne nume im ''Konzäpt:'' Namensruum aagleit wäre.",
	'smw_multiple_concepts' => 'In jedwädere Konzäptsyte cha s nume ei Konzäptdefinition din haa.',
	'smw_concept_cache_miss' => 'S Konzäpt „$1“ cha im Momänt nit aagwändet wäre, wel d Wiki-Konfiguration offline grächnet muess wäre.
Wänn s Probläm imfall noch eme Rung nit verschwindet, no bitt Dyy Syteverwalter, des Konzäpt megli z mache.',
	'smw_noinvannot' => 'Wärt chenne nit mit umgchehrte Eigeschafte gchännzeichnet wäre',
	'smw_baduri' => 'URI mit dr Form „$1“ sin nit zuelässig.',
	'smw_printername_auto' => 'Automatisch',
	'smw_printername_count' => 'Zellerergebnis',
	'smw_printername_csv' => 'CSV-Export',
	'smw_printername_debug' => 'Debug-Abfrog (fir Experte)',
	'smw_printername_embedded' => 'Inhalt vu yyböute Syte',
	'smw_printername_json' => 'JSON-Export',
	'smw_printername_list' => 'Lischt',
	'smw_printername_ol' => 'Uflischtig',
	'smw_printername_ul' => 'Ufgliderig',
	'smw_printername_rss' => 'RSS-Export',
	'smw_printername_table' => 'Tabälle',
	'smw_printername_broadtable' => 'Breiti Tabälle',
	'smw_printername_template' => 'Vorlag',
	'smw_paramdesc_limit' => 'Di maximal Aazahl vu Ergebnis, wu zruck gee solle wäre',
	'smw_paramdesc_headers' => 'Chopfzyyle bzw. d Nämme vu dr Eigeschafte aazeige',
	'smw_paramdesc_mainlabel' => 'S Label vu Hauptsytename',
	'smw_paramdesc_link' => 'Wärt as Gleicher (Links) aazeige',
	'smw_paramdesc_intro' => 'Dr Text, wu vor dr Suechergebnis soll aazeigt wäre, wänn s het',
	'smw_paramdesc_outro' => 'Dr Text, wu no dr Suechergebnis soll aazeigt wäre, wänn s het',
	'smw_paramdesc_default' => 'Dr Text, wu soll aazeigt wäre, wänn s kei Suechergebnis het',
	'smw_paramdesc_searchlabel' => 'Text im Gleich (Link) zue dr Ergebnis',
	'smw_paramdesc_sep' => 'S Trännzeiche fir Wärt',
	'smw_paramdesc_template' => 'Dr Name vu dr Vorlag, wu Uusdruck dermit solle aazeigt wäre',
	'smw_paramdesc_columns' => 'D Aazahl vu dr Spalte go Ergebnis aazeige (Standard isch $1)',
	'smw_paramdesc_embedformat' => 'Dr HTML-Befähl zum Iberschrifte definiere',
	'smw_paramdesc_embedonly' => 'Kei Iberschrifte aazeige',
	'smw_paramdesc_rsstitle' => 'Dr Text, wu as Titel fir dr Kanal soll brucht wäre',
	'smw_paramdesc_rssdescription' => 'Dr Text, wu as Bschryybig fir dr Kanal soll brucht wäre',
	'smw_iq_disabled' => 'Semantischi Aafroge sin in däm Wiki zur Zyt nit megli.',
	'smw_iq_moreresults' => '… meh Ergebniss',
	'smw_iq_nojs' => 'Dr Inhalt vu däm Elemänt cha mit eme Browser mit JavaScript-Unterstitzig bschaut wäre.',
	'smw_iq_altresults' => 'Suechergebnis as Lischt aazeige.',
	'smw_unknown_importns' => 'Fir dr Namensruum „$1“ sin leider kei Importfunktione verfiegbar.',
	'smw_nonright_importtype' => 'S Elemänt „$1“ cha nume fir Syte im Namensruum „$2“ bruucht wäre.',
	'smw_wrong_importtype' => 'S Elemänt „$1“ cha nit fir Syte im Namensruum „$2“ bruucht wäre.',
	'smw_no_importelement' => 'S Elemänt „$1“ stoht leider nit zum Importiere z Verfiegig.',
	'smw_parseerror' => 'Dr Wärt, wu Du yygee hesch, isch nit verstande wore.',
	'smw_notitle' => '„$1“ cha nit as Sytename in däm Wiki bruucht wäre.',
	'smw_wrong_namespace' => 'Nume Syten im Namensruum „$1“ sin doo zuelässig.',
	'smw_unknowntype' => 'Imn dr Eigeschaft isch dr nit bekannt Datetyp „$1“ zuegwise wore.',
	'smw_manytypes' => 'In dr Eigeschaft sin e paar Datetype zuegwise wore.',
	'smw_emptystring' => 'Lääri Zeichefolge wäre nit akzeptiert.',
	'smw_maxstring' => 'D Zeichechette „$1“ isch z lang.',
	'smw_notinenum' => '„$1“ ghert nit zue dr meglige Wärt vu däre Eigeschaft ($2).',
	'smw_noboolean' => '„$1“ isch kei Wohretswärt (wohr/falsch).',
	'smw_true_words' => 'wohr,w,jo,j',
	'smw_false_words' => 'falsch,f,nei,n',
	'smw_nofloat' => '„$1“ isch kei Zahl.',
	'smw_infinite' => 'D Zahl „$1“ isch z lang.',
	'smw_infinite_unit' => 'D Umrächnig in d Eiheit „$1“ isch nit megli: d Zahl isch z lang.',
	'smw_novalues' => 'Kei Wärt spezifiziert.',
	'smw_unsupportedprefix' => 'Vornedra gstellti Zeiche bi Dezimalzahle („$1“) wäre nit unterstitzt.',
	'smw_unsupportedunit' => 'Umrächnig vu dr Eiheit „$1“ nit unterstitzt.',
	'smw_nodatetime' => 'S Datum „$1“ isch nit verstande wore.',
	'smw_toomanyclosing' => 'In dr Aafrog chemme z vyyl „$1“ vor.',
	'smw_noclosingbrackets' => 'In dr Aafrog chunnt e „<nowiki>[[</nowiki>“ vor, isch aber nit mit eme „]]“ abgschlosse.',
	'smw_misplacedsymbol' => 'S Symbol „$1“ isch an ere Stell bruucht wore, wu s nit sinnvoll isch.',
	'smw_unexpectedpart' => 'Dr Teil „$1“ vu dr Aafrog isch nit verstande wore. D Ergebnis sin villicht nit wie s erwartet woren isch.',
	'smw_emptysubquery' => 'In ere Teilaafrog het s kei Bedingig.',
	'smw_misplacedsubquery' => 'E Teilaafrog isch an ere Stell bruucht wore, wu keini Teilaafroge derfe vorchu.',
	'smw_valuesubquery' => 'Teilaafroge wäre fir Wärt vudr Eigeschaft „$1“ nit unterstitzt.',
	'smw_overprintoutlimit' => 'In dr Aafrog het s zvyyl Druckaawyysige.',
	'smw_badprintout' => 'E Druckaawyysig isch nit verstande wore.',
	'smw_badtitle' => '„$1“ isch nit zuelässig as Sytetitel.',
	'smw_badqueryatom' => 'E Teil „<nowiki>[[…]]</nowiki>“ vu dr Aafrog isch nit verstande wore.',
	'smw_propvalueproblem' => 'Dr Wärt vu dr Eigeschaft „$1“ isch nit verstande wore.',
	'smw_noqueryfeature' => 'E Teil Aafrog-Feature sin im Momänt mit däm Wiki nit megli un dää Teil vu dr Frog isch glescht wore ($1).',
	'smw_noconjunctions' => 'UND-Verchnipfige in dr Aafroge wäre in däm Wiki nit unterstitzt un dää Teil vu dr Aafrog isch glescht wore ($1).',
	'smw_nodisjunctions' => 'ODER-Verchnipfige wäre in däm Wiki nit unterstitzt un e Teil vu dr Aafrog isch glescht wore ($1).',
	'smw_querytoolarge' => 'Die Aafrogbedingige chenne für Greßi un Tiefi vu Aafroge nit berucksichtigt wäre wäge dr Beschränkige, wu in däm Wiki giltig sin: $1.',
	'smw_devel_warning' => 'Die Funktion isch zur Zyt no in dr Entwicklig un isch villicht nonig voll yysatzfähig. S wär besser, wänn Du dr Inhalt vum Wiki spycheresch, voreb Du die Funktion bruuchsch.',
	'smw_notemplategiven' => 'Ass die Aafrog cha bearbeitet wäre, muess im Parameter „template“ e Wärt yytrage syy.',
	'smw_type_header' => 'Eigeschafte mit em Datetyp „$1“',
	'smw_typearticlecount' => 'S {{PLURAL:$1|wird ei Eigeschaft|wäre $1 Eigeschafte}} mit däm Datetyp aazeigt:',
	'smw_attribute_header' => 'Syte mit dr Eigeschaft „$1“',
	'smw_attributearticlecount' => 'S {{PLURAL:$1|wird ei Syten|wäre $1 Syten}} aazeigt, wu die Eigeschaft {{PLURAL:$1|bruucht|bruuche}}:',
	'smw_subproperty_header' => 'Untereigeschafte',
	'smw_subpropertyarticlecount' => 'Die Eigeschaft het {{PLURAL:$1|die Untereigeschaft|die $1 Untereigeschafte}}:',
	'smw_concept_header' => 'Syte vum Konzäpt „$1“',
	'smw_conceptarticlecount' => 'S {{PLURAL:$1|wird ei Syten|wäre $1 Syten}} aazeigt, wu zue däm Konzäpt {{PLURAL:$1|ghert|ghere}}:',
	'exportrdf' => 'Syten as RDF exportiere',
	'smw_exportrdf_docu' => 'Doo chenne Informationen iber einzelni Syten im RDF-Format abgruefe wäre. Bitte gib d Name vu dr Syte  <i>zyylewyys</i> yy.',
	'smw_exportrdf_recursive' => 'Exportier au alli relevante Syte rekursiv. Dänk dra, ass d Ergebnis chenne arg groß syy!',
	'smw_exportrdf_backlinks' => 'Exportier au alli Syte, wu uf exportierti Syte verwyye. Leit e RDF aa, wu lyychter cha dursuecht wäre.',
	'smw_exportrdf_lastdate' => 'Exportier keini Syte, wu nimi gänderet wore sin syt em Zytpunkt, wu aagee isch.',
	'smw_exportrdf_submit' => 'Exportiere',
	'properties' => 'Eigeschafte',
	'smw_properties_docu' => 'In däm Wiki git s die Eigeschafte:',
	'smw_property_template' => '$1 mit Datetyp $2 ($3)',
	'smw_propertylackspage' => 'Alli Eigeschafte sotte uf ere Syte bschribe syy!',
	'smw_propertylackstype' => 'Fir die Eigeschaft isch kei Datetyp aagee wore ($1 wird vorerscht as Typ aagnuh).',
	'smw_propertyhardlyused' => 'Die Eigeschaft wird im Wiki chuum bruucht!',
	'unusedproperties' => 'Verwaisti Eigeschafte',
	'smw_unusedproperties_docu' => 'Die Eigeschafte git s, trotz ass si nit bruucht wäre.',
	'smw_unusedproperty_template' => '$1 mit Datetyp $2',
	'wantedproperties' => 'Gwinschti Eigeschafte',
	'smw_wantedproperties_docu' => 'Die Attribut wäre no uf keinere Syte bschribe, trotz ass si scho in däm Wiki bruucht wäre.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|Vorchu|Vorchu}})',
	'tooltip-purge' => 'Druck doo go alli Aafroge un Vorlage uf däre Syte nej lade.',
	'smw_purge' => 'nej lade',
	'types' => 'Datetype',
	'smw_types_docu' => 'Die Datetype chenne Eigeschafte zuegwise wäre. E jede Datetyp het e eigeni Syte, wu gnaueri Informatione druf chenne yytrage wäre.',
	'smw_typeunits' => 'Maßeinheite vum Datetyp „$1“: $2',
	'semanticstatistics' => 'Statischtik iber semantischi Date',
	'smw_semstats_text' => "In däm Wiki {{PLURAL:$1|isch '''1''' Wert|sin '''$1''' Wärt}} fir insgsamt '''$2''' [[Special:Properties|{{PLURAL:$2|Eigeschaft|verschideni Eigeschafte}}]] yygee wore. '''$3''' {{PLURAL:$3|Eigeschaft het|Eigeschafte hän}} e eigeni Syte un dr gwischt Datetyp isch fir '''$4''' vu däne aagee wore. E paar vo dr Eigeschafte, wu s het, chenne [[Special:UnusedProperties|verwaisti Eigeschafte]] syy. Eigeschafte, wu no ne Syte sott aagleit wäre derfir, sin in dr [[Special:WantedProperties|Lischt vu dr gwinschte Eigeschafte]] ufgfiert.",
	'uriresolver' => 'URI-Ufleser',
	'smw_uri_doc' => 'Dr URI-Ufleser setzt d Empfählige »<a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>« um. Är sorgt defir, ass Mänsche nit zue Netzsyte wäre.',
	'ask' => 'Semantischi Suechi',
	'smw_ask_sortby' => 'Sortiere no Spalte (optional)',
	'smw_ask_ascorder' => 'Obsgi',
	'smw_ask_descorder' => 'Nidsgi',
	'smw_ask_submit' => 'Ergebnis finde',
	'smw_ask_editquery' => '[Aafrog bearbeite]',
	'smw_add_sortcondition' => '[Sortieraawyysig zuefiege]',
	'smw_ask_hidequery' => 'Aafrog uusblände',
	'smw_ask_help' => 'Hilf',
	'smw_ask_queryhead' => 'Aafrog',
	'smw_ask_printhead' => 'Zuesätzligi Aagabe, wu solle aazeigt wäre',
	'smw_ask_printdesc' => '(ei Eigeschaftsname je Zyyle yyfiege)',
	'smw_ask_format_as' => 'Formatiert as:',
	'smw_ask_defaultformat' => 'Standard',
	'smw_ask_otheroptions' => 'Andri Optione',
	'smw_ask_show_embed' => 'Yyböute Code zeige',
	'smw_ask_hide_embed' => 'Yyböute Code verstecke',
	'smw_ask_embed_instr' => 'Verwänd dää Code unte go die Abstimmig in e Wikisyte yyböue.',
	'searchbyproperty' => 'Iber e Eigeschaft sueche',
	'smw_sbv_docu' => 'Diese Spezialsyte findet alli Syte, wu e bstimmte Wärt hän fir d Eigeschaft, wu aagee woren isch.',
	'smw_sbv_novalue' => 'Bitte dr gwinscht Wärt yygee oder alli Wärte fir d Eigeschaft $1 aaluege.',
	'smw_sbv_displayresult' => 'E Lischt vu allene Syte, wu e Eigeschaft $1 mit em Wärt $2 hän.',
	'smw_sbv_displayresultfuzzy' => 'E Lischt vu allene Syte, wu d Eigeschaft „$1“ mit em Wärt „$2“ hän.
Wel nume wenig Ergebnis gfunde wore sin, wäre au ähnligi Wärt ufglischtet.',
	'smw_sbv_property' => 'Eigeschaft:',
	'smw_sbv_value' => 'Wärt:',
	'smw_sbv_submit' => 'Ergebnis finde',
	'browse' => 'Wiki browse',
	'smw_browselink' => 'Eigeschaften aazeige',
	'smw_browse_article' => 'Bitte gib dr Titel vun ere Syte yy.',
	'smw_browse_go' => 'Gang',
	'smw_browse_show_incoming' => 'zeig Eigeschafte, wu do ane vergleicht sin',
	'smw_browse_hide_incoming' => 'verstecki Eigeschafte, wu do ane vergleicht sin',
	'smw_browse_no_outgoing' => 'Die Syte het kei Eigeschafte.',
	'smw_browse_no_incoming' => 'Kei Eigeschafte vergleiche uf die Syte.',
	'smw_inverse_label_default' => '$1 vu',
	'smw_inverse_label_property' => 'Umgchehrti Eigeschaftbezeichnig',
	'pageproperty' => 'Eigeschaftswärt vun ere Syte',
	'smw_pp_docu' => 'No allene Wärt sueche, wu e bstimmt Attribut fir d Syte hän, wu aagee woren isch. Gib e Syte un au ne Attribut yy.',
	'smw_pp_from' => 'Vu dr Syte',
	'smw_pp_type' => 'Eigeschaft',
	'smw_pp_submit' => 'Ergebnis aazeige',
	'smw_result_prev' => 'Zrugg',
	'smw_result_next' => 'Firschi',
	'smw_result_results' => 'Ergebnis',
	'smw_result_noresults' => 'Kei Ergebnis gfunde.',
	'smwadmin' => 'Admin-Funktione fir Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Spycherplatz fir Semantic MediaWiki yystelle',
	'smw_smwadmin_setupsuccess' => 'D Spychereinheit isch erfolgryych yygrichtet wore.',
	'smw_smwadmin_return' => 'Zrugg zue $1',
	'smw_smwadmin_updatestarted' => 'E neje Update-Prozäss fir d Aktualisierig vu dr semantische Date isch gstartet wore.
Alli gspycherete Date wäre nej aagleit oder repariert, wänn netig.
Du chasch dr Fortschritt vum Update uf däre Spezialsyte verfolge.',
	'smw_smwadmin_updatenotstarted' => 'S lauft scho ne Update-Prozäss.
S wird kei neje aagfange.',
	'smw_smwadmin_updatestopped' => 'Alli Aktualisierigsprozäss, wu s git, sin aaghalte wore.',
	'smw_smwadmin_updatenotstopped' => 'Go Prozäss aahlate, wu am laufe sin, muesch Du s Kontrollchäschtli aktiviere zum aazeige, ass Du Dir wirkli sicher bisch.',
	'smw_smwadmin_docu' => 'Die Spezialsyte hilft währed dr Installation un em Upgrade vu <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Dänk dra, wichtigi Date vor dr Uusfierig vu adminischtrative Funktione z sichere.',
	'smw_smwadmin_db' => 'Datebankinstallation un -aktualisierig',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki bruucht e paar Erwyterige an dr MediaWiki-Datebank go di semantische Date z spychere.
Die Funktion gwährleischtet, ass d Datebank richtig yygrichtet isch.
D Änderige, wu in däm Schritt gmacht wäre, stere dr Räscht vu dr MediaWiki-Datebank nit un chenne eifach zrugggsetzt wäre, wänn gwinscht.
Die Setup-Funktion cha e paar Mol uusgfiert wäre ohni Schade z verursache, s isch aber nume eimol netig bi dr  Installation oder em Update.',
	'smw_smwadmin_permissionswarn' => 'Wänn d Aktion mit eme SQL-Fähler abbricht, chennt s syy, ass dr Datebankbenutzer, wu s Wiki iber en uf d Datenbank zuegryft (lueg d Datei LocalSettings.php), nit d Rächt dezue het.
Go des Probläm lese  isch s megli, em Benutzer zuesätzligi Rächt fir s Aalege und Lesche vu Tabälle z gee, dr  Datebank-Adminischtrator zytwyys in d LocalSettings.php yyztrage oder s Wartigsskript <tt>SMW_setup.php</tt> z verwände, wu d Benutzerdate us AdminSettings.php cha verwände.',
	'smw_smwadmin_dbbutton' => 'Tabällen initialisiere oder aktualisere',
	'smw_smwadmin_announce' => 'Dyy Wiki aachinde',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki het e Netzservice zum neji semantischi Wikisyte bekannt gee.
Dää Service wird bruucht go ne Lischt kriege, weli effentligi Syte Semantic MediaWiki bruuche, in dr Hauptsach aber zum im <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic-MediaWiki-Projäkt</a> e Iberbick iber typischi Aawändige vu  Semantic MediaWiki z gee.
Lueg d Semantic-MediaWiki-Homepage fir <a href="http://semantic-mediawiki.org/wiki/Registry">meh Informatione iber dää Service</a>.',
	'smw_smwadmin_announcebutton' => 'Druck dää Chnopf go d URL vu Dynem Wiki zue däm Dienscht zuefiege.
Dää Dienscht nimmt kei Wiki uf, wu nit efffentlig zuegängig sin. Gspycheret wäre au nume effentlig zuegängigi Informatione.',
	'smw_smwadmin_datarefresh' => 'Datereparatur un -aktualisierig',
	'smw_smwadmin_datarefreshdocu' => 'S isch megli alli Datebanke vu Semantic MediaWiki uf dr Grundlag vum aktuälle Inhalt vum Wiki widerhärzstelle.
Des cha hälfe, ne kaputti Datebank nej z lade oder Date z aktualisiere, wänn wägen eme Softwareupgrade d Datebankstruktur gänderet wore isch.
S Update wird fir jedi Syte uusgfiert un wird e Wyyli bruuche.
Doo wird zeigt, eb e Update lauft un Di wird erlaubt e Update z starte oder z stoppe (usser wänn die Funktion vum Sytebetryyber deaktiviert woren isch).',
	'smw_smwadmin_datarefreshprogress' => '<strong>E Update lauft scho.</strong>
E Update bruucht nromalerwyys lang, wel d Date nume in chleine Prtione aktualisiert wäre, jedes Mol wänn eber uf s Wiki zuegryft.
Go des Update schnäller z beände, cha mer s MediaWiki-Wartigsskript <tt>runJobs.php</tt> bruuche (mit em Parameter <tt>--maxjobs 1000</tt> cha d Aazahl vu dr Updates, wu uf eimol durgfiert wäre, bschränkt wäre).
Gschätzte Fortschritt vum Update, wu grad lauft:',
	'smw_smwadmin_datarefreshbutton' => 'Mit dr Datenaktualisierig aafange',
	'smw_smwadmin_datarefreshstop' => 'Mit däre Aktualisierig ufhere',
	'smw_smwadmin_datarefreshstopconfirm' => 'Jo, ich bi mer sicher.',
	'smw_smwadmin_support' => 'Unterstitzig iberchu',
	'smw_smwadmin_supportdocu' => 'Verschideni Quälle hälfe Dir villicht bi me Problämfall:',
	'smw_smwadmin_installfile' => 'Wänn s Probläm mit dr Inschtallation git, chennt d Datei <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL</a> villicht wyterhälfe.',
	'smw_smwadmin_smwhomepage' => 'Di vollständig Benutzerdokumentation vu Semantic MediaWiki findsch uf <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Fähler chennte bi <a href="https://bugzilla.wikimedia.org/">Bugzilla</a> berichtet wäre.',
	'smw_smwadmin_questions' => 'Wänn Du meh Frogen oder Vorschleg hesch, mach mit an dr Diskussion uf <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki user forum</a>.',
	'smw_adminlinks_datastructure' => 'Datestruktur',
	'smw_adminlinks_displayingdata' => 'Date abbilde',
	'smw_adminlinks_inlinequerieshelp' => 'Hilf fir Inline-Abfroge',
);

/** Hebrew (עברית)
 * @author Amire80
 * @author Rotemliss
 * @author Udi Oron אודי אורון
 * @author YaronSh
 */
$messages['he'] = array(
	'smw-desc' => 'הופכת את הוויקי שלכם לנגיש יותר - עבור מכונות "וגם" עבור בני אדם ([http://semantic-mediawiki.org/wiki/Help:User_manual תיעוד מקוון])',
	'smw_edithelp' => 'עזרה בנושא עריכת יחסים ותכונות',
	'smw_viewasrdf' => 'הזנת RDF',
	'smw_finallistconjunct' => ', וגם',
	'smw_factbox_head' => 'עובדות על אודות $1 &mdash; לחץ <span class="smwsearchicon">+</span> בכדי למצוא דפים דומים.',
	'smw_isspecprop' => 'מאפיין זה הינו מאפיין מיוחד באתר ויקי זה.',
	'smw_isknowntype' => 'סוג זה הינו בין סוגי הנתונים התקניים של אתר ויקי זה.',
	'smw_isaliastype' => 'סוג זה הינו שם נוסף עבור סוג הנתונים "$1".',
	'smw_isnotype' => 'סוג זה "$1" אינו סוג נתונים תקני בוויקי, כמו כן לא ניתנה לו הגדרת משתמש.',
	'smw_concept_description' => 'תיאור הרעיון "$1"',
	'smw_no_concept_namespace' => 'ניתן להגדיר רעיונות רק בדפים שבמרחב השם Concept: .',
	'smw_multiple_concepts' => 'לכל דף רעיון יכולה להיות רק הגדרת רעיון אחת.',
	'smw_concept_cache_miss' => 'לא ניתן להשתמש ברעיון "$1" כרגע, כיוון שתצורת הוויקי דורשת את עיבודו באופן לא מקוון.
אם התקלה אינה נעלמת לאחר זמן מה, בקשו ממנהל האתר להפוך רעיון זה לזמין.',
	'smw_baduri' => 'כתובות מהצורה "$1" אינן מורשות.',
	'smw_printername_auto' => 'אוטומטי',
	'smw_printername_count' => 'ספירת התוצאות',
	'smw_printername_csv' => 'ייצוא ל־CVS',
	'smw_printername_embedded' => 'הטמעת תוכן הדף',
	'smw_printername_json' => 'ייצוא JSON',
	'smw_printername_list' => 'רשימה',
	'smw_printername_ol' => 'ספירה',
	'smw_printername_rss' => 'ייצוא ל־RSS',
	'smw_printername_table' => 'טבלה',
	'smw_printername_broadtable' => 'טבלה רחבה',
	'smw_printername_template' => 'תבנית',
	'smw_paramdesc_limit' => 'מספר התוצאות המרבי להחזרה',
	'smw_paramdesc_headers' => 'הצגת הכותרות/שמות המאפיינים',
	'smw_paramdesc_link' => 'הצגת ערכים כקישורים',
	'smw_paramdesc_intro' => 'הטקסט להצגה לפני תוצאות התשאול, אם יש כאלו',
	'smw_paramdesc_outro' => 'הטקסט להצגה לאחר תוצאות התשאול, אם יש כאלו',
	'smw_paramdesc_default' => 'הטקסט להצגה אם אין תוצאות תשאול',
	'smw_paramdesc_searchlabel' => 'הטקסט בקישור אל התוצאות',
	'smw_paramdesc_sep' => 'המפריד בין הערכים',
	'smw_paramdesc_columns' => 'מספר העמודות להצגת התוצאות (ברירת המחדל היא $1)',
	'smw_paramdesc_embedformat' => 'תגית ה־HTML המשמשת להגדרת כותרות',
	'smw_paramdesc_embedonly' => 'לא יוצגו כותרות',
	'smw_paramdesc_rsstitle' => 'הטקסט שישמש ככותרת ההזנה',
	'smw_paramdesc_rssdescription' => 'הטקסט שישמש לתיאור ההזנה',
	'smw_iq_disabled' => 'שאילתות סמנטיות בוטלו באתר ויקי זה.',
	'smw_iq_moreresults' => '&hellip; תוצאות נוספות',
	'smw_iq_nojs' => 'השתמשו בדפדפן התומך ב־JavaScript לצפיה ברכיב זה.',
	'smw_iq_altresults' => 'עיינו ברשימת התוצאות ישירות.',
	'smw_unknown_importns' => 'פונקציות הייבוא אינן זמינות עבור מרחב השם "$1".',
	'smw_nonright_importtype' => 'ניתן להשתמש ב־$1 אך ורק עבור דפים במרחב השם "$2".',
	'smw_wrong_importtype' => 'לא ניתן להשתמש ב־$1 עבור דפים במרחב השם "$2".',
	'smw_no_importelement' => 'הרכיב "$1" אינו זמין לייבוא.',
	'smw_parseerror' => 'הערך הניתן אינו ניתן לפענוח.',
	'smw_notitle' => 'לא ניתן להשתמש ב"$1" כשם לדף באתר ויקי זה.',
	'smw_wrong_namespace' => 'רק דפים ממרחב השם "$1" מורשים כאן.',
	'smw_unknowntype' => '[אופס! טיפוס לא מוכר "$1" הוגדר עבור תכונה זו]',
	'smw_manytypes' => 'הוגדר יותר מסוג אחד למאפיין זה.',
	'smw_emptystring' => '[אופס! לא ניתן להשתמש כאן במחרוזות ריקות]',
	'smw_maxstring' => 'ייצוג המחרוזת $1 ארוך מדי.',
	'smw_notinenum' => '"$1" אינו נמצא בערכים האפשריים ($2) למאפיין זה.',
	'smw_noboolean' => '[אופס! "$1" אינה תכונה מטיפוס נכון-לאנכון]',
	'smw_true_words' => 'true,t,yes,y,כן,נכון,אמת,חיובי,כ',
	'smw_false_words' => 'false,f,no,n,לא,לא נכון,לא-נכון,ש,שקר,שלילי,ל',
	'smw_nofloat' => '"$1" אינו מספר.',
	'smw_infinite' => 'מספרים גדולים כמו "$1" אינם נתמכים.',
	'smw_infinite_unit' => 'תוצאת ההמרה ליחידה "$1" היא מספר גדול מדי.',
	'smw_unsupportedprefix' => 'לא קיימת תמיכה בקידומות למספרים ("$1").',
	'smw_unsupportedunit' => 'אין תמיכה להמרת יחידות לטיפוס "$1"',
	'smw_nodatetime' => 'התאריך "$1" אינו מובן.',
	'smw_toomanyclosing' => 'נראה כי ישנם מופעים רבים מדי של "$1" בשאילתה.',
	'smw_noclosingbrackets' => 'בכמה מהפעמים בהם השתמשתם ב־"<nowiki>[[</nowiki>" בשאילתה לא דאגתם להציב "]]" תואם לסגירה.',
	'smw_misplacedsymbol' => 'נעשה שימוש בסימן "$1" במקום בו אינו מועיל.',
	'smw_unexpectedpart' => 'החלק "$1" מהשאילתה לא הובן.
ייתכן שהתוצאות לא יתאימו למצופה.',
	'smw_emptysubquery' => 'לאחת משאילתות המשנה אין תנאים תקינים.',
	'smw_misplacedsubquery' => 'בכמה משאילתות המשנה נעשה שימוש במקום בו שאילתות משנה אינן מורשות.',
	'smw_valuesubquery' => 'שאילתות משנה אינן נתמכות עבור ערכי המאפיין "$1".',
	'smw_badtitle' => '"$1" אינה כותרת תקינה לדף.',
	'smw_badqueryatom' => 'כמה חלקים "<nowiki>[[…]]</nowiki>" מהשאילתה לא הובנו.',
	'smw_propvalueproblem' => 'ערך המאפיין "$1" לא הובן.',
	'smw_noqueryfeature' => 'חלק מהתכונות שבשאילתה אינן נתמכות באתר ויקי זה וחלקים מהשאילתה הושמטו ($1).',
	'smw_querytoolarge' => 'לא ניתן להתחשב בתנאי השאילתה הבאה עקב מגבלות אתרי הוויקי על גודל השאילתה או על עומקה: $1.',
	'smw_devel_warning' => 'תכונה זו נמצאת כעת בפיתוח, ויתכן שאינה פעילה באופן מלא.
גבו את הנתונים שלכם לפני שתשתמשו בה.',
	'smw_notemplategiven' => 'ציינו ערך עבור הפרמטר "template" כדי שמבנה שאילתה זו יעבוד.',
	'smw_type_header' => 'מאפיינים מסוג "$1"',
	'smw_typearticlecount' => 'הצגת {{PLURAL:$1|מאפיין אחד המשתמש|$1 מאפיינים המשתמשים}} בסוג זה.',
	'smw_attribute_header' => 'דפים המשתמשים במאפיין "$1"',
	'smw_attributearticlecount' => 'הצגת {{PLURAL:$1|דף אחד המשתמש|$1 דפים המשתמשים}} במאפיין זה.',
	'smw_subproperty_header' => 'מאפייני משנה',
	'smw_subpropertyarticlecount' => 'למאפיין זה יש את {{PLURAL:$1|מאפיין המשנה הבא|$1 מאפייני המשנה הבאים}}:',
	'smw_concept_header' => 'דפים מהרעיון "$1"',
	'smw_conceptarticlecount' => 'הצגת {{PLURAL:$1|דף אחד השייך|$1 דפים השייכים}} לרעיון זה.',
	'smw_rss_description' => 'הזנת RSS של $1',
	'specialpages-group-smw_group' => 'מדיה־ויקי סמנטי',
	'exportrdf' => 'ייצוא דפים ל־RDF',
	'smw_exportrdf_docu' => 'דף זה מאפשר לכם לאחזר נתונים מדף במבנה RDF.
כדי לייצא דפים, כתבו את כותרות הדפים בתיבת הטקסט שלהלן, כותרת אחת בכל שורה.',
	'smw_exportrdf_recursive' => 'ייצוא רקורסיבי של כל הדפים הקשורים.
שימו לב שהתוצאה עלולה להיות גדולה!',
	'smw_exportrdf_backlinks' => 'כמו כן, יתבצע ייצוא של כל הדפים המפנים לדפים המיוצאים.
ייווצר RDF הניתן לעיון.',
	'smw_exportrdf_lastdate' => 'אין לייצא דפים שלא שונו מאז נקודת הזמן שצוינה.',
	'smw_exportrdf_submit' => 'ייצוא',
	'properties' => 'מאפיינים',
	'smw_properties_docu' => 'בוויקי נעשה שימוש במאפיינים הבאים.',
	'smw_property_template' => '$1 מסוג $2 ($3)',
	'smw_propertylackspage' => 'פרטי כל המאפיינים אמורים להופיע בדף!',
	'smw_propertylackstype' => 'לא צוין סוג עבור מאפיין זה (בינתיים נעשה שימוש בסוג $1).',
	'smw_propertyhardlyused' => 'בקושי נעשה שימוש במאפיין זה בוויקי!',
	'unusedproperties' => 'מאפיינים שאינם בשימוש',
	'smw_unusedproperties_docu' => 'המאפיינים הבאים קיימים למרות ששום דף אחר אינו משתמש בהם.',
	'smw_unusedproperty_template' => '$1 מסוג $2',
	'wantedproperties' => 'מאפיינים מבוקשים',
	'smw_wantedproperties_docu' => 'באתר הוויקי נעשה שימוש במאפיינים אלה, אין להם עדיין דף שיתאר אותם.',
	'smw_wantedproperty_template' => '$1 (בשימוש {{PLURAL:$2|פעם אחת|$2 פעמים}})',
	'tooltip-purge' => 'לחצו כאן כדי לרענן את כל התבניות והשאילתות בדף זה',
	'smw_purge' => 'רענון תבניות ושאילתות',
	'types' => 'טיפוסים',
	'smw_types_docu' => 'ברשימה זו מופיעים כל טיפוסי המידע שתכונות יכולות להשתמש בהם . לכל טיפוס מידע יש דף המסביר על אודותיו.',
	'smw_typeunits' => 'יחידות מידה מסוג "$1": $2',
	'semanticstatistics' => 'סטטיסטיקה סמנטית',
	'smw_semstats_text' => "אתר ויקי זה מכיל {{PLURAL:$1|ערך מאפיין '''אחד'''|'''$1''' ערכי מאפיינים}} עבור סך כולל של [[Special:Properties|{{PLURAL:$2|מאפין '''אחד'''|'''$2''' מאפיינים שונים}}]].
ל{{PLURAL:מאפיין '''אחד'''|־'''$3''' מאפיינים}} יש דף משלהם, וסוג הנתונים המיועד צוין עבור '''$4''' מאלה.
ייתכן שכמה ממהמאפיינים הקיימים הם [[Special:UnusedProperties|מאפיינים שאינם בשימוש]].
מאפיינים שעדיין חסר להם דף נמצאים ב[[Special:WantedProperties|רשימת המאפיינים המבוקשים]].",
	'uriresolver' => 'פותר הכתובות',
	'ask' => 'חיפוש סמנטי',
	'smw_ask_sortby' => 'מיון לפי טור (אופציונאלי)',
	'smw_ask_ascorder' => 'בסדר עולה',
	'smw_ask_descorder' => 'בסדר יורד',
	'smw_ask_submit' => 'חפש תוצאות',
	'smw_ask_editquery' => '[עריכת השאילתה]',
	'smw_add_sortcondition' => '[הוספת הגדרת מיון]',
	'smw_ask_hidequery' => 'הסתרת השאילתה',
	'smw_ask_help' => 'עזרה בכתיבת שאילתות',
	'smw_ask_queryhead' => 'שאילתה',
	'smw_ask_printhead' => 'נתונים נוספים להצגה',
	'smw_ask_printdesc' => '(יש להוסיף כל שם מאפיין בשורה נפרדת)',
	'smw_ask_format_as' => 'עיצוב בתור:',
	'smw_ask_defaultformat' => 'ברירת מחדל',
	'smw_ask_otheroptions' => 'אפשרויות אחרות',
	'smw_ask_show_embed' => 'הצגת קוד הטמעה',
	'smw_ask_hide_embed' => 'הסתרת קוד הטמעה',
	'searchbyproperty' => 'חיפוש לפי מאפיין',
	'smw_sbv_docu' => 'חיפוש כל הדפים שיש להם מאפיין וערך מסוימים.',
	'smw_sbv_novalue' => 'כתבו ערך תקין למאפיין, או צפו בכל ערכי המאפיינים עבור "$1".',
	'smw_sbv_displayresult' => 'רשימת כל הדפים שיש להם את המאפיין "$1" עם הערך "$2"',
	'smw_sbv_displayresultfuzzy' => 'רשימת כל הדפים בעלי המאפיין "$1" עם הערך "$2".
מאחר שיש רק מעט תוצאות, יוצגו גם ערכים סמוכים.',
	'smw_sbv_property' => 'מאפיין:',
	'smw_sbv_value' => 'ערך:',
	'smw_sbv_submit' => 'חיפוש תוצאות',
	'browse' => 'עיון בוויקי',
	'smw_browselink' => 'עיון במאפיינים',
	'smw_browse_article' => 'כתבו את שם הדף ממנו יתחיל העיון.',
	'smw_browse_go' => 'הצגה',
	'smw_browse_show_incoming' => 'הצגת מאפיינים המקשרים לכאן',
	'smw_browse_hide_incoming' => 'הסתרת מאפיינים המקשרים לכאן',
	'smw_browse_no_outgoing' => 'לדף זה אין מאפיינים.',
	'smw_browse_no_incoming' => 'אין מאפיינים המקשרים לדף זה.',
	'smw_inverse_label_default' => '$1 מתוך',
	'pageproperty' => 'חיפוש במאפייני דף',
	'smw_pp_docu' => 'חיפוש כל הנתונים הממלאים מאפיין של דף נתון.
כתבו גם את הדף וגם את המאפיין.',
	'smw_pp_from' => 'מהדף',
	'smw_pp_type' => 'מאפיין',
	'smw_pp_submit' => 'חיפוש תוצאות',
	'smw_result_prev' => 'הקודם',
	'smw_result_next' => 'הבא',
	'smw_result_results' => 'תוצאות',
	'smw_result_noresults' => 'מצטערת, אין תוצאות',
	'smwadmin' => 'תכונות ניהוליות עבור המדיה־ויקי הסמנטי',
	'smw_smwadmin_settingup' => 'הגדרת איחסון עבור המדיה־ויקי הסמנטי',
	'smw_smwadmin_setupsuccess' => 'מנוע האיחסון הוגדר בהצלחה.',
	'smw_smwadmin_return' => 'חזרה אל $1',
	'smw_smwadmin_updatestarted' => 'הותחל תהליך עדכון חדש לרענון הנתונים הסמנטיים.
כל הנתונים המאוחסנים ייבנו מחדש או יתוקנו היכן שיש צורך.
תוכלו לעקוב אחר תהליך העדכון בדף מיוחד זה.',
	'smw_smwadmin_updatenotstarted' => 'יש כבר תהליך עדכון פעיל.
לא יווצר אחד נוסף.',
	'smw_smwadmin_updatestopped' => 'כל תהליכי העדכון הקיימים נעצרו.',
	'smw_smwadmin_updatenotstopped' => 'כדי לעצור תהליך עדכון פעיל, עליכם לסמן את תיבת הסימון כדי לציין שאתם בטוחים בכך.',
	'smw_smwadmin_docu' => 'דף מיוחד זה יעזור לכם במהלך ההתקנה והשידרוג של <a href="http://semantic-mediawiki.org">המדיה־ויקי הסמנטי</a>.
זכרו לגבות את הנתונים החיוניים לכם בטרם הפעלת התכונות הניהוליות.',
	'smw_smwadmin_db' => 'התקנת ושדרוג בסיס הנתונים',
	'smw_smwadmin_dbdocu' => 'הרחבת מדיה־ויקי הסמנטי דורשת כמה הרחבות לבסיס הנתונים של מדיה־ויקי כדי לאחסן את הנתונים הסמנטיים.
הפונקציה שלהלן מוודאת שמסד הנתונים שלכם מוגדר כראוי.
השינויים שנערכים בשלב זה אינם משפיעים על שאר בסיס הנתונים של מדיה־ויקי, וניתן לבטלם בקלות אם תרצו בכך.
ניתן להפעיל את פונקציית ההגדרה הזו מספר פעמים מבלי לגרום לנזק כלשהו, אך היא נדרשת רק פעם אחת עם ההתקנה או עם שדרוג.',
	'smw_smwadmin_permissionswarn' => 'אם הפעולה נכשלת עם שגיאות SQL, למשתמש של בסיס הנתונים של אתר הוויקי שלכם (תוכלו למצוא אותו בקובץ ה־LocalSettings.php שלכם) אין הרשאות מתאימות.
אנא הוסיפו למשתמש זה הרשאות ליצירה ולמחיקה של טבלאות, כתבו את פרטי גישת העל לבסיס הנתונים לקובץ LocalSetting.php באופן זמני, או השתמשו בסקריפט התחזוקה <tt>SMW_setup.php</tt> שיכול להשתמש בהרשאות של הקובץ AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'אתחול או שדרוג טבלאות',
	'smw_smwadmin_announce' => 'הכריזו על הוויקי שלכם',
	'smw_smwadmin_announcedocu' => 'למדיה־ויקי הסמנטי ישנו שירות מקוון להכרזה על אתרי ויקי סמנטיים חדשים.
שירות זה משמש לאיחסון רשימת אתרים ציבוריים המשתמשים במדיה־ויקי הסמנטי, לרוב כדי לעזור ל<a href="http://semantic-mediawiki.org/wiki/SMW_Project">מיזם המדיה־ויקי הסמנטי</a> לקבל סקירה של שימושים טיפוסיים במדיה־ויקי הסמנטי.
עיינו בדף הבית של המדיה־ויקי הסמנטי ל<a href="http://semantic-mediawiki.org/wiki/Registry">מידע נוסף אודות שירות זה</a>.',
	'smw_smwadmin_announcebutton' => 'לחצו על הכפתור הבא כדי לשלוח את כתובת הויקי שלכם לשירות זה.
השירות לא ירשום אתרי ויקי שאינם נגישים לכלל, והמידע שיישמר יהיה מידע הזמין לכלל בלבד.',
	'smw_smwadmin_datarefresh' => 'תיקון ושידרוג נתונים',
	'smw_smwadmin_datarefreshdocu' => 'ניתן לשחזר את כל הנתונים של מדיה־ויקי הסמנטי לפי התוכן הנוכחי של אתר הוויקי.
פעולה זו עשויה להיות שימושית לתיקון נתונים שגויים או לעדכון הנתונים אם המבנה הפנימי שונה לאור שדרוג התוכנה.
העדכון מופעל דף־דף והוא לא יושלם מיד.
המידע להלן מראה האם העדכון מתבצע כעת ומאפשר לכם להתחיל או להפסיק את העדכונים (אלא אם כן תכונה זו בוטלה על ידי מנהל האתר).',
	'smw_smwadmin_datarefreshprogress' => '<strong>כבר מתבצע תהליך עדכון.</strong>
מצב בו העדכון מתקדם לאט הוא מצב נורמלי, מאחר שהנתונים מתעדכנים בחלקים קטנים בכל פעם שמשתמש ניגש לוויקי.
כדי לסיים את העדכון מהר יותר, תוכלו להפעיל את סקריפט התחזוקה <tt>runJobs.php</tt> (השתמשו באפשרות <tt>--maxjobs 1000</tt> כדי להגביל את מספר העדכונים שמתבצעים בבת אחת).
התקדמות משוערת של העדכון הנוכחי:',
	'smw_smwadmin_datarefreshbutton' => 'התחלת עדכון הנתונים',
	'smw_smwadmin_datarefreshstop' => 'עצירת עדכון זה',
	'smw_smwadmin_datarefreshstopconfirm' => 'כן, אנו בטוחים.',
	'smw_smwadmin_support' => 'קבלת תמיכה',
	'smw_smwadmin_supportdocu' => 'מגוון משאבים עומדים לרשותכם במקרה של תקלה:',
	'smw_smwadmin_installfile' => 'אם יש לכם בעיות בהתקנה, התחילו בבדיקת ההנחיות המופיעות בקובץ <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'התיעוד המלא למשתמשי המדיה־ויקי הסמנטי נמצא בכתובת <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'ניתן לדווח על באגים ב<a href="https://bugzilla.wikimedia.org/">באגזילה של מדיה־ויקי</a>.',
	'smw_smwadmin_questions' => 'אם יש לכם הצעות או שאלות נוספות, הצטרפו לדיון שנערך ב<a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">פורום המשתמשים של Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'מבנה הנתונים',
	'smw_adminlinks_displayingdata' => 'הצגת נתונים',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 */
$messages['hi'] = array(
	'smw_edithelp' => 'गुणधर्मोंकी सहायता बदल रहें हैं',
	'smw_viewasrdf' => 'RDF फ़ीड',
	'smw_finallistconjunct' => ', और',
	'smw_factbox_head' => '$1 के बारेमें फ़ैक्ट्स',
	'smw_iq_moreresults' => '… आगे के रिज़ल्ट',
	'smw_true_words' => 'सही,t,हां,y',
	'smw_false_words' => 'गलत,f,ना,n',
	'smw_nofloat' => '“$1” यह संख्या नहीं हैं।',
	'smw_type_header' => '“$1” प्रकारके गुणधर्म',
	'properties' => 'गुणधर्म',
	'unusedproperties' => 'इस्तेमाल न किये हुए गुणधर्म',
	'smw_unusedproperty_template' => '$2 प्रकारके $1',
	'wantedproperties' => 'चाहिये होनेवाले गुणधर्म',
);

/** Hiligaynon (Ilonggo)
 * @author Jose77
 */
$messages['hil'] = array(
	'smw_browse_go' => 'Lakat',
);

/** Croatian (Hrvatski)
 * @author Dalibor Bosits
 */
$messages['hr'] = array(
	'smw_browse_go' => 'Kreni',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'smw-desc' => "Twój wiki přistupniši činić - za mašiny ''a'' ludźi ([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentacija online])",
	'smw_edithelp' => 'Wobźěłowanska pomoc za kajkosće',
	'smw_viewasrdf' => 'RDF-kanal',
	'smw_finallistconjunct' => 'a',
	'smw_factbox_head' => 'Fakty wo $1',
	'smw_isspecprop' => 'Tuta kajkosć je specialna kajkosć w tutym wikiju.',
	'smw_isknowntype' => 'Tutón typ słuša k standardnym datowym typam tutoho wikija.',
	'smw_isaliastype' => 'Tutón typ je lias za datowy typ "$1".',
	'smw_isnotype' => 'Tutón typ "$1" njeje standardny datowy typ w tutym wikiju a nima ani wužiwarsku definiciju.',
	'smw_concept_description' => 'Wopisanje koncepta "$1"',
	'smw_no_concept_namespace' => "Koncepty hodźa so jenož w mjenowym rumje ''Koncept:'' definować.",
	'smw_multiple_concepts' => 'Kóžda konceptowa strona móže jenož jednu konceptowu definiciju měć.',
	'smw_concept_cache_miss' => 'Koncept "$1" njeda so tuchwilu wužiwać, dokelž wikijowa konfiguracija jón za předźěłowanje offline trjeba.
Jeli so problem po wěstym času njezhubi, woprašej so sydłoweho administratora, zo by wón tutón koncept k dispoziciji stajił.',
	'smw_noinvannot' => 'Hódnoty njedadźa so nawopačnym kajkosćam připokazać.',
	'smw_baduri' => 'URI formy "$1" njejsu dowolene.',
	'smw_printername_auto' => 'Awtomatiski',
	'smw_printername_count' => 'Wuslědki ličić',
	'smw_printername_csv' => 'Eksport CSV',
	'smw_printername_debug' => 'Naprašowanje za zmylkami přepytać (za ekspertow)',
	'smw_printername_embedded' => 'Wobsah strony zasadźić',
	'smw_printername_json' => 'Eksport JSON',
	'smw_printername_list' => 'Lisćina',
	'smw_printername_ol' => 'Naličenje',
	'smw_printername_ul' => 'Nalistowanje',
	'smw_printername_rss' => 'Eksport RSS',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Šěroka tabela',
	'smw_printername_template' => 'Předłoha',
	'smw_paramdesc_limit' => 'Maksimalna ličba wuslědkow, kotraž ma so wróćić',
	'smw_paramdesc_headers' => 'Mjena hłowow abo atributow zwobraznić',
	'smw_paramdesc_mainlabel' => 'Pomjenowanje, kotrež ma so hłownej stronje dać',
	'smw_paramdesc_link' => 'Hódnoty jako wotkazy pokazać',
	'smw_paramdesc_intro' => 'Tekst, kotryž ma so před naprašowanskimi wuslědkami zwobraznić, jeli tajke su',
	'smw_paramdesc_outro' => 'Tekst, kotryž ma so za naprašowanskimi wuslědkami zwobraznić, jeli tajke su',
	'smw_paramdesc_default' => 'Tekst, kotryž ma so zwobraznić, jeli žane naprašowanske wuslědki njejsu',
	'smw_paramdesc_searchlabel' => 'Tekst wotkaza do wuslědkow',
	'smw_paramdesc_sep' => 'Dźělatko za hódnoty',
	'smw_paramdesc_template' => 'Mjeno předłohi, z kotrejž maja so wućišće zwobraznić',
	'smw_paramdesc_columns' => 'Ličba špaltow, w kotrychž maja so wuslědki zwobraznić (standard je $1)',
	'smw_paramdesc_embedformat' => 'HTML-taflički, kotrež so wužiwaja, zo bychu nadpisma definowali',
	'smw_paramdesc_embedonly' => 'Žane nadpisma zwobraznić',
	'smw_paramdesc_rsstitle' => 'Tekst, kotryž ma so jako titul kanala wužiwać',
	'smw_paramdesc_rssdescription' => 'Tekst, kotryž ma so jako wopisanje kanala wužiwać',
	'smw_iq_disabled' => 'Semantiske naprašowanja su w tutym wikiju znjemóžnjene.',
	'smw_iq_moreresults' => '... dalše wuslědki',
	'smw_iq_nojs' => 'Wužij wobhladowak, kotryž JavaScritp podpěruje, zo by sej tutón element wobhladał.',
	'smw_iq_altresults' => 'Lisćinu wuslědkow direktnje přepytać.',
	'smw_unknown_importns' => 'Za mjenowy rum "$1"  importowanske funkcije k dispoziciji njesteji.',
	'smw_nonright_importtype' => '$1 da so jenož za strony w mjenowym rumje "$2" wužiwać.',
	'smw_wrong_importtype' => '$1 njeda so za strony w mjenowym rumje "$2" wužiwać.',
	'smw_no_importelement' => 'Element "$1" za importowanje k dispoziciji njesteji.',
	'smw_parseerror' => 'Podata hódnota njebu zrozumjena.',
	'smw_notitle' => '"$1" njeda so jako mjeno strony w tutym wikiju wužiwać.',
	'smw_wrong_namespace' => 'Jenož strony w mjenowym rumje "$1" su tu dowolene.',
	'smw_unknowntype' => 'Za kajkosć bu njepodpěrowany typ "$1" definowany.',
	'smw_manytypes' => 'Za kajkosć bu wjace hač jeden typ definowany.',
	'smw_emptystring' => 'Prózdne znamješkowe slědy so njeakceptuja.',
	'smw_maxstring' => 'Znamješkowy slěd $1 je předołhi.',
	'smw_notinenum' => '"$1" w lisćinje móžnych hódnotow ($2) za tutu kajkosć njeje.',
	'smw_noboolean' => '"$1" płaćiwa hódnota typa boolean (wěrny/njewěrny) njeje.',
	'smw_true_words' => 'wěrny, haj, true',
	'smw_false_words' => 'wopak, njewěrny, ně, false',
	'smw_nofloat' => '"$1" ličba njeje.',
	'smw_infinite' => 'Ličby, kotrež su tak wulke kaž "$1", so njepodpěruja.',
	'smw_infinite_unit' => 'Konwertowanje do jednotki "$1" wjedźeše k ličbje, kotraž je předołha.',
	'smw_novalues' => 'Žane hódnoty podate.',
	'smw_unsupportedprefix' => 'Prefiksy za ličby ("$1") so njepodpěruja.',
	'smw_unsupportedunit' => 'Konwertowanje jednotki "$1" so njepodpěruje.',
	'smw_nodatetime' => 'Datum "$1" njebu zrozumjeny.',
	'smw_toomanyclosing' => 'Zda so, zo "$1" w tutym naprašowanju přehusto wustupuje.',
	'smw_noclosingbrackets' => 'Wustupowanje pora róžkatych spinkow "<nowiki>[[</nowiki>" w twojim naprašowanju njeje přez wotpowědny "]]" wukónčene.',
	'smw_misplacedsymbol' => 'Symbol "$1" so na městnje wužiwa, hdźež wužitny njeje.',
	'smw_unexpectedpart' => 'Dźěl "$1" naprašowanja njebu zrozumjeny.
Wuslědki snano kaž wočakowane njejsu.',
	'smw_emptysubquery' => 'Někajke podnaprašowanje nima płaćiwe wuměnjenje.',
	'smw_misplacedsubquery' => 'Někajke podnaprašowanje so na městnje wužiwa, hdźež podnaprašowanja njejsu dowolene.',
	'smw_valuesubquery' => 'Podnaprašowanja so za hódnoty kajkosće "$1" njepodpěruja.',
	'smw_overprintoutlimit' => 'Wotprašowanje wobsahuje přewjele wudawanskich naprašowanjow.',
	'smw_badprintout' => 'Wudawanska instrukcija w wotprašowanju je so skomoliła.',
	'smw_badtitle' => '"$1" płaćiwy titul strony njeje.',
	'smw_badqueryatom' => 'Dźěl "<nowiki>[[…]]</nowiki>" naprašowanja njebu zrozumjeny.',
	'smw_propvalueproblem' => 'Hódnota kajkosće "$1" njebu zrozumjena.',
	'smw_noqueryfeature' => 'Wotprašowanska funkcija njepodpěruje so w tutym wikiju a dźěl wotprašowanja je so wotstronił ($1).',
	'smw_noconjunctions' => 'A-zwjazanja we wotprašowanajch njepodpěruja so w tutym wikiju a dźěl wotprašowanja je so wotstronił ($1).',
	'smw_nodisjunctions' => 'ABO-zwjazanja we wotprašowanjach njepodpěruja so w tutym wikiju a dźěl wotprašowanja je so wotstronił ($1).',
	'smw_querytoolarge' => 'Slědowace naprašowanske wuměnjenja njedachu so dla wikijowych wobmjezowanjow za wulkosć abo hłubokosć naprašowanja wobkedźbować: $1.',
	'smw_devel_warning' => 'Tuta funkcija je tuchwilu hišće we wuwiću a móhło być, zo hišće korektnje funguje. Zawěsć swoje daty, prjedy hač ju wužiwa.',
	'smw_notemplategiven' => 'Podaj hódnotu za parameter "template", zo by tutón naprašowanski format fungował.',
	'smw_type_header' => 'Kajkosće typa "$1"',
	'smw_typearticlecount' => '{{PLURAL:$1|Pokazuje so kajkosć, kotraž tutón typ wužiwa|Pokazujetej so $1 kajkosći, kotrejž tutón typ wužiwatej|Pokazuja so $1 kajkosće, kotrež tutón typ wužiwaja|Pokazuje so $1 kajkosćow, kotrež tutón typ wužiwa}}.',
	'smw_attribute_header' => 'Strony, kotrež kajkosć "$1" wužiwaja',
	'smw_attributearticlecount' => '{{PLURAL:$1|Pokazuje so $1 strona, kotraž tutu kajkosć wužiwa|Pokazujetej $1 stronje, kotrejž tutu kajkosć wužiwatej|Pokazuja so $1 strony, kotrež tutu kajksć wužiwaja|Pokazuje so $1 stronow, kotrež tutu kajkosć wužiwa}}.',
	'smw_subproperty_header' => 'Podkajkosće',
	'smw_subpropertyarticlecount' => 'Tuta kajkosć ma {{PLURAL:$1|slědowacu podkajkosć|slědowacej $1 podkajkosći|slědowace $1 podkajkosće|slědowacych $1 podkajkosćow}}:',
	'smw_concept_header' => 'Strony koncepta "$1"',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Pokazuje so $1 strona, kotraž|Pokazujetej so $1 stronje, kotrejž|Pokazuja so $1, kotrež|Pokazuje so $1 stronow, kotrež}} k tutomu konceptej {{PLURAL:$1|słuša|słušatej|słušeja|słuša}}.',
	'exportrdf' => 'Do RDF eksportować',
	'smw_exportrdf_docu' => 'Tuta strona ći zmóžnja daty ze strony we formaće RDF wotwołać. Zo by strony eksportował, zapodaj titule w slědowacym kašćiku, jedyn titul na linku.',
	'smw_exportrdf_recursive' => 'Eksportuj wšě piwuzne strony.
Wobkedźbuj, zo wuslědk móhł wulki być!',
	'smw_exportrdf_backlinks' => 'Eksportuj tež wšě strony, kotrež so na eksportowane strony poćahuja.
Płodźi přepytujomny RDF.',
	'smw_exportrdf_lastdate' => 'Njeeksportuj strony, kotrež njejsu so wot podateho časoweho dypka změnili.',
	'smw_exportrdf_submit' => 'Eksportować',
	'properties' => 'Kajkosće',
	'smw_properties_docu' => 'Slědowace kajkosće so we wikiju wužiwaja.',
	'smw_property_template' => '$1 typa $2 ($3)',
	'smw_propertylackspage' => 'Wšě kajkosće měli so přez stronu wopisać!',
	'smw_propertylackstype' => 'Za tutu kajkosć njeje so žadyn typ podał (mjeztym so typ $1 předpokładuje).',
	'smw_propertyhardlyused' => 'Tuta kajkosć so we wikiju lědma wužiwa!',
	'unusedproperties' => 'Njewužiwane kajkosće',
	'smw_unusedproperties_docu' => 'Slědowace kajkosće eksistuja, hačrunjež žana druha strona je wužiwa.',
	'smw_unusedproperty_template' => '$1 typa $2',
	'wantedproperties' => 'Požadane kajkosće',
	'smw_wantedproperties_docu' => 'Slědowace kajkosće so we wikiju wužiwaja, ale nimaja stronu, kotraž je wopisuje.',
	'smw_wantedproperty_template' => '$1 ({{PLURAL:$2|jónu wužity|dwójce wužitej|$2 razy wužite|$2 razow wužite}})',
	'tooltip-purge' => 'Klikń tu, zo by wšě naprašowanja a předłohi na tutej stronje aktualizował',
	'smw_purge' => 'Aktualizować',
	'types' => 'Typy',
	'smw_types_docu' => 'Deleka je lisćina wšěch datowych typow, kotrež dadźa so kajkosćam připokazać.
Kóždy datowy typ ma stronu, hdźež móžeš přidatne informacije namakać.',
	'smw_typeunits' => 'Měrjenske jednotki typa "$1": $2',
	'semanticstatistics' => 'Semantiska statistika',
	'smw_semstats_text' => "Tutón wiki wobsahuje '''$1''' {{PLURAL:$1|kajkostnu hódnotu|kajkostnej hódnoće|kajkostne hódnoty|kajkostnych hódnotow}} za dohromady '''$2''' [[Special:Properties|{{PLURAL:$2|kajkosć|rozdźělnej kajkosći|rozdźělne kajkosće|rozdźělnych kajkosćow}}]].
'''$3''' {{PLURAL:$3|kajkosć ma|kajkosći matej|kajkosće maja|kajkosćow ma}} swójsku stronu, a požadany datowy typ je za '''$4''' z nich podaty.
Někotre z eksistowacych kajkosćow móhli [[Special:UnusedProperties|njewužiwane kajkosće]] być. Kajkosće, kotrež stronu nimaja, su na [[Special:WantedProperties|lisćinje požadanych kajkosćow]].",
	'uriresolver' => 'Rezolwer URI',
	'smw_uri_doc' => 'Rozpušćak URI implementuje <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>.
Stara so wo to, zo so ludźo z websydłami njestanu.',
	'ask' => 'Semantiske pytanje',
	'smw_ask_sortby' => 'Po špalće sortěrować (opcionalny)',
	'smw_ask_ascorder' => 'Postupowacy',
	'smw_ask_descorder' => 'Spadowacy',
	'smw_ask_submit' => 'Wuslědki namakać',
	'smw_ask_editquery' => '[Naprašowanje wobdźěłać]',
	'smw_add_sortcondition' => '[Sortěrowanske wuměnjenje přidać]',
	'smw_ask_hidequery' => 'Naprašowanje schować',
	'smw_ask_help' => 'Pomoc za naprašowanja',
	'smw_ask_queryhead' => 'Naprašowanje',
	'smw_ask_printhead' => 'Přidatne daty, kotrež maja so zwobraznić',
	'smw_ask_printdesc' => '(přidaj jedne atributowe mjeno na linku)',
	'smw_ask_format_as' => 'Formatować jako:',
	'smw_ask_defaultformat' => 'standard',
	'smw_ask_otheroptions' => 'Druhe opcije',
	'smw_ask_show_embed' => 'Zasadźeny kod pokazać',
	'smw_ask_hide_embed' => 'Zasadźeny kod schować',
	'smw_ask_embed_instr' => 'Wužij slědowacy kod, zo by tute wotprašowanje do wikijoweje strony zasadźił.',
	'searchbyproperty' => 'Po kajkosći pytać',
	'smw_sbv_docu' => 'Wšě strrony pytać, kotrež maja wěstu kajkosć a hódnotu.',
	'smw_sbv_novalue' => 'Zapodaj płaćiwu hódnotu za kajkosć abo wobhladaj sej wšě hódnoty kajkosće za "$1".',
	'smw_sbv_displayresult' => 'Lisćina wšěch stronow, kotrež maja kajkosć "$1" z hódnotu "$2"',
	'smw_sbv_displayresultfuzzy' => 'Lisćina wšěch stronow, kotrež maja kajkosć "$1" z hódnotu "$2".
Dokelž je jenož mało wuslědkow, so tež podobne hódnoty nalistuja.',
	'smw_sbv_property' => 'Kajkosć:',
	'smw_sbv_value' => 'Hódnota:',
	'smw_sbv_submit' => 'Wuslědki namakać',
	'browse' => 'Wiki přepytać',
	'smw_browselink' => 'Kajkosće přepytać',
	'smw_browse_article' => 'Zapodaj mjeno strony, wot kotrejež ma so pytanje započeć.',
	'smw_browse_go' => 'Wotpósłać',
	'smw_browse_show_incoming' => 'kajkosće pokazać, kotrež sem wotkazuja',
	'smw_browse_hide_incoming' => 'kajkosće schować, kotrež sem wotkazuja',
	'smw_browse_no_outgoing' => 'Tuta strona nima kajkosće.',
	'smw_browse_no_incoming' => 'Žane kajkosće k tutej stronje njewotkazuja.',
	'smw_inverse_label_default' => '$1 z',
	'smw_inverse_label_property' => 'Pomjenowanje nawopačneje kajkosće',
	'pageproperty' => 'Pytanje kajkosćow strony',
	'smw_pp_docu' => 'Pytaj wšě hódnoty kajkosće na datej stronje.
Zapodaj stronu kaž tež kajkosć.',
	'smw_pp_from' => 'Ze strony',
	'smw_pp_type' => 'Kajkosć',
	'smw_pp_submit' => 'Wuslědki namakać',
	'smw_result_prev' => 'Předchadny',
	'smw_result_next' => 'Přichodny',
	'smw_result_results' => 'Wuslědki',
	'smw_result_noresults' => 'Žane wuslědki.',
	'smwadmin' => 'Administraciske funkcije za Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Składowanski rum za Semantic MediaWiki nastajić',
	'smw_smwadmin_setupsuccess' => 'Składowanska jednotka je so wuspěšnje nastajiła.',
	'smw_smwadmin_return' => 'Wróćo k $1',
	'smw_smwadmin_updatestarted' => 'Nowy proces aktualizacije za wobnowjenje semantiskich datow bu startowany.
Wšě składowane daty budu so znowa tworić abo porjedźeć, hdźež je trěbne.
Móžeš proces aktualizacije na tutej specialnej stronje slědować.',
	'smw_smwadmin_updatenotstarted' => 'Proces aktualizacije hižo běži.
Nowy so njezapočnje.',
	'smw_smwadmin_updatestopped' => 'Wšě eksistowace aktualizaciske procesy su so zastajili.',
	'smw_smwadmin_updatenotstopped' => 'Zo by běžny aktualizowanski proces zastajił, dyrbiš kontrolny kašćik aktiwizować, zo by podał, zo sy sej woprawdźe wěsty.',
	'smw_smwadmin_docu' => 'Tuta specialna strona ći za instalaciju a akutalizaciju <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a> pomha.
Njezabudź hódnotne daty zawěsćić, prjedy hač administratiwne funkcije wuwjedźeš.',
	'smw_smwadmin_db' => 'Instalacija a aktualizacija datoweje banki',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki trjeba někotre rozšěrjenja na datowej bance MediaWiki, zo by semantiske daty składował.
Slědowaca funkcija zawěsćuje, zo twoja datowa banka je prawje zarjadowana.
Změny, kotrež so w tutym kroku činja, njewobwliwuja zbytk datowje banki MediaWiki a dadźa so lochko cofnyć, jeli požadane.
Tuta zarjadowanska funkcija da so wjacore razy wuwjesć, bjeztoho zo so škoda zawinuje, je wšak jenož jedyn raz při instalaciji abo aktualizaciji trěbna.',
	'smw_smwadmin_permissionswarn' => 'Jeli operacija so ze zmylkami SQL njeradźi, najskerje wužiwar datoweje banki, kotrehož twój wiki wužiwa (hlej twoju dataju LocalSettings.php), dosahace prawa nima.
Zaruč tute přidatne wužiwarske prawa za wutworjenje a wušmórnjenje tabelow, zapodaj nachwilu přizjewjenje twojeho administratora datoweje banki do dataje LocalSettings.php abo wužij wothladowanski skript <tt>SMW_setup.php</tt>, kotryž móže wužiwarske daty z dataje AdminSettings.php wužiwać.',
	'smw_smwadmin_dbbutton' => 'Tabele inicializować abo aktualizować',
	'smw_smwadmin_announce' => 'Twój wiki připowědźić',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki ma websłužbu za wozjewjenje nowych semantiskich wikisydłow.
To so wužiwa, zo by so lisćina zjawnych sydłow wothladowała, kotrež Semantic MediaWiki wužiwaja, hłownje, zo by <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projektej Semantic MediaWiki</a> pomhała, zo by přehlad wo typiskich wužiwanskich móžnosćach Semantic MediaWiki dóstał.
Hlej startowu stronu Semantic MediaWiki za <a href="http://semantic-mediawiki.org/wiki/Registry">dalše informacije wo tutej słužbje</a>.',
	'smw_smwadmin_announcebutton' => 'Klikń na slědowace tłóčatko, zo by swój wikijowy URL tutej słužbje pósłał.
Słužba njebudźe wikije registrować, kotrež zjawnje přistupnje njejsu, a budźe jenož zjawnje přistupne informacije składować.',
	'smw_smwadmin_datarefresh' => 'Porjedźenje a aktualizacija datow',
	'smw_smwadmin_datarefreshdocu' => 'Je móžno wšě daty ze Semantic MediaWiki na zakładźe aktualneho wobsaha wikija wobnowić. To móže wužitne być, zo bychu so wobškodźene daty porjedźili abo daty aktualizowali, jeli interny format je so aktualizacije softwary dla změnił.
Aktualizacija so stronu po stronu přewjedźe a njebudźe so hnydom kónčić.
Naslědne pokazuje, jeli aktualizacija so wotměwa a ći dowoluje aktualizacije startować abo zastajić (chibazo tuta funkcija bu wot administratora sydła znjemóžnjena).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Aktualizacija so hižo wotměwa.</strong>
Je normalnje, zo so aktualizacija jenož pomału wotměwa, dokelž daty jenož w małych porcijach kóždy raz, hdyž wužiwar ma přistup na wiki, aktualizuje.
Zo by tutu aktualizaciju spěšnišo skónčił, móžeš wothladowanski skript MediaWiki <tt>runJobs.php</tt> zawołać (wužij opciju <tt>--maxjobs 1000</tt>, zo by ličbu aktualizacijow, kotrež so z jednym wotmachom přewjedu, wobmjezował).
Trochowany staw aktualneje aktualizacije:',
	'smw_smwadmin_datarefreshbutton' => 'Aktualizaciju datow započeć',
	'smw_smwadmin_datarefreshstop' => 'Tutu aktualizaciju zastajić',
	'smw_smwadmin_datarefreshstopconfirm' => 'Haj, sym wěsty.',
	'smw_smwadmin_support' => 'Podpěru dóstać',
	'smw_smwadmin_supportdocu' => 'Wšelake resursy móhli ći w problemowych padach pomhać:',
	'smw_smwadmin_installfile' => 'Jeli su problemy z twojej instalaciju, wobhladaj sej směrnicy w <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">dataji INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Kompletna wužiwarska dokumentacija za Semantic MediaWiki je na <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Zmylki móžeš w systemje <a href="https://bugzilla.wikimedia.org/">Bugzilla</a> zdźělić.',
	'smw_smwadmin_questions' => 'Jeli maš dalše prašenja abo namjety, wobdźěl so na diskusiji na <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">wužiwarskim forumje Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Struktura datow',
	'smw_adminlinks_displayingdata' => 'Zwobraznjenje datow',
	'smw_adminlinks_inlinequerieshelp' => 'Pomoc za rjadowe wotprašowanja',
);

/** Haitian (Kreyòl ayisyen)
 * @author Jvm
 * @author Masterches
 */
$messages['ht'] = array(
	'smw_edithelp' => 'Èd nan redaksyon pwopryete yo ak relasyon',
	'smw_viewasrdf' => 'Wè tankou fòma RDF',
	'smw_finallistconjunct' => ', epi',
	'smw_factbox_head' => 'Bagay an relasyon ak $1',
	'smw_isspecprop' => 'Pwopryete sa espesyal toutbon nan wiki sa',
	'smw_isknowntype' => 'Tip sa ap fè pati de tip done estanda nan wiki sa.',
	'smw_isaliastype' => 'Tip sa se yon alyas pou done "$1".',
	'smw_isnotype' => 'Tip "$1" sa pa yon tip estandè nan wiki a, li pa defini pa yon itilizatè tou.',
	'smw_baduri' => 'Eskize nou, URIs yo pou domèn "$1" pa otorize, oubyen li pa disponib nan plas isit la.',
	'smw_iq_disabled' => 'Eskize nou. Rechèch nan atik wiki sa a pa otorize oubyen nou dezaktive l.',
	'smw_iq_moreresults' => '… lòt rezilta yo',
	'smw_iq_nojs' => 'Souple, itilize yon navigatè (bwozè entènèt) ki aksepte JavaScript aktive pou ou kapab wè eleman sa, bagay sa.',
	'smw_iq_altresults' => 'Fouye, gade lis rezilta yo dirèkteman.',
	'smw_unknown_importns' => 'Fonksyon pou ou kapab chaje fichye (rekipere pou ou menm) pa disponib pou espas non sa "$1".',
	'smw_nonright_importtype' => 'Ou dwe itilize eleman $1 sa sèlman pou paj ki genyen non espas sa "$2".',
	'smw_wrong_importtype' => '$1 pa dwe itilize pou paj ki nan non espas "$2".',
	'smw_no_importelement' => 'Eleman "$1" pa disponib pou rekipere, pou chaje.',
	'smw_parseerror' => 'Valè ou bay oubyen sa li retounen pa klè, nou pa kapab konprann li.',
	'smw_notitle' => 'Nou pa kapab itilize "$1" tankou non yon paj nan wiki sa.',
	'smw_unknowntype' => 'Tip done "$1" yo ki pa sipòte retounen nan atribi a.',
	'smw_manytypes' => 'Plizyè tip done pase  nan atribi.',
	'smw_emptystring' => 'Chèn mo ou bay an pa dwe vid.',
	'smw_maxstring' => 'Chèn reprezantasyon $1 an two long pou {{SITENAME}}.',
	'smw_notinenum' => '"$1" pa nan lis valè posib pou ($2) pou atribi, pwopryete a.',
	'smw_noboolean' => '"$1" pa rekonèt tankou yon valè bouleyen (vre/fo).',
	'smw_true_words' => 'vre,v,wi,w',
	'smw_false_words' => 'fo,f,non,n',
	'smw_nofloat' => '"$1" pa yon nonmb.',
	'smw_infinite' => 'Nonmb $1 an twò lon.',
	'smw_infinite_unit' => 'Konvèsyon inite pou $1 bay yon nonmb twò gran pou {{SITENAME}}.',
	'smw_unsupportedprefix' => 'Prefiks pou nonmb ("$1") yo pa sipòte nan sistèm an.',
);

/** Hungarian (Magyar)
 * @author Dani
 * @author Glanthor Reviol
 */
$messages['hu'] = array(
	'smw-desc' => "A wiki elérhetőbbé tétele – gépek ''és'' emberek számára is ([http://semantic-mediawiki.org/wiki/Help:User_manual online dokumentáció])",
	'smw_edithelp' => 'Szerkesztési segítség a tulajdonságokhoz',
	'smw_viewasrdf' => 'RDF hírcsatorna',
	'smw_finallistconjunct' => ', és',
	'smw_factbox_head' => '$1-tények',
	'smw_isspecprop' => 'Ez a tulajdonság különleges ebben a wikiben.',
	'smw_isknowntype' => 'Ez a típus ennek a wikinek az alapvető adattípusai közé tartozik.',
	'smw_isaliastype' => 'Ez a típus egy a(z) „$1” adattípus alternatív neve',
	'smw_isnotype' => 'A(z) „$1” típus nem szabványos adattípus a wikiben, és felhasználói definíciója sincs megadva.',
	'smw_concept_description' => 'A(z) „$1” koncepció leírása',
	'smw_no_concept_namespace' => "Koncepciókat csak a ''Koncepció:'' névtérben levő lapokon lehet megadni.",
	'smw_multiple_concepts' => 'Minden koncepció lapon csak egy koncepció definíciója szerepelhet.',
	'smw_concept_cache_miss' => 'A(z) „$1” koncepció nem használható pillanatnyilag, mivel a wiki konfigurációja szerint kapcsolat nélküli módban kell kiszámítani.
Ha a probléma nem szűnik meg bizonyos idő elteltével, kérd az oldal adminisztrátorát hogy tegye elérhetővé a koncepciót.',
	'smw_noinvannot' => 'Inverz tulajdonságokhoz nem lehet értékeket rendelni.',
	'smw_baduri' => '„$1” formájú URI-k nem engedélyezettek.',
	'smw_printername_auto' => 'Automatikus',
	'smw_printername_count' => 'Eredmények megszámlálása',
	'smw_printername_csv' => 'CSV exportálás',
	'smw_printername_debug' => 'Lekérdezés hibakeresése (szakértőknek)',
	'smw_printername_embedded' => 'Lap tartalmának beágyazása',
	'smw_printername_json' => 'JSON exportálás',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Felsorolás',
	'smw_printername_ul' => 'Részletezés',
	'smw_printername_rss' => 'RSS exportálás',
	'smw_printername_table' => 'Táblázat',
	'smw_printername_broadtable' => 'Széles táblázat',
	'smw_printername_template' => 'Sablon',
	'smw_paramdesc_limit' => 'Legfeljebb ennyi eredmény megjelenítése',
	'smw_paramdesc_headers' => 'Fejlécek/tulajdonságnevek megjelenítése',
	'smw_paramdesc_mainlabel' => 'A kezdőlap nevének címkéje',
	'smw_paramdesc_link' => 'Az értékek hivatkozásként jelenjenek meg',
	'smw_paramdesc_intro' => 'A lekérdezés eredményei előtt megjelenő szöveg',
	'smw_paramdesc_outro' => 'A lekérdezés eredményei után megjelenő szöveg',
	'smw_paramdesc_default' => 'Megjelenítendő szöveg, ha a lekérdezésnek nincs eredménye',
	'smw_paramdesc_searchlabel' => 'Az eredményekre mutató hivatkozás szövege',
	'smw_paramdesc_sep' => 'Az értékek közötti elválasztó',
	'smw_paramdesc_template' => 'Egy sablon neve, amellyel megjelenítendő a kiírás',
	'smw_paramdesc_columns' => 'A keresési eredmények oszlopainak száma (az alapértelmezett $1)',
	'smw_paramdesc_embedformat' => 'A címsorokhoz használt HTML-tag',
	'smw_paramdesc_embedonly' => 'Fejlécek kikapcsolása',
	'smw_paramdesc_rsstitle' => 'A hírcsatorna címeként használt szöveg',
	'smw_paramdesc_rssdescription' => 'A hírcsatorna leírásaként használt szöveg',
	'smw_iq_disabled' => 'A szemantikus lekérdezések le vannak tiltva ezen a wikin.',
	'smw_iq_moreresults' => '… további eredmények',
	'smw_iq_nojs' => 'Használj JavaScript képes böngészőt ennek az elemnek a megjelenítéséhez.',
	'smw_iq_altresults' => 'Az eredménylista közvetlen böngészése.',
	'smw_unknown_importns' => 'Az import funkciók nem elérhetőek a(z) „$1” névtérben.',
	'smw_nonright_importtype' => '$1 csak a(z) „$2” névtérben található lapokhoz használható.',
	'smw_wrong_importtype' => '$1 nem használható a(z) „$2” névtérben található lapokhoz.',
	'smw_no_importelement' => 'A(z) „$1” elem nem elérhető importáláshoz.',
	'smw_parseerror' => 'A megadott érték nem érthető.',
	'smw_notitle' => 'A(z) „$1” nem használható lap neveként ebben a wikiben.',
	'smw_wrong_namespace' => 'Csak a(z) „$1” névtérbeli lapok engedélyezettek itt.',
	'smw_unknowntype' => 'A megadott „$1” típus nem támogatott a tulajdonságnál.',
	'smw_manytypes' => 'Egynél több megadott típus a tulajdonsághoz.',
	'smw_emptystring' => 'Üres sztringek nem elfogadhatóak.',
	'smw_maxstring' => 'A(z) „$1” szöveges reprezentáció túl hosszú.',
	'smw_notinenum' => '„$1” nincs a lehetséges értékek listájában ($2) ehhez a tulajdonsághoz.',
	'smw_noboolean' => '„$1” nem értelmezhető mint logikai (igaz/hamis) érték',
	'smw_true_words' => 'igaz,igen,i',
	'smw_false_words' => 'hamis,nem,n',
	'smw_nofloat' => '„$1” nem egy szám.',
	'smw_infinite' => 'Ilyen nagy számok („$1”) nem támogatottak.',
	'smw_infinite_unit' => 'A(z) „$1” egységre konvertálás eredménye túl nagy szám.',
	'smw_novalues' => 'Nincsenek megadva értékek.',
	'smw_unsupportedprefix' => 'Előtagok számokhoz („$1”) nem támogatottak.',
	'smw_unsupportedunit' => 'Egység konvertálás a(z) „$1” egységhez nem támogatott.',
	'smw_nodatetime' => 'A(z) „$1” dátum nem értelmezhető.',
	'smw_toomanyclosing' => 'A(z) „$1” túl sokszor fordul elő a lekérdezésben.',
	'smw_noclosingbrackets' => 'A lekérdezésben szerepelnek nyitó szögletes zárójelek „(<nowiki>[[</nowiki>)” a lezáró párjuk („]]”) nélkül.',
	'smw_misplacedsymbol' => 'A(z) „$1” szimbólum egy olyan helyen volt használva, ahol nincs haszna.',
	'smw_unexpectedpart' => 'A lekérdezés „$1” része nem értelmezhető.
Az eredmények eltérhetnek a várttól.',
	'smw_emptysubquery' => 'Valamely allekérdezés nem tartalmaz érvényes feltételt.',
	'smw_misplacedsubquery' => 'Allekérdezés volt egy olyan helyen, ahol nem engedélyezettek az allekérdezések.',
	'smw_valuesubquery' => 'A(z) „$1” tulajdonság értékeinél nem támogatottak az allekérdezések.',
	'smw_overprintoutlimit' => 'A lekérdezésben túl sok kiírási kérelem van.',
	'smw_badprintout' => 'Valamelyik kiíró utasítás hibásan lett formázva a lekérdezésben.',
	'smw_badtitle' => 'A(z) „$1” nem egy érvényes lapcím.',
	'smw_badqueryatom' => 'A lekérdezés egy részét („<nowiki>[[…]]</nowiki>”) nem sikerült értelmezni.',
	'smw_propvalueproblem' => 'A(z) „$1” tulajdonság értéke nem értelmezhető.',
	'smw_noqueryfeature' => 'A lekérdezés egyes részei nem támogatottak ebben a wikiben, így a lekérdezés egy része el lett dobva ($1).',
	'smw_noconjunctions' => 'A konjunkció a lekérdezésekben nem támogatott ebben a wikiben, így a lekérdezés egy része el lett dobva ($1).',
	'smw_nodisjunctions' => 'A diszjunkció a lekérdezésekben nem támogatott ebben a wikiben, így a lekérdezés egy része el lett dobva ($1).',
	'smw_querytoolarge' => 'A következő lekérdezés-feltételek nem lettek figyelembe véve a wikin érvényes lekérdezésméret vagy -mélység-korlátozások miatt: $1',
	'smw_devel_warning' => 'Ez a funkció fejlesztés alatt áll, így nem biztos, hogy tökéletesen működik.
Készíts biztonsági másolatot az adataidról, mielőtt használod.',
	'smw_notemplategiven' => 'Adj értéket a lekérdezés „paramétersablonjának”, hogy működjön ez a lekérdezésformátum.',
	'smw_type_header' => 'A(z) „$1” típus tulajdonságai',
	'smw_typearticlecount' => '{{PLURAL:$1|Egy|$1}} tulajdonság megjelenítése ezen típus használatával.',
	'smw_attribute_header' => 'A(z) „$1” tulajdonságot használó lapok',
	'smw_attributearticlecount' => '{{PLURAL:$1|Egy|$1}} lap megjelenítése ezen tulajdonság használatával.',
	'smw_subproperty_header' => 'Altulajdonságok',
	'smw_subpropertyarticlecount' => 'Ez a tulajdonság a következő {{PLURAL:$1|egy|$1}} altulajdonsággal rendelkezik:',
	'smw_concept_header' => 'A(z) „$1” koncepcióhoz tartozó lapok',
	'smw_conceptarticlecount' => 'A koncepcióhoz tartozó $1 lap megjelenítése.',
	'exportrdf' => 'Lapok exportálása RDF-be',
	'smw_exportrdf_docu' => 'Ez a lap lehetőséget teremt adatok beszerzésére egy lapról RDF formátumban.
A lapok exportálásához írd be a címeiket az alábbi szövegdobozba, soronként egyet.',
	'smw_exportrdf_recursive' => 'Az összes kapcsolódó lap rekurzív exportálása.
Az eredmény elég nagy lehet!',
	'smw_exportrdf_backlinks' => 'Kimenti az összes lapot, ami hivatkozik az exportált lapokra.
Böngészhető RDF-et készít.',
	'smw_exportrdf_lastdate' => 'Ne exportáljon lapokat, amelyek nem változtak mióta a megadott időpont óta.',
	'smw_exportrdf_submit' => 'Exportálás',
	'properties' => 'Tulajdonságok',
	'smw_properties_docu' => 'A wikiben az alábbi tulajdonságok használatosak.',
	'smw_property_template' => '$2 típusú $1 ($3)',
	'smw_propertylackspage' => 'Minden tulajdonságnak kell hogy legyen leírólapja!',
	'smw_propertylackstype' => 'Nincs típus megadva ehhez a tulajdonsághoz ($1 típus feltételezése).',
	'smw_propertyhardlyused' => 'Ez a tulajdonság aligha használatos a wikiben!',
	'unusedproperties' => 'Nem használt tulajdonságok',
	'smw_unusedproperties_docu' => 'A következő tulajdonságok habár léteznek, de egyetlen lap sem használja őket.',
	'smw_unusedproperty_template' => '$2 típusú $1',
	'wantedproperties' => 'Keresett tulajdonságok',
	'smw_wantedproperties_docu' => 'A következő tulajdonságok használva vannak a wikiben, azoban még nem rendelkeznek leíró lappal.',
	'smw_wantedproperty_template' => '$1 ($2 helyen használva)',
	'tooltip-purge' => 'Kattints ide a lapon lévő összes lekérdezés és sablon frissítéséhez',
	'smw_purge' => 'Frissítés',
	'types' => 'Típusok',
	'smw_types_docu' => 'Alább azon adattípusok listája látható, melyek hozzárendelhetőek a tulajdonságokhoz.
Minden egyes adattípus rendelkezik egy lappal, ahol további információkat lehet megadni.',
	'smw_typeunits' => '„$1” típusú mérési egységek: $2',
	'semanticstatistics' => 'Szemantikus statisztika',
	'smw_semstats_text' => "Ez a wiki '''$1''' tulajdonságértéket tartalmaz '''$2''' [[Special:Properties|különböző tulajdonsághoz]].
'''$3''' tulajdonság rendelkezik saját lappal, és '''$4''' adattípusa van megadva.
A létező tulajdonságok egy része [[Special:UnusedProperties|használaton kívüli]] lehet.
A lappal nélküli tulajdonságok a [[Special:WantedProperties|keresett tulajdonságok listáján]] tekinthetőek meg.",
	'uriresolver' => 'URI feloldó',
	'smw_uri_doc' => 'Az URI-feloldó implementálja a <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>-ben meghatározottakat.
Biztosítja, hogy az emberek ne váljanak weboldalakká.',
	'ask' => 'Szemantikus keresés',
	'smw_ask_sortby' => 'Rendezés oszlopok szerint (nem kötelező)',
	'smw_ask_ascorder' => 'Növekvő',
	'smw_ask_descorder' => 'Csökkenő',
	'smw_ask_submit' => 'Eredmények keresése',
	'smw_ask_editquery' => '[Lekérdezés szerkesztése]',
	'smw_add_sortcondition' => '[Rendezési feltétel hozzáadása]',
	'smw_ask_hidequery' => 'Lekérdezés elrejtése',
	'smw_ask_help' => 'Lekérdezések súgója',
	'smw_ask_queryhead' => 'Lekérdezés',
	'smw_ask_printhead' => 'További megjelenítendő adatok',
	'smw_ask_printdesc' => '(egy tulajdonságnevet adj meg soronként)',
	'smw_ask_format_as' => 'Formázás mint:',
	'smw_ask_defaultformat' => 'alapértelmezett',
	'smw_ask_otheroptions' => 'Egyéb beállítások',
	'smw_ask_show_embed' => 'Beágyazási kód megjelenítése',
	'smw_ask_hide_embed' => 'Beágyazási kód elrejtése',
	'smw_ask_embed_instr' => 'Ha egy wikilapra szeretnéd beilleszteni ezt a lekérdezést, másold be az alábbi kódot.',
	'searchbyproperty' => 'Keresés tulajdonság szerint',
	'smw_sbv_docu' => 'Az összes olyan lap megkeresése, ami a megadott tulajdonsággal és értékkel rendelkezik.',
	'smw_sbv_novalue' => 'Add meg a tulajdonság egy érvényes értékét, vagy nézd meg a(z) „$1” összes tulajdonság-értékét.',
	'smw_sbv_displayresult' => 'Az össze lap listája, amelyeknek vagy van „$1” tulajdonsága „$2” értékkel',
	'smw_sbv_displayresultfuzzy' => 'Az összes olyan lap listája, melyeknél a(z) „$1” tulajdonság a(z) „$2” értéket veszi fel.
Mivel csak néhány találat van, a közeli értékek is meg vannak jelenítve.',
	'smw_sbv_property' => 'Tulajdonság:',
	'smw_sbv_value' => 'Érték:',
	'smw_sbv_submit' => 'Eredmények keresése',
	'browse' => 'Wiki tallózása',
	'smw_browselink' => 'Tulajdonságok böngészése',
	'smw_browse_article' => 'Add meg a lap nevét, ahonnan el szeretnéd kezdeni a böngészést.',
	'smw_browse_go' => 'Menj',
	'smw_browse_show_incoming' => 'ide hivatkozó tulajdonságok megjelenítése',
	'smw_browse_hide_incoming' => 'ide hivatkozó tulajdonságok elrejtése',
	'smw_browse_no_outgoing' => 'Ehhez a laphoz nem tartoznak tulajdonságok.',
	'smw_browse_no_incoming' => 'Egy tulajdonság sem hivatkozik erre a lapra.',
	'smw_inverse_label_default' => '$1',
	'smw_inverse_label_property' => 'Tulajdonság címkéjének felcserélése',
	'pageproperty' => 'Laptulajdonság keresés',
	'smw_pp_docu' => 'Egy tulajdonság összes értékének keresése egy adott oldalon.
Add meg a lapot és a tulajdonságot is.',
	'smw_pp_from' => 'Ettől a laptól:',
	'smw_pp_type' => 'Tulajdonság',
	'smw_pp_submit' => 'Eredmények keresése',
	'smw_result_prev' => 'Előző',
	'smw_result_next' => 'Következő',
	'smw_result_results' => 'Eredmények',
	'smw_result_noresults' => 'Nincs találat.',
	'smwadmin' => 'A Szemantikus MediaWiki adminisztrációs funkciói',
	'smw_smwadmin_settingup' => 'A Szemantikus MediaWiki tárolómotorjának beállítása',
	'smw_smwadmin_setupsuccess' => 'A tárolómotor sikeresen be lett állítva.',
	'smw_smwadmin_return' => 'Vissza ide: $1',
	'smw_smwadmin_updatestarted' => 'Egy új frissítő folyamat indult a szemantikus adatok frissítése céljából.
Minden tárolt adat újra elő lesz állítva, és javítva lesz, ahol szükséges.
A frissítési folyamat előrehaladását ezen a speciális lapon követheted figyelemmel.',
	'smw_smwadmin_updatenotstarted' => 'Már fut egy frissítő folyamat.
Nem kell újat készíteni.',
	'smw_smwadmin_updatestopped' => 'Minden futó frissítési folyamat leállítva.',
	'smw_smwadmin_updatenotstopped' => 'Az éppen futó frissítési folyamat megszakításához aktiválnod kell a dobozt, hogy jelezd, tényleg biztos vagy benne.',
	'smw_smwadmin_docu' => 'Ez a speciális lap segít a <a href="http://semantic-mediawiki.org">Szemantikus MediaWiki</a> telepítése és frissítése során.
Ne felejts el másolatot készíteni az értékes adatokról az adminisztratív funkciók használata előtt.',
	'smw_smwadmin_db' => 'Adatbázistelepítés és -frissítés',
	'smw_smwadmin_dbdocu' => 'A Szemantikus MediaWikinek szüksége van néhány kiterjesztésre az adatbázison a szemantikus adatok tárolásához.
Az alábbi funkció ellenőrzi, hogy az adatbázis megfelelően be van-e állítva.
Az ezen lépés során végrehajtott változások nincsenek hatással a MediaWiki adatbázisának többi részére, és egyszerűen visszavonható, amennyiben szükséges.
Ez a telepítési lépés többször is végrehajtható, anékül, hogy bármilyen kárt tenne, de csak egyszer szükséges a telepítés vagy frissítés során.',
	'smw_smwadmin_permissionswarn' => 'Ha a művelet SQL-hibákkal leáll, a wikid által használt adatbázis-felhasználó (amit a LocalSettings.php-ben adtál meg) valószínűleg nem rendelkezik a megfelelő jogosultságokkal.
Adj a felhasználó számára táblák készítéséhez és törléséhez jogosultságot, ideiglenesen add meg a root fiók adatait, vagy használd az <tt>SMW_setup.php</tt> karbantartó parancsfájlt, ami az AdminSettings.php-ben megadott adatokkal lép be.',
	'smw_smwadmin_dbbutton' => 'Táblák inicializálása vagy frissítése',
	'smw_smwadmin_announce' => 'Wiki bejelentése',
	'smw_smwadmin_announcedocu' => 'A Szemantikus MediaWikinek van egy webes szolgáltatása az új szemantikus wikioldalak jelzésére.
Ezt arra használjuk, hogy karbantartsuk azon nyilvános oldalak listáját, melyek Szemantikus MediaWikit használnak, főként azért, hogy segítsük a <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Szemantikus MediaWiki-projektet</a>, így nyerve áttekintést arról, hogy mire használják általában ezt a kiegészítőt.
A szolgáltatásról további információkat <a href="http://semantic-mediawiki.org/wiki/Registry">a Szemantikus MediaWiki honlapján</a> találsz.',
	'smw_smwadmin_announcebutton' => 'Kattints a következő gombra, ha el szeretnéd küldeni a wikid URL-címét ennek a szolgáltatásnak.
A szolgáltatás nem rögzít olyan wikiket, melyek nem érhetőek el nyilvánosan, és csak mindenki számára elérhető információkat gyűjt.',
	'smw_smwadmin_datarefresh' => 'Adatok javítása és aktualizálása',
	'smw_smwadmin_datarefreshdocu' => 'A wiki jelenlegi tartalma alapján lehetőség van az összes Szemantikus MediaWiki-adat helyreállítására.
Ez hasznos lehet a sérült adatok javításakor, vagy az adatok frissítésekor, ha a belső formátum megváltozott szoftverfrissítés miatt.
A frissítés oldalról oldalra van végrehajtva, és nem lesz azonnal kész.
Alább látható, hogy jelenleg folyamatban van-e ilyen frissítés, és elindíthatod vagy leállíthatod a frissítéseket (kivéve, ha az oldal adminisztrátora letiltotta ezt a lehetőséget).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Frissítés folyamatban.</strong>
Normális, ha a frissítés lassan halad, hiszen az adatok csak egy kis részét frissíti minden alkalommal, ha egy felhasználó hozzáfér a wikihez.
Ha gyorsabban be szeretnéd fejezni a frissítést, hívd meg a <tt>runJobs.php</tt> karbantartó parancsfájlt (használd a <tt>--maxjobs 1000</tt> kapcsolót az egy menetben végrehajtott frissítések korlátozásához).
A jelenlegi frissítés becsült előrehaladása:',
	'smw_smwadmin_datarefreshbutton' => 'Adatok frissítésének megkezdése',
	'smw_smwadmin_datarefreshstop' => 'Frissítés megszakítása',
	'smw_smwadmin_datarefreshstopconfirm' => 'Igen, biztos vagyok benne.',
	'smw_smwadmin_support' => 'Segítséget kérek',
	'smw_smwadmin_supportdocu' => 'Különböző források, amelyek segíthetnek problémák esetén:',
	'smw_smwadmin_installfile' => 'Ha problémákat észlelsz a telepítéssel, ellenőrizd az útmutatót az <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL fájlban</a>.',
	'smw_smwadmin_smwhomepage' => 'A Szemantikus MediaWiki teljes felhasználói dokumentációja a <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b> címen található.',
	'smw_smwadmin_mediazilla' => 'A hibákat a <a href="https://bugzilla.wikimedia.org/">Bugzillán</a> lehet jelenteni.',
	'smw_smwadmin_questions' => 'Ha további kérdéseid vagy javaslataid vannak, csatlakozz a <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Szemantikus MediaWiki felhasználói fórumán</a> folyó beszélgetéshez.',
	'smw_adminlinks_datastructure' => 'Adatstruktúra',
	'smw_adminlinks_displayingdata' => 'Adatok megjelenítése',
	'smw_adminlinks_inlinequerieshelp' => 'Szövegbeli lekérdezés-súgó',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'smw-desc' => "Pro render tu wiki plus accessibile – a machinas '''e''' a humanos ([http://semantic-mediawiki.org/wiki/Help:User_manual documentation in linea])",
	'smw_edithelp' => 'Adjuta super le modification del proprietates',
	'smw_viewasrdf' => 'Syndication RDF',
	'smw_finallistconjunct' => ', e',
	'smw_factbox_head' => 'Factos super $1',
	'smw_isspecprop' => 'Iste proprietate es special in iste wiki.',
	'smw_isknowntype' => 'Iste typo es inter le typos de datos standard de iste wiki.',
	'smw_isaliastype' => 'Iste typo es un alias pro le typo de datos "$1".',
	'smw_isnotype' => 'Iste typo "$1" non es un typo de datos standard in le wiki, ni ha essite date a illo un definition de usator.',
	'smw_concept_description' => 'Description del concepto "$1"',
	'smw_no_concept_namespace' => 'Le conceptos pote solmente esser definite in paginas in le spatio de nomines Concept:.',
	'smw_multiple_concepts' => 'Cata pagina de concepto pote haber un sol definition de concepto.',
	'smw_concept_cache_miss' => 'Le concepto "$1" non pote esser usate al momento, post que le configuration del wiki require que illo sia computate foras de linea. Si le problema non dispare post alcun tempore, demanda al administrator de tu sito de render disponibile iste concepto.',
	'smw_noinvannot' => 'Le valores non pote esser assignate al proprietates inverse.',
	'smw_baduri' => 'Le adresses URI del forma "$1" non es permittite.',
	'smw_rss_link' => 'RSS',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automatic',
	'smw_printername_count' => 'Contar resultatos',
	'smw_printername_csv' => 'Exportation in CSV',
	'smw_printername_debug' => 'Consulta de debugging (pro expertos)',
	'smw_printername_embedded' => 'Incastrar contento de pagina',
	'smw_printername_json' => 'Exportation in JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumeration',
	'smw_printername_ul' => 'Lista detaliate',
	'smw_printername_rss' => 'Exportation in RSS',
	'smw_printername_table' => 'Tabella',
	'smw_printername_broadtable' => 'Tabella large',
	'smw_printername_template' => 'Patrono',
	'smw_paramdesc_limit' => 'Le numero maxime de resultatos a retornar',
	'smw_paramdesc_headers' => 'Monstrar le capites/nomines de proprietate',
	'smw_paramdesc_mainlabel' => 'Le etiquetta a dar al nomine del pagina principal',
	'smw_paramdesc_link' => 'Monstrar valores como ligamines',
	'smw_paramdesc_intro' => 'Le texto a monstrar ante le resultatos del consulta, si existe',
	'smw_paramdesc_outro' => 'Le texto a monstrar post le resultatos del consulta, si existe',
	'smw_paramdesc_default' => 'Le texto a monstrar si le consulta non produce resultatos',
	'smw_paramdesc_searchlabel' => 'Le texto in le ligamine verso le resultatos',
	'smw_paramdesc_sep' => 'Le separator de valores',
	'smw_paramdesc_template' => 'Le nomine de un patrono con le qual presentar le impressiones',
	'smw_paramdesc_columns' => 'Le numero de columnas in le quales presentar resultatos (predefinition es $1)',
	'smw_paramdesc_embedformat' => 'Le etiquetta HTML usate pro definir capites',
	'smw_paramdesc_embedonly' => 'Non monstrar capites',
	'smw_paramdesc_rsstitle' => 'Le texto a usar como titulo del syndication',
	'smw_paramdesc_rssdescription' => 'Le texto a usar como description del syndicato',
	'smw_iq_disabled' => 'Le consultas semantic ha essite disactivate pro iste wiki.',
	'smw_iq_moreresults' => '… ulterior resultatos',
	'smw_iq_nojs' => 'Usa un navigator capace de executar JavaScript pro visualisar iste elemento.',
	'smw_iq_altresults' => 'Percurrer directemente le lista de resultatos.',
	'smw_unknown_importns' => 'Le functiones de importation non es disponibile pro le spatio de nomines de "$1".',
	'smw_nonright_importtype' => '$1 pote solmente esser usate pro paginas con le spatio de nomines "$2".',
	'smw_wrong_importtype' => '$1 non pote esser usate pro paginas in le spatio de nomines "$2".',
	'smw_no_importelement' => 'Le elemento "$1" non es disponibile pro importation.',
	'smw_parseerror' => 'Le valor date non esseva comprendite.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '&nbsp;',
	'smw_notitle' => '"$1" non pote esser usate como nomine de pagina in iste wiki.',
	'smw_wrong_namespace' => 'Solmente le paginas in le spatio de nomines "$1" es permittite hic.',
	'smw_unknowntype' => 'Typo non supportate "$1" definite pro proprietate.',
	'smw_manytypes' => 'Plus de un typo definite pro proprietate.',
	'smw_emptystring' => 'Series de characteres vacue non es acceptate.',
	'smw_maxstring' => 'Le representation de serie de characteres $1 es troppo longe.',
	'smw_notinenum' => '"$1" non es in le lista de valores possibile ($2) pro iste proprietate.',
	'smw_noboolean' => '"$1" non es recognoscite como un valor boolean (ver/false).',
	'smw_true_words' => 'ver,v,si,s',
	'smw_false_words' => 'false,f,no,n',
	'smw_nofloat' => '"$1" non es un numero.',
	'smw_infinite' => 'Le numeros tanto grande como "$1" non es supportate.',
	'smw_infinite_unit' => 'Le conversion in unitate "$1" resultava in un numero troppo grande.',
	'smw_novalues' => 'Nulle valor specificate.',
	'smw_unsupportedprefix' => 'Le prefixos pro numeros ("$1") non es supportate.',
	'smw_unsupportedunit' => 'Le conversion del unitate "$1" non es supportate.',
	'smw_nodatetime' => 'Le data "$1" non esseva comprendite.',
	'smw_toomanyclosing' => 'Il pare haber troppo de occurrentias de "$1" in le consulta.',
	'smw_noclosingbrackets' => 'Alcun uso de "<nowiki>[[</nowiki>" in tu consulta non esseva claudite per un correspondente "]]".',
	'smw_misplacedsymbol' => 'Le symbolo "$1" esseva usate in un loco ubi illo non es utile.',
	'smw_unexpectedpart' => 'Le parte "$1" del consulta non esseva comprendite.
Le resultatos pote non esser como expectate.',
	'smw_emptysubquery' => 'Alcun subconsulta ha nulle condition valide.',
	'smw_misplacedsubquery' => 'Alcun subconsulta esseva usate in un loco ubi nulle subconsultas es permittite.',
	'smw_valuesubquery' => 'Le subconsultas non es supportate pro valores del proprietate "$1".',
	'smw_overprintoutlimit' => 'Le consulta contine troppo de requestas "printout".',
	'smw_badprintout' => 'Alcun commando "print" in le consulta esseva mal formate.',
	'smw_badtitle' => '"$1" non es un titulo de pagina valide.',
	'smw_badqueryatom' => 'Alcun parte "<nowiki>[[…]]</nowiki>" del consulta non esseva comprendite.',
	'smw_propvalueproblem' => 'Le valor del proprietate "$1" non esseva comprendite.',
	'smw_noqueryfeature' => 'Alcun functionalitate de consulta non esseva supportate in iste wiki; un parte del consulta ha essite omittite ($1).',
	'smw_noconjunctions' => 'Le conjunctiones in consultas non es supportate in iste wiki; un parte del consulta ha essite ommittite ($1).',
	'smw_nodisjunctions' => 'Le disjunctiones in consultas non es supportate in iste wiki; un parte del consulta ha essite omittite ($1).',
	'smw_querytoolarge' => 'Le sequente conditiones de consulta non pote esseva considerate a causa del restrictiones de iste wiki concernente le grandor o profunditate del consultas: $1.',
	'smw_devel_warning' => 'Iste function es actualmente sub disveloppamento, e pote non esser completemente functional.
Face un copia de reserva de tu datos ante que tu lo usa.',
	'smw_notemplategiven' => 'Forni un valor pro le parametro "template" pro facer functionar iste formato de consulta.',
	'smw_type_header' => 'Proprietates del typo "$1"',
	'smw_typearticlecount' => 'Presentation de $1 {{PLURAL:$1|proprietate|proprietates}} que usa iste typo.',
	'smw_attribute_header' => 'Paginas que usa le proprietate "$1"',
	'smw_attributearticlecount' => 'Presentation de $1 {{PLURAL:$1|pagina|paginas}} que usa iste proprietate.',
	'smw_subproperty_header' => 'Subproprietates',
	'smw_subpropertyarticlecount' => 'Iste proprietate ha le sequente $1 {{PLURAL:$1|subproprietate|subproprietates}}:',
	'smw_concept_header' => 'Paginas del concepto "$1"',
	'smw_conceptarticlecount' => 'Presentation de $1 {{PLURAL:$1|pagina|paginas}} que appertine a ille concepto.',
	'smw_rss_description' => 'Syndication RSS de $1',
	'specialpages-group-smw_group' => 'MediaWiki semantic',
	'exportrdf' => 'Exportar paginas verso RDF',
	'smw_exportrdf_docu' => 'Iste pagina permitte obtener le datos de un pagina in formato RDF.
Pro exportar pagina, entra le titulos in le quadro de texto in basso, un titulo per linea.',
	'smw_exportrdf_recursive' => 'Exportar recursivemente tote le paginas connexe.
Nota que le resultato pote esser grande!',
	'smw_exportrdf_backlinks' => 'Exportar equalmente tote le paginas con referentias al paginas exportate.
Genera un RDF navigabile.',
	'smw_exportrdf_lastdate' => 'Non exportar paginas que non esseva cambiate post le momento specificate.',
	'smw_exportrdf_submit' => 'Exportar',
	'properties' => 'Proprietates',
	'smw_properties_docu' => 'Le sequente proprietates es usate in le wiki.',
	'smw_property_template' => '$1 del typo $2 ($3)',
	'smw_propertylackspage' => 'Tote le proprietates debe esser describite per un pagina!',
	'smw_propertylackstype' => 'Nulle typo esseva specificate pro iste proprietate (es assumite le typo $1 pro le momento).',
	'smw_propertyhardlyused' => 'Iste proprietate es a pena usate in iste wiki!',
	'unusedproperties' => 'Proprietates non usate',
	'smw_unusedproperties_docu' => 'Le sequente proprietates existe ben que nulle altere pagina los utilisa.',
	'smw_unusedproperty_template' => '$1 del typo $2',
	'wantedproperties' => 'Proprietates desirate',
	'smw_wantedproperties_docu' => 'Le sequente proprietates es uate in le wiki sed non ha ancora un pagina pro describer los.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uso|usos}})',
	'tooltip-purge' => 'Clicca hic pro refrescar tote le consultas e patronos in iste pagina',
	'smw_purge' => 'Refrescar',
	'types' => 'Typos',
	'smw_types_docu' => 'Lo sequente es un lista de tote le typos de datos assignabile a proprietates.
Cata typo de datos ha un pagina ubi informationes additional pote esser fornite.',
	'smw_typeunits' => 'Unitates de mesura del typo "$1": $2',
	'semanticstatistics' => 'Statisticas semantic',
	'smw_semstats_text' => "Iste wiki contine '''$1''' {{PLURAL:$1|valor|valores}} de proprietate pro un total de '''$2'''
[[Special:Properties|{{PLURAL:$2|proprietate|proprietates distincte}}]].
<b>$3</b> {{PLURAL:$3|proprietate ha su proprie pagina|proprietates ha lor proprie paginas}}, e le typo de datos intendite es specificate pro '''$4''' de {{PLURAL:$3|illo|illos}}.
Alcunes del proprietates existente pote esser [[Special:UnusedProperties|proprietates non usate]].
Le proprietates al quales manca ancora un pagina se trova in le [[Special:WantedProperties|lista de proprietates desirate]].",
	'uriresolver' => 'Resolvitor de URI',
	'smw_uri_doc' => 'Le resolvitor de URL implementa le <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">conclusion del Gruppo de Architectura Technic del W3C a proposito de httpRange-14</a>.
Illo assecura que le humanos non se transforma in sitos web.',
	'ask' => 'Recerca semantic',
	'smw_ask_sortby' => 'Ordinar per columna (optional)',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Cercar resultatos',
	'smw_ask_editquery' => '[Modificar consulta]',
	'smw_add_sortcondition' => '[Adder condition de ordinamento]',
	'smw_ask_hidequery' => 'Celar consulta',
	'smw_ask_help' => 'Adjuta super le consultas',
	'smw_ask_queryhead' => 'Consulta',
	'smw_ask_printhead' => 'Datos additional a presentar',
	'smw_ask_printdesc' => '(adde un nomine de proprietate per linea)',
	'smw_ask_format_as' => 'Formatar in:',
	'smw_ask_defaultformat' => 'predefinition',
	'smw_ask_otheroptions' => 'Altere optiones',
	'smw_ask_show_embed' => 'Revelar codice de incastrar',
	'smw_ask_hide_embed' => 'Celar codice de incastrar',
	'smw_ask_embed_instr' => 'Pro incastrar iste consulta in linea in un pagina wiki usa le codice sequente.',
	'searchbyproperty' => 'Cercar per proprietate',
	'smw_sbv_docu' => 'Cercar tote le paginas que ha un proprietate e valor date.',
	'smw_sbv_novalue' => 'Entra un valor valide pro le proprietate, o vide tote le valores possibile del proprietate "$1".',
	'smw_sbv_displayresult' => 'Un lista de tote le paginas que ha le proprietate "$1" con valor "$2"',
	'smw_sbv_displayresultfuzzy' => 'Un lista de tote le paginas que ha le proprietate "$1" con valor "$2".
Post que il ha pauc resultatos, le valores proxime es equalmente monstrate.',
	'smw_sbv_property' => 'Proprietate:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => 'Cercar resultatos',
	'browse' => 'Percurrer le wiki',
	'smw_browselink' => 'Percurrer proprietates',
	'smw_browse_article' => 'Entra le nomine del pagina ab le qual tu vole initiar le exploration.',
	'smw_browse_go' => 'Ir',
	'smw_browse_more' => '…',
	'smw_browse_show_incoming' => 'monstrar le proprietates con ligamines verso hic',
	'smw_browse_hide_incoming' => 'celar le proprietates con ligamines verso hic',
	'smw_browse_no_outgoing' => 'Iste pagina non ha proprietates.',
	'smw_browse_no_incoming' => 'Nulle proprietate ha un ligamine a iste pagina.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Etiquetta de proprietate inverse',
	'pageproperty' => 'Recerca de proprietates de paginas',
	'smw_pp_docu' => 'Cercar tote le filtros de un proprietate in un pagina date.
Entra e un pagina e un proprietate.',
	'smw_pp_from' => 'Ab pagina',
	'smw_pp_type' => 'Proprietate',
	'smw_pp_submit' => 'Cercar resultatos',
	'smw_result_prev' => 'Precedente',
	'smw_result_next' => 'Sequente',
	'smw_result_results' => 'Resultatos',
	'smw_result_noresults' => 'Nulle resultato.',
	'smwadmin' => 'Functiones admin pro MediaWiki Semantic',
	'smw_smwadmin_settingup' => 'Installation de spatio de immagazinage pro Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Le motor de immagazinage ha essite installate con successo.',
	'smw_smwadmin_return' => 'Retornar a $1',
	'smw_smwadmin_updatestarted' => 'Un nove processo de actualisation pro le refrescamento del datos semantic ha essite comenciate.
Tote le datos immagazinate essera reconstruite o reparate ubi necessari.
Tu pote sequer le progresso del actualisation in iste pagina special.',
	'smw_smwadmin_updatenotstarted' => 'Il ha ja un processo de actualisation in curso de execution.
Non es create un altere.',
	'smw_smwadmin_updatestopped' => 'Tote le processos de actualisation existente ha essite stoppate.',
	'smw_smwadmin_updatenotstopped' => 'Pro stoppar le processo de actualisation in curso, tu debe marcar le quadrato pro indicar que tu es absolutemente secur de voler facer isto.',
	'smw_smwadmin_docu' => 'Iste pagina special te adjuta durante le installation e actualisation de <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Non oblida facer un copia de reserva del datos de valor ante de executar un function administrative.',
	'smw_smwadmin_db' => 'Installation e actualisation del base de datos',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki require alcun extensiones al base de datos de MediaWiki a fin de poter immagazinar le datos semantic.
Le function infra assecura que tu base de datos es configurate correctemente.
Le cambiamentos facite durante iste passo non afficera le resto del base de datos de MediaWiki, e pote esser facilemente disfacite si desirate.
Iste function de installation pote esser executate plure vices sin causar alcun damno, sed es necessari solmente un vice post cata installation o actualisation.',
	'smw_smwadmin_permissionswarn' => 'Si le operation falle con errores SQL, le usator de base de datos que tu wiki usa (verifica tu <tt>LocalSettings.php</tt>) probabilemente non ha permissiones sufficiente.
O da a iste usator le permissiones additional de crear e deler tabulas, o entra temporarimente le nomine e contrasigno del usator <tt>root</tt> de tu base de datos in <tt>LocalSettings.php</tt>, o usa le script de mantenentia <tt>SMW_setup.php</tt> le qual pote usar le credentiales de AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Initialisar u actualisar tabulas',
	'smw_smwadmin_announce' => 'Annunciar tu wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki dispone de un servicio web pro annunciar nove sitos de wiki semantic.
Iste es usate pro mantener un lista de sitos public que usa Semantic MediaWiki, principalmente pro adjutar le <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projecto Semantic MediaWiki</a> a obtener un impression general del usos typic de Semantic MediaWiki.
Vide le pagina principal de Semantic MediaWiki pro <a href="http://semantic-mediawiki.org/wiki/Registry">ulterior informationes a proposito de iste servicio</a>.',
	'smw_smwadmin_announcebutton' => 'Preme le sequente button pro submitter le adresse URL de tu wiki a iste servicio.
Le servicio non registrara wikis que non es aperte al publico, e illo retenera solmente le informationes publicamente accessibile.',
	'smw_smwadmin_datarefresh' => 'Reparation e actualisation de datos',
	'smw_smwadmin_datarefreshdocu' => 'Es possibile restaurar tote le datos de Semantic MediaWiki a base del conento actual del wiki.
Isto pote esser utile pro reparar datos corrumpite o pro refrescar le datos si le formato interne ha cambiate a causa de alcun actualisation de software.
Le actualisation es executate pagina a pagina e non essera completate immediatemente.
Lo sequente monstra si un actualisation es in progresso e permitte comenciar o stoppar le actualisationes (a minus que iste function ha essite disactivate per le administrator del sito).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Un actualisation es ja in curso.</strong>
Es normal que le actualisation progrede lentemente post que illo refresca datos solmente in micre pecias cata vice que un usator accede al wiki.
Pro completar iste actualisation plus rapidemente, tu pote invocar le script de mantenentia de MediaWiki <tt>runJobs.php</tt> (usa le option <tt>--maxjobs 1000</tt> pro restringer le numero de actualisationes facite in un lot).
Progresso estimate del actualisation currente:',
	'smw_smwadmin_datarefreshbutton' => 'Comenciar le actualisation del datos',
	'smw_smwadmin_datarefreshstop' => 'Stoppar iste actualisation',
	'smw_smwadmin_datarefreshstopconfirm' => 'Si, io es secur.',
	'smw_smwadmin_support' => 'Obtener supporto',
	'smw_smwadmin_supportdocu' => 'Plure ressources poterea adjutar te in caso de problemas:',
	'smw_smwadmin_installfile' => 'Si tu incontra problemas con tu installation, comencia per verificar le directivas in le <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">file INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Le documentation de usator complete de Semantic MediaWiki se trova a <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Le defectos pote esser reportate in <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Si tu ha ulterior questiones o suggestiones, participa in le discussion al <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">foro del usatores de Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Structura de datos',
	'smw_adminlinks_displayingdata' => 'Monstrar datos',
	'smw_adminlinks_inlinequerieshelp' => 'Adjuta super consultas incorporate',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Irwangatot
 * @author IvanLanin
 * @author Rex
 */
$messages['id'] = array(
	'smw-desc' => "Membuat wiki Anda lebih mudah diakses - oleh mesin ''dan'' manusia ([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentasi daring])",
	'smw_edithelp' => 'Bantuan penyuntingan sifat',
	'smw_viewasrdf' => 'Umpan RDF',
	'smw_finallistconjunct' => ', dan',
	'smw_factbox_head' => 'Fakta tentang $1',
	'smw_isspecprop' => 'Sifat ini adalah sifat khusus di wiki ini.',
	'smw_isknowntype' => 'Tipe ini antara tipe data standar dari wiki ini.',
	'smw_isaliastype' => 'Tipe ini adalah suatu alias bagi tipe data "$1".',
	'smw_isnotype' => 'Tipe ini "$1" bukan tipe data standar di wiki ini, dan juga belum mendapat suatu definisi pengguna.',
	'smw_concept_description' => 'Deskripsi konsep "$1"',
	'smw_no_concept_namespace' => 'Konsep hanya dapat didefinisikan pada halaman dalam ruang nama Konsep:.',
	'smw_multiple_concepts' => 'Setiap halaman konsep hanya dapat memiliki satu konsep definisi.',
	'smw_concept_cache_miss' => 'Konsep "$1" tidak dapat digunakan saat ini karena konfigurasi wiki membutuhkannya untuk dihitung secara luring.
Jika masalah ini tidak hilang setelah beberapa waktu, mintalah pengelola situs untuk membuat konsep ini tersedia.',
	'smw_noinvannot' => 'Nilai tidak dapat diberikan pada properti inversi.',
	'smw_baduri' => 'URI berbentuk "$1" tidak diperbolehkan.',
	'smw_printername_auto' => 'Otomatis',
	'smw_printername_count' => 'Hasil perhitungan',
	'smw_printername_csv' => 'Expor CSV',
	'smw_printername_debug' => 'Debug query (untuk ahli)',
	'smw_printername_embedded' => 'Sertakan isi halaman',
	'smw_printername_json' => 'Ekspor JSON',
	'smw_printername_list' => 'Daftar',
	'smw_printername_ol' => 'Enumerasi',
	'smw_printername_ul' => 'Itemisasi',
	'smw_printername_rss' => 'Ekspor RSS',
	'smw_printername_table' => 'Tabel',
	'smw_printername_broadtable' => 'Tabel lebar',
	'smw_printername_template' => 'Templat',
	'smw_paramdesc_limit' => 'Jumlah maksimum hasil yang diberikan',
	'smw_paramdesc_headers' => 'Tampilkan nama kepala/properti',
	'smw_paramdesc_mainlabel' => 'Label untuk nama halaman utama',
	'smw_paramdesc_link' => 'Tampilkan nilai sebagai pranala',
	'smw_paramdesc_intro' => 'Tulisan yang ditampilkan sebelum hasil kueri, jika ada',
	'smw_paramdesc_outro' => 'Tulisan untuk ditampilkan setelah hasil kueri, jika ada',
	'smw_paramdesc_default' => 'Tulisan untuk ditampilkan jika tidak ada hasil kueri',
	'smw_paramdesc_searchlabel' => 'Tulisan pada pranala menuju hasil',
	'smw_paramdesc_sep' => 'Pemisah untuk nilai',
	'smw_paramdesc_template' => 'Nama templat yang digunakan untuk menampilkan cetakan',
	'smw_paramdesc_columns' => 'Jumlah kolom untuk menampilkan hasil (bawaannya adalah $1)',
	'smw_paramdesc_embedformat' => 'Tag HTML yang digunakan untuk menentukan judul',
	'smw_paramdesc_embedonly' => 'Jangan tampilkan judul',
	'smw_paramdesc_rsstitle' => 'Tulisan yang digunakan sebagai judul umpan',
	'smw_paramdesc_rssdescription' => 'Tulisan yang digunakan sebagai deskripsi umpan',
	'smw_iq_disabled' => 'Query semantik telah dinonaktifkan di wiki ini.',
	'smw_iq_moreresults' => '… hasil lebih lanjut',
	'smw_iq_nojs' => 'Gunakan penjelajah dengan JavaScript diaktifkan untuk melihat elemen ini.',
	'smw_iq_altresults' => 'Lihat daftar hasil secara langsung.',
	'smw_unknown_importns' => 'Fungsi impor tidak tersedia untuk ruang nama "$1".',
	'smw_nonright_importtype' => '$1 hanya dapat digunakan untuk halaman dengan ruang nama "$2".',
	'smw_wrong_importtype' => '$1 tidak dapat digunakan untuk halaman dalam ruang nama "$2".',
	'smw_no_importelement' => 'Elemen "$1" tidak tersedia untuk diimpor.',
	'smw_parseerror' => 'Nilai yang diberikan tidak dipahami.',
	'smw_notitle' => '"$1" tidak dapat digunakan sebagai nama halaman di wiki ini.',
	'smw_wrong_namespace' => 'Hanya halaman pada ruang nama "$1" yang diizinkan di sini.',
	'smw_unknowntype' => 'Tipe "$1" yang tidak didukung ditetapkan untuk properti.',
	'smw_manytypes' => 'Lebih dari satu tipe yang ditetapkan untuk properti.',
	'smw_emptystring' => 'Untaian kosong tidak diterima.',
	'smw_maxstring' => 'Representasi untaian $1 terlalu panjang.',
	'smw_notinenum' => '"$1" tidak ada dalam daftar kemungkinan nilai ($2) untuk properti ini.',
	'smw_noboolean' => '"$1" tidak dikenali sebagai suatu nilai Boolean (true/false)',
	'smw_true_words' => 'benar,t,ya,y',
	'smw_false_words' => 'salah,f,tidak,n',
	'smw_nofloat' => '"$1" bukan angka.',
	'smw_infinite' => 'Angka sebesar "$1" tidak didukung.',
	'smw_infinite_unit' => 'Konversi menjadi unit "$1" menghasilkan suatu angka yang terlalu besar.',
	'smw_unsupportedprefix' => 'Awalan untuk angka ("$1") tidak didukung.',
	'smw_unsupportedunit' => 'Konversi unit untuk unit "$1" tidak didukung.',
	'smw_nodatetime' => 'Tanggal "$1" tidak dipahami.',
	'smw_toomanyclosing' => 'Tampaknya ada terlalu banyak penyebutan "$1" pada query.',
	'smw_noclosingbrackets' => 'Penggunaan beberapa "<nowiki>[[</nowiki>" pada query Anda tidak ditutup dengan pasangan "]]".',
	'smw_misplacedsymbol' => 'Simbol "$1" digunakan pada tempat yang mubazir.',
	'smw_unexpectedpart' => 'Bagian "$1" dari query tidak dipahami.
Hasilnya mungkin tidak seperti yang diharapkan.',
	'smw_emptysubquery' => 'Beberapa subquery tidak memiliki kondisi yang valid.',
	'smw_misplacedsubquery' => 'Beberapa subquery digunakan pada tempat yang tidak mengizinkan subquery.',
	'smw_valuesubquery' => 'Subquery tidak didukung untuk nilai dari properti "$1".',
	'smw_overprintoutlimit' => 'Query mengandung terlalu banyak permintaan keluaran.',
	'smw_badprintout' => 'Beberapa perintah cetak pada query salah bentuk.',
	'smw_badtitle' => '"$1" bukan judul halaman yang valid.',
	'smw_badqueryatom' => 'Beberapa bagian "<nowiki>[[…]]</nowiki>" pada query tidak dipahami.',
	'smw_propvalueproblem' => 'Nilai properti "$1" tidak dipahami.',
	'smw_noqueryfeature' => 'Beberapa fitur query belum didukung di wiki ini dan sebagian query diabaikan ($1).',
	'smw_noconjunctions' => 'Konjungsi dalam query tidak didukung dalam wiki ini dan sebagian dari query diabaikan ($1).',
	'smw_nodisjunctions' => 'Disjungsi dalam query tidak didukung dalam wiki ini dan sebagian dari query diabaikan ($1).',
	'smw_querytoolarge' => 'Kondisi query berikut tidak dapat diproses karena pembatas wiki terhadap ukuran atau kedalaman query: $1.',
	'smw_devel_warning' => 'Fitur ini sedang dalam pengembangan dan mungkin belum berfungsi penuh.
Cadangkan data Anda sebelum menggunakannya.',
	'smw_notemplategiven' => 'Berikan suatu nilai bagi parameter "template" agar format query ini dapat bekerja.',
	'smw_type_header' => 'Properti bertipe "$1"',
	'smw_typearticlecount' => 'Menampilkan $1 {{PLURAL:$1|properti|properti}} yang menggunakan tipe ini.',
	'smw_attribute_header' => 'Halaman yang menggunakan properti "$1"',
	'smw_attributearticlecount' => 'Menampilkan $1 {{PLURAL:$1|halaman|halaman}} yang menggunakan properti ini.',
	'smw_subproperty_header' => 'Subproperti',
	'smw_subpropertyarticlecount' => 'Properti ini memiliki $1 {{PLURAL:$1|subproperti|subproperti}} berikut:',
	'smw_concept_header' => 'Halaman berkonsep "$1"',
	'smw_conceptarticlecount' => 'Menampilkan $1 {{PLURAL:$1|halaman|halaman}} yang termasuk konsep ini.',
	'exportrdf' => 'Ekspor halaman ke RDF',
	'smw_exportrdf_docu' => 'Halaman ini mengizinkan Anda untuk mendapatkan data dari suatu halaman dalam format RDF.
Untuk mengekspor halaman, masukkan judul di kotak teks di bawah, satu judul per baris.',
	'smw_exportrdf_recursive' => 'Ekspor semua halaman yang terkait secara rekursif.
Perhatikan bahwa hasilnya bisa besar!',
	'smw_exportrdf_backlinks' => 'Ekspor juga semua halaman yang merujuk ke halaman yang diekspor.
Menghasilkan RDF yang dapat ditelurusi.',
	'smw_exportrdf_lastdate' => 'Jangan mengekspor halaman yang tidak berubah sejak waktu yang diberikan.',
	'smw_exportrdf_submit' => 'Ekspor',
	'properties' => 'Properti',
	'smw_properties_docu' => 'Properti berikut digunakan dalam wiki ini.',
	'smw_property_template' => '$1 bertipe $2 ($3)',
	'smw_propertylackspage' => 'Semua properti harus dideskripsikan dengan suatu halaman!',
	'smw_propertylackstype' => 'Tidak ada tipe yang dispesifikasikan untuk properti ini (untu saat ini diasumsikan bertipe $1)',
	'smw_propertyhardlyused' => 'Properti ini hampir tak digunakan di wiki ini!',
	'unusedproperties' => 'Properti yang tak digunakan',
	'smw_unusedproperties_docu' => 'Properti berikut ada walaupun tidak ada halaman lain yang memanfaatkan mereka.',
	'smw_unusedproperty_template' => '$1 bertipe $2',
	'wantedproperties' => 'Properti yang diinginkan',
	'smw_wantedproperties_docu' => 'Properti berikut digunakan pada wiki ini tetapi belum memiliki sebuah halaman untuk mendeskripsikannya.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|penggunaan|penggunaan}})',
	'tooltip-purge' => 'Klik di sini untuk menyegarkan semua query dan templat pada halaman ini',
	'smw_purge' => 'Segarkan',
	'types' => 'Tipe',
	'smw_types_docu' => 'Berikut adalah daftar semua tipe data yang dapat diberikan pada properti.
Setiap tipe data memiliki suatu halaman yang memberikan informasi tambahan.',
	'smw_typeunits' => 'Unit ukuran tipe "$1": $2',
	'semanticstatistics' => 'Statistik semantik',
	'smw_semstats_text' => "Wiki ini memiliki '''$1''' {{PLURAL:$1|nilai|nilai}} properti dari total '''$2''' [[Special:Properties|{{PLURAL:$2|properti|properti}}]].
'''$3''' {{PLURAL:$3|properti|properti}} telah memiliki halaman sendiri, dan tipe data telah diberikan pada '''$4''' di antaranya.
Beberapa properti yang ada mungkin merupakan [[Special:UnusedProperties|properti yang tak digunakan]].
Properti yang masih tidak memiliki halaman ditemukan pada [[Special:WantedProperties|daftar properti yang diinginkan]].",
	'uriresolver' => 'Pengurai URI',
	'smw_uri_doc' => 'Pengurai URI menerapkan <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C pencarian TAG pada httpRange-14</a>.
Ini memastikan bahwa manusia tidak berubah menjadi situs web.',
	'ask' => 'Pencarian semantik',
	'smw_ask_sortby' => 'Urut berdasar kolom (pilihan)',
	'smw_ask_ascorder' => 'Menanjak',
	'smw_ask_descorder' => 'Menurun',
	'smw_ask_submit' => 'Temukan hasil',
	'smw_ask_editquery' => '[Sunting query]',
	'smw_add_sortcondition' => '[Tambahkan kondisi pengurutan]',
	'smw_ask_hidequery' => 'Sembunyikan query',
	'smw_ask_help' => 'Bantuan query',
	'smw_ask_queryhead' => 'Query',
	'smw_ask_printhead' => 'Data tambahan untuk ditampilkan',
	'smw_ask_printdesc' => '(tambahkan satu nama properti per baris)',
	'smw_ask_format_as' => 'Format sebagai:',
	'smw_ask_defaultformat' => 'baku',
	'smw_ask_otheroptions' => 'Pilihan lain',
	'smw_ask_show_embed' => 'Tampilkan kode sertaan',
	'smw_ask_hide_embed' => 'Sembunyikan kode sertaan',
	'smw_ask_embed_instr' => 'Untuk menyertakan query ini secara tersisip dalam suatu halaman wiki gunakan kode di bawah.',
	'searchbyproperty' => 'Pencarian menurut properti',
	'smw_sbv_docu' => 'Cari semua halaman yang memiliki properti dan nilai yang diberikan.',
	'smw_sbv_novalue' => 'Masukkan nilai yang valid untuk properti, atau lihat semua nilai properti untuk "$1".',
	'smw_sbv_displayresult' => 'Daftar semua halaman yang memiliki properti "$1" dengan nilai "$2"',
	'smw_sbv_displayresultfuzzy' => 'Daftar semua halaman yang memiliki properti "$1" dengan nilai "$2".
Karena hanya ada sedikit hasil, nilai yang mendekati juga ditampilkan.',
	'smw_sbv_property' => 'Properti:',
	'smw_sbv_value' => 'Nilai:',
	'smw_sbv_submit' => 'Temukan hasil',
	'browse' => 'Jelajahi wiki',
	'smw_browselink' => 'Jelajahi properti',
	'smw_browse_article' => 'Masukkan nama halaman untuk memulai penelusuran',
	'smw_browse_go' => 'Tuju ke',
	'smw_browse_show_incoming' => 'tampilkan properti yang bertaut ke sini',
	'smw_browse_hide_incoming' => 'sembunyikan properti yang bertaut ke sini',
	'smw_browse_no_outgoing' => 'Halaman ini tidak memiliki properti.',
	'smw_browse_no_incoming' => 'Tidak ada properti yang bertaut ke halaman ini.',
	'smw_inverse_label_default' => '$1 dari',
	'smw_inverse_label_property' => 'Label properti inversi',
	'pageproperty' => 'Pencarian properti halaman',
	'smw_pp_docu' => 'Pencarian semua nilai suatu properti pada suatu halaman.
Masukkan satu halaman dan satu properti.',
	'smw_pp_from' => 'Dari halaman',
	'smw_pp_type' => 'Properti',
	'smw_pp_submit' => 'Temukan hasil',
	'smw_result_prev' => 'Sebelumnya',
	'smw_result_next' => 'Selanjutnya',
	'smw_result_results' => 'Hasil',
	'smw_result_noresults' => 'Tidak ada hasilnya.',
	'smwadmin' => 'Fungsi admin untuk Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Pengaturan simpanan untuk Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Mesin penyimpanan berhasil disiapkan.',
	'smw_smwadmin_return' => 'Kembali ke $1',
	'smw_smwadmin_updatestarted' => 'Suatu proses pembaruan untuk menyegarkan data semantik telah dimulai.
Semua data tersimpan akan dibangun ulang atau diperbaiki jika diperlukan.
Anda dapat mengikuti kemajuan pembaruan tersebut di halaman istimewa ini.',
	'smw_smwadmin_updatenotstarted' => 'Sudah ada suatu proses pembaruan yang sedang berjalan.
Tidak membuat proses lain.',
	'smw_smwadmin_updatestopped' => 'Semua proses pembaruan yang ada telah dihentikan.',
	'smw_smwadmin_updatenotstopped' => 'Untuk menghentikan proses pembaruan yang sedang berjalan, Anda harus memilih kotak centang untuk menunjukkan bahwa Anda benar-benar yakin.',
	'smw_smwadmin_docu' => 'Halaman istimewa ini akan membantu Anda selama instalasi dan peningkatan dari <a href="http://semantic-mediawiki.org">Semantic MediaWiki.</a>
Jangan lupa untuk mencadangkan data Anda yang berharga sebelum melaksanakan fungsi administratif.',
	'smw_smwadmin_db' => 'Instalasi dan peningkatan basis data',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki mensyaratkan beberapa pengembangan basis data MediaWiki untuk menyimpan data semantik.
Fungsi berikut memastikan bahwa basis data Anda dipersiapkan dengan baik.
Perubahan yang dilakukan pada langkah ini tidak memengaruhi bagian lain dari basis data MediaWiki, dan dengan mudah dapat dibatalkan jika diingkan.
Fungsi persiapan ini dapat dilakukan berulang kali tanpa menyebabkan kerusaan, tapi hanya dibutuhkan sekali sewaktu instalasi atau peningkatan.',
	'smw_smwadmin_permissionswarn' => 'Jika operasi gagal karena kesalahan SQL, pengguna basis data yang digunakan oleh wiki Anda (cek LocalSettings.php Anda) mungkin tidak mempunyai hak akses yang cukup.
Anda dapat memberikan hak akses tambahan untuk membuat dan menghapus tabel, memasukkan sementara pengguna root basis data Anda di LocalSettings.php, atau menggunakan skrip pemeliharaan <tt>SMW_setup.php</tt> yang dapat menggunakan hak akses dari AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Menginisiasi atau meningkatkan tabel',
	'smw_smwadmin_announce' => 'Umumkan wiki Anda',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki memiliki layanan web untuk mengumumkan situs wiki semantik baru.
Ini digunakan untuk memelihara suatu daftar situs publik yang menggunakan Semantic MediaWiki, terutama untuk membantu <a href="http://semantic-mediawiki.org/wiki/SMW_Project">proyek Semantic MediaWiki</a> untuk mendapat gambaran penggunaan umum dari Semantic MediaWiki.
Kunjungin beranda Semantic MediaWiki untuk <a href="http://semantic-mediawiki.org/wiki/Registry">informasi lebih lanjut tentang layanan ini</a>.',
	'smw_smwadmin_announcebutton' => 'Tekan tombol berikut untuk mengirim URL wiki Anda ke layanan itu.
Layanan ini tidak akan mendaftarkan wiki yang tidak bisa diakses publik, dan hanya akan menyimpan informasi yang bisa diakses publik.',
	'smw_smwadmin_datarefresh' => 'Perbaikan dan peningkatan data',
	'smw_smwadmin_datarefreshdocu' => 'Dimungkinkan untuk memulihkan semua data Semantic MediaWiki berdasarkan isi yang ada sekarang di wiki ini.
Hal ini berguna untuk memperbaiki data yang rusak atau menyegarkan data jika format internal telah berubah karena suatu peningkatan perangkat lunak.
Pembaruan dilaksanakan halaman per halaman dan tidak akan langsung selesai.
Tampilan berikut menunjukkan jika suatu pembaruan sedang berlangsung dan memungkinkan Anda untuk memulai atau menghentikan proses (kecuali jika fitur ini dimatikan oleh pengelola situs).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Suatu pembaruan sedang dalam proses.</strong>
Adalah wajar jika kemajuan pembaruan berjalan lambat karena ia hanya menyegarkan data sedikit demi sedikit setiap kali seorang pengguna mengakses wiki ini.
Untuk menyelesaikan pembaruan ini dengan lebih cepat, Anda dapat menjalankan skrip pemeliharaan MediaWiki <tt>runJobs.php</tt> (gunakan opsi <tt>--maxjobs 1000</tt> untuk membatasi jumlah pembaruan yang dilakukan dalam satu saat).
Perkiraan kemajuan pembaruan saat ini:',
	'smw_smwadmin_datarefreshbutton' => 'Mulai pembaruan data',
	'smw_smwadmin_datarefreshstop' => 'Hentikan pembaruan ini',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ya, saya yakin.',
	'smw_smwadmin_support' => 'Cari dukungan',
	'smw_smwadmin_supportdocu' => 'Berbagai sumber dapat membantu Anda jika ada masalah:',
	'smw_smwadmin_installfile' => 'Jika Anda menghadapi masalah dengan instalasi Anda, mulailah dengan mengecek pedoman di <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">berkas INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Dokumentasi pengguna lengkap untuk Semantic MediaWiki tersedia di <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Bug dapat dilaporkan ke <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Jika Anda memiliki pertanyaan atau saran lain, bergabunglah dengan diskusi di <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">forum pengguna Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Struktur data',
	'smw_adminlinks_displayingdata' => 'Menampilkan data',
	'smw_adminlinks_inlinequerieshelp' => 'Bantuan query sisip',
);

/** Igbo (Igbo)
 * @author Ukabia
 */
$messages['ig'] = array(
	'smw_viewasrdf' => 'ntá RDF',
	'smw_finallistconjunct' => ', na',
	'smw_factbox_head' => 'Ómárí maka $1',
	'smw_printername_count' => 'güó ihe futárá',
	'smw_printername_list' => 'Ndetu',
	'smw_printername_table' => 'Agada',
	'smw_printername_template' => 'Nkpurụ ihü',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'smw_printername_template' => 'Shablono',
	'smw_result_next' => 'Sequanta',
);

/** Italian (Italiano)
 * @author Civvì
 * @author Cruccone
 * @author Darth Kule
 * @author Davide Eynard, David Laniado
 * @author Gianfranco
 * @author Melos
 * @author Pietrodn
 */
$messages['it'] = array(
	'smw-desc' => "Rende la tua wiki più accessibile - per le macchine ''e'' per gli umani ([http://semantic-mediawiki.org/wiki/Help:User_manual documentazione in linea])",
	'smw_edithelp' => 'Aiuto sulla modifica delle proprietà',
	'smw_viewasrdf' => 'Feed RDF',
	'smw_finallistconjunct' => ' e',
	'smw_factbox_head' => 'Fatti riguardanti $1',
	'smw_isspecprop' => "Questa proprietà è una proprietà speciale all'interno di questo wiki.",
	'smw_isknowntype' => 'Questo tipo &egrave; fra i tipi di dato standard di questo wiki',
	'smw_isaliastype' => 'Questo tipo &egrave; un alias per il tipo di dato “$1”.',
	'smw_isnotype' => "Il tipo “$1” non &egrave; un tipo di dato standard nel wiki, n&eacute; &egrave; stato ancora definito dall'utente.",
	'smw_concept_description' => 'Descrizione del concetto "$1"',
	'smw_no_concept_namespace' => 'I concetti possono essere definiti solo sulle pagine nel namespace Concept:.',
	'smw_multiple_concepts' => 'Ogni pagina concetto può avere una sola definizione di concetto.',
	'smw_concept_cache_miss' => 'Il concetto "$1" non può essere usato ora, siccome la configurazione della wiki richiede che sia elaborato off-line. Se il problema non si risolve dopo un po\' di tempo, chiedi all\'amministratore del tuo sito di rendere disponibile questo concetto.',
	'smw_noinvannot' => 'Il valore non può essere assegnato alla proprietà inversa.',
	'smw_baduri' => 'Spiacenti. Gli URI del tipo “$1” non sono consentiti.',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automatico',
	'smw_printername_count' => 'Conta risultati',
	'smw_printername_csv' => 'Esportazione CSV',
	'smw_printername_debug' => 'Debug della query (per utenti esperti)',
	'smw_printername_embedded' => 'Includi i contenuti della pagina',
	'smw_printername_json' => 'Esportazione JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumerazione',
	'smw_printername_ul' => 'Creazione lista di elementi',
	'smw_printername_rss' => 'Esportazione RSS',
	'smw_printername_table' => 'Tabella',
	'smw_printername_broadtable' => 'Tabella estesa',
	'smw_printername_template' => 'Template',
	'smw_paramdesc_limit' => 'Il numero massimo di risultati da restituire',
	'smw_paramdesc_headers' => 'Mostra i nomi di header/proprietà',
	'smw_paramdesc_mainlabel' => "L'etichetta da dare al nome della pagina principale",
	'smw_paramdesc_link' => 'Mostra i valori come link',
	'smw_paramdesc_intro' => 'Testo da mostrare prima dei risultati della query, se ce ne sono',
	'smw_paramdesc_outro' => 'Testo da mostrare dopo i risultati della query, se ce ne sono',
	'smw_paramdesc_default' => 'Testo da mostrare se la query non dà risultati',
	'smw_paramdesc_searchlabel' => 'Il testo nel link ai risultati',
	'smw_paramdesc_sep' => 'Il separatore per i valori',
	'smw_paramdesc_template' => 'Il nome di un template con cui mostrare quanto restituito',
	'smw_paramdesc_columns' => 'Il numero di colonne in cui ordinare la visualizzazione dei risultati (valore predefinito: $1)',
	'smw_paramdesc_embedformat' => 'Il tag HTML usato per definire le intestazioni',
	'smw_paramdesc_embedonly' => 'Non mostrare intestazioni',
	'smw_paramdesc_rsstitle' => 'Testo da usare come titolo del feed',
	'smw_paramdesc_rssdescription' => 'Testo da usare come descrizione del feed',
	'smw_iq_disabled' => 'Spiacenti. Le query semantiche sono state disabilitate per questo wiki.',
	'smw_iq_moreresults' => '&hellip; risultati successivi',
	'smw_iq_nojs' => 'Per favore, usate un browser che supporti Javascript per visualizzare questo elemento.',
	'smw_iq_altresults' => "Visualizza direttamente l'elenco dei risultati.",
	'smw_unknown_importns' => 'Le funzioni di importazione non sono disponibili per il namespace “$1”.',
	'smw_nonright_importtype' => '$1 pu&ograve; essere utilizzato solo per pagine con namespace “$2”.',
	'smw_wrong_importtype' => '$1 non pu&ograve; essere utilizzate per pagine nel namespace “$2”.',
	'smw_no_importelement' => "L'elemento “$1” non &egrave; disponibile per l'importazione.",
	'smw_parseerror' => 'Il valore dato non è stato compreso.',
	'smw_notitle' => "“$1” non pu&ograve; essere utilizzato come nome di una pagina all'interno di questo wiki.",
	'smw_wrong_namespace' => 'Qui sono consentite solo pagine del namespace "$1".',
	'smw_unknowntype' => 'È stato definito un tipo non supportato "$1" per la proprietà.',
	'smw_manytypes' => 'È stato definito più di un tipo per la proprietà.',
	'smw_emptystring' => 'Le stringhe vuote non sono accettate.',
	'smw_maxstring' => 'La stringa $1 è troppo lunga.',
	'smw_notinenum' => '"$1" non è nella lista dei valori possibili ($2) per questa proprietà.',
	'smw_noboolean' => '“$1” non &egrave; riconosciuto come valore Booleano (vero/falso).',
	'smw_true_words' => 'vero,v,si,s,true,t,yes,y',
	'smw_false_words' => 'falso,f,no,n,false',
	'smw_nofloat' => '“$1” non &egrave; un numero.',
	'smw_infinite' => 'I numeri grandi come "$1" non sono supportati.',
	'smw_infinite_unit' => 'La conversione nell\'unità di misura "$1" ha generato un numero che è troppo grande.',
	'smw_novalues' => 'Nessun valore specificato',
	'smw_unsupportedprefix' => 'I prefissi per i numeri (“$1”) non sono supportati.',
	'smw_unsupportedunit' => "La conversione per l'unit&agrave; di misura “$1” non &egrave; supportata.",
	'smw_nodatetime' => 'Non &egrave; stato possibile comprendere la data “$1”.',
	'smw_toomanyclosing' => "Sembrano esserci troppe ripetizioni di “$1” all'interno della query.",
	'smw_noclosingbrackets' => 'Alcune "<nowiki>[[</nowiki>" all\'interno della query non sono state chiuse con le corrispondenti "]]".',
	'smw_misplacedsymbol' => 'Il simbolo “$1” &grave; stato usato in un punto in cui &egrave; inutile.',
	'smw_unexpectedpart' => 'Non &egrave; stato possibile comprendere la parte “$1” della query. Il risultato potrebbe essere diverso da quello atteso.',
	'smw_emptysubquery' => 'Qualche subquery ha una condizione non valida.',
	'smw_misplacedsubquery' => 'Qualche subquery &egrave; stata utilizzata in una posizione in cui non era consentito.',
	'smw_valuesubquery' => 'Le subquery non sono supportate per i valori della proprietà "$1".',
	'smw_overprintoutlimit' => 'La query contiene troppe richieste di printout.',
	'smw_badprintout' => "Comando print malformato all'interno della query.",
	'smw_badtitle' => 'Spiacenti, “$1” non &egrave; un titolo valido.',
	'smw_badqueryatom' => 'Non è stato possibile comprendere parte "<nowiki>[[…]]</nowiki>" della query.',
	'smw_propvalueproblem' => 'Non è stato possibile comprendere il valore della proprietà "$1".',
	'smw_noqueryfeature' => 'Qualche funzionalità di query non è stata supportata in questa wiki e parte della query è stata rimossa ($1).',
	'smw_noconjunctions' => 'Le congiunzioni nelle query non sono supportate in questa wiki e parte della query è stata rimossa ($1).',
	'smw_nodisjunctions' => "La disgiunzione all'interno delle query non &egrave; supportata in questo wiki, quindi parte della query &egrave; stata ignorata ($1).",
	'smw_querytoolarge' => "Le seguenti condizioni all'interno della query non sono state considerate a causa delle restrizioni di dimensione o profondit&agrave; delle query impostate per questo wiki: $1.",
	'smw_devel_warning' => 'Questa funzione &egrave; attualmente in fase di sviluppo e potrebbe non essere completamente funzionante: si consiglia di eseguire un backup dei dati prima di usarla.',
	'smw_notemplategiven' => 'Per favore fornisci un valore per il parametro "template" per far funzionare questo formato di query.',
	'smw_type_header' => 'Proprietà del tipo "$1"',
	'smw_typearticlecount' => 'Visualizzazione di $1 {{PLURAL:$1|proprietà|proprietà}} che usano questo tipo.',
	'smw_attribute_header' => 'Pagine che usano la proprietà "$1"',
	'smw_attributearticlecount' => 'Visualizzazione di $1 {{PLURAL:$1|pagina che usa|pagine che usano}} questa proprietà.',
	'smw_subproperty_header' => 'Sottoproprietà',
	'smw_subpropertyarticlecount' => 'Questa proprietà ha {{PLURAL:$1|la seguente|le seguenti $1}} sottoproprietà.',
	'smw_concept_header' => 'Pagine del concetto "$1"',
	'smw_conceptarticlecount' => 'Mostro {{PLURAL:$1|una pagina|$1 pagine}} appartenenti a quel concetto.',
	'exportrdf' => 'Esporta le pagine in RDF',
	'smw_exportrdf_docu' => 'Questa pagina consente di ottenere dati da una pagina in formato RDF. Per esportare delle pagine, inseritene i titoli nella casella di testo sottostante, un titolo per riga.',
	'smw_exportrdf_recursive' => 'Esporta ricorsivamente tutte le pagine correlate. Nota: il risultato potrebbe essere molto grande!',
	'smw_exportrdf_backlinks' => 'Esporta anche le pagine che si riferiscono a quelle esportate. Genera un RDF navigabile.',
	'smw_exportrdf_lastdate' => 'Non esportare le pagine che non hanno sub&igrave;to modifiche dal momento specificato.',
	'smw_exportrdf_submit' => 'Esporta',
	'properties' => 'Proprietà',
	'smw_properties_docu' => "Le seguenti proprietà sono utilizzate all'interno del wiki.",
	'smw_property_template' => '$1 di tipo $2 ($3)',
	'smw_propertylackspage' => 'Tutte le proprietà dovrebbero essere descritte da una pagina!',
	'smw_propertylackstype' => 'Non è stato specificato nessun tipo per questa proprietà (per il momento si suppone sia di tipo $1).',
	'smw_propertyhardlyused' => 'Questa proprietà non è quasi mai usata nel wiki!',
	'unusedproperties' => 'Propietà non utilizzate',
	'smw_unusedproperties_docu' => "Le seguenti proprietà esistono nonostante nessun'altra pagina ne faccia uso.",
	'smw_unusedproperty_template' => '$1 di tipo $2',
	'wantedproperties' => 'Proprietà senza descrizione',
	'smw_wantedproperties_docu' => 'Le seguenti proprietà sono usate nel wiki ma non hanno ancora una pagina che le descriva.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uso|usi}})',
	'tooltip-purge' => 'Clicca qui per riaggiornare tutte le query e i template di questa pagina',
	'smw_purge' => 'Aggiorna',
	'types' => 'Tipi',
	'smw_types_docu' => 'La seguente &egrave; una lista di tutti i tipi di dati che possono essere assegnati alle propiet&agrave;. Ogni tipo di dato ha una pagina dove si possono trovare informazioni aggiuntive.',
	'smw_typeunits' => 'Unit&agrave; di misura di tipo “$1”: $2',
	'semanticstatistics' => 'Statistiche Semantiche',
	'smw_semstats_text' => "Questo sito contiene '''$1''' {{PLURAL:$1|valore|valori}} di proprietà per un totale di '''$2''' [[Special:Properties|{{PLURAL:$2|proprietà|differenti proprietà}}]].
'''$3''' proprietà {{PLURAL:$3|ha|hanno}} una propria pagina e il tipo di dato inteso è specificato per '''$4''' di queste.
Alcune delle proprietà esistenti possono essere [[Special:UnusedProperties|proprietà non utilizzate]].
Le proprietà che ancora non hanno una pagina si possono trovare nell'[[Special:WantedProperties|elenco delle proprietà senza descrizione]].",
	'uriresolver' => 'Risolutore di URI',
	'smw_uri_doc' => 'Il risolutore di URI implementa il <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>. Fa in modo che gli esseri umani non diventino siti Web.',
	'ask' => 'Ricerca semantica',
	'smw_ask_sortby' => 'Ordina per colonna (opzionale)',
	'smw_ask_ascorder' => 'Crescente',
	'smw_ask_descorder' => 'Decrescente',
	'smw_ask_submit' => 'Trova risultati',
	'smw_ask_editquery' => '[Modifica query]',
	'smw_add_sortcondition' => '[Aggiungi condizione di ordinamento]',
	'smw_ask_hidequery' => 'Nascondi query',
	'smw_ask_help' => 'Help sulle query',
	'smw_ask_queryhead' => 'Interrogazione',
	'smw_ask_printhead' => 'Dati supplementari da mostrare',
	'smw_ask_printdesc' => '(aggiungi un nome di proprietà per riga)',
	'smw_ask_format_as' => 'Formatta come:',
	'smw_ask_defaultformat' => 'predefinito',
	'smw_ask_otheroptions' => 'Altre opzioni',
	'smw_ask_show_embed' => 'Mostra codice di inclusione',
	'smw_ask_hide_embed' => 'Nascondi codice di inclusione',
	'smw_ask_embed_instr' => 'Per includere questa query in linea in una pagina wiki, usa il codice qui sotto.',
	'searchbyproperty' => 'Cerca per proprietà',
	'smw_sbv_docu' => 'Cerca tutte le pagine che hanno proprietà e valore specificati.',
	'smw_sbv_novalue' => 'Inserire un valore valido per la proprietà, o visualizzare tutti i valori di proprietà per "$1".',
	'smw_sbv_displayresult' => 'Lista di tutte le pagine che hanno proprietà "$1" con valore "$2"',
	'smw_sbv_displayresultfuzzy' => 'Una lista di tutte le pagine che hanno la proprietà "$1" col valore "$2".
Siccome ci sono solo pochi risultati, sono visualizzati anche i valori vicini.',
	'smw_sbv_property' => 'Proprietà:',
	'smw_sbv_value' => 'Valore:',
	'smw_sbv_submit' => 'Trova risultati',
	'browse' => 'Esplora il wiki',
	'smw_browselink' => 'Sfoglia le proprietà',
	'smw_browse_article' => "Inserire il nome della pagina da cui iniziare l'esplorazione",
	'smw_browse_go' => 'Vai',
	'smw_browse_show_incoming' => 'mostra le proprietà che linkano qui',
	'smw_browse_hide_incoming' => 'nascondi le proprietà che linkano qui',
	'smw_browse_no_outgoing' => 'Questa pagina non ha proprietà.',
	'smw_browse_no_incoming' => 'Nessuna proprietà linka a questa pagina.',
	'smw_inverse_label_default' => '$1 di',
	'smw_inverse_label_property' => 'Etichetta della proprietà inversa',
	'pageproperty' => 'Ricerca proprietà della pagina',
	'smw_pp_docu' => 'Cerca tutti i valori che soddisfano una proprietà su una data pagina. Inserire sia la pagina sia la proprietà.',
	'smw_pp_from' => 'Da pagina',
	'smw_pp_type' => 'Proprietà',
	'smw_pp_submit' => 'Trova risultati',
	'smw_result_prev' => 'Precedente',
	'smw_result_next' => 'Successivo',
	'smw_result_results' => 'Risultati',
	'smw_result_noresults' => 'Spiacenti, nessun risultato.',
	'smwadmin' => 'Funzioni amministrative per Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Installazione storage per Semantic MediaWiki in corso',
	'smw_smwadmin_setupsuccess' => 'Il motore di storage è stato installato correttamente.',
	'smw_smwadmin_return' => 'Ritorna a $1',
	'smw_smwadmin_updatestarted' => "Un nuovo processo di aggiornamento per ricaricare i dati semantici è iniziato.
Tutti i dati registrati saranno ricostruiti o riparati se necessario.
Puoi seguire i progressi dell'aggiornamento in questa pagina speciale.",
	'smw_smwadmin_updatenotstarted' => "C'è già un processo di aggiornamento in corso.
Non ne verrà avviato un altro.",
	'smw_smwadmin_updatestopped' => 'Tutti i processi di aggiornamento in corso sono stati arrestati.',
	'smw_smwadmin_updatenotstopped' => 'Per arrestare i processi di aggiornamento in corso, devi selezionare la casellina per confermare che sei davvero sicuro di volerlo fare.',
	'smw_smwadmin_docu' => 'Questa pagina speciale serve ad aiutarti durante l\'installazione e l\'aggiornamento di <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Ricordati di fare un backup dei dati importanti prima di eseguire funzioni amministrative.',
	'smw_smwadmin_db' => 'Installazione database e aggiornamento',
	'smw_smwadmin_dbdocu' => "Semantic MediaWiki richiede alcune estensioni del database MediaWiki per poter registrare i dati semantici.
La funzione qui sotto verifica che il tuo database sia installato correttamente.
Le modifiche effettuate in questo passaggio non hanno effetto sul resto del database MediaWiki, e possono essere facilmente annullate se necessario.
Questa funzione di setup può essere rieseguita più volte senza conseguenze indesiderate, ma è richiesta solo una volta all'atto dell'installazione o dell'aggiornamento.",
	'smw_smwadmin_permissionswarn' => "Se l'operazione fallisce con errori SQL, l'utente del database usato dal tuo Wiki (controlla nel LocalSettings.php) probabilmente non ha permessi sufficienti.
Alternativamente assegna a questo utente permessi aggiuntivi per creare e cancellare tabelle, oppure immetti temporaneamente in LocalSettings.php i dati di accesso root al database, oppure usa lo script di manutenzione <tt>SMW_setup.php</tt> che può usare le credenziali di AdminSettings.php.",
	'smw_smwadmin_dbbutton' => 'Inizializza o aggiorna tabelle',
	'smw_smwadmin_announce' => 'Annuncia il tuo wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki dispone di un servizio web per dare notizia di nuovi siti wiki semantici.
Il servizio è usato per mantenere una lista di siti pubblici che usano Semantic MediaWiki principalmente per fornire al <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Progetto Semantic MediaWiki</a> una panoramica degli usi tipici del Semantic MediaWiki.
Visita la Home Page di Semantic MediaWiki per <a href="http://semantic-mediawiki.org/wiki/Registry">maggiori informazioni su questo servizio</a>.',
	'smw_smwadmin_announcebutton' => 'Premi il bottone seguente per inviare la URL del tuo wiki a quel servizio.
Il servizio non registrerà wiki che non siano pubblicamente accessibili, e conserverà esclusivamente informazioni pubblicamente accessibili.',
	'smw_smwadmin_datarefresh' => 'Riparazione ed aggiornamento dei dati',
	'smw_smwadmin_datarefreshdocu' => "Si possono ripristinare tutti i dati Semantic MediaWiki basati sui contenuti attuali del wiki.
Questo può essere utile per riparare dati corrotti o per aggiornare i dati se il loro formato interno si è modificato per qualche aggiornamento di software.
L'aggiornamento è eseguito pagina per pagina e non sarà completato immediatamente.
Qui di seguito si vede se un aggiornamento è in corso e potrai avviare od arrestare gli aggiornamenti (a meno che questa funzionalità non sia stata disattivata dall'amministratore del sito).",
	'smw_smwadmin_datarefreshprogress' => "<strong>Un aggiornamento è già in corso.</strong>
Non è anormale che l'aggiornamento proceda solo lentamente, poiché verifica i dati solo a piccoli pacchetti ogni volta che un utente accede al wiki.
Per terminare il processo pià rapidamente, puoi invocare lo script di manutenzione MediaWiki <tt>runJobs.php</tt> (usa l'opzione <tt>--maxjobs 1000</tt> per restringere il numero di verifiche svolte in ciascuna tornata).
Progresso stimato dell'aggiornamento in corso:",
	'smw_smwadmin_datarefreshbutton' => "Inizia l'aggiornamento dei dati",
	'smw_smwadmin_datarefreshstop' => 'Ferma questo aggiornamento',
	'smw_smwadmin_datarefreshstopconfirm' => 'Sì, sono sicuro.',
	'smw_smwadmin_support' => 'Ottenere supporto',
	'smw_smwadmin_supportdocu' => "Diverse risorse potrebbero esserti d'aiuto in caso di problemi:",
	'smw_smwadmin_installfile' => 'Se hai problemi con la tua installazione, inizia a verificare le linee guida nel <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">file INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'La documentazione completa per l\'utente di Semantic MediaWiki si trova in <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'I Bug possono essere riportati a <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Se hai altre domande o suggerimenti, unisciti alle discussioni sul <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">forum degli utenti di Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Struttura dei dati',
	'smw_adminlinks_displayingdata' => 'Visualizzazione dati',
	'smw_adminlinks_inlinequerieshelp' => 'Aiuto sulle query inline',
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author Hosiryuhosi
 * @author Naohiro19
 * @author 青子守歌
 */
$messages['ja'] = array(
	'smw-desc' => 'あなたのウィキを、機械および人間にとってよりアクセスしやすいものにします ([http://semantic-mediawiki.org/wiki/Help:User_manual オンラインドキュメント])',
	'smw_edithelp' => 'プロパティの編集ヘルプ',
	'smw_viewasrdf' => 'RDFフィード',
	'smw_finallistconjunct' => ', および',
	'smw_factbox_head' => '$1 に関する事実',
	'smw_isspecprop' => 'このプロパティはこのウィキ内の特別なプロパティです。',
	'smw_isknowntype' => 'この型はこのウィキの標準データ型の1つです。',
	'smw_isaliastype' => 'この型はデータ型「$1」の別名です。',
	'smw_isnotype' => 'この型「$1」はこのウィキの標準データ型ではなく、利用者による定義も与えられていません。',
	'smw_concept_description' => '概念「$1」の説明',
	'smw_no_concept_namespace' => '概念は Concept: 名前空間のページでのみ定義できます。',
	'smw_multiple_concepts' => '各概念ページはただ1つの概念定義をもつことができます。',
	'smw_concept_cache_miss' => '概念「$1」は、ウィキの設定によりオフラインでの処理が必要なため、ただいま利用することができません。しばらく経っても問題が消えない場合、サイト管理者にこの概念を利用できるよう問い合わせてください。',
	'smw_noinvannot' => '逆プロパティに値を割り当てることはできません。',
	'smw_baduri' => '「$1」という形式のURIは認められていません。',
	'smw_printername_auto' => '自動',
	'smw_printername_count' => '集計結果',
	'smw_printername_csv' => 'CSV形式で書き出し',
	'smw_printername_debug' => 'デバッグ・クエリー(上級者向け)',
	'smw_printername_embedded' => 'ページの内容を埋め込む',
	'smw_printername_json' => 'JSON形式で書き出し',
	'smw_printername_list' => '一覧',
	'smw_printername_ol' => '番号付箇条書き',
	'smw_printername_ul' => '箇条書き',
	'smw_printername_rss' => 'RSS形式で書き出し',
	'smw_printername_table' => '表',
	'smw_printername_broadtable' => '幅広の表',
	'smw_printername_template' => 'テンプレート',
	'smw_paramdesc_limit' => '返却結果の最大数',
	'smw_paramdesc_headers' => 'ヘッダーやプロパティーの名前を表示する',
	'smw_paramdesc_mainlabel' => 'メインページの名前に与えるラベル',
	'smw_paramdesc_link' => '値をリンクとして表示する',
	'smw_paramdesc_intro' => '問い合わせ結果がある場合、その前に表示する文章',
	'smw_paramdesc_outro' => '問い合わせ結果がある場合、その後に表示する文章',
	'smw_paramdesc_default' => '問い合わせ結果がない場合に表示する文章',
	'smw_paramdesc_searchlabel' => '結果へのリンクに充てる文字列',
	'smw_paramdesc_sep' => '値の区切り記号',
	'smw_paramdesc_template' => '印刷出力とともに表示するテンプレートの名前',
	'smw_paramdesc_columns' => '結果を表示する列の数 (既定は3)',
	'smw_paramdesc_embedformat' => '見出しを定義するための HTML タグ',
	'smw_paramdesc_embedonly' => '見出しを表示しない',
	'smw_paramdesc_rsstitle' => 'フィードの表題として使う文字列',
	'smw_paramdesc_rssdescription' => 'フィードの説明文として使う文字列',
	'smw_iq_disabled' => '意味的クエリーはこのウィキでは無効になっています。',
	'smw_iq_moreresults' => '… 追加結果',
	'smw_iq_nojs' => 'この要素を表示するには JavaScript が有効なブラウザを使ってください。',
	'smw_iq_altresults' => '結果一覧を直接閲覧する。',
	'smw_unknown_importns' => 'インポート機能は「$1」名前空間では利用できません。',
	'smw_nonright_importtype' => '$1は名前空間「$2」のページでしか利用できません。',
	'smw_wrong_importtype' => '$1は名前空間「$2」のページでは利用できません。',
	'smw_no_importelement' => '要素「$1」はインポートが利用できません。',
	'smw_parseerror' => '指定値が理解できませんでした。',
	'smw_notitle' => '「$1」はこのウィキではページ名として使用できません。',
	'smw_wrong_namespace' => '「$1」名前空間のページのみがここでは許可されています。',
	'smw_unknowntype' => '対応していない型「$1」がプロパティに対して定義されました。',
	'smw_manytypes' => '複数の型がプロパティに対して定義されました。',
	'smw_emptystring' => '空文字列は受け入れられません。',
	'smw_maxstring' => '文字列表現 $1 は長すぎます。',
	'smw_notinenum' => '「$1」はこのプロパティが取りうる値 ($2) 一覧にありません。',
	'smw_noboolean' => '「$1」はブール値 (真または偽) として認識されません。',
	'smw_true_words' => 'true,t,yes,y,真,はい',
	'smw_false_words' => 'false,f,no,n,偽,いいえ',
	'smw_nofloat' => '「$1」は数ではありません。',
	'smw_infinite' => '「$1」以上の数には対応しません。',
	'smw_infinite_unit' => '単位「$1」への変換結果は数として大きすぎます。',
	'smw_novalues' => '値が指定されていません。',
	'smw_unsupportedprefix' => '数値のプレフィクス ($1) には対応しません。',
	'smw_unsupportedunit' => '単位「$1」への変換には対応しません。',
	'smw_nodatetime' => '「$1」という日付は理解できませんでした。',
	'smw_toomanyclosing' => 'クエリー中に含まれる「$1」の数が多すぎるようです。',
	'smw_noclosingbrackets' => 'クエリー中の <nowiki>[[</nowiki> に、対応する ]] で閉じられていないものがありました。',
	'smw_misplacedsymbol' => '記号「$1」は意味のない場所で使われていました。',
	'smw_unexpectedpart' => 'クエリーの一部「$1」は理解できませんでした。結果は予期しないものになるかもしれません。',
	'smw_emptysubquery' => 'サブクエリーには有効な条件をもたないものがあります。',
	'smw_misplacedsubquery' => 'サブクエリーのなかに、サブクエリーが許可されていない場所で使われているものがあります。',
	'smw_valuesubquery' => 'プロパティ「$1」の値に対してはサブクエリーが使えません。',
	'smw_overprintoutlimit' => 'クエリーに含まれる出力要求が多すぎます。',
	'smw_badprintout' => 'クエリー中のプリント文には形式の誤ったものがあります。',
	'smw_badtitle' => '「$1」は有効なページ名ではありません。',
	'smw_badqueryatom' => 'クエリーの「<nowiki>[[…]]</nowiki>」という部分が理解できませんでした。',
	'smw_propvalueproblem' => 'プロパティ「$1」の値は理解できませんでした。',
	'smw_noqueryfeature' => 'このウィキではクエリーの機能の一部をサポートしておらず、クエリーの一部が破棄されました ($1)。',
	'smw_noconjunctions' => 'このウィキではクエリーに連言をサポートしておらず、クエリーの一部が破棄されました ($1)。',
	'smw_nodisjunctions' => 'このウィキではクエリーに選言をサポートしておらず、クエリーの一部が破棄されました ($1)。',
	'smw_querytoolarge' => '次のクエリー条件は、クエリーの長さまたは深さに関するウィキ上の制限のため、考慮されませんでした: $1',
	'smw_devel_warning' => 'この機能は現在開発中であり、完全には機能しない可能性があります。使用前にあなたのデータをバックアップしてください。',
	'smw_notemplategiven' => 'このクエリー形式が実行されるためには「テンプレート」引数の値を指定してください。',
	'smw_type_header' => '型「$1」のプロパティ',
	'smw_typearticlecount' => 'この型を使っている $1個の{{PLURAL:$1|プロパティ}}を表示しています。',
	'smw_attribute_header' => 'プロパティ「$1」を使っているページ',
	'smw_attributearticlecount' => 'このプロパティを使っている $1個の{{PLURAL:$1|ページ}}を表示しています。',
	'smw_subproperty_header' => 'サブプロパティ',
	'smw_subpropertyarticlecount' => 'このプロパティには次の $1個の{{PLURAL:$1|サブプロパティ}}があります:',
	'smw_concept_header' => '概念「$1」のページ',
	'smw_conceptarticlecount' => 'この概念に属する $1個の{{PLURAL:$1|ページ}}を表示しています。',
	'smw_rss_description' => '$1 RSSフィード',
	'specialpages-group-smw_group' => 'セマンティック・メディアウィキ',
	'exportrdf' => 'ページをRDFにエクスポート',
	'smw_exportrdf_docu' => 'このページを使うとページからデータをRDF形式で取得できます。ページをエクスポートするには、下のテキストボックスにページ名を一行に一つずつ入力してください。',
	'smw_exportrdf_recursive' => 'すべての関連ページを再帰的にエクスポートする。結果は大きくなることがあるので注意してください。',
	'smw_exportrdf_backlinks' => 'エクスポートされたページを参照するすべてのページをさらにエクスポートする。閲覧が可能なRDFを生成します。',
	'smw_exportrdf_lastdate' => '指定した時点以降に変更がされていないページをエクスポートしない。',
	'smw_exportrdf_submit' => 'エクスポート',
	'properties' => 'プロパティ',
	'smw_properties_docu' => '以下のプロパティがこのウィキでは使われています。',
	'smw_property_template' => '$1: 型 $2 ($3件)',
	'smw_propertylackspage' => 'プロパティはすべて、専用のページで解説されるべきです！',
	'smw_propertylackstype' => 'このプロパティには型が指定されていません (現時点では型 $1 を仮定しています)。',
	'smw_propertyhardlyused' => 'このプロパティはウィキ内でほとんど使われていません！',
	'unusedproperties' => '使われていないプロパティ',
	'smw_unusedproperties_docu' => '以下のプロパティは存在しますが、他のページから利用されていません。',
	'smw_unusedproperty_template' => '$1: 型 $2',
	'wantedproperties' => '望まれているプロパティ',
	'smw_wantedproperties_docu' => '以下のプロパティはこのウィキ内で使われていますが、プロパティを解説するページがまだ存在しません。',
	'smw_wantedproperty_template' => '$1 ($2{{PLURAL:$2|件}})',
	'tooltip-purge' => 'ここをクリックして、このページ上のすべてのクエリーとテンプレートを最新の状態にします',
	'smw_purge' => '更新',
	'types' => '型',
	'smw_types_docu' => '以下はプロパティに割り当てられているすべてのデータ型の一覧です。各データ型は追加情報が載ったページをもっています。',
	'smw_typeunits' => '型「$1」の単位: $2',
	'semanticstatistics' => '意味的統計',
	'smw_semstats_text' => "このウィキには、計 '''$2'''種の[[Special:Properties|{{PLURAL:$2|プロパティ}}]]と '''$1'''個の{{PLURAL:$1|プロパティ値}}があります。'''$3'''個の{{PLURAL:$3|プロパティ}}には専用のページがあり、うち '''$4'''個にはデータ型が指定されています。既存のプロパティには[[Special:UnusedProperties|使われていないプロパティ]]があるかもしれません。解説ページがまだ存在しないプロパティは[[Special:WantedProperties|望まれているプロパティ一覧]]に載っています。",
	'uriresolver' => 'URIリゾルバー',
	'smw_uri_doc' => 'URIリゾルバーは <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG での httpRange-14 に関する議論成果</a>を実装しています。これは人間がウェブサイトに向かわないように取り計らいます。',
	'ask' => '意味的検索',
	'smw_ask_sortby' => '列ごとに整列 (任意選択)',
	'smw_ask_ascorder' => '昇順',
	'smw_ask_descorder' => '降順',
	'smw_ask_submit' => '結果を取得',
	'smw_ask_editquery' => '[クエリーを編集]',
	'smw_add_sortcondition' => '[整列条件を追加]',
	'smw_ask_hidequery' => 'クエリーを非表示',
	'smw_ask_help' => 'クエリーのヘルプ',
	'smw_ask_queryhead' => 'クエリー',
	'smw_ask_printhead' => '表示する追加データ',
	'smw_ask_printdesc' => '(プロパティー名を1行ごとに1つ追加してください)',
	'smw_ask_format_as' => 'フォーマット:',
	'smw_ask_defaultformat' => 'デフォルト',
	'smw_ask_otheroptions' => '他の選択肢',
	'smw_ask_show_embed' => '埋め込み用コードを表示',
	'smw_ask_hide_embed' => '埋め込み用コードを非表示',
	'smw_ask_embed_instr' => 'このクエリをウィキページにインラインで埋め込むには、下のコードを使います。',
	'searchbyproperty' => 'プロパティによる検索',
	'smw_sbv_docu' => '指定したプロパティと値をもつすべてのページを検索する。',
	'smw_sbv_novalue' => 'そのプロパティにとって有効な値を入力するか、「$1」のすべてのプロパティ値を確認してください。',
	'smw_sbv_displayresult' => 'プロパティ「$1」の値に「$2」をとっているすべてのページの一覧',
	'smw_sbv_displayresultfuzzy' => 'プロパティ「$1」の値に「$2」をとっているすべてのページの一覧。ほんのわずかの結果しかなかったため、近い値も表示しています。',
	'smw_sbv_property' => 'プロパティ:',
	'smw_sbv_value' => '値:',
	'smw_sbv_submit' => '結果を取得',
	'browse' => 'ウィキを閲覧',
	'smw_browselink' => 'プロパティを閲覧',
	'smw_browse_article' => '閲覧を開始するページの名前を入力してください。',
	'smw_browse_go' => '表示',
	'smw_browse_show_incoming' => 'ここにリンクしているプロパティを表示',
	'smw_browse_hide_incoming' => 'ここにリンクしているプロパティを非表示',
	'smw_browse_no_outgoing' => 'このページはプロパティをもっていません。',
	'smw_browse_no_incoming' => 'このページにリンクしているプロパティはありません。',
	'smw_inverse_label_default' => '$1である',
	'smw_inverse_label_property' => '逆プロパティの名前',
	'pageproperty' => 'ページプロパティの検索',
	'smw_pp_docu' => '指定されたページ上のプロパティのすべての値を検索します。ページとプロパティの両方を入力してください。',
	'smw_pp_from' => '対象ページ',
	'smw_pp_type' => 'プロパティ',
	'smw_pp_submit' => '結果を取得',
	'smw_result_prev' => '前',
	'smw_result_next' => '次',
	'smw_result_results' => '結果',
	'smw_result_noresults' => '該当結果はありません。',
	'smwadmin' => 'Semantic MediaWiki の管理機能',
	'smw_smwadmin_settingup' => 'Semantic MediaWiki のストレージ構築',
	'smw_smwadmin_setupsuccess' => 'ストレージエンジンの構築に成功しました。',
	'smw_smwadmin_return' => '$1 に戻る',
	'smw_smwadmin_updatestarted' => '意味的データを最新の状態とするための新しい更新プロセスが開始しました。格納済みのデータはすべて必要に応じて再構築または修復されます。この特別ページで更新の状況を追うことができます。',
	'smw_smwadmin_updatenotstarted' => 'すでに実行中の更新プロセスがあります。別のものを作成しないでください。',
	'smw_smwadmin_updatestopped' => '既存のすべての更新プロセスは停止されました。',
	'smw_smwadmin_updatenotstopped' => '実行中の更新プロセスを停止するには、本当に理解していることを示すためにチェックボックスを選択する必要があります。',
	'smw_smwadmin_docu' => 'この特別ページは <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a> のインストールとアップグレードを補助します。管理機能を実行する前に重要なデータをバックアップするようにしてください。',
	'smw_smwadmin_db' => 'データベースのインストールおよびアップグレード',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki は意味的データを格納するため、MediaWiki のデータベースに対していくつかの拡張を必要とします。以下の機能はあなたのデータベースが適切に構築されていることを確実にするものです。この作業でなされた変更は MediaWiki のデータベースのその他の部分には影響を与えず、必要なら簡単に取り消しができます。この機能は複数回実行したとしてもなんの害もありませんが、インストールもしくはアップグレード時に一度だけ実行すれば十分です。',
	'smw_smwadmin_permissionswarn' => 'SQLエラーを出して処理が失敗したとすると、それはおそらくあなたのウィキのデータベースユーザー(LocalSettings.php を確認してください)が必要な権限をもっていないためです。一時的に LocalSettings.php でデータベースのルートとしてログインして、そのユーザーにテーブルを作成および削除するための追加権限を与えるか、あるいは AdminSettings.php の設定情報を利用できるメンテナンススクリプト <tt>SMW_setup.php</tt> を使用してください。',
	'smw_smwadmin_dbbutton' => 'テーブルを初期化またはアップグレード',
	'smw_smwadmin_announce' => 'あなたのウィキの発表',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki には新しいセマンティック・ウィキのサイトを発表するためのウェブサービスがあります。
このサービスは Semantic MediaWiki を使用するサイト一覧を保守するために用いられており、主に <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki プロジェクト</a>が Semantic MediaWiki の典型的な使用法を把握するために利用されています。
Semantic MediaWiki のホームページで<a href="http://semantic-mediawiki.org/wiki/Registry">このサービスについてのさらなる情報</a>を確認してください。',
	'smw_smwadmin_announcebutton' => '次のボタンを押して、あなたのウィキのURLをこのサービスに提出します。このサービスは、公開されていないウィキは登録せず、公開されている情報のみを保管します。',
	'smw_smwadmin_datarefresh' => 'データの修復とアップグレード',
	'smw_smwadmin_datarefreshdocu' => 'ウィキの現在の内容に基づいて、Semantic MediaWiki の全データを復旧することができます。この機能は破損したデータを修復する場合や、ソフトウェアのアップグレードによって内部形式が変わった際にデータを移行する場合などに有用です。この更新は1ページずつ実行され、直ちには完了しません。以下では、更新が進行中か否かを示し、更新を開始または停止することができます (この機能がサイト管理者によって無効化されていない場合に限る)。',
	'smw_smwadmin_datarefreshprogress' => '<strong>更新が既に進行中です。</strong>
利用者がウィキにアクセスするたびに少量の塊のデータを更新するだけなので、更新がゆっくりとしか進まないのは正常なことです。
この更新をより速く終えたい場合は、MediaWiki のメンテナンススクリプト <tt>runJobs.php</tt> を起動できます (1つのバッチでなされる更新の数を制限するために <tt>--maxjobs 1000</tt> オプションを用いてください)。
現在の更新の推定進捗:',
	'smw_smwadmin_datarefreshbutton' => 'データの更新を開始',
	'smw_smwadmin_datarefreshstop' => 'この更新を停止',
	'smw_smwadmin_datarefreshstopconfirm' => 'はい、もちろんです。',
	'smw_smwadmin_support' => '支援を得る',
	'smw_smwadmin_supportdocu' => '問題が起きたときに種々のリソースが助けとなるかもしれません:',
	'smw_smwadmin_installfile' => 'インストールに問題を発見した場合、<a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL ファイル</a>にある指針を確認することから始めてください。',
	'smw_smwadmin_smwhomepage' => 'Semantic MediaWiki の完全な利用者用ドキュメントは <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b> にあります。',
	'smw_smwadmin_mediazilla' => 'バグは <a href="https://bugzilla.wikimedia.org/">Bugzilla</a> で報告できます。',
	'smw_smwadmin_questions' => 'さらなる質問や提案がある場合は、<a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki 利用者フォーラム</a>での議論に参加してください。',
	'smw_adminlinks_datastructure' => 'データ構造',
	'smw_adminlinks_displayingdata' => 'データ表示',
	'smw_adminlinks_inlinequerieshelp' => 'インラインクエリーのヘルプ',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 * @author Pras
 */
$messages['jv'] = array(
	'smw_edithelp' => 'Pitulung panyuntingan ing sifat-sifat',
	'smw_viewasrdf' => 'RDF feed',
	'smw_finallistconjunct' => ', lan',
	'smw_factbox_head' => 'Fakta-fakta ngenani $1',
	'smw_isspecprop' => 'Sifat iki iku sawijining sifat kusus ing wiki iki.',
	'smw_isknowntype' => 'Jenis iki kalebu jenis baku data ing wiki iki.',
	'smw_isaliastype' => 'Jenis iki sawijining alias kanggo jenis data “$1”.',
	'smw_isnotype' => 'Jenis “$1” iki dudu sawijining jenis data baku ing wiki, lan uga ora diwènèhi sawijining définisi déning sang panganggo.',
	'smw_baduri' => 'Nuwun sèwu, URI awujud “$1” ora diidinaké.',
	'smw_iq_disabled' => 'Nuwun sèwu. Kwéri sémantik kanggo wiki iki dipatèni.',
	'smw_iq_moreresults' => '… pituwas sabanjuré',
	'smw_iq_nojs' => 'Mangga nganggo sawijining panjlajah wèb JavaScript kanggo ndeleng unsur iki.',
	'smw_iq_altresults' => 'Sigra mirsani daftar pituwas.',
	'smw_unknown_importns' => 'Fungsi impor ora ana kanggo bilik nama “$1”.',
	'smw_nonright_importtype' => '$1 namung bisa dienggo ing kaca-kaca sajroning bilik nama “$2”.',
	'smw_wrong_importtype' => '$1 ora bisa dienggo ing kaca-kaca ing bilik nama “$2”.',
	'smw_no_importelement' => 'Unsur “$1” ora kasedyakaké kanggi diimpor.',
	'smw_parseerror' => 'Bijih sing diwènèhaké ora dimangertèni.',
	'smw_notitle' => '“$1” ora bisa dienggo minangka jeneng kaca ing wiki iki.',
	'smw_unknowntype' => 'Jenis “$1” sing ora disengkuyung, didéfinisi kanggo sifat.',
	'smw_manytypes' => 'Sifaté didéfinisi luwih saka sajenis.',
	'smw_emptystring' => 'Rangkéan kosong ora ditampa.',
	'smw_maxstring' => 'Répresèntasi string $1 kedawan.',
	'smw_notinenum' => '“$1” ora ana ing daftar bijih-bijih sing mungkin ($2) kanggo sifat iki.',
	'smw_noboolean' => '“$1” ora ditepungi minangka sawijining bijih Boolean (bener/salah).',
	'smw_true_words' => 'bener,t,ya,y',
	'smw_false_words' => 'salah,s,ora,o',
	'smw_nofloat' => '“$1” iku dudu angka.',
	'smw_infinite' => 'Angka sing gedhéné nganti "$1" ora didhukung.',
	'smw_infinite_unit' => 'Konvèrsi menyang unit "$1" ngasilaké angka sing kagedhèn.',
	'smw_unsupportedprefix' => 'Préfiks kanggo angka-angka (“$1”) ora disengkuyung.',
	'smw_unsupportedunit' => 'Konvèrsi unit kanggo unit “$1” ora disengkuyung.',
	'smw_nodatetime' => 'Tanggal “$1” ora dimangertèni.',
	'smw_toomanyclosing' => 'Katoné ana kakèhan “$1” sajroning kwéri.',
	'smw_noclosingbrackets' => 'Sawetara panrapan “<nowiki>[[</nowiki>” ing kwéri panjenengan ora ditutup déning “]]” sing cocog.',
	'smw_misplacedsymbol' => 'Simbul “$1” dienggo ing sawijining panggonan sing ora miguna.',
	'smw_unexpectedpart' => 'Bagéyan “$1” saka kwéri ora dimangertèni.
Pituwasé bisa-bisa ora kaya sing diarepaké.',
	'smw_emptysubquery' => 'Sawetara subkwéri ora nduwé kondisi absah.',
	'smw_misplacedsubquery' => 'Sawetara subkwéri dienggo ing panggonan sing ora diparengaké anané subkwéri.',
	'smw_valuesubquery' => 'Subkwéri ora disengkuyung kanggo bijih saka sifat “$1”.',
	'smw_overprintoutlimit' => 'Kwériné kakèhan ngandhut panyuwunan cithakan.',
	'smw_badprintout' => 'Sawetara déklarasi print sajroning kwéri formulasiné salah.',
	'smw_badtitle' => 'Nuwun sèwu, nanging "$1" iku dudu irah-irahan utawa judhul kaca sing absah.',
	'smw_badqueryatom' => 'Ora mudheng “<nowiki>[[…]]</nowiki>” sawetara bagéyan kwéri.',
	'smw_propvalueproblem' => 'Bijih sifat "$1" ora dimangertèni.',
	'smw_nodisjunctions' => 'Pamisahan ing kwéri ora disengkuyung ing wiki iki lan sabagéyan saka kwéri dadi dilirwakaké ($1).',
	'smw_querytoolarge' => 'Sarat kwéri sing kapacak ing ngisor iki ora bisa digalih amerga anané rèstriksi wiki ing ukuran utawa jeroné: $1.',
	'smw_devel_warning' => "Fitur iki saiki isih dikembangaké, lan mbok-menawa durung sakabèhé fungsional.
''Backup'' dhisik data panjenengan sadurungé nganggo fitur iki.",
	'smw_type_header' => 'Sifat-sifat saka jenis "$1"',
	'smw_typearticlecount' => 'Nuduhaké $1 {{PLURAL:$1|sifat|sifat}} nganggo jinis iki.',
	'smw_attribute_header' => 'Kaca-kaca sing nganggo sifat “$1”',
	'smw_attributearticlecount' => 'Nuduhaké $1 {{PLURAL:$1|kaca|kaca}} nganggo sifat iki.',
	'exportrdf' => 'Èkspor kaca-kaca menyang RDF',
	'smw_exportrdf_docu' => 'Kaca iki marengaké panjenengan kanggo olèh data saka sawijining kaca ing format RDF.
Kanggo ngèkspor kaca-kaca, mangga lebokna irah-irahan ing kothak tèks ing ngisor iki, sairah-irahan per baris.',
	'smw_exportrdf_recursive' => 'Ngèkspor kabèh kaca sing ana gandhèngané minangka rékursif.
Pènget: pituwasé bisa gedhé!',
	'smw_exportrdf_backlinks' => 'Uga ngèkspor kabèh kaca ing ngrujuk ing kaca-kaca sing dièkspor.
Nggawé berkas RDF sing bisa dijlajah.',
	'smw_exportrdf_lastdate' => 'Aja ngèkspor kaca-kaca sing ora diowahi wiwit sawijining wektu tartamtu.',
	'properties' => 'Sifat-sifat',
	'smw_properties_docu' => 'Sifat-sifat ing ngisori iki dienggo ing wiki iki.',
	'smw_property_template' => '$1 saka jenis $2 ($3)',
	'smw_propertylackspage' => 'Kabèh sifat kudu didèskripsi déning sawijining kaca!',
	'smw_propertylackstype' => 'Ora ana jenis sing dispésifikasi kanggo sifat iki (ngasumsi jenis $1 kanggo saiki).',
	'smw_propertyhardlyused' => 'Sifat iki mèh ora dienggo sajroning wiki iki!',
	'unusedproperties' => 'Sifat-sifat sing ora dienggo',
	'smw_unusedproperties_docu' => 'Sifat-sifat sing kapacak iki ana, senadyan ora ana kaca liya sing nganggo.',
	'smw_unusedproperty_template' => '$1 saka jenis $2',
	'wantedproperties' => 'Sifat sing dipéngini',
	'smw_wantedproperties_docu' => 'Sifat-sifat iki dienggo ing wiki, nanging durung duwé kaca sing ndéskripsi.',
	'smw_wantedproperty_template' => '$1 ({{PLURAL:$2|dianggo kaping|dianggo kaping }}$2)',
	'tooltip-purge' => 'Kliken ing kéné kanggo nganyari kabèh kwéri lan cithakan ing kaca iki',
	'smw_purge' => 'Anyarana',
	'types' => 'Jenis-jenis',
	'smw_types_docu' => 'Ing ngisor iki kapacak sawijining daftar kabèh jenis data sing bisa ditunjukaké menyang sifat-sifat.
Saben jenis data duwé kaca ing ngendi informasi tambahan bisa diwènèhaké.',
	'smw_typeunits' => 'Unit-unit pangukuran jenis “$1”: $2',
	'semanticstatistics' => 'Statistik sémantik',
	'smw_semstats_text' => "Wiki iki ngandhut '''$1''' {{PLURAL:$1|aji|aji}} sifat nganti gunggung '''$2''' [[Special:Properties|{{PLURAL:$2|sifat|sifat}}]].
'''$3''' {{PLURAL:$3|sifat nduwèni|sifat nduwèni}} kaca dhéwé, lan jinis-data sing dimaksudaké kanggo '''$4'''.
Sawetara sifat sing ana mbokmanawa [[Special:UnusedProperties|ora dipigunakaké]].
Sifat-sifat sing isih ora duwé kaca bisa ditemokaké ing [[Special:WantedProperties|dhaptar sifat-sifat sing dikarepaké]].",
	'uriresolver' => 'URI Resolver',
	'smw_uri_doc' => "''URI resolver''-é ngimplèmèntasi <a href=\"http://www.w3.org/2001/tag/issues.html#httpRange-14\">W3C TAG finding on httpRange-14</a>. Iku ngurusi supaya manungsa ora owah lan dadi situs-situs wèb.",
	'ask' => 'Panggolèkan sémantik',
	'smw_ask_sortby' => 'Sortir miturut kolom (opsional)',
	'smw_ask_ascorder' => 'Munggah saka ngisor menyang ndhuwur',
	'smw_ask_descorder' => 'Mudhun saka ndhuwur menyang ngisor',
	'smw_ask_submit' => 'Pituwas panggolèkan',
	'smw_ask_editquery' => '[Sunting kwéri]',
	'smw_add_sortcondition' => '[Tambah sarat nyortir]',
	'smw_ask_hidequery' => 'Delikna kwéri',
	'smw_ask_help' => 'Pitulung kwéri',
	'smw_ask_queryhead' => 'Kwéri',
	'smw_ask_printhead' => 'Cithakan tambahan (opsional)',
	'searchbyproperty' => 'Golèk miturut sifat',
	'smw_sbv_docu' => 'Golèk kabèh kaca sing duwé sifat lan bijih tartamtu.',
	'smw_sbv_novalue' => 'Mangga lebokna bijih absah kanggo sifat iki, utawa tuduhna kabèh bijih-bijihé sifat kanggo “$1.”',
	'smw_sbv_displayresult' => 'Sawijining daftar kabèh kaca sing duwé sifat “$1” mawa bijih “$2”',
	'smw_sbv_property' => 'Sifat/properti:',
	'smw_sbv_value' => 'Aji:',
	'smw_sbv_submit' => 'Golèk pituwas (kasil)',
	'browse' => 'Jlajaha wiki',
	'smw_browse_article' => 'Lebokna irah-irahan kaca sing arep didadèkaké kaca awal olèhé panjenengan njlajah-njlajah.',
	'smw_browse_go' => 'Tumuju',
	'pageproperty' => 'Panggolèkan sifat kaca',
	'smw_pp_docu' => 'Nggolèki kabèh pangisi sawijining sifat ing sawijining kaca.
Tulung isèkna loro-loroné sawijining kaca lan sifat.',
	'smw_pp_from' => 'Saka kaca',
	'smw_pp_type' => 'Sifat',
	'smw_pp_submit' => 'Pituwas panggolèkan',
	'smw_result_prev' => 'Sadurungé',
	'smw_result_next' => 'Sabanjuré',
	'smw_result_results' => 'Pituwas (kasil)',
	'smw_result_noresults' => 'Nuwun sèwu, ora ana pituwasé (kasilé).',
);

/** Georgian (ქართული)
 * @author Malafaya
 */
$messages['ka'] = array(
	'smw_finallistconjunct' => ', და',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Lovekhmer
 * @author Thearith
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'smw_finallistconjunct' => 'និង',
	'smw_factbox_head' => 'ហេតុការណ៍ពិត​អំពី $1',
	'smw_isspecprop' => 'លក្ខណៈសម្បត្តិ​នេះ គឺជា​លក្ខណៈសម្បត្តិ​ពិសេស​នៅក្នុង​វិគី​នេះ​។',
	'smw_baduri' => 'URIs នៃ​ទម្រង់ "$1" មិន​ត្រូវ​បាន​អនុញ្ញាត​ទេ​។',
	'smw_iq_moreresults' => '... លទ្ធផល​ខាងមុខ​ទៀត',
	'smw_iq_nojs' => 'ប្រើប្រាស់ JavaScript ដើម្បី​ឱ្យ​កម្មវិធីរុករក​មើល​ធាតុ​នេះ​បាន​។',
	'smw_iq_altresults' => 'រកមើល​លទ្ធផល​ពី​បញ្ជី​ដោយ​ផ្ទាល់​។',
	'smw_unknown_importns' => 'ការនាំចូល​អនុគមន៍ មិន​អាច​ប្រើប្រាស់​សម្រាប់​លំហឈ្មោះ "$1" ទេ​។',
	'smw_nonright_importtype' => '$1 អាច​ត្រូវ​បាន​ប្រើប្រាស់​សម្រាប់​ទំព័រ​ជាមួយ​លំហឈ្មោះ "$2"​។',
	'smw_wrong_importtype' => '$1 មិន​អាច​ត្រូវ​បាន​ប្រើប្រាស់​សម្រាប់​ទំព័រ​នៅក្នុង​លំហឈ្មោះ "$2" ទេ​។',
	'smw_no_importelement' => 'ធាតុ "$1" មិន​អាច​នាំចូល​បាន​ទេ​។',
	'smw_parseerror' => 'តម្លៃ​ដែល​បាន​ផ្ដល់ឱ្យ មិន​អាច​យល់​បាន​ទេ​។',
	'smw_notitle' => '"$1" មិន​អាច​ត្រូវ​បាន​ប្រើប្រាស់​ជា​ឈ្មោះ​ទំព័រ​នៅក្នុង​វិគី​នេះ​ទេ​។',
	'smw_wrong_namespace' => 'មានតែ​ទំព័រ​នៅ​ក្នុង​លំហឈ្មោះ "$1" ប៉ុណ្ណោះ ដែល​ត្រូវ​បាន​អនុញ្ញាត​នៅទីនេះ​។',
	'smw_noboolean' => '"$1" មិន​ត្រូវ​បាន​ទទួលស្គាល់​ជា​តម្លៃ​ប៊ូលីន (ត្រូវ/ខុស) ទេ​។',
	'smw_true_words' => 'ត្រូវ,ត,បាទ,ប',
	'smw_false_words' => 'ខុស,ខ,ទេ,ទ',
	'smw_nofloat' => '"$1" មិនមែន​ជា​លេខ​ទេ​។',
	'smw_nodatetime' => 'កាលបរិច្ឆេទ "$1" មិន​អាច​យល់​បាន​ទេ​។',
	'smw_toomanyclosing' => 'ហាក់ដូចជា មាន​​ការគាប់ជួន​ច្រើនពេក​នៃ "$1" នៅក្នុង​សំណួរ​របស់​អ្នក​។',
	'smw_noclosingbrackets' => 'ការប្រើប្រាស់​នៃ "<nowiki>[[</nowiki>" នៅក្នុង​សំណួរ​របស់​អ្នក​មិនត្រូវ​បាន​បិទ​ដោយ​សញ្ញា​ "]]" ជាគូ​។',
	'smw_misplacedsymbol' => 'និមិត្តសញ្ញា "$1" ត្រូវ​បាន​ប្រើ​ជំនួស​កន្លែង ដែល​មិន​ត្រូវ​បាន​ប្រើ​។',
	'smw_badtitle' => '"$1" មិន​មាន​ចំណងជើង​ទំព័រ​ត្រឹមត្រូវ​ទេ​។',
	'smw_propvalueproblem' => 'តម្លៃ​នៃ​លក្ខណៈសម្បត្តិ "$1" មិន​អាច​យល់​បាន​ទេ​។',
	'smw_notemplategiven' => 'ផ្ដល់​តម្លៃ​សម្រាប់​ប៉ារ៉ាម៉ែត្រ "ទំព័រគំរូ" សម្រាប់​ទ្រង់ទ្រង់​សំណួរ​នេះ​ដើម្បី​ធ្វើការ​។',
	'smw_type_header' => 'លក្ខណៈសម្បត្តិ​នៃ​គំរូ "$1"',
	'smw_typearticlecount' => 'បង្ហាញ $1 {{PLURAL:$1|លក្ខណៈសម្បត្តិ|លក្ខណៈសម្បត្តិ}} ដែល​កំពុង​ប្រើប្រាស់​គំរូនេះ​។',
	'smw_attribute_header' => 'ទំព័រ​ដែល​កំពុង​ប្រើប្រាស់​លក្ខណៈសម្បត្តិ "$1"',
	'smw_attributearticlecount' => 'បង្ហាញ $1 {{PLURAL:$1|ទំព័រ|ទំព័រ}} ដែល​កំពុង​ប្រើប្រាស់​លក្ខណៈសម្បត្តិ​នេះ​។',
	'smw_subproperty_header' => 'លក្ខណៈសម្បត្តិ​រង',
	'smw_subpropertyarticlecount' => 'លក្ខណៈសម្បត្តិ​នេះមាន $1 {{PLURAL:$1|លក្ខណៈសម្បត្តិ​រង|លក្ខណៈសម្បត្តិ​រង}}​ ដូចតទៅ៖',
	'exportrdf' => 'នាំចេញ​ទំព័រ​ទៅ RDF',
	'properties' => 'លក្ខណៈសម្បត្តិ',
	'smw_properties_docu' => 'លក្ខណៈសម្បត្តិ​ដូច​ខាងក្រោម​ត្រូវ​បាន​ប្រើប្រាស់​នៅ​ក្នុង​វិគី​។',
	'smw_property_template' => '$1 នៃ​គំរូ $2 ($3)',
	'smw_propertylackspage' => 'លក្ខណៈសម្បត្តិ​ទាំងអស់ គួរតែ​ត្រូវ​បាន​ពីពណ៌នា​ដោយ​ទំព័រ​មួយ​!',
	'smw_propertyhardlyused' => 'លក្ខណៈសម្បត្តិ ស្ទើរតែ​មិនត្រូវ​បាន​ប្រើប្រាស់​ជាមួយ​វិគី​!',
	'unusedproperties' => 'លក្ខណៈសម្បត្តិ​មិន​ប្រើប្រាស់',
	'smw_unusedproperty_template' => '$1 នៃ​គំរូ $2',
	'wantedproperties' => 'លក្ខណៈសម្បត្តិ​ដែល​ចង់បាន',
	'smw_wantedproperties_docu' => 'លក្ខណៈសម្បត្តិ​ដូចតទៅនេះ ត្រូវ​បាន​ប្រើប្រាស់​នោក្នុង​វិគី ប៉ុន្ដែ​នៅ​មិនទាំន់​មាន​ទំព័រ​ណាមួយ​សម្រាប់​ពិពណ៌នា​ពួកវា​ឡើយ​។',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|ប្រើប្រាស់|ប្រើប្រាស់}})',
	'smw_purge' => 'ធ្វើឱ្យស្រស់',
	'types' => 'ប្រភេទ',
	'semanticstatistics' => 'ស្ថិតិ​និឃណ្ដសាស្ត្រ',
	'uriresolver' => 'អ្នកដោះស្រាយ URI',
	'smw_ask_sortby' => 'តម្រៀប​តាម​ជួរឈរ (តាមបំណង)',
	'smw_ask_ascorder' => 'លំដាប់ឡើង',
	'smw_ask_descorder' => 'លំដាប់ចុះ',
	'smw_ask_submit' => 'ស្វែងរកលទ្ធផល',
	'searchbyproperty' => 'ស្វែងរក​តាម​រយៈ​លក្ខណៈសម្បត្តិ',
	'smw_sbv_docu' => 'ស្វែងរក​គ្រប់​ទំព័រ​ទាំងអស់ ដែល​ត្រូវ​បាន​ផ្ដល់​លក្ខណៈសម្បត្តិ និង​តម្លៃ​។',
	'smw_sbv_novalue' => 'បញ្ចូល​តម្លៃ​ត្រឹមត្រូវ​សម្រាប់​លក្ខណៈសម្បត្តិ ឬ​ក៏ មើល​គ្រប់​លក្ខណៈសម្បត្តិ​ទាំងអស់​សម្រាប់ "$1"​។',
	'smw_sbv_displayresult' => 'បញ្ជី​មួយ​នៃ​ទំព័រ​ទាំងអស់ ដែល​មានន​លក្ខណៈសម្បត្តិ "$1" ជាមួយ​តម្លៃ "$2"',
	'smw_sbv_displayresultfuzzy' => 'បញ្ជី​មួយ​នៃ​ទំព័រ​ទាំងអស់ ដែល​មានន​លក្ខណៈសម្បត្តិ "$1" ជាមួយ​តម្លៃ "$2"​។
ដោុហេតុតែ មាន​លទ្ធផល​តិចតួច​ប៉ុណ្ណោះ ក៏ប្រហាក់ប្រហែល​ជាមួយ​តម្លៃ​ដែល​ត្រូវ​បាន​បង្ហាញ​ផងដែរ​។',
	'smw_sbv_property' => 'លក្ខណៈសម្បត្តិ៖',
	'smw_sbv_value' => 'តំលៃលេខ៖',
	'smw_sbv_submit' => 'ស្វែងរក​លទ្ធផល',
	'browse' => 'រាវរកវិគី',
	'smw_browselink' => 'រកមើល​លក្ខណៈសម្បត្តិ',
	'smw_browse_article' => 'សូម​បញ្ចូល​ឈ្មោះ​នៃ​ទំព័រ ដើម្បី​ចាប់ផ្ដើម​រុករក​ពី​។',
	'smw_browse_go' => 'ទៅ',
	'smw_browse_show_incoming' => 'បង្ហាញ​លក្ខណៈសម្បត្តិ ដែល​មាន​តំណភ្ជាប់​នៅទីនេះ​។',
	'smw_browse_hide_incoming' => 'លាក់​លក្ខណៈសម្បត្តិ ដែល​មាន​តំណភ្ជាប់​នៅទីនេះ​។',
	'smw_browse_no_outgoing' => 'ទំព័រ​នេះ​មិនមាន​លក្ខណៈសម្បត្តិ​ទេ​។',
	'smw_browse_no_incoming' => 'គ្មាន​លក្ខណៈសម្បត្តិ ដែល​ភ្ជាប់ទៅ​ទំព័រ​នេះ​ទេ​។',
	'smw_inverse_label_default' => '$1 នៃ',
	'pageproperty' => 'ស្វែងរក​លក្ខណៈសម្បត្តិ​ទំព័រ',
	'smw_pp_from' => 'ពីទំព័រ',
	'smw_pp_type' => 'លក្ខណៈសម្បត្តិ',
	'smw_pp_submit' => 'ស្វែងរកលទ្ធផល',
	'smw_result_prev' => 'មុន',
	'smw_result_next' => 'បន្ទាប់',
	'smw_result_results' => 'លទ្ធផល',
	'smw_result_noresults' => 'សូមអភ័យទោស! មិនមានលទ្ធផលទេ។',
	'smw_smwadmin_return' => 'ត្រឡប់​ទៅកាន់ $1',
	'smw_smwadmin_db' => 'ការដំឡើង និង​ធ្វើឱ្យប្រសើរ​នូវ​មូលដ្ឋានទិន្នន័យ',
	'smw_smwadmin_announce' => 'ន្រកាស​វិគី​របស់​អ្នក',
	'smw_smwadmin_datarefresh' => 'ជួសជុល និង​ធ្វើឱ្យ​ប្រសើរ​នូវ​ទិន្នន័យ',
	'smw_smwadmin_datarefreshbutton' => 'ចាប់ផ្ដើម​បន្ទាន់សម័យ​ទិន្នន័យ',
	'smw_smwadmin_datarefreshstop' => 'បញ្ឈប់​ការ​បន្ទាន់សម័យ​នេះ',
	'smw_smwadmin_datarefreshstopconfirm' => 'បាទ/ចាស, ខ្ញុំ​ប្រាកដ​ហើយ​។',
);

/** Kannada (ಕನ್ನಡ)
 * @author Nayvik
 */
$messages['kn'] = array(
	'smw_finallistconjunct' => ', ಮತ್ತು',
	'smw_browse_go' => 'ಹೋಗು',
);

/** Korean (한국어)
 * @author Albamhandae
 * @author Kwj2772
 */
$messages['ko'] = array(
	'smw_edithelp' => '도움말을 수정하려면 속성을',
	'smw_viewasrdf' => 'RDF 피드',
	'smw_factbox_head' => '$1에 대한 사실',
	'smw_isspecprop' => '이 속성은 이 위키의 특별한 속성입니다.',
	'smw_isaliastype' => '이 유형은 데이터의 별칭을 “$1”.',
	'smw_baduri' => '죄송합니다, uri의 범위에서 “$1” 해당 장소에서 사용할 수 없다.',
	'smw_no_importelement' => '원소 “$1” 에 사용할 수없습니다 져올.',
	'smw_unknowntype' => '지원되지 않는 종류 “$1” 정의에 대한 속성을.',
	'smw_maxstring' => '문자열 표현 $1 이 너무 긴이 사이트에 대한.',
	'smw_infinite' => '숫자와 대형으로 “$1” 는 지원되지 않습니다이 사이트에서.',
	'smw_infinite_unit' => '전환으로 단위를 “$1” 결과는이 사이트에 대한 숫자가 너무 큽니다.',
	'smw_unsupportedprefix' => '접두사에 대한 숫자("$1")는 지원되지 않습니다.',
	'smw_nodatetime' => '의 날짜 “$1” 는 이해할 수 없다.',
	'smw_badprintout' => '검색어에 인쇄 성명 커보였다.',
	'smw_typearticlecount' => '이 유형을 사용하여 보여주 $1 의 등록 정보를합니다.',
	'smw_attributearticlecount' => '이 속성을 사용하여 보여주 $1 페이지입니다.',
	'exportrdf' => 'RDF로 문서 내보내기',
	'smw_pp_type' => '부동산',
);

/** Krio (Krio)
 * @author Jose77
 */
$messages['kri'] = array(
	'smw_browse_go' => 'Go to am',
);

/** Kinaray-a (Kinaray-a)
 * @author Jose77
 */
$messages['krj'] = array(
	'smw_browse_go' => 'Agto',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'smw-desc' => 'Määt Ding Wiki besser ze bruche - för Minsche un Maschiene. ([http://semantic-mediawiki.org/wiki/Help:User_manual Handbooch])',
	'smw_edithelp' => 'Hölp beim Ändere vun Eijeschaffte',
	'smw_viewasrdf' => 'RDF Kannaal',
	'smw_finallistconjunct' => ', un',
	'smw_factbox_head' => 'Tatsaache övver $1',
	'smw_isspecprop' => 'Die Eijeschaff es en spezijelle Eijeschaff en hee dämm Wiki.',
	'smw_isknowntype' => 'Dä Datetüp es ein vun de standattmääßejje Datetüpe en hee däm Wiki.',
	'smw_isaliastype' => 'Hee dä Datetüp es ene andere Name för dä Datetüp „$1“.',
	'smw_isnotype' => 'Dä Datetüp „$1“ es keine vun dä standattmääßejje Datetüpe en hee däm Wiki, un hä hät och kein öönlijje Deffinizjuhn krääje.',
	'smw_concept_description' => 'Beschrievong för et Kunzäp: „$1“',
	'smw_no_concept_namespace' => 'Kunzäpter kam_mer bloß em {{ns:concept}}-Appachtemang faßlääje.',
	'smw_multiple_concepts' => 'Op jeede {{ns:concept}}-Sigg kann bloß ei Kunzäp faßjelaat wääde.',
	'smw_concept_cache_miss' => 'Dat Kunzap „$1“ kann för der Momang noch nit jebruch wääde.
Dem Wiki sing Kumfijurazjuhn fordert, dat dat offline ußjeräshent weed.
Wann dat nit noh en jeweße Zick nit fun sellfs jedonn es, un hee di
Aanforderung dorschjeiht, dann froch Dinge Wiki-Köbes donoh, noh dämm Kunzäp.',
	'smw_noinvannot' => 'För Eijeschaffte met ömjedriehte Reschtung künne kei Wääte verjovve wääde.',
	'smw_baduri' => 'URIs met dämm Opbou „$1“ sin nit zojelohße.',
	'smw_rss_link' => '<i lang="en">RSS</i>',
	'smw_csv_link' => '<i lang="en">CSV</i>',
	'smw_printername_auto' => 'Automattesch',
	'smw_printername_count' => 'Zälle, wat erus kütt',
	'smw_printername_csv' => 'Expoot em <i lang="en">CSV</i>-Fommaat',
	'smw_printername_debug' => 'En dä Frooch noh Fählere söhke (joot för de Expächte)',
	'smw_printername_embedded' => 'Sigge-Enhallt enföhje',
	'smw_printername_json' => 'Expoot em <i lang="en">JSON</i>-Fommaat',
	'smw_printername_list' => 'Leß',
	'smw_printername_ol' => 'Opzälle',
	'smw_printername_ul' => 'Einzel met Einzelheite opföhre',
	'smw_printername_rss' => 'Expoot em <i lang="en">RSS</i>-Fommaat',
	'smw_printername_table' => 'Tabäll',
	'smw_printername_broadtable' => 'En breed Tabäll',
	'smw_printername_template' => 'Schabloon',
	'smw_paramdesc_limit' => 'De hühßte Aanzahl vun Äjeebnesse för zeröck ze jävve',
	'smw_paramdesc_headers' => 'Donn de Name vun de Köpp oder Eijeschaffte aanzeije',
	'smw_paramdesc_mainlabel' => 'Wi dä <code>mainlabel</code> Parrameeter för inlain Affroore beschrevve weed',
	'smw_paramdesc_link' => 'Donn de Wääte als Lengks aanzeije',
	'smw_paramdesc_intro' => 'Wat för ene Täx aanjezeijsch wääde sull, für dämm, wat jefonge woodt',
	'smw_paramdesc_outro' => 'Wat för ene Täx aanjezeijsch wääde sull, noh dämm, wat jefonge woodt',
	'smw_paramdesc_default' => 'Wat för ene Täx aanjezeijsch wääde sull, wann nix jefonge woodt',
	'smw_paramdesc_searchlabel' => 'Dä Täx för em Lengk för wat eruß kütt',
	'smw_paramdesc_sep' => 'Wat zwesche de Wääte schtonn sull',
	'smw_paramdesc_template' => 'Dä Name vun ene Schabloon, för de Ußjabe met aanzzeije',
	'smw_paramdesc_columns' => 'De Aanzahl Schpallde för aanzezije, wad eruß kütt — der Schtandatt wöhr $1',
	'smw_paramdesc_embedformat' => 'De <i lang="en">html</i>-Befähle för de Övverschreffte ze makeere',
	'smw_paramdesc_embedonly' => 'Kein Övverschreffte aanzeije',
	'smw_paramdesc_rsstitle' => 'Dä Täx met dämm dä Kannaal beschrevve wääde sull',
	'smw_paramdesc_rssdescription' => 'Dä Täx met dämm dä Kannaal beschrevve wääde sull',
	'smw_iq_disabled' => 'Semantesche Frore sem em Wiki em Momang afjeschaldt.',
	'smw_iq_moreresults' => '…&nbsp;mieh vun däm, wat jefonge woodt',
	'smw_iq_nojs' => 'Dat Denge hee kanns De met enen Brauser, dä JavaScrip kann, beloore.',
	'smw_iq_altresults' => 'Direk en de Leß bläddere.',
	'smw_unknown_importns' => 'Mer künne nix en dat Appachtemang „$1“ empoteere.',
	'smw_nonright_importtype' => '$1 künne mer bloß för Sigge en däm Appachtemang „$2“ bruche.',
	'smw_wrong_importtype' => 'Dat Ellement „$1“ künne mer nit för Sigge en däm Appachtemang „$2“ bruche.',
	'smw_no_importelement' => 'Dat Ellement „$1“ künne mer nit empoteere.',
	'smw_parseerror' => 'Dä aanjejovve Wäät kunnte mer nit vershtonn.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '&nbsp;',
	'smw_notitle' => '„$1“ kam_mer en hee däm Wiki nit als ene Siggename bruche.',
	'smw_wrong_namespace' => 'Bloß Sigge uß däm Appachtemang „$1“ sin hee zohjelohße.',
	'smw_unknowntype' => 'De Zoot „$1“ för de Eijeschaff dom_mer nit ongershtöze.',
	'smw_manytypes' => 'Di Eijeschaff es en mieh wi ein Zoot dren.',
	'smw_emptystring' => 'De jonn kei Reihe uß Boochstabe un Zeishe, woh nit ens ei dofun dren shteiht. Alsu nit leddesch lohße.',
	'smw_maxstring' => '„$1“ es zoh lang, en Boochshtabe ußjedröck.',
	'smw_notinenum' => '„$1“ es nit bei dä zohjeloße Wääte för di Eijeschaff, dat wöhre: $2',
	'smw_noboolean' => '„$1“ es keine vun dä Wääte för „wohr“ un „verkeeht“.',
	'smw_true_words' => 'wohr,wor,woo,woh,wo,w,j,jo,joh,true,t,yes,y',
	'smw_false_words' => 'verkiehrt,verkihrt,verkirt,verkeht,verkeet,verket,vokiehrt,vokihrt,vokirt,vokeht,vokeet,voket,ferkiehrt,ferkihrt,ferkirt,ferkeht,ferkeet,ferket,fokiehrt,fokihrt,fokirt,fokeht,fokeet,foket,fallsch,falsch,näh,nää,nä,false,f,no,n',
	'smw_nofloat' => '„$1“ es kei Zahl.',
	'smw_infinite' => 'Zahle esu jruuß udder esu lang wi „$1“ dom_mer hee nit ongershtöze.',
	'smw_infinite_unit' => 'Dat Ömräschne in de Einheit $1 es nit müjjelesch — di Zahl eß zo lang doför.',
	'smw_unsupportedprefix' => 'Vörsätz för Zahle („$1“) dom_mer nit ongershtöze.',
	'smw_unsupportedunit' => 'Et Ömrechne weed för de Einheit „$1“ nit müjjelesch sin.',
	'smw_nodatetime' => 'Dat Dattum „$1“ künne mer nit vershtonn.',
	'smw_toomanyclosing' => 'En dä Frooch es zoh öff „$1“ enthallde.',
	'smw_noclosingbrackets' => 'En <code><nowiki>[[</nowiki></code> en Dinge Frooch woh nit zohjemaat, un hät kei <code>]]</code> wat drop paßße deiht.',
	'smw_misplacedsymbol' => 'Dat Sümbohl „$1“ wohr aan ene Shtell, woh et nix nöz.',
	'smw_unexpectedpart' => 'Dä Aandeil „$1“ en dä Frooch kunnte mer nit vershtonn. Wat eruß kütt, künnt jet angersch sin, wi jedaach.',
	'smw_emptysubquery' => 'En Ongerfrooch hät kein reschtejje Bedengung.',
	'smw_misplacedsubquery' => 'En Ongerfrooch douch aan ene Shtäll op, woh kei Ongerfroore sin dörve.',
	'smw_valuesubquery' => 'En Ongerfrooch noh de Wääte fun dä Eijeschaff „$1“ künne mer nit.',
	'smw_overprintoutlimit' => 'En dä Frooch sull zoh vill, udder zoh öff jet, ußjejovve wäde. Dat jeiht nit. Dat künne mer nit.',
	'smw_badprintout' => 'Ene Befähl för jet ußzejävve wohr en dä Frooch esu nit en Oodenung,',
	'smw_badtitle' => '„$1“ es keine jöltejje Tittel för en Sigk.',
	'smw_badqueryatom' => 'Ene Aandeil „<nowiki>[[…]]</nowiki>“ en dä Anfrooch es nit ze vershtonn.',
	'smw_propvalueproblem' => 'Dä Eijeschaff „$1“ ier Wäät es nit ze vershtonn.',
	'smw_noqueryfeature' => 'Ene Deijl vun dä Aanfrooch iere Eijeschaffte sin hee en dämm Wiki nit
müjjelesch, un dä Aandeil ($1) es dröm us dä Frooch eruß jenumme woode.',
	'smw_noconjunctions' => 'Konjunxjohne (e „un“ en Aanfroore) sin hee en dämm Wiki nit müjjelesch, un dä Aandeil ($1) es dröm us dä Frooch eruß jenumme woode.',
	'smw_nodisjunctions' => 'Dißjunxjohne (e „of“ un „odder“ en Aanfroore) sin hee en dämm Wiki nit müjjelesch, un dä Aandeil ($1) es dröm us dä Frooch eruß jenumme woode.',
	'smw_querytoolarge' => 'De Bedengunge hee noh kunnte mer nit mieh beärbeide, weil dem Wiki sing Jrenze för der Ömfang udder de Aanzahl Verschachtelunge vun Datebangk_Froore övverschredde wohre: $1.',
	'smw_devel_warning' => 'Dat hee es em Momang en de Äntweckung, et künnt sinn, dat dat nit janz flupp. Donn Ding Daate seschere, iih, dat De et probeeß.',
	'smw_notemplategiven' => 'Jiv ene Wäät för dä Parrammeeter „Schabloon“ aan, domet di Aat Frooch jonn kann.',
	'smw_type_header' => 'Eijeschaffte vun dä Aat „$1“',
	'smw_typearticlecount' => 'Mer zeije {{PLURAL:$1|Ein Eijeschaff|$1 Eijeschaffte|kei Eijeschaff}} met dämm Datentüp aan:',
	'smw_attribute_header' => 'Sigge met dä Eijeschaff „$1“',
	'smw_attributearticlecount' => '{{PLURAL:$1|Hee kütt ein Sigg|Hee kumme $1 Sigge|Et jitt kei Sigge}} met dä Eijeschaff dren{{PLURAL:$1|:|:|.}}',
	'smw_subproperty_header' => 'Unger-Eijeschaffte',
	'smw_subpropertyarticlecount' => 'Di Eijeschaff hät {{PLURAL:$1|ein Onger-Eijeschaff:|$1 Onger-Eijeschaffte:|kein Onger-Eijeschaff.}}',
	'smw_concept_header' => 'Sigge vun däm Kumzäp „$1“',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Ein Sigg jehööt|$1 Sigge jehüüre|Et jehüüere kein Sigge}} zoh dämm Kumzäp{{PLURAL:$1|:|:|.}}',
	'smw_rss_description' => '<i lang="en">RSS</i> Kanaal $1',
	'specialpages-group-smw_group' => 'Semantesch MediaWiki',
	'exportrdf' => 'Sigge em Fommaat RDF expoteere',
	'smw_exportrdf_docu' => 'Hee di Sigg määd et müjjelesch, Daate vun en Sigg em <i lang="en">RDF</i>-Fommaat ze krijje. Öm Sigge ze Expoteere, doon dänne ier Tittele, jeeder_ein en en Reih fö sesch, onge en dat Täx-Feld erin schriive.',
	'smw_exportrdf_recursive' => 'Donn all de Sigge expotteere, di domet zosamme hange, un di domet och, un esu wigger. Opjepaß, dat künnt reschtesch vill wääde!',
	'smw_exportrdf_backlinks' => 'Donn och all de Sigge expoteere, di op expoteete Sigge verwiese donn, un maach en <i lang="en">RDF</i> Dattei, woh me dren bläddere udder mem Brauser draan jonn kann.',
	'smw_exportrdf_lastdate' => 'Donn kein Sigge expoteere, di noh däm aanjejovve Dattum un dä aanjejovve Uhrzick nimmieh verändert woodte.',
	'smw_exportrdf_submit' => 'Loß Jonn!',
	'properties' => 'Eijeschaffte',
	'smw_properties_docu' => 'Hee di Eijeschaffte wäde em Wiki jebruch:',
	'smw_property_template' => '$1 fun dä Zoot $2 ({{PLURAL:$3|ei|$3|kei}} mol)',
	'smw_propertylackspage' => 'Alle Eijeschaffte sullte op en Sigg beschrevve sin!',
	'smw_propertylackstype' => 'För die Eijeschaff es bes jetz kei Date-Aat aanjejovve, mer nämme för der Momang ens „$1“.',
	'smw_propertyhardlyused' => 'Die Eijeschaff weed em Wiki koum jebruch!',
	'unusedproperties' => 'Eijeschaffte, die nit jebruch wääde',
	'smw_unusedproperties_docu' => 'Hee die Eijeschaffte jidd_et un han Sigge, ävver de Eijeschaffte sellver wääde em Momang nörjenswoh jebruch.',
	'smw_unusedproperty_template' => '$1 vun de Aat $2',
	'wantedproperties' => 'Nit aanjelaate Eijeschaffte',
	'smw_wantedproperties_docu' => 'De Eijeschaffte hee noh wäde em Wiki jebruch, ävver se han noch kei Sigg, die se beschrief, un äkliere deiht.',
	'smw_wantedproperty_template' => '$1 ({{PLURAL:$2|eimol|$2 mol|nit}} jebruch)',
	'tooltip-purge' => 'Fonn hee klicke, öm all de Schabloone un semantesche Leste un Affroore en dä Sigg op der neuste Shtand ze bränge.',
	'smw_purge' => 'Nöü Aanzeije',
	'types' => 'Date-Tüpe',
	'smw_types_docu' => 'Hee kütt en Leß met alle Datte-Tüpe, die en Eijeschaff hann künnt.
Jede Tüp hät en eije Sigg, woh mer zosäzlesch Enfommazjuhne enndraare kann.',
	'smw_typeunits' => 'De Mooßeinheit för dä Datte-Tüp „$1“ es: $2',
	'semanticstatistics' => 'Shtatistik övver de semantesche Date',
	'smw_semstats_text' => "Dat Wiki hät {{PLURAL:$1|'''eine''' Wäät|'''$1''' Wääte|'''nit eine''' Wäät}} för ensjesamp '''{{PLURAL:$2|ein|$2|keine}}''' ongerscheedlijje [[Special:Properties|{{PLURAL:$2|Eijeschaff|Eijeschaffte|Eijeschaff}}]].
{{PLURAL:$3|'''Ein''' Eijeschaff hät|'''$3''' Eijeschaffte han|'''Kein''' Eijeschaff hät}} en eije Sigg, un en Zoot (dä Datetyp) es för '''{{PLURAL:$4|eine|$4|keine}}'''  dovun aanjejovve. Et künne och [[Special:UnusedProperties|{{lcfirst:{{#special:UnusedProperties}}}}]] dronger sinn. Eijeschaffte ohne eije Sigg sin op dä Sigg met de [[Special:WantedProperties|{{lcfirst:{{#special:WantedProperties}}}}]] opjeleß.",
	'uriresolver' => 'Oplööser för <i lang="en">URIs</i>',
	'smw_uri_doc' => 'Dä <i lang="en">URI resolver</i> hät dä Vörschlaach <<i lang="en">a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a></i> opjenumme
(-: un sorresch esu doför, dat uß Minsche kei Websigge wääde :-)',
	'ask' => 'Semantesch Söke',
	'smw_ask_sortby' => 'Noh de Spallde zotteere (moß ävver nit)',
	'smw_ask_ascorder' => 'Nomaal eröm zotteere',
	'smw_ask_descorder' => 'Röckwääts zotteere',
	'smw_ask_submit' => 'Lohß Jonn!',
	'smw_ask_editquery' => '[Opdraach ändere]',
	'smw_add_sortcondition' => '[Zoteere dobeidonn]',
	'smw_ask_hidequery' => 'Opdrach nit aanzeije',
	'smw_ask_help' => 'Hölp',
	'smw_ask_queryhead' => 'Froore',
	'smw_ask_printhead' => 'Zosäzlijje Ußdröcker för aanzezeije',
	'smw_ask_printdesc' => '(Donn jeede Eijeschaff op ein Reih för sesch enjävve)',
	'smw_ask_format_as' => 'Fommatteere als:',
	'smw_ask_defaultformat' => 'Shtandadt-Fommaat',
	'smw_ask_otheroptions' => 'Ander Ußwahle',
	'smw_ask_show_embed' => 'Donn dä Wiki_Kood zom ennfööje aanzeije',
	'smw_ask_hide_embed' => 'Donn dä Wiki_Kood zom Ennfööje vershteishe',
	'smw_ask_embed_instr' => 'Öm di Frooch en en Sigg em Wiki enzeboue, donn dä Wiki_Koode hee dronger en di Sigg enfööje.',
	'searchbyproperty' => 'Övver de Eijeschaffte söke',
	'smw_sbv_docu' => 'Donn noh all dä Sigge söhke, die beshtemmpte Eijeschaff han, un medd_ennem beshtemmpte Wäät för se.',
	'smw_sbv_novalue' => 'Donn ene jöltijje Wäät för di Eijeschaff aanjevve, udder donn Der all de müjjelesche Wääte för „$1“ aanlooere.',
	'smw_sbv_displayresult' => 'Leß met alle Sigge met dä Eijeschaff „$1“, die do dä Wäät „$2“ hät.',
	'smw_sbv_displayresultfuzzy' => 'Leß met alle Sigge met dä Eijeschaff „$1“, die do dä Wäät „$2“ hät.<br />
(Weil nur winnisch dovun do sin, dom_mer de ähnlesche Wääte metzeije)',
	'smw_sbv_property' => 'Eijeschaff:',
	'smw_sbv_value' => 'Wäät:',
	'smw_sbv_submit' => 'Lohß Jonn!',
	'browse' => 'Em Wiki bläddere',
	'smw_browselink' => 'Eijeschaffte aanzeije',
	'smw_browse_article' => 'Beß esu joot, un jif dä Tittel vun dä Sigg aan, wo De met däm Bläddere aanfange wells.',
	'smw_browse_go' => 'Loß Jonn!',
	'smw_browse_more' => '&nbsp;…',
	'smw_browse_show_incoming' => 'donn de Eijeschaffte aanzeije, di ene Lengk noh hee han',
	'smw_browse_hide_incoming' => 'donn de Eijeschaffte vershteishe, di ene Lengk noh hee han',
	'smw_browse_no_outgoing' => 'Die Sigg hee hät kei Eijeschaffte.',
	'smw_browse_no_incoming' => 'Mer han kein Eijeschaffte em Wiki, di ene Lengk noh hee han.',
	'smw_inverse_label_default' => '$1 vun',
	'smw_inverse_label_property' => 'Dä Name för di Eijeschaff, wann dä ier Reschtung ömjedrieht weed',
	'pageproperty' => 'Söke noh Eijeschaffte vun Sigge',
	'smw_pp_docu' => 'Söhk noh all dä Wääte, di en beshtemmpte Eijeschaff en dä aanjejovve Sigg hät. Donn sowohl en Sigg aanjevve als och en Eijeschaff.',
	'smw_pp_from' => 'Vun Sigg',
	'smw_pp_type' => 'Eijeschaff',
	'smw_pp_submit' => 'Lohß Jonn!',
	'smw_result_prev' => 'Vörijje',
	'smw_result_next' => 'Wigger',
	'smw_result_results' => 'Erus jekumme',
	'smw_result_noresults' => 'Nix jefonge.',
	'smwadmin' => 'Verwalldung fun <i lang="en">Semantic MediaWiki</i>',
	'smw_smwadmin_settingup' => 'Shpeisherplaz opsetze för <i lang="en">Semantic MediaWiki</i>.',
	'smw_smwadmin_setupsuccess' => 'Dä Shpeisherplaz es opjesaz för <i lang="en">Semantic MediaWiki</i>.',
	'smw_smwadmin_return' => 'Jangk retuur noh $1',
	'smw_smwadmin_updatestarted' => 'Ene Projrammlouf för de semantesche Date neu opzeboue es em Jang. All de jeshpeisherte Date wäde neu zosamme jebout un woh nüdesch repareet. Mer kann bei däm Louf hee op dä Söndersigg metloore.',
	'smw_smwadmin_updatenotstarted' => 'Et es ald e Projramm för dat op der neuste Shtand ze bränge aam Loufe.
Mer donn jetz nit noch ein aanshtüße!',
	'smw_smwadmin_updatestopped' => 'Alle Projramme för et op der neuste Shtand Bränge, sin jetz aanjehallde woode.',
	'smw_smwadmin_updatenotstopped' => 'Öm dat Projramm anzehallde, wat ald am Loufe es, moß De dat Höcksche en dat Käßje maache, öm ze zeije, dat De Der janz sesher bes.',
	'smw_smwadmin_docu' => 'Hee di Söndersigg hellef beim Enshtallerere un beim op der neue Shtand bränge vum <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>. Opjepaß: Donn Ding Date seschere, ih dat De di Funkßjohne aanschmiiße deihß!',
	'smw_smwadmin_db' => 'Datebangk inshtalleere un op der neuste Shatnd bränge',
	'smw_smwadmin_dbdocu' => 'Semantesch MediaWiki hät bruch eije zosätzlejje Plaz en de Datebangk vum MediaWiki, öm sing semantesche Date ongerzebrenge. De Funkßjuhne hee dronger sorje doför, dat de Datebangk em Wiki öhndlesch för Semantesch MediaWiki opjesaz es. Wat hee verändert weet, dathät keine Enfloß op dä Rääß vun dä Datebangk vum MediaWiki, un mer kann et och eifach widder retuur maache, wann mer well. Di Funkßjuhn zom Opseze kam_mer esu öff loufe lohße, wi mer well, dat schaadt nix, ävver et es bloß eijmohl nüdesch bemm Enreschte, udder bem Ömshteije op en neuere Projrammversion.',
	'smw_smwadmin_permissionswarn' => 'Wann de Aufjab met enem Fähler em <i lang="en">SQL</i> donävve jeiht, dann künnd et sin, dat dä Name för op de Datebangk zohzejriife en de <code>LocalSettings.php</code> för Ding Wiki nit jenooch Rääschte en dä Datebangk hät. Entweder jiß De dämm dat Rääsch, Tabälle aanzelääje udder fott ze maache, udder donn för der Momang Dinge <i lang="en">English text sample</i> udder Datebank-Köbes en dä <code>tings.php </code> enndraare, udder nemm dat Waadungsprojramm <code>SMW_setup.php</code> wat sesch op de Aanjabe en <code>AdminSettings.php</code> betrecke kann.',
	'smw_smwadmin_dbbutton' => 'Tabelle aanlääje udder op der neuste Shatnd bränge',
	'smw_smwadmin_announce' => 'Donn Ding Wiki annongßeere un bikannt maache',
	'smw_smwadmin_announcedocu' => 'Semantesch MediaWiki hät en Websigg för neu Semantsche MediaWiki ßaits aanzeköndijje. Doh weed en Leß met de öffentlesche Websaits jehallde, en de Houpsaach, öm dämm <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantesch MediaWiki Projäk</a> zoh enem Övverbleck ze verhellve, wi Semantesch MediaWiki esu enjesaz weed. Op dä Houpäjtsch fun dämm Projäk fengks De <a href="http://semantic-mediawiki.org/wiki/Registry">mieh övver dä Deens</a>.',
	'smw_smwadmin_announcebutton' => 'Met dämm Knopp hee deihs De Dingem Wiki sing <i lang="en">URL</i> aan dä Deens schecke. Dä deiht bloß öffentlesch oproofbaare Wikis opnämme, un bloß öffentlesch oproofbaare Enfomazjuhne övvernämme.',
	'smw_smwadmin_datarefresh' => 'Date repareere un op der neuste Shtand bränge',
	'smw_smwadmin_datarefreshdocu' => 'Et es müjjelesch, all Date vun Semantesch MediaWiki uß dä nommaale Date em Wiki widder neu zesamme ze krijje. Dat kann joot sin, öm kapodde Date ze repareere, udder de Date op der aktoälle Shtand ze bränge, nohdämm sesh jet draan jeändert hät, dorjen Änderung aan de Projramme. De Aanpassung weed Sigg för Sigg jedonn un weed dröm nit paaftisch fäädesch weede. Heenoh kanns De sin, ov en Aanpassung em Jang es, un Do kanns ein aanfange udder aanhallde, ußer wann ene Wiki_Köbes di Müjjeleschkeit ußjeschalldt hät.',
	'smw_smwadmin_datarefreshprogress' => '<strong>En XXXXXXX es ald ungerwähß.</strong> Es es nomaal för ene XXXXXXXXX dat dat langsam föran jeiht, weil dobei de Date nur en klein Häppsche jeändert wääde, un nur dann, wann eine dat wiki bruch. Öm flöcker fäädesch ze wäde, kanns de dat Waadungs-Projramm <code>runJobs.php</code> vun MediaWiki aanschmiiße. Nemm dä Parrameeter <code>--maxjobs 1000</code> öm dä XXXXXXXXXX en jedem Rötsch faß_ze_lääje. Mer sen onjefähr esu wick:',
	'smw_smwadmin_datarefreshbutton' => 'Aanfange met de Date op der neue Shtand ze brenge',
	'smw_smwadmin_datarefreshstop' => 'Donn dat op der neue Shtand brenge ophüüre',
	'smw_smwadmin_datarefreshstopconfirm' => 'Joh, esch ben mer sescher, esch well dat han.',
	'smw_smwadmin_support' => 'Hölp krijje',
	'smw_smwadmin_supportdocu' => 'Bei Probleme kriss De velleich Hölp övver en Aanzahl vun Müjjeleschkeite:',
	'smw_smwadmin_installfile' => 'Wann De Schwiireschkeite met Dinge Enshtallzjuhn häs, dann donn met de Reeschlinnije en dä Dattei <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL</a> anfange, donoh ze söke, wat De donn kanns.',
	'smw_smwadmin_smwhomepage' => 'De kumplätte Dokku för et <i lang="en">Semantic Mediawiki</i> es op <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b> ze fenge.',
	'smw_smwadmin_mediazilla' => 'Fähler kanns De övver <a href="https://bugzilla.wikimedia.org/" lang="en">Bugzilla</a> melde.',
	'smw_smwadmin_questions' => 'Wann De noch Froore häß odder Vörschlääsch maache odder klaafe wells, jangk op et <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user"><i lang="en">Semantic MediaWiki</i> Metmaacher Forum</a> un donn doh metschwaade.',
	'smw_adminlinks_datastructure' => 'De Daateshtruktur',
	'smw_adminlinks_displayingdata' => 'Daate aanzeije',
	'smw_adminlinks_inlinequerieshelp' => 'Hölp övver de em Wiki sing Sigge enjeboute Froore',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Les Meloures
 * @author Robby
 */
$messages['lb'] = array(
	'smw-desc' => "Är Wiki méi accessibel machen - fir Maschinnen ''a'' Menschen ([http://semantic-mediawiki.org/wiki/Help:User_manual online documentation])",
	'smw_edithelp' => "D'Hellëf vun den Eegeschaften änneren",
	'smw_finallistconjunct' => ', an',
	'smw_factbox_head' => 'Fakten iwwer $1',
	'smw_isspecprop' => 'Dëse Eegeschaft ass eng Spezial-Eegschaft an dëser Wiki.',
	'smw_isknowntype' => 'Dësen Typ ass ee vun de Standard-Datantype vun dëser Wiki.',
	'smw_isaliastype' => 'Dësen Typ vun donnéeën ass keen Alias fir den Typ vun Donnéeën "$1".',
	'smw_concept_description' => 'Beschreiwung vum Konzept "$1"',
	'smw_multiple_concepts' => 'Op jiddwer Konzeptsäit ka just eng Definitioun vun engem Konzept stoen.',
	'smw_baduri' => 'URIë vun der Form "$1" sinn net erlaabt.',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automatesch',
	'smw_printername_count' => 'Resultater zielen',
	'smw_printername_csv' => 'Export als CSV',
	'smw_printername_debug' => 'Debug-Ufro (fir Experten)',
	'smw_printername_embedded' => 'Säiteninhalter abannen',
	'smw_printername_json' => 'Export als JSON',
	'smw_printername_list' => 'Lëscht',
	'smw_printername_ol' => 'Opzielung',
	'smw_printername_ul' => 'Opzielung',
	'smw_printername_rss' => 'Export als RSS',
	'smw_printername_table' => 'Tabell',
	'smw_printername_broadtable' => 'Breed Tabell',
	'smw_printername_template' => 'Schabloun',
	'smw_paramdesc_limit' => "D'maximal Zuel vu Resultater déi gewise gëtt",
	'smw_paramdesc_mainlabel' => "D'Etiquette déi der Haaptsäit den Numm gëtt",
	'smw_paramdesc_link' => "D'Werter als Linke weisen",
	'smw_paramdesc_default' => 'Den Text den ugewise gëtt wann et keng Resultater vun der Sich gëtt',
	'smw_paramdesc_searchlabel' => "Den Text am Link op d'Resultater",
	'smw_paramdesc_sep' => "D'Trennzeeche fir Wäerter",
	'smw_paramdesc_template' => "Den Numm vun enger Schabloun mat däer d'Drockversiounen gewise ginn",
	'smw_paramdesc_columns' => "D?zuel vu Colonnen an deenen d'Resultater vun dr Sich gewise ginn (Standard ass $1)",
	'smw_paramdesc_embedformat' => "Den HTML-Tag dee benotzt gëtt fir d'Iwwerschrëften ze definéieren",
	'smw_paramdesc_embedonly' => 'Keng Iwwerschrëfte weisen',
	'smw_paramdesc_rsstitle' => 'Den Text deen als Iwwerschrëft vun der Rubrik benotzt gëtt',
	'smw_iq_moreresults' => '… weider Resultater',
	'smw_iq_nojs' => 'Benotzt w.e.g e Browser matt JavaScript fir dëst Element ze gesinn',
	'smw_iq_altresults' => "D'Lëscht mat de Resultater weisen.",
	'smw_unknown_importns' => 'Importfonctioune si fir den Nummraum "$1" net disponibel.',
	'smw_nonright_importtype' => '$1 kann nëmme fir Säiten am Nummraum "$2" benotzt ginn.',
	'smw_wrong_importtype' => '$1 kann net fir Säiten am Nummraum "$2" benotzt ginn.',
	'smw_no_importelement' => 'D\'Element "$1" kann net importéiert ginn.',
	'smw_parseerror' => 'De Wert deen dir aginn hutt gouf net verstan.',
	'smw_notitle' => '"$1" kann net als Numm vun enger Säit op dëser Wiki benotzt ginn.',
	'smw_wrong_namespace' => 'Nëmme Säiten aus dem Nummraum "$1" sinn hei erlaabt.',
	'smw_emptystring' => 'Eidel Zeeche ginn net akzeptéiert.',
	'smw_maxstring' => "D'Zeecheketten $1 ass ze laang.",
	'smw_notinenum' => '"$1" ass net an der Lëscht vun de méigleche Wäerter ($2) fir dës Eegeschaft.',
	'smw_true_words' => 'wouer,w,jo,j',
	'smw_false_words' => 'falsch,f,neen,n',
	'smw_nofloat' => '"$1" ass keng Zuel.',
	'smw_infinite' => 'Zuelen esou grouss wéi "$1" ginn net ënnerstëtzt.',
	'smw_infinite_unit' => 'D\'Ëmrechnen an d\'Eenheet "$1" huet eng Zuel erginn géi ze grouss ass.',
	'smw_novalues' => 'Keng Wäerter spezifizéiert.',
	'smw_unsupportedunit' => 'Umrechnung vun der Eenheet "$1" gëtt net ënnerstëtzt.',
	'smw_nodatetime' => 'Den Datum "$1" gouf net verstan.',
	'smw_noclosingbrackets' => 'Eng oder méi "<nowiki>[[</nowiki>" an Ärer Ufro war net zou duerch eng entspriechent "]]".',
	'smw_misplacedsymbol' => 'D\'Symbol "$1" gouf op ener Plaz benotzt wou et net nëtzlech ass.',
	'smw_overprintoutlimit' => "An der Ufro sinn zevill Instruktioune fir d'Duerstellung vum Resultat.",
	'smw_badtitle' => 'Pardon, awer "$1" ass kee gëltegen Titel vun enger Säit.',
	'smw_badqueryatom' => 'Een Deel "<nowiki>[[…]]</nowiki>" vun der Ufro gouf net verstan.',
	'smw_propvalueproblem' => 'De Wert vun der eegeschaft "$1" gouf net verstan.',
	'smw_devel_warning' => 'Dës Fonctioun ass elo eréischt an der Entwécklung a fonctionnéiert eventuell net korrekt.
Séchert Är Donnéeën (Backup) ier Dir dës Fonctioun benotzt.',
	'smw_type_header' => 'Eegeschafte vum Typ "$1"',
	'smw_attribute_header' => 'Säiten déi d\'Eegeschaft "$1" benotzen',
	'smw_concept_header' => 'Säite vum Konzept "$1"',
	'smw_conceptarticlecount' => 'Déi $1 {{PLURAL:$1|Säit|Säite}} weisen déi zu deem Konzept gehéieren.',
	'exportrdf' => 'Säiten als RDF exportéieren',
	'smw_exportrdf_backlinks' => 'Och all Säiten déi op déi exportéiert Säite referéieren exportéieren.
Et gët en RDF ugeluecht dee liicht duerchsicht ka ginn.',
	'smw_exportrdf_lastdate' => 'Keng Säiten exportéieren déi zënter dem Zäitpunkt deen uginn ass net geännert goufen.',
	'smw_exportrdf_submit' => 'Exportéieren',
	'properties' => 'Eegeschaften',
	'smw_properties_docu' => 'Dës Eegeschafte ginn op dëser Wiki benotzt.',
	'smw_property_template' => '$1 vum Typ $2 ($3)',
	'smw_propertylackspage' => 'All Eegeschafte sollen op enger Säit beschriwwe sinn!',
	'smw_propertyhardlyused' => 'Dës Eegeschaft gëtt an dëser Wiki kaum benotzt!',
	'unusedproperties' => 'Onbenotzten Eegeschaften',
	'smw_unusedproperties_docu' => 'Dës Eegeschafte gëtt et och wa keng aner Säit se benotzt.',
	'smw_unusedproperty_template' => '$1 vum Typ $2',
	'wantedproperties' => 'Gewënschten Eegeschaften',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|mol benotzt|mol benotzt}})',
	'tooltip-purge' => "Klickt hei fir all Ufroen a Schablounen op dëser Säit z'aktualiséieren",
	'smw_purge' => 'Aktualiséieren',
	'types' => 'Typen',
	'smw_typeunits' => 'Moosseenheete vum Typ "$1": $2',
	'semanticstatistics' => 'Semantesch Statistiken',
	'ask' => 'Semantesch Sich',
	'smw_ask_sortby' => 'No der Colonne sortéieren (optional)',
	'smw_ask_ascorder' => 'Vu kleng op grouss (croissant)',
	'smw_ask_descorder' => 'vu grouss op kleng (décroissant)',
	'smw_ask_submit' => 'Resultater sichen',
	'smw_ask_editquery' => '[Ufro änneren]',
	'smw_add_sortcondition' => "[Konditioun fir d'Zortéieren derbäisetzen]",
	'smw_ask_hidequery' => 'Ufro verstoppen',
	'smw_ask_help' => 'Hëllef ufroen',
	'smw_ask_queryhead' => 'Ufro',
	'smw_ask_printhead' => 'Zousätzlech Date weisen',
	'smw_ask_printdesc' => '(eng Eegeschaft pro Linn derbäisetzen)',
	'smw_ask_format_as' => 'Formatéieren als:',
	'smw_ask_defaultformat' => 'Standard',
	'smw_ask_otheroptions' => 'Aner Optiounen',
	'smw_ask_show_embed' => 'Agebonnene Code weisen',
	'smw_ask_hide_embed' => 'Agebonnene Code verstoppen',
	'searchbyproperty' => 'No Eegeschafte sichen',
	'smw_sbv_docu' => 'Sich no alle Säiten déi eng bestëmmten Eegeschaft mat engem bestëmmete Wert hunn.',
	'smw_sbv_displayresult' => 'Eng Lëscht vun alle Säiten déi d\'Eegeschaft "$1" mam Wert "$2" hunn',
	'smw_sbv_property' => 'Eegeschaft:',
	'smw_sbv_value' => 'Wert:',
	'smw_sbv_submit' => 'Resultater sichen',
	'browse' => "Duerch d'Wiki goen",
	'smw_browse_go' => 'Lass',
	'smw_browse_show_incoming' => 'Eegeschafte weisen déi heihi linken',
	'smw_browse_hide_incoming' => 'Eegeschafte verstoppen déi hei hi linken',
	'smw_browse_no_outgoing' => 'Dës Säit huet keng Eegeschaften',
	'smw_browse_no_incoming' => 'Et linke keng Eegeschaften op dës Säit.',
	'smw_inverse_label_default' => '$1 vu(n)',
	'pageproperty' => 'An den Eegeschafte vun der Säit sichen',
	'smw_pp_from' => 'Vun der Säit',
	'smw_pp_type' => 'Eegeschaft',
	'smw_pp_submit' => 'Resultater sichen',
	'smw_result_prev' => 'Vireg',
	'smw_result_next' => 'Nächst',
	'smw_result_results' => 'Resultater',
	'smw_result_noresults' => 'Pardon, et gouf näischt fonnt.',
	'smwadmin' => 'Admin-Fonctiounen fir Semantic MediaWiki',
	'smw_smwadmin_return' => 'Zréck op $1',
	'smw_smwadmin_updatenotstarted' => 'Et ass schonn een Aktualiséiereungs-Prozess amgaang.
Et ka keen neien ugefaang ginn.',
	'smw_smwadmin_updatestopped' => 'All Aktualisatiouns-Prozesser goufe gestoppt.',
	'smw_smwadmin_db' => 'Datebankinstallatioun and -aktualiséierung',
	'smw_smwadmin_dbbutton' => 'Tabellen initialiséieren oder aktualiséieren',
	'smw_smwadmin_announce' => 'Är wiki ukënnegen',
	'smw_smwadmin_datarefresh' => 'Donnéeë gi gefléckt an aktualiséiert',
	'smw_smwadmin_datarefreshbutton' => "Ufänken Daten z'aktualiséieren",
	'smw_smwadmin_datarefreshstop' => 'Dësn Update stoppen',
	'smw_smwadmin_datarefreshstopconfirm' => 'Jo, ech si sécher.',
	'smw_smwadmin_support' => 'Ënnerstëtzung kréien',
	'smw_smwadmin_smwhomepage' => 'Déi komplett Benotzerdokumentatioun vu Semantic MediaWiki fannt Dir op b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Feeler kënnen op <a href="https://bugzilla.wikimedia.org/">Bugzilla</a> gemellt ginn.',
	'smw_smwadmin_questions' => 'Wann dir nach Froen oder Propositiounen hutt, da bedeelegt Iech un der Diskussioun op dem <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki Benotzer-Forum</a>.',
	'smw_adminlinks_datastructure' => 'Datestruktur',
	'smw_adminlinks_displayingdata' => 'Donnéeë weisen',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'smw-desc' => "Го прави вашето вики подостапно - за машини ''и'' луѓе ([http://semantic-mediawiki.org/wiki/Help:User_manual документација])",
	'smw_edithelp' => 'Помош со уредување на својства',
	'smw_viewasrdf' => 'RDF емитување',
	'smw_finallistconjunct' => ' и',
	'smw_factbox_head' => 'Факти за $1',
	'smw_isspecprop' => 'Ова својство е специјално својство во ова вики.',
	'smw_isknowntype' => 'Овој тип им припаѓа на стандардните типови на податоци на ова вики.',
	'smw_isaliastype' => 'Овој тип е алијас на типот на податоци „$1“.',
	'smw_isnotype' => 'Овој тип „$1“ не претставува стандарден тип на податок во викито, и затоа нема добиено ни корисничка одредба.',
	'smw_concept_description' => 'Опис на концептот „$1“',
	'smw_no_concept_namespace' => 'Концептите можат да се определуваат само на страници во именскиот простор „Концепт:“ („Concept:“).',
	'smw_multiple_concepts' => 'Секоја концептна страница може да има само по една одредба на концепт.',
	'smw_concept_cache_miss' => 'Концептот „$1“ во моментов не може да се користи, бидејќи местењата на викито бараат тој да се пресмета вон интернет.
Ако проблемот не исчезне по извесно време, побарајте од вашиот администратор да го овозможи тој концепт.',
	'smw_noinvannot' => 'На обратните својства не можат да им се назначуваат вредности.',
	'smw_baduri' => 'URI-ja од обликот „$1“ не се дозволени.',
	'smw_printername_auto' => 'Автоматски',
	'smw_printername_count' => 'Резултати од пребројувањето',
	'smw_printername_csv' => 'CSV извоз',
	'smw_printername_debug' => 'Поправање грешки во барања (за експерти)',
	'smw_printername_embedded' => 'Вметни содржина од страница',
	'smw_printername_json' => 'JSON извоз',
	'smw_printername_list' => 'Список',
	'smw_printername_ol' => 'Набројување',
	'smw_printername_ul' => 'Список',
	'smw_printername_rss' => 'RSS извоз',
	'smw_printername_table' => 'Табела',
	'smw_printername_broadtable' => 'Широка табела',
	'smw_printername_template' => 'Шаблон',
	'smw_paramdesc_limit' => 'Максималниот број на дадени резултати',
	'smw_paramdesc_headers' => 'Прикажувај наслови/имиња на својства',
	'smw_paramdesc_mainlabel' => 'Ознаката која се дава на името на главната страница',
	'smw_paramdesc_link' => 'Прикажи ги вредностите како врски',
	'smw_paramdesc_intro' => 'Текстот за прикажување пред резултатите од барањето, ако ги има',
	'smw_paramdesc_outro' => 'Текстот за прикажување по резултатите од барањето, ако ги има',
	'smw_paramdesc_default' => 'Текстот за прикажување ако нема резултати од барањето',
	'smw_paramdesc_searchlabel' => 'Текстот на врската кон резултатите',
	'smw_paramdesc_sep' => 'Разделувачот за вредностите',
	'smw_paramdesc_template' => 'Името на шаблонот со чија помош ќе се прикажуваат податоците',
	'smw_paramdesc_columns' => 'Бројот на колони за приказ на резултати (3 по основно)',
	'smw_paramdesc_embedformat' => 'HTML-ознаката која се користи за определување на наслови',
	'smw_paramdesc_embedonly' => 'Не прикажувај наслови',
	'smw_paramdesc_rsstitle' => 'Текстот што ќе се користи како наслов на каналот',
	'smw_paramdesc_rssdescription' => 'Текстот што ќе се користи како опис на каналот',
	'smw_iq_disabled' => 'На ова вики се оневозможени семантички барања.',
	'smw_iq_moreresults' => '… понатамошни резултати',
	'smw_iq_nojs' => 'За да го видите овој елемент користете прелистувач со поддршка за JavaScript.',
	'smw_iq_altresults' => 'Прелистај го списокот на резултати.',
	'smw_unknown_importns' => 'Функциите за увоз се недостапни за именскиот простор „$1“.',
	'smw_nonright_importtype' => '$1 може да се користи само за страници со именски простор „$2“.',
	'smw_wrong_importtype' => '$1 не може да се користи за страници во именскиот простор „$2“.',
	'smw_no_importelement' => 'Елементот „$1“ е недостапен за увоз.',
	'smw_parseerror' => 'Дадената вредност не беше разбрана.',
	'smw_notitle' => '„$1“ не може да се користи како име на страница во ова вики.',
	'smw_wrong_namespace' => 'Тука се дозвоени само страници во именскиот простор „$1“.',
	'smw_unknowntype' => 'За својството е определен неподдржан тип „$1“.',
	'smw_manytypes' => 'За својството е определен повеќе од еден тип.',
	'smw_emptystring' => 'Не се прифаќаат празни низи.',
	'smw_maxstring' => 'Низната претстава $1 е предолга.',
	'smw_notinenum' => '„$1“ не е на списокот на можни вредности ($2) за ова својство.',
	'smw_noboolean' => '„$1“ не претставува Булова вредност (точно/неточно).',
	'smw_true_words' => 'вистина,да,в,д,true,t,yes,y',
	'smw_false_words' => 'лага,л,невистина,н,не,false,f,no,n',
	'smw_nofloat' => '„$1“ не претставува број.',
	'smw_infinite' => 'Броевите со толкава должина како „$1“ не се поддржани.',
	'smw_infinite_unit' => 'Претворањето во единицата „$1“ доведе до преголем број.',
	'smw_novalues' => 'Нема назначено вредности.',
	'smw_unsupportedprefix' => 'Не се поддржани префикси за броеви („$1“).',
	'smw_unsupportedunit' => 'Претворањето не е поддржано за единицата „$1“.',
	'smw_nodatetime' => 'Датумот „$1“ не е разбран.',
	'smw_toomanyclosing' => 'Во барањето има премногу јавувања на „$1“.',
	'smw_noclosingbrackets' => 'Во вашето барање беа искористени загради „<nowiki>[[</nowiki>“ на кои им недостатуваат соодветни затворачки загради „]]“.',
	'smw_misplacedsymbol' => 'Знакот „$1“ е додаден на место кајшто не е корисен',
	'smw_unexpectedpart' => 'Делот „$1“ од барањето не беше разбран.
Резултатите може да се разликуваат од очекуваното.',
	'smw_emptysubquery' => 'Едно од подбарањата нема важечки услов.',
	'smw_misplacedsubquery' => 'Користено е подбарање на некое место кадешто не се дозволени подбарања.',
	'smw_valuesubquery' => 'Подбарањата не се поддржани за вредностите на својството „$1“.',
	'smw_overprintoutlimit' => 'Барањето содржи премногу побарувања за изводен приказ.',
	'smw_badprintout' => 'Некој исказ за изводен приказ во барањето е неправилно составен.',
	'smw_badtitle' => '„$1“ не претставува важечки наслов на страница.',
	'smw_badqueryatom' => 'Извесен дел „<nowiki>[[…]]</nowiki>“ од барањето не беше разбран.',
	'smw_propvalueproblem' => 'Вредноста на својството „$1“ не е разбрана.',
	'smw_noqueryfeature' => 'Некои функции од барањето не се поддржани на ова вики, и затоа е испуштен дел од барањето ($1).',
	'smw_noconjunctions' => 'Сврзници во барања не се поддржани во ова вики, и затоа е испуштен дел од барањето ($1).',
	'smw_nodisjunctions' => 'Во ова вики не се поддржани дисјункции во барањата, и затоа еден дел од барањето е отфрлен ($1).',
	'smw_querytoolarge' => 'Следниве услови на барањето не можеа да бидат земени во предвид заради ограничувањата на големината или длабочината на барањата во ова вики: $1',
	'smw_devel_warning' => 'Оваа функција е моментално во развој, и може да не биде наполно функционална.
Направете резервна копија на податоците пред да ја користите.',
	'smw_notemplategiven' => 'Наведете вредност за параметарот „template“ за да може да работи овој формат на барање.',
	'smw_type_header' => 'Својства од типот „$1“',
	'smw_typearticlecount' => '{{PLURAL:$1|Прикажано е $1 својство кое го користи|Прикажани се $1 својства кои го користат}} овој тип.',
	'smw_attribute_header' => 'Страници кои го користат својството „$1“',
	'smw_attributearticlecount' => '{{PLURAL:$1|Прикажана е $1 страница која го користи ова својство|Прикажани се $1 страници кои го користат}} ова својство.',
	'smw_subproperty_header' => 'Потсвојства',
	'smw_subpropertyarticlecount' => 'Ова својство {{PLURAL:$1|го има следново $1 потсвојство|ги има следниве $1 потсвојства}}:',
	'smw_concept_header' => 'Страници на концептот „$1“',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Прикажана е $1 страница која му припаѓа|Прикажани се $1 страници кои му припаѓаат}} на тој концепт.',
	'exportrdf' => 'Извези страници во RDF',
	'smw_exportrdf_docu' => 'Оваа страница ви овозможува да преземете податоци од страница во RDF формат.
За да ги извезете страниците, внесете ги насловите во кутијата подолу (по еден наслов во секој ред).',
	'smw_exportrdf_recursive' => 'Рекурзивно извези ги сите поврзани страници.
Имајте на ум дека резултатот може да биде мошне голем!',
	'smw_exportrdf_backlinks' => 'Извези ги и страниците кои укажуваат на извезените страници.
Создава RDF со поддршка за прелистување.',
	'smw_exportrdf_lastdate' => 'Не извезувај страници кои се немаат променето од назначениот датум наваму.',
	'smw_exportrdf_submit' => 'Извези',
	'properties' => 'Својства',
	'smw_properties_docu' => 'Во викито се користат следниве својства.',
	'smw_property_template' => '$1 од типот $2 ($3)',
	'smw_propertylackspage' => 'Сите својства треба да се опишани во страница!',
	'smw_propertylackstype' => 'Нема назначено тип за ова својство (засега по основно ќе се користи типот $1)',
	'smw_propertyhardlyused' => 'Ова својство речиси не се користи на викито!',
	'unusedproperties' => 'Неискористени својства',
	'smw_unusedproperties_docu' => 'Следниве својства постојат, но ниедна друга страница не ги користи.',
	'smw_unusedproperty_template' => '$1 од типот $2',
	'wantedproperties' => 'Потребни својства',
	'smw_wantedproperties_docu' => 'Следниве својства се користат во викито, но сè уште немаат своја страница за опис.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|употреба|употреби}})',
	'tooltip-purge' => 'Кликнете тука за да ги обновите сите барања и шаблони на оваа страница',
	'smw_purge' => 'Превчитај',
	'types' => 'Типови',
	'smw_types_docu' => 'Ова е список на сите типови на податоци кои можат да се назначуваат на својства.
Секој тип на податок има своја страница кадешто може да се наведат дополнителни информации.',
	'smw_typeunits' => 'Мерни единици од типот „$1“: $2',
	'semanticstatistics' => 'Семантички статистики',
	'smw_semstats_text' => "Ова вики содржи '''$1''' {{PLURAL:$1|својствена вредност|својствени вредности}} од вкупно '''$2''' [[Special:Properties|{{PLURAL:$2|својство|различни својства}}]].
'''$3''' {{PLURAL:$3|својство има|својства имаат}} своја страница, а предвидениот тип на податоци е назначен за '''$4''' од нив.
Некои од постоечките својства може да се [[Special:UnusedProperties|неискористени]].
Својствата кои сè уште немаат страница се наведени на [[Special:WantedProperties|списокот на потребни својства]].",
	'uriresolver' => 'URI претворач',
	'smw_uri_doc' => 'URI претварачот ја имплементира <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C пронаоѓање на ознаки на httpRange-14</a>.
Тој има за задача да внимава луѓето да не се претворат во веб-страници.',
	'ask' => 'Семантичко пребарување',
	'smw_ask_sortby' => 'Сортирај по колона (незадолжително)',
	'smw_ask_ascorder' => 'Нагорен',
	'smw_ask_descorder' => 'Надолен',
	'smw_ask_submit' => 'Пронајди',
	'smw_ask_editquery' => '(Уреди барање)',
	'smw_add_sortcondition' => '(Додај услов за сортирање)',
	'smw_ask_hidequery' => 'Сокриј барање',
	'smw_ask_help' => 'Помош со поставување барања',
	'smw_ask_queryhead' => 'Барање',
	'smw_ask_printhead' => 'Дополнителни податоци за приказ',
	'smw_ask_printdesc' => '(додавајте едно име на својство по ред)',
	'smw_ask_format_as' => 'Форматирај како:',
	'smw_ask_defaultformat' => 'по основно',
	'smw_ask_otheroptions' => 'Други нагодувања',
	'smw_ask_show_embed' => 'Прикажи вграден код',
	'smw_ask_hide_embed' => 'Сокриј вграден код',
	'smw_ask_embed_instr' => 'За да го вметнете ова барање во вики-страницата меѓу редови, употребете го кодот подолу.',
	'searchbyproperty' => 'Пребарај по својство',
	'smw_sbv_docu' => 'Пребарување на сите страници кои имаат дадено својство и вредност.',
	'smw_sbv_novalue' => 'Внесете важечка вредност за својството, или пак погледнете ги сите вредности на својството „$1“.',
	'smw_sbv_displayresult' => 'Список на сите страници што го содржат својството „$1“ со вредност „$2“',
	'smw_sbv_displayresultfuzzy' => 'Список на сите страници кои имаат својство „$1“ со вредност „$2“.
Бидејќи има само неколку резултати, прикажани се и приближни вредности.',
	'smw_sbv_property' => 'Својство:',
	'smw_sbv_value' => 'Вредност:',
	'smw_sbv_submit' => 'Пронајди',
	'browse' => 'Прелистај вики',
	'smw_browselink' => 'Прелистај својства',
	'smw_browse_article' => 'Внесете го името на страницата од која би почнале да прелистувате.',
	'smw_browse_go' => 'Оди',
	'smw_browse_show_incoming' => 'прикажи својства кои водат овде',
	'smw_browse_hide_incoming' => 'сокриј својства кои водат овде',
	'smw_browse_no_outgoing' => 'Оваа страница нема својства.',
	'smw_browse_no_incoming' => 'До оваа страница не водат никакви својства.',
	'smw_inverse_label_default' => '$1 од',
	'smw_inverse_label_property' => 'Обратен наслов на својството',
	'pageproperty' => 'Пребарување својства на страница',
	'smw_pp_docu' => 'Пребарај ги сите вредности на едно својство на дадена страница.
Внесете и страница и својство.',
	'smw_pp_from' => 'Од страница',
	'smw_pp_type' => 'Својство',
	'smw_pp_submit' => 'Пребарај резултати',
	'smw_result_prev' => 'Претходно',
	'smw_result_next' => 'Следно',
	'smw_result_results' => 'Резултати',
	'smw_result_noresults' => 'Нема резултати.',
	'smwadmin' => 'Администраторски функции за Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Поставување на складиште за Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Складишниот систем е успешно поставен.',
	'smw_smwadmin_return' => 'Назад кон $1',
	'smw_smwadmin_updatestarted' => 'Започнат е нов процес за обнова на семантичките податоци.
Сите складирани податоци ќе бидат преработени или поправени, каде што е потребно.
На оваа специјална страница можете да го следите процесот на поднова.',
	'smw_smwadmin_updatenotstarted' => 'Веќе е во тек едно подновување.
Нема да се создаде друго.',
	'smw_smwadmin_updatestopped' => 'Сите постоечки процеси на поднова се сопрени.',
	'smw_smwadmin_updatenotstopped' => 'За да го запрете текот на подновата, мора да го активирате кутивчето за избор кое укажува на тоа дека сте навистина сигурни дека сакате да направите така.',
	'smw_smwadmin_docu' => 'Оваа специјална страница ви помага во текот на инсталацијата и подновата на <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Не заборавајте да направите резервни копии од значајни податоци пред да вршите административни постапки.',
	'smw_smwadmin_db' => 'Инсталација и поднова на базата на податоци',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki бара додавање на извесни додатоци кон базата на податоци на МедијаВики за да складира семантички податоци.
Функцијата подолу ви гарантира дека вашата база на податоци е правилно поставена.
Промените извршени во овој чекор немаат влијание врз остатокот од базата на МедијаВики, и лесно можат да се вратат по старо ако се јави потреба.
Оваа функција на поставката може да се врши повеќе пати без тоа да причини било каква штета, но потребна е само еднаш при инсталирање или подновување.',
	'smw_smwadmin_permissionswarn' => 'Ако операцијата не успее со SQL грешки, корисникот на базата на податоци кој работи за вашето вики (проверете ги вашите LocalSettings.php) веројатно нема доволно дозволи.
Доделете му доволно дозволи на корисникот за да може да создава и брише табели, привремено внесете го најавниот корен (root) на вашата база на податоци во LocalSettings.php, или пак употребете ја скриптата за одржување <tt>SMW_setup.php</tt> која може да ги користи акердитивите за пристап од AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Започни или поднови табели',
	'smw_smwadmin_announce' => 'Објавете го вашето вики',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki има веб-служба за соопштување на нови семантички вики-страници.
Ова се користи за одржување на список на јавни веб-места кои го користат Semantic MediaWiki, главно со цел да му се помогне на <a href="http://semantic-mediawiki.org/wiki/SMW_Project">проектот Semantic MediaWiki</a> да добие претстава за типичните употреби на Semantic MediaWiki.
Погледајте ја веб-страницата на Semantic MediaWiki за <a href="http://semantic-mediawiki.org/wiki/Registry">повеќе информации за оваа служба</a>.',
	'smw_smwadmin_announcebutton' => 'Притиснете го следново копче за да ја испратите URL-адресата на вашето вики во таа служба.
Службата нема да регистрира викија што не се јавно достапни, и ќе складира само достапни информации.',
	'smw_smwadmin_datarefresh' => 'Поправка и поднова на податоци',
	'smw_smwadmin_datarefreshdocu' => 'Постои можност за враќање на сите Semantic MediaWiki податоци врз основа на тековните содржини на викито.
Ова е корисно за поправка на расипани податоци или за обнова на податоците ако внатрешниот формат се има променето како резултат на некаква надградба на програмската опрема.
Подновувањето се врши страница по страница, и ќе треба да помине некое време за да профункционира.
Подолу е прикажано дали има поднова во тек, и тоа ви овозможува да започнувате или запирате подновувања (освен ако таа можност не е исклучена од администраторот на мрежното место).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Веќе е во тек една поднова.</strong>
Нормално е подновата да биде бавна, бидејќи податоците се обновуваат во мали делчиња секојпат кога корисникот ќе отиде на викито.
За да ја убрзате подновата, можете да ја повикате скриптата за одржување на MediaWiki <tt>runJobs.php</tt> (користете ја можноста <tt>--maxjobs 1000</tt> за да го ограничите бројот на поднови во една партија).
Проценет напредок на тековната поднова:',
	'smw_smwadmin_datarefreshbutton' => 'Започни со подновување на податоци',
	'smw_smwadmin_datarefreshstop' => 'Започни го ова подновување',
	'smw_smwadmin_datarefreshstopconfirm' => 'Да, сигурен сум.',
	'smw_smwadmin_support' => 'Како да добиете поддршка',
	'smw_smwadmin_supportdocu' => 'Различни ресурси кои можат да ви помогнат во случај на проблеми:',
	'smw_smwadmin_installfile' => 'Ако наидете на проблеми при инсталацијата, најпрвин прочитајте ги напатствијата во <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">податотеката INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Целосната корисничка документација за Semantic MediaWiki ќе ја најдете на <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Бубачките (грешките) можат да се пријават на <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Ако имате некои други прашања или предлози, приклучете ѝ се на дискусијата на <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">форумот за корисници на Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Структура на податоците',
	'smw_adminlinks_displayingdata' => 'Приказ на податоци',
	'smw_adminlinks_inlinequerieshelp' => 'Помош со вметнати барања',
);

/** Malayalam (മലയാളം)
 * @author Shijualex
 */
$messages['ml'] = array(
	'smw_finallistconjunct' => 'ഉം',
	'smw_factbox_head' => '$1നെ കുറിച്ചുള്ള സത്യങ്ങൾ',
	'smw_iq_moreresults' => '… കൂടുതൽ ഫലങ്ങൾ',
	'smw_iq_nojs' => 'ഈ എലമെന്റ് കാണുവാൻ ദയവായി ജാവാസ്ക്രിപ് എനേബിൾ ചെയ്ത ബ്രൗസർ ഉപയോഗിക്കുക.',
	'smw_unknown_importns' => 'ഇറക്കുമതി ഫങ്ങ്ഷൻസ് “$1” എന്ന നാമമേഖലയിൽ ലഭ്യമല്ല.',
	'smw_nonright_importtype' => '“$2” എന്ന നാമമേഖലയിലുള്ള താളുകളിൽ മാത്രമേ $1 ഉപയോഗിക്കാൻ പറ്റൂ.',
	'smw_wrong_importtype' => '“$2” എന്ന നാമമേഖലയിലുള്ള താളുകളിൽ $1 ഉപയോഗിക്കുവാൻ പറ്റില്ല.',
	'smw_parseerror' => 'താങ്കൾ ചേർത്ത മൂല്യം മനസ്സിലാക്കാൻ സാധിച്ചില്ല.',
	'smw_true_words' => 'ശരി,ശരി,അതെ,അതെ',
	'smw_false_words' => 'തെറ്റ്,തെറ്റ്,അല്ല,അല്ല',
	'smw_nofloat' => '“$1” ഒരു സംഖ്യയല്ല.',
	'smw_infinite' => '“$1” എന്ന സംഖ്യയുടെയത്ര വലിപ്പമുള്ള സംഖ്യകൾ {{SITENAME}} സം‌രംഭത്തിൽ പിൻ‌താങ്ങുന്നില്ല.',
	'smw_unsupportedunit' => '“$1” എന്ന ഏകകത്തിന്റെ ഏകകമാറ്റം പിൻ‌താങ്ങുന്നില്ല.',
	'smw_misplacedsymbol' => '“$1” എന്ന ചിഹ്നം അതു ഉപയോഗിക്കാൻ പാടില്ലാത്ത ഒരു സ്ഥലത്ത് ഉപയോഗിച്ചിരിക്കുന്നു.',
	'smw_badtitle' => 'ക്ഷമിക്കണം, “$1”  എന്നതു സാധുവായൊരു തലക്കെട്ട് അല്ല.',
	'exportrdf' => 'RDFലേക്ക് താളുകൾ എക്സ്‌പോർട്ട് ചെയ്യുക',
	'smw_wantedproperty_template' => '$1 ($2 ഉപയോഗങ്ങൾ)',
	'types' => 'തരങ്ങൾ',
	'smw_ask_ascorder' => 'ആരോഹണം',
	'smw_ask_descorder' => 'അവരോഹണം',
	'smw_ask_submit' => 'ഫലങ്ങൾ കാണുക',
	'smw_sbv_value' => 'മൂല്യം',
	'smw_sbv_submit' => 'ഫലങ്ങൾ കാണുക',
	'browse' => 'വിക്കിയിൽ പരതുക',
	'smw_browse_go' => 'പോകൂ',
	'smw_pp_from' => 'ഈ താളിൽ നിന്ന്',
	'smw_pp_submit' => 'ഫലങ്ങൾ കാണുക',
	'smw_result_prev' => 'മുമ്പത്തെ',
	'smw_result_next' => 'അടുത്തത്',
	'smw_result_results' => 'ഫലങ്ങൾ',
	'smw_result_noresults' => 'ക്ഷമിക്കുക, ഫലങ്ങൾ ഒന്നുമില്ല',
);

/** Marathi (मराठी)
 * @author Kaustubh
 */
$messages['mr'] = array(
	'smw_edithelp' => 'गुणधर्मांवरील मदत संपादा',
	'smw_viewasrdf' => 'RDF फीड',
	'smw_finallistconjunct' => ', व',
	'smw_factbox_head' => '$1 च्या फॅक्ट्स',
	'smw_isspecprop' => 'हा गुणधर्म या विकिवरील विशेष गुणधर्म आहे.',
	'smw_isknowntype' => 'हा प्रकार या विकिवरील ठराविक डाटा प्रकारांपैकी एक आहे.',
	'smw_isaliastype' => 'हा प्रकार “$1” या डाटाप्रकारची पुनरुक्ती आहे.',
	'smw_isnotype' => 'हा  “$1” प्रकार या विकिवरील ठराविक डाटा प्रकारांपैकी नाही, व त्याची सदस्य व्याख्या सुद्धा दिलेली नाही.',
	'smw_baduri' => 'माफ करा, “$1” अर्जाचे URI वापरण्यास परवानगी नाही.',
	'smw_iq_disabled' => 'माफ करा. या विकिवर सिमँटिक पॄच्छा करण्यास बंदी आहे.',
	'smw_iq_moreresults' => '… पुढचे निकाल',
	'smw_iq_nojs' => 'हा एलेमेंट पाहण्यासाठी जावास्क्रीप्ट युक्त ब्राउजर वापरा.',
	'smw_iq_altresults' => 'थेट निकाल यादी चाळा.',
	'smw_unknown_importns' => '“$1” या नामविश्वासाठी आयात कार्ये उपलब्ध नाहीत.',
	'smw_nonright_importtype' => '$1 हे फक्त “$2” या नामविश्वातील पानांसाठीच वापरता येते.',
	'smw_wrong_importtype' => '$1 हे “$2” या नामविश्वातील पानांसाठी वापरता येत नाही.',
	'smw_no_importelement' => '“$1” हा एलेमेंट आयातीसाठी उपलब्ध नाही.',
	'smw_parseerror' => 'दिलेली किंमत समजलेली नाही.',
	'smw_notitle' => 'या विकिवर “$1” हे पानाच्या शीर्षकात वापरता येत नाही.',
	'smw_unknowntype' => 'गुणधर्माचा प्रकार “$1” वापरता येत नाही.',
	'smw_manytypes' => 'गुणधर्माला एकापेक्षा जास्त प्रकार दिलेले आहेत.',
	'smw_emptystring' => 'रिकाम्या किंमती वापरता येत नाहीत.',
	'smw_maxstring' => '{{SITENAME}} साठी $1 हे स्ट्रींग रिप्रेझेंटेशन खूप लांब आहे.',
	'smw_notinenum' => 'या गुणधर्माच्या योग्य किंमतींच्या ($2) यादीत “$1” नाही आहे.',
	'smw_noboolean' => '“$1” ही योग्य बुलियन (बरोबर/चूक) किंमत नाही.',
	'smw_true_words' => 'बरोबर,t,हो,y',
	'smw_false_words' => 'चूक,f,नाही,n',
	'smw_nofloat' => '“$1” ही संख्या नाही.',
	'smw_infinite' => '{{SITENAME}} वर “$1” एवढ्या मोठ्या संख्या वापरता येत नाहीत.',
	'smw_infinite_unit' => '“$1” एककात बदल केल्यानंतर येणारी संख्या ही {{SITENAME}} वर वापरता येण्यासारख्या संख्यांपेक्षा खूप मोठी आहे.',
	'smw_unsupportedprefix' => 'संख्या (“$1”) साठी उपपदे वापरता येत नाहीत.',
	'smw_unsupportedunit' => '“$1” हे एकक बदलता येत नाही.',
	'smw_nodatetime' => '“$1” हा दिनांक समजला नाही.',
	'smw_toomanyclosing' => 'या पृच्छेमध्ये “$1” खूप ठिकाणी आलेले आहे.',
	'smw_noclosingbrackets' => 'तुमच्या पृच्छेत कुठेतरी वापरलेले “<nowiki>[[</nowiki>” हे योग्य अशा जुळणार्‍या “]]” ने बंद केलेले नाही.',
	'smw_misplacedsymbol' => '“$1” चिन्ह जिथे उपयोगी नाही अशा ठिकाणी वापरलेले आहे.',
	'smw_unexpectedpart' => 'पृच्छेचा “$1” हा भाग समजलेला नाही.
निकाल योग्य असतीलच याची खात्री नाही.',
	'smw_emptysubquery' => 'कुठल्यातरी उपपृच्छेमध्ये योग्य कंडिशन दिलेली नाही.',
	'smw_misplacedsubquery' => 'एक उपपृच्छा अशा ठिकाणी दिलेली आहे जिथे उपपृच्छा वापरायला परवानगी नाही.',
	'smw_valuesubquery' => '“$1” गुणधर्माच्या किंमतींसाठी उपपृच्छा वापरता येत नाहीत.',
	'smw_overprintoutlimit' => 'या पृच्छेमध्ये खूप जास्त प्रिंट विनंत्या आहेत.',
	'smw_badprintout' => 'या पृच्छेमधील काही प्रिंट मागण्या अयोग्य प्रकारे दिलेल्या आहेत.',
	'smw_badtitle' => 'माफ करा, पण “$1” हे योग्य पानाचे शीर्षक नाही.',
	'smw_badqueryatom' => 'पृच्छेचा काही भाग “<nowiki>[[…]]</nowiki>” समजलेला नाही.',
	'smw_propvalueproblem' => '“$1” गुणधर्माची किंमत समजलेली नाही.',
	'smw_nodisjunctions' => 'पृच्छे मध्ये तुकडे या विकिवर चालत नाहीत, त्यामुळे पृच्छेचा तुकडा टाकून दिला  ($1).',
	'smw_querytoolarge' => 'पृच्छेचा आकार अथवा खोलीवर असणार्‍या ह्या विकिवरील मर्यादांमुळे खालील पृच्छा अटी लक्षात घेता आलेल्या नाहीत: $1.',
	'smw_devel_warning' => 'हे फिचर सध्या प्रायोगिक अवस्थेत आहे, आणि कदाचित त्यामुळे पूर्णपणे काम करणार नाही.
कृपया तुमचा डाटा वापरण्यापूर्वी त्याची प्रत करून ठेवा.',
	'smw_type_header' => '“$1” प्रकारचे गुणधर्म',
	'smw_typearticlecount' => 'हा प्रकार वापरणारे $1 गुणधर्म दाखवित आहे.',
	'smw_attribute_header' => '“$1” गुणधर्म वापरणारी पृष्ठे',
	'smw_attributearticlecount' => 'हा गुणधर्म वापरणारी $1 पाने दाखवित आहे..',
	'smw_rss_description' => '$1 आरएसएस फीड',
	'specialpages-group-smw_group' => 'सिमँटिक मीडियाविकि',
	'exportrdf' => 'RDF कडे पाने निर्यात करा',
	'smw_exportrdf_docu' => 'हे पान तुम्हाला एखाद्या पानावरील मजकूर RDF मध्ये घेण्यास मदत करते.
पाने निर्यात करण्याकरीता, खाली एका ओळीत एक याप्रमाणे पानांची शीर्षके लिहा.',
	'smw_exportrdf_recursive' => 'सर्व जुळलेली पाने आपोआप निर्यात करा.
कृपया नोंद घ्या की निकाल खूप मोठा असू शकतो!',
	'smw_exportrdf_backlinks' => 'निर्यात केलेल्या पानांचे संदर्भ देणारी पाने सुद्धा निर्यात करा.
ब्राउजेबल RDF तयार होईल.',
	'smw_exportrdf_lastdate' => 'दिलेल्या वेळेनंतर ज्या पानांमध्ये बदल झालेले नाहीत अशी पाने निर्यात करू नका.',
	'properties' => 'गुणधर्म',
	'smw_properties_docu' => 'या विकिवर खालील गुणधर्म वापरलेले आहेत.',
	'smw_property_template' => '$2 प्रकारची $1 ($3)',
	'smw_propertylackspage' => 'एका पानावर सर्व गुणधर्मांची माहिती असणे आवश्यक आहे!',
	'smw_propertylackstype' => 'या गुणधर्माचा प्रकार दिलेला नाही (आत्तापुरता $1 हा प्रकार गृहीत धरत आहे).',
	'smw_propertyhardlyused' => 'या विकिवर हा गुणधर्म क्वचितच वापरला जातो!',
	'unusedproperties' => 'न वापरलेले गुणधर्म',
	'smw_unusedproperties_docu' => 'खालील गुणधर्म कुठल्याही पानावर वापरण्यात आलेले नाहीत.',
	'smw_unusedproperty_template' => '$2 प्रकारचे $1',
	'wantedproperties' => 'पाहिजे असलेले गुणधर्म',
	'smw_wantedproperties_docu' => 'या विकिवर वापरण्यात आलेल्या खालील गुणधर्मांसाठी माहिती पृष्ठे अस्तित्वात नाहीत.',
	'smw_wantedproperty_template' => '$1 ($2 वापरतो)',
	'tooltip-purge' => 'या पानावरील सर्व साचे व पृच्छा ताज्या-तवान्या करण्यासाठी इथे टिचकी द्या',
	'smw_purge' => 'ताजेतवाने करा',
	'types' => 'प्रकार',
	'smw_types_docu' => 'खाली गुणधर्माशी जोडता येणार्‍या सर्व डाटा प्रकारांची यादी आहे.
प्रत्येक डाटा प्रकाराचे एक पाने आहे जिथे जास्तीची माहिती देता येईल.',
	'smw_typeunits' => '“$1” प्रकारची मापनाची एकके: $2',
	'semanticstatistics' => 'सिमँटिक सांख्यिकी',
	'smw_semstats_text' => 'ह्या विकिमध्ये <b>$1</b> गुणधर्मांच्या किंमती आहेत ज्या एकूण <b>$2</b> वेगवेगळ्या <a href="$3">गुणधर्म</a> दर्शवितात.
<b>$4</b> गुणधर्मांना स्वत:ची पाने आहेत, व त्यापैकी <b>$5</b> गुणधर्मांना जुळणारे डाटा प्रकार दिलेले आहेत.
यातील काही गुणधर्म हे <a href="$6">न वापरलेले गुणधर्म</a> असण्याची शक्यता आहे.
ज्या गुणधर्मांना स्वत:चे पान नाही असे गुणधर्म <a href="$7">पाहिजे असलेल्या गुणधर्मांची यादी</a> मध्ये सापडतील.',
	'uriresolver' => 'URI रिजल्व्हर',
	'smw_uri_doc' => 'URI रिझॉल्वर मध्ये एक <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C टॅग आहे जो httpRange-14 शोधण्यास मदत करतो</a>. हा मनुष्यप्राणी संकेतस्थळामध्ये बदलणार नाही याची काळजी घेतो.',
	'ask' => 'सिमंटिक शोध',
	'smw_ask_sortby' => 'रकान्या प्रमाणे लावा (वैकल्पिक)',
	'smw_ask_ascorder' => 'चढत्या श्रेणीने',
	'smw_ask_descorder' => 'उतरत्या श्रेणीने',
	'smw_ask_submit' => 'निकाल शोधा',
	'smw_ask_editquery' => '[पृच्छा संपादा]',
	'smw_add_sortcondition' => '[लावण्याची अट वाढवा]',
	'smw_ask_hidequery' => 'पृच्छा लपवा',
	'smw_ask_help' => 'पृच्छा करण्यासाठी मदत',
	'smw_ask_queryhead' => 'पॄच्छा',
	'smw_ask_printhead' => 'जास्तीच्या छापील प्रती (वैकल्पिक)',
	'searchbyproperty' => 'गुणधर्माप्रमाणे शोधा',
	'smw_sbv_docu' => 'दिलेला गुणधर्म व किंमत असणारी सर्व पाने शोधा.',
	'smw_sbv_novalue' => 'कृपया या गुणधर्माची एक योग्य किंमत द्या, किंवा “$1” साठीच्या सर्व किंमती पहा.',
	'smw_sbv_displayresult' => 'गुणधर्म  “$1” व त्याची किंमत “$2” असणार्‍ सर्व पानांची यादी',
	'smw_sbv_property' => 'गुणधर्म',
	'smw_sbv_value' => 'किंमत',
	'smw_sbv_submit' => 'निकाल शोधा',
	'browse' => 'विकि न्याहाळा',
	'smw_browse_article' => 'विकि ज्या पानापासून न्याहाळायचा त्या पानाचे नाव लिहा',
	'smw_browse_go' => 'चला',
	'pageproperty' => 'पान गुणधर्म शोध',
	'smw_pp_docu' => 'दिलेल्या पानावरील एखाद्या गुणधर्माच्या सर्व किंमतींचा शोध घ्या.
कृपया पान व गुणधर्म दोन्ही द्या.',
	'smw_pp_from' => 'पानावरून',
	'smw_pp_type' => 'गुणधर्म',
	'smw_pp_submit' => 'निकाल शोधा',
	'smw_result_prev' => 'मागील',
	'smw_result_next' => 'पुढील',
	'smw_result_results' => 'निकाल',
	'smw_result_noresults' => 'माफ करा, निकाल नाहीत.',
);

/** Maltese (Malti)
 * @author Chrisportelli
 * @author Roderick Mallia
 */
$messages['mt'] = array(
	'smw_browse_go' => 'Mur',
	'smw_result_prev' => "Ta' qabel",
);

/** Erzya (Эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'smw_sbv_property' => 'Уликсчись:',
	'smw_browse_go' => 'Адя',
	'smw_pp_type' => 'Уликсчи',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 */
$messages['nah'] = array(
	'smw_finallistconjunct' => ' īhuān',
	'smw_nofloat' => '"$1" ahmo tlapōhualli.',
	'smw_purge' => 'Ticyancuīyāz',
	'smw_browse_go' => 'Yāuh',
	'smw_result_prev' => 'Achtopa',
	'smw_result_next' => 'Niman',
	'smw_smwadmin_return' => 'Titocuepāz īhuīc $1',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'smw-desc' => "Maakt uw wiki toegankelijker - voor machines ''en'' mensen ([http://semantic-mediawiki.org/wiki/Help:User_manual online documentatie])",
	'smw_edithelp' => 'Bewerkingshulp bij eigenschappen',
	'smw_viewasrdf' => 'RDF-feed',
	'smw_finallistconjunct' => ', en',
	'smw_factbox_head' => 'Feiten over $1',
	'smw_isspecprop' => 'Dit is een speciale eigenschap in de wiki.',
	'smw_isknowntype' => 'Dit is een standaard gegevenstype in deze wiki.',
	'smw_isaliastype' => 'Dit type is een alias voor het gegevenstype "$1".',
	'smw_isnotype' => 'Het type "$1" is geen standaard gegevenstype in deze wiki. Er is ook nog geen gebruikersdefinitie voor opgegeven.',
	'smw_concept_description' => 'Beschrijving van het concept "$1"',
	'smw_no_concept_namespace' => "Concepten kunnen alleen gedefinieerd worden op pagina's in de naamruimte Concept:",
	'smw_multiple_concepts' => 'Iedere conceptpagina kan maar één conceptdefinitie bevatten.',
	'smw_concept_cache_miss' => 'Het concept "$1" kan op het moment niet gebruikt worden omdat de dit volgende de instellingen van de wiki offline berekend moet worden.
Als het probleem over enige tijd nog niet verholpen is, vraag de beheerder dan om dit concept beschikbaar te maken.',
	'smw_noinvannot' => 'Waarden kunnen niet toegekend worden aan omgekeerde eigenschappen.',
	'smw_baduri' => "URI's uit de reeks “$1” zijn hier niet beschikbaar.",
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automatisch',
	'smw_printername_count' => 'Resultaten tellen',
	'smw_printername_csv' => 'Naar CSV exporteren',
	'smw_printername_debug' => 'Query debuggen (voor experts)',
	'smw_printername_embedded' => 'Paginainhoud insluiten',
	'smw_printername_json' => 'Naar JSON exporteren',
	'smw_printername_list' => 'Lijst',
	'smw_printername_ol' => 'Opsomming',
	'smw_printername_ul' => 'Itemisatie',
	'smw_printername_rss' => 'Naar RSS exporteren',
	'smw_printername_table' => 'Tabel',
	'smw_printername_broadtable' => 'Brede tabel',
	'smw_printername_template' => 'Sjabloon',
	'smw_paramdesc_limit' => 'Het maximaal aantal weer te geven resultaten',
	'smw_paramdesc_headers' => 'De namen van koppen en eigenschappen weergeven',
	'smw_paramdesc_mainlabel' => 'Het label voor de hoofdpaginanaam',
	'smw_paramdesc_link' => 'Waarden als verwijzingen weergeven',
	'smw_paramdesc_intro' => 'De tekst die wordt weergegeven boven de zoekresultaten, als die er zijn',
	'smw_paramdesc_outro' => 'De tekst die wordt weergegeven onder de zoekresultaten, als die er zijn',
	'smw_paramdesc_default' => 'De tekst die wordt weergegeven als er geen zoekresultaten zijn',
	'smw_paramdesc_searchlabel' => 'De tekst voor de verwijzing naar resultaten',
	'smw_paramdesc_sep' => 'Het scheidingsteken voor waarden',
	'smw_paramdesc_template' => 'De naam van het sjabloon waar de afdrukken mee worden weergegeven',
	'smw_paramdesc_columns' => 'Het aantal kolommen om resultaten in weer te geven (standaard $1)',
	'smw_paramdesc_embedformat' => 'Het HTML-label voor de koptekstdefinities',
	'smw_paramdesc_embedonly' => 'Geen koppen weergeven',
	'smw_paramdesc_rsstitle' => 'De tekst die wordt gebruikt als de naam van de feed',
	'smw_paramdesc_rssdescription' => 'De tekst die wordt gebruikt als de beschrijving van de feed',
	'smw_iq_disabled' => 'Zoekopdrachten binnen tekst zijn uitgeschakeld in deze wiki.',
	'smw_iq_moreresults' => '… overige resultaten',
	'smw_iq_nojs' => 'Gebruiker een browser waarin JavaScript is ingeschakeld om dit element te zien.',
	'smw_iq_altresults' => 'De resultatenlijst direct bekijken',
	'smw_unknown_importns' => 'Importfuncties zijn niet beschikbaar voor de naamruimte “$1”.',
	'smw_nonright_importtype' => "$1 kan alleen gebruikt worden voor pagina's in de naamruimte “$2”.",
	'smw_wrong_importtype' => "$1 kan niet gebruikt worden in pagina's in de naamruimte “$2”.",
	'smw_no_importelement' => 'Element “$1” is niet beschikbaar voor import.',
	'smw_parseerror' => 'De opgegeven waarde is niet begrepen.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '"$1" kan niet gebruikt worden als paginanaam.',
	'smw_wrong_namespace' => 'Hier zijn alleen pagina\'s uit de naamruimte "$1" toegestaan.',
	'smw_unknowntype' => 'Type “$1” is niet beschikbaar voor de gedefinieerde eigenschap.',
	'smw_manytypes' => 'Meer dan één type gedefinieerd voor eigenschap.',
	'smw_emptystring' => 'Lege strings zijn niet toegestaan.',
	'smw_maxstring' => 'De stringrepresentatie $1 is te lang.',
	'smw_notinenum' => '“$1” komt niet voor in de lijst met mogelijke waarden ($2) voor deze eigenschap.',
	'smw_noboolean' => '“$1” is niet herkend als een booleaanse waarde (waar/onwaar).',
	'smw_true_words' => 'waar,w,ja,j,true',
	'smw_false_words' => 'onwaar,o,nee,n,false',
	'smw_nofloat' => '“$1” is geen getal.',
	'smw_infinite' => 'Getallen zo groot als “$1” worden niet ondersteund.',
	'smw_infinite_unit' => 'Conversie naar eenheid “$1” resulteerde in een getal dat te groot is.',
	'smw_novalues' => 'Geen waarden opgegeven.',
	'smw_unsupportedprefix' => 'Voorvoegsels voor getallen (“$1”) worden niet ondersteund.',
	'smw_unsupportedunit' => 'Eenheidconversie voor eenheid “$1” is niet ondersteund.',
	'smw_nodatetime' => 'De datum “$1” kon niet verwerkt worden.',
	'smw_toomanyclosing' => '“$1” lijkt te vaak voor te komen in de zoekopdracht.',
	'smw_noclosingbrackets' => 'In uw zoekopdracht is het gebruik van “<nowiki>[[</nowiki>” niet gesloten door een bijbehorende “]]”.',
	'smw_misplacedsymbol' => 'Het symbool “$1” is gebruikt op een plaats waar het niet gebruikt hoort te worden.',
	'smw_unexpectedpart' => 'Het deel “$1” van de zoekopdracht is niet begrepen. De resultaten kunnen afwijken van de verwachting.',
	'smw_emptysubquery' => 'Er is een subzoekopdracht met een onjuiste conditie.',
	'smw_misplacedsubquery' => 'Er is een subzoekopdracht gebruikt op een plaats waar subzoekopdrachten niet gebruikt mogen worden.',
	'smw_valuesubquery' => 'Subzoekopdrachten worden niet ondersteund voor waarden van eigenschap “$1”.',
	'smw_overprintoutlimit' => 'De zoekopdracht bevat te veel printoutverzoeken.',
	'smw_badprintout' => 'Er is een print statement in de zoekopdracht onjuist geformuleerd.',
	'smw_badtitle' => '“$1” is geen geldige paginanaam.',
	'smw_badqueryatom' => 'Een onderdeel “<nowiki>[[…]]</nowiki>” van de zoekopdracht is niet begrepen.',
	'smw_propvalueproblem' => 'De waarde van eigenschap “$1” is niet begrepen.',
	'smw_noqueryfeature' => 'Een bepaalde vraagoptie wordt niet ondersteund in deze wiki en een deel van de zoekopdracht is genegeerd ($1).',
	'smw_noconjunctions' => 'Verbindingen in zoekopdrachten worden in deze wiki niet ondersteund en een deel van de zoekopdracht is genegeerd ($1).',
	'smw_nodisjunctions' => 'Scheidingen in zoekopdrachten worden niet ondersteund in deze wiki en er is een deel van de zoekopdracht genegeerd ($1).',
	'smw_querytoolarge' => 'De volgende zoekopdrachtcondities zijn niet in acht genomen vanwege beperkingen in de grootte of diepte van zoekopdrachten in deze wiki: $1.',
	'smw_devel_warning' => 'Deze functie wordt op het moment ontwikkeld en is wellicht niet volledig functioneel. Maak een back-up voordat u deze functie gebruikt.',
	'smw_notemplategiven' => 'Geef een waarde voor de parameter "sjabloon" op om deze zoekopdracht te laten werken.',
	'smw_type_header' => 'Eigenschappen voor type “$1”',
	'smw_typearticlecount' => 'Er {{PLURAL:$1|is $1 eigenschap die gebruik maakt|zijn $1 eigenschappen die gebruik maken}} van dit type.',
	'smw_attribute_header' => "Pagina's die de eigenschap “$1” gebruiken",
	'smw_attributearticlecount' => "Er {{PLURAL:$1|is $1 pagina die deze eigenschap gebruikt|zijn $1 pagina's die deze eigenschappen gebruiken}}.",
	'smw_subproperty_header' => 'Subeigenschappen',
	'smw_subpropertyarticlecount' => 'Deze eigenschap heeft de volgende $1 {{PLURAL:$1|subeigenschap|subeigenschappen}}:',
	'smw_concept_header' => 'Pagina\'s met het concept "$1"',
	'smw_conceptarticlecount' => "$1 {{PLURAL:$1|pagina|pagina's}} die bij dat concept {{PLURAL:$1|hoort|horen}} worden weergegeven.",
	'exportrdf' => "Export pagina's naar RDF",
	'smw_exportrdf_docu' => "Deze pagina maakt het mogelijk gegevens te verkrijgen van een pagina in RDF-formaat.
Voer in het onderstaande invoerveld paginanamen in om pagina's te exporteren.
Iedere paginanaam op een eigen regel.",
	'smw_exportrdf_recursive' => "Alle gerelateerde pagina's recursief exporteren.
Het resultaat kan groot zijn!",
	'smw_exportrdf_backlinks' => "Exporteer ook alle pagina's die verwijzen naar de te exporteren pagina's. Genereert door te bladeren RDF.",
	'smw_exportrdf_lastdate' => "Exporteer geen pagina's die sinds het opgegeven punt niet gewijzigd zijn.",
	'smw_exportrdf_submit' => 'Exporteren',
	'properties' => 'Eigenschappen',
	'smw_properties_docu' => 'De volgende eigenschappen worden in de wiki gebruikt.',
	'smw_property_template' => '$1 van type $2 ($3)',
	'smw_propertylackspage' => 'Alle eigenschappen moeten op een pagina beschreven worden!',
	'smw_propertylackstype' => 'Er is geen type opgegeven voor deze eigenschap (type $1 wordt verondersteld).',
	'smw_propertyhardlyused' => 'Deze eigenschap wordt vrijwel niet gebruikt in de wiki.',
	'unusedproperties' => 'Ongebruikte eigenschappen',
	'smw_unusedproperties_docu' => 'De volgende eigenschappen bestaan, hoewel ze niet gebruikt worden.',
	'smw_unusedproperty_template' => '$1 van type $2',
	'wantedproperties' => 'Gewenste eigenschappen',
	'smw_wantedproperties_docu' => 'De volgende eigenschapen worden gebruikt in de wiki, maar hebben geen pagina waarop ze worden beschreven.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|keer|keren}} gebruikt)',
	'tooltip-purge' => 'Klik hier om alle zoekopdrachten en sjablonen op deze pagina bij te werken',
	'smw_purge' => 'Verversen',
	'types' => 'Typen',
	'smw_types_docu' => 'Hieronder staat een lijst van alle datatypen die aan eigenschappen kunnen worden toegewezen. Ieder datatype heeft een pagina waar aanvullende informatie opgegeven kan worden.',
	'smw_typeunits' => 'Eenheden van type "$1": $2',
	'semanticstatistics' => 'Semantische statistieken',
	'smw_semstats_text' => "Deze wiki bevat '''$1''' {{PLURAL:$1|eigenschapwaarde|eigenschapwaarden}} voor '''$2''' verschillende [[Special:Properties|{{PLURAL:$2|eigenschap|verschillende eigenschappen}}]].
'''$3''' {{PLURAL:$3|eigenschap heeft|eigenschappen hebben}} een eigen pagina en het gegevenstype is voor '''$4''' daarvan aangegeven.
Een aantal van de bestaande eigenschappen is wellicht [[Special:UnusedProperties|ongebruikt]].
Eigenschappen waar nog geen pagina voor is zijn te vinden op de [[Special:WantedProperties|lijst met gewenste eigenschappen]].",
	'uriresolver' => 'URI-resolver',
	'smw_uri_doc' => 'De URI-resolver implementeert de <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>. Het zorgt ervoor dat mensen niet veranderen in websites.',
	'ask' => 'Semantisch zoeken',
	'smw_ask_sortby' => 'Sorteren op kolom (optioneel)',
	'smw_ask_ascorder' => 'Oplopend',
	'smw_ask_descorder' => 'Aflopend',
	'smw_ask_submit' => 'Resultaten zoeken',
	'smw_ask_editquery' => '[zoekopdracht bewerken]',
	'smw_add_sortcondition' => '[sorteervoorwaarde toevoegen]',
	'smw_ask_hidequery' => 'Zoekopdracht verbergen',
	'smw_ask_help' => 'Hulp bij zoekopdrachten',
	'smw_ask_queryhead' => 'Zoekopdracht',
	'smw_ask_printhead' => 'Overige weer te geven gegevens',
	'smw_ask_printdesc' => '(voeg één eigenschapsnaam per regel toe)',
	'smw_ask_format_as' => 'Opmaken als:',
	'smw_ask_defaultformat' => 'standaard',
	'smw_ask_otheroptions' => 'Andere opties',
	'smw_ask_show_embed' => 'Ingesloten code weergeven',
	'smw_ask_hide_embed' => 'Ingesloten code verbergen',
	'smw_ask_embed_instr' => 'Gebruik de onderstaande code om deze zoekopdracht op te nemen in een wikipagina.',
	'searchbyproperty' => 'Zoek op eigenschap',
	'smw_sbv_docu' => "Zoek naar alle pagina's die een bepaalde eigenschap en waarde hebben.",
	'smw_sbv_novalue' => 'Voer een geldige waarde in voor de eigenschap, of bekijk alle waarden voor eigenschap “$1.”',
	'smw_sbv_displayresult' => "Een lijst met alle pagina's waarop eigenschap “$1” de waarde “$2” heeft",
	'smw_sbv_displayresultfuzzy' => 'Een lijst van alle pagina\'s met de eigenschap "$1" met waarde "$2".
Omdat er een beperkt aantal resultaten is, worden ook nabije waarden weergegeven.',
	'smw_sbv_property' => 'Eigenschap:',
	'smw_sbv_value' => 'Waarde:',
	'smw_sbv_submit' => 'Resultaten zoeken',
	'browse' => 'Wiki bekijken',
	'smw_browselink' => 'Eigenschappen bekijken',
	'smw_browse_article' => 'Voer de naam in van de pagina waar u met browsen wilt beginnen.',
	'smw_browse_go' => 'OK',
	'smw_browse_show_incoming' => 'eigenschappen weergeven die hierheen verwijzen',
	'smw_browse_hide_incoming' => 'eigenschappen verbergen die hierheen verwijzen',
	'smw_browse_no_outgoing' => 'Deze pagina heeft geen eigenschappen.',
	'smw_browse_no_incoming' => 'Er verwijzen geen eigenschappen naar deze pagina.',
	'smw_inverse_label_default' => '$1 van',
	'smw_inverse_label_property' => 'Tegenovergesteld eigenschapslabel',
	'pageproperty' => 'Eigenschap pagina zoeken',
	'smw_pp_docu' => 'Zoek naar alle fillers voor een eigenschap op een gegeven pagina.
Voer zowel een pagina als een eigenschap in.',
	'smw_pp_from' => 'Van pagina',
	'smw_pp_type' => 'Eigenschap',
	'smw_pp_submit' => 'Resultaten zoeken',
	'smw_result_prev' => 'Vorige',
	'smw_result_next' => 'Volgende',
	'smw_result_results' => 'Resultaten',
	'smw_result_noresults' => 'Geen resultaten.',
	'smwadmin' => 'Administratieve functies voor Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Opslag instellen voor Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'De opslag is ingesteld.',
	'smw_smwadmin_return' => 'Terug naar $1',
	'smw_smwadmin_updatestarted' => 'Er is een proces gestart voor het bijwerken van de semantische gegevens.
Alle opgeslagen gegevens worden opnieuw opgebouwd of gerepareerd als dat nodig is.
U kunt de voortgang volgen via deze speciale pagina.',
	'smw_smwadmin_updatenotstarted' => 'Er loopt al een bijwerkproces.
Er wordt geen nieuw proces gestart.',
	'smw_smwadmin_updatestopped' => 'Alle lopende bijwerkprocessen zijn afgebroken.',
	'smw_smwadmin_updatenotstopped' => 'Om de lopende processes te stoppen, moet u het vinkje inschakelen om aan te geven dat u het zeker weet.',
	'smw_smwadmin_docu' => 'Deze speciale pagina assisteert u tijdens de installatie en het bijwerken van <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Denk eraan een back-up te maken van uw waardevolle gegevens voordat u beheershandelingen uitvoert.',
	'smw_smwadmin_db' => 'Database installeren en bijwerken',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki heeft een aantal uitbreidingen aan de database van MediaWiki nodig om de semantische gegevens op te kunnen slaan.
De onderstaande functionaliteit zorgt ervoor dat uw database juist is ingesteld.
De wijzigingen die in deze stap worden gemaakt, hebben geen invloed op de bestaande database van MediaWiki, en zijn eventueel eenvoudig ongedaan te maken.
Deze instelfunctie kan meerdere keren worden uitgevoerd zonder schade aan te richten, hoewel het uiteraard slechts noodzakelijk is deze een keer uit te voeren per installatie of upgrade.',
	'smw_smwadmin_permissionswarn' => 'Als de handeling faalt met SQL-fouten, heeft de databasegebruiker van uw wiki (zie LocalSettings.php) waarschijnlijk onvoldoende rechten.
Geef deze gebruiker de benodigde extra rechten om tabellen aan te maken en te verwijderen, geef tijdelijk de aanmeldgegevens van de hoofdgebruiker van uw databasesysteem aan in LocalSettings.php, of gebruik het beheerscript <tt>SMW_setup.php</tt> dat de instellingen van AdminSettings.php kan gebruiken.',
	'smw_smwadmin_dbbutton' => 'Tabellen initialiseren of bijwerken',
	'smw_smwadmin_announce' => 'Uw wiki aankondigen',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki heeft een webservice voor het aankondigen van nieuwe semantische wikisites.
Deze dienst wordt gebruikt om een lijst bij te houden van publiek toegankelijke sites die Semantic MediaWiki gebruiken, voornamelijk om het <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki-project</a> inzicht te geven in het typische gebruik van Semantic MediaWiki.
Op de homepage van Semantic MediaWiki staat <a href="http://semantic-mediawiki.org/wiki/Registry">meer informatie over deze dienst</a>.',
	'smw_smwadmin_announcebutton' => "Klik op de knop om de URL van uw wiki naar de dienst te sturen.
De dienst registreert geen wiki's die niet publiek toegankelijk zijn en slaat alleen publiek toegankelijke informatie op.",
	'smw_smwadmin_datarefresh' => 'Gegevens repareren en bijwerken',
	'smw_smwadmin_datarefreshdocu' => 'Het is mogelijk om alle gegevens van Semantic MediaWiki opnieuw te genereren op basis van de huidige inhoud van de wiki.
Dit kan handig zijn om gegevens te repareren of de gegevens te verversen als de interne opmaak gewijzigd is bij een softwareupdate.
De gegevens worden pagina voor pagina bijgewerkt en het kan enige tijd duren voor de taak is afgerond.
Hieronder wordt weergegeven of er op dit moment een taak loopt en stelt u in staat een taak te stoppen of te starten (tenzij deze mogelijkheid door de sitebeheerder is uitgeschaked).',
	'smw_smwadmin_datarefreshprogress' => "<strong>Er loopt een bijwerktaak</strong>
Het is normaal dat de voortgang langzaam is omdat de gegevens ververst worden in kleine porties iedere keer als een gebruiker de wiki raadpleegt.
Om het bijwerken sneller te laten verlopen, kunt u het beheerscript <tt>runJobs.php</tt> draaien. Gebruik de optie <tt>--maxjobs 1000</tt> om aan het aantal bij te werken pagina's per handeling te beperken.
Geschatte voortgang van de huidige taak:",
	'smw_smwadmin_datarefreshbutton' => 'Gegevens bijwerken',
	'smw_smwadmin_datarefreshstop' => 'Bijwerken afbreken',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ja, ik weet het zeker.',
	'smw_smwadmin_support' => 'Ondersteuning krijgen',
	'smw_smwadmin_supportdocu' => 'Een aantal bronnen kunnen u ondersteunen als u problemen ondervindt:',
	'smw_smwadmin_installfile' => 'Als u problemen ondervindt bij uw installatie, controleer dan de richlijnen in het bestand <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'De volledige gebruikersdocumentatie voor Semantic MediaWiki is te vinden op <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Bugs en suggesties kunt u rapporteren in <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Als u verdere vragen of suggesties hebt, neem dan deel aan het overleg op het <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki gebruikersforum</a>.',
	'smw_adminlinks_datastructure' => 'Gegevensstructuur',
	'smw_adminlinks_displayingdata' => 'Gegevens weergeven',
	'smw_adminlinks_inlinequerieshelp' => 'Hulp bij inline zoekopdrachten',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Gunnernett
 * @author Harald Khan
 */
$messages['nn'] = array(
	'smw_edithelp' => 'Endringshjelp for eigenskapar',
	'smw_viewasrdf' => 'RDF-kjelda',
	'smw_finallistconjunct' => ' og',
	'smw_factbox_head' => 'Fakta om $1',
	'smw_isspecprop' => 'Denne eigenskapen er ein spesialeigenskap på denne wikien',
	'smw_isknowntype' => 'Denne datatypen er mellom standardtypane på denne wikien.',
	'smw_isaliastype' => 'Denne datatypen er den same som «$1».',
	'smw_isnotype' => 'Datatypen «$1» er ikkje ein standarddatatype på denne wikien og har heller ikkje blitt gjeven ein brukardefinsjon.',
	'smw_concept_description' => 'Skildring av konseptet «$1»',
	'smw_no_concept_namespace' => 'Konsept kan berre bli definerte frå sider i Concept:-namnerommet.',
	'smw_multiple_concepts' => 'Kvar konseptsida kan berre ha éin konseptdefinisjon.',
	'smw_concept_cache_miss' => 'Konseptet «$1» kan ikkje bli nytta for augneblinken, då wikikonfigurasjonen krev at det blir sett saman fråkopla.
Om problemet ikkje går vekk etter noko tid, be sideadministratoren om å gjera dette konseptet tilgjengleg.',
	'smw_baduri' => 'URI-ar på forma «$1» er ikkje tillatne.',
	'smw_printername_auto' => 'Automatisk',
	'smw_printername_count' => 'Tel opp resultata',
	'smw_printername_csv' => 'CSV eksport',
	'smw_printername_json' => 'JSON eksport',
	'smw_printername_list' => 'Liste',
	'smw_printername_ol' => 'Nummerering',
	'smw_printername_ul' => 'Objektisering',
	'smw_printername_rss' => 'RSS eksport',
	'smw_printername_table' => 'Tabell',
	'smw_printername_broadtable' => 'Brei tabell',
	'smw_printername_template' => 'Mal',
	'smw_iq_disabled' => 'Semantiske spørjingar har blitt slegne av på denne wikien.',
	'smw_iq_moreresults' => '… fleire resultat',
	'smw_iq_nojs' => 'Nytt ein nettlesar med støtta for JavaScript for å syna dette elementet.',
	'smw_iq_altresults' => 'Gå igjennom resultatlista direkte.',
	'smw_unknown_importns' => 'Importeringsfunksjonar er ikkje tilgjengelege for namnerommet «$1».',
	'smw_nonright_importtype' => '$1 kan berre bli nytta for sider i namnerommet «$2».',
	'smw_wrong_importtype' => '$1 kan ikkje bli nytta for sider i namnerommet «$2».',
	'smw_no_importelement' => 'Elementet «$1» er ikkje tilgjengeleg for importering.',
	'smw_parseerror' => 'Den gjevne verdien blei ikkje forstått.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '«$1» kan ikkje bli nytta som sidenamn på denne wikien.',
	'smw_wrong_namespace' => 'Berre sider i namnerommet «$1» er tillatne her.',
	'smw_unknowntype' => 'Typen «$1» som er definert for eigenskapen er ikkje støtta.',
	'smw_manytypes' => 'Meir enn éin type definert for eigenskapen.',
	'smw_emptystring' => 'Tomme strenger blir ikkje godtekne.',
	'smw_maxstring' => 'Strengerepresenteringa $1 er for lang.',
	'smw_notinenum' => '«$1» er ikkje i lista over moglege verdiar ($2) for denne eigenskapen.',
	'smw_noboolean' => '«$1» blir ikkje kjend att som ein Boolean-verdi (sant/usant).',
	'smw_true_words' => 'true,t,yes,y,ja,j,sant,s',
	'smw_false_words' => 'false,f,no,n,nei,usant,u',
	'smw_nofloat' => '«$1» er ikkje eit tal.',
	'smw_infinite' => 'Tal so store som «$1» er ikkje støtta.',
	'smw_infinite_unit' => 'Konvertering til eininga «$1» resulterte i eit tal som er for stort.',
	'smw_unsupportedprefix' => 'Prefiks for tal («$1») er ikkje støtta.',
	'smw_unsupportedunit' => 'Einingskonvertering for eininga «$1» er ikkje støtta.',
	'smw_nodatetime' => 'Datoen «$1» vart ikkje forstått.',
	'smw_toomanyclosing' => '«$1» finst for mange gonger i spørjinga.',
	'smw_noclosingbrackets' => 'Nokre klammar i spørjinga di («<nowiki>[[</nowiki>») vart ikkje lukka påfølgjande klammar («]]»).',
	'smw_misplacedsymbol' => 'Symbolet «$1» vart nytta på ein stad der det ikkje er gagnleg.',
	'smw_unexpectedpart' => '«$1»-delen av spørjinga var uforståeleg.
Resultata kan vera uventa.',
	'smw_emptysubquery' => 'Ei underspørjing har ikkje gyldige føresetnader.',
	'smw_misplacedsubquery' => 'Ei underspørjing vart nytta på ein stad der underspørjingar ikkje er tillatne.',
	'smw_valuesubquery' => 'Underspørjingar er ikkje støtta for verdiar av eigenskapen «$1».',
	'smw_overprintoutlimit' => 'Spørjinga inneheld for mange førespurnader om utskrifter.',
	'smw_badprintout' => 'Nokre utskriftuttrykk i spørjinga hadde ugyldig form.',
	'smw_badtitle' => '"$1" er ikkje ein gyldig sidetittel.',
	'smw_badqueryatom' => 'Ein lut («<nowiki>[[…]]</nowiki>») av spørjinga vart ikkje forstått.',
	'smw_propvalueproblem' => 'Verdien av eigenskapen «$1» vart ikkje forstått.',
	'smw_noqueryfeature' => 'Nokre spørjefunksjonar er ikkje støtta på denne wikien, og luter av spørjinga vart difor hoppa over ($1).',
	'smw_noconjunctions' => 'Konjunksjonar i spørjingar er ikkje støtta på denne wikien, og luter av spørjinga vart difor hoppa over ($1).',
	'smw_nodisjunctions' => 'Disjunksjonar i spørjingar er ikkje støtta på denne wikien, og luter av spørjinga vart difor hoppa over ($1).',
	'smw_querytoolarge' => 'Følgjande spørjeføresetnader kunne ikkje verta teke omsyn til grunna avgrensingane til wikien når det gjeld spørjestorleik eller djupn: $1',
	'smw_devel_warning' => 'Denn funksjonen er under utvikling og fungerer kanskje ikkje som han skal.
Ta ein kopi av dataa dine før du nyttar deg av han.',
	'smw_notemplategiven' => 'Oppgje ein verdi for parameteren «mal» for at dette spørjeformatet skal verka.',
	'smw_type_header' => 'Eigenskapar av typen «$1»',
	'smw_typearticlecount' => 'Syner {{PLURAL:$1|éin eigenskap|$1 eigenskapar}} som nyttar denne typen.',
	'smw_attribute_header' => 'Sider som nyttar eigenskapen «$1»',
	'smw_attributearticlecount' => 'Syner {{PLURAL:$1|éi sida|$1 sider}} som nyttar denne eigenskapen.',
	'smw_subproperty_header' => 'Undereigenskapar',
	'smw_subpropertyarticlecount' => 'Denne eigenskapen har følgjande {{PLURAL:$|undereigenskap|$1 undereigenskapar}}:',
	'smw_concept_header' => 'Sider av konseptet «$1»',
	'smw_conceptarticlecount' => 'Syner {{PLURAL:$1|éi sida|$1 sider}} som høyrer til konseptet.',
	'exportrdf' => 'Eksporter sider til RDF',
	'smw_exportrdf_docu' => 'Denne sida lèt deg skaffa data frå ei sida i RDF-format.
Skriv inn titlar i tekstboksten nedanfor for å eksportera sider, éin tittel per linja.',
	'smw_exportrdf_recursive' => 'Eksporter alle relaterte sider rekursivt.
Merk at resultatet kan vera stort.',
	'smw_exportrdf_backlinks' => 'Eksporter òg alle sider som refererer til dei eksporterte sidene.
Lagar ein RDF som ein kan gå gjennom.',
	'smw_exportrdf_lastdate' => 'Ikkje eksporter sider som ikkje blei endra sia oppgjeve tidspunkt.',
	'smw_exportrdf_submit' => 'Eksport',
	'properties' => 'Eigenskapar',
	'smw_properties_docu' => 'Følgjande eigenskapar er nytta på wikien.',
	'smw_property_template' => '$1 av typen $2 ($3)',
	'smw_propertylackspage' => 'Alle eigenskapar burde vore skildra av ei sida.',
	'smw_propertylackstype' => 'Ingen type blei oppgjeven for denne eigenskapen (reknar med at typen er $1 mellombels)',
	'smw_propertyhardlyused' => 'Denne eigenskapen blir knapt nytta på wikien!',
	'unusedproperties' => 'Unytta eigenskapar',
	'smw_unusedproperties_docu' => 'Dei følgjande eigenskpane finst, sjølv om ingen andre sider nyttar dei.',
	'smw_unusedproperty_template' => '$1 av typen $2',
	'wantedproperties' => 'Ynskte eigenskapar',
	'smw_wantedproperties_docu' => 'Dei følgjande eigenskapen er nytta på wikien, men har ikkje sider som skildrar dei.',
	'smw_wantedproperty_template' => '$1 (nytta {{PLURAL:$2|éin gong|$2 gonger}})',
	'tooltip-purge' => 'Trykk her for å oppfriska alle spørjingar og malar på denne sida',
	'smw_purge' => 'Oppfrisk',
	'types' => 'Typar',
	'smw_types_docu' => 'Fylgjande er ei lista over alle datatypar som eigenskapar kan ha.
Kvar datatype har ei sida der ekstra informasjon kan verta oppgjeven.',
	'smw_typeunits' => 'Måleiningar av typen «$1»: $2',
	'semanticstatistics' => 'Semantisk statistikk',
	'smw_semstats_text' => "Denne wikien inneheld <b>$1</b> {{PLURAL:$1|eigenskapsverdi|eigenskapsverdiar}} for totalt <b>$2</b> [[Special:Properties|{{PLURAL:$2|eigenskap|eigenskapar}}]].
'''$3''' {{PLURAL:$3|eigenskap|eigenskapar}} har ei eiga sida, og den meinte datatypen er oppgjeven for <b>$4</b> av desse.
Somme av dei eksisterande eigenskapane kan vera [[Special:UnusedProperties|unytta eigenskapar]].
Eigenskapar som framleis ikkje har ei eiga sida finst på [[Special:WantedProperties|lista over ynskte eigenskapar]].",
	'uriresolver' => 'URI-løysar',
	'smw_uri_doc' => "URI-løysaren implementerer ''<a href=\"http://www.w3.org/2001/tag/issues.html#httpRange-14\">finning av W3C TAG-ar på «httpRange-14»</a>''.
Han syter for at menneske ikkje vert til nettsider.",
	'ask' => 'Semantisk søk',
	'smw_ask_sortby' => 'Sorter etter kolonne (valfritt)',
	'smw_ask_ascorder' => 'Stigande',
	'smw_ask_descorder' => 'Søkkjande',
	'smw_ask_submit' => 'Finn resultat',
	'smw_ask_editquery' => '[Brigd spørjing]',
	'smw_add_sortcondition' => '[Legg til sorteringsføresetnader]',
	'smw_ask_hidequery' => 'Løyn spørjing',
	'smw_ask_help' => 'Spørjehjelp',
	'smw_ask_queryhead' => 'Spørjing',
	'smw_ask_printhead' => 'Ekstra utskrifter (valfritt)',
	'smw_ask_format_as' => 'Formatér som:',
	'smw_ask_defaultformat' => 'standard',
	'searchbyproperty' => 'Søk etter eigenskap',
	'smw_sbv_docu' => 'Søk etter alle sider som har ein viss eigenskap og verdi.',
	'smw_sbv_novalue' => 'Skriv inn ein gyldig verdi for eigenskapen, eller sjå alle eigenskapsverdiar for «$1».',
	'smw_sbv_displayresult' => 'Ei lista over alle sider som har eigenskapen «$1» med verdien «$2»',
	'smw_sbv_displayresultfuzzy' => 'Ei lista over alle sider som har eigenskapen «$1» med verdien «$2».
Sidan det berre kom fram nokre få resultat er òg nære verdiar viste.',
	'smw_sbv_property' => 'Eigenskap:',
	'smw_sbv_value' => 'Verdi:',
	'smw_sbv_submit' => 'Finn resultat',
	'browse' => 'Bla gjennom wikien',
	'smw_browselink' => 'Bla gjennom eigenskapar',
	'smw_browse_article' => 'Skriv inn namnet på sida du vil starta å bla frå.',
	'smw_browse_go' => 'Gå',
	'smw_browse_show_incoming' => 'syn eigenskapar som lenkjar hit',
	'smw_browse_hide_incoming' => 'løyn eigenskapar som lenkjar hit',
	'smw_browse_no_outgoing' => 'Denne sida har ingen eigenskapar.',
	'smw_browse_no_incoming' => 'Ingen eigenskapar lenkjar til denne sida.',
	'smw_inverse_label_default' => '$1 av',
	'smw_inverse_label_property' => 'Vrengd eigenskapsmerke',
	'pageproperty' => 'Sideeigenskapssøk',
	'smw_pp_docu' => 'Søk etter all eigenskapstekst på ei viss side.
Skriv inn både sidenamn og eigenskap.',
	'smw_pp_from' => 'Frå side',
	'smw_pp_type' => 'Eigenskap',
	'smw_pp_submit' => 'Finn resultat',
	'smw_result_prev' => 'Førre',
	'smw_result_next' => 'Neste',
	'smw_result_results' => 'Resultat',
	'smw_result_noresults' => 'Fann ingen resultat.',
	'smwadmin' => 'Administratorfunksjonar for Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Set opp lagringsplass for Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Lagringseininga blei sett opp.',
	'smw_smwadmin_return' => 'Attende til $1',
	'smw_smwadmin_updatestarted' => 'Ein ny oppdateringsprosses for å oppfriska dei semantiske dataa blei starta.
Alle lagra data vil bygt om eller reparert der det trengst.
Du kan fylgja med på framgangen til oppdateringa på denne spesialsida.',
	'smw_smwadmin_updatenotstarted' => 'Ein oppdateringsprosses køyrer frå før.
Startar ikkje ein ny ein.',
	'smw_smwadmin_updatestopped' => 'Alle eksisterande oppdateringsprosessar har blitt stoppa.',
	'smw_smwadmin_updatenotstopped' => 'For å stoppa oppdateringsprosessen som køyrer, må du markera boksen for å syna at du verkeleg meiner det.',
	'smw_smwadmin_docu' => 'Denne spesialsida hjelper deg under installering og oppgradering av <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Hugs å ta kopiar av viktige data før du køyrer administrerande funksjonar.',
	'smw_smwadmin_db' => 'Databaseinnstallering og -oppgradering',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki krev nokre utvidingar i MediaWiki-databasen for å kunna lagra semantiske data.
Funksjonen under syter for at databasen din er sett opp rett.
Endringar gjort i dette steget har ikkje nokon effekt på resten av MediaWiki-databasen og kan enkelt bli attenderulla om det skulle vera ynskjeleg.
Denne oppsettsfunksjonen kan bli køyrt fleire gongen utan at ein gjer noko skade, men han trengst berre éin gong under installering eller oppgradering.',
	'smw_smwadmin_permissionswarn' => 'Om operasjonen mislukkast med SQL-feil, har sannsynlegvis ikkje databasebrukaren nytta av wikien din dei rette løyva (sjekk LocalSettings.php).
Anten gje denne brukaren dei rette løyva til å oppretta og sletta tabellar og mellombels skriv inn innloggingsinformasjonen til database-rooten din i LocalSettings.php, eller køyr vedlikehaldsskriptet <tt>SMW_setup.php</tt> som kan nytta løyva til AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Set i verk eller oppgrader tabellar',
	'smw_smwadmin_announce' => 'Kunngjer wikien din',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki har ei nettenesta for å kunngjera nye semantiske wikisider.
Dette er gjort for å vedlikehalda ei lista over offentlege sider som nyttar Semantic MediaWiki, hovudsakleg for å hjelpa <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki-prosjektet</a> med å få eit oversyn over typiske nytteområde av Semantic MediaWiki.
Sjå heimesida til Semantic MediaWiki for <a href="http://semantic-mediawiki.org/wiki/Registry">meir informasjon om denne tenesta</a>.',
	'smw_smwadmin_announcebutton' => 'Trykk den fylgjande knappen for å gje wikiadressa di til tenesta.
Tenesta vil ikkje registrera wikiar som ikkje er opne offentleg, og ho vil berre lagra informasjon som er offentleg tilgjengeleg.',
	'smw_smwadmin_datarefresh' => 'Datareparasjon eller -oppgradering',
	'smw_smwadmin_datarefreshdocu' => 'Det er mogleg å få attende alle Semantic MediaWiki-dataa basert på det noverande innahaldet til wikien.
Dette kan vera nyttig for å reparera øydelagde data eller for å oppfriska dataa om det interne formatet har blitt endra grunna programvareoppdatering.
Oppdateringa blir utført sida for sida og vil ikkje vera ferdig med ein gong.
Det fylgjande syner om ei oppdatering er på gong og lèt deg byrja eller stoppa oppdateringar (viss ikkje denne moglegheita er deaktivert av sideadministratoren).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Ei oppdatering held allereie på.</strong>
Det er normalt at oppdateringa går sakte då ho berre oppfriskar data i små bitar kvar gong ein brukar er innom wikien.
For å fullføra denne oppdateringa på ein kjappare måte, kan du setja i gang MediaWiki-vedlikehaldsskriptet <tt>runJobs.php</tt> (nytt valet <tt>--maxjobs 1000</tt> for å avgrensa talet på oppdetaringar som blir gjort i eitt stykke).
Estimert framdrift på den noverande oppdateringa:',
	'smw_smwadmin_datarefreshbutton' => 'Start oppdatering',
	'smw_smwadmin_datarefreshstop' => 'Stopp denne oppdateringa',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ja, eg er sikker.',
	'smw_smwadmin_support' => 'Får støtta',
	'smw_smwadmin_supportdocu' => 'Diverse ressursar kan kanskje hjelpa deg om du skulle få problem:',
	'smw_smwadmin_installfile' => 'Om du møter på problem under installeringa, start med å studera retningslinene i <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL-fila</a>.',
	'smw_smwadmin_smwhomepage' => 'Den komplette brukardokumentasjonen for Semantic MediaWiki finn du på <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Feil kan bli rapporterte til <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Om du har fleire spørsmål eller forslag, bli med i diskusjonen på <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki-brukarforumet</a>.',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Audun
 * @author Harald Khan
 * @author Jon Harald Søby
 * @author Laaknor
 * @author Nghtwlkr
 */
$messages['no'] = array(
	'smw-desc' => "Gjøre wikien din mer tilgjengelig - for maskiner ''og'' mennesker ([http://semantic-mediawiki.org/wiki/Help:User_manual online documentation])",
	'smw_edithelp' => 'Redigeringshjelp for egenskaper',
	'smw_viewasrdf' => 'RDF-kilde',
	'smw_finallistconjunct' => ' og',
	'smw_factbox_head' => 'Fakta om $1',
	'smw_isspecprop' => 'Denne egenskapen er en spesialegenskap på denne wikien.',
	'smw_isknowntype' => 'Denne datatypen er blant standardtypene på denne wikien.',
	'smw_isaliastype' => 'Denne datatypen er et alias for typen «$1».',
	'smw_isnotype' => 'Datatypen «$1» er ikke en standardtype på denne wikien, og har ikke blitt gitt en brukerdefinsjon.',
	'smw_concept_description' => 'Beskrivelse av konseptet «$1»',
	'smw_no_concept_namespace' => 'Konsepter kan kun defineres på sider i Concept:-navnerommet.',
	'smw_multiple_concepts' => 'Hver konseptside kan kun ha én konseptdefinisjon.',
	'smw_concept_cache_miss' => 'Konseptet "$1" kan ikke brukes for øyeblikket da wikiens konfigurasjon krever at den blir satt opp frakoplet.
Hvis problemet ikke forsvinner etter en periode, spør sidens administratorer om å gjøre konseptet tilgjengelig.',
	'smw_baduri' => 'Beklager, URI-er på formen «$1» er ikke tillatt.',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automatisk',
	'smw_printername_count' => 'Tell opp resultat',
	'smw_printername_csv' => 'CSV-eksport',
	'smw_printername_debug' => 'Feilsøkspørring (for eksperter)',
	'smw_printername_embedded' => 'Innkapselert sideinnhold',
	'smw_printername_json' => 'JSON eksport',
	'smw_printername_list' => 'Liste',
	'smw_printername_ol' => 'Nummerering',
	'smw_printername_ul' => 'Objektsering',
	'smw_printername_rss' => 'RSS eksport',
	'smw_printername_table' => 'Tabell',
	'smw_printername_broadtable' => 'Bred tabell',
	'smw_printername_template' => 'Mal',
	'smw_paramdesc_limit' => 'Maksimalt antall resultat som skal returneres',
	'smw_paramdesc_link' => 'Vis verdier som lenker',
	'smw_paramdesc_intro' => 'Tekst som skal vises før spørringsresultat, dersom det er noen',
	'smw_paramdesc_outro' => 'Tekst som skal vises etter spørringsresultat, dersom det er noen',
	'smw_paramdesc_default' => 'Tekst som skal vises dersom det ikke er noen resultat for spørringen',
	'smw_paramdesc_searchlabel' => 'Tekst i lenken til resultat',
	'smw_paramdesc_sep' => 'Separatorverdier',
	'smw_paramdesc_template' => 'Navnet på malen som skal vise frem utskriftene',
	'smw_paramdesc_columns' => 'Antall kolonner som resultatene skal vises i (standard er $1)',
	'smw_paramdesc_rsstitle' => 'Tekst som skal brukes som tittel på matingen',
	'smw_paramdesc_rssdescription' => 'Tekst som skal brukes som beskrivelse av matingen',
	'smw_iq_disabled' => 'Beklager. Semantiske spørringer er slått av på denne wikien.',
	'smw_iq_moreresults' => '… flere resultater',
	'smw_iq_nojs' => 'Bruk en nettleser med JavaScript-støtte for å vise dette elementet.',
	'smw_iq_altresults' => 'Gå gjennom resultatlisten direkte.',
	'smw_unknown_importns' => 'Importeringsfunksjoner er ikke tilgjengelige for navnerommet «$1».',
	'smw_nonright_importtype' => '$1 kan kun brukes for sider i navnerommet «$2».',
	'smw_wrong_importtype' => '$1 kan ikke brukes for sider i navnerommet «$2».',
	'smw_no_importelement' => 'Elementet «$1» er ikke tilgjengelig for importering.',
	'smw_parseerror' => 'Den gitte verdien ble ikke forstått.',
	'smw_notitle' => '«$1» kan ikke brukes som sidenavn på denne wikien.',
	'smw_wrong_namespace' => 'Kun sider i navnerommet «$1» er tillatte her.',
	'smw_unknowntype' => 'Typen «$1» som er definert for egenskapen støttes ikke.',
	'smw_manytypes' => 'Mer enn én type definert for egenskapen.',
	'smw_emptystring' => 'Tomme strenger godtas ikke.',
	'smw_maxstring' => 'Strengrepresentasjonen $1 er for lang.',
	'smw_notinenum' => '«$1» er ikke i listen over mulige verdier ($2) for denne egenskapen.',
	'smw_noboolean' => '«$1» gjenkjennes ikke som en Boolean-verdi (true/false).',
	'smw_true_words' => 'true,t,yes,y,ja,j,sant,s',
	'smw_false_words' => 'false,f,no,n,nei,usant,u',
	'smw_nofloat' => '«$1» er ikke et tall.',
	'smw_infinite' => 'Tall så store som «$1» støttes ikke.',
	'smw_infinite_unit' => 'Konvertering til enheten «$1» resulterte i et tall som er for stort.',
	'smw_novalues' => 'Ingen verdier angitt.',
	'smw_unsupportedprefix' => 'Prefiks for tall («$1») støttes ikke.',
	'smw_unsupportedunit' => 'Enhetskonvertering for enheten «$1» støttes ikke.',
	'smw_nodatetime' => 'Datoen «$1» ble ikke forstått.',
	'smw_toomanyclosing' => '«$1» opptrer for mange ganger i spørringen.',
	'smw_noclosingbrackets' => 'Bruken av «<nowiki>[[</nowiki>» i spørringen din ble ikke stengt av «]]».',
	'smw_misplacedsymbol' => 'Symbolet «$1» ble brukt på et sted hvor det ikke er nyttig.',
	'smw_unexpectedpart' => '«$1»-delen av spørringen var uforståelig.
Resultatene kan være uventede.',
	'smw_emptysubquery' => 'En underspørring har ingen gyldige betingelser.',
	'smw_misplacedsubquery' => 'En underspørring ble brukt på et sted hvor underspørringer ikke tillates.',
	'smw_valuesubquery' => 'Underspørringer støttes ikke for verdier av egenskapen «$1».',
	'smw_overprintoutlimit' => 'Spørringen inneholder for mange skriveforespørsler.',
	'smw_badprintout' => 'Noen skriveuttrykk i spørringen hadde ugyldig form.',
	'smw_badtitle' => 'Beklager, «$1» er ikke en gyldig sidetittel.',
	'smw_badqueryatom' => 'En del («<nowiki>[[…]]</nowiki>») av spørringen ble ikke forstått.',
	'smw_propvalueproblem' => 'Verdien av egenskapen «$1» ble ikke forstått.',
	'smw_noqueryfeature' => 'Noen spørringsfunksjoner ble ikke støttet i denne wikien, og deler av spørringen ble hoppet over ($1).',
	'smw_noconjunctions' => 'Konjunksjoner i spørringer støttes ikke i denne wikien, og deler av spørringen ble hoppet over ($1).',
	'smw_nodisjunctions' => 'Disjunksjoner i spørringer støttes ikke på denne wikien, og deler av spøringen ble utelatt ($1).',
	'smw_querytoolarge' => 'Følgende spørringsbetingelser kunne ikke tas til hensyn på grunn av wikiens begrensninger i spørringsstørrelse eller dybde: $1',
	'smw_devel_warning' => 'Denne funksjonen er under utvikling, og fungerer muligens ikke som den skal.
Ta en kopi av dataene før du bruker den.',
	'smw_notemplategiven' => 'Oppgi en verdi for parameteret «mal» for at dette spørringsformatet skal fungere.',
	'smw_type_header' => 'Egenskaper av typen «$1»',
	'smw_typearticlecount' => 'Viser {{PLURAL:$1|én egenskap|$1 egenskaper}} som bruker denne typen.',
	'smw_attribute_header' => 'Sider som bruker egenskapen «$1»',
	'smw_attributearticlecount' => 'Viser {{PLURAL:$1|én side|$1 sider}} som bruker denne egenskapen.',
	'smw_subproperty_header' => 'Underegenskaper',
	'smw_subpropertyarticlecount' => 'Denne egenskapen har følgende {{PLURAL:$|underegenskap|$1 underegenskaper}}:',
	'smw_concept_header' => 'Sider av konseptet «$1»',
	'smw_conceptarticlecount' => 'Viser {{PLURAL:$1|én side|$1 sider}} som hører til det konseptet.',
	'exportrdf' => 'Eksporter sider til RDF',
	'smw_exportrdf_docu' => 'Denne siden lar deg skaffe data fra en side i RDF-format.
Skriv inn titler i tekstboksten nedenfor for å eksportere sider, én tittel per linje.',
	'smw_exportrdf_recursive' => 'Eksporter alle relaterte sider rekursivt.
Merk at resultatet kan være stort.',
	'smw_exportrdf_backlinks' => 'Eksporter også alle sider som refererer til de eksporterte sidene.
Lager en RDF som kan gås gjennom.',
	'smw_exportrdf_lastdate' => 'Ikke eksporter sider som ikke ble endret siden gitte tidspunkt.',
	'smw_exportrdf_submit' => 'Eksporter',
	'properties' => 'Egenskaper',
	'smw_properties_docu' => 'Følgende egenskaper brukes på wikien.',
	'smw_property_template' => '$1 av type $2 ($3)',
	'smw_propertylackspage' => 'Alle egenskaper burde beskrives av en side.',
	'smw_propertylackstype' => 'Ingen type ble oppgitt for denne egenskapen (antar at typen er $1 foreløpig).',
	'smw_propertyhardlyused' => 'Denne egenskapen brukes nesten ikke på wikien.',
	'unusedproperties' => 'Ubrukte egenskaper',
	'smw_unusedproperties_docu' => 'Følgende egenskaper finnes, selv om ingen andre sider bruker dem.',
	'smw_unusedproperty_template' => '$1 av type $2',
	'wantedproperties' => 'Ønskede egenskaper',
	'smw_wantedproperties_docu' => 'Følgende egenskaper brukes på wikien, men har ikke en side med forklaring.',
	'smw_wantedproperty_template' => '$1 (brukt {{PLURAL:$2|én gang|$2 ganger}})',
	'tooltip-purge' => 'Klikk her for å gjenoppfriske alle spørringer og maler på denne siden',
	'smw_purge' => 'Gjenoppfrisk',
	'types' => 'Typer',
	'smw_types_docu' => 'Følgende er en liste over alle datatyper som egenskaper kan ha.
Hver datatype har en side der ekstra informasjon kan oppgis.',
	'smw_typeunits' => 'Måleenheter av typen «$1»: $2',
	'semanticstatistics' => 'Semantisk statistikk',
	'smw_semstats_text' => "Denne wikien inneholder {{PLURAL:$1|'''én''' egenskapsverdi|'''$1''' egenskapsverdier}} for totalt [[Special:Properties|{{PLURAL:$2|'''én''' egenskap|'''$2''' forskjellige egenskaper}}]].
{{PLURAL:$3|'''Én''' egenskap|'''$3''' egenskaper}} har en egen side, og den mente datatypen er spesifisert for '''$4''' av disse.
Enkelte av de eksisterende egenskapene kan være [[Special:UnusedProperties|ubrukte egenskaper]].
Egenskaper som fortsatt mangler en egen side finnes på [[Special:WantedProperties|listen over ønskede egenskaper]].",
	'uriresolver' => 'URI-løser',
	'smw_uri_doc' => 'URI-løseren implementerer <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">finning av W3C TAG-er på «httpRange-14»</a>.
Den sørger for at mennesker ikke blir til nettsteder.',
	'ask' => 'Semantisk søk',
	'smw_ask_sortby' => 'Sorter etter kolonne (valgfritt)',
	'smw_ask_ascorder' => 'Stigende',
	'smw_ask_descorder' => 'Synkende',
	'smw_ask_submit' => 'Finn resultater',
	'smw_ask_editquery' => '[Rediger spørring]',
	'smw_add_sortcondition' => '[Legg til sorteringsbetingelse]',
	'smw_ask_hidequery' => 'Skjul spørring',
	'smw_ask_help' => 'Spørringshjelp',
	'smw_ask_queryhead' => 'Spørring',
	'smw_ask_printhead' => 'Tilleggsdata kan vises',
	'smw_ask_printdesc' => '(legg til et egenskapsnavn per linje)',
	'smw_ask_format_as' => 'Formater som:',
	'smw_ask_defaultformat' => 'standard',
	'smw_ask_otheroptions' => 'Andre alternativ',
	'smw_ask_show_embed' => 'Vis innkapslet kode',
	'smw_ask_hide_embed' => 'Skjul innkapslet kode',
	'searchbyproperty' => 'Søk etter egenskap',
	'smw_sbv_docu' => 'Søk etter alle sider som har en gitt egenskap og verdi.',
	'smw_sbv_novalue' => 'Skriv inn en gyldig verdi for egenskapen, eller vis alle egenskapsverdier for «$1».',
	'smw_sbv_displayresult' => 'En liste over alle sider som har egenskapen «$1» med verdien «$2»',
	'smw_sbv_displayresultfuzzy' => 'En liste over alle sider som har egenskapen «$1» med verdien «$2».
Siden det bare ble noen få resultater, vises også nære verdier.',
	'smw_sbv_property' => 'Egenskap:',
	'smw_sbv_value' => 'Verdi:',
	'smw_sbv_submit' => 'Finn resultater',
	'browse' => 'Bla gjennom wikien',
	'smw_browselink' => 'Bla gjennom egenskaper',
	'smw_browse_article' => 'Skriv inn navnet på siden du vil starte å bla fra.',
	'smw_browse_go' => 'Gå',
	'smw_browse_show_incoming' => 'vis egenskaper som lenker hit',
	'smw_browse_hide_incoming' => 'gjem egenskaper som lenker hit',
	'smw_browse_no_outgoing' => 'Denne siden har ingen egenskaper.',
	'smw_browse_no_incoming' => 'Ingen egenskaper lenker til denne siden.',
	'smw_inverse_label_default' => '$1 av',
	'smw_inverse_label_property' => 'Invers egenskapmerkelapp',
	'pageproperty' => 'Sideegenskapsøk',
	'smw_pp_docu' => 'Søk etter all egenskapstekst på en gitt side.
Skriv inn både sidenavn og egenskap.',
	'smw_pp_from' => 'Fra side',
	'smw_pp_type' => 'Egenskap',
	'smw_pp_submit' => 'Finn resultater',
	'smw_result_prev' => 'Forrige',
	'smw_result_next' => 'Neste',
	'smw_result_results' => 'Resultater',
	'smw_result_noresults' => 'Beklager, ingen resultater',
	'smwadmin' => 'Administratorfunksjoner for Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Setter opp lagringsplass for Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Lagringsmotoren ble satt upp.',
	'smw_smwadmin_return' => 'Gå tilbake til $1',
	'smw_smwadmin_updatestarted' => 'En ny oppdateringsprosess for oppfriskning av de semantiske dataene ble startet.
Alle lagrede data vil bli bygd på nytt eller reparert der det trengs.
Du kan følge med på fremgangen til oppdateringen på denne spesialsiden.',
	'smw_smwadmin_updatenotstarted' => 'Det kjører allerede en oppdateringsprosess.
Starter ikke en ny en.',
	'smw_smwadmin_updatestopped' => 'Alle eksisterende oppdateringsprosesser har blitt stoppet.',
	'smw_smwadmin_updatenotstopped' => 'For å stoppe den kjørende oppdateringsprosessen må du markere boksen for å vise at du er helt sikker.',
	'smw_smwadmin_docu' => 'Denne spesialsiden hjelper deg under innstallasjon og oppgradering av <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Husk å ta sikkerhetskopier av viktige data før du starter administrerende funksjoner.',
	'smw_smwadmin_db' => 'Databaseinnstallasjon og -oppgradering',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki krever noen utvidelser i MediaWiki-databasen for å kunne lagre semantiske data.
Funksjonen uner sikrer at databasen din blir satt opp riktig.
Endringene gjort i dette steget har ingen effekt på resten av MediaWiki-databasen og kan enkelt gjøres om om ønskelig.
Denne oppsettsfunksjonen kan bli kjørt flere ganger uten skadevirkning, men den trenger kun kjøres en gang ved installasjon eller oppgradering.',
	'smw_smwadmin_permissionswarn' => 'Dersom operasjonen mislykkes med SQL-feil, har sannsynligvis ikke databasebrukeren brukt av din wiki tilstrekkelige rettigheter (sjekk LocalSettings.php).
Enten gi denne brukeren de riktige rettighetene til å opprette og slette tabeller, midlertidig skriv inn innloggingsinformasjonen til database-roten i LocalSettings.php eller bruk vedlikeholdsskriptet <tt>SMW_setup.php</tt> som kan bruke rettighetene til AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Initialiser eller oppgrader tabeller',
	'smw_smwadmin_announce' => 'Kunngjør din wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki har en nettjeneste for kunngjøring av nye semantiske wikisider.
Dette er brukt for å opprettholde en liste over offentlige nettsteder som bruker Semantic MediaWiki, hovedsaklig for å hjelpe <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki</a> med å få et overblikk over typiske bruksområder av Semantic MediaWiki.
Se hjemmesiden til Semantic MediaWiki for <a href="http://semantic-mediawiki.org/wiki/Registry">mer informasjon om denne tjenesten</a>.',
	'smw_smwadmin_announcebutton' => 'Trykk på følgende knapp for å oppgi din wikis URL til den tjenesten.
Tjenesten vil ikke registrere wikier som ikke er offentlig tilgjengelig, og den vil bare lagre offentlig tilgjengelig informasjon.',
	'smw_smwadmin_datarefresh' => 'Datareparasjon og -oppgradering',
	'smw_smwadmin_datarefreshdocu' => 'Det er mulig å gjenopprette all Semantic MediaWiki-data basert på det nåværende innholdet på wikien.
Dette kan være nyttig for å reparere ødelagt data eller for å oppfriske data hvis det interne formatet har blitt endret på grunn av programvareoppdateringer.
Oppdateringen blir utført side for side og vil ikke bli fullført umiddelbart.
Det følgende viser om en oppdatering er i gang og lar deg starte eller stoppe oppdateringer (ved mindre denne muligheten er gjort utilgjengelig av sidens administratorer).',
	'smw_smwadmin_datarefreshprogress' => '<strong>En oppdatering er allerede i gang.</strong>
Det er normalt at oppdateringen går tregt fremover siden den bare oppdaterer data i små biter hver gang en bruker besøker wikien.
For å fullføre denne oppdateringen raskere kan du starte MediaWiki vedlikeholdsskriptet <tt>runJobs.php</tt> (bruk valget <tt>--maxjobs 1000</tt> for å avgrense antallet oppdateringer som kan gjøres samtidig).
Anslått fremdrift for gjeldende oppdatering:',
	'smw_smwadmin_datarefreshbutton' => 'Start oppdatering av data',
	'smw_smwadmin_datarefreshstop' => 'Stopp denne oppdateringen',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ja, jeg er sikker.',
	'smw_smwadmin_support' => 'Få støtte',
	'smw_smwadmin_supportdocu' => 'Forskjellige ressurser kan kanskje hjelpe deg om du skulle ha problemer:',
	'smw_smwadmin_installfile' => 'Hvis du opplever problemer med installasjonen, start med å sjekke retningslinjene i <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL-filen</a>.',
	'smw_smwadmin_smwhomepage' => 'Den komplette brukerdokumentasjonen til Semantic MediaWiki finnes på <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Feil kan bli rapportert til <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Hvis du har ytterligere spørsmål eller forslag, bli med i diskusjonen på <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki brukerforum</a>.',
	'smw_adminlinks_datastructure' => 'Datastruktur',
	'smw_adminlinks_displayingdata' => 'Viser data',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'smw-desc' => "Rendre lo wiki mai accessible - per las maquinas ''e'' los umans ([http://semantic-mediawiki.org/wiki/Help:User_manual documentacion en linha])",
	'smw_edithelp' => "Ajuda a la redaccion de relacions e d'atributs",
	'smw_viewasrdf' => 'Veire coma RDF',
	'smw_finallistconjunct' => ' e',
	'smw_factbox_head' => 'Faches relatius a $1 &mdash; Recèrca de paginas similaras amb <span class="smwsearchicon">+</span>.',
	'smw_isspecprop' => 'Aquesta proprietat es una proprietat especiala sus aqueste wiki.',
	'smw_isknowntype' => "Aqueste tipe fa partida dels tipes de donadas estandards d'aqueste wiki.",
	'smw_isaliastype' => 'Aqueste tipe es un aliàs del tipe de donadas “$1”.',
	'smw_isnotype' => 'Lo tipe “$1” es pas un tipe de donadas estandard sus aqueste wiki, e tanpauc es pas estat definit per un utilizaire.',
	'smw_concept_description' => 'Descripcion del concèpte « $1 »',
	'smw_no_concept_namespace' => 'Los concèptes pòt unicament èsser definits dins la pagina dins lo Concèpte : espaci de nom.',
	'smw_multiple_concepts' => 'Cada pagina de concèpte pòt pas aver qu’una sola definicion.',
	'smw_concept_cache_miss' => 'Lo concèpte « $1 » pòt pas èsser utilizat pel moment, perque la configuracion del wiki requerís que siá aviat fòra linha. Se lo problèma persistís aprèp qualques instants, demandatz a vòstre administrator del site de rendre disponible aqueste concèpte.',
	'smw_noinvannot' => 'Las valors pòdon pas èsser allogadas per inversar de proprietats.',
	'smw_baduri' => 'O planhèm. Las URIs del domeni $1 son pas disponiblas a aqueste emplaçament',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automatic',
	'smw_printername_count' => 'Comptatge dels resultats',
	'smw_printername_csv' => 'expòrt en CSV',
	'smw_printername_debug' => 'Requèste de debogatge (pels expèrts)',
	'smw_printername_embedded' => 'Contengut de las paginas incrustadas',
	'smw_printername_json' => 'expòrt en JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumeracion',
	'smw_printername_ul' => 'Detalh',
	'smw_printername_rss' => 'expòrt en RSS',
	'smw_printername_table' => 'Tablèu',
	'smw_printername_broadtable' => 'Taula larga',
	'smw_printername_template' => 'Modèl',
	'smw_iq_disabled' => "O planhèm. Las recèrcas dins los articles d'aqueste wiki son pas autorizadas.",
	'smw_iq_moreresults' => '… autres resultats',
	'smw_iq_nojs' => 'Utilizatz un navigador amb JavaScript per veire aqueste element.',
	'smw_iq_altresults' => 'Percórrer dirèctament la lista dels resultats.',
	'smw_unknown_importns' => 'Cap de foncion d\'impòrt es pas disponible per l\'espaci de nomenatge "$1".',
	'smw_nonright_importtype' => 'L\'element "$1" pòt pas èsser emplegat que per d\'articles de l\'espaci de nomenatge "$2".',
	'smw_wrong_importtype' => 'L\'element "$1" pòt pas èsser emplegat que per d\'articles de l\'espaci de nomenatge domeni "$2".',
	'smw_no_importelement' => 'L\'element "$1" es pas disponible per l\'importacion.',
	'smw_parseerror' => 'La donada indicada es pas estada compresa.',
	'smw_kiloseparator' => ',',
	'smw_notitle' => '“$1” pòt pas èsser utilizat coma nom de pagina sus aqueste wiki.',
	'smw_wrong_namespace' => "Solas las paginas de l'espaci de noms « $1 » son autorizadas aicí.",
	'smw_unknowntype' => 'Lo tipe de donadas "$1" pas suportat es estat tornat a l\'atribut.',
	'smw_manytypes' => "Maites tipes de donadas son estats assignats a l'atribut.",
	'smw_emptystring' => 'Las cadenas voidas son pas acceptadas.',
	'smw_maxstring' => 'La cadena de representacion $1 es tròp granda.',
	'smw_notinenum' => '\\"$1\\" fa pas partida de las valors possiblas ($2) per aqueste atribut.',
	'smw_noboolean' => '\\"$1\\" es pas reconegut coma una valor boleana (verai/fals).',
	'smw_true_words' => 'verai,v,òc,true',
	'smw_false_words' => 'fals,f,non,false',
	'smw_nofloat' => '"$1" es pas un nombre.',
	'smw_infinite' => 'Los nombres tant grands coma « $1 » son pas suportats.',
	'smw_infinite_unit' => "La conversion dins l'unitat « $1 » a balhat un nombre tròp grand.",
	'smw_unsupportedprefix' => 'De prefixes ("$1") son pas suportats actualament',
	'smw_unsupportedunit' => 'La conversion de l\'unitat "$1" es pas suportada',
	'smw_nodatetime' => 'La data "$1" es pas estada compresa.',
	'smw_toomanyclosing' => "Sembla que i a tròp d'ocuréncias de “$1” dins la requèsta.",
	'smw_noclosingbrackets' => "D'unes “<nowiki>[[</nowiki>” dins vòstra requèsta son pas estats clauses per de “]]” correspondents.",
	'smw_misplacedsymbol' => 'Lo simbòl “$1” es estat utilizat a un endrech ont es pas util.',
	'smw_unexpectedpart' => 'La partida “$1” de la requèsta es pas estada compresa. Los resultats pòdon èsser imprevists.',
	'smw_emptysubquery' => "D'unas sosrequèstas an una condicion invalida.",
	'smw_misplacedsubquery' => "D'unas sosrequèstas son estadas utilizadas a un endrech ont cap de sosrequèsta es pas permesa.",
	'smw_valuesubquery' => 'Sosrequèsta pas suportada per las valors de la proprietat “$1”.',
	'smw_overprintoutlimit' => "La requèsta conten tròp d'instruccions de formatatge.",
	'smw_badprintout' => "D'unas instruccions de formatatge dins la requèsta son pas estadas compresas.",
	'smw_badtitle' => 'O planhèm, mas “$1” es pas un títol de pagina valable.',
	'smw_badqueryatom' => 'Las partidas “<nowiki>[[…]]</nowiki>” de la requèsta son pas estadas compresas.',
	'smw_propvalueproblem' => 'La valor de la proprietat “$1” es pas estada compresa.',
	'smw_noqueryfeature' => 'Qualques foncionalitats de requèstas son pas suportadas sus aqueste wiki e una partida d’entre elas es estada levada ($1).',
	'smw_noconjunctions' => 'Las conjoncions dins las requèstas son pas suportadas sus aqueste wiki e una partida d’entre elas es estada levada ($1).',
	'smw_nodisjunctions' => 'Las disjoncions dins las requèstas son pas suportadas sus aqueste wiki e de partidas de la requèsta son estadas ignoradas($1).',
	'smw_querytoolarge' => "Las condicions seguentas de la requèsta an pas pogut èsser evaluadas en rason de las restriccions d'aqueste wiki a la talha o a la prigondor de las requèstas : $1.",
	'smw_devel_warning' => "Aquesta foncion es encara en desvolopament e benlèu es pas encara operacionala. Pòt èsser judiciós de far un salvament del contengut del wiki abans tota utilizacion d'aquesta foncion.",
	'smw_notemplategiven' => 'Provesissètz una valor pel paramètre « modèl » per aqueste format de requèsta per trabalhar.',
	'smw_type_header' => 'Atributs de tipe “$1”',
	'smw_typearticlecount' => "Afichar {{PLURAL:$1|la proprietat qu'utiliza|las $1 proprietats qu'utilizan}} aqueste tipe.",
	'smw_attribute_header' => "Paginas utilizant l'atribut “$1”",
	'smw_attributearticlecount' => "Afichar {{PLURAL:$1|la pagina qu'utiliza|las $1 paginas qu'utilizan}} aquesta proprietat.",
	'smw_subproperty_header' => 'Sosproprietats',
	'smw_subpropertyarticlecount' => 'Aquesta proprietat dispausa {{PLURAL:$1|de la sosproprietat seguenta|de las $1 sosproprietats seguentas}} :',
	'smw_concept_header' => 'Paginas del concèpte « $1 »',
	'smw_conceptarticlecount' => 'Afichar {{PLURAL:$1|la pagina que repausa|las $1 paginas que repausan}} sus aqueste concèpte.',
	'smw_rss_description' => '$1 fial RSS',
	'exportrdf' => "Exportar l'article en RDF",
	'smw_exportrdf_docu' => "Sus aquesta pagina, de partidas del contengut d'un article pòdon èsser exportadas dins lo format RDF. Picatz lo nom de las paginas desiradas dins la bóstia de tèxte çaijós, <i>un nom per linha </i>.",
	'smw_exportrdf_recursive' => "Exportar tanben totas las paginas pertinentas d'un biais recursiu. Aquesta possibilitat pòt abotir a un fòrt grand nombre de resultats !",
	'smw_exportrdf_backlinks' => 'Exportar tanben totas las paginas que renvian a de paginas exportadas. Produsís un RDF dins lo qual la navigacion es mai aisida.',
	'smw_exportrdf_lastdate' => 'Exportar pas las paginas pas modificadas dempuèi lo moment indicat.',
	'smw_exportrdf_submit' => 'Exportar',
	'properties' => 'Proprietats',
	'smw_properties_docu' => 'Sus aqueste wiki, son utilizadas las proprietats seguentas.',
	'smw_property_template' => '$1 del tipe $2 ($3)',
	'smw_propertylackspage' => 'Tota proprietat deuriá èsser descricha per una pagina !',
	'smw_propertylackstype' => 'Cap de tipe es pas estat especificat per aquesta proprietat (tipe actualament supausat : $1).',
	'smw_propertyhardlyused' => 'Aquesta proprietat es fòrça utilizada sus aqueste wiki !',
	'unusedproperties' => 'Proprietats inutilizadas',
	'smw_unusedproperties_docu' => 'Las proprietats seguentas existisson, quitament se cap de pagina las utiliza pas.',
	'smw_unusedproperty_template' => '$1 de tipe $2',
	'wantedproperties' => 'Proprietats demandadas',
	'smw_wantedproperties_docu' => 'Las proprietats seguentas son utilizadas sus aqueste wiki mas an pas encara de pagina per las descriure.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|utilizacion|utilizacions}})',
	'tooltip-purge' => "Reactualizar totas las recèrcas e totes los borrolhons d'aquesta pagina.",
	'smw_purge' => 'Reactualizar',
	'types' => 'Tipes',
	'smw_types_docu' => "Los tipes de donadas seguents pòdon èsser assignadas als atributs. Cada tipe de donadas a son pròpri article, dins lo qual pòdon figurar d'entresenhas mai precisas.",
	'smw_typeunits' => 'Unitats de mesura de tipe “$1” : $2',
	'semanticstatistics' => 'Estatisticas semanticas',
	'smw_semstats_text' => "Aqueste wiki conten '''$1''' {{PLURAL:$1|valor|valors}} de proprietat per una soma de '''$2''' [[Special:Properties|{{PLURAL:$2|proprietat diferenta|proprietats diferentas}}]].
'''$3''' {{PLURAL:$3|proprietat a sa|proprietats an lor}} pagina pròprie, e lo tipe de donadas volgut es especificat per '''$4''' d'aquesta.
Unas de las proprietats existentas pòdon en fach èsser [[Special:UnusedProperties|inutilizadas]].
Las proprietats qu'an pas encara de pagina se tròban dins la [[Special:WantedProperties|lista de las proprietats demandadas]].",
	'uriresolver' => "Resolveire d'URI",
	'smw_uri_doc' => 'Lo resolveire d\'URI implementa la <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">conclusion del TAG del W3C a prepaus del httpRange-14</a>. Se pòt assegurar que los umans vengan pas de sites web.',
	'ask' => 'Recèrca semantica',
	'smw_ask_sortby' => 'Triar per colomnas (opcional)',
	'smw_ask_ascorder' => 'Creissent',
	'smw_ask_descorder' => 'Descreissent',
	'smw_ask_submit' => 'Trobar de resultats',
	'smw_ask_editquery' => '[Editar la requèsta]',
	'smw_add_sortcondition' => '[Apond las condicions de triada]',
	'smw_ask_hidequery' => 'Amagar la requèsta',
	'smw_ask_help' => 'Ajuda a la requèsta',
	'smw_ask_queryhead' => 'Requèsta',
	'smw_ask_printhead' => 'Condicions suplementàrias (facultatiu)',
	'smw_ask_format_as' => 'Formatar en :',
	'smw_ask_defaultformat' => 'defaut',
	'smw_ask_show_embed' => 'Far veire lo còde incrustat',
	'smw_ask_hide_embed' => 'Amagar lo còde incrustat',
	'smw_ask_embed_instr' => 'Per incrustar aquesta requèsta dins una pagina wiki, utilizatz lo còde çaijós.',
	'searchbyproperty' => 'Recercar per atribut',
	'smw_sbv_docu' => "Recercar totas las paginas qu'an un atribut donat amb una cèrta valor.",
	'smw_sbv_novalue' => 'Picatz una valor o consultatz totas las valors dels atributs per $1.',
	'smw_sbv_displayresult' => "Lista de totas las paginas qu'an un atribut $1 amb la valor $2.",
	'smw_sbv_displayresultfuzzy' => 'Una lista de totas las paginas que son la proprietat « $1 » amb la valor « $2 ». Perque i a pas que qualques resultats, las valors pròchas tanben son afichadas.',
	'smw_sbv_property' => 'Proprietat :',
	'smw_sbv_value' => 'Valor :',
	'smw_sbv_submit' => 'Trobar de resultats',
	'browse' => 'Percórrer lo wiki',
	'smw_browselink' => 'Cercar las proprietats',
	'smw_browse_article' => 'Picatz lo nom de la pagina a partir de la quala volètz començar la navigacion.',
	'smw_browse_go' => 'Validar',
	'smw_browse_show_incoming' => 'afichar las proprietats que puntan aicí',
	'smw_browse_hide_incoming' => 'amagar las proprietats que puntan aicí',
	'smw_browse_no_outgoing' => 'Aquesta pagina a pas cap de proprietat.',
	'smw_browse_no_incoming' => 'Cap de proprietat punta pas cap a aquesta pagina.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Inversar lo labèl de proprietat',
	'pageproperty' => 'Recercar dins las proprietats de la pagina',
	'smw_pp_docu' => "Recercar totas las valors d'una proprietat dins una pagina donada. Picatz la pagina e una proprietat.",
	'smw_pp_from' => 'De la pagina',
	'smw_pp_type' => 'Proprietat',
	'smw_pp_submit' => 'Trobar de resultats',
	'smw_result_prev' => 'Precedent',
	'smw_result_next' => 'Seguent',
	'smw_result_results' => 'Resultats',
	'smw_result_noresults' => 'O planhèm, pas de resultats.',
	'smwadmin' => "Foncions d'administrator per Semantic MediaWiki",
	'smw_smwadmin_settingup' => "Installa l'estocatge per Semantic MediaWiki",
	'smw_smwadmin_setupsuccess' => "Lo motir d'estocatge es estat installat amb succès.",
	'smw_smwadmin_return' => 'Tornar cap a $1',
	'smw_smwadmin_updatestarted' => 'Un processús novèl pel refrescament de semantic data a començat.
Totas las donadas estocadas seràn reconstruchas o quitament reparadas se necessari.
Podètz seguir la progression de la mesa a jorn sus aquesta pagina especiala.',
	'smw_smwadmin_updatenotstarted' => 'Un processús de mesa a jorn ja es en cors d’execucion.
Ne creetz pas un autre.',
	'smw_smwadmin_updatestopped' => 'Totes los processús de mesa a jorn son estats arrestats.',
	'smw_smwadmin_updatenotstopped' => 'Per arrestar lo processús en cors de mesa a jorn, vos cal marcar la casa per indicar que ne sètz vertadièrament segur(a).',
	'smw_smwadmin_docu' => 'Aquesta pagina especiala vos ajuda pendent l’installacion e la mesa a nivèl de <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Doblidetz pas de salvar las donadas abans las foncions d’administracion del site.',
	'smw_smwadmin_db' => 'Installacion e mesa a nivèl de la banca de donadas',
	'smw_smwadmin_dbdocu' => "Semantic MediaWiki requerís maitas extensions per la banca de donadas MediaWiki en òrdre per emmagazinar las donadas de semantica.
La foncion çaijós verifica que vòstra banca de donadas es estada installada corrèctament.
Las modificacions fachas al moment d'aquesta etapa afectaràn pas la rèsta de la banca de donadas Mediawiki, e pòt èsser desfacha a volontat.
Aquesta foncion d’installacion pòt èsser aviada mantun còp sens causar lo mendre degalh, mas una sola installacion o mesa e nivèl es necessària.",
	'smw_smwadmin_permissionswarn' => "Se l’operacion fracassa amb d'errors SQL, l’utilizaire de la banca de donadas utilizada per vòstre wiki, (agachatz vòstre LocalSettings.php) risca probablament d'aver pas las permissions sufisentas.
Cal siá permetre a aqueste utilizaire de dispausar de las permissions per crear e suprimir las taulas, siá entrar temporàriament la connexion en root a vòstra banca de donadas dins lo LocalSettings.php, siá utilizar l'escript de mantenença <tt>SMW_setup.php</tt> lo qual pòt utilizar las acreditacions de AdminSettings.php.",
	'smw_smwadmin_dbbutton' => 'Inicializa las taulas de mesa a nivèl',
	'smw_smwadmin_announce' => 'Anonciar vòstre wiki',
	'smw_smwadmin_announcedocu' => "Semantic MediaWiki dispausa d’un servici internet per anonciar de sites wiki semantics novèls.
Aquò's utilizat per manténer una lista dels sites publics qu'utilizan Semantic MediaWiki, principalament per ajudar <a href=\"http://semantic-mediawiki.org/wiki/SMW_Project\">lo projècte Semantic MediaWiki</a> a obténer una vista d’ensemble dels usatges tipics d'aqueste projècte.
Vejatz la pagina d’acuèlh de Semantic MediaWiki <a href=\"http://semantic-mediawiki.org/wiki/Registry\">per mai d'entresenhas a prepaus d'aqueste servici</a>.",
	'smw_smwadmin_announcebutton' => 'Quichatz sul boton seguent per sometre l’adreça internet de vòstre wiki a aqueste servici.
Lo servici enregistrarà pas los wiki que son pas accessibles al public, e estocarà pas que las informacions publicament accessiblas.',
	'smw_smwadmin_datarefresh' => 'Reparacion e mesa a nivèl de las donadas',
	'smw_smwadmin_datarefreshdocu' => "Es possible de restablir totas las donadas Semantic MediaWiki basadas suls contenguts corrents d'aqueste wiki.
Aquò pòt èsser util per reparar de donadas rompudas o per refrescar las donadas se lo format intèrne a cambiat al moment de las remesas a nivèl.
La mesa a jorn es executada pagina per pagina e se serà pas acabada immediatament.
La pagina seguenta aficha se una mesa a jorn es en cors d’execucion e vos permet de començar o d’arrestar aquestas (levat s'aquesta foncionalitat est desactivada per l’administrator del site).",
	'smw_smwadmin_datarefreshprogress' => "<strong>Una mesa a jorn es en cors d’execucion.</strong>
Es normal qu’una mesa a jorn progresse lentament dempuèi que refresca unicament las donadas dins de troces pichons a cada còp qu’un utilizaire accedís al wiki.
Per acabar aquesta mesa a jorn mai rapidament, podètz invocar l'escript de mantenença Mediawiki <tt>runJobs.php</tt> (utilizatz l’opcion <tt>--maxjobs 1000</tt> per restrénher lo nombre de las mesas a jorn per escript aviat).
Progression estimada de la mesa a jorn actuala :",
	'smw_smwadmin_datarefreshbutton' => 'Començar la mesa a jorn de las donadas',
	'smw_smwadmin_datarefreshstop' => 'Arrestar aquesta mesa a jorn',
	'smw_smwadmin_datarefreshstopconfirm' => 'Òc, ne soi segur(a).',
	'smw_smwadmin_support' => 'Obtencion d’un supòrt',
	'smw_smwadmin_supportdocu' => 'De ressorsas divèrsas vos poiriàn ajudar en cas de problèmas :',
	'smw_smwadmin_installfile' => 'S\'experimentatz de problèmas amb vòstra installacion, començatz per agachar lo guida en linha dins lo <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">fichièr INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'La documentacion completa de l’utilizaire de Semantic MediaWiki se tròba sus <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Los bògs pòdon èsser someses sus <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Avètz d’autras questions o de suggestions, rejonhètz la discussion sul <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">forum dels utilizaires de Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Estructura de las donadas',
	'smw_adminlinks_displayingdata' => 'Afichatge de las donadas',
	'smw_adminlinks_inlinequerieshelp' => 'Ajuda sus las requèstas',
);

/** Ossetic (Иронау)
 * @author Amikeco
 */
$messages['os'] = array(
	'smw_printername_template' => 'Шаблон',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'smw_finallistconjunct' => ' unn',
	'smw_printername_list' => 'Lischt',
	'smw_true_words' => 'ya,yes,true',
	'smw_false_words' => 'nee,no,false',
	'smw_nofloat' => '„$1“ iss ken Zehl.',
	'smw_browse_go' => 'Geh los',
	'smw_inverse_label_default' => '$1 vun',
	'smw_pp_from' => 'Blatt',
	'smw_result_prev' => 'zerick',
	'smw_result_next' => 'vaerschich',
	'smw_smwadmin_return' => 'Zerick zu $1',
);

/** Polish (Polski)
 * @author Maikking
 * @author Sp5uhe
 * @author ToSter
 * @author Łukasz Bolikowski
 */
$messages['pl'] = array(
	'smw_edithelp' => 'Pomoc edycyjna odnośnie relacji i atrybutów',
	'smw_finallistconjunct' => ' i',
	'smw_factbox_head' => 'Fakty o $1 &mdash; Kliknij <span class="smwsearchicon">+</span> aby znaleźć podobne strony.',
	'smw_isspecprop' => 'Ta własność jest unikalna dla tej wiki.',
	'smw_isknowntype' => 'Ten typ danych należy do standardowych typów dla tej wiki.',
	'smw_isaliastype' => 'Ten typ danych to alias typu „$1”.',
	'smw_isnotype' => 'Typ danych „$1” nie jest standardowy dla tej wiki i nie został również zdefiniowany przez użytkownika.',
	'smw_concept_description' => 'Opis koncepcji „$1”',
	'smw_no_concept_namespace' => 'Koncepcje można definiować tylko w przestrzeni nazw Koncepcja:',
	'smw_multiple_concepts' => 'Każda strona koncepcji może mieć tylko jedną definicję koncepcji.',
	'smw_baduri' => 'Niestety, URI z przestrzeni „$1” nie są w tym miejscu dostępne.',
	'smw_printername_auto' => 'Automatycznie',
	'smw_printername_count' => 'Wyniki obliczeń',
	'smw_printername_csv' => 'eksport CSV',
	'smw_printername_debug' => 'Śledzenie zapytania (dla specjalistów)',
	'smw_printername_embedded' => 'Zagnieżdżone fragmenty strony',
	'smw_printername_json' => 'eksport JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Lista numerowana',
	'smw_printername_ul' => 'Lista nienumerowana',
	'smw_printername_rss' => 'eksport RSS',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Szeroka tabela',
	'smw_printername_template' => 'Szablon',
	'smw_iq_disabled' => 'Niestety, w tym wiki wyłączono możliwość tworzenia zapytań w artykułach.',
	'smw_iq_moreresults' => '&hellip; dalsze wyniki',
	'smw_iq_nojs' => 'Aby obejrzeć ten element, włącz w przeglądarce obsługę JavaScript.',
	'smw_iq_altresults' => 'Przeglądaj bezpośrednio listę wyników.',
	'smw_unknown_importns' => 'Brak możliwości importu z przestrzeni nazw „$1”.',
	'smw_nonright_importtype' => '$1 może być użyte tylko dla artykułów z przestrzeni nazw „$2”.',
	'smw_wrong_importtype' => '$1 nie może być użyte dla artykułów z przestrzeni nazw „$2”.',
	'smw_no_importelement' => 'Nie można zaimportować elementu „$1”.',
	'smw_parseerror' => 'Podana wartość jest niezrozumiała.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '„$1” nie może być użyte jako nazwa strony.',
	'smw_wrong_namespace' => 'Dozwolone są tutaj tylko strony z przestrzeni nazw „$1”.',
	'smw_unknowntype' => '„$1” jako typ atrybutu nie jest wspierany.',
	'smw_manytypes' => 'Zdefiniowano więcej niż jeden typ dla atrybutu.',
	'smw_emptystring' => 'Puste łańcuchy znakowe są niedozwolone.',
	'smw_maxstring' => 'Reprezentacja znakowa $1 jest zbyt długa.',
	'smw_notinenum' => '“$1” nie jest na liście dozwolonych wartości ($2) dla tego atrybutu.',
	'smw_noboolean' => '“$1” nie zostało rozpoznane jako wartość logiczna (prawda/fałsz).',
	'smw_true_words' => 'prawda,t,yes,y,tak,true',
	'smw_false_words' => 'fałsz,f,no,n,nie,false',
	'smw_nofloat' => '„$1” nie jest liczbą.',
	'smw_infinite' => 'Liczby tak duże jak „$1” nie są wspierane.',
	'smw_infinite_unit' => 'Konwersja do jednostki „$1” zwróciła liczbę, która jest zbyt duża.',
	'smw_unsupportedprefix' => 'Przedrostki dla liczb (“$1”) nie są obecnie wspierane.',
	'smw_unsupportedunit' => 'Konwersja dla jednostki „$1” nie jest wspierana.',
	'smw_nodatetime' => 'Data „$1” nie została zrozumiana.',
	'smw_toomanyclosing' => 'W zapytaniu jest zbyt wiele wystąpień „$1”.',
	'smw_noclosingbrackets' => 'W zapytaniu któryś z podwójnych nawiasów „<nowiki>[[</nowiki>” nie został zamknięty nawiasem „]]”.',
	'smw_misplacedsymbol' => 'Symbolu „$1” użyto w niewłaściwym miejscu.',
	'smw_unexpectedpart' => 'Część „$1” zapytania jest niezrozumiała.
Wyniki mogą być inne od oczekiwanych.',
	'smw_emptysubquery' => 'Podzapytanie nie ma prawidłowych warunków do wykonania.',
	'smw_misplacedsubquery' => 'Podzapytanie zostało użyte w niedozwolonym miejscu.',
	'smw_valuesubquery' => 'Podzapytania nie są dozwolone jako wartości własności „$1”.',
	'smw_overprintoutlimit' => 'Zapytanie zawiera zbyt wiele instrukcji wydruku.',
	'smw_badprintout' => 'Któraś z instrukcji wydruku nie została zrozumiana.',
	'smw_badtitle' => '„$1” nie jest prawidłowym tytułem strony.',
	'smw_badqueryatom' => 'Część zapytania „<nowiki>[[…]]</nowiki>” nie została zrozumiana.',
	'smw_propvalueproblem' => 'Wartość „$1” nie została rozpoznana.',
	'smw_noqueryfeature' => 'Niektóre elementy zapytania nie są obsługiwane na tej wiki, pominięto część zapytania ($1).',
	'smw_noconjunctions' => 'Koniunkcje w zapytaniach nie są obsługiwane na tej wiki, pominięto część zapytania ($1).',
	'smw_nodisjunctions' => 'Alternatywy w zapytaniach nie są obsługiwane na tej wiki, pominięto część zapytania ($1).',
	'smw_querytoolarge' => 'Następujące warunki zapytania nie mogły zostać uwzględnione ze względu na ograniczenia wiki w wielkości lub głębokości zapytania: $1.',
	'smw_devel_warning' => 'Ta opcja jest obecnie w fazie rozwoju, może nie być w pełni funkcjonalna. Przed użyciem zabezpiecz swoje dane.',
	'smw_notemplategiven' => 'Należy podać parametr „template”, aby to zapytanie zadziałało.',
	'smw_type_header' => 'Atrybuty typu “$1”',
	'smw_typearticlecount' => 'Pokazano $1 {{PLURAL:$1|atrybut używający|atrybuty używające|atrybutów używających}} tego typu.',
	'smw_attribute_header' => 'Strony używające atrybutu “$1”',
	'smw_attributearticlecount' => 'Pokazano $1 {{PLURAL:$1|stronę używającą|strony używające|stron używających}} tego atrybutu.',
	'smw_subproperty_header' => 'Podwłasności',
	'smw_subpropertyarticlecount' => 'Ta własność ma {{PLURAL:$1|podwłasność|$1 następujące podwłasności:|$1 następujących podwłasności:}}',
	'smw_concept_header' => 'Strony koncepcji „$1”',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Wyświetlona jest jedna strona należąca|Wyświetlone zostały $1 strony należące|Wyświetlonych zostało $1 stron należących}} do tej koncepcji.',
	'exportrdf' => 'Eksport stron do RDF',
	'smw_exportrdf_docu' => 'Ta strona pozwala eksportować fragmenty artykułu w formacie RDF.  Aby wyeksportować artykuły, wpisz ich tytuły w poniższym polu tekstowym, po jednym tytule w wierszu.',
	'smw_exportrdf_recursive' => 'Rekursywny eksport wszystkich powiązanych stron.  Zwróć uwagę, że wynik może być olbrzymi!',
	'smw_exportrdf_backlinks' => 'Eksportuj także wszystkie strony, które odwołują się do eksportowanych stron.  Tworzy przeglądalny RDF.',
	'smw_exportrdf_lastdate' => 'Nie eksportuj stron, które nie były zmieniane od podanego czasu.',
	'smw_exportrdf_submit' => 'Eksport',
	'properties' => 'Właściwości',
	'smw_properties_docu' => 'Następujące własności są wykorzystywane w wiki.',
	'smw_property_template' => '$1 typu $2 ($3)',
	'smw_propertylackspage' => 'Wszystkie własności powinny być opisane stroną!',
	'smw_propertylackstype' => 'Nie określono żadnego typu dla tej własności (tymczasowo przypisano typ $1).',
	'smw_propertyhardlyused' => 'Ta własność jest rzadko używana w przestrzeni wiki!',
	'unusedproperties' => 'Niewykorzystywane własności',
	'smw_unusedproperties_docu' => 'Następujące własności istnieją, mimo że żadne inne strony ich nie wykorzystują.',
	'smw_unusedproperty_template' => '$1 typu $2',
	'wantedproperties' => 'Pożądane własności',
	'smw_wantedproperties_docu' => 'Następujące własności są wykorzystywane na wiki, ale nie mają jeszcze opisującej ich strony.',
	'smw_wantedproperty_template' => '$1 (wykorzystane {{PLURAL:$2|raz|$2 razy}})',
	'tooltip-purge' => 'Kliknij tutaj, aby odświeżyć wszystkie zapytania i szablony na tej stronie',
	'smw_purge' => 'Odśwież',
	'types' => 'Typy',
	'smw_types_docu' => 'Poniżej znajduje się lista wszystkich typów które mogą być przypisane atrybutom.  Każdy typ posiada artykuł, w którym mogą znajdować się dodatkowe informacje.',
	'smw_typeunits' => 'Jednostka danych typu „$1” to $2',
	'semanticstatistics' => 'Statystyka semantyczna',
	'uriresolver' => 'Resolver URI',
	'smw_uri_doc' => 'Resolver URI implementuje <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG finding on httpRange-14</a>. Dzięki temu ludzie nie zamieniają się w strony WWW.',
	'ask' => 'Szukanie semantyczne',
	'smw_ask_sortby' => 'Sortuj według kolumny (opcjonalnie)',
	'smw_ask_ascorder' => 'Rosnąco',
	'smw_ask_descorder' => 'Malejąco',
	'smw_ask_submit' => 'Szukaj wyników',
	'smw_ask_editquery' => '[Edytuj zapytanie]',
	'smw_add_sortcondition' => '[Dodaj warunki sortowania]',
	'smw_ask_hidequery' => 'Ukryj zapytanie',
	'smw_ask_help' => 'Pomoc dla tworzenia zapytań',
	'smw_ask_queryhead' => 'Zapytanie',
	'smw_ask_printhead' => 'Dodatkowe wydruki (opcjonalnie)',
	'smw_ask_format_as' => 'Formatuj jako',
	'smw_ask_defaultformat' => 'domyślny',
	'smw_ask_otheroptions' => 'Inne opcje',
	'smw_ask_show_embed' => 'Pokaż kod zagnieżdżony',
	'smw_ask_hide_embed' => 'Ukryj zagnieżdżony kod',
	'smw_ask_embed_instr' => 'Aby zagnieździć to zapytanie na stronie wiki, użyj poniższego kodu.',
	'searchbyproperty' => 'Szukaj po atrybucie',
	'smw_sbv_docu' => 'Szukanie wszystkich stron, które mają dany atrybut i wartość.',
	'smw_sbv_novalue' => 'Wpisz wartość, lub zobacz wszystkie wartości atrybutów dla $1.',
	'smw_sbv_displayresult' => 'Lista wszystkich stron, które mają atrybut $1 z wartością $2.',
	'smw_sbv_displayresultfuzzy' => 'Lista wszystkich stron, które posiadają własność „$1” o wartości „$2”.
Ponieważ znaleziono tylko kilka wyników, pokazano również wyniki podobne.',
	'smw_sbv_property' => 'Atrybut',
	'smw_sbv_value' => 'Wartość',
	'smw_sbv_submit' => 'Znajdź wyniki',
	'browse' => 'Przeglądaj artykuły',
	'smw_browselink' => 'Przeglądaj właściwości',
	'smw_browse_article' => 'Wpisz nazwę artykułu, od którego chcesz rozpocząć przeglądanie.',
	'smw_browse_go' => 'Idź',
	'smw_browse_show_incoming' => 'pokaż własności linkujące tutaj',
	'smw_browse_hide_incoming' => 'ukryj własności linkujące tutaj',
	'smw_browse_no_outgoing' => 'Ta strona nie ma żadnych własności.',
	'smw_browse_no_incoming' => 'Żadne własności nie linkują do tej strony.',
	'smw_inverse_label_default' => '$1 z',
	'smw_inverse_label_property' => 'Etykieta odwrotnej własności',
	'pageproperty' => 'Szukanie własności stron',
	'smw_pp_docu' => 'Wyszukiwanie wszystkich wartości danej właściwości na zadanej stronie.
Podaj zarówno stronę, jak i właściwość.',
	'smw_pp_from' => 'Od strony',
	'smw_pp_type' => 'Własność',
	'smw_pp_submit' => 'Znajdź wyniki',
	'smw_result_prev' => 'Poprzednia',
	'smw_result_next' => 'Następne',
	'smw_result_results' => 'Wyniki',
	'smw_result_noresults' => 'Niestety, brak wyników.',
	'smwadmin' => 'Funkcje administracyjne dla Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Ustawianie przestrzeni dyskowej dla Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Silnik przestrzeni dyskowej został pomyślnie ustawiony.',
	'smw_smwadmin_return' => 'Powrót do $1',
	'smw_smwadmin_updatestarted' => 'Uruchomiono nowy proces aktualizacji danych semantycznych.
Wszystkie zapisane dane zostaną przebudowane lub naprawione w razie potrzeby.
Możesz śledzić stan procesu aktualizacji na tej specjalnej stronie.',
	'smw_smwadmin_db' => 'Instalacja i aktualizacja bazy danych',
	'smw_smwadmin_dbbutton' => 'Inicjalizuj lub aktualizuj tabele',
	'smw_smwadmin_announce' => 'Opublikuj swoje wiki',
	'smw_smwadmin_datarefresh' => 'Naprawa i aktualizacja danych',
	'smw_smwadmin_datarefreshbutton' => 'Rozpocznij aktualizację danych',
	'smw_smwadmin_datarefreshstop' => 'Zatrzymaj aktualizację danych',
	'smw_smwadmin_datarefreshstopconfirm' => 'Tak, jestem pewien.',
	'smw_smwadmin_support' => 'Jak otrzymać wsparcie',
	'smw_smwadmin_supportdocu' => 'Różnorodne źródła informacji mogą okazać się przydatne jeśli wystąpią problemy:',
	'smw_smwadmin_installfile' => 'Jeśli doświadczysz problemów z instalacją, zacznij od sprawdzenia wskazówek w <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">pliku INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Kompletna dokumentacja Semantic MediaWiki znajduje się na stronie <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Błędy możesz zgłaszać w <a href="https://bugzilla.wikimedia.org/">Bugzilli</a>.',
	'smw_smwadmin_questions' => 'Jeśli nadal masz pytania lub sugestie przyłącz się do dyskusji na <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">forum użytkowników Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Struktura danych',
	'smw_adminlinks_displayingdata' => 'Pokaż dane',
	'smw_adminlinks_inlinequerieshelp' => 'Pomoc dotycząca wewnętrznych zapytań',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'smw-desc' => "Rende soa wiki pì acessìbil - për le màchine ''e'' j'uman ([http://semantic-mediawiki.org/wiki/Help:User_manual documentassion an linia])",
	'smw_edithelp' => 'Agiut për modifiché le propietà',
	'smw_viewasrdf' => 'Fluss RDF',
	'smw_finallistconjunct' => 'e',
	'smw_factbox_head' => 'Fàit a propòsit ëd $1',
	'smw_isspecprop' => "Costa propietà a l'é na propietà special ëd costa wiki.",
	'smw_isknowntype' => 'Costa sòrt-sì a fa part ëd le sòrt ëd dàit ëstàndard ëd costa wiki.',
	'smw_isaliastype' => "Costa sòrt a l'é 'n sobrichet për la sòrt ëd dàit «$1».",
	'smw_isnotype' => "La sòrt «$1» a l'é pa na sòrt ëd dàit ëstàndard an sla wiki, e a l'ha gnanca arseivù na definission da n'utent.",
	'smw_concept_description' => 'Descrission dël concet «$1»',
	'smw_no_concept_namespace' => 'Ij concet a peulo mach esse definì ant le pàgine dlë spassi nominal Concept:.',
	'smw_multiple_concepts' => 'Minca pàgina ëd concet a peul avèj mach na definission.',
	'smw_concept_cache_miss' => "Ël concet «$1» a peul pa esse dovrà ant ës moment, përchè la configurassion ëd la wiki a ciama ch'a sia calcolà fòra ëd linia.
Se ël problema a van nen via an chèich moment, ciamé a l'aministrator ëd sò sit ëd rende 's concet disponìbil.",
	'smw_noinvannot' => 'Ij valor a peulo pa esse assignà a le proprietà anverse.',
	'smw_baduri' => 'URI dla forma "$1" a son pa përmëttù.',
	'smw_printername_auto' => 'Automàtich',
	'smw_printername_count' => "Conta dj'arzultà",
	'smw_printername_csv' => 'esportassion an CSV',
	'smw_printername_debug' => "Arcesta d'eliminassion dij bigat (për gent pràtica)",
	'smw_printername_embedded' => 'Contù dle pàgine mojà',
	'smw_printername_json' => 'esportassion an JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumerassion',
	'smw_printername_ul' => 'Detaj',
	'smw_printername_rss' => 'Esportassion RSS',
	'smw_printername_table' => 'Tàula',
	'smw_printername_broadtable' => 'Tàula estèisa',
	'smw_printername_template' => 'Stamp',
	'smw_paramdesc_limit' => "Ël màssim nùmer d'arzultà da smon-e",
	'smw_paramdesc_headers' => "Mostré j'antestassion/ij nòm dle proprietà",
	'smw_paramdesc_mainlabel' => "L'etichëtta da dé al nòm ëd la pàgina prinsipal",
	'smw_paramdesc_link' => 'Smon-e ij valor com dle liure',
	'smw_paramdesc_intro' => "Ël test da mostré prima dj'arzultà dl'arcesta, s'a-i na j'é",
	'smw_paramdesc_outro' => "Ël test da mostré apress a j'arzultà dl'arcesta, s'a-i na j'é",
	'smw_paramdesc_default' => "Ël test da mostré s'a-i é gnun arzultà a l'arcesta",
	'smw_paramdesc_searchlabel' => "Ël test ant ël colegament a j'arzultà",
	'smw_paramdesc_sep' => 'Ël separator për ij valor',
	'smw_paramdesc_template' => "Ël nòm ëd në stamp con ël qual visualisé j'arzultà",
	'smw_paramdesc_columns' => "Ël nùmer ëd colòne andoa mostré j'arzultà (lë stàndard a l'é $1)",
	'smw_paramdesc_embedformat' => "L'etichëtta HTML dovrà për definì j'antestassion",
	'smw_paramdesc_embedonly' => "Smon-e nen j'antestassion",
	'smw_paramdesc_rsstitle' => 'Ël test da mostré com tìtol dël fluss',
	'smw_paramdesc_rssdescription' => 'Ël test da dovré com descrission dël fluss',
	'smw_iq_disabled' => "J'arceste semàntiche a son ëstàite disabilità për sta wiki-sì.",
	'smw_iq_moreresults' => '... àutri arzultà',
	'smw_iq_nojs' => "Dòvra un navigador abilità a JavaScript për vëdde st'element-sì.",
	'smw_iq_altresults' => "Scor la lista dj'arzultà diretament.",
	'smw_unknown_importns' => "Le funsion d'amportassion a son pà disponìbij për lë spassi nominal ''$1''.",
	'smw_nonright_importtype' => "$1 a peul esse mach dovrà për dle pàgine dlë spassi nominal ''$2''.",
	'smw_wrong_importtype' => "$1 a peul pa esse dovrà për le pàgine ant lë spassi nominal ''$2''.",
	'smw_no_importelement' => "L'element ''$1'' a l'é pa disponìbil për l'amportassion.",
	'smw_parseerror' => "Ël valor dàit a l'é pa stàit capì.",
	'smw_notitle' => "''$1'' a peul pa esse dovrà com nòm ëd pàgina an sta wiki-sì.",
	'smw_wrong_namespace' => "Mach le pàgine ant lë spassi nominal ''$1'' a son possìbij ambelessì.",
	'smw_unknowntype' => "Un tipo ''$1'' pa mantnù a l'é definì për proprietà.",
	'smw_manytypes' => 'Pi che un tipo definì për proprietà.',
	'smw_emptystring' => 'Stringhe veuide a son pa acetà.',
	'smw_maxstring' => "La rapresentassion dë stringa $1 a l'é tròp longa.",
	'smw_notinenum' => "''$1'' a l'é pa ant la lista dij valor possìbij ($2) për sta proprietà-sì.",
	'smw_noboolean' => "''$1'' a l'é pa arconossù 'me valor Boolean (ver/fàuss).",
	'smw_true_words' => 'ver,v,é!,é',
	'smw_false_words' => 'fàuss,f,nò,n',
	'smw_nofloat' => "''$1'' a l'é pa un nùmer",
	'smw_infinite' => "Nùmer gròss com ''$1'' a son pa mantnù.",
	'smw_infinite_unit' => "La conversion ant l'ùnità ''$1'' a dà com arzultà un nùmer che a l'é tròp gròss.",
	'smw_novalues' => 'Pa gnun valor specificà.',
	'smw_unsupportedprefix' => "Ij prefiss për nùmer (''$1'') a son pa mantnù.",
	'smw_unsupportedunit' => "La conversion dë mzura për l'unità ''$1'' a l'é pa mantnùa.",
	'smw_nodatetime' => "La data ''$1'' a l'é pa stàita capìa.",
	'smw_toomanyclosing' => "A smija ch'a-i sio tròpe ocorense ëd ''$1'' ant l'arcesta.",
	'smw_noclosingbrackets' => 'Chèich usagi ëd "<nowiki>[[</nowiki>" an soa arcesta a son pa stàit sarà da un corëspondent "]]".',
	'smw_misplacedsymbol' => 'Ël sìmbol "$1" a l\'era dovrà ant un pòst andoa a l\'é pa ùtil.',
	'smw_unexpectedpart' => 'La part "$1" ëd l\'arcesta a l\'é pa stàita capìa.
J\'arzultà a peulo esse pa coma spetà.',
	'smw_emptysubquery' => "Chèich sot-arcesta a l'ha ëd condission pa bon-e.",
	'smw_misplacedsubquery' => "Chèich sot-arcesta a l'era dovrà ant un pòst andoa gnun-e sot-arceste a j'ero përmëttùe.",
	'smw_valuesubquery' => 'Sot-arcesta pa mantnùa për ij valor ëd la proprietà "$1".',
	'smw_overprintoutlimit' => "L'arcesta a conten tròpe anstrussion d'ampaginassion.",
	'smw_badprintout' => "Chèiche istrussion dë stampa ant l'arcesta a j'ero ampostà mal.",
	'smw_badtitle' => '"$1" a l\'é un tìtol ëd pàgina pa bon.',
	'smw_badqueryatom' => 'Chèich part "<nowiki>[[…]]</nowiki>" ëd l\'arcesta a l\'é pa stàita capìa.',
	'smw_propvalueproblem' => 'Ël valor ëd la proprietà "$1" a l\'é pa stàit capì.',
	'smw_noqueryfeature' => "Chèica funsion ëd l'arcesta a l'é pa mantnù su sta wiki-sì e part ëd l'arcesta a l'é stàita sautà ($1).",
	'smw_noconjunctions' => "Le congiunsion ant j'arcesta a son pa mantnùe su sta wiki-sì e part ëd l'arcesta a l'é stàita sautà ($1).",
	'smw_nodisjunctions' => "Le disgiunsion ant j'arceste a son pa apogià su sta wiki-sì e part ëd l'arcesta a l'é stàita sautà ($1).",
	'smw_querytoolarge' => "Le condission ëd l'arcesta sì-sota a son pa stàite considerà an rason dla le restrission ëd la wiki ant la dimension o profondità dj'arceste: $1.",
	'smw_devel_warning' => "Sta funsion-sì a l'é al moment sota dësvlup, e a podrìa marcé pa completament.
Ch'a salva ij sò dat prima ëd dovrela.",
	'smw_notemplategiven' => 'Dà un valor për ël paràmetr "stamp" an manera che sto formà-sì d\'arcesta a travaja.',
	'smw_type_header' => 'Proprietà dël tipo "$1".',
	'smw_typearticlecount' => "Mostré $1 {{PLURAL:$1|la proprietà|le proprietà}} ch'a deuvro sto tipo-sì.",
	'smw_attribute_header' => 'Pàgine ch\'a deuvro la proprietà "$1".',
	'smw_attributearticlecount' => "Smon-e $1 {{PLURAL:$1|la pàgine|le pàgine}} ch'a deuvro sta proprietà-sì.",
	'smw_subproperty_header' => 'Sot-proprietà',
	'smw_subpropertyarticlecount' => "Sta proprietà-sì a l'ha le $1 {{PLURAL:$1|sot-proprietà|sot-proprietà}} sì-dapress:",
	'smw_concept_header' => 'Pàgine dël concet "$1"',
	'smw_conceptarticlecount' => 'Smon-e $1 {{PLURAL:$1|pàgina|pàgine}} che a aparten-o a col concet.',
	'exportrdf' => 'Espòrta pàgine an RDF',
	'smw_exportrdf_docu' => "Sta pàgina-sì a-j përmët d'oten-e dat da na pàgina an formà RDF.
Për esporté dle pàgine, ch'a anserissa ij tìtoj ant la casela ëd test sì-sota, un tìtol për linia.",
	'smw_exportrdf_recursive' => "Esporté ricorsivament tute le pàgine corelà.
Noté che l'arzultà a podrìa esse motobin gròss!",
	'smw_exportrdf_backlinks' => "Esporté ëdcò tute le pàgine ch'a s'arferisso a le pàgine esportà.
A génera RDF navigàbij.",
	'smw_exportrdf_lastdate' => 'Espòrta pa pàgine che a son pa stàite cangià dal moment specificà.',
	'smw_exportrdf_submit' => 'Esporté',
	'properties' => 'Proprietà',
	'smw_properties_docu' => 'Le proprietà sì-sota a son dovrà ant la wiki.',
	'smw_property_template' => '$1 ëd tipo $2 ($3)',
	'smw_propertylackspage' => 'Tute le proprietà a dovrìo esse descrivùe da na pàgina!',
	'smw_propertylackstype' => "Gnun tipo a l'é stàit specificà për sta proprietà-sì (as fa cont ch'a sia ëd tipo $1, për adess).",
	'smw_propertyhardlyused' => "Sta proprietà-sì a l'é dovrà apen-a ant la wiki!",
	'unusedproperties' => 'Proprietà pa dovrà',
	'smw_unusedproperties_docu' => 'Le proprietà sì-sota a esisto, bele che gnun-e àutre pàgine a-j deuvro.',
	'smw_unusedproperty_template' => '$1 ëd tipo $2',
	'wantedproperties' => 'Proprietà vorsùe',
	'smw_wantedproperties_docu' => "Le proprietà sì-sota a son dovrà ant la wiki ma a l'han ancó pa na pàgina për descrivje.",
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|usagi|usagi}})',
	'tooltip-purge' => "Sgnaché ambelessì për rinfresché tute j'arceste e jë stamp dë sta pàgina-sì",
	'smw_purge' => 'Rinfrësca',
	'types' => 'Tipo',
	'smw_types_docu' => "Cola sì-sota a l'é na lista ëd tùit ij tipo ëd dat che a peulo esse assignà a la proprietà.
Minca tipo ëd dat a l'ha na pàgina andoa d'anformassion adissionaj a peulo esse smonùe.",
	'smw_typeunits' => 'Unità dë mzura dël tipo "$1": $2',
	'semanticstatistics' => 'Statìstiche semàntiche',
	'smw_semstats_text' => "Sta wiki-sì a conten '''$1''' {{PLURAL:$1|valor|valor}} ëd proprietà për un total ëd '''$2''' [[Special:Properties|{{PLURAL:$2|proprietà|proprietà diferente}}]].
'''$3''' {{PLURAL:$3|proprietà a l'ha|proprietà a l'han}} na soa pàgina, e ël tipo ëd dat a l'é specificà për '''$4''' ëd lor.
Cheidun-e dle proprietà esistente a peulo esse [[Special:UnusedProperties|proprietà pa dovrà]].
Proprietà che a l'han pa ancó na pàgina a peulo esse trovà dzora a la [[Special:WantedProperties|lista dle proprietà vorsùe]].",
	'uriresolver' => "Arzolvidor d'URI",
	'smw_uri_doc' => "L'arzolvidor d'URI a realisa la <a href=\"http://www.w3.org/2001/tag/issues.html#httpRange-14\">W3C TAG finding on httpRange-14</a>.
A fa an manera che j'uman a dvento pa ëd sit ëd la Ragnà.",
	'ask' => 'Arserca semàntica',
	'smw_ask_sortby' => 'Órdina për colòna (opsional)',
	'smw_ask_ascorder' => 'Chërsent',
	'smw_ask_descorder' => 'Calant',
	'smw_ask_submit' => "Trové d'arzultà",
	'smw_ask_editquery' => "[Modifiché l'arcesta]",
	'smw_add_sortcondition' => "[Gionta condission d'órdin]",
	'smw_ask_hidequery' => "Stërmé l'arcesta",
	'smw_ask_help' => "Agiut an sj'arceste",
	'smw_ask_queryhead' => 'Anterogassion',
	'smw_ask_printhead' => 'Dat adissionaj da smon-e',
	'smw_ask_printdesc' => '(gionta un nòm ëd proprietà për linia);',
	'smw_ask_format_as' => 'Ampaginé com:',
	'smw_ask_defaultformat' => 'stàndard',
	'smw_ask_otheroptions' => 'Àutre opsion',
	'smw_ask_show_embed' => 'Smon-e ël còdes antern',
	'smw_ask_hide_embed' => 'Stërmé ël còdes antern',
	'smw_ask_embed_instr' => "Për anclude costa anterogassion an linia ant na pàgina wiki, ch'a deuvra ël còdes sì-sota.",
	'searchbyproperty' => 'Serca për proprietà',
	'smw_sbv_docu' => "Serca për tute le pàgine che a l'han proprietà e valor dàit.",
	'smw_sbv_novalue' => 'Ch\'a anserissa un valor bon për la proprietà, o ch\'a varda tùit ij valor ëd le proprietà për "$1".',
	'smw_sbv_displayresult' => 'Na lista ëd tute le pàgine che a l\'han la proprietà "$1" con valor "$2"',
	'smw_sbv_displayresultfuzzy' => 'Na lista ëd tute le pàgine che a l\'han la proprietà "$1" con valor "$2".
Dagià ch\'a-i son ëstàje mach pòchi arzultà, a son smonù ëdcò ij valor davzin.',
	'smw_sbv_property' => 'Propietà:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => "Trové dj'arzultà",
	'browse' => 'Varda wiki',
	'smw_browselink' => 'Varda propietà',
	'smw_browse_article' => "Ch'a anseriss ël nòm ëd la pàgina da andoa ancaminé a vardé.",
	'smw_browse_go' => 'Va',
	'smw_browse_show_incoming' => 'smon-e le propietà che a colego ambelessì',
	'smw_browse_hide_incoming' => "stërmé le propietà ch'a colego ambelessì",
	'smw_browse_no_outgoing' => "Sta pàgina-sì a l'ha pa ëd propietà.",
	'smw_browse_no_incoming' => 'Gnun-a propietà a colega a sta pàgina-sì.',
	'smw_inverse_label_default' => '$1 ëd',
	'smw_inverse_label_property' => 'Etichëtta dla propietà anversa',
	'pageproperty' => 'Serca propietà dla pàgina',
	'smw_pp_docu' => 'Serca tùit ij valor ëd na propietà su na pàgina dàita.',
	'smw_pp_from' => 'Da pàgina',
	'smw_pp_type' => 'Propietà',
	'smw_pp_submit' => "Smon-e j'arzultà",
	'smw_result_prev' => 'Prima',
	'smw_result_next' => 'Apress',
	'smw_result_results' => 'Arzultà',
	'smw_result_noresults' => 'Pa gnun arzultà.',
	'smwadmin' => "Funsion d'aministrator për Semantic MediaWiki",
	'smw_smwadmin_settingup' => 'Anstalassion ëd memòria për Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => "Ël motor ëd memorisassion a l'é stàit anstalà da bin.",
	'smw_smwadmin_return' => 'Torna a $1',
	'smw_smwadmin_updatestarted' => "Un process ëd modìfica neuv për rinfrësché ij dat semàntich a l'é stàit fàit parte.
Tùit ij dat memorisà a saran rifàit o riparà andoa a-i é dabzògn.
A peul trové l'andament ëd la modìfica an sta pàgina special-sì.",
	'smw_smwadmin_updatenotstarted' => "A-i é già un process ëd modìfica an camin.
Creene nen n'àutr.",
	'smw_smwadmin_updatestopped' => 'Tùit ij process ëd modìfica esistent a son ëstàit fërmà.',
	'smw_smwadmin_updatenotstopped' => "Për fërmé ël process ëd modìfica an cors, a deuv ativé la casela për indiché ch'a l'é pròpi sicur.",
	'smw_smwadmin_docu' => "Sta pàgina special-sì a lo giuta durant l'instalassion e l'agiornament ëd <a href=\"http://semantic-mediawiki.org\">Semantic MediaWiki</a>.
Ch'as visa ëd salvé ij dat ëd valor prima ëd fé le funsion aministrative.",
	'smw_smwadmin_db' => 'Anstalassion e agiornament dla base ëd dàit',
	'smw_smwadmin_dbdocu' => "Semantic MediaWiki a l'ha dabzògn ëd chèiche estension a la base ëd dàit MediaWiki për memorisé ij dat semàntich.
La funsion sì-sota a assicura che soa base ëd dàit a l'é ampostà për da bin.
Ij cangiament fàit an cost pass-sì a toco pa ël rest dla bse ëd dàit mediaWiki, e a l'é bel fé torné andré s'as veul.
Sta funsion d'ampostassion-sì a peul esse fàita vàire vire sensa fé gnun dann, ma a-i n'a j'é dabzògn mach na vira për l'anstalassion o l'agiornament.",
	'smw_smwadmin_permissionswarn' => "Se l'operassion a faliss con dj'eror SQL, l'utent dla base ëd dàit dovrà da soa wiki (ch'a contròla sò LocalSettings.php) probabilment a l'ha pa basta 'd përmess.
O bin ch'a-j daga a st'utent dij përmess adissionaj për creé e scancelé 'd tabele, temporaneament ch'a anserissa lë stranòm ëd l'utent ris an  LocalSettings.php, opura ch'a deuvra ël senari ëd manteniment <tt>SMW_setup.php</tt> ch'a peul dovré le credensiaj d'AdminSettings.php.",
	'smw_smwadmin_dbbutton' => 'Inissialisé o agiorné le tàule',
	'smw_smwadmin_announce' => 'Anonsia toa wiki',
	'smw_smwadmin_announcedocu' => "Semantic MediaWiki a l'ha un servissi an grija për nonsié ëd sit neuv ëd wiki semàntiche.
Sòn a l'é dovrà për manten-e na lista ëd sit pùblich che a deuvro Semantic MediaWiki, pi che d'àutr për giuté ël <a href=\"http://semantic-mediawiki.org/wiki/SMW_Project\">proget Semantic MediaWiki</a> a avèj na vision dj'usagi tìpich ëd Semantic MediaWiki.
Ch'a bèica la pàgina ëd Semantic MediaWiki për <a href=\"http://semantic-mediawiki.org/wiki/Registry\">d'àutre anformassion su 's servissi</a>.",
	'smw_smwadmin_announcebutton' => "Ch'a sgnaca ël boton sì-sota për mandé adrësse dl'aragnà wiki a col servissi là.
Ël servissi a registrërà pa le wiki ch'a son pa acessìbij pùblicament, e a memorisërà mach j'anformassion acessìbij publicament.",
	'smw_smwadmin_datarefresh' => 'Riparassion ëd dat e agiornament',
	'smw_smwadmin_datarefreshdocu' => "A l'é possìbil ripristiné tùit ij dat Semantic MediaWiki basà dzora al contnù corent ëd la wiki.
Sòn a peul ven-e a taj për riparé dat rot o për rinfrësché dat se ël formà antern a l'é cangià për chèich agiornament dël programa.
La modìfica a l'é fàita pàgina për pàgina e a sarà pa completa sùbit.
Lòn ch'a-i é sì-sota a mostra se na modìfica a l'é an cors e a-j përmët ëd fé parte o fërmé le modìfiche (gavà che sta possibilità a sia stàita disabilità da l'aministrator dël sit).",
	'smw_smwadmin_datarefreshprogress' => "<strong>na modìfica a l'é già an cors.</strong>
A l'é normal che la modìfica a von-a anans mach pian përchè a rinfrësca dat an cite partìe minca vira che n'utent a intra ant la wiki.
Për fé finì sta modìfica pi an pressa, a peul ciamé ël senari ëd manteniment MediaWiki <tt>runJobs.php</tt> (ch'a deuvra l'opsion <tt>--maxjobs 1000</tt> për strenze ël nùmer ëd modìfiche fàite ant un lòt).
Avansament stimà dla modìfica corenta:",
	'smw_smwadmin_datarefreshbutton' => 'Ancamin-a a agiorné ij dat',
	'smw_smwadmin_datarefreshstop' => 'Ferma sto agiornament-sì',
	'smw_smwadmin_datarefreshstopconfirm' => 'Bò, i son sicur.',
	'smw_smwadmin_support' => "Oteniment ëd n'agiut",
	'smw_smwadmin_supportdocu' => 'Vàire arsorse a peulo giutelo an cas ëd problema:',
	'smw_smwadmin_installfile' => "S'a treuva ëd problema con soa anstalassion, ch'a ancamin-a a controlé le linie guida ant l'<a href=\"http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL\">archivi INSTALL</a>.",
	'smw_smwadmin_smwhomepage' => 'La documentassion utent completa ëd Semantich WikiMedia a l\'é a <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Ij bigat a peulo esse arportà a <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => "S'a l'ha d'àutre chestion o sugeriment, ch'a vada a la discussion dzora a la <a href=\"http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user\">piassa dj'utent ëd Semantic MediaWiki</a>.",
	'smw_adminlinks_datastructure' => 'Strutura dij dat',
	'smw_adminlinks_displayingdata' => 'Visualisé ij dat',
	'smw_adminlinks_inlinequerieshelp' => "Agiut an sj'anterogassion an linia",
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'smw_finallistconjunct' => '، او',
	'smw_printername_list' => 'لړليک',
	'smw_printername_template' => 'کينډۍ',
	'smw_iq_moreresults' => 'نورې پايلې ...',
	'smw_nodatetime' => 'دا "$1" نېټه و نه پېژندل شوه.',
	'smw_exportrdf_submit' => 'صادرول',
	'properties' => 'ځانتياوې',
	'unusedproperties' => 'ناکارېدلې ځانتياوې',
	'wantedproperties' => 'غوښتل شوې ځانتياوې',
	'smw_ask_ascorder' => 'ختند',
	'smw_ask_defaultformat' => 'تلواليز',
	'smw_sbv_value' => 'ارزښت:',
	'browse' => 'ويکي سپړل',
	'smw_browselink' => 'د سپړلو ځانتياوې',
	'smw_browse_go' => 'ورځه',
	'smw_pp_type' => 'ځانتيا',
	'smw_result_prev' => 'پخواني',
	'smw_result_next' => 'راتلونکي',
	'smw_result_results' => 'پايلې',
	'smw_result_noresults' => 'اوبښۍ، هېڅ کومه پايله نشته.',
	'smw_smwadmin_datarefreshstopconfirm' => 'هو، زه ډاډه يم.',
);

/** Portuguese (Português)
 * @author 555
 * @author Crazymadlover
 * @author Hamilton Abreu
 * @author Lijealso
 * @author Malafaya
 * @author Waldir
 */
$messages['pt'] = array(
	'smw-desc' => "Tornar a sua wiki mais acessível - a máquinas ''e'' a seres humanos ([http://semantic-mediawiki.org/wiki/Help:User_manual documentação ''online''])",
	'smw_edithelp' => 'Ajuda de edição sobre propriedades',
	'smw_viewasrdf' => 'Feed RDF',
	'smw_finallistconjunct' => 'e',
	'smw_factbox_head' => 'Factos sobre $1',
	'smw_isspecprop' => 'Esta propriedade é uma propriedade especial nesta wiki.',
	'smw_isknowntype' => 'Este tipo de dados é um dos tipos padrão desta wiki.',
	'smw_isaliastype' => 'Este tipo é um nome alternativo para o tipo de dados “$1”.',
	'smw_isnotype' => 'Este tipo de dados “$1” não é um tipo padrão da wiki, nem não lhe foi dada uma definição de utilizador.',
	'smw_concept_description' => 'Descrição do conceito "$1"',
	'smw_no_concept_namespace' => 'Conceitos podem ser definidos apenas através das páginas do espaço nominal Concept:.',
	'smw_multiple_concepts' => 'Cada página de conceito pode possuir apenas uma definição de conceito.',
	'smw_concept_cache_miss' => "O conceito \"\$1\" não pode ser usado neste momento, porque a configuração da wiki requer que ele seja calculado ''off-line''. Caso o problema não seja resolvido dentro de algum tempo, peça a um administrador da wiki que disponibilize este conceito.",
	'smw_noinvannot' => 'Valores não podem ser atribuídos a propriedades inversas.',
	'smw_baduri' => 'Desculpe, URIs da forma “$1” não são permitidos.',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automático',
	'smw_printername_count' => 'Contar resultados',
	'smw_printername_csv' => 'Exportação CSV',
	'smw_printername_debug' => 'Depurar consulta (para peritos)',
	'smw_printername_embedded' => 'Incorporar conteúdo da página',
	'smw_printername_json' => 'Exportação JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumeração',
	'smw_printername_ul' => 'Especificação',
	'smw_printername_rss' => 'Exportação RSS',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Tabela ampla',
	'smw_printername_template' => 'Predefinição',
	'smw_paramdesc_limit' => 'O número máximo de resultados a devolver',
	'smw_paramdesc_headers' => 'Apresentar os nomes dos cabeçalhos e propriedades',
	'smw_paramdesc_mainlabel' => 'A etiqueta a atribuir ao nome da página principal',
	'smw_paramdesc_link' => 'Apresentar os valores na forma de links',
	'smw_paramdesc_intro' => 'O texto a apresentar antes dos resultados da consulta, caso existam',
	'smw_paramdesc_outro' => 'O texto a apresentar após os resultados da consulta, caso existam',
	'smw_paramdesc_default' => 'O texto a apresentar se a consulta não produziu resultados',
	'smw_paramdesc_searchlabel' => 'O texto no link para os resultados',
	'smw_paramdesc_sep' => 'O separador de valores',
	'smw_paramdesc_template' => 'O nome da predefinição com a qual são apresentadas as impressões',
	'smw_paramdesc_columns' => 'O número de colunas em que os resultados serão apresentados (por omissão, $1)',
	'smw_paramdesc_embedformat' => 'O elemento HTML usado para definir cabeçalhos',
	'smw_paramdesc_embedonly' => 'Não mostrar cabeçalhos',
	'smw_paramdesc_rsstitle' => "O texto que será usado como título do ''feed''",
	'smw_paramdesc_rssdescription' => "O texto que será usado como descrição do ''feed''",
	'smw_iq_disabled' => 'Consultas semânticas foram impossibilitadas nesta wiki.',
	'smw_iq_moreresults' => '… mais resultados',
	'smw_iq_nojs' => 'Por favor, use um browser com JavaScript activado para ver este elemento.',
	'smw_iq_altresults' => 'Navegar pela lista de resultados directamente.',
	'smw_unknown_importns' => 'As funções de importação não estão disponíveis para o espaço nominal “$1”.',
	'smw_nonright_importtype' => '$1 só pode ser usado com páginas no espaço nominal “$2”.',
	'smw_wrong_importtype' => '$1 não pode ser usado com páginas no espaço nominal “$2”.',
	'smw_no_importelement' => 'Elemento “$1” não disponível para importação.',
	'smw_parseerror' => 'O valor fornecido não foi compreendido.',
	'smw_notitle' => '“$1” não pode ser usado como nome de página nesta wiki.',
	'smw_wrong_namespace' => 'Apenas páginas no espaço nominal "$1" são permitidas aqui.',
	'smw_unknowntype' => 'Tipo não suportado “$1”  definido para propriedade.',
	'smw_manytypes' => 'Mais do que um tipo definido para a propriedade.',
	'smw_emptystring' => 'Cadeias de caracteres vazias não são aceites.',
	'smw_maxstring' => 'Representação de cadeia de caracteres $1 é demasiado longa.',
	'smw_notinenum' => '“$1” não está na lista de valores possíveis ($2) para esta propriedade.',
	'smw_noboolean' => '“$1” não é reconhecido como um valor booleano (verdadeiro/falso).',
	'smw_true_words' => 'verdadeiro,v,sim,s',
	'smw_false_words' => 'falso,f,não,nao,n',
	'smw_nofloat' => '“$1” não é um número.',
	'smw_infinite' => 'Números tão grandes como “$1” não são suportados.',
	'smw_infinite_unit' => 'A conversão para a unidade “$1” resultou num número demasiado grande.',
	'smw_novalues' => 'Não foram especificados valores.',
	'smw_unsupportedprefix' => 'Prefixos em números (“$1”) não são suportados.',
	'smw_unsupportedunit' => 'Conversão de unidade para unidade “$1” não suportada.',
	'smw_nodatetime' => 'A data “$1” não foi compreendida.',
	'smw_toomanyclosing' => 'Parece haver demasiadas ocorrências de "$1" na consulta.',
	'smw_noclosingbrackets' => 'Um uso de "<nowiki>[[</nowiki>" na sua consulta não foi fechada por um "]]" correspondente.',
	'smw_misplacedsymbol' => 'O símbolo “$1” foi usado num sítio onde não é útil.',
	'smw_unexpectedpart' => 'A parte "$1" da consulta não foi compreendida.
Os resultados podem não ser os esperados.',
	'smw_emptysubquery' => 'Uma subconsulta tem uma condição inválida.',
	'smw_misplacedsubquery' => 'Uma subconsulta foi usada num local onde não são permitidas subconsultas.',
	'smw_valuesubquery' => 'Subconsultas não suportadas para valores da propriedade "$1".',
	'smw_overprintoutlimit' => 'Esta consulta contém demasiados pedidos de saídas.',
	'smw_badprintout' => 'Uma frase de saída na consulta estava mal formada.',
	'smw_badtitle' => 'Desculpe, mas “$1” não é um título de página válido.',
	'smw_badqueryatom' => 'Uma parte "<nowiki>[[…]]</nowiki>" da consulta não foi compreendida.',
	'smw_propvalueproblem' => 'O valor da propriedade “$1” não foi compreendido.',
	'smw_noqueryfeature' => 'Uma característica da consulta não é suportada nesta wiki e parte da consulta foi descartada ($1).',
	'smw_noconjunctions' => 'Conjunções em consultas não são suportadas nesta wiki e parte da consulta foi descartada ($1).',
	'smw_nodisjunctions' => 'Disjunções em consultas não são suportadas nesta wiki e parte da consulta foi descartada ($1).',
	'smw_querytoolarge' => 'Não foi possível considerar as seguintes condições da consulta, devido às restrições no tamanho e profundidade de consulta das wikis: $1.',
	'smw_devel_warning' => 'Esta funcionalidade está neste momento em desenvolvimento, e pode não estar totalmente funcional.
Faça uma cópia de segurança dos seus dados antes de a usar.',
	'smw_notemplategiven' => 'Forneça um valor para o parâmetro "template" para que este formato de consulta funcione.',
	'smw_type_header' => 'Propriedades do tipo “$1”',
	'smw_typearticlecount' => 'Apresentando {{PLURAL:$1|uma propriedade que usa|$1 propriedades que usam}} este tipo.',
	'smw_attribute_header' => 'Páginas que usam a propriedade “$1”',
	'smw_attributearticlecount' => 'A apresentar {{PLURAL:$1|uma página que usa|$1 páginas que usam}} esta propriedade.',
	'smw_subproperty_header' => 'Subpropriedades',
	'smw_subpropertyarticlecount' => 'Esta propriedade possui {{PLURAL:$1|a seguinte subpropriedade|as seguintes $1 subpropriedades}}:',
	'smw_concept_header' => 'Páginas do conceito "$1"',
	'smw_conceptarticlecount' => 'A apresentar {{PLURAL:$1|uma página pertencente|$1 páginas pertencentes}} ao conceito.',
	'smw_rss_description' => 'Feed RSS de $1',
	'exportrdf' => 'Exportar páginas para RDF',
	'smw_exportrdf_docu' => 'Esta página permite-lhe obter dados de uma página no formato RDF.
Para exportar páginas, introduza os seus títulos na caixa de texto abaixo, um título por linha.',
	'smw_exportrdf_recursive' => 'Exportar recursivamente todas as páginas relacionadas.
Note que o resultado pode ser volumoso!',
	'smw_exportrdf_backlinks' => 'Também exporta todas as páginas que referem as páginas exportadas.
Gera RDF navegável.',
	'smw_exportrdf_lastdate' => 'Não exporte páginas que não foram alteradas desde o tempo dado.',
	'smw_exportrdf_submit' => 'Exportar',
	'properties' => 'Propriedades',
	'smw_properties_docu' => 'As seguintes propriedades são usadas nesta wiki.',
	'smw_property_template' => '$1 de tipo $2 ($3)',
	'smw_propertylackspage' => 'Todas as propriedades devem ser descritas por uma página!',
	'smw_propertylackstype' => 'Nenhum tipo foi especificado para esta propriedade (assumindo tipo $1 por agora).',
	'smw_propertyhardlyused' => 'Esta propriedade é muito pouco usada nesta wiki!',
	'unusedproperties' => 'Propriedades não usadas',
	'smw_unusedproperties_docu' => 'As seguintes propriedade existem apesar de nenhuma página fazer uso delas.',
	'smw_unusedproperty_template' => '$1 de tipo $2',
	'wantedproperties' => 'Propriedades em falta',
	'smw_wantedproperties_docu' => 'As seguintes propriedades são usadas na wiki mas ainda não têm uma página que as descreva.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|uso|usos}})',
	'tooltip-purge' => 'Carregue aqui para refrescar todas as consultar e predefinições nesta página',
	'smw_purge' => 'Refrescar',
	'types' => 'Tipos',
	'smw_types_docu' => 'A seguinte lista contém todos os tipos de dados que podem ser atribuídos a propriedades.
Cada tipo de dados tem uma página onde pode ser fornecida informação adicional.',
	'smw_typeunits' => 'Unidades de medida de tipo “$1”: $2',
	'semanticstatistics' => 'Estatísticas de semântica',
	'smw_semstats_text' => "Esta wiki contém '''$1''' {{PLURAL:$1|valor|valores}} de propriedades num total de '''$2''' [[Special:Properties|{{PLURAL:$2|propriedade diferente|propriedades diferentes}}]].
'''$3''' {{PLURAL:$3|propriedade tem|propriedades têm}} uma página própria, e o tipo de dados pretendido está especificado para '''$4''' delas.
Algumas das propriedades existentes poderão ser [[Special:UnusedProperties|propriedades não usadas]].
As propriedades que não possuem uma página poderão ser encontradas na [[Special:WantedProperties|lista de propriedades em falta]].",
	'uriresolver' => 'Resolvedor de URIs',
	'smw_uri_doc' => 'O resolvedor de URIs implementa a <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">descoberta TAG da W3C sobre o httpRange-14</a>. Certifica-se de que os seres humanos não se tornem em sites da internet.',
	'ask' => 'Pesquisa semântica',
	'smw_ask_sortby' => 'Ordenar por coluna (opcional)',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Procurar resultados',
	'smw_ask_editquery' => '[Editar consulta]',
	'smw_add_sortcondition' => '[Adicionar condição de ordenação]',
	'smw_ask_hidequery' => 'Esconder consulta',
	'smw_ask_help' => 'Ajuda sobre consultas',
	'smw_ask_queryhead' => 'Consulta',
	'smw_ask_printhead' => 'Dados adicionais para apresentar',
	'smw_ask_printdesc' => '(adicionar um nome de propriedade por linha)',
	'smw_ask_format_as' => 'Formatar como:',
	'smw_ask_defaultformat' => 'padrão',
	'smw_ask_otheroptions' => 'Outras opções',
	'smw_ask_show_embed' => 'Mostrar código para incorporação',
	'smw_ask_hide_embed' => 'Ocultar código de incorporação',
	'smw_ask_embed_instr' => 'Para incorporar esta consulta numa página wiki, use o código abaixo.',
	'searchbyproperty' => 'Procurar por propriedade',
	'smw_sbv_docu' => 'Buscar todas as páginas que possuem uma determinada propriedade e valor.',
	'smw_sbv_novalue' => 'Por favor, introduza um valor válido para a propriedade, ou veja todos os valores da propriedade “$1.”',
	'smw_sbv_displayresult' => 'Segue-se uma lista de todas as páginas que possuem a propriedade “$1” com valor “$2”',
	'smw_sbv_displayresultfuzzy' => 'Uma lista de todas as páginas que têm a propriedade "$1" com o valor "$2".
Uma vez que houve poucos resultados, valores próximos são também apresentados.',
	'smw_sbv_property' => 'Propriedade:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => 'Procurar resultados',
	'browse' => 'Navegue pela wiki',
	'smw_browselink' => 'Navegar pelas propriedades',
	'smw_browse_article' => 'Introduza o nome da página a partir da qual deseja começar a navegar.',
	'smw_browse_go' => 'Ir',
	'smw_browse_show_incoming' => 'mostrar propriedades que apontem para cá',
	'smw_browse_hide_incoming' => 'ocultar propriedades que apontem para cá',
	'smw_browse_no_outgoing' => 'Esta página não possui propriedades.',
	'smw_browse_no_incoming' => 'Nenhuma propriedade linca para esta página.',
	'smw_inverse_label_default' => '$1 de',
	'smw_inverse_label_property' => 'Etiqueta propriedade inversa',
	'pageproperty' => 'Busca de propriedades de página',
	'smw_pp_docu' => 'Buscar todos os conteúdos de uma propriedade numa dada página.
Por favor, introduza ambas a página e a propriedade.',
	'smw_pp_from' => 'Da página',
	'smw_pp_type' => 'Propriedade',
	'smw_pp_submit' => 'Procurar resultados',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Seguinte',
	'smw_result_results' => 'Resultados',
	'smw_result_noresults' => 'Não há resultados.',
	'smwadmin' => 'Funções administrativas do MediaWiki Semântico',
	'smw_smwadmin_settingup' => 'A configurar armazenamento para o MediaWiki Semântico',
	'smw_smwadmin_setupsuccess' => 'O motor de armazenamento foi configurado com sucesso.',
	'smw_smwadmin_return' => 'Voltar a $1',
	'smw_smwadmin_updatestarted' => 'Foi iniciado um novo processo de actualização para refrescar os dados semânticos.
Todos os dados armazenados serão reconstruídos ou reparados onde necessário.
Pode seguir o progresso da actualização nesta página especial.',
	'smw_smwadmin_updatenotstarted' => 'Já existe um processo de actualização em curso.
Não foi criado outro.',
	'smw_smwadmin_updatestopped' => 'Todos os processos de actualização existentes foram parados.',
	'smw_smwadmin_updatenotstopped' => 'Para parar o processo de actualização em curso, deve marcar a caixa de selecção para indicar que tem realmente a certeza.',
	'smw_smwadmin_docu' => 'Esta página especial auxilia-o durante a instalação ou actualização do <a href="http://semantic-mediawiki.org">MediaWiki Semântico</a>.
Lembre-se de efectuar cópias de segurança dos dados importantes antes de executar funções administrativas.',
	'smw_smwadmin_db' => 'Instalação e actualização da base de dados',
	'smw_smwadmin_dbdocu' => 'O MediaWiki Semântico requer algumas alterações da base de dados MediaWiki de forma a armazenar os dados semânticos.
A função abaixo assegura que a sua base de dados está devidamente preparada.
As alterações feitas neste passo não afectam o resto da base de dados MediaWiki, e podem ser facilmente desfeitas se desejado.
Esta função de preparação pode ser executada várias vezes sem causar quaisquer danos, mas é necessária apenas uma vez na instalação ou actualização.',
	'smw_smwadmin_permissionswarn' => "Se a operação falhar com erros de SQL, provavelmente o utilizador de base de dados usado pela sua wiki (consulte o seu LocalSettings.php) não possui permissões suficientes.
Conceda a este utilizador permissões adicionais para criar e eliminar tabelas, introduza temporariamente as credenciais do seu super-utilizador (<i>root</i>) da base de dados em LocalSettings.php, ou use o ''script'' de manutenção <tt>SMW_setup.php</tt>, o qual pode usar as credenciais presentes em AdminSettings.php.",
	'smw_smwadmin_dbbutton' => 'Inicializar ou actualizar tabelas',
	'smw_smwadmin_announce' => 'Anuncie a sua wiki',
	'smw_smwadmin_announcedocu' => 'O MediaWiki Semântico tem um serviço na internet para anunciar novas wikis semânticas.
Este é usado para manter uma lista de sites públicos que usam o MediaWiki Semântico, principalmente para auxiliar o <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projecto MediaWiki Semântico</a> a obter uma ideia geral das utilizações típicas do MediaWiki Semântico.
Veja a página inicial do MediaWiki Semântico para <a href="http://semantic-mediawiki.org/wiki/Registry">mais informações sobre este serviço</a>.',
	'smw_smwadmin_announcebutton' => 'Clique o seguinte botão para submeter a URL da sua wiki ao serviço.
O serviço não registará wikis que não estejam publicamente acessíveis e apenas armazenará informação publicamente acessível.',
	'smw_smwadmin_datarefresh' => 'Reparação de dados e actualização',
	'smw_smwadmin_datarefreshdocu' => 'É possível restaurar todos os dados do MediaWiki Semântico baseado no conteúdo actual da wiki.
Isto pode ser útil para reparar dados corrompidos ou para refrescar os dados se o formato interno tiver sido alterado devido a alguma evolução do software.
A actualização é executada página a página e não ficará completa de imediato.
Abaixo é mostrado se uma actualização está a decorrer e permite-lhe iniciar ou parar actualizações (a menos que esta funcionalidade tenha sido desactivada por um administrador do site).',
	'smw_smwadmin_datarefreshprogress' => "<strong>Já se encontra a decorrer uma actualização.</strong>
É normal que a actualização progrida lentamente já que apenas refresca dados em pequenos blocos de cada vez que um utilizador acede à wiki.
Para terminar esta actualização mais rapidamente, pode executar o ''script'' de manutenção do MediaWiki <tt>runJobs.php</tt> (use a opção <tt>--maxjobs 1000</tt> para restringir o número de actualizações feitas em cada bloco).
Progresso estimado da actualização em curso:",
	'smw_smwadmin_datarefreshbutton' => 'Iniciar a actualização dos dados',
	'smw_smwadmin_datarefreshstop' => 'Parar esta actualização',
	'smw_smwadmin_datarefreshstopconfirm' => 'Sim, tenho a certeza.',
	'smw_smwadmin_support' => 'Obtendo suporte',
	'smw_smwadmin_supportdocu' => 'Vários recursos poderão ajudá-lo em caso de problemas:',
	'smw_smwadmin_installfile' => 'Se tiver problemas com a sua instalação, comece por rever as linhas orientadoras no <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">ficheiro INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'A documentação completa para o utilizador do MediaWiki Semântico está em <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Defeitos podem ser reportados no <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Se tem mais questões ou sugestões, junte-se à discussão no <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">fórum dos utilizadores do MediaWiki Semântico</a>.',
	'smw_adminlinks_datastructure' => 'Estrutura de dados',
	'smw_adminlinks_displayingdata' => 'Mostrando os dados',
	'smw_adminlinks_inlinequerieshelp' => "Ajuda para consultas dinâmicas ''(inline queries)''",
);

/** Brazilian Portuguese (Português do Brasil)
 * @author 555
 * @author Eduardo.mps
 * @author GKnedo
 * @author Hamilton Abreu
 * @author Heldergeovane
 * @author Luckas Blade
 * @author Rafael Vargas
 * @author Waldir
 */
$messages['pt-br'] = array(
	'smw-desc' => "Fazendo sua wiki mais acessível - para máquinas ''e'' humanos ([http://semantic-mediawiki.org/wiki/Help:User_manual documentação ''online''])",
	'smw_edithelp' => 'Ajuda de edição sobre propriedades',
	'smw_viewasrdf' => 'Feed RDF',
	'smw_finallistconjunct' => ' e',
	'smw_factbox_head' => 'dados sobre $1',
	'smw_isspecprop' => 'Esta propriedade é uma propriedade especial neste wiki.',
	'smw_isknowntype' => 'Este tipo está entre os tipos de dados padrão deste wiki.',
	'smw_isaliastype' => 'Este tipo é um alias do tipo de dados “$1”.',
	'smw_isnotype' => 'Este tipo "$1" não é uma tipo de dados padrão no wiki, nem lhe foi dada uma definição de usuário.',
	'smw_concept_description' => 'Descrição do conceito "$1"',
	'smw_no_concept_namespace' => 'Conceitos só podem ser definidos em páginas no domínio Conceito:.',
	'smw_multiple_concepts' => 'Cada página de conceito pode ter apenas uma definição de conceito.',
	'smw_concept_cache_miss' => 'O conceito "$1" não poderá ser utilizado neste momento, uma vez que a configuração deste wiki necessita ser refeita off-line. Caso o problema não seja resolvido automaticamente dentro de algum tempo, peça a um administrador deste wiki que este conceito seja disponibilizado.',
	'smw_baduri' => 'URIs na forma de "$1" não são permitidos.',
	'smw_printername_auto' => 'Automático',
	'smw_printername_count' => 'Contar resultados',
	'smw_printername_csv' => 'Exportação em CSV',
	'smw_printername_debug' => 'Depurar consulta (para peritos)',
	'smw_printername_embedded' => 'Incorporar conteúdo da página',
	'smw_printername_json' => 'Exportação em JSON',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Enumeração',
	'smw_printername_ul' => 'Discriminação',
	'smw_printername_rss' => 'Exportação em RSS',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Tabela ampla',
	'smw_printername_template' => 'Predefinição',
	'smw_iq_disabled' => 'Consultas semânticas foram desativadas neste wiki.',
	'smw_iq_moreresults' => '… mais resultados',
	'smw_iq_nojs' => 'Por favor, use um navegador com JavaScript ativado para visualizar este elemento.',
	'smw_iq_altresults' => 'Navegar pela lista de resultados diretamente.',
	'smw_unknown_importns' => 'As funções de importação não estão disponíveis para o espaço nominal “$1”.',
	'smw_nonright_importtype' => '$1 só pode ser usado com páginas no espaço nominal “$2”.',
	'smw_wrong_importtype' => '$1 não pode ser usado com páginas no espaço nominal “$2”.',
	'smw_no_importelement' => 'Elemento “$1” não disponível para importação.',
	'smw_parseerror' => 'O valor fornecido não foi compreendido.',
	'smw_notitle' => '"$1" não pode ser usado como nome de página neste wiki.',
	'smw_wrong_namespace' => 'Apenas páginas no espaço nominal "$1" são permitidas aqui.',
	'smw_unknowntype' => 'Tipo "$1" definido para propriedade não é suportado.',
	'smw_manytypes' => 'Mais do que um tipo definido para a propriedade.',
	'smw_emptystring' => 'Cadeias de caracteres vazias não são aceitas.',
	'smw_maxstring' => 'Representação de cadeia de caracteres $1 é longa demais.',
	'smw_notinenum' => '"$1" não está na lista de valores possíveis ($2) para esta propriedade.',
	'smw_noboolean' => '"$1" não é reconhecido como um valor Booleano (verdadeiro/falso).',
	'smw_true_words' => 'verdadeiro,v,sim,s',
	'smw_false_words' => 'falso,f,não,nao,n',
	'smw_nofloat' => '“$1” não é um número.',
	'smw_infinite' => 'Números tão grandes como "$1" não são suportados.',
	'smw_infinite_unit' => 'A conversão para a unidade "$1" resultou num número grande demais.',
	'smw_unsupportedprefix' => 'Prefixos em números ("$1") não são suportados.',
	'smw_unsupportedunit' => 'Conversão de unidade para unidade "$1" não suportada.',
	'smw_nodatetime' => 'A data “$1” não foi compreendida.',
	'smw_toomanyclosing' => 'Parece haver ocorrências demais de "$1" na consulta.',
	'smw_noclosingbrackets' => 'Um uso de "<nowiki>[[</nowiki>" na sua consulta não foi fechada por um "]]" correspondente.',
	'smw_misplacedsymbol' => 'O símbolo "$1" foi usado num local onde não é útil.',
	'smw_unexpectedpart' => 'A parte "$1" da consulta não foi compreendida.
Os resultados podem não ser os esperados.',
	'smw_emptysubquery' => 'Alguma subconsulta não tem uma condição válida.',
	'smw_misplacedsubquery' => 'Uma subconsulta foi usada em um local onde não são permitidas subconsultas.',
	'smw_valuesubquery' => 'Subconsultas não suportadas para valores da propriedade "$1".',
	'smw_overprintoutlimit' => 'Esta consulta contém pedidos de saídas em excesso.',
	'smw_badprintout' => 'Alguma frase de saída na consulta estava mal formada.',
	'smw_badtitle' => 'Desculpe, mas "$1" não é um título de página válido.',
	'smw_badqueryatom' => 'Alguma parte "<nowiki>[[…]]</nowiki>" da consulta não foi compreendida.',
	'smw_propvalueproblem' => 'O valor da propriedade "$1" não foi compreendido.',
	'smw_notemplategiven' => 'Providencie um valor para o parâmetro "template" para o formato desta consulta funcionar.',
	'smw_type_header' => 'Propriedades do tipo "$1"',
	'smw_typearticlecount' => 'Exibindo $1 {{PLURAL:$1|propriedade que usa|propriedades que usam}} este tipo.',
	'smw_attribute_header' => 'Páginas que usam a propriedade "$1"',
	'smw_attributearticlecount' => 'Exibindo $1 {{PLURAL:$1|página que usa|páginas que usam}} esta propriedade.',
	'smw_subproperty_header' => 'Subpropriedades',
	'smw_subpropertyarticlecount' => 'Esta propriedade possui {{PLURAL:$1|a seguinte subpropriedade|as seguintes $1 subpropriedades}}:',
	'smw_concept_header' => 'Páginas do conceito "$1"',
	'smw_conceptarticlecount' => 'Exibindo {{PLURAL:$1|uma página pertencente|$1 páginas pertencentes}} à este conceito.',
	'exportrdf' => 'Exportar páginas para RDF',
	'smw_exportrdf_docu' => 'Esta página permite que você obtenha dados de uma página no formato RDF.
Para exportar páginas, introduza os seus títulos na caixa de texto abaixo, um título por linha.',
	'smw_exportrdf_submit' => 'Exportar',
	'properties' => 'Propriedades',
	'smw_properties_docu' => 'As seguintes propriedades são usadas nesta wiki.',
	'smw_purge' => 'Atualizar',
	'types' => 'Tipos',
	'smw_types_docu' => 'A seguinte lista contém todos os tipos de dados que podem ser atribuídos a propriedades.
Cada tipo de dados tem uma página onde informação adicional pode ser providenciada.',
	'ask' => 'Pesquisa semântica',
	'smw_ask_sortby' => 'Ordenar por coluna (opcional)',
	'smw_ask_ascorder' => 'Ascendente',
	'smw_ask_descorder' => 'Descendente',
	'smw_ask_submit' => 'Procurar resultados',
	'smw_ask_editquery' => '[Editar consulta]',
	'smw_add_sortcondition' => '[Adicionar condição de ordenação]',
	'smw_ask_hidequery' => 'Esconder consulta',
	'smw_ask_help' => 'Ajuda sobre consultas',
	'smw_ask_queryhead' => 'Consulta',
	'smw_ask_printhead' => 'Dados adicionas para exibir',
	'smw_ask_format_as' => 'Formatar como:',
	'smw_ask_defaultformat' => 'Padrão',
	'smw_ask_otheroptions' => 'Outras opções',
	'smw_ask_show_embed' => 'Mostrar código embutido',
	'smw_ask_hide_embed' => 'Ocultar código embutido',
	'smw_ask_embed_instr' => 'Para embutir esta consulta em uma página wiki, use o código abaixo.',
	'searchbyproperty' => 'Pesquisar por propriedade',
	'smw_sbv_docu' => 'Pesquisar todas as páginas que possuem uma propriedade e um valor dados.',
	'smw_sbv_novalue' => 'Introduza um valor válido para a propriedade, ou veja todos os valores da propriedade "$1".',
	'smw_sbv_displayresult' => 'Segue-se uma lista de todas as páginas que possuem a propriedade "$1" com valor "$2"',
	'smw_sbv_displayresultfuzzy' => 'Uma lista de todas as páginas que têm a propriedade "$1" com o valor "$2".
Uma vez que houve poucos resultados, também são apresentados valores próximos.',
	'smw_sbv_property' => 'Propriedade:',
	'smw_sbv_value' => 'Valor:',
	'smw_sbv_submit' => 'Procurar resultados',
	'browse' => 'Navegar pela wiki',
	'smw_browselink' => 'Navegar pelas propriedades',
	'smw_browse_article' => 'Introduza o nome da página a partir da qual deseja começar a navegar.',
	'smw_browse_go' => 'Ir',
	'smw_browse_show_incoming' => 'exibir propriedades que apontem para cá',
	'smw_browse_hide_incoming' => 'ocultar propriedades que apontem para cá',
	'smw_browse_no_outgoing' => 'Esta página não possui propriedades.',
	'smw_browse_no_incoming' => 'Nenhuma propriedade aponta para esta página.',
	'pageproperty' => 'Pesquisa de propriedade de página',
	'smw_pp_docu' => 'Pesquise todos os conteúdos de uma propriedade em uma página dada.
Por favor, inclua tanto a página quanto a propriedade.',
	'smw_pp_from' => 'Da página',
	'smw_pp_type' => 'Propriedade',
	'smw_pp_submit' => 'Procurar resultados',
	'smw_result_prev' => 'Anterior',
	'smw_result_next' => 'Posterior',
	'smw_result_results' => 'Resultados',
	'smw_result_noresults' => 'Não há resultados.',
	'smwadmin' => 'Funções administrativas do Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Configurando armazenamento para Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'O mecanismo de armazenamento foi configurado com sucesso.',
	'smw_smwadmin_return' => 'Voltar a $1',
	'smw_smwadmin_updatestarted' => 'Um novo processo de atualização para atualizar os dados semânticos foi iniciado.
Todos os dados armazenados serão reconstruídos ou reparados onde necessário.
Você pode seguir o progresso da atualização nesta página especial.',
	'smw_smwadmin_updatenotstarted' => 'Já existe um processo de atualização em execução.
Não foi criado outro.',
	'smw_smwadmin_updatestopped' => 'Todos os processos de atualização existentes foram parados.',
	'smw_smwadmin_updatenotstopped' => 'Para parar o processo de atualização em execução, você deverá ativar a caixa de seleção para indicar que tem realmente a certeza.',
	'smw_smwadmin_docu' => 'Esta página especial ajuda-o durante a instalação ou atualização do <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Lembre-se de efetuar cópias de segurança dos dados importantes antes de executar funções administrativas.',
	'smw_smwadmin_db' => 'Instalação e atualização da base de dados',
	'smw_smwadmin_dbbutton' => 'Inicializar ou atualizar tabelas',
	'smw_smwadmin_announce' => 'Anuncie a sua wiki',
	'smw_smwadmin_datarefresh' => 'Reparação de dados e atualização',
	'smw_smwadmin_datarefreshprogress' => '<strong>Uma atualização já se encontra a decorrer.</strong>
É normal que a atualização progrida lentamente já que apenas refresca dados em pequenos blocos de cada vez que um utilizador acede ao wiki.
Para terminar esta atualização mais rapidamente, você pode executar o script de manutenção do MediaWiki <tt>runJobs.php</tt> (use a opção <tt>--maxjobs 1000</tt> para restringir o número de atualizações feitas num bloco).
Progresso estimado da atualização corrente:',
	'smw_smwadmin_datarefreshbutton' => 'Iniciar a atualização dos dados',
	'smw_smwadmin_datarefreshstop' => 'Parar esta atualização',
	'smw_smwadmin_datarefreshstopconfirm' => 'Sim, eu tenho certeza.',
	'smw_smwadmin_support' => 'Obtendo suporte',
	'smw_smwadmin_supportdocu' => 'Vários recursos poderão ajudá-lo em caso de problemas:',
	'smw_smwadmin_installfile' => 'Se tiver problemas com a sua instalação, comece por rever as orientações no <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">arquivo INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'A documentação completa para o utilizador do Semantic MediaWiki está em <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Defeitos podem ser reportados no <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Se você tem mais questões ou sugestões, junte-se à discussão em <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Fórum de usuários Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Estrutura de dados',
	'smw_adminlinks_displayingdata' => 'Mostrando os dados',
	'smw_adminlinks_inlinequerieshelp' => 'Ajuda para consultas inline',
);

/** Tarifit (Tarifit)
 * @author Jose77
 */
$messages['rif'] = array(
	'smw_browse_go' => 'Raḥ ɣa',
);

/** Romanian (Română)
 * @author Firilacroco
 * @author KlaudiuMihaila
 */
$messages['ro'] = array(
	'smw_viewasrdf' => 'Flux RDF',
	'smw_finallistconjunct' => 'și',
	'smw_concept_description' => 'Descrierea conceptului "$1"',
	'smw_printername_auto' => 'Automatic',
	'smw_printername_count' => 'Numără rezultatele',
	'smw_printername_csv' => 'Export CSV',
	'smw_printername_json' => 'Export JSON',
	'smw_printername_list' => 'Listă',
	'smw_printername_ol' => 'Enumerare',
	'smw_printername_rss' => 'export RSS',
	'smw_printername_table' => 'Tabel',
	'smw_printername_template' => 'Format',
	'smw_iq_disabled' => 'Interogările semantice au fost dezactivate pe acest wiki.',
	'smw_iq_moreresults' => '… mai multe rezultate',
	'smw_nonright_importtype' => '$1 poate fi folosit doar pentru paginile din spațiul de nume "$2".',
	'smw_wrong_importtype' => '$1 nu poate fi folosit pentru paginile din spațiul de nume "$2".',
	'smw_no_importelement' => 'Elementul "$1" nu este disponibil pentru import.',
	'smw_parseerror' => 'Valoarea oferită nu este înțeleasă.',
	'smw_notitle' => '"$1" nu poate fi folosit ca nume de pagină în acest wiki.',
	'smw_wrong_namespace' => 'Numai paginile din spațiul de nume "$1" sunt permise aici.',
	'smw_emptystring' => 'Şirurile vide nu sunt acceptate.',
	'smw_notinenum' => '"$1" nu este în lista de valori posibile ($2) pentru această proprietate.',
	'smw_noboolean' => '"$1" nu este recunoscut ca valoare Booleană.',
	'smw_nofloat' => '"$1" nu este număr.',
	'smw_infinite' => 'Numerele mari precum "$1" nu sunt suportate.',
	'smw_infinite_unit' => 'Conversia în mărimea "$1" a rezultat într-un număr care este prea mare.',
	'smw_nodatetime' => 'Data "$1" nu a fost înțeleasă.',
	'smw_unexpectedpart' => 'Partea "$1" a interogării nu a fost înțeleasă.
Rezultatele pot fi neașteptate.',
	'smw_badtitle' => '"$1" nu este titlu de pagină corect.',
	'smw_propvalueproblem' => 'Valoarea proprietății "$1" nu a fost înțeleasă.',
	'smw_type_header' => 'Proprietăți de tipul "$1"',
	'smw_attribute_header' => 'Pagini care folosesc proprietate "$1"',
	'smw_subproperty_header' => 'Subproprietăți',
	'smw_subpropertyarticlecount' => 'Această proprietate are {{PLURAL:$1|următoarea subproprietate|următoarele $1 subproprietăți}}:',
	'smw_concept_header' => 'Pagini ale conceptului "$1"',
	'exportrdf' => 'Exportă paginile în RDF',
	'smw_exportrdf_submit' => 'Export',
	'properties' => 'Proprietăți',
	'smw_properties_docu' => 'Următoarele proprietăți sunt folosite în wiki.',
	'smw_property_template' => '$1 de tipul $2 ($3)',
	'smw_propertylackstype' => 'Nici un tip nu a fost specificat pentru această proprietate (presupunem deocamdată tipul $1).',
	'smw_propertyhardlyused' => 'Această proprietate este puțin folosită în wiki!',
	'unusedproperties' => 'Proprietăți neutilizate',
	'smw_unusedproperties_docu' => 'Următoarele proprietăți există, deși nici o altă pagină nu le folosește.',
	'smw_unusedproperty_template' => '$1 de tipul $2',
	'wantedproperties' => 'Proprietăți dorite',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|utilizare|utilizări}})',
	'smw_purge' => 'Reîncărcare',
	'types' => 'Tipuri',
	'semanticstatistics' => 'Statistici semantice',
	'uriresolver' => 'Rezolvator URI',
	'ask' => 'Căutare semantică',
	'smw_ask_sortby' => 'Sortare după coloană (opțional)',
	'smw_ask_ascorder' => 'Crescător',
	'smw_ask_descorder' => 'Descrescător',
	'smw_ask_submit' => 'Găsește rezultate',
	'smw_ask_hidequery' => 'Ascunde interogare',
	'smw_ask_queryhead' => 'Interogare',
	'searchbyproperty' => 'Căutare după proprietate',
	'smw_sbv_property' => 'Proprietate:',
	'smw_sbv_value' => 'Valoare:',
	'smw_sbv_submit' => 'Găsește rezultate',
	'browse' => 'Răsfoiți wiki',
	'smw_browselink' => 'Răsfoiți proprietățile',
	'smw_browse_go' => 'Mergi',
	'smw_browse_no_outgoing' => 'Această pagină nu are proprietăți.',
	'smw_browse_no_incoming' => 'Nici o proprietate nu se leagă la această pagină.',
	'smw_pp_from' => 'De la pagina',
	'smw_pp_type' => 'Proprietate',
	'smw_pp_submit' => 'Găsește rezultate',
	'smw_result_prev' => 'Precedent',
	'smw_result_next' => 'Următor',
	'smw_result_results' => 'Rezultate',
	'smw_result_noresults' => 'Ne pare rău, nici un rezultat.',
	'smw_smwadmin_return' => 'Înapoi la $1',
	'smw_smwadmin_datarefreshbutton' => 'Începerea actualizării datelor',
	'smw_smwadmin_datarefreshstop' => 'Opriți această actualizare',
	'smw_smwadmin_datarefreshstopconfirm' => 'Da, sunt sigur.',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'smw_viewasrdf' => 'Feed RDF',
	'smw_finallistconjunct' => ', e',
	'smw_true_words' => 'vere,true,t,sine,si,yes,y',
	'smw_false_words' => 'fause,false,f,none,no,n',
	'properties' => 'Proprietà',
	'smw_property_template' => '$1 de tipe $2 ($3)',
	'smw_unusedproperty_template' => '$1 de tipe $2',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|ause|ausene}})',
	'types' => 'Tipe',
	'smw_typeunits' => 'Aunità de mesure d\'u tipe "$1": $2',
);

/** Russian (Русский)
 * @author Ferrer
 * @author Innv
 * @author Lockal
 * @author QuestPC
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'smw-desc' => "Делает вашу вики более доступной — для машин ''и'' людей ([http://semantic-mediawiki.org/wiki/Help:User_manual документация в сети])",
	'smw_edithelp' => 'Редактирование справки по свойствам',
	'smw_viewasrdf' => 'RDF источник',
	'smw_finallistconjunct' => ' и',
	'smw_factbox_head' => 'Факты: $1',
	'smw_isspecprop' => 'Это свойство является специальным для данного сайта.',
	'smw_isknowntype' => 'Этот тип данных принадлежит к стандартным типам данных данного сайта.',
	'smw_isaliastype' => 'Этот тип данных является альтернативным именем типа данных “$1”.',
	'smw_isnotype' => 'Тип данных “$1” не был определен.',
	'smw_concept_description' => 'Описание представления «$1»',
	'smw_no_concept_namespace' => 'Представления могут определяться только на страницах, принадлежащих пространству имён «Представление:» («Concept:»).',
	'smw_multiple_concepts' => 'Страница представления может содержать только одно определение представления.',
	'smw_concept_cache_miss' => 'Представление «$1» в настоящий момент не может быть использовано, так как настройка вики-сайта требует, чтобы его результат определялся в фоновом режиме. Если данное сообщение не исчезнет через некоторое время, обратитесь к администратору вики-сайта для включения данного представления.',
	'smw_noinvannot' => 'Обратным свойствам не могут быть присвоены значения.',
	'smw_baduri' => 'Извините, но ссылки из диапазона "$1" не доступны отсюда.',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Автоматически',
	'smw_printername_count' => 'Результаты подсчёта',
	'smw_printername_csv' => 'Экспорт CSV',
	'smw_printername_debug' => 'Отладка запросов (для экспертов)',
	'smw_printername_embedded' => 'Включаемое содержимое страниц',
	'smw_printername_json' => 'Экспорт JSON',
	'smw_printername_list' => 'Список',
	'smw_printername_ol' => 'Перечисление',
	'smw_printername_ul' => 'Список',
	'smw_printername_rss' => 'Экспорт RSS',
	'smw_printername_table' => 'Таблица',
	'smw_printername_broadtable' => 'Широкая таблица',
	'smw_printername_template' => 'Шаблон',
	'smw_paramdesc_limit' => 'Максимальное число возвращаемых результатов',
	'smw_paramdesc_headers' => 'Показывать заголовки/названия свойств',
	'smw_paramdesc_mainlabel' => 'Обозначение, даваемое названию главной страницы',
	'smw_paramdesc_link' => 'Показывать значения как ссылки',
	'smw_paramdesc_intro' => 'Текст для отображения перед результатами запроса, если они есть',
	'smw_paramdesc_outro' => 'Текст для отображения после результатов запроса, если они есть',
	'smw_paramdesc_default' => 'Текст для отображения, если нет результатов запроса',
	'smw_paramdesc_searchlabel' => 'Текст ссылки на результатах',
	'smw_paramdesc_sep' => 'Разделитель значений',
	'smw_paramdesc_template' => 'Название шаблона, с помощью которого будут выводиться данные',
	'smw_paramdesc_columns' => 'Количество столбцов для вывода результатов поиска (по умолчанию $1)',
	'smw_paramdesc_embedformat' => 'HTML-тег, используемый для обозначения заголовков',
	'smw_paramdesc_embedonly' => 'Не отображать заголовки',
	'smw_paramdesc_rsstitle' => 'Текст, который будет использоваться в качестве названия канала',
	'smw_paramdesc_rssdescription' => 'Текст, который будет использоваться в качестве описания канала',
	'smw_iq_disabled' => 'Извините, но встроенные запросы отключены для этого сайта.',
	'smw_iq_moreresults' => '&hellip; следующие результаты',
	'smw_iq_nojs' => 'Используйте браузер с поддержкой JavaScript для просмотра данного элемента.',
	'smw_iq_altresults' => 'Просмотреть список результатов.',
	'smw_unknown_importns' => 'Ошибка: Функции импорта не доступны для пространства имен "$1".',
	'smw_nonright_importtype' => 'Ошибка: $1 может быть использован только для статей с пространством имен "$2".',
	'smw_wrong_importtype' => 'Ошибка: $1 не может быть использован для статей с пространством имен "$2".',
	'smw_no_importelement' => 'Ошибка: Элемент "$1" не доступен для импорта.',
	'smw_parseerror' => 'Переданное значение не было понято.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '',
	'smw_notitle' => '“$1” не может быть использован как заголовок статьи на данном сайте.',
	'smw_wrong_namespace' => 'Здесь допустимы только страницы из пространства имён «$1».',
	'smw_unknowntype' => 'Тип "$1" не поддерживается для данного свойства.',
	'smw_manytypes' => 'Более одного типа определено для свойства.',
	'smw_emptystring' => 'Пустые строки недопустимы.',
	'smw_maxstring' => 'Строковое представление $1 слишком длинное.',
	'smw_notinenum' => '"$1" не входит в список допустимых значений ($2) для этого свойства.',
	'smw_noboolean' => '"$1" не является булевым значением (да/нет).',
	'smw_true_words' => 'да,t,yes,д,истина,и,true',
	'smw_false_words' => 'нет,f,no,n,н,ложь,л,false',
	'smw_nofloat' => '"$1" не является числом.',
	'smw_infinite' => 'Столь длинные числа как $1 не поддерживаются.',
	'smw_infinite_unit' => 'Преобразование значения в единицы измерения «$1» привело к слишком длинному числу.',
	'smw_novalues' => 'Не указаны значения.',
	'smw_unsupportedprefix' => 'Префиксы для чисел ("$1") не поддерживаются в настоящее время.',
	'smw_unsupportedunit' => 'Преобразование единиц измерения для "$1" не поддерживается.',
	'smw_nodatetime' => 'Дата «$1» не распознана.',
	'smw_toomanyclosing' => 'Ошибка: Слишком много вхождений “$1” в данном запросе.',
	'smw_noclosingbrackets' => 'Открывающаяся пара скобок «<nowiki>[[</nowiki>» не была закрыта парой соответствующих ей закрывающих скобок «]]» в данном запросе.',
	'smw_misplacedsymbol' => 'Ошибка: Использование символа “$1” в данном месте лишено смысла.',
	'smw_unexpectedpart' => 'Ошибка: Часть “$1” запроса не была распознана. Результаты могут отличаться от ожидаемых.',
	'smw_emptysubquery' => 'Ошибка: В одном из подзапросов не указано правильного знака условия.',
	'smw_misplacedsubquery' => 'Ошибка: Подзапрос используется в месте, где подзапросы не разрешены.',
	'smw_valuesubquery' => 'Подзапросы не поддерживаются для значений свойства «$1».',
	'smw_overprintoutlimit' => 'Ошибка: Запрос содержит слишком много требований вывода.',
	'smw_badprintout' => 'Ошибка: Некоторое выражение вывода в запросе неправильно составлено.',
	'smw_badtitle' => '«$1» не является правильным заголовком статьи.',
	'smw_badqueryatom' => 'Часть запроса «<nowiki>[[…]]</nowiki>» не была разобрана.',
	'smw_propvalueproblem' => 'Ошибка: Значение свойства “$1” не разобрано.',
	'smw_noqueryfeature' => 'Часть запроса была опущена, так как некоторые из возможностей языка запросов не поддерживаются на этом вики-сайте ($1).',
	'smw_noconjunctions' => 'Часть запроса была опущена, так как операция «Логическое И» не поддерживается на этом вики-сайте ($1).',
	'smw_nodisjunctions' => 'Ошибка: Дизъюнкции (логическое ИЛИ) не поддерживаются данным сайтом, поэтому использующая их часть запроса была проигнорирована ($1).',
	'smw_querytoolarge' => 'Ошибка: Указанные условия запроса “$1” не могут быть выполнены из-за ограничения на глубину или размер запроса.',
	'smw_devel_warning' => 'Эта функция в настоящее время находится в разработке. Сделайте резервную копию прежде чем её использовать.',
	'smw_notemplategiven' => 'Чтобы данный запрос выполнялся, необходимо задать значение для параметра «template».',
	'smw_type_header' => 'Свойства типа “$1”',
	'smw_typearticlecount' => '{{PLURAL:$1|Отображается|Отображаются|Отображаются}} $1 {{PLURAL:$1|свойство|свойства|свойств}} этого типа.',
	'smw_attribute_header' => 'Страницы, использующие свойство “$1”',
	'smw_attributearticlecount' => '{{PLURAL:$1|Отображается|Отображаются|Отображаются}} $1 {{PLURAL:$1|страница, использующая|страницы, использующие|страниц, использующие}} это свойство.',
	'smw_subproperty_header' => 'Подсвойства',
	'smw_subpropertyarticlecount' => 'Это свойство имеет {{PLURAL:$1|следующее $1 подсвойство|следующие $1 подсвойства|следующие $1 подсвойств}}:',
	'smw_concept_header' => 'Страницы, использующие представление «$1»',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Показана|Показаны|Показаны}} $1 {{PLURAL:$1|страница|страницы|страниц}}, {{PLURAL:$1|принадлежащая|принадлежащие|принадлежащие}} данному представлению.',
	'smw_rss_description' => '$1 источник RSS',
	'exportrdf' => 'Экспорт страниц в RDF',
	'smw_exportrdf_docu' => 'Эта страница позволяет экспортировать части статьи в формате RDF. Наберите заголовки необходимых статей по одному на строку.',
	'smw_exportrdf_recursive' => 'Рекурсивный экспорт всех связанных страниц. Результат этой операции может быть очень большим!',
	'smw_exportrdf_backlinks' => 'Также экспортировать все страницы, которые ссылаются на экспортируемые страницы. Генерирует RDF с поддержкой полноценной навигации.',
	'smw_exportrdf_lastdate' => 'Не экспортировать страницы, которые не менялись с указанной даты.',
	'smw_exportrdf_submit' => 'Экспорт',
	'properties' => 'Свойства',
	'smw_properties_docu' => 'Следующие свойства используются на данном сайте.',
	'smw_property_template' => '$1 имеет тип $2, количество использований ($3)',
	'smw_propertylackspage' => 'Каждое свойство должно иметь свою страницу описания!',
	'smw_propertylackstype' => 'Данному свойству не сопоставлен тип данных (по умолчанию будет использоваться тип $1).',
	'smw_propertyhardlyused' => 'Это свойство изначально предопределено для данного сайта!',
	'unusedproperties' => 'Неиспользуемые свойства',
	'smw_unusedproperties_docu' => 'Следующие свойства определены, но не используются ни в одной из статей.',
	'smw_unusedproperty_template' => '$1 имеет тип $2',
	'wantedproperties' => 'Неописанные свойства',
	'smw_wantedproperties_docu' => 'Следующие свойства используются в статьях данного сайта, но не имеют соответствующих им страниц описаний.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|использование|использования|использований}})',
	'tooltip-purge' => 'Нажмите здесь для обновления всех запросов и шаблонов на этой странице',
	'smw_purge' => 'Обновить',
	'types' => 'Типы',
	'smw_types_docu' => 'Список поддерживаемых типов свойств. Каждый тип имеет страницу, на которую можно поместить его расширенное описание.',
	'smw_typeunits' => 'Единицы измерения типа “$1”: $2',
	'semanticstatistics' => 'Семантическая статистика',
	'smw_semstats_text' => "Данный сайт содержит '''$1''' {{PLURAL:$1|значение|значения|значений}} свойств, общее число которых составляет '''$2''' [[Special:Properties|{{PLURAL:$2|свойство|различных свойства|различных свойств}}]].
'''$3''' {{PLURAL:$3|свойство|свойства|свойств}} имеют страницу описания, а определённый тип данных задан для '''$4''' из них.
Некоторые из существующих свойств могут [[Special:UnusedProperties|не использоваться]].
Свойства, для которых не созданы страницы описания, перечислены в [[Special:WantedProperties|списке неописанных свойств]].",
	'uriresolver' => 'Преобразователь URI',
	'smw_uri_doc' => 'Преобразователь URI осуществляет <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C поиск http тэгов с использованием Range-14</a>. Данная возможность упрощает поиск семантической информации.',
	'ask' => 'Семантический поиск',
	'smw_ask_sortby' => 'Сортировать по столбцу (необязательно)',
	'smw_ask_ascorder' => 'По возрастанию',
	'smw_ask_descorder' => 'По убыванию',
	'smw_ask_submit' => 'Найти',
	'smw_ask_editquery' => '[Редактировать запрос]',
	'smw_add_sortcondition' => '[Добавить условие сортировки]',
	'smw_ask_hidequery' => 'Скрыть запрос',
	'smw_ask_help' => 'Помощь по составлению запросов',
	'smw_ask_queryhead' => 'Запрос',
	'smw_ask_printhead' => 'Отображать дополнительные сведения',
	'smw_ask_printdesc' => '(добавляйте по одному названию свойства на строку)',
	'smw_ask_format_as' => 'Форматировать как:',
	'smw_ask_defaultformat' => 'по умолчанию',
	'smw_ask_otheroptions' => 'Другие настройки',
	'smw_ask_show_embed' => 'Показать встроенный код',
	'smw_ask_hide_embed' => 'Скрыть встроенный код',
	'smw_ask_embed_instr' => 'Для линейного встраивания этого запроса в вики-страницу, используйте приведённых ниже код.',
	'searchbyproperty' => 'Искать по свойству',
	'smw_sbv_docu' => 'Искать все страницы, которые содержат указаннок свойство и значение.',
	'smw_sbv_novalue' => 'Укажите значение или просмотрите все значения свойства $1.',
	'smw_sbv_displayresult' => 'Список всех страниц, которые содержат свойство $1 со значением $2.',
	'smw_sbv_displayresultfuzzy' => 'Список всех страниц, содержащих свойство «$1» со значением «$2».
Так как количество точных результатов невелико, также показаны страницы, содержащие близкие значения данного свойства.',
	'smw_sbv_property' => 'Свойство:',
	'smw_sbv_value' => 'Значение:',
	'smw_sbv_submit' => 'Найти',
	'browse' => 'Просмотреть сайт',
	'smw_browselink' => 'Просмотреть свойства',
	'smw_browse_article' => 'Введите имя страницы для начала просмотра.',
	'smw_browse_go' => 'Перейти',
	'smw_browse_show_incoming' => 'показать свойства, ссылающиеся сюда',
	'smw_browse_hide_incoming' => 'скрыть свойства, ссылающиеся сюда',
	'smw_browse_no_outgoing' => 'Эта страница не содержит свойств.',
	'smw_browse_no_incoming' => 'Нет свойства, ссылающихся на эту страницу.',
	'smw_inverse_label_default' => '$1 из',
	'smw_inverse_label_property' => 'Метка обратного свойства',
	'pageproperty' => 'Страница поиска свойств',
	'smw_pp_docu' => 'Искать все значения свойства на указанной странице. Пожалуйста введите имя страницы и имя свойства.',
	'smw_pp_from' => 'Со страницы',
	'smw_pp_type' => 'Свойство',
	'smw_pp_submit' => 'Поиск результатов',
	'smw_result_prev' => 'Предыдущая',
	'smw_result_next' => 'Следующая',
	'smw_result_results' => 'Результаты',
	'smw_result_noresults' => 'Извините, но ничего не найдено.',
	'smwadmin' => 'Администрирование Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Создание хранилища для Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Система хранения была успешно установлена.',
	'smw_smwadmin_return' => 'Вернуться к $1',
	'smw_smwadmin_updatestarted' => 'Запущен новый процесс обновления семантических данных.
Все сохранённые данные будут перестроены и восстановлены, где это необходимо.
Вы можете следить за ходом обновления на этой служебной странице.',
	'smw_smwadmin_updatenotstarted' => 'Уже запущен один процесс обновления.
Второй не создаётся.',
	'smw_smwadmin_updatestopped' => 'Все существующие процессы обновления остановлены.',
	'smw_smwadmin_updatenotstopped' => 'Чтобы остановить запущенный процесс обновления, вы должны поставить отметку, подтверждающую, что вы действительно уверены в этом решении.',
	'smw_smwadmin_docu' => 'Эта служебная страница поможет вам в процессе установки и обновления <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Не забудьте произвести резервное копирование значимых данных перед выполнением административных действий.',
	'smw_smwadmin_db' => 'Установка и обновление базы данных',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki требует наличия некоторых расширений к базе данных MediaWiki, позволяющих хранить семантические данные.
Приведённая ниже функция гарантирует, что ваша база данных установлена корректно.
Изменения, сделанные на этом шаге, не влияют на основную часть базы данных MediaWiki и могут быть при желании легко отменены.
Хотя эта функция установки может быть выполнена несколько раз не причинив никакого, её запуск необходим только один раз во время установки или обновления.',
	'smw_smwadmin_permissionswarn' => 'Причиной сбоев при выполнении SQL-команд, может быть отсутствие необходимых прав у пользователя, от имени которого вы подключаетесь к базе данных вики (проверьте ваш LocalSettings.php).
Предоставьте этому пользователю дополнительные права на создание и удаление таблиц, временно введите логин root в LocalSettings.php, или используйте обслуживающий скрипт <tt>SMW_setup.php</tt>, который может использовать настройки доступа из AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Инициализация или обновление таблиц',
	'smw_smwadmin_announce' => 'Объявление вашей вики',
	'smw_smwadmin_announcedocu' => 'У Semantic MediaWiki есть веб-сервис для объявлений новых семантических вики-сайтов.
Он используется для поддержки списка общественно доступных сайтов, использующих Semantic MediaWiki, это помогает проекту <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki project</a> получить представление о типовых использованиях Semantic MediaWiki.
<a href="http://semantic-mediawiki.org/wiki/Registry">Более подробную информацию</a> можно найти на домашней странице Semantic MediaWiki.',
	'smw_smwadmin_announcebutton' => 'Нажмите на следующую кнопку, чтобы отправить адрес вашей вики в этот сервис.
Сервис не будет регистрировать вики, не являются публично доступными, он будет хранить только публично доступную информацию.',
	'smw_smwadmin_datarefresh' => 'Восстановление и обновление данных',
	'smw_smwadmin_datarefreshdocu' => 'Можно восстановить все данные Semantic MediaWiki, основанные на текущем содержимом вики.
Это может быть полезно для восстановления сломанных данных, обновления данных в случае, если внутренний формат изменился в связи с некоторым обновлением программного обеспечения.
Обновление будет выполняться страница за страницей и займёт некоторое время.
Ниже показано как идёт процесс обновления, даётся возможность начать или прекратить обновление (если эта функция не была отключена на администратором сайте).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Обновление уже запущено.</strong>
Это нормально, что процесс обновления идём достаточно медленно, поскольку он обновляет данные лишь небольшими порциями, когда пользователь обращается к вики.
Чтобы закончить данное обновление быстрее, вы можете вызвать скрипт обслуживания MediaWiki <tt>runJobs.php</tt> (используйте настройку <tt>- maxjobs 1000</tt>, чтобы ограничить количество обновлений в одной партии).
Ориентировочный ход выполнения текущего обновления:',
	'smw_smwadmin_datarefreshbutton' => 'Начать обновление данных',
	'smw_smwadmin_datarefreshstop' => 'Остановить это обновление',
	'smw_smwadmin_datarefreshstopconfirm' => 'Да, я уверен.',
	'smw_smwadmin_support' => 'Получить поддержку',
	'smw_smwadmin_supportdocu' => 'Различные ресурсы, которые могут помочь в случае проблем:',
	'smw_smwadmin_installfile' => 'Если вы испытываете затруднения при установке, прочтите руководство в <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">файле INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Полная документация пользователя Semantic MediaWiki на <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Ошибки могут быть сообщены в <a href="https://bugzilla.wikimedia.org/">Багзиллу</a>.',
	'smw_smwadmin_questions' => 'Если у вас есть дополнительные вопросы или предложения, присоединяйтесь к обсуждению на <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">форуме пользователей Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Структура данных',
	'smw_adminlinks_displayingdata' => 'Отображение данных',
	'smw_adminlinks_inlinequerieshelp' => 'Справка по встроенным запросам',
);

/** Serbo-Croatian (Srpskohrvatski / Српскохрватски)
 * @author OC Ripper
 */
$messages['sh'] = array(
	'smw_result_prev' => 'Prethodna',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'smw-desc' => "Sprístupnenie vašej wiki pre stroje ''aj'' ľudí ([http://semantic-mediawiki.org/wiki/Help:User_manual dokumentácia])",
	'smw_edithelp' => 'Pomoc pri upravovaní vzťahov a atribútov',
	'smw_viewasrdf' => 'RDF kanál',
	'smw_finallistconjunct' => ' a',
	'smw_factbox_head' => 'Skutočnosti o $1 &mdash; Kliknutím na <span class="smwsearchicon">+</span> vyhľadáte podobné stránky.',
	'smw_isspecprop' => 'Táto vlastnosť je špeciálna vlastnosť na tejto wiki.',
	'smw_isknowntype' => 'Tento typ patrí medzi štandardné údajové typy na tejto wiki.',
	'smw_isaliastype' => 'Tento typ je alias údajového typu „$1“.',
	'smw_isnotype' => 'Tento typ „$1“ nie je štandardný údajový typ na tejto wiki a nebol ani definovaný používateľom.',
	'smw_concept_description' => 'Popis pojmu „$1”',
	'smw_no_concept_namespace' => 'Pojmy je možné definovať iba na stránkach v mennom priestore Concept:',
	'smw_multiple_concepts' => 'Každý pojem môže mať iba jednu definíciu pojmu.',
	'smw_concept_cache_miss' => 'Pojem „$1” nemožno momentálne použiť, pretože konfigurácia wiki vyžaduje, aby sa vypočítal, keď wiki nebude pripojená. Ak problém po určitej dobe nezmizne, požiadajte správcu, aby tento pojem sprístupnil.',
	'smw_noinvannot' => 'Hodnoty nemožno priradiť inverzným vlastnostiam.',
	'smw_baduri' => 'Prepáčte, URI z rozsahu "$1" na tomto mieste nie sú dostupné.',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automaticky',
	'smw_printername_count' => 'Výsledky počítania',
	'smw_printername_csv' => 'export CSV',
	'smw_printername_debug' => 'Ladiaca požiadavka (pre expertov)',
	'smw_printername_embedded' => 'Vložiť obsah stránky',
	'smw_printername_json' => 'export JSON',
	'smw_printername_list' => 'Zoznam',
	'smw_printername_ol' => 'Vymenovaný typ',
	'smw_printername_ul' => 'Rozpoložkovanie',
	'smw_printername_rss' => 'export RSS',
	'smw_printername_table' => 'Tabuľka',
	'smw_printername_broadtable' => 'Široká tabuľka',
	'smw_printername_template' => 'Šablóna',
	'smw_paramdesc_limit' => 'Maximálny počet vrátených výsledov',
	'smw_paramdesc_headers' => 'Zobrazovať hlavičky/názvy vlastností',
	'smw_paramdesc_mainlabel' => 'Označenie názvu hlavnej stránky',
	'smw_paramdesc_link' => 'Zobrazovať hodnoty ako odkazy',
	'smw_paramdesc_intro' => 'Text, ktorý sa má zobrazovať pred výsledkami požiadavky (nepovinnné)',
	'smw_paramdesc_outro' => 'Text, ktorý sa má zobrazovať po výsledkoch požiadavky (nepovinnné)',
	'smw_paramdesc_default' => 'Text, ktorý sa má zobrazovať ak požiadavka nevráti žiadne výsledky',
	'smw_paramdesc_searchlabel' => 'Text v odkaze na výsledky',
	'smw_paramdesc_sep' => 'Oddeľovač hodnôt',
	'smw_paramdesc_template' => 'Názov šablóny pomocou ktorej zobrazovať výtlačky',
	'smw_paramdesc_columns' => 'Počet stĺpcov v ktorých zobrazovať výsledky (predvolené $1)',
	'smw_paramdesc_embedformat' => 'Značka HTML na definíciu nadpisov',
	'smw_paramdesc_embedonly' => 'Nezobrazovať nadpisy',
	'smw_paramdesc_rsstitle' => 'Text, ktorý sa má použiť ako názov kanála',
	'smw_paramdesc_rssdescription' => 'Text, ktorý sa má použiť ako popis kanála',
	'smw_iq_disabled' => 'Prepáčte. Inline queries have been disabled for this wiki.',
	'smw_iq_moreresults' => '&hellip; ďalšie výsledky',
	'smw_iq_nojs' => 'Na zobrazenie tohto prvku prosím použite prehliadač so zapnutým JavaScriptom.',
	'smw_iq_altresults' => 'Prehliadať priamo zoznam výsledkov.',
	'smw_unknown_importns' => 'Funkcie importu nie sú dostupné pre menný priestor "$1".',
	'smw_nonright_importtype' => '$1 je možné použiť iba pre stránky z menného priestoru "$2".',
	'smw_wrong_importtype' => '$1 nie je možné použiť pre stránky z menného priestoru "$2".',
	'smw_no_importelement' => 'Prvok "$1" nie je dostupný na import.',
	'smw_parseerror' => 'Zadaná hodnota nebola pochopená.',
	'smw_notitle' => '„$1“ nie je možné na tejto wiki použiť ako názov stránky.',
	'smw_wrong_namespace' => 'Sú tu povolené iba stránky v mennom priestore „$1”.',
	'smw_unknowntype' => 'Pre atribút je definovaný nepodporovaný typ "$1".',
	'smw_manytypes' => 'Pre atribút bol definovaný viac ako jeden typ.',
	'smw_emptystring' => 'Prázdne reťazcie nie sú akceptované.',
	'smw_maxstring' => 'Reprezentácia reťazca $1 je príliš dlhá.',
	'smw_notinenum' => '„$1“ nie je v zozname možných hodnôt ($2) tejto vlastnosti.',
	'smw_noboolean' => '"$1" nebolo rozpoznané ako platná hodnota typy boolean (áno/nie).',
	'smw_true_words' => 'áno,true',
	'smw_false_words' => 'nie,false',
	'smw_nofloat' => '"$1" nie je číslo s plávajúcou desatinnou čiarkou.',
	'smw_infinite' => 'Čísla také veľké ako „$1“ nie sú podporované.',
	'smw_infinite_unit' => 'Konverzia na jednotky „$1“ dala ako výsledok číslo, ktoré je príliš veľké.',
	'smw_unsupportedprefix' => 'Predpony čísiel („$1“) nie sú podporované.',
	'smw_unsupportedunit' => 'konverzia jednotiek "$1" nie je podporované',
	'smw_nodatetime' => 'Nevedel som interpretovať dátum "$1".',
	'smw_toomanyclosing' => 'Zdá sa, že požiadavka obsahuje príliš mnoho výskytov „$1“.',
	'smw_noclosingbrackets' => 'Niektoré použitie „<nowiki>[[</nowiki>” vo vašej požiadavke nebolo ukončené zodpovedajúcim „]]”.',
	'smw_misplacedsymbol' => 'Symbol „$1“ bol použitý na mieste, kde nemá význam.',
	'smw_unexpectedpart' => 'Časť požiadavky „$1“ nebola pochopená.
Výsledky nemusia byť podľa očakávaní.',
	'smw_emptysubquery' => 'Niektorá subpožiadavka nemá platný stav.',
	'smw_misplacedsubquery' => 'Niektorá subpožiadavka bola použitá na mieste, kde nie sú povolené subpožiadavky.',
	'smw_valuesubquery' => 'Subpožiadavky nie sú podporované pre hodnoty vlastnosti „$1“.',
	'smw_overprintoutlimit' => 'Požiadavka obsahuje príliš mnoho požiadaviek na výpis.',
	'smw_badprintout' => 'Niektorý príkaz na výpis v požiadavke bol chybne utvorený.',
	'smw_badtitle' => 'Prepáčte, ale „$1“ nie je platný názov stránky.',
	'smw_badqueryatom' => 'Niektorá časť „<nowiki>[[…]]</nowiki>“ nebola pochopená.',
	'smw_propvalueproblem' => 'Hodnota vlastnosti „$1“ nebola pochopená.',
	'smw_noqueryfeature' => 'Táto wiki nepodporuje istú časť požiadavky a jej časť bola ignorovaná ($1).',
	'smw_noconjunctions' => 'Táto wiki nepodporuje konjunkcie v požiadavkách a časť požiadavky bola ignorovaná ($1).',
	'smw_nodisjunctions' => 'Disjunkcie nie sú v požiadavkách na tejto wiki podporované a časť požiadavky bola ignorovaná ($1).',
	'smw_querytoolarge' => 'Nasledovné podmienky požiadavky nebudú zohľadnené z dôvodu obmedzení tejto wiki na dĺžku alebo hĺbku požiadavky: $1.',
	'smw_devel_warning' => 'Táto vlastnosť je momentálne vo vývoji a nemusí byť celkom funkčná. Predtým, než ju použijete si zálohujte dáta.',
	'smw_notemplategiven' => 'Aby tento formát požiadavky fungoval, poskytnite prosím hodnotu parametra „template”.',
	'smw_type_header' => 'Vlastnosti typu „$1“',
	'smw_typearticlecount' => '{{PLURAL:$1|Zobrazuje sa $1 vlastnosť|Zobrazujú sa $1 vlastnosti|Zobrazuje sa $1 vlastností}} tohto typu.',
	'smw_attribute_header' => 'Stránky používajúce vlastnosť „$1“',
	'smw_attributearticlecount' => 'Zobrazuje sa $1 {{PLURAL:$1|stránka|stránky|stránok}}, ktoré používajú túto vlastnosť.',
	'smw_subproperty_header' => 'Podvlastnosti',
	'smw_subpropertyarticlecount' => 'Táto vlastnosť má {{PLURAL:|nasledovnú podvlastnosť|nasledovné $1 podvlastnosti|nasledovných $1 podvlastností}}:',
	'smw_concept_header' => 'Návrh „$1”',
	'smw_conceptarticlecount' => 'Zobrazuje sa $1 {{PLURAL:$1|stránka patriaca|stránky patriace|stránok patriacich}} tomuto návrhu.',
	'exportrdf' => 'Exportovať stránky do RDF',
	'smw_exportrdf_docu' => 'Táto stránka vám umožňuje exportovať časti stránok do formátu RDF. Po zadaní názvov stránok do spodného textového poľa, jeden názov na riadok, môžete exportovať stránky.',
	'smw_exportrdf_recursive' => 'Rekurzívne exportovať všetky súvisiace stránky. Pozor, výsledok môže byť veľmi veľký!',
	'smw_exportrdf_backlinks' => 'Tieť exportovať všetky stránky, ktoré odkazujú na exportované stránky. Vytvorí prehliadateľné RDF.',
	'smw_exportrdf_lastdate' => 'Neexportovať stránky, ktoré neboli zmenené od zadaného času.',
	'smw_exportrdf_submit' => 'Export',
	'properties' => 'Vlastnosti',
	'smw_properties_docu' => 'Na tejto wiki sa používajú nasledovné vlastnosti.',
	'smw_property_template' => '$1 typu $2 ($3)',
	'smw_propertylackspage' => 'Všetky vlastnosti by mali mať popisnú stránku!',
	'smw_propertylackstype' => 'Pre túto vlastnosť nebol uvedený žiadny typ (nateraz sa predpokladá typ $1).',
	'smw_propertyhardlyused' => 'Táto vlastnosť sa na wiki takmer nepoužíva!',
	'unusedproperties' => 'Nepoužité vlastnosti',
	'smw_unusedproperties_docu' => 'Nasledovné vlastnosti existujú napriek tomu, že ich nevyužíva žiadna iná stránka.',
	'smw_unusedproperty_template' => '$1 typu $2',
	'wantedproperties' => 'Žiadané vlastnosti',
	'smw_wantedproperties_docu' => 'Nasledovné vlastnosti, ktoré existujú na tejto wiki, zatiaľ nemajú popisnú stránku.',
	'smw_wantedproperty_template' => '$1 (použité {{PLURAL:$2|raz|$2-krát}})',
	'tooltip-purge' => 'Kliknutím sem obnovíte všetky dotazy a šablóny na tejto stránke',
	'smw_purge' => 'Obnoviť',
	'types' => 'Typy',
	'smw_types_docu' => 'Nasleduje zoznam všetkých údajových typov, ktoré je možné priradiť atribútom. Každý údajový typ má stránku, kde je možné poskytnúť dodatočné informácie.',
	'smw_typeunits' => 'Jednotky typu „$1“: $2',
	'semanticstatistics' => 'Sémantická štatistika',
	'smw_semstats_text' => "Táto wiki obsahuje '''$1''' {{PLURAL:$1|hodnotu|hodnoty|hodnôt}} vlastností celkom {{PLURAL:$2|'''jednej''' vlastnosti|'''$2''' rozličných vlastností|'''$2''' rozličných vlastností}}. {{PLURAL:$3|'''Jedna''' vlastnosť má|'''$3''' vlastnosti majú|'''$3''' vlastností má}} vlastnú stránku a zamýšľaný údajový typ {{PLURAL:$4|má uvedený '''$4''' z nich|majú uvedené '''$4''' z nich|má uvedených '''$4''' z nich}}.
Niektoré z existujúcich vlastností môžu byť [[Special:UnusedProperties|nepoužité]].
Vlastnosti, ktorým stále chýba stránka sa nachádzajú na [[Special:WantedProperties|zozname žiadaných vlastností]].",
	'uriresolver' => 'Prekladač URI',
	'smw_uri_doc' => 'URI resolver sa stará o implementáciu <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">W3C TAG hľadanie na httpRange-14</a>. Stará sa o to, aby sa ľudia nestali webstránkami.',
	'ask' => 'Sémantické vyhľadávanie',
	'smw_ask_sortby' => 'Zoradiť podľa stĺpca',
	'smw_ask_ascorder' => 'Vzostupne',
	'smw_ask_descorder' => 'Zostupne',
	'smw_ask_submit' => 'Nájdi výsledky',
	'smw_ask_editquery' => '[Upraviť požiadavku]',
	'smw_add_sortcondition' => '[Pridať podmienku na zoradenie]',
	'smw_ask_hidequery' => 'Skryť požiadavku',
	'smw_ask_help' => 'Pomocník pre požiadavky',
	'smw_ask_queryhead' => 'Požiadavka',
	'smw_ask_printhead' => 'Ďalšie zobrazované údaje',
	'smw_ask_printdesc' => '(pridajte jednu vlastnosť na riadok)',
	'smw_ask_format_as' => 'Formátovať ako:',
	'smw_ask_defaultformat' => 'štandardne',
	'smw_ask_otheroptions' => 'Ďalšie možnosti',
	'smw_ask_show_embed' => 'Zobraziť kód embed',
	'smw_ask_hide_embed' => 'Skryť kód embed',
	'smw_ask_embed_instr' => 'Ak chcete vložiť túto požiadavku do wiki stránky, použite dolu uvedený kód.',
	'searchbyproperty' => 'Hľadať podľa hodnoty atribútu',
	'smw_sbv_docu' => 'Hľadať na wiki článok, ktorý má atribút s istou hodnotou.',
	'smw_sbv_novalue' => 'Nebola poskytnutá hodnota. Prosím, poskytnite ju vo formulári alebo zobrazte všetky atribúty typu $1',
	'smw_sbv_displayresult' => 'Zoznam všetkých článkov, ktoré majú atribút $1 $2.',
	'smw_sbv_displayresultfuzzy' => 'Zoznam všetkých stránok, ktoré majú vlastnosť „$1” s hodnotou „$2”.
Keďže výsledkov bolo len niekoľko, zobrazujú sa aj blízke hodnoty.',
	'smw_sbv_property' => 'Atribút:',
	'smw_sbv_value' => 'Hodnota:',
	'smw_sbv_submit' => 'Hľadať výsledky',
	'browse' => 'Prehliadať wiki',
	'smw_browselink' => 'Prehliadať vlastnosti',
	'smw_browse_article' => 'Zadajte názov stránky, od ktorej chcete začať prehliadať.',
	'smw_browse_go' => 'Vykonať',
	'smw_browse_show_incoming' => 'zobraziť vlastnosti, ktoré sem odkazujú',
	'smw_browse_hide_incoming' => 'skryť vlastnosti, ktoré sem odkazujú',
	'smw_browse_no_outgoing' => 'Táto stránka neobsahuje vlastnosti.',
	'smw_browse_no_incoming' => 'Žiadne vlastnosti neodkazujú na túto stránku.',
	'smw_inverse_label_default' => '$1 z',
	'smw_inverse_label_property' => 'Označenie inverznej vlastnosti',
	'pageproperty' => 'Hľadanie vlastností stránky',
	'smw_pp_docu' => 'Hľadanie všetkých výplní vlastnosti na zadanej stránke.
Prosím, zadajte stránku aj vlastnosť.',
	'smw_pp_from' => 'Od stránky',
	'smw_pp_type' => 'Vlastnosť',
	'smw_pp_submit' => 'Výsledky hľadania',
	'smw_result_prev' => 'Späť',
	'smw_result_next' => 'Ďalej',
	'smw_result_results' => 'Výsledky',
	'smw_result_noresults' => 'Prepáčte, žiadne výsledky.',
	'smwadmin' => 'Správcovské funkcie Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Nastavenie úložiska pre Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Úložisko bolo úspešne nastavené.',
	'smw_smwadmin_return' => 'Späť na $1',
	'smw_smwadmin_updatestarted' => 'Začal sa nový proces aktualizácie sémantických údajov.
Všetky uložené údaje budú znova zostavené alebo opravené tam, kde je to potrebné.
Na tejto špeciálnej stránke môžete sledovať priebeh aktualizácie.',
	'smw_smwadmin_updatenotstarted' => 'Už beží proces aktualizácie.
Nespustí sa ďalší.',
	'smw_smwadmin_updatestopped' => 'Všetky bežiace procesy aktualizácie boli zastavené.',
	'smw_smwadmin_updatenotstopped' => 'Bežiaci proces aktualizácie môžete zastaviť označením zaškrtávacieho poľa, čím potvrdíte, že ste si naozaj istý.',
	'smw_smwadmin_docu' => 'Táto špeciálna stránka vám pomôže počas inštalácie a aktualizácie <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Pamätajte na zálohovanie dôležitých údajov pred vykonávaním správcovských funkcií.',
	'smw_smwadmin_db' => 'Inštalácia a aktualizácia databázy',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki vyžaduje niektoré rozšírenia databázy MediaWiki, aby molo ukladať sémantické údaje.
Funkcia nižšie zabezpečuje správne nastavenie databázy.
Zmeny vykonané v tomto kroku neovplyvňujú zvyšok databázy MediaWiki a ak je to potrebné, je ich možno jednoducho vrátiť.
Túto funkcia nastavenia možno vykonať viacnásobne bez akejkoľvek ujmy, ale je potrebná iba raz počas inštalácie či aktualizácie.',
	'smw_smwadmin_permissionswarn' => 'Ak táto operácia zlyhá na chybách SQL, používateľ databázy, ktorého využíva vaša wiki (pozrite sa do LocalSettings.php) pravdepodobne nemá dostatočné privilégiá.
Buď udeľte tomuto používateľovi ďalšie privilégiá na vytváranie a mazanie tabuliek, dočasne zadajte prihlasovacie údaje používateľa root databázy do LocalSettings.php alebo použite skript na údržbu t>SMW_setup.php</tt>, ktorý dokáže využiť oprávnenia z AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Inicializovať alebo aktualizovať tabuľky',
	'smw_smwadmin_announce' => 'Oznámiť vašu wiki',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki má webovú službu na oznamovanie nových sémantických wiki lokalít.
Tým pomáha  udržiavať zoznam verejných lokalít používajúcich Semantic MediaWiki. najmä aby pomohla <a href="http://semantic-mediawiki.org/wiki/SMW_Project">projektu Semantic MediaWiki</a> získať prehľad typických využití Semantic MediaWiki.
ďalšie informácie o tejto službe nájdete na <a href="http://semantic-mediawiki.org/wiki/Registry">domovskej stránke Semantic MediaWiki</a>.',
	'smw_smwadmin_announcebutton' => 'Stlačením nasledovného tlačidla odošlete URL vašej wiki tejto službe.
Služba nebude registrovať wiki, ktoré nie sú verejne prístupné a bude ukladať iba verejne dostupné informácie.',
	'smw_smwadmin_datarefresh' => 'Oprava a aktualizácia dát',
	'smw_smwadmin_datarefreshdocu' => 'Je možné obnoviť všetky údaje Semantic MediaWiki na základe aktuálneho obsahu wiki.
To sa hodí na opravu poškodených údajov alebo obnovu údajov ak sa pri aktualizácii softvéru zmenil vnútorný formát ukladania údajov.
Aktualizáciu je možné spustiť na špeciálnej stránke a nebude dokočená okamžite.
Tu sa zobrazuje priebeh aktualizácie a môžete tu spustiť alebo zastaviť aktualizácie (ak túto funkciu správca nevypol).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Aktualizácia už prebieha.</strong>
Je normálne, že aktualizácie prebieha pomaly, pretože obnovuje údaje iba po malých kúskoch naraz, keď používateľ zobrazí stránku wiki.
Rýchlejšie dokončenie tejto aktualizácie môžete dosiahnuť vyvolaním údržbového skriptu MediaWiki <tt>runJobs.php</tt> (použite voľbu <tt>--maxjobs 1000</tt> na obmedzenie počtu aktualizácií v jednej dávke).
Odhadovaný priebeh aktualizácie:',
	'smw_smwadmin_datarefreshbutton' => 'Spustiť aktualizáciu údajov',
	'smw_smwadmin_datarefreshstop' => 'Zastaviť túto aktualizáciu',
	'smw_smwadmin_datarefreshstopconfirm' => 'Áno, som si istý.',
	'smw_smwadmin_support' => 'Ako získať podporu',
	'smw_smwadmin_supportdocu' => 'V prípade problémov vám môžu pomôcť rozličné zdroje:',
	'smw_smwadmin_installfile' => 'Ak budete mať s inštaláciou problém, začnite kontrolou smerníc <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">v súbore INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Úplná používateľská dokumentácia Semantic MediaWiki sa nachádza na <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Chyby môžete oznamovať v systéme <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Ak máte ďalšie otázky alebo návrhy, zapojte sa do diskusie <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">na používateľskom fóre Semantic MediaWiki</a>.',
	'smw_adminlinks_datastructure' => 'Štruktúra údajov',
	'smw_adminlinks_displayingdata' => 'Zobrazenie údajov',
	'smw_adminlinks_inlinequerieshelp' => 'Pomoc k inline požiadavkám',
);

/** Serbian Cyrillic ekavian (Српски (ћирилица))
 * @author Sasa Stefanovic
 * @author Slaven Kosanovic
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'smw_edithelp' => 'Уређивање помоћи особина',
	'smw_viewasrdf' => 'RDF добављач',
	'smw_finallistconjunct' => ', и',
	'smw_factbox_head' => 'Чињенице о $1',
	'smw_isspecprop' => 'Ова особина је посебна особина на овом викију.',
	'smw_isknowntype' => 'Овај тип припада стандардним типовима података на овом викију.',
	'smw_isaliastype' => 'Овај тип је надимак за тип података "$1".',
	'smw_isnotype' => 'Овај тип "$1" није стандардни тип података на викију, и још увек није дефинисан.',
	'smw_concept_description' => 'Опис концепта "$1"',
	'smw_no_concept_namespace' => 'Концепте је једино могуће дефинисати на страницама у именском простору Concept:',
	'smw_multiple_concepts' => 'Свака појединачна страница концепта, може садржати дефиницију само једног концепта.',
	'smw_concept_cache_miss' => 'Концепт "$1" се тренутно не може користити, пошто конфигурација викија захтева да буде компутован офлајн.
Ако проблем не нестане за неко време, затражите од администратора сајта да учини овај концепт доступним.',
	'smw_noinvannot' => 'Вредности није могуће приписати инверзним особинама.',
	'smw_baduri' => 'URI-ји облика "$1", нису прихватљиви.',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Аутоматски',
	'smw_printername_csv' => 'CSV извоз',
	'smw_printername_debug' => 'Упит за пречишћавање (само за експерте)',
	'smw_printername_embedded' => 'Угнезди садржај странице',
	'smw_printername_json' => 'JSON извоз',
	'smw_printername_list' => 'Списак',
	'smw_printername_ol' => 'Енумерација',
	'smw_printername_rss' => 'RSS извоз',
	'smw_printername_table' => 'Табела',
	'smw_printername_broadtable' => 'Широка табела',
	'smw_printername_template' => 'Шаблон',
	'smw_paramdesc_limit' => 'Максимални број резултата који ће бити враћени',
	'smw_paramdesc_mainlabel' => 'Етикета која ће се користити за име главне странице',
	'smw_paramdesc_link' => 'Прикажи вредности у облику веза',
	'smw_paramdesc_intro' => 'Текст који треба да се прикаже прије резултата упита (у случају потребе)',
	'smw_paramdesc_outro' => 'Текст који треба да се прикаже иза резултата упита (у случају потребе)',
	'smw_paramdesc_default' => 'Текст који треба да се прикаже у случају да упит није дао резултате',
	'smw_paramdesc_searchlabel' => 'Текст у вези ка резултатима',
	'smw_paramdesc_sep' => 'Раздвајач за вредности',
	'smw_paramdesc_columns' => 'Број колона у којима ће се приказати резултати (предодређено $1)',
	'smw_paramdesc_rsstitle' => 'Текст који ће се користити као наслов у добављачу',
	'smw_paramdesc_rssdescription' => 'Текст који ће се користити као опис у добављачу',
	'smw_iq_disabled' => 'Семантички упити су онемогућени на овом викију.',
	'smw_iq_moreresults' => '... више резултата',
	'smw_iq_nojs' => 'Користите прегледач који подржава JavaScript-у како би могли да видите овај елеменат.',
	'smw_iq_altresults' => 'Директно прегледај списак резултата.',
	'smw_unknown_importns' => 'Увожење функција није могуће за именски простор "$1".',
	'smw_nonright_importtype' => '$1 се једино може користити за странице у именском простору "$2".',
	'smw_wrong_importtype' => '$1 се не може користити за странице у именском простору "$2".',
	'smw_no_importelement' => 'Елемент "$1" није расположив за увоз.',
	'smw_parseerror' => 'Дата вредност није схваћена.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '"$1" се не може користити за име странице на овом викију.',
	'smw_wrong_namespace' => 'Само странице из именског простора "$1" су дозвољене овде.',
	'smw_unknowntype' => 'Неподржан тип "$1" је дефинисан за особину.',
	'smw_manytypes' => 'Више од једног типа је дефинисано за ову особину.',
	'smw_emptystring' => 'Празни стрингови нису прихватљиви.',
	'smw_maxstring' => 'Текстуална представа $1 је предугачка.',
	'smw_notinenum' => '"$1" није на списку могућих вредности ($2) за ову особину.',
	'smw_noboolean' => '"$1" није препознат као Болова вредност (истинито/неистинито).',
	'smw_true_words' => 'истинито, и, да, д',
	'smw_false_words' => 'неистинито, н, не, н',
	'smw_nofloat' => '"$1" није број.',
	'smw_infinite' => 'Бројеви дужине као "$1" нису подржани.',
	'smw_infinite_unit' => 'Конверзија у јединице "$1" је као резултат дала предугачак број.',
	'smw_unsupportedprefix' => 'Префикси за бројеве ("$1") нису подржани.',
	'smw_unsupportedunit' => 'Конверзија јединица за јединицу "$1" није подржана.',
	'smw_nodatetime' => 'Формат датума "$1" није разумљив.',
	'smw_toomanyclosing' => 'Изгледа да је превише случајева типа "$1" у упиту.',
	'smw_noclosingbrackets' => 'Неке угласте заграде "<nowiki>[[</nowiki>" у вашем упиту, нису затворене одговарајућим "]]".',
	'smw_misplacedsymbol' => 'Симбол "$1" је искоришћен на месту где није од користи.',
	'smw_unexpectedpart' => 'Део упита "$1" није схваћен.
Резултати могу бити неочекивани.',
	'smw_emptysubquery' => 'Неки подупити не садрже ваљане услове.',
	'smw_misplacedsubquery' => 'Неки подупити су коришћени на месту где подупити нису дозвољени.',
	'smw_valuesubquery' => 'За вредности особине "$1", подупити нису подржани.',
	'smw_overprintoutlimit' => 'Упит садржи превише захтева за излазне резултате.',
	'smw_badprintout' => 'Неки параметри за упит су погрешно обликовани.',
	'smw_badtitle' => '"$1" није ваљан наслов за страницу.',
	'smw_badqueryatom' => 'Један део "<nowiki>[[…]]</nowiki>" упита није схваћен.',
	'smw_propvalueproblem' => 'Вредност за особину "$1" није схваћена.',
	'smw_noqueryfeature' => 'Неки делови овог упита нису подржани на овом викију, те је део упита изостављен ($1).',
	'smw_noconjunctions' => 'Конјукције у упитима нису подржане на овом викију, те је део упита изостављен ($1).',
	'smw_nodisjunctions' => 'Дисјункције у упитима нису подржане на овом викију, те је део упита изостављен ($1).',
	'smw_querytoolarge' => 'Следеће услове упита није могуће разматрати због рестрикција викија за дужину и обим упита: $1.',
	'smw_devel_warning' => 'Ова карактеристика је тренутно још у развоју, те је могуће да није потпуно функционална.
Направите резервну копију ваших података пре њеног коришћења.',
	'smw_notemplategiven' => 'Понудите вредност за параметар ”шаблон”, како би овај формат упита дао резултат.',
	'smw_type_header' => 'Особине типа "$1"',
	'smw_typearticlecount' => 'Приказ $1 {{PLURAL:$1|особине|особина}} за овај тип.',
	'smw_attribute_header' => 'Странице које користе особину "$1"',
	'smw_attributearticlecount' => 'Приказ $1 {{PLURAL:$1|странице|страница}} које користе ову особину.',
	'smw_subproperty_header' => 'Подособине',
	'smw_subpropertyarticlecount' => 'Ова особина садржи следећу/е $1 {{PLURAL:$1|подособину|подособине}}:',
	'smw_concept_header' => 'Странице концепта "$1"',
	'smw_conceptarticlecount' => 'Приказ $1 {{PLURAL:$1|странице|страница}} које припадају том концепту.',
	'smw_rss_description' => '$1 RSS добављач',
	'specialpages-group-smw_group' => 'Семантички медијавики',
	'exportrdf' => 'Извези странице у RDF',
	'smw_exportrdf_docu' => 'Ова страница омогућава добијање података из странице у RDF формату.
Како би извезли странице, унесите наслове у доњи формулар, по принципу један наслов за сваки ред.',
	'smw_exportrdf_recursive' => 'Рекурзивно извези све повезане странице.
Обратите пажњу да резултат може бити веома обиман!',
	'smw_exportrdf_backlinks' => 'Такође извези све странице које вежу на већ извезене странице.
Генерише RDF који је могуће прегледати.',
	'smw_exportrdf_lastdate' => 'Не извози странице које нису мењане од датог момента.',
	'smw_exportrdf_submit' => 'Извоз',
	'properties' => 'Особине',
	'smw_properties_docu' => 'Следеће особине се користе на викију.',
	'smw_property_template' => '$1 типа $2 ($3)',
	'smw_propertylackspage' => 'Све особине требају имати описну страницу!',
	'smw_propertylackstype' => 'Нема дефинисаног типа за ову особину (за сада усвајам тип $1).',
	'smw_propertyhardlyused' => 'Ова особина једва да се користи на овом  викију!',
	'unusedproperties' => 'Неискоришћене особине',
	'smw_unusedproperties_docu' => 'Следеће особине постоје иако нема других страница које их користе.',
	'smw_unusedproperty_template' => '$1 типа $2',
	'wantedproperties' => 'Тражене особине',
	'smw_wantedproperties_docu' => 'Следеће особине се користе на викију, али још увек немају своју страницу са описом.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|употреба|употреба}})',
	'tooltip-purge' => 'Кликните овде за чишћење кеша свих упита и шаблона на овој страници',
	'smw_purge' => 'Очисти кеш',
	'types' => 'Типови',
	'smw_types_docu' => 'Следи списак свих типова података који се могу приписати особинама.
Сваки тип података има своју страницу где је могуће додати додатне информације.',
	'smw_typeunits' => 'Мерне јединице типа "$1": $2',
	'semanticstatistics' => 'Семантичке статистике',
	'smw_semstats_text' => 'Овај вики садржи <b>$1</b> вредности особина за укупно <b>$2</b> различитих <a href="$3">особина</a>.
<b>$4</b> особина поседује своју властиту страницу и намењени типови података су убележени за њих <b>$5</b>.
Неке од постојећих особина су можда<a href="$6">неискоришћене особине</a>.
Особине које још увек немају своју страницу, могу се наћи на <a href="$7">списку тражених особинаs</a>.',
	'uriresolver' => 'URI резолвер',
	'ask' => 'Семантичка претрага',
	'smw_ask_sortby' => 'Сортирај у колоне (опционо)',
	'smw_ask_ascorder' => 'Узлазећи',
	'smw_ask_descorder' => 'Силазећи',
	'smw_ask_submit' => 'Пронађи резултате',
	'smw_ask_editquery' => '[Уреди упит]',
	'smw_add_sortcondition' => '[Додај услове сортирања]',
	'smw_ask_hidequery' => 'Сакриј упит',
	'smw_ask_help' => 'Упит у странице помоћи',
	'smw_ask_queryhead' => 'Упит',
	'smw_ask_printhead' => 'Додатни подаци за приказ',
	'smw_ask_printdesc' => '(додај једно име особине по линији)',
	'smw_ask_format_as' => 'Форматирај као:',
	'smw_ask_defaultformat' => 'предодређено',
	'smw_ask_otheroptions' => 'Друге опције',
	'smw_ask_show_embed' => 'Прикажи угнеждени код',
	'smw_ask_hide_embed' => 'Сакриј угнеждени код',
	'smw_ask_embed_instr' => 'За непосредно гнеждење овог упита у страницу викија, користи доњи код.',
	'searchbyproperty' => 'Претражи по особинама',
	'smw_sbv_docu' => 'Претражи све странице које поседују дату особину и вредност.',
	'smw_sbv_novalue' => 'Унесите ваљану вредност за ову особину, или погледајте све вредности особине за "$1".',
	'smw_sbv_displayresult' => 'Списак свих страница које садрже особину "$1" са вредношћу "$2"',
	'smw_sbv_displayresultfuzzy' => 'Списак свих страница које садрже особину "$1" са вредношћу "$2".
Пошто је пронађено само неколико резултата, такође су приказане приближне вредности.',
	'smw_sbv_property' => 'Особина:',
	'smw_sbv_value' => 'Вредност:',
	'smw_sbv_submit' => 'Пронађи резултате',
	'browse' => 'Прегледај вики',
	'smw_browselink' => 'Прегледај особине',
	'smw_browse_article' => 'Унесите име почетне странице за претрагу.',
	'smw_browse_go' => 'Иди',
	'smw_browse_show_incoming' => 'прикажи особине које вежу овде',
	'smw_browse_hide_incoming' => 'сакриј особине које вежу овде',
	'smw_browse_no_outgoing' => 'Ова страница нема особина.',
	'smw_browse_no_incoming' => 'Нема особина које вежу на ову страницу.',
	'smw_inverse_label_default' => '$1 од',
	'smw_inverse_label_property' => 'Реципрочна етикета особине',
	'pageproperty' => 'Страница за претрагу особина',
	'smw_pp_docu' => 'Претражи све вредности особине на датој страници.
Унесите обоје, и страницу, и особину.',
	'smw_pp_from' => 'Од странице',
	'smw_pp_type' => 'Особина',
	'smw_pp_submit' => 'Пронађени резултати',
	'smw_result_prev' => 'Претходни',
	'smw_result_next' => 'Наредни',
	'smw_result_results' => 'Резултати',
	'smw_result_noresults' => 'Нема резултата.',
	'smwadmin' => 'Управљачке функције за Семантички медијавики',
	'smw_smwadmin_settingup' => 'Покрећем складиште за Семантички медијавики.',
	'smw_smwadmin_setupsuccess' => 'Машина за складиштење је успешно покренута.',
	'smw_smwadmin_return' => 'Повратак на $1',
	'smw_smwadmin_updatestarted' => 'Започет је нови процес за обнављање семантичких података.
Сви сачувани подаци ће бити поново обновљени или поправљени по потреби.
Можете следити ток ажурирања на овој посебној страници.',
	'smw_smwadmin_updatenotstarted' => 'Већ је у току један процес ажурирања.
Не покрећите други.',
	'smw_smwadmin_updatestopped' => 'Сви постојећи процеси ажурирања су обустављени.',
	'smw_smwadmin_updatenotstopped' => 'Како бисте обуставили покренути процес ажурирања, морате активирати контролни оквир да бисте потврдили да сте сигурни да желите да га обуставите.',
	'smw_smwadmin_docu' => 'Ова посебна страница вам помаже приликом инсталирања и ажурирања <a href="http://semantic-mediawiki.org">Семантичког медијавикија</a>.
Не заборавите да направите копију вредних података пре него покренете функције администрације.',
	'smw_smwadmin_db' => 'Инсталирање и ажурирање базе података',
	'smw_smwadmin_dbdocu' => 'Семантички медијавики захтева неке додатке у бази података Медијавикија, како би се могли чувати семантички подаци.
Доња функција потврђује да је ваша база података исправно инсталирана.
Промене које ће се сада извести немају последица за остали део базе података Медијавикија, а по потреби се могу врло лако поништити.
Ова функција инсталирања се може покретати више пута без бојазни да ће нанети неку штету, али је неопходна само једном приликом инсталирања или ажурирања.',
	'smw_smwadmin_permissionswarn' => 'Ако се операција заврши са SQL грешкама, корисник базе података (погледајте ваш LocalSettings.php) вероватно нема довољно дозвола за извршавање неопходних операција.
Или дајте неопходне дозволе том кориснику како би могао да прави и брише табеле у бази, привремено се улогујте као root у LocalSettings.php, или користите скрипту за одржавање <tt>SMW_setup.php</tt>, која може користити акредитацију из скрипте AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Покретање или ажурирање табела базе података',
	'smw_smwadmin_announce' => 'Дојавите о постојању вашег викија',
	'smw_smwadmin_announcedocu' => 'Семантички медијавики има веб сервиз за дојаву о постојању нових викија.
Тај сајт се користи за одржавање списка јавно доступних сајтова који користе Семантички медијавики, углавном ради помоћи <a href="http://semantic-mediawiki.org/wiki/SMW_Project">пројекту Семантички медијавики</a> да прикупи информације о типичним коришћењима Семантичког медијавикија.
Погледајте главну страну Семаничког медијавикија за <a href="http://semantic-mediawiki.org/wiki/Registry">више информација о овом сервизу</a>.',
	'smw_smwadmin_announcebutton' => 'Кликните на следеће дугме за слање URL-а вашег викија том сервису.
Сервис неће регистровати викије који нису јавно доступни, а једино ће сачувати јавно доступне информације.',
	'smw_smwadmin_datarefresh' => 'Поправљање података и ажурирање',
	'smw_smwadmin_datarefreshdocu' => 'Могуће је рестаурирати све податке Семантичког медијавикија, базирајући се на садржају викија.
То може бити корисно за репарацију података или обнављање података у случају да су се извршиле неке измене у унутрашњем формату због надоградње софтвера.
Ажурирање ће се обавити страницу по страницу и неће се одмах завршити.
Следећи приказ служи за надгледање ажурирања у прогресу и омогућава вам да их покренете или обуставите (осим ако администратор сајта није искључио ову могућност).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Једно ажурирање је већ у току.</strong>
Нормално је да ажурирање напредује споро, пошто се само освежавају мали делови података сваки пут када корисник приступи викију.
Да би се ово ажурирање брже завршило, можете покренути скрипту за одржавање Медијавикија <tt>runJobs.php</tt> (користите опцију <tt>--maxjobs 1000</tt> за рестрикцију броја ажурирања у једном пакету).
Процена напредовања тренутног ажурирања:',
	'smw_smwadmin_datarefreshbutton' => 'Почни ажурирање података',
	'smw_smwadmin_datarefreshstop' => 'Заустави ово ажурирање',
	'smw_smwadmin_datarefreshstopconfirm' => 'Да, сигуран сам.',
	'smw_smwadmin_support' => 'Добијање подршке',
	'smw_smwadmin_supportdocu' => 'Постоји више места која могу помоћи у случају проблема:',
	'smw_smwadmin_installfile' => 'Ако се нађете у проблемима са вашом инсталацијом, погледајте водич у <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">фајлу INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Потпуна корисничка документација за Семантички медијавики, налази се на сајту <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Багови се могу пријављивати на <a href="https://bugzilla.wikimedia.org/">Медијазилу</a>.',
	'smw_smwadmin_questions' => 'Ако имате даљих питања или сугестија, укључите се у дискусију на листи <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki user forum</a>.',
	'smw_adminlinks_datastructure' => 'Структура података',
	'smw_adminlinks_displayingdata' => 'Приказивање података',
	'smw_adminlinks_inlinequerieshelp' => 'Помоћ за непосредне упите',
);

/** Serbian Latin ekavian (Srpski (latinica))
 * @author Liangent
 * @author Michaello
 * @author Slaven Kosanovic
 */
$messages['sr-el'] = array(
	'smw_edithelp' => 'Uređivanje pomoći osobina',
	'smw_viewasrdf' => 'RDF dobavljač',
	'smw_finallistconjunct' => ', i',
	'smw_factbox_head' => 'Činjenice o $1',
	'smw_isspecprop' => 'Ova osobina je specijalna osobina na ovom vikiju.',
	'smw_isknowntype' => 'Ovaj tip pripada standardnim tipovima podataka na ovom vikiju.',
	'smw_isaliastype' => 'Ovaj tip je nadimak za tip podataka "$1".',
	'smw_isnotype' => 'Ovaj tip "$1" nije standardni tip podataka na vikiju, i još nije definisan.',
	'smw_concept_description' => 'Opis koncepta "$1"',
	'smw_no_concept_namespace' => 'Koncepte je jedino moguće definisati na stranicama u imenskom prostoru Concept:',
	'smw_multiple_concepts' => 'Na svakoj stranici koncepta, moguće je definisati samo jedan koncept.',
	'smw_concept_cache_miss' => 'Koncept "$1" se trenutno ne može koristiti, pošto konfiguracija vikija zahteva da bude komputovan oflajn.
Ako problem ne nestane za neko vreme, zatražite od administratora sajta da učini ovaj koncept dostupnim.',
	'smw_noinvannot' => 'Vrednosti nije moguće pripisati inverznim osobinama.',
	'smw_baduri' => 'URI-ji oblika "$1", nisu prihvatljivi.',
	'smw_rss_link' => 'RSS',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automatski',
	'smw_printername_csv' => 'CSV izvoz',
	'smw_printername_debug' => 'Upit za prečišćavanje (samo za eksperte)',
	'smw_printername_embedded' => 'Ugnezdi sadržaj stranice',
	'smw_printername_json' => 'JSON izvoz',
	'smw_printername_list' => 'Spisak',
	'smw_printername_ol' => 'Enumeracija',
	'smw_printername_rss' => 'RSS izvoz',
	'smw_printername_table' => 'Tabela',
	'smw_printername_broadtable' => 'Široka tabela',
	'smw_printername_template' => 'Šablon',
	'smw_paramdesc_limit' => 'Maksimalni broj rezultata koji će biti vraćeni',
	'smw_paramdesc_mainlabel' => 'Etiketa koja će se koristiti za ime glavne stranice',
	'smw_paramdesc_link' => 'Prikaži vrednosti u obliku veza',
	'smw_paramdesc_intro' => 'Tekst koji treba da se prikaže prije rezultata upita (u slučaju potrebe)',
	'smw_paramdesc_outro' => 'Tekst koji treba da se prikaže iza rezultata upita (u slučaju potrebe)',
	'smw_paramdesc_default' => 'Tekst koji treba da se prikaže u slučaju da upit nije dao rezultate',
	'smw_paramdesc_searchlabel' => 'Tekst u vezi ka rezultatima',
	'smw_paramdesc_sep' => 'Razdvajač za vrednosti',
	'smw_paramdesc_columns' => 'Broj kolona u kojima će se prikazati rezultati (predodređeno $1)',
	'smw_paramdesc_rsstitle' => 'Tekst koji će se koristiti kao naslov u dobavljaču',
	'smw_paramdesc_rssdescription' => 'Tekst koji će se koristiti kao opis u dobavljaču',
	'smw_iq_disabled' => 'Semantički upiti su onemogućeni na ovom vikiju.',
	'smw_iq_moreresults' => '... više rezultata',
	'smw_iq_nojs' => 'Koristite pregledač koji podržava JavaScript-u kako bi mogli da vidite ovaj elemenat.',
	'smw_iq_altresults' => 'Pregledaj direktno spisak rezultata.',
	'smw_unknown_importns' => 'Uvoženje funkcija nije moguće za imenski prostor "$1".',
	'smw_nonright_importtype' => '$1 se jedino može koristiti za stranice u imenskom prostoru "$2".',
	'smw_wrong_importtype' => '$1 se ne može koristiti za stranice u imenskom prostoru "$2".',
	'smw_no_importelement' => 'Element "$1" nije raspoloživ za uvoz.',
	'smw_parseerror' => 'Data vrednost nije shvaćena.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => '"$1" se ne može koristiti za ime stranice na ovom vikiju.',
	'smw_wrong_namespace' => 'Samo stranice iz imenskog prostora "$1" su dozvoljene ovde.',
	'smw_unknowntype' => 'Nepodržan tip "$1" je definisan za osobinu.',
	'smw_manytypes' => 'Više od jednog tipa je definisano za ovu osobinu.',
	'smw_emptystring' => 'Prazni stringovi nisu prihvatljivi.',
	'smw_maxstring' => 'Tekstualna predstava $1 je predugačka.',
	'smw_notinenum' => '"$1" nije na spisku mogućih vrednosti ($2) za ovu osobinu.',
	'smw_noboolean' => '"$1" nije prepoznat kao Bolova vrednost (istinito/neistinito).',
	'smw_true_words' => 'istinito, i, da, d',
	'smw_false_words' => 'neistinito, n, ne, n',
	'smw_nofloat' => '"$1" nije broj.',
	'smw_infinite' => 'Brojevi dužine kao "$1" nisu podržani.',
	'smw_infinite_unit' => 'Konverzija u jedinice "$1" je kao rezultat dala predugačak broj.',
	'smw_unsupportedprefix' => 'Prefiksi za brojeve ("$1") nisu podržani.',
	'smw_unsupportedunit' => 'Konverzija jedinica za jedinicu "$1" nije podržana.',
	'smw_nodatetime' => 'Format datuma "$1" nije razumljiv.',
	'smw_toomanyclosing' => 'Izgleda da je previše slučajeva tipa "$1" u upitu.',
	'smw_noclosingbrackets' => 'Neke iskorišćene "<nowiki>[[</nowiki>" u vašem upitu nisu zatvorene odgovarajućim "]]".',
	'smw_misplacedsymbol' => 'Simbol "$1" je iskorišćen na mestu gde nije od koristi.',
	'smw_unexpectedpart' => 'Deo upita "$1" nije shvaćen.
Rezultati mogu biti neočekivani.',
	'smw_emptysubquery' => 'Neki podupiti ne sadrže valjane uslove.',
	'smw_misplacedsubquery' => 'Neki podupiti su korišćeni na mestu gde podupiti nisu dozvoljeni.',
	'smw_valuesubquery' => 'Za vrednosti osobine "$1", podupiti nisu podržani.',
	'smw_overprintoutlimit' => 'Upit sadrži previše zahteva za izlazne rezultate.',
	'smw_badprintout' => 'Neki parametri za upit su pogrešno oblikovani.',
	'smw_badtitle' => '"$1" nije valjan naslov za stranicu.',
	'smw_badqueryatom' => 'Jedan deo "<nowiki>[[…]]</nowiki>" upita nije shvaćen.',
	'smw_propvalueproblem' => 'Vrednost za osobinu "$1" nije shvaćena.',
	'smw_noqueryfeature' => 'Neki delovi ovog upita nisu podržani na ovom vikiju, te je deo upita izostavljen ($1).',
	'smw_noconjunctions' => 'Konjukcije u upitima nisu podržane na ovom vikiju, te je deo upita izostavljen ($1).',
	'smw_nodisjunctions' => 'Disjunkcije u upitima nisu podržane na ovom vikiju, te je deo upita izostavljen ($1).',
	'smw_querytoolarge' => 'Sledeće uslove upita nije moguće razmatrati zbog restrikcija vikija za dužinu i obim upita: $1.',
	'smw_devel_warning' => 'Ova karakteristika je trenutno još u razvoju, te je moguće da nije potpuno funkcionalna.
Napravite rezervnu kopiju vaših podataka pre njenog korišćenja.',
	'smw_notemplategiven' => 'Ponudite vrednost za parametar ”šablon”, kako bi ovaj format upita dao rezultat.',
	'smw_type_header' => 'Osobine tipa "$1"',
	'smw_typearticlecount' => 'Prikaz $1 {{PLURAL:$1|osobine|osobina}} za ovaj tip.',
	'smw_attribute_header' => 'Stranice koje koriste osobinu "$1"',
	'smw_attributearticlecount' => 'Prikaz $1 {{PLURAL:$1|stranice|stranica}} koje koriste ovu osobinu.',
	'smw_subproperty_header' => 'Podosobine',
	'smw_subpropertyarticlecount' => 'Ova osobina sadrži sledeću/e $1 {{PLURAL:$1|podosobinu|podosobine}}:',
	'smw_concept_header' => 'Stranice koncepta "$1"',
	'smw_conceptarticlecount' => 'Prikaz $1 {{PLURAL:$1|stranice|stranica}} koje pripadaju tom konceptu.',
	'smw_rss_description' => '$1 RSS dobavljač',
	'specialpages-group-smw_group' => 'Semantički medijaviki',
	'exportrdf' => 'Izvezi stranice u RDF',
	'smw_exportrdf_docu' => 'Ova stranica omogućava dobijanje podataka iz stranice u RDF formatu.
Kako bi izvezli stranice, unesite naslove u donji formular, po principu jedan naslov za svaki red.',
	'smw_exportrdf_recursive' => 'Rekurzivno izvezi sve povezane stranice.
Obratite pažnju da rezultat može biti veoma obiman!',
	'smw_exportrdf_backlinks' => 'Takođe izvezi sve stranice koje vežu na već izvezene stranice.
Generiše RDF koji je moguće pregledati.',
	'smw_exportrdf_lastdate' => 'Ne izvozi stranice koje nisu menjane od datog momenta.',
	'smw_exportrdf_submit' => 'Izvoz',
	'properties' => 'Osobine',
	'smw_properties_docu' => 'Sledeće osobine se koriste na vikiju.',
	'smw_property_template' => '$1 tipa $2 ($3)',
	'smw_propertylackspage' => 'Sve osobine trebaju imati opisnu stranicu!',
	'smw_propertylackstype' => 'Nema definisanog tipa za ovu osobinu (za sada usvajam tip $1).',
	'smw_propertyhardlyused' => 'Ova osobina jedva da se koristi na ovom vikiju!',
	'unusedproperties' => 'Neiskorišćene osobine',
	'smw_unusedproperties_docu' => 'Sledeće osobine postoje iako nema drugih stranica koje ih koriste.',
	'smw_unusedproperty_template' => '$1 tipa $2',
	'wantedproperties' => 'Tražene osobine',
	'smw_wantedproperties_docu' => 'Sledeće osobine se koriste na vikiju, ali još uvek nemaju svoju stranicu sa opisom.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|upotreba|upotreba}})',
	'tooltip-purge' => 'Kliknite ovde za čišćenje keša svih upita i šablona na ovoj stranici',
	'smw_purge' => 'Očisti keš',
	'types' => 'Tipovi',
	'smw_types_docu' => 'Sledi spisak svih tipova podataka koji se mogu pripisati osobinama.
Svaki tip podataka ima svoju stranicu gde je moguće dodati dodatne informacije.',
	'smw_typeunits' => 'Merne jedinice tipa "$1": $2',
	'semanticstatistics' => 'Semantičke statistike',
	'uriresolver' => 'URI rezolver',
	'ask' => 'Semantička pretraga',
	'smw_ask_sortby' => 'Sortiraj u kolone (opciono)',
	'smw_ask_ascorder' => 'Uzlazeći',
	'smw_ask_descorder' => 'Silazeći',
	'smw_ask_submit' => 'Pronađi rezultate',
	'smw_ask_editquery' => '[Uredi upit]',
	'smw_add_sortcondition' => '[Dodaj uslove sortiranja]',
	'smw_ask_hidequery' => 'Sakrij upit',
	'smw_ask_help' => 'Upit u stranice pomoći',
	'smw_ask_queryhead' => 'Upit',
	'smw_ask_printhead' => 'Dodatni podaci za prikaz',
	'smw_ask_printdesc' => '(dodaj jedno ime osobine po liniji)',
	'smw_ask_format_as' => 'Formatiraj kao:',
	'smw_ask_defaultformat' => 'podrazumevano',
	'smw_ask_otheroptions' => 'Druge opcije',
	'smw_ask_show_embed' => 'Prikaži ugneždeni kod',
	'smw_ask_hide_embed' => 'Sakrij ugneždeni kod',
	'smw_ask_embed_instr' => 'Za neposredno gneždenje ovog upita u stranicu vikija, koristi donji kod.',
	'searchbyproperty' => 'Pretraži po osobinama',
	'smw_sbv_docu' => 'Pretraži sve stranice koje poseduju datu osobinu i vrednost.',
	'smw_sbv_novalue' => 'Unesite valjanu vrednost za ovu osobinu, ili pogledajte sve vrednosti osobine za "$1".',
	'smw_sbv_displayresult' => 'Spisak svih stranica koje sadrže osobinu "$1" sa vrednošću "$2"',
	'smw_sbv_displayresultfuzzy' => 'Spisak svih stranica koje sadrže osobinu "$1" sa vrednošću "$2".
Pošto je pronađeno samo nekoliko rezultata, takođe su prikazane približne vrednosti.',
	'smw_sbv_property' => 'Osobina:',
	'smw_sbv_value' => 'Vrednost:',
	'smw_sbv_submit' => 'Pronađi rezultate',
	'browse' => 'Pretraži viki',
	'smw_browselink' => 'Pregledaj osobine',
	'smw_browse_article' => 'Unesite ime početne stranice za pretragu.',
	'smw_browse_go' => 'Idi',
	'smw_browse_show_incoming' => 'prikaži osobine koje vežu ovde',
	'smw_browse_hide_incoming' => 'sakrij osobine koje vežu ovde',
	'smw_browse_no_outgoing' => 'Ova stranica nema osobina.',
	'smw_browse_no_incoming' => 'Nema osobina koje vežu na ovu stranicu.',
	'smw_inverse_label_default' => '$1 od',
	'smw_inverse_label_property' => 'Recipročna etiketa osobine',
	'pageproperty' => 'Stranica za pretragu osobina',
	'smw_pp_docu' => 'Pretraživanje svega što ispunjava osobinu na datoj stranici.
Unesite oboje, i stranicu i osobinu,',
	'smw_pp_from' => 'Od stranice',
	'smw_pp_type' => 'Osobina',
	'smw_pp_submit' => 'Pronađeni rezultati',
	'smw_result_prev' => 'Prethodni',
	'smw_result_next' => 'Naredni',
	'smw_result_results' => 'Rezultati',
	'smw_result_noresults' => 'Nema rezultata.',
	'smwadmin' => 'Upravljačke funkcije za Semantički medijaviki',
	'smw_smwadmin_settingup' => 'Pokrećem skladište za Semantički medijaviki.',
	'smw_smwadmin_setupsuccess' => 'Mašina za skladištenje je uspešno pokrenuta.',
	'smw_smwadmin_return' => 'Povratak na $1',
	'smw_smwadmin_updatestarted' => 'Započet je novi proces za obnavljanje semantičkih podataka.
Svi sačuvani podaci će biti ponovo obnovljeni ili popravljeni po potrebi.
Možete slediti progres ažuriranja na ovoj posebnoj stranici.',
	'smw_smwadmin_updatenotstarted' => 'Već je u toku jedan proces ažuriranja.
Ne pokrećite drugi.',
	'smw_smwadmin_updatestopped' => 'Svi postojeći procesi ažuriranja su obustavljeni.',
	'smw_smwadmin_updatenotstopped' => 'Kako biste obustavili pokrenuti proces ažuriranja, morate aktivirati kontrolni okvir da potvrdite da ste sigurni.',
	'smw_smwadmin_docu' => 'Ova posebna stranica vam pomaže prilikom instaliranja i ažuriranja <a href="<a href="http://semantic-mediawiki.org">Semantičkog">http://semantic-mediawiki.org">Semantičkog</a> medijavikija</a>.
Ne zaboravite da napravite kopiju vrednih podataka pre nego pokrenete funkcije administracije.',
	'smw_smwadmin_db' => 'Instaliranje i ažuriranje baze podataka',
	'smw_smwadmin_dbdocu' => 'Semantički medijaviki zahteva neke dodatke u bazi podataka Medijavikija, kako bi se mogli čuvati semantički podaci.
Donja funkcija potvrđuje da je vaša baza podataka ispravno instalirana.
Promene koje će se sada izvesti nemaju posledica za ostali deo baze podataka Medijavikija, a po potrebi se mogu vrlo lako poništiti.
Ova funkcija instaliranja se može pokretati više puta bez bojazni da će naneti neku štetu, ali je neophodna samo jednom prilikom instaliranja ili ažuriranja.',
	'smw_smwadmin_permissionswarn' => 'Ako se operacija završi sa SQL greškama, korisnik baze podataka (pogledajte vaš LocalSettings.php) verovatno nema dovoljno dozvola za izvršavanje neophodnih operacija.
Ili dajte neophodne dozvole tom korisniku kako bi mogao da pravi i briše tabele u bazi, temporalno se ulogujte kao root u LocalSettings.php, ili koristite skriptu za održavanje <tt>SMW_setup.php</tt>, koja može koristiti akreditive iz skripte AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Pokretanje ili ažuriranje tabela baze podataka',
	'smw_smwadmin_announce' => 'Dojavite o postojanju vašeg vikija',
	'smw_smwadmin_announcedocu' => 'Semantički medijaviki ima veb serviz za dojavu o postojanju novih vikija.
Taj sajt se koristi za održavanje spiska javno dostupnih sajtova koji koriste Semantički medijaviki, uglavnom radi pomoći <a href="<a href="http://semantic-mediawiki.org/wiki/SMW_Project">projektu">http://semantic-mediawiki.org/wiki/SMW_Project">projektu</a> Semantički medijaviki</a> da prikupi informacije o tipičnim korišćenjima Semantičkog medijavikija.
Pogledajte glavnu stranu Semaničkog medijavikija za <a href="<a href="http://semantic-mediawiki.org/wiki/Registry">više">http://semantic-mediawiki.org/wiki/Registry">više</a> informacija o ovom servizu</a>.',
	'smw_smwadmin_announcebutton' => 'Kliknite na sledeće dugme za slanje URL-a vašeg vikija tom servizu.
Serviz neće registrovati vikije koji nisu javno dostupni, i jedino će sačuvati javno dostupne informacije,',
	'smw_smwadmin_datarefresh' => 'Popravljanje podataka i ažuriranje',
	'smw_smwadmin_datarefreshdocu' => 'Moguće je restaurirati sve podatke Semantičkog medijavikija, bazirajući se na sadržaju vikija.
To može biti korisno za reparaciju podataka ili obnavljanje podataka u slučaju da su se izvršile neke izmene u unutrašnjem formatu zbog nadogradnje softvera.
Ažuriranje će se obaviti stranicu po stranicu i neće se odmah završiti.
Sledeći prikaz služi za nadgledanje ažuriranja u progresu i omogućava vam da ih pokrenete ili obustavite (osim ako administrator sajta nije isključio ovu mogućnost).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Jedno ažuriranje je već u toku.</strong>
Normalno je da ažuriranje napreduje sporo, pošto se samo osvežavaju mali delovi podataka svaki put kada korisnik pristupi vikiju.
Da bi se ovo ažuriranje brže završilo, možete pokrenuti skriptu za održavanje Medijavikija <tt>runJobs.php</tt> (koristite opciju <tt>--maxjobs 1000</tt> za restrikciju broja ažuriranja u jednom paketu).
Procena napredovanja trenutnog ažuriranja:',
	'smw_smwadmin_datarefreshbutton' => 'Počni ažuriranje podataka',
	'smw_smwadmin_datarefreshstop' => 'Obustavi ovo ažuriranje',
	'smw_smwadmin_datarefreshstopconfirm' => 'Da, siguran sam.',
	'smw_smwadmin_support' => 'Dobijanje podrške',
	'smw_smwadmin_supportdocu' => 'Postoji više mesta koja mogu biti od pomoći u slučaju problema:',
	'smw_smwadmin_installfile' => 'Ako se nađete u problemima sa vašom instalacijom, pogledajte vodič u <a href="<a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">fajlu">http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">fajlu</a> INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Potpuna korisnička dokumentacija za Semantički medijaviki, nalazi se na sajtu <b><a href="<a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.">http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.</a>',
	'smw_smwadmin_mediazilla' => 'Bagovi se mogu prijavljivati na <a href="<a href="https://bugzilla.wikimedia.org/">Medijazilu</a>.">https://bugzilla.wikimedia.org/">Medijazilu</a>.</a>',
	'smw_smwadmin_questions' => 'Ako imate daljih pitanja ili sugestija, uključite se u diskusiju na listi <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki user forum</a>.',
	'smw_adminlinks_datastructure' => 'Struktura podataka',
	'smw_adminlinks_displayingdata' => 'Prikazivanje podataka',
	'smw_adminlinks_inlinequerieshelp' => 'Pomoć za neposredne upite',
);

/** Swedish (Svenska)
 * @author Boivie
 * @author Eliasb
 * @author Flrn
 * @author Gabbe.g
 * @author Lejonel
 * @author Leo Johannes
 * @author M.M.S.
 * @author MagnusA
 * @author Najami
 * @author Per
 * @author Sannab
 */
$messages['sv'] = array(
	'smw-desc' => "Gör din wiki mer tillgänglig - för maskiner ''och'' människor ([http://semantic-mediawiki.org/wiki/Help:User_manual online documentation])",
	'smw_edithelp' => 'Redigeringshjälp för egenskaper',
	'smw_viewasrdf' => 'RDF-matning',
	'smw_finallistconjunct' => ', och',
	'smw_factbox_head' => 'Fakta om $1',
	'smw_isspecprop' => 'Den här egenskapen är en specialegenskap på den här wikin.',
	'smw_isknowntype' => 'Den här datatypen är bland standardtyperna på den här wikin.',
	'smw_isaliastype' => 'Den här datatypen är ett alias för typen "$1".',
	'smw_isnotype' => 'Datatypen "$1" är inte en standardtyp på den här wikin, och har inte heller givits en användardefinition.',
	'smw_concept_description' => 'Beskrivning av konceptet "$1"',
	'smw_no_concept_namespace' => 'Koncept kan endast defineras på sidor i namnrymden Concept:',
	'smw_multiple_concepts' => 'Varje konceptsida kan endast ha en konceptdefinition.',
	'smw_concept_cache_miss' => 'Konceptet "$1" kan inte användas för tillfället, eftersom wiki-konfigurationen kräver att det beräknas off-line.
Om problemet inte försvinner efter någon tid, så be din administratör att göra konceptet tillgängligt.',
	'smw_noinvannot' => 'Värden kan inte tilldelas inverterade egenskaper.',
	'smw_baduri' => 'Beklagar, URI-er på formen "$1" är inte tillåtet.',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Automatisk',
	'smw_printername_count' => 'Räkna resultat',
	'smw_printername_csv' => 'CSV-exportering',
	'smw_printername_debug' => 'Felsökningsfråga (för experter)',
	'smw_printername_embedded' => 'Bädda in sidinnehåll',
	'smw_printername_json' => 'JSON-exportering',
	'smw_printername_list' => 'Lista',
	'smw_printername_ol' => 'Numrering',
	'smw_printername_ul' => 'Objektisering',
	'smw_printername_rss' => 'RSS-exportering',
	'smw_printername_table' => 'Tabell',
	'smw_printername_broadtable' => 'Bred tabell',
	'smw_printername_template' => 'Mall',
	'smw_paramdesc_link' => 'Visa värden som länkar',
	'smw_paramdesc_embedonly' => 'Visa inga rubriker',
	'smw_iq_disabled' => 'Beklagar. Semantiska efterfrågningar har slagits av på den här wikin.',
	'smw_iq_moreresults' => '… mer resultat',
	'smw_iq_nojs' => 'Var god använd en webbläsare som stödjer JavaScript för att visa det här elementet.',
	'smw_iq_altresults' => 'Gå igenom resultatslistan direkt.',
	'smw_unknown_importns' => 'Importeringfunktioner är inte tillgängliga för namnrymden "$1".',
	'smw_nonright_importtype' => '$1 kan endast användas för sidor i namnrymden "$2".',
	'smw_wrong_importtype' => '$1 kan inte användas för sidor i namnrymden "$2".',
	'smw_no_importelement' => 'Elementet "$1" är inte tillgänglig för importering.',
	'smw_parseerror' => 'Det angivna värdet förståddes inte.',
	'smw_notitle' => '"$1" kan inte användas som sidnamn på den här wikin.',
	'smw_wrong_namespace' => 'Endast sidor i namnrymden "$1" tillåts här.',
	'smw_unknowntype' => 'Typen "$1" som är definierad för egenskapen stödjs inte.',
	'smw_manytypes' => 'Mer än en typ definierad för egenskapen.',
	'smw_emptystring' => 'Tomma stränger accepteras inte.',
	'smw_maxstring' => 'Strängrepresentationen $1 är för lång.',
	'smw_notinenum' => '"$1" är inte i listan över möjliga värden ($2) för den här egenskapen.',
	'smw_noboolean' => '"$1" är inte erkänt som ett Boolean-värde (sant/falskt).',
	'smw_true_words' => 'sant,s,ja,j',
	'smw_false_words' => 'falskt,f,nej,n',
	'smw_nofloat' => '"$1" är inte ett tal.',
	'smw_infinite' => 'Tal så stora som "$1" stödjs inte.',
	'smw_infinite_unit' => 'Konvertering till enheten "$1" resulterade i ett tal som är för stort.',
	'smw_novalues' => 'Inga värden angivna.',
	'smw_unsupportedprefix' => 'Prefix för tal ("$1") stödjs inte.',
	'smw_unsupportedunit' => 'Enhetskonvertering för enheten "$1" stödjs inte.',
	'smw_nodatetime' => 'Datumet "$1" förstods inte.',
	'smw_toomanyclosing' => '"$1" uppträder för många gånger i efterfrågningen.',
	'smw_noclosingbrackets' => 'Användningen av "<nowiki>[[</nowiki>" i din efterfrågning stängdes inte av "]]".',
	'smw_misplacedsymbol' => 'Symbolen "$1" användes på en plats där den inte är användbar.',
	'smw_unexpectedpart' => 'Delen "$1" av efterfrågningen förstods inte.
Vissa resultat kan bli oväntade.',
	'smw_emptysubquery' => 'Någon underfråga har inget giltigt villkor.',
	'smw_misplacedsubquery' => 'Någon underfråga användes på ett ställe där inga underfrågor tillåts.',
	'smw_valuesubquery' => 'Underfrågor stöds inte för värden på egenskapen “$1”.',
	'smw_overprintoutlimit' => 'Efterfrågningen innehåller för många utskriftsbegäran.',
	'smw_badprintout' => 'Något utskriftsuttryck i frågan var felutformad.',
	'smw_badtitle' => 'Beklagar, "$1" är inte en giltig sidtitel.',
	'smw_badqueryatom' => 'Någon del “<nowiki>[[…]]</nowiki>” av frågan förstods inte.',
	'smw_propvalueproblem' => 'Värdet på egenskap “$1” förstods inte.',
	'smw_noqueryfeature' => 'För någon frågefunktion saknades det stöd i denna wikin och delar av frågan hoppades över ($1).',
	'smw_noconjunctions' => 'För konjunktioner i frågor saknas det stöd i denna wikin och delar av frågan hoppades över ($1).',
	'smw_nodisjunctions' => 'För disjunktioner i frågor saknas det stöd i denna wikin och delar av frågan hoppades över ($1).',
	'smw_querytoolarge' => 'Följande frågevillkor kunde inte tas hänsyn till på grund av wikins begränsningar i frågestorlek eller -djup: $1.',
	'smw_devel_warning' => 'Denna funktion är under utveckling, och fungerar kanske inte fullt ut.
Gör backup på din data innan du använder den.',
	'smw_notemplategiven' => 'För att den här frågan ska fungera behöver du ange ett värde på parametern "template".',
	'smw_type_header' => 'Egenskaper av typen “$1”',
	'smw_typearticlecount' => 'Visar $1 {{PLURAL:$1|egenskap|egenskaper}} som använder den här typen.',
	'smw_attribute_header' => 'Sidor som använder egenskapen "$1"',
	'smw_attributearticlecount' => 'Visar $1 {{PLURAL:$1|sida|sidor}} som använder den här egenskapen.',
	'smw_subproperty_header' => 'Underegenskaper',
	'smw_subpropertyarticlecount' => 'Denna egenskap har följande $1 {{PLURAL:$1|underegenskap|underegenskaper}}:',
	'smw_concept_header' => 'Sidor av konceptet "$1"',
	'smw_conceptarticlecount' => 'Visar {{PLURAL:$1|en sida|$1 sidor}} som hör till det konceptet.',
	'exportrdf' => 'Exportera sidor till RDF',
	'smw_exportrdf_docu' => 'Den här sidan låter dig hämta data från en sida i RDF-format.
Skriv sidtitlar i textrutan härunder för att exportera sidor (en titel per rad).',
	'smw_exportrdf_recursive' => 'Exportera alla relaterade sidor rekursivt.
Observera att resultatet kan bli stort!',
	'smw_exportrdf_backlinks' => 'Exportera också alla sidor som refererar till de exporterade sidorna.
Skapar en RDF som kan gås igenom.',
	'smw_exportrdf_lastdate' => 'Exportera inte sidor som inte ändrats efter den uppgivna tidpunkten.',
	'smw_exportrdf_submit' => 'Exportera',
	'properties' => 'Egenskaper',
	'smw_properties_docu' => 'Följande egenskaper används i wikin',
	'smw_property_template' => '$1 av typen $2 ($3)',
	'smw_propertylackspage' => 'Alla egenskaper ska beskrivas av en sida!',
	'smw_propertylackstype' => 'Ingen typ specificerades för denna egenskap (antar typ $1 tills vidare).',
	'smw_propertyhardlyused' => 'Denna egenskap används knappt i wikin!',
	'unusedproperties' => 'Oanvända egenskaper',
	'smw_unusedproperties_docu' => 'Följande egenskaper finns fastän ingen annan sida använder dem.',
	'smw_unusedproperty_template' => '$1 av typen $2',
	'wantedproperties' => 'Önskade egenskaper',
	'smw_wantedproperties_docu' => 'Följande egenskaper används i wikin men har ännu inte en sida som beskriver dem.',
	'smw_wantedproperty_template' => '$1 (använd $2 {{PLURAL:$2|gång|gånger}})',
	'tooltip-purge' => 'Klicka här för att ladda om alla frågor och mallar på den här sidan',
	'smw_purge' => 'Uppdatera',
	'types' => 'Typer',
	'smw_types_docu' => 'Följande är en lista över alla datatyper som egenskaper kan ha.
Varje datatyp har en sida där ytterligare information kan uppges.',
	'smw_typeunits' => 'Mätenhet för typ “$1”: $2',
	'semanticstatistics' => 'Semantisk statistik',
	'smw_semstats_text' => "Denna wiki innehåller '''$1''' {{PLURAL:$1|egenskapsvärde|egenskapsvärden}} för totalt '''$2''' [[Special:Properties|{{PLURAL:$2|egenskap|olika egenskaper}}]].
'''$3''' {{PLURAL:$3|egenskap|egenskaper}} har en egen sida, och den avsedda datatypen är specificerad för '''$4''' av dessa.
Några av de existerande egenskaperna kan vara [[Special:UnusedProperties|oanvända egenskaper]].
Egenskaper som fortfarande saknar en egen sida finns på [[Special:WantedProperties|listan över önskade egenskaper]].",
	'uriresolver' => 'URI-lösare',
	'smw_uri_doc' => "URI-lösaren implementerar ''<a href=\"http://www.w3.org/2001/tag/issues.html#httpRange-14\">W3C TAG fynden i httpRange-14</a>''. Den ser till så att människor inte blir webbsidor.",
	'ask' => 'Semantisk sökning',
	'smw_ask_sortby' => 'Sortera efter kolumn (valfritt)',
	'smw_ask_ascorder' => 'Stigande',
	'smw_ask_descorder' => 'Sjunkande',
	'smw_ask_submit' => 'Hitta resultat',
	'smw_ask_editquery' => '[Redigera fråga]',
	'smw_add_sortcondition' => '[Lägg till sorteringsvillkor]',
	'smw_ask_hidequery' => 'Dölj fråga',
	'smw_ask_help' => 'Frågehjälp',
	'smw_ask_queryhead' => 'Fråga',
	'smw_ask_printhead' => 'Ytterligare utskrifter (valbart)',
	'smw_ask_format_as' => 'Formatera som:',
	'smw_ask_defaultformat' => 'standard',
	'smw_ask_otheroptions' => 'Andra alternativ',
	'smw_ask_show_embed' => 'Visa inbäddad kod',
	'smw_ask_hide_embed' => 'Göm inbäddad kod',
	'smw_ask_embed_instr' => 'För att lägga in denna fråga i en wiki-sida, använda koden nedan.',
	'searchbyproperty' => 'Sök efter egenskap',
	'smw_sbv_docu' => 'Sök efter alla sidor som har en given egenskap och värde.',
	'smw_sbv_novalue' => 'Skriv in ett giltigt värde för egenskapen, eller visa alla egenskapsvärden för “$1.”',
	'smw_sbv_displayresult' => 'En lista över alla sidor som har egenskapen “$1” med värdet “$2”',
	'smw_sbv_displayresultfuzzy' => 'En lista över alla sidor som har egenskapen "$1" med värdet "$2".
Eftersom det bara finns ett fåtal resultat, visas även näraliggande värden.',
	'smw_sbv_property' => 'Egenskap:',
	'smw_sbv_value' => 'Värde:',
	'smw_sbv_submit' => 'Hitta resultat',
	'browse' => 'Bläddra igenom wikin',
	'smw_browselink' => 'Se egenskaper',
	'smw_browse_article' => 'Skriv namnet på sidan du vill börja bläddra från.',
	'smw_browse_go' => 'Gå',
	'smw_browse_show_incoming' => 'visa egenskaper som länkar hit',
	'smw_browse_hide_incoming' => 'göm egenskaper som länkar hit',
	'smw_browse_no_outgoing' => 'Denna sida har inga egenskaper.',
	'smw_browse_no_incoming' => 'Inga egenskaper länkar till den här sidan.',
	'smw_inverse_label_default' => '$1 av',
	'smw_inverse_label_property' => 'Benämning på inverterad egenskap',
	'pageproperty' => 'Sidegenskapssökning',
	'smw_pp_docu' => 'Sök efter allt innehåll för en egenskap på en given sida.
Skriv in både en sida och en egenskap.',
	'smw_pp_from' => 'Från sida',
	'smw_pp_type' => 'Egenskap',
	'smw_pp_submit' => 'Hitta resultat',
	'smw_result_prev' => 'Föregående',
	'smw_result_next' => 'Nästa',
	'smw_result_results' => 'Resultat',
	'smw_result_noresults' => 'Beklagar, inga resultat.',
	'smwadmin' => 'Administratörsfunktioner för Semantic MediaWiki',
	'smw_smwadmin_settingup' => 'Sätter upp lagringsplats för Semantic MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Lagringsmotorn har satts upp.',
	'smw_smwadmin_return' => 'Gå tillbaka till $1',
	'smw_smwadmin_updatestarted' => 'En ny process för att uppdatera semantiska data har startats.
All lagrad data kommer att byggas om eller repareras där det behövs.
Du kan följa hur uppdateringen går på denna specialsida.',
	'smw_smwadmin_updatenotstarted' => 'En uppdateringsprocess kör redan.
Startar inte en ny.',
	'smw_smwadmin_updatestopped' => 'Alla existerande uppdateringsprocesser har stoppats.',
	'smw_smwadmin_updatenotstopped' => 'Du måste kryssa i rutan för att visa att du verkligen vill stoppa uppdateringsprocessen.',
	'smw_smwadmin_docu' => 'Denna specialsida hjälper dig under installation och uppgradering av <a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>.
Kom ihåg att ta backup på värdefulla data innan du kör administrativa funktioner.',
	'smw_smwadmin_db' => 'Databasinstallation och -uppgradering',
	'smw_smwadmin_dbdocu' => 'Semantic MediaWiki behöver några tillägg till MediaWiki-databasen för att kunna lagra semantiska data.
Funktionen nedan ser till att din databas konfigureras korrekt.
Ändringarna som görs i detta steg påverkar inte resten av MediaWiki-databasen, och kan lätt göras ogjorda om så önskas.
Denna installationsfunktion kan köras flera gånger utan att orsaka någon skada, men det är nödvändigt att köra den en gång vid installation eller uppgradering.',
	'smw_smwadmin_permissionswarn' => "Om operationen misslyckas och visar SQL-fel så har din wikis databasanvändare (kolla din LocalSettings.php) förmodligen inte tillräckliga rättigheter.
Det finns tre sätt att åtgärda detta: Ge rättigheter till användaren att skapa och radera tabeller, ändra temporärt användaren till ''root'' i LocalSettings.php, eller använd underhållsscriptet <tt>SMW_setup.php</tt>, vilken kan använda rättigheterna för AdminSettings.php.",
	'smw_smwadmin_dbbutton' => 'Initialisera eller uppgradera tabeller',
	'smw_smwadmin_announce' => 'Meddela att din wiki finns',
	'smw_smwadmin_announcedocu' => 'Semantic MediaWiki har en webbtjänst för tillkännagivande av nya semantiska wiki-webbplatser.
Den används för att upprätthålla en lista över publika webbplatser som använder Semantic MediaWiki, huvudsakligen för att hjälpa <a href="http://semantic-mediawiki.org/wiki/SMW_Project">Semantic MediaWiki-projektet</a> att få överblick över typiska användningsområden av Semantic MediaWiki.
Se hemsidan för Semantic MediaWiki för <a href="http://semantic-mediawiki.org/wiki/Registry">mer information om denna tjänst</a>.',
	'smw_smwadmin_announcebutton' => 'Tryck på följande knapp för att skicka din wikis URL till den tjänsten.
Tjänsten registrerar inte wiki:er som inte är publikt åtkomliga, och den lagrar endast publikt åtkomlig information.',
	'smw_smwadmin_datarefresh' => 'Datareparation och -uppgradering',
	'smw_smwadmin_datarefreshdocu' => 'Det är möjligt att återställa all Semantic MediaWiki-data baserat på det aktuella innehållet för din wiki.
Detta kan vara användbart för att reparera eller fräscha upp data om det interna formatet har ändrats på grund av programuppdateringar.
Uppdateringen utförs sida för sida och blir inte klar omedelbart.
Det följande visar om en uppdatering pågår och tillåter dig att starta eller stoppa uppdateringar (såvida inte denna finess har stängts av av administratören).',
	'smw_smwadmin_datarefreshprogress' => '<strong>En uppdatering pågår redan.</strong>
Det är normalt att uppdateringen fortskrider långsamt, eftersom den endast uppdaterar data i små bitar åt gången varje gång en användare använder wikin.
För att avsluta uppdateringen snabbare, kan du köra MediaWiki-scriptet <tt>runJobs.php</tt> (använd valet <tt>--maxjobs 1000</tt>  för att begränsa antalet uppdateringar per körning).
Uppskattning av hur långt uppdateringen har kommit:',
	'smw_smwadmin_datarefreshbutton' => 'Starta uppdatering av data',
	'smw_smwadmin_datarefreshstop' => 'Stoppa denna uppdatering',
	'smw_smwadmin_datarefreshstopconfirm' => 'Ja, jag är säker.',
	'smw_smwadmin_support' => 'Få support',
	'smw_smwadmin_supportdocu' => 'Flera resurser kan hjälpa dig om du får problem:',
	'smw_smwadmin_installfile' => 'Om du upplever problem med din installation så börja med att studera anvisningarna i filen <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">INSTALL</a>.',
	'smw_smwadmin_smwhomepage' => 'Den kompletta användardokumentationen till Semantic MediaWiki finns på <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => 'Fel kan rapporteras till <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_smwadmin_questions' => 'Om du har ytterligare frågor eller förslag, gå med i diskussionen på  <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki användarforum</a>.',
	'smw_adminlinks_datastructure' => 'Datastruktur',
	'smw_adminlinks_displayingdata' => 'Visar data',
	'smw_adminlinks_inlinequerieshelp' => 'Hjälp för inbäddade frågor',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'smw_edithelp' => 'లక్షణాల మార్పుకి సహాయం',
	'smw_finallistconjunct' => ', మరియు',
	'smw_factbox_head' => '$1 గురించి వాస్తవాలు',
	'smw_isspecprop' => 'ఈ లక్షణం ఈ వికీలో ప్రత్యేకం',
	'smw_concept_description' => '"$1" భావన యొక్క వివరణ',
	'smw_printername_list' => 'జాబితా',
	'smw_printername_table' => 'పట్టిక',
	'smw_printername_template' => 'మూస',
	'smw_iq_moreresults' => '… మరిన్ని ఫలితాలు',
	'smw_iq_altresults' => 'ఫలితాల జాబితాని నేరుగా చూడండి.',
	'smw_parseerror' => 'ఇచ్చిన విలువ అర్థం కాలేదు.',
	'smw_notitle' => '"$1"ని ఈ వికీలో పేజీ పేరుగా ఉపయోగించలేరు.',
	'smw_wrong_namespace' => '"$1" అనే పేరుబరితో ఉన్న పేజీలను మాత్రమే ఇక్కడ అనుమతిస్తాం.',
	'smw_emptystring' => 'ఖాళీ పదాలను అనుమతించం.',
	'smw_true_words' => 'true,t,yes,y,అవును,సత్యం',
	'smw_false_words' => 'false,f,no,n,కాదు,అసత్యం',
	'smw_nofloat' => '“$1” అనేది సంఖ్య కాదు.',
	'smw_nodatetime' => '"$1" అనే తేదీ ఏమిటో అర్థంకాలేదు.',
	'smw_badtitle' => '"$1" అన్నది సరైన పేజీ శీర్షిక కాదు.',
	'smw_type_header' => '"$1" రకపు లక్షణాలు',
	'smw_typearticlecount' => 'ఈ రకాన్ని వాడుతున్న $1 {{PLURAL:$1|లక్షణాన్ని|లక్షణాలని}} చూపిస్తున్నాం.',
	'smw_attribute_header' => '"$1" లక్షణాన్ని వాడుతున్న పేజీలు',
	'smw_attributearticlecount' => 'ఈ లక్షణాన్ని వాడుతున్న $1 {{PLURAL:$1|పేజీని|పేజీలను}} చూపిస్తున్నాం.',
	'smw_subproperty_header' => 'ఉపలక్షణాలు',
	'properties' => 'లక్షణాలు',
	'smw_properties_docu' => 'ఈ వికీలో ఈ క్రింది లక్షణాలను ఉపయోగించారు.',
	'smw_property_template' => '$2 రకం యొక్క $1 ($3)',
	'unusedproperties' => 'ఉపయోగించని లక్షణాలు',
	'smw_unusedproperties_docu' => 'ఈ క్రింది లక్షణాలు ఉన్నా వాటిని పేజీలలోనూ వాడలేదు.',
	'smw_unusedproperty_template' => '$2 రకం యొక్క $1',
	'wantedproperties' => 'కావాల్సిన లక్షణాలు',
	'smw_wantedproperties_docu' => 'ఈ క్రింది లక్షణాలను ఈ వికీలో ఉపయోగించారు కానీ ఇంకా వాటి గురించి వివరించే పేజీలేమీ లేవు.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|వాడుక|వాడుకలు}})',
	'types' => 'రకాలు',
	'smw_ask_ascorder' => 'ఆరోహణ',
	'smw_ask_descorder' => 'అవరోహణ',
	'smw_ask_printhead' => 'చూపించాల్సిన అదనపు భోగట్టా',
	'smw_ask_otheroptions' => 'ఇతర ఎంపికలు',
	'smw_sbv_property' => 'లక్షణం:',
	'smw_sbv_value' => 'విలువ:',
	'smw_browse_go' => 'వెళ్ళు',
	'smw_browse_no_outgoing' => 'ఈ పేజీలో లక్షణాలేమీ లేవు.',
	'smw_browse_no_incoming' => 'ఈ పేజీకి లంకె వేస్తున్న లక్షణాలేమీ లేవు.',
	'smw_pp_from' => 'పేజీ నుండి',
	'smw_pp_type' => 'లక్షణం',
	'smw_result_prev' => 'గత',
	'smw_result_next' => 'తదుపరి',
	'smw_result_results' => 'ఫలితాలు',
	'smw_result_noresults' => 'క్షమించండి, ఫలితాలేమీ లేవు.',
	'smw_smwadmin_announce' => 'మీ వికీని ప్రకటించండి',
	'smw_smwadmin_datarefreshbutton' => 'భోగట్టాని తాజాకరించడం ఆపివేయి',
	'smw_smwadmin_support' => 'తోడ్పాటుని పొందడం',
);

/** Tetum (Tetun)
 * @author MF-Warburg
 */
$messages['tet'] = array(
	'smw_true_words' => 'loos,l,sin,s',
	'smw_false_words' => 'sala,s,lae,la',
	'smw_result_prev' => 'Molok',
	'smw_result_next' => 'Oinmai',
);

/** Tajik (Cyrillic) (Тоҷикӣ (Cyrillic))
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'smw_sbv_value' => 'Қимат',
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'smw_browse_go' => 'Git',
	'smw_result_prev' => 'Öňki',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'smw_edithelp' => 'Tulong sa paggawa ng pagbabago sa mga pag-aari',
	'smw_viewasrdf' => 'Pasubo/pakaing RDF',
	'smw_finallistconjunct' => ', at',
	'smw_factbox_head' => 'Totoong mga bagay hinggil sa $1',
	'smw_isspecprop' => 'Ang pag-aaring ito ay isang natatanging pag-aari sa wiking ito.',
	'smw_isknowntype' => 'Ang uring ito ay kabilang sa pampantayang mga uri ng dato ng wiking ito.',
	'smw_isaliastype' => 'Ang uring ito ay isang iba pang pangalan/katawagan para sa uri ng datong "$1".',
	'smw_isnotype' => 'Ang uring "$1" ay hindi isang pamantayang uri ng dato sa loob ng wiki, at hindi rin nabigyang isang kahulugang pantagagamit.',
	'smw_concept_description' => 'Paglalarawan ng diwa/konseptong "$1"',
	'smw_no_concept_namespace' => 'Mabibigyang kahulugan lamang ang mga diwa (konsepto) sa ibabaw ng mga pahinang nasa loob ng Diwa: espasyo ng pangalan.',
	'smw_multiple_concepts' => 'Magkakaroon lamang ng isang kahulugang pangkonsepto ang bawat isang pahina ng diwa.',
	'smw_concept_cache_miss' => 'Hindi magagamit sa sandaling ito ang diwang "$1", dahil sa kinakailangan ng pagkakaayos ng wiki na tuusin ito habang hindi nakaugnay sa internet.
Kapag hindi nawala/naalis ang suliranin makalipas ang ilang panahon, pakihiling sa iyong tagapangasiwa na gawing makukuha ang diwang ito.',
	'smw_baduri' => 'Hindi pinapahintulutan ang mga URI ng pormularyong "$1".',
	'smw_rss_link' => 'RSS',
	'smw_csv_link' => 'CSV',
	'smw_printername_auto' => 'Kusa',
	'smw_printername_count' => 'Bilangin ang mga kinalabasan',
	'smw_printername_csv' => 'Luwas ng CSV',
	'smw_printername_debug' => 'Tanggalan ng depekto ang tanong (para sa mga dalubhasa)',
	'smw_printername_embedded' => 'Ibaon ang mga nilalaman ng pahina',
	'smw_printername_json' => 'Luwas ng JSON',
	'smw_printername_list' => 'Talaan',
	'smw_printername_ol' => 'Pagtatala',
	'smw_printername_ul' => 'Pag-iisa-isa',
	'smw_printername_rss' => 'Luwas ng RSS',
	'smw_printername_table' => 'Tabla',
	'smw_printername_broadtable' => 'Malawak na tabla',
	'smw_printername_template' => 'Suleras',
	'smw_iq_disabled' => 'Hindi pinagana ang mga katanungang hinggil sa kahulugan ng salita (semantiko) para sa wiking ito.',
	'smw_iq_moreresults' => '… karagdagang mga resulta/kinalabasan',
	'smw_iq_nojs' => "Gumamit ng isang pantingin-tingin (''browser'') na pinagana ng JavaScript ipang matingnan ang langkap (elemento) na ito.",
	'smw_iq_altresults' => 'Tuwirang tumitingin-tingin sa talaan ng kinalabasan/resulta.',
	'smw_unknown_importns' => 'Hindi makukuha ang mga tungkuling pang-angkat para sa espasyo ng pangalang "$1".',
	'smw_nonright_importtype' => 'Magagamit lamang ang $1 para sa mga pahinang may espasyo ng pangalang "$2".',
	'smw_wrong_importtype' => 'Hindi magagamit ang $1 para sa mga pahinang nasa loob ng espasyo ng pangalang "$2".',
	'smw_no_importelement' => 'Hindi makukuha ang langkap (elemento) na "$1" upang maangkat.',
	'smw_parseerror' => 'Hindi naunawaan ang ibinigay na halaga.',
	'smw_notitle' => 'Hindi magagamit sa loob ng wiking ito ang "$1" bilang isang pangalan ng pahina.',
	'smw_wrong_namespace' => 'Tanging mga pahinang nasa espasyo ng pangalang "$1" ang pinapahintulutan dito.',
	'smw_unknowntype' => 'Binigyang kahulugan para sa pag-aari ang hindi tinatangkilik na uring "$1".',
	'smw_manytypes' => 'Mahigit sa isang uri ang binigyang kahulugan para sa pag-aari.',
	'smw_emptystring' => 'Hindi tinatanggap ang mga bagting na walang laman.',
	'smw_maxstring' => 'Napakahaba ng kumakatawan para sa bagting na $1.',
	'smw_notinenum' => 'Ang "$1" ay wala sa loob ng talaan ng maaaring maging mga halaga ($2) para sa pag-aaring ito.',
	'smw_noboolean' => "Ang \"\$1\" ay hindi kinikilala bilang isang halaga ng ''Boolean'' (tama/mali).",
	'smw_true_words' => 'totoo,t,oo,o',
	'smw_false_words' => 'mali,m,hindi,h',
	'smw_nofloat' => 'Hindi isang bilang ang "$1".',
	'smw_infinite' => 'Hindi tinatangkilik ang mga bilang na kasinlaki ng "$1".',
	'smw_infinite_unit' => 'Ang pagpapalit patungo sa yunit na "$1" ay nagresulta sa isang bilang na napakalaki.',
	'smw_unsupportedprefix' => 'Hindi tinatangkilik ang mga unlapi para sa mga bilang ("$1").',
	'smw_unsupportedunit' => 'Hindi tinatangkilik ang pagpapalit ng yunit para sa bahaging "$1".',
	'smw_nodatetime' => 'Hindi naunawaan ang petsang "$1".',
	'smw_toomanyclosing' => 'Tila mayroong napakaraming mga kaganapan ng "$1" sa loob ng katanungan.',
	'smw_noclosingbrackets' => 'Ilang mga paggamit ng "<nowiki>[[</nowiki>" sa loob ng iyong katanungan ang hindi naisara sa pamamagitan ng isang tumutugmang "]]".',
	'smw_misplacedsymbol' => 'Ginamit ang sagisag na "$1" sa loob ng isang pook na hindi naman ito magagamit (walang pakinabang).',
	'smw_unexpectedpart' => 'Hindi naunawaan ang bahaging "$1" ng katanungan.
Maaaring hindi inaasahan ang magiging mga kinalabasan.',
	'smw_emptysubquery' => 'Walang tanggap na kalagayan (kalakaran) ang kabahaging katanungan.',
	'smw_misplacedsubquery' => 'Hindi ginamit ang ilang kabahaging mga katanungan sa loob ng isang pook kung saan hindi pinapahintulutan ang mga kabahaging katanungan.',
	'smw_valuesubquery' => 'Hindi tinatangkilik ang kabahaging mga katanungan para sa mga halaga ng pag-aaring "$1".',
	'smw_overprintoutlimit' => 'Naglalaman ang katanungan ng napakaraming mga kahilingan ng paglilimbag.',
	'smw_badprintout' => 'Ilan sa mga panlimbag na pahayag sa loob ng katanungan ay may maling hugis.',
	'smw_badtitle' => 'Ang "$1" ay hindi isang tanggap na pamagat ng pahina.',
	'smw_badqueryatom' => 'Hindi naunawaan ang ilang bahaging "<nowiki>[[…]]</nowiki>" ng katanungan.',
	'smw_propvalueproblem' => 'Hindi naunawaan ang halaga ng pag-aaring "$1".',
	'smw_noqueryfeature' => 'Ilang katangiang-kasangkapan ng katanungan ay hindi tinatangkilik sa wiking ito at inilaglag na ang bahagi ng katanungan ($1).',
	'smw_noconjunctions' => 'Hindi tinatangkilik sa wiking ito ang mga pangatnig at inilaglag na ang bahagi ng katanungan ($1).',
	'smw_nodisjunctions' => 'Hindi tinatangkilik sa wiking ito ang pagkakakalas-kalas sa mga katanungan at inilaglag na ang bahgi ng katanungan ($1).',
	'smw_querytoolarge' => 'Hindi maisasaalang-alang ang sumusunod na mga kalagayan ng katanungan dahil sa mga hangganan ng mga wiki sa sukat o lalim ng katanungan: $1.',
	'smw_devel_warning' => 'Kasalukuyang pinauunlad pa ang katangiang-kasangkapang ito, at maaaring hindi pa ganap na gumagana/umaandar.
Magtabi/magdagdag ng pamalit na kopya/sipi ng dato mo bago ito gamitin.',
	'smw_notemplategiven' => 'Magbigay ng isang halaga para sa parametrong "suleras" upang gumana/maganap ang ganitong anyo/pormat ng katanungan.',
	'smw_type_header' => 'Mga pag-aari ng uring "$1"',
	'smw_typearticlecount' => 'Nagpapakita ng $1 na {{PLURAL:$1|pag-aari|mga pag-aari}}ng ginagamitan ng ganitong uri.',
	'smw_attribute_header' => 'Mga pahinang gumagamit na pag-aaring "$1"',
	'smw_attributearticlecount' => 'Nagpapakita ng $1 {{PLURAL:$1|pahina|mga pahina}}ng ginagamitan ng ganitong ari-arian.',
	'smw_subproperty_header' => 'Kabahaging mga pag-aari',
	'smw_subpropertyarticlecount' => 'Ang pag-aaring ito ay mayroong sumusunod na $1 {{PLURAL:$1|kabahaging ari-arian|kabahaging mga ari-arian}}:',
	'smw_concept_header' => 'Mga pahina ng diwang "$1"',
	'smw_conceptarticlecount' => 'Nagpapakita ng $1 {{PLURAL:$1|pahina|mga pahina}}ng kasali sa ganyang diwa.',
	'exportrdf' => 'Iluwas/Ipadala ang mga pahina patungo sa RDF',
	'smw_exportrdf_docu' => 'Ipinapahintulot ng pahinang ito na makakuha ka ng dato mula sa isang pahinang nasa anyong RDF.
Upang makapagluwas ng mga pahina, ipasok ang mga pamagat sa loob ng kahong pangtekstong nasa ibaba, isang pamagat bawat guhit/hanay.',
	'smw_exportrdf_recursive' => 'Tumatawag sa sarili na angkatin ang lahat ng kaugnay na mga pahina.
Tandaan lamang na maaaring malaki ang kinalabasan/resulta!',
	'smw_exportrdf_backlinks' => 'Nagluluwas din ng lahat ng mga pahinang tumutukoy sa iniluwas na mga pahina.
Gumagawa ng matitingnan-tingnang RDF.',
	'smw_exportrdf_lastdate' => 'Huwag iluwas ang mga pahinang hindi nabago mula sa isang ibinigay na sandali sa loob ng panahon/oras.',
	'smw_exportrdf_submit' => 'Iluwas',
	'properties' => 'Mga pag-aari',
	'smw_properties_docu' => 'Ginagamit sa wiki ang sumusunod na mga pahina ng pag-aari.',
	'smw_property_template' => '$1 ng uring $2 ($3)',
	'smw_propertylackspage' => 'Lahat ng mga pag-aari ay dapat na nilalarawan ng isang pahina!',
	'smw_propertylackstype' => 'Walang uring tinukoy para sa pag-aaring ito (ipapalagay na nasa uring $1 muna sa ngayon).',
	'smw_propertyhardlyused' => 'Madalang gamitin ang ganitong pag-aari sa loob ng wiking ito!',
	'unusedproperties' => 'Mga pag-aaring hindi pa nagagamit',
	'smw_unusedproperties_docu' => 'Umiiral ang sumusunod na mga pag-aari bagaman wala namang ibang pahinang gumagamit ng mga ito.',
	'smw_unusedproperty_template' => '$1 ng uring $2',
	'wantedproperties' => 'Ninanais na mga ari-arian',
	'smw_wantedproperties_docu' => 'Ginagamit sa loob ng wiki ang sumusunod na mga pag-aari ngunit wala pang isang pahinang naglalarawan sa kanila.',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|gamit|mga gamit}})',
	'tooltip-purge' => 'Pindutin dito upang masariwa ang lahat ng mga katanungan at mga suleras na nasa pahinang ito',
	'smw_purge' => 'Sariwain',
	'types' => 'Mga uri',
	'smw_types_docu' => 'Ang sumusunod ay isang talaan ng lahat ng mga uri ng datong maaaring italaga sa mga pag-aari.
Mayroong isang pahina ang bawat uri ng dato kung saan maaaring makapagbigay ng karagdagang kabatiran.',
	'smw_typeunits' => 'Mga yunit ng sukat ng uring "$1": $2',
	'semanticstatistics' => 'Mga estadistika ng Semantiko (hinggil sa kahulugan ng mga salita)',
	'smw_semstats_text' => "Naglalaman ang wiking ito ng '''$1''' {{PLURAL:$1|halaga|mga halaga}} ng ari-ariang may kabuoang '''$2''' [[Special:Properties|{{PLURAL:$2|ari-arian|iba't ibang ari-arian}}]].
'''$3''' {{PLURAL:$3|pag-aari ang may|mga pag-aari ang may mga}} sariling pahina na, at ang inilalaang uri ng dato ay tinukoy para sa '''$4''' ng mga iyon.
Ilan sa umiiral na mga ari-arian ay maaaring [[Special:UnusedProperties|hindi ginagamit na mga pag-aari]].
Ang mga ari-ariang wala pa ring isang pahina ay matatagpuan sa [[Special:WantedProperties|talaan ng ninanais na mga pag-aari]].",
	'uriresolver' => 'tagalutas ng URI',
	'smw_uri_doc' => 'Ipinatutupad ng tagapaglutas na URI ang <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">Paghahanap ng W3C TAG sa httpRange-14</a>.
Pinag-iingatan nitong huwag maging mga sityo ng web (websayt) ang mga tao.',
	'ask' => 'Paghahanap hinggil sa kahulugan ng mga salita (semantiko)',
	'smw_ask_sortby' => 'Pagpangkat-pangkating ayon sa pahabang kahanayan (maaaring wala nito)',
	'smw_ask_ascorder' => 'Tumataas',
	'smw_ask_descorder' => 'Bumababa',
	'smw_ask_submit' => 'Hanapin ang mga kinalabasan/resulta',
	'smw_ask_editquery' => '[Baguhin ang katanungan]',
	'smw_add_sortcondition' => '[Idagdag ang kalagayang pampagpapangkat-pangkat]',
	'smw_ask_hidequery' => 'Itago ang katanungan',
	'smw_ask_help' => 'Tulong sa pagtatanong',
	'smw_ask_queryhead' => 'Katanungan',
	'smw_ask_printhead' => 'Karagdagang mga datong ipapakita',
	'smw_ask_format_as' => 'Iayos bilang:',
	'smw_ask_defaultformat' => 'likas na katakdaan',
	'smw_ask_show_embed' => 'Ipakita ang kodigong pambaon',
	'smw_ask_hide_embed' => 'Ibaong nakakubli ang kodigo',
	'smw_ask_embed_instr' => 'Upang maibaon ang katanungang ito sa loob ng guhit papasok sa isang pahina ng wiki, gamitin ang kodigong nasa ibaba.',
	'searchbyproperty' => 'Maghanap ayon sa pag-aari',
	'smw_sbv_docu' => 'Hanapin ang lahat ng mga pahinang may isang ibinigay na pag-aari at halaga.',
	'smw_sbv_novalue' => 'Maglagay/magpasok ng isang tanggap na halaga para sa pag-aari, o tingnan ang lahat ng mga halaga ng ari-arian para sa "$1".',
	'smw_sbv_displayresult' => 'Isang talaan ng lahat ng mga pahinang may pag-aaring "$1" na may halagang "$2"',
	'smw_sbv_displayresultfuzzy' => 'Isang talaan ng lahat ng mga pahinang may pag-aaring "$1" na may halagang "$2".
Dahil mayroong mangilan-ngilang mga kinalabasan lamang, ipinakikita rin ang kalapit na mga halaga.',
	'smw_sbv_property' => 'Pag-aari:',
	'smw_sbv_value' => 'Halaga:',
	'smw_sbv_submit' => 'Hanapin ang mga kinalabasan',
	'browse' => 'Tumingin-tingin sa wiki',
	'smw_browselink' => 'Tumingin-tingin sa mga pag-aari',
	'smw_browse_article' => 'Ipasok/ilagay ang pangalan ng pahinang pagsisimulan ng pagtingin-tingin.',
	'smw_browse_go' => 'Gawin na',
	'smw_browse_show_incoming' => 'ipakita ang mga pag-aaring kumakawing (umuugnay) dito',
	'smw_browse_hide_incoming' => 'itago ang mga pag-aaring kumakawing (umuugnay) dito',
	'smw_browse_no_outgoing' => 'Walang mga pag-aari ang pahinang ito.',
	'smw_browse_no_incoming' => 'Walang mga pag-aaring nakakawing (umuugnay) patungo sa pahinang ito.',
	'smw_inverse_label_default' => '$1 ng',
	'smw_inverse_label_property' => 'Ibinaligtad na tatak ng pag-aari',
	'pageproperty' => 'Paghahanap sa pag-aari ng pahina',
	'smw_pp_docu' => 'Hanapin ang lahat ng mga pampuno ng isang pag-aari sa isang ibinigay na pahina.
Kapwa ipasok ang isang pahina at isang pag-aari.',
	'smw_pp_from' => 'Mula sa pahina',
	'smw_pp_type' => 'Pag-aari',
	'smw_pp_submit' => 'Hanapin ang mga resulta',
	'smw_result_prev' => 'Sinundan',
	'smw_result_next' => 'Susunod',
	'smw_result_results' => 'Mga kinalabasan (resulta)',
	'smw_result_noresults' => 'Walang mga kinalabasan/resulta.',
	'smwadmin' => 'Mga tungkulin ng tagapangasiwa para sa Semantikong MediaWiki',
	'smw_smwadmin_settingup' => 'Inihahanda ang taguan para sa Semantikong MediaWiki',
	'smw_smwadmin_setupsuccess' => 'Matagumpay na naihanda ang makina ng pagtatago.',
	'smw_smwadmin_return' => 'Magbalik sa $1',
	'smw_smwadmin_updatestarted' => 'Sinimulan na ang isang bagong pagpapatakbo/proseso ng pagsasapanahon para sa pagsasariwa ng datong semantiko (hinggil sa kahulugan ng salita).
Lahat ng nakatabing mga dato ay muling bubuoin o kukumpunihin/iaayos kung saan kailangan.
Masusundan mo ang pagsulong/progreso ng pagsasapanahon sa natatanging pahinang ito.',
	'smw_smwadmin_updatenotstarted' => 'Mayroon nang isang umaandar na pagpapatakbo ng pagsasapanahon.
Hindi na lilikha ng isa pa.',
	'smw_smwadmin_updatestopped' => 'Inihinto ang lahat ng umiiral na mga pagpapatakbong pangpagsasapanahon.',
	'smw_smwadmin_updatenotstopped' => 'Upang mapahinto ang pagpapaandar ng pagpapatakbo ng pagsasapanahon, dapat mong pasiglahin ang kahong lagayan ng tsek para maipahayag na nakatitiyak kang talaga.',
	'smw_smwadmin_docu' => 'Tumutulong ang natatanging pahinang ito sa iyo sa panahon ng pagluluklok at pagtataas ng uri ng <a href="http://semantic-mediawiki.org">Semantikong MediaWiki</a>.
Huwag kalimutang gumawa ng karagdagang sipi ng mahalagang dato bago isagawa ang mga tungkuling pangtagapangasiwa.',
	'smw_smwadmin_db' => 'Pagluluklok (instalasyon) at pagtataas ng uri (grado/klase) ng kalipunan ng dato',
	'smw_smwadmin_dbdocu' => 'Nangangailangan ang Semantikong Mediawiki ng ilang mga karugtong sa kalipunan ng dato ng MediaWiki upang maitabi ang datong hinggil sa kahulugan ng mga salita.
Tinitiyak ng tungkuling nasa ibaba na tama ang pagkakahanda ng kalipunan ng dato mo.
Hindi nakakaapekto ang mga pagbabagong ginawa sa hakbang na ito sa iba pang mga bahagi ng kalipunan ng dato ng MediaWiki, at madaling/maginhawang maibabalik kung nanaisin.
Maaaring isagawa ng maramihang ulit ang tungkulin ng paghahandang ito na hindi nakapagdurulot ng anumang pinsala, subalit isang ulit lamang itong kailangan sa pagluluklok/instalasyon o pagtataas ng uri/grado.',
	'smw_smwadmin_permissionswarn' => 'Kapag nabigo ang pagsasagawa na may mga kamaliang pang-SQL, maaaring walang sapat na mga kapahintulutan ang tagagamit ng kalipunan ng dato na hinirang ng iyong wiki (suriin/tingnan ang iyong LocalSettings.php).
Maaaring bigyan ang tagagamit na ito ng karagdagang mga kapahintulutan upang makalikha at makapagbura ng mga tabla, pansamantalang ipasok ang panglagda ng iyong ugat ng kalipunan ng dato sa LocalSettings.php, o gamitin ang panitik na pampagpapanatiling <tt>SMW_setup.php</tt> na makagagamit ng mga kredensyal (katibayan ng kapangyarihan at pagtitiwala) ng AdminSettings.php.',
	'smw_smwadmin_dbbutton' => 'Umpisahan o itaas ang uri (klase) ng mga tabla',
	'smw_smwadmin_announce' => 'Ipahayag ang wiki mo',
	'smw_smwadmin_announcedocu' => 'Ang Semantikong Mediawiki ay mayroong isang palingkurang pangweb para sa pagpapahayag ng bagong mga sayt ng bagong wiking semantiko (hinggil sa kahulugan ng mga salita).
Ginagamit ito upang makapagpanatili ng isang talaan ng mga sityong pangmadala/pampublikong gumagamit ng Semantikong MediaWiki, pangunahin na upang tulungan ang <a href="http://semantic-mediawiki.org/wiki/SMW_Project">proyektong Semantikong MediaWiki</a> upang makakuha ng pang-ibabaw/pangunahing paglalarawan ng karaniwang mga paggamit ng Semantikong MediaWiki.
Tingnan ang tahanang pahina ng Semantikong MediaWiki para sa <a href="http://semantic-mediawiki.org/wiki/Registry">karagdagan pang kabatiran hinggil sa serbisyong ito</a>.',
	'smw_smwadmin_announcebutton' => 'Pindutin ang sumusunod na pindutan upang maipasa/maipadala ang URL mong pangwiki patungo sa palingkurang iyan.
Hindi itatala ng palingkuran ang mga wiki na hindi mapupuntahan ng madla, at itatago lamang nito ang kabatiran napupuntahan ng publiko.',
	'smw_smwadmin_datarefresh' => 'Pagkukumpuni at pagtataas ng uri (grado/klase) ng dato',
	'smw_smwadmin_datarefreshdocu' => 'Maaaring maibalik muli ang lahat ng dato ng Semantikong MediaWiki batay sa pangkasalukuyang mga nilalaman ng wiki.
Magiging gamitin ito sa pagaayos/pagkukumpuni ng nasirang dato o upang masariwa ang dato kung nabago ang panloob na kaanyuan/pormat dahil sa ilang mga pagtataas ng uri ng sopwer.
Isinasakatuparan ang pagsasapanahon ng pahina sa pahina at hindi agad-agarang mabubuo.
Ipinapakita ng sumusunod kung sumusulong na ang isang pagsasapanahon at magpapahintulot sa iyo upang simulan o pahintuin ang mga pagsasapanahon (maliban na lamang kung hindi pinagana/pinaandar ng tagapangasiwa ng sityo/sayt ang katangiang-kasangkapang ito).',
	'smw_smwadmin_datarefreshprogress' => '<strong>Sumusulong na ang isang pagsasapanahon.</b>
Pangkaraniwan lamang na mabagal ang pagsulong ng pagsasapanahon dahil sinasariwa lamang nito ang maliliit na tipak ng dato sa bawat panahong pumupunta sa wiki ang isang tagagamit.
Upang mas mabilisang matapos ang pagsasapanahong ito, maaari mong tawagin ang panitik na pangpagpapanatiling <tt>runJobs.php</tt> (gamitin ang pagpipiliang <tt>--maxjobs 1000</tt> ng MediaWiki upang mabigyan ng hangganan ang bilang ng mga pagsasapanahong ginagawa sa bawat isang bungkos).
Tinatayang progreso ng pangkasalukuyang pagsasapanahon:',
	'smw_smwadmin_datarefreshbutton' => 'Umpisahang isapanahon ang dato',
	'smw_smwadmin_datarefreshstop' => 'Ihinto ang pagsasapanahong ito',
	'smw_smwadmin_datarefreshstopconfirm' => 'Oo, nakatitiyak ako.',
	'smw_smwadmin_support' => 'Pagkuha ng suporta',
	'smw_smwadmin_supportdocu' => 'Maaaring makatulong sa iyo ang sari-saring kapakipakinabang na mga bagay-bagay kung sakaling magkaroon ng mga suliranin:',
	'smw_smwadmin_installfile' => 'Kung sakaling makaranas ka ng mga suliranin hinggil sa iyong pag-iinstala/gawaing panluluklok, magsimula sa pagsusuri ng mga pamamatnubay na nasa loob ng <a href="http://svn.wikimedia.org/svnroot/mediawiki/trunk/extensions/SemanticMediaWiki/INSTALL">ILUKLOK ang talaksan</a>.',
	'smw_smwadmin_smwhomepage' => 'Ang buong kasulatang pantagagamit ng Semantikong Mediawiki ay nasa <b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>.',
	'smw_smwadmin_mediazilla' => "Maaaring iulat ang mga depekto/sira (''bug'') sa <a href=\"https://bugzilla.wikimedia.org/\">Bugzilla</a>.",
	'smw_smwadmin_questions' => 'Kung mayroon ka pang karagdagang mga katanungan o mga mungkahi, makilahok sa usapang nasa <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Pangmadlang talakayan ng tagagamit ng MediaWiking Semantiko</a>.',
);

/** Turkish (Türkçe)
 * @author Karduelis
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'smw_edithelp' => 'Özelliklerde değişiklik yardımı',
	'smw_viewasrdf' => 'RDF beslemesi',
	'smw_finallistconjunct' => ' ve',
	'smw_factbox_head' => '$1 hakkındaki gerçekler',
	'smw_isspecprop' => 'Bu özellik, bu vikideki özel bir özelliktir.',
	'smw_isknowntype' => 'Bu tür, bu vikinin standart veri türleri arasında.',
	'smw_concept_description' => '"$1" kavramının tanımı',
	'smw_multiple_concepts' => 'Tüm kavram sayfaları sadece birer kavram tanımına sahip olabilir.',
	'smw_printername_auto' => 'Otomatik',
	'smw_printername_count' => 'Sonuçları say',
	'smw_printername_csv' => 'CSV dışa aktarımı',
	'smw_printername_embedded' => 'Sayfa içeriklerini yerleştir',
	'smw_printername_list' => 'Liste',
	'smw_printername_rss' => 'RSS dışa aktarımı',
	'smw_printername_table' => 'Tablo',
	'smw_printername_broadtable' => 'Geniş tablo',
	'smw_printername_template' => 'Şablon',
	'smw_paramdesc_limit' => 'Verilecek azami sonuç sayısı',
	'smw_paramdesc_headers' => 'Başlıkları/özellik adlarını göster',
	'smw_paramdesc_link' => 'Değerleri bağlantı olarak gösterir',
	'smw_paramdesc_searchlabel' => 'Sonuçlara giden bağlantıdaki metin',
	'smw_paramdesc_sep' => 'Değerler için ayraç',
	'smw_paramdesc_embedonly' => 'Başlık gösterme',
	'smw_paramdesc_rsstitle' => 'Beslemenin başlığı olarak kullanılacak metin',
	'smw_iq_moreresults' => '... ek sonuçlar',
	'smw_iq_nojs' => 'Bu bileşeni görmek için JavaScript özelliği etkinleştirilmiş bir tarayıcı kullanın.',
	'smw_iq_altresults' => 'Direkt olarak sonuç listesini incele.',
	'smw_unknowntype' => 'Özellik için desteklenmeyen "$1" türü tanımlanmış.',
	'smw_emptystring' => 'Boş dizgiler kabul edilmemektedir.',
	'smw_maxstring' => 'Dizgi temsili $1 çok uzun.',
	'smw_nofloat' => '"$1" bir sayı değil.',
	'smw_toomanyclosing' => 'Sorguda çok fazla "$1" kullanımı mevcut.',
	'smw_misplacedsymbol' => '"$1" sembolü, yararlı olmadığı bir noktada kullanıldı.',
	'smw_badtitle' => '"$1", geçerli bir sayfa adı değil.',
	'smw_type_header' => '"$1" türünün özellikleri',
	'smw_attribute_header' => '"$1" özelliğini kullanan sayfalar',
	'smw_subproperty_header' => 'Alt özellikler',
	'exportrdf' => "Sayfaları RDF'ye aktar",
	'smw_exportrdf_lastdate' => 'Süre olarak belirtilen noktadan bu yana değiştirilmemiş sayfaları dışa aktarma.',
	'smw_exportrdf_submit' => 'Dışa aktar',
	'properties' => 'Özellikler',
	'smw_properties_docu' => 'Vikide aşağıdaki özellikler kullanılıyor.',
	'smw_propertylackspage' => 'Tüm özellikler bir sayfa tarafından açıklanmalıdır!',
	'smw_propertyhardlyused' => 'Bu özellik, viki dahilinde nadiren kullanılmaktadır!',
	'unusedproperties' => 'Kullanılmayan özellikler',
	'wantedproperties' => 'İstenen özellikler',
	'smw_wantedproperty_template' => '$1 ($2 {{PLURAL:$2|kullanım|kullanım}})',
	'tooltip-purge' => 'Bu sayfadaki tüm sorgu ve şablonları yenilemek için buraya tıklayın',
	'smw_purge' => 'Yenile',
	'types' => 'Türler',
	'semanticstatistics' => 'Anlamsal istatistikler',
	'ask' => 'Anlamsal arama',
	'smw_ask_ascorder' => 'Artan',
	'smw_ask_descorder' => 'Azalan',
	'smw_ask_submit' => 'Sonuçları bul',
	'smw_ask_editquery' => '[Sorguyu değiştir]',
	'smw_add_sortcondition' => '[Sıralama koşulu ekle]',
	'smw_ask_hidequery' => 'Sorguyu gizle',
	'smw_ask_help' => 'Sorgulama yardımı',
	'smw_ask_queryhead' => 'Sorgu',
	'smw_ask_printhead' => 'Görüntülenecek ek veriler',
	'smw_ask_printdesc' => '(satır başına bir özellik adı girin)',
	'smw_ask_defaultformat' => 'varsayılan',
	'smw_ask_otheroptions' => 'Diğer seçenekler',
	'smw_ask_show_embed' => 'Yerleştirme kodunu göster',
	'smw_ask_hide_embed' => 'Yerleştirme kodunu gizle',
	'searchbyproperty' => 'Özelliğe göre ara',
	'smw_sbv_docu' => 'Belirtilen özellik ve değere sahip tüm sayfaları ara.',
	'smw_sbv_novalue' => 'Özellik için geçerli bir değer girin ya da "$1" için tüm özellik değerlerini görün.',
	'smw_sbv_displayresult' => '"$2" değeri ile "$1" özelliğine sahip tüm sayfaların bir listesi',
	'smw_sbv_property' => 'Özellik:',
	'smw_sbv_value' => 'Değer:',
	'smw_sbv_submit' => 'Sonuç bul',
	'browse' => 'Vikiye gözat',
	'smw_browselink' => 'Özelliklere gözat',
	'smw_browse_go' => 'Git',
	'smw_browse_show_incoming' => 'buraya bağlantı veren özellikleri göster',
	'smw_browse_hide_incoming' => 'buraya bağlantı veren özellikleri gizle',
	'smw_browse_no_outgoing' => 'Bu sayfa özelliğe sahip değil.',
	'smw_browse_no_incoming' => 'Bu sayfaya bağlantı veren özellik yok.',
	'pageproperty' => 'Sayfa özelliği arama',
	'smw_pp_from' => 'Şu sayfadan:',
	'smw_pp_type' => 'Özellik',
	'smw_pp_submit' => 'Sonuçları bul',
	'smw_result_prev' => 'Önceki',
	'smw_result_next' => 'sonraki',
	'smw_result_results' => 'Sonuçlar',
	'smw_result_noresults' => 'Sonuç yok.',
	'smwadmin' => 'Anlamsal MediaWiki için hizmetlilik fonksiyonları',
	'smw_smwadmin_settingup' => 'Anlamsal MediaWiki için saklama ayarlanıyor',
	'smw_smwadmin_setupsuccess' => 'Saklama motoru başarıyla ayarlandı.',
	'smw_smwadmin_updatenotstarted' => 'Yürürlükte olan bir güncelleme işlemi mevcut.
Bir diğeri oluşturulmuyor.',
	'smw_smwadmin_updatestopped' => 'Tüm mevcut güncelleme işlemleri durduruldu.',
	'smw_smwadmin_announce' => 'Vikinizi duyurun',
	'smw_smwadmin_datarefresh' => 'Veri onarımı ve yükseltmesi',
	'smw_smwadmin_datarefreshbutton' => 'Veri güncellemesini başlat',
	'smw_smwadmin_datarefreshstop' => 'Bu güncellemeyi durdur',
	'smw_smwadmin_datarefreshstopconfirm' => 'Evet, eminim.',
	'smw_smwadmin_support' => 'Destek alınıyor',
	'smw_adminlinks_datastructure' => 'Veri yapısı',
	'smw_adminlinks_displayingdata' => 'Veriler görüntüleniyor',
	'smw_adminlinks_inlinequerieshelp' => 'Satıriçi sorgu yardımı',
);

/** Tatar (Cyrillic) (Татарча/Tatarça (Cyrillic))
 * @author Ерней
 */
$messages['tt-cyrl'] = array(
	'smw_ask_defaultformat' => 'килешү буенча',
);

/** ئۇيغۇرچە (ئۇيغۇرچە)
 * @author Alfredie
 */
$messages['ug-arab'] = array(
	'smw_browse_go' => 'كۆچۈش',
);

/** Uighur (Latin) (Uyghurche‎ / ئۇيغۇرچە (Latin))
 * @author Jose77
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['ug-latn'] = array(
	'smw_browse_go' => 'Köchüsh',
);

/** Ukrainian (Українська)
 * @author Prima klasy4na
 */
$messages['uk'] = array(
	'smw_result_prev' => 'Попередня',
	'smw_result_next' => 'Наступна',
	'smw_result_results' => 'Результати',
);

/** Veps (Vepsan kel')
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'smw_viewasrdf' => 'RDF-purde',
	'smw_finallistconjunct' => ' da',
	'smw_factbox_head' => 'Faktad $1:n polhe',
	'smw_printername_auto' => 'Avtomatižikš',
	'smw_printername_count' => "Lugeda rezul'tatad",
	'smw_printername_list' => 'Nimikirjutez',
	'smw_printername_table' => 'Tablut',
	'smw_printername_broadtable' => 'Leved tablut',
	'smw_exportrdf_submit' => 'Eksport',
	'properties' => 'Ičendad',
	'semanticstatistics' => 'Semantine statistik',
	'ask' => 'Semantine ecind',
	'smw_ask_submit' => "Löuta rezul'tatad",
	'smw_ask_editquery' => '[Redaktiruida küzund]',
	'smw_browse_go' => 'Mäne',
	'smw_pp_from' => 'Lehtpolelpäi',
	'smw_pp_type' => 'Ičend',
	'smw_pp_submit' => "Löuta rezul'tatad",
	'smw_result_prev' => 'Edeline',
	'smw_result_next' => "Jäl'ghine",
	'smw_result_results' => "Rezul'tatad",
	'smw_result_noresults' => "Ei ole rezul'tatoid.",
	'smwadmin' => 'Redaktiruida Semantic MediaWiki',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'smw_edithelp' => 'Trợ giúp sửa đổi tại thuộc tính',
	'smw_viewasrdf' => 'Tin RDF',
	'smw_finallistconjunct' => ', và',
	'smw_factbox_head' => 'Sự thật về $1',
	'smw_isspecprop' => 'Thuộc tính này là thuộc tính đặc biệt trong wiki này.',
	'smw_isknowntype' => 'Kiểu này là một trong những kiểu dữ liệu chuẩn của wiki này.',
	'smw_isaliastype' => 'Kiểu này là tên hiệu của kiểu dữ liệu “$1”.',
	'smw_isnotype' => 'Kiểu “$1” này không phải là kiểu dữ liệu chuẩn trên wiki, và cũng chưa được cung cấp định nghĩa người dùng.',
	'smw_baduri' => 'Rất tiếc, không cho phép URI có dạng “$1”.',
	'smw_printername_auto' => 'Tự động',
	'smw_printername_count' => 'Đếm kết quả',
	'smw_printername_csv' => 'Xuất CSV',
	'smw_printername_embedded' => 'Nhúng nội dung trang',
	'smw_printername_json' => 'Xuất JSON',
	'smw_printername_list' => 'Danh sách',
	'smw_printername_rss' => 'Xuất RSS',
	'smw_printername_table' => 'Bảng',
	'smw_printername_broadtable' => 'Bảng rộng',
	'smw_printername_template' => 'Bản mẫu',
	'smw_iq_disabled' => 'Rất tiếc. Chức năng truy vấn ngữ nghĩa đã bị tắt tại wiki này.',
	'smw_iq_moreresults' => '… kết quả khác',
	'smw_iq_nojs' => 'Xin hãy dùng trình duyệt có kích hoạt JavaScript để xem thành phần này.',
	'smw_iq_altresults' => 'Xem qua trực tiếp danh sách kết quả.',
	'smw_unknown_importns' => 'Nhập các hàm chưa có tại không gian tên “$1”.',
	'smw_nonright_importtype' => '$1 chỉ dùng được tại những trang thuộc không gian tên “$2”.',
	'smw_wrong_importtype' => '$1 không thể dùng được tại những trang thuộc không gian tên “$2”.',
	'smw_no_importelement' => 'Thành phần “$1” không có để nhập.',
	'smw_parseerror' => 'Không hiểu giá trị cung cấp.',
	'smw_decseparator' => ',',
	'smw_kiloseparator' => '.',
	'smw_notitle' => 'Không thể dùng “$1” làm tên trang trên wiki này.',
	'smw_unknowntype' => 'Không hỗ trợ kiểu “$1” trong thuộc tính.',
	'smw_manytypes' => 'Thuộc tính này có nhiều hơn một kiểu',
	'smw_emptystring' => 'Không chấp nhận chuỗi trống.',
	'smw_maxstring' => 'Đại diện chuỗi $1 quá dài.',
	'smw_notinenum' => '“$1” không nằm trong danh sách các giá trị khả dĩ ($2) cho thuộc tính này.',
	'smw_noboolean' => '“$1” không phải là giá trị Boole (đúng/sai).',
	'smw_true_words' => 'true,t,yes,y,đúng,đ,có,c',
	'smw_false_words' => 'false,f,no,n,sai,s,không,k',
	'smw_nofloat' => '“$1” không phải là số.',
	'smw_infinite' => 'Không hỗ trợ các số lớn như “$1”.',
	'smw_infinite_unit' => 'Chuyển đổi thành đơn vị “$1” đẫn tới một con số quá lớn.',
	'smw_unsupportedprefix' => 'Không hỗ trợ tiền tố cho các số (“$1”).',
	'smw_unsupportedunit' => 'Không hỗ trợ chuyển đổi đơn vị cho đơn vị “$1”.',
	'smw_nodatetime' => 'Không hiểu ngày “$1”.',
	'smw_toomanyclosing' => 'Dường có quá nhiều lần xuất hiện “$1” trong câu truy vấn.',
	'smw_noclosingbrackets' => 'Lần sử dụng “<nowiki>[[</nowiki>” nào đó trong câu truy vấn của bạn không được đóng bằng “]]”.',
	'smw_misplacedsymbol' => 'Ký hiệu “$1” được dùng tại nơi nó không hữu ích.',
	'smw_unexpectedpart' => 'Phần “$1” của câu truy vấn không hiểu được.
Kết quả có thể không như mong đợi.',
	'smw_emptysubquery' => 'Một truy vấn con nào đó không có điều kiện hợp lệ.',
	'smw_misplacedsubquery' => 'Một truy vấn con nào đó được dùng tại nơi không cho phép dùng truy vấn con.',
	'smw_valuesubquery' => 'Truy vấn con không hỗ trợ các giá trị của tham số “$1”.',
	'smw_overprintoutlimit' => 'Câu truy vấn chứa quá nhiều yêu cầu trang in.',
	'smw_badprintout' => 'Lệnh yêu cầu in nào đó trong câu truy vấn có dạng sai.',
	'smw_badtitle' => 'Tên trang “$1” không hợp lệ.',
	'smw_badqueryatom' => 'Phần “<nowiki>[[…]]</nowiki>” nào đó của câu truy vấn không hiểu được.',
	'smw_propvalueproblem' => 'Không hiểu giá trị của thuộc tính “$1”.',
	'smw_nodisjunctions' => 'Phân tách trong câu truy vấn không hỗ trợ trong wiki này và một phần câu truy vấn bị bỏ qua ($1).',
	'smw_querytoolarge' => 'Các điều kiện truy vấn sau đây không được xem xét do hạn chế của wiki trong độ dài hoặc độ sâu truy vấn: $1.',
	'smw_devel_warning' => 'Tính năng này hiện đang được phát triển, và có thể không hoạt động đầy đủ.
Hãy sao lưu dữ liệu của bạn trước khi dùng nó.',
	'smw_notemplategiven' => 'Xin hãy cung cấp giá trị cho tham số “template” để đinh dạng truy vấn này có thể hoạt động.',
	'smw_type_header' => 'Tính chất của loại “$1”',
	'smw_typearticlecount' => 'Hiển thị $1 thuộc tính sử dụng kiểu này.{{PLURAL:$1||}}',
	'smw_attribute_header' => 'Những trang dùng thuộc tính “$1”',
	'smw_attributearticlecount' => 'Hiển thị $1 trang dùng thuộc tính này.{{PLURAL:$1||}}',
	'smw_subproperty_header' => 'Thuộc tính con',
	'smw_concept_header' => 'Trang về khái niệm “$1”',
	'smw_rss_description' => '$1 feed RSS',
	'exportrdf' => 'Xuất trang ra RDF',
	'smw_exportrdf_docu' => 'Trang này cho phép bạn lấy dữ liệu từ trang theo dạng RDF.
Để xuất trang, gõ vào tựa đề trong khung dưới đây, một dòng một tựa đề.',
	'smw_exportrdf_recursive' => 'Xuất đệ quy tất cả các trang liên quan.
Chú ý rằng kết quả không thể quá lớn!',
	'smw_exportrdf_backlinks' => 'Cũng xuất tất cả các trang chỉ đến trang được xuất.
Tạo ra RDF có thể duyệt được.',
	'smw_exportrdf_lastdate' => 'Đừng xuất trang không thay đổi từ một thời điểm cho trước.',
	'smw_exportrdf_submit' => 'Xuất',
	'properties' => 'Thuộc tính',
	'smw_properties_docu' => 'Các thuộc tính được dùng trong wiki.',
	'smw_property_template' => '$1 thuộc loại $2 ($3)',
	'smw_propertylackspage' => 'Tất cả các thuộc tính nên được mô tả bằng một trang!',
	'smw_propertylackstype' => 'Không có loại này được chỉ định cho thuộc tính này (từ giờ giả thiết loại $1).',
	'smw_propertyhardlyused' => 'Thuộc tính này khó sử dụng trong wiki!',
	'unusedproperties' => 'Thuộc tính không sử dụng',
	'smw_unusedproperties_docu' => 'Các thuộc tính sau tồn tại mặc dù không có trang nào dùng chúng.',
	'smw_unusedproperty_template' => '$1 thuộc loại $2',
	'wantedproperties' => 'Thuộc tính cần nhất',
	'smw_wantedproperties_docu' => 'Các thuộc tính sau được dùng trong wiki nhưng chưa có trang nào mô tả chúng.',
	'smw_wantedproperty_template' => '$1 ($2 lần sử dụng){{PLURAL:$1||}}',
	'tooltip-purge' => 'Nhấn vào đây để làm tươi tất cả các truy vấn và bản mẫu trên trang này',
	'smw_purge' => 'Làm tươi',
	'types' => 'Các dạng',
	'smw_types_docu' => 'Sau đây là danh sách tất cả các kiểu dữ liệu có thể gán vào thuộc tính.
Mỗi kiểu dữ liệu có một trang tại đó có thông tin bổ sung.',
	'smw_typeunits' => 'Đơn vị đo lường thuộc loại “$1”: $2',
	'semanticstatistics' => 'Thống kê ngữ nghĩa',
	'smw_semstats_text' => "Wiki này có chứa '''$1''' giá trị thuộc tính cho tổng cộng '''$2''' [[Special:Properties|thuộc tính khác nhau]].
'''$3''' thuộc tính có trang riêng, và kiểu dữ liệu dự tính được chỉ định cho '''$4''' trong số đó.
Một số thuộc tính hiện có có thể [[Special:UnusedProperties|chưa được sử dụng]].
Có thể tìm thấy thuộc tính còn thiếu trang tại [[Special:WantedProperties|danh sách các thuộc tính cần có]].",
	'uriresolver' => 'Bộ giải URI',
	'smw_uri_doc' => 'Bộ giải URI hiện thực <a href="http://www.w3.org/2001/tag/issues.html#httpRange-14">THẺ W3C tìm thấy tại httpRange-14</a>. Nó lo việc con người không quay lại trang web.',
	'ask' => 'Tìm kiếm ngữ nghĩa',
	'smw_ask_sortby' => 'Sắp xếp theo cột (tùy chọn)',
	'smw_ask_ascorder' => 'Tăng dần',
	'smw_ask_descorder' => 'Giảm dần',
	'smw_ask_submit' => 'Kết quả tìm kiếm',
	'smw_ask_editquery' => '[Sửa truy vấn]',
	'smw_add_sortcondition' => '[Thêm điều kiện sắp xếp]',
	'smw_ask_hidequery' => 'Ẩn truy vấn',
	'smw_ask_help' => 'Trợ giúp truy vấn',
	'smw_ask_queryhead' => 'Truy vấn',
	'smw_ask_printhead' => 'Dữ liệu bổ sung được hiển thị',
	'smw_ask_defaultformat' => 'mặc định',
	'smw_ask_otheroptions' => 'Tùy chọn khác',
	'smw_ask_show_embed' => 'Hiện mã để nhúng',
	'smw_ask_hide_embed' => 'Ẩn mã để nhúng',
	'searchbyproperty' => 'Tìm theo thuộc tính',
	'smw_sbv_docu' => 'Tìm tất cả các trang có thuộc tính và giá trị cho trước.',
	'smw_sbv_novalue' => 'Xin nhập vào một giá trị hợp lệ cho thuộc tính, hoặc xem tất cả các giá trị thuộc tính của “$1.”',
	'smw_sbv_displayresult' => 'Danh sách tất cả các trang có thuộc tính “$1” có giá trị “$2”',
	'smw_sbv_property' => 'Thuộc tính:',
	'smw_sbv_value' => 'Giá trị:',
	'smw_sbv_submit' => 'Kết quả tìm kiếm',
	'browse' => 'Duyệt wiki',
	'smw_browselink' => 'Duyệt thuộc tính',
	'smw_browse_article' => 'Gõ vào tên trang để bắt đầu duyệt.',
	'smw_browse_go' => 'Xem',
	'smw_browse_show_incoming' => 'hiện các thuộc tính liên kết đến đây',
	'smw_browse_hide_incoming' => 'ẩn các thuộc tính liên kết đến đây',
	'smw_browse_no_outgoing' => 'Trang này không có thuộc tính.',
	'smw_browse_no_incoming' => 'Không có thuộc tính liên kết đến trang này.',
	'pageproperty' => 'Tìm kiếm thuộc tính trang',
	'smw_pp_docu' => 'Tìm tất cả các lấp chỗ trống của một thuộc tính tại một trang cho trước.
Xin nhập vào cả một trang và một thuộc tính.',
	'smw_pp_from' => 'Từ trang',
	'smw_pp_type' => 'Thuộc tính',
	'smw_pp_submit' => 'Kết quả tìm kiếm',
	'smw_result_prev' => 'Trước',
	'smw_result_next' => 'Sau',
	'smw_result_results' => 'Kết quả',
	'smw_result_noresults' => 'Không có kết quả nào.',
	'smw_smwadmin_return' => 'Trở lại $1',
	'smw_smwadmin_announce' => 'Tuyên bố wiki của bạn',
	'smw_smwadmin_datarefreshbutton' => 'Bắt đầu nâng cấp dữ liệu',
	'smw_smwadmin_datarefreshstop' => 'Ngừng việc nâng cấp',
	'smw_smwadmin_datarefreshstopconfirm' => 'Có chắc',
	'smw_smwadmin_support' => 'Trợ giúp',
	'smw_smwadmin_mediazilla' => 'Hãy báo cáo lỗi tại <a href="https://bugzilla.wikimedia.org/">Bugzilla</a>.',
	'smw_adminlinks_datastructure' => 'Cấu trúc dữ liệu',
	'smw_adminlinks_displayingdata' => 'Hiển thị dữ liệu',
);

/** Volapük (Volapük)
 * @author Malafaya
 * @author Smeira
 */
$messages['vo'] = array(
	'smw_edithelp' => 'Redakamayuf tefü patöfs',
	'smw_finallistconjunct' => ', e',
	'smw_factbox_head' => 'Jenöfots dö $1',
	'smw_isspecprop' => 'Patöf at binon patöf patik in vük at.',
	'smw_isknowntype' => 'Sot at binon bal stabanünodasotas vüka at.',
	'smw_isaliastype' => 'Sot at binon näinem nünodasota: „$1“.',
	'smw_isnotype' => 'Sot at: „$1“ no binon stabanünodasot in vük at, e no edageton miedeti fa geban.',
	'smw_concept_description' => 'Bepenam suemoda: „$1“.',
	'smw_no_concept_namespace' => 'Suemods kanons pamiedetön te su pads nemadaspada: Miedet.',
	'smw_multiple_concepts' => 'Suemodapad alik dalon labön suemodimiedeti te bali.',
	'smw_baduri' => 'Els URI ön fom: „$1“ no padälons.',
	'smw_iq_moreresults' => '... seks pluik',
	'smw_iq_nojs' => 'Gebolös bevüresodanafömi labü el JavaScript ad logön bineti at.',
	'smw_iq_altresults' => 'Logön nenmediko sekalisedi.',
	'smw_nonright_importtype' => '$1 dalon pagebön te tefü pads nemaspada: „$2“.',
	'smw_wrong_importtype' => '$1 no dalon pagebön tefü pads nemaspada: „$2“.',
	'smw_no_importelement' => 'Binet: „$1“ no gebidon ad panüveigön.',
	'smw_parseerror' => 'Völad pegivöl no pesuemon.',
	'smw_notitle' => '„$1“ no dalon pagebön as padanem in vük at.',
	'smw_wrong_namespace' => 'Te pades se nemaspad: „$1“ padälons ad binön is.',
	'smw_manytypes' => 'Sots plu bals pemiedetons pro patöf.',
	'smw_emptystring' => 'Vödems vagik no pelasumons.',
	'smw_notinenum' => '„$1“ no komon in lised völadas mögik ($2) patöfa at.',
	'smw_true_words' => 'veratik,v,si,s',
	'smw_false_words' => 'dobik,d,no,n',
	'smw_nofloat' => '„$1“ no binon num.',
	'smw_infinite' => 'Nums so gretik äs „$1“ no kanons pagebön.',
	'smw_unsupportedprefix' => 'Foyümots pro nums („$1“) no dalons pagebön.',
	'smw_nodatetime' => 'Dät: „$1“ no pesuemon.',
	'smw_emptysubquery' => 'Donaseivid semik no labon stipi lonöföl.',
	'smw_misplacedsubquery' => 'Donaseivid semik pägebon uto, kö donaseivids no padälons.',
	'smw_badtitle' => '„$1“ no binon padatiäd lonöföl.',
	'smw_badqueryatom' => 'Dil semik: „<nowiki>[[…]]</nowiki>“ seivida no pesuemon.',
	'smw_propvalueproblem' => 'Völad patöfa: „$1“ no pesuemon.',
	'smw_notemplategiven' => 'Gevolös völadi paramete: „samafomot“, dat seividafomät at ojäfidon.',
	'smw_type_header' => 'Patöfs sota: „$1“',
	'smw_typearticlecount' => '{{PLURAL:$1|Patöf $1 pajonon, kel labon|Patöfs $1 pajonons, kels labons}} soti at.',
	'smw_attribute_header' => 'Pads patöfi: „$1“ geböls',
	'smw_attributearticlecount' => '{{PLURAL:$1|Pad $1 pajonon, kel gebon|Pads $1 pajonons, kels gebons}} patöfi at.',
	'smw_subproperty_header' => 'Donapatöfs',
	'smw_subpropertyarticlecount' => 'Patöf at labon {{PLURAL:$1|donapatöfi|donapatöfis}} sököl $1.',
	'smw_concept_header' => 'Pads suemoda: „$1“.',
	'smw_conceptarticlecount' => '{{PLURAL:$1|Pajonon pad $1, kel duton|Pajonons pads $1, kels dutons}} lü suemod at.',
	'exportrdf' => 'Seveigön padis at RDF',
	'properties' => 'Patöfs',
	'smw_properties_docu' => 'Patöfs sököl pagebons in vük.',
	'smw_property_template' => '$1 sota: $2 ($3)',
	'smw_propertylackspage' => 'Patöfs valik sötons pabepenön su pad semik!',
	'smw_propertyhardlyused' => 'Patöf at pagebon vemo selediko in vük!',
	'unusedproperties' => 'Patöfs no pegeböls',
	'smw_unusedproperties_docu' => 'Patöfs sököl dabinons, do pad votik nonik gebon onis.',
	'smw_unusedproperty_template' => '$1 sota: $2',
	'wantedproperties' => 'Patöfs pavilöl',
	'smw_wantedproperties_docu' => 'Patöfs sököl pagebons in vük ab no nog labons bepenamapadis oksik.',
	'smw_wantedproperty_template' => '$1 (gebs $2)',
	'types' => 'Sots',
	'smw_ask_submit' => 'Tuvön sekis',
	'smw_ask_editquery' => '[Bevobön seividi]',
	'smw_add_sortcondition' => '[Läükön leodükamastipi]',
	'smw_ask_hidequery' => 'Klänedön seividi',
	'smw_ask_queryhead' => 'Seivid',
	'searchbyproperty' => 'Sukön ma patöf',
	'smw_sbv_docu' => 'Sukön padis valik patöfi e völadi semikis labölis.',
	'smw_sbv_novalue' => 'Penolös völadi lonöfol patöfa, u logolös patöfavöladis valik tefü „$1“.',
	'smw_sbv_displayresult' => 'Lised padas valik labü völad: „$2“ patöfa: „$1“.',
	'smw_sbv_displayresultfuzzy' => 'Lised padas valik labü völad: „$1“ patöfa: „$1“.
Bi petuvons pads te aniks, i völads nilöfik palisedons.',
	'smw_sbv_property' => 'Patöf',
	'smw_sbv_value' => 'Völad',
	'smw_sbv_submit' => 'Tuvön sekis',
	'browse' => 'Padön vüki',
	'smw_browselink' => 'Logön patöfis',
	'smw_browse_article' => 'Penolös nemi pada, de kel padam oprimon.',
	'smw_browse_go' => 'Ledunön',
	'smw_browse_show_incoming' => 'jonön patöfis isio peyümölis',
	'smw_browse_hide_incoming' => 'klänedön patöfis isio peyümölis',
	'smw_browse_no_outgoing' => 'Pad at no labon patöfis.',
	'smw_browse_no_incoming' => 'Patöfs nonik peyümons lü pad at.',
	'smw_inverse_label_default' => '$1 de',
	'pageproperty' => 'Suk padapatöfas',
	'smw_pp_from' => 'De pad',
	'smw_pp_type' => 'Patöf',
	'smw_pp_submit' => 'Tuvön sekis',
	'smw_result_prev' => 'Büik',
	'smw_result_next' => 'Sököl',
	'smw_result_results' => 'Seks.',
	'smw_result_noresults' => 'Seks nonik.',
	'smw_smwadmin_return' => 'Geikön lü pad: $1',
);

/** Chinese (China) (‪中文(中国大陆)‬)
 * @author Roc Michael
 */
$messages['zh-cn'] = array(
	'smw_edithelp' => '与关联(relations)及属性(attributes)有关的编辑协助',
	'smw_finallistconjunct' => '， 和',
	'smw_factbox_head' => '关于$1 的小文件',
	'smw_isspecprop' => '在此wiki系统内，此一性质为一种特殊性质',
	'smw_isknowntype' => '此一型态系为这个wiki系统内的标准的资料型态之一',
	'smw_isaliastype' => '此一型态系为资料型态“$1＂的别称',
	'smw_isnotype' => '在此wiki系统内，此一“$1＂型态并非是一项标准的资料型态，并且尚未被用户赋予其定义',
	'smw_baduri' => '抱歉，在此处无法取得从“$1＂范围的，URIs. (译注原文为：Sorry, URIs of the form “$1＂ are not allowed.)',
	'smw_iq_disabled' => '抱歉，联机查询在此wiki已被设置为无效',
	'smw_iq_moreresults' => '&hellip; 高级查询',
	'smw_iq_nojs' => '请使用内建JavaScript的浏览器以浏览此元素.',
	'smw_unknown_importns' => '导入功能对“$1＂的名字空间无效＂.',
	'smw_nonright_importtype' => '$1仅能用于名字空间为“$2＂的页面。',
	'smw_wrong_importtype' => '$1无法用于名字空间为“$2＂的页面。',
	'smw_no_importelement' => '无法导入“$1＂元素',
	'smw_notitle' => '在此wiki内，是无法用“$1＂来当作页面名称的',
	'smw_unknowntype' => '不支持为性质所定义的“$1＂形态。',
	'smw_manytypes' => '定义此性质的型态已超过了一种以上。',
	'smw_emptystring' => '不接受空白字串。',
	'smw_maxstring' => '对本站而言，$1所代表的字串太长了。',
	'smw_notinenum' => '“$1＂ 并非在此属性有可能的值 ($2)的列表之中',
	'smw_noboolean' => '“$1＂无法被视为布林值(true/false)。',
	'smw_true_words' => '是,t,yes,y,true',
	'smw_false_words' => '否,f,no,n,false',
	'smw_nofloat' => '“$1＂ 并非为是数字',
	'smw_infinite' => '在此站内并不支持像是“$1＂如此庞大的数目字。',
	'smw_infinite_unit' => '对此站而言转换“$1＂单位所产生的数目字过于庞大。',
	'smw_unsupportedprefix' => '数字(“$1＂) 的字首目前尚未被支持',
	'smw_unsupportedunit' => '单位转换无法适用于“$1＂此一单位',
	'smw_nodatetime' => '日期值“$1＂无法被识别，对日期值的支持目前尚属实验性质。',
	'smw_toomanyclosing' => '在此查询中“$1＂显然出现太多次了',
	'smw_noclosingbrackets' => '在您的查询中“[&#x005B;＂ 并未以对应的“]]＂来予以封闭',
	'smw_misplacedsymbol' => '“$1＂此一符号用于某项无用之处',
	'smw_unexpectedpart' => '查询的“$1＂部份无法被识别，可能会出现预料之外的结果',
	'smw_emptysubquery' => '某些子查询并不具备有效的查询条件',
	'smw_misplacedsubquery' => '某些子查询被用在不宜于使用子查询之处',
	'smw_valuesubquery' => '“$1＂质性的值并不适用于子查询',
	'smw_overprintoutlimit' => '此查询含有太多的输出要求',
	'smw_badprintout' => '在此查询中，有些输出叙述已被弄错了',
	'smw_badtitle' => '抱歉！“$1＂ 并非是有效的页面名称',
	'smw_badqueryatom' => '在此查询中，部份的“[#x005B;&hellip]]＂无法被识别。',
	'smw_propvalueproblem' => '质性“$1＂的值无法被识别',
	'smw_nodisjunctions' => '在此wiki系统内分开查询是不被支持的，并有部份查询已被遗漏 ($1)。(译注原文为：Disjunctions in queries are not supported in this wiki and part of the query was dropped ($1).)',
	'smw_querytoolarge' => '基于此wiki系统对查询的规模及在深度方面的限制，以下的查询条件无法被接受：$1',
	'smw_devel_warning' => '此元件尚于开发中，也许无法完成发挥功效，在使用它之前，请先备份您的资料',
	'smw_type_header' => '“$1＂型态的性质',
	'smw_typearticlecount' => '以此型态显示 $1 性质',
	'smw_attribute_header' => '使用性质“$1＂的页面',
	'smw_attributearticlecount' => '以此性质显示$1页面.',
	'exportrdf' => '输出页面至RDF 。',
	'smw_exportrdf_docu' => '此一页面可让您获取RDF格式页面的资料，要输出页面，请在下方的文字框内键入页面的抬头，一项一行。',
	'smw_exportrdf_recursive' => '逐项输出所有的相关的页面，请注意输出的结果可能颇为庞大。',
	'smw_exportrdf_backlinks' => '并且输出与输出页面有关的页面，产生可供人阅读的RDF。(browsable RDF)',
	'smw_exportrdf_lastdate' => '无须输出那些在所设之时间点以后就未再被更动过的页面',
	'properties' => '性质',
	'smw_properties_docu' => '以下的性质已被用于此wiki内',
	'smw_property_template' => ' $1 　型态为：$2　使用次数：($3)',
	'smw_propertylackspage' => '所有的性质应以某一页面加以描述。',
	'smw_propertylackstype' => '此一性质尚未被指定形态，先暂定为$1型态。',
	'smw_propertyhardlyused' => '此一性质难以用于此wiki内',
	'unusedproperties' => '未使用的性质',
	'smw_unusedproperties_docu' => '下方的性质虽已存在，但无其他的页面使用它们。',
	'smw_unusedproperty_template' => '$2型态的$1',
	'wantedproperties' => '待建立的性质',
	'smw_wantedproperties_docu' => '下方的性质虽已用于此wiki内，但却未事先以任何页面去定义它们。',
	'smw_wantedproperty_template' => '$1 (已用于$2处)',
	'tooltip-purge' => '按此处以更新此页全部的查询项目及样板。',
	'smw_purge' => '更新',
	'types' => '型态',
	'smw_types_docu' => '以下为所有资料型态的列表，资料型态可用于指定性质，每项资料型态皆有提供附加信息的页面。',
	'smw_typeunits' => '“$1＂型态的量测单位：$2',
	'semanticstatistics' => '语意统计(Semantic Statistics)',
	'smw_semstats_text' => '此wiki含有<b>$1</b>性质的值以用于总计<b>$2</b> 不同于 <a href="$3">性质</a>。 <b>$4</b>性质有着专属的专面，且预期所需的资料型态因着<b>$5</b>，而已被指定了，有些现有的性质也许为<a href="$6">未使用的性质</a>。您可在 <a href="$7">待建立的性质列表</a>中，找到那些尚未建立专属页面的性质。(译注原文为：This wiki contains <b>$1</b> property values for a total of <b>$2</b> different <a href="$3">properties</a>. <b>$4</b> properties have an own page, and the intended datatype is specified for <b>$5</b> of those. Some of the existing properties might by <a href="$6">unused properties</a>. Properties that still lack a page are found on the <a href="$7">list of wanted properties</a>.This wiki contains <b>$1</b> property values for a total of <b>$2</b> different <a href="$3">properties</a>. <b>$4</b> properties have an own page, and the intended datatype is specified for <b>$5</b> of those. Some of the existing properties might by <a href="$6">unused properties</a>. Properties that still lack a page are found on the <a href="$7">list of wanted properties</a>.)',
	'ask' => '语意搜寻',
	'smw_ask_sortby' => '依栏位排序',
	'smw_ask_ascorder' => '升幂',
	'smw_ask_descorder' => '降幂',
	'smw_ask_submit' => '搜自导引结果',
	'smw_ask_editquery' => '[编辑查询]',
	'smw_ask_hidequery' => '隐藏查询',
	'smw_ask_help' => '查询协助',
	'smw_ask_queryhead' => '查询',
	'smw_ask_printhead' => '其他查询(选择性的)',
	'searchbyproperty' => '依性质搜寻',
	'smw_sbv_docu' => '依所指定的性质及其值来搜寻页面',
	'smw_sbv_novalue' => '请为该性质输入一项有效值，或请查阅“$1.＂的全部的性质的值',
	'smw_sbv_displayresult' => '所有“$1＂性质项目中，皆带有“$2＂值的页面列表',
	'smw_sbv_property' => '性质',
	'smw_sbv_value' => '值',
	'smw_sbv_submit' => '搜自导引结果',
	'browse' => '浏览wiki',
	'smw_browse_article' => '在开始浏览的表单中输入页面名称',
	'smw_browse_go' => '前往',
	'pageproperty' => '页面性质搜寻',
	'smw_pp_docu' => '搜寻某一页面全部性质的过滤条件，请同时输入页面及性质',
	'smw_pp_from' => '开始页面(From page)',
	'smw_pp_type' => '性质',
	'smw_pp_submit' => '搜自导引结果',
	'smw_result_prev' => '前一页',
	'smw_result_next' => '下一页',
	'smw_result_results' => '结果',
	'smw_result_noresults' => '抱歉，无您所要的结果。',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Gzdavidwong
 * @author Liangent
 * @author PhiLiP
 */
$messages['zh-hans'] = array(
	'smw_finallistconjunct' => '和',
	'smw_nofloat' => '「$1」不是一个数字。',
	'smw_exportrdf_submit' => '汇出',
	'smw_pp_submit' => '搜索结果',
	'smw_result_results' => '结果',
	'smw_result_noresults' => '没有结果。',
	'smw_smwadmin_datarefreshbutton' => '开始更新数据',
	'smw_smwadmin_mediazilla' => '臭虫可到<a href="https://bugzilla.wikimedia.org/">Bugzilla</a>报告。',
	'smw_adminlinks_datastructure' => '数据结构',
);

/** Traditional Chinese (‪中文(繁體)‬)
 * @author Gzdavidwong
 * @author Sheepy
 * @author Wrightbus
 */
$messages['zh-hant'] = array(
	'smw_finallistconjunct' => ', 和',
	'smw_nofloat' => '「$1」不是一個數字。',
	'smw_exportrdf_submit' => '匯出',
	'smw_pp_submit' => '搜尋結果',
	'smw_result_results' => '結果',
	'smw_result_noresults' => '沒有結果。',
	'smw_smwadmin_datarefreshbutton' => '開始更新數據',
	'smw_smwadmin_mediazilla' => '臭蟲可到<a href="https://bugzilla.wikimedia.org/">Bugzilla</a>報告。',
	'smw_adminlinks_datastructure' => '數據結構',
);

/** Chinese (Taiwan) (‪中文(台灣)‬)
 * @author Roc michael
 * @author Sheepy
 */
$messages['zh-tw'] = array(
	'smw_edithelp' => '與關聯(relations)及屬性(attributes)有關的編輯協助',
	'smw_finallistconjunct' => '， 和',
	'smw_factbox_head' => '關於$1 的小檔案',
	'smw_isspecprop' => '在此wiki系統內，此一性質為一種特殊性質',
	'smw_isknowntype' => '此一型態係為這個wiki系統內的標準的資料型態之一',
	'smw_isaliastype' => '此一型態係為資料型態“$1”的別稱',
	'smw_isnotype' => '在此wiki系統內，此一“$1”型態並非是一項標準的資料型態，並且尚未被用戶賦予其定義',
	'smw_concept_description' => '"$1"概念的描述',
	'smw_no_concept_namespace' => '如欲定義概念則須在名字空間為「概念」(Concept)的頁面中，予以定義。',
	'smw_multiple_concepts' => '每個概念頁面僅能有一項概念定義',
	'smw_baduri' => '抱歉，在此處不允許“$1”的URI. (譯註原文為：Sorry, URIs of the form “$1” are not allowed.)',
	'smw_printername_count' => '計數結果',
	'smw_printername_csv' => 'CSV匯出',
	'smw_printername_json' => 'JSON匯出',
	'smw_printername_ol' => '列舉',
	'smw_printername_rss' => 'RSS匯出',
	'smw_iq_disabled' => '抱歉，線上查詢在此wiki已被設定為無效',
	'smw_iq_moreresults' => '&hellip; 進階查詢',
	'smw_iq_nojs' => '請使用內建JavaScript的瀏覽器以瀏覽此元素.',
	'smw_iq_altresults' => '直接瀏覽結果清單',
	'smw_unknown_importns' => '匯入功能對“$1”的名字空間無效”.',
	'smw_nonright_importtype' => '$1僅能用於名字空間為“$2”的頁面。',
	'smw_wrong_importtype' => '$1無法用於名字空間為“$2”的頁面。',
	'smw_no_importelement' => '無法匯入“$1”元素',
	'smw_parseerror' => '所賦予的值無法被理解',
	'smw_notitle' => '在此wiki內，是無法用“$1”來當作頁面名稱的',
	'smw_wrong_namespace' => '此處僅允許名字空間為「$1」的頁面。',
	'smw_unknowntype' => '不支援為性質所定義的“$1”形態。',
	'smw_manytypes' => '定義此性質的型態已超過了一種以上。',
	'smw_emptystring' => '不接受空白字串。',
	'smw_maxstring' => '對本站而言，$1所代表的字串太長了。',
	'smw_notinenum' => '“$1” 並非在此屬性有可能的值 ($2)的清單之中',
	'smw_noboolean' => '“$1”無法被視為布林值(true/false)。',
	'smw_true_words' => '是,t,yes,y,true',
	'smw_false_words' => '否,f,no,n,false',
	'smw_nofloat' => '“$1” 並非為是數字',
	'smw_infinite' => '在此站內並不支援像是“$1”如此龐大的數目字。',
	'smw_infinite_unit' => '對此站而言轉換“$1”單位所產生的數目字過於龐大。',
	'smw_unsupportedprefix' => '數字(“$1”) 的字首目前尚未被支援',
	'smw_unsupportedunit' => '單位轉換無法適用於“$1”此一單位',
	'smw_nodatetime' => '日期值“$1”無法被識別，對日期值的支援目前尚屬實驗性質。',
	'smw_toomanyclosing' => '在此查詢中“$1”顯然出現太多次了',
	'smw_noclosingbrackets' => '在您的查詢中“[&#x005B;” 並未以對應的“]]”來予以封閉',
	'smw_misplacedsymbol' => '“$1”此一符號用於某項無用之處',
	'smw_unexpectedpart' => '查詢的“$1”部份無法被識別，可能會出現預料之外的結果',
	'smw_emptysubquery' => '某些子查詢並不具備有效的查詢條件',
	'smw_misplacedsubquery' => '某些子查詢被用在不宜於使用子查詢之處',
	'smw_valuesubquery' => '“$1”質性的值並不適用於子查詢',
	'smw_overprintoutlimit' => '此查詢含有太多的輸出要求',
	'smw_badprintout' => '在此查詢中，有些輸出敘述已被弄錯了',
	'smw_badtitle' => '抱歉！“$1” 並非是有效的頁面名稱',
	'smw_badqueryatom' => '在此查詢中，部份的“[#x005B;&hellip]]”無法被識別。',
	'smw_propvalueproblem' => '質性“$1”的值無法被識別',
	'smw_noqueryfeature' => '某些查詢元件並不被此一wiki所支援且部份的查詢已被中止 ($1)。',
	'smw_nodisjunctions' => '在此wiki系統內分開查詢是不被支援的，並有部份查詢已被遺漏 ($1)。(譯註原文為：Disjunctions in queries are not supported in this wiki and part of the query was dropped ($1).)',
	'smw_querytoolarge' => '基於此wiki系統對查詢的規模及在深度方面的限制，以下的查詢條件無法被接受：$1',
	'smw_devel_warning' => '此元件尚於開發中，也許無法完成發揮功效，在使用它之前，請先備份您的資料',
	'smw_type_header' => '“$1”型態的性質',
	'smw_typearticlecount' => '以此型態顯示 $1 性質',
	'smw_attribute_header' => '使用性質“$1”的頁面',
	'smw_attributearticlecount' => '以此性質顯示$1頁面.',
	'smw_subproperty_header' => '子性質',
	'smw_subpropertyarticlecount' => '此性質具有如下的$1子性質',
	'smw_concept_header' => '「$1」概念的頁面',
	'exportrdf' => '輸出頁面至RDF 。',
	'smw_exportrdf_docu' => '此一頁面可讓您獲取RDF格式頁面的資料，要輸出頁面，請在下方的文字框內鍵入頁面的抬頭，一項一行。',
	'smw_exportrdf_recursive' => '逐項輸出所有的相關的頁面，請注意輸出的結果可能頗為龐大。',
	'smw_exportrdf_backlinks' => '並且輸出與輸出頁面有關的頁面，產生可供人閱讀的RDF。(browsable RDF)',
	'smw_exportrdf_lastdate' => '無須輸出那些在所設之時間點以後就未再被更動過的頁面',
	'smw_exportrdf_submit' => '匯出',
	'properties' => '性質',
	'smw_properties_docu' => '以下的性質已被用於此wiki內',
	'smw_property_template' => ' $1 　型態為：$2　使用次數：($3)',
	'smw_propertylackspage' => '所有的性質應以某一頁面加以描述。',
	'smw_propertylackstype' => '此一性質尚未被指定形態，先暫定為$1型態。',
	'smw_propertyhardlyused' => '此一性質難以用於此wiki內',
	'unusedproperties' => '未使用的性質',
	'smw_unusedproperties_docu' => '下方的性質雖已存在，但無其他的頁面使用它們。',
	'smw_unusedproperty_template' => '$2型態的$1',
	'wantedproperties' => '待建立的性質',
	'smw_wantedproperties_docu' => '下方的性質雖已用於此wiki內，但卻未事先以任何頁面去定義它們。',
	'smw_wantedproperty_template' => '$1 (已用於$2處)',
	'tooltip-purge' => '按此處以更新此頁全部的查詢項目及樣板。',
	'smw_purge' => '更新',
	'types' => '型態',
	'smw_types_docu' => '以下為所有資料型態的清單，資料型態可用於指定性質，每項資料型態皆有提供附加資訊的頁面。',
	'smw_typeunits' => '“$1”型態的量測單位：$2',
	'semanticstatistics' => '語意統計(Semantic Statistics)',
	'smw_semstats_text' => '此wiki含有<b>$1</b>性質的值以用於總計<b>$2</b> 不同於 <a href="$3">性質</a>。 <b>$4</b>性質有著專屬的專面，且預期所需的資料型態因著<b>$5</b>，而已被指定了，有些現有的性質也許為<a href="$6">未使用的性質</a>。您可在 <a href="$7">待建立的性質清單</a>中，找到那些尚未建立專屬頁面的性質。(譯註原文為：This wiki contains <b>$1</b> property values for a total of <b>$2</b> different <a href="$3">properties</a>. <b>$4</b> properties have an own page, and the intended datatype is specified for <b>$5</b> of those. Some of the existing properties might by <a href="$6">unused properties</a>. Properties that still lack a page are found on the <a href="$7">list of wanted properties</a>.This wiki contains <b>$1</b> property values for a total of <b>$2</b> different <a href="$3">properties</a>. <b>$4</b> properties have an own page, and the intended datatype is specified for <b>$5</b> of those. Some of the existing properties might by <a href="$6">unused properties</a>. Properties that still lack a page are found on the <a href="$7">list of wanted properties</a>.)',
	'ask' => '語意搜尋',
	'smw_ask_sortby' => '依欄位排序',
	'smw_ask_ascorder' => '升冪',
	'smw_ask_descorder' => '降冪',
	'smw_ask_submit' => '搜尋的結果',
	'smw_ask_editquery' => '[編輯查詢]',
	'smw_add_sortcondition' => '[新增排序條件]',
	'smw_ask_hidequery' => '隱藏查詢',
	'smw_ask_help' => '查詢協助',
	'smw_ask_queryhead' => '查詢',
	'smw_ask_printhead' => '其他查詢(選擇性的)',
	'smw_ask_format_as' => '格式化為：',
	'smw_ask_defaultformat' => '預設',
	'smw_ask_otheroptions' => '其他選項',
	'smw_ask_show_embed' => '顯示內嵌程式碼',
	'smw_ask_hide_embed' => '隱藏內嵌程式碼',
	'searchbyproperty' => '依性質搜尋',
	'smw_sbv_docu' => '依所指定的性質及其值來搜尋頁面',
	'smw_sbv_novalue' => '請為該性質輸入一項有效值，或請查閱“$1.”的全部的性質的值',
	'smw_sbv_displayresult' => '所有“$1”性質項目中，皆帶有“$2”值的頁面清單',
	'smw_sbv_property' => '性質',
	'smw_sbv_value' => '值',
	'smw_sbv_submit' => '搜尋的結果',
	'browse' => '瀏覽wiki',
	'smw_browselink' => '瀏覽性質',
	'smw_browse_article' => '在開始瀏覽的表單中輸入頁面名稱',
	'smw_browse_go' => '前往',
	'smw_browse_show_incoming' => '顯示連結至此處的性質',
	'smw_browse_hide_incoming' => '隱藏連結至此處的性質',
	'smw_browse_no_outgoing' => '此頁並無任何的性質',
	'smw_browse_no_incoming' => '無性質連結至此頁面',
	'pageproperty' => '頁面性質搜尋',
	'smw_pp_docu' => '搜尋某一頁面全部性質的過濾條件，請同時輸入頁面及性質',
	'smw_pp_from' => '開始頁面(From page)',
	'smw_pp_type' => '性質',
	'smw_pp_submit' => '搜尋的結果',
	'smw_result_prev' => '前一頁',
	'smw_result_next' => '下一頁',
	'smw_result_results' => '結果',
	'smw_result_noresults' => '抱歉，無您所要的結果。',
	'smwadmin' => '語意維基(Semantic Mediawiki)主控台',
	'smw_smwadmin_return' => '返回至$1',
	'smw_smwadmin_updatestarted' => '已開始級及更新語意資料(semantic data)。
所有現存所需的資料將被重建及修復。
您可依循在此特殊頁面的更新程序。',
	'smw_smwadmin_updatenotstarted' => '目前某項更新程序下在進行中，不可重覆啟動另一項程序。',
	'smw_smwadmin_docu' => '此特殊頁面協助您在安裝及升級<a href="http://semantic-mediawiki.org">Semantic MediaWiki</a>的期間。請記得在執行管理功能(administrative functions)之前須備份重要的資料。',
	'smw_smwadmin_db' => '資料庫安裝及升級',
	'smw_smwadmin_announce' => '公告您的wiki',
	'smw_smwadmin_datarefresh' => '資料修理及升級',
	'smw_smwadmin_datarefreshbutton' => '開始更新資料',
	'smw_smwadmin_datarefreshstop' => '停止此次的更新',
	'smw_smwadmin_datarefreshstopconfirm' => '是的，我確定。',
	'smw_smwadmin_support' => '取得支援',
	'smw_smwadmin_smwhomepage' => '完整的Semantic MediaWiki用戶文件在<b><a href="http://semantic-mediawiki.org">semantic-mediawiki.org</a></b>。',
	'smw_smwadmin_mediazilla' => '臭蟲(程式的缺陷)可回報至<a href="https://bugzilla.wikimedia.org/">Bugzilla</a>。',
	'smw_smwadmin_questions' => '如果您有進一步的問題或建議，請參與在<a href="http://sourceforge.net/mailarchive/forum.php?forum_name=semediawiki-user">Semantic MediaWiki user forum</a>此處的討論。',
	'smw_adminlinks_datastructure' => '資料結構',
	'smw_adminlinks_displayingdata' => '顯示資料',
	'smw_adminlinks_inlinequerieshelp' => '線上查詢協助',
);

