<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$aliases = array();

/** English */
$aliases['en'] = array(
	'AddData' => array( 'AddData' ),
	'AddPage' => array( 'AddPage' ),
	'CreateCategory' => array( 'CreateCategory' ),
	'CreateForm' => array( 'CreateForm' ),
	'CreateProperty' => array( 'CreateProperty' ),
	'CreateTemplate' => array( 'CreateTemplate' ),
	'EditData' => array( 'EditData' ),
	'Forms' => array( 'Forms' ),
	'Templates' => array( 'Templates' ),
	'UploadWindow' => array( 'UploadWindow' ),
);

/** Arabic (العربية) */
$aliases['ar'] = array(
	'AddData' => array( 'إضافة_بيانات' ),
	'AddPage' => array( 'إضافة_صفحة' ),
	'CreateCategory' => array( 'إنشاء_تصنيف' ),
	'CreateForm' => array( 'إنشاء_استمارة' ),
	'CreateProperty' => array( 'إنشاء_خاصية' ),
	'CreateTemplate' => array( 'إنشاء_قالب' ),
	'EditData' => array( 'تعديل_البيانات' ),
	'Forms' => array( 'استمارات' ),
	'Templates' => array( 'قوالب' ),
	'UploadWindow' => array( 'نافذة_الرفع' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$aliases['arz'] = array(
	'AddData' => array( 'رود_داتا' ),
	'AddPage' => array( 'زود_صفحه' ),
	'CreateCategory' => array( 'اعمل_تصنيف' ),
	'CreateForm' => array( 'اعمل_استماره' ),
	'CreateProperty' => array( 'اعمل_ملكيه' ),
	'CreateTemplate' => array( 'إاعمل_قالب' ),
	'EditData' => array( 'تعديل_الداتا' ),
	'Forms' => array( 'استمارات' ),
	'Templates' => array( 'قوالب' ),
	'UploadWindow' => array( 'ويندو_الأپلود' ),
);

/** Breton (Brezhoneg) */
$aliases['br'] = array(
	'AddData' => array( 'OuzhpennañDanvez' ),
	'AddPage' => array( 'OuzhpennañPajenn' ),
	'CreateCategory' => array( 'KrouiñRummad' ),
	'Templates' => array( 'Patromoù' ),
);

/** Bosnian (Bosanski) */
$aliases['bs'] = array(
	'AddData' => array( 'DodavanjePodataka' ),
	'AddPage' => array( 'DodavanjeStranice' ),
	'CreateCategory' => array( 'PravljenjeKategorije' ),
	'CreateForm' => array( 'PravljenjeObrasca' ),
	'CreateProperty' => array( 'PravljenjeSvojstva' ),
	'CreateTemplate' => array( 'PravljenjeSablon' ),
	'Forms' => array( 'Obrasci' ),
	'Templates' => array( 'Sabloni' ),
	'UploadWindow' => array( 'ProzorPostavljanja' ),
);

/** Spanish (Español) */
$aliases['es'] = array(
	'Templates' => array( 'Plantillas' ),
);

/** Basque (Euskara) */
$aliases['eu'] = array(
	'CreateCategory' => array( 'KategoriaSortu' ),
	'CreateTemplate' => array( 'TxantiloiaSortu' ),
	'Templates' => array( 'Txantiloiak' ),
);

/** Persian (فارسی) */
$aliases['fa'] = array(
	'AddData' => array( 'افزودن_داده' ),
	'AddPage' => array( 'افزودن_صفحه' ),
	'CreateCategory' => array( 'ایجاد_رده' ),
	'CreateForm' => array( 'ایجاد_فرم' ),
	'CreateProperty' => array( 'ایجاد_صفت' ),
	'CreateTemplate' => array( 'ایجاد_الگو' ),
	'EditData' => array( 'ویرایش_داده' ),
	'Forms' => array( 'فرم‌ها' ),
	'Templates' => array( 'الگوها' ),
	'UploadWindow' => array( 'پنجره_بارگذاری' ),
);

/** Finnish (Suomi) */
$aliases['fi'] = array(
	'CreateTemplate' => array( 'Luo malline' ),
	'Templates' => array( 'Mallineet' ),
);

/** French (Français) */
$aliases['fr'] = array(
	'AddData' => array( 'AjouterDonnées', 'Ajouter données' ),
	'AddPage' => array( 'AjouterPage', 'Ajouter page' ),
	'CreateCategory' => array( 'Créer catégorie', 'CréerCatégorie' ),
	'CreateTemplate' => array( 'Créer modèle', 'CréerModèle' ),
	'Templates' => array( 'Modèles' ),
);

/** Franco-Provençal (Arpetan) */
$aliases['frp'] = array(
	'AddData' => array( 'Apondre des balyês', 'ApondreDesBalyês' ),
	'AddPage' => array( 'Apondre una pâge', 'ApondreUnaPâge' ),
	'CreateCategory' => array( 'Fâre una catègorie', 'FâreUnaCatègorie' ),
	'CreateForm' => array( 'Fâre un formulèro', 'FâreUnFormulèro' ),
	'CreateProperty' => array( 'Dèfenir una propriètât', 'DèfenirUnaPropriètât' ),
	'CreateTemplate' => array( 'Fâre un modèlo', 'FâreUnModèlo' ),
	'EditData' => array( 'Changiér les balyês', 'ChangiérLesBalyês' ),
	'Forms' => array( 'Formulèros' ),
	'Templates' => array( 'Modèlos' ),
	'UploadWindow' => array( 'Fenétra de tèlèchargement', 'FenétraDeTèlèchargement' ),
);

/** Galician (Galego) */
$aliases['gl'] = array(
	'Forms' => array( 'Formularios' ),
	'Templates' => array( 'Modelos' ),
);

/** Swiss German (Alemannisch) */
$aliases['gsw'] = array(
	'AddData' => array( 'Date zuegee' ),
	'AddPage' => array( 'Syte zuegee' ),
	'CreateCategory' => array( 'Kategori aalege' ),
	'CreateForm' => array( 'Form aalege' ),
	'CreateProperty' => array( 'Eigeschaft aalege' ),
	'CreateTemplate' => array( 'Template aalege' ),
	'EditData' => array( 'Date bearbeite' ),
	'Forms' => array( 'Form' ),
	'UploadWindow' => array( 'Fänschter zum Uffelade' ),
);

/** Upper Sorbian (Hornjoserbsce) */
$aliases['hsb'] = array(
	'Forms' => array( 'Formulary' ),
	'Templates' => array( 'Předłohi' ),
);

/** Hungarian (Magyar) */
$aliases['hu'] = array(
	'AddData' => array( 'Adat hozzáadása' ),
	'AddPage' => array( 'Oldal hozzáadása' ),
	'CreateCategory' => array( 'Kategória készítés' ),
	'CreateForm' => array( 'Űrlap készítése' ),
	'CreateProperty' => array( 'Tulajdonság készítése' ),
	'CreateTemplate' => array( 'Sablon készítése' ),
	'EditData' => array( 'Adat szerkesztése' ),
	'Forms' => array( 'Űrlapok' ),
	'Templates' => array( 'Sablonok' ),
	'UploadWindow' => array( 'Feltöltő ablak' ),
);

/** Interlingua (Interlingua) */
$aliases['ia'] = array(
	'AddData' => array( 'Adder datos' ),
	'AddPage' => array( 'Adder pagina' ),
	'CreateCategory' => array( 'Crear categoria' ),
	'CreateForm' => array( 'Crear formulario' ),
	'CreateProperty' => array( 'Crear proprietate' ),
	'CreateTemplate' => array( 'Crear patrono' ),
	'EditData' => array( 'Modificar datos' ),
	'Forms' => array( 'Formularios' ),
	'Templates' => array( 'Patronos' ),
	'UploadWindow' => array( 'Cargar fenestra' ),
);

/** Indonesian (Bahasa Indonesia) */
$aliases['id'] = array(
	'AddData' => array( 'Tambah data', 'TambahData' ),
	'AddPage' => array( 'Tambah halaman', 'TambahHalaman' ),
	'CreateCategory' => array( 'Buat kategori', 'BuatKategori' ),
	'CreateForm' => array( 'Buat formulir', 'BuatFormulir' ),
	'CreateProperty' => array( 'Buat properti', 'BuatProperti' ),
	'CreateTemplate' => array( 'Buat templat', 'BuatTemplat' ),
	'EditData' => array( 'Sunting data', 'SuntingData' ),
	'Forms' => array( 'Formulir semantik', 'FormulirSemantik' ),
	'Templates' => array( 'Templat' ),
	'UploadWindow' => array( 'Jendela pengunggahan', 'JendelaPengunggahan' ),
);

/** Italian (Italiano) */
$aliases['it'] = array(
	'AddData' => array( 'AggiungiDati' ),
	'AddPage' => array( 'AggiungiPagina' ),
	'CreateCategory' => array( 'CreaCategoria' ),
	'CreateForm' => array( 'CreaModulo' ),
	'CreateProperty' => array( 'CreaProprietà' ),
	'CreateTemplate' => array( 'CreaTemplate' ),
	'EditData' => array( 'ModificaDati' ),
	'Forms' => array( 'Moduli' ),
	'Templates' => array( 'Template' ),
	'UploadWindow' => array( 'AggiornaFinestra' ),
);

/** Japanese (日本語) */
$aliases['ja'] = array(
	'AddData' => array( 'データ追加' ),
	'AddPage' => array( 'ページ追加' ),
	'CreateCategory' => array( 'カテゴリ作成' ),
	'CreateForm' => array( 'フォーム作成' ),
	'CreateProperty' => array( 'プロパティ作成' ),
	'CreateTemplate' => array( 'テンプレート作成' ),
	'EditData' => array( 'データ編集' ),
	'Forms' => array( 'フォーム一覧' ),
	'Templates' => array( 'テンプレート一覧' ),
	'UploadWindow' => array( 'アップロードウィンドウ' ),
);

/** Georgian (ქართული) */
$aliases['ka'] = array(
	'Templates' => array( 'თარგები' ),
);

/** Khmer (ភាសាខ្មែរ) */
$aliases['km'] = array(
	'AddData' => array( 'បន្ថែមទិន្នន័យ' ),
	'AddPage' => array( 'បន្ថែមទំព័រ' ),
	'CreateCategory' => array( 'បង្កើតចំណាត់ត់ថ្នាក់ក្រុម' ),
	'CreateForm' => array( 'បង្កើត​ទម្រង់' ),
	'CreateTemplate' => array( 'បង្កើតទំព័រគំរូ' ),
	'EditData' => array( 'កែប្រែទិន្នន័យ' ),
	'Forms' => array( 'ទម្រង់​នានា' ),
	'Templates' => array( 'ទំព័រគំរូ' ),
);

/** Korean (한국어) */
$aliases['ko'] = array(
	'AddData' => array( '데이터 추가' ),
	'AddPage' => array( '페이지 추가' ),
	'CreateCategory' => array( '카테고리 추가' ),
	'CreateForm' => array( '양식 추가' ),
	'CreateTemplate' => array( '틀 추가' ),
	'EditData' => array( '데이터 편집' ),
	'Templates' => array( '틀' ),
);

/** Colognian (Ripoarisch) */
$aliases['ksh'] = array(
	'AddData' => array( 'Date dobei donn' ),
	'AddPage' => array( 'Sigg dobei donn' ),
	'CreateCategory' => array( 'Saachjropp aanlääje' ),
	'CreateForm' => array( 'Fommulaa aanlääje' ),
	'CreateProperty' => array( 'Eijeschaff aanlääje' ),
	'CreateTemplate' => array( 'Schabloon aanlääje' ),
	'EditData' => array( 'Date ändere' ),
	'Forms' => array( 'Fommulaare' ),
	'Templates' => array( 'Schabloone' ),
	'UploadWindow' => array( 'Finster zum Huhlaade', 'Finster zom Huhlaade' ),
);

/** Cornish (Kernewek) */
$aliases['kw'] = array(
	'CreateCategory' => array( 'GwruthylKlass' ),
	'CreateTemplate' => array( 'GwruthylSkantlyn' ),
	'Templates' => array( 'Skantlyns' ),
);

/** Ladino (Ladino) */
$aliases['lad'] = array(
	'Templates' => array( 'Xabblones' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$aliases['lb'] = array(
	'AddData' => array( 'Daten derbäisetzen' ),
	'AddPage' => array( 'Säit derbäisetzen' ),
	'CreateCategory' => array( 'Kategorie uleeën' ),
	'CreateForm' => array( 'Formulaire uleeën' ),
	'CreateProperty' => array( 'Eegeschaften uleeën' ),
	'CreateTemplate' => array( 'Schabloun uleeën' ),
	'EditData' => array( 'Daten änneren' ),
	'Forms' => array( 'Formulairen' ),
	'Templates' => array( 'Schablounen' ),
	'UploadWindow' => array( 'Fënster eroplueden' ),
);

/** Macedonian (Македонски) */
$aliases['mk'] = array(
	'AddData' => array( 'ДодајПодаток' ),
	'AddPage' => array( 'ДодајСтраница' ),
	'CreateCategory' => array( 'СоздајКатегорија' ),
	'CreateForm' => array( 'СоздајФорум' ),
	'CreateProperty' => array( 'СоздајСвојство' ),
	'CreateTemplate' => array( 'СоздајШаблон' ),
	'EditData' => array( 'УредиПодаток' ),
	'Forms' => array( 'Форми' ),
	'Templates' => array( 'Шаблони' ),
);

/** Malayalam (മലയാളം) */
$aliases['ml'] = array(
	'AddData' => array( 'വിവരങ്ങൾചേർക്കുക' ),
	'AddPage' => array( 'താൾചേർക്കുക' ),
	'CreateCategory' => array( 'വർഗ്ഗസൃഷ്ടി' ),
	'CreateForm' => array( 'ഫോംസൃഷ്ടി' ),
	'CreateTemplate' => array( 'ഫലകസൃഷ്ടി' ),
	'EditData' => array( 'വിവരങ്ങൾതിരുത്തുക' ),
	'Forms' => array( 'ഫോമുകൾ' ),
	'Templates' => array( 'ഫലകങ്ങൾ' ),
	'UploadWindow' => array( 'അപ്‌ലോഡ്ജാലകം' ),
);

/** Marathi (मराठी) */
$aliases['mr'] = array(
	'AddData' => array( 'विदाभरा' ),
	'AddPage' => array( 'पानजोडा' ),
	'CreateCategory' => array( 'वर्गतयारकरा' ),
	'CreateForm' => array( 'फॉर्मतयारकरा' ),
	'CreateProperty' => array( 'वैशिष्ट्येतयारकरा' ),
	'CreateTemplate' => array( 'साचेतयारकरा' ),
	'EditData' => array( 'विदासंपादा' ),
	'Forms' => array( 'फॉर्म्स' ),
	'Templates' => array( 'साचे' ),
	'UploadWindow' => array( 'चढवाखिडकी' ),
);

/** Maltese (Malti) */
$aliases['mt'] = array(
	'AddData' => array( 'ŻidDati' ),
	'AddPage' => array( 'ŻidPaġna' ),
	'CreateCategory' => array( 'OħloqKategorija' ),
	'Templates' => array( 'Mudelli' ),
);

/** Nedersaksisch (Nedersaksisch) */
$aliases['nds-nl'] = array(
	'AddData' => array( 'Gegevens_toevoegen' ),
	'AddPage' => array( 'Pagina_toevoegen' ),
	'CreateCategory' => array( 'Kattegerie_anmaken' ),
	'CreateForm' => array( 'Formelier_anmaken' ),
	'CreateProperty' => array( 'Eigenschap_anmaken' ),
	'CreateTemplate' => array( 'Mal_anmaken' ),
	'EditData' => array( 'Gegevens_bewarken' ),
	'Forms' => array( 'Formelieren' ),
	'Templates' => array( 'Mallen' ),
	'UploadWindow' => array( 'Bestaanstoevoegingsscharm' ),
);

/** Dutch (Nederlands) */
$aliases['nl'] = array(
	'AddData' => array( 'GegevensToevoegen' ),
	'AddPage' => array( 'PaginaToevoegen' ),
	'CreateCategory' => array( 'CategorieAanmaken' ),
	'CreateForm' => array( 'FormulierAanmaken' ),
	'CreateProperty' => array( 'EigenschapAanmaken' ),
	'CreateTemplate' => array( 'SjabloonAanmaken' ),
	'EditData' => array( 'GegevensBewerken' ),
	'Forms' => array( 'Formulieren' ),
	'Templates' => array( 'Sjablonen' ),
	'UploadWindow' => array( 'Uploadscherm' ),
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬) */
$aliases['no'] = array(
	'AddData' => array( 'Legg til data' ),
	'AddPage' => array( 'Legg til side' ),
	'CreateCategory' => array( 'Opprett kategori' ),
	'CreateForm' => array( 'Opprett skjema' ),
	'CreateProperty' => array( 'Opprett egenskap' ),
	'CreateTemplate' => array( 'Opprett mal' ),
	'EditData' => array( 'Rediger data' ),
	'Forms' => array( 'Skjemaer' ),
	'Templates' => array( 'Maler' ),
	'UploadWindow' => array( 'Opplastingsvindu' ),
);

/** Occitan (Occitan) */
$aliases['oc'] = array(
	'AddPage' => array( 'Apondre una pagina', 'ApondrePagina' ),
	'CreateCategory' => array( 'Crear una categoria', 'CrearCategoria' ),
	'CreateForm' => array( 'Crear un formulari', 'CrearFormulari' ),
	'CreateProperty' => array( 'Crear una proprietat', 'CrearProprietat' ),
	'CreateTemplate' => array( 'Crear un modèl', 'CrearModèl' ),
	'Forms' => array( 'Formularis' ),
	'Templates' => array( 'Modèls' ),
);

/** Pashto (پښتو) */
$aliases['ps'] = array(
	'AddPage' => array( 'مخ ګډول' ),
	'CreateCategory' => array( 'وېشنيزه جوړول' ),
	'CreateProperty' => array( 'د جوړولو ځانتيا' ),
	'CreateTemplate' => array( 'کينډۍ جوړول' ),
	'Templates' => array( 'کينډۍ' ),
);

/** Portuguese (Português) */
$aliases['pt'] = array(
	'AddData' => array( 'Adicionar dados' ),
	'AddPage' => array( 'Adicionar página' ),
	'CreateCategory' => array( 'Criar categoria' ),
	'CreateForm' => array( 'Criar formulário' ),
	'CreateProperty' => array( 'Criar propriedade' ),
	'CreateTemplate' => array( 'Criar modelo' ),
	'EditData' => array( 'Editar dados' ),
	'Forms' => array( 'Formulários' ),
	'Templates' => array( 'Modelos' ),
	'UploadWindow' => array( 'Janela de carregamento' ),
);

/** Brazilian Portuguese (Português do Brasil) */
$aliases['pt-br'] = array(
	'Forms' => array( 'Formulários' ),
	'Templates' => array( 'Predefinições' ),
);

/** Romanian (Română) */
$aliases['ro'] = array(
	'Templates' => array( 'Formate' ),
);

/** Slovak (Slovenčina) */
$aliases['sk'] = array(
	'AddData' => array( 'PridaťDáta' ),
	'AddPage' => array( 'PridaťStránku' ),
	'CreateCategory' => array( 'VytvoriťKategóriu' ),
	'CreateForm' => array( 'VytvoriťFormulár' ),
	'CreateProperty' => array( 'VytvoriťVlastnosť' ),
	'CreateTemplate' => array( 'VytvoriťŠablónu' ),
	'EditData' => array( 'UpraviťDáta' ),
	'Forms' => array( 'Formuláre' ),
	'Templates' => array( 'Šablóny' ),
	'UploadWindow' => array( 'NahrávacieOkno' ),
);

/** Albanian (Shqip) */
$aliases['sq'] = array(
	'Forms' => array( 'Format' ),
	'Templates' => array( 'Stampat' ),
);

/** Serbian Cyrillic ekavian (Српски (ћирилица)) */
$aliases['sr-ec'] = array(
	'AddPage' => array( 'ДодајСтраницу' ),
	'CreateCategory' => array( 'НаправиКатегорију' ),
);

/** Swahili (Kiswahili) */
$aliases['sw'] = array(
	'AddData' => array( 'WekaData' ),
	'AddPage' => array( 'WekaKurasa' ),
	'CreateCategory' => array( 'UndaJamii' ),
	'CreateForm' => array( 'UndaFomu' ),
	'CreateTemplate' => array( 'UndaKigezo' ),
	'EditData' => array( 'HaririData' ),
	'Forms' => array( 'Fomu' ),
	'Templates' => array( 'Vigezo' ),
	'UploadWindow' => array( 'DirishalaKupakizia' ),
);

/** Thai (ไทย) */
$aliases['th'] = array(
	'CreateCategory' => array( 'สร้างหมวดหมู่' ),
	'CreateForm' => array( 'สร้างฟอร์ม' ),
	'CreateTemplate' => array( 'สร้างแม่แบบ' ),
	'Forms' => array( 'แบบฟอร์ม' ),
	'Templates' => array( 'แม่แบบ' ),
);

/** Tagalog (Tagalog) */
$aliases['tl'] = array(
	'AddData' => array( 'Idagdag ang dato' ),
	'AddPage' => array( 'Idagdag ang pahina' ),
	'CreateCategory' => array( 'Likhain ang kaurian' ),
	'CreateForm' => array( 'Likhain ang pormularyo' ),
	'CreateProperty' => array( 'Likhain ang pag-aari' ),
	'CreateTemplate' => array( 'Likhain ang suleras' ),
	'EditData' => array( 'Baguhin ang dato' ),
	'Forms' => array( 'Mga pormularyo' ),
	'Templates' => array( 'Mga suleras' ),
	'UploadWindow' => array( 'Bintana ng pagkarga' ),
);

/** Turkish (Türkçe) */
$aliases['tr'] = array(
	'AddData' => array( 'VeriEkle' ),
	'AddPage' => array( 'SayfaEkle' ),
	'CreateCategory' => array( 'KategoriOluştur' ),
	'CreateForm' => array( 'FormOluştur' ),
	'CreateProperty' => array( 'ÖzellikOluştur' ),
	'CreateTemplate' => array( 'ŞablonOluştur' ),
	'EditData' => array( 'VeriDüzenle', 'VeriDeğiştir' ),
	'Forms' => array( 'Formlar' ),
	'Templates' => array( 'Şablonlar' ),
	'UploadWindow' => array( 'YüklemePenceresi' ),
);

/** Vèneto (Vèneto) */
$aliases['vec'] = array(
	'AddData' => array( 'ZontaDati' ),
	'AddPage' => array( 'ZontaPagina' ),
	'CreateTemplate' => array( 'CreaModèl' ),
	'Templates' => array( 'Modèi' ),
	'UploadWindow' => array( 'AjornaFenestra' ),
);

