<?php
/**
 * Internationalization file for the Semantic Forms extension
 *
 * @file
 * @ingroup Extensions
 */

// FIXME: Can be enabled when new style magic words are used (introduced in r52503)
// require_once( dirname( __FILE__ ) . '/SF_Magic.php' );

$messages = array();

/** English
 * @author Yaron Koren
 */
$messages['en'] = array(
	// user messages
	'semanticforms-desc'                 => 'Forms for adding and editing semantic data',
	'specialpages-group-sf_group'        => 'Semantic Forms',
	'createproperty'                     => 'Create a property',
	'sf_createproperty_linktoform'       => 'This property will link to pages that use the form:',
	'sf_createproperty_allowedvalsinput' => 'If you want this property to only be allowed to have certain values, enter the list of allowed values, separated by commas (if a value contains a comma, replace it with "\,"):',
	'sf_createproperty_propname'         => 'Property name:',
	'sf_createproperty_proptype'         => 'Type:',
	'templates'                          => 'Templates',
	'sf_templates_docu'                  => 'The following templates exist in the wiki.',
	'sf_templates_definescat'            => 'defines category:',
	'createtemplate'                     => 'Create a template',
	'sf_createtemplate_namelabel'        => 'Template name:',
	'sf_createtemplate_categorylabel'    => 'Category defined by template (optional):',
	'sf_createtemplate_templatefields'   => 'Template fields',
	'sf_createtemplate_fieldsdesc'       => 'To have the fields in this template no longer require field names, simply enter the index of each field (e.g. 1, 2, 3, etc.) as the name, instead of an actual name.',
	'sf_createtemplate_fieldname'        => 'Field name:',
	'sf_createtemplate_displaylabel'     => 'Display label:',
	'sf_createtemplate_semanticproperty' => 'Semantic property:',
	'sf_createtemplate_fieldislist'      => 'This field can hold a list of values, separated by commas',
	'sf_createtemplate_aggregation'      => 'Aggregation',
	'sf_createtemplate_aggregationdesc'  => 'To list, on any page using this template, all of the pages that have a certain property pointing to that page, specify the appropriate property below:',
	'sf_createtemplate_aggregationlabel' => 'Title for list:',
	'sf_createtemplate_outputformat'     => 'Output format:',
	'sf_createtemplate_standardformat'   => 'Standard',
	'sf_createtemplate_infoboxformat'    => 'Right-hand-side infobox',
	'sf_createtemplate_addfield'         => 'Add field',
	'sf_createtemplate_deletefield'      => 'Delete',
	'sf_createtemplate_addtemplatebeforesave' => 'You must add at least one template to this form before you can save it.',
	'forms'                              => 'Forms',
	'sf_forms_docu'                      => 'The following forms exist in the wiki.',
	'createform'                         => 'Create a form',
	'sf_createform_nameinput'            => 'Form name',
	'sf_createform_nameinputdesc'        => '(convention is to name the form after the main template it populates):',
	'sf_createform_template'             => 'Template:',
	'sf_createform_templatelabelinput'   => 'Template label (optional):',
	'sf_createform_allowmultiple'        => 'Allow for multiple (or zero) instances of this template in the created page',
	'sf_createform_field'                => 'Field:',
	'sf_createform_fieldprop'            => 'This field defines the property $1, of type $2.',
	'sf_createform_fieldproplist'        => 'This field defines a list of elements that have the property $1, of type $2.',
	'sf_createform_fieldpropunknowntype' => 'This field defines the property $1, of unspecified type.',
	'sf_createform_inputtype'            => 'Input type:',
	'sf_createform_inputtypedefault'     => '(default)',
	'sf_createform_formlabel'            => 'Form label:',
	'sf_createform_hidden'               => 'Hidden',
	'sf_createform_restricted'           => 'Restricted (only sysop users can modify it)',
	'sf_createform_mandatory'            => 'Mandatory',
	'sf_createform_removetemplate'       => 'Remove template',
	'sf_createform_addtemplate'          => 'Add template:',
	'sf_createform_beforetemplate'       => 'Before template:',
	'sf_createform_atend'                => 'At end',
	'sf_createform_add'                  => 'Add',
	'sf_createform_choosefield'          => 'Choose a field to add',
	'createcategory'                     => 'Create a category',
	'sf_createcategory_name'             => 'Category name:',
	'sf_createcategory_defaultform'      => 'Default form:',
	'sf_createcategory_makesubcategory'  => 'Make this a subcategory of another category (optional):',
	'createclass'                        => 'Create a class',
	'sf_createclass_docu'                => 'Enter all the data here to create the properties, template, form and category for a single class. For more options, use the pages $1 instead.',
	'sf_createclass_allowedvalues'       => 'Allowed values',
	'sf_createclass_listofvalues'        => 'List of values',
	'sf_createclass_leavefieldblank'     => 'If the field name is the same as the property name, you can leave it blank.',
	'sf_createclass_missingvalues'       => 'Not all required fields were filled out.',
	'sf_createclass_success'             => 'Properties, template, form and category will be created.',
	'formstart'                          => 'Start of form',
	'sf_formstart_badform'               => 'Error: no form page was found at $1',
	'sf_formstart_badtitle'              => 'Error: "$1" is an invalid title for a page.',
	'sf_formstart_docu'                  => 'Enter the name of a page here, to be edited with the form "$1".
If this page already exists, you will be sent to the form for editing that page.
Otherwise, you will be sent to the form for adding the page.',
	'sf_formstart_noform_docu'           => 'Enter the name of a page here, and select the form to edit it with.
If this page already exists, you will be sent to the form for editing that page.
Otherwise, you will be sent to the form for adding the page.',
	'sf_formstart_createoredit'          => 'Create or edit',
	'formedit'                           => 'Edit with form',
	'sf_formedit_createtitle'            => 'Create $1: $2',
	'sf_formedit_badurl'                  => 'This is the page for editing with a form. You must specify both a form name and a target page in the URL;
it should look like \'Special:FormEdit?form=&lt;form name&gt;&target=&lt;target page&gt;\', or  \'Special:FormEdit/&lt;form name&gt;/&lt;target page&gt;\'.',
	'sf_formedit_altforms'                => 'You can instead add this page with one of the following forms:',
	'sf_formedit_altformsonly'            => 'Please select from one of the following forms to add this page:',
	'sf_formcreate'                      => 'Create with form',
	'sf_viewform'                        => 'View form',
	'sf_editsource'                      => 'Edit source',
	'sf_formedit_edittitle'                  => 'Edit $1: $2',
	'sf_formedit_morethanoneform'        => "'''Warning:''' More than one default form is defined for this page.",
	'sf_formedit_formwarning'            => 'Warning: This page <a href="$1">already exists</a>, but it does not use this form.',
	'sf_formedit_remove'                 => 'Remove',
	'sf_formedit_addanother'             => 'Add another',
	'sf_formedit_none'                   => 'None',
	'runquery'                           => 'Run query',
	'sf_runquery_badurl'                 => 'You must specify a form name in the URL;
the URL should look like \'Special:RunQuery/&lt;form name&gt;\'.',
	'sf_runquery_title'                  => 'Run query: $1',
	'sf_runquery_additionalquery'        => 'Additional query',

	'sf_formerrors_header'               => 'There were errors with your form input; see below',
	'sf_blank_error'                     => 'cannot be blank',
	'sf_bad_url_error'                   => 'must have the correct URL format, starting with \'http\'',
	'sf_bad_email_error'                 => 'must have a valid email address format',
	'sf_bad_number_error'                => 'must be a valid number',
	'sf_bad_integer_error'               => 'must be a valid integer',
	'sf_bad_date_error'                  => 'must be a valid date',
	'uploadwindow'                       => 'Upload window', // Description for Special:UploadWindow
	'sf_deletionlog'                     => 'Deletion log',

	// content messages
	'sf_property_isproperty'             => 'This is a property of type $1.',
	'sf_property_linkstoform'            => 'It links to pages that use the form $1.',
	'sf_property_allowedvals'            => 'The allowed {{PLURAL:$1|value for this property is|values for this property are}}:',
	'sf_template_docu'                   => 'This is the "$1" template.
It should be called in the following format:',
	'sf_template_docufooter'             => 'Edit the page to see the template text.',
	'sf_form_docu'                       => 'This is the "$1" form.
To create a page with this form, enter the page name below;
if a page with that name already exists, you will be sent to a form to edit that page.',
	'sf_form_freetextlabel'          => 'Free text',
	'sf_category_hasdefaultform'         => 'This category uses the form $1.',
	'sf_category_desc'                   => 'This is the $1 category.',
	'sf_blank_namespace'                 => 'Main',

	// user rights
	'right-viewedittab'          => 'View "Edit" tab for pages editable by form',
	'right-editrestrictedfields' => 'Edit restricted form fields',
);

/** Message documentation (Message documentation)
 * @author EugeneZelenko
 * @author Fryed-peach
 * @author Jon Harald Søby
 * @author Purodha
 * @author Raymond
 * @author Siebrand
 * @author Umherirrender
 */
$messages['qqq'] = array(
	'semanticforms-desc' => '{{desc}}',
	'sf_createproperty_proptype' => '{{Identical|Type}}',
	'templates' => '{{Identical|Template}}',
	'sf_createtemplate_standardformat' => '{{Identical|Standard}}',
	'sf_createtemplate_deletefield' => '{{Identical|Delete}}',
	'sf_createform_template' => '{{Identical|Template}}',
	'sf_createform_field' => '{{Identical|Field}}',
	'sf_createform_inputtypedefault' => '{{Identical|Default}}',
	'sf_createform_hidden' => '{{Identical|Hidden}}',
	'sf_createform_add' => '{{Identical|Add}}',
	'formstart' => 'Name of a special page.',
	'sf_formedit_createtitle' => '* $1 is the main part of the title of a semantic form
* $2 is the prefixed title, with spaces for the target page
{{Identical|Create}}',
	'sf_formedit_edittitle' => '* $1 is the main part of the title of a semantic form
* $2 is the prefixed title, with spaces for the target page',
	'sf_formedit_remove' => '{{Identical|Remove}}',
	'sf_formedit_none' => '{{Identical|None}}',
	'sf_blank_error' => '{{Identical|Cannot be blank}}',
	'uploadwindow' => 'Special page name for [[Special:UploadWindow]].',
	'sf_deletionlog' => '{{Identical|Deletion log}}',
	'sf_form_freetextlabel' => '{{Identical|Free text}}',
	'right-viewedittab' => '{{doc-right|viewedittab}}',
	'right-editrestrictedfields' => '{{doc-right|editrestrictedfields}}',
);

/** Niuean (ko e vagahau Niuē)
 * @author Jose77
 */
$messages['niu'] = array(
	'sf_createtemplate_deletefield' => 'Tamate',
);

/** Afrikaans (Afrikaans)
 * @author Arnobarnard
 * @author Naudefj
 * @author SPQRobin
 */
$messages['af'] = array(
	'sf_createproperty_propname' => 'Naam:',
	'sf_createproperty_proptype' => 'Tipe:',
	'templates' => 'Sjablone',
	'sf_createtemplate_standardformat' => 'Standaard',
	'sf_createtemplate_deletefield' => 'Skrap',
	'sf_createform_template' => 'Sjabloon:',
	'sf_createform_field' => 'Veld:',
	'sf_createform_inputtypedefault' => '(standaard)',
	'sf_createform_hidden' => 'Verborge',
	'sf_createform_add' => 'Voeg by',
	'sf_createcategory_name' => 'Naam:',
	'sf_formedit_remove' => 'Skrap',
	'sf_formedit_none' => 'Geen',
	'sf_blank_error' => 'mag nie leeg wees nie',
	'sf_bad_date_error' => "moet 'n geldige datum wees",
	'sf_deletionlog' => 'Skraplogboek',
	'sf_form_freetextlabel' => 'Vrye teks',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'semanticforms-desc' => 'Formularët për shtimin dhe redaktimit të dhënat semantik',
	'specialpages-group-sf_group' => 'Semantik Format',
	'createproperty' => 'Krijo një pronë',
	'sf_createproperty_linktoform' => 'Kjo pronë do të lidhë për faqet që përdorin formën:',
	'sf_createproperty_allowedvalsinput' => 'Nëse dëshironi që kjo pronë të vetëm të lejohet të ketë vlera të caktuara, të hyjë në listën e vlerave të lejuara, të ndara me presje (nëse vlera përmban një presje, të zëvendësojë atë me ","):',
	'sf_createproperty_propname' => 'Emri i Pronës:',
	'sf_createproperty_proptype' => 'Tipi:',
	'templates' => 'Templates',
	'sf_templates_docu' => 'Në vijim templates ekzistojnë në wiki.',
	'sf_templates_definescat' => 'definon kategorinë:',
	'createtemplate' => 'Krijo një template',
	'sf_createtemplate_namelabel' => 'Emri Stampa:',
	'sf_createtemplate_categorylabel' => 'Kategoria përcaktuar nga template (opsional):',
	'sf_createtemplate_templatefields' => 'Fushat Template',
	'sf_createtemplate_fieldsdesc' => 'Për të kanë fushat në këtë shabllon nuk kërkojnë emra fushë, thjesht shkruani indeksi i çdo fushë (p.sh. 1, 2, 3, etj), si emri, në vend të një emri aktual.',
	'sf_createtemplate_fieldname' => 'Emri Fusha:',
	'sf_createtemplate_displaylabel' => 'etiketë Display:',
	'sf_createtemplate_semanticproperty' => 'pronës Semantic:',
	'sf_createtemplate_fieldislist' => 'Kjo fushë mund të mbajë një listë të vlerave, të ndara me presje',
	'sf_createtemplate_aggregation' => 'Grumbull',
	'sf_createtemplate_aggregationdesc' => 'Për të listës, në çdo faqe duke përdorur këtë template, të gjitha faqet që kanë një pronë të caktuar duke treguar atë faqe, specifikoni e pronës përkatëse më poshtë:',
	'sf_createtemplate_aggregationlabel' => 'Titulli për listën:',
	'sf_createtemplate_outputformat' => 'Formati Output:',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_infoboxformat' => 'Djathtas-anën Infobox',
	'sf_createtemplate_addfield' => 'fushë Shto',
	'sf_createtemplate_deletefield' => 'Fshij',
	'sf_createtemplate_addtemplatebeforesave' => 'Ju duhet të shtoni te pakten nje template për këtë formë para se të mund ta ruani atë.',
	'forms' => 'Formularët',
	'sf_forms_docu' => 'Format e mëposhtme ekzistojnë në wiki.',
	'createform' => 'Krijo një formë',
	'sf_createform_nameinput' => 'Emri Form',
	'sf_createform_nameinputdesc' => '(Konventë është që emri të formuar pas shabllonin kryesor ajo krijohet):',
	'sf_createform_template' => 'Stampa:',
	'sf_createform_templatelabelinput' => 'Etiketa Template (opsional):',
	'sf_createform_allowmultiple' => 'Lejo për të shumta (ose zero) raste të këtij template në faqen e krijuar',
	'sf_createform_field' => 'Fusha:',
	'sf_createform_fieldprop' => 'Kjo fushë definon pronën $1, e llojit $2.',
	'sf_createform_fieldproplist' => 'Kjo fushë përcakton një listë të elementëve që kanë pronë $1, e llojit $2.',
	'sf_createform_fieldpropunknowntype' => 'Kjo fushë definon pronën $1, e llojit të pacaktuar.',
);

/** Amharic (አማርኛ)
 * @author Codex Sinaiticus
 */
$messages['am'] = array(
	'sf_createproperty_propname' => 'ስም:',
	'sf_createtemplate_standardformat' => 'መደበኛ',
	'sf_createcategory_name' => 'ስም:',
);

/** Aragonese (Aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'sf_createproperty_propname' => 'Nombre:',
	'templates' => 'Plantillas',
	'sf_createtemplate_deletefield' => 'Borrar',
	'sf_createform_template' => 'Plantilla:',
	'sf_createcategory_name' => 'Nombre:',
	'sf_formedit_createtitle' => 'Creyar $1: $2',
	'sf_bad_date_error' => "ha d'estar una calendata conforme",
);

/** Arabic (العربية)
 * @author Meno25
 * @author OsamaK
 */
$messages['ar'] = array(
	'semanticforms-desc' => 'نماذج لإضافة وتعديل بيانات سيمانتك',
	'specialpages-group-sf_group' => 'منتديات سيمانتيك',
	'createproperty' => 'إنشاء خاصية',
	'sf_createproperty_linktoform' => 'هذه الخاصية ستصل إلى الصفحات التي تستخدم الاستمارة:',
	'sf_createproperty_allowedvalsinput' => 'لو كنت تريد أن تحتوي هذه الخاصية فقط على قيم معينة، أدخل قائمة القيم المسموحة، مفصولة بفاصلات (لو أن قيمة ما تحتوي على فاصلة، استبدلها ب "\\,"):',
	'sf_createproperty_propname' => 'اسم الخاصية:',
	'sf_createproperty_proptype' => 'النوع:',
	'templates' => 'قوالب',
	'sf_templates_docu' => 'القوالب التالية موجودة في الويكي.',
	'sf_templates_definescat' => 'يعرف التصنيف:',
	'createtemplate' => 'إنشاء قالب',
	'sf_createtemplate_namelabel' => 'اسم القالب:',
	'sf_createtemplate_categorylabel' => 'التصنيف معرف بواسطة قالب (اختياري):',
	'sf_createtemplate_templatefields' => 'حقول القالب',
	'sf_createtemplate_fieldsdesc' => 'لكي تجعل الحقول في هذا القالب لا تتطلب أسماء حقول، ببساطة أدخل فهرس كل حقل (مثل 1، 2، 3، إلى آخره.) كاسم، بدلا من اسم حقيقي.',
	'sf_createtemplate_fieldname' => 'اسم الحقل:',
	'sf_createtemplate_displaylabel' => 'علامة العرض:',
	'sf_createtemplate_semanticproperty' => 'خاصية سيمانتيك:',
	'sf_createtemplate_fieldislist' => 'هذا الحقل يمكنه أن يحتوي على قائمة من القيم، مفصولة بفاصلات',
	'sf_createtemplate_aggregation' => 'أجريجاشن',
	'sf_createtemplate_aggregationdesc' => 'لعرض، على أية صفحة تستخدم هذا القالب، كل الصفحات التي تمتلك خاصية معينة تشير إلى هذه الصفحة، حدد الخاصية المناسبة بالأسفل:',
	'sf_createtemplate_aggregationlabel' => 'العنوان للقائمة:',
	'sf_createtemplate_outputformat' => 'صيغة الخرج:',
	'sf_createtemplate_standardformat' => 'قياسي',
	'sf_createtemplate_infoboxformat' => 'صندوق معلومات على اليمين',
	'sf_createtemplate_addfield' => 'أضف حقلًا',
	'sf_createtemplate_deletefield' => 'حذف',
	'sf_createtemplate_addtemplatebeforesave' => 'يجب أن تضيف على الأقل قالبا واحدا إلى هذه الاستمارة قبل حفظها.',
	'forms' => 'استمارات',
	'sf_forms_docu' => 'الاستمارات التالية موجودة في الويكي.',
	'createform' => 'إنشاء استمارة',
	'sf_createform_nameinput' => 'اسم الاستمارة',
	'sf_createform_nameinputdesc' => '(العادة أن تتم تسمية النموذج بعد القالب الرئيسي الذي يشهره):',
	'sf_createform_template' => 'القالب:',
	'sf_createform_templatelabelinput' => 'علامة القالب (اختياري):',
	'sf_createform_allowmultiple' => 'السماح بوجود عدة (أو صفر) نسخة من هذا القالب في الصفحة المنشأة',
	'sf_createform_field' => 'الحقل:',
	'sf_createform_fieldprop' => 'هذا الحقل يعرف الخاصية $1، من نوع $2.',
	'sf_createform_fieldproplist' => 'هذا الحقل يعرف قائمة من العناصر التي تمتلك الخاصية $1، من نوع $2.',
	'sf_createform_fieldpropunknowntype' => 'هذا الحقل يعرف الخاصية $1، من نوع غير محدد.',
	'sf_createform_inputtype' => 'نوع الإدخال:',
	'sf_createform_inputtypedefault' => '(افتراضي)',
	'sf_createform_formlabel' => 'علامة الاستمارة:',
	'sf_createform_hidden' => 'مخفي',
	'sf_createform_restricted' => 'محدد (فقط المستخدمون مديرو النظام يمكنهم تعديله)',
	'sf_createform_mandatory' => 'إلزامي',
	'sf_createform_removetemplate' => 'إزالة القالب',
	'sf_createform_addtemplate' => 'إضافة القالب:',
	'sf_createform_beforetemplate' => 'قبل القالب:',
	'sf_createform_atend' => 'في النهاية',
	'sf_createform_add' => 'أضف',
	'sf_createform_choosefield' => 'اختر حقلا للإضافة',
	'createcategory' => 'إنشاء تصنيف',
	'sf_createcategory_name' => 'اسم التصنيف:',
	'sf_createcategory_defaultform' => 'الاستمارة الافتراضية:',
	'sf_createcategory_makesubcategory' => 'اجعل هذا تصنيفا فرعيا لتصنيف آخر (اختياري):',
	'createclass' => 'أنشئ رتبة',
	'sf_createclass_docu' => 'أدخل كل البيانات هنا لإنشاء الخواص، القوالب، النماذج والتصنيفات لرتبة واحدة. لمزيد من الخيارات، استخدم الصفحات $1 كبديل.',
	'sf_createclass_allowedvalues' => 'القيم المسموح بها',
	'sf_createclass_listofvalues' => 'قائمة القيم',
	'sf_createclass_leavefieldblank' => 'إذا كان اسم الحقل هو نفسه اسم الخاصية، فتستطيع تركه فارغًا.',
	'sf_createclass_missingvalues' => 'لم تملأ جميع الحقول.',
	'sf_createclass_success' => 'سوف تنشأ الخصائص والقالب والنموذج والتصنيف.',
	'formstart' => 'إضافة صفحة مع نموذج',
	'sf_formstart_badform' => 'خطأ: لا صفحة استمارة تم العثور عليها في $1',
	'sf_formstart_badtitle' => 'خطأ: "$1" عنوان غير صحيح لصفحة.',
	'sf_formstart_docu' => "أدخل اسم الصفحة هنا، لكي يتم تعديلها مع الاستمارة '$1'.
إذا كانت هذه الصفحة موجودة بالفعل، سيتم إرسالك إلى الاستمارة لتعديل هذه الصفحة.
أما غير ذلك، فسيتم إرسالك إلى الاستمارة لإضافة الصفحة.",
	'sf_formstart_noform_docu' => 'أدخل اسم الصفحة هنا، واختر الاستمارة لتعديلها معها.
إذا كانت هذه الصفحة موجودة بالفعل، سيتم إرسالك إلى الاستمارة لتعديل هذه الصفحة.
أما غير ذلك، فسيتم إرسالك إلى الاستمارة لإضافة الصفحة.',
	'sf_formstart_createoredit' => 'أضف أو عدّل',
	'formedit' => 'عدل مع الاستمارة',
	'sf_formedit_createtitle' => 'أضف $1: $2',
	'sf_formedit_badurl' => "هذه هي الصفحة لإضافة البيانات. يجب عليك تحديد اسم صفحة وصفحة هدف في المسار؛ ينبغي أن تبدو ك 'Special:FormEdit?form=&lt;form name&gt;&target=&lt;target page&gt;' أو  'Special:FormEdit/&lt;form name&gt;/&lt;target page&gt;'.",
	'sf_formedit_altforms' => 'يمكنك كبديل إضافة هذه الصفحة مع واحد من الاستمارات التالية:',
	'sf_formedit_altformsonly' => 'من فضلك اختر إحدى الاستمارات التالية لإضافة هذه الصفحة إليها:',
	'sf_formcreate' => 'أنشئ بنموذج',
	'sf_viewform' => 'عرض من',
	'sf_editsource' => 'مصدر التعديل',
	'sf_formedit_edittitle' => 'عدل $1: $2',
	'sf_formedit_morethanoneform' => "'''تحذير:''' أكثر من نموذج مبدئي معرّف لهذه الصفحة.",
	'sf_formedit_formwarning' => 'تحذير: هذه الصفحة <a href="$1">موجودة بالفعل</a>، لكنها لا تستخدم هذه الاستمارة.',
	'sf_formedit_remove' => 'إزالة',
	'sf_formedit_addanother' => 'إضافة آخر',
	'sf_formedit_none' => 'لا شيء',
	'runquery' => 'شغّل استعلامًا',
	'sf_runquery_badurl' => "يجب أن تحدد اسم نموذج في المسار;
المسار ينبغي أن يبدو ك 'Special:RunQuery/&lt;form name&gt;'.",
	'sf_runquery_title' => 'تشغيل الاستعلام: $1',
	'sf_runquery_additionalquery' => 'استعلام إضافي',
	'sf_formerrors_header' => 'هناك أخطاء في مدخلات استمارتك؛ انظر بالأسفل',
	'sf_blank_error' => 'لا يمكن أن يكون فارغا',
	'sf_bad_url_error' => "يجب أن يحتوي صيغة المسار الصحيحة، بادئا ب 'http'",
	'sf_bad_email_error' => 'يجب أن يحتوي صيغة عنوان بريد إلكتروني صحيحة',
	'sf_bad_number_error' => 'يجب أن يكون عددا سليما',
	'sf_bad_integer_error' => 'يجب أن يكون عددا صحيحا سليما',
	'sf_bad_date_error' => 'يجب أن يكون تاريخا سليما',
	'uploadwindow' => 'نافذة الرفع',
	'sf_deletionlog' => 'سجل الحذف',
	'sf_property_isproperty' => 'هذه خاصية من نوع $1.',
	'sf_property_linkstoform' => 'هي تصل إلى الصفحات التي تستخدم الاستمارة $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1||القيمة المسموح بها لهذه الخاصية هي|القيمتان المسموح بهما لهذه الخاصية هما|القيم المسموح بها لهذه الخاصية هي}}:',
	'sf_template_docu' => "هذا قالب '$1'.
ينبغي استدعاؤه بالصيغة التالية:",
	'sf_template_docufooter' => 'عدل الصفحة لرؤية نص القالب.',
	'sf_form_docu' => "هذه استمارة '$1'.
لإنشاء صفحة بهذه الاستمارة، أدخل اسم الصفحة بالأسفل؛
إذا وُجدت صفحة بهذا الاسم، فسيتم إرسالك إلى استمارة لتعديل تلك الصفحة.",
	'sf_form_freetextlabel' => 'نص حر',
	'sf_category_hasdefaultform' => 'هذا التصنيف يستخدم الاستمارة $1.',
	'sf_category_desc' => 'هذا $1 تصنيف.',
	'sf_blank_namespace' => 'رئيسي',
	'right-viewedittab' => 'أظهر لسان "عدّل" للصفحات التي يمكن تعديلها باستخدام نموذج.',
	'right-editrestrictedfields' => 'حرّر حقول النموذج المقيّدة',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'sf_createtemplate_deletefield' => 'ܫܘܦ',
	'sf_createform_hidden' => 'ܛܘܫܝܐ',
	'sf_createform_removetemplate' => 'ܠܚܝ ܩܠܒܐ',
	'sf_createform_add' => 'ܐܘܣܦ',
	'createcategory' => 'ܒܪܝ ܣܕܪܐ',
	'sf_createcategory_name' => 'ܫܡܐ ܕܣܕܪܐ:',
	'sf_formstart_createoredit' => 'ܒܪܝ ܐܘ ܫܚܠܦ',
	'sf_editsource' => 'ܫܚܠܦ ܥܩܪܐ',
	'sf_formedit_edittitle' => 'ܫܚܠܦ $1: $2',
	'sf_formedit_remove' => 'ܠܚܝ',
	'sf_formedit_addanother' => 'ܐܘܣܦ ܐܚܪܢܐ',
	'sf_formedit_none' => 'ܠܐ ܡܕܡ',
	'uploadwindow' => 'ܐܣܩ ܟܘܬܐ',
	'sf_blank_namespace' => 'ܪܫܝܬܐ',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Ghaly
 * @author Meno25
 */
$messages['arz'] = array(
	'semanticforms-desc' => 'نماذج لإضافة وتعديل بيانات سيمانتك',
	'specialpages-group-sf_group' => 'منتديات سيمانتيك',
	'createproperty' => 'إنشاء خاصية',
	'sf_createproperty_allowedvalsinput' => 'لو كنت تريد أن تحتوى هذه الخاصية فقط على قيم معينة، أدخل قائمة القيم المسموحة، مفصولة بفاصلات (لو أن قيمة ما تحتوى على فاصلة، استبدلها ب "\\,"):',
	'sf_createproperty_propname' => 'اسم الخاصية:',
	'sf_createproperty_proptype' => 'النوع:',
	'templates' => 'قوالب',
	'sf_templates_docu' => 'القوالب التالية موجودة فى الويكى.',
	'sf_templates_definescat' => 'يعرف التصنيف:',
	'createtemplate' => 'إنشاء قالب',
	'sf_createtemplate_namelabel' => 'اسم القالب:',
	'sf_createtemplate_categorylabel' => 'التصنيف معرف بواسطة قالب (اختياري):',
	'sf_createtemplate_templatefields' => 'حقول القالب',
	'sf_createtemplate_fieldsdesc' => 'لكى تجعل الحقول فى هذا القالب لا تتطلب أسماء حقول، ببساطة أدخل فهرس كل حقل (مثل 1، 2، 3، إلى آخره.) كاسم، بدلا من اسم حقيقى.',
	'sf_createtemplate_fieldname' => 'اسم الحقل:',
	'sf_createtemplate_displaylabel' => 'علامة العرض:',
	'sf_createtemplate_semanticproperty' => 'خاصية سيمانتيك:',
	'sf_createtemplate_fieldislist' => 'هذا الحقل يمكنه أن يحتوى على قائمة من القيم، مفصولة بفاصلات',
	'sf_createtemplate_aggregation' => 'أجريجاشن',
	'sf_createtemplate_aggregationdesc' => 'لعرض، على أية صفحة تستخدم هذا القالب، كل الصفحات التى تمتلك خاصية معينة تشير إلى هذه الصفحة، حدد الخاصية المناسبة بالأسفل:',
	'sf_createtemplate_aggregationlabel' => 'العنوان للقائمة:',
	'sf_createtemplate_outputformat' => 'صيغة الخرج:',
	'sf_createtemplate_standardformat' => 'قياسي',
	'sf_createtemplate_infoboxformat' => 'صندوق معلومات على اليمين',
	'sf_createtemplate_addfield' => 'إضافة حقل',
	'sf_createtemplate_deletefield' => 'حذف',
	'sf_createtemplate_addtemplatebeforesave' => 'يجب أن تضيف على الأقل قالبا واحدا إلى هذه الاستمارة قبل حفظها.',
	'forms' => 'استمارات',
	'sf_forms_docu' => 'الاستمارات التالية موجودة فى الويكى.',
	'createform' => 'إنشاء استمارة',
	'sf_createform_nameinput' => 'اسم الاستمارة',
	'sf_createform_template' => 'القالب:',
	'sf_createform_templatelabelinput' => 'علامة القالب (اختياري):',
	'sf_createform_allowmultiple' => 'السماح بوجود عدة (أو صفر) نسخة من هذا القالب فى الصفحة المنشأة',
	'sf_createform_field' => 'الحقل:',
	'sf_createform_fieldprop' => 'هذا الحقل يعرف الخاصية $1، من نوع $2.',
	'sf_createform_fieldproplist' => 'هذا الحقل يعرف قائمة من العناصر التى تمتلك الخاصية $1، من نوع $2.',
	'sf_createform_fieldpropunknowntype' => 'الحقل ده يعرف الخاصية $1، من نوع  مش متحدد.',
	'sf_createform_inputtype' => 'نوع الإدخال:',
	'sf_createform_inputtypedefault' => '(افتراضي)',
	'sf_createform_formlabel' => 'علامة الاستمارة:',
	'sf_createform_hidden' => 'مخفي',
	'sf_createform_restricted' => 'محدد (فقط المستخدمون مديرو النظام يمكنهم تعديله)',
	'sf_createform_mandatory' => 'إلزامي',
	'sf_createform_removetemplate' => 'إزالة القالب',
	'sf_createform_addtemplate' => 'إضافة القالب:',
	'sf_createform_beforetemplate' => 'قبل القالب:',
	'sf_createform_atend' => 'فى النهاية',
	'sf_createform_add' => 'إضافة',
	'sf_createform_choosefield' => 'اختر حقلا للإضافة',
	'createcategory' => 'إنشاء تصنيف',
	'sf_createcategory_name' => 'اسم التصنيف:',
	'sf_createcategory_defaultform' => 'الاستمارة الافتراضية:',
	'sf_createcategory_makesubcategory' => 'اجعل هذا تصنيفا فرعيا لتصنيف آخر (اختياري):',
	'formstart' => 'إضافة صفحة مع نموذج',
	'sf_formstart_badform' => 'خطأ: لا صفحة استمارة تم العثور عليها فى $1',
	'sf_formstart_docu' => "أدخل اسم الصفحة هنا، لكى يتم تعديلها مع الاستمارة '$1'.
إذا كانت هذه الصفحة موجودة بالفعل، سيتم إرسالك إلى الاستمارة لتعديل هذه الصفحة.
أما غير ذلك، فسيتم إرسالك إلى الاستمارة لإضافة الصفحة.",
	'sf_formstart_noform_docu' => 'أدخل اسم الصفحة هنا، واختر الاستمارة لتعديلها معها.
إذا كانت هذه الصفحة موجودة بالفعل، سيتم إرسالك إلى الاستمارة لتعديل هذه الصفحة.
أما غير ذلك، فسيتم إرسالك إلى الاستمارة لإضافة الصفحة.',
	'sf_formstart_createoredit' => 'أضف أو عدل',
	'formedit' => 'عدل مع الاستمارة',
	'sf_formedit_createtitle' => 'أضف $1: $2',
	'sf_formedit_badurl' => "هذه هى الصفحة لإضافة البيانات. يجب عليك تحديد اسم صفحة وصفحة هدف فى المسار؛ ينبغى أن تبدو ك 'Special:FormEdit?form=&lt;form name&gt;&target=&lt;target page&gt;' أو  'Special:FormEdit/&lt;form name&gt;/&lt;target page&gt;'.",
	'sf_formedit_altforms' => 'يمكنك كبديل إضافة هذه الصفحة مع واحد من الاستمارات التالية:',
	'sf_formedit_altformsonly' => 'من فضلك اختر إحدى الاستمارات التالية لإضافة هذه الصفحة إليها:',
	'sf_viewform' => 'عرض من',
	'sf_editsource' => 'مصدر التعديل',
	'sf_formedit_edittitle' => 'عدل $1: $2',
	'sf_formedit_formwarning' => 'تحذير: هذه الصفحة <a href="$1">موجودة بالفعل</a>، لكنها لا تستخدم هذه الاستمارة.',
	'sf_formedit_remove' => 'إزالة',
	'sf_formedit_addanother' => 'إضافة آخر',
	'sf_formedit_none' => 'لا شيء',
	'sf_formerrors_header' => 'هناك أخطاء فى مدخلات استمارتك؛ انظر بالأسفل',
	'sf_blank_error' => 'لا يمكن أن يكون فارغا',
	'sf_bad_url_error' => "يجب أن يحتوى صيغة المسار الصحيحة، بادئا ب 'http'",
	'sf_bad_email_error' => 'يجب أن يحتوى صيغة عنوان بريد إلكترونى صحيحة',
	'sf_bad_number_error' => 'يجب أن يكون عددا سليما',
	'sf_bad_integer_error' => 'يجب أن يكون عددا صحيحا سليما',
	'sf_bad_date_error' => 'يجب أن يكون تاريخا سليما',
	'uploadwindow' => 'نافذة الرفع',
	'sf_property_isproperty' => 'هذه خاصية من نوع $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1||القيمة المسموح بها لهذه الخاصية هي|القيمتان المسموح بهما لهذه الخاصية هما|القيم المسموح بها لهذه الخاصية هي}}:',
	'sf_template_docu' => "هذا قالب '$1'.
ينبغى استدعاؤه بالصيغة التالية:",
	'sf_template_docufooter' => 'عدل الصفحة لرؤية نص القالب.',
	'sf_form_docu' => "هذه استمارة '$1'.
لإضافة صفحة مع هذه الاستمارة، أدخل اسم الصفحة بالأسفل؛
إذا كانت هناك صفحة موجودة بهذا الاسم، سيتم إرسالك إلى استمارة لتعديل هذه الصفحة.",
	'sf_form_freetextlabel' => 'نص حر',
	'sf_category_hasdefaultform' => 'هذا التصنيف يستخدم الاستمارة $1.',
	'sf_category_desc' => 'هذا $1 تصنيف.',
	'sf_blank_namespace' => 'رئيسي',
);

/** Kotava (Kotava)
 * @author Nkosi ya Cabinda
 * @author Wikimistusik
 */
$messages['avk'] = array(
	'createproperty' => 'Redura va pilkaca',
	'sf_createproperty_propname' => 'Yolt :',
	'sf_createproperty_proptype' => 'Ord :',
	'templates' => 'Tezeem',
	'sf_templates_docu' => 'Bata teza yo koe wiki tid.',
	'sf_templates_definescat' => 'lomatentura :',
	'createtemplate' => 'Redura va teza',
	'sf_createtemplate_namelabel' => 'Tezayolt :',
	'sf_createtemplate_categorylabel' => 'Loma tezon tentuna (rotison) :',
	'sf_createtemplate_templatefields' => 'Tezarapteem',
	'sf_createtemplate_fieldname' => 'Raptayolt :',
	'sf_createtemplate_displaylabel' => 'Kralfintara :',
	'sf_createtemplate_semanticproperty' => 'Sugdalafa pilkaca :',
	'sf_createtemplate_aggregationdesc' => 'Moe betu bu favesu va bata teza, ta vexalara va kot teliz digis va man pilkot skedas va batu bu, va pilkotanh vleveon bazel :',
	'sf_createtemplate_aggregationlabel' => 'Vexalavergumvelt :',
	'sf_createtemplate_outputformat' => 'Divaf breviz',
	'sf_createtemplate_standardformat' => 'Preksaf',
	'sf_createtemplate_addfield' => 'Loplekura va rapta',
	'sf_createtemplate_deletefield' => 'Sulara',
	'sf_createtemplate_addtemplatebeforesave' => 'Va tanoya teza ko bata erurateza leon goloplekul abdi da rogiwal.',
	'forms' => 'Eruratezeem',
	'sf_forms_docu' => 'Bata erurateza yo koe wiki tid.',
	'createform' => 'Redura va erurateza',
	'sf_createform_template' => 'Teza :',
	'sf_createform_templatelabelinput' => 'Tezakral (rotir) :',
	'sf_createform_field' => 'Rapta :',
	'sf_createform_fieldprop' => 'Bata rapta va $1 pilkaca (dem $2 ord) tentur.',
	'sf_createform_fieldproplist' => 'Bata rapta va reem tentur lize kota ra va $1 pilkot (ke $2 ord) digir.',
	'sf_createform_fieldpropunknowntype' => 'Bata rapta va $1 pilkaca (ke meruidayan ord) tentur.',
	'sf_createform_inputtype' => 'Kof ord :',
	'sf_createform_inputtypedefault' => '(omavon)',
	'sf_createform_formlabel' => 'Eruratezakral :',
	'sf_createform_hidden' => 'Palsen',
	'sf_createform_restricted' => 'Irutan (anton ristusik vaon robetar)',
	'sf_createform_removetemplate' => 'Tioltera va teza',
	'sf_createform_addtemplate' => 'Loplekura va teza :',
	'sf_createform_beforetemplate' => 'Abdi teza :',
	'sf_createform_atend' => 'Arton',
	'sf_createform_add' => 'Loplekura',
	'sf_createform_choosefield' => 'Va goloplekuna rapta kiblal !',
	'createcategory' => 'Redura va loma',
	'sf_createcategory_name' => 'Yolt :',
	'sf_createcategory_defaultform' => 'Omavafa erurateza :',
	'sf_createcategory_makesubcategory' => 'Artazukara va bata loma ton volveyloma (rotison) :',
	'formstart' => 'Loplekura va bu',
	'sf_formstart_badform' => 'Rokla : meku eruratezabu trasinu koe $1',
	'sf_formstart_createoredit' => 'Loplekura ok betara',
	'formedit' => 'Betara kan erurateza',
	'sf_formedit_createtitle' => 'Loplekura va $1 : $2',
	'sf_formedit_altformsonly' => 'Va tanoya vlevefa erurateza goloplekuna ko batu bu vay rebal :',
	'sf_editsource' => 'Klitabetara',
	'sf_formedit_edittitle' => 'Betara va $1 : $2',
	'sf_formedit_formwarning' => 'Obral ! Batu bu (<a href="$1">) ixam tir</a>, vexe va bata erurateza me faver.',
	'sf_formedit_remove' => 'Dimplekura',
	'sf_formedit_addanother' => 'Loplekura va arcoba',
	'sf_blank_error' => 'Me rotir vlardaf',
	'sf_bad_url_error' => "Gotir URL brevizanh, tozus kan 'http'",
	'sf_bad_email_error' => 'Gotir e-mail mane brevizanh',
	'sf_bad_number_error' => 'gotir va enafa ota',
	'sf_bad_date_error' => 'gotir enafa evla',
	'sf_property_isproperty' => 'Tir pilkaca ke $1 ord.',
	'sf_property_allowedvals' => 'Rictana voda se ke bat pilkovoy tid :',
	'sf_template_docu' => "Tir '$1' teza. Kan vlevef breviz zo gonerur :",
	'sf_template_docufooter' => 'Burupera ta wira va tezacek',
	'sf_form_docu' => "Tir '$1' erurateza. Ta koon buloplekura, va buyolt vleveon bazel ; ede milyoltafu bu ixam tir, ta bubetara erurateza zo fintatar.",
	'sf_form_freetextlabel' => 'Nuyaf krent',
	'sf_category_hasdefaultform' => 'Bata loma va $1 erurateza faver.',
	'sf_category_desc' => 'Tir $1 loma.',
	'sf_blank_namespace' => 'Nelkaxo',
);

/** Belarusian (Taraškievica orthography) (Беларуская (тарашкевіца))
 * @author EugeneZelenko
 * @author Jim-by
 * @author Red Winged Duck
 */
$messages['be-tarask'] = array(
	'semanticforms-desc' => 'Формы для даданьня і рэдагаваньня сэмантычных зьвестак',
	'specialpages-group-sf_group' => 'Сэмантычныя формы',
	'createproperty' => 'Стварыць уласьцівасьць',
	'sf_createproperty_linktoform' => 'Гэта ўласьцівасьць будзе спасылацца на старонкі, якія выкарыстоўваюць форму:',
	'sf_createproperty_allowedvalsinput' => 'Калі Вы жадаеце, каб гэта ўласьцівасьць мела толькі некаторыя значэньні, увядзіце сьпіс дазволеных значэньняў, падзелены коскамі (калі значэньне ўтрымлівае коску, замяніце яе на «\\,»):',
	'sf_createproperty_propname' => 'Назва ўласьцівасьці:',
	'sf_createproperty_proptype' => 'Тып:',
	'templates' => 'Шаблёны',
	'sf_templates_docu' => 'У {{GRAMMAR:месны|{{SITENAME}}}} існуюць наступныя шаблёны.',
	'sf_templates_definescat' => 'вызначае катэгорыю:',
	'createtemplate' => 'Стварыць шаблён',
	'sf_createtemplate_namelabel' => 'Назва шаблёну:',
	'sf_createtemplate_categorylabel' => 'Катэгорыя, якая вызначаецца шаблёнам (неабавязкова):',
	'sf_createtemplate_templatefields' => 'Палі шаблёну',
	'sf_createtemplate_fieldsdesc' => 'Палі гэтага шаблёну болей не патрабуюць назваў, проста ўвядзіце індэкс кожнага поля (напрыклад, 1, 2, 3 і г.д.) замест назваў.',
	'sf_createtemplate_fieldname' => 'Назва поля:',
	'sf_createtemplate_displaylabel' => 'Надпіс, які будзе паказвацца:',
	'sf_createtemplate_semanticproperty' => 'Сэмантычная ўласьцівасьць:',
	'sf_createtemplate_fieldislist' => 'Гэта поле можа ўтрымліваць сьпіс значэньняў, падзеленых коскамі',
	'sf_createtemplate_aggregation' => 'Злучэньне',
	'sf_createtemplate_aggregationdesc' => 'Каб выводзіць на любую старонку, якая выкарыстоўвае гэты шаблён, усе старонкі, у якіх гэтая ўласьцівасьць спасылаецца на гэтую старонку, пазначце адпаведную ўласьцівасьць ніжэй:',
	'sf_createtemplate_aggregationlabel' => 'Назва сьпісу:',
	'sf_createtemplate_outputformat' => 'Фармат вываду:',
	'sf_createtemplate_standardformat' => 'Стандартны',
	'sf_createtemplate_infoboxformat' => 'Інфармацыйная панэль справа',
	'sf_createtemplate_addfield' => 'Дадаць поле',
	'sf_createtemplate_deletefield' => 'Выдаліць',
	'sf_createtemplate_addtemplatebeforesave' => 'Вам трэба дадаць хаця бы адзін шаблён да гэтай формы для таго, каб яе можна было захаваць.',
	'forms' => 'Формы',
	'sf_forms_docu' => 'У {{GRAMMAR:месны|{{SITENAME}}}} існуюць наступныя формы.',
	'createform' => 'Стварыць форму',
	'sf_createform_nameinput' => 'Назва формы',
	'sf_createform_nameinputdesc' => '(умоўныя абазначэньні зьяўляюцца назвай формы пасьля таго, як яе запоўніць галоўны шаблён):',
	'sf_createform_template' => 'Шаблён:',
	'sf_createform_templatelabelinput' => 'Пазнака шаблёну (неабавязкова):',
	'sf_createform_allowmultiple' => 'Дазволіць некалькі (ці нуль) экзэмпляраў гэтага шаблёну ў ствараемай старонцы',
	'sf_createform_field' => 'Поле:',
	'sf_createform_fieldprop' => 'Гэта поле вызначае ўласьцівасьць $1 тыпу $2.',
	'sf_createform_fieldproplist' => 'Гэта поле вызначае сьпіс элемэнтаў, якія маюць уласьцівасьць $1 тыпу $2.',
	'sf_createform_fieldpropunknowntype' => 'Гэта поле вызначае ўласьцівасьць $1 непазначанага тыпу.',
	'sf_createform_inputtype' => 'Уваходны тып:',
	'sf_createform_inputtypedefault' => '(па змоўчваньні)',
	'sf_createform_formlabel' => 'Пазнака формы:',
	'sf_createform_hidden' => 'Схаваная',
	'sf_createform_restricted' => 'Абмежаваная (зьмяняць могуць толькі адміністратары)',
	'sf_createform_mandatory' => 'Абавязковая',
	'sf_createform_removetemplate' => 'Выдаліць шаблён',
	'sf_createform_addtemplate' => 'Дадаць шаблён:',
	'sf_createform_beforetemplate' => 'Перад шаблёнам:',
	'sf_createform_atend' => 'У канцы',
	'sf_createform_add' => 'Дадаць',
	'sf_createform_choosefield' => 'Выберыце поле для даданьня',
	'createcategory' => 'Стварыць катэгорыю',
	'sf_createcategory_name' => 'Назва катэгорыі:',
	'sf_createcategory_defaultform' => 'Форма па змоўчваньні:',
	'sf_createcategory_makesubcategory' => 'Зрабіць гэта падкатэгорыяй іншай катэгорыі (неабавязкова):',
	'createclass' => 'Стварыць кляс',
	'sf_createclass_docu' => 'Для стварэньня ўласьцівасьцяў, шаблёнаў, форм і катэгорый аднаго кляса, увядзіце тут ўсе зьвесткі. Для дадатковых магчымасьцяў, выкарыстоўвайце старонкі $1.',
	'sf_createclass_allowedvalues' => 'Дазволеныя значэньні',
	'sf_createclass_listofvalues' => 'Сьпіс значэньняў',
	'sf_createclass_leavefieldblank' => 'Калі назва поля такая ж як і назва ўласьцівасьці, Вы можаце пакінуць яе пустой.',
	'sf_createclass_missingvalues' => 'Ня ўсе неабходныя палі былі запоўнены.',
	'sf_createclass_success' => 'Будуць створаны ўласьцівасьці, шаблёны, формы і катэгорыі.',
	'formstart' => 'Дадаць старонку з формай',
	'sf_formstart_badform' => 'Памылка: ня знойдзена старонка формы на $1',
	'sf_formstart_badtitle' => 'Памылка: «$1» — няслушная назва для старонкі.',
	'sf_formstart_docu' => "Увядзіце тут назву старонкі, якую трэба рэдагаваць з дапамогай формы '$1'. 
Калі гэта старонка ўжо існуе, Вы будзеце накіраваны на форму рэдагаваньня старонкі. 
У адваротным выпадку, Вы будзеце накіраваны на форму даданьня старонкі.",
	'sf_formstart_noform_docu' => 'Увядзіце тут назву старонкі і выберыце форму, з дапамогай якой Вы будзеце рэдагаваць старонку.
Калі гэта старонка ўжо існуе, Вы будзеце накіраваны на форму рэдагаваньня старонкі.
У адваротным выпадку, Вы будзеце накіраваны на форму даданьня старонкі.',
	'sf_formstart_createoredit' => 'Стварыць альбо рэдагаваць',
	'formedit' => 'Рэдагаваць з дапамогай формы',
	'sf_formedit_createtitle' => 'Стварыць $1: $2',
	'sf_formedit_badurl' => "Гэтая старонка для рэдагаваньня праз форму. Вам неабходна пазначыць назву формы і мэтавую старонку ў URL-адрасе;
гэта павінна выглядаць наступным чынам: 'Special:FormEdit?form=&lt;назва формы&gt;&target=&lt;мэтавая старонка&gt;' альбо  'Special:FormEdit/&lt;назва формы&gt;/&lt;мэтавая старонка&gt;'.",
	'sf_formedit_altforms' => 'Замест гэтага Вы можаце дадаць гэту старонку з дапамогай наступных формаў:',
	'sf_formedit_altformsonly' => 'Калі ласка, выберыце адну з наступных формаў для даданьня гэтай старонкі:',
	'sf_formcreate' => 'Стварыць з дапамогай формы',
	'sf_viewform' => 'Паказаць форму',
	'sf_editsource' => 'Рэдагаваць крыніцу',
	'sf_formedit_edittitle' => 'Рэдагаваньне $1: $2',
	'sf_formedit_morethanoneform' => 'Увага: для гэтай старонкі вызначана па змоўчваньні больш за адну форму.',
	'sf_formedit_formwarning' => 'Увага: старонка <a href="$1">ужо існуе</a>, але яна не выкарыстоўвае гэтую форму.',
	'sf_formedit_remove' => 'Выдаліць',
	'sf_formedit_addanother' => 'Дадаць іншую',
	'sf_formedit_none' => 'Нічога',
	'runquery' => 'Выканаць запыт',
	'sf_runquery_badurl' => "Вам неабходна пазначыць назву формы ў URL-адрасе;
URL-адрас павінен мець выгляд 'Special:RunQuery/&lt;назва формы&gt;'.",
	'sf_runquery_title' => 'Выканаць запыт: $1',
	'sf_runquery_additionalquery' => 'Дадатковы запыт',
	'sf_formerrors_header' => 'Знойдзеныя памылкі ў Вашай форме ўводу; глядзіце ніжэй',
	'sf_blank_error' => 'ня можа быць пустым',
	'sf_bad_url_error' => "павінна мець слушны фармат URL, пачынацца з 'http'",
	'sf_bad_email_error' => 'павінна мець слушны фармат адрасу электроннай пошты',
	'sf_bad_number_error' => 'павінна быць слушным лікам',
	'sf_bad_integer_error' => 'павінна быць слушным цэлым лікам',
	'sf_bad_date_error' => 'павінна быць слушнай датай',
	'uploadwindow' => 'Акно загрузкі',
	'sf_deletionlog' => 'Журнал выдаленьняў',
	'sf_property_isproperty' => 'Гэта ўласьцівасьць тыпу $1.',
	'sf_property_linkstoform' => 'Гэта ўласьцівасьць спасылаецца на старонкі, якія выкарыстоўваюць форму $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Дазволенае значэньне|Дазволеныя значэньні}} для гэтай уласьцівасьці:',
	'sf_template_docu' => "Гэта шаблён '$1', які павінен выклікацца наступным чынам:",
	'sf_template_docufooter' => 'Рэдагуйце старонку, каб убачыць тэкст шаблёну.',
	'sf_form_docu' => 'Гэта форма «$1».
Каб стварыць старонку з гэтай формай, увядзіце назву старонкі ніжэй;
калі старонка з такой назвай ужо існуе, Вы будзеце накіраваны на форму рэдагаваньня гэтай старонкі.',
	'sf_form_freetextlabel' => 'Свабодны тэкст',
	'sf_category_hasdefaultform' => 'Гэта катэгорыя выкарыстоўвае форму $1.',
	'sf_category_desc' => 'Гэта катэгорыя $1.',
	'sf_blank_namespace' => 'Галоўная',
	'right-viewedittab' => 'прагляд закладак «Рэдагаваць» для старонак, якія можна рэдагаваць праз форму',
	'right-editrestrictedfields' => 'рэдагаваньне абмежаваных палёў форм',
);

/** Bulgarian (Български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'sf_createproperty_propname' => 'Име:',
	'sf_createproperty_proptype' => 'Вид:',
	'templates' => 'Шаблони',
	'sf_templates_docu' => 'Следните шаблони съществуват в уикито.',
	'sf_templates_definescat' => 'дефинира категория:',
	'createtemplate' => 'Създаване на шаблон',
	'sf_createtemplate_namelabel' => 'Име на шаблон:',
	'sf_createtemplate_categorylabel' => 'Категория, дефинирана от шаблон (незадължително):',
	'sf_createtemplate_fieldname' => 'Име на полето:',
	'sf_createtemplate_semanticproperty' => 'Семантично свойство:',
	'sf_createtemplate_fieldislist' => 'Това поле може да съдържа само списък със стойности, разделени със запетаи',
	'sf_createtemplate_aggregationlabel' => 'Заглавие за списъка:',
	'sf_createtemplate_outputformat' => 'Изходен формат:',
	'sf_createtemplate_standardformat' => 'Стандартен',
	'sf_createtemplate_infoboxformat' => 'Инфокутия в дясно',
	'sf_createtemplate_addfield' => 'Добавяне на поле',
	'sf_createtemplate_deletefield' => 'Изтриване',
	'sf_createtemplate_addtemplatebeforesave' => 'Преди да бъде възможно съхраняването на формуляра е необходимо в него да бъде добавен поне един шаблон.',
	'forms' => 'Формуляри',
	'sf_forms_docu' => 'В уикито съществуват следните формуляри.',
	'createform' => 'Създаване на формуляр',
	'sf_createform_template' => 'Шаблон:',
	'sf_createform_field' => 'Поле:',
	'sf_createform_inputtypedefault' => '(по подразбиране)',
	'sf_createform_removetemplate' => 'Премахване на шаблон',
	'sf_createform_addtemplate' => 'Добавяне на шаблон:',
	'sf_createform_beforetemplate' => 'Преди шаблон:',
	'sf_createform_atend' => 'В края',
	'sf_createform_add' => 'Добавяне',
	'sf_createform_choosefield' => 'Избор на поле за добавяне',
	'createcategory' => 'Създаване на категория',
	'sf_createcategory_name' => 'Име:',
	'sf_createcategory_defaultform' => 'Формуляр по подразбиране:',
	'formstart' => 'Добавяне на страница с формуляр',
	'sf_formstart_createoredit' => 'Добавяне или редактиране',
	'formedit' => 'Редактиране с формуляр',
	'sf_formedit_createtitle' => 'Добавяне на $1: $2',
	'sf_formedit_altformsonly' => 'Изберете един от следните формуляри за добавяне на страницата:',
	'sf_viewform' => 'Преглед на формуляра',
	'sf_editsource' => 'Редактиране на източника',
	'sf_formedit_edittitle' => 'Редактиране на $1: $2',
	'sf_formedit_formwarning' => 'Внимание: Тази страница <a href="$1">вече съществува</a>, но не използва този формуляр.',
	'sf_formedit_remove' => 'Премахване',
	'sf_formedit_none' => 'Няма',
	'sf_blank_error' => 'не може да бъде празно',
	'sf_bad_url_error' => "необходимо е да съдържа правилния URL формат, започващ с 'http'",
	'sf_bad_email_error' => 'необходимо е да съдържа валиден формат за е-поща',
	'sf_bad_number_error' => 'необходимо е да е валидно число',
	'sf_bad_date_error' => 'необходимо е да бъде валидна дата',
	'uploadwindow' => 'Прозорец за качване',
	'sf_template_docu' => "Това е шаблонът '$1'. Той следва да бъде извикван в следния формат:",
	'sf_template_docufooter' => 'Редактирането на страницата ще покаже текста на шаблона.',
	'sf_form_docu' => 'Това е формулярът \'$1".
За добавяне на страница с този формуляр, необходимо е да се въведе името на страницата по-долу;
ако страница с това име вече съществува, ще бъде отворен формуляр за редактиране на страницата.',
	'sf_form_freetextlabel' => 'Свободен текст',
	'sf_category_hasdefaultform' => 'Тази категория използва формуляра $1.',
	'sf_category_desc' => 'Това е категорията $1.',
);

/** Bengali (বাংলা)
 * @author Zaheen
 */
$messages['bn'] = array(
	'sf_createtemplate_deletefield' => 'মুছে ফেলা হোক',
);

/** Breton (Brezhoneg)
 * @author Fohanno
 * @author Fulup
 * @author Y-M D
 */
$messages['br'] = array(
	'semanticforms-desc' => 'Furmskrid evit ouzhpennañ hag aozañ roadennoù semantek',
	'specialpages-group-sf_group' => 'Furmskridoù semantek',
	'createproperty' => 'Krouiñ ur perzh',
	'sf_createproperty_linktoform' => 'Ar perzh-mañ a liammo ouzh ar pajennoù a implij ar furmskrid :',
	'sf_createproperty_propname' => 'Anv ar perzh :',
	'sf_createproperty_proptype' => 'Seurt :',
	'templates' => 'Patromoù',
	'sf_templates_docu' => 'Ar patromoù-mañ zo anezho dija er wiki.',
	'sf_templates_definescat' => 'termeniñ a ra ar rummad :',
	'createtemplate' => 'Sevel ur patrom',
	'sf_createtemplate_namelabel' => 'Anv ar patrom :',
	'sf_createtemplate_categorylabel' => 'Rummad termenet gant ar patrom-mañ (diret) :',
	'sf_createtemplate_templatefields' => 'Maeziennoù skouer',
	'sf_createtemplate_fieldname' => 'Anv ar vaezienn :',
	'sf_createtemplate_displaylabel' => 'Tikedenn diskwel :',
	'sf_createtemplate_semanticproperty' => 'Perzh semantek :',
	'sf_createtemplate_fieldislist' => "Er vaezienn-mañ e c'hall bezañ ur roll talvoudoù, dispartiet gant virgulennoù",
	'sf_createtemplate_aggregation' => 'Skolveuriadur',
	'sf_createtemplate_aggregationlabel' => 'Titl evit al listenn :',
	'sf_createtemplate_outputformat' => 'Furmad moned er-maez :',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_infoboxformat' => 'Infobox dehou',
	'sf_createtemplate_addfield' => 'Ouzhpennañ ur vaezienn',
	'sf_createtemplate_deletefield' => 'Diverkañ',
	'sf_createtemplate_addtemplatebeforesave' => "Ret eo deoc'h ouzhpennañ ur patrom da nebeutañ d'ar furmskrid-mañ a-raok gallout e enrollañ.",
	'forms' => 'Furmskridoù',
	'sf_forms_docu' => 'Ar furmskridoù-mañ zo anezho er wiki.',
	'createform' => 'Krouiñ ur furmskrid',
	'sf_createform_nameinput' => 'Anv ar furmskrid',
	'sf_createform_template' => 'Patrom :',
	'sf_createform_templatelabelinput' => 'Tikedenn patrom (diret) :',
	'sf_createform_field' => 'Maezienn :',
	'sf_createform_fieldprop' => 'Ar vaezienn-mañ a dermen ar perzh $1, eus ar seurt $2.',
	'sf_createform_inputtype' => 'Doare moned :',
	'sf_createform_inputtypedefault' => '(dre ziouer)',
	'sf_createform_formlabel' => 'Label er furmskrid :',
	'sf_createform_hidden' => 'Kuzhet',
	'sf_createform_restricted' => "Strishaet (an implijerien sysop hepken a c'hall e gemmañ)",
	'sf_createform_mandatory' => 'Rekis',
	'sf_createform_removetemplate' => 'Lemel ar skouer',
	'sf_createform_addtemplate' => 'Ouzhpennañ ur patrom :',
	'sf_createform_beforetemplate' => 'A-raok ar patrom :',
	'sf_createform_atend' => 'En dibenn',
	'sf_createform_add' => 'Ouzhpennañ',
	'sf_createform_choosefield' => 'Dibab ur vaezienn da ouzhpennañ',
	'createcategory' => 'Sevel ur rummad',
	'sf_createcategory_name' => 'Anv ar rummad :',
	'sf_createcategory_defaultform' => 'Furmskrid dre ziouer :',
	'createclass' => "Krouiñ ur c'hlas",
	'sf_createclass_allowedvalues' => 'Talvoudennoù aotreet',
	'sf_createclass_listofvalues' => 'Roll talvoudennoù',
	'sf_createclass_missingvalues' => "N'eo ket bet leuniet an holl vaeziennoù ret.",
	'formstart' => 'Ouzhpennañ ur bajenn gant ur furmskrid',
	'sf_formstart_badform' => "Fazi : n'eus bet kavet pajenn furmskrid ebet en $1.",
	'sf_formstart_badtitle' => "Fazi : « $1 » n'eo ket un titl reizh evit ur bajenn.",
	'sf_formstart_createoredit' => 'Krouiñ pe kemmañ',
	'formedit' => 'Aozañ gant ur furmskrid',
	'sf_formedit_createtitle' => 'Krouiñ $1 : $2',
	'sf_formedit_altformsonly' => 'Diuzit unan eus ar furmskridoù-mañ evit ouzhpennañ ar bajenn-mañ :',
	'sf_formcreate' => 'Krouiñ gant ur furmskrid',
	'sf_viewform' => 'Gwelet ar furmskrid',
	'sf_editsource' => 'Kemmañ ar vammenn',
	'sf_formedit_edittitle' => 'Aozañ $1: $2',
	'sf_formedit_morethanoneform' => "'''Evezh : ''' Ouzhpenn ur furmskrid dre ziouer zo termenet evit ar bajenn-mañ.",
	'sf_formedit_formwarning' => 'Evezh : Ar bajenn-mañ <a href="$1">zo anezhi dija</a>, met ne implij ket ar furmskrid-mañ.',
	'sf_formedit_remove' => 'Tennañ',
	'sf_formedit_addanother' => 'Ouzhpennañ unan all',
	'sf_formedit_none' => 'Hini ebet',
	'runquery' => 'Seveniñ ar reked',
	'sf_runquery_badurl' => "Ret eo deoc'h diferañ un anv furmskrid en URL ;
Dleet e vefe d'an URL bezañ evel « Special:RunQuery/&lt;anv ar furmskrid&gt; ».",
	'sf_runquery_title' => 'Seveniñ ar reked : $1',
	'sf_runquery_additionalquery' => 'Reked ouzhpenn',
	'sf_formerrors_header' => 'Fazioù zo er furmskrid; gw. amañ dindan',
	'sf_blank_error' => "ne c'hall ket bezañ goullo",
	'sf_bad_url_error' => 'a rank kaout ur furmad URL reizh, o kregiñ gant "http"',
	'sf_bad_email_error' => "a rank kaout ur furmad chomlec'h postel reizh",
	'sf_bad_number_error' => 'a rank bezañ un niver reizh',
	'sf_bad_integer_error' => 'a rank bezañ un niver anterin reizh',
	'sf_bad_date_error' => 'a rank bezañ un deiziad reizh',
	'uploadwindow' => 'Kargañ ar prenestr',
	'sf_deletionlog' => 'Marilh an dilamadennoù',
	'sf_property_isproperty' => 'Ar perzh-mañ zo eus ar seurt $1.',
	'sf_property_linkstoform' => 'Liammañ a ra ouzh ar pajennoù a implij ar furmskrid $1.',
	'sf_property_allowedvals' => 'An talvoudenn{{PLURAL:$1||où}} aotreet evit ar perzh-se a zo :',
	'sf_template_docu' => 'Hemañ eo ar patrom « $1 ».
Dleet e vefe bezañ galvet er furmad-mañ :',
	'sf_template_docufooter' => 'Aozañ ar bajenn evit gwelet testenn ar patrom.',
	'sf_form_docu' => "Setu amañ ar furmskrid « $1 ».
Evit krouiñ ur bajenn gant ar furmskrid-mañ, ebarzhit anv ar bajenn amañ dindan ;
Ma'z eus ur bajenn en anv-se dija, e viot kaset d'ur furmskrid a dalvez d'hec'h aozañ.",
	'sf_form_freetextlabel' => 'Testenn dieub',
	'sf_category_hasdefaultform' => 'Ar rummad-mañ a implij ar furmskrid $1.',
	'sf_category_desc' => 'Ar rummad $1 eo hemañ.',
	'sf_blank_namespace' => 'Pennañ',
	'right-viewedittab' => 'Gwelet an ivinell "kemmañ" evit ar pajennoù kemmus dre ur furmskrid',
	'right-editrestrictedfields' => 'Aozañ maeziennoù strishaet ar furmskridoù',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'semanticforms-desc' => 'Obrasci za dodavanje i uređivanje semantičkih podataka',
	'specialpages-group-sf_group' => 'Semantički obrasci',
	'createproperty' => 'Napravi osobinu',
	'sf_createproperty_linktoform' => 'Ovo svojstvo će voditi na stranice koje koriste obrazac:',
	'sf_createproperty_propname' => 'Naziv svojstva:',
	'sf_createproperty_proptype' => 'Vrsta:',
	'templates' => 'Šabloni',
	'sf_templates_docu' => 'Slijedeći šabloni postoje u wikiju.',
	'sf_templates_definescat' => 'definira kategoriju:',
	'createtemplate' => 'Napravi šablon',
	'sf_createtemplate_namelabel' => 'Ime šablona:',
	'sf_createtemplate_categorylabel' => 'Kategorija određena putem šablona (neobavezno):',
	'sf_createtemplate_templatefields' => 'Polja šablona',
	'sf_createtemplate_fieldname' => 'Ime polja:',
	'sf_createtemplate_displaylabel' => 'Prikaži naljepnicu:',
	'sf_createtemplate_semanticproperty' => 'Semantičko svojstvo:',
	'sf_createtemplate_fieldislist' => 'Ovo polje može sadržavati spisak vrijednosti, razdvojene zarezima',
	'sf_createtemplate_aggregationlabel' => 'Naslov za spisak:',
	'sf_createtemplate_outputformat' => 'Izlazni format:',
	'sf_createtemplate_standardformat' => 'Standardni',
	'sf_createtemplate_infoboxformat' => 'Infokutija na desnoj strani',
	'sf_createtemplate_addfield' => 'Dodaj polje',
	'sf_createtemplate_deletefield' => 'Obriši',
	'sf_createtemplate_addtemplatebeforesave' => 'Morate dodati najmanje jedan šablon u ovaj obrazac prije nego što ga sačuvate.',
	'forms' => 'Obrasci',
	'sf_forms_docu' => 'Slijedeći obrasci postoje u wikiju.',
	'createform' => 'Napravi obrazac',
	'sf_createform_nameinput' => 'Naziv obrasca',
	'sf_createform_template' => 'Šablon:',
	'sf_createform_templatelabelinput' => 'Naslov šablona (opcija):',
	'sf_createform_field' => 'Polje:',
	'sf_createform_fieldprop' => 'Ovo polje definira svojstvo $1 tipa $2.',
	'sf_createform_inputtype' => 'Tip unosa:',
	'sf_createform_inputtypedefault' => '(standardno)',
	'sf_createform_formlabel' => 'Naslov obrasca:',
	'sf_createform_hidden' => 'sakrivena',
	'sf_createform_restricted' => 'Ograničeni (samo administratori ga mogu mijenjati)',
	'sf_createform_mandatory' => 'Obavezno',
	'sf_createform_removetemplate' => 'Ukloni šablon',
	'sf_createform_addtemplate' => 'Dodaj šablon:',
	'sf_createform_beforetemplate' => 'Prije šablona:',
	'sf_createform_atend' => 'Na kraju',
	'sf_createform_add' => 'Dodaj',
	'sf_createform_choosefield' => 'Izaberite polje za dodavanje',
	'createcategory' => 'Napravi kategoriju',
	'sf_createcategory_name' => 'Naziv kategorije:',
	'sf_createcategory_defaultform' => 'Pretpostavljeni obrazac:',
	'sf_createcategory_makesubcategory' => 'Učini ovo subkategorijom neke kategorije (neobavezno):',
	'createclass' => 'Napravi klasu',
	'sf_createclass_allowedvalues' => 'Dopuštene vrijednosti',
	'sf_createclass_listofvalues' => 'Spisak vrijednosti',
	'formstart' => 'Dodaj stranicu putem obrasca',
	'sf_formstart_badform' => 'Greška: nije pronađena stranica obrasca na $1',
	'sf_formstart_createoredit' => 'Dodaj ili uredi',
	'formedit' => 'Uredi sa obrascem',
	'sf_formedit_createtitle' => 'Dodaj $1: $2',
	'sf_formedit_altformsonly' => 'Molimo Vas da odaberete jedan od slijedećih obrazaca za dodavanje ovoj stranici:',
	'sf_formcreate' => 'Napravi sa obrascem',
	'sf_viewform' => 'Pogledaj obrazac',
	'sf_formedit_edittitle' => 'Uređivanje $1: $2',
	'sf_formedit_remove' => 'Ukloni',
	'sf_formedit_addanother' => 'Dodaj slijedeći',
	'sf_formedit_none' => 'ništa',
	'runquery' => 'Pokreni upit',
	'sf_runquery_title' => 'Pokreni upit: $1',
	'sf_runquery_additionalquery' => 'Dodatni upiti',
	'sf_blank_error' => 'ne može biti prazno',
	'sf_bad_email_error' => 'mora se navesti valjan format e-mail adrese',
	'sf_bad_number_error' => 'mora biti validan broj',
	'sf_bad_integer_error' => 'mora biti valjan cijeli broj',
	'sf_bad_date_error' => 'mora biti valjan datum',
	'uploadwindow' => 'Prozor za postavljanje',
	'sf_deletionlog' => 'Zapisnik brisanja',
	'sf_template_docu' => "Ovo je '$1' obrazac.
Trebao bi se nazvati u slijedećem formatu:",
	'sf_form_freetextlabel' => 'Slobodni tekst',
	'sf_category_hasdefaultform' => 'Ova kategorija koristi obrazac $1.',
	'sf_category_desc' => 'Ovo je $1 kategorija.',
	'sf_blank_namespace' => 'Glavno',
	'right-editrestrictedfields' => 'Uređivanje ograničenih polja obrazca',
);

/** Catalan (Català)
 * @author Dvdgmz
 * @author Paucabot
 * @author SMP
 * @author Solde
 * @author Toniher
 */
$messages['ca'] = array(
	'semanticforms-desc' => 'Formularis per afegir i editar continguts semàntics.',
	'specialpages-group-sf_group' => 'Semantic Forms',
	'createproperty' => 'Crea una propietat',
	'sf_createproperty_linktoform' => 'Aquesta propietat enllaçarà a pàgines que usin el formulari:',
	'sf_createproperty_allowedvalsinput' => 'Si voleu que aquest camp permeti només alguns valors específics, introduiu la llista dels valors permesos, separats per comes (si un valor conté una coma, substituiu-la per "\\,"):',
	'sf_createproperty_propname' => "Nom de l'atribut:",
	'sf_createproperty_proptype' => 'Tipus:',
	'templates' => 'Plantilles',
	'sf_templates_docu' => 'Les següents plantilles existeixen en el wiki.',
	'sf_templates_definescat' => 'Definir categoria:',
	'createtemplate' => 'Crea una plantilla',
	'sf_createtemplate_namelabel' => 'Nom de la plantilla:',
	'sf_createtemplate_categorylabel' => 'Categoria definida mitjançant la plantilla (opcional):',
	'sf_createtemplate_templatefields' => 'Camps de la plantilla',
	'sf_createtemplate_fieldsdesc' => "Per disposar dels camps en aquesta plantilla no és necessari posar els noms dels camps, simplement introdueix el número d'índex de cada camp (per exemple: 1, 2, 3, etc.) com a denominació de cadascun d'ells, en lloc del seu nom real.",
	'sf_createtemplate_fieldname' => 'Nom del camp:',
	'sf_createtemplate_displaylabel' => 'Mostrar etiqueta:',
	'sf_createtemplate_semanticproperty' => 'Propietat semàntica:',
	'sf_createtemplate_fieldislist' => 'Aquest camp pot suportar una llista de valors, separats per comes',
	'sf_createtemplate_aggregation' => 'Agregació',
	'sf_createtemplate_aggregationdesc' => 'Per crear una llista, a qualsevol pàgina que utilitzi aquesta plantilla, de tots els articles que tenen alguna propietat que apunta a aquesta pàgina, especifiqueu la propietat adequada a continuació:',
	'sf_createtemplate_aggregationlabel' => 'Títol del llistat:',
	'sf_createtemplate_outputformat' => 'Format de sortida:',
	'sf_createtemplate_standardformat' => 'Estàndard',
	'sf_createtemplate_infoboxformat' => 'Infocaixa a la dreta',
	'sf_createtemplate_addfield' => 'Afegeix un camp',
	'sf_createtemplate_deletefield' => 'Elimina',
	'sf_createtemplate_addtemplatebeforesave' => "Per poder guardar-lo has d'afegir com a mínim una plantilla a aquest formulari.",
	'forms' => 'Formularis',
	'sf_forms_docu' => 'Els formularis següents ja existeixen al wiki.',
	'createform' => 'Crea un formulari',
	'sf_createform_nameinput' => 'Nom del formulari',
	'sf_createform_nameinputdesc' => '(la convenció és anomenar el formulari com la plantilla principal que omple):',
	'sf_createform_template' => 'Plantilla:',
	'sf_createform_templatelabelinput' => 'Etiqueta de la plantilla (opcional):',
	'sf_createform_allowmultiple' => "Permet múltiples (o cap) instàncies d'aquesta plantilla en la pàgina a crear",
	'sf_createform_field' => 'Camp:',
	'sf_createform_fieldprop' => 'Aquest camp defineix la propietat $1, de tipus $2',
	'sf_createform_fieldproplist' => "Aquest camp defineix una llista d'elements que tenen la propietat $1, de tipus $2",
	'sf_createform_fieldpropunknowntype' => "Aquest camp defineix la propietat $1, de la qual no s'ha especificat la tipologia",
	'sf_createform_inputtype' => "Tipus d'entrada:",
	'sf_createform_inputtypedefault' => '(per defecte)',
	'sf_createform_formlabel' => 'Etiqueta de formulari:',
	'sf_createform_hidden' => 'Amagat',
	'sf_createform_restricted' => 'Restringit (només els usuaris sysop, administradors, poden modificar-lo)',
	'sf_createform_mandatory' => 'Obligatori',
	'sf_createform_removetemplate' => 'Esborrar plantilla',
	'sf_createform_addtemplate' => 'Afegeix una plantilla:',
	'sf_createform_beforetemplate' => 'Plantilla anterior:',
	'sf_createform_atend' => 'Al final',
	'sf_createform_add' => 'Afegeix',
	'sf_createform_choosefield' => 'Escull un camp per afegir',
	'createcategory' => 'Crea una categoria',
	'sf_createcategory_name' => 'Nom de la categoria:',
	'sf_createcategory_defaultform' => 'Formulari per defecte:',
	'sf_createcategory_makesubcategory' => "Fes que aquesta sigui una sub-categoria d'una altra categoria (opcional):",
	'createclass' => 'Crea una classe',
	'sf_createclass_allowedvalues' => 'Valors permesos',
	'sf_createclass_listofvalues' => 'Llista de valors',
	'sf_createclass_missingvalues' => "No s'han omplert tots els camps necessaris.",
	'sf_createclass_success' => 'Es crearan propietats, plantilla, formulari i categoria.',
	'formstart' => 'Afegeix pàgina via formulari',
	'sf_formstart_badform' => "Error: no s'ha trobat una pàgina de formulari a $1",
	'sf_formstart_docu' => "Introdueix el nom de la pàgina aquí, per ser editada amb el formulari '$1'.
Si aquesta pàgina ja existeix, se t'obrirà el formulari per editar-la.
Si no, se t'obrirà el formulari per afegir una pàgina nova.",
	'sf_formstart_noform_docu' => "Introdueix aquí el nom de la pàgina i selecciona un formulari per editar-la.
Si aquesta pàgina ja existeix, se t'obrirà el formulari per editar-la.
Si no, se t'obrirà el formulari per afegir una pàgina nova.",
	'sf_formstart_createoredit' => 'Crea o edita',
	'formedit' => 'Edita amb formulari',
	'sf_formedit_createtitle' => 'Crea $1: $2',
	'sf_formedit_badurl' => "Aquesta és la pàgina per afegir dades. Has d'especificar tant el nom del formulari com la pàgina de destí a la URL; ha de ser quelcom similar a 'Special:FormEdit?form=&lt;nom formulari&gt;&target=&lt;pàgina destí&gt;', o bé 'Special:FormEdit/&lt;nom formulari&gt;/&lt;pàgina destí&gt;'.",
	'sf_formedit_altforms' => 'Alternativament pots afegir aquesta pàgina amb un dels formularis següents:',
	'sf_formedit_altformsonly' => 'Seleccioneu un formulari entre els següents per afegir aquesta pàgina:',
	'sf_formcreate' => 'Crea amb formulari',
	'sf_viewform' => 'Veure el formulari',
	'sf_editsource' => 'Edita el codi font',
	'sf_formedit_edittitle' => 'Editar $1: $2',
	'sf_formedit_morethanoneform' => "'''Avís:''' s'ha definit més d'un formulari per defecte en aquesta pàgina.",
	'sf_formedit_formwarning' => 'Atenció: Aquesta pàgina <a href="$1">ja existeix</a>, però no fa servir aquest formulari.',
	'sf_formedit_remove' => 'Elimina',
	'sf_formedit_addanother' => 'Afegeix-ne un altre',
	'sf_formedit_none' => 'Cap',
	'runquery' => 'Executa la consulta',
	'sf_runquery_title' => 'Executa consulta: $1',
	'sf_runquery_additionalquery' => 'Consulta addicional',
	'sf_formerrors_header' => 'Hi ha hagut errors en les teves entrades al formulari; veure a continuació',
	'sf_blank_error' => 'no es pot deixar en blanc',
	'sf_bad_url_error' => "ha de tenir un format de URL correcte, començant per 'http'",
	'sf_bad_email_error' => "ha de tenir un format vàlid d'adreça de correu electrònic",
	'sf_bad_number_error' => 'ha de ser un nombre vàlid',
	'sf_bad_integer_error' => 'ha de ser un nombre enter',
	'sf_bad_date_error' => 'ha de ser una data vàlida',
	'uploadwindow' => 'Finestra de càrrega',
	'sf_deletionlog' => "Registre d'eliminació",
	'sf_property_isproperty' => 'Aquesta és una propietat del tipus $1.',
	'sf_property_linkstoform' => 'Enllaça a pàgines que usen el formulari $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|El valor permès per a aquesta propietat és|Els valors permesos per a aquestes propietats són}}:',
	'sf_template_docu' => "Aquesta és la plantilla '$1'.
Que ha de ser cridada en el format següent:",
	'sf_template_docufooter' => 'Edita la pàgina per veure el text de la plantilla.',
	'sf_form_docu' => "Aquest és el formulari '$1'.
Per crear una pàgina amb aquest formulari, entreu el nom de la pàgina a continuació;
si la pàgina amb aquest nom ja existeix, s'obrirà un formulari per editar-la.",
	'sf_form_freetextlabel' => 'Text lliure',
	'sf_category_hasdefaultform' => 'Aquesta categoria fa servir el formulari $1.',
	'sf_category_desc' => 'Aquesta és la categoria $1.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Visualitza la pestanya «Edita» a les pàgines que es poden editar amb un formulari',
	'right-editrestrictedfields' => 'Edita els camps restringits del formulari',
);

/** Czech (Česky)
 * @author Matěj Grabovský
 */
$messages['cs'] = array(
	'createproperty' => 'Vytvořit vlastnost',
	'sf_createproperty_propname' => 'Název:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Šablony',
	'sf_createtemplate_fieldname' => 'Název pole:',
	'sf_createtemplate_displaylabel' => 'Zobrazované označení:',
	'sf_createtemplate_semanticproperty' => 'Sémantická vlastnost:',
);

/** Church Slavic (Словѣ́ньскъ / ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ)
 * @author ОйЛ
 */
$messages['cu'] = array(
	'sf_createtemplate_deletefield' => 'поничьжє́ниѥ',
);

/** Danish (Dansk)
 * @author Jon Harald Søby
 */
$messages['da'] = array(
	'sf_createproperty_propname' => 'Navn:',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_deletefield' => 'Slet',
	'sf_createform_template' => 'Skabelon:',
	'sf_createform_inputtypedefault' => '(standard)',
	'sf_createcategory_name' => 'Navn:',
	'sf_formedit_none' => 'Ingen',
);

/** German (Deutsch)
 * @author Als-Holder
 * @author Cipher
 * @author DaSch
 * @author Dominik Rodler
 * @author Goetz
 * @author Kghbln
 * @author Melancholie
 * @author Pill
 * @author Purodha
 * @author The Evil IP address
 * @author Umherirrender
 */
$messages['de'] = array(
	'semanticforms-desc' => 'Stellt Formulare zum Hinzufügen und Bearbeiten semantischer Daten bereit',
	'specialpages-group-sf_group' => 'Semantische Formulare',
	'createproperty' => 'Ein Attribut erstellen',
	'sf_createproperty_linktoform' => 'Dieses Attribut verweist auf Seiten, welche nachfolgendes Formular nutzen:',
	'sf_createproperty_allowedvalsinput' => 'Wenn du für dieses Attribut nur bestimmte Werte ermöglichen willst, gib diese bitte als kommagetrennte Liste ein (wenn ein Wert ein Komma enthält, ersetze dieses durch „\\,“ ohne Anführungen):',
	'sf_createproperty_propname' => 'Attributname:',
	'sf_createproperty_proptype' => 'Datentyp:',
	'templates' => 'Vorlagen',
	'sf_templates_docu' => 'Die folgenden Vorlagen existieren in {{SITENAME}}.',
	'sf_templates_definescat' => 'definiert Kategorie:',
	'createtemplate' => 'Eine Vorlage erstellen',
	'sf_createtemplate_namelabel' => 'Vorlagenname:',
	'sf_createtemplate_categorylabel' => 'Durch Vorlage definierte Kategorie (optional):',
	'sf_createtemplate_templatefields' => 'Vorlagenfelder',
	'sf_createtemplate_fieldsdesc' => 'Die Felder dieser Vorlage benötigen nicht mehr zwingend einen Namen (Feldnamen). Zur Unterscheidung ist es ausreichend die Felder aufsteigend mit Zahlen zu indexieren (bspw. 1, 2, 3, usw.).',
	'sf_createtemplate_fieldname' => 'Feldname:',
	'sf_createtemplate_displaylabel' => 'Anzuzeigender Feldname:',
	'sf_createtemplate_semanticproperty' => 'Semantisches Attribut:',
	'sf_createtemplate_fieldislist' => 'Dieses Feld kann eine Liste von Werten enthalten, die durch Kommata getrennt werden.',
	'sf_createtemplate_aggregation' => 'Zusammenfassung',
	'sf_createtemplate_aggregationdesc' => 'Um alle Seiten auflisten zu können, die über ein bestimmtes Attribut verfügen, das auf eine Seite mit dieser Vorlage verweist, muss das entsprechende Attribut hier angegeben werden:',
	'sf_createtemplate_aggregationlabel' => 'Titel für die Liste:',
	'sf_createtemplate_outputformat' => 'Ausgabeformat:',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_infoboxformat' => 'Rechts platzierte Infobox',
	'sf_createtemplate_addfield' => 'Weiteres Feld hinzufügen',
	'sf_createtemplate_deletefield' => 'Löschen',
	'sf_createtemplate_addtemplatebeforesave' => 'Hinweis: Du musst mindestens eine Vorlage zu diesem Formular hinzufügen, bevor du es speichern kannst.',
	'forms' => 'Formulare',
	'sf_forms_docu' => 'Die folgenden Formulare existieren in {{SITENAME}}:',
	'createform' => 'Erstelle ein Formular',
	'sf_createform_nameinput' => 'Formularname',
	'sf_createform_nameinputdesc' => '(Konvertion ist, das Formular nach der Hauptvorlage zu benennen):',
	'sf_createform_template' => 'Vorlage:',
	'sf_createform_templatelabelinput' => 'Vorlagebezeichnung (optional):',
	'sf_createform_allowmultiple' => 'Erlaube mehrere (oder keine) Instanzen dieser Vorlage auf der erstellten Seite',
	'sf_createform_field' => 'Feld:',
	'sf_createform_fieldprop' => 'Dieses Feld definiert die Eigenschaft $1 vom Typ $2.',
	'sf_createform_fieldproplist' => 'Dieses Feld definiert eine Liste an Elementen, die die Eigenschaft $1 vom Typ $2 besitzen.',
	'sf_createform_fieldpropunknowntype' => 'Dieses Feld definiert die Eigenschaft $1 mit einem unspezifizierten Typ.',
	'sf_createform_inputtype' => 'Gib den Typ ein:',
	'sf_createform_inputtypedefault' => '(Standardwert)',
	'sf_createform_formlabel' => 'Formularbezeichnung:',
	'sf_createform_hidden' => 'Versteckt',
	'sf_createform_restricted' => 'Gesperrt (nur Administratoren können Änderungen vornehmen)',
	'sf_createform_mandatory' => 'Pflichtfeld',
	'sf_createform_removetemplate' => 'Entferne Vorlage',
	'sf_createform_addtemplate' => 'Füge eine Vorlage hinzu:',
	'sf_createform_beforetemplate' => 'vor Vorlage',
	'sf_createform_atend' => 'am Ende',
	'sf_createform_add' => 'Hinzufügen',
	'sf_createform_choosefield' => 'Wähle ein Feld aus, das du hinzufügen willst.',
	'createcategory' => 'Erstelle eine Kategorie',
	'sf_createcategory_name' => 'Name der Kategorie:',
	'sf_createcategory_defaultform' => 'Standardformular:',
	'sf_createcategory_makesubcategory' => 'Mache diese Kategorie zu einer Unterkategorie einer anderen Kategorie (optional):',
	'createclass' => 'Klasse erstellen',
	'sf_createclass_docu' => 'Gib hier alle Daten ein, um die Attribute, die Vorlage, das Formular und die Kategorie für eine einzelne Klasse zu erstellen.
Für mehrere Optionen nutze bitte die Seite $1.',
	'sf_createclass_allowedvalues' => 'Erlaubte Werte',
	'sf_createclass_listofvalues' => 'Werteliste',
	'sf_createclass_leavefieldblank' => 'Wenn der Feldname dem Attributnamen entspricht, kann es leer gelassen werden.',
	'sf_createclass_missingvalues' => 'Es wurden nicht alle benötigten Felder ausgefüllt.',
	'sf_createclass_success' => 'Attribute, die Vorlage, das Formular und die Kategorie werden erstellt.',
	'formstart' => 'Füge Seite hinzu',
	'sf_formstart_badform' => 'Fehler: es wurde keine Seite gefunden bei $1',
	'sf_formstart_badtitle' => 'Fehler: „$1“ ist kein gültiger Seitentitel.',
	'sf_formstart_docu' => 'Gib in dieses Textfeld den Namen der Seite ein, die mit Formular „$1“ bearbeitet werden soll. Wenn bereits eine Seite mit diesem Namen existiert, wirst du zu einem Formular weitergeleitet, mit dem du diese Seite bearbeiten kannst. Andernfalls wirst du zu einem Formular weitergeleitet, mit dem du diese Seite erstellen kannst.',
	'sf_formstart_noform_docu' => 'Gib in dieses Textfeld den Namen der Seite ein und wähle das Formular, mit dem die Seite bearbeitet werden soll. Wenn bereits eine Seite mit diesem Namen existiert, wirst du zu einem Formular weitergeleitet, mit dem du diese Seite bearbeiten kannst. Andernfalls wirst du zu einem Formular weitergeleitet, mit dem du diese Seite erstellen kannst.',
	'sf_formstart_createoredit' => 'Erstellen oder Bearbeiten',
	'formedit' => 'mit Formular bearbeiten',
	'sf_formedit_createtitle' => '$1 erstellen: $2',
	'sf_formedit_badurl' => 'Dies ist die Seite zum Bearbeiten mit einem Formular. Du musst den Namen eines Formulars und die zu bearbeitende Zielseite in der URL angeben. Es sollte aussehen wie „Special:FormEdit?form=&lt;Formularname&gt;&target=&lt;Zielseite&gt;“ oder „Special:FormEdit/&lt;Formularname&gt;/&lt;Zielseite&gt;“.',
	'sf_formedit_altforms' => 'Alternativ kannst Du diese Seite mit einem der folgenden Formulare erstellen:',
	'sf_formedit_altformsonly' => 'Bitte wähle eines der folgenden Formulare aus, um diese Seite zu erstellen:',
	'sf_formcreate' => 'Mit Formular erstellt',
	'sf_viewform' => 'Formular anzeigen',
	'sf_editsource' => 'Quelltext bearbeiten',
	'sf_formedit_edittitle' => 'Bearbeite $1: $2',
	'sf_formedit_morethanoneform' => 'Warnung: Mehr als ein Standardformular ist für diese Seite definiert.',
	'sf_formedit_formwarning' => 'Warnung: Diese Seite <a href="$1">existiert bereits</a>, aber sie benutzt nicht dieses Formular.',
	'sf_formedit_remove' => 'Entfernen',
	'sf_formedit_addanother' => 'Weitere hinzufügen',
	'sf_formedit_none' => 'Keine',
	'runquery' => 'Abfrage ausführen',
	'sf_runquery_badurl' => 'Es wurde kein Formular in der URL angegeben;
die URL sollte wie folgt aussehen: „Special:RunQuery/&lt;form name&gt;”',
	'sf_runquery_title' => 'Ausgeführte Abfrage: $1',
	'sf_runquery_additionalquery' => 'Ergänzende Abfrage',
	'sf_formerrors_header' => 'Deine Eingabe ist fehlerhaft; weiteres siehe unten',
	'sf_blank_error' => 'Darf nicht leer sein!',
	'sf_bad_url_error' => 'muss ein gültiges URL-Format haben, beginnend mit „http://“',
	'sf_bad_email_error' => 'muss ein gültiges E-Mail-Adressformat haben',
	'sf_bad_number_error' => 'muss eine gültige Zahl sein',
	'sf_bad_integer_error' => 'muss eine gültige Ganzzahl sein',
	'sf_bad_date_error' => 'muss ein gültiges Datum sein',
	'uploadwindow' => 'Upload-Fenster',
	'sf_deletionlog' => 'Lösch-Logbuch',
	'sf_property_isproperty' => 'Dies ist eine Eigenschaft des Typs $1.',
	'sf_property_linkstoform' => 'Es verlinkt zu Seiten, welche das Formular „$1“ nutzen.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Der mögliche Wert für diese Eigenschaft ist|Die möglichen Werte für diese Eigenschaft sind}}:',
	'sf_template_docu' => 'Dies ist die Vorlage für „$1“. Sie sollte im folgenden Format aufgerufen werden:',
	'sf_template_docufooter' => 'Bearbeite diese Seite, um den Vorlagentext zu sehen.',
	'sf_form_docu' => 'Dies ist das „$1“-Formular.
Um eine Seite mit diesem Formular zu erstellen, gebe den Seitennamen unten ein;
wenn eine Seite mit diesem Namen bereits existiert, wirst du zu einem Formular zum Bearbeiten der Seite weitergeleitet.',
	'sf_form_freetextlabel' => 'Freitext',
	'sf_category_hasdefaultform' => 'Diese Kategorie nutzt das Formular $1.',
	'sf_category_desc' => 'Dies ist die Kategorie $1.',
	'sf_blank_namespace' => 'Seite',
	'right-viewedittab' => '„Bearbeiten“-Tab für Seiten zeigen, die per Formular bearbeitet werden können',
	'right-editrestrictedfields' => 'Eingeschränkte Formularfelder bearbeiten',
);

/** German (formal address) (Deutsch (Sie-Form))
 * @author Dst
 * @author Imre
 * @author Kghbln
 * @author The Evil IP address
 * @author Umherirrender
 */
$messages['de-formal'] = array(
	'sf_createproperty_allowedvalsinput' => 'Wenn Sie für dieses Attribut nur bestimmte Werte ermöglichen wollen, geben Sie diese bitte als kommagetrennte Liste ein (wenn ein Wert ein Komma enthält, ersetzen Sie das Komma mit „\\,“):',
	'sf_createtemplate_fieldsdesc' => 'Wenn ein Feld einer Vorlage keinen Feldnamen benötigen soll, geben Sie einfach anstatt eines tatsächlichen Namens die Indexnummer des Feldes als Name ein (z.B. 1, 2, 3 usw.).',
	'sf_createtemplate_aggregationdesc' => 'Um auf allen Seiten, die diese Vorlage benutzen, alle Seiten aufzulisten, die ein bestimmtes Attribut besitzen und auf diese Seiten verlinkt sind, geben Sie das gewünschte Attribut hier an:',
	'sf_createtemplate_addtemplatebeforesave' => 'Hinweis: Sie müssen mindestens eine Vorlage zu diesem Formular hinzufügen, bevor Sie es speichern können.',
	'sf_createform_allowmultiple' => 'Erlauben Sie mehrere (oder keine) Instanzen dieser Vorlage auf der erstellten Seite',
	'sf_createform_choosefield' => 'Wählen Sie ein Feld aus, das Sie hinzufügen wollen.',
	'sf_createcategory_makesubcategory' => 'Machen Sie diese Kategorie zu einer Unterkategorie einer anderen Kategorie (optional):',
	'sf_createclass_docu' => 'Geben Sie hier alle Daten ein, um die Attribute, die Vorlage, das Formular und die Kategorie für eine einzelne Klasse zu erstellen.
Für mehrere Optionen nutzen Sie bitte die Seite $1.',
	'sf_formstart_docu' => 'Geben Sie in dieses Textfeld den Namen der Seite ein, die mit Formular „$1“ bearbeitet werden soll. Wenn bereits eine Seite mit diesem Namen existiert, werden Sie zu einem Formular weitergeleitet, mit dem Sie diese Seite bearbeiten können. Andernfalls werden Sie zu einem Formular weitergeleitet, mit dem Sie diese Seite erstellen können.',
	'sf_formstart_noform_docu' => 'Geben Sie in dieses Textfeld den Namen der Seite ein und wählen Sie das Formular, mit dem die Seite bearbeitet werden soll. Wenn bereits eine Seite mit diesem Namen existiert, werden Sie zu einem Formular weitergeleitet, mit dem Sie diese Seite bearbeiten können. Andernfalls werden Sie zu einem Formular weitergeleitet, mit dem Sie diese Seite erstellen können.',
	'sf_formedit_badurl' => 'Dies ist die Seite zum Bearbeiten mit einem Formular. Sie müssen den Namen eines Formulars und die zu bearbeitende Zielseite in der URL angeben. Es sollte aussehen wie „Special:FormEdit?form=&lt;Formularname&gt;&target=&lt;Zielseite&gt;“ oder „Special:FormEdit/&lt;Formularname&gt;/&lt;Zielseite&gt;“.',
	'sf_formedit_altforms' => 'Alternativ können Sie diese Seite mit einem der folgenden Formulare erstellen:',
	'sf_formedit_altformsonly' => 'Bitte wählen Sie eines der folgenden Formulare aus, um diese Seite zu erstellen:',
	'sf_formerrors_header' => 'Ihre Eingabe ist fehlerhaft; weiteres siehe unten',
	'sf_template_docufooter' => 'Bearbeiten Sie diese Seite, um den Vorlagentext zu sehen.',
	'sf_form_docu' => 'Dies ist das „$1“-Formular.
Um eine Seite mit diesem Formular zu erstellen, geben Sie den Seitennamen unten ein;
wenn eine Seite mit diesem Namen bereits existiert, werden Sie zu einem Formular zum Bearbeiten der Seite weitergeleitet.',
);

/** Zazaki (Zazaki)
 * @author Belekvor
 * @author Mirzali
 */
$messages['diq'] = array(
	'sf_formedit_none' => 'Çıniyo',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'semanticforms-desc' => 'Formulary za pśidawanje a wobźěłowanje semantiskich datow',
	'specialpages-group-sf_group' => 'Semantiske formulary',
	'createproperty' => 'Kakosć napóraś',
	'sf_createproperty_linktoform' => 'Toś ta kakosć buźo k bokam wótkazowaś, kótarež wužywaju formular:',
	'sf_createproperty_allowedvalsinput' => 'Jolic coš za toś ta kakosć jano wěste gódnoty dowóliś, zapódaj lisćinu dowólonych gódnotow, wótźělonych pśez komy (jolic gódnota wopśimujo komu, wuměń ju pśez "\\,"):',
	'sf_createproperty_propname' => 'Mě kakosći:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Pśedłogi',
	'sf_templates_docu' => 'Slědujuce pśedłogi eksistěruju we wikiju.',
	'sf_templates_definescat' => 'definěrujo kategoriju:',
	'createtemplate' => 'Pśedłogu napóraś',
	'sf_createtemplate_namelabel' => 'Mě pśedłogi:',
	'sf_createtemplate_categorylabel' => 'Pśez kategoriju definěrowana pśedłoga (opcionalny):',
	'sf_createtemplate_templatefields' => 'Póla pśedłogi',
	'sf_createtemplate_fieldsdesc' => 'Jolic póla w toś tej pśedłoze wěcej njamaju pólowe mjenja měś, zapódaj jadnorje indeks kuždego póla (na pś. 1, 2, 3 atd.) ako mě město aktualnego mjenja.',
	'sf_createtemplate_fieldname' => 'Mě póla:',
	'sf_createtemplate_displaylabel' => 'Etiket za zwobraznjenje:',
	'sf_createtemplate_semanticproperty' => 'Semantiska kakosć:',
	'sf_createtemplate_fieldislist' => 'Toś to pólo móžo lisćinu gódnotow wopśimjeś, wótźělonych pśez komy',
	'sf_createtemplate_aggregation' => 'Zrědowanje',
	'sf_createtemplate_aggregationdesc' => 'Aby nalicył na boku, kótaryž wužywa toś tu pśedłogu, wšykne boki, kótarež maju wěstu kakosć a kótaraž pokazujo na toś ten bok, pódaj dołojce góžecu se kakosć:',
	'sf_createtemplate_aggregationlabel' => 'Titel za lisćinu:',
	'sf_createtemplate_outputformat' => 'Wudawański format:',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_infoboxformat' => 'Infokašćik napšawo',
	'sf_createtemplate_addfield' => 'Pólo pśidaś',
	'sf_createtemplate_deletefield' => 'Wulašowaś',
	'sf_createtemplate_addtemplatebeforesave' => 'Musyš nanejmjenjej jadnu pśedłogu toś tomu formularoju pśidaś, nježli až móžoš jen składowaś.',
	'forms' => 'Formulary',
	'sf_forms_docu' => 'Slědujuce formulary eksistěeruju we wikiju.',
	'createform' => 'Formular napóraś',
	'sf_createform_nameinput' => 'Mě formulara',
	'sf_createform_nameinputdesc' => '(pó konwenciji formular groni se pó głownej pśedłoze, kótaruž wopśimujo):',
	'sf_createform_template' => 'Pśedłoga:',
	'sf_createform_templatelabelinput' => 'Pomjenjenje pśedłogi (opcionalny):',
	'sf_createform_allowmultiple' => 'Někotare (abo žedne) instance toś teje pśedłogi w napóranem boku dowóliś',
	'sf_createform_field' => 'Pólo:',
	'sf_createform_fieldprop' => 'Toś to pólo definěrujo kakosć $1 typa $2.',
	'sf_createform_fieldproplist' => 'Toś to pólo definěrujo lisćinu elementow, kótarež maju kakosć $1 typa $2.',
	'sf_createform_fieldpropunknowntype' => 'Toś to póla definěrujo kakosć $1 njepódanego typa.',
	'sf_createform_inputtype' => 'Typ zapódaś:',
	'sf_createform_inputtypedefault' => '(standard)',
	'sf_createform_formlabel' => 'Pomjenjenje formulara:',
	'sf_createform_hidden' => 'Schowany',
	'sf_createform_restricted' => 'Wobgranicowany (jano administratory mógu jen změniś)',
	'sf_createform_mandatory' => 'Obligatoriske pólo',
	'sf_createform_removetemplate' => 'Pśedłogu wótpóraś',
	'sf_createform_addtemplate' => 'Pśedłogu pśidaś:',
	'sf_createform_beforetemplate' => 'Pśed pśedłogu:',
	'sf_createform_atend' => 'Na kóńcu',
	'sf_createform_add' => 'Pśidaś',
	'sf_createform_choosefield' => 'Wubjeŕ pólo, kótarež coš pśidaś',
	'createcategory' => 'Kategoriju napóraś',
	'sf_createcategory_name' => 'Mě kategorije:',
	'sf_createcategory_defaultform' => 'Standardny formular:',
	'sf_createcategory_makesubcategory' => 'To k pódkategoriji drugeje kategorije cyniś (opcionalny):',
	'createclass' => 'Klasu napóraś',
	'sf_createclass_docu' => 'Zapódaj how wše daty, aby napórał kakosći, pśedłogu, formular a kategoriju za jadnotliwu klasu.
Za dalšne opcije wužyj boki $1 město togo.',
	'sf_createclass_allowedvalues' => 'Dowólone gódnoty',
	'sf_createclass_listofvalues' => 'Lisćina gódnotow',
	'sf_createclass_leavefieldblank' => 'Jolic mě póla jo samske kaž mě kakosći, móžoš jo prozne wóstajiś.',
	'sf_createclass_missingvalues' => 'Nic wše póla su se wupołnili.',
	'sf_createclass_success' => 'Kakosći, pśedłoga, formular a kategorija se napóraju',
	'formstart' => 'Bok z formularom pśidaś',
	'sf_formstart_badform' => 'Zmólka: žeden formular njejo se namakał pla $1',
	'sf_formstart_badtitle' => 'Zmólka: "$1" jo njepłaśiwy titel za bok.',
	'sf_formstart_docu' => "Zapódaj how mě boka, kótaryž ma se z formularom '$1' wobźěłaś.
Jolic toś ten bok južo eksistěrujo, buźoš se k formularoju za wobźěłowanje togo boka dalej pósrědnjaś.
Howac buźoš se k formularoju za pśidawanje boka dalej pósrědnjaś.",
	'sf_formstart_noform_docu' => 'Zapódaj how mě boka a wubjeŕ formular, z kótarymž coš jen wobźěłaś.
Jolic toś ten bok južo eksistěrujo, buźoš se k formularoju za wobźěłowanje togo boka dalej pósrědnjaś.
Howac buźoš se k formularoju za pśidawanje boka dalej pósrědnjaś.',
	'sf_formstart_createoredit' => 'Napóraś abo wobźěłaś',
	'formedit' => 'Z formularom wobźěłaś',
	'sf_formedit_createtitle' => '$1 napóraś: $2',
	'sf_formedit_badurl' => "To jo bok za wobźěłowanje z formularom. Musyš ako mě formulara tak teke celowy bok w URL pódaś; URL by měł kaž 'Special:FormEdit?form=&lt;mě formulara&gt;&target=&lt;celowy bok&gt;' abo  'Special:FormEdit/&lt;mě formulara&gt;/&lt;celowy bok&gt;' wuglědaś.",
	'sf_formedit_altforms' => 'Móžoš město togo toś ten bok z jadnym ze slědujucych formularow pśidaś:',
	'sf_formedit_altformsonly' => 'Pšosym wubjeŕ jaden ze slědujucych formularow, aby pśidał toś ten bok:',
	'sf_formcreate' => 'Z formularom napóraś',
	'sf_viewform' => 'Formular se woglědaś',
	'sf_editsource' => 'Žrědło wobźěłaś',
	'sf_formedit_edittitle' => '$1 wobźěłaś: $2',
	'sf_formedit_morethanoneform' => 'Warnowanje: Za toś ten bok jo se definěrował wěcej ako jaden standardny formular.',
	'sf_formedit_formwarning' => 'Warnowanje: Toś ten bok <a href="$1">južo eksistěrujo</a>, ale njewužywa toś ten formular.',
	'sf_formedit_remove' => 'Wótpóraś',
	'sf_formedit_addanother' => 'Drugi pśidaś',
	'sf_formedit_none' => 'Žeden',
	'runquery' => 'Wótpšašanje startowaś',
	'sf_runquery_badurl' => "Musyš formularne mě w URL pódaś;
URL měł wuglědaś ako 'Special:RunQuery/&lt;formularne mě&gt;'.",
	'sf_runquery_title' => 'Start wótpšašanja: $1',
	'sf_runquery_additionalquery' => 'Pśidatne wótpšašanje',
	'sf_formerrors_header' => 'Su zmólki w zapódaśu twójogo formulara; glědaj dołojce',
	'sf_blank_error' => 'njesmějo prozny byś',
	'sf_bad_url_error' => 'musy korektny format URL měś a se z "http://" zachopiś',
	'sf_bad_email_error' => 'musy płaśiwy format e-mailoweje adresy měś',
	'sf_bad_number_error' => 'musy płaśiwa licba byś',
	'sf_bad_integer_error' => 'musy płaśiw ceła licba byś',
	'sf_bad_date_error' => 'musy płaśiwy datum byś',
	'uploadwindow' => 'Wokno nagraśow',
	'sf_deletionlog' => 'protokol wulašowanjow',
	'sf_property_isproperty' => 'To jo kakosć typa $1.',
	'sf_property_linkstoform' => 'Wótkazujo k bokam, kótarež wužywaju formular $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Dowólona gódnota za toś tu kakosć jo|Dowólonej gódnośe za toś tu kakosć stej|Dowólone gódnoty za toś tu kakosć su|Dowólone gódnoty za toś tu kakosć su}}:',
	'sf_template_docu' => "To jo pśedłof '$1'.
By se měł w slědujucem formaśe wuwołaś:",
	'sf_template_docufooter' => 'Wobźěłaj bok, aby wiźeł tekst pśedłogi.',
	'sf_form_docu' => 'To jo formular "$1".
Aby napórał bok z toś tym formularom, zapódaj dołojce mě boka;
jolic bok z tym mjenim južo eksistěrujo, buźoš se k formularoju dalej pósrědnjaś, aby ten bok wobźěłał.',
	'sf_form_freetextlabel' => 'Lichy tekst',
	'sf_category_hasdefaultform' => 'Toś ta kategorija wužywa formular $1.',
	'sf_category_desc' => 'To jo kategorija $1.',
	'sf_blank_namespace' => 'Głowny',
	'right-viewedittab' => 'Rejtark "Wobźěłaś" za boki, kótarež su wobźěłujobne pśez formular, se woglědaś',
	'right-editrestrictedfields' => 'Wobgranicowane formularne póla wobźěłaś',
);

/** Greek (Ελληνικά)
 * @author Consta
 * @author Crazymadlover
 * @author Omnipaedista
 * @author ZaDiak
 * @author Απεργός
 */
$messages['el'] = array(
	'semanticforms-desc' => 'Φόρμες για την προσθήκη και επεξεργασία σημασιολογικών δεδομένων',
	'specialpages-group-sf_group' => 'Σημασιολογικές Φόρμες',
	'createproperty' => 'Δημιουργήστε μια ιδιότητα',
	'sf_createproperty_propname' => 'Όνομα ιδιότητας:',
	'sf_createproperty_proptype' => 'Τύπος:',
	'templates' => 'Πρότυπο:',
	'sf_templates_docu' => 'Τα παρακάτω πρότυπα υπάρχουν σε αυτό το βίκι.',
	'sf_templates_definescat' => 'προσδιορίζει την κατηγορία:',
	'createtemplate' => 'Δημιουργήστε ένα πρότυπο',
	'sf_createtemplate_namelabel' => 'Όνομα προτύπου:',
	'sf_createtemplate_templatefields' => 'Πρότυπο περιοχών',
	'sf_createtemplate_fieldname' => 'Όνομα περιοχής:',
	'sf_createtemplate_displaylabel' => 'Ετικέτα Ανάλυσης:',
	'sf_createtemplate_semanticproperty' => 'Σημασιολογική ιδιότητα:',
	'sf_createtemplate_aggregation' => 'Συνάθροιση',
	'sf_createtemplate_aggregationlabel' => 'Τίτλος για τη λίστα:',
	'sf_createtemplate_outputformat' => 'Φορμά εξόδου:',
	'sf_createtemplate_standardformat' => 'Συνήθης',
	'sf_createtemplate_addfield' => 'Προσθήκη περιοχής',
	'sf_createtemplate_deletefield' => 'Διαγραφή',
	'forms' => 'Μορφές',
	'sf_forms_docu' => 'Οι παρακάτω φόρμες υπάρχουν σε αυτό το βίκι.',
	'createform' => 'Δημιουργία μιας φόρμας',
	'sf_createform_nameinput' => 'Όνομα φόρμας',
	'sf_createform_template' => 'Πρότυπο:',
	'sf_createform_templatelabelinput' => 'Ετίκετα προτύπου (προαιρετικό):',
	'sf_createform_field' => 'Πεδίο:',
	'sf_createform_inputtype' => 'Τύπος εισόδου:',
	'sf_createform_inputtypedefault' => '(Προεπιλογή)',
	'sf_createform_formlabel' => 'Ετικέτα φόρμας:',
	'sf_createform_hidden' => 'Κρυμμένος',
	'sf_createform_mandatory' => 'Υποχρεωτικός',
	'sf_createform_removetemplate' => 'Αφαίρεση προτύπου',
	'sf_createform_addtemplate' => 'Προσθήκη προτύπου:',
	'sf_createform_beforetemplate' => 'Πριν το πρότυπο:',
	'sf_createform_atend' => 'Στο τέλος',
	'sf_createform_add' => 'Προσθήκη',
	'sf_createform_choosefield' => 'Επιλογή μιας περιοχής για προσθήκη',
	'createcategory' => 'Δημιουργήστε μια κατηγορία',
	'sf_createcategory_name' => 'Όνομα κατηγορίας:',
	'sf_createcategory_defaultform' => 'Προεπιλεγμένη φόρμα:',
	'createclass' => 'Δημιουργία μίας κλάσης',
	'sf_createclass_allowedvalues' => 'Επιτρεπόμενες αξίες',
	'sf_createclass_listofvalues' => 'Κατάλογος τιμών',
	'sf_createclass_missingvalues' => 'Δεν συμπληρώθηκαν όλα τα απαραίτητα πεδία.',
	'formstart' => 'Προσθέστε σελίδα με μορφή',
	'sf_formstart_createoredit' => 'Δημιουργία ή επεξεργασία',
	'formedit' => 'Επεξεργασία με φόρμα',
	'sf_formedit_createtitle' => 'Δημιουργία $1: $2',
	'sf_formcreate' => 'Δημιουργία με φόρμα',
	'sf_viewform' => 'Εμφάνιση φόρμας',
	'sf_editsource' => 'Επεξεργασία πηγής',
	'sf_formedit_edittitle' => 'Επεξεργασία $1: $2',
	'sf_formedit_remove' => 'Αφαίρεση',
	'sf_formedit_addanother' => 'Προσθήκη κι άλλου',
	'sf_formedit_none' => 'Κανένα',
	'runquery' => 'Εκτέλεση αιτήματος',
	'sf_runquery_title' => 'Εκτέλεση αιτήματος: $1',
	'sf_runquery_additionalquery' => 'Επιπρόσθετο αίτημα',
	'sf_blank_error' => 'δεν γίνεται να εκκαθαριστεί',
	'sf_bad_number_error' => 'πρέπει να είναι ένας έγκυρος αριθμός',
	'sf_bad_integer_error' => 'πρέπει να είναι ένας έγκυρος ακέραιος αριθμός',
	'sf_bad_date_error' => 'πρέπει να είναι μια έγκυρη ημερομηνία',
	'uploadwindow' => 'Φόρτωση παραθύρου',
	'sf_deletionlog' => 'Αρχείο διαγραφών',
	'sf_property_isproperty' => 'Αυτή είναι μια ιδιότητα του τύπου $1.',
	'sf_property_linkstoform' => 'Συνδέει σε σελίδες για χρήση μιας φόρμας $1.',
	'sf_template_docufooter' => 'Επεξεργαστείτε τη σελίδα για να δείτε το κείμενο του προτύπου',
	'sf_form_freetextlabel' => 'Ελεύθερο κείμενο',
	'sf_category_hasdefaultform' => 'Αυτή η κατηγορία χρησιμοποιεί την φόρμα $1.',
	'sf_category_desc' => 'Αυτή είναι η κατηγορία $1.',
	'sf_blank_namespace' => 'Κύριος',
	'right-editrestrictedfields' => 'Επεξεργασία περιορισμένων πεδίων φορμών',
);

/** Esperanto (Esperanto)
 * @author Michawiki
 * @author Yekrats
 */
$messages['eo'] = array(
	'semanticforms-desc' => 'Formularoj por aldonado kaj redaktado de semantikaj datumoj',
	'specialpages-group-sf_group' => 'Semantikaj Kamparoj',
	'createproperty' => 'Kreu atributon',
	'sf_createproperty_propname' => 'Nomo de la atributo:',
	'sf_createproperty_proptype' => 'Speco:',
	'templates' => 'Ŝablonoj',
	'sf_templates_docu' => 'La jenaj ŝablonoj ekzistas en la vikio.',
	'sf_templates_definescat' => 'priskribas kategorion:',
	'createtemplate' => 'Kreu ŝablono',
	'sf_createtemplate_namelabel' => 'Nomo de ŝablono:',
	'sf_createtemplate_categorylabel' => 'Kategorio difinita de ŝablono (nedevige):',
	'sf_createtemplate_templatefields' => 'Kampoj de ŝablono',
	'sf_createtemplate_fieldname' => 'Nomo de kampo:',
	'sf_createtemplate_displaylabel' => 'Montru etikedon:',
	'sf_createtemplate_semanticproperty' => 'Semantika atributo:',
	'sf_createtemplate_fieldislist' => 'Ĉi kampo povas enhavi liston da valoroj, apartigitaj de komoj',
	'sf_createtemplate_aggregation' => 'Agregaĵo',
	'sf_createtemplate_aggregationlabel' => 'Titolo por listo:',
	'sf_createtemplate_outputformat' => 'Eliga formato:',
	'sf_createtemplate_standardformat' => 'Norma',
	'sf_createtemplate_infoboxformat' => 'Dekstra informokesto',
	'sf_createtemplate_addfield' => 'Aldonu kampon',
	'sf_createtemplate_deletefield' => 'Forigi',
	'sf_createtemplate_addtemplatebeforesave' => 'Vi devas aldoni almenaŭ unu ŝablonon al ĉi kamparo antaŭ vi povas konservi ĝin.',
	'forms' => 'Kamparoj',
	'sf_forms_docu' => 'La jenaj kampoj ekzistas en la vikio.',
	'createform' => 'Kreu kamparon',
	'sf_createform_nameinput' => 'Nomo de la formularo',
	'sf_createform_template' => 'Ŝablono:',
	'sf_createform_templatelabelinput' => 'Etikedo de ŝablono (nedevige):',
	'sf_createform_allowmultiple' => 'Akomodi multajn (aŭ nul) ekzemplerojn de ĉi ŝablono en la kreita paĝo',
	'sf_createform_field' => 'Kampo:',
	'sf_createform_fieldprop' => 'Ĉi tiu kampo difinas la atributon $1, de speco $2.',
	'sf_createform_fieldproplist' => 'Ĉi tiu kampo difinas liston de elementoj kiu havas la atributon $1, de tipo $2.',
	'sf_createform_fieldpropunknowntype' => 'Ĉi tiu kampo difinas la atributon $1, de nespecifa tipo.',
	'sf_createform_inputtype' => 'Eniga speco:',
	'sf_createform_inputtypedefault' => '(defaŭlto)',
	'sf_createform_formlabel' => 'Etikedo de kamparo:',
	'sf_createform_hidden' => 'Kaŝita',
	'sf_createform_restricted' => 'Limigita (nur administrantaj uzantoj povas ŝanĝi ĝin)',
	'sf_createform_mandatory' => 'Deviga',
	'sf_createform_removetemplate' => 'Forigu ŝablonon',
	'sf_createform_addtemplate' => 'Aldonu ŝablonon:',
	'sf_createform_beforetemplate' => 'Antaŭ ŝablono:',
	'sf_createform_atend' => 'Ĉe fino',
	'sf_createform_add' => 'Aldoni',
	'sf_createform_choosefield' => 'Elektu kampon por aldoni',
	'createcategory' => 'Kreu kategorion',
	'sf_createcategory_name' => 'Kategoria nomo:',
	'sf_createcategory_defaultform' => 'Defaŭlta kamparo:',
	'sf_createcategory_makesubcategory' => 'Faru ĉi tiun kiel kategorion de alia kategorio (nedevige):',
	'createclass' => 'Krei klason',
	'sf_createclass_allowedvalues' => 'Permesitaj valoroj',
	'sf_createclass_listofvalues' => 'Listo de valoroj',
	'formstart' => 'Aldoni paĝon kun kamparo',
	'sf_formstart_badform' => 'Eraro: neniu kampara paĝo estis trovita ĉe $1',
	'sf_formstart_createoredit' => 'Aldonu aŭ redaktu',
	'formedit' => 'Redaktu kun kamparo',
	'sf_formedit_createtitle' => 'Aldonu $1: $2',
	'sf_formedit_altformsonly' => 'Bonvolu elekti unu el la jenaj kamparoj aldoni ĉi paĝon:',
	'sf_formcreate' => 'Krei per formularo',
	'sf_viewform' => 'Rigardi kamparon',
	'sf_editsource' => 'Redaktu fonton',
	'sf_formedit_edittitle' => 'Redaktu $1: $2',
	'sf_formedit_formwarning' => 'Averto: Ĉi paĝo <a href="$1">jam ekzistas</a>, sed ĝi ne uzas ĉi kamparon.',
	'sf_formedit_remove' => 'Forigi',
	'sf_formedit_addanother' => 'Aldonu plu',
	'sf_formedit_none' => 'Neniu',
	'sf_runquery_additionalquery' => 'Aldona serĉomendo',
	'sf_formerrors_header' => 'Estis eraroj kun via kampara enigo, jene:',
	'sf_blank_error' => 'ne povas esti malplena',
	'sf_bad_url_error' => "nepre havas la korektan URL-formaton, komence kun 'http'",
	'sf_bad_email_error' => 'devas havi validan formaton de retpoŝta adreso',
	'sf_bad_number_error' => 'devas esti valida nombro',
	'sf_bad_integer_error' => 'devas esti valida enjero',
	'sf_bad_date_error' => 'devas esti valida dato',
	'uploadwindow' => 'Alŝuta fenestro',
	'sf_deletionlog' => 'Protokolo pri forigado',
	'sf_property_isproperty' => 'Ĉi tiu estas atributo de speco $1.',
	'sf_property_allowedvals' => 'La {{PLURAL:$1|permesita valoro por ĉi tiu atributo|permesitaj valoroj por ĉi tiuj atributoj}} estas:',
	'sf_template_docu' => "Ĉi tiu estas la '$1' ŝablono. Ĝi estu vokita en la jena formato:",
	'sf_template_docufooter' => 'Redaktu la paĝo por vidi la ŝablonan tekston.',
	'sf_form_freetextlabel' => 'Libera teksto',
	'sf_category_hasdefaultform' => 'Ĉi kategorio uzas la kamparon $1.',
	'sf_category_desc' => 'Ĉi tiu estas la $1 kategorio.',
	'sf_blank_namespace' => 'Ĉefa',
);

/** Spanish (Español)
 * @author Cmitnick
 * @author Crazymadlover
 * @author Dvdgmz
 * @author Jatrobat
 * @author Pertile
 * @author Peter17
 * @author Sanbec
 */
$messages['es'] = array(
	'semanticforms-desc' => 'Formularios para añadir y editar datos semánticos',
	'specialpages-group-sf_group' => 'Formularios semánticos',
	'createproperty' => 'Crear una propiedad',
	'sf_createproperty_linktoform' => 'Esta propiedad vinculará a páginas que usen el formulario:',
	'sf_createproperty_allowedvalsinput' => 'Si usted desea que esta propiedad solo permita tener ciertos valores, ingrese la lista de valores permitidos, separados por comas (si un valor contiene una coma, reemplazelo con "\\,"):',
	'sf_createproperty_propname' => 'Nombre de propiedad:',
	'sf_createproperty_proptype' => 'Tipo:',
	'templates' => 'Plantillas',
	'sf_templates_docu' => 'Las siguientes plantillas existen en el wiki.',
	'sf_templates_definescat' => 'Definir categoría:',
	'createtemplate' => 'Crear una plantilla',
	'sf_createtemplate_namelabel' => 'Nombre de la Plantilla:',
	'sf_createtemplate_categorylabel' => 'Categoría definida por la plantilla (opcional):',
	'sf_createtemplate_templatefields' => 'Campos de la Plantilla',
	'sf_createtemplate_fieldsdesc' => 'Para obtener los campos en esta plantilla ya no hace falta especificar los nombres de los campos, simplemente ingresa el índice de cada campo (por ejemplo 1, 2, 3, etc.) para referirte a él, en vez de su nombre real.',
	'sf_createtemplate_fieldname' => 'Nombre del Campo:',
	'sf_createtemplate_displaylabel' => 'Mostrar etiqueta:',
	'sf_createtemplate_semanticproperty' => 'Propiedad semántica:',
	'sf_createtemplate_fieldislist' => 'Este campo puede soportar una lista de valores, separados por comas',
	'sf_createtemplate_aggregation' => 'Agregación',
	'sf_createtemplate_aggregationdesc' => 'Para listar, en cualquier página usando esta plantilla, todas la páginas que tengan una cierta propiedad que apunte a esa página, especifica la propiedad adecuada a continuación:',
	'sf_createtemplate_aggregationlabel' => 'Título para la lista:',
	'sf_createtemplate_outputformat' => 'Formato de salida:',
	'sf_createtemplate_standardformat' => 'Estándar',
	'sf_createtemplate_infoboxformat' => 'Caja de información del lado derecho',
	'sf_createtemplate_addfield' => 'Agregar campo',
	'sf_createtemplate_deletefield' => 'Borrar',
	'sf_createtemplate_addtemplatebeforesave' => 'Debe agregar al menos una plantilla a este formulario antes de guardarlo.',
	'forms' => 'Formularios',
	'sf_forms_docu' => 'Los siguientes formularios existen en el wiki.',
	'createform' => 'Crear un formulario',
	'sf_createform_nameinput' => 'Nombre del Formulario',
	'sf_createform_nameinputdesc' => '(la convención es nombrar el formulario después de que la plantilla principal se rellena):',
	'sf_createform_template' => 'Plantilla:',
	'sf_createform_templatelabelinput' => 'Etiqueta de la plantilla (opcional):',
	'sf_createform_allowmultiple' => 'Permitir múltiples (o ninguna) instancias de esta plantilla en la página creada',
	'sf_createform_field' => 'Campo:',
	'sf_createform_fieldprop' => 'Este campo define la propiedad $1, de tipo $2.',
	'sf_createform_fieldproplist' => 'Este campo define una lista de elementos que tienen la propiedad $1, de tipo $2.',
	'sf_createform_fieldpropunknowntype' => 'Este campo define la propiedad $1, de tipo no especificado.',
	'sf_createform_inputtype' => 'Tipo de entrada:',
	'sf_createform_inputtypedefault' => '(por defecto)',
	'sf_createform_formlabel' => 'Etiqueta del Formulario:',
	'sf_createform_hidden' => 'Oculto',
	'sf_createform_restricted' => 'Restringido (solo usuarios sysop pueden modificarlo)',
	'sf_createform_mandatory' => 'Obligado',
	'sf_createform_removetemplate' => 'Sacar plantilla',
	'sf_createform_addtemplate' => 'Agregar plantilla:',
	'sf_createform_beforetemplate' => 'Plantilla anterior:',
	'sf_createform_atend' => 'Al final',
	'sf_createform_add' => 'Agregar',
	'sf_createform_choosefield' => 'Escoger un campo para agregar',
	'createcategory' => 'Crear una categoría',
	'sf_createcategory_name' => 'Nombre de categoría:',
	'sf_createcategory_defaultform' => 'Formulario por defecto:',
	'sf_createcategory_makesubcategory' => 'Hacer esto una subcategoría de otra categoría (opcional):',
	'createclass' => 'Crear una clase',
	'sf_createclass_docu' => 'Ingresar todos los datos aquí para crear las propiedades, plantilla, formulario y categoría para una sóla clase. Para más opciones, usar las páginas $1 en su lugar.',
	'sf_createclass_allowedvalues' => 'Valores permitidos',
	'sf_createclass_listofvalues' => 'Lista de valores',
	'sf_createclass_leavefieldblank' => 'Si el nombre de campo es el mismo que el nombre de propiedad, puedes dejarlo en blanco.',
	'sf_createclass_missingvalues' => 'No todos los campos requeridos fueron llenados.',
	'sf_createclass_success' => 'Propiedades, plantilla, formulario y categoría serán creadas.',
	'formstart' => 'Agregar página con formulario',
	'sf_formstart_badform' => 'Error: no se encontró la página del formulario en $1',
	'sf_formstart_badtitle' => 'Error: "$1" es un título inválido para una página.',
	'sf_formstart_docu' => "Ingresar el nombre de la página aqui, para ser editado con el formulario '$1'. Si esta página ya existe, usted será enviado al formulario para editar esa página. De otra forma, usted será enviado al formulario para agregar la página.",
	'sf_formstart_noform_docu' => 'Ingresar el nombre de la página aqui, y seleccionar el formulario con el cual se editará. Si esta página ya existe, usted será enviado al formulario para editar esa página. De otra forma, usted será enviado al formulario para agregar la página.',
	'sf_formstart_createoredit' => 'Crear o editar',
	'formedit' => 'Editar con formulario',
	'sf_formedit_createtitle' => 'Crear $1: $2',
	'sf_formedit_badurl' => "Esta es la página para la edición con un formulario. Debe especificar tanto el nombre del formulario como la página de destino en la URL; el resultado se debería ver 'Especial:EditarFormulario?form=&lt;nombre del formulario&gt;&target=&lt;página destino&gt;' o 'Epecial:EditarFormulario/&lt;nombre del formulario&gt;/&lt;página destino&gt;'.",
	'sf_formedit_altforms' => 'Usted puede también agregar esta página con uno de los siguientes formularios:',
	'sf_formedit_altformsonly' => 'Porfavor seleccionar de uno de los siguientes formularios para agregar esta página:',
	'sf_formcreate' => 'Crear con formulario',
	'sf_viewform' => 'Ver el formulario',
	'sf_editsource' => 'Editar fuente',
	'sf_formedit_edittitle' => 'Editar $1: $2',
	'sf_formedit_morethanoneform' => 'Advertencia: Más de un formulario por defecto está definido para esta página.',
	'sf_formedit_formwarning' => 'Advertencia: Esta página <a href="$1">ya existe</a>, pero no usa este formulario.',
	'sf_formedit_remove' => 'Sacar',
	'sf_formedit_addanother' => 'Agregar otro',
	'sf_formedit_none' => 'Ninguno',
	'runquery' => 'Ejecutar consulta',
	'sf_runquery_badurl' => "Debes especificar un nombre de formulario en el URL;
el URL debería lucir como 'Special:RunQuery/&lt;form name&gt;'.",
	'sf_runquery_title' => 'Ejecutar consulta: $1',
	'sf_runquery_additionalquery' => 'Consulta adicional',
	'sf_formerrors_header' => 'Hubo errores en los datos del formulario; vea más abajo',
	'sf_blank_error' => 'no puede estar en blanco',
	'sf_bad_url_error' => "debe tener el formato correcto de URL, comenzando con 'http'",
	'sf_bad_email_error' => 'debe tener un formato de dirección de email válido',
	'sf_bad_number_error' => 'debe ser un número válido',
	'sf_bad_integer_error' => 'debe ser un entero válido',
	'sf_bad_date_error' => 'debe ser una fecha válida',
	'uploadwindow' => 'Ventana para subir archivos',
	'sf_deletionlog' => 'Registro de borrado',
	'sf_property_isproperty' => 'Esta es una propiedad de tipo $1.',
	'sf_property_linkstoform' => 'Vincula a páginas que usen el formulario $1.',
	'sf_property_allowedvals' => 'Los {{PLURAL:$1|valor permitido para esta propiedad es|valores permitidos para esta propiedad son}}:',
	'sf_template_docu' => "Este es la plantilla '$1'. Debe ser llamada en el siguiente formato:",
	'sf_template_docufooter' => 'Editar la página para ver el texto de la plantilla.',
	'sf_form_docu' => "Este es el formulario ''$1''.
Para crear una página con este formulario, ingrese el nombre de la página a continuación; si la página con ese nombre ya existe, será dirigido al formulario para editar esa página.",
	'sf_form_freetextlabel' => 'Texto libre',
	'sf_category_hasdefaultform' => 'Esta categoría usa el formulario $1.',
	'sf_category_desc' => 'Esta es la categoría $1.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Ver pestaña "Editar" para páginas editables por formulario',
	'right-editrestrictedfields' => 'Editar campos de formulario restringidos',
);

/** Basque (Euskara)
 * @author An13sa
 * @author Kobazulo
 */
$messages['eu'] = array(
	'createproperty' => 'Propietatea sortu',
	'sf_createproperty_propname' => 'Ezaugarriaren izena:',
	'sf_createproperty_proptype' => 'Mota:',
	'templates' => 'Txantiloiak',
	'createtemplate' => 'Txantiloia sortu',
	'sf_createtemplate_namelabel' => 'Txantiloiaren izena:',
	'sf_createtemplate_displaylabel' => 'Etiketa erakutsi:',
	'sf_createtemplate_deletefield' => 'Ezabatu',
	'sf_createform_template' => 'Txantiloia:',
	'sf_createform_removetemplate' => 'Txantiloia kendu',
	'sf_createform_addtemplate' => 'Txantiloia gehitu:',
	'sf_createform_add' => 'Gehitu',
	'createcategory' => 'Kategoria sortu',
	'sf_createcategory_name' => 'Kategoriaren izena:',
	'sf_formstart_createoredit' => 'Sortu edo aldatu',
	'sf_formedit_createtitle' => '$1 aldatu: $2',
	'sf_editsource' => 'Iturria aldatu',
	'sf_formedit_edittitle' => '$1 aldatu: $2',
	'sf_formedit_remove' => 'Kendu',
	'sf_formedit_addanother' => 'Beste bat gehitu',
	'sf_deletionlog' => 'Ezabaketa erregistroa',
	'sf_form_freetextlabel' => 'Testu askea',
	'sf_blank_namespace' => 'Nagusia',
);

/** Persian (فارسی)
 * @author Huji
 * @author Momeni
 * @author Tofighi
 */
$messages['fa'] = array(
	'semanticforms-desc' => 'فرم‌هایی برای افزودن و ویرایش اطلاعات معنایی',
	'specialpages-group-sf_group' => 'فرم‌های معنایی',
	'createproperty' => 'ویژگی بسازید',
	'sf_createproperty_allowedvalsinput' => 'اگر می‌خواهید این ورودی تنها مقادیر مشخصی داشته باشد،سیاهه مقادیر را وارد کنید و آنها را با کاما جدا سازید (اگر در این مقادیر از کاما استفاده می‌کنید، آن‌را با "\\،" جایگزین نمایید):',
	'sf_createproperty_propname' => 'نام:',
	'sf_createproperty_proptype' => 'نوع:',
	'templates' => 'الگوها',
	'sf_templates_docu' => 'الگوهای زیر در این ویکی وجود دارند.',
	'sf_templates_definescat' => 'تعیین رده:',
	'createtemplate' => 'الگو بسازید',
	'sf_createtemplate_namelabel' => 'نام الگو:',
	'sf_createtemplate_categorylabel' => 'تعیین رده به‌وسیله الگو (دلخواه):',
	'sf_createtemplate_templatefields' => 'ورودی‌های الگو',
	'sf_createtemplate_fieldsdesc' => 'برای داشتن ورودی‌های بدون نام در الگوها،کافیست شماره ورودی را به جای نام واقعی ورودی وارد کنید (مثلا ۳،۲،۱ و ...).',
	'sf_createtemplate_fieldname' => 'نام ورودی:',
	'sf_createtemplate_displaylabel' => 'نمایش برچسب:',
	'sf_createtemplate_semanticproperty' => 'ویژگی معنایی:',
	'sf_createtemplate_fieldislist' => 'این ورودی می‌تواند یک سیاهه از مقادیر را که با کاما از هم جدا شده‌اند، در خود ذخیره کند',
	'sf_createtemplate_aggregation' => 'تراکم',
	'sf_createtemplate_aggregationdesc' => 'برای داشتن سیاهه همه صفحاتی که این الگو را به‌کار می‌برند، و همه آن مقالاتی که با ویژگی معینی با آن صفحه در ارتباط هستند، وِیژگی مناسب را مشخص کنید:',
	'sf_createtemplate_aggregationlabel' => 'عنوان سیاهه',
	'sf_createtemplate_outputformat' => 'قالب خروجی:',
	'sf_createtemplate_standardformat' => 'استاندارد',
	'sf_createtemplate_infoboxformat' => 'جعبه اطلاعات سمت راست',
	'sf_createtemplate_addfield' => 'افزودن ورودی',
	'sf_createtemplate_deletefield' => 'حذف',
	'sf_createtemplate_addtemplatebeforesave' => 'قبل از اینکه بتوانید فرم را ذخیره کنید، شما می‌بایست حداقل یک الگو به این فرم اضافه نمایید.',
	'forms' => 'فرم‌ها',
	'sf_forms_docu' => 'فرم‌های زیر در این ویکی وجود دارند.',
	'createform' => 'فرم بسازید',
	'sf_createform_nameinput' => 'نام فرم (بهتر است که بعد از پر شدن به‌وسیله یک الگو، فرم نام‌گذاری شود):',
	'sf_createform_template' => 'الگو:',
	'sf_createform_templatelabelinput' => 'برچسب الگو (دلخواه):',
	'sf_createform_allowmultiple' => 'می‌توان چند (یا صفر) نمونه از این الگو را در ساختن صفحه‌ها استفاده کرد',
	'sf_createform_field' => 'ورودی:',
	'sf_createform_fieldprop' => 'این ورودی ویژگی $1 از نوع $2 را تعیین می‌کند.',
	'sf_createform_fieldproplist' => 'این ورودی یک سیاهه از مواردی که ویژگی $1 از نوع $2 را دارند، تعیین می‌کند.',
	'sf_createform_fieldpropunknowntype' => 'این ورودی ویژگی $1 از نوع نامشخص را تعیین می‌کند.',
	'sf_createform_inputtype' => 'نوع ورودی:',
	'sf_createform_inputtypedefault' => '(پیش‌فرض)',
	'sf_createform_formlabel' => 'برچسب فرم:',
	'sf_createform_hidden' => 'مخفی',
	'sf_createform_restricted' => 'محدود‌شده (فقط مدیران می‌توانند ویرایش کنند)',
	'sf_createform_mandatory' => 'الزامی',
	'sf_createform_removetemplate' => 'حذف الگو',
	'sf_createform_addtemplate' => 'افزودن الگو:',
	'sf_createform_beforetemplate' => 'قبل از الگوی:',
	'sf_createform_atend' => 'در آخر',
	'sf_createform_add' => 'افزودن',
	'sf_createform_choosefield' => 'یک ورودی برای افزودن انتخاب کنید',
	'createcategory' => 'رده بسازید',
	'sf_createcategory_name' => 'نام:',
	'sf_createcategory_defaultform' => 'فرم پیش‌فرض:',
	'sf_createcategory_makesubcategory' => 'قرار دادن این رده به عنوان زیررده یک رده دیگر(دلخواه):',
	'formstart' => 'افزودن صفحه',
	'sf_formstart_badform' => 'خطا: هیچ صفحه فرمی در $1 پیدا نشد',
	'sf_formstart_docu' => "برای ویرایش با فرم '$1'، نام صفحه را اینجا وارد کنید. اگر صفحه در حال حاضر موجود باشد، شما به فرم ویرایش صفحه هدایت می‌شوید. در غیر این‌صورت به فرم افزودن صفحه منتقل خواهید شد.",
	'sf_formstart_noform_docu' => 'نام صفحه را اینجا وارد کنید و فرمی را که می‌خواهید ویرایش با آن انجام شود انتخاب نمایید. اگر صفحه در حال حاضر موجود باشد، شما به صفحه ویرایش آن صفحه به‌وسیله فرم  هدایت می‌شوید. در غیر این‌صورت به فرم افزودن صفحه منتقل خواهید شد.',
	'sf_formstart_createoredit' => 'افزودن یا ویرایش',
	'formedit' => 'ویرایش با فرم',
	'sf_formedit_createtitle' => 'افزودن $1: $2',
	'sf_formedit_badurl' => 'این صفحه برای افزودن اطلاعات است. شما باید هم نام فرم هم صفحه مقصد را در URL وارد کنید. چیزی شبیه به این <br /><span dir="ltr"> \'ویژه:FormEdit?form=&lt;نام فرم&gt;&target=&lt;صفحه مقصد&gt;\' </span><br />یا<br /><span dir="ltr"> \'ویژه:FormEdit/&lt;نام فرم&gt;/&lt;صفحه مقصد&gt;\' </span>.',
	'sf_formedit_altforms' => 'می‌توانید این صفحه را به‌وسیله فرم‌های زیر نیز بسازید:',
	'sf_formedit_altformsonly' => 'لطفا برای افزودن صفحه از یکی از فرم‌های زیر استفاده کنید:',
	'sf_viewform' => 'نمایش فرم',
	'sf_editsource' => 'ویرایش مبدأ',
	'sf_formedit_edittitle' => 'ویرایش $1: $2',
	'sf_formedit_formwarning' => 'اخطار: این صفحه <a href="$1">هم‌اکنون وجود دارد</a>، ولی به‌وسیله این فرم ساخته نشده است.',
	'sf_formedit_remove' => 'حذف',
	'sf_formedit_addanother' => 'افزدون دیگری',
	'sf_formedit_none' => 'هیچکدام',
	'sf_formerrors_header' => 'خطاهایی در ورودی فرمتان وجود دارد؛ قسمت پایین را ببینید',
	'sf_blank_error' => 'نمی‌تواند خالی باشد',
	'sf_bad_url_error' => "باید قالب URL درستی داشته باشد و با 'http' شروع شود",
	'sf_bad_email_error' => 'باید قالب صحیحی برای پست الکترونیک داشته باشد',
	'sf_bad_number_error' => 'باید یک عدد معتبر باشد',
	'sf_bad_integer_error' => 'باید یک عدد صحیح معتبر باشد',
	'sf_bad_date_error' => 'باید یک تاریخ معتبر باشد',
	'uploadwindow' => 'پنجره بارگذاری',
	'sf_property_isproperty' => 'این یک ویژگی از نوع $1 است.',
	'sf_property_allowedvals' => 'مقادیر مجاز برای این ویژگی یا صفت این‌ها هستند:',
	'sf_template_docu' => "این الگوی '$1' است. باید با این قالب فراخوانی شود:",
	'sf_template_docufooter' => 'برای مشاهده متن الگو صفحه را ویرایش کنید.',
	'sf_form_docu' => "این فرم '$1' است. برای افزودن یک صفحه به‌وسیله این فرم،نام صفحه را وارد کنید، اگر صفحه‌ای با این نام وجود داشته باشد، به فرم ویرایش صفحه هدایت می‌شوید.",
	'sf_form_freetextlabel' => 'متن دلخواه',
	'sf_category_hasdefaultform' => 'این رده از فرم $1 استفاده می‌کند.',
	'sf_category_desc' => 'این رده $1 است.',
	'sf_blank_namespace' => 'اصلی',
);

/** Finnish (Suomi)
 * @author Centerlink
 * @author Cimon Avaro
 * @author Crt
 * @author Mobe
 * @author Nedergard
 * @author Nike
 * @author Silvonen
 * @author Str4nd
 * @author ZeiP
 */
$messages['fi'] = array(
	'semanticforms-desc' => 'Mahdollisuus semanttisen tiedon syöttämiseen ja muokkaamiseen.',
	'specialpages-group-sf_group' => 'Semanttiset lomakkeet',
	'createproperty' => 'Luo ominaisuus',
	'sf_createproperty_linktoform' => 'Tämä ominaisuus linkittää sivuille, jotka käyttävät lomaketta:',
	'sf_createproperty_allowedvalsinput' => 'Jos haluat kentän voivan sisältää vain tiettyjä arvoja, anna pilkuin erotettu lista sallituista arvoista (jos arvo sisältää pilkun, korvaa pilkku kenoviivalla, esim. ”\\,”):',
	'sf_createproperty_propname' => 'Ominaisuuden nimi:',
	'sf_createproperty_proptype' => 'Tyyppi',
	'templates' => 'Mallineet',
	'sf_templates_docu' => 'Tässä Wikissä on seuraavat mallineet:',
	'sf_templates_definescat' => 'määrittelee luokan',
	'createtemplate' => 'Luo malline',
	'sf_createtemplate_namelabel' => 'Mallineen nimi',
	'sf_createtemplate_categorylabel' => 'Mallineen määrittelemä luokka (ei-pakollinen)',
	'sf_createtemplate_templatefields' => 'Mallineen kentät',
	'sf_createtemplate_fieldsdesc' => 'Kenttien määrittäminen tähän mallineeseen onnistuu nykyään käyttämällä numeroita (1, 2, 3…) kentän nimenä oikean nimen sijaan.',
	'sf_createtemplate_fieldname' => 'Kentän nimi',
	'sf_createtemplate_displaylabel' => 'Näyttönimi',
	'sf_createtemplate_semanticproperty' => 'Semanttinen ominaisuus',
	'sf_createtemplate_fieldislist' => 'Tämä kenttä voi sisältää pilkuin erotetun listan arvoista',
	'sf_createtemplate_aggregation' => 'Aggregaatio',
	'sf_createtemplate_aggregationdesc' => 'Jos haluat listan (millä tahansa mallinetta käyttävällä sivulla) sivuista, joilla on tietty ominaisuus, joka osoittaa sivuun, määrittele sopiva ominaisuus alle:',
	'sf_createtemplate_aggregationlabel' => 'Listan otsikko',
	'sf_createtemplate_outputformat' => 'Tulostemuoto',
	'sf_createtemplate_standardformat' => 'Oletusmuoto',
	'sf_createtemplate_infoboxformat' => 'Oikealla tietolaatikossa',
	'sf_createtemplate_addfield' => 'Lisää kenttä',
	'sf_createtemplate_deletefield' => 'Poista',
	'sf_createtemplate_addtemplatebeforesave' => 'Sinun pitää lisätä ainakin yksi malline tähän lomakkeeseen, ennen kuin voit tallentaa sen.',
	'forms' => 'Lomakkeet',
	'sf_forms_docu' => 'Tässä wikissä on seuraavat lomakkeet:',
	'createform' => 'Luo lomake',
	'sf_createform_nameinput' => 'Lomakkeen nimi',
	'sf_createform_nameinputdesc' => '(hyvä tapa on nimetä lomake sen pääasiallisen mallineen mukaan):',
	'sf_createform_template' => 'Malline',
	'sf_createform_templatelabelinput' => 'Mallineen näyttönimi (ei-pakollinen)',
	'sf_createform_allowmultiple' => 'Tämä malline voi esiintyä luodulla sivulla useasti tai ei kertaakaan',
	'sf_createform_field' => 'Kenttä',
	'sf_createform_fieldprop' => 'Tämä kenttä määrittelee ominaisuuden $1, joka on tyyppiä $2.',
	'sf_createform_fieldproplist' => 'Tämä kenttä määrittelee listan elementeistä, joilla on ominaisuus $1, joka on tyyppiä $2.',
	'sf_createform_fieldpropunknowntype' => 'Tämä kenttä määrittelee ominaisuuden $1, jonka tyyppi on määrittelemätön.',
	'sf_createform_inputtype' => 'Syötetyyppi',
	'sf_createform_inputtypedefault' => '(oletus)',
	'sf_createform_formlabel' => 'Lomakkeen näyttönimi',
	'sf_createform_hidden' => 'Piilotettu',
	'sf_createform_restricted' => 'Rajoitettu (vain ylläpitäjät voivat muokata)',
	'sf_createform_mandatory' => 'Pakollinen',
	'sf_createform_removetemplate' => 'Poista malline',
	'sf_createform_addtemplate' => 'Lisää malline:',
	'sf_createform_beforetemplate' => 'Ennen mallinetta',
	'sf_createform_atend' => 'Lopussa',
	'sf_createform_add' => 'Lisää',
	'sf_createform_choosefield' => 'Valitse lisättävä kenttä',
	'createcategory' => 'Luo luokka',
	'sf_createcategory_name' => 'Luokkanimi',
	'sf_createcategory_defaultform' => 'Oletuslomake',
	'sf_createcategory_makesubcategory' => 'Tee tästä toisen luokan alaluokka (ei-pakollinen):',
	'createclass' => 'Luo luokka',
	'sf_createclass_docu' => 'Kirjoita kaikki tiedot tähän ominaisuuksien, mallineen, muodon ja luokan luomiseksi yksittäisluokkaan. Käytä lisäasetuksia varten sen sijaan sivuja $1.',
	'sf_createclass_allowedvalues' => 'Sallitut arvot',
	'sf_createclass_listofvalues' => 'Lista arvoista',
	'sf_createclass_leavefieldblank' => 'Jos kentän nimi on sama kuin ominaisuuden nimi, voit jättää sen tyhjäksi.',
	'sf_createclass_missingvalues' => 'Kaikkia pakollisia kenttiä ei ole täytetty.',
	'sf_createclass_success' => 'Ominaisuudet, malline, muoto ja luokka luodaan.',
	'formstart' => 'Lisää sivu lomakkeella',
	'sf_formstart_badform' => 'Virhe: lomakesivua ei löytynyt kohteesta $1',
	'sf_formstart_badtitle' => 'Virhe: ”$1” on virheellinen nimi sivulle.',
	'sf_formstart_docu' => 'Anna sivun nimi, jota muokataan lomakkeella $1. Jos sivu on jo olemassa, sinut ohjataan lomakkeelle, jolla voi muokata sitä sivua. Muussa tapauksessa sinut ohjataan sivunlisäyslomakkeelle.',
	'sf_formstart_noform_docu' => 'Anna sivun nimi ja valitse lomake, jolla haluat muokata sitä. Jos sivu on jo olemassa, sinut ohjataan lomakkeelle, jolla voit muokata sitä sivua. Muussa tapauksessa sinut ohjataan sivunlisäyslomakkeelle.',
	'sf_formstart_createoredit' => 'Luo tai muokkaa',
	'formedit' => 'Muokkaa lomakkeella',
	'sf_formedit_createtitle' => 'Luo $1: $2',
	'sf_formedit_badurl' => 'Tämä sivu on datan lisäämistä varten. Sinun täytyy määritellä sekä lomakkeen nimi että kohdesivu URL-osoitteessa. Osoitteen pitäisi olla muotoa ”Special:FormEdit?form=&lt;lomakkeen nimi&gt;&target=&lt;kohdesivu&gt;” tai ”Special:FormEdit/&lt;lomakkeen nimi&gt;/&lt;kohdesivu&gt;”.',
	'sf_formedit_altforms' => 'Voit sen sijaan lisätä tämän sivun ja jonkun seuraavista lomakkeista:',
	'sf_formedit_altformsonly' => 'Valitse jokin seuraavista lomakkeista, jonka haluat lisätä tällä sivulle:',
	'sf_formcreate' => 'Luo lomakkeella',
	'sf_viewform' => 'Näytä lomake',
	'sf_editsource' => 'Muokkaa lähdetekstiä',
	'sf_formedit_edittitle' => 'Muokkaa $1: $2',
	'sf_formedit_morethanoneform' => "'''Virhe:''' Tälle sivulle on määritetty enemmän kuin yksi oletuslomake.",
	'sf_formedit_formwarning' => 'Varoitus: sivu <a href="$1">on jo olemassa</a>, mutta se ei käytä tätä lomaketta.',
	'sf_formedit_remove' => 'Poista',
	'sf_formedit_addanother' => 'Lisää toinen',
	'sf_formedit_none' => 'ei mikään',
	'runquery' => 'Suorita kysely',
	'sf_runquery_badurl' => 'Sinun tulee antaa lomakkeen nimi URL-osoitteessa;
osoitteen tulisi näyttää esimerkiksi tältä: ”Special:RunQuery/&lt;form name&gt;”.',
	'sf_runquery_title' => 'Suorita kysely: $1',
	'sf_runquery_additionalquery' => 'Lisähakukysely',
	'sf_formerrors_header' => 'Syöttämissäsi tiedoissa on vikaa.',
	'sf_blank_error' => 'ei voi olla tyhjä',
	'sf_bad_url_error' => 'pitää olla kelvollinen URL-osoite, jonka protokolla on http',
	'sf_bad_email_error' => 'pitää olla kelvollinen sähköpostiosoite',
	'sf_bad_number_error' => 'pitää olla kelvollinen numero',
	'sf_bad_integer_error' => 'pitää olla kelvollinen kokonaisluku',
	'sf_bad_date_error' => 'pitää olla kelvollinen päiväys',
	'uploadwindow' => 'Tallennusikkuna',
	'sf_deletionlog' => 'Poistoloki',
	'sf_property_isproperty' => 'Tämä on ominaisuus, jonka tyyppi on $1.',
	'sf_property_linkstoform' => 'Linkittää sivuille, jotka käyttävät lomaketta $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Sallittu arvo tälle ominaisuudelle on|Sallitut arvot tälle ominaisuudelle ovat}}:',
	'sf_template_docu' => 'Tämä on malline $1. Sitä käytetään seuraavasti:',
	'sf_template_docufooter' => 'Muokkaa tätä sivua, jos haluat nähdä mallineen tekstin.',
	'sf_form_docu' => 'Tämä on lomake $1.
Jos haluat luoda sivun, jossa on tämä lomake, kirjoita sivun nimi alle.
Jos sivu on jo olemassa, sinut ohjataan lomakkeelle, jolla voi muokata kyseistä sivua.',
	'sf_form_freetextlabel' => 'Vapaamuotoinen teksti',
	'sf_category_hasdefaultform' => 'Tämä luokka käyttää lomaketta $1.',
	'sf_category_desc' => 'Tämä on luokka $1.',
	'sf_blank_namespace' => 'Päänimiavaruus',
	'right-viewedittab' => 'Näytä ”Muokkaa”-välilehti lomakkein muokattaville sivuille',
	'right-editrestrictedfields' => 'Muokata rajoitettuja lomakekenttiä',
);

/** French (Français)
 * @author Crochet.david
 * @author Dereckson
 * @author Grondin
 * @author IAlex
 * @author Peter17
 * @author PieRRoMaN
 * @author Sherbrooke
 * @author Urhixidur
 */
$messages['fr'] = array(
	'semanticforms-desc' => 'Formulaires pour ajouter ou modifier des données sémantiques',
	'specialpages-group-sf_group' => 'Formulaires sémantiques',
	'createproperty' => 'Définir une propriété',
	'sf_createproperty_linktoform' => 'Cette propriété liera vers les pages utilisant le formulaire :',
	'sf_createproperty_allowedvalsinput' => 'Si vous voulez restreindre ce champ à certaines valeurs, entrez la liste des valeurs permises séparées par des virgules (si une valeur contient une virgule, utilisez « \\, ») :',
	'sf_createproperty_propname' => 'Nom de la propriété :',
	'sf_createproperty_proptype' => 'Type :',
	'templates' => 'Modèles',
	'sf_templates_docu' => 'Les modèles suivants existent dans le wiki.',
	'sf_templates_definescat' => 'définit la catégorie :',
	'createtemplate' => 'Créer un modèle',
	'sf_createtemplate_namelabel' => 'Nom de modèle :',
	'sf_createtemplate_categorylabel' => 'Catégorie définie par ce modèle (facultatif) :',
	'sf_createtemplate_templatefields' => 'Champs de modèle',
	'sf_createtemplate_fieldsdesc' => 'Pour un modèle qui n’utilise aucun nom pour les champs, remplacez simplement les noms de champs par leurs indices (exemples : 1, 2, 3, etc.).',
	'sf_createtemplate_fieldname' => 'Nom du champ :',
	'sf_createtemplate_displaylabel' => 'Étiquette pour l’affichage :',
	'sf_createtemplate_semanticproperty' => 'Propriété sémantique :',
	'sf_createtemplate_fieldislist' => 'Ce champ peut contenir une liste de valeurs séparées par des virgules.',
	'sf_createtemplate_aggregation' => 'Agrégation',
	'sf_createtemplate_aggregationdesc' => 'Pour lister, sur chaque page utilisant ce modèle, toutes celles qui ont une propriété pointant vers celle-ci, indiquez la propriété adéquate ci-dessous :',
	'sf_createtemplate_aggregationlabel' => 'Titre pour la liste :',
	'sf_createtemplate_outputformat' => 'Format de sortie :',
	'sf_createtemplate_standardformat' => 'Normal',
	'sf_createtemplate_infoboxformat' => 'Infobox de droite',
	'sf_createtemplate_addfield' => 'Ajouter un champ',
	'sf_createtemplate_deletefield' => 'Supprimer',
	'sf_createtemplate_addtemplatebeforesave' => 'Vous devez ajouter au moins un modèle à ce formulaire avant de pouvoir le sauvegarder.',
	'forms' => 'Formulaires',
	'sf_forms_docu' => 'Les formulaires suivants existent dans le wiki.',
	'createform' => 'Créer un formulaire',
	'sf_createform_nameinput' => 'Nom de formulaire',
	'sf_createform_nameinputdesc' => '(la convention est de nommer le formulaire selon le modèle principal qu’il remplit)',
	'sf_createform_template' => 'Modèle :',
	'sf_createform_templatelabelinput' => 'Étiquette de modèle (facultatif) :',
	'sf_createform_allowmultiple' => 'Permettre plusieurs (ou zéro) instances de ce modèle dans la page créée',
	'sf_createform_field' => 'Champ :',
	'sf_createform_fieldprop' => 'Ce champ définit la propriété $1, de type $2.',
	'sf_createform_fieldproplist' => 'Ce champ définit une liste des éléments qui ont la propriété $1, de type $2.',
	'sf_createform_fieldpropunknowntype' => 'Ce champ définit la propriété $1, de type indéterminé.',
	'sf_createform_inputtype' => 'Type d’entrée :',
	'sf_createform_inputtypedefault' => '(par défaut)',
	'sf_createform_formlabel' => 'Étiquette dans le formulaire :',
	'sf_createform_hidden' => 'Masqué',
	'sf_createform_restricted' => 'Restreint',
	'sf_createform_mandatory' => 'Obligatoire',
	'sf_createform_removetemplate' => 'Enlever ce modèle',
	'sf_createform_addtemplate' => 'Ajouter un modèle :',
	'sf_createform_beforetemplate' => 'Avant le modèle :',
	'sf_createform_atend' => 'À la fin',
	'sf_createform_add' => 'Ajouter',
	'sf_createform_choosefield' => 'Choisissez un champ à ajouter',
	'createcategory' => 'Créer une catégorie',
	'sf_createcategory_name' => 'Nom de la catégorie :',
	'sf_createcategory_defaultform' => 'Formulaire par défaut :',
	'sf_createcategory_makesubcategory' => 'Crée une sous-catégorie d’une autre catégorie (facultatif) :',
	'createclass' => 'Créer une classe',
	'sf_createclass_docu' => 'Spécifiez ici les données servant à créer les propriétés, modèle, formulaire et catégorie d’une classe. Pour plus d’options, utilisez plutôt les pages $1.',
	'sf_createclass_allowedvalues' => 'Valeurs autorisées',
	'sf_createclass_listofvalues' => 'Liste de valeurs',
	'sf_createclass_leavefieldblank' => 'Si le nom du champ est le même que le nom de la propriété, vous pouvez laisser ce champ vide.',
	'sf_createclass_missingvalues' => 'Les champs obligatoires n’ont pas tous été remplis.',
	'sf_createclass_success' => 'Les propriétés, modèle, formulaire et catégorie seront créés.',
	'formstart' => 'Ajouter une page avec un formulaire',
	'sf_formstart_badform' => 'Erreur : aucune page de formulaire n’a été trouvée sur $1.',
	'sf_formstart_badtitle' => 'Erreur : « $1 » est un titre de page invalide.',
	'sf_formstart_docu' => 'Entrez ici le nom de la page destinée à être modifiée avec le formulaire « $1 ». Si cette page existe déjà, vous serez dirigé vers le formulaire afin de le modifier. Dans le cas contraire, vous serez redirigé vers celui permettant de l’ajouter.',
	'sf_formstart_noform_docu' => 'Entrez ici le nom de la page, puis sélectionnez le formulaire qui servira à la modifier. Si cette page existe déjà, vous serez dirigé vers le formulaire afin de le modifier. Dans le cas contraire, vous serez redirigé vers celui permettant de l’ajouter.',
	'sf_formstart_createoredit' => 'Créer ou modifier',
	'formedit' => 'Modifier avec un formulaire',
	'sf_formedit_createtitle' => 'Créer $1 : $2',
	'sf_formedit_badurl' => 'Ceci est la page pour modifier les données en utilisant un formulaire. Il faut indiquer un nom de formulaire et une page cible dans l’URL ;
l’URL doit ressembler à « Special:FormEdit?form=&lt;nom de formulaire&gt;&target=&lt;nom de page cible&gt; » ou « Special:FormEdit/&lt;nom de formulaire&gt;/&lt;nom de page cible&gt; ».',
	'sf_formedit_altforms' => 'Vous pouvez, à la place, ajouter cette page avec l’un des formulaires suivants :',
	'sf_formedit_altformsonly' => 'Vous êtes prié{{GENDER:||e|(e)}} de sélectionner l’un des formulaires suivants pour ajouter cette page :',
	'sf_formcreate' => 'Créer avec un formulaire',
	'sf_viewform' => 'Voir le formulaire',
	'sf_editsource' => 'Modifier la source',
	'sf_formedit_edittitle' => 'Modifier $1 : $2',
	'sf_formedit_morethanoneform' => 'Avertissement : Plus d’un formulaire par défaut est spécifié pour cette page.',
	'sf_formedit_formwarning' => 'Attention : cette page <a href="$1">existe déjà</a>, mais elle n’utilise pas ce formulaire.',
	'sf_formedit_remove' => 'Enlever',
	'sf_formedit_addanother' => 'Ajouter une autre',
	'sf_formedit_none' => 'Aucune',
	'runquery' => 'Exécuter la requête',
	'sf_runquery_badurl' => 'Vous devez spécifier un nom de formulaire dans l’URL ;
quelque chose comme « Special:RunQuery/&lt;nom du formulaire&gt; ».',
	'sf_runquery_title' => 'Exécuter la requête : $1',
	'sf_runquery_additionalquery' => 'Requête additionnelle',
	'sf_formerrors_header' => 'Il y a certaines erreurs dans le formulaire. Cf. ci-dessous.',
	'sf_blank_error' => 'ne peut pas être blanc',
	'sf_bad_url_error' => 'doit avoir un format URL correct, commençant par « http »',
	'sf_bad_email_error' => 'doit avoir un format correct d’adresse courriel.',
	'sf_bad_number_error' => 'doit être un nombre valide',
	'sf_bad_integer_error' => 'doit être un nombre entier valide',
	'sf_bad_date_error' => 'doit être une date valide',
	'uploadwindow' => 'Téléverser (importer) la fenêtre',
	'sf_deletionlog' => 'Historique des suppressions',
	'sf_property_isproperty' => 'Cette propriété est de type $1.',
	'sf_property_linkstoform' => 'Elle pointe sur les pages utilisant le formulaire $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|La valeur autorisée pour cette propriété est|Les valeurs autorisées pour cette propriété sont}} :',
	'sf_template_docu' => 'Ceci est le modèle « $1 ». Il devrait être appelé selon le format suivant :',
	'sf_template_docufooter' => 'Modifier la page pour voir le texte du modèle.',
	'sf_form_docu' => 'Ceci est le formulaire « $1 ».
Pour créer une page avec ce formulaire, entrez le nom de la page ci-dessous ;
si une page avec ce nom existe déjà, vous serez dirigé vers un formulaire pour l’éditer.',
	'sf_form_freetextlabel' => 'Texte libre',
	'sf_category_hasdefaultform' => 'Cette catégorie utilise le formulaire « $1 ».',
	'sf_category_desc' => 'Ceci est la catégorie « $1 ».',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Voir l’onglet « modifier » pour les pages modifiables via un formulaire',
	'right-editrestrictedfields' => 'Modifier les champs restreints des formulaires',
);

/** Franco-Provençal (Arpetan)
 * @author Cedric31
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'sf_createtemplate_deletefield' => 'Suprimar',
	'sf_createform_add' => 'Apondre',
	'createcategory' => 'Fâre una catègorie',
	'sf_createcategory_name' => 'Nom de la catègorie :',
	'sf_formedit_edittitle' => 'Changiér $1 : $2',
);

/** Western Frisian (Frysk)
 * @author Snakesteuben
 */
$messages['fy'] = array(
	'sf_createtemplate_standardformat' => 'Standert',
	'sf_createtemplate_deletefield' => 'Wiskje',
	'sf_createform_inputtypedefault' => '(standert)',
	'sf_createform_add' => 'Tafoegje',
	'sf_formedit_none' => 'Gjin',
);

/** Galician (Galego)
 * @author Alma
 * @author Toliño
 * @author Xosé
 */
$messages['gl'] = array(
	'semanticforms-desc' => 'Formularios para engadir e editar datos semánticos',
	'specialpages-group-sf_group' => 'Formularios semánticos',
	'createproperty' => 'Crear unha propiedade',
	'sf_createproperty_linktoform' => 'Esta propiedade ligará ás páxinas que usan o formulario:',
	'sf_createproperty_allowedvalsinput' => 'Se quere que esta propiedade só teña permitidos determinados valores, introduza a lista de valores permitidos separados por comas (se un valor contén unha coma substitúaa por "\\,"):',
	'sf_createproperty_propname' => 'Nome da propiedade:',
	'sf_createproperty_proptype' => 'Tipo:',
	'templates' => 'Modelos',
	'sf_templates_docu' => 'Os seguintes modelos existen neste wiki.',
	'sf_templates_definescat' => 'defina a categoría:',
	'createtemplate' => 'Crear un modelo',
	'sf_createtemplate_namelabel' => 'Nome do modelo:',
	'sf_createtemplate_categorylabel' => 'Categoría definida polo modelo (opcional):',
	'sf_createtemplate_templatefields' => 'Modelo dos campos',
	'sf_createtemplate_fieldsdesc' => 'Para facer que os campos deste modelo non requiran xa nomes de campo, simplemente introduza o índice de cada campo (p. ex. 1, 2, 3, etc.) como nome, no canto dun nome real.',
	'sf_createtemplate_fieldname' => 'Nome do Campo:',
	'sf_createtemplate_displaylabel' => 'Mostrar etiqueta:',
	'sf_createtemplate_semanticproperty' => 'Propiedade semántica:',
	'sf_createtemplate_fieldislist' => 'Este campo pode conter unha lista de valores separados por vírgulas',
	'sf_createtemplate_aggregation' => 'Agregación',
	'sf_createtemplate_aggregationdesc' => 'Para listar, en calquera páxina que use este modelo, todas as páxinas que teñen unha propiedade determinada que apunte cara a ela, especifique a propiedade apropiada a continuación:',
	'sf_createtemplate_aggregationlabel' => 'Título para a lista:',
	'sf_createtemplate_outputformat' => 'Formato de saída:',
	'sf_createtemplate_standardformat' => 'Estándar',
	'sf_createtemplate_infoboxformat' => 'Caixa de información da dereita',
	'sf_createtemplate_addfield' => 'Engadir campo',
	'sf_createtemplate_deletefield' => 'Eliminar',
	'sf_createtemplate_addtemplatebeforesave' => 'Ten que engadir un modelo polo menos a este formulario antes de podelo gardar.',
	'forms' => 'Formularios',
	'sf_forms_docu' => 'Os seguintes formularios existen neste wiki.',
	'createform' => 'Crear un formulario',
	'sf_createform_nameinput' => 'Nome do formulario',
	'sf_createform_nameinputdesc' => '(por convención, dáselle o nome segundo o modelo principal ao que achega os datos):',
	'sf_createform_template' => 'Modelo:',
	'sf_createform_templatelabelinput' => 'Etiqueta do modelo (opcional):',
	'sf_createform_allowmultiple' => 'Permitir un número múltiple (ou cero) deste modelo na páxina creada',
	'sf_createform_field' => 'Campo:',
	'sf_createform_fieldprop' => 'Este campo define a propiedade $1, de clase $2.',
	'sf_createform_fieldproplist' => 'Este campo define unha lista dos elementos que teñen a propiedade $1, da clase $2.',
	'sf_createform_fieldpropunknowntype' => 'Este campo define a propiedade $1, de clase non especificada.',
	'sf_createform_inputtype' => 'Tipo de entrada:',
	'sf_createform_inputtypedefault' => '(por omisión)',
	'sf_createform_formlabel' => 'Etiqueta de formulario:',
	'sf_createform_hidden' => 'Agochado',
	'sf_createform_restricted' => 'Restrinxido (só usuarios administradores poden modificalo)',
	'sf_createform_mandatory' => 'Obrigatorio',
	'sf_createform_removetemplate' => 'Eliminar modelo',
	'sf_createform_addtemplate' => 'Engadir modelo:',
	'sf_createform_beforetemplate' => 'Antes do modelo:',
	'sf_createform_atend' => 'Ao final',
	'sf_createform_add' => 'Engadir',
	'sf_createform_choosefield' => 'Elixa un campo para engadir',
	'createcategory' => 'Crear unha categoría:',
	'sf_createcategory_name' => 'Nome da categoría:',
	'sf_createcategory_defaultform' => 'Formulario predefinido:',
	'sf_createcategory_makesubcategory' => 'Facer unha subcategoría doutra categoría (opcional):',
	'createclass' => 'Creae unha clase',
	'sf_createclass_docu' => 'Insira todos os datos aquí para crear as propiedades, o modelo, o formulario e a categoría para unha única clase. Para máis opcións, use as páxinas $1 no canto desta.',
	'sf_createclass_allowedvalues' => 'Valores permitidos',
	'sf_createclass_listofvalues' => 'Lista de valores',
	'sf_createclass_leavefieldblank' => 'Se o nome do campo é o mesmo có nome da propiedade, pode deixalo en branco.',
	'sf_createclass_missingvalues' => 'Non todos os campos obrigatorios foron enchidos.',
	'sf_createclass_success' => 'As propiedades, o modelo, o formulario e a categoría serán creados.',
	'formstart' => 'Engadir unha páxina con formulario',
	'sf_formstart_badform' => 'Erro: non se atopou unha páxina de formulario en $1',
	'sf_formstart_badtitle' => 'Erro: "$1" é un título incorrecto para unha páxina.',
	'sf_formstart_docu' => 'Introduza aquí o nome da páxina que se editará co formulario "$1". Se esta páxina xa existise, enviaráselle ao formulario para editar esa páxina. De non ser así, enviaráselle ao formulario para engadir a páxina.',
	'sf_formstart_noform_docu' => 'Introduza aquí o nome da páxina e escolla o formulario co que a quere editar. Se esta páxina xa existise, enviaráselle ao formulario para editar esa páxina. De non ser así, enviaráselle ao formulario para engadir a páxina.',
	'sf_formstart_createoredit' => 'Crear ou editar',
	'formedit' => 'Editar con formulario',
	'sf_formedit_createtitle' => 'Crear $1: $2',
	'sf_formedit_badurl' => 'Esta é a páxina para editar cun formulario. Ten que especificar un nome de formulario e unha páxina de destino no URL;
debería ser algo así como "Special:FormEdit?form=&lt;nome do formulario&gt;&target=&lt;páxina de destino&gt;" ou  "Special:FormEdit/&lt;nome do formulario&gt;/&lt;páxina de destino&gt;".',
	'sf_formedit_altforms' => 'Vostede pode engadir esta páxina cun dos seguintes formularios:',
	'sf_formedit_altformsonly' => 'Seleccione un dos seguintes formularios para engadir esta páxina:',
	'sf_formcreate' => 'Crear cun formulario',
	'sf_viewform' => 'Ver o formulario',
	'sf_editsource' => 'Editar orixe',
	'sf_formedit_edittitle' => 'Editar $1: $2',
	'sf_formedit_morethanoneform' => "'''Aviso:''' hai máis dun formulario definido por defecto para esta páxina.",
	'sf_formedit_formwarning' => 'Aviso: esta páxina <a href="$1">xa existe</a>, pero non usa este formulario.',
	'sf_formedit_remove' => 'Eliminar',
	'sf_formedit_addanother' => 'Engadir outro',
	'sf_formedit_none' => 'Ningún',
	'runquery' => 'Executar a pescuda',
	'sf_runquery_badurl' => 'Debe especificar un nome de formulario no enderezo URL;
o URL debe ser do tipo "Special:RunQuery/&lt;nome do formulario&gt;".',
	'sf_runquery_title' => 'Executar a pescuda: $1',
	'sf_runquery_additionalquery' => 'Pescuda adicional',
	'sf_formerrors_header' => 'Producíronse erros na entrada do seu formulario; vexa máis abaixo',
	'sf_blank_error' => 'non poden estar en blanco',
	'sf_bad_url_error' => "debe ter un correcto formato URL, comezando con 'http'",
	'sf_bad_email_error' => 'debe ter un enderezo de correo electrónico cun formato válido',
	'sf_bad_number_error' => 'debe ser un número válido',
	'sf_bad_integer_error' => 'ha de ser un enteiro válido',
	'sf_bad_date_error' => 'debe ser unha data válida',
	'uploadwindow' => 'Cargar unha ventá',
	'sf_deletionlog' => 'Rexistro de borrados',
	'sf_property_isproperty' => 'Esta é unha propiedade de clase $1.',
	'sf_property_linkstoform' => 'Liga con páxinas que usan o formulario $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|O valor permitido|Os valores permitidos}} para esta propiedade {{PLURAL:$1|é|son}}:',
	'sf_template_docu' => "Este é o modelo '$1'. Pode ser chamado no seguinte formato:",
	'sf_template_docufooter' => 'Editar a páxina para ver o modelo de texto.',
	'sf_form_docu' => 'Este é o formulario "$1".
Para crear unha páxina con este formulario, introduza o nome da páxina a continuación;
se xa existe unha páxina con ese nome enviaráselle a un formulario para editar esa páxina.',
	'sf_form_freetextlabel' => 'Texto libre',
	'sf_category_hasdefaultform' => 'Esta categoría usa o formulario $1.',
	'sf_category_desc' => 'Esta é a categoría $1.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Ver a lapela "Editar" nas páxinas editables por formularios',
	'right-editrestrictedfields' => 'Editar os campos restrinxidos dos formularios',
);

/** Gothic (Gothic)
 * @author Crazymadlover
 * @author Jocke Pirat
 * @author Omnipaedista
 */
$messages['got'] = array(
	'sf_createtemplate_deletefield' => 'Taíran',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Crazymadlover
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'specialpages-group-sf_group' => 'Σημασιολογικοὶ Τύποι',
	'createproperty' => 'Ποιεῖν ἰδιότητα τινά',
	'sf_createproperty_propname' => 'Ὄνομα ἰδιότητος:',
	'sf_createproperty_proptype' => 'Τύπος:',
	'templates' => 'Πρότυπα',
	'sf_templates_definescat' => 'ὁρίζει κατηγορίαν:',
	'createtemplate' => 'Ποιεῖν πρότυπόν τι',
	'sf_createtemplate_namelabel' => 'Ὄνομα προτύπου:',
	'sf_createtemplate_fieldname' => 'Ὄνομα πεδίου:',
	'sf_createtemplate_addfield' => 'Προστιθέναι πεδίον',
	'sf_createtemplate_deletefield' => 'Σβεννύναι',
	'forms' => 'Τύποι',
	'createform' => 'Ποιεῖν τύπον τινά',
	'sf_createform_template' => 'Πρότυπον:',
	'sf_createform_field' => 'Πεδίον:',
	'sf_createform_inputtypedefault' => '(προκαθωρισμένη)',
	'sf_createform_hidden' => 'Κεκρυμμένη',
	'sf_createform_mandatory' => 'Ὑποχρεωτικόν',
	'sf_createform_add' => 'Προστιθέναι',
	'sf_createcategory_name' => 'Ὄνομα κατηγορίας:',
	'sf_formstart_createoredit' => 'Ποιεῖν ἢ μεταγράφειν',
	'sf_formedit_createtitle' => 'Ποιεῖν $1: $2',
	'sf_viewform' => 'Ὁρᾶν τύπον',
	'sf_editsource' => 'Μεταγράφειν πηγήν',
	'sf_formedit_edittitle' => 'Μεταγράφειν $1: $2',
	'sf_formedit_remove' => 'Άφαιρεῖν',
	'sf_formedit_none' => 'Οὐδέν',
	'runquery' => 'Ἐκτελεῖν πεῦσιν',
	'sf_runquery_title' => 'Ἐκτελεῖν πεῦσιν: $1',
	'uploadwindow' => 'Ἐπιφορτίζειν θυρίδα',
	'sf_form_freetextlabel' => 'Ἐλεύθερον κείμενον',
	'sf_blank_namespace' => 'Κύριον',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'semanticforms-desc' => 'Formular fir s Yyfiege un Bearbeite vu semantische Date',
	'specialpages-group-sf_group' => 'Semantischi Formular',
	'createproperty' => 'E Attribut aalege',
	'sf_createproperty_linktoform' => 'Die Eigeschaft vergleicht zue Syte, wu des Format bruuche:',
	'sf_createproperty_allowedvalsinput' => 'Wänn Du fir des Fäld nume bstimmti Wärt witt megli mache, gib die bitte as kommatrännti Lischt yy (wänn s in eme Wärt e Komma het, ersetz des mit „\\,“):',
	'sf_createproperty_propname' => 'Eigeschaftsname:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Vorlage',
	'sf_templates_docu' => 'Die Vorlage git s uf {{SITENAME}}.',
	'sf_templates_definescat' => 'definiert Kategorii:',
	'createtemplate' => 'E Vorlag aalege',
	'sf_createtemplate_namelabel' => 'Vorlagename:',
	'sf_createtemplate_categorylabel' => 'Dur Vorlag definierti Kategorii (optional):',
	'sf_createtemplate_templatefields' => 'Vorlagefälder',
	'sf_createtemplate_fieldsdesc' => 'Wänn e Fäld vum ere Vorlag kei Feldname meh bruucht, gib eifach statt eme ächte Name d Indexnummere vum Fäld as Name yy (z. B. 1, 2, 3 usw.).',
	'sf_createtemplate_fieldname' => 'Fäldname:',
	'sf_createtemplate_displaylabel' => 'Fäldname aazeige:',
	'sf_createtemplate_semanticproperty' => 'Semantisch Attribut:',
	'sf_createtemplate_fieldislist' => 'In däm Fäld cha s e Lischt vu Wärt haa, wu dur Komma trännt wäre.',
	'sf_createtemplate_aggregation' => 'Zämmefassig',
	'sf_createtemplate_aggregationdesc' => 'Zum uf allene Syte, wu die Vorlag bruuche, alli Syte ufzlischte, wu ne bstimmt Attribut hän un uf die Syte vergleicht sin, gib s gwinscht Attribut do aa:',
	'sf_createtemplate_aggregationlabel' => 'Titel fir Lischt:',
	'sf_createtemplate_outputformat' => 'Uusgabformat:',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_infoboxformat' => 'Infobox uf dr rächte Syte',
	'sf_createtemplate_addfield' => 'Fieg Fäld yy',
	'sf_createtemplate_deletefield' => 'Lesche',
	'sf_createtemplate_addtemplatebeforesave' => 'Du muesch zmindescht ei Vorlag zue däm Formular zuefiege, voreb Du s cha spychere.',
	'forms' => 'Formular',
	'sf_forms_docu' => 'Die Formular git s in {{SITENAME}}:',
	'createform' => 'Leg e Formular aa',
	'sf_createform_nameinput' => 'Formularname',
	'sf_createform_nameinputdesc' => '(no dr Konvention wird e Formular no dr Hauptvorlag gnännt, wu s fillt):',
	'sf_createform_template' => 'Vorlag:',
	'sf_createform_templatelabelinput' => 'Vorlagename (optional):',
	'sf_createform_allowmultiple' => 'Erlaub mehreri (oder null) Instanze vu däre Vorlag in dr aagleite Syte',
	'sf_createform_field' => 'Fäld:',
	'sf_createform_fieldprop' => 'Des Fäld definiert s Attribut $1 vum Typ $2.',
	'sf_createform_fieldproplist' => 'Des Fäld definiert e Lischt vu Elemänt, wu s Attribut $1 vum Typ $2 hän.',
	'sf_createform_fieldpropunknowntype' => 'Des Fäld definiert d Eigeschaft $1 mit eme nit spezifizierte Typ.',
	'sf_createform_inputtype' => 'Gib dr Typ yy:',
	'sf_createform_inputtypedefault' => '(Standardwärt)',
	'sf_createform_formlabel' => 'Formularname:',
	'sf_createform_hidden' => 'Versteckt',
	'sf_createform_restricted' => 'Gsperrt (nume Ammanne chenne ebis ändere)',
	'sf_createform_mandatory' => 'Pflichtfäld',
	'sf_createform_removetemplate' => 'Vorlag useneh',
	'sf_createform_addtemplate' => 'Vorlag zuefiege:',
	'sf_createform_beforetemplate' => 'Vor Vorlag:',
	'sf_createform_atend' => 'Am Änd',
	'sf_createform_add' => 'Zuefiege',
	'sf_createform_choosefield' => 'Wehl e Fäld uus, wu Du iwtt zuefiege',
	'createcategory' => 'E Kategorii aalege',
	'sf_createcategory_name' => 'Kategoriename:',
	'sf_createcategory_defaultform' => 'Standardformular:',
	'sf_createcategory_makesubcategory' => 'Mach die Kategorii zuen ere Subkategorii vun ere andere Kategorii (optional):',
	'createclass' => 'E Klasse aalege',
	'sf_createclass_docu' => 'Gib do alli Date yy go d Eigeschafte, e Vorlag, e Formular un e Kategorii fir e einzelni Klasse aalege. Fir meh Megligkeite verwänd stattdem d Syte $1.',
	'sf_createclass_allowedvalues' => 'Erlaubti Wärt',
	'sf_createclass_listofvalues' => 'Lischt vu Wärt',
	'sf_createclass_leavefieldblank' => 'Wänn dr Fäldname dr nämlig isch wie dr Eigeschaftsname, chasch s läär loo.',
	'sf_createclass_missingvalues' => 'S sin nonig alli erforderlige Fälder uusgfillt.',
	'sf_createclass_success' => 'Eigeschafte, Vorlag, Formular und Kategorii wäre aagleit.',
	'formstart' => 'Syte mit Formular zuefiege',
	'sf_formstart_badform' => 'Fähler: s isch kei Syte gfunde wore bi $1',
	'sf_formstart_badtitle' => "Fähler: '$1' isch kei giltige Titel fir e Syte.",
	'sf_formstart_docu' => 'Gib in des Täxtfäld dr Name vu dr Syte yy, wu mit em Formular „$1“ soll bearbeitet wäre. Wänn s scho ne Syte mit däm Name het, wirsch zuen eme Formular wytergleitet, wu Du die Syte chasch mit bearbeite. Suscht wirsch zuen eme Formular wytergleitet, wu Du die Syte chasch mit aalege.',
	'sf_formstart_noform_docu' => 'Gib in des Täxtfäld dr Name vu dr Syte yy un wehl s Formular, wu d Syte mit soll bearbeitet wäre. Wänn s scho ne Syte mit däm Name het, wirsch zuen eme Formular wytergleitet, wu Du die Syte chasch mit bearbeite. Suscht wirsch zuen eme Formular wytergleitet, wu Du die Syte chasch mit aalege.',
	'sf_formstart_createoredit' => 'Aalege oder Bearbeite',
	'formedit' => 'mit Formular bearbeite',
	'sf_formedit_createtitle' => 'Leg $1: $2 aa',
	'sf_formedit_badurl' => 'Des isch d Syte zum Bearbeite mit eme Formular. Du muesch dr Name vun eme Formulars un d Ziilsyte, wu soll bearbeitet wäre, in dr URL aagee. S sott uussäh wie „Special:FormEdit?form=&lt;Formularname&gt;&target=&lt;Ziilsyte&gt;“ oder „Special:FormEdit/&lt;Formularname&gt;/&lt;Ziilsyte&gt;“.',
	'sf_formedit_altforms' => 'Du chasch die Syte au mit eim vu däne Formular aalege:',
	'sf_formedit_altformsonly' => 'Bitte wehl eis vu däne Formular uus go die Syte aalege:',
	'sf_formcreate' => 'Mit Formular aalege',
	'sf_viewform' => 'Formular aazeige',
	'sf_editsource' => 'Quälltäxt bearbeite',
	'sf_formedit_edittitle' => 'Bearbeit $1: $2',
	'sf_formedit_morethanoneform' => 'Warnig: s isch meh wie ei Standardformular definiert fir die Syte.',
	'sf_formedit_formwarning' => 'Warnig: Die Syte <a href="$1">git s scho</a>, aber si bruucht nit des Formular.',
	'sf_formedit_remove' => 'Useneh',
	'sf_formedit_addanother' => 'Wyteri zuefiege',
	'sf_formedit_none' => 'Keini',
	'runquery' => 'Abfrog starte',
	'sf_runquery_badurl' => "Du muesch e Formularname aagee in dr URL;
d URL sott eso ussäh 'Special:RunQuery/&lt;Formularname&gt;'.",
	'sf_runquery_title' => 'Abfrog starte: $1',
	'sf_runquery_additionalquery' => 'Zuesätzligi Abfrog',
	'sf_formerrors_header' => 'Dyy Yygab isch fählerhaft; fir meh lueg unte',
	'sf_blank_error' => 'derf nit läär syy',
	'sf_bad_url_error' => 'muess s richtig URL-Format haa, wu aafangt mit „http://“',
	'sf_bad_email_error' => 'muess e giltig E-Mail-Adrässformat haa',
	'sf_bad_number_error' => 'muess e giltigi Zahl syy',
	'sf_bad_integer_error' => 'muess e giltigi Ganzzahl syy',
	'sf_bad_date_error' => 'muess e giltig Datum syy',
	'uploadwindow' => 'Fänschter zum Uffelade',
	'sf_deletionlog' => 'Leschlogbuech',
	'sf_property_isproperty' => 'Des isch e Eigeschaft vum Typ $1.',
	'sf_property_linkstoform' => 'Vergleicht zue Syte, wu s Format $1 bruuche.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Dr erlaubt Wärt fir die Eigeschaft isch|Di erlaubte Wärt fir die Eigeschaft sin}}:',
	'sf_template_docu' => 'Des isch d Vorlag fir „$1“. Si sott in däm Format ufgruefe wäre:',
	'sf_template_docufooter' => 'Die Syte bearbeite go dr Vorlagetäxt säh.',
	'sf_form_docu' => 'Des isch s „$1“-Formular.
Go ne Syte aalege mit däm Formular, gib dr Sytename unte yy.
Wänn s scho ne Syte mit däm Name het, wirsch zuen eme Formular wytergleitet, wu Du die Syte chasch aalege mit.',
	'sf_form_freetextlabel' => 'Frejtäxt',
	'sf_category_hasdefaultform' => 'Die Kategorii bruucht s Formular $1.',
	'sf_category_desc' => 'Des isch d Kategorii $1.',
	'sf_blank_namespace' => 'Hauptsyte',
	'right-viewedittab' => 'D "Bearbeite"-Regischtercharte fir bearbeitbari Syte no Format aaluege',
	'right-editrestrictedfields' => 'Yygschränkti Formatfälde bearbeite',
);

/** Gujarati (ગુજરાતી)
 * @author Dsvyas
 */
$messages['gu'] = array(
	'sf_createform_hidden' => 'છદ્મ',
	'sf_createform_restricted' => 'સંરક્ષિત (ફક્ત પ્રબંધકો જ ફેરફાર કરી શકે છે)',
	'sf_createform_mandatory' => 'ફરજિયાત',
	'sf_createform_removetemplate' => 'ઢાંચો દૂર કરો',
	'sf_createform_addtemplate' => 'ઢાંચો ઉમેરો:',
	'sf_createform_beforetemplate' => 'ઢાંચા પહેલા:',
	'sf_createform_atend' => 'અંતમાં',
	'sf_createform_add' => 'ઉમેરો',
	'createcategory' => 'શ્રેણીની રચના કરો',
	'sf_createcategory_name' => 'નામ',
	'sf_createcategory_makesubcategory' => 'આને અન્ય શ્રેણીની ઉપશ્રેણી બનાવો (વૈકલ્પિક):',
	'formstart' => 'ફોર્મ વાળું પાનું ઉમેરો',
	'sf_blank_namespace' => 'મુખ્ય',
);

/** Manx (Gaelg)
 * @author MacTire02
 */
$messages['gv'] = array(
	'sf_createproperty_propname' => 'Ennym:',
	'sf_createtemplate_deletefield' => 'Scryss',
	'createcategory' => 'Croo ronney',
	'sf_createcategory_name' => 'Ennym:',
);

/** Hakka (Hak-kâ-fa)
 * @author Hakka
 */
$messages['hak'] = array(
	'sf_createtemplate_deletefield' => 'Chhù-thet',
);

/** Hawaiian (Hawai`i)
 * @author Kalani
 * @author Singularity
 */
$messages['haw'] = array(
	'sf_createproperty_propname' => 'Inoa:',
	'sf_createform_inputtypedefault' => '(paʻamau)',
	'sf_createform_add' => 'Ho‘ohui',
	'sf_createcategory_name' => 'Inoa:',
	'sf_formedit_remove' => 'Kāpae',
);

/** Hebrew (עברית)
 * @author Rotemliss
 * @author Yaron Koren
 * @author YaronSh
 */
$messages['he'] = array(
	'semanticforms-desc' => 'טפסים להוספת ולעריכת נתונים סמנטיים',
	'specialpages-group-sf_group' => 'טפסים סמנטיים',
	'createproperty' => 'יצירת מאפיין',
	'sf_createproperty_linktoform' => 'מאפיין זה יקשר לדפים המשתמשים בטופס:',
	'sf_createproperty_allowedvalsinput' => 'אם ברצונכם שלמאפיין זה יהיו רק כמה ערכים מורשים, הזינו את רשימת הערכים המורשים, מופרדים בפסיקים (אם ערך כלשהו מכיל פסיק, החליפו אותו ב־"\\,"):',
	'sf_createproperty_propname' => 'שם המאפיין:',
	'sf_createproperty_proptype' => 'סוג:',
	'templates' => 'תבניות',
	'sf_templates_docu' => 'התבניות הבאות קיימות בוויקי הזה.',
	'sf_templates_definescat' => 'מגדיר את הקטגוריה:',
	'createtemplate' => 'צור תבנית',
	'sf_createtemplate_namelabel' => 'שם התבנית:',
	'sf_createtemplate_categorylabel' => 'קטגוריה מוגדרת על ידי תבנית ():',
	'sf_createtemplate_templatefields' => 'שדות התבנית',
	'sf_createtemplate_fieldsdesc' => 'כדי ששדות התבנית לא יצטרכו שמות, פשוט הכנס את האינדקס של השדה (1, 2, 3...) במקום שם אמיתי.',
	'sf_createtemplate_fieldname' => 'שם השדה:',
	'sf_createtemplate_displaylabel' => 'תוית תצוגה:',
	'sf_createtemplate_semanticproperty' => 'זה השדה הסמנטי:',
	'sf_createtemplate_fieldislist' => 'השדה יכול להכיל רשימת ערכים, המופרדים בפסיקים',
	'sf_createtemplate_aggregation' => 'מצבור',
	'sf_createtemplate_aggregationdesc' => 'כדי להציג בכל דף המשתמש בתבנית זו את כל הדפים המכילים מאפיין מסוים המצביע לדף זה, ציינו את המאפיין המתאים להלן:',
	'sf_createtemplate_aggregationlabel' => 'כותרת לרשימה:',
	'sf_createtemplate_outputformat' => 'מבנה הפלט:',
	'sf_createtemplate_standardformat' => 'תקני',
	'sf_createtemplate_infoboxformat' => 'תיבת מידע מצד שמאל',
	'sf_createtemplate_addfield' => 'הוספת שדה',
	'sf_createtemplate_deletefield' => 'מחיקה',
	'sf_createtemplate_addtemplatebeforesave' => 'עליכם להוסיף לפחות תבנית אחת לטופס זה לפני שתוכלו לשמור אותו.',
	'forms' => 'טפסים',
	'sf_forms_docu' => 'הטפסים הבאים קיימים בוויקי הזה.',
	'createform' => 'יצירת טופס',
	'sf_createform_nameinput' => 'שם הטופס',
	'sf_createform_nameinputdesc' => '(מקובל לתת לטופס שם בהתאם לשם התבנית העיקרית שהוא מגדיר):',
	'sf_createform_template' => 'תבנית:',
	'sf_createform_templatelabelinput' => 'תוית לתבנית (אופציונלי):',
	'sf_createform_allowmultiple' => ' הרשה כפילויות (או אפס) מהתבנית הזאת בדף המיוצר',
	'sf_createform_field' => 'שדה:',
	'sf_createform_fieldprop' => 'שדה זה מגדיר את המאפיין $1, מסוג $2.',
	'sf_createform_fieldproplist' => 'שדה זה מגדיר את רשימת הרכיבים שיש להם את המאפיין $1, מסוג $2.',
	'sf_createform_fieldpropunknowntype' => 'שדה זה מגדיר את המאפיין $1, מסוג לא מוגדר.',
	'sf_createform_inputtype' => 'סוג הקלט:',
	'sf_createform_inputtypedefault' => '(ברירת מחדל)',
	'sf_createform_formlabel' => 'תוית בטופס:',
	'sf_createform_hidden' => 'מוסתר',
	'sf_createform_restricted' => 'מוגבל (רק מפעילי מערכת יכולים לשנות זאת)',
	'sf_createform_mandatory' => 'הכרחי',
	'sf_createform_removetemplate' => 'הסרת תבנית',
	'sf_createform_addtemplate' => 'הוספת תבנית:',
	'sf_createform_beforetemplate' => 'לפני התבנית:',
	'sf_createform_atend' => 'בסוף',
	'sf_createform_add' => 'הוספה',
	'sf_createform_choosefield' => 'בחרו שדה להוספה',
	'createcategory' => 'יצירת קטגוריה',
	'sf_createcategory_name' => 'שם הקטגוריה:',
	'sf_createcategory_defaultform' => 'טופס ברירת המחדל:',
	'sf_createcategory_makesubcategory' => 'הפיכת קטגוריה זו לקטגוריית משנה של קטגוריה אחרת (אופציונלי):',
	'createclass' => 'יצירת מחלקה',
	'sf_createclass_docu' => 'כתבו כאן את כל המידע ליצירת המאפיינים, התבנית, הטופס והקטגוריה עבור מחלקה בודדת. לאפשרויות נוספות, השתמשו בדפים $1 במקום זאת.',
	'sf_createclass_allowedvalues' => 'ערכים מורשים',
	'sf_createclass_listofvalues' => 'רשימת ערכים',
	'sf_createclass_leavefieldblank' => 'אם שם השדה זהה לשם המאפיין, ניתן להותירו ריק.',
	'sf_createclass_missingvalues' => 'לא כל השדות הנדרשים מולאו.',
	'sf_createclass_success' => 'יווצרו מאפיינים, תבנית, טופס וקטגוריה.',
	'formstart' => 'הוספת דף עם טופס',
	'sf_formstart_badform' => 'שגיאה: לא נמצא דף טופס ב־$1',
	'sf_formstart_badtitle' => 'שגיאה: "$1" היא כותרת דף בלתי תקינה.',
	'sf_formstart_docu' => "כתבו כאן את שם הדף, שייערך באמצעות הטופס '$1'.
אם דף זה כבר קיים, תועברו אל הטופס לעריכת אותו הדף.
אחרת, תועברו אל הטופס להוספת הדף.",
	'sf_formstart_noform_docu' => 'כתבו כאן את שם הדף, ובחרו את הטופס באמצעותו תבוצע עריכת הדף.
אם דף זה כבר קיים, תועברו אל הטופס לעריכת אותו הדף.
אחרת, תועברו אל הטופס להוספת הדף.',
	'sf_formstart_createoredit' => 'הוספה או עריכה',
	'formedit' => 'עריכה באמצעות טופס',
	'sf_formedit_createtitle' => 'הוספת $1: $2',
	'sf_formedit_badurl' => "דף זה משמש להוספת נתונים. עליכם לפרט גם את שם הטופס וגם את כתובת דף היעד; התוצאה אמורה להראות כך: 'Special:FormEdit?form=&lt;form name&gt;&target=&lt;target page&gt;', או כך - 'Special:FormEdit/&lt;form name&gt;/&lt;target page&gt;'.",
	'sf_formedit_altforms' => 'במקום זאת תוכלו להוסיף דף זה באמצעות אחד מהטפסים הבאים:',
	'sf_formedit_altformsonly' => 'אנא בחרו מאחד הטפסים הבאים להוספת דף זה:',
	'sf_formcreate' => 'יצירה עם טופס',
	'sf_viewform' => 'הצגת הטופס',
	'sf_editsource' => 'עריכת מקור',
	'sf_formedit_edittitle' => 'עריכת $1: $2',
	'sf_formedit_morethanoneform' => "'''אזהרה:''' יותר מטופס ברירת מחדל אחד מוגדר לדף זה.",
	'sf_formedit_formwarning' => 'אזהרה: דף זה <a href="$1">כבר קיים</a>, אך אינו משתמש בטופס זה.',
	'sf_formedit_remove' => 'הסרה',
	'sf_formedit_addanother' => 'הוספת עוד',
	'sf_formedit_none' => 'לא כלום',
	'runquery' => 'הרצת שאילתה',
	'sf_runquery_badurl' => "יש לציין את שם הטופס בכתובת;
על הכתובת להיות מהצורה 'Special:RunQuery/&lt;שם הטופס&gt;'.",
	'sf_runquery_title' => 'הרצת שאילתה: $1',
	'sf_runquery_additionalquery' => 'שאילתה נוספת',
	'sf_formerrors_header' => 'אירעו שגיאות בקלט הטופס שלכם; עיינו להלן',
	'sf_blank_error' => 'אין להותיר ריק',
	'sf_bad_url_error' => "עליו להיות במבנה כתובת תקין, המתחיל ב־'http'",
	'sf_bad_email_error' => 'עליו להיות במבנה תקין של כתובת דוא"ל',
	'sf_bad_number_error' => 'עליו להיות מספר תקין',
	'sf_bad_integer_error' => 'עליו להיות מספר שלם תקין',
	'sf_bad_date_error' => 'עליו להיות תאריך תקין',
	'uploadwindow' => 'חלון ההעלאה',
	'sf_deletionlog' => 'יומן מחיקות',
	'sf_property_isproperty' => 'זהו מאפיין מסוג $1.',
	'sf_property_linkstoform' => 'מקשר לדפים המשתמשים בטופס $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|הערך האפשרי למאפיין זה הוא|הערכים האפשריים למאפיין זה הם}}:',
	'sf_template_docu' => "זוהי התבנית '$1'.
שמה צריך להיות במבנה הבא:",
	'sf_template_docufooter' => 'ערכו את הדף כדי לצפות בטקסט התבנית.',
	'sf_form_docu' => "זהו הטופס '$1'.
על מנת להוסיף דף עם טופס זה, כתבו את שם הדף להלן;
אם דף בשם זה כבר קיים, תועברו אל טופס לעריכת הדף.",
	'sf_form_freetextlabel' => 'טקסט חופשי',
	'sf_category_hasdefaultform' => 'קטגוריה זו משתמשת בטופס $1.',
	'sf_category_desc' => 'זוהי הקטגוריה $1.',
	'sf_blank_namespace' => 'ראשי',
	'right-viewedittab' => 'צפייה בלשונית "עריכה" של דפים הניתנים לעריכה על ידי טופס',
	'right-editrestrictedfields' => 'עריכת שדות טופס מוגבלים',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 */
$messages['hi'] = array(
	'createproperty' => 'एक गुणधर्म बनायें',
	'sf_createproperty_propname' => 'नाम:',
	'sf_createproperty_proptype' => 'प्रकार:',
	'templates' => 'साँचे',
	'sf_templates_definescat' => 'श्रेणीकी व्याख्या:',
	'createtemplate' => 'साँचा बनायें',
	'sf_createtemplate_namelabel' => 'साँचा का नाम:',
	'sf_createtemplate_templatefields' => 'साँचा के फ़िल्ड',
	'sf_createtemplate_fieldname' => 'फ़िल्ड नाम:',
	'sf_createtemplate_displaylabel' => 'दर्शाने का लेबल:',
	'sf_createtemplate_semanticproperty' => 'सिमँटिक गुणधर्म:',
	'sf_createtemplate_aggregation' => 'एग्रिगेशन',
	'sf_createtemplate_aggregationlabel' => 'सूची शीर्षक:',
	'sf_createtemplate_outputformat' => 'आउटपुट रूपरेखा:',
	'sf_createtemplate_standardformat' => 'स्टँडर्ड',
	'sf_createtemplate_infoboxformat' => 'दाईंऔर ज़ानकारी सन्दूक',
	'sf_createtemplate_addfield' => 'फ़िल्ड बढायें',
	'sf_createtemplate_deletefield' => 'हटायें',
	'forms' => 'फ़ार्म',
	'createform' => 'फ़ार्म बनायें',
	'sf_createform_template' => 'साँचा:',
	'sf_createform_templatelabelinput' => 'साँचा लेबल (वैकल्पिक):',
	'sf_createform_field' => 'फिल्ड़:',
	'sf_createform_inputtype' => 'इनपुट प्रकार:',
	'sf_createform_inputtypedefault' => '(डिफॉल्ट)',
	'sf_createform_formlabel' => 'फ़ार्म लेबल:',
	'sf_createform_hidden' => 'छुपाई हुई',
	'sf_createform_restricted' => 'प्रतिबंधित (सिर्फ प्रबंधक बदल सकतें हैं)',
	'sf_createform_mandatory' => 'अत्यावश्यक',
	'sf_createform_removetemplate' => 'साँचा हटायें',
	'sf_createform_addtemplate' => 'साँचा बढायें:',
	'sf_createform_beforetemplate' => 'साँचे के पहले:',
	'sf_createform_atend' => 'आखिरमें',
	'sf_createform_add' => 'बढायें',
	'sf_createform_choosefield' => 'बढाने के लिये फ़िल्ड चुनें',
	'createcategory' => 'श्रेणी बनायें',
	'sf_createcategory_name' => 'नाम:',
	'sf_createcategory_defaultform' => 'डिफ़ाल्ट फ़ार्म:',
	'formstart' => 'पन्ना बढायें',
	'sf_formstart_createoredit' => 'बढायें या बदलें',
	'formedit' => 'फ़ार्म के साथ बदलें',
	'sf_formedit_createtitle' => 'बढायें $1: $2',
	'sf_editsource' => 'स्रोत बदलें',
	'sf_formedit_edittitle' => 'बदलें $1: $2',
	'sf_formedit_remove' => 'हटायें',
	'sf_formedit_addanother' => 'दूसरा बढायें',
	'sf_formedit_none' => 'बिल्कुल नहीं',
	'sf_blank_error' => 'खाली नहीं हो सकता',
	'sf_bad_number_error' => 'एक वैध संख्या होना आवश्यक हैं',
	'sf_bad_integer_error' => 'एक वैध इंटीजर होना आवश्यक हैं',
	'sf_bad_date_error' => 'एक वैध तारीख होना आवश्यक हैं',
	'sf_property_isproperty' => 'यह $1 प्रकार का गुणधर्म हैं।',
	'sf_form_freetextlabel' => 'मुक्त पाठ',
	'sf_category_hasdefaultform' => 'यह श्रेणी फ़ार्म $1 का इस्तेमाल करती हैं।',
	'sf_category_desc' => 'यह $1 श्रेणी हैं।',
	'sf_blank_namespace' => 'मुख्य',
);

/** Hiligaynon (Ilonggo)
 * @author Jose77
 */
$messages['hil'] = array(
	'sf_createtemplate_deletefield' => 'Panason',
);

/** Croatian (Hrvatski)
 * @author Dalibor Bosits
 */
$messages['hr'] = array(
	'sf_createtemplate_deletefield' => 'Izbriši',
	'sf_formedit_remove' => 'Ukloni',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'semanticforms-desc' => 'Formulary za přidawanje a wobdźěłowanje semantiskich datow',
	'specialpages-group-sf_group' => 'Semantiske formulary',
	'createproperty' => 'Wutwor kajkosć',
	'sf_createproperty_linktoform' => 'Tuta kajkosć budźe k stronam wotkazować, kotrež formular wužiwaja:',
	'sf_createproperty_allowedvalsinput' => 'Jeli chceš, zo su jenož wěste hódnoty za tute kajkosć dowolene, zapodaj lisćinu dowolenych hódnotow, wotdźělenych přez komy (jeli hódnota komu wobsahuje, narunaj ju přez "\\,"):',
	'sf_createproperty_propname' => 'Mjeno kajkosće:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Předłohi',
	'sf_templates_docu' => 'Slědowace předłohi su we {{GRAMMAR:Lokatiw|{{SITENAME}}}}',
	'sf_templates_definescat' => 'definuje kategoriju:',
	'createtemplate' => 'Wutwor předłohu',
	'sf_createtemplate_namelabel' => 'Mjeno předłohi:',
	'sf_createtemplate_categorylabel' => 'Kategorija definowana přez předłohu (opcionalny):',
	'sf_createtemplate_templatefields' => 'Pola předłohi',
	'sf_createtemplate_fieldsdesc' => 'Jeli pola w tutej předłoze hižo nimaja polowe mjena potrjebować, zapodaj prosće indeks kóždeho pola (na př. 1, 2, 3 atd.) jako mjeno město woprawdźiteho mjena.',
	'sf_createtemplate_fieldname' => 'Polowe mjeno:',
	'sf_createtemplate_displaylabel' => 'Polowe mjeno, kotrež ma so pokazać:',
	'sf_createtemplate_semanticproperty' => 'Semantiska kajkosć:',
	'sf_createtemplate_fieldislist' => 'Tute polo móže lisćinu hódnotow wobsahować, kotrež so přez komu wotdźěleja.',
	'sf_createtemplate_aggregation' => 'Agregacija',
	'sf_createtemplate_aggregationdesc' => 'Zo by na stronje, kotraž tutu předłohu wužiwa, wšě strony nalistował, kotrež wěstu kajkosć maja a na tu stronu wotkazuja, podaj tu wotpowědnu kajkosć:',
	'sf_createtemplate_aggregationlabel' => 'Titul za lisćinu:',
	'sf_createtemplate_outputformat' => 'Wudatny format:',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_infoboxformat' => 'Naprawo zaměstnjeny infokašćik',
	'sf_createtemplate_addfield' => 'Polo přidać',
	'sf_createtemplate_deletefield' => 'Wušmórnyć',
	'sf_createtemplate_addtemplatebeforesave' => 'Dyrbiš znajmjeńša jednu předłohu k tutomu formularej přidać, prjedy hač móžeš jón składować.',
	'forms' => 'Formulary',
	'sf_forms_docu' => 'Slědowace formulary eksistuja w {{GRAMMAR:Lokatiw|{{SITENAME}}}}',
	'createform' => 'Formular wutworić',
	'sf_createform_nameinput' => 'Formularne mjeno',
	'sf_createform_nameinputdesc' => '(je konwencija, zo so formular po hłownej předłoze pomjenuje, kotruž wupjelnjuje).',
	'sf_createform_template' => 'Předłoha:',
	'sf_createform_templatelabelinput' => 'Mjeno předłohi (opcionalny):',
	'sf_createform_allowmultiple' => 'Wjacore (abo žane) instancy tuteje předłohi we wutworjenej stronje dowolić',
	'sf_createform_field' => 'Polo:',
	'sf_createform_fieldprop' => 'Tute polo definuje kajkosć $1 typa $2.',
	'sf_createform_fieldproplist' => 'Tute polo definuje lisćinu elementow, kotrež maja kajkosć $1 typa $2.',
	'sf_createform_fieldpropunknowntype' => 'Tute polo definuje kajkosć $1 njepodateho typa.',
	'sf_createform_inputtype' => 'Zapodaj typ:',
	'sf_createform_inputtypedefault' => '(Standard)',
	'sf_createform_formlabel' => 'Formularne mjeno:',
	'sf_createform_hidden' => 'Schowany',
	'sf_createform_restricted' => 'Zawrěty (jenož administratorojo móža změnić)',
	'sf_createform_mandatory' => 'Winowatostne polo',
	'sf_createform_removetemplate' => 'Předłohu wotstronić',
	'sf_createform_addtemplate' => 'Předłohu přidać:',
	'sf_createform_beforetemplate' => 'Před předłohu:',
	'sf_createform_atend' => 'Na kóncu',
	'sf_createform_add' => 'Přidać',
	'sf_createform_choosefield' => 'Wubjer polo, kotrež chceš přidać',
	'createcategory' => 'Kategoriju wutworić',
	'sf_createcategory_name' => 'Mjeno kategorije:',
	'sf_createcategory_defaultform' => 'Standardny formular:',
	'sf_createcategory_makesubcategory' => 'Tutu kategoriju k podkategoriji druheje kategorije činić (opcionalny):',
	'createclass' => 'Klasu wutworić',
	'sf_createclass_docu' => 'Zapodajće tu wšě daty, zo by kajkosće, předłohu, formular a kategoriju za jednotliwu klasu wutworił.
Za dalše opcije wužij strony $1 město toho.',
	'sf_createclass_allowedvalues' => 'Dowolene hódnoty',
	'sf_createclass_listofvalues' => 'Lisćina hódnotow',
	'sf_createclass_leavefieldblank' => 'Jeli mjeno pola je samsne kaj mjeno kajkosće, móžeš jo prózdne wostajić.',
	'sf_createclass_missingvalues' => 'Nic wšě trěbne pola su wupjelnjene.',
	'sf_createclass_success' => 'Kajkosće, předłoha, formular a kategorija budu so wutworjeć.',
	'formstart' => 'Stronu z formularom přidać',
	'sf_formstart_badform' => 'Zmylk: Žana formularna strona pola $1 namakana',
	'sf_formstart_badtitle' => 'Zmylk: "$1" je njepłaćiwy titul za stronu.',
	'sf_formstart_docu' => "Zapodaj tu mjeno strony, kotraž so ma z formularom '$1' wobdźěłać. Jeli tuta strona hižo eksistuje, posrědkuješ k formularej, z kotrymž móžeš tut stronu wobdźěłać. Hewak posrědkuješ so k formularej, z kotrymž móžeš stronu přidać.",
	'sf_formstart_noform_docu' => 'Zapodaj tu mjeno strony a wubjer formular, z kotrymž chceš ju wobdźěłać. Jeli strona hižo eksistuje, posrědkuješ so k formularej, z kotrymž tutu stronu wobdźěłać. Hewak posrědkujes so k formularej, z kotrymž móžeš přidać.',
	'sf_formstart_createoredit' => 'Wutworić abo wobdźěłać',
	'formedit' => 'Z formularom wobdźěłać',
	'sf_formedit_createtitle' => '$1 wutworić: $2',
	'sf_formedit_badurl' => "To je strona za wobdźěłowanje z formularom. Dyrbiš formularne mjeno kaž tež cilowu stronu w URL podać; měło kaž 'Special:FormEdit?form=&lt;formularne mjeno&gt;&target=&lt;cilowa strona&gt;' abo  'Special:FormEdit/&lt;formularne mjeno&gt;/&lt;cilowa strona&gt;' wupadać.",
	'sf_formedit_altforms' => 'Móžeš město toho tutu stronu z jednym ze slědowacych formularow přidać:',
	'sf_formedit_altformsonly' => 'Wubjer přošu jedyn ze slědowacych formularow, zo by tutu stronu přidał:',
	'sf_formcreate' => 'Z formularom wutworić',
	'sf_viewform' => 'Formular wobhladać',
	'sf_editsource' => 'Žórło wobdźěłać',
	'sf_formedit_edittitle' => '$1 wobdźěłać: $2',
	'sf_formedit_morethanoneform' => 'Warnowanje: Za tutu stronu bu wjace hač jedyn standardny formular definowany.',
	'sf_formedit_formwarning' => 'Warnowanje: Tuta strona <a href="$1">hižo eksistuje</a>, ale njewužiwa tutón formular.',
	'sf_formedit_remove' => 'Wotstronić',
	'sf_formedit_addanother' => 'Dalše přidać',
	'sf_formedit_none' => 'Žadyn',
	'runquery' => 'Naprašowanje startować',
	'sf_runquery_badurl' => "Dyrbiš formularne mjeno w URL podać;
URL měł wupadać kaž 'Special:RunQuery/&lt;formularne mjeno&gt;'.",
	'sf_runquery_title' => 'Start naprašowanja: $1',
	'sf_runquery_additionalquery' => 'Přidatne naprašowanje',
	'sf_formerrors_header' => 'Su zmylki z twojim formularnym zapodaćom wustupili, hlej deleka',
	'sf_blank_error' => 'Njesmě prózdny być!',
	'sf_bad_url_error' => "dyrbi korektny format URL měć, kotryž so z 'http://' započina",
	'sf_bad_email_error' => 'dyrbi płaćiwy format za e-mejlowe adresy měć',
	'sf_bad_number_error' => 'dyrbi płaćiwa ličba być',
	'sf_bad_integer_error' => 'dyrbi płaćiwa cyła ličba być',
	'sf_bad_date_error' => 'dyrbi płaćiwy datum być',
	'uploadwindow' => 'Wokno nahraćow',
	'sf_deletionlog' => 'protokol wušmórnjenjow',
	'sf_property_isproperty' => 'To je kajkosć typa $1.',
	'sf_property_linkstoform' => 'Wotkazuje k stronam, kotrež formular $1 wužiwaja.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Dowolena hódnota za tutu kajkosć je|Dowolenej hódnoće za tutu kajkosć stej|Dowolene hódnoty za tutu kajkosć su|Dowolene hódnoty za tutu kajkosć su}}:',
	'sf_template_docu' => "To je předłoha '$1'. Měła so w slědowacym formaće wołać:",
	'sf_template_docufooter' => 'Wobdźěłaj tutu stronu, zo by tekst předłohi widźał.',
	'sf_form_docu' => 'To je formular "$1".
Zo by stronu z tutym formularom wutworił, zapodaj deleka mjeno strony; 
jeli strona z tutym mjenom hižo eksistuje, posrědkuješ so dale k formularej, z kotrymž móžeš tutu stronu wobdźěłać.',
	'sf_form_freetextlabel' => 'Swobodny tekst',
	'sf_category_hasdefaultform' => 'Tuta kategorija wužiwa formular $1.',
	'sf_category_desc' => 'To je kategorija $1.',
	'sf_blank_namespace' => 'Hłowny',
	'right-viewedittab' => 'Rajtark "Wobźěłać" za strony, kotrež su přez formular wobźěłujomne, sej wobhladać',
	'right-editrestrictedfields' => 'Wobmjezowane formularne pola wobdźěłać',
);

/** Hungarian (Magyar)
 * @author Dani
 * @author Dorgan
 * @author Glanthor Reviol
 * @author Tgr
 */
$messages['hu'] = array(
	'semanticforms-desc' => 'Űrlapok szemantikus adatok hozzáadásához és szerkesztéséhez',
	'specialpages-group-sf_group' => 'Szemantikus űrlapok',
	'createproperty' => 'Tulajdonság létrehozása',
	'sf_createproperty_linktoform' => 'Ez a tulajdonság hivatkozni fog azokra a lapokra, amelyek használják az űrlapot:',
	'sf_createproperty_allowedvalsinput' => 'Ha azt szeretnéd, hogy ez a tulajdonság csak bizonyos értékeket vehessen fel, add meg az engedélyezett értékek listáját, vesszővel elválasztva (ha az érték tartalmaz vesszőt, használd a „\\,” alakot):',
	'sf_createproperty_propname' => 'Tulajdonságnév:',
	'sf_createproperty_proptype' => 'Típus:',
	'templates' => 'Sablonok',
	'sf_templates_docu' => 'A következő sablonok találhatóak meg a wikiben.',
	'sf_templates_definescat' => 'definiálja a kategóriát:',
	'createtemplate' => 'Sablon létrehozása',
	'sf_createtemplate_namelabel' => 'A sablon neve:',
	'sf_createtemplate_categorylabel' => 'A sablon által megadott kategória (nem kötelező):',
	'sf_createtemplate_templatefields' => 'A sablon mezői:',
	'sf_createtemplate_fieldsdesc' => 'Ha azt szeretnéd, hogy a sablonban lévő mezőknek ne kelljen mezőneveket adni, egyszerűen írd be a mező indexét (pl. 1, 2, 3 stb.) névként a valódi név helyett.',
	'sf_createtemplate_fieldname' => 'Mező neve:',
	'sf_createtemplate_displaylabel' => 'Megjelenített szöveg:',
	'sf_createtemplate_semanticproperty' => 'Szemantikus tulajdonság:',
	'sf_createtemplate_fieldislist' => 'Ez a mező értékek vesszővel elválasztott listáját tartalmazhatja.',
	'sf_createtemplate_aggregation' => 'Aggregáció',
	'sf_createtemplate_aggregationdesc' => 'A listázáshoz bármelyik lapon, ami ezt a sablont használja, az összes olyen lapnak, melynek van egy bizonyos tulajdonsága, ami arra a lapra mutat, add meg az alább látható tulajdonságot:',
	'sf_createtemplate_aggregationlabel' => 'Lista címe:',
	'sf_createtemplate_outputformat' => 'Kimeneti formátum:',
	'sf_createtemplate_standardformat' => 'Alapértelmezett',
	'sf_createtemplate_infoboxformat' => 'Jobboldai infobox',
	'sf_createtemplate_addfield' => 'Mező hozzáadása',
	'sf_createtemplate_deletefield' => 'Törlés',
	'sf_createtemplate_addtemplatebeforesave' => 'Legalább egy sablont hozzá kell rendelned az űrlaphoz a mentés előtt.',
	'forms' => 'Űrlapok',
	'sf_forms_docu' => 'A következő űrlapok találhatóak meg a wikiben.',
	'createform' => 'Űrlap létrehozása.',
	'sf_createform_nameinput' => 'Űrlap neve',
	'sf_createform_nameinputdesc' => '(a szokás az, hogy az űrlapot az azt felépítő fő sablon után nevezzük el):',
	'sf_createform_template' => 'Sablon:',
	'sf_createform_templatelabelinput' => 'Sablon-címke (nem kötelező):',
	'sf_createform_allowmultiple' => 'A sablon többször is (vagy egyszer sem) szerepelhet az elkészült lapon',
	'sf_createform_field' => 'Mező:',
	'sf_createform_fieldprop' => 'Ez a mező definiálja a(z) $2 típusú $1 tulajdonságot.',
	'sf_createform_fieldproplist' => 'Ez a mező olyan elemek listáját definiálja, amelyeknek van $2 típusú $1 tulajdonságok.',
	'sf_createform_fieldpropunknowntype' => 'Ez a mező definiálja a nem megadott típusú $1 tulajdonságot.',
	'sf_createform_inputtype' => 'Bemenet típusa:',
	'sf_createform_inputtypedefault' => '(alapértelmezett)',
	'sf_createform_formlabel' => 'Az űrlap címkéje:',
	'sf_createform_hidden' => 'Rejtett',
	'sf_createform_restricted' => 'Korlátozott (csak adminisztrátorok módosíthatják)',
	'sf_createform_mandatory' => 'Kötelező',
	'sf_createform_removetemplate' => 'Sablon eltávolítása',
	'sf_createform_addtemplate' => 'Sablon hozzáadása:',
	'sf_createform_beforetemplate' => 'Sablon elé:',
	'sf_createform_atend' => 'A végén',
	'sf_createform_add' => 'Hozzáadás',
	'sf_createform_choosefield' => 'Válaszd ki azt a mezőt, amelyiket hozzá szeretnéd adni',
	'createcategory' => 'Kategória létrehozása',
	'sf_createcategory_name' => 'Kategórianév:',
	'sf_createcategory_defaultform' => 'Alapértelmezett űrlap:',
	'sf_createcategory_makesubcategory' => 'Legyen ez egy kategória alkategóriája (nem kötelező):',
	'createclass' => 'Osztály létrehozása',
	'sf_createclass_docu' => 'Add meg itt az összes adatot a tulajdonságok, a sablon és a kategória létrehozásához egyetlen osztályhoz. További beállításokat a(z) $1 lapon végezhetsz.',
	'sf_createclass_allowedvalues' => 'Megengedett értékek',
	'sf_createclass_listofvalues' => 'Értékek listája',
	'sf_createclass_leavefieldblank' => 'Ha a mező neve megegyezik a tulajdonság nevével, üresen hagyhatod.',
	'sf_createclass_missingvalues' => 'Nem töltötted ki az összes kötelező mezőt.',
	'sf_createclass_success' => 'Tulajdonságok, sablon, űrlap és kategória lesz létrehozva.',
	'formstart' => 'Oldal hozzáadása űrlappal',
	'sf_formstart_badform' => 'Hiba: nem található űrlap a(z) $1 címen',
	'sf_formstart_badtitle' => 'Hiba: a(z) „$1” érvénytelen lapcím.',
	'sf_formstart_docu' => 'Add meg annak a lapnak a nevét, amit a(z) „$1” űrlap segítségével szeretnél szerkeszteni.
Ha ez a lap már létezik, ahhoz az űrlaphoz leszel irányítva a lap szerkesztéséhez.
Egyébként a lap hozzáadása űrlaphoz leszel küldve.',
	'sf_formstart_noform_docu' => 'Add meg annak a lapnak a nevét, majd válaszd ki az űrlapot, amivel szerkeszteni akarod.
Ha ez a lap már létezik, ahhoz az űrlaphoz leszel irányítva a lap szerkesztéséhez.
Egyébként a lap hozzáadása űrlaphoz leszel küldve.',
	'sf_formstart_createoredit' => 'Létrehozás vagy szerkesztés',
	'formedit' => 'Szerkesztés űrlappal',
	'sf_formedit_createtitle' => '$1 létrehozása: $2',
	'sf_formedit_badurl' => 'Ezen a lapon űrlap segítségével szerkeszthetsz. Meg kell adnod az űrlap nevét és a céllap URL-címét is;
a következőképpen kell kinéznie: „Special:FormEdit?form=&lt;űrlap neve&gt;&target=&lt;céllap&gt;”, vagy „Special:FormEdit/&lt;űrlap neve&gt;/&lt;céllap&gt;”.',
	'sf_formedit_altforms' => 'Helyette hozzáadhatod ezt a lapot a következő űrlapok egyikével:',
	'sf_formedit_altformsonly' => 'Válassz egyet a következő űrlapok közül, amit hozzá szeretnél adni ehhez a laphoz:',
	'sf_formcreate' => 'Létrehozás űrlappal',
	'sf_viewform' => 'Űrlap megtekintése',
	'sf_editsource' => 'Forrás szerkesztése',
	'sf_formedit_edittitle' => '$1: $2 szerkesztése',
	'sf_formedit_morethanoneform' => "'''Figyelmeztetés:''' több mint egy alapértelmezett űrlap van megadva ehhez a laphoz.",
	'sf_formedit_formwarning' => 'Figyelem: Ez a lap <a href="$1">már létezik</a>, de nem használja ezt az űrlapot.',
	'sf_formedit_remove' => 'Eltávolítás',
	'sf_formedit_addanother' => 'Másik hozzáadása',
	'sf_formedit_none' => 'Nincs',
	'runquery' => 'Lekérdezés futtatása',
	'sf_runquery_badurl' => "Meg kell adnod egy űrlap nevét az URL-ben;
az URL-nek így kell kinéznie: 'Special:RunQuery/&lt;űrlap neve&gt;'.",
	'sf_runquery_title' => 'Lekérdezés futtatása: $1',
	'sf_runquery_additionalquery' => 'További lekérdezés',
	'sf_formerrors_header' => 'Hibák voltak az űrlapon megadott adatokban; lásd lentebb',
	'sf_blank_error' => 'nem lehet üres',
	'sf_bad_url_error' => 'a helyes URL formátumban kell lennie, az elején „http://”-vel',
	'sf_bad_email_error' => 'helyes e-mail cím formátumban kell lennie',
	'sf_bad_number_error' => 'számnak kell lennie',
	'sf_bad_integer_error' => 'egész számnak kell lennie',
	'sf_bad_date_error' => 'érvényes dátumnak kell lennie',
	'uploadwindow' => 'Feltöltési ablak',
	'sf_deletionlog' => 'Törlési napló',
	'sf_property_isproperty' => 'Ez egy „$1” típusú tulajdonság.',
	'sf_property_linkstoform' => 'Hivatkozik azokra a lapokra, amelyek a(z) $1 űrlapot használják.',
	'sf_property_allowedvals' => 'A tulajdonság a következő {{PLURAL:$1|értéket|értékeket}} veheti fel:',
	'sf_template_docu' => 'Ez a(z) „$1” sablon.
A következő formátumban kell meghívni:',
	'sf_template_docufooter' => 'Szerkeszd a lapot, hogy láthasd a sablon szövegét.',
	'sf_form_docu' => 'Ez a(z) „$1” űrlap.
Ha új lapot szeretnél létrehozni ezzel az űrlappal, írd be alább a lap nevét.
Ha már létezik ilyen nevű lap, egy űrlaphoz leszel irányítva, ahol szerkesztheted a lapot.',
	'sf_form_freetextlabel' => 'Szabad szöveg',
	'sf_category_hasdefaultform' => 'Ez a kategória a(z) „$1” űrlapot használja.',
	'sf_category_desc' => 'Ez a(z) $1 kategória.',
	'sf_blank_namespace' => 'Fő',
	'right-viewedittab' => 'Nézd a „Szerkesztés” fület azokhoz a lapokhoz, melyek űrlappal szerkeszthetőek',
	'right-editrestrictedfields' => 'korlátozott űrlap-mezők szerkesztése',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'semanticforms-desc' => 'Formularios pro adder e modificar datos semantic',
	'specialpages-group-sf_group' => 'Formularios semantic',
	'createproperty' => 'Crear un proprietate',
	'sf_createproperty_linktoform' => 'Iste proprietate ligara verso paginas que usa le formulario:',
	'sf_createproperty_allowedvalsinput' => 'Si tu vole que iste proprietate sia permittite a haber solmente certe valores, entra le lista del valores permittite, separate per commas (si un valor contine un comma, reimplacia lo con "\\,"):',
	'sf_createproperty_propname' => 'Nomine del proprietate:',
	'sf_createproperty_proptype' => 'Typo:',
	'templates' => 'Patronos',
	'sf_templates_docu' => 'Le sequente patronos existe in le wiki.',
	'sf_templates_definescat' => 'defini categoria:',
	'createtemplate' => 'Crear un patrono',
	'sf_createtemplate_namelabel' => 'Nomine del patrono:',
	'sf_createtemplate_categorylabel' => 'Categoria definite per patrono (optional):',
	'sf_createtemplate_templatefields' => 'Campos de patrono',
	'sf_createtemplate_fieldsdesc' => 'Pro effectuar que le campos in iste patrono non require plus le nomines de campos, simplemente entra le indice de cata campo (p.ex. 1, 2, 3, etc.) como le nomine, in loco del nomine real.',
	'sf_createtemplate_fieldname' => 'Nomine del campo:',
	'sf_createtemplate_displaylabel' => 'Etiquetta pro monstrar:',
	'sf_createtemplate_semanticproperty' => 'Proprietate semantic:',
	'sf_createtemplate_fieldislist' => 'Iste campo pote tener un lista de valores, separate per commas',
	'sf_createtemplate_aggregation' => 'Aggregation',
	'sf_createtemplate_aggregationdesc' => 'Pro listar, in omne pagina que usa iste patrono, tote le paginas que ha un certe proprietate punctante verso ille pagina, specifica le proprietate in question ci infra:',
	'sf_createtemplate_aggregationlabel' => 'Titulo pro lista:',
	'sf_createtemplate_outputformat' => 'Formato de output:',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_infoboxformat' => 'Quadro de information a dextra',
	'sf_createtemplate_addfield' => 'Adder campo',
	'sf_createtemplate_deletefield' => 'Deler',
	'sf_createtemplate_addtemplatebeforesave' => 'Tu debe adder al minus un patrono a iste formulario ante que tu pote salveguardar lo.',
	'forms' => 'Formularios',
	'sf_forms_docu' => 'Le sequente formularios existe in le wiki.',
	'createform' => 'Crear un formulario',
	'sf_createform_nameinput' => 'Nomine del formulario',
	'sf_createform_nameinputdesc' => '(es costumari dar al formulario le nomine del patrono principal que illo reimple):',
	'sf_createform_template' => 'Patrono:',
	'sf_createform_templatelabelinput' => 'Etiquetta del patrono (optional):',
	'sf_createform_allowmultiple' => 'Permitter multiple (o zero) instantias de iste patrono in le pagina create',
	'sf_createform_field' => 'Campo:',
	'sf_createform_fieldprop' => 'Iste campo defini le proprietate $1, del typo $2.',
	'sf_createform_fieldproplist' => 'Iste campo defini un lista de elementos que ha le proprietate $1, del typo $2.',
	'sf_createform_fieldpropunknowntype' => 'Iste campo defini le proprietate $1, de un typo non specificate.',
	'sf_createform_inputtype' => 'Typo de entrata:',
	'sf_createform_inputtypedefault' => '(predefinition)',
	'sf_createform_formlabel' => 'Etiquetta de formulario:',
	'sf_createform_hidden' => 'Celate',
	'sf_createform_restricted' => 'Restringite (solmente administratores pote modificar lo)',
	'sf_createform_mandatory' => 'Obligatori',
	'sf_createform_removetemplate' => 'Remover patrono',
	'sf_createform_addtemplate' => 'Adder patrono:',
	'sf_createform_beforetemplate' => 'Ante patrono:',
	'sf_createform_atend' => 'Al fin',
	'sf_createform_add' => 'Adder',
	'sf_createform_choosefield' => 'Selige un campo a adder',
	'createcategory' => 'Crear un categoria',
	'sf_createcategory_name' => 'Nomine del categoria:',
	'sf_createcategory_defaultform' => 'Formulario predefinite:',
	'sf_createcategory_makesubcategory' => 'Facer isto un subcategoria de un altere categoria (optional):',
	'createclass' => 'Crear un classe',
	'sf_createclass_docu' => 'Entra tote le datos hic pro crear le proprietates, patrono, formulario e categoria pro un singule classe. Pro plus optiones, usa le paginas $1 in loco de iste.',
	'sf_createclass_allowedvalues' => 'Valores permittite',
	'sf_createclass_listofvalues' => 'Lista de valores',
	'sf_createclass_leavefieldblank' => 'Si le nomine del campo es le mesme que le nomine del proprietate, tu pote lassar lo vacue.',
	'sf_createclass_missingvalues' => 'Non tote le campos requirite ha essite completate.',
	'sf_createclass_success' => 'Proprietates, patrono, formulario e categoria essera create.',
	'formstart' => 'Adder pagina con formulario',
	'sf_formstart_badform' => 'Error: nulle pagina de formulario esseva trovate a $1',
	'sf_formstart_badtitle' => 'Error: "$1" es un titulo invalide pro un pagina.',
	'sf_formstart_docu' => "Entra le nomine de un pagina hic, pro esser modificate con le formulario '$1'.
Si iste pagina existe ja, tu essera inviate al formulario pro modificar ille pagina.
Alteremente, tu essera inviate al formulario pro adder le pagina.",
	'sf_formstart_noform_docu' => 'Entra hic le nomine del pagina, e selige le formulario con le qual modificar lo.
Si iste pagina ja existe, tu essera inviate al formulario pro modificar ille pagina.
Alteremente, tu esserea inviate al formulario pro modificar le pagina.',
	'sf_formstart_createoredit' => 'Crear o modificar',
	'formedit' => 'Modificar con formulario',
	'sf_formedit_createtitle' => 'Crear $1: $2',
	'sf_formedit_badurl' => "Isto es le pagina pro modificar con un formulario. Tu debe specificar e un nomine de formulario e un pagina de destination in le adresse URL; illo debe resimilar 'Special:FormEdit?form=&lt;nomine del formulario&gt;&target=&lt;pagina de destination&gt;', o  'Special:FormEdit/&lt;nomine del formulario&gt;/&lt;pagina de destination&gt;'.",
	'sf_formedit_altforms' => 'Tu pote, in loco de isto, adder iste pagina con un del sequente formularios:',
	'sf_formedit_altformsonly' => 'Per favor selige un del sequente formularios pro adder iste pagina:',
	'sf_formcreate' => 'Crear con formulario',
	'sf_viewform' => 'Vider formulario',
	'sf_editsource' => 'Modificar fonte',
	'sf_formedit_edittitle' => 'Modificar $1: $2',
	'sf_formedit_morethanoneform' => 'Attention: Plus de un formulario predefinite es definite pro iste pagina.',
	'sf_formedit_formwarning' => 'Attention: Iste pagina <a href="$1">existe ja</a>, sed non usa iste formulario.',
	'sf_formedit_remove' => 'Remover',
	'sf_formedit_addanother' => 'Adder un altere',
	'sf_formedit_none' => 'Nulle',
	'runquery' => 'Executar consulta',
	'sf_runquery_badurl' => "Es necessari specificar le nomine de un formulario in le URL;
le URL debe esser in le forma 'Special:RunQuery/&lt;nomine del formulario&gt;'.",
	'sf_runquery_title' => 'Executar consulta: $1',
	'sf_runquery_additionalquery' => 'Consulta additional',
	'sf_formerrors_header' => 'Il ha errores in lo que tu entrava in le formulario; vide infra',
	'sf_blank_error' => 'non pote esser vacue',
	'sf_bad_url_error' => "le adresse URL debe esser in formato correcte, comenciante con 'http'",
	'sf_bad_email_error' => 'le adresse de e-mail debe esser in formato correcte',
	'sf_bad_number_error' => 'debe esser un numero valide',
	'sf_bad_integer_error' => 'debe esser un numero integre valide',
	'sf_bad_date_error' => 'debe esser un data valide',
	'uploadwindow' => 'Cargar fenestra',
	'sf_deletionlog' => 'registro de deletiones',
	'sf_property_isproperty' => 'Isto es un proprietate del typo $1.',
	'sf_property_linkstoform' => 'Illo liga verso paginas que usa le formulario $1.',
	'sf_property_allowedvals' => 'Le {{PLURAL:$1|valor|valores}} permittite pro iste proprietate es:',
	'sf_template_docu' => "Isto es le patrono '$1'.
Illo debe esser appellate in le formato sequente:",
	'sf_template_docufooter' => 'Modifica le pagina pro vider le texto del patrono.',
	'sf_form_docu' => 'Isto es le formulario "$1".
Pro crear un pagina con iste formulario, entra le nomine del pagina in basso;
si un pagina con iste nomine ja existe, tu essera inviate a un formulario pro modificar iste pagina.',
	'sf_form_freetextlabel' => 'Texto libere',
	'sf_category_hasdefaultform' => 'Iste categoria usa le formulario $1.',
	'sf_category_desc' => 'Isto es le categoria $1.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Vider le scheda "Modificar" pro paginas modificabile per formulario',
	'right-editrestrictedfields' => 'Modificar le campos restringite de formularios',
);

/** Indonesian (Bahasa Indonesia)
 * @author Bennylin
 * @author Irwangatot
 * @author IvanLanin
 * @author Rex
 */
$messages['id'] = array(
	'semanticforms-desc' => 'Formulir untuk menambahkan dan menyunting data semantik',
	'specialpages-group-sf_group' => 'Semantic Forms',
	'createproperty' => 'Buat properti',
	'sf_createproperty_linktoform' => 'Properti ini akan tertaut ke halaman yang menggunakan formulir:',
	'sf_createproperty_allowedvalsinput' => 'Jika Anda ingin properti ini hanya diizinkan untuk memiliki suatu nilai tertentu, masukkan daftar nilai yang diizinkan, dipisahkan dengan koma (jika suatu nilai mengandung koma, ganti dengan "\\,"):',
	'sf_createproperty_propname' => 'Nama properti:',
	'sf_createproperty_proptype' => 'Tipe:',
	'templates' => 'Templat',
	'sf_templates_docu' => 'Templat berikut ada di wiki ini',
	'sf_templates_definescat' => 'mendefinisikan kategori:',
	'createtemplate' => 'Buat templat',
	'sf_createtemplate_namelabel' => 'Nama templat:',
	'sf_createtemplate_categorylabel' => 'Kategori yang didefinisikan oleh templat (opsional):',
	'sf_createtemplate_templatefields' => 'Kolom templat',
	'sf_createtemplate_fieldsdesc' => 'Untuk membuat kolom pada templat ini tidak lagi membutuhkan nama kolom, masukkan saja indeks masing-masing kolom (mis. 1, 2, 3, dll.) sebagai nama, dan bukan nama yang sebenarnya.',
	'sf_createtemplate_fieldname' => 'Nama kolom:',
	'sf_createtemplate_displaylabel' => 'Label tampilan:',
	'sf_createtemplate_semanticproperty' => 'Properti semantik:',
	'sf_createtemplate_fieldislist' => 'Kolom ini dapat menampung daftar nilai, dipisahkan oleh koma',
	'sf_createtemplate_aggregation' => 'Agregasi',
	'sf_createtemplate_aggregationdesc' => 'Untuk memberikan daftar, pada setiap halaman yang menggunakan templat ini, semua halaman yang memiliki properti tertentu yang merujuk ke halaman tersebut, tentukan properti yang sesuai di bawah ini:',
	'sf_createtemplate_aggregationlabel' => 'Judul daftar:',
	'sf_createtemplate_outputformat' => 'Format keluaran:',
	'sf_createtemplate_standardformat' => 'Standar',
	'sf_createtemplate_infoboxformat' => 'Kotak info di sisi kanan',
	'sf_createtemplate_addfield' => 'Tambahkan kolom',
	'sf_createtemplate_deletefield' => 'Hapus',
	'sf_createtemplate_addtemplatebeforesave' => 'Anda harus memberikan paling tidak satu templat untuk formulir ini sebelum dapat menyimpannya.',
	'forms' => 'Formulir',
	'sf_forms_docu' => 'Formulir berikut ada di wiki ini.',
	'createform' => 'Buat formulir',
	'sf_createform_nameinput' => 'Nama formulir',
	'sf_createform_nameinputdesc' => '(konvensinya adalah menamai formulir ini menurut templat utama yang diisinya):',
	'sf_createform_template' => 'Templat:',
	'sf_createform_templatelabelinput' => 'Label templat (opsional):',
	'sf_createform_allowmultiple' => 'Izinkan beberapa (atau nol) templat ini di halaman yang dibuat',
	'sf_createform_field' => 'Kolom:',
	'sf_createform_fieldprop' => 'Kolom ini menentukan properti $1 yang bertipe $2.',
	'sf_createform_fieldproplist' => 'Kolom ini menentukan beberapa elemen yang memiliki properti $1 bertipe $2.',
	'sf_createform_fieldpropunknowntype' => 'Kolom ini menentukan properti $1 yang tipenya tidak ditentukan.',
	'sf_createform_inputtype' => 'Tipe masukan:',
	'sf_createform_inputtypedefault' => '(baku)',
	'sf_createform_formlabel' => 'Label formulir:',
	'sf_createform_hidden' => 'Tersembunyi',
	'sf_createform_restricted' => 'Terbatas (hanya pengurus yang dapat mengubahnya)',
	'sf_createform_mandatory' => 'Diwajibkan',
	'sf_createform_removetemplate' => 'Hapus templat',
	'sf_createform_addtemplate' => 'Tambah templat:',
	'sf_createform_beforetemplate' => 'Sebelum templat:',
	'sf_createform_atend' => 'Di akhir',
	'sf_createform_add' => 'Tambahkan',
	'sf_createform_choosefield' => 'Pilih kolom untuk ditambahkan',
	'createcategory' => 'Buat kategori',
	'sf_createcategory_name' => 'Nama kategori:',
	'sf_createcategory_defaultform' => 'Formulir baku:',
	'sf_createcategory_makesubcategory' => 'Jadikan sebagai subkategori dari kategori lain (opsional):',
	'createclass' => 'Buat kelas',
	'sf_createclass_docu' => 'Masukkan semua data di sini untuk membuat properti, tempat, formulir, dan kategori untuk suatu kelas tunggal. Untuk lebih banyak pilihan, gunakan halaman $1.',
	'sf_createclass_allowedvalues' => 'Nilai yang diizinkan',
	'sf_createclass_listofvalues' => 'Daftar nilai',
	'sf_createclass_leavefieldblank' => 'Jika nama kolom sama dengan nama properti, Anda dapat membiarkannya kosong.',
	'sf_createclass_missingvalues' => 'Tidak semua kolom yang diperlukan telah diisi.',
	'sf_createclass_success' => 'Properti, templat, formulir, dan kategori akan dibuat.',
	'formstart' => 'Buat halaman dengan formulir',
	'sf_formstart_badform' => 'Kesalahan: halaman formulir tak ditemukan di $1',
	'sf_formstart_badtitle' => 'Kesalahan: "$1" adalah judul yang tidak valid untuk suatu halaman.',
	'sf_formstart_docu' => 'Masukkan nama halaman untuk disunting dengan formulir "$1" di sini.
Jika halaman ini sudah ada, Anda akan diarahkan ke formulir untuk menyunting halaman itu.
Jika belum, Anda akan diarahkan ke formulir untuk menambahkan halaman.',
	'sf_formstart_noform_docu' => 'Masukkan nama halaman di sini dan pilih formulir untuk menyuntingnya.
Jika halaman ini sudah ada, Anda akan diarahkan ke formulir untuk menyunting halaman itu.
Jika belum, Anda akan diarahkan ke formulir untuk menambahkan halaman.',
	'sf_formstart_createoredit' => 'Tambah atau sunting',
	'formedit' => 'Sunting dengan formulir',
	'sf_formedit_createtitle' => 'Tambah $1: $2',
	'sf_formedit_badurl' => "Ini adalah halaman untuk menambah data. Anda harus memberikan baik nama formulir maupun nama halaman target di URL;
bentuknya harus seperti 'Special:FormEdit?form=&lt;form name&gt;&target=&lt;target page&gt;', atau 'Special:FormEdit/&lt;form name&gt;/&lt;target page&gt;'.",
	'sf_formedit_altforms' => 'Sebagai gantinya, Anda dapat menambahkan halaman ini dengan salah satu dari formulir berikut:',
	'sf_formedit_altformsonly' => 'Silakan pilih salah satu dari formulir berikut untuk menambah halaman ini:',
	'sf_formcreate' => 'Buat dengan formulir',
	'sf_viewform' => 'Lihat formulir',
	'sf_editsource' => 'Sunting sumber',
	'sf_formedit_edittitle' => 'Sunting $1: $2',
	'sf_formedit_morethanoneform' => "'''Peringatan:''' Lebih dari satu formulir baku ditentukan untuk halaman ini.",
	'sf_formedit_formwarning' => 'Peringatan: Halaman ini <a href="$1">telah ada</a> tapi tidak menggunakan formulir ini.',
	'sf_formedit_remove' => 'Hapus',
	'sf_formedit_addanother' => 'Tambah lagi',
	'sf_formedit_none' => 'Tidak ada',
	'runquery' => 'Jalankan query',
	'sf_runquery_badurl' => "Anda harus menentukan suatu nama formulir di URL;
bentuknya harus seperti 'Special:RunQuery/&lt;form name&gt;'.",
	'sf_runquery_title' => 'Jalankan query: $1',
	'sf_runquery_additionalquery' => 'Query tambahan',
	'sf_formerrors_header' => 'Ada kesalahan pada masukan formulir Anda; lihat di bawah',
	'sf_blank_error' => 'tidak boleh kosong',
	'sf_bad_url_error' => "harus memiliki format URL yang benar, dimulai dengan 'http'",
	'sf_bad_email_error' => 'harus memiliki format alamat surel yang benar',
	'sf_bad_number_error' => 'harus berupa angka',
	'sf_bad_integer_error' => 'harus berupa bilangan bulat',
	'sf_bad_date_error' => 'harus berupa tanggal',
	'uploadwindow' => 'Jendela pengunggahan',
	'sf_deletionlog' => 'Log penghapusan',
	'sf_property_isproperty' => 'Ini adalah properti bertipe $1',
	'sf_property_linkstoform' => 'Ia terhubung dengan halaman yang menggunakan formulir $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Nilai|Nilai}} yang diizinkan untuk properti ini adalah:',
	'sf_template_docu' => 'Ini adalah templat "$1".
Ia harus dipanggil dengan format berikut:',
	'sf_template_docufooter' => 'Sunting halaman ini untuk melihat teks templat.',
	'sf_form_docu' => 'Ini adalah formulir "$1".
Untuk menambah halaman dengan menggunakan formulir ini, masukkan nama halaman di bawah ini;
jika halaman dengan nama tersebut sudah ada, Anda akan diarahkan ke formulir untuk menyunting halaman tersebut.',
	'sf_form_freetextlabel' => 'Teks gratis',
	'sf_category_hasdefaultform' => 'Kategori ini menggunakan formulir $1.',
	'sf_category_desc' => 'Ini adalah kategori $1.',
	'sf_blank_namespace' => 'Utama',
	'right-viewedittab' => 'Lihat tab "Sunting" untuk menyunting halaman dengan formulir',
	'right-editrestrictedfields' => 'Sunting kolom formulir terbatas',
);

/** Igbo (Igbo) */
$messages['ig'] = array(
	'sf_createtemplate_deletefield' => 'Gbakashia',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'templates' => 'Shabloni',
	'sf_createform_template' => 'Shablono:',
);

/** Icelandic (Íslenska)
 * @author S.Örvarr.S
 */
$messages['is'] = array(
	'sf_createproperty_propname' => 'Nafn:',
	'sf_createtemplate_standardformat' => 'Staðlað',
	'sf_createcategory_name' => 'Nafn:',
);

/** Italian (Italiano)
 * @author Alessandro Rosà
 * @author Civvì
 * @author Darth Kule
 * @author Melos
 */
$messages['it'] = array(
	'semanticforms-desc' => 'Modulo per aggiungere e modificare dati semantici',
	'specialpages-group-sf_group' => 'Moduli semantici',
	'createproperty' => 'Crea una proprietà',
	'sf_createproperty_linktoform' => 'Questa proprietà ti collegherà alla pagina che usa il seguente modulo:',
	'sf_createproperty_allowedvalsinput' => 'Se vuoi che questa proprietà possa ammettere solo determinati valori, inserisci una lista di valori ammessi, separati da virgole (se un valore presenta una virgola, sostituiscilo con mettendoci un backslash davanti in questo modo "\\,"):',
	'sf_createproperty_propname' => 'Nome proprietà:',
	'sf_createproperty_proptype' => 'Tipo:',
	'templates' => 'Template',
	'sf_templates_docu' => 'Il seguente template già esiste nel wiki.',
	'sf_templates_definescat' => 'Definisci categorie:',
	'createtemplate' => 'Crea un nuovo template',
	'sf_createtemplate_namelabel' => 'Nome template:',
	'sf_createtemplate_categorylabel' => 'Categorie definite attraverso template (opzionale):',
	'sf_createtemplate_templatefields' => 'Campi template',
	'sf_createtemplate_fieldsdesc' => "Per richiamare i campi di questo template non è necessario usare il loro nome, semplicemente inserisci il numero d'indice del campo (per esempio 1, 2, 3, etc) al posto del nome.",
	'sf_createtemplate_fieldname' => 'Nome campo:',
	'sf_createtemplate_displaylabel' => 'Parola da mostrare:',
	'sf_createtemplate_semanticproperty' => 'Proprietà semantiche:',
	'sf_createtemplate_fieldislist' => 'Questo campo può contenere una lista di valori, separati dalle virgole',
	'sf_createtemplate_aggregation' => 'Aggregazione',
	'sf_createtemplate_aggregationdesc' => 'Per vedere, fra le pagine che usano questo template, tutte le pagine che hanno una proprietà che punta a questa pagina, specifica la appropriata proprietà qui sotto:',
	'sf_createtemplate_aggregationlabel' => 'Titolo per la lista:',
	'sf_createtemplate_outputformat' => 'Formato di output:',
	'sf_createtemplate_standardformat' => 'Predefinito',
	'sf_createtemplate_infoboxformat' => 'Infobox nella parte destra',
	'sf_createtemplate_addfield' => 'Aggiungi campo',
	'sf_createtemplate_deletefield' => 'Cancella',
	'sf_createtemplate_addtemplatebeforesave' => 'Devi aggiungere almeno un template a questo modulo prima di poterlo salvare.',
	'forms' => 'Moduli',
	'sf_forms_docu' => 'I seguenti moduli già esistono nel wiki.',
	'createform' => 'Crea un nuovo modulo',
	'sf_createform_nameinput' => 'Nome modulo',
	'sf_createform_nameinputdesc' => '(la convenzione vuole che il nome del modulo venga assegnato dopo la popolazione del template principale ):',
	'sf_createform_template' => 'Template:',
	'sf_createform_templatelabelinput' => 'Nome da visualizzare del template (opzionale):',
	'sf_createform_allowmultiple' => 'Permetti multiple (nessuna) istanze di questo template nella pagina creata',
	'sf_createform_field' => 'Campo:',
	'sf_createform_fieldprop' => 'Questo campo definisce le proprietà  $1, di tipo $2.',
	'sf_createform_fieldproplist' => 'Questo campo definisce una lista di elementi che ha la proprietà $1, di tipo $2.',
	'sf_createform_fieldpropunknowntype' => 'Questo campo definisce la proprietà $1, di tipo non specificato.',
	'sf_createform_inputtype' => 'Tipo input:',
	'sf_createform_inputtypedefault' => '(predefinito)',
	'sf_createform_formlabel' => 'Etcihetta del modulo:',
	'sf_createform_hidden' => 'Nascosto',
	'sf_createform_restricted' => 'Riservato (solo utenti di tipo sysop possono modificarlo)',
	'sf_createform_mandatory' => 'Obbligatorio',
	'sf_createform_removetemplate' => 'Rimuovi template',
	'sf_createform_addtemplate' => 'Aggiungi template:',
	'sf_createform_beforetemplate' => 'Template precedente:',
	'sf_createform_atend' => 'Alla fine:',
	'sf_createform_add' => 'Aggiungi',
	'sf_createform_choosefield' => 'Scegli campo da aggiungere',
	'createcategory' => 'Crea una categoria',
	'sf_createcategory_name' => 'Nome categoria:',
	'sf_createcategory_defaultform' => 'Modulo predefinito:',
	'sf_createcategory_makesubcategory' => 'Falla diventare una sottocategoria di una categoria già presente (opzionale):',
	'createclass' => 'Crea una classe',
	'sf_createclass_docu' => 'Aggiungi qui tutte le informazioni per creare le proprietà, i template, i moduli e le categoria per una singola classe. Per ulteriori opzioni invece vai alla pagina $1.',
	'sf_createclass_allowedvalues' => 'Valori permessi',
	'sf_createclass_listofvalues' => 'Lista di valori',
	'sf_createclass_leavefieldblank' => 'Se il nome del campo è lo stesso del nome della proprietà, non puoi lasciarli vuoti.',
	'sf_createclass_missingvalues' => 'Campi richiesti non completamente riempiti.',
	'sf_createclass_success' => 'Proprietà, template, moduli e categorie verranno create.',
	'formstart' => 'Aggiungi pagina usando un modulo',
	'sf_formstart_badform' => 'Errore: nessun modulo è stato trovato alla pagina $1',
	'sf_formstart_badtitle' => 'Errore: "$1" non è un titolo valido per la pagina',
	'sf_formstart_docu' => "Inserisci il nome della pagina qui, per esser modificata con il modulo '$1'.
Se questa pagina esiste già, verrai indirizzato ad un modulo che ti permette di modificarla.
Altrimenti, verrai indirizzato ad un nuovo modulo che ti permetterà di aggiungere la nuova pagina.",
	'sf_formstart_noform_docu' => 'Inserisci il nome della pagina qui, e selezione il modulo con cui la vuoi modificare.
	Se questa pagina esiste già, verrai indirizzato ad un modulo che ti permette di modificarla.
	Altrimenti, verrai indirizzato ad un nuovo modulo che ti permetterà di aggiungere la nuova pagina.',
	'sf_formstart_createoredit' => 'Crea o modifica',
	'formedit' => 'Modifica tramite un modulo',
	'sf_formedit_createtitle' => 'Crea $1: $2',
	'sf_formedit_badurl' => "Questa è la pagina per modificare i dati inseriti tramite un modulo. Nell'URL devi specificare sia il nome del modulo e sia la pagina da modificare;
dovrebbe risultare una cosa di questo tipo 'Special:FormEdit?form=<form name>&target=<target page>', oppure 'Special:FormEdit/<form name>/<target page>'.",
	'sf_formedit_altforms' => 'Invece puoi aggiungere una pagina con uno dei seguenti moduli già creati:',
	'sf_formedit_altformsonly' => 'Per favore seleziona una dei seguenti moduli per aggiungere questa pagina:',
	'sf_formcreate' => 'Crea con un modulo',
	'sf_viewform' => 'Visualizza modulo',
	'sf_editsource' => 'Modifica sorgente',
	'sf_formedit_edittitle' => 'Modifica $1: $2',
	'sf_formedit_morethanoneform' => "'''Attenzione:''' Più di un modulo predefinito è stato definito per questa pagina.",
	'sf_formedit_formwarning' => 'Attenzione: Questa pagina <a href="$1">esiste già</a>, ma non usa questo form.',
	'sf_formedit_remove' => 'Rimuovi',
	'sf_formedit_addanother' => "Aggiungi un'\\altro",
	'sf_formedit_none' => 'Nessuno',
	'runquery' => 'Esegui query',
	'sf_runquery_badurl' => "Devi specificare il nome del form nell'\\ URL;
l'\\ URL dovrebbe risultare una cosa di questo tipo 'Special:RunQuery/<form name>'.",
	'sf_runquery_title' => 'Esegui query: $1',
	'sf_runquery_additionalquery' => 'Query aggiuntive',
	'sf_formerrors_header' => 'Ci sono stati degli errori nel form di input; vedi qui sotto',
	'sf_blank_error' => 'Non può esser vuoto',
	'sf_bad_url_error' => "Deve avere un formato dell'\\URL corretto, completo anche di 'http'",
	'sf_bad_email_error' => 'Deve avere un formato per di indirizzo email valido',
	'sf_bad_number_error' => "Dev'\\esser un numero valido",
	'sf_bad_integer_error' => "Dev'\\esser un'\\intero valido",
	'sf_bad_date_error' => "Dev'\\esser una data valida",
	'uploadwindow' => 'Finestra di upload',
	'sf_deletionlog' => 'Log cancellazioni',
	'sf_property_isproperty' => 'Questa è una proprietà di tipo $1.',
	'sf_property_linkstoform' => 'Ti collegherà alle pagine che usano il modulo $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Il valore permesso per questa proprità è|I valori permessi per questa proprietà sono}}:',
	'sf_template_docu' => "Questo è il template '$1'.
Dovrebbe esser chiamato con il seguente formato:",
	'sf_template_docufooter' => 'Modificare la pagine per vedere il testo del template.',
	'sf_form_docu' => 'Questo è il modulo "$1".
Per creare una pagina con questo modulo, inserire il nome della pagina qui sotto; se la pagina con il nome indicato esiste già, verrai inviato al modulo di modifica della pagina.',
	'sf_form_freetextlabel' => 'Testo libero',
	'sf_category_hasdefaultform' => 'Questa categoria usa il modulo $1.',
	'sf_category_desc' => 'Questa è la categoria $1.',
	'sf_blank_namespace' => 'Principale',
	'right-viewedittab' => 'Visualizza la scheda "Modifica" per le pagine modificabili tramite modulo',
	'right-editrestrictedfields' => 'Modifica campi riservati di moduli',
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author Hosiryuhosi
 * @author Whym
 * @author 青子守歌
 */
$messages['ja'] = array(
	'semanticforms-desc' => '意味的データを追加および編集するためのフォーム',
	'specialpages-group-sf_group' => 'セマンティック・フォーム',
	'createproperty' => 'プロパティ作成',
	'sf_createproperty_linktoform' => 'このプロパティは、次のフォームを利用するページにリンクします:',
	'sf_createproperty_allowedvalsinput' => 'このプロパティに一部の値しか設定できないようにするには、許可する値一覧をコンマで区切って入力します (値がコンマを含む場合は「\\,」に置き換えてください)。',
	'sf_createproperty_propname' => 'プロパティ名:',
	'sf_createproperty_proptype' => '型:',
	'templates' => 'テンプレート一覧',
	'sf_templates_docu' => '次のテンプレートがウィキに存在します。',
	'sf_templates_definescat' => 'カテゴリを定義:',
	'createtemplate' => 'テンプレートの作成',
	'sf_createtemplate_namelabel' => 'テンプレート名:',
	'sf_createtemplate_categorylabel' => 'テンプレートが定義するカテゴリ (省略可能):',
	'sf_createtemplate_templatefields' => 'テンプレートのフィールド',
	'sf_createtemplate_fieldsdesc' => 'このテンプレートにフィールドをもたせるのにフィールド名は必要はありません。実際の名前の代わりに、単に各フィールドの番号 (1、2、3、など) を名前として入力してください。',
	'sf_createtemplate_fieldname' => 'フィールド名:',
	'sf_createtemplate_displaylabel' => '表示ラベル:',
	'sf_createtemplate_semanticproperty' => '意味的プロパティ:',
	'sf_createtemplate_fieldislist' => 'このフィールドには値をコンマ区切りの一覧で入力することができます',
	'sf_createtemplate_aggregation' => '集約',
	'sf_createtemplate_aggregationdesc' => 'このテンプレートを使っているページで、そのページを指すプロパティをもつすべての記事を列挙するためには、該当のプロパティを以下に指定してください:',
	'sf_createtemplate_aggregationlabel' => '一覧の名:',
	'sf_createtemplate_outputformat' => '出力形式:',
	'sf_createtemplate_standardformat' => '標準',
	'sf_createtemplate_infoboxformat' => '右手側の情報ボックス',
	'sf_createtemplate_addfield' => 'フィールド追加',
	'sf_createtemplate_deletefield' => '削除',
	'sf_createtemplate_addtemplatebeforesave' => '保存する前に、最低でも1つのテンプレートをこのフォームに加えなければなりません。',
	'forms' => 'フォーム一覧',
	'sf_forms_docu' => '次のフォームがウィキに存在します。',
	'createform' => 'フォームの作成',
	'sf_createform_nameinput' => 'フォーム名',
	'sf_createform_nameinputdesc' => '(慣例では、フォームがデータを投入する本体のテンプレートの名前から命名します):',
	'sf_createform_template' => 'テンプレート:',
	'sf_createform_templatelabelinput' => 'テンプレートのラベル (省略可能):',
	'sf_createform_allowmultiple' => '作成されたページでこのテンプレートを複数 (もしくはゼロ) 回使用できるようにする',
	'sf_createform_field' => 'フィールド:',
	'sf_createform_fieldprop' => 'このフィールドは型 $2 のプロパティ $1 を定義します。',
	'sf_createform_fieldproplist' => 'このフィールドは、型 $2 のプロパティ $1 をもつ要素一覧を定義します。',
	'sf_createform_fieldpropunknowntype' => 'このフィールドは型が未指定のプロパティ $1 を定義します。',
	'sf_createform_inputtype' => '入力型:',
	'sf_createform_inputtypedefault' => '(デフォルト)',
	'sf_createform_formlabel' => 'フォームのラベル:',
	'sf_createform_hidden' => '非表示',
	'sf_createform_restricted' => '制限的 (管理者のみが変更できる)',
	'sf_createform_mandatory' => '必須',
	'sf_createform_removetemplate' => 'テンプレートの削除',
	'sf_createform_addtemplate' => 'テンプレート追加:',
	'sf_createform_beforetemplate' => 'テンプレートの前:',
	'sf_createform_atend' => '末尾に',
	'sf_createform_add' => '追加',
	'sf_createform_choosefield' => '追加するフィールドを選択',
	'createcategory' => 'カテゴリ作成',
	'sf_createcategory_name' => 'カテゴリ名:',
	'sf_createcategory_defaultform' => 'デフォルトのフォーム:',
	'sf_createcategory_makesubcategory' => 'これを別のカテゴリのサブカテゴリとする (任意選択):',
	'createclass' => 'クラスの作成',
	'sf_createclass_docu' => '単一のクラスに対応する、プロパティ群、テンプレート、フォーム、およびカテゴリを作成するためのデータすべてをここに入力してください。より多くの選択肢が必要な場合、ページ $1 を使ってください。',
	'sf_createclass_allowedvalues' => '許容される値',
	'sf_createclass_listofvalues' => '値の一覧',
	'sf_createclass_leavefieldblank' => 'フィールド名がプロパティ名と同一の場合は空欄にできます。',
	'sf_createclass_missingvalues' => '必須のフィールドに未入力のものがあります。',
	'sf_createclass_success' => 'プロパティ群、テンプレート、フォーム、およびカテゴリが作成されます。',
	'formstart' => 'フォームによるページの追加',
	'sf_formstart_badform' => 'エラー: $1 にはフォームページが見つかりませんでした',
	'sf_formstart_badtitle' => 'エラー:「$1」はページ名として無効です。',
	'sf_formstart_docu' => 'フォーム「$1」で編集するページの名前をここに入力してください。そのページが既に存在する場合、そのページを編集するためのフォームへ転送されます。その他の場合は、そのページを追加するためのフォームへ転送されます。',
	'sf_formstart_noform_docu' => 'ページの名前をここに入力し、編集に使うフォームを選んでください。そのページが既に存在する場合、そのページを編集するためのフォームへ転送されます。その他の場合は、そのページを追加するためのフォームへ転送されます。',
	'sf_formstart_createoredit' => '作成、または編集',
	'formedit' => 'フォームを使って編集',
	'sf_formedit_createtitle' => '$1を作成：$2',
	'sf_formedit_badurl' => 'これはフォームを使って編集するためのページです。フォーム名と対象ページの両方をURLに指定しなければなりません。
"Special:FormEdit?form=&lt;フォーム名&gt;&target=&lt;対象ページ&gt;" あるいは "Special:FormEdit/&lt;フォーム名&gt;/&lt;対象ページ&gt;" というような形式になります。',
	'sf_formedit_altforms' => '代わりに次のうちどれかのフォームを使って、このページを追加することができます:',
	'sf_formedit_altformsonly' => 'このページを追加するために、次のうちどれかのフォームを選んでください:',
	'sf_formcreate' => 'フォームを使って作成',
	'sf_viewform' => 'フォームを表示',
	'sf_editsource' => 'ソースを編集',
	'sf_formedit_edittitle' => '$1 を編集: $2',
	'sf_formedit_morethanoneform' => '警告: このページに対するデフォルトのフォームが複数定義されています。',
	'sf_formedit_formwarning' => '警告: このページは<a href="$1">既に存在します</a>が、このフォームを利用していません。',
	'sf_formedit_remove' => '削除',
	'sf_formedit_addanother' => '別のものを追加',
	'sf_formedit_none' => 'なし',
	'runquery' => 'クエリー実行',
	'sf_runquery_badurl' => 'URL中にフォーム名を指定しなければなりません。URLは「Special:RunQuery/&lt;フォーム名&gt;」というような形式になります。',
	'sf_runquery_title' => 'クエリーの実行: $1',
	'sf_runquery_additionalquery' => '追加クエリー',
	'sf_formerrors_header' => 'フォームへの入力内容に誤りがありました。以下をご覧ください',
	'sf_blank_error' => '空であってはならない',
	'sf_bad_url_error' => "URLの形式が 'http' から始まる正しいものでなくてはならない",
	'sf_bad_email_error' => 'メールアドレスの形式として正しくなくてはならない',
	'sf_bad_number_error' => '数として有効でなくてはならない',
	'sf_bad_integer_error' => '整数として有効でなくてはならない',
	'sf_bad_date_error' => '正しい日付でなくてはならない',
	'uploadwindow' => 'アップロード・ウィンドウ',
	'sf_deletionlog' => '削除記録',
	'sf_property_isproperty' => 'これは型 $1 のプロパティです。',
	'sf_property_linkstoform' => 'フォーム $1 を利用するページにリンクする。',
	'sf_property_allowedvals' => 'このプロパティが取ることのできる{{PLURAL:$1|値}}:',
	'sf_template_docu' => 'これは「$1」テンプレートです。次の形式で呼び出します:',
	'sf_template_docufooter' => 'テンプレートの内容を見るにはページを編集してください。',
	'sf_form_docu' => 'これは「$1」フォームです。このフォームを使ってページを追加するには、下にページ名を入力してください。その名前のページが既に存在する場合、そのページを編集するフォームに転送されます。',
	'sf_form_freetextlabel' => '自由に記載',
	'sf_category_hasdefaultform' => 'このカテゴリはフォーム $1 を使っています。',
	'sf_category_desc' => 'これは $1 カテゴリです。',
	'sf_blank_namespace' => '標準',
	'right-viewedittab' => 'フォームによって編集可能なページの「編集」タブが表示される',
	'right-editrestrictedfields' => '制限があるフォームのフィールドを編集する',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 * @author Pras
 */
$messages['jv'] = array(
	'sf_createproperty_propname' => 'Jeneng sifat/properti:',
	'sf_createproperty_proptype' => 'Jenis:',
	'templates' => 'Cithakan-cithakan',
	'sf_templates_docu' => 'Cithakan-cithakan iki ana ing wiki iki.',
	'sf_templates_definescat' => 'namtokaké kategori:',
	'createtemplate' => 'Nggawé cithakan',
	'sf_createtemplate_namelabel' => 'Jeneng cithakan:',
	'sf_createtemplate_fieldname' => 'Jeneng lapangan:',
	'sf_createtemplate_semanticproperty' => 'Sifat sémantik:',
	'sf_createtemplate_aggregationlabel' => 'Irah-irahan kanggo daftar:',
	'sf_createtemplate_standardformat' => 'Baku',
	'sf_createtemplate_deletefield' => 'Busak',
	'forms' => 'Formulir-formulir',
	'createform' => 'Nggawé formulir',
	'sf_createform_template' => 'Cithakan:',
	'sf_createform_templatelabelinput' => 'Label cithakan (opsional):',
	'sf_createform_field' => 'Lapangan:',
	'sf_createform_inputtype' => 'Jenis input:',
	'sf_createform_inputtypedefault' => '(baku)',
	'sf_createform_formlabel' => 'Label formulir:',
	'sf_createform_hidden' => 'Kadelikaké',
	'sf_createform_restricted' => 'Diwatesi (namung para panganggo opsis sing bisa modifikasi)',
	'sf_createform_removetemplate' => 'Ilangana cithakan',
	'sf_createform_add' => 'Tambah',
	'createcategory' => 'Gawé kategori',
	'sf_createcategory_name' => 'Jeneng kategori:',
	'sf_createcategory_defaultform' => 'Formulir baku:',
	'sf_editsource' => 'Sunting sumber',
	'sf_formedit_edittitle' => 'Sunting $1: $2',
	'sf_formedit_remove' => 'Busak',
	'sf_formedit_addanother' => 'Tambah liyané',
	'sf_formedit_none' => 'Ora ana',
	'sf_blank_error' => 'ora olèh kosong',
	'sf_bad_email_error' => 'kudu duwé format alamat e-mail sing absah',
	'sf_bad_number_error' => 'kudu angka sing absah',
	'sf_bad_integer_error' => 'kudu integer sing absah',
	'sf_bad_date_error' => 'kudu tanggal sing absah',
	'sf_template_docufooter' => 'Suntingen kacané kanggo ndeleng tèks cithakan.',
	'sf_form_freetextlabel' => 'Tèks bébas',
	'sf_category_hasdefaultform' => 'Kategori iki nganggo formulir $1.',
	'sf_category_desc' => 'Iki kategori $1',
	'sf_blank_namespace' => 'Utama',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Chhorran
 * @author Lovekhmer
 * @author Thearith
 * @author គីមស៊្រុន
 * @author វ័ណថារិទ្ធ
 */
$messages['km'] = array(
	'specialpages-group-sf_group' => 'ទម្រង់​និឃណ្ដសាស្ត្រ',
	'createproperty' => 'បង្កើត​លក្ខណៈសម្បត្តិ',
	'sf_createproperty_propname' => 'ឈ្មោះលក្ខណៈសម្បត្តិ៖',
	'sf_createproperty_proptype' => 'ប្រភេទ៖',
	'templates' => 'ទំព័រគំរូ',
	'sf_templates_docu' => 'ខាងក្រោមនេះជាទំព័រគំរូដែលមានក្នុងវិគីនេះ។',
	'sf_templates_definescat' => 'ដាក់ឈ្មោះឱ្យចំណាត់ថ្នាក់ក្រុម៖',
	'createtemplate' => 'បង្កើតទំព័រគំរូ',
	'sf_createtemplate_namelabel' => 'ឈ្មោះទំព័រគំរូ៖',
	'sf_createtemplate_displaylabel' => 'បង្ហាញ​ស្លាក:',
	'sf_createtemplate_aggregationlabel' => 'ចំណងជើង​សម្រាប់​បញ្ជី:',
	'sf_createtemplate_outputformat' => 'ទ្រ់ង់ទ្រាយ​ទិន្នផល:',
	'sf_createtemplate_standardformat' => 'ស្តង់ដារ',
	'sf_createtemplate_infoboxformat' => 'ប្រអប់​ព័ត៌មាន​ខាងស្ដាំដៃ',
	'sf_createtemplate_addfield' => 'បន្ថែម​វាល',
	'sf_createtemplate_deletefield' => 'លុបចេញ',
	'sf_createtemplate_addtemplatebeforesave' => 'អ្នក​ត្រូវតែ​បន្ថែម​ទំព័រគំរូ​យ៉ាងតិចមួយ​ទៅក្នុង​ទម្រង់​នេះ មុនពេល​អ្នក​អាច​រក្សា​វា​ទុក​។',
	'forms' => 'បែបបទ',
	'sf_forms_docu' => 'ទម្រង់​ដូចតទៅនេះ មាន​នៅ​ក្នុង​វិគី​រួច​ហើយ​។',
	'createform' => 'បង្កើត មួយបែបបទ',
	'sf_createform_template' => 'ទំព័រគំរូ៖',
	'sf_createform_templatelabelinput' => 'ប្លាកគំរូខ្នាត (ជំរើស):',
	'sf_createform_field' => 'វាល:',
	'sf_createform_inputtypedefault' => '(លំនាំដើម)',
	'sf_createform_formlabel' => 'ស្លាក​ទម្រង់:',
	'sf_createform_hidden' => 'ត្រូវបានលាក់',
	'sf_createform_restricted' => 'ត្រូវ​បាន​កម្រិត (មានតែ​អ្នកភិបាលបាល​ប៉ុណ្ណោះ​ទើប​មាន​សិទ្ធិ​កែប្រែ​បាន)',
	'sf_createform_removetemplate' => 'ដកទំព័រគំរូ​ចេញ',
	'sf_createform_addtemplate' => 'បន្ថែម​ទំព័រគំរូ:',
	'sf_createform_beforetemplate' => 'មុនទំព័រគំរូ:',
	'sf_createform_atend' => 'នៅ​ទីបញ្ចប់',
	'sf_createform_add' => 'បន្ថែម',
	'sf_createform_choosefield' => 'ជ្រើសរើស​វាល​ដើម្បី​បន្ថែម',
	'createcategory' => 'បង្កើតចំណាត់ថ្នាក់ក្រុម',
	'sf_createcategory_name' => 'ឈ្មោះចំណាត់ថ្នាក់ក្រុម៖',
	'sf_createcategory_defaultform' => 'បែបបទលំនាំដើម៖',
	'sf_createcategory_makesubcategory' => 'ដាក់​ចំណាត់ថ្នាក់ក្រុមរង​នេះ ទៅនឹង​ចំណាត់ថ្នាក់ក្រុម​ដទៃ (តាមបំណង):',
	'formstart' => 'បន្ថែមទំព័រ​ជាមួយ​ទម្រង់',
	'sf_formstart_badform' => 'កំហុស: គ្មាន​ទំព័រទម្រង់​ត្រូវ​បាន​រកឃើញ​នៅ $1 ទេ',
	'sf_formstart_createoredit' => 'បន្ថែមឬកែប្រែ',
	'formedit' => 'កែប្រែបែបបទនេះ',
	'sf_formedit_createtitle' => 'បន្ថែម $1: $2',
	'sf_viewform' => 'មើលបែបបទ',
	'sf_editsource' => 'កែប្រែកូដ',
	'sf_formedit_edittitle' => 'កែប្រែ $1: $2',
	'sf_formedit_formwarning' => 'ការព្រមាន: ទំព័រ​នេះ <a href="$1">មាន​រួចហើយ</a> ប៉ុន្តែ​វា​មិនអាច​ប្រើប្រាស់​ទម្រង់​នេះ​បាន​ទេ​។',
	'sf_formedit_remove' => 'ដកចេញ',
	'sf_formedit_addanother' => 'បន្ថែមមួយផ្សេងទៀត',
	'sf_formedit_none' => 'ទទេ',
	'sf_formerrors_header' => 'បាន​មាន​កំហុស​ជាមួយ​ការបញ្ចូល​ទម្រង់​របស់​អ្នក, សូម​មើល​ខាងក្រោម',
	'sf_blank_error' => 'មិនអាចទទេទេ',
	'sf_bad_url_error' => "ត្រូវតែ​មាន​ទ្រង់ទ្រាយ URL ត្រឹមត្រូវ ដែល​ផ្ដើមឡើង​ជាមួយ 'http'",
	'sf_bad_email_error' => 'ទម្រង់អាសយដ្ឋានអ៊ីមែល មិនត្រឹមត្រូវ',
	'sf_bad_number_error' => 'ត្រូវតែ​ជា​លេខ​ត្រឹមត្រូវ',
	'sf_bad_integer_error' => 'ត្រូវតែ​ជា​ចំនួនគត់​ត្រឹមត្រូវ',
	'sf_bad_date_error' => 'ត្រូវតែ​ជា​កាលបរិច្ឆេទ​ត្រឹមត្រូវ',
	'uploadwindow' => 'ផ្ទុក​បង្អួច​ឡើង',
	'sf_property_isproperty' => 'នេះ​គឺជា​លក្ខណៈសម្បត្តិមួយ​នៃ​គំរូ $1 ។',
	'sf_property_allowedvals' => 'តម្លៃ $1 ​ដែល​ត្រូវ​បាន​អនុញ្ញាត​សម្រាប់​លក្ខណៈសម្បត្តិ​នេះ​មាន៖',
	'sf_template_docu' => "នេះ​គឺជា​ទំព័រគំរូ '$1' ។
វា​នឹង​ត្រូវ​គេ​ហៅ​មកប្រើប្រាស់ នៅក្នុង​ទ្រង់ទ្រាយ​ដូចតទៅ៖",
	'sf_template_docufooter' => 'កែប្រែទំព័រ ដើម្បីឃើញអត្ថបទគំរូ ។',
	'sf_form_docu' => "នេះ​គឺ​ជាបែប​បទ​​ '$1'​។ ដើម្បី​បន្ថែម​ទំព័រ​មួយ​ជាមួយ​បែប​បទ​​នេះ​ សូមវាយ​បញ្ចូល​ឈ្មោះ​ទំព័រ​ខាង​ក្រោម​។​ ប្រសិន​បើ​មានទំព័រ​ដែល​មានឈ្មោះ​នោះ​រួច​ហើយ​ អ្នក​នឹង​ត្រូវ​បាន​ផ្ញើ​ទៅ​កាន់​បែប​បទ​​មួយ​ដើម្បី​កែប្រែ​ទំព័រ​នោះ​។​",
	'sf_form_freetextlabel' => 'អត្ថបទ​សេរី​',
	'sf_category_hasdefaultform' => 'ចំណាត់ក្រុមនេះ ប្រើប្រាស់បែបបទ $1 ។',
	'sf_category_desc' => 'នេះ​គឺជា​ចំណាត់ថ្នាក់ក្រុម $1 ។',
	'sf_blank_namespace' => 'ចម្បង​',
);

/** Kannada (ಕನ್ನಡ)
 * @author Nayvik
 */
$messages['kn'] = array(
	'sf_createtemplate_deletefield' => 'ಅಳಿಸು',
);

/** Krio (Krio)
 * @author Jose77
 */
$messages['kri'] = array(
	'sf_createtemplate_deletefield' => 'Dilit',
);

/** Kinaray-a (Kinaray-a)
 * @author Jose77
 */
$messages['krj'] = array(
	'sf_createtemplate_deletefield' => 'Para',
	'sf_createform_template' => 'Template',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'semanticforms-desc' => 'Fommulaare för Semantesch Date dabei ze donn, un och ze ändere',
	'specialpages-group-sf_group' => 'Semantesch Fommulaare',
	'createproperty' => 'Donn en Eijeschaff aanlääje',
	'sf_createproperty_linktoform' => 'Die Eijeschaff deiht dann op Sigge lingke, di hee dat Fommullaa bruche:',
	'sf_createproperty_allowedvalsinput' => 'Wann för die Eijeschaff bloß janz beshtemmpte Wääte müjjelesch sin, dann donn die hee op_leste. Schriif jede Wäät einzel op, un maach e Komma dozwsche. Wann De ene Wäät häs, woh e Komma en däm Wäät sellver dren enthallde es, donn för dat Komma ene <code>\\</code> schriive, alsu esu jet wi „<code>Mätze\\, Läffelle\\, un Jaffelle</code>“:',
	'sf_createproperty_propname' => 'Dä Eijeschaff ier Name:',
	'sf_createproperty_proptype' => 'Zoot:',
	'templates' => 'Schablone',
	'sf_templates_docu' => 'Hee di Schablone jidd_et em Wiki:',
	'sf_templates_definescat' => 'beshtemmp de Saachjrop:',
	'createtemplate' => 'En Schabloon aanlääje',
	'sf_createtemplate_namelabel' => 'Dä Schabloon iere Name:',
	'sf_createtemplate_categorylabel' => 'Met dä Schabloon beschrevve Saachjropp, wann_er ein doh es:',
	'sf_createtemplate_templatefields' => 'Felder vun de Schablohn',
	'sf_createtemplate_fieldsdesc' => 'Öm Felder en dä Schabloon ze han, moß De kein Name för di Felder mieh aanjevve. Et es jenooch, dänne ier Nommere ze weße, donn eifach 1, 2, 3, un esu wigger aanjevve, aan däm Plaz för de Name.',
	'sf_createtemplate_fieldname' => 'Dä Name för dat Feld:',
	'sf_createtemplate_displaylabel' => 'För Aanzezeije, de Opschreff för dat Feld:',
	'sf_createtemplate_semanticproperty' => 'Semantesch Eijeschaff:',
	'sf_createtemplate_fieldislist' => 'En dämm Feld kann en Leß met Wääte shtonn, met Kommas dozwesche',
	'sf_createtemplate_aggregation' => 'Aansammlong',
	'sf_createtemplate_aggregationdesc' => 'Öm op jede Sigg, di di Schabloon he bruch, all de Sigge opzeleste, di_j_en beshtemmpte Eijeschaff han, di op hee di Sigg zeije deiht, donn jenou di Eijeschaff hee dronger aanjevve:',
	'sf_createtemplate_aggregationlabel' => 'De Överschreff för de Leß:',
	'sf_createtemplate_outputformat' => 'Dat Fommaat för et Ußjävve:',
	'sf_createtemplate_standardformat' => 'Shtanndat',
	'sf_createtemplate_infoboxformat' => 'Ene Kaste op de rääschte Sigg',
	'sf_createtemplate_addfield' => 'E Feld dobei donn',
	'sf_createtemplate_deletefield' => 'Fottschmieße',
	'sf_createtemplate_addtemplatebeforesave' => 'Do moß ald winnishßdens ein Schabloon en dat Fommulaa enjedraare hann, ih dat De jet afspeishere kanns.',
	'forms' => 'Fommulaare',
	'sf_forms_docu' => 'Hee di Fommulaare ham_mer em Wiki.',
	'createform' => 'Donn e Fommulaa aanlääje',
	'sf_createform_nameinput' => 'Dä Name för dat Fommulaa',
	'sf_createform_nameinputdesc' => '(För jewöhnlesch deiht mer dat Fommulaa noh dä Houp-Schabloon deufe, woh et Date erin brängk):',
	'sf_createform_template' => 'Schabloon:',
	'sf_createform_templatelabelinput' => 'Dä Name vun dä Schablon, wann ein jebruch weed:',
	'sf_createform_allowmultiple' => 'Donn zwesche noll un jede Aanzahl Oproofe vun dä Schabloon hee, en dä neu aanjelaate Sigg zohlohße',
	'sf_createform_field' => 'Feld:',
	'sf_createform_fieldprop' => 'Dat Feld beschrief de Eijeschaff „$1“. Se es vun dä Zoot „$2“.',
	'sf_createform_fieldproplist' => 'Dat Feld beschrief en Leß met Ellemänte met dä Eijeschaff „$1“, vun dä Zoot „$2“.',
	'sf_createform_fieldpropunknowntype' => 'Dat Feld beschrief de Eijeschaff „$1“, wat fö_n Zoot Eijeschaff dat dat es, es nit jesaat.',
	'sf_createform_inputtype' => 'De Zoot vun dä Date för enzejävve:',
	'sf_createform_inputtypedefault' => '(dä Shtandatt)',
	'sf_createform_formlabel' => 'Däm Fommulaa singe Name:',
	'sf_createform_hidden' => 'Vershtoche',
	'sf_createform_restricted' => 'Bloß de Wiki-Köbesse künne hee jet draan ändere.',
	'sf_createform_mandatory' => 'Nüüdesch',
	'sf_createform_removetemplate' => 'Maach de Schabloon fott',
	'sf_createform_addtemplate' => 'Donn en Schabloon dobei:',
	'sf_createform_beforetemplate' => 'Vör dä Schabloon:',
	'sf_createform_atend' => 'Aam Engk',
	'sf_createform_add' => 'Donn dobei',
	'sf_createform_choosefield' => 'Donn a Feld ußwähle, wat dobei kumme sull',
	'createcategory' => 'Donn en {{ns:Category}} aanlääje',
	'sf_createcategory_name' => 'Dä Saachjropp iere Name:',
	'sf_createcategory_defaultform' => 'Dat Shtandatt-Fommulaa:',
	'sf_createcategory_makesubcategory' => 'Donn di Saachjropp als Ongerjropp endraare en dä Saachjropp (udder lohß leddisch):',
	'createclass' => 'Zoot ov Klass aanlääje.',
	'sf_createclass_docu' => 'Donn hee all de Date enjevve, öm de Eijeschaffte, de SChabloon, dat Fommulaa, un de Saachjropp för en einzel Zoot ov Klass aanzelääje. Wann de mieh Müjjeleschkeite wells, donn de Sigg $1 doför nämme.',
	'sf_createclass_allowedvalues' => 'Zohjelohße Wääte',
	'sf_createclass_listofvalues' => 'Leß met Wääte',
	'sf_createclass_leavefieldblank' => 'Wann dat Feld dersellve Name hät, wi de Eijeschaff, dann bruchs De däm singe Name nit ußzefölle.',
	'sf_createclass_missingvalues' => 'Nit alle vun de nüüdejje Felder sin ußjeföllt.',
	'sf_createclass_success' => 'De Eijeschaffte, en Schabloon, dat Fommulaa, un de Saachjrupp wäde aanjelaat.',
	'formstart' => 'Donn en Sigg dobei övver e Fommullaa',
	'sf_formstart_badform' => 'Ene Fähler es opjetrodde: Mer han kei Fommullaa „$1“ jefonge.',
	'sf_formstart_badtitle' => 'Fähler: „$1“ es ene onjöltige Sigggetittel.',
	'sf_formstart_docu' => 'Jiff hee dä Name vun dä Sigg en, di mem Fommulaa „$1“ beärbeidt wäde sull. Wann de Sigg ald doh es, küß De op dat Fommullaa, för di Sigg ze ändere. Söns küß De op dat Fommullaa för di Sigg aanzelääje.',
	'sf_formstart_noform_docu' => 'Jiff hee dä Name vun däm Sigg en, un donn dat Fommulaa ußsööke woh drövver di Sigg beärbeidt wäde sull. Wann di Sigg ald doh es, küß De op dat Fommullaa, för di Sigg ze ändere. Söns küß De op dat Fommullaa för di Sigg aanzelääje.',
	'sf_formstart_createoredit' => 'Dobei donn udder Ändere',
	'formedit' => 'Date övver e Fommullaa änndere',
	'sf_formedit_createtitle' => 'Donn $1 dobei: $2',
	'sf_formedit_badurl' => "Date es de Sigg för Date dobei ze donn. Do moß ene Name för e Fommulaa un för en Sigg an dä ierem <i lang=\"en\">URL</i> aanjevve. Dat sullt eu ähnlesch ußsinn, wieh: <code>{{#special:addData}}?form=''&lt;Fomullaa_Name&gt;''&target=''&lt;Sigge_Name&gt;''</code>, udder wi: <code>{{#special:addData}}/''&lt;Fomullaa_Name &gt;''/''&lt;Sigge_Name&gt;''</code>.",
	'sf_formedit_altforms' => 'Shtatt dämm kanns De di Sigg övver ein vun hee dä Fommulaare aanlääje:',
	'sf_formedit_altformsonly' => 'Donn ein vun dä Fommulaare ußwähle, öm di Sigg aanzelääje:',
	'sf_formcreate' => 'Övver e Fommulaa aanlääje',
	'sf_viewform' => 'Dat Fommullaa aanzeije',
	'sf_editsource' => 'Dä Quellkode Ändere',
	'sf_formedit_edittitle' => '$1 Ändere: $2',
	'sf_formedit_morethanoneform' => 'Opjepaß: Dör di Sigg hee es mieh wie ein Shtandadt-Fommulaa ennjeshtallt.',
	'sf_formedit_formwarning' => 'Opjepaß: Di Sigg <a href="$1">jidd_et aldt</a>, ävver se deiht hee dat Fommulaa nit bruche.',
	'sf_formedit_remove' => 'Fott nämme',
	'sf_formedit_addanother' => 'Donn noch mieh dobei',
	'sf_formedit_none' => 'Kei',
	'runquery' => 'De Frooch loufe lohße',
	'sf_runquery_badurl' => "Do moß en däm <i lang=\"en\">URL</i> ene Nahme för e Fommulaa aanjävve.
Dat süüht dann esu us, wi <code>{{#special:RunQuery}}/''&lt;Fomullaa_Name &gt;''</code>.",
	'sf_runquery_title' => 'De Frooch „<code>$1</code>“ loufe lohße',
	'sf_runquery_additionalquery' => 'Zohsäzlejje Frooch',
	'sf_formerrors_header' => 'Mer han Fähler jefonge en däm, wat De enjejovve häß. Süsch doh:',
	'sf_blank_error' => 'kam_mer nit leddisch lohße',
	'sf_bad_url_error' => 'moß et reschteje Fomaat för en <i lang="en">URL</i> han un moß met <code>http</code> aanfange',
	'sf_bad_email_error' => 'moß et reschteje Fomaat för en <i lang="en">e-mail</i>-Adräß hann',
	'sf_bad_number_error' => 'moß en reschteje Zahl sin',
	'sf_bad_integer_error' => 'moß en reschteje janze Zahl sin',
	'sf_bad_date_error' => 'moß e reschtesch Dattum sin',
	'uploadwindow' => 'Dat Finster för zem Huhlaade',
	'sf_deletionlog' => 'Logbooch vum Sigge Verschteische',
	'sf_property_isproperty' => 'Dat ess_en Eijeschaff vun dä Zoot $1.',
	'sf_property_linkstoform' => 'Et hät ene Lengk op Sigge, di dat Fommulaa „$1“ verwende donn.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Dä einzijje müjjelesche Wäät för di Eijeschaff es:|De müjjelesche Wääte för di Eijeschaff sin:|Mer han kein müjjelesche Wääte för di Eijeschaff.}}',
	'sf_template_docu' => 'Dat es de Schabloon för „$1“, un dat Fommaat för se opzeroofe es:',
	'sf_template_docufooter' => 'Donn di Sigg zom Ändere oproofe, öm dä Schablone iere Enhalldt als Tex ze sinn ze krijje.',
	'sf_form_docu' => 'Dat hee de dat Fommullaa „$1“.
Öm hee met en Sigg aanzelääje, donn unge dä Name för di Sigg endraare. Sullt di Sigg ald doh sin, küß De op dat Fommullaa för di Sigg ze ändere.',
	'sf_form_freetextlabel' => 'Freije Tex',
	'sf_category_hasdefaultform' => 'Hee di Saachjropp bruch dat Fommulaa „$1“.',
	'sf_category_desc' => 'Dat es de Saachjropp „$1“.',
	'sf_blank_namespace' => '{{int:blanknamespace}}',
	'right-viewedittab' => '„{{int:edit}}“-Lengk för Sigge, die mer övver Fommulaare ändere kann',
	'right-editrestrictedfields' => 'Beschrängk zohjänglijje Felder en Fommulaare ändere',
);

/** Cornish (Kernewek)
 * @author Kernoweger
 * @author Kw-Moon
 */
$messages['kw'] = array(
	'createtemplate' => 'Gwruthyl skantlyn',
	'sf_createform_template' => 'Skantlyn:',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Les Meloures
 * @author Robby
 */
$messages['lb'] = array(
	'specialpages-group-sf_group' => 'Semantesch Formulairen',
	'sf_createproperty_propname' => 'Numm vun der Eegeschaft:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Schablounen',
	'sf_templates_docu' => 'Dës Schabloune gëtt et op dëser Wiki.',
	'sf_templates_definescat' => "definéiert d'Kategorie:",
	'createtemplate' => 'Eng nei Schabloun maachen',
	'sf_createtemplate_namelabel' => 'Numm vun der Schabloun:',
	'sf_createtemplate_categorylabel' => 'Kategorie déi duerch eng Schabloun definéiert ass (fakultativ):',
	'sf_createtemplate_templatefields' => 'Schablounefelder',
	'sf_createtemplate_fieldname' => 'Numm vum Feld:',
	'sf_createtemplate_displaylabel' => 'Etiquette weisen:',
	'sf_createtemplate_aggregation' => 'Resumé',
	'sf_createtemplate_aggregationlabel' => "Titel fir d'Lëscht:",
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_addfield' => 'Feld derbäisetzen',
	'sf_createtemplate_deletefield' => 'Läschen',
	'sf_createtemplate_addtemplatebeforesave' => 'Dir musst mindestens eng Schabloun an dëser Formulaire drasetzen ier Dir e späichere kënnt.',
	'forms' => 'Formulairen',
	'sf_forms_docu' => 'Dës Formulaire gëtt et op dëser Wiki.',
	'createform' => 'E Formulaire uleeën',
	'sf_createform_nameinput' => 'Numm vum Formulaire',
	'sf_createform_template' => 'Schabloun:',
	'sf_createform_templatelabelinput' => 'Etiquette vun der Schabloun (fakultativ)',
	'sf_createform_field' => 'Feld:',
	'sf_createform_inputtypedefault' => '(Standardwert)',
	'sf_createform_formlabel' => 'Etikett vum Formulaire:',
	'sf_createform_hidden' => 'Verstoppt',
	'sf_createform_restricted' => 'Gespaart (Nëmmen Administrateuren kënnen et änneren)',
	'sf_createform_mandatory' => 'Obligateresch',
	'sf_createform_removetemplate' => 'Schablon ewechhuelen',
	'sf_createform_addtemplate' => 'Schabloun derbäisetzen:',
	'sf_createform_beforetemplate' => "Virun d'Schabloun:",
	'sf_createform_atend' => 'Um Enn',
	'sf_createform_add' => 'Derbäisetzen',
	'createcategory' => 'Eng Kategorie maachen',
	'sf_createcategory_name' => 'Numm vun der Kategorie:',
	'sf_createcategory_defaultform' => 'Standard-Formulaire:',
	'sf_createclass_allowedvalues' => 'Zougeloosse Wäerter',
	'sf_createclass_listofvalues' => 'Lëscht vun de Wäerter',
	'sf_createclass_missingvalues' => 'Et goufen net all erfuederlech Felder ausgefëllt.',
	'formstart' => 'Säit mat engem Formulaire derbäisetzen',
	'sf_formstart_badform' => 'Feeler: et gouf keng Formulaire-Säit op $1 fonnt.',
	'sf_formstart_badtitle' => 'Feeler: "$1" ass kee valaben Titel fir eng Säit',
	'sf_formstart_createoredit' => 'Uleeën oder änneren',
	'formedit' => 'Formulaire änneren',
	'sf_formedit_createtitle' => '$1: $2 uleeën',
	'sf_formedit_altforms' => 'Dir kënnt dës Säit och mat engem vun dëse Formulairen derbäisetzen:',
	'sf_formedit_altformsonly' => 'Sicht w.e.g. e vun dëse Formulairen eraus fir dës Säit derbäizesetzen:',
	'sf_formcreate' => 'Mat engem Formulaire gemaach',
	'sf_viewform' => 'Formulaire weisen',
	'sf_editsource' => 'Quelltext änneren',
	'sf_formedit_edittitle' => 'Ännert $1: $2',
	'sf_formedit_formwarning' => 'Opgepasst: Dës Säit <a href="$1">gëtt et schonn</a>, awer si benotzt dëse Formulaire net.',
	'sf_formedit_remove' => 'Ewech huelen',
	'sf_formedit_addanother' => 'Nach een derbäisetzen',
	'sf_formedit_none' => 'Keen',
	'runquery' => 'Ufro ausféieren',
	'sf_runquery_title' => 'ausféiere vu der Ufro: $1',
	'sf_runquery_additionalquery' => 'Zousätzlech Ufro',
	'sf_formerrors_header' => 'Et ware Feeler andeem wat Dir an de Formulaire aginn hutt; kuckt hei ënnendrënner',
	'sf_blank_error' => 'Däerf net eidel sinn!',
	'sf_bad_url_error' => "muss de korrekten URL-format hunn, a mat 'http' ufänken",
	'sf_bad_email_error' => 'muss e valabelen E-Mailadresse-Format hunn',
	'sf_bad_number_error' => 'muss eng valabel Zuel sinn',
	'sf_bad_integer_error' => 'muss eng valabel ganz Zuel sinn',
	'sf_bad_date_error' => 'muss e gëltegen Datum sinn',
	'uploadwindow' => 'Fënster fir eropzelueden',
	'sf_deletionlog' => 'Logbuch vum Läschen',
	'sf_property_linkstoform' => 'Et ass mat Säite verlinkt déi de Formulaire $1 benotzen.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Den erlaabte Wäert fir dës Eegeschaft ass|Déi erlaabte Wäerter fir dës Eegeschaft sinn}}:',
	'sf_template_docu' => "Dëst ass d''$1'-Schabloun.
Si soll an dësem Format opgeruff ginn:",
	'sf_template_docufooter' => "Ännert d'Säit fir den Text vun der Schabloun ze gesinn",
	'sf_form_freetextlabel' => 'Fräien Text',
	'sf_category_hasdefaultform' => 'Dës Kategorie benotzt de Formelär $1.',
	'sf_category_desc' => "Dëst ass d'$1 Kategorie.",
	'sf_blank_namespace' => 'Haapt',
	'right-viewedittab' => '"Änneren"-Tab fir Säiten, déi duerch e Formlaire geännert kënne ginn, weisen',
);

/** Limburgish (Limburgs)
 * @author Ooswesthoesbes
 */
$messages['li'] = array(
	'createproperty' => 'Eigesjap aanmake',
	'sf_createproperty_propname' => 'Naam:',
	'sf_createproperty_proptype' => 'Type:',
	'templates' => 'Sjablone',
	'createtemplate' => "'n Sjabloon aanmake",
	'forms' => 'Formelere',
	'createform' => 'Formeleer aanmake',
	'createcategory' => "'n Categorie aanmake",
	'formstart' => 'Pazjena toevoge',
	'sf_formstart_createoredit' => 'Toevoge of bewèrke',
	'formedit' => 'Bewèrke mit dit formeleer',
	'sf_formedit_createtitle' => '$1 toevoge: $2',
	'sf_editsource' => 'Brón bewèrke',
	'sf_formedit_edittitle' => '$1 bewèrke: $2',
);

/** Lithuanian (Lietuvių)
 * @author Domas
 */
$messages['lt'] = array(
	'createproperty' => 'Sukurti savybę',
	'sf_createproperty_allowedvalsinput' => 'Jeigu norite, kad šis laukas galėtų įgyti tik konkrečias reikšmes, surašykite visas leistinas reikšmes, atskirtas kableliais (jeigu reikšmė turi kablelį, pakeiskite jį į „\\,“):',
	'sf_createproperty_propname' => 'Vardas:',
	'sf_createproperty_proptype' => 'Tipas:',
	'templates' => 'Šablonai',
	'sf_templates_docu' => 'Šiame sąraše pateikiami visi šablonai.',
	'sf_templates_definescat' => 'apibrėžia kategoriją:',
	'createtemplate' => 'Sukurti šabloną',
	'sf_createtemplate_namelabel' => 'Šablono vardas:',
	'sf_createtemplate_categorylabel' => 'Kategorija apibrėžiama šiuo šablonu (nebūtina):',
	'sf_createtemplate_templatefields' => 'Šablono laukai',
	'sf_createtemplate_fieldsdesc' => 'Šablonui reikšmės gali būti nurodomos ir be laukų vardų. Tokiu atvėju šioje formoje vietoj konkrečių laukų vardų turėtų būti nurodomi indeksai (pvz. 1, 2, 3 ir t. t.).',
	'sf_createtemplate_fieldname' => 'Lauko vardas:',
	'sf_createtemplate_displaylabel' => 'Rodomas užrašas:',
	'sf_createtemplate_semanticproperty' => 'Semantinė savybė:',
	'sf_createtemplate_fieldislist' => 'Šis laukas gali turėti kelias kableliais atskirtas reikšmes.',
	'sf_createtemplate_aggregation' => 'Savybių surinkimas',
	'sf_createtemplate_aggregationdesc' => 'Užpildykite šiuos laukus, jeigu norite, kad kiekviename šį šabloną naudojančiame puslapyje būtų pateiktas straipsnių, kurie konkrečia savybe rodo į tą puslapį, sąrašas:',
	'sf_createtemplate_aggregationlabel' => 'Sąrašo pavadinimas:',
	'sf_createtemplate_outputformat' => 'Išvedimo formatas:',
	'sf_createtemplate_standardformat' => 'Standartinis',
	'sf_createtemplate_infoboxformat' => 'Informacinis langas dešinėje',
	'sf_createtemplate_addfield' => 'Pridėti lauką',
	'sf_createtemplate_deletefield' => 'Pašalinti',
	'sf_createtemplate_addtemplatebeforesave' => 'Prieš išsaugant šią formą, būtina pridėti bent vieną lauką.',
	'forms' => 'Formos',
	'sf_forms_docu' => 'Šiame sąraše pateikiamos visos formos.',
	'createform' => 'Sukurti formą',
	'sf_createform_nameinput' => 'Formos vardas (dažniausiai priimtina pavadinti pagrindinio formoje naudojamo šablono vardu):',
	'sf_createform_template' => 'Šablonas:',
	'sf_createform_templatelabelinput' => 'Šablono kortelės užrašas (nebūtinas):',
	'sf_createform_allowmultiple' => 'Leisti kelis (arba nė vieno) šio šablono vienetus sukurtame puslapyje',
	'sf_createform_field' => 'Laukas:',
	'sf_createform_fieldprop' => 'Šis laukas apibrėžia „$2“ tipo savybę „$1“.',
	'sf_createform_fieldproplist' => 'Šis laukas apibrėžia elementų turinčių „$2“ tipo savybę „$1“.',
	'sf_createform_fieldpropunknowntype' => 'Šis laukas apibrėžia neapibrėžto tipo savybę „$1“.',
	'sf_createform_inputtype' => 'Įvedimo tipas:',
	'sf_createform_inputtypedefault' => '(pagrindinis)',
	'sf_createform_formlabel' => 'Formos užrašas:',
	'sf_createform_hidden' => 'Paslėptas',
	'sf_createform_restricted' => 'Apribotas (jį redaguoti gali tik sysop naudotojai)',
	'sf_createform_mandatory' => 'Privalomas',
	'sf_createform_removetemplate' => 'Pašalinti šabloną',
	'sf_createform_addtemplate' => 'Pridėti šabloną:',
	'sf_createform_beforetemplate' => 'Prieš šabloną:',
	'sf_createform_atend' => 'Pabaigoje',
	'sf_createform_add' => 'Pridėti',
	'sf_createform_choosefield' => 'Pasirinkite pridedama lauką',
	'createcategory' => 'Sukurti kategoriją',
	'sf_createcategory_name' => 'Vardas:',
	'sf_createcategory_defaultform' => 'Pagrindinė forma:',
	'sf_createcategory_makesubcategory' => 'Padaryti kaip subkategoriją kitai kategorijai (nebūtina):',
	'formstart' => 'Sukurti puslapį naudojant formą',
	'sf_formstart_badform' => 'Klaida: nerastas naudojantis formą $1 puslapis',
	'sf_formstart_docu' => 'Įveskite puslapio vardą, kurį redaguosite su forma „$1“. Jeigu puslapis tokiu vardu egzistuoja, būsite nukreiptas į šio puslapio redagavimo formą. Kitu atveju, būsite nukreiptas į naujo puslapio kūrimo formą.',
	'sf_formstart_noform_docu' => 'Įveskite puslapio vardą ir pasirinkite formą kuria jį redaguosite. Jeigu puslapis tokiu vardu egzistuoja, būsite nukreiptas į šio puslapio redagavimo formą. Kitu atveju, būsite nukreiptas į naujo puslapio kūrimo formą.',
	'sf_formstart_createoredit' => 'Pridėti ar keisti',
	'formedit' => 'Redaguoti su forma',
	'sf_formedit_createtitle' => 'Pridėti $1: $2',
	'sf_formedit_badurl' => "Šis puslapis skirtas naujų duomenų įvedimui. Jūs turite adrese nurodyti formos vardą ir norimą redaguoti puslapį. Adresas turėtų atrodyti kaip „Specialus:FormEdit?form=&lt;formos vardas&gt;&target=&lt;puslapis&gt;“ arba „Specialus:FormEdit/&lt;formos vardas&gt;/&lt;puslapis&gt;'“.",
	'sf_formedit_altforms' => 'Sukurti puslapį galite naudodami vieną iš šių formų:',
	'sf_formedit_altformsonly' => 'Pasirinkite vieną iš šių formų puslapio sukūrimui:',
	'sf_viewform' => 'Rodyti formą',
	'sf_editsource' => 'Redaguoti kodą',
	'sf_formedit_edittitle' => 'Redaguoti $1: $2',
	'sf_formedit_formwarning' => 'Dėmesio: Šis puslapis <a href="$1">jau yra</a>, bet jis nenaudoja šios formos.',
	'sf_formedit_remove' => 'Pašalinti',
	'sf_formedit_addanother' => 'Pridėti kitą',
	'sf_formedit_none' => 'Nieko',
	'sf_formerrors_header' => 'Pildomoje formoje yra klaidų. Žiūrėkite žemiau',
	'sf_blank_error' => 'negali būti tuščias',
	'sf_bad_url_error' => 'turi būti taisyklinga nuoroda (URL), prasidedanti „http“',
	'sf_bad_email_error' => 'turi būti taisyklingas el. pašto adresas',
	'sf_bad_number_error' => 'turi būti skaičius',
	'sf_bad_integer_error' => 'turi būti teigiamas skaičius',
	'sf_bad_date_error' => 'turi būti taisyklinga data',
	'uploadwindow' => 'Failo įkėlimo langas',
	'sf_property_isproperty' => 'Tai yra „$1“ tipo savybė.',
	'sf_property_allowedvals' => 'Šios savybės leidžiamos reikšmės yra:',
	'sf_template_docu' => 'Tai yra „$1“ šablonas.
Jis turėtų būti kviečiamas šiuo formatu formatu:',
	'sf_template_docufooter' => 'Norėdami matyti šablono tekstą, turite redaguoti puslapį.',
	'sf_form_docu' => 'Tai yra „$1“ forma.
Norėdami sukurti puslapį naudojantis šia forma, įveskite to pulslapio vardą žemiau.
Jeigu puslapis tokiu vardu jau egzistuoja, šia forma galėsite jį redaguoti.',
	'sf_form_freetextlabel' => 'Laisvas tekstas',
	'sf_category_hasdefaultform' => 'Ši kategorija naudoja „$1“ formą.',
	'sf_category_desc' => 'Tai yra „$1“ kategorija.',
	'sf_blank_namespace' => 'Pagrindinis',
);

/** Eastern Mari (Олык Марий)
 * @author Сай
 */
$messages['mhr'] = array(
	'sf_createtemplate_deletefield' => 'Шӧраш',
	'sf_createform_inputtypedefault' => '(ойлыде)',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 * @author Brest
 */
$messages['mk'] = array(
	'semanticforms-desc' => 'Обрасци за додавање и уредување на семантички податоци',
	'specialpages-group-sf_group' => 'Семантички обрасци',
	'createproperty' => 'Создај својство',
	'sf_createproperty_linktoform' => 'Ова својство ќе дава врски до страници што го користат образецот:',
	'sf_createproperty_allowedvalsinput' => 'Ако сакате ова својство да може да има само извесни вредности, внесете го списокот на дозволени вредности, одделени со запирки (ако некоја вредност содржи запирка, тогаш заменете ја запирката со „\\,“):',
	'sf_createproperty_propname' => 'Име на својството:',
	'sf_createproperty_proptype' => 'Тип:',
	'templates' => 'Шаблони',
	'sf_templates_docu' => 'Во викито постојат следниве шаблони.',
	'sf_templates_definescat' => 'дефинира категорија:',
	'createtemplate' => 'Создај шаблон',
	'sf_createtemplate_namelabel' => 'Име на шаблонот:',
	'sf_createtemplate_categorylabel' => 'Категорија дефинирана од шаблон (незадолжително):',
	'sf_createtemplate_templatefields' => 'Полиња на шаблонот:',
	'sf_createtemplate_fieldsdesc' => 'Ако сакате полињата во шаблонов повеќе да не бараат имиња, едноставно внесете индекс за секое поле (на пр. 1, 2, 3, и тн.) наместо фактичко име.',
	'sf_createtemplate_fieldname' => 'Име на полето:',
	'sf_createtemplate_displaylabel' => 'Наслов за прика:',
	'sf_createtemplate_semanticproperty' => 'Семантичко својство:',
	'sf_createtemplate_fieldislist' => 'Ова поле може да содржи список на вредности, одделени со запирки',
	'sf_createtemplate_aggregation' => 'Насобирање',
	'sf_createtemplate_aggregationdesc' => 'За да ги наведете сите страници што имаат извесно својство кое покажува кон таа страница на било која страница што го користи овој шаблон, назначете го соодветното својство подолу:',
	'sf_createtemplate_aggregationlabel' => 'Наслов за списокот:',
	'sf_createtemplate_outputformat' => 'Формат на изводот:',
	'sf_createtemplate_standardformat' => 'Стандарден',
	'sf_createtemplate_infoboxformat' => 'Инфокутија на десно',
	'sf_createtemplate_addfield' => 'Додај поле',
	'sf_createtemplate_deletefield' => 'Избриши',
	'sf_createtemplate_addtemplatebeforesave' => 'Пред да можете да го зачувате, во образецов мора да додадете барем еден шаблон.',
	'forms' => 'Обрасци',
	'sf_forms_docu' => 'Во викито постојат следниве обрасци.',
	'createform' => 'Создај образец',
	'sf_createform_nameinput' => 'Име на образецот',
	'sf_createform_nameinputdesc' => '(по обичај образецот се именува по главниот шаблон кој го содржи)',
	'sf_createform_template' => 'Шаблон:',
	'sf_createform_templatelabelinput' => 'Наслов на шаблонот (незадолжително):',
	'sf_createform_allowmultiple' => 'Овозможи повеќе (или нула) јавувања на овој шаблон во создадената страница',
	'sf_createform_field' => 'Поле:',
	'sf_createform_fieldprop' => 'Ова поле го дефинира својството $1, од типот $2.',
	'sf_createform_fieldproplist' => 'Ова поле определува список на елементите што го имаат својството $1, од типот $2.',
	'sf_createform_fieldpropunknowntype' => 'Ова поле го определува својството $1, од неназначен тип.',
	'sf_createform_inputtype' => 'Вносен тип:',
	'sf_createform_inputtypedefault' => '(по основно)',
	'sf_createform_formlabel' => 'Наслов на образецот:',
	'sf_createform_hidden' => 'Скриена',
	'sf_createform_restricted' => 'Ограничено (можат да менуваат само за систем-оператори)',
	'sf_createform_mandatory' => 'Задолжително',
	'sf_createform_removetemplate' => 'Отстрани шаблон',
	'sf_createform_addtemplate' => 'Додај шаблон:',
	'sf_createform_beforetemplate' => 'Пред шаблонот:',
	'sf_createform_atend' => 'На крај',
	'sf_createform_add' => 'Додај',
	'sf_createform_choosefield' => 'Одберете поле за додавање',
	'createcategory' => 'Создај категорија',
	'sf_createcategory_name' => 'Име на категоријата:',
	'sf_createcategory_defaultform' => 'Основен образец:',
	'sf_createcategory_makesubcategory' => 'Направи ова да биде поткатегорија на друга категорија (незадолжително):',
	'createclass' => 'Создај класа',
	'sf_createclass_docu' => 'Тука внесете ги сите податоци за да ги создадете својствата, шаблонот, образецот и категориајта за една класа. За повеќе можности за нагодување, употребете ја страницата $1.',
	'sf_createclass_allowedvalues' => 'Дозволени вредности',
	'sf_createclass_listofvalues' => 'Список на вредности',
	'sf_createclass_leavefieldblank' => 'Ако името на полето е исто како името на својството, тогаш оставете го празно.',
	'sf_createclass_missingvalues' => 'Не се пополнети сите потребни полиња.',
	'sf_createclass_success' => 'Ќе бидат создадени својства, шаблон, образец и категорија.',
	'formstart' => 'Додај страница со образец',
	'sf_formstart_badform' => 'Грешка: на $1 не е пронајден образец',
	'sf_formstart_badtitle' => 'Грешка: „$1“ не претставува важечки наслов за страница.',
	'sf_formstart_docu' => 'Тука внесете го името на страницата која ќе се уредува со образецот „$1“.
Ако оваа страница веќе постои, ќе ви бидете пренасочени кон образецот за уредување на таа страница.
Ако не постои, ќе бидете пренасочени кон образецот за додавање на страницата.',
	'sf_formstart_noform_docu' => 'Тука внесете го името на страницата, и одберете го образецот со кој ќе уредувате.
Ако оваа страница веќе постои, ќе ви бидете пренасочени кон образецот за уредување.
Ако не постои, ќе бидете пренасочени кон образецот за додавање на страницата.',
	'sf_formstart_createoredit' => 'Создај или уреди',
	'formedit' => 'Уреди со образец',
	'sf_formedit_createtitle' => 'Создавање на $1: $2',
	'sf_formedit_badurl' => 'Оваа страница служи за уредување со помош на образец. Мора да назначите име на образецот и целна страница во URL-адресата;
тоа треба да изгледа како „Special:FormEdit?form=&lt;form name&gt;&target=&lt;target page&gt;“ или „Special:FormEdit/&lt;form name&gt;/&lt;target page&gt;“.',
	'sf_formedit_altforms' => 'Наместо тоа, можете да ја додадете оваа страница со еден од следниве обрасци:',
	'sf_formedit_altformsonly' => 'Одберете еден од следните обрасци за додавање на страницата:',
	'sf_formcreate' => 'Создај со образец',
	'sf_viewform' => 'Види го образецот',
	'sf_editsource' => 'Уреди го изворот',
	'sf_formedit_edittitle' => 'Уреди $1: $2',
	'sf_formedit_morethanoneform' => "'''Предупредување:''' за оваа страница е дефиниран повеќе од еден основен образец.",
	'sf_formedit_formwarning' => 'Предупредување: Оваа страница <a href="$1">веќе постои</a>, но не го користи овој образец.',
	'sf_formedit_remove' => 'Отстрани',
	'sf_formedit_addanother' => 'Додај уште',
	'sf_formedit_none' => 'Нема',
	'runquery' => 'Пушти барање',
	'sf_runquery_badurl' => 'Мора да назначите име на образецот во URL-адресата;
URL-адресата треба да изгледа вака: „Special:RunQuery/&lt;form name&gt;“.',
	'sf_runquery_title' => 'Постави прашање: $1',
	'sf_runquery_additionalquery' => 'Дополнително прашање',
	'sf_formerrors_header' => 'Најдени се грешки во вносот на образецот; погледајте подолу',
	'sf_blank_error' => 'не може да стои празно',
	'sf_bad_url_error' => 'мора да има правилен URL формат, кој почнува со „http“',
	'sf_bad_email_error' => 'мора да има важечки формат на е-поштенска адреса',
	'sf_bad_number_error' => 'мора да биде важечки број',
	'sf_bad_integer_error' => 'мора да биде важечки цел број',
	'sf_bad_date_error' => 'мора да биде важечки датум',
	'uploadwindow' => 'Прозорец за подигање',
	'sf_deletionlog' => 'Дневник на бришења',
	'sf_property_isproperty' => 'Ова е својство од типот $1.',
	'sf_property_linkstoform' => 'Дава врски кон страниците кои го користат образецот $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Дозволената вредност за ова својство е|Дозволените вредности за ова својство се}}:',
	'sf_template_docu' => 'Ова е шаблонот „$1“.
Треба да се повикува во следниов формат:',
	'sf_template_docufooter' => 'Почнете со уредување на страницата за да го видите текстот на шаблонот.',
	'sf_form_docu' => 'Ова е образецот „$1“.
За да создадете страница со овој образец, внесете го името на страницата подолу;
ако веќе постои така именувана страница, ќе бидете пренасочени кон образец за уредување на таа страница.',
	'sf_form_freetextlabel' => 'Слободен текст',
	'sf_category_hasdefaultform' => 'Оваа категорија го користи образецот $1.',
	'sf_category_desc' => 'Ова е категоријата $1.',
	'sf_blank_namespace' => 'Главен',
	'right-viewedittab' => 'Приказ на јазиче „Уреди“ за страниците уредливи со образец',
	'right-editrestrictedfields' => 'Уредување на ограничени полиња на обрасци',
);

/** Malayalam (മലയാളം)
 * @author Shijualex
 */
$messages['ml'] = array(
	'sf_createproperty_propname' => 'പേര്‌:',
	'sf_createproperty_proptype' => 'തരം:',
	'templates' => 'ഫലകങ്ങൾ',
	'sf_templates_docu' => 'താഴെ പ്രദർശിപ്പിച്ചിരിക്കുന്ന ഫലകങ്ങൾ ഈ വിക്കിയിൽ നിലവിലുണ്ട്.',
	'sf_templates_definescat' => 'വർഗ്ഗം നിർ‌വചിക്കുന്നു:',
	'createtemplate' => 'ഫലകം നിർമ്മിക്കുക',
	'sf_createtemplate_namelabel' => 'ഫലകത്തിന്റെ പേര്‌:',
	'sf_createtemplate_categorylabel' => 'ഫലകം ഉപയോഗിച്ചു്‌ നിർ‌വചിച്ച വർഗ്ഗം (നിർബന്ധമില്ല):',
	'sf_createtemplate_aggregationlabel' => 'പട്ടികയ്ക്കുള്ള തലക്കെട്ട്:',
	'sf_createtemplate_outputformat' => 'ഔട്ട്പുട്ട് ഫോർമാറ്റ്:',
	'sf_createtemplate_standardformat' => 'മാനകം',
	'sf_createtemplate_deletefield' => 'മായ്ക്കുക',
	'createform' => 'ഫോം സൃഷ്ടിക്കുക',
	'sf_createform_template' => 'ഫലകം:',
	'sf_createform_field' => 'ഫീൽഡ്:',
	'sf_createform_inputtype' => 'ഇൻ‌പുട്ട് തരം:',
	'sf_createform_inputtypedefault' => '(സ്വതവെ)',
	'sf_createform_hidden' => 'മറഞ്ഞിരിക്കുന്നത്',
	'sf_createform_restricted' => 'നിയന്ത്രിതം (സിസോപ്പുകൾക്ക് മാത്രമേ ഇതു തിരുത്താൻ സാധിക്കൂ)',
	'sf_createform_mandatory' => 'നിർബന്ധം',
	'sf_createform_removetemplate' => 'ഫലകം മാറ്റുക',
	'sf_createform_addtemplate' => 'ഫലകം ചേർക്കുക:',
	'sf_createform_beforetemplate' => 'ഫലകത്തിനു മുൻപ്:',
	'sf_createform_atend' => 'അവസാനത്തിൽ',
	'sf_createform_add' => 'ചേർക്കുക',
	'createcategory' => 'വർഗ്ഗം സൃഷ്ടിക്കുക',
	'sf_createcategory_name' => 'പേര്‌:',
	'sf_createcategory_defaultform' => 'സ്വതവെയുള്ള ഫോം:',
	'sf_createcategory_makesubcategory' => 'ഇതു മറ്റൊരു വർഗ്ഗത്തിന്റെ ഉപവർഗ്ഗമാക്കുക (നിർബന്ധമില്ല):',
	'sf_formstart_badform' => 'പിഴവ്: $1ല്‍ ഫോം താള്‍ ഒന്നും കണ്ടില്ല',
	'sf_formstart_createoredit' => 'ചേര്‍ക്കുക അല്ലെങ്കില്‍ തിരുത്തുക',
	'formedit' => 'ഫോം ഉപയോഗിച്ചു തിരുത്തുക',
	'sf_formedit_createtitle' => '$1 ചേര്‍ക്കുക: $2',
	'sf_formedit_altformsonly' => 'ഈ താള്‍ ചേര്‍ക്കുവാന്‍ താഴെ കൊടുത്തിട്ടുള്ള ഫോമുകളില്‍ ഒന്ന് തിരഞ്ഞെടുക്കുക:',
	'sf_viewform' => 'ഫോം കാണുക',
	'sf_editsource' => 'മൂലരൂപം തിരുത്തുക',
	'sf_formedit_edittitle' => '$1 തിരുത്തുക: $2',
	'sf_formedit_remove' => 'നീക്കം ചെയ്യുക',
	'sf_formedit_addanother' => 'മറ്റൊന്ന് ചേര്‍ക്കുക',
	'sf_formedit_none' => 'ഒന്നുമില്ല',
	'sf_formerrors_header' => 'താങ്കളുടെ ഇൻപുട്ട് ഫോമിൽ പിഴവുകൾ ഉണ്ട്; താഴെ കാണുക',
	'sf_blank_error' => 'ശൂന്യമാക്കിയിടുന്നത് അനുവദനീയമല്ല',
	'sf_bad_url_error' => "'http' എന്നു തുടങ്ങുന്ന ശരിയായ URL രൂപം ഉപയോഗിക്കണം",
	'sf_bad_email_error' => 'സാധുവായ ഇമെയിൽ വിലാസ ഫോർമാറ്റ് നിർബന്ധമാണ്‌',
	'sf_bad_number_error' => 'സാധുവായ സംഖ്യ നിർബന്ധമാണ്‌',
	'sf_bad_integer_error' => 'നിർബന്ധമായും സാധുവായ ഒരു അക്കമാകണം',
	'sf_bad_date_error' => 'സാധുവായ തീയതി നിർബന്ധമാണ്‌',
	'sf_template_docufooter' => 'ഫലകത്തിന്റെ ഉള്ളടക്കം കാണാൻ താൾ തിരുത്തുക.',
	'sf_category_hasdefaultform' => 'ഈ വർഗ്ഗം $1 എന്ന ഫോം ഉപയോഗിക്കുന്നു.',
	'sf_category_desc' => 'ഇതു $1 എന്ന വർഗ്ഗമാണ്‌.',
	'sf_blank_namespace' => 'മുഖ്യം',
);

/** Mongolian (Монгол)
 * @author Chinneeb
 */
$messages['mn'] = array(
	'sf_deletionlog' => 'Устгалын лог',
);

/** Marathi (मराठी)
 * @author Kaustubh
 * @author Mahitgar
 */
$messages['mr'] = array(
	'createproperty' => 'एक गुणधर्म तयार करा',
	'sf_createproperty_allowedvalsinput' => 'जर तुम्ही या रकान्यात फक्त काहीच किंमती भरू इच्छित असाल, तर त्यांची यादी बनवा, स्वल्पविरामाने किंमतींमध्ये फरक दाखवा (जर एखाद्या किंमतीतच स्वल्पविराम येत असेल, तर त्या जागी "\\," लिहा):',
	'sf_createproperty_propname' => 'नाव:',
	'sf_createproperty_proptype' => 'प्रकार:',
	'templates' => 'साचे',
	'sf_templates_docu' => 'या विकिवर खालील साचे उपलब्ध आहेत.',
	'sf_templates_definescat' => 'वर्गाची व्याख्या:',
	'createtemplate' => 'साचा तयार करा',
	'sf_createtemplate_namelabel' => 'साच्याचे नाव:',
	'sf_createtemplate_categorylabel' => 'साचा कुठल्या वर्गात आहे (वैकल्पिक):',
	'sf_createtemplate_templatefields' => 'साच्यातील रकाने',
	'sf_createtemplate_fieldsdesc' => 'जर या साच्यातील रकान्यांना नावे द्यायची नसतील, तर खर्‍या नावांऐवजी फक्त क्रमांक द्या (उदा. १, २, ३, इ.).',
	'sf_createtemplate_fieldname' => 'रकाना नाव:',
	'sf_createtemplate_displaylabel' => 'दाखविण्याचे लेबल:',
	'sf_createtemplate_semanticproperty' => 'सिमॅंटिक गुणधर्म:',
	'sf_createtemplate_fieldislist' => 'हा रकाना स्वल्पविरामाने वाटलेली किंमतींची यादी दर्शवितो',
	'sf_createtemplate_aggregation' => 'एकत्रीकरण',
	'sf_createtemplate_aggregationdesc' => 'एखाद्या पानावर असणार्‍या गुणधर्माला निर्देश करणारी पाने, ज्यांमध्ये हा साचा वापरण्यात आलेला आहे, अशा पानांची यादी करण्यासाठी तो गुणधर्म खाली लिहा:',
	'sf_createtemplate_aggregationlabel' => 'यादी साठी शीर्षक:',
	'sf_createtemplate_outputformat' => 'आउटपुटची रूपरेषा:',
	'sf_createtemplate_standardformat' => 'स्टॅंडर्ड',
	'sf_createtemplate_infoboxformat' => 'उजवीकडील माहितीचौकट',
	'sf_createtemplate_addfield' => 'रकाना वाढवा',
	'sf_createtemplate_deletefield' => 'वगळा',
	'sf_createtemplate_addtemplatebeforesave' => 'हा अर्ज जतन करण्यापूर्वी तुम्ही कमीत कमी एक साचा देणे आवश्यक आहे.',
	'forms' => 'अर्ज',
	'sf_forms_docu' => 'विकिवर खालील अर्ज उपलब्ध आहेत.',
	'createform' => 'नवीन अर्ज बनवा',
	'sf_createform_nameinput' => 'अर्जाचे नाव (सर्वसाधारणपणे अर्ज ज्या मुख्य साच्यासाठी आहे त्या साच्याच्या नावानंतर अर्जाचे नाव असे लिहावे):',
	'sf_createform_template' => 'साचा:',
	'sf_createform_templatelabelinput' => 'साच्याचे लेबल (वैकल्पिक):',
	'sf_createform_allowmultiple' => 'तयार केलेल्या पानावर हा साचा अनेकवेळा (किंवा शून्यवेळा) वापरण्याची परवानगी द्या',
	'sf_createform_field' => 'रकाना:',
	'sf_createform_fieldprop' => 'हा रकाना $2 या प्रकारचा $1 हा गुणधर्म सांगतो.',
	'sf_createform_fieldproplist' => 'हा रकाना $2 या प्रकारचे $1 गुणधर्म असणार्‍या एलेमेंट्स ची यादी देतो.',
	'sf_createform_fieldpropunknowntype' => 'हा रकाना अनोळखी प्रकारचा $1 हा गुणधर्म देतो.',
	'sf_createform_inputtype' => 'इनपुट प्रकार:',
	'sf_createform_inputtypedefault' => '(अविचल)',
	'sf_createform_formlabel' => 'अर्ज लेबल:',
	'sf_createform_hidden' => 'लपविलेले',
	'sf_createform_restricted' => 'प्रतिबंधित (फक्त प्रबंधकच बदलू शकतात)',
	'sf_createform_mandatory' => 'अत्यावश्यक',
	'sf_createform_removetemplate' => 'साचा काढा',
	'sf_createform_addtemplate' => 'साचा वाढवा:',
	'sf_createform_beforetemplate' => 'या साच्याच्या आधी:',
	'sf_createform_atend' => 'शेवटी',
	'sf_createform_add' => 'वाढवा',
	'sf_createform_choosefield' => 'वाढविण्यासाठी एक रकाना निवडा',
	'createcategory' => 'वर्ग बनवा',
	'sf_createcategory_name' => 'नाव:',
	'sf_createcategory_defaultform' => 'अविचल अर्ज:',
	'sf_createcategory_makesubcategory' => 'याला एका दुसर्‍या वर्गाचा उपवर्ग बनवा (वैकल्पिक):',
	'formstart' => 'पान वाढवा',
	'sf_formstart_badform' => 'त्रुटी: $1 वर कुठलेही अर्ज पान सापडलेले नाही',
	'sf_formstart_docu' => "'$1' अर्जाचा वापर करून बदलण्यात येणार्‍या पानाचे नाव इथे लिहा.
जर हे पान अगोदरच अस्तित्वात असेल, तर तुम्हांला ते पान बदलण्यासाठी लागणारा अर्ज देण्यात येईल.
नाहीतर, तुम्हांला ते पान वाढविण्याचा अर्ज देण्यात येईल.",
	'sf_formstart_noform_docu' => 'बदलण्यात येणार्‍या पानाचे नाव लिहा तसेच बदलण्यासाठी वापरण्यात येणारा अर्ज निवडा.
जर हे पान अगोदरच अस्तित्वात असेल, तर तुम्हांला ते पान बदलण्यासाठी लागणारा अर्ज देण्यात येईल.
नाहीतर, तुम्हांला ते पान वाढविण्याचा अर्ज देण्यात येईल.',
	'sf_formstart_createoredit' => 'वाढवा किंवा बदला',
	'formedit' => 'अर्जासहित बदला',
	'sf_formedit_createtitle' => 'वाढवा $1: $2',
	'sf_formedit_badurl' => "हे पान मजकूर वाढविण्यासाठी आहे. तुम्ही एक अर्जाचे नाव व लक्ष्य पान दोन्ही URL मध्ये देणे आवश्यक आहे. URL अशी दिसेल 'Special:FormEdit?form=&lt;अर्जाचे नाव&gt;&target=&lt;लक्ष्य पान&gt;', किंवा  'Special:FormEdit/&lt;अर्जाचे नाव&gt;/&lt;लक्ष्य पान&gt;'.",
	'sf_formedit_altforms' => 'हे पान तुम्ही या ऐवजी खालीलपैकी एक अर्ज वापरून वाढवू शकता:',
	'sf_formedit_altformsonly' => 'हे पान वाढविण्यासाठी कृपया खालील पैकी एक अर्ज निवडा:',
	'sf_viewform' => 'अर्ज पहा',
	'sf_editsource' => 'स्रोत संपादित करा',
	'sf_formedit_edittitle' => 'संपादित करा $1: $2',
	'sf_formedit_formwarning' => 'इशारा: हे पान <a href="$1">अस्तित्वात आहे</a>, पण ते पान ह्या अर्जाचा वापर करीत नाही.',
	'sf_formedit_remove' => 'काढा',
	'sf_formedit_addanother' => 'दुसरे वाढवा',
	'sf_formedit_none' => 'काहीही नाही',
	'sf_formerrors_header' => 'तुमच्या अर्जामध्ये त्रुटी आहेत; खाली पहा',
	'sf_blank_error' => 'रिकामे असू शकत नाही',
	'sf_bad_url_error' => "'http' ने सुरू होणारी बरोबर URL असणे आवश्यक आहे",
	'sf_bad_email_error' => 'बरोबल इ-मेल पत्ता असणे आवश्यक आहे',
	'sf_bad_number_error' => 'योग्य संख्या असणे आवश्यक आहे',
	'sf_bad_integer_error' => 'योग्य पूर्णांक संख्या असणे आवश्यक आहे',
	'sf_bad_date_error' => 'योग्य दिनांक असणे आवश्यक आहे',
	'sf_property_isproperty' => 'हा $1 प्रकारचा गुणधर्म आहे.',
	'sf_property_allowedvals' => 'या गुणधर्माच्या योग्य किंमती पुढीलप्रमाणे आहेत:',
	'sf_template_docu' => "हा '$1' साचा आहे.
हा खालीलप्रमाणे वापरला पाहिजे:",
	'sf_template_docufooter' => 'पानात साचा मजकूर पाहण्यासाठी योग्य असे बदल करा.',
	'sf_form_docu' => "हा '$1' अर्ज आहे.
हा अर्ज वापरून एखादे पान वाढविण्यासाठी, खाली पानाचे शीर्षक लिहा;
जर त्या नावाचे पान अगोदरच अस्तित्वात असेल, तर तुम्हांला ते पान बदलण्यासाठीचा अर्ज पाठविला जाईल.",
	'sf_form_freetextlabel' => 'मुक्त मजकुर',
	'sf_category_hasdefaultform' => 'हे वर्गीकरण फॉर्म $1 वापरते.',
	'sf_category_desc' => 'हे $1 वर्गीकरण आहे.',
	'sf_blank_namespace' => 'मुख्य',
);

/** Erzya (Эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'sf_createproperty_propname' => 'Лемезэ:',
	'sf_createproperty_proptype' => 'Типезэ:',
	'sf_createtemplate_deletefield' => 'Нардамс',
	'sf_createform_template' => 'Лопа парцунось:',
	'sf_createform_field' => 'Паксясь:',
	'sf_createform_hidden' => 'Кекшезь',
	'sf_createform_add' => 'Поладомс',
	'createcategory' => 'Шкамс категория',
	'sf_createcategory_name' => 'Лемезэ:',
	'sf_editsource' => 'Витнемс-петнемс лисьмапрянзо',
	'sf_formedit_remove' => 'Нардык',
);

/** Mazanderani (مازِرونی)
 * @author محک
 */
$messages['mzn'] = array(
	'sf_formedit_badurl' => 'این صفحه برای افزودن ایطیلاعات هسته. شما ونه هم ایسم فورم هم ولگی که خانی بوری ره در URL دله بیارین. چیزی شبیه اینتا <br /><span dir="ltr"> \'شاء:FormEdit?form=&lt;نام فرم&gt;&target=&lt;ولگی که خانی بوری&gt;\' </span><br />یا<br /><span dir="ltr"> \'شاء:FormEdit/&lt;ایسم فرم&gt;/&lt;ولگی که خانی بوری&gt;\' </span>.',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 */
$messages['nah'] = array(
	'sf_createproperty_propname' => 'Tōcāitl:',
	'templates' => 'Nemachiyōtīlli',
	'createtemplate' => 'Ticchīhuāz cē nemachiyōtīlli',
	'sf_createtemplate_namelabel' => 'Nemachiyōtīlli ītōca:',
	'sf_createtemplate_deletefield' => 'Ticpolōz',
	'sf_createform_inputtypedefault' => '(ic default)',
	'sf_createform_hidden' => 'Ichtac',
	'sf_createform_atend' => 'Tlamilizpan',
	'sf_createform_add' => 'Ticcētilīz',
	'sf_createcategory_name' => 'Tōcāitl:',
	'sf_formstart_createoredit' => 'Titlacēntilīz ahnozo titlapatlāz',
	'sf_formedit_createtitle' => 'Ticcēntilīz $1: $2',
	'sf_formedit_edittitle' => 'Ticpatlāz $1: $2',
	'sf_formedit_addanother' => 'Titlacēntilīz occē',
	'sf_formedit_none' => 'Ahtlein',
);

/** Low German (Plattdüütsch)
 * @author Slomox
 */
$messages['nds'] = array(
	'sf_createproperty_propname' => 'Naam:',
	'sf_createcategory_name' => 'Naam:',
);

/** Nedersaksisch (Nedersaksisch)
 * @author Servien
 */
$messages['nds-nl'] = array(
	'sf_createform_add' => 'Toevoegen',
);

/** Dutch (Nederlands)
 * @author McDutchie
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'semanticforms-desc' => 'Formulieren voor het toevoegen en bewerken van semantische gegevens',
	'specialpages-group-sf_group' => 'Semantische formulieren',
	'createproperty' => 'Eigenschap aanmaken',
	'sf_createproperty_linktoform' => "Deze eigenschap verwijst naar pagina's die het volgende formulier gebruiken:",
	'sf_createproperty_allowedvalsinput' => 'Als u wilt dat deze eigenschap een beperkt aantal waarden mag hebben, geef dan een lijst met toegelaten waarden in, door komma\'s gescheiden. Als een waarde een komma bevat, vervang deze dan door "\\,":',
	'sf_createproperty_propname' => 'Naam eigenschap:',
	'sf_createproperty_proptype' => 'Type:',
	'templates' => 'Sjablonen',
	'sf_templates_docu' => 'De onderstaande sjablonen bestaan in de wiki.',
	'sf_templates_definescat' => 'bepaalt categorie:',
	'createtemplate' => 'Een sjabloon maken',
	'sf_createtemplate_namelabel' => 'Sjabloonnaam:',
	'sf_createtemplate_categorylabel' => 'Categorie bepaald door sjabloon (optioneel):',
	'sf_createtemplate_templatefields' => 'Sjabloonvelden',
	'sf_createtemplate_fieldsdesc' => 'Om de velden van een sjabloon geen verplichte veldnamen te laten hebben, kunt u de index van dat veld (bijvoorbeeld 1, 2, 3, enzovoort) als naam opgeven in plaats van de eigenlijke naam.',
	'sf_createtemplate_fieldname' => 'Veldnaam:',
	'sf_createtemplate_displaylabel' => 'Beschrijving:',
	'sf_createtemplate_semanticproperty' => 'Semantische eigenschap:',
	'sf_createtemplate_fieldislist' => "Dit veld kan een lijst van waardes houden, gescheiden door komma's",
	'sf_createtemplate_aggregation' => 'Aggregatie',
	'sf_createtemplate_aggregationdesc' => "Om op iedere pagina die van dit sjabloon gebruik maakt een lijst weer te geven van alle pagina's met een naar die pagina verwijzende eigenschap, geeft u de betreffende eigenschap hieronder aan:",
	'sf_createtemplate_aggregationlabel' => 'Titel voor lijst:',
	'sf_createtemplate_outputformat' => 'Uitvoerformaat:',
	'sf_createtemplate_standardformat' => 'Standaard',
	'sf_createtemplate_infoboxformat' => 'Infobox rechterkant',
	'sf_createtemplate_addfield' => 'Veld toevoegen',
	'sf_createtemplate_deletefield' => 'Verwijderen',
	'sf_createtemplate_addtemplatebeforesave' => 'U moet ten minste één sjabloon toevoegen aan dit formulier voordat u het kunt opslaan.',
	'forms' => 'Formulieren',
	'sf_forms_docu' => 'De onderstaande formulieren bestaan in de wiki.',
	'createform' => 'Formulier aanmaken',
	'sf_createform_nameinput' => 'Formuliernaam',
	'sf_createform_nameinputdesc' => '(conventie om het formulier te noemen naar het hoofdsjabloon):',
	'sf_createform_template' => 'Sjabloon:',
	'sf_createform_templatelabelinput' => 'Sjabloonlabel (optioneel):',
	'sf_createform_allowmultiple' => 'Meerdere (of geen) instanties van dit sjabloon toestaan op de gemaakte pagina',
	'sf_createform_field' => 'Veld:',
	'sf_createform_fieldprop' => 'Dit veld bepaalt de eigenschap $1, van type $2.',
	'sf_createform_fieldproplist' => 'Dit veld bepaalt een lijst elementen die de eigenschap $1 hebben, van type $2.',
	'sf_createform_fieldpropunknowntype' => 'Dit veld bepaalt de eigenschap $1, van onbepaald type.',
	'sf_createform_inputtype' => 'Invoertype:',
	'sf_createform_inputtypedefault' => '(standaard)',
	'sf_createform_formlabel' => 'Formulierlabel:',
	'sf_createform_hidden' => 'Verborgen',
	'sf_createform_restricted' => 'Beperkt (alleen beheerders kunnen bewerken)',
	'sf_createform_mandatory' => 'Verplicht',
	'sf_createform_removetemplate' => 'Sjabloon verwijderen',
	'sf_createform_addtemplate' => 'Sjabloon toevoegen:',
	'sf_createform_beforetemplate' => 'Voor sjabloon:',
	'sf_createform_atend' => 'Onderaan',
	'sf_createform_add' => 'Toevoegen',
	'sf_createform_choosefield' => 'Kies een veld om toe te voegen',
	'createcategory' => 'Een categorie aanmaken',
	'sf_createcategory_name' => 'Categorienaam:',
	'sf_createcategory_defaultform' => 'Standaard formulier:',
	'sf_createcategory_makesubcategory' => 'Deze categorie een ondercategorie van een andere categorie maken (optioneel):',
	'createclass' => 'Klasse aanmaken',
	'sf_createclass_docu' => "Voer hier alle gegevens in om de eigenschappen, het sjabloon, het formulier en de categorie voor een klasse aan te maken.
Gebruik de pagina's $1 voor meer mogelijkheden.",
	'sf_createclass_allowedvalues' => 'Toegestane waarden',
	'sf_createclass_listofvalues' => 'Lijst met waarden',
	'sf_createclass_leavefieldblank' => 'Als de veldnaam hetzelfde is als de naam van de eigenschap, kunt u het leeglaten.',
	'sf_createclass_missingvalues' => 'Niet alle verplichte velden zijn ingevuld.',
	'sf_createclass_success' => 'De eigenschappen, het sjabloon, het formulier en de categorie worden aangemaakt.',
	'formstart' => 'Pagina toevoegen met formulier',
	'sf_formstart_badform' => 'Fout: er is geen formulierpagina aangetroffen op $1',
	'sf_formstart_badtitle' => 'Fout: "$1" is een ongeldige paginanaam.',
	'sf_formstart_docu' => "Voer de naam van de pagina die bewerkt wordt met het formulier '$1' hier in. Als deze pagina al bestaat, wordt u doorgestuurd naar het formulier om die pagina te bewerken. Anders wordt u doorgestuurd naar het formulier om de pagina toe te voegen.",
	'sf_formstart_noform_docu' => 'Voer de naam van de pagina hier in en selecteer het formulier waarmee die bewerkt wordt. Als deze pagina al bestaat, wordt u doorgestuurd naar het formulier om die pagina te bewerken. Anders wordt u doorgestuurd naar het formulier om de pagina toe te voegen.',
	'sf_formstart_createoredit' => 'Aanmaken of bewerken',
	'formedit' => 'Bewerken met dit formulier',
	'sf_formedit_createtitle' => '$1 aanmaken: $2',
	'sf_formedit_badurl' => 'Op deze pagina kunt u bewerkingen uitvoeren met behulp van een formulier. Geef zowel een formuliernaam als een doelpagina op in de URL. Het hoort eruit te zien als "Special:FormEdit?form=&lt;formuliernaam&gt;&target=&lt;doelpagina&gt;" of  "Special:FormEdit/&lt;formuliernaam&gt;/&lt;doelpagina&gt;".',
	'sf_formedit_altforms' => 'U kunt in de plaats deze pagina toevoegen met een van de volgende formulieren:',
	'sf_formedit_altformsonly' => 'Gelieve te selecteren van een van de volgende formulieren om deze pagina toe te voegen:',
	'sf_formcreate' => 'Via formulier aanmaken',
	'sf_viewform' => 'Formulier bekijken',
	'sf_editsource' => 'Bron bewerken',
	'sf_formedit_edittitle' => '$1 bewerken: $2',
	'sf_formedit_morethanoneform' => 'Waarschuwing: er is meer één standaard formulier is ingesteld voor deze pagina.',
	'sf_formedit_formwarning' => 'Deze pagina <a href="$1">bestaat al</a>, maar die gebruikt dit formulier niet.',
	'sf_formedit_remove' => 'Verwijderen',
	'sf_formedit_addanother' => 'Nog toevoegen',
	'sf_formedit_none' => 'Geen',
	'runquery' => 'Zoekopdracht uitvoeren',
	'sf_runquery_badurl' => 'U moet een formuliernaam aangeven in de URL.
De URL moet er als volgt uitzien: "Special:RunQuery/&lt;formuliernaam&gt;".',
	'sf_runquery_title' => 'Zoekopdracht: $1',
	'sf_runquery_additionalquery' => 'Additionele zoekopdracht',
	'sf_formerrors_header' => 'Er zaten fouten in uw formulierinvoer. Details staan hieronder',
	'sf_blank_error' => 'mag niet leeg blijven',
	'sf_bad_url_error' => "moet de juiste URL hebben, beginnend met 'http'",
	'sf_bad_email_error' => 'moet een geldig e-mailadres-formaat hebben',
	'sf_bad_number_error' => 'moet een geldig nummer zijn',
	'sf_bad_integer_error' => 'moet een geldig geheel getal zijn',
	'sf_bad_date_error' => 'moet een geldige datum zijn',
	'uploadwindow' => 'Uploadscherm',
	'sf_deletionlog' => 'Verwijderlogboek',
	'sf_property_isproperty' => 'Dit is een eigenschap van type $1.',
	'sf_property_linkstoform' => "Deze verwijst naar pagina's die gebruikmaken van het formulier $1.",
	'sf_property_allowedvals' => 'De toegelaten {{PLURAL:$1|waarde voor deze eigenschap is|waarden voor deze eigenschap zijn}}:',
	'sf_template_docu' => "Dit is het sjabloon '$1'. Gebruik het op de volgende wijze:",
	'sf_template_docufooter' => 'Bewerk de pagina om de sjabloontekst te bekijken.',
	'sf_form_docu' => 'Dit is het formulier "$1".
Om een pagina aan te maken via dit formulier typt u de paginanaam hieronder in;
als een pagina met die naam al bestaat, krijgt u het bewerkingsscherm te zien en kunt u die pagina via een formulier bewerken.',
	'sf_form_freetextlabel' => 'Vrije tekst',
	'sf_category_hasdefaultform' => 'Deze categorie gebruikt het formulier $1.',
	'sf_category_desc' => 'Dit is de categorie $1.',
	'sf_blank_namespace' => 'Hoofdnaamruimte',
	'right-viewedittab' => 'Tabblad "Bewerken" zien op pagina\'s die via een formulier bewerkt kunnen worden',
	'right-editrestrictedfields' => 'Beperkte formuliervelden bewerken',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Gunnernett
 * @author Harald Khan
 * @author Jon Harald Søby
 */
$messages['nn'] = array(
	'semanticforms-desc' => 'Skjema for å leggja til og endra semantiske data',
	'specialpages-group-sf_group' => 'Semantiske skjema',
	'createproperty' => 'Opprett ein eigenskap',
	'sf_createproperty_linktoform' => 'Denne eigenskapen vil lenke til sider som nyttar skjemaet:',
	'sf_createproperty_allowedvalsinput' => 'Om du ønskjer at denne eigenskapen berre skal kunna ha visse verdiar, skriv inn lista over tillatne verdiar med verdiane skilde med komma (om ein verdi inneheld eit komma, erstatt det med «\\,»):',
	'sf_createproperty_propname' => 'Namn på eigenskap:',
	'sf_createproperty_proptype' => 'Type:',
	'templates' => 'Malar',
	'sf_templates_docu' => 'Følgjande malar finst på wikien.',
	'sf_templates_definescat' => 'definerer kategori:',
	'createtemplate' => 'Opprett ein mal',
	'sf_createtemplate_namelabel' => 'Malnamn:',
	'sf_createtemplate_categorylabel' => 'Kategori definert av mal (valfri):',
	'sf_createtemplate_templatefields' => 'Malfelt',
	'sf_createtemplate_fieldsdesc' => 'For at felta i malen ikkje lenger skal krevja feltnamn, skriv inn indeksnummeret til kvart felt (til dømes 1, 2, 3, osb.) som namn, i staden for eit faktisk namn:',
	'sf_createtemplate_fieldname' => 'Feltnamn:',
	'sf_createtemplate_displaylabel' => 'Vis merke:',
	'sf_createtemplate_semanticproperty' => 'Semantisk eigenskap:',
	'sf_createtemplate_fieldislist' => 'Dette feltet kan innehalda ei lista over verdiar skilde med komma',
	'sf_createtemplate_aggregation' => 'Aggregering',
	'sf_createtemplate_aggregationdesc' => 'For på kvar ei sida som nyttar denne malen, å lista opp alle artiklane med ein viss eigenskap som lenkjar til sida, oppgje eigenskapen nedanfor:',
	'sf_createtemplate_aggregationlabel' => 'Listetittel:',
	'sf_createtemplate_outputformat' => 'Resultatformat:',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_infoboxformat' => 'Infoboks på høgre sida:',
	'sf_createtemplate_addfield' => 'Legg til felt',
	'sf_createtemplate_deletefield' => 'Slett',
	'sf_createtemplate_addtemplatebeforesave' => 'Du må leggja til minst ein mal til skjemaet før du kan lagra det.',
	'forms' => 'Skjema',
	'sf_forms_docu' => 'Følgjande skjema finst på wikien.',
	'createform' => 'Opprett eit skjema',
	'sf_createform_nameinput' => 'Skjemanamn',
	'sf_createform_template' => 'Mal:',
	'sf_createform_templatelabelinput' => 'Malmerke (valfritt):',
	'sf_createform_allowmultiple' => 'Tillat fleire (eller ingen) instansar av denne malen på den oppretta sida',
	'sf_createform_field' => 'Felt:',
	'sf_createform_fieldprop' => 'Dette feltet definerer eigenskapen $1, av type $2.',
	'sf_createform_fieldproplist' => 'Dette feltet definerer ei lista over element som har eigenskapen $1, av type $2.',
	'sf_createform_fieldpropunknowntype' => 'Dette feltet definerer eigenskapen $1, av uspesifisert type.',
	'sf_createform_inputtype' => 'Innteksttype:',
	'sf_createform_inputtypedefault' => '(standard)',
	'sf_createform_formlabel' => 'Skjemamerke:',
	'sf_createform_hidden' => 'Løynd',
	'sf_createform_restricted' => 'Avgrensa (berre administratorar kan endra det)',
	'sf_createform_mandatory' => 'Obligatorisk',
	'sf_createform_removetemplate' => 'Fjern mal',
	'sf_createform_addtemplate' => 'Legg til mal:',
	'sf_createform_beforetemplate' => 'Før mal:',
	'sf_createform_atend' => 'Ved slutten',
	'sf_createform_add' => 'Legg til',
	'sf_createform_choosefield' => 'Vel eit felt til å leggja til',
	'createcategory' => 'Opprett ein kategori',
	'sf_createcategory_name' => 'Kategorinamn:',
	'sf_createcategory_defaultform' => 'Standardskjema:',
	'sf_createcategory_makesubcategory' => 'Gjer dette til ein underkategori av ein annan kategori (valfritt):',
	'formstart' => 'Legg til ei sida gjennom eit skjema',
	'sf_formstart_badform' => 'Feil: fann ikkje noka skjemasida på $1',
	'sf_formstart_docu' => 'Skriv inn namnet på sida som skal bli endra med skjemaet «$1» her. 
Om sida finst frå før, vil du bli teken med til skjemaet for endring av ho.
Viss ikkje vil du bli teken med til skjemaet for å oppretta sida.',
	'sf_formstart_noform_docu' => 'Skriv inn namnet på sida her, og vel kva skjema du vil nytta til å endra ho. Om sida finst frå før, vil du bli teken med til skjemaet for endring av ho. Viss ikkje vil du bli teken med til skjemaet for å oppretta sida.',
	'sf_formstart_createoredit' => 'Legg til eller endr',
	'formedit' => 'Endra med skjema',
	'sf_formedit_createtitle' => 'Legg til $1: $2',
	'sf_formedit_badurl' => 'Dette er sida for å leggja til data. Du må oppgje både eit skjemanamn og ei målsida i adressa; det burde sjå slik ut: «Special:FormEdit?form=&lt;skjemanamn&gt;&target=&lt;målsida&gt;» eller slik ut: «Special:FormEdit/&lt;skjemanamn&gt;/&lt;målsida&gt;».',
	'sf_formedit_altforms' => 'Du kan i staden oppretta sida ved å nytta eitt av dei følgande skjemaa:',
	'sf_formedit_altformsonly' => 'Vel mellom desse skjemaa for å oppretta sida:',
	'sf_viewform' => 'Sjå skjema',
	'sf_editsource' => 'Endra kjelda',
	'sf_formedit_edittitle' => 'Endra $1: $2',
	'sf_formedit_formwarning' => 'Åtvaring: Sida <a href="$1">finst frå før</a>, men nyttar ikkje dette skjemaet.',
	'sf_formedit_remove' => 'Fjern',
	'sf_formedit_addanother' => 'Legg til enno ein',
	'sf_formedit_none' => 'Ingen',
	'sf_formerrors_header' => 'Det var feil i skjemaet ditt; sjå nedanfor',
	'sf_blank_error' => 'kan ikkje vera tom',
	'sf_bad_url_error' => "må ha korrekt adresseformat, inkludert 'http'",
	'sf_bad_email_error' => 'må ha gyldig format på e-postadressa',
	'sf_bad_number_error' => 'må vera eit gyldig tal',
	'sf_bad_integer_error' => 'må vera eit gyldig heiltal',
	'sf_bad_date_error' => 'må vera ein gyldig dato',
	'uploadwindow' => 'Opplastingsvindauga',
	'sf_property_isproperty' => 'Dette er ein eigenskap av typen $1.',
	'sf_property_linkstoform' => 'Det lenker til sida som nyttar skjemaet $1.',
	'sf_property_allowedvals' => 'Dei tillatne verdiane for denne eigenskapen er:',
	'sf_template_docu' => 'Dette er malen «$1».
Han burde bli kalla opp med følgjande format:',
	'sf_template_docufooter' => 'Endra sida for å sjå malteksten.',
	'sf_form_docu' => 'Dette er skjemaet «$1». 
Skriv inn eit sidenamn nedanfor for å oppretta ei sida med dette skjemaet. Om ei sida med dette namnet finst frå før, vil du bli sendt til eit skjema for endring av ho.',
	'sf_form_freetextlabel' => 'Fritekst',
	'sf_category_hasdefaultform' => 'Denne kategorien nyttar skjemaet «$1».',
	'sf_category_desc' => 'Dett er kategorien $1.',
	'sf_blank_namespace' => 'Hovud',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Harald Khan
 * @author Jon Harald Søby
 * @author Laaknor
 * @author Nghtwlkr
 */
$messages['no'] = array(
	'semanticforms-desc' => 'Skjema for å legge til og endre semantiske data',
	'specialpages-group-sf_group' => 'Semantiske skjemaer',
	'createproperty' => 'Opprett en egenskap',
	'sf_createproperty_linktoform' => 'Denne egenskapen vil lenke til sider som bruker skjemaet:',
	'sf_createproperty_allowedvalsinput' => 'Om du ønsker at dette feltet kun skal kunne ha visse verdier, skriv inn listen over tillatte verdier, adskilt med komma (om en verdi inneholder komma, erstatt det med «\\,»):',
	'sf_createproperty_propname' => 'Navn på egenskap:',
	'sf_createproperty_proptype' => 'Type:',
	'templates' => 'Maler',
	'sf_templates_docu' => 'Følgende maler finnes på wikien.',
	'sf_templates_definescat' => 'definerer kategori:',
	'createtemplate' => 'Opprett en mal',
	'sf_createtemplate_namelabel' => 'Malnavn:',
	'sf_createtemplate_categorylabel' => 'Kategori definert av mal (valgfri):',
	'sf_createtemplate_templatefields' => 'Malfelter',
	'sf_createtemplate_fieldsdesc' => 'For at feltene i denne malen ikke lenger skal kreve feltnavn, skriv inn indeksnummeret til hvert felt (altså 1, 2, 3, osv.) som navn, i stedet for et faktisk navn.',
	'sf_createtemplate_fieldname' => 'Feltnavn:',
	'sf_createtemplate_displaylabel' => 'Vis etikett:',
	'sf_createtemplate_semanticproperty' => 'Semantisk egenskap:',
	'sf_createtemplate_fieldislist' => 'Dette feltet kan inneholde en liste over verdier adskilt med komma',
	'sf_createtemplate_aggregation' => 'Aggregering',
	'sf_createtemplate_aggregationdesc' => 'For å liste opp alle artiklene som har en viss egenskap som peker til den siden på alle sider som bruker malen, angi denne egenskapen nedenfor:',
	'sf_createtemplate_aggregationlabel' => 'Tittel for liste:',
	'sf_createtemplate_outputformat' => 'Resultatformat:',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_infoboxformat' => 'Infoboks på høyre side',
	'sf_createtemplate_addfield' => 'Legg til felt',
	'sf_createtemplate_deletefield' => 'Slett',
	'sf_createtemplate_addtemplatebeforesave' => 'Du må legge til minst én mal til dette skjemaet før du kan lagre det.',
	'forms' => 'Skjemaer',
	'sf_forms_docu' => 'Følgende skjemaer finnes på wikien.',
	'createform' => 'Opprett et skjema',
	'sf_createform_nameinput' => 'Skjemanavn',
	'sf_createform_nameinputdesc' => '(konvensjonen er å navngi skjemaet etter hovedmalen den finnes i):',
	'sf_createform_template' => 'Mal:',
	'sf_createform_templatelabelinput' => 'Malnavn (valgfritt):',
	'sf_createform_allowmultiple' => 'Tillat flere (eller ingen) instanser av denne malen på siden som opprettes',
	'sf_createform_field' => 'Felt:',
	'sf_createform_fieldprop' => 'Dette feltet definerer egenskapen $1, av type $2.',
	'sf_createform_fieldproplist' => 'Dette feltet definerer en liste over elementer som har egenskapen $1, av type $2.',
	'sf_createform_fieldpropunknowntype' => 'Dette feltet definerer egenskapen $1, av uspesifisert type.',
	'sf_createform_inputtype' => 'Innskrivningstype:',
	'sf_createform_inputtypedefault' => '(standard)',
	'sf_createform_formlabel' => 'Skjemaetikett:',
	'sf_createform_hidden' => 'Skjult',
	'sf_createform_restricted' => 'Begrenset (kun administratorer kan endre den)',
	'sf_createform_mandatory' => 'Obligatorisk',
	'sf_createform_removetemplate' => 'Fjern mal',
	'sf_createform_addtemplate' => 'Legg til mal:',
	'sf_createform_beforetemplate' => 'Før mal:',
	'sf_createform_atend' => 'Ved slutten',
	'sf_createform_add' => 'Legg til',
	'sf_createform_choosefield' => 'Velg et felt å legge til',
	'createcategory' => 'Opprett en kategori',
	'sf_createcategory_name' => 'Kategorinavn:',
	'sf_createcategory_defaultform' => 'Standardskjema:',
	'sf_createcategory_makesubcategory' => 'Gjør dette til en underkategori av en annen kategori (valgfritt):',
	'createclass' => 'Opprett en klasse',
	'sf_createclass_docu' => 'Skriv inn alle data her for å opprette egenskaper, maler, skjemaer og kategorier for en enkelt klasse. For flere alternativer, bruk sidene $1 istedet.',
	'sf_createclass_allowedvalues' => 'Tillatte verdier',
	'sf_createclass_listofvalues' => 'Liste over verdier',
	'sf_createclass_leavefieldblank' => 'Dersom feltnavnet er det samme som navnet på egenskapen kan du la den være blank.',
	'sf_createclass_missingvalues' => 'Noen obligatoriske felt ble ikke fylt ut.',
	'sf_createclass_success' => 'Egenskaper, maler, skjemaer og kategorier vil bli opprettet.',
	'formstart' => 'Legg til side gjennom et skjema',
	'sf_formstart_badform' => 'Feil: ingen skjemaside funnet på $1',
	'sf_formstart_badtitle' => 'Feil: «$1» er en ugyldig tittel for en side.',
	'sf_formstart_docu' => 'Skriv inn navnet på siden som skal redigeres med skjemaet «$1» her. Om siden finnes allerede vil du bli tatt med til skjemaet for redigering av den siden. Hvis ikke vil du bli tatt med til skjemaet for å opprette siden.',
	'sf_formstart_noform_docu' => 'Skriv inn navnet på siden her, og velg hvilket skjema du vil bruke til å redigere den. Om siden finnes allerede, vil du bli tatt med til skjemaet for redigering av den siden. Hvis ikke vil du bli tatt med til skjemaet for å opprette siden.',
	'sf_formstart_createoredit' => 'Opprett eller rediger',
	'formedit' => 'Rediger med skjema',
	'sf_formedit_createtitle' => 'Opprett $1: $2',
	'sf_formedit_badurl' => 'Dette er siden for å redigere med et skjema. Du må angi både et skjemanavn og en målside i URL-en;
det burde se slik ut «Special:FormEdit?form=&lt;skjemanavn&gt;&target=&lt;målside&gt;», eller slik «Special:FormEdit/&lt;skjemanavn&gt;/&lt;målside&gt;».',
	'sf_formedit_altforms' => 'Du kan i stedet opprette siden ved å bruke et av følgende skjemaer:',
	'sf_formedit_altformsonly' => 'Velg blant disse skjemaene for å opprette siden:',
	'sf_formcreate' => 'Opprett med skjema',
	'sf_viewform' => 'Se skjema',
	'sf_editsource' => 'Rediger kilde',
	'sf_formedit_edittitle' => 'Rediger $1: $2',
	'sf_formedit_morethanoneform' => "'''Advarsel:''' Mer enn ett standard skjema er definert for denne siden.",
	'sf_formedit_formwarning' => 'Advarsel: Denne siden <a href="$1">finnes allerede</a>, men bruker ikke dette skjemaet.',
	'sf_formedit_remove' => 'Fjern',
	'sf_formedit_addanother' => 'Legg til en til:',
	'sf_formedit_none' => 'Ingen',
	'runquery' => 'Utfør spørring',
	'sf_runquery_badurl' => "Du må angi et skjemanavn i nettadressen;
nettadressen burde være på formen 'Special:RunQuery/&lt;form name&gt;'.",
	'sf_runquery_title' => 'Utfør spørring: $1',
	'sf_runquery_additionalquery' => 'Tilleggsspørring',
	'sf_formerrors_header' => 'Det var feil i skjemaet ditt; se nedenfor',
	'sf_blank_error' => 'kan ikke være blank',
	'sf_bad_url_error' => "må ha korrekt URL-format, inkludert 'http'",
	'sf_bad_email_error' => 'må ha gyldig format på e-postadressen',
	'sf_bad_number_error' => 'må være et gyldig tall',
	'sf_bad_integer_error' => 'må være et gyldig heltall',
	'sf_bad_date_error' => 'må være en gyldig dato',
	'uploadwindow' => 'Opplastingsvindu',
	'sf_deletionlog' => 'Slettingslogg',
	'sf_property_isproperty' => 'Dette er en egenskap av type $1.',
	'sf_property_linkstoform' => 'Det lenker til sider som bruker skjemaet $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Den tillatte verdien|De tillatte verdiene}} for denne egenskapen er:',
	'sf_template_docu' => 'Dette er malen «$1». Den burde kalles opp med følgende format:',
	'sf_template_docufooter' => 'Rediger siden for å se malteksten.',
	'sf_form_docu' => 'Dette er skjemaet «$1».
For å opprette en side med dette skjemaet, skriv inn sidenavnet under;
om en side med det navnet finnes allerede vil du bli sendt til et skjema for redigering av den siden.',
	'sf_form_freetextlabel' => 'Fritekst',
	'sf_category_hasdefaultform' => 'Denne kategorien bruker skjemaet $1.',
	'sf_category_desc' => 'Dette er kategorien $1',
	'sf_blank_namespace' => 'Hoved',
	'right-viewedittab' => 'Vis «Rediger»-fanen for sider som kan redigeres via skjema',
	'right-editrestrictedfields' => 'Rediger begrensede skjemafelt',
);

/** Northern Sotho (Sesotho sa Leboa)
 * @author Mohau
 */
$messages['nso'] = array(
	'sf_createproperty_propname' => 'Leina:',
	'sf_createproperty_proptype' => 'Mohuta:',
	'sf_createtemplate_deletefield' => 'Phumula',
	'sf_createform_add' => 'Lokela',
	'sf_createcategory_name' => 'Leina',
	'sf_formedit_createtitle' => 'Lokela $1: $2',
	'sf_formedit_edittitle' => 'Fetola $1: $2',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'semanticforms-desc' => 'Formularis per apondre e modificar de donadas semanticas',
	'specialpages-group-sf_group' => 'Semantic Forms',
	'createproperty' => 'Definir una proprietat',
	'sf_createproperty_linktoform' => "Aquesta proprietat ligarà cap a las paginas qu'utilizan lo formulari :",
	'sf_createproperty_allowedvalsinput' => "Se decidètz qu'aqueste camp accèpta pas que d'unas valors, picatz la lista de las valors permesas, separadas per de virgulas. (Se una valor conten una virgula, remplaçat-la per « \\, ») :",
	'sf_createproperty_propname' => 'Nom de la proprietat :',
	'sf_createproperty_proptype' => 'Tipe :',
	'templates' => 'Modèls',
	'sf_templates_docu' => 'Los modèls seguents existisson dins lo wiki.',
	'sf_templates_definescat' => 'definís la categoria :',
	'createtemplate' => 'Crear un modèl',
	'sf_createtemplate_namelabel' => 'Nom de modèl :',
	'sf_createtemplate_categorylabel' => 'Categoria definida per aqueste modèl (facultatiu) :',
	'sf_createtemplate_templatefields' => 'Camps de modèl',
	'sf_createtemplate_fieldsdesc' => "Per un modèl qu'utiliza pas cap de nom pels camps, entratz simplament son indèx (exemples : 1, 2, 3, etc.) pel nom, al luòc del nom actual.",
	'sf_createtemplate_fieldname' => 'Nom del camp :',
	'sf_createtemplate_displaylabel' => "Etiqueta per l'afichatge :",
	'sf_createtemplate_semanticproperty' => 'Proprietat de la semantica :',
	'sf_createtemplate_fieldislist' => 'Aqueste camp pòt conténer una lista de valors separadas per de virgulas.',
	'sf_createtemplate_aggregation' => 'Agregacion',
	'sf_createtemplate_aggregationdesc' => "Per listar, sus cada pagina qu'utilizan aqueste modèl, totas las qu'an una proprietat que punta cap a aquesta pagina, indicatz la proprietat adeqüata çaijós :",
	'sf_createtemplate_aggregationlabel' => 'Títol per la lista :',
	'sf_createtemplate_outputformat' => 'Format de sortida :',
	'sf_createtemplate_standardformat' => 'Estandard',
	'sf_createtemplate_infoboxformat' => 'Infobox de drecha',
	'sf_createtemplate_addfield' => 'Apondre un camp',
	'sf_createtemplate_deletefield' => 'Escafa',
	'sf_createtemplate_addtemplatebeforesave' => 'Vos cal apondre almens un modèl a aqueste formulari abans de lo poder salvar.',
	'forms' => 'Formularis',
	'sf_forms_docu' => 'Los formularis seguents existisson dins lo wiki.',
	'createform' => 'Crear un formulari',
	'sf_createform_nameinput' => 'Nom de formulari',
	'sf_createform_nameinputdesc' => '(la convencion es de nomenar lo formulari aprèp lo modèl principal qu’emplena) :',
	'sf_createform_template' => 'Modèl :',
	'sf_createform_templatelabelinput' => 'Etiqueta de modèl (facultatiu) :',
	'sf_createform_allowmultiple' => "Permetre mantuna (o zèro) instàncias d'aqueste modèl dins la pagina creada",
	'sf_createform_field' => 'Camp :',
	'sf_createform_fieldprop' => 'Aqueste camp definís la proprietat $1, del tipe $2.',
	'sf_createform_fieldproplist' => "Aqueste camp definís una lista dels elements qu'an la proprietat $1, del tipe $2.",
	'sf_createform_fieldpropunknowntype' => "Aqueste camp definís la proprietat $1, d'un tipe non indicat.",
	'sf_createform_inputtype' => "Tipe d'entrada :",
	'sf_createform_inputtypedefault' => '(per defaut)',
	'sf_createform_formlabel' => 'Etiqueta dins lo formulari:',
	'sf_createform_hidden' => 'Amagat',
	'sf_createform_restricted' => 'Restrench',
	'sf_createform_mandatory' => 'Obligatòri',
	'sf_createform_removetemplate' => 'Levar aqueste modèl',
	'sf_createform_addtemplate' => 'Apondre un modèl :',
	'sf_createform_beforetemplate' => 'Abans lo modèl :',
	'sf_createform_atend' => 'A la fin',
	'sf_createform_add' => 'Apondre',
	'sf_createform_choosefield' => "Causissètz un camp d'ajustar",
	'createcategory' => 'Crear una categoria',
	'sf_createcategory_name' => 'Nom de la categoria :',
	'sf_createcategory_defaultform' => 'Formulari per defaut :',
	'sf_createcategory_makesubcategory' => "Crèa una soscategoria d'una autra categoria (facultatiu) :",
	'createclass' => 'Crear una classa',
	'sf_createclass_docu' => 'Especificatz aicí las donadas que servisson per crear las proprietats, modèl, formulari e categoria d’una classa. Per mai d’opcions, utilizatz puslèu las paginas $1.',
	'sf_createclass_allowedvalues' => 'Valors autorizadas',
	'sf_createclass_listofvalues' => 'Lista de valors',
	'sf_createclass_leavefieldblank' => 'Se lo nom del champ es lo meteis que lo nom de la proprietat, podètz daissar aqueste camp void.',
	'sf_createclass_missingvalues' => 'Los camps obligatòris son pas estats emplenats totes.',
	'sf_createclass_success' => 'Las proprietats, modèl, formulari e categoria seràn creats.',
	'formstart' => 'Apondre una pagina amb un formulari',
	'sf_formstart_badform' => 'Error : cap de pagina de formulari es pas estada trobada sus $1.',
	'sf_formstart_badtitle' => 'Error : « $1 » es un títol de pagina invalid.',
	'sf_formstart_docu' => "Picatz aicí lo nom de la pagina destinada a èsser editada amb lo formulari « $1 ». Se aquesta pagina existís ja, seretz dirigit cap al formulari per l'editar. Dins lo cas contrari, seretz redirigit cap a lo que permet de l'apondre.",
	'sf_formstart_noform_docu' => "Picatz aicí lo nom de la pagina puèi seleccionatz lo formulari amb lo qual serà editada. S'aquesta pagina existís ja, seretz dirigit cap al formulari per l'editar. Dins lo cas contrari, seretz redirigit cap a lo que permet de l'apondre.",
	'sf_formstart_createoredit' => 'Modificar o apondre de donadas',
	'formedit' => 'Modificar amb un formulari',
	'sf_formedit_createtitle' => 'Apondre $1 : $2',
	'sf_formedit_badurl' => "Aquò es la pagina per apondre las donadas. Cal indicar un nom de formulari e una pagina cibla dins l'URL; l'URL se deu semblar a « Special:FormEdit?form=&lt;nom de formulari&gt;&target=&lt;nom de pagina cibla&gt; » o « Special:FormEdit/&lt;nom de formulari&gt;/&lt;nom de pagina cibla&gt; ».",
	'sf_formedit_altforms' => 'Podètz, a la plaça, apondre aquesta pagina amb un dels formularis seguents :',
	'sf_formedit_altformsonly' => 'Se vos plai, seleccionatz un dels formularis seguents per apondre aquesta pagina :',
	'sf_formcreate' => 'Crear amb un formulari',
	'sf_viewform' => 'Veire lo formulari',
	'sf_editsource' => 'Editar la font',
	'sf_formedit_edittitle' => 'Editar $1 : $2',
	'sf_formedit_morethanoneform' => 'Avertiment : Mai d’un formulari per defaut es especificat per aquesta pagina.',
	'sf_formedit_formwarning' => 'Atencion : aquesta pagina <a href="$1">existís ja</a>, mas utiliza pas aqueste formulari.',
	'sf_formedit_remove' => 'Levar',
	'sf_formedit_addanother' => 'Apondre un autre',
	'sf_formedit_none' => 'Cap',
	'runquery' => 'Executar la requèsta',
	'sf_runquery_badurl' => "Vos cal un nom de formulari dins l'URL ;
l'URL deuriá èsser coma « Special:RunQuery/&lt;nom del formulari&gt; ».",
	'sf_runquery_title' => 'Executar la requèsta : $1',
	'sf_runquery_additionalquery' => 'Requèsta adicionala',
	'sf_formerrors_header' => 'I a cèrtas errors dins lo formulari. Cf. çaijós.',
	'sf_blank_error' => 'pòt pas èsser blanc',
	'sf_bad_url_error' => 'deu aver un format URL corrècte, començant per « http »',
	'sf_bad_email_error' => "deu aver un format corrècte d'adreça de corrièr electronic.",
	'sf_bad_number_error' => 'deu èsser un nombre valid',
	'sf_bad_integer_error' => 'deu èsser un nombre entièr valid',
	'sf_bad_date_error' => 'deu èsser una data valida',
	'uploadwindow' => 'Importar la fenèstra',
	'sf_deletionlog' => 'Istoric de las supressions',
	'sf_property_isproperty' => 'Aquò es una proprietat del tipe $1.',
	'sf_property_linkstoform' => "Liga cap a las paginas qu'utilizan lo formulari $1.",
	'sf_property_allowedvals' => '{{PLURAL:$1|La valor autorizada per aquesta proprietat es|Las valors autorizadas per aquesta proprietat son}} :',
	'sf_template_docu' => 'Aquò es lo modèl « $1 ». Deuriá èsser apelat segon lo format seguent :',
	'sf_template_docufooter' => 'Modificar la pagina per veire lo tèxte del modèl.',
	'sf_form_docu' => "Aquò es lo formulari « $1 ». Per apondre una pagina amb aqueste formulari, picatz son nom çaijós ; se existís ja, seretz dirigit cap a un formulari destinat a l'editar.",
	'sf_form_freetextlabel' => 'Tèxte liure',
	'sf_category_hasdefaultform' => 'Aquesta categoria utiliza lo formulari « $1 ».',
	'sf_category_desc' => 'Aquò es la categoria « $1 ».',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => "Veire l'onglet « modificar » per las paginas modificablas via un formulari",
	'right-editrestrictedfields' => 'Modificar los camps restrenches dels formularis',
);

/** Ossetic (Иронау)
 * @author Amikeco
 */
$messages['os'] = array(
	'sf_createproperty_proptype' => 'Тип:',
	'templates' => 'Шаблонтæ',
	'sf_createtemplate_deletefield' => 'Аппар',
	'sf_createform_template' => 'Шаблон:',
	'sf_formedit_none' => 'Нæй',
);

/** Deitsch (Deitsch)
 * @author Xqt
 */
$messages['pdc'] = array(
	'templates' => 'Moddle',
	'sf_createtemplate_deletefield' => 'Lösche',
	'sf_createform_add' => 'Dezu duh',
	'sf_formstart_createoredit' => 'Dezu duh odder ennere',
	'sf_formedit_createtitle' => 'Duh $1: $2 dezu',
	'sf_formedit_edittitle' => '$1: $2 ennere',
	'sf_formedit_addanother' => 'Weidere dezu duh',
	'sf_formedit_none' => 'Ken',
	'sf_blank_namespace' => 'Blatt',
);

/** Polish (Polski)
 * @author Jwitos
 * @author Maikking
 * @author McMonster
 * @author Sp5uhe
 * @author ToSter
 */
$messages['pl'] = array(
	'semanticforms-desc' => 'Formularze do dodawania i edycji danych semantycznych',
	'specialpages-group-sf_group' => 'Semantyczne formularze',
	'createproperty' => 'Utwórz własność',
	'sf_createproperty_linktoform' => 'Ta własność linkuje do stron, które korzystają z formularza',
	'sf_createproperty_allowedvalsinput' => 'Jeśli chcesz, aby ta własność mogła zawierać tylko określone wartości, podaj listę dozwolonych wartości oddzielonych przecinkami (jeśli wartość zawiera przecinek, zastąp go „\\,”):',
	'sf_createproperty_propname' => 'Nazwa własności',
	'sf_createproperty_proptype' => 'Typ',
	'templates' => 'Szablony',
	'sf_templates_docu' => 'Następujące szablony istnieją w przestrzeni wiki.',
	'sf_templates_definescat' => 'definiuje kategorię',
	'createtemplate' => 'Utwórz szablon',
	'sf_createtemplate_namelabel' => 'Nazwa szablonu',
	'sf_createtemplate_categorylabel' => 'Kategoria zdefiniowana przez szablon (nieobowiązkowe)',
	'sf_createtemplate_templatefields' => 'Pola szablonu',
	'sf_createtemplate_fieldsdesc' => 'Aby pola szablonu nie wymagały nazw pól, wprowadź indeks dla każdego pola (np. 1, 2, 3 itd.) jako nazwę.',
	'sf_createtemplate_fieldname' => 'Nazwa pola',
	'sf_createtemplate_displaylabel' => 'Wyświetlana etykieta',
	'sf_createtemplate_semanticproperty' => 'Własność semantyczna',
	'sf_createtemplate_fieldislist' => 'Pole może zawierać listę wartości rozdzielonych przecinkami',
	'sf_createtemplate_aggregation' => 'Streszczenie',
	'sf_createtemplate_aggregationdesc' => 'Aby korzystając z tego szablonu wypisać na dowolnej stronie wszystkie strony, których pewna własność wskazuje na daną stronę, wybierz odpowiednią własność:',
	'sf_createtemplate_aggregationlabel' => 'Tytuł listy',
	'sf_createtemplate_outputformat' => 'Format wyjścia:',
	'sf_createtemplate_standardformat' => 'Standardowy',
	'sf_createtemplate_infoboxformat' => 'Infoboks po prawej',
	'sf_createtemplate_addfield' => 'Dodaj pole',
	'sf_createtemplate_deletefield' => 'Usuń',
	'sf_createtemplate_addtemplatebeforesave' => 'Musisz dodać przynajmniej jeden szablon do tego formularza, zanim go zapiszesz.',
	'forms' => 'Formularze',
	'sf_forms_docu' => 'Poniższe formularze są już zdefiniowane w przestrzeni wiki.',
	'createform' => 'Utwórz formularz',
	'sf_createform_nameinput' => 'Nazwa formularza',
	'sf_createform_nameinputdesc' => '(zwyczajowo nazwę formularza tworzy się z nazwy najczęściej wykorzystywanego w nim szablonu)',
	'sf_createform_template' => 'Szablon',
	'sf_createform_templatelabelinput' => 'Etykieta szablonu (nieobowiązkowa)',
	'sf_createform_allowmultiple' => 'Zezwól na wielokrotne użycie lub nieużycie tego szablonu na tworzonej stronie',
	'sf_createform_field' => 'Pole:',
	'sf_createform_fieldprop' => 'To pole definiuje własność $1 typu $2.',
	'sf_createform_fieldproplist' => 'To pole definiuje listę elementów, które mają własność $1 typu $2.',
	'sf_createform_fieldpropunknowntype' => 'To pole definiuje własność $1 nieznanego typu.',
	'sf_createform_inputtype' => 'Podaj typ',
	'sf_createform_inputtypedefault' => '(wartość domyślna)',
	'sf_createform_formlabel' => 'Etykieta formularza',
	'sf_createform_hidden' => 'Ukryte',
	'sf_createform_restricted' => 'Możliwość dokonania tej czynności zastrzeżona została dla użytkowników z uprawnieniami administratora',
	'sf_createform_mandatory' => 'Obowiązkowe',
	'sf_createform_removetemplate' => 'Usuń szablon',
	'sf_createform_addtemplate' => 'Dodaj szablon',
	'sf_createform_beforetemplate' => 'Przed szablonem',
	'sf_createform_atend' => 'Na końcu',
	'sf_createform_add' => 'Dodaj',
	'sf_createform_choosefield' => 'Wybierz pole do dodania',
	'createcategory' => 'Stwórz kategorię',
	'sf_createcategory_name' => 'Nazwa kategorii',
	'sf_createcategory_defaultform' => 'Domyślny formularz',
	'sf_createcategory_makesubcategory' => 'Uczyń tę kategorię podkategorią innej kategorii (nieobowiązkowe)',
	'createclass' => 'Utwórz klasę',
	'sf_createclass_docu' => 'Wpisz wszystkie informacje, aby utworzyć własności, szablon, formularz oraz kategorię dla pojedynczej klasy. Większa liczba opcji dostępna jest na stronie $1.',
	'sf_createclass_allowedvalues' => 'Dopuszczalne wartości',
	'sf_createclass_listofvalues' => 'Lista wartości',
	'sf_createclass_leavefieldblank' => 'Możesz pozostawić nazwę pola pustą, jeśli jest taka sama jak nazwa własności.',
	'sf_createclass_missingvalues' => 'Nie zostały wypełnione wszystkie wymagane pola.',
	'sf_createclass_success' => 'Zostaną utworzone: własności, szablon, formularz oraz kategoria.',
	'formstart' => 'Dodaj stronę z formularzem',
	'sf_formstart_badform' => 'Błąd – na $1 nie odnaleziono żadnego formularza',
	'sf_formstart_createoredit' => 'Dodaj lub edytuj',
	'formedit' => 'Edytuj korzystając z formularza',
	'sf_formedit_createtitle' => 'Dodaj $1: $2',
	'sf_formedit_altforms' => 'Zamiast tego możesz dodać stronę z jednym z następujących formularzy:',
	'sf_formedit_altformsonly' => 'Wybierz jeden z poniższych formularzy, aby dodać tę stronę:',
	'sf_formcreate' => 'Utwórz korzystając z formularza',
	'sf_viewform' => 'Zobacz formularz',
	'sf_editsource' => 'Edytuj źródło',
	'sf_formedit_edittitle' => 'Edytuj $1: $2',
	'sf_formedit_morethanoneform' => "'''Uwaga''' – dla tej strony zdefiniowano więcej niż jeden domyślny formularz.",
	'sf_formedit_formwarning' => 'Uwaga – ta strona <a href="$1">już istnieje</a>, ale nie używa tego formularza.',
	'sf_formedit_remove' => 'Usuń',
	'sf_formedit_addanother' => 'Dodaj kolejny',
	'sf_formedit_none' => 'Brak',
	'runquery' => 'Uruchom zapytanie',
	'sf_runquery_title' => 'Uruchom zapytanie: $1',
	'sf_runquery_additionalquery' => 'Dodatkowe zapytanie',
	'sf_formerrors_header' => 'We wprowadzonych przez Ciebie danych wystąpiły błędy; zobacz poniżej',
	'sf_blank_error' => 'nie może pozostać puste',
	'sf_bad_url_error' => 'musi mieć poprawny format adresu URL, rozpoczynającego się od „http”',
	'sf_bad_email_error' => 'musi mieć poprawny format adresu e‐mail',
	'sf_bad_number_error' => 'musi być poprawną liczbą',
	'sf_bad_integer_error' => 'musi być poprawną liczbą całkowitą',
	'sf_bad_date_error' => 'musi być poprawną datą',
	'uploadwindow' => 'Okno przesyłania plików',
	'sf_property_isproperty' => 'To jest własność typu $1.',
	'sf_property_linkstoform' => 'Linkuje do stron, używających formularza $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Dopuszczalna wartość dla tej własności to|Dopuszczalne wartości dla tej własności to:}}',
	'sf_template_docu' => 'To jest szablon „$1”.
Powinien zostać wywołany w następującym formacie:',
	'sf_template_docufooter' => 'Edytuj stronę, aby zobaczyć tekst szablonu.',
	'sf_form_docu' => 'To jest formularz „$1”.
Aby dodać stronę za pomocą tego formularza, wpisz poniżej nazwę strony.
Jeśli strona z tą nazwą już istnieje, otwarty zostanie formularz edycji tej strony.',
	'sf_form_freetextlabel' => 'Dowolny tekst',
	'sf_category_hasdefaultform' => 'Ta kategoria używa formularza $1.',
	'sf_category_desc' => 'To jest kategoria $1.',
	'sf_blank_namespace' => 'Główna',
	'right-viewedittab' => 'Widoczność zakładki „Edytuj” dla stron, które można edytować korzystając z formularza',
	'right-editrestrictedfields' => 'Edycja zabezpieczonych pól formularzy',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'semanticforms-desc' => 'Formolari për gionté e selessioné dat semàntich',
	'specialpages-group-sf_group' => 'Formolari Semàntich',
	'createproperty' => 'Crea na proprietà',
	'sf_createproperty_linktoform' => "Sta proprietà-sì a mandrà a le pàgine ch'a deuvro ël formolari:",
	'sf_createproperty_allowedvalsinput' => "S'a veul che costa proprietà-sì a peussa mach avèj serti valor, ch'a anserissa la lista dij valor possìbij, separà da 'd vìrgole (se un valor a conten na vìrgola, rimpiassla con \"\\,\"):",
	'sf_createproperty_propname' => 'Nòm dla proprietà:',
	'sf_createproperty_proptype' => 'Sòrt:',
	'templates' => 'Stamp',
	'sf_templates_docu' => 'Ant la wiki a esisto jë stamp sì-sota.',
	'sf_templates_definescat' => 'a definiss la categorìa:',
	'createtemplate' => 'Crea në stamp',
	'sf_createtemplate_namelabel' => 'Nòm ëd lë stamp:',
	'sf_createtemplate_categorylabel' => 'Categorìa definìa da stamp (opsional):',
	'sf_createtemplate_templatefields' => 'Camp dë stamp',
	'sf_createtemplate_fieldsdesc' => "Përché ij camp an sto stamp-sì a ciamo pa pi dij nòm ëd camp, ch'a anserissa mach l'ìndes ëd minca camp (për esempi 1, 2, 3, e via fòrt) për nòm, nopà dël nòm ver.",
	'sf_createtemplate_fieldname' => 'Nòm dël camp:',
	'sf_createtemplate_displaylabel' => 'Tichëtta për la visualisassion:',
	'sf_createtemplate_semanticproperty' => 'Proprietà semàntica:',
	'sf_createtemplate_fieldislist' => 'Sto camp-sì a peul ten-e na lista ëd valor, separà da vìrgole',
	'sf_createtemplate_aggregation' => 'Agregassion',
	'sf_createtemplate_aggregationdesc' => "Për listé, su minca pàgina ch'a deuvra sto stamp-sì, tute le pàgine ch'a l'han na serta proprietà ch'a ponta a cola pàgina, ch'a spessìfica sì-sota la proprietà ch'a-i va:",
	'sf_createtemplate_aggregationlabel' => 'Tìtol për lista:',
	'sf_createtemplate_outputformat' => 'Formà ëd surtìa:',
	'sf_createtemplate_standardformat' => 'Stàndard',
	'sf_createtemplate_infoboxformat' => "Banda dj'anformassion a drita",
	'sf_createtemplate_addfield' => 'Gionté un camp',
	'sf_createtemplate_deletefield' => 'Scancelé',
	'sf_createtemplate_addtemplatebeforesave' => 'A deuv gionté almanch në stamp a cost formolari-sì prima ëd podèj salvelo.',
	'forms' => 'Formolari',
	'sf_forms_docu' => 'Ij formolari sì-sota a esisto ant la wiki.',
	'createform' => 'Creé un formolari',
	'sf_createform_nameinput' => 'Nòm dël formolari',
	'sf_createform_nameinputdesc' => "(la convension a l'é ëd ciamé ël formolari conforma a lë stamp prinsipal ch'a ampiniss):",
	'sf_createform_template' => 'Stamp:',
	'sf_createform_templatelabelinput' => 'Etichëtta dlë stamp (opsional):',
	'sf_createform_allowmultiple' => "Përmëtte d'istanse mùltiple (o gnun-e) dë sto stamp-sì ant la pàgina creà",
	'sf_createform_field' => 'Camp:',
	'sf_createform_fieldprop' => 'Sto camp-sì a definiss la proprietà $1, ëd sòrt $2.',
	'sf_createform_fieldproplist' => "Sto camp-sì a definiss na lista d'element ch'a l'han la proprietà $1, ëd sòrt $2.",
	'sf_createform_fieldpropunknowntype' => 'Sto camp-sì a definiss la proprietà $1, ëd sòrt pa spessificà.',
	'sf_createform_inputtype' => "Tipo d'ingress:",
	'sf_createform_inputtypedefault' => '(stàndard)',
	'sf_createform_formlabel' => 'Etichëtta dël formolari:',
	'sf_createform_hidden' => 'Stërmà',
	'sf_createform_restricted' => 'Riservà (mach utent aministrator a peulo modifichelo)',
	'sf_createform_mandatory' => 'Obligatòri',
	'sf_createform_removetemplate' => 'Gavé lë stamp',
	'sf_createform_addtemplate' => 'Gionté në stamp:',
	'sf_createform_beforetemplate' => 'Prima dlë stamp:',
	'sf_createform_atend' => 'A la fin',
	'sf_createform_add' => 'Gionta',
	'sf_createform_choosefield' => 'Sern un camp da gionté',
	'createcategory' => 'Crea na categorìa',
	'sf_createcategory_name' => 'Nòm dla categorìa:',
	'sf_createcategory_defaultform' => 'Formolari dë stàndard:',
	'sf_createcategory_makesubcategory' => "Fé vnì sta categorìa-sì na sot-categorìa ëd n'àutra categorìa (opsional):",
	'createclass' => 'Crea na class',
	'sf_createclass_docu' => "Ch'a anseriss sì tùit ij dat për creé le proprietà, stamp, formolari e categorìa për na sìngola class. Për pi d'opsion, ch'a deuvra pitòst le pàgine $1.",
	'sf_createclass_allowedvalues' => 'Valor përmëttù',
	'sf_createclass_listofvalues' => 'Lista ëd valor',
	'sf_createclass_leavefieldblank' => "Se ël nòm dël camp a l'é l'istess che ël nòm dla proprietà, a peul lasselo veuid.",
	'sf_createclass_missingvalues' => 'Pa tùit ij camp ciamà a son stàit ampinì.',
	'sf_createclass_success' => 'Proprietà, stamp, formolari e categorìa a saran creà.',
	'formstart' => 'Gionté na pàgina con un formolari',
	'sf_formstart_badform' => "Eror: gnun-a pàgina ëd formolari a l'é stàita trovà a $1",
	'sf_formstart_badtitle' => 'Eror: "$1" a l\'é un tìtol pa bon për na pàgina.',
	'sf_formstart_docu' => 'Ch\'a anserissa ël nòm ëd la pàgina ambelessì, da modifiché con ël formolari "$1".
Se sta pàgina-sì a esist già, a sarà mandà al formolari për modifiché cola pàgina.
Dësnò, a sarà mandà al formolari për gionté la pàgina.',
	'sf_formstart_noform_docu' => "Ch'a anserissa ël nòm ëd la pàgina ambelessì, e ch'a selession-a ël formolari për modifichela.
Se sta pàgina-sì a esist già, a sarà mandà al formolari për modifiché cola pàgina.
Dësnò, a sarà mandà al formolari për gionté la pàgina.",
	'sf_formstart_createoredit' => 'Crea o modìfica',
	'formedit' => 'Modifiché con un formolari',
	'sf_formedit_createtitle' => 'Crea $1: $2',
	'sf_formedit_badurl' => "Costa-sì a l'é la pàgina për modifiché con un formolari. A dev spessifiché sia un nòm ëd formolari sia na pàgina obietiv ant l'adrëssa dl'aragnà;
a dovrìa smijé a 'Special:FormEdit?form=&lt;form name&gt;&target=&lt;nòm dla pàgina&gt;', or  
'Special:FormEdit/&lt;form name&gt;/&lt;nòm dla pàgina&gt;'.",
	'sf_formedit_altforms' => 'A peul anvece gionté sta pàgina-sì con un dij formolari sì-sota:',
	'sf_formedit_altformsonly' => "Për piasì, ch'a selession-a un dij formolari sì-sota për gionté costa pàgina:",
	'sf_formcreate' => 'Creé con un formolari',
	'sf_viewform' => 'Visualisé ël formolari',
	'sf_editsource' => 'Modifiché la sorgiss',
	'sf_formedit_edittitle' => 'Modìfica $1: $2',
	'sf_formedit_morethanoneform' => "'''Atension:''' Pi che un formolari dë stàndard a l'é spessificà për costa pàgina.",
	'sf_formedit_formwarning' => 'Atension: Sta pàgina-sì <a href="$1">a esist già</a>, ma a deuvra pa cost formolari.',
	'sf_formedit_remove' => 'Gava',
	'sf_formedit_addanother' => "Gionté n'àutr",
	'sf_formedit_none' => 'Gnun',
	'runquery' => 'Consulté la base dat',
	'sf_runquery_badurl' => "A deuv spessifiché un nòm ëd formolari ant l'adrëssa dl'aragnà;
l'adrëssa a dovrìa esse com 'Special:RunQuery/&lt;nom del formolari&gt;'.",
	'sf_runquery_title' => "Fé andé l'arcesta: $1",
	'sf_runquery_additionalquery' => 'Arcesta adissional',
	'sf_formerrors_header' => "A-i son ëstaje d'eror con l'imission ëd sò formolari; beiché sì-sota",
	'sf_blank_error' => 'a peul pa esse veuid',
	'sf_bad_url_error' => "a deuv avèj ël formà d'adrëssa giust, partend con 'http'",
	'sf_bad_email_error' => "a deuv avèj un formà bon ëd l'adrëssa ëd pòsta eletrònica",
	'sf_bad_number_error' => 'a deuv esse un nùmer bon',
	'sf_bad_integer_error' => "a deuv esse n'antregh ch'a vada bin",
	'sf_bad_date_error' => 'a deuv esse na data bon-a',
	'uploadwindow' => 'Carié la fnestra',
	'sf_deletionlog' => 'Registr djë scancelament',
	'sf_property_isproperty' => "Costa-sì a l'é na proprietà ëd sòrt $1.",
	'sf_property_linkstoform' => "A colega a le pàgine ch'a deuvro ël formolari $1.",
	'sf_property_allowedvals' => "{{PLURAL:$1|Ël valor përmëttù për sta proprietà-sì a l'é|Ij valor përmëttù për sta proprietà-sì a son}}:",
	'sf_template_docu' => 'Cost-sì a l\'é lë stamp "$1".
A dovrìa esse arciamà ant ël formà sì-sota:',
	'sf_template_docufooter' => 'Modìfica la pàgina për vëdde ël test ëd lë stamp.',
	'sf_form_docu' => 'Cost-sì a l\'é ël formolari "$1".
Për creé na pàgina con cost formolari, ch\'a anserissa ël nòm ëd la pàgina sì-sota;
se na pàgina con col nòm a esist già, a sarà mandà a \'n formolari për modifiché cola pàgina.',
	'sf_form_freetextlabel' => 'Test lìber.',
	'sf_category_hasdefaultform' => 'Sta categorìa-sì a deuvra ël formolari $1.',
	'sf_category_desc' => "Costa a l'é la categorìa $1.",
	'sf_blank_namespace' => 'Prinsipal',
	'right-viewedittab' => 'Visualisé ël boton "Modifiché" për le pàgine modificàbij con un formolari',
	'right-editrestrictedfields' => 'Modìfiché ij camp ëd formolari arservà',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'createproperty' => 'يوه ځانتيا ځانګړې کول',
	'sf_createproperty_propname' => 'د ځانتيا نوم:',
	'sf_createproperty_proptype' => 'ډول:',
	'templates' => 'کينډۍ',
	'sf_templates_definescat' => 'د وېشنيزې څرګندونه:',
	'createtemplate' => 'يوه کينډۍ جوړول',
	'sf_createtemplate_namelabel' => 'د کينډۍ نوم:',
	'sf_createtemplate_aggregationlabel' => 'د لړليک لپاره سرليک:',
	'sf_createtemplate_deletefield' => 'ړنګول',
	'sf_createform_template' => 'کينډۍ:',
	'sf_createform_inputtypedefault' => '(تلواليز)',
	'sf_createform_hidden' => 'پټ',
	'sf_createform_addtemplate' => 'کينډۍ ورګډول:',
	'sf_createform_atend' => 'په پای کې',
	'sf_createform_add' => 'ورګډول',
	'createcategory' => 'يوه وېشنيزه جوړول',
	'sf_createcategory_name' => 'د وېشنيزې نوم:',
	'formstart' => 'د فورمې سره يوځای يو مخ ګډول',
	'sf_formstart_createoredit' => 'جوړول يا سمول',
	'sf_formedit_createtitle' => '$1 جوړول: $2',
	'sf_formedit_remove' => 'غورځول',
	'sf_formedit_addanother' => 'يو بل ورګډول',
	'sf_formedit_none' => 'هېڅ',
	'sf_bad_email_error' => 'بايد چې برېښليک پته يوه سمه بڼه ولري',
	'sf_bad_number_error' => 'بايد چې يوه سمه شمېره وي',
	'sf_bad_date_error' => 'بايد چې يوه سمه نېټه وي',
	'sf_deletionlog' => 'د ړنګولو يادښت',
	'sf_form_freetextlabel' => 'خپلواکه متن',
	'sf_category_desc' => 'همدا د $1 وېشنيزه ده.',
);

/** Portuguese (Português)
 * @author 555
 * @author Hamilton Abreu
 * @author Lijealso
 * @author Malafaya
 * @author Waldir
 */
$messages['pt'] = array(
	'semanticforms-desc' => 'Formulários para adicionar e editar dados semânticos',
	'specialpages-group-sf_group' => 'Formulários Semânticos',
	'createproperty' => 'Criar uma propriedade',
	'sf_createproperty_linktoform' => 'Esta propriedade irá ligar às páginas que usem o formulário:',
	'sf_createproperty_allowedvalsinput' => 'Se pretende que esta propriedade apenas possa conter determinados valores, introduza a lista de valores permitidos, separados por vírgulas (se um valor contém uma vírgula, substitua-a por "\\,"):',
	'sf_createproperty_propname' => 'Nome da propriedade:',
	'sf_createproperty_proptype' => 'Tipo:',
	'templates' => 'Predefinições',
	'sf_templates_docu' => 'As seguintes predefinições existem nesta wiki.',
	'sf_templates_definescat' => 'definir categoria:',
	'createtemplate' => 'Criar uma predefinição',
	'sf_createtemplate_namelabel' => 'Nome da predefinição:',
	'sf_createtemplate_categorylabel' => 'Categoria definida pela predefinição (opcional):',
	'sf_createtemplate_templatefields' => 'Campos da predefinição:',
	'sf_createtemplate_fieldsdesc' => 'Para fazer com que os campos deste modelo não requiram descrições, simplesmente introduza o índice de cada campo (p.ex. 1, 2, 3, etc.) como o nome do campo, em vez de um nome real.',
	'sf_createtemplate_fieldname' => 'Nome do campo:',
	'sf_createtemplate_displaylabel' => 'Mostrar etiqueta:',
	'sf_createtemplate_semanticproperty' => 'Propriedade semântica:',
	'sf_createtemplate_fieldislist' => 'Este campo permite uma lista de valores, separados por vírgulas',
	'sf_createtemplate_aggregation' => 'Agregação',
	'sf_createtemplate_aggregationdesc' => 'Para listar, em qualquer página usando esta predefinição, todos os artigos que têm uma certa propriedade a apontar para aquela página, especifique a propriedade adequada abaixo:',
	'sf_createtemplate_aggregationlabel' => 'Título para a lista:',
	'sf_createtemplate_outputformat' => 'Formato de saída:',
	'sf_createtemplate_standardformat' => 'Padrão',
	'sf_createtemplate_infoboxformat' => 'Caixa informativa do lado direito',
	'sf_createtemplate_addfield' => 'Adicionar campo',
	'sf_createtemplate_deletefield' => 'Apagar',
	'sf_createtemplate_addtemplatebeforesave' => 'Tem de adicionar pelo menos uma predefinição a este formulário antes de o poder gravar.',
	'forms' => 'Formulários',
	'sf_forms_docu' => 'Os seguintes formulários existem na wiki.',
	'createform' => 'Criar um formulário',
	'sf_createform_nameinput' => 'Nome do formulário',
	'sf_createform_nameinputdesc' => '(a convenção é a de nomear o formulário segundo a predefinição principal que preenche):',
	'sf_createform_template' => 'Predefinição:',
	'sf_createform_templatelabelinput' => 'Etiqueta da predefinição (opcional):',
	'sf_createform_allowmultiple' => 'Permitir múltiplas (ou zero) instâncias desta predefinição na página criada',
	'sf_createform_field' => 'Campo:',
	'sf_createform_fieldprop' => 'Este campo define a propriedade $1, do tipo $2.',
	'sf_createform_fieldproplist' => 'Este campo define uma lista de elementos que possuem a propriedade $1, do tipo $2.',
	'sf_createform_fieldpropunknowntype' => 'Este campo define uma propriedade $1, de tipo não especificado.',
	'sf_createform_inputtype' => 'Tipo de entrada:',
	'sf_createform_inputtypedefault' => '(padrão)',
	'sf_createform_formlabel' => 'Etiqueta do formulário:',
	'sf_createform_hidden' => 'Oculto',
	'sf_createform_restricted' => 'Restrito (apenas sysops poderão modificá-lo)',
	'sf_createform_mandatory' => 'Obrigatório',
	'sf_createform_removetemplate' => 'Remover predefinição',
	'sf_createform_addtemplate' => 'Adicionar predefinição:',
	'sf_createform_beforetemplate' => 'Antes da predefinição:',
	'sf_createform_atend' => 'Ao fim',
	'sf_createform_add' => 'Adicionar',
	'sf_createform_choosefield' => 'Escolha um campo a adicionar',
	'createcategory' => 'Criar uma categoria',
	'sf_createcategory_name' => 'Nome da categoria:',
	'sf_createcategory_defaultform' => 'Formulário padrão:',
	'sf_createcategory_makesubcategory' => 'Fazer desta categoria uma subcategoria de outra categoria (opcional):',
	'createclass' => 'Criar uma classe',
	'sf_createclass_docu' => 'Introduza todos os dados aqui para criar as propriedades, modelo, formulário e categoria para uma única classe. Para mais opções, utilize antes as páginas $1.',
	'sf_createclass_allowedvalues' => 'Valores permitidos',
	'sf_createclass_listofvalues' => 'Lista de valores',
	'sf_createclass_leavefieldblank' => 'Se o nome do campo é o mesmo que o nome da propriedade, pode deixá-lo em branco.',
	'sf_createclass_missingvalues' => 'Os campos obrigatórios não foram todos preenchidos.',
	'sf_createclass_success' => 'Propriedades, modelo, formulário e categoria serão criados.',
	'formstart' => 'Adicionar página com formulário',
	'sf_formstart_badform' => 'Erro: não foi encontrada nenhuma página de formulário em $1',
	'sf_formstart_badtitle' => 'Erro: "$1" é um título inválido para uma página.',
	'sf_formstart_docu' => "Introduza o nome da página aqui, para ser editada com o formulário '$1'.
Se a página já existir, será enviado para o formulário de edição dessa página.
Caso contrário, será enviado para o formulário de adição da página.",
	'sf_formstart_noform_docu' => 'Introduza o nome da página aqui, e selecione um formulário a usar na sua edição.
Se a página já existir, será enviado para o formulário de edição dessa página.
Caso contrário, será enviado para o formulário de adição da página.',
	'sf_formstart_createoredit' => 'Criar ou editar',
	'formedit' => 'Editar com formulário',
	'sf_formedit_createtitle' => 'Criar $1: $2',
	'sf_formedit_badurl' => "Esta é a página para editar com um formulário. Na URL deve especificar um nome de formulário e uma página alvo; deverá parecer-se com 'Special:FormEdit?form=&lt;form name&gt;&target=&lt;target page&gt;', ou 'Special:FormEdit/&lt;form name&gt;/&lt;target page&gt;'.",
	'sf_formedit_altforms' => 'Pode, em alternativa, adicionar esta página com um dos seguintes formulários:',
	'sf_formedit_altformsonly' => 'Por favor, seleccione um dos seguintes formulários para adicionar esta página:',
	'sf_formcreate' => 'Criar com formulário',
	'sf_viewform' => 'Ver formulário',
	'sf_editsource' => 'Editar a origem',
	'sf_formedit_edittitle' => 'Editar $1: $2',
	'sf_formedit_morethanoneform' => 'Atenção: Mais de um formulário padrão está definido para esta página.',
	'sf_formedit_formwarning' => 'Aviso: Esta página <a href="$1">já existe</a>, mas não utiliza este formulário.',
	'sf_formedit_remove' => 'Remover',
	'sf_formedit_addanother' => 'Adicionar outro',
	'sf_formedit_none' => 'Nenhum',
	'runquery' => 'Executar consulta',
	'sf_runquery_badurl' => "Deve especificar um nome de formulário na URL;
deverá parecer-se com 'Special:RunQuery/&lt;form name&gt;'.",
	'sf_runquery_title' => 'Executar consulta: $1',
	'sf_runquery_additionalquery' => 'Consulta adicional',
	'sf_formerrors_header' => 'Houve erros nas entradas do seu formulário; veja abaixo',
	'sf_blank_error' => 'não pode estar em branco',
	'sf_bad_url_error' => "Tem de ter o formato de URL correcto, começando com 'http'",
	'sf_bad_email_error' => 'deverá introduzir um endereço de correio electrónico com formato válido',
	'sf_bad_number_error' => 'deverá introduzir um número válido',
	'sf_bad_integer_error' => 'deverá introduzir um inteiro válido',
	'sf_bad_date_error' => 'deverá introduzir uma data válida',
	'uploadwindow' => 'Janela de carregamento',
	'sf_deletionlog' => 'Registo de eliminações',
	'sf_property_isproperty' => 'Esta é uma propriedade do tipo $1.',
	'sf_property_linkstoform' => 'Liga às páginas que usam o formulário $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|O valor permitido para esta propriedade é|Os valores permitidos para esta propriedade são}}:',
	'sf_template_docu' => "Esta é a predefinição '$1'.
Ela deverá ser chamada no seguinte formato:",
	'sf_template_docufooter' => 'Edite a página para ver o texto da predefinição',
	'sf_form_docu' => 'Este é o formulário "$1".
Para criar uma página com este formulário, introduza o nome da página abaixo;
se já existir uma página com o mesmo nome, será reencaminhado para um formulário para editar essa página.',
	'sf_form_freetextlabel' => 'Texto livre',
	'sf_category_hasdefaultform' => 'Esta categoria usa o formulário $1.',
	'sf_category_desc' => 'Esta é a categoria $1.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Ver o separador "Editar" para páginas editáveis por formulário',
	'right-editrestrictedfields' => 'Editar os campos restritos de formulários',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author 555
 * @author Crazymadlover
 * @author Eduardo.mps
 * @author Enqd
 * @author Leonardo Costa
 * @author Luckas Blade
 * @author Rafael Vargas
 */
$messages['pt-br'] = array(
	'semanticforms-desc' => 'Formulários para adicionar e editar dados semânticos',
	'specialpages-group-sf_group' => 'Formulários Semânticos',
	'createproperty' => 'Criar uma propriedade',
	'sf_createproperty_linktoform' => 'Esta propriedade irá ligar às páginas que usem o formulário:',
	'sf_createproperty_allowedvalsinput' => 'Se pretende que esta propriedade apenas possa conter determinados valores, introduza a lista de valores permitidos, separados por vírgulas (se um valor contém uma vírgula, substitua-a por "\\,"):',
	'sf_createproperty_propname' => 'Nome da propriedade:',
	'sf_createproperty_proptype' => 'Tipo:',
	'templates' => 'Predefinições',
	'sf_templates_docu' => 'Existem as seguintes predefinições neste wiki.',
	'sf_templates_definescat' => 'define categoria:',
	'createtemplate' => 'Criar uma predefinição',
	'sf_createtemplate_namelabel' => 'Nome da predefinição:',
	'sf_createtemplate_categorylabel' => 'Categoria definida por predefinição (opcional):',
	'sf_createtemplate_templatefields' => 'Campos da predefinição',
	'sf_createtemplate_fieldsdesc' => 'Para ter os campos nesta predefinição não é necessário o nome dos campos, simplesmente entre com o índice de cada campo (e.g. 1, 2, 3, etc.) como nome, ao invés de um nome atual.',
	'sf_createtemplate_fieldname' => 'Nome do campo:',
	'sf_createtemplate_displaylabel' => 'Exibir rótulo:',
	'sf_createtemplate_semanticproperty' => 'Propriedade semântica:',
	'sf_createtemplate_fieldislist' => 'Este campo pode manter uma lista de valores, separados por vírgulas',
	'sf_createtemplate_aggregation' => 'Agregação',
	'sf_createtemplate_aggregationdesc' => 'Para listar, em qualquer página usando essa predefinição, todas as páginas que tem uma determinada propriedade apontando para aquela página, especifique a propriedade apropriada abaixo:',
	'sf_createtemplate_aggregationlabel' => 'Título para a lista:',
	'sf_createtemplate_outputformat' => 'Formato de saída:',
	'sf_createtemplate_standardformat' => 'Padrão',
	'sf_createtemplate_infoboxformat' => 'Caixa informativa do lado direito',
	'sf_createtemplate_addfield' => 'Adicionar campo',
	'sf_createtemplate_deletefield' => 'Deletar',
	'sf_createtemplate_addtemplatebeforesave' => 'Você deve adicionar ao menos uma predefinição para este formulário antes de salvar.',
	'forms' => 'Formulários',
	'sf_forms_docu' => 'Existem os seguintes formulários neste wiki.',
	'createform' => 'Criar um formulário',
	'sf_createform_nameinput' => 'Nome do formulário',
	'sf_createform_nameinputdesc' => '(a convenção é a de nomear o formulário segundo a predefinição principal que preenche):',
	'sf_createform_template' => 'Predefinição:',
	'sf_createform_templatelabelinput' => 'Título da predefinição (opcional):',
	'sf_createform_allowmultiple' => 'Permitir várias instâncias (ou zero) dessa predefinição na página criada',
	'sf_createform_field' => 'Campo:',
	'sf_createform_fieldprop' => 'Este campo define a propriedade $1, do tipo $2.',
	'sf_createform_fieldproplist' => 'Este campo define uma lista de elementos que tem a propriedade $1, do tipo $2.',
	'sf_createform_fieldpropunknowntype' => 'Este campo define a propriedade $1, de um tipo não especificado.',
	'sf_createform_inputtype' => 'Tipo de entrada:',
	'sf_createform_inputtypedefault' => '(padrão)',
	'sf_createform_formlabel' => 'Título do formulário:',
	'sf_createform_hidden' => 'Escondido',
	'sf_createform_restricted' => 'Restrito (somente usuários sysop podem modificar isto)',
	'sf_createform_mandatory' => '	Obrigatório',
	'sf_createform_removetemplate' => 'Remover predefinição',
	'sf_createform_addtemplate' => 'Adicionar predefinição:',
	'sf_createform_beforetemplate' => 'Predefinição anterior:',
	'sf_createform_atend' => 'No final',
	'sf_createform_add' => 'Adicionar',
	'sf_createform_choosefield' => 'Escolha um campo para adicionar',
	'createcategory' => 'Criar uma categoria',
	'sf_createcategory_name' => 'Nome da categoria:',
	'sf_createcategory_defaultform' => 'Formulário padrão:',
	'sf_createcategory_makesubcategory' => 'Faz desta uma subcategoria de outra categoria (opcional):',
	'createclass' => 'Criar uma classe',
	'sf_createclass_docu' => 'Introduza todos os dados aqui para criar as propriedades, predefinições, formulários e categorias para cada classe. Para mais opções, use as páginas $1.',
	'sf_createclass_allowedvalues' => 'Valores permitidos',
	'sf_createclass_listofvalues' => 'Lista de valores',
	'sf_createclass_leavefieldblank' => 'Se o nome do campo é o mesmo que o nome da propriedade, você pode deixá-lo em branco.',
	'sf_createclass_missingvalues' => 'Nem todos os campos requeridos foram preenchidos.',
	'sf_createclass_success' => 'As propriedades, predefinições, os formulários e categorias serão criados.',
	'formstart' => 'Adicionar página',
	'sf_formstart_badform' => 'Erro: nenhum formulário de página foi encontrado em $1',
	'sf_formstart_badtitle' => 'Erro: "$1" é um título inválido para uma página.',
	'sf_formstart_docu' => "Entre com o nome da página aqui, para ser editado com o formulário '$1'. Se esta página já existir, você será direcionado para o formulário para editar a página. Senão, você será direcionado para o formulário para adicionar a página.",
	'sf_formstart_noform_docu' => 'Entre com o nome da página aqui, e selecione o formulário na qual a página será editada. Se esta página já existir, você será direcionado para o formulário para editar a página.  Senão, você será direcionado para o formulário para adicionar a página.',
	'sf_formstart_createoredit' => 'Criar ou editar',
	'formedit' => 'Editar com formulário',
	'sf_formedit_createtitle' => 'Criar $1: $2',
	'sf_formedit_badurl' => "Esta é a página para editar com um formulário. É necessário especificar na URL um nome de formulário e uma página alvo; 
ficará algo como 'Special:FormEdit?form=&lt;form name&gt;&target=&lt;target page&gt;', ou 'Special:FormEdit/&lt;form name&gt;/&lt;target page&gt;'.",
	'sf_formedit_altforms' => 'Você também pode adicionar está página com um dos seguintes formulários:',
	'sf_formedit_altformsonly' => 'Por favor selecione através de um dos seguintes formulários para adicionar esta página:',
	'sf_formcreate' => 'Criar com formulário',
	'sf_viewform' => 'Ver formulário',
	'sf_editsource' => 'Editar fonte',
	'sf_formedit_edittitle' => 'Editar $1: $2',
	'sf_formedit_morethanoneform' => 'Aviso: Mais de um formulário padrão está definido para esta página.',
	'sf_formedit_formwarning' => 'Perigo: Esta página <a href="$1">already exists</a>, mas não use esse formulário.',
	'sf_formedit_remove' => 'Remover',
	'sf_formedit_addanother' => 'Adicionar outro',
	'sf_formedit_none' => 'Nenhum',
	'runquery' => 'Executar consulta',
	'sf_runquery_badurl' => "Você deve especificar um nome de formulário na URL;
a URL deve se parecer com 'Special:RunQuery/&lt;form name&gt;'.",
	'sf_runquery_title' => 'Executar consulta: $1',
	'sf_runquery_additionalquery' => 'Consulta adicional',
	'sf_formerrors_header' => 'Houve erros nas entradas do seu formulário; veja abaixo',
	'sf_blank_error' => 'Não pode ficar em branco',
	'sf_bad_url_error' => "deve ter o formato correto da URL, começando com 'http'",
	'sf_bad_email_error' => 'deve ter um formato válido de email',
	'sf_bad_number_error' => 'deve ser um número válido',
	'sf_bad_integer_error' => 'deve ser um válido integer',
	'sf_bad_date_error' => 'deve ser uma data válida',
	'uploadwindow' => 'Janela de carregamento',
	'sf_deletionlog' => 'Registro de eliminações',
	'sf_property_isproperty' => 'Esta é uma propriedade do tipo $1.',
	'sf_property_linkstoform' => 'Liga às páginas que usam o formulário $1.',
	'sf_property_allowedvals' => 'Os {{PLURAL:$1|valor permitido para este propriedade é|valores permitidos para este propriedade são}}:',
	'sf_template_docu' => "Esta é a '$1' predefinição.
Ela deve ser chamada no seguinte formato:",
	'sf_template_docufooter' => 'Edite a página para ver o texto da predefinição.',
	'sf_form_docu' => 'Este é o formulário "$1".
Para criar uma página com este formulário, insira o nome da página abaixo;
se já existir uma página com o mesmo nome, você será encaminhado para um formulário, para editar essa página.',
	'sf_form_freetextlabel' => 'Texto livre',
	'sf_category_hasdefaultform' => 'Esta categoria usa o formulário $1.',
	'sf_category_desc' => 'Esta é a $1 categoria.',
	'sf_blank_namespace' => 'Principal',
	'right-viewedittab' => 'Ver a aba "Editar" para páginas editáveis por formulário',
	'right-editrestrictedfields' => 'Editar campos restritos de formulários',
);

/** Tarifit (Tarifit)
 * @author Jose77
 */
$messages['rif'] = array(
	'sf_createtemplate_deletefield' => 'Sfaḍ',
);

/** Romanian (Română)
 * @author Firilacroco
 * @author KlaudiuMihaila
 * @author Mihai
 */
$messages['ro'] = array(
	'specialpages-group-sf_group' => 'Formulare semantice',
	'createproperty' => 'Creați o proprietate',
	'sf_createproperty_propname' => 'Numele proprietății:',
	'sf_createproperty_proptype' => 'Tip:',
	'templates' => 'Formate',
	'sf_templates_definescat' => 'definește o categorie:',
	'createtemplate' => 'Creați un format',
	'sf_createtemplate_namelabel' => 'Numele formatului:',
	'sf_createtemplate_fieldname' => 'Numele câmpului:',
	'sf_createtemplate_semanticproperty' => 'Proprietate semnatică:',
	'sf_createtemplate_aggregation' => 'Agregare',
	'sf_createtemplate_aggregationlabel' => 'Titlu pentru listă:',
	'sf_createtemplate_outputformat' => 'Format ieșire:',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_addfield' => 'Adăugați un câmp',
	'sf_createtemplate_deletefield' => 'Şterge',
	'forms' => 'Formular',
	'createform' => 'Creați un formular',
	'sf_createform_nameinput' => 'Numele formularului',
	'sf_createform_template' => 'Format:',
	'sf_createform_field' => 'Câmp:',
	'sf_createform_fieldprop' => 'Acest câmp definește proprietatea $1, de tipul $2.',
	'sf_createform_inputtype' => 'Tip intrare:',
	'sf_createform_formlabel' => 'Eticheta formularului',
	'sf_createform_hidden' => 'Ascunse',
	'sf_createform_mandatory' => 'Obligatoriu',
	'sf_createform_removetemplate' => 'Ştergeți formatul',
	'sf_createform_addtemplate' => 'Introduceți format:',
	'sf_createform_beforetemplate' => 'Înainte de format:',
	'sf_createform_atend' => 'La sfârșit',
	'sf_createform_add' => 'Adaugă',
	'sf_createform_choosefield' => 'Alegeți un câmp de introdus',
	'createcategory' => 'Creați o categorie',
	'sf_createcategory_name' => 'Numele categoriei:',
	'sf_createcategory_defaultform' => 'Formular inițial:',
	'sf_createclass_allowedvalues' => 'Valori permise',
	'sf_createclass_listofvalues' => 'Listă de valori',
	'sf_createclass_missingvalues' => 'Nu toate câmpurile necesare au fost completate.',
	'formstart' => 'Adaugă o pagină cu un formular',
	'sf_formstart_createoredit' => 'Adăugați sau modificați',
	'formedit' => 'Editează cu un formular',
	'sf_formedit_createtitle' => 'Adăugare $1: $2',
	'sf_formcreate' => 'Creați un formular',
	'sf_viewform' => 'Vedeți formular',
	'sf_editsource' => 'Modificare sursă',
	'sf_formedit_edittitle' => 'Modificare $1: $2',
	'sf_formedit_remove' => 'Elimină',
	'sf_formedit_addanother' => 'Adăugați altul',
	'sf_formedit_none' => 'Nimic',
	'runquery' => 'Executare interogare',
	'sf_blank_error' => 'nu poate fi gol',
	'sf_bad_number_error' => 'trebuie să fie un număr corect',
	'sf_bad_integer_error' => 'trebuie să fie un număr întreg corect',
	'sf_bad_date_error' => 'trebuie să fie o dată corectă',
	'uploadwindow' => 'Fereastra de încărcare',
	'sf_deletionlog' => 'Jurnalul ștergerilor',
	'sf_property_isproperty' => 'Aceasta este o proprietate de tipul $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Valoarea admisă pentru această proprietate este|Valorile admise pentru această proprietate sunt}}:',
	'sf_form_freetextlabel' => 'Text liber',
	'sf_blank_namespace' => 'Principal',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'sf_createform_field' => 'Cambe:',
);

/** Russian (Русский)
 * @author Ferrer
 * @author Innv
 * @author Kaganer
 * @author Lockal
 * @author QuestPC
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'semanticforms-desc' => 'Формы для добавления и правки семантических данных',
	'specialpages-group-sf_group' => 'Семантические формы',
	'createproperty' => 'Создать свойство',
	'sf_createproperty_linktoform' => 'Это свойство содержит ссылку на страницы, которые используют форму:',
	'sf_createproperty_allowedvalsinput' => 'Если вы хотите, чтобы данное свойство могло содержать только определённые значения, введите через запятую список допустимых значений (если значение содержит запятую, то замените её на «\\,»):',
	'sf_createproperty_propname' => 'Имя свойства:',
	'sf_createproperty_proptype' => 'Тип:',
	'templates' => 'Шаблоны',
	'sf_templates_docu' => 'Следующие шаблоны существуют в вики.',
	'sf_templates_definescat' => 'определяет категорию:',
	'createtemplate' => 'Создать шаблон',
	'sf_createtemplate_namelabel' => 'Имя шаблона:',
	'sf_createtemplate_categorylabel' => 'Категория, определяемая шаблоном (необязательно):',
	'sf_createtemplate_templatefields' => 'Поля шаблона',
	'sf_createtemplate_fieldsdesc' => 'Для указания полей шаблона не требуется указывать их имена, просто введите индекс каждого поля (например, 1, 2, 3 и т. д.) вместо фактического имени.',
	'sf_createtemplate_fieldname' => 'Имя поля:',
	'sf_createtemplate_displaylabel' => 'Отображаемая надпись:',
	'sf_createtemplate_semanticproperty' => 'Семантическое свойство:',
	'sf_createtemplate_fieldislist' => 'Это поле может содержать список разделённых запятыми значений',
	'sf_createtemplate_aggregation' => 'Соединение',
	'sf_createtemplate_aggregationdesc' => 'Чтобы вывести на любую страницу, использующую этот шаблон, все страницы, у которых заданное свойство указывает на эту страницу, укажите соответствующее свойство ниже:',
	'sf_createtemplate_aggregationlabel' => 'Заголовок списка:',
	'sf_createtemplate_outputformat' => 'Формат вывода:',
	'sf_createtemplate_standardformat' => 'обычный',
	'sf_createtemplate_infoboxformat' => 'информационная панель справа',
	'sf_createtemplate_addfield' => 'Добавить поле',
	'sf_createtemplate_deletefield' => 'Удалить',
	'sf_createtemplate_addtemplatebeforesave' => 'Вы должны добавить на эту форму по крайней мере один шаблон, чтобы её было можно сохранить.',
	'forms' => 'Формы',
	'sf_forms_docu' => 'В вики существуют следующие формы.',
	'createform' => 'Создать форму',
	'sf_createform_nameinput' => 'Название формы',
	'sf_createform_nameinputdesc' => '(конвенция названия формы после заполнения основного шаблона):',
	'sf_createform_template' => 'Шаблон:',
	'sf_createform_templatelabelinput' => 'Обозначение шаблона (необязательно):',
	'sf_createform_allowmultiple' => 'Разрешить несколько (или ноль) экземпляров этого шаблона на создаваемой странице',
	'sf_createform_field' => 'Поле:',
	'sf_createform_fieldprop' => 'Это поле определяет свойство $1 типа $2.',
	'sf_createform_fieldproplist' => 'Это поле определяет список элементов, имеющих свойство $1 типа $2.',
	'sf_createform_fieldpropunknowntype' => 'Это поле определяет свойство $1 неуказанного типа.',
	'sf_createform_inputtype' => 'Входной тип:',
	'sf_createform_inputtypedefault' => '(по умолчанию)',
	'sf_createform_formlabel' => 'Обозначение формы:',
	'sf_createform_hidden' => 'скрытая',
	'sf_createform_restricted' => 'ограниченная (править могут только администраторы)',
	'sf_createform_mandatory' => 'обязательная',
	'sf_createform_removetemplate' => 'Удалить шаблон',
	'sf_createform_addtemplate' => 'Добавить шаблон:',
	'sf_createform_beforetemplate' => 'Перед шаблоном:',
	'sf_createform_atend' => 'В конце',
	'sf_createform_add' => 'Добавить',
	'sf_createform_choosefield' => 'Выберите поле для добавления',
	'createcategory' => 'Создать категорию',
	'sf_createcategory_name' => 'Название категории:',
	'sf_createcategory_defaultform' => 'Форма по умолчанию:',
	'sf_createcategory_makesubcategory' => 'Сделать это подкатегорией другой категории (необязательно):',
	'createclass' => 'Создать класс',
	'sf_createclass_docu' => 'Введите здесь все данные для создание свойств, шаблона, формы и категории для одного класса. Для более подробных настроек, используйте страницу $1.',
	'sf_createclass_allowedvalues' => 'Допустимые значения',
	'sf_createclass_listofvalues' => 'Список значений',
	'sf_createclass_leavefieldblank' => 'Если название поля совпадает с названием свойства, вы можете оставить его пустым.',
	'sf_createclass_missingvalues' => 'Не все требуемые поля были заполнены.',
	'sf_createclass_success' => 'Будут созданы настройки, шаблоны, формы и категории.',
	'formstart' => 'Добавить страницу с формой',
	'sf_formstart_badform' => 'Ошибка. Форма не найдена на $1',
	'sf_formstart_badtitle' => 'Ошибка. «$1» — недопустимое название страницы.',
	'sf_formstart_docu' => 'Введите здесь название страницы, которую нужно править с помощью формы «$1». Если страница уже существует, вы будите направлены на форму редактирования страницы, иначе вы будите направлены на форму добавления страницы.',
	'sf_formstart_noform_docu' => 'Введите здесь название страницы и выберите форму, с помощью которой ей следует редактировать. Если эта страница уже существует, вы будите направлены на форму редактирования страницы, иначе вы будите направлены на форму добавления страницы.',
	'sf_formstart_createoredit' => 'Создать или править',
	'formedit' => 'Править с помощью формы',
	'sf_formedit_createtitle' => 'Создание $1: $2',
	'sf_formedit_badurl' => 'Это страница для редактирования с помощью формы. Вы должны указать имя формы и целевую страницу в URL;
выглядеть это должно на подобии «Special:FormEdit?form=&lt;form name&gt;&target=&lt;target page&gt;» или «Special:FormEdit/&lt;form name&gt;/&lt;target page&gt;».',
	'sf_formedit_altforms' => 'Вы можете вместо этого добавить эту страницу с помощью одной из следующих форм:',
	'sf_formedit_altformsonly' => 'Пожалуйста, выберите одну из следующих форм для добавления этой страницы:',
	'sf_formcreate' => 'Создать с формой',
	'sf_viewform' => 'Смотреть форму',
	'sf_editsource' => 'Править исходники',
	'sf_formedit_edittitle' => 'Редактирование $1: $2',
	'sf_formedit_morethanoneform' => 'Внимание. Для этой страницы была определена больше чем одна форма по умолчанию.',
	'sf_formedit_formwarning' => 'Предупреждение. Эта страница <a href="$1">уже существует</a>, но не использует эту форму.',
	'sf_formedit_remove' => 'Удалить',
	'sf_formedit_addanother' => 'Добавить ещё',
	'sf_formedit_none' => 'Ничего',
	'runquery' => 'Запустить запрос',
	'sf_runquery_badurl' => 'Вы должны определить имя формы в URL;
URL должен выглядеть так: «Special:RunQuery/&lt;form name&gt;».',
	'sf_runquery_title' => 'Запустить запрос: $1',
	'sf_runquery_additionalquery' => 'Дополнительные запросы',
	'sf_formerrors_header' => 'Были обнаружены ошибки в вашей форме ввода, см. ниже',
	'sf_blank_error' => 'не может быть пустым',
	'sf_bad_url_error' => 'должно иметь правильный URL-формат, начинаться с «http»',
	'sf_bad_email_error' => 'должно содержать адрес почты соответствующего формата',
	'sf_bad_number_error' => 'должно быть числом',
	'sf_bad_integer_error' => 'должно быть целым числом',
	'sf_bad_date_error' => 'должно быть датой',
	'uploadwindow' => 'Окно загрузки',
	'sf_deletionlog' => 'Журнал удалений',
	'sf_property_isproperty' => 'Это свойство типа $1.',
	'sf_property_linkstoform' => 'Ссылки на страницы, использующие форму $1.',
	'sf_property_allowedvals' => 'Для данного свойства {{PLURAL:$1|допускается следующее значение|допускаются следующие значения}}:',
	'sf_template_docu' => 'Это шаблон «$1». Он должен вызываться следующим образом:',
	'sf_template_docufooter' => 'Начните редактировать эту страницу, чтобы увидеть текст шаблона.',
	'sf_form_docu' => 'Это форма «$1».
Чтобы создать страницу с помощью этой формы, введите ниже название страницы;
если страница с таким именем уже существует, вы будите направлены на форму редактирования этой страницы.',
	'sf_form_freetextlabel' => 'Текст',
	'sf_category_hasdefaultform' => 'Эта категория использует форму $1.',
	'sf_category_desc' => 'Это категория $1.',
	'sf_blank_namespace' => 'Основное',
	'right-viewedittab' => 'вкладка «править» для страниц, редактируемых формой',
	'right-editrestrictedfields' => 'правка защищённых полей формы',
);

/** Sanskrit (संस्कृत)
 * @author Hemant wikikosh1
 * @author Mahitgar
 */
$messages['sa'] = array(
	'sf_blank_namespace' => 'प्रमुखम्',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'semanticforms-desc' => 'Formuláre na pridávanie a úpravu sémantických údajov',
	'specialpages-group-sf_group' => 'Sémantické formuláre',
	'createproperty' => 'Vytvoriť vlastnosť',
	'sf_createproperty_linktoform' => 'Táto vlastnosť bude odkazovať na stránky, ktoré používajú formulár:',
	'sf_createproperty_allowedvalsinput' => 'Ak chcete povoliť tejto vlastnosti nadobúdať iba určité hodnoty, zadajte zoznam povolených hodnôt oddelených čiarkami (ak hodnota obsahuje čiarku, nahraďte ju „\\,“)',
	'sf_createproperty_propname' => 'Názov vlastnosti:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Šablóny',
	'sf_templates_docu' => 'Na wiki existujú nasledujúce šablóny.',
	'sf_templates_definescat' => 'definuje kategóriu:',
	'createtemplate' => 'Vytvoriť šablónu',
	'sf_createtemplate_namelabel' => 'Názov šablóny:',
	'sf_createtemplate_categorylabel' => 'Kategória definovaná šablónou (nepovinné):',
	'sf_createtemplate_templatefields' => 'Polia šablóny',
	'sf_createtemplate_fieldsdesc' => 'Aby už polia tejto šablóny nevyžadovali názvy polí, jednoducho zadajte ako názov index každého poľa (napr. 1, 2, 3 atď.) namiesto skutočného názvu.',
	'sf_createtemplate_fieldname' => 'Názov poľa:',
	'sf_createtemplate_displaylabel' => 'Zobrazovať označenie:',
	'sf_createtemplate_semanticproperty' => 'Sémantická vlastnosť:',
	'sf_createtemplate_fieldislist' => 'Toto pole môže uchovávať zoznam hodnôt oddelených čiarkami',
	'sf_createtemplate_aggregation' => 'Agregácia',
	'sf_createtemplate_aggregationdesc' => 'Na vypísanie všetkých stránok, ktorých určená vlastnosť odkazuje na danú stránku (na akejkoľvek stránke používajúcej túto šablónu), zadajte príslušnú vlastnosť:',
	'sf_createtemplate_aggregationlabel' => 'Názov zoznamu:',
	'sf_createtemplate_outputformat' => 'Výstupný formát:',
	'sf_createtemplate_standardformat' => 'Štandardný',
	'sf_createtemplate_infoboxformat' => 'Infobox na pravej strane',
	'sf_createtemplate_addfield' => 'Pridať pole',
	'sf_createtemplate_deletefield' => 'Zmazať',
	'sf_createtemplate_addtemplatebeforesave' => 'Predtým, než budete môcť uložiť tento formulár mu musíte pridať aspoň jednu šablónu.',
	'forms' => 'Formuláre',
	'sf_forms_docu' => 'Na wiki existujú nasledové formuláre.',
	'createform' => 'Vytvoriť formulár',
	'sf_createform_nameinput' => 'Názov formulára',
	'sf_createform_nameinputdesc' => '(je zvykom pomenovať formulár podľa hlavnej šablóny, ktorú plní):',
	'sf_createform_template' => 'Šablóna:',
	'sf_createform_templatelabelinput' => 'Označenie šablóny (nepovinné):',
	'sf_createform_allowmultiple' => 'Povoliť vo vytvorenej stránke viacero (alebo nula) inštancií tejto šablóny',
	'sf_createform_field' => 'Pole:',
	'sf_createform_fieldprop' => 'Toto pole definuje vlastnosť $1 typu $2.',
	'sf_createform_fieldproplist' => 'Toto pole definuje zoznam prvkov, ktoré majú vlastnosť $1 typu $2.',
	'sf_createform_fieldpropunknowntype' => 'Toto pole definuje vlastnosť $1 neuvedeného typu.',
	'sf_createform_inputtype' => 'Typ vstupu:',
	'sf_createform_inputtypedefault' => '(štandard)',
	'sf_createform_formlabel' => 'Označenie formulára:',
	'sf_createform_hidden' => 'Skrytý',
	'sf_createform_restricted' => 'Obmedzené (môžu meniť iba správcovia)',
	'sf_createform_mandatory' => 'Povinné',
	'sf_createform_removetemplate' => 'Odstrániť šablónu',
	'sf_createform_addtemplate' => 'Pridať šablónu:',
	'sf_createform_beforetemplate' => 'Pred šablónou:',
	'sf_createform_atend' => 'Na konci',
	'sf_createform_add' => 'Pridať',
	'sf_createform_choosefield' => 'Zvoľte, ktoré pole pridať',
	'createcategory' => 'Vytvoriť kategóriu',
	'sf_createcategory_name' => 'Názov kategórie:',
	'sf_createcategory_defaultform' => 'Štandardný formulár:',
	'sf_createcategory_makesubcategory' => 'Táto kategória je podkategóriou inej kategórie (nepovinné):',
	'createclass' => 'Vytvoriť triedu',
	'sf_createclass_docu' => 'Sem zadajte všetky údaje na vytvorenie vlastností, šablóny, formulára a kategórie jednej triedy. Ak chcete zadať ďalšie voľby, použite stránku $1.',
	'sf_createclass_allowedvalues' => 'Povolené hodnoty',
	'sf_createclass_listofvalues' => 'Zoznam hodnôt',
	'sf_createclass_leavefieldblank' => 'Ak je názov poľa zhodný s názvom vlastnosti, môžete ho ponechať prázdny.',
	'sf_createclass_missingvalues' => 'Neboli vyplnené všetky požadované polia.',
	'sf_createclass_success' => 'Vytvoria sa vlastnosti, šablóna, formulár a kategória.',
	'formstart' => 'Pridať stránku s formulárom',
	'sf_formstart_badform' => 'Chyba: na $1 nebola nájdená žiadna stránka formulára',
	'sf_formstart_badtitle' => 'Chyba: „$1“ nie je platný názov stránky.',
	'sf_formstart_docu' => 'Sem zadajte názov stránky, ktorá sa má upravovať formulárom „$1“. Ak táto stránka už existuje, budete presmerovaný na formulár pre úpravu tejto stránky. Inak budete presmerovaný na formulár pre pridanie tejto stránky.',
	'sf_formstart_noform_docu' => 'Sem zadajte názov stránky a vyberte, ktorým formulárom sa má upravovať. Ak táto stránka už existuje, budete presmerovaný na formulár pre úpravu tejto stránky. Inak budete presmerovaný na formulár pre pridanie tejto stránky.',
	'sf_formstart_createoredit' => 'Pridať alebo upraviť',
	'formedit' => 'Upraviť pomocou formulára',
	'sf_formedit_createtitle' => 'Pridať $1: $2',
	'sf_formedit_badurl' => 'Toto je stránka na pridávanie údajov. Musíte v URL uviesť názov formulára aj cieľovú stránku. Mala by byť v tvare „Special:FormEdit?form=&lt;názov formulára&gt;&target=&lt;cieľová stránka&gt;“ alebo „Special:FormEdit/&lt;názov formulára&gt;/&lt;cieľová stránka&gt;“.',
	'sf_formedit_altforms' => 'Namiesto toho môžete pridať túto stránku jedným z nasledovných formulárov:',
	'sf_formedit_altformsonly' => 'Prosím, vyberte jeden z nasledovných formulárov, ktorým sa pridá táto stránka.',
	'sf_formcreate' => 'Vytvoriť s formulárom',
	'sf_viewform' => 'Zobraziť formulár',
	'sf_editsource' => 'Upraviť zdroj',
	'sf_formedit_edittitle' => 'Upraviť $1: $2',
	'sf_formedit_morethanoneform' => 'Upozornenie: Táto stránka má definovaný viac ako jeden štandardný formulár.',
	'sf_formedit_formwarning' => 'Upozornenie: Táto stránka <a href="$1">už existuje</a>, ale nepoužíva tento formulár.',
	'sf_formedit_remove' => 'Odstrániť',
	'sf_formedit_addanother' => 'Pridať ďalšiu',
	'sf_formedit_none' => 'Žiadne',
	'runquery' => 'Spustiť požiadavku',
	'sf_runquery_badurl' => 'Musíte v URL uviesť názov formulára;
URL by malo byť v tvare „Special:RunQuery/&lt;názov formulára&gt;“',
	'sf_runquery_title' => 'Spustiť požiadavku: $1',
	'sf_runquery_additionalquery' => 'Ďalšia požiadavka',
	'sf_formerrors_header' => 'Zaslanie formulára, ktorý ste vyplnili, spôsobilo nasledovné chyby:',
	'sf_blank_error' => 'nemôže byť nevyplnené',
	'sf_bad_url_error' => 'musí mať správny formát URL, začínajúci „http“',
	'sf_bad_email_error' => 'musí mať správny formát emailovej adresy',
	'sf_bad_number_error' => 'musí byť platné číslo',
	'sf_bad_integer_error' => 'musí byť platné celé číslo',
	'sf_bad_date_error' => 'musí byť platný dátum',
	'uploadwindow' => 'Okno nahrávania',
	'sf_deletionlog' => 'Záznam mazaní',
	'sf_property_isproperty' => 'Toto je vlastnosť typu $1.',
	'sf_property_linkstoform' => 'Odkazuje na stránky používajúce formulár $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Povolená hodnota|Povolené hodnoty}} tejto vlastnosti {{PLURAL:$1|je|sú}}:',
	'sf_template_docu' => 'Toto je šablóna „$1“. Mala by byť volaná v nasledovnom tvare:',
	'sf_template_docufooter' => 'Text šablóny uvidíte, keď začnete upravovať stránku.',
	'sf_form_docu' => 'Toto je formulár „$1“. Novú stránku pomocou tohto formulára pridáte zadaním názvu stránky dolu; ak stránka s takým názvom už existuje, budete presmerovaný na formulár pre úpravu tejto stránky.',
	'sf_form_freetextlabel' => 'Voľný text',
	'sf_category_hasdefaultform' => 'Táto kategória používa formulár $1.',
	'sf_category_desc' => 'Toto je kategória $1.',
	'sf_blank_namespace' => 'Hlavná',
	'right-viewedittab' => 'Zobraziť zíložku „Upraviť“ na stránkach, ktoré možno upraviť pomocou formulára',
	'right-editrestrictedfields' => 'Upraviť polia formulára s obmedzeným prístupom',
);

/** Serbian Cyrillic ekavian (Српски (ћирилица))
 * @author Sasa Stefanovic
 * @author Михајло Анђелковић
 */
$messages['sr-ec'] = array(
	'specialpages-group-sf_group' => 'Семантичке Форме',
	'createproperty' => 'Направи особину',
	'sf_createproperty_linktoform' => 'Ова особина ће повезивати на стране, које користе форму:',
	'sf_createproperty_allowedvalsinput' => 'Ако желите да овој особини буде дозвољено да има само одређене вредности, унесите списак дозвољених вредност, одвојених зарезима (ако вредност садржи зарез, пишите га као „\\,“):',
	'sf_createproperty_propname' => 'Име особине:',
	'sf_createproperty_proptype' => 'Тип:',
	'templates' => 'Шаблони',
	'sf_templates_docu' => 'Следећи шаблони постоје у Викију.',
	'sf_templates_definescat' => 'дефинише категорију:',
	'createtemplate' => 'Направи шаблон',
	'sf_createtemplate_namelabel' => 'Име шаблона:',
	'sf_createtemplate_categorylabel' => 'Категорија дефинисана шаблоном (опционо):',
	'sf_createtemplate_templatefields' => 'Поља шаблона',
	'sf_createtemplate_fieldname' => 'Име поља:',
	'sf_createtemplate_displaylabel' => 'Прикажи лабелу:',
	'sf_createtemplate_semanticproperty' => 'Семантичка особина:',
	'sf_createtemplate_fieldislist' => 'Ово поље може да садржи списак вредности, одвојених зарезима',
	'sf_createtemplate_aggregation' => 'Агрегација',
	'sf_createtemplate_aggregationlabel' => 'Наслов листе:',
	'sf_createtemplate_outputformat' => 'Излазни формат:',
	'sf_createtemplate_standardformat' => 'Стандард',
	'sf_createtemplate_addfield' => 'Додај поље',
	'sf_createtemplate_deletefield' => 'Обриши',
	'forms' => 'Форме',
	'sf_forms_docu' => 'Следеће форме постоје на Викију.',
	'createform' => 'Направи форму',
	'sf_createform_nameinput' => 'Име форме',
	'sf_createform_template' => 'Шаблон:',
	'sf_createform_field' => 'Поље:',
	'sf_createform_fieldprop' => 'Ово поље дефинише особину $1, типа $2.',
	'sf_createform_inputtypedefault' => '(подразумевано)',
	'sf_createform_formlabel' => 'Из лабеле:',
	'sf_createform_hidden' => 'Сакривено',
	'sf_createform_removetemplate' => 'Обриши шаблон',
	'sf_createform_addtemplate' => 'Додај шаблон:',
	'sf_createform_beforetemplate' => 'Пре шаблона:',
	'sf_createform_atend' => 'На крају',
	'sf_createform_add' => 'Додај',
	'sf_createform_choosefield' => 'Изабери поље за додавање',
	'createcategory' => 'Направи категорију',
	'sf_createcategory_name' => 'Име категорије:',
	'sf_createcategory_defaultform' => 'Подразумевана форма:',
	'createclass' => 'Направи класу',
	'sf_createclass_allowedvalues' => 'Дозвољене вредности',
	'sf_createclass_listofvalues' => 'Списак вредности',
	'formstart' => 'Почетак форме',
	'sf_formstart_createoredit' => 'Направи или измени',
	'formedit' => 'Измени формом',
	'sf_formedit_createtitle' => 'Направи $1: $2',
	'sf_editsource' => 'Измени сорс',
	'sf_formedit_edittitle' => 'Измени $1: $2',
	'sf_formedit_remove' => 'Уклони',
	'sf_formedit_none' => 'Нема',
	'sf_bad_number_error' => 'мора бити исправан број',
	'sf_bad_integer_error' => 'мора бити исправан цели број',
	'sf_bad_date_error' => 'мора бити исправан датум',
	'uploadwindow' => 'Прозор за слање',
	'sf_deletionlog' => 'Историја брисања',
);

/** Serbian Latin ekavian (Srpski (latinica))
 * @author Michaello
 */
$messages['sr-el'] = array(
	'specialpages-group-sf_group' => 'Semantičke Forme',
	'createproperty' => 'Napravi osobinu',
	'sf_createproperty_linktoform' => 'Ova osobina će povezivati na strane, koje koriste formu:',
	'sf_createproperty_allowedvalsinput' => 'Ako želite da ovoj osobini bude dozvoljeno da ima samo određene vrednosti, unesite spisak dozvoljenih vrednost, odvojenih zarezima (ako vrednost sadrži zarez, pišite ga kao „\\,“):',
	'sf_createproperty_propname' => 'Ime osobine:',
	'sf_createproperty_proptype' => 'Tip:',
	'templates' => 'Šabloni',
	'sf_templates_docu' => 'Sledeći šabloni postoje u Vikiju.',
	'sf_templates_definescat' => 'definiše kategoriju:',
	'createtemplate' => 'Napravi šablon',
	'sf_createtemplate_namelabel' => 'Ime šablona:',
	'sf_createtemplate_categorylabel' => 'Kategorija definisana šablonom (opciono):',
	'sf_createtemplate_templatefields' => 'Polja šablona',
	'sf_createtemplate_fieldname' => 'Ime polja:',
	'sf_createtemplate_displaylabel' => 'Prikaži labelu:',
	'sf_createtemplate_semanticproperty' => 'Semantička osobina:',
	'sf_createtemplate_fieldislist' => 'Ovo polje može da sadrži spisak vrednosti, odvojenih zarezima',
	'sf_createtemplate_aggregation' => 'Agregacija',
	'sf_createtemplate_aggregationlabel' => 'Naslov liste:',
	'sf_createtemplate_outputformat' => 'Izlazni format:',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_addfield' => 'Dodaj polje',
	'sf_createtemplate_deletefield' => 'Obriši',
	'forms' => 'Forme',
	'sf_forms_docu' => 'Sledeće forme postoje na Vikiju.',
	'createform' => 'Napravi formu',
	'sf_createform_nameinput' => 'Ime forme',
	'sf_createform_template' => 'Šablon:',
	'sf_createform_field' => 'Polje:',
	'sf_createform_fieldprop' => 'Ovo polje definiše osobinu $1, tipa $2.',
	'sf_createform_inputtypedefault' => '(podrazumevano)',
	'sf_createform_formlabel' => 'Iz labele:',
	'sf_createform_hidden' => 'Sakriveno',
	'sf_createform_removetemplate' => 'Obriši šablon',
	'sf_createform_addtemplate' => 'Dodaj šablon:',
	'sf_createform_beforetemplate' => 'Pre šablona:',
	'sf_createform_atend' => 'Na kraju',
	'sf_createform_add' => 'Dodaj',
	'sf_createform_choosefield' => 'Izaberi polje za dodavanje',
	'createcategory' => 'Napravi kategoriju',
	'sf_createcategory_name' => 'Ime kategorije:',
	'sf_createcategory_defaultform' => 'Podrazumevana forma:',
	'createclass' => 'Napravi klasu',
	'sf_createclass_allowedvalues' => 'Dozvoljene vrednosti',
	'sf_editsource' => 'Izmeni sors',
	'sf_formedit_edittitle' => 'Izmeni $1: $2',
	'sf_formedit_remove' => 'Ukloni',
	'sf_formedit_none' => 'Nema',
	'sf_bad_number_error' => 'mora biti ispravan broj',
	'sf_bad_integer_error' => 'mora biti ispravan celi broj',
	'sf_bad_date_error' => 'mora biti ispravan datum',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'createproperty' => 'Moak ne Oainskup',
	'sf_createproperty_allowedvalsinput' => 'Wan du foar dit Attribut bloot bestimde Wäide muugelk moakje wolt, reek do dan as kommatrände Lieste ien (wan n Wäid n Komma änthaalt, ärsät dit truch "\\," sunner Anfierengen):',
	'sf_createproperty_propname' => 'Attributnoome:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Foarloage',
	'sf_templates_docu' => 'Do foulgjende Foarloagen existierje in {{SITENAME}}.',
	'sf_templates_definescat' => 'definiert Kategorie:',
	'createtemplate' => 'Moak ne Foarloage',
	'sf_createtemplate_namelabel' => 'Foarloagenoome:',
	'sf_createtemplate_categorylabel' => 'Truch Foarloage definierde Kategorie (optionoal):',
	'sf_createtemplate_templatefields' => 'Foarloagenfäilde',
	'sf_createtemplate_fieldsdesc' => 'Wan n Fäild fon ne Foarloage naan Fäildnoome moor bruukt, reek eenfach insteede fon n wuudelken Noome ju Indexnummer fon dät Fäild as Noome ien (t.B. 1, 2, 3 usw.).',
	'sf_createtemplate_fieldname' => 'Fäildnoome:',
	'sf_createtemplate_displaylabel' => 'Antouwiesende Fäildbeteekenge:',
	'sf_createtemplate_semanticproperty' => 'Semantiske Oainskup:',
	'sf_createtemplate_fieldislist' => 'Dit Fäild kon ne Lieste fon Wäide änthoolde, do der truch Kommata tränd wäide.',
	'sf_createtemplate_addfield' => 'Föich Fäild bietou',
	'sf_createtemplate_deletefield' => 'Läskje',
	'sf_createtemplate_addtemplatebeforesave' => 'Du moast mindestens ne Foarloage an dit Formular bietouföigje, eer du dät spiekerje koast.',
	'forms' => 'Formulare',
	'sf_forms_docu' => 'Do foulgjende Formulare existierje in {{SITENAME}}:',
	'createform' => 'Moak n Formular',
	'sf_createform_nameinput' => 'Formularnoome',
	'sf_createform_template' => 'Foarloage:',
	'sf_createform_templatelabelinput' => 'Foarloagebeteekenge (optionoal)',
	'sf_createform_allowmultiple' => 'Ferlööwje moorere (of nul) Instanzen fon disse Foarloage in ju moakede Siede',
	'sf_createform_field' => 'Fäild:',
	'sf_createform_fieldprop' => 'Dit Fäild definiert ju Oainskup $1 fon dän Typ $2.',
	'sf_createform_fieldproplist' => 'Dit Fäild definiert ne Lieste fon Elemente, do ju Oainskup $1 fon dän Typ $2 hääbe.',
	'sf_createform_fieldpropunknowntype' => 'Dit Fäild definiert ju Oainskup $1 mäd n nit-spezifizierten Typ.',
	'sf_createform_inputtype' => 'Reek dän Typ ien:',
	'sf_createform_inputtypedefault' => '(Standoardwäid)',
	'sf_createform_formlabel' => 'Formularbeteekenge:',
	'sf_createform_hidden' => 'Ferstat',
	'sf_createform_restricted' => 'Speerd (bloot Sysops konnen annerje)',
	'sf_createform_mandatory' => 'Plichtfäild',
	'sf_createform_removetemplate' => 'Foarloage wächhoalje',
	'sf_createform_addtemplate' => 'Föich Foarloage bietou',
	'sf_createform_beforetemplate' => 'foar Foarloage',
	'sf_createform_atend' => 'ap e Eend',
	'sf_createform_add' => 'Föich bietou',
	'sf_createform_choosefield' => 'Wääl n Fäild uut, dät du bietouföigje wolt.',
	'createcategory' => 'Moak ne Kategorie',
	'sf_createcategory_name' => 'Noome fon ju Kategorie:',
	'sf_createcategory_defaultform' => 'Standoardformular:',
	'sf_createcategory_makesubcategory' => 'Moak disse Kategorie tou ne Subkategorie fon n uur Kategorie (optional):',
	'formstart' => 'Föich Siede bietou',
	'sf_formstart_badform' => 'Failer: der wuude neen Siede fuunen bie $1',
	'sf_formstart_docu' => "Reek in dit Textfäild dän Noome fon ju Siede ien, ju der mäd Formular '$1' beoarbaided wäide schäl. Wan der al ne Siede mäd dissen Noome bestoant, wädst du tou n Formular fäärelat, wiermäd du disse Siede beoarbaidje koast. Uurs wädst du tou n Formular fäärelat, wiermäd du disse Siede moakje koast.",
	'sf_formstart_noform_docu' => 'Reek in dit Textfäild dän Noome fon ju Siede ien un wääl dät Formular, wiermäd ju Siede beoarbaided wäide schäl. Wan der al ne Siede mäd dissen Noome bestoant, wädst du tou n Formular fäärelät, wiermäd du disse Siede beoarbaidje koast. Uurs wädst du tou n Formular fäärelat, wiermäd du disse Siede moakje koast.',
	'sf_formstart_createoredit' => 'Bietouföigje of beoarbaidje',
	'formedit' => 'Beoarbaidje mäd Formular',
	'sf_formedit_createtitle' => 'Föich $1: $2 bietou',
	'sf_formedit_badurl' => "Dit is ju Siede toun Bietouföigjen fon Doaten. Du moast dän Noome fon n Formular UN ju tou beoarbaidjende Sielsiede in ju URL anreeke. Dät schuul uutsjo as 'Special:FormEdit?form=&lt;Formularnoome&gt;&target=&lt;Sielsiede&gt;' of 'Special:FormEdit/&lt;Formularnoome&gt;/&lt;Sielsiede&gt;'.",
	'sf_formedit_altforms' => 'Du koast insteede deerfon disse Siede mäd een fon do foulgjende Formulare moakje:',
	'sf_formedit_altformsonly' => 'Wääl een fon do foulgjende Formulare uut, uum disse Siede tou moakjen:',
	'sf_editsource' => 'Beoarbaidje Wältext',
	'sf_formedit_edittitle' => 'Beoarbaidje $1: $2',
	'sf_formedit_formwarning' => 'Woarschauenge: Disse Siede <a href="$1">bestoant al</a>, oawers ju benutset dit Formular nit.',
	'sf_formedit_remove' => 'Wächhoalje',
	'sf_formedit_addanother' => 'Wiedere bietouföigje',
	'sf_blank_error' => 'Duur nit loos weese!',
	'sf_bad_url_error' => "mout dät korrekte URL-Format hääbe, ounfangend mäd 'http://'",
	'sf_bad_email_error' => 'mout n gultich Email-Adresformoat hääbe',
	'sf_bad_number_error' => 'mout ne gultige Taal weese',
	'sf_bad_integer_error' => 'mout ne gultige Ganstaal weese',
	'sf_bad_date_error' => 'mout n gultich Doatum weese',
	'sf_property_isproperty' => 'Dit is ne Oainskup fon dän Typ $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Die muugelke Wäid foar disse Oainskup is|Do muugelke Wäide foar disse Oainskup sunt}}:',
	'sf_template_docu' => "Dit is ju Foarloage foar '$1'. Ju schuul in dät foulgjende Formoat apruupen wäide:",
	'sf_template_docufooter' => 'Beoarbaidje disse Siede, uum dän Foarloagentext tou sjoon.',
	'sf_form_docu' => "Reek in dit Textfäild dän Noome fon ju Siede ien, ju der mäd Formular '$1' moaked wäide schäl. Wan der al ne Siede mäd dissen Noome bestoant, wädst du tou n Formular fäärelat, wiermäd du disse Siede beoarbaidje koast.",
	'sf_form_freetextlabel' => 'Fräitext',
	'sf_category_hasdefaultform' => 'Disse Kategorie benutset dät Formular $1.',
	'sf_category_desc' => 'Dit is ju Kategorie $1.',
);

/** Swedish (Svenska)
 * @author Jon Harald Søby
 * @author Lejonel
 * @author M.M.S.
 * @author Najami
 * @author Per
 */
$messages['sv'] = array(
	'semanticforms-desc' => 'Formulär för att lägga till och redigera semantisk data',
	'specialpages-group-sf_group' => 'Semantiska formulär',
	'createproperty' => 'Skapa en egenskap',
	'sf_createproperty_linktoform' => 'Denna egenskap kommer länka till sidor som använder formuläret:',
	'sf_createproperty_allowedvalsinput' => 'Om du önskar att detta fält endast ska kunna ha vissa värden, lista tillåtna värden, separerade med komma (om ett värde innehåller komma, ersätt det med "\\,"):',
	'sf_createproperty_propname' => 'Egenskapsnamn:',
	'sf_createproperty_proptype' => 'Typ:',
	'templates' => 'Mallar',
	'sf_templates_docu' => 'Följande mallar finns på wikin.',
	'sf_templates_definescat' => 'definierar kategori:',
	'createtemplate' => 'Skapa en mall',
	'sf_createtemplate_namelabel' => 'Mallnamn:',
	'sf_createtemplate_categorylabel' => 'Kategori definierad av mall (valfri):',
	'sf_createtemplate_templatefields' => 'Mallfält',
	'sf_createtemplate_fieldsdesc' => 'För att fälten i denna mall inte längre ska kräva fältnamn, skriv in indexnummret till varje fält (alltså 1, 2, 3, osv.) som namn, i stället för ett riktigt namn.',
	'sf_createtemplate_fieldname' => 'Fältnamn:',
	'sf_createtemplate_displaylabel' => 'Visa etikett:',
	'sf_createtemplate_semanticproperty' => 'Semantisk egenskap:',
	'sf_createtemplate_fieldislist' => 'Detta fält kan innehålla en lista över värden, separarat med komma',
	'sf_createtemplate_aggregation' => 'Aggregering',
	'sf_createtemplate_aggregationdesc' => 'För att lista upp alla artiklar som har en viss egenskap som pekar till den sidan på alla sidor som använder mallen, ange denna egenskap nedan:',
	'sf_createtemplate_aggregationlabel' => 'Titel för lista:',
	'sf_createtemplate_outputformat' => 'Resultatsformat:',
	'sf_createtemplate_standardformat' => 'Standard',
	'sf_createtemplate_infoboxformat' => 'Infobox på höger sida',
	'sf_createtemplate_addfield' => 'Lägg till fält',
	'sf_createtemplate_deletefield' => 'Radera',
	'sf_createtemplate_addtemplatebeforesave' => 'Du måste lägga till minst en mall till detta formulär innan du kan spara det.',
	'forms' => 'Formulär',
	'sf_forms_docu' => 'Följande formulär finns på wikin.',
	'createform' => 'Skapa ett formulär',
	'sf_createform_nameinput' => 'Formulärnamn',
	'sf_createform_nameinputdesc' => '(standarden är att döpa formuläret efter mallen som det använder):',
	'sf_createform_template' => 'Mall:',
	'sf_createform_templatelabelinput' => 'Malletikett (valfritt):',
	'sf_createform_allowmultiple' => 'Tillåt flera (eller inga) instanser av denna mall på sidan som skapades',
	'sf_createform_field' => 'Fält:',
	'sf_createform_fieldprop' => 'Det här fältet definierar egenskapen $1, av typen $2.',
	'sf_createform_fieldproplist' => 'Det här fältet definierar en lista över element som har egenskapen $1, av typen $2.',
	'sf_createform_fieldpropunknowntype' => 'Det här fältet definierar egenskapen $1, av ospecifierad typ.',
	'sf_createform_inputtype' => 'Inskrivningstyp:',
	'sf_createform_inputtypedefault' => '(standard)',
	'sf_createform_formlabel' => 'Formuläretikett:',
	'sf_createform_hidden' => 'Dolda',
	'sf_createform_restricted' => 'Begränsat (endast administratörer kan ändra den)',
	'sf_createform_mandatory' => 'Obligatorisk',
	'sf_createform_removetemplate' => 'Ta bort mall',
	'sf_createform_addtemplate' => 'Lägg till mall:',
	'sf_createform_beforetemplate' => 'Före mall:',
	'sf_createform_atend' => 'Vid slutet',
	'sf_createform_add' => 'Lägg till',
	'sf_createform_choosefield' => 'Välj ett fält att lägga till',
	'createcategory' => 'Skapa en kategori',
	'sf_createcategory_name' => 'Kategorinamn:',
	'sf_createcategory_defaultform' => 'Standardformulär:',
	'sf_createcategory_makesubcategory' => 'Gör detta till en underkategori av en annan kategori (valfritt):',
	'createclass' => 'Skapa en klass',
	'sf_createclass_docu' => 'Skriv in all data här för att skapa egenskaper, mallar, scheman och kategorier för en klass. För fler alternativ använd sidan $1 istället.',
	'sf_createclass_allowedvalues' => 'Tillåtna värden',
	'sf_createclass_listofvalues' => 'Lista över värden',
	'sf_createclass_leavefieldblank' => 'Om fältnamnet är det samma som namnet på egenskapen så kan du lämna det blankt.',
	'sf_createclass_missingvalues' => 'Några obligatoriska fält blev inte ifyllda.',
	'sf_createclass_success' => 'Egenskaper, mallar, formulär och kategorier kommer att skapas.',
	'formstart' => 'Lägg till sida genom ett formulär',
	'sf_formstart_badform' => 'Fel: ingen formulärsida hittades på $1',
	'sf_formstart_badtitle' => 'Fel: "$1" är inte en giltig titel på en sida.',
	'sf_formstart_docu' => 'Skriv in namnet på sidan som ska redigeras med formuläret "$1" här.
Om sidan redan existerar kommer du skickas över till formulärt för redigering av den sidan.
Om du inte skickas över till formuläret för att skapa sidan.',
	'sf_formstart_noform_docu' => 'Skriv in namnet på sidan här, och välj vilket formulär du vill använda till att redigera den.
Om sidan redan existerar, kommer du skickas över till formuläret för redigering av den sidan.
Om du inte kommer skickas över till formuläret för att skapa sidan.',
	'sf_formstart_createoredit' => 'Lägg till eller redigera',
	'formedit' => 'Redigera med formulär',
	'sf_formedit_createtitle' => 'Lägg till $1: $2',
	'sf_formedit_badurl' => 'Det här är sidan för att lägga till data. Du måste ange både ett formulärnamn och en målsida i URL-en; 
det borde se ut som; "Special:FormEdit?form=&lt;´formulärnamn&gt;&target=&lt;målsida&gt;", eller som: "Special:FormEdit/&lt;form name&gt;/&lt;target page&gt;".',
	'sf_formedit_altforms' => 'Du kan istället skapa sidan genom att använda ett av följande formulär:',
	'sf_formedit_altformsonly' => 'Var god välj från en av de följande formulären för att lägga till den här sidan:',
	'sf_formcreate' => 'Skapa med formulär',
	'sf_viewform' => 'Visa formulär',
	'sf_editsource' => 'Redigera källa',
	'sf_formedit_edittitle' => 'Redigera $1: $2',
	'sf_formedit_formwarning' => 'Varning: Den här sidan <a href="$1">finns redan</a>, men använder inte det här formuläret.',
	'sf_formedit_remove' => 'Radera',
	'sf_formedit_addanother' => 'Lägg till en annan',
	'sf_formedit_none' => 'Ingen',
	'runquery' => 'Kör sökning',
	'sf_runquery_title' => 'Kör sökning: $1',
	'sf_runquery_additionalquery' => 'Ytterligare fråga',
	'sf_formerrors_header' => 'Det fanns fel i ditt formulär; se nedan',
	'sf_blank_error' => 'kan inte vara tom',
	'sf_bad_url_error' => 'måste ha korrekt URL-format, inkluderande "http"',
	'sf_bad_email_error' => 'måste ha ett giltigt format på e-postadressen',
	'sf_bad_number_error' => 'måste vara ett giltigt tal',
	'sf_bad_integer_error' => 'måste vara ett giltigt heltal',
	'sf_bad_date_error' => 'måste vara ett giltigt datum',
	'uploadwindow' => 'Uppladdningsfönster',
	'sf_deletionlog' => 'Raderingslogg',
	'sf_property_isproperty' => 'Det här är en egenskap av typen $1.',
	'sf_property_linkstoform' => 'Det länkar till sidor som använder formuläret $1',
	'sf_property_allowedvals' => 'De tillåtna värdena för den här egenskapen är:',
	'sf_template_docu' => 'Det här är mallen "$1".
Det borde namnges i följande format:',
	'sf_template_docufooter' => 'Redigera sidan för att se mall texten.',
	'sf_form_docu' => 'Det här är formuläret "$1".
För att lägga till en sidan med det här formuläret, skriv in namnet på sidan nedan;
om en sida med det namnet redan finns kommer du skickas över till ett formulär för redigering av den sidan.',
	'sf_form_freetextlabel' => 'Fritext',
	'sf_category_hasdefaultform' => 'Den här kategorin använder formuläret $1.',
	'sf_category_desc' => 'Detta är $1 kategorin.',
	'sf_blank_namespace' => 'Huvud',
);

/** Silesian (Ślůnski)
 * @author Herr Kriss
 */
$messages['szl'] = array(
	'sf_createproperty_propname' => 'Mjano:',
	'sf_createform_add' => 'Dodej',
	'sf_createcategory_name' => 'Mjano:',
);

/** Telugu (తెలుగు)
 * @author Veeven
 */
$messages['te'] = array(
	'sf_createproperty_propname' => 'లక్షణపు పేరు:',
	'sf_createproperty_proptype' => 'రకం:',
	'templates' => 'మూసలు',
	'sf_templates_definescat' => 'వర్గాన్ని నిర్వచిస్తుంది:',
	'createtemplate' => 'మూసని సృష్టించండి',
	'sf_createtemplate_namelabel' => 'మూస పేరు:',
	'sf_createtemplate_fieldislist' => 'ఈ ఖాళీలో కామాలతో వేరుపరచి బహుళ విలువలని ఇవ్వవచ్చు',
	'sf_createtemplate_aggregation' => 'సంకలనం',
	'sf_createtemplate_aggregationlabel' => 'జాబితాకి శీర్షిక:',
	'sf_createtemplate_standardformat' => 'ప్రామాణిక',
	'sf_createtemplate_infoboxformat' => 'కుడివైపు సమాచారపెట్టె',
	'sf_createtemplate_deletefield' => 'తొలగించు',
	'sf_createform_nameinput' => 'ఫారం పేరు',
	'sf_createform_template' => 'మూస:',
	'sf_createform_templatelabelinput' => 'మూస పేరు (ఐచ్చికం):',
	'sf_createform_inputtypedefault' => '(అప్రమేయం)',
	'sf_createform_hidden' => 'దాచినది',
	'sf_createform_mandatory' => 'తప్పనిసరి',
	'sf_createform_removetemplate' => 'మూసని తొలగించండి',
	'sf_createform_addtemplate' => 'మూసని చేర్చండి:',
	'sf_createform_beforetemplate' => 'మూసకి ముందు:',
	'sf_createform_atend' => 'చివరన',
	'sf_createform_add' => 'చేర్చు',
	'createcategory' => 'వర్గాన్ని సృష్టించండి',
	'sf_createcategory_name' => 'వర్గపు పేరు:',
	'sf_createcategory_makesubcategory' => 'దీన్ని మరో వర్గానికి ఉపవర్గం చెయ్యి (ఐచ్ఛికం):',
	'sf_createclass_allowedvalues' => 'అనుమతించే విలువలు',
	'sf_createclass_listofvalues' => 'విలువల యొక్క జాబితా',
	'formstart' => 'ఫారంతో పేజీని చేర్చండి',
	'sf_formstart_createoredit' => 'చేర్చు లేదా మార్చు',
	'sf_formedit_formwarning' => 'హెచ్చరిక: ఈ పేజీ <a href="$1">ఇప్పటికే ఉంది</a>, కానీ దానిలో ఈ ఫారం లేదు.',
	'sf_formedit_remove' => 'తొలగించు',
	'sf_formedit_addanother' => 'మరోటి చేర్చండి',
	'sf_formedit_none' => 'ఏమీలేదు',
	'sf_blank_error' => 'ఖాళీగా ఉండకూడదు',
	'sf_bad_number_error' => 'ఖచ్చితంగా ఓ సంఖ్య అయివుండాలి',
	'sf_bad_integer_error' => 'సరైన పూర్ణసంఖ్య అయివుండాలి',
	'sf_bad_date_error' => 'సరైన తేదీ అయివుండాలి',
	'sf_deletionlog' => 'తొలగింపు చిట్టా',
	'sf_form_freetextlabel' => 'స్వేచ్ఛా పాఠ్యం',
	'sf_category_hasdefaultform' => 'ఈ వర్గం $1 అనే ఫారాన్ని వాడుతుంది.',
	'sf_category_desc' => 'ఇది $1 అనే వర్గం.',
	'sf_blank_namespace' => 'ప్రధాన',
);

/** Tetum (Tetun)
 * @author MF-Warburg
 */
$messages['tet'] = array(
	'sf_createproperty_propname' => 'Naran:',
	'sf_createtemplate_deletefield' => 'Halakon',
	'sf_createform_add' => 'Tau tan',
	'sf_createcategory_name' => 'Naran kategoria nian:',
);

/** Tajik (Cyrillic) (Тоҷикӣ (Cyrillic))
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'createproperty' => 'Вижагӣ бисозед',
	'sf_createproperty_allowedvalsinput' => 'Агар мехоҳед ин вуруди танҳои миқдорҳои мушаххаси миҷоз дошта бошад, феҳристи миқдорҳои миҷозро ворид кунед ва онҳоро бо вергул ҷудо созед (агар миқдор вергул дошта бошад, онро бо "\\," иваз кунед):',
	'sf_createproperty_propname' => 'Ном:',
	'sf_createproperty_proptype' => 'Навъ:',
	'templates' => 'Шаблонҳо',
	'sf_templates_docu' => 'Шаблонҳои зер дар ин вики вуҷуд доранд.',
	'sf_templates_definescat' => 'таъйиди гурӯҳ:',
	'createtemplate' => 'Шаблон бисозед',
	'sf_createtemplate_namelabel' => 'Номи шаблон:',
	'sf_createtemplate_categorylabel' => 'Таъйиди гурӯҳ бо воситаи шаблон (ихтиёрӣ):',
	'sf_createtemplate_templatefields' => 'Вурудиҳои шаблон',
	'sf_createtemplate_aggregationlabel' => 'Унвон барои феҳрист:',
	'sf_createtemplate_standardformat' => 'Стандарт',
	'sf_createtemplate_deletefield' => 'Ҳафз',
	'sf_createtemplate_addtemplatebeforesave' => 'Шумо бояд ҳадди ақал як шаблон ба ин форм қабл аз захира кардани он илова кунед.',
	'sf_forms_docu' => 'Формҳои зерин дар вики вуҷуд доранд.',
	'createform' => 'Эҷоди як форм',
	'sf_createform_template' => 'Шаблон:',
	'sf_createform_inputtypedefault' => '(пешфарз)',
	'sf_createform_add' => 'Илова кардан',
	'sf_createcategory_name' => 'Ном:',
	'sf_formedit_remove' => 'Ҳазф',
	'sf_formedit_addanother' => 'Иловаи дигаре',
	'sf_formedit_none' => 'Ҳеҷ кадом',
	'sf_formerrors_header' => 'Хатоҳое дар вуруди форматон вуҷуд дорад; ба зер нигаред',
	'sf_blank_error' => 'наметавон холӣ бошад',
	'sf_property_isproperty' => 'Ин як вижагӣ аз навъи $1 аст.',
	'sf_template_docu' => "Ин шаблони '$1' аст. Бояд бо қолаби зерин фарохонӣ шавад:",
	'sf_template_docufooter' => 'Барои мушоҳидаи матни шаблон саҳифаро вироиш кунед.',
	'sf_form_docu' => "Ин форми '$1' аст. Барои илова кардани як саҳифае бо ин форм, дар зер номи саҳифаро ворид кунед; агар саҳифае бо ин ном вуҷуд дошта бошад, ба форми вироиши саҳифа ҳидоят мешавед.",
	'sf_form_freetextlabel' => 'Матни дилхоҳ',
	'sf_category_hasdefaultform' => 'Ин гурӯҳ аз форми $1 истифода мекунад.',
	'sf_category_desc' => 'Ин гурӯҳи $1 аст.',
	'sf_blank_namespace' => 'Аслӣ',
);

/** Tajik (Latin) (Тоҷикӣ (Latin))
 * @author Liangent
 */
$messages['tg-latn'] = array(
	'createproperty' => 'Viƶagī bisozed',
	'sf_createproperty_proptype' => "Nav':",
	'templates' => 'Şablonho',
	'sf_templates_docu' => 'Şablonhoi zer dar in viki vuçud dorand.',
	'sf_templates_definescat' => "ta'jidi gurūh:",
	'createtemplate' => 'Şablon bisozed',
	'sf_createtemplate_namelabel' => 'Nomi şablon:',
	'sf_createtemplate_categorylabel' => "Ta'jidi gurūh bo vositai şablon (ixtijorī):",
	'sf_createtemplate_templatefields' => 'Vurudihoi şablon',
	'sf_createtemplate_aggregationlabel' => 'Unvon baroi fehrist:',
	'sf_createtemplate_standardformat' => 'Standart',
	'sf_createtemplate_deletefield' => 'Hafz',
	'sf_createtemplate_addtemplatebeforesave' => 'Şumo bojad haddi aqal jak şablon ba in form qabl az zaxira kardani on ilova kuned.',
	'sf_forms_docu' => 'Formhoi zerin dar viki vuçud dorand.',
	'createform' => 'Eçodi jak form',
	'sf_createform_template' => 'Şablon:',
	'sf_createform_inputtypedefault' => '(peşfarz)',
	'sf_createform_add' => 'Ilova kardan',
	'sf_formedit_remove' => 'Hazf',
	'sf_formedit_addanother' => 'Ilovai digare',
	'sf_formedit_none' => 'Heç kadom',
	'sf_formerrors_header' => 'Xatohoe dar vurudi formaton vuçud dorad; ba zer nigared',
	'sf_blank_error' => 'nametavon xolī boşad',
	'sf_property_isproperty' => "In jak viƶagī az nav'i $1 ast.",
	'sf_template_docu' => "In şabloni '$1' ast. Bojad bo qolabi zerin faroxonī şavad:",
	'sf_template_docufooter' => 'Baroi muşohidai matni şablon sahifaro viroiş kuned.',
	'sf_form_docu' => "In formi '$1' ast. Baroi ilova kardani jak sahifae bo in form, dar zer nomi sahifaro vorid kuned; agar sahifae bo in nom vuçud doşta boşad, ba formi viroişi sahifa hidojat meşaved.",
	'sf_form_freetextlabel' => 'Matni dilxoh',
	'sf_category_hasdefaultform' => 'In gurūh az formi $1 istifoda mekunad.',
	'sf_category_desc' => 'In gurūhi $1 ast.',
	'sf_blank_namespace' => 'Aslī',
);

/** Thai (ไทย)
 * @author Octahedron80
 * @author Passawuth
 */
$messages['th'] = array(
	'sf_createtemplate_deletefield' => 'ลบ',
	'sf_createform_add' => 'เพิ่ม',
	'sf_formedit_none' => 'ไม่มี',
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'sf_createtemplate_deletefield' => 'Öçür',
	'sf_formedit_remove' => 'Aýyr',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'semanticforms-desc' => 'Mga pormularyo para sa paggawa ng mga dagdag at pagbabago sa dato hinggil sa kahulugan ng salita (semantiko)',
	'specialpages-group-sf_group' => 'Mga Pormularyo ng Semantiko (hinggil sa kahulugan ng salita)',
	'createproperty' => 'Lumikha ng pag-aari',
	'sf_createproperty_linktoform' => 'Ang pag-aaring ito ay kakawing patungo sa mga pahinang gumagamit ng pormularyong:',
	'sf_createproperty_allowedvalsinput' => 'Kung nais mong pahintulutan ang pag-aaring ito na magkaroon lamang ng partikular na mga halaga, ipasok ang talaan ng pinahihintulutang mga halaga, na pinaghihiwalay-hiwalay ng mga kuwit (kapag naglalaman ang isang halaga ng isang kuwit, palitan ito ng "\\,"):',
	'sf_createproperty_propname' => 'Pangalan ng pag-aari:',
	'sf_createproperty_proptype' => 'Uri:',
	'templates' => 'Mga suleras',
	'sf_templates_docu' => 'Umiiral na sa wiki ang sumusunod na mga suleras.',
	'sf_templates_definescat' => 'nagbibigay ng kahulugan sa kaurian/kategorya:',
	'createtemplate' => 'Lumikha ng isang suleras',
	'sf_createtemplate_namelabel' => 'Pangalan ng suleras:',
	'sf_createtemplate_categorylabel' => 'Kauriang binibigyang kahulugan ng suleras (maaaring wala nito):',
	'sf_createtemplate_templatefields' => 'Mga kahanayan ng suleras',
	'sf_createtemplate_fieldsdesc' => 'Hindi na ngayon kailangan ang mga pangalan ng kahanayan upang magkaroon ng mga kahanayan sa suleras na ito, payak na ipasok/ilagay lamang ang paksaan (indeks) ng bawat kahanayan (halimbawa na ang 1, 2, 3, atbp.) bilang pangalan, sa halip na isang tunay na pangalan.',
	'sf_createtemplate_fieldname' => 'Pangalan ng kahanayan:',
	'sf_createtemplate_displaylabel' => 'Ipinakikitang tatak:',
	'sf_createtemplate_semanticproperty' => 'Pag-aaring semantiko (hinggil sa kahulugan ng salita):',
	'sf_createtemplate_fieldislist' => 'Makapaghahawak ng isang talaan ng mga halaga ang kahanayang ito, pinaghihiwa-hiwalay ng mga kuwit',
	'sf_createtemplate_aggregation' => 'Pagkakakumpul-kumpol',
	'sf_createtemplate_aggregationdesc' => 'Upang maitala, sa anumang pahinang gumagamit ng ganitong suleras ang lahat ng mga pahinang may isang tiyak na pag-aari na tumuturo patungo sa pahinang iyon, tukuyin ang naaangkop na ari-ariang nasa ibaba:',
	'sf_createtemplate_aggregationlabel' => 'Pamagat ng talaan:',
	'sf_createtemplate_outputformat' => 'Anyo/pormat ng kalalabasan:',
	'sf_createtemplate_standardformat' => 'Pamantayan',
	'sf_createtemplate_infoboxformat' => 'Kahon ng kabatirang nasa gawi ng kanang kamay',
	'sf_createtemplate_addfield' => 'Magdagdag ng kahanayan',
	'sf_createtemplate_deletefield' => 'Burahin',
	'sf_createtemplate_addtemplatebeforesave' => 'Dapat kang magdagdag ng kahit na isang suleras sa pormularyong ito bago mo ito masagip.',
	'forms' => 'Mga pormularyo',
	'sf_forms_docu' => 'Umiiral na sa wiking ito ang sumusunod na mga pormularyo.',
	'createform' => 'Lumikha ng isang pormularyo',
	'sf_createform_nameinput' => 'Pangalan ng pormularyo',
	'sf_createform_nameinputdesc' => '(ang nakagawian ay pangalanan ang pormularyo pagkaraan ng pangunahing suleras na dinaramihan nito):',
	'sf_createform_template' => 'Suleras:',
	'sf_createform_templatelabelinput' => 'Tatak ng suleras (maaaring wala nito):',
	'sf_createform_allowmultiple' => 'Nagpapahintulot para sa maramihang (o walang) mga halimbawa/huwaran ng ganitong suleras sa loob ng nalikhang pahina',
	'sf_createform_field' => 'Kahanayan:',
	'sf_createform_fieldprop' => 'Binibigyang kahulugan ng kahanayang ito ang pag-aaring $1, ng uring $2.',
	'sf_createform_fieldproplist' => 'Binibigyang kahulugan ng kahanayang ito ang isang talaan ng mga langkap na mayroong pag-aaring $1, ng uring $2.',
	'sf_createform_fieldpropunknowntype' => 'Binibigyang kahulugan ng kahanayang ito ang pag-aaring $1, na hindi tinutukoy ang uri.',
	'sf_createform_inputtype' => 'Uri ng ipinapasok:',
	'sf_createform_inputtypedefault' => '(likas na katakdaan)',
	'sf_createform_formlabel' => 'Tatak ng pormularyo:',
	'sf_createform_hidden' => 'Nakatago',
	'sf_createform_restricted' => "May hangganan (tanging mga tagagamit na ''sysop'' lamang ang makapagbabago nito)",
	'sf_createform_mandatory' => 'Kailangang gawin talaga',
	'sf_createform_removetemplate' => 'Tanggalin ang suleras',
	'sf_createform_addtemplate' => 'Idagdag ang suleras:',
	'sf_createform_beforetemplate' => 'Bago dumating ang suleras:',
	'sf_createform_atend' => 'Sa hulihan',
	'sf_createform_add' => 'Idagdag/magdagdag',
	'sf_createform_choosefield' => 'Pumili ng kahanayang idaragdag',
	'createcategory' => 'Lumikha ng isang kaurian (kategorya)',
	'sf_createcategory_name' => 'Pangalan ng kategorya:',
	'sf_createcategory_defaultform' => 'Likas na nakatakdang pormularyo:',
	'sf_createcategory_makesubcategory' => 'Gawin itong isang kabahaging kaurian/kategorya ng iba pang kaurian (maaaring wala nito):',
	'createclass' => 'Gumawa ng isang klase',
	'sf_createclass_docu' => 'Ipasok dito ang lahat ng mga dato upang malikha ang lahat ng mga pag-aari, suleras, pormularyo at kategorya para sa isang nag-iisang klase.  Para sa mas marami pang mga mapagpipilian, gamitin sa halip ang mga pahinang $1.',
	'sf_createclass_allowedvalues' => 'Pinahihintulutang mga halaga',
	'sf_createclass_listofvalues' => 'Talaan ng mga halaga',
	'sf_createclass_leavefieldblank' => 'Kapag ang pangalan ng kahon ay kapareho ng sa pangalan ng pag-aari, maaari mo itong iwanang walang laman.',
	'sf_createclass_missingvalues' => 'Hindi pa nalagyan ang lahat ng kinakailangang mga lugar.',
	'sf_createclass_success' => 'Lilikhain ang mga pag-aari, suleras, pormularyo at kategorya.',
	'formstart' => 'Magdagdag ng pahinang may pormularyo',
	'sf_formstart_badform' => 'Kamalian: walang natagpuang pahina ng pormularyong nasa $1',
	'sf_formstart_badtitle' => 'Kamalian: ang "$1" ay isang hindi tanggap na pamagat para sa isang pahina.',
	'sf_formstart_docu' => "Ipasok dito ang pangalan ng pahina, na babaguhin sa pamamagitan ng pormularyong '$1'.
Kung umiiral na ang pahinang ito, dadalhin ka patungo sa pormularyong para sa paggawa ng pagbabago sa pahinang iyon.
At kung hindi, dadalhin ka naman patungo sa pormularyo para sa pagdaragdag ng pahina.",
	'sf_formstart_noform_docu' => 'Dito ipasok/ilagay ang pangalan ng pahina, at piliin ang pormularyong gagamitin sa pagbago nito.
Kung umiiral na ang pahinang ito, dadalhin ka patungo sa pormularyo para sa paggawa ng pagbabago para sa pahinang iyan.
Kung hindi, dadalhin ka naman patungo sa pormularyo upang maidagdag ang pahina.',
	'sf_formstart_createoredit' => 'Likhain o baguhin',
	'formedit' => 'Baguhin na may pormularyo',
	'sf_formedit_createtitle' => 'Likhain ang $1: $2',
	'sf_formedit_badurl' => "Ito ang pahina para sa pagdaragdag na may pormularyo.  Dapat mong tukuying kapwa ang isang pangalan ng pormularyo at isang pinupuntiryang pahinang nasa loob ng URL;
dapat itong magmukhang katulad ng 'Special:FormEdit?form=&lt;form name&gt;&target=&lt;target page&gt;', o  'Special:FormEdit/&lt;form name&gt;/&lt;target page&gt;'.",
	'sf_formedit_altforms' => 'Sa halip, maaari mong idagdag ang pahinang ito na may isa sa sumusunod na mga pormularyo:',
	'sf_formedit_altformsonly' => 'Pumili lamang po mula sa isa sa sumusunod na mga pormularyo upang maidagdag ang pahinang ito:',
	'sf_formcreate' => 'Likhaing may pormularyo',
	'sf_viewform' => 'Tingnan ang pormularyo',
	'sf_editsource' => 'Baguhin ang pinagmulan',
	'sf_formedit_edittitle' => 'Baguhin ang $1: $2',
	'sf_formedit_morethanoneform' => "'''Babala:''' Mahigit sa isang pormularyong likas na itinakda ang binigyang kahulugan para sa pahinang ito.",
	'sf_formedit_formwarning' => 'Babala: <a href="$1">Umiiral na</a> ang pahinang ito, ngunit hindi ito gumagamit ng ganitong pormularyo.',
	'sf_formedit_remove' => 'Tanggalin',
	'sf_formedit_addanother' => 'Magdagdag ng isa pa',
	'sf_formedit_none' => 'Wala',
	'runquery' => 'Patakbuhin ang tanong',
	'sf_runquery_badurl' => "Kailangan kang tumukoy ng isang pangalan ng pormularyo sa loob ng URL;
dapat magmukhang katulad ng 'Special:RunQuery/&lt;form name&gt;' ang URL.",
	'sf_runquery_title' => 'Patakbuhin ang tanong: $1',
	'sf_runquery_additionalquery' => 'Karagdagang tanong',
	'sf_formerrors_header' => 'Mayroong mga kamalian sa mga ipinasok mo sa pormularyo; tingnan sa ibaba',
	'sf_blank_error' => 'hindi maaaring walang laman',
	'sf_bad_url_error' => "dapat na mayroong tamang anyo/pormat ng URL, na nagsisimula sa 'http'",
	'sf_bad_email_error' => 'dapat na mayroong isang tanggap na anyo/pormat ng adres ng e-liham',
	'sf_bad_number_error' => 'dapat na isang tanggap na bilang',
	'sf_bad_integer_error' => "dapat na isang tanggap na buumbilang (''integer'')",
	'sf_bad_date_error' => 'dapat na isang tanggap na petsa',
	'uploadwindow' => 'Dungawan ng pagkarga',
	'sf_deletionlog' => 'Talaan ng pagbubura',
	'sf_property_isproperty' => 'Isa itong pag-aari ng uring $1.',
	'sf_property_linkstoform' => 'Kumakawing ito sa mga pahinang gumagamit ng pormularyong $1.',
	'sf_property_allowedvals' => 'Ang pinahihintulutang {{PLURAL:$1|halaga para sa pag-aaring ito ay|mga halaga para sa pag-aaring ito ay}}:',
	'sf_template_docu' => "Ito ang suleras na '$1'.
Dapat na tawagin ito alinsunod sa sumusunod na anyo/pormat:",
	'sf_template_docufooter' => 'Baguhin ang pahina upang makita ang teksto ng suleras.',
	'sf_form_docu' => "Ito ang pormularyong '$1'.
Upang makalikha ng isang pahina na may ganitong pormularyo, ipasok ang pangalan ng pahina sa ibaba;
kung umiiral na ang isang pahinang may ganyang pangalan, dadalhin ka patungo sa isang pormularyo upang mabago ang pahinyang iyan.",
	'sf_form_freetextlabel' => 'Malayang teksto',
	'sf_category_hasdefaultform' => 'Ang kaurian/kategoryang ito ay gumagamit ng pormularyong $1.',
	'sf_category_desc' => 'Ito ang kauriang $1.',
	'sf_blank_namespace' => 'Pangunahin',
	'right-viewedittab' => 'Tingnan ang panglaylay na "Baguhin" para sa mga pahinang mababago na ginagamitan ng pormularyo',
	'right-editrestrictedfields' => 'Baguhin ang mga lugar ng ipinagbabawal na pormularyo',
);

/** Turkish (Türkçe)
 * @author Joseph
 * @author Karduelis
 * @author Vito Genovese
 */
$messages['tr'] = array(
	'specialpages-group-sf_group' => 'Anlamsal Formlar',
	'createproperty' => 'Bir özellik oluştur',
	'sf_createproperty_propname' => 'Özellik ismi:',
	'sf_createproperty_proptype' => 'Tip:',
	'templates' => 'Şablonlar',
	'createtemplate' => 'Şablon oluştur',
	'sf_createtemplate_namelabel' => 'Şablon adı:',
	'sf_createtemplate_templatefields' => 'Şablon alanları',
	'sf_createtemplate_fieldname' => 'Alan adı:',
	'sf_createtemplate_displaylabel' => 'Etiketi görüntüle:',
	'sf_createtemplate_semanticproperty' => 'Anlamsal özellik:',
	'sf_createtemplate_aggregationlabel' => 'Liste için başlık:',
	'sf_createtemplate_outputformat' => 'Çıktı biçimi:',
	'sf_createtemplate_standardformat' => 'Standart',
	'sf_createtemplate_addfield' => 'Alan ekle',
	'sf_createtemplate_deletefield' => 'Sil',
	'forms' => 'Formlar',
	'createform' => 'Form oluştur',
	'sf_createform_nameinput' => 'Form adı',
	'sf_createform_template' => 'Şablon:',
	'sf_createform_templatelabelinput' => 'Şablon etiketi (isteğe bağlı):',
	'sf_createform_field' => 'Alan:',
	'sf_createform_inputtypedefault' => '(var sayılan)',
	'sf_createform_formlabel' => 'Form etiketi:',
	'sf_createform_hidden' => 'Gizli',
	'sf_createform_mandatory' => 'Zorunlu',
	'sf_createform_removetemplate' => 'Şablon kaldır',
	'sf_createform_addtemplate' => 'Şablon ekle:',
	'sf_createform_beforetemplate' => 'Şablondan önce:',
	'sf_createform_add' => 'Ekle',
	'sf_createform_choosefield' => 'Eklenecek bir alan seçin',
	'createcategory' => 'Bir kategori oluştur',
	'sf_createcategory_name' => 'Kategori ismi:',
	'sf_createcategory_defaultform' => 'Var sayılan form:',
	'sf_createclass_allowedvalues' => 'İzin verilen değerler',
	'sf_createclass_listofvalues' => 'Değerlerin listesi',
	'formstart' => 'Form ile sayfa ekle',
	'sf_formstart_createoredit' => 'Ekle veya düzelt',
	'sf_viewform' => 'Formu gör',
	'sf_editsource' => 'Kaynak düzelt',
	'sf_formedit_remove' => 'Kaldır',
	'sf_formedit_none' => 'Hiçbiri',
	'sf_runquery_additionalquery' => 'Ek sorgu',
	'sf_blank_error' => 'boş olamaz',
	'sf_bad_number_error' => 'geçerli bir sayı olmalı',
	'sf_bad_integer_error' => 'geçerli bir tamsayı olmalı',
	'sf_bad_date_error' => 'geçerli bir tarih olmalı',
	'sf_form_freetextlabel' => 'Serbest metin',
	'sf_category_desc' => 'Bu $1 kategorisidir.',
	'sf_blank_namespace' => 'Ana',
	'right-editrestrictedfields' => 'Kısıtlanmış form alanlarını değiştirir',
);

/** Tatar (Cyrillic) (Татарча/Tatarça (Cyrillic))
 * @author Ерней
 */
$messages['tt-cyrl'] = array(
	'sf_createform_inputtypedefault' => '(килешү буенча)',
);

/** Ukrainian (Українська)
 * @author AS
 * @author Ahonc
 * @author Prima klasy4na
 */
$messages['uk'] = array(
	'semanticforms-desc' => 'Форми для додавання і редагування семантичних даних',
	'specialpages-group-sf_group' => 'Семантичні форми',
	'createproperty' => 'Створити властивість',
	'sf_createproperty_linktoform' => 'Ця властивість містить посилання на сторінки, які використовують форму:',
	'sf_createproperty_propname' => 'Назва властивості:',
	'sf_createproperty_proptype' => 'Тип:',
	'templates' => 'Шаблони',
	'sf_createtemplate_namelabel' => 'Назва шаблону:',
	'sf_createtemplate_deletefield' => 'Вилучити',
	'sf_createform_field' => 'Поле:',
	'sf_formedit_remove' => 'Вилучити',
);

/** Veps (Vepsan kel')
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'sf_createproperty_propname' => 'Ičendan nimi:',
	'sf_createproperty_proptype' => 'Tip:',
	'templates' => 'Šablonad',
	'sf_templates_docu' => 'Wikiš om ningoižid šablonoid:',
	'sf_templates_definescat' => 'märhapaneb kategorijan:',
	'createtemplate' => 'Säta šablon',
	'sf_createtemplate_namelabel' => 'Šablonan nimi:',
	'sf_createtemplate_categorylabel' => 'Kategorii, kudamban märhapaneb šablon (opcionaližikš):',
	'sf_createtemplate_templatefields' => 'Šablonan pöudod:',
	'sf_createtemplate_outputformat' => 'Lähtmižformat:',
	'sf_createtemplate_standardformat' => 'Standartine',
	'sf_createtemplate_addfield' => 'Läžata pöud',
	'sf_createtemplate_deletefield' => 'Čuta poiš',
	'forms' => 'Formad',
	'createform' => 'Säta form',
	'sf_createform_nameinput' => 'Forman nimi',
	'sf_createform_template' => 'Šablon:',
	'sf_createform_field' => 'Pöud:',
	'sf_createform_hidden' => 'Peittud',
	'sf_createform_add' => 'Ližata',
	'createcategory' => 'Säta kategorii',
	'sf_createcategory_name' => 'Kategorijan nimi:',
	'sf_createcategory_defaultform' => 'Form augotižjärgendusen mödhe:',
	'sf_formstart_createoredit' => 'Ližada vai redaktirui',
	'sf_editsource' => 'Redaktiruida purde',
	'sf_formedit_remove' => 'Čuta poiš',
	'sf_formedit_addanother' => 'Ližata völ',
	'sf_form_freetextlabel' => 'Joudai tekst',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'semanticforms-desc' => 'Mẫu để thêm và sửa đổi dữ liệu ngữ nghĩa',
	'specialpages-group-sf_group' => 'Mẫu Ngữ Nghĩa',
	'createproperty' => 'Tạo một thuộc tính',
	'sf_createproperty_linktoform' => 'Thuộc tính này sẽ liên kết đến các trang sử dụng mẫu:',
	'sf_createproperty_allowedvalsinput' => 'Nếu bạn muốn thuộc tính này chỉ cho phép một số giá trị nào đó, hãy nhập vào danh sách các giá trị cho phép, phân cách nhau bằng dấu phẩy (nếu một giá trị có chứa dấu phẩy, hãy thay nó bằng “\\,”):',
	'sf_createproperty_propname' => 'Tên thuộc tính:',
	'sf_createproperty_proptype' => 'Loại:',
	'templates' => 'Bản mẫu',
	'sf_templates_docu' => 'Các bản mẫu sau có trong wiki.',
	'sf_templates_definescat' => 'định nghĩa thể loại:',
	'createtemplate' => 'Tạo bản mẫu',
	'sf_createtemplate_namelabel' => 'Tên bản mẫu:',
	'sf_createtemplate_categorylabel' => 'Thể loại do bản mẫu định nghĩa (tùy chọn):',
	'sf_createtemplate_templatefields' => 'Các trường trong bản mẫu',
	'sf_createtemplate_fieldsdesc' => 'Để dùng các trường không cần tên trong bản mẫu, chỉ cần gõ vào thứ tự mỗi trường (như 1, 2, 3, v.v.) thay vì tên thật sự.',
	'sf_createtemplate_fieldname' => 'Tên trường:',
	'sf_createtemplate_displaylabel' => 'Hiển thị nhãn:',
	'sf_createtemplate_semanticproperty' => 'Thuộc tính ngữ nghĩa:',
	'sf_createtemplate_fieldislist' => 'Trường này có thể chứa nhiều giá trị, cách nhau bằng dấu phẩy',
	'sf_createtemplate_aggregation' => 'Tập hợp',
	'sf_createtemplate_aggregationdesc' => 'Để liệt kê tất cả các bài viết có thuộc tính nào đó tại trang dùng bản mẫu này, hãy chỉ định thuộc tính thích hợp ở dưới:',
	'sf_createtemplate_aggregationlabel' => 'Đề mục cho danh sách:',
	'sf_createtemplate_outputformat' => 'Định dạng xuất:',
	'sf_createtemplate_standardformat' => 'Chuẩn',
	'sf_createtemplate_infoboxformat' => 'Hộp thông tin phía bên phải',
	'sf_createtemplate_addfield' => 'Thêm trường',
	'sf_createtemplate_deletefield' => 'Xóa',
	'sf_createtemplate_addtemplatebeforesave' => 'Bạn phải thêm vào ít nhất một bản mẫu vào mẫu trước khi bạn có lưu nó lại.',
	'forms' => 'Các biểu mẫu',
	'sf_forms_docu' => 'Các mẫu dưới đây có trong wiki.',
	'createform' => 'Tạo ra biểu mẫu',
	'sf_createform_nameinput' => 'Tên biểu mẫu',
	'sf_createform_nameinputdesc' => '(quy ước là đặt tên biểu mẫu theo bản mẫu chính mà nó điền):',
	'sf_createform_template' => 'Bản mẫu:',
	'sf_createform_templatelabelinput' => 'Nhãn bản mẫu (tùy chọn):',
	'sf_createform_allowmultiple' => 'Cho phép nhiều (hoặc không) thực thể của bản mẫu này trong trang được tạo',
	'sf_createform_field' => 'Trường:',
	'sf_createform_fieldprop' => 'Trường này định nghĩa tính chất $1, thuộc kiểu $2.',
	'sf_createform_fieldproplist' => 'Trường này định nghĩa danh sách các phần tử có tính chất $1, thuộc kiểu $2.',
	'sf_createform_fieldpropunknowntype' => 'Trường này định nghĩa tính chất $1, thuộc kiểu không xác định.',
	'sf_createform_inputtype' => 'Kiểu nhập vào:',
	'sf_createform_inputtypedefault' => '(mặc định)',
	'sf_createform_formlabel' => 'Nhãn cho mẫu:',
	'sf_createform_hidden' => 'Ẩn',
	'sf_createform_restricted' => 'Hạn chế (chỉ có quản lý mới được thay đổi)',
	'sf_createform_mandatory' => 'Bắt buộc',
	'sf_createform_removetemplate' => 'Xóa bỏ bản mẫu',
	'sf_createform_addtemplate' => 'Thêm bản mẫu:',
	'sf_createform_beforetemplate' => 'Trước bản mẫu:',
	'sf_createform_atend' => 'Vào cuối',
	'sf_createform_add' => 'Thêm',
	'sf_createform_choosefield' => 'Chọn một trường để thêm vào',
	'createcategory' => 'Tạo thể loại',
	'sf_createcategory_name' => 'Tên thể loại:',
	'sf_createcategory_defaultform' => 'Biểu mẫu mặc định:',
	'sf_createcategory_makesubcategory' => 'Chuyển cái này thành thể loại con của một thể loại khác (tùy chọn):',
	'createclass' => 'Tạo lớp',
	'sf_createclass_docu' => 'Nhập tất cả dữ liệu tại đây để khởi tạo thuộc tính, bản mẫu, mẫu đơn và thể loại dành cho một lớp đơn. Để có thêm tùy chọn, hãy dùng trang $1.',
	'sf_createclass_allowedvalues' => 'Giá trị cho phép',
	'sf_createclass_listofvalues' => 'Danh sách giá trị',
	'sf_createclass_leavefieldblank' => 'Nếu tên trường trùng với tên thuộc tính, bạn có thể bỏ trống nó.',
	'sf_createclass_missingvalues' => 'Các ô bắt buộc chưa được điền đầy đủ.',
	'sf_createclass_success' => 'Thuộc tính, bản mẫu, mẫu đơn và thể loại sẽ được khởi tạo.',
	'formstart' => 'Dùng mẫu để thêm trang',
	'sf_formstart_badform' => 'Lỗi: không có trang mẫu nào tìm thấy tại $1',
	'sf_formstart_docu' => 'Nhập vào tên trang ở đây, để có thể sửa đổi với mẫu ‘$1’. Nếu trang này đã tồn tại, bạn sẽ được chuyển đến mẫu để sửa đổi trang đó. Nếu không, bạn sẽ được chuyển đến mẫu để thêm trang.',
	'sf_formstart_noform_docu' => 'Nhập tên trang vào đây, và chọn mẫu để sửa đổi với nó. Nếu trang này đã tồn tại, bạn sẽ được chuyển tới mẫu sửa đổi trang. Nếu không, bạn sẽ được chuyển đến mẫu để thêm trang.',
	'sf_formstart_createoredit' => 'Tạo hay sửa đổi',
	'formedit' => 'Sửa bằng mẫu này',
	'sf_formedit_createtitle' => 'Tạo $1: $2',
	'sf_formedit_badurl' => 'Đây là trang để sửa đổi bằng biểu mẫu. Bạn phải xác định cả tên biểu mẫu và trang đích trong địa chỉ URL; nó sẽ có dạng là “{{ns:Special}}:FormEdit?form=&lt;form name&gt;&target=&lt;target page&gt;” hoặc “{{ns:Special}}:FormEdit/&lt;form name&gt;/&lt;target page&gt;”.',
	'sf_formedit_altforms' => 'Thay vào đó bạn có thể thêm trang này vào một trong những mẫu sau:',
	'sf_formedit_altformsonly' => 'Xin chọn một trong những mẫu dưới đây để thêm vào trang này:',
	'sf_formcreate' => 'Tạo bằng biểu mẫu',
	'sf_viewform' => 'Xem mẫu',
	'sf_editsource' => 'Sửa đổi mã nguồn',
	'sf_formedit_edittitle' => 'Sửa đổi $1: $2',
	'sf_formedit_morethanoneform' => 'Cảnh báo: Có nhiều hơn một mẫu đơn mặc định được định nghĩa cho trang này.',
	'sf_formedit_formwarning' => 'Cảnh báo: Trang này <a href="$1">đã tồn tại</a>, nhưng nó không dùng mẫu này.',
	'sf_formedit_remove' => 'Dời',
	'sf_formedit_addanother' => 'Thêm tiếp',
	'sf_formedit_none' => 'Không có',
	'sf_formerrors_header' => 'Có lỗi với dữ liệu nhập mẫu của bạn; xem ở dưới',
	'sf_blank_error' => 'không được để trống',
	'sf_bad_url_error' => 'phải có định dạng URL đúng, bắt đầu bằng ‘http’',
	'sf_bad_email_error' => 'phải có định dạng địa chỉ thư điện tử đúng',
	'sf_bad_number_error' => 'phải có số đúng',
	'sf_bad_integer_error' => 'phải là số nguyên đúng',
	'sf_bad_date_error' => 'phải là ngày đúng',
	'uploadwindow' => 'Cửa sổ tải',
	'sf_deletionlog' => 'Nhật trình xóa',
	'sf_property_isproperty' => 'Đây là tính chất thuộc kiểu $1.',
	'sf_property_linkstoform' => 'Nó liên kết đến các trang sử dụng mẫu $1.',
	'sf_property_allowedvals' => '{{PLURAL:$1|Giá trị|Các giá trị}} cho phép của thuộc tính này là:',
	'sf_template_docu' => 'Đây là bản mẫu “$1”. Nó nên được gọi theo định dạng sau:',
	'sf_template_docufooter' => 'Sửa trang để xem văn bản bản mẫu.',
	'sf_form_docu' => 'Đây là biểu mẫu “$1”. Để tạo trang bằng biểu mẫu này, nhập vào tên trang ở dưới. Nếu một trang với tên này đã tồn tại, bạn sẽ được chuyển đến biểu mẫu để sửa trang đó.',
	'sf_form_freetextlabel' => 'Văn bản tự do',
	'sf_category_hasdefaultform' => 'Thể loại này sử dụng mẫu $1.',
	'sf_category_desc' => 'Đây là thể loại $1.',
	'sf_blank_namespace' => 'Chính',
	'right-viewedittab' => 'Xem thẻ “Sửa đổi” tại các trang có thể sửa đổi dùng biểu mẫu',
	'right-editrestrictedfields' => 'Sửa đổi các trường biểu mẫu hạn chế',
);

/** Volapük (Volapük)
 * @author Malafaya
 * @author Smeira
 */
$messages['vo'] = array(
	'sf_createproperty_propname' => 'Nem:',
	'sf_createproperty_proptype' => 'Sot:',
	'templates' => 'Samafomots',
	'createtemplate' => 'Jafön samafomoti',
	'sf_createtemplate_namelabel' => 'Nem samafomota:',
	'sf_createtemplate_templatefields' => 'Fels samafomota',
	'sf_createtemplate_fieldname' => 'Felanem:',
	'sf_createtemplate_aggregationlabel' => 'Tiäd liseda:',
	'sf_createtemplate_addfield' => 'Läükön feli',
	'sf_createtemplate_deletefield' => 'Moükön',
	'sf_createtemplate_addtemplatebeforesave' => 'Mutol läükön samafomoti pu bali fomete at büä okanol dakipön oni.',
	'forms' => 'Fomets',
	'sf_forms_docu' => 'Fomets fovik dabinons in vük.',
	'createform' => 'Jafön fometi',
	'sf_createform_template' => 'Samafomot:',
	'sf_createform_field' => 'Fel:',
	'sf_createform_hidden' => 'Klänedik',
	'sf_createform_removetemplate' => 'Moükön samafomoti',
	'sf_createform_addtemplate' => 'Läükön samafomoti',
	'sf_createform_beforetemplate' => 'Bü samafomot:',
	'sf_createform_add' => 'Läükön',
	'sf_createform_choosefield' => 'Välön feli läükabik',
	'createcategory' => 'Jafön kladi',
	'sf_createcategory_name' => 'Kladanem:',
	'sf_createcategory_defaultform' => 'Fomet kösömik:',
	'sf_createcategory_makesubcategory' => 'Vedükön atosi donakladi klada votik (no peflagon):',
	'formstart' => 'Läükön padi me fomet',
	'sf_formstart_badform' => 'Pöl: fometapad nonik petuvon lä $1',
	'sf_formstart_docu' => 'Penolös is nemi pada, kel poredakon me fomet: „$1“.
If pad at ya dabinon, ologol fometi ad redakön padi dabinöl at.
Voto ologol fometi ad läükön padi.',
	'sf_formstart_noform_docu' => 'Penolös is padanemi e välolös fometi, me kel vilol redakön oni.
If pad at ya dabinons, ologol fometi ad redakön padi dabinöl at.
Voto ologol fometi ad läükön padi.',
	'sf_formstart_createoredit' => 'Läükön u votükön',
	'formedit' => 'Redakön me fomet',
	'sf_formedit_createtitle' => 'Läükön $1: $2',
	'sf_formedit_badurl' => 'Pad at pagebon ad läükön nünodis. Mutoy penön fometanemi e zeilapadi ini el URL, kel muton logotön so: „Special:FormEdit?form=&lt;fometanem&gt;&target=&lt;zeilapad&gt;“, u: „Special:FormEdit/&lt;fometanem&gt;/&lt;zeilapad&gt;“.',
	'sf_formedit_altforms' => 'Kanol plao läükön padi at me bal fometas fovik:',
	'sf_formedit_altformsonly' => 'Välolös bali fometas sököl ad läükön padi at:',
	'sf_viewform' => 'Logön fometi',
	'sf_editsource' => 'Redakön fonäti',
	'sf_formedit_edittitle' => 'Votükön $1: $2',
	'sf_formedit_formwarning' => 'Nuned: Pad at <a href="$1">ya dabinon</a>, ab no gebon fometi at.',
	'sf_formedit_remove' => 'Moükön',
	'sf_formedit_addanother' => 'Läükön votiki',
	'sf_formedit_none' => 'Nonik',
	'sf_blank_error' => 'no dalon vagön',
	'sf_bad_url_error' => 'muton labön fomäti verätik ela URL, primölo me el „http“.',
	'sf_bad_email_error' => 'muton labön fomäti ladeta leäktronik lonöföl',
	'sf_bad_number_error' => 'muton binön num lonöföl',
	'sf_bad_date_error' => 'muton binön dät lonöföl',
	'uploadwindow' => 'Löpükamafenät',
	'sf_template_docu' => 'Atos binon samafomot: „$1“.
Söton pavokön ma fomät fovik:',
	'sf_template_docufooter' => 'Redakön padi at logön samafomotavödemi.',
	'sf_form_docu' => 'Pad at binon fomet: „$1“.
Ad läükön padi me fomet at, penolös padanemi dono; if pad labü nem at ya dabinon, ologol fometi ad redakön padi dabinöl at.',
	'sf_form_freetextlabel' => 'Vödem libik',
	'sf_category_hasdefaultform' => 'Klad at gebon fometi: $1.',
	'sf_category_desc' => 'Atos binon klad: $1.',
	'sf_blank_namespace' => 'Cifik',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 */
$messages['yi'] = array(
	'sf_createproperty_propname' => 'אטריבוט נאמען:',
	'sf_createproperty_proptype' => 'טיפ:',
	'templates' => 'מוסטערן',
	'sf_templates_docu' => 'די פאלגנדע מוסטערן עקזיסטירן אין דער וויקי.',
	'sf_templates_definescat' => 'דעפינירט קאטעגאריע:',
	'createtemplate' => 'באשאפן א מוסטער',
	'sf_createtemplate_namelabel' => 'מוסטער נאמען:',
	'sf_createtemplate_templatefields' => 'מוסטער פֿעלדער',
	'sf_createtemplate_deletefield' => 'אויסמעקן',
	'sf_createform_hidden' => 'באַהאַלטן',
	'sf_createform_add' => 'צולייגן',
	'createcategory' => 'שאפֿן א קאטעגאריע',
	'sf_createcategory_name' => 'קאטעגאריע נאָמען:',
	'sf_formedit_none' => 'קיין',
);

/** Chinese (China) (‪中文(中国大陆)‬)
 * @author Roc Michael <roc.no1@gmail.com>
 */
$messages['zh-cn'] = array(
	'createproperty' => '新增语意(semantic)性质',
	'sf_createproperty_allowedvalsinput' => '如果您希望此栏位只能输入特定的值,请将那些值输入此处，并以半型的逗号(,)分隔，万一您所指定的值中已包含了半型逗号，请在该逗号前加上一个反斜线(\\,)：',
	'sf_createproperty_propname' => '名称：',
	'sf_createproperty_proptype' => '型态:',
	'templates' => '样板',
	'sf_templates_docu' => '本wiki系统已含有下列的样板。',
	'sf_templates_definescat' => '定义分类(Category)：',
	'createtemplate' => '新增样板',
	'sf_createtemplate_namelabel' => '样板名称：',
	'sf_createtemplate_categorylabel' => '以样板定义分类(选用性的)',
	'sf_createtemplate_templatefields' => '样板栏位',
	'sf_createtemplate_fieldsdesc' => '于某个样板之内新增无须名称的栏位，仅需赋予索引值(例如： 1,2,3 等等)给这些栏位 而无须指定名称。',
	'sf_createtemplate_fieldname' => '栏位名称：',
	'sf_createtemplate_displaylabel' => '栏位标签：',
	'sf_createtemplate_semanticproperty' => '语意(Semantic)性质',
	'sf_createtemplate_fieldislist' => '本栏位能够以某些值来建立列表，那些值须以半型逗号「,」分隔。',
	'sf_createtemplate_aggregation' => '聚集(Aggregation)',
	'sf_createtemplate_aggregationdesc' => '列出所有使用本样版的页面，而那些带有特定性质指向那页面的文章，指定着如下性质：译注：To list, on any page using this template, all of the articles that have a certain property pointing to that page, specify the appropriate property below :',
	'sf_createtemplate_aggregationlabel' => '列表标题',
	'sf_createtemplate_outputformat' => '输出格式：',
	'sf_createtemplate_standardformat' => '标准型',
	'sf_createtemplate_infoboxformat' => '右置型信息招牌，广告牌',
	'sf_createtemplate_addfield' => '新增栏位',
	'sf_createtemplate_deletefield' => '删除',
	'sf_createtemplate_addtemplatebeforesave' => '在您存贮它之前，您必须为这个表单加入至少一项样板。',
	'forms' => '表单',
	'sf_forms_docu' => '本wiki系统已建有下列的表单。',
	'createform' => '新增表单',
	'sf_createform_nameinput' => '表单名称(大致上系以其主要的引用样板的名称来为其命名)：',
	'sf_createform_template' => '样板：',
	'sf_createform_templatelabelinput' => '样板标签(选用性的)',
	'sf_createform_allowmultiple' => '多重选项样板，此样板用于在新增页面上的多重(或无)选项。',
	'sf_createform_field' => '栏位：',
	'sf_createform_fieldprop' => '此栏定义$2型态的$1性质。',
	'sf_createform_fieldproplist' => '此栏定义一些采$2型态且带有$1质性的元件',
	'sf_createform_fieldpropunknowntype' => '此栏定义 $1性质，却未指定型态。译注原文为：This field defines the property $1, of unspecified type.',
	'sf_createform_inputtype' => '输入型态：',
	'sf_createform_inputtypedefault' => '(内定值)',
	'sf_createform_formlabel' => '表单标签。',
	'sf_createform_hidden' => '隐藏',
	'sf_createform_restricted' => '受限制的页面(只有管理员可编辑)',
	'sf_createform_mandatory' => '强制性的',
	'sf_createform_removetemplate' => '删除样板',
	'sf_createform_addtemplate' => '新增样板：',
	'sf_createform_beforetemplate' => '在样板之前：',
	'sf_createform_atend' => '在末端',
	'sf_createform_add' => '新增',
	'sf_createform_choosefield' => '选取欲新增的栏位',
	'createcategory' => '新增分类(Category)',
	'sf_createcategory_name' => '名称：',
	'sf_createcategory_defaultform' => '预设的表单',
	'sf_createcategory_makesubcategory' => '令此项分类(Category)成为某一分类项下的子分类(选择性使用)',
	'formstart' => '新增页面',
	'sf_formstart_badform' => '错误！在$1上并没有找到表单页面。',
	'sf_formstart_docu' => "输入页面名称以便以'$1'表单编辑。如果此页已存在的话，您便能以表单编辑该页，否则，您便能以表单新增此页面。",
	'sf_formstart_noform_docu' => '请于此处输入页面名称，再选取表单对其进行编辑，如果此页已存在的话，您便能以表单编辑该页，否则，您便能以表单新增此页面。',
	'sf_formstart_createoredit' => '新增或编辑',
	'formedit' => '以表单进行编辑',
	'sf_formedit_createtitle' => '增加 $1： $2',
	'sf_formedit_badurl' => "本页为新增资料之用，您必须在URL里同时指定表单及目标页面，它看起来应该像是'Special:FormEdit?form=&lt;表单名称&gt;&target=&lt;目标页面&gt;' 或是 'Special:FormEdit/&lt;表单名称&gt;/&lt;目标页面&gt;'。",
	'sf_formedit_altforms' => '您可选用下列其中一个的表单来新增此页',
	'sf_formedit_altformsonly' => '请从下列的表单中选出其中一个，并以该表单编辑此页：',
	'sf_editsource' => '编辑来源',
	'sf_formedit_edittitle' => '编辑 $1: $2',
	'sf_formedit_formwarning' => '警告：<a href="$1">此页</a>已经存在，只是尚未引用本表单。',
	'sf_formedit_remove' => '删除',
	'sf_formedit_addanother' => '新增其他',
	'sf_blank_error' => '不得为空白',
	'sf_bad_url_error' => "须有正确的URL格式（即以 'http'起头）",
	'sf_bad_email_error' => '必须是有效的电子邮件(Email)格式',
	'sf_bad_number_error' => '必须是有效的数字',
	'sf_bad_integer_error' => '必须是有效的整数',
	'sf_bad_date_error' => '必须是有效的日期',
	'sf_property_isproperty' => '这是$1型态的性质。',
	'sf_property_allowedvals' => '此属性的可用型态为：',
	'sf_template_docu' => "这是'$1'样板，它须以如下的格式引用：",
	'sf_template_docufooter' => '编辑此页以查看样板文字。',
	'sf_form_docu' => "这是'$1'表单，编辑此页以查看原始码，您能以此表单新增资料[[$2|这里]]。",
	'sf_form_freetextlabel' => '随意文字区(Free text)',
	'sf_category_hasdefaultform' => '此项分类(category)使用$1表单。',
	'sf_category_desc' => '这是$1分类(category)',
	'sf_blank_namespace' => '主',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Gzdavidwong
 * @author Liangent
 * @author PhiLiP
 */
$messages['zh-hans'] = array(
	'sf_createproperty_propname' => '名称：',
	'sf_createproperty_proptype' => '类型：',
	'templates' => '模板',
	'sf_createtemplate_namelabel' => '模板名称：',
	'sf_createtemplate_standardformat' => '标准',
	'sf_createform_hidden' => '隐藏',
	'sf_viewform' => '检视表格',
	'sf_formedit_remove' => '移除',
	'sf_blank_error' => '不可留空',
	'sf_bad_number_error' => '必须为有效数字',
	'sf_bad_integer_error' => '必须为有效整数',
	'sf_bad_date_error' => '必须为有效日期',
);

/** Traditional Chinese (‪中文(繁體)‬)
 * @author Gzdavidwong
 * @author Liangent
 * @author Wrightbus
 */
$messages['zh-hant'] = array(
	'sf_createproperty_propname' => '名稱：',
	'sf_createproperty_proptype' => '類型：',
	'templates' => '模板',
	'sf_createtemplate_namelabel' => '模板名稱：',
	'sf_createtemplate_standardformat' => '標準',
	'sf_createform_hidden' => '隱藏',
	'sf_viewform' => '檢視表格',
	'sf_formedit_remove' => '移除',
	'sf_blank_error' => '不可留空',
	'sf_bad_number_error' => '必須為有效數字',
	'sf_bad_integer_error' => '必須為有效整數',
	'sf_bad_date_error' => '必須為有效日期',
);

/** Chinese (Taiwan) (‪中文(台灣)‬)
 * @author Roc michael
 */
$messages['zh-tw'] = array(
	'semanticforms-desc' => '用來新增及編輯語意資料的表單',
	'specialpages-group-sf_group' => '語意表單',
	'createproperty' => '新增性質',
	'sf_createproperty_linktoform' => '此一性質將連結至使用此表單的頁面：<br>
This property will link to pages that use the form:',
	'sf_createproperty_allowedvalsinput' => '如果您希望此欄位只能輸入特定的值,請將那些值輸入此處，並以半型的逗號(,)分隔，萬一您所指定的值中已包含了半型逗號，請在該逗號前加上一個反斜線(\\,)：',
	'sf_createproperty_propname' => '名稱：',
	'sf_createproperty_proptype' => '型態:',
	'templates' => '樣板',
	'sf_templates_docu' => '本wiki系統已含有下列的樣板。',
	'sf_templates_definescat' => '定義分類：',
	'createtemplate' => '新增樣板',
	'sf_createtemplate_namelabel' => '樣板名稱：',
	'sf_createtemplate_categorylabel' => '以樣板定義分類(選用性的)',
	'sf_createtemplate_templatefields' => '樣板欄位',
	'sf_createtemplate_fieldsdesc' => '於某個樣板之內新增無須名稱的欄位，僅需賦予索引值(例如： 1,2,3 等等)給這些欄位 而無須指定名稱。',
	'sf_createtemplate_fieldname' => '欄位名稱：',
	'sf_createtemplate_displaylabel' => '欄位標籤：',
	'sf_createtemplate_semanticproperty' => '語意性質',
	'sf_createtemplate_fieldislist' => '本欄位能夠以某些值來建立清單，那些值須以半型逗號「,」分隔。',
	'sf_createtemplate_aggregation' => '聚集(Aggregation)',
	'sf_createtemplate_aggregationdesc' => '請指定一項性質，若在某些頁面中該性質的值與您正在瀏覽的頁面的名稱相同時，則這些頁面將會在您正在瀏覽的頁面中被列舉出來。',
	'sf_createtemplate_aggregationlabel' => '清單標題',
	'sf_createtemplate_outputformat' => '輸出格式：',
	'sf_createtemplate_standardformat' => '標準型',
	'sf_createtemplate_infoboxformat' => '右置型訊息看板',
	'sf_createtemplate_addfield' => '新增欄位',
	'sf_createtemplate_deletefield' => '刪除',
	'sf_createtemplate_addtemplatebeforesave' => '在您儲存它之前，您必須為這個表單加入至少一項樣板。',
	'forms' => '表單',
	'sf_forms_docu' => '本wiki系統已建有下列的表單。',
	'createform' => '新增表單',
	'sf_createform_nameinput' => '表單名稱(大致上係以其主要的引用樣板的名稱來為其命名)：',
	'sf_createform_template' => '樣板：',
	'sf_createform_templatelabelinput' => '樣板標籤(選用性的)',
	'sf_createform_allowmultiple' => '多重選項樣板，此樣板用於在新增頁面上的多重(或無)選項。',
	'sf_createform_field' => '欄位：',
	'sf_createform_fieldprop' => '此欄定義$2型態的$1性質。',
	'sf_createform_fieldproplist' => '此欄定義一些採$2型態且帶有$1質性的元件',
	'sf_createform_fieldpropunknowntype' => '此欄定義 $1性質，卻未指定型態。譯注原文為：This field defines the property $1, of unspecified type.',
	'sf_createform_inputtype' => '輸入型態：',
	'sf_createform_inputtypedefault' => '(內定值)',
	'sf_createform_formlabel' => '表單標籤。',
	'sf_createform_hidden' => '隱藏',
	'sf_createform_restricted' => '受限制的頁面(只有管理員可編輯)',
	'sf_createform_mandatory' => '強制性的',
	'sf_createform_removetemplate' => '刪除樣板',
	'sf_createform_addtemplate' => '新增樣板：',
	'sf_createform_beforetemplate' => '在樣板之前：',
	'sf_createform_atend' => '在末端',
	'sf_createform_add' => '新增',
	'sf_createform_choosefield' => '選取欲新增的欄位',
	'createcategory' => '新增分類',
	'sf_createcategory_name' => '名稱：',
	'sf_createcategory_defaultform' => '預設的表單',
	'sf_createcategory_makesubcategory' => '令此項分類成為某一分類項下的子分類(選擇性使用)',
	'createclass' => '建立類別(class)',
	'sf_createclass_docu' => '使用$1頁面，於此處輸入所有資料，以建立單一類別的性質、模板、表單和分類<br>
Enter all the data here to create the properties, template, form and category for a single class. For more options, use the pages $1 instead.',
	'sf_createclass_allowedvalues' => '允許值',
	'sf_createclass_listofvalues' => '列出值(List of values)',
	'sf_createclass_leavefieldblank' => '如果該欄位名稱與性質相同，則您可留空不填。',
	'sf_createclass_missingvalues' => '並非所有用來查詢的欄位值皆已被找到了。',
	'sf_createclass_success' => '性質、模板、表單及分類將要被建立。',
	'formstart' => '新增頁面',
	'sf_formstart_badform' => '錯誤！在$1上並沒有找到表單頁面。',
	'sf_formstart_docu' => "輸入頁面名稱以便以'$1'表單編輯。如果此頁已存在的話，您便能以表單編輯該頁，否則，您便能以表單新增此頁面。",
	'sf_formstart_noform_docu' => '請於此處輸入頁面名稱，再選取表單對其進行編輯，如果此頁已存在的話，您便能以表單編輯該頁，否則，您便能以表單新增此頁面。',
	'sf_formstart_createoredit' => '新增或編輯',
	'formedit' => '以表單進行編輯',
	'sf_formedit_createtitle' => '增加 $1： $2',
	'sf_formedit_badurl' => "本頁為新增資料之用，您必須在URL裡同時指定表單及目標頁面，它看起來應該像是'Special:FormEdit?form=&lt;表單名稱&gt;&target=&lt;目標頁面&gt;' 或是 'Special:FormEdit/&lt;表單名稱&gt;/&lt;目標頁面&gt;'。",
	'sf_formedit_altforms' => '您可選用下列其中一個的表單來新增此頁',
	'sf_formedit_altformsonly' => '請從下列的表單中選出其中一個，並以該表單編輯此頁：',
	'sf_formcreate' => '以表單建立',
	'sf_viewform' => '查看表單',
	'sf_editsource' => '編輯來源',
	'sf_formedit_edittitle' => '編輯 $1: $2',
	'sf_formedit_morethanoneform' => "'''警告：'''用來編輯此頁的表單已超過一個以上了。",
	'sf_formedit_formwarning' => '警告：<a href="$1">此頁</a>已經存在，只是尚未引用本表單。',
	'sf_formedit_remove' => '刪除',
	'sf_formedit_addanother' => '新增其他',
	'sf_formedit_none' => '無',
	'runquery' => '執行查詢',
	'sf_runquery_badurl' => "您必須在URL中指定某表單，該URL應該看起來像是'特殊:執行查詢/&lt;表單名稱&gt;'.<br>
You must specify a form name in the URL;
the URL should look like 'Special:RunQuery/&lt;form name&gt;'.",
	'sf_runquery_title' => '執行查詢: $1',
	'sf_runquery_additionalquery' => '條件式查詢(Additional query)',
	'sf_formerrors_header' => '您在表單的輸入項目中有錯誤；請參考下方',
	'sf_blank_error' => '不得為空白',
	'sf_bad_url_error' => "須有正確的URL格式（即以 'http'起頭）",
	'sf_bad_email_error' => '必須是有效的電子郵件(Email)格式',
	'sf_bad_number_error' => '必須是有效的數字',
	'sf_bad_integer_error' => '必須是有效的整數',
	'sf_bad_date_error' => '必須是有效的日期',
	'uploadwindow' => '上傳檔案視窗',
	'sf_property_isproperty' => '這是$1型態的性質。',
	'sf_property_linkstoform' => '連結至使用$1表單的頁面。(It links to pages that use the form $1.)',
	'sf_property_allowedvals' => '此屬性的可用型態為：',
	'sf_template_docu' => "這是'$1'樣板，它須以如下的格式引用：",
	'sf_template_docufooter' => '編輯此頁以查看樣板文字。',
	'sf_form_docu' => "這是'$1'表單，編輯此頁以查看原始碼，您能以此表單新增資料[[$2|這裡]]。",
	'sf_form_freetextlabel' => '隨意文字區(Free text)',
	'sf_category_hasdefaultform' => '此項分類使用$1表單。',
	'sf_category_desc' => '這是$1分類',
	'sf_blank_namespace' => '主',
	'right-viewedittab' => '查看頁面的「編輯」頁籤(該頁面皆可使用表單予以編輯)',
	'right-editrestrictedfields' => '編輯受限制的表單欄位(restricted form fields)',
);

