#!/usr/bin/env python
# encoding: utf-8
"""
da.py

Created by 苏 晔俊 on 2012-05-12.
Copyright (c) 2012 . All rights reserved.
"""

import logging

from bson.objectid import ObjectId

from leo.store import db_client as db
from leo.store import redis_client as r

"""helper methods"""

def _encode_doc(doc):
    """encode doc with utf-8 to cache into redis"""
    cache_obj = dict()
    for k,v in doc.iteritems():
        if isinstance(v, list) or isinstance(v,dict):
            continue
        
        if isinstance(v, str):
            cache_obj[k] = v.encode("utf-8")
        else:
            cache_obj[k] = v
    return cache_obj

def _decode_doc(doc):
    """decode doc fetched from redis with utf-8"""
    for k,v in doc.iteritems():
        doc[k] = v.decode("utf-8")
    return doc
    
"""general data access methods"""

def GetKindByNum(docs, num):
    """fetch from cache first, then from db if not found"""
    cache_key = docs.name+"_"+str(num)
    cache_doc = r.hgetall(cache_key)
    if cache_doc:
        doc = _decode_doc(cache_doc)
        return doc
    else:
        doc = docs.find_one({"num": int(num)})
        if doc:
            #put into cache, only cache basic type
            cache_doc = _encode_doc(doc)
            r.hmset(cache_key, cache_doc)
            r.expire(cache_key, 86400)
            return doc
        else:
            return None

def GetKindByName(docs, name):
    """fetch from cache first, then from db if not found"""
    cache_key = docs.name+"::"+name
    cache_doc = r.hgetall(cache_key)
    if cache_doc:
        doc = _decode_doc(cache_doc)
        return doc
    else:
        doc = docs.find_one({"name":name})
        if doc:
            #put into cache, only cache basic type
            cache_doc = _encode_doc(doc)
            r.hmset(cache_key, cache_doc)
            r.expire(cache_key, 86400)
            return doc
        else:
            return None   

def UpdateKindByObjectId(docs, objId, update_fields):
    """update fields in db and remove from cache"""
    new_doc = docs.update({"_id":ObjectId(objId)}, {"$set":update_fields}, safe = True)

def IncKindByObjectId(docs, objId, update_fields):
    """update fields in db and remove from cache"""
    new_doc = docs.update({"_id":ObjectId(objId)}, {"$inc":update_fields}, safe = True)


"""special helper methods"""

def GetSite():
    """fetch site from cache, then from db if not found"""
    cache_key = "site"
    one = r.hgetall(cache_key)
    if one:
        return one
    else:
        one = db.site.find_one()
        if one:
            r.hmset(cache_key, one)
            r.expire(cache_key, 86400 * 30)
            return one
        else:
            return None

def GetCounter():
    """fetch site from cache, then from db if not found"""
    cache_key = "counter"
    one = r.hgetall(cache_key)
    if one:
        return one
    else:
        one = db.counter.find_one()
        if one:
            r.hmset(cache_key, one)
            r.expire(cache_key, 86400 * 30)
            return one
        else:
            return None

def IncCounter(field_name):
    """inc field_name of Counter"""
    db.counter.update({"_id":{"$exists":True}}, {"$inc":{field_name:1}}, upsert=True, safe=True)
    r.delete("counter")    