#!/usr/bin/env python
# encoding: utf-8
"""
form.py

Created by 苏 晔俊 on 2012-05-12.
Copyright (c) 2012 . All rights reserved.
"""

import tornado.locale
from wtforms import *

class MyTranslations(object):
    def __init__(self, tornado_locale_obj):
        self.locale_obj = tornado_locale_obj

    def gettext(self, string):
        return self.locale_obj.translate(string)

    def ngettext(self, singular, plural, n):
        return self.locale_obj.translate(singular, plural_message=plural, count=n)

class BaseForm(Form):
    def _get_translations(self):
        locale_obj = tornado.locale.get('zh_CN')
        return MyTranslations(locale_obj)