#!/usr/bin/env python
# encoding: utf-8
"""
handler.py

Created by 苏 晔俊 on 2012-05-11.
Copyright (c) 2012 . All rights reserved.
"""
import tornado.web

#data
from leo.store import db_client as db
from leo.store import redis_client as r
from leo.da import *
from leo.security import *

#handler
from leo.route import route
from leo.handler import *

#util
from leo.pagination import Pagination

class BaseHandler(tornado.web.RequestHandler):
    @property
    def per_page(self):
        return 10
        
    def render(self,template_name,template_values):
        name = template_name + '.html'

        if self.settings['xsrf_cookies']:
            template_values['xsrf_form_html'] = self.xsrf_form_html()
        
        template = self.application.env.get_template(name)
        self.write(template.render(**template_values))


class FormWrapper(object):
    def __init__(self, handler):
        self.handler = handler

    def __iter__(self):
        return iter(self.handler.request.arguments)

    def __len__(self):
        return len(self.handler.request.arguments)

    def __contains__(self, name):
        # We use request.arguments because get_arguments always returns a
        # value regardless of the existence of the key.
        return (name in self.handler.request.arguments)

    def getlist(self, name):
        # get_arguments by default strips whitespace from the input data,
        # so we pass strip=False to stop that in case we need to validate
        # on whitespace.
        return self.handler.get_arguments(name, strip=False)