#!/usr/bin/env python
# encoding: utf-8
"""
pagination.py

Created by 苏 晔俊 on 2012-05-26.
Copyright (c) 2012 . All rights reserved.
"""

from math import ceil

class Pagination(object):

    def __init__(self, page, per_page, total_count):
        self.page = page
        self.per_page = per_page
        self.total_count = total_count

    @property
    def pages(self):
        total = int(ceil(self.total_count / float(self.per_page)))
        if total==0:
            return 1
        else:
            return total

    @property
    def has_prev(self):
        return self.page > 1

    @property
    def has_next(self):
        return self.page < self.pages

    def iter_pages(self, left_edge=2, left_current=2,
                   right_current=5, right_edge=2):
        last = 0
        for num in xrange(1, self.pages + 1):
            if num <= left_edge or \
               (num > self.page - left_current - 1 and \
                num < self.page + right_current) or \
               num > self.pages - right_edge:
                if last + 1 != num:
                    yield None
                yield num
                last = num