#!/usr/bin/env python
# encoding: utf-8
"""
route.py

Created by 苏 晔俊 on 2012-05-26.
Copyright (c) 2012 . All rights reserved.
"""

import logging
import tornado.web

class route(object):
    """decorates RequestHandlers and builds up a list of routable handlers"""

    _routes = []

    def __init__(self, uri, name=None):
        self._uri = uri
        self.name = name

    def __call__(self, _handler):
        """called when class decorated"""
        name = self.name or _handler.__name__
        route = tornado.web.URLSpec(self._uri, _handler, name=self.name)
        self._routes.append(route)
        return _handler

    @classmethod
    def get_routes(self):
        return self._routes
