#!/usr/bin/env python
# encoding: utf-8
"""
security.py

Created by 苏 晔俊 on 2012-05-12.
Copyright (c) 2012 . All rights reserved.
"""

from leo.store import db_client as db
from leo.store import redis_client as r
from leo.da import GetKindByNum

def CheckAuth(handler):
    """fetch member"""
    ip = handler.request.remote_ip
    auth = handler.get_cookie("auth")
    if auth:
        auth_key = "auth"+":"+auth
        member_num = r.get(auth_key)
        if member_num:
            #fetch member with num
            member = GetKindByNum(db.members, member_num)
            if member:
                member["ip"] = ip
                return member
            else:
                return False
        else:
            #fetch member with auth
            member = db.members.find_one({"auth":auth})
            if member:
                r.set(auth_key, member["num"])
                member["ip"] = ip
                return member
    else:
        return False

