#!/usr/bin/env python
# encoding: utf-8
"""
store.py

Created by 苏 晔俊 on 2012-05-12.
Copyright (c) 2012 . All rights reserved.
"""

import logging

#tornado
from tornado.options import options

#mongodb
import pymongo
from pymongo.son_manipulator import AutoReference, NamespaceInjector
conn=pymongo.Connection("localhost",27017)
db_client=conn[options.database]
db_client.add_son_manipulator(NamespaceInjector())  
db_client.add_son_manipulator(AutoReference(db_client))  

#redis
import redis
pool=redis.ConnectionPool(host='localhost', port=6379, db=0)
redis_client=redis.Redis(connection_pool=pool)

def init_db():
    """init database"""
    if db_client.site.count()==0:
        site_doc={
            "name" : "leo",
            "title" : "Project Leo",
            "description" : "Tornado based society"
        }
        db_client.site.insert(site_doc)

    if db_client.nodes.count()==0:
        node_docs=[
            {
                "name" : "match",
                "title" : "比赛"
            },
            {
                "name" : "training",
                "title" : "训练"
            },
            {
                "name" : "chat",
                "title" : "谈天说地"
            }
        ]
        db_client.nodes.insert(node_docs)
    
    # set max id for each collection
    max_id = db_client.members.count()
    redis_client.set("members", max_id)
    
    max_id = db_client.topics.count()
    redis_client.set("topics", max_id)
    