#!/usr/bin/env python
# encoding: utf-8
"""
util.py

Created by 苏 晔俊 on 2012-05-11.
Copyright (c) 2012 . All rights reserved.
"""

def convert_bytes(value):
    """convert bytes to readable size, eg. 1024bytes=1M"""
    bytes = float(value)
    if bytes >= 1099511627776:
        terabytes = bytes / 1099511627776
        size = '%.2fT' % terabytes
    elif bytes >= 1073741824:
        gigabytes = bytes / 1073741824
        size = '%.2fG' % gigabytes
    elif bytes >= 1048576:
        megabytes = bytes / 1048576
        size = '%.2fM' % megabytes
    elif bytes >= 1024:
        kilobytes = bytes / 1024
        size = '%.2fK' % kilobytes
    else:
        size = '%.2fb' % bytes
    return size

def format_datetime(value):
    from datetime import datetime
    if isinstance(value, datetime):
        return value.strftime("%Y-%m-%d %H:%M:%S")
    else:
        return ""