# -*- coding: utf-8 -*-
import os

from pagador.configuracao.cadastro import CampoFormulario, FormularioBase, TipoDeCampo
from pagador.configuracao.cliente import Script, TipoScript

eh_aplicacao = True


def caminho_do_arquivo_de_template(arquivo):
    diretorio = os.path.dirname(os.path.realpath(__file__))
    return os.path.join(diretorio, "templates", arquivo)


class MeioPagamentoCadastro(object):
    @property
    def registro(self):
        script = Script(tipo=TipoScript.html, nome="registro")
        script.adiciona_linha(u'Ainda não tem conta no MercadoPago?<br/>')
        script.adiciona_linha('<a href="//registration-br.mercadopago.com/registration-mp?mode=mp" title="Criar conta MercadoPago" class="btn btn-info btn-xs" target="_blank">cadastre-se</a>')
        return script

    def to_dict(self):
        return [
            self.registro.to_dict()
        ]

PARCELAS = [(0, "Todas"), (1, 1), (3, 3), (6, 6), (9, 9), (12, 12), (15, 15), (24, 24)]

class Formulario(FormularioBase):
    mostrar_parcelamento = CampoFormulario("mostrar_parcelamento", "Marque para mostrar o parcelamento na listagem dos produtos e na página do produto.", tipo=TipoDeCampo.boleano, requerido=False, ordem=1)
    maximo_parcelas = CampoFormulario("maximo_parcelas", "Máximo de parcelas", tipo=TipoDeCampo.escolha, requerido=False, ordem=2, texto_ajuda=u"Quantidade máxima de parcelas para esta forma de pagamento.", opcoes=PARCELAS)
    parcelas_sem_juros = CampoFormulario("parcelas_sem_juros", "Parcelas sem juros", tipo=TipoDeCampo.escolha, requerido=False, ordem=3, texto_ajuda=u"Número de parcelas sem juros para esta forma de pagamento.", opcoes=PARCELAS)


class MeioPagamentoEnvio(object):
    @property
    def css(self):
        return Script(tipo=TipoScript.css, caminho_arquivo=caminho_do_arquivo_de_template("style.css"))

    @property
    def function_enviar(self):
        return Script(tipo=TipoScript.javascript, eh_template=True, caminho_arquivo=caminho_do_arquivo_de_template("javascript.js"))

    @property
    def mensagens(self):
        return Script(tipo=TipoScript.html, caminho_arquivo=caminho_do_arquivo_de_template("mensagens.html"))

    def to_dict(self):
        return [
            self.css.to_dict(),
            self.function_enviar.to_dict(),
            self.mensagens.to_dict()
        ]


class MeioPagamentoSelecao(object):
    logo = Script(tipo=TipoScript.html, nome="logo", conteudo=u'<img src="{{ STATIC_URL }}novo-template/img/bandeiras/mercadopago.png" title="Mercado Pago" alt="Mercado Pago">', eh_template=True)

    @property
    def bandeiras(self):
        bandeiras = Script(tipo=TipoScript.html, nome="explicativo")
        bandeiras.adiciona_linha('<ul class="bandeiras-pagamento">')
        bandeiras.adiciona_linha('    <li><i class="icone-pagamento visa" title="Visa"></i></li>')
        bandeiras.adiciona_linha('    <li><i class="icone-pagamento mastercard" title="Mastercard"></i></li>')
        bandeiras.adiciona_linha('    <li><i class="icone-pagamento amex" title="Amex"></i></li>')
        bandeiras.adiciona_linha('    <li><i class="icone-pagamento elo" title="Elo"></i></li>')
        bandeiras.adiciona_linha('    <li><i class="icone-pagamento hipercard" title="Hipercard"></i></li>')
        bandeiras.adiciona_linha('    <li><i class="icone-pagamento boleto" title="Hipercard"></i></li>')
        bandeiras.adiciona_linha('    </ul>')
        return bandeiras

    def to_dict(self):
        return [
            self.logo.to_dict(),
            self.bandeiras.to_dict()
        ]
