# -*- coding: utf-8 -*-

import urllib

from pagador import settings
from pagador.envio.models import SituacaoPedido
from pagador.envio.requisicao import Enviar
from pagador.retorno.registro import RegistrarPagamento
from pagador_paypal.extensao.envio import ExpressCheckout, ExpressCheckoutDetails
from pagador_paypal.extensao.seguranca import ParametrosPayPal


class TipoAck(object):
    Sucesso = "success"
    Falha = "failure"


# class Metodo(object):
#     express_checkout = "SetExpressCheckout"
#     checkout_details = "GetExpressCheckoutDetails"


class EnviarPedido(Enviar):
    def __init__(self, pedido, dados, configuracao_pagamento):
        super(EnviarPedido, self).__init__(pedido, dados, configuracao_pagamento)
        ExpressCheckout.cria_payment_request()
        ExpressCheckout.cria_shipto()
        for item in range(0, len(self.pedido.itens.all())):
            ExpressCheckout.cria_item_payment_request(item)
        self.exige_autenticacao = True
        self.processa_resposta = True
        self.url = "https://api-3t.{}paypal.com/nvp".format("sandbox." if settings.DEBUG else "")
        self.grava_identificador = False
        self.headers = {"Content-Type": "application/x-www-form-urlencoded; charset=utf-8"}
        self.envio_por_querystring = True

    def gerar_dados_de_envio(self):
        notification_url = settings.PAYPAL_NOTIFICATION_URL.format(self.pedido.conta_id)
        parametros = ParametrosPayPal("paypal", id=self.pedido.conta_id)
        express_checkout = ExpressCheckout(
            user=parametros.username,
            pwd=parametros.password,
            signature=parametros.signature,
            buttonsource=parametros.button_source,
            email=self.pedido.cliente.email,
            returnurl="{}/success?next_url={}&referencia={}".format(notification_url, self.dados["next_url"], self.pedido.numero),
            cancelurl="{}/failure?next_url={}&referencia={}".format(notification_url, self.dados["next_url"], self.pedido.numero),
            version=settings.PAYPAL_VERSION,
            method="SetExpressCheckout",
            localecode='pt_BR',

            paymentrequest_0_paymentaction='SALE',
            paymentrequest_0_notifyurl=notification_url,
            paymentrequest_0_amt=self.formatador.formata_decimal(self.pedido.valor_total),
            paymentrequest_0_shippingamt=self.formatador.formata_decimal(self.pedido.valor_envio),
            paymentrequest_0_currencycode="BRL",
            paymentrequest_0_itemamt=self.formatador.formata_decimal(self.pedido.valor_subtotal),
            paymentrequest_0_invnum=self.pedido.numero,

            paymentrequest_0_shiptoname=self.pedido.endereco_entrega.nome,
            paymentrequest_0_shiptostreet="{}, {} {}".format(self.pedido.endereco_entrega.endereco, self.pedido.endereco_entrega.numero, self.pedido.endereco_entrega.complemento),
            paymentrequest_0_shiptostreet2=self.pedido.endereco_entrega.bairro,
            paymentrequest_0_shiptocity=self.pedido.endereco_entrega.cidade,
            paymentrequest_0_shiptostate=self.pedido.endereco_entrega.estado,
            paymentrequest_0_shiptozip=self.pedido.endereco_entrega.cep,
            paymentrequest_0_shiptocountrycode="BR",
            paymentrequest_0_shiptophonenum=self.pedido.cliente.telefone_principal
        )
        for indice, item in enumerate(self.pedido.itens.all()):
            self.define_valor_de_atributo_de_item(express_checkout, "NAME", indice, item.nome[:127])
            self.define_valor_de_atributo_de_item(express_checkout, "DESC", indice, self.descricao_completa_de_item(item))
            self.define_valor_de_atributo_de_item(express_checkout, "AMT", indice, self.formatador.formata_decimal(item.preco_venda))
            self.define_valor_de_atributo_de_item(express_checkout, "QTY", indice, self.formatador.formata_decimal(item.quantidade))
            self.define_valor_de_atributo_de_item(express_checkout, "NUMBER", indice, item.sku[:127])
            self.define_valor_de_atributo_de_item(express_checkout, "ITEMURL", indice, item.produto.get_absolute_url())
        return express_checkout.to_dict()

    def define_valor_de_atributo_de_item(self, express_checkout, atributo, indice, valor):
        nome = "L_PAYMENTREQUEST_0_{}{}".format(atributo, indice)
        express_checkout.define_valor_de_atributo(nome, {nome.lower(): valor})

    @property
    def items(self):
        return []

    def obter_situacao_do_pedido(self, status_requisicao):
        return None

    def processar_resposta(self, resposta):
        content = resposta.content
        retorno = {}
        if content:
            content = urllib.unquote(content).decode('utf8')
            retorno = {par.split("=")[0].lower(): par.split("=")[1].lower() for par in content.split("&")}
        if "ack" in retorno and retorno["ack"] == TipoAck.Sucesso:
            url = "https://www.{}paypal.com/cgi-bin/webscr?cmd=_express-checkout&token={}".format(("sandbox." if settings.DEBUG else ""), retorno["token"])
            return {"content": {"url": url}, "status": 200, "reenviar": False, "identificador": retorno["token"]}

        return {"content": retorno, "status": 500, "reenviar": False}

    def descricao_completa_de_item(self, item):
        if item.produto.descricao_completa:
            return item.produto.descricao_completa[:127]
        return ""
