//{% load filters %}
var url = '';
var $counter = null;
var segundos = 5;
$(function() {
    var $payPalMensagem = $(".paypal-mensagem");

    function iniciaContador() {
        $counter = $payPalMensagem.find(".segundos");
        setInterval('if (segundos > 0) { $counter.text(--segundos); }', 1000);
    }
    var mensagemDeErroPadrao = "Ocorreu um erro ao enviar sua solicitação. Se o erro persistir, contate nosso SAC.";

    function enviaPagamento() {
        $payPalMensagem.find(".msg-danger").hide();
        $payPalMensagem.find(".msg-success").hide();
        $payPalMensagem.find(".msg-warning").show();
        $payPalMensagem.removeClass("alert-message-success");
        $payPalMensagem.removeClass("alert-message-danger");
        $payPalMensagem.addClass("alert-message-warning");
        var url_pagar = '{% url_loja "checkout_pagador" pedido.numero pagamento.id %}?next_url=' + window.location.href.split("?")[0];
        $.getJSON(url_pagar)
            .fail(function (data) {
                if ('{{ settings.DEBUG }}' == 'True') {
                    exibeMensagemErro(data.status, data.content);
                }
                else {
                    exibeMensagemErro(data.status, mensagemDeErroPadrao);
                }
            })
            .done(function (data) {
                if (data.sucesso) {
                    $("#aguarde").hide();
                    $("#redirecting").show();
                    url = data.content.url;
                    iniciaContador();
                    setTimeout('window.location = url;', 5000);
                }
                else {
                    if (data.content.hasOwnProperty("l_errorcode0")) {
                        exibeMensagemErro(data.content["l_errorcode0"], data.content["l_shortmessage0"] + " - " + data.content["l_longmessage0"]);
                    }
                    else if (data.status == 404) {
                        var fatal = false;
                        if (data.content.hasOwnProperty("fatal")) {
                            fatal = data.content.fatal;
                        }
                        exibeMensagemErro(data.status, data.content.mensagem, fatal);
                    }
                    else if (data.content.hasOwnProperty("erro")) {
                        exibeMensagemErro(data.status, data.content.erro);
                    }
                    else {
                        if ('{{ settings.DEBUG }}' == 'True') {
                            exibeMensagemErro(data.status, data.content);
                        }
                        else {
                            exibeMensagemErro(data.status, mensagemDeErroPadrao);
                        }
                    }
                }
            });
    }

    $(".msg-danger").on("click", ".pagar", function() {
        enviaPagamento();
    });

    $(".msg-success").on("click", ".ir-mp", function() {
        window.location = url;
    });

    $(".msg-danger").on("click", "#exibeDetalhesDoErro", function() {
        $("#detalheErro").show();
    });

    function exibeMensagemErro(status, mensagem, fatal) {
        $payPalMensagem.find(".msg-warning").hide();
        $payPalMensagem.toggleClass("alert-message-warning alert-message-danger");
        var $errorMessage = $("#errorMessage");
        if (status == 585) {
            $errorMessage.text(mensagem);
        }
        else {
            var $detalheErro = $("#detalheErro");
            var $exibeDetalhesDoErro = $("#exibeDetalhesDoErro");
            $detalheErro.text(mensagem);
            $exibeDetalhesDoErro.show();
            $errorMessage.text(status + ": " + mensagemDeErroPadrao);
        }
        $payPalMensagem.find(".msg-danger").show();
        if (fatal) {
            $(".pagar").remove();
            $(".click").remove();
        }
    }

    function exibeMensagemSucesso(situacao) {
        $payPalMensagem.find(".msg-warning").hide();
        $payPalMensagem.toggleClass("alert-message-warning alert-message-success");
        var $success = $payPalMensagem.find(".msg-success");
        $success.find("#redirecting").hide();
        if (situacao == "pago") {
            $success.find("#successMessage").show();
        }
        else {
            $success.find("#pendingMessage").show();
        }
        $success.show();
    }

    var pedidoPago = '{{ pedido.situacao_id }}' == '4';
    var pedidoAguardandoPagamento = '{{ pedido.situacao_id }}' == '2' || '{{ pedido.situacao_id }}' == '3';

    if (window.location.search != "" && window.location.search.indexOf("failure") > -1) {
        exibeMensagemErro(585, "Pagamento cancelado no PayPal!");
    }
    else if (window.location.search != "" && window.location.search.indexOf("success") > -1 || pedidoPago) {
        exibeMensagemSucesso("pago");
    }
    else if (window.location.search != "" && window.location.search.indexOf("pending") > -1 || pedidoAguardandoPagamento) {
        exibeMensagemSucesso("aguardando");
    }
    else {
        enviaPagamento();
    }
});
