# -*- coding: utf-8 -*-
import json

import requests
from pagador.envio import notificador
from pagador.envio.models import Pedido
from pagador.extensao.base import Plugavel, PluginNaoEncontrado
from pagador.seguranca.autenticador import Credenciais
from repositories.pedido.models import PedidoVendaSituacao


class EnviarPedido(Plugavel):
    def __init__(self, meio_pagamento, pedido_numero, dados, conta_id, configuracao_pagamento=None):
        self.meio_pagamento = meio_pagamento
        self.pedido = Pedido.objects.get(numero=pedido_numero, conta_id=conta_id)
        self.dados = dados
        self.configuracao_pagamento = configuracao_pagamento
        self.headers = {"Content-Type": "application/json"}
        self._requisicao = None

    def processar_resposta(self, resposta):
        if getattr(self.requisicao, "processa_resposta", False):
            return self.requisicao.processar_resposta(resposta)
        return {"data": resposta.content, "status": resposta.status_code}

    @property
    def requisicao(self):
        if not self._requisicao:
            try:
                self._requisicao = self.plugin_requisicao.EnviarPedido(self.pedido, self.dados)
            except AttributeError, ex:
                raise PluginNaoEncontrado(u"O meio de pagamento '{}' não possui a classe requisicao.EnviarPedido.".format(self.meio_pagamento))
        return self._requisicao

    def post(self):
        if getattr(self.requisicao, "usa_autenticacao", False):
            credenciador = Credenciais(self.meio_pagamento, self.configuracao_pagamento)
            self.headers.update(credenciador.por_cabecalho_http())
        dados = self.requisicao.dados
        if type(dados is dict):
            dados = json.dumps(dados)
        resposta = requests.post(self.requisicao.url, data=dados, headers=self.headers)
        return self.processar_resposta(resposta)

    def enviar(self):
        resultado = self.post()
        if resultado["status"] == 200:
            notificador.envia_alteracao_de_situacao_de_pedido(self.pedido.numero, PedidoVendaSituacao.SITUACAO_PEDIDO_PAGO)
        else:
            notificador.envia_alteracao_de_situacao_de_pedido(self.pedido.numero, PedidoVendaSituacao.SITUACAO_PEDIDO_CANCELADO)
        return resultado
