# -*- coding: utf-8 -*-
import json
from django.db import IntegrityError
from flask import request, logging

from flask.ext import restful

from pagador import MeioDePagamentoNaoEncontrado, MeioDePagamentoNaoDefinido
from pagador.configuracao.models import FormaDePagamento, FormaDePagamentoConfiguracao
from pagador.envio.requisicao import EnviarPedido
from pagador.extensao.base import PluginNaoEncontrado


logger = logging.getLogger("API-PAGADOR")


class HelloWorld(restful.Resource):
    def get(self):
        return {"hello": "world pagador"}


class FormasPagamentoResource(restful.Resource):
    def get(self):
        conta_id = request.args.get('conta_id', None)
        com_configuracao = False
        if conta_id:
            com_configuracao = True
            formas_pagamento = FormaDePagamento.configuracoes_ativas(conta_id=conta_id)
        else:
            formas_pagamento = FormaDePagamento.objects.filter(ativo=True)
        return {"formas_pagamento": [forma.to_dict(com_configuracao=com_configuracao) for forma in formas_pagamento]}


class PagamentoBaseResource(restful.Resource):
    def __init__(self):
        self.pagamento_id = None
        self._forma_de_pagamento = None

    def retorno(self, pagamento_id=None):
        if pagamento_id:
            self.pagamento_id = pagamento_id
        if self.retorno_tem_erro:
            status = self.forma_de_pagamento["status"]
            del self.forma_de_pagamento["status"]
            return self.forma_de_pagamento, status
        return self.forma_de_pagamento, 200

    @property
    def retorno_tem_erro(self):
        return "erro" in self.forma_de_pagamento

    @property
    def forma_de_pagamento(self):
        if not self._forma_de_pagamento:
            try:
                self._forma_de_pagamento = FormaDePagamento.objects.get(id=self.pagamento_id, ativo=True).to_dict(com_configuracao=False)
            except FormaDePagamento.DoesNotExist:
                self._forma_de_pagamento = {"erro": u"Não foi encontrada forma de pagamento ativa com id {}".format(self.pagamento_id), "status": 404}
        return self._forma_de_pagamento


class FormaPagamentoResource(PagamentoBaseResource):
    def get(self, pagamento_id):
        return self.retorno(pagamento_id)


class FormaPagamentoConfiguracaoResource(PagamentoBaseResource):
    def get(self, pagamento_id, conta_id):
        self.pagamento_id = pagamento_id
        pagamento = self.forma_de_pagamento
        if self.retorno_tem_erro:
            return self.retorno()
        try:
            pagamento_configuracao, criado = FormaDePagamentoConfiguracao.objects.get_or_create(
                conta_id=conta_id,
                forma_pagamento_id=pagamento["id"]
            )
            #FIXME: Melhorar isso. Tornar o Resource menos conhecedor dessa regra
            return pagamento_configuracao.to_dict()
        except (MeioDePagamentoNaoDefinido, MeioDePagamentoNaoEncontrado, PluginNaoEncontrado), ex:
            return {"erro": u"pagador: {}".format(ex)}, 500
        except IntegrityError, ex:
            return {"erro": "Erro no banco de dados: {}".format(ex)}, 500

    #FIXME: ALERTA!!! ALERTA!!! SEM TESTES!!! ALERTA!!! ALERTA!!!
    def post(self, pagamento_id, conta_id):
        dados = request.get_json()
        try:
            pagamento_configuracao, criado = FormaDePagamentoConfiguracao.objects.get_or_create(
                conta_id=conta_id,
                forma_pagamento_id=pagamento_id,
            )
            pagamento_configuracao.salvar(dados)
        except (MeioDePagamentoNaoDefinido, MeioDePagamentoNaoEncontrado, PluginNaoEncontrado), ex:
            return {"erro": u"pagador: {}".format(ex)}, 500
        except IntegrityError, ex:
            return {"erro": "Erro no banco de dados: {}".format(ex)}, 500


#FIXME: ALERTA!!! ALERTA!!! SEM TESTES!!! ALERTA!!! ALERTA!!!
class FormaPagamentoScriptResource(PagamentoBaseResource):
    def get(self, pagamento_id, conta_id):
        self.pagamento_id = pagamento_id
        pagamento = self.forma_de_pagamento
        if self.retorno_tem_erro:
            return self.retorno()
        try:
            pagamento_configuracao = FormaDePagamentoConfiguracao.objects.get(
                conta_id=conta_id,
                forma_pagamento_id=pagamento["id"]
            )
            return {"scripts": pagamento_configuracao.script.to_dict()}
        except (MeioDePagamentoNaoDefinido, MeioDePagamentoNaoEncontrado, PluginNaoEncontrado), ex:
            return {"erro": u"pagador: {}".format(ex)}, 500
        except IntegrityError, ex:
            return {"erro": "Erro no banco de dados: {}".format(ex)}, 500


#FIXME: ALERTA!!! ALERTA!!! SEM TESTES!!! ALERTA!!! ALERTA!!!
class FormaPagamentoSelecaoResource(PagamentoBaseResource):
    def get(self, pagamento_id, conta_id):
        self.pagamento_id = pagamento_id
        pagamento = self.forma_de_pagamento
        if self.retorno_tem_erro:
            return self.retorno()
        try:
            pagamento_configuracao = FormaDePagamentoConfiguracao.objects.get(
                conta_id=conta_id,
                forma_pagamento_id=pagamento["id"]
            )
            return {"scripts": pagamento_configuracao.selecao.to_dict()}
        except (MeioDePagamentoNaoDefinido, MeioDePagamentoNaoEncontrado, PluginNaoEncontrado), ex:
            return {"erro": u"pagador: {}".format(ex)}, 500
        except IntegrityError, ex:
            return {"erro": "Erro no banco de dados: {}".format(ex)}, 500


#FIXME: ALERTA!!! ALERTA!!! SEM TESTES!!! ALERTA!!! ALERTA!!!
class FormaPagamentoConfiguracaoEnviarResource(PagamentoBaseResource):
    def post(self, pagamento_id, conta_id, pedido_numero):
        dados = {}
        if request.data:
            dados = json.loads(request.data)
        self.pagamento_id = pagamento_id
        pagamento = self.forma_de_pagamento
        if self.retorno_tem_erro:
            return self.retorno()
        try:
            pagamento_configuracao = FormaDePagamentoConfiguracao.objects.get(
                conta_id=conta_id,
                forma_pagamento_id=pagamento["id"]
            )
            enviar_pedido = EnviarPedido(pagamento["codigo"], pedido_numero, dados, conta_id, pagamento_configuracao)
            return enviar_pedido.enviar()
        except (MeioDePagamentoNaoDefinido, MeioDePagamentoNaoEncontrado, PluginNaoEncontrado), ex:
            return {"erro": u"pagador: {}".format(ex)}, 500
        except IntegrityError, ex:
            return {"erro": "Erro no banco de dados: {}".format(ex)}, 500
        except Exception, ex:
            return {"erro": u"Servidor: {}".format(ex)}, 500
