# -*- coding: utf-8 -*-


class TipoDeCampo(object):
    texto = "CharField"
    boleano = "BooleanField"


class CampoFormulario(object):
    def __init__(self, nome, label, descricao=None, requerido=False, tipo=TipoDeCampo.texto, tamanho_min=None, tamanho_max=None, ordem=0):
        self.ordem = ordem
        self.nome = nome
        self.label = label
        self.descricao = descricao
        self.requerido = requerido
        self.tipo = tipo
        self.tamanho_min = tamanho_min
        self.tamanho_max = tamanho_max

    def to_dict(self):
        return {
            "nome": self.nome,
            "ordem": self.ordem,
            "label": self.label,
            "descricao": self.descricao,
            "requerido": self.requerido,
            "tipo": self.tipo,
            "tamanho_min": self.tamanho_min,
            "tamanho_max": self.tamanho_max
        }