# -*- coding: utf-8 -*-
import json
import requests
from pagador import settings


def envia_alteracao_de_situacao_de_pedido(pedido_numero, situacao):
    url = "{}pedido/{}/situacao/{}".format(settings.QUEUE_URL, pedido_numero, situacao)
    return requests.put(url)


def grava_evidencia_envio(meio_pagamento, para, dados, resposta):
    if settings.GRAVA_EVIDENCIA:
        evidencia = {
            "tipo_evidencia": "pagador-envio",
            "evidencia": {
                "meio_pagamento": meio_pagamento,
                "envio": {
                    "dados": dados,
                    "url":  para
                },
                "resposta": resposta
            }
        }
        try:
            evidencia = json.dumps(evidencia)
            requests.post(settings.EVIDENCIA_URL, data=evidencia, headers={"Content-Type": "application/json"})
        except Exception:
            pass
