# -*- coding: utf-8 -*-
from importlib import import_module
from pagador import settings


class ParametroInstalacaoInvalido(Exception):
    pass


class ModuloNaoEncontrado(Exception):
    pass


class ConfiguracaoInvalida(Exception):
    pass


class Parametros(object):
    def __init__(self, meio_pagamento, argumentos_da_instancia):
        self.meio_pagamento = meio_pagamento
        try:
            parametros = settings.MODULO_PARAMETROS_INSTALACAO
        except AttributeError:
            raise ConfiguracaoInvalida(u"O arquivo de configuração (pagador.settings) não possui o item MODULO_PARAMETROS_INSTALACAO. Por favor verfique a documentação.")
        try:
            modulo = import_module("{}".format(parametros["modulo"]))
        except KeyError:
            raise ParametroInstalacaoInvalido(u"O módulo dos parâmetros não foi encontrado nas configurações. Você esqueceu de inclui-lo em pagador.settings.MODULO_PARAMETROS_INSTALACAO?")
        except ImportError:
            raise ModuloNaoEncontrado(u"Não foi encontrado o modulo '{}' para os paramêtros no ambiente. Use pip install <pacote-modulo-parametros> e tente novamente.".format(parametros["modulo"]))
        try:
            classe = getattr(modulo, parametros["classe"])
        except KeyError:
            raise ParametroInstalacaoInvalido(u"A classe dos parâmetros não foi encontrada nas configurações. Você esqueceu de inclui-la em pagador.settings.MODULO_PARAMETROS_INSTALACAO?")
        try:
            instancia = None
            if parametros["tipo_classe"] == "Django":
                instancia = classe.objects.get(**argumentos_da_instancia)
        except KeyError:
            raise ParametroInstalacaoInvalido(u"O tipo da classe dos parâmetros não foi encontrado nas configurações. Você esqueceu de inclui-lo em pagador.settings.MODULO_PARAMETROS_INSTALACAO?")
        try:
            try:
                conteudo = instancia
                for atributo in parametros["atributo"].split("."):
                    conteudo = getattr(conteudo, atributo)
            except AttributeError:
                raise ParametroInstalacaoInvalido(u"O atributo {} definido em pagador.settings.MODULO_PARAMETROS_INSTALACAO não é membro do classe {}.".format(parametros["atributo"], parametros["classe"]))
            for chave in self.chaves:
                if parametros["tipo_atributo"] == "dict":
                    setattr(self, chave, conteudo[meio_pagamento][chave])
        except KeyError:
            raise ParametroInstalacaoInvalido(u"O atributo ou o tipo do atributo não foi encontrado nas configurações. Você esqueceu de inclui-lo em pagador.settings.MODULO_PARAMETROS_INSTALACAO?")

    @property
    def chaves(self):
        raise NotImplementedError


class Ativador(object):
    def __init__(self, conta_id):
        self.conta_id = conta_id

    def url_ativador(self):
        raise NotImplementedError