# -*- coding: utf-8 -*-

from pagador.extensao import base


class CredenciadorInvalido(Exception):
    pass


class AutenticadorNaoEncontrado(Exception):
    pass


class Credenciador(object):
    def __init__(self, credenciamento):
        self.credenciamento = credenciamento

    def obter_credenciais(self):
        return "user {token} password {senha}".format(self.credenciamento)

    def esta_valido(self):
        return True


class Credenciais(base.Plugavel):
    def __init__(self, meio_pagamento, configuracao_pagamento):
        self.meio_pagamento = meio_pagamento
        self.configuracao_pagamento = configuracao_pagamento
        self._credenciador = None

    @property
    def credenciador(self):
        if not self._credenciador:
            try:
                self._credenciador = self.plugin_seguranca.Credenciador(self.configuracao_pagamento)
            except AttributeError:
                raise AutenticadorNaoEncontrado(u"O meio de pagamento '{}' não possui a classe Credenciador.".format(self.meio_pagamento))
        return self._credenciador

    def esta_valido(self):
        return self.credenciador.esta_valido()

    def por_query_string(self, chave="access_token"):
        try:
            return "{}={}".format(chave, self.credenciador.obter_credenciais())
        except AttributeError:
            raise CredenciadorInvalido(u"O credenciador {}.{} não implementa o método obter_credenciais(credenciamento=None).".format(self.credenciador.__module__, self.credenciador.__class__.__name__))

    def por_cabecalho_http(self, cabecalho="Authorization"):
        try:
            return {cabecalho: self.credenciador.obter_credenciais()}
        except AttributeError:
            raise CredenciadorInvalido(u"O credenciador {}.{} não implementa o método obter_credenciais(credenciamento=None).".format(self.credenciador.__module__, self.credenciador.__class__.__name__))
