# -*- coding: utf-8 -*-

import os

if not 'DJANGO_SETTINGS_MODULE' in os.environ:
    os.environ['DJANGO_SETTINGS_MODULE'] = 'api_pagador.settings'

SECRET_KEY = 'v6q!c(7t@spf&-4a%(awdesf4&b6(!a8z2^a)%^0#+8a9t(7hs'

HOST = '0.0.0.0'
PORT = 5000

DEBUG = False

try:
    from local_settings import *
except:
    pass

LOG_LEVEL = 'DEBUG' if DEBUG else 'ERROR'

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'standard': {
            'format': '%(asctime)s [%(levelname)s] %(name)s: %(message)s'
        },
    },
    'handlers': {
        'default': {
            'level': LOG_LEVEL,
            'class': 'logging.StreamHandler',
            'formatter': 'standard',
            'stream': 'ext://sys.stdout'
        }
    },
    'loggers': {
        '': {
            'handlers': ['default'],
            'level': LOG_LEVEL,
            'propagate': True
        },
        'django.db.backends': {
            'level': LOG_LEVEL,
            'handers': ['default'],
        },
    }
}
