# -*- coding: utf-8 -*-

from pagador import settings
from pagador.extensao.base import Plugavel, PluginNaoEncontrado
from pagador.pedido import notificador
from pagador.retorno.notificador import grava_evidencia_retorno


class RegistroBase(object):
    def __init__(self, dados):
        self.dados = dados
        self.alterar_situacao = False
        self.pedido_numero = None
        self.redireciona_para = None
        self.situacao = None


class RegistrarPagamento(Plugavel):
    def __init__(self, meio_pagamento, dados):
        self.meio_pagamento = meio_pagamento
        self.dados = dados
        self._registrador = None

    @property
    def registrador(self):
        if not self._registrador:
            try:
                self._registrador = self.plugin_retorno.Registro(self.dados)
            except AttributeError:
                raise PluginNaoEncontrado(u"O meio de pagamento '{}' não possui a classe requisicao.EnviarPedido.".format(self.meio_pagamento))
        return self._registrador

    def processar(self, tipo):
        if settings.GRAVA_EVIDENCIA:
            self.dados["tipo"] = tipo
            grava_evidencia_retorno(self.meio_pagamento, self.dados)
        self.registrador.processar(tipo)
        if self.registrador.alterar_situacao and self.registrador.situacao:
            notificador.envia_alteracao_de_situacao_de_pedido(self.registrador.pedido_numero, self.registrador.situacao)
        if self.registrador.redireciona_para:
            return {"redirect": self.registrador.redireciona_para}
        return {"processado": "OK"}
