# -*- coding: utf-8 -*-


class TipoDeCampo(object):
    texto = "CharField"
    boleano = "BooleanField"
    escolha = "ChoiceField"


class CampoFormulario(object):
    def __init__(self, nome, label, bound=True, descricao=None, requerido=False, tipo=TipoDeCampo.texto, tamanho_min=None, tamanho_max=None, ordem=0, texto_ajuda=None, opcoes=(), grupo=None):
        self.bound = bound
        self.ordem = ordem
        self.nome = nome
        self.label = label
        self.descricao = descricao
        self.requerido = requerido
        self.tipo = tipo
        self.tamanho_min = tamanho_min
        self.tamanho_max = tamanho_max
        self.texto_ajuda = texto_ajuda
        self.opcoes = opcoes
        self.grupo = grupo

    def to_dict(self):
        return {
            "nome": self.nome,
            "ordem": self.ordem,
            "label": self.label,
            "bound": self.bound,
            "descricao": self.descricao,
            "requerido": self.requerido,
            "tipo": self.tipo,
            "tamanho_min": self.tamanho_min,
            "tamanho_max": self.tamanho_max,
            "texto_ajuda": self.texto_ajuda,
            "opcoes": self.opcoes,
            "grupo": self.grupo
        }


class FormularioBase(object):
    def __init__(self):
        self._fields = [field for field in dir(self) if field != "fields" and isinstance(getattr(self, field), CampoFormulario)]

    @property
    def fields(self):
        return {field: getattr(self, field) for field in self._fields}

    def to_dict(self):
        return {field: self.fields[field].to_dict() for field in self.fields}

    def define_valores_em_model(self, model, valores):
        model.ativo = valores.get("ativo", False)
        for field in self.fields:
            field = self.fields[field]
            if field.bound:
                setattr(model, field.nome, valores.get(field.nome, None))
        return model


class ValoresBase(FormularioBase):
    def __init__(self, model, formulario):
        self.formulario = formulario
        self.model = model
        super(ValoresBase, self).__init__()

    @property
    def fields(self):
        return self.formulario.fields

    def to_dict(self):
        self_dict = {
            'ativo': {
                'campo': 'ativo',
                'valor': self.model.ativo
            }
        }
        self_dict.update({field: {"campo": self.fields[field].nome, "valor": getattr(self.model, self.fields[field].nome)} for field in self.fields if self.fields[field].bound})
        return self_dict
