# -*- coding: utf-8 -*-
import datetime

from repositories.pedido.models import PedidoVenda, PedidoVendaSituacao


class Pedido(PedidoVenda):
    class Meta:
        proxy = True

    @property
    def provavel_data_entrega(self):
        return self.data_criacao + datetime.timedelta(days=self.prazo_entrega)

    def marcar_pedido_como_pago(self):
        self.alterar_situacao(PedidoVendaSituacao.SITUACAO_PEDIDO_PAGO)

    def marcar_pedido_como_invalido(self):
        self.alterar_situacao(PedidoVendaSituacao.SITUACAO_PEDIDO_CANCELADO)
