# -*- coding: utf-8 -*-
import sys

from werkzeug.serving import run_simple
from werkzeug.wsgi import DispatcherMiddleware
from api_pagador.app import app_pagador
from api_pagador import settings, urls

sys.path.append('./')
urls.registrar()


def define_no_settings(variavel, valor):
    if not hasattr(settings, variavel.upper()):
        setattr(settings, variavel.upper(), valor)

if __name__ == "__main__":
    parent_app = DispatcherMiddleware(app_pagador, {})
    run_simple(settings.HOST, settings.PORT, parent_app)
