# -*- coding: utf-8 -*-
import json
import requests
from pagador import settings


def grava_evidencia_retorno(meio_pagamento, dados):
    evidencia = {
        "tipo_evidencia": "pagador-retorno",
        "evidencia": {
            "meio_pagamento": meio_pagamento,
            "recebido": {
                "dados": dados
            }
        }
    }
    try:
        evidencia = json.dumps(evidencia)
        requests.post(settings.EVIDENCIA_URL, data=evidencia, headers={"Content-Type": "application/json"})
    except Exception:
        pass