# -*- coding: utf-8 -*-
from importlib import import_module
from pagador import settings, MeioDePagamentoNaoDefinido, MeioDePagamentoNaoEncontrado


class Plugavel(object):
    def __getattr__(self, name):
        if name.startswith("plugin_"):
            tipo = name.replace("plugin_", "")
            return self.plugin(tipo)
        return object.__getattribute__(self, name)

    def plugin(self, tipo):
        # try:
        import_meio_pagamento = settings.LIBS_MEIOS_DE_PAGAMENTO[self.meio_pagamento]
        modulo = import_module("{}.{}".format(import_meio_pagamento, tipo))
        return modulo
        # except KeyError:
        #     raise MeioDePagamentoNaoDefinido(u"O meio de pagamento '{}' não foi encontrada nas configurações. Você esqueceu de inclui-la em pagador.settings.LIBS_MEIOS_DE_PAGAMENTO?".format(self.meio_pagamento))
        # except ImportError:
        #     raise MeioDePagamentoNaoEncontrado(u"Não foi encontrado o modulo '{}.{}' para o meio de pagamento '{}' no ambiente.".format(import_meio_pagamento, tipo, self.meio_pagamento))


class PluginNaoEncontrado(Exception):
    pass