# -*- coding: utf-8 -*-
import json
import requests
from pagador import settings


def grava_evidencia_envio(meio_pagamento, para, dados, resposta):
    evidencia = {
        "tipo_evidencia": "pagador-envio",
        "evidencia": {
            "meio_pagamento": meio_pagamento,
            "envio": {
                "dados": dados,
                "url":  para
            },
            "resposta": resposta
        }
    }
    try:
        evidencia = json.dumps(evidencia)
        headers = {"Content-Type": "application/json"}
        if settings.EVIDENCIA_USA_AUTENTICACAO_HEADER:
            headers.update({"Authorization": settings.EVIDENCIA_HEADER_AUTENTICACAO})
        requests.post(settings.EVIDENCIA_URL, data=evidencia, headers=headers)
    except Exception:
        pass
