# -*- coding: utf-8 -*-
import json
import requests
from pagador import settings


def grava_evidencia_retorno(meio_pagamento, dados, tipo_evidencia="pagador-retorno", registrado=False, enviado=None):
    evidencia = {
        "tipo_evidencia": tipo_evidencia,
        "evidencia": {
            "meio_pagamento": meio_pagamento,
            "recebido": {
                "dados": dados
            },
            "enviado": enviado
        }
    }
    if tipo_evidencia == "pagador-retorno":
        evidencia["evidencia"]["found"] = registrado

    try:
        evidencia = json.dumps(evidencia)
        requests.post(settings.EVIDENCIA_URL, data=evidencia, headers={"Content-Type": "application/json"})
    except Exception:
        pass