# -*- coding: utf-8 -*-
import sys

from werkzeug.serving import run_simple
from werkzeug.wsgi import DispatcherMiddleware
from api_pagador import urls
from api_pagador.app import app_pagador
from api_pagador import settings

sys.path.append('./')
app_pagador.config.from_object(settings)
parent_app = DispatcherMiddleware(app_pagador, {})
urls.registrar()

if __name__ == "__main__":
    run_simple(settings.HOST, settings.PORT, parent_app, use_reloader=True, use_debugger=True, processes=4)
