# -*- coding: utf-8 -*-
from xml.etree import ElementTree


class Formatador(object):
    @classmethod
    def formata_data(cls, data, hora=True, iso=False):
        if hora:
            return data.strftime("%Y-%m-%d{}%H:%M:%S".format("T" if iso else " "))
        return data.strftime("%Y-%m-%d")

    @classmethod
    def formata_decimal(cls, valor, como_float=False, como_int=False):
        if como_float:
            return float('{0:.2f}'.format(valor))
        if como_int:
            return int(valor)
        return '{0:.2f}'.format(valor)

    @classmethod
    def converte_tel_em_tupla_com_ddd(cls, telefone):
        return telefone[:2], telefone[2:]

    @classmethod
    def trata_email_com_mais(cls, email):
        if not "+" in email:
            return email
        partes = email.split("@")
        caixa = partes[0].split("+")[0]
        return "{}@{}".format(caixa, partes[1])

    @classmethod
    def dict_para_xml(cls, dados, tem_cabecalho=False):
        if not type(dados) is dict:
            return ""
        if not dados:
            return ""
        documento = []
        if not tem_cabecalho:
            documento.append('<?xml version="1.0" encoding="UTF-8" standalone="yes"?>')
        for chave, valor in dados.iteritems():
            documento.append("<{}>".format(chave))
            if type(valor) is dict:
                documento.append(cls.dict_para_xml(valor, True))
            elif type(valor) is list:
                for parte in valor:
                    documento.append(cls.dict_para_xml(parte, True))
            else:
                documento.append(unicode(valor))
            documento.append("</{}>".format(chave))
        return "".join(documento)

    @classmethod
    def xml_para_dict(cls, content):
        def iterando(elemento):
            resultado = {}
            childrens = elemento.getchildren()
            if len(childrens) > 0:
                if len(elemento.findall(childrens[0].tag)) > 1:
                    resultado[elemento.tag] = []
                else:
                    resultado[elemento.tag] = {}
                for children in childrens:
                    if type(resultado[elemento.tag]) is list:
                        resultado[elemento.tag].append(iterando(children))
                    else:
                        resultado[elemento.tag].update(iterando(children))
            else:

                resultado[elemento.tag] = elemento.text
            return resultado
        root = ElementTree.fromstring(content)
        return iterando(root)
