# -*- coding: utf-8 -*-
import json
import requests
from pagador import settings


def normaliza_conteudo_de_resposta(resposta):
    if "content" in resposta:
        if not type(resposta["content"]) is dict:
            resposta["content"] = {"string": resposta["content"]}


def grava_evidencia_envio(meio_pagamento, para, dados, resposta, conta_id, pedido_numero):
    normaliza_conteudo_de_resposta(resposta)
    evidencia = {
        "tipo_evidencia": "pagador-envio",
        "evidencia": {
            "conta_id": conta_id,
            "pedido_numero": pedido_numero,
            "meio_pagamento": meio_pagamento,
            "envio": {
                "dados": dados,
                "url":  para
            },
            "resposta": resposta
        }
    }
    try:
        evidencia = json.dumps(evidencia)
        headers = {"Content-Type": "application/json"}
        if settings.EVIDENCIA_USA_AUTENTICACAO_HEADER:
            headers.update({"Authorization": settings.EVIDENCIA_HEADER_AUTENTICACAO})
        requests.post(settings.EVIDENCIA_URL, data=evidencia, headers=headers)
    except Exception:
        pass
