# -*- coding: utf-8 -*-


class TipoScript(object):
    javascript = "javascript"
    source = "source"
    html = "html"
    css = "css"


class Script(object):
    def __init__(self, tipo=TipoScript.javascript, nome=None, eh_template=False, conteudo=None, caminho_arquivo=None):
        self.tipo = tipo
        self.nome = nome
        self.eh_template = eh_template
        if conteudo and type(conteudo) is not list:
            self.conteudo = [conteudo]
        else:
            self.conteudo = []
        if caminho_arquivo:
            arquivo = open(caminho_arquivo)
            self.conteudo = [linha.strip() for linha in arquivo]
            arquivo.close()

    def adiciona_linha(self, linha):
        self.conteudo.append(linha)

    def to_dict(self):
        return {
            'tipo': self.tipo,
            'nome': self.nome,
            'conteudo': '\n'.join(self.conteudo),
            'eh_template': self.eh_template
        }
