# -*- coding: utf-8 -*-
from importlib import import_module
from pagador import settings
from pagador.utils import Formatador


class ParametroInstalacaoInvalido(Exception):
    pass


class ModuloNaoEncontrado(Exception):
    pass


class ConfiguracaoInvalida(Exception):
    pass


class InstalacaoNaoFinalizada(Exception):
    pass


class InstaladorBase(object):
    def __init__(self, configuracao):
        self.configuracao = configuracao

    @property
    def formatador(self):
        return Formatador


class Parametros(object):
    def __init__(self, meio_pagamento, **argumentos_da_instancia):
        self.meio_pagamento = meio_pagamento
        self.monta_paramentros(**argumentos_da_instancia)

    def monta_paramentros(self, **argumentos_da_instancia):
        try:
            parametros = settings.MODULO_PARAMETROS_INSTALACAO
        except AttributeError:
            raise ConfiguracaoInvalida(u"O arquivo de configuração (pagador.settings) não possui o item MODULO_PARAMETROS_INSTALACAO. Por favor verfique a documentação.")
        try:
            modulo = import_module("{}".format(parametros["modulo"]))
        except KeyError, ex:
            raise ParametroInstalacaoInvalido(u"O módulo dos parâmetros não foi encontrado nas configurações. Você esqueceu de inclui-lo em pagador.settings.MODULO_PARAMETROS_INSTALACAO?")
        except ImportError:
            raise ModuloNaoEncontrado(u"Não foi encontrado o modulo '{}' para os paramêtros no ambiente. Use pip install <pacote-modulo-parametros> e tente novamente.".format(parametros["modulo"]))
        try:
            classe = getattr(modulo, parametros["classe"])
        except KeyError:
            raise ParametroInstalacaoInvalido(u"A classe dos parâmetros não foi encontrada nas configurações. Você esqueceu de inclui-la em pagador.settings.MODULO_PARAMETROS_INSTALACAO?")
        try:
            if parametros["tipo_classe"] == "Django":
                instancia = classe.objects.get(**argumentos_da_instancia)
            else:
                instancia = classe()
        except KeyError:
            raise ParametroInstalacaoInvalido(u"O tipo da classe dos parâmetros não foi encontrado nas configurações. Você esqueceu de inclui-lo em pagador.settings.MODULO_PARAMETROS_INSTALACAO?")
        try:
            try:
                conteudo = instancia
                for atributo in parametros["atributo"].split("."):
                    conteudo = getattr(conteudo, atributo)
            except AttributeError:
                raise ParametroInstalacaoInvalido(u"O atributo {} definido em pagador.settings.MODULO_PARAMETROS_INSTALACAO não é membro do classe {}.".format(parametros["atributo"], parametros["classe"]))
            if self.meio_pagamento in conteudo:
                #FIXME: só funciona se o parâmetro for um dicionário.
                for chave in self.chaves:
                    if parametros["tipo_atributo"] == "dict":
                        valor = None
                        if chave in conteudo[self.meio_pagamento]:
                            valor = conteudo[self.meio_pagamento][chave]
                        setattr(self, chave, valor)
            else:
                self.monta_paramentros(id=1)
        except KeyError:
            raise ParametroInstalacaoInvalido(u"O atributo ou o tipo do atributo não foi encontrado nas configurações. Você esqueceu de inclui-lo em pagador.settings.MODULO_PARAMETROS_INSTALACAO?")

    @property
    def chaves(self):
        raise NotImplementedError
