# -*- coding: utf-8 -*-
from urllib import quote_plus
from unicodedata import normalize
from xml.etree import ElementTree
from decimal import Decimal


class Formatador(object):
    @classmethod
    def formata_data(cls, data, hora=True, iso=False):
        if hora:
            return data.strftime("%Y-%m-%d{}%H:%M:%S".format("T" if iso else " "))
        return data.strftime("%Y-%m-%d")

    @classmethod
    def formata_cpf(cls, cpf):
        if len(cpf) == 11 and cpf.isdigit():
            return '%s.%s.%s-%s' % (cpf[:3], cpf[3:6], cpf[6:9], cpf[9:])
        return None

    @classmethod
    def formata_cnpj(cls, cnpj):
        if len(cnpj) == 14 and cnpj.isdigit():
            return '%s.%s.%s/%s-%s' % (cnpj[:2], cnpj[2:5], cnpj[5:8], cnpj[8:12], cnpj[12:])
        return None

    @classmethod
    def formata_cpf_cnpj(cls, cpf_cnpj):
        formatado = cls.formata_cpf(cpf_cnpj) or cls.formata_cnpj(cpf_cnpj)
        if not formatado:
            return cpf_cnpj
        return formatado

    @classmethod
    def string_para_url(cls, texto):
        return quote_plus(unicode(texto))

    @classmethod
    def string_para_decimal(cls, valor):
        try:
            return Decimal(valor)
        except ValueError:
            return Decimal(0)

    @classmethod
    def formata_decimal(cls, valor, como_float=False, como_int=False):
        if como_float:
            return float('{0:.2f}'.format(valor))
        if como_int:
            return int(valor)
        return '{0:.2f}'.format(valor)

    @classmethod
    def converte_tel_em_tupla_com_ddd(cls, telefone):
        ddd = telefone[:2]
        numero = telefone[2:]
        if not ddd.isdigit() or not telefone.isdigit():
            return '', ''
        if int(ddd) < 11:
            return '', ''
        if len(numero) < 8 or len(numero) > 9:
            return '', ''
        if numero.startswith("0"):
            return '', ''
        return ddd, numero

    @classmethod
    def trata_email_com_mais(cls, email):
        if not "+" in email:
            return email
        partes = email.split("@")
        caixa = partes[0].split("+")[0]
        return "{}@{}".format(caixa, partes[1])

    @classmethod
    def dict_para_xml(cls, dados, tem_cabecalho=False):
        if not type(dados) is dict:
            return ""
        if not dados:
            return ""
        documento = []
        if not tem_cabecalho:
            documento.append('<?xml version="1.0" encoding="UTF-8" standalone="yes"?>')
        for chave, valor in dados.iteritems():
            documento.append("<{}>".format(chave))
            if type(valor) is dict:
                documento.append(cls.dict_para_xml(valor, True))
            elif type(valor) is list:
                for parte in valor:
                    documento.append(cls.dict_para_xml(parte, True))
            else:
                documento.append(unicode(valor))
            documento.append("</{}>".format(chave))
        return "".join(documento)

    @classmethod
    def xml_para_dict(cls, content):
        def iterando(elemento):
            resultado = {}
            childrens = elemento.getchildren()
            if len(childrens) > 0:
                if len(elemento.findall(childrens[0].tag)) > 1:
                    resultado[elemento.tag] = []
                else:
                    resultado[elemento.tag] = {}
                for children in childrens:
                    if type(resultado[elemento.tag]) is list:
                        resultado[elemento.tag].append(iterando(children))
                    else:
                        resultado[elemento.tag].update(iterando(children))
            else:

                resultado[elemento.tag] = elemento.text
            return resultado
        root = ElementTree.fromstring(content)
        return iterando(root)

    @classmethod
    def trata_unicode_com_limite(cls, texto, limite=None, ascii=False, trata_espaco_duplo=False):
        if not texto:
            return ""
        if type(texto) in [unicode, str]:
            texto = texto.encode("utf-8")
        if ascii:
            texto = cls.string_para_ascii(texto)
        if trata_espaco_duplo:
            texto = " ".join([palavra for palavra in texto.split(" ") if palavra.strip()])
        if limite:
            return texto[:limite]
        return texto

    @classmethod
    def string_para_ascii(cls, texto):
        try:
            return normalize('NFKD', texto.decode('utf-8')).encode('ASCII', 'ignore')
        except UnicodeEncodeError:
            return normalize('NFKD', texto).encode('ASCII', 'ignore')
