# -*- coding: utf-8 -*-
import datetime

from repositories.pedido.models import PedidoVenda, PedidoVendaFormaPagamento, PedidoVendaSituacao


class SituacaoPedido(PedidoVendaSituacao):
    class Meta:
        proxy = True


class Pedido(PedidoVenda):
    class Meta:
        proxy = True

    @property
    def provavel_data_entrega(self):
        return self.data_criacao + datetime.timedelta(days=self.prazo_entrega)

    def pedido_venda_pagamento_da_forma_de_pagamento(self, pagamento_id):
        return PedidoVendaFormaPagamento.objects.filter(pedido=self, conta=self.conta, pagamento_id=pagamento_id)
