# -*- coding: utf-8 -*-
import re


class Atributo(object):
    def __init__(self, nome, eh_lista=False, eh_serializavel=False):
        self.nome = nome
        self.eh_lista = eh_lista
        self.eh_serializavel = eh_serializavel


class ValorComAtributos(object):
    def __init__(self, valor, atributos):
        self.valor = valor
        self.atributos = atributos


class CampoSerializavel(object):
    def __init__(self, nome, valor=None):
        self.nome = nome.replace(" ", "")
        parametros = {}
        if type(valor) is ValorComAtributos:
            parametros = valor.atributos
            valor = valor.valor
        self.parametros = parametros
        self._valor = valor

    @property
    def valor(self):
        return self._valor

    @valor.setter
    def valor(self, valor):
        self._valor = valor

    def to_dict(self):
        if hasattr(self.valor, "to_dict"):
            return {self.nome: self.valor.to_dict()}
        if type(self.valor) is list:
            return {self.nome: [valor.to_dict() for valor in self.valor]}
        return {self.nome: self.valor}

    def to_xml(self):
        parametros = []
        for parametro in self.parametros.keys():
            if type(self.parametros[parametro]) in [list, dict]:
                continue
            parametros.append('{}="{}"'.format(parametro, self.parametros[parametro]))
        if hasattr(self.valor, "to_xml"):
            return '<{}{}{}>{}</{}>'.format(self.nome, (" " if parametros else ""), " ".join(parametros), self.valor.to_xml(), self.nome)
        if type(self.valor) is list:
            lista = ["<{}{}{}>".format(self.nome, (" " if parametros else ""), " ".join(parametros))]
            for valor in self.valor:
                if hasattr(valor, "to_xml"):
                    lista.append(valor.to_xml())
                else:
                    lista.append("<{}>{}</{}>".format(self.nome, valor, self.nome))
            lista.append("</{}>".format(self.nome))
            return "".join(lista)
        return '<{}{}{}>{}</{}>'.format(self.nome, (" " if parametros else ""), " ".join(parametros), self.valor, self.nome)


class EntidadeSerializavel(object):
    atributos = []
    parametros = {}

    def __init__(self, *args, **kwargs):
        for atributo in self.atributos:
            if type(atributo) is Atributo:
                self.define_valor_de_atributo(atributo, kwargs)

    def define_valor_de_atributo(self, atributo, kwargs):
        if not type(atributo) is Atributo:
            atributo = Atributo(atributo)
        nome_python = self.nome_de_atributo_python(atributo.nome)
        if nome_python in kwargs:
            if atributo.eh_serializavel and not issubclass(kwargs[nome_python].__class__, EntidadeSerializavel) and not issubclass(kwargs[nome_python].__class__, ValorComAtributos):
                raise ValueError(u"O parâmetro {} deve ser do tipo EntidadeSerializavel".format(nome_python))
            if atributo.eh_lista:
                valor = self.cria_lista_de_campo_serializavel(atributo.nome, kwargs[nome_python])
                setattr(self, nome_python, valor)
            else:
                setattr(self, nome_python, CampoSerializavel(atributo.nome, kwargs[nome_python]))

    def to_dict(self):
        retorno = {}
        for nome_atributo in dir(self):
            atributo = getattr(self, nome_atributo)
            if type(atributo) is CampoSerializavel:
                retorno.update(atributo.to_dict())
        return retorno

    @property
    def parametros_chave_valor(self):
        parametros = []
        for chave in self.parametros:
            parametros.append('{}="{}"'.format(chave, self.parametros[chave]))
        return " ".join(parametros)

    def to_xml(self, top=False):
        retorno = []
        if top:
            retorno.append("<{}{}{}>".format(self.__class__.__name__, (" " if self.parametros else ""), self.parametros_chave_valor))
        for nome_atributo in dir(self):
            atributo = getattr(self, nome_atributo)
            if type(atributo) is CampoSerializavel:
                retorno.append(atributo.to_xml())
        if top:
            retorno.append("</{}>".format(self.__class__.__name__))
        return "".join(retorno)

    def nome_de_atributo_python(self, atributo):
        atributo = atributo.replace(" ", "")
        s1 = re.sub('(.)([A-Z][a-z]+)', r'\1_\2', atributo)
        return re.sub('([a-z0-9])([A-Z])', r'\1_\2', s1).lower()

    def cria_lista_de_campo_serializavel(self, parametro, lista):
        if not type(lista) is list:
            lista = [lista]
        for item in lista:
            if not issubclass(item.__class__, EntidadeSerializavel):
                raise ValueError(u"O parâmetro {} deve ser uma lista de EntidadeSerializavel".format(self.nome_de_atributo_python(parametro)))
        return CampoSerializavel(parametro, lista)