# -*- coding: utf-8 -*-
from random import randint
from time import sleep
from flask import logging


class ResponseOk(object):
    def __init__(self):
        self.status_code = 200
        gateway_reference = "".join([str(randint(0, 9)) for numero in range(1, 17)])
        authcode = "".join([str(randint(0, 9)) for numero in range(1, 7)])
        self.content = """<?xml version="1.0" encoding="UTF-8"?>
<Response version="2">
<CardTxn>
<authcode>{}</authcode>
<card_scheme>VISA</card_scheme>
<country>United Kingdom</country>
</CardTxn>
<acquirer>Rede</acquirer>
<auth_host_reference>3</auth_host_reference>
<gateway_reference>{}</gateway_reference>
<extended_response_message>Sucesso</extended_response_message>
<extended_status>00</extended_status>
<merchantreference>123403</merchantreference>
<mid>456732145</mid>
<mode>TEST</mode>
<reason>ACCEPTED</reason>
<status>1</status>
<time>1372847996</time>
</Response>
""".format(authcode, gateway_reference)
        sleep(3)


ERROS = {
    "51": "Produto ou serviço não habilitado para o estabelecimento. Entre em contato com a Rede",
    "53": "Transação não permitida para o emissor. Entre em contato com a Rede",
    "56": "Erro nos dados informados. Tente novamente. Ao receber este erro na transação de confirmação da pré (fulfill), importante reenviar a transação diariamente durante 3 dias e caso persista o erro entrar em contato com nosso suporte técnico",
    "57": "Estabelecimento inválido",
    "58": "Transação não autorizada. Contate o emissor",
    "65": "Senha inválida. Tente novamente",
    "69": "Transação não permitida para este produto ou serviço",
    "72": "Contate o emissor",
    "74": "Falha na comunicação. Tente novamente",
    "79": "Cartão expirado. Transação não pode ser resubmetida. Contate o emissor",
    "80": "Transação não autorizada. Contate o emissor. (Saldo Insuficiente)",
    "81": "Produto ou serviço não habilitado para o emissor (AVS)",
    "82": "Transação não autorizada para cartão de débito",
    "83": "Transação não autorizada. Problemas com cartão. Contate o emissor",
    "84": "Transação não autorizada. Transação não pode ser resubmetida. Contate o emissor",
}


class ResponseErro(object):
    def __init__(self, status="58"):
        self.status_code = 200
        self.content = """<?xml version="1.0" encoding="UTF-8"?>
<Response version="2">
<CardTxn>
<card_scheme>VISA</card_scheme>
<country>United Kingdom</country>
</CardTxn>
<acquirer>Rede</acquirer>
<auth_host_reference>13</auth_host_reference>
<gateway_reference>4500903000000007</gateway_reference>
<extended_response_message>{}</extended_response_message>
<extended_status>{}</extended_status>
<information>DECLINE</information>
<merchantreference>123408</merchantreference>
<mid>456732145</mid>
<mode>TEST</mode>
<reason>DECLINED</reason>
<status>7</status>
<time>1372852207</time>
</Response>
""".format(ERROS[status], status)

logger = logging.getLogger("api_pagador")


class RequestsMock(object):
    def post(self, url, data=None, headers=None):
        logger.info("Enviou para {} os dados {} com header {}".format(url, data, headers))
        if "<pan>11112222" in data:
            return ResponseErro()
        return ResponseOk()
