# -*- coding: utf-8 -*-
from random import randint, seed
from time import sleep
from flask import logging


class ResponseOk(object):
    def __init__(self, com_antifraude=False, com_revisao=False):
        self.status_code = 200
        seed()
        self.gateway_reference = "".join([str(randint(0, 9)) for numero in range(1, 17)])
        self.content = self.content_normal
        if com_antifraude:
            self.content = self.content_antifraude
        if com_revisao:
            self.content = self.content_revisao
        sleep(2.5)

    @property
    def content_normal(self):
        authcode = "".join([str(randint(0, 9)) for numero in range(1, 7)])
        return """<?xml version="1.0" encoding="UTF-8"?>
<Response version="2">
<CardTxn>
<authcode>{}</authcode>
<card_scheme>VISA</card_scheme>
<country>United Kingdom</country>
</CardTxn>
<acquirer>Rede</acquirer>
<auth_host_reference>3</auth_host_reference>
<gateway_reference>{}</gateway_reference>
<extended_response_message>Sucesso</extended_response_message>
<extended_status>00</extended_status>
<merchantreference>123403</merchantreference>
<mid>456732145</mid>
<mode>TEST</mode>
<reason>ACCEPTED</reason>
<status>1</status>
<time>1372847996</time>
</Response>
""".format(authcode, self.gateway_reference)

    @property
    def content_antifraude(self):
        authcode = "".join([str(randint(0, 9)) for numero in range(1, 7)])
        return """<?xml version="1.0" encoding="UTF-8"?>
<Response version="2">
<CardTxn>
<authcode>{}</authcode>
<card_scheme>VISA</card_scheme>
<country>United Kingdom</country>
</CardTxn>
<Risk>
 <action_response>
 <bankresult_response>
 <cpi_value>-1</cpi_value>
 <response_code>00</response_code>
 <response_message>Successful</response_message>
 <transaction_id>{}</transaction_id>
 </bankresult_response>
 <screening_response>
 <cpi_value>0</cpi_value>
 <response_code>00</response_code>
 <response_message>Transaction Approved </response_message>
 <transaction_id>3200900010000275</transaction_id>
 </screening_response>
 </action_response>
 </Risk>
 <acquirer>Rede</acquirer>
<auth_host_reference>3</auth_host_reference>
<gateway_reference>{}</gateway_reference>
<extended_response_message>Sucesso</extended_response_message>
<extended_status>00</extended_status>
<merchantreference>123403</merchantreference>
<mid>456732145</mid>
<mode>TEST</mode>
<reason>ACCEPTED</reason>
<status>1</status>
<time>1372847996</time>
</Response>
""".format(authcode, self.gateway_reference, self.gateway_reference)

    @property
    def content_revisao(self):
        return """<?xml version="1.0" encoding="UTF-8"?>
<Response version="2">
<CardTxn>
<card_scheme>Mastercard</card_scheme>
</CardTxn>
<Risk>
<action_response>
<screening_response>
<cpi_value>0</cpi_value>
<response_code>02</response_code>
<response_message>Transaction marked for Review</response_message>
<transaction_id>{}</transaction_id>
</screening_response>
</action_response>
</Risk>
<gateway_reference>{}</gateway_reference>
<information>Transaction marked for review by the RSG</information>
<merchantreference>3cb4b5ca105c388ea6</merchantreference>
<mode>LIVE</mode>
<reason>Transaction marked for review</reason>
<status>1127</status>
<time>1288167601</time>
</Response>
""".format(self.gateway_reference, self.gateway_reference)


ERROS = {
    "51": "Produto ou serviço não habilitado para o estabelecimento. Entre em contato com a Rede",
    "53": "Transação não permitida para o emissor. Entre em contato com a Rede",
    "56": "Erro nos dados informados. Tente novamente. Ao receber este erro na transação de confirmação da pré (fulfill), importante reenviar a transação diariamente durante 3 dias e caso persista o erro entrar em contato com nosso suporte técnico",
    "57": "Estabelecimento inválido",
    "58": "Transação não autorizada. Contate o emissor",
    "65": "Senha inválida. Tente novamente",
    "69": "Transação não permitida para este produto ou serviço",
    "72": "Contate o emissor",
    "74": "Falha na comunicação. Tente novamente",
    "79": "Cartão expirado. Transação não pode ser resubmetida. Contate o emissor",
    "80": "Transação não autorizada. Contate o emissor. (Saldo Insuficiente)",
    "81": "Produto ou serviço não habilitado para o emissor (AVS)",
    "82": "Transação não autorizada para cartão de débito",
    "83": "Transação não autorizada. Problemas com cartão. Contate o emissor",
    "84": "Transação não autorizada. Transação não pode ser resubmetida. Contate o emissor",
}


class ResponseErro(object):
    def __init__(self, com_antifraude=False, status="58"):
        self.status_code = 200
        self.status = status
        seed()
        self.gateway_reference = "".join([str(randint(0, 9)) for numero in range(1, 17)])
        self.content = self.content_normal
        if com_antifraude:
            self.content = self.content_antifraude
        sleep(2.5)

    @property
    def content_normal(self):
        return """<?xml version="1.0" encoding="UTF-8"?>
<Response version="2">
<CardTxn>
<card_scheme>VISA</card_scheme>
<country>United Kingdom</country>
</CardTxn>
<acquirer>Rede</acquirer>
<auth_host_reference>13</auth_host_reference>
<gateway_reference>{}</gateway_reference>
<extended_response_message>{}</extended_response_message>
<extended_status>{}</extended_status>
<information>DECLINE</information>
<merchantreference>123408</merchantreference>
<mid>456732145</mid>
<mode>TEST</mode>
<reason>DECLINED</reason>
<status>7</status>
<time>1372852207</time>
</Response>
""".format(self.gateway_reference, ERROS[self.status], self.status)

    @property
    def content_antifraude(self):
        return """<?xml version="1.0" encoding="UTF-8"?>
<Response version="2">
<CardTxn>
<card_scheme>VISA</card_scheme>
<country>United Kingdom</country>
</CardTxn>
<Risk>
<action_response>
<screening_response>
<cpi_value>-1</cpi_value>
<response_code>01</response_code>
<response_message>Transaction not Approved</response_message>
<transaction_id>{}</transaction_id>
</screening_response>
</action_response>
</Risk>
<acquirer>Rede</acquirer>
<auth_host_reference>13</auth_host_reference>
<gateway_reference>{}</gateway_reference>
<extended_response_message>{}</extended_response_message>
<extended_status>{}</extended_status>
<information>DECLINE</information>
<merchantreference>123408</merchantreference>
<mid>456732145</mid>
<mode>TEST</mode>
<reason>REJECTED</reason>
<status>1126</status>
<time>1372852207</time>
</Response>
""".format(self.gateway_reference, self.gateway_reference, ERROS[self.status], self.status)


logger = logging.getLogger("api_pagador")


# class RequestsMock(object):
def post(url, data=None, headers=None, timeout=None):
    logger.info("Enviou para {} os dados {} com header {} e timeout de {} com read de {}".format(url, data, headers, timeout[0], timeout[1]))
    com_antifraude = "<Risk>" in data
    if "<pan>11112222" in data:
        return ResponseErro(com_antifraude=com_antifraude)
    if "<pan>22223333" in data:
        return ResponseOk(com_revisao=True)
    return ResponseOk(com_antifraude=com_antifraude)
