# -*- coding: utf-8 -*-
import json
import requests
from pagador import settings


def grava_evidencia_retorno(meio_pagamento, dados, conta_id, pedido_numero, tipo_evidencia="retorno", registrado=False, enviado=None):

    evidencia = {
        "index": "pagador",
        "tipo_evidencia": meio_pagamento + '-' + tipo_evidencia,
        "evidencia": {
            "conta_id": conta_id,
            "pedido_numero": pedido_numero,
            "recebido": {
                "dados": dados
            },
            "enviado": enviado
        }
    }

    if tipo_evidencia == "retorno":
        evidencia["evidencia"]["found"] = registrado

    try:
        evidencia = json.dumps(evidencia)
        requests.post(settings.EVIDENCIA_URL, data=evidencia, headers={"Content-Type": "application/json"})
    except Exception:
        pass