# -*- coding: utf-8 -*-

from pagador.extensao import base


class CredenciadorInvalido(Exception):
    pass


class AutenticadorNaoEncontrado(Exception):
    pass


class Credenciador(object):
    def __init__(self, credenciamento):
        self.credenciamento = credenciamento

    def obter_credenciais(self):
        return "user {token} password {senha}".format(self.credenciamento)

    def esta_valido(self):
        return True

    @property
    def suporta_atualizacao(self):
        return False

    @property
    def chave(self):
        return "access_token"


class TipoAutenticacao(object):
    cabecalho_http = 1
    query_string = 2
    form_urlencode = 3


class TipoConexao(object):
    envio = 1
    retorno = 2


class Credenciais(base.Plugavel):
    def __init__(self, meio_pagamento, configuracao_pagamento):
        self.meio_pagamento = meio_pagamento
        self.configuracao_pagamento = configuracao_pagamento
        self._credenciador = None

    @property
    def credenciador(self):
        if not self._credenciador:
            try:
                self._credenciador = self.plugin_seguranca.Credenciador(self.configuracao_pagamento)
            except AttributeError, ex:
                if "Credenciador" in unicode(ex):
                    raise AutenticadorNaoEncontrado(u"O meio de pagamento '{}' não possui a classe Credenciador.".format(self.meio_pagamento))
                raise
        return self._credenciador

    def define_autenticacao(self, url=None, atualiza_autenticacao=False):
        if not url:
            url = self.credenciador.url
        if self.credenciador.suporta_atualizacao and (atualiza_autenticacao or not self.credenciador.esta_valido()):
            self.configuracao_pagamento.atualizar()
        if self.credenciador.tipo == TipoAutenticacao.cabecalho_http:
            return self.por_cabecalho_http()
        if self.credenciador.tipo == TipoAutenticacao.form_urlencode:
            return self.por_form_urlencoded()
        if self.credenciador.tipo == TipoAutenticacao.query_string:
            separador = "&" if "?" in url else "?"
            return "{}{}{}".format(url, separador, self.por_query_string())
        return None

    def por_query_string(self):
        return "{}={}".format(self.credenciador.chave, self.credenciador.obter_credenciais())

    def por_form_urlencoded(self):
        return {self.credenciador.chave: self.credenciador.obter_credenciais()}

    def por_cabecalho_http(self, cabecalho="Authorization"):
        return {cabecalho: self.credenciador.obter_credenciais()}
