# libComXML

This library permits XML generation from Python objects

```xml
<CATALOG>
  <CD>
    <TITLE>Empire Burlesque</TITLE>
    <ARTIST>Bob Dylan</ARTIST>
    <COUNTRY>USA</COUNTRY>
    <COMPANY>Columbia</COMPANY>
    <PRICE>10.90</PRICE>
    <YEAR>1985</YEAR>
  </CD>
  <CD>
    <TITLE>Hide your heart</TITLE>
    <ARTIST>Bonnie Tyler</ARTIST>
    <COUNTRY>UK</COUNTRY>
    <COMPANY>CBS Records</COMPANY>
    <PRICE>9.90</PRICE>
    <YEAR>1988</YEAR>
  </CD>
</CATALOG>
```

```python
from libcomxml.core import XmlModel, XmlField


class Cd(XmlModel):
    def __init__(self):
        self.data = XmlField('CD')
        self.title = XmlField('TITLE')
        self.artist = XmlField('ARTIST')
        self.country = XmlField('COUNTRY')
        self.company = XmlField('COMPANY')
        self.price = XmlField('PRICE')
        self.year = XmlField('YEAR')
        super(Cd, self).__init__('CD', 'data')


class Catalog(XmlModel):
    def __init__(self):
        self.catalog = XmlField('CATALOG')
        self.cds = []
        super(Catalog, self).__init__('CATALOG', 'catalog')


catalog = Catalog()
cd = Cd()
cd.feed({
    'title': 'Empire Burlesque',
    'artist': 'Bob Dylan',
    'country': 'USA',
    'company': 'Columbia',
    'price': 10.90,
    'year': 1985
})
catalog.cds.append(cd)
cd = Cd()
cd.feed({
    'title': 'Hide your hear',
    'artist': 'Bonnie Tyler',
    'country': 'UK',
    'company': 'CBS Records',
    'price': 9.90,
    'year': 1988
})
catalog.cds.append(cd)
catalog.build_tree()
print catalog
```
