#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Wed Aug 28 14:37:29 2013 by generateDS.py version 2.10b.
#

import sys
import getopt
import re as re_
import base64
import datetime as datetime_

etree_ = None
Verbose_import_ = False
(
    XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class Annotation(GeneratedsSuper):
    """Placeholder for MIRIAM related metadata, among others."""
    member_data_items_ = [
        MemberSpec_('', 'xs:string', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, anytypeobjs_=None):
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if Annotation.subclass:
            return Annotation.subclass(*args_, **kwargs_)
        else:
            return Annotation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Annotation', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Annotation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Annotation'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Annotation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Annotation'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'Annotation')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class Annotation


class ComponentType(GeneratedsSuper):
    """Contains an extension to NeuroML by creating custom LEMS
    ComponentType."""
    member_data_items_ = [
        MemberSpec_('extends', 'xs:string', 0),
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('description', 'xs:string', 0),
        MemberSpec_('', 'xs:string', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, extends=None, name=None, description=None, anytypeobjs_=None):
        self.extends = _cast(None, extends)
        self.name = _cast(None, name)
        self.description = _cast(None, description)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if ComponentType.subclass:
            return ComponentType.subclass(*args_, **kwargs_)
        else:
            return ComponentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.anytypeobjs_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ComponentType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ComponentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ComponentType'):
        if self.extends is not None and 'extends' not in already_processed:
            already_processed.add('extends')
            outfile.write(' extends=%s' % (self.gds_format_string(quote_attrib(self.extends).encode(ExternalEncoding), input_name='extends'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.description is not None and 'description' not in already_processed:
            already_processed.add('description')
            outfile.write(' description=%s' % (self.gds_format_string(quote_attrib(self.description).encode(ExternalEncoding), input_name='description'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ComponentType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ComponentType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.extends is not None and 'extends' not in already_processed:
            already_processed.add('extends')
            showIndent(outfile, level)
            outfile.write('extends="%s",\n' % (self.extends,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        if self.description is not None and 'description' not in already_processed:
            already_processed.add('description')
            showIndent(outfile, level)
            outfile.write('description="%s",\n' % (self.description,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('extends', node)
        if value is not None and 'extends' not in already_processed:
            already_processed.add('extends')
            self.extends = value
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('description', node)
        if value is not None and 'description' not in already_processed:
            already_processed.add('description')
            self.description = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'ComponentType')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
# end class ComponentType


class IncludeType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('href', 'xs:anyURI', 0),
        MemberSpec_('valueOf_', [], 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, href=None, valueOf_=None, mixedclass_=None, content_=None):
        self.href = _cast(None, href)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if IncludeType.subclass:
            return IncludeType.subclass(*args_, **kwargs_)
        else:
            return IncludeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IncludeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IncludeType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IncludeType'):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IncludeType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='IncludeType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            showIndent(outfile, level)
            outfile.write('href="%s",\n' % (self.href,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class IncludeType


class Q10Settings(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('fixedQ10', 'Nml2Quantity_none', 0),
        MemberSpec_('experimentalTemp', 'Nml2Quantity_temperature', 0),
        MemberSpec_('type', 'NmlId', 0),
        MemberSpec_('q10Factor', 'Nml2Quantity_none', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, fixed_q10=None, experimental_temp=None, type=None, q10_factor=None):
        self.fixed_q10 = _cast(None, fixed_q10)
        self.experimental_temp = _cast(None, experimental_temp)
        self.type = _cast(None, type)
        self.q10_factor = _cast(None, q10_factor)
        pass
    def factory(*args_, **kwargs_):
        if Q10Settings.subclass:
            return Q10Settings.subclass(*args_, **kwargs_)
        else:
            return Q10Settings(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_temperature(self, value):
        # Validate type Nml2Quantity_temperature, a restriction on xs:string.
        pass
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Q10Settings', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Q10Settings')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Q10Settings'):
        if self.fixed_q10 is not None and 'fixed_q10' not in already_processed:
            already_processed.add('fixed_q10')
            outfile.write(' fixedQ10=%s' % (quote_attrib(self.fixed_q10), ))
        if self.experimental_temp is not None and 'experimental_temp' not in already_processed:
            already_processed.add('experimental_temp')
            outfile.write(' experimentalTemp=%s' % (quote_attrib(self.experimental_temp), ))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.q10_factor is not None and 'q10_factor' not in already_processed:
            already_processed.add('q10_factor')
            outfile.write(' q10Factor=%s' % (quote_attrib(self.q10_factor), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Q10Settings', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Q10Settings'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.fixed_q10 is not None and 'fixed_q10' not in already_processed:
            already_processed.add('fixed_q10')
            showIndent(outfile, level)
            outfile.write('fixed_q10="%s",\n' % (self.fixed_q10,))
        if self.experimental_temp is not None and 'experimental_temp' not in already_processed:
            already_processed.add('experimental_temp')
            showIndent(outfile, level)
            outfile.write('experimental_temp="%s",\n' % (self.experimental_temp,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        if self.q10_factor is not None and 'q10_factor' not in already_processed:
            already_processed.add('q10_factor')
            showIndent(outfile, level)
            outfile.write('q10_factor="%s",\n' % (self.q10_factor,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('fixedQ10', node)
        if value is not None and 'fixedQ10' not in already_processed:
            already_processed.add('fixedQ10')
            self.fixed_q10 = value
            self.validate_Nml2Quantity_none(self.fixed_q10)    # validate type Nml2Quantity_none
        value = find_attr_value_('experimentalTemp', node)
        if value is not None and 'experimentalTemp' not in already_processed:
            already_processed.add('experimentalTemp')
            self.experimental_temp = value
            self.validate_Nml2Quantity_temperature(self.experimental_temp)    # validate type Nml2Quantity_temperature
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_NmlId(self.type)    # validate type NmlId
        value = find_attr_value_('q10Factor', node)
        if value is not None and 'q10Factor' not in already_processed:
            already_processed.add('q10Factor')
            self.q10_factor = value
            self.validate_Nml2Quantity_none(self.q10_factor)    # validate type Nml2Quantity_none
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Q10Settings


class HHRate(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('midpoint', 'Nml2Quantity_voltage', 0),
        MemberSpec_('rate', 'Nml2Quantity_pertime', 0),
        MemberSpec_('scale', 'Nml2Quantity_voltage', 0),
        MemberSpec_('type', 'NmlId', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, midpoint=None, rate=None, scale=None, type=None):
        self.midpoint = _cast(None, midpoint)
        self.rate = _cast(None, rate)
        self.scale = _cast(None, scale)
        self.type = _cast(None, type)
        pass
    def factory(*args_, **kwargs_):
        if HHRate.subclass:
            return HHRate.subclass(*args_, **kwargs_)
        else:
            return HHRate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        pass
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HHRate', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HHRate')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HHRate'):
        if self.midpoint is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            outfile.write(' midpoint=%s' % (quote_attrib(self.midpoint), ))
        if self.rate is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            outfile.write(' rate=%s' % (quote_attrib(self.rate), ))
        if self.scale is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            outfile.write(' scale=%s' % (quote_attrib(self.scale), ))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
    def exportChildren(self, outfile, level, namespace_='', name_='HHRate', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='HHRate'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.midpoint is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            showIndent(outfile, level)
            outfile.write('midpoint="%s",\n' % (self.midpoint,))
        if self.rate is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            showIndent(outfile, level)
            outfile.write('rate="%s",\n' % (self.rate,))
        if self.scale is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            showIndent(outfile, level)
            outfile.write('scale="%s",\n' % (self.scale,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('midpoint', node)
        if value is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            self.midpoint = value
            self.validate_Nml2Quantity_voltage(self.midpoint)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('rate', node)
        if value is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            self.rate = value
            self.validate_Nml2Quantity_pertime(self.rate)    # validate type Nml2Quantity_pertime
        value = find_attr_value_('scale', node)
        if value is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            self.scale = value
            self.validate_Nml2Quantity_voltage(self.scale)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_NmlId(self.type)    # validate type NmlId
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class HHRate


class HHVariable(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('midpoint', 'Nml2Quantity_voltage', 0),
        MemberSpec_('rate', 'xs:float', 0),
        MemberSpec_('scale', 'Nml2Quantity_voltage', 0),
        MemberSpec_('type', 'NmlId', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, midpoint=None, rate=None, scale=None, type=None):
        self.midpoint = _cast(None, midpoint)
        self.rate = _cast(float, rate)
        self.scale = _cast(None, scale)
        self.type = _cast(None, type)
        pass
    def factory(*args_, **kwargs_):
        if HHVariable.subclass:
            return HHVariable.subclass(*args_, **kwargs_)
        else:
            return HHVariable(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        pass
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HHVariable', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HHVariable')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HHVariable'):
        if self.midpoint is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            outfile.write(' midpoint=%s' % (quote_attrib(self.midpoint), ))
        if self.rate is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            outfile.write(' rate="%s"' % self.gds_format_float(self.rate, input_name='rate'))
        if self.scale is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            outfile.write(' scale=%s' % (quote_attrib(self.scale), ))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
    def exportChildren(self, outfile, level, namespace_='', name_='HHVariable', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='HHVariable'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.midpoint is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            showIndent(outfile, level)
            outfile.write('midpoint="%s",\n' % (self.midpoint,))
        if self.rate is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            showIndent(outfile, level)
            outfile.write('rate=%f,\n' % (self.rate,))
        if self.scale is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            showIndent(outfile, level)
            outfile.write('scale="%s",\n' % (self.scale,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('midpoint', node)
        if value is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            self.midpoint = value
            self.validate_Nml2Quantity_voltage(self.midpoint)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('rate', node)
        if value is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            try:
                self.rate = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (rate): %s' % exp)
        value = find_attr_value_('scale', node)
        if value is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            self.scale = value
            self.validate_Nml2Quantity_voltage(self.scale)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_NmlId(self.type)    # validate type NmlId
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class HHVariable


class HHTime(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('midpoint', 'Nml2Quantity_voltage', 0),
        MemberSpec_('rate', 'Nml2Quantity_time', 0),
        MemberSpec_('scale', 'Nml2Quantity_voltage', 0),
        MemberSpec_('type', 'NmlId', 0),
        MemberSpec_('tau', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, midpoint=None, rate=None, scale=None, type=None, tau=None):
        self.midpoint = _cast(None, midpoint)
        self.rate = _cast(None, rate)
        self.scale = _cast(None, scale)
        self.type = _cast(None, type)
        self.tau = _cast(None, tau)
        pass
    def factory(*args_, **kwargs_):
        if HHTime.subclass:
            return HHTime.subclass(*args_, **kwargs_)
        else:
            return HHTime(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HHTime', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HHTime')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HHTime'):
        if self.midpoint is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            outfile.write(' midpoint=%s' % (quote_attrib(self.midpoint), ))
        if self.rate is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            outfile.write(' rate=%s' % (quote_attrib(self.rate), ))
        if self.scale is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            outfile.write(' scale=%s' % (quote_attrib(self.scale), ))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.tau is not None and 'tau' not in already_processed:
            already_processed.add('tau')
            outfile.write(' tau=%s' % (quote_attrib(self.tau), ))
    def exportChildren(self, outfile, level, namespace_='', name_='HHTime', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='HHTime'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.midpoint is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            showIndent(outfile, level)
            outfile.write('midpoint="%s",\n' % (self.midpoint,))
        if self.rate is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            showIndent(outfile, level)
            outfile.write('rate="%s",\n' % (self.rate,))
        if self.scale is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            showIndent(outfile, level)
            outfile.write('scale="%s",\n' % (self.scale,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        if self.tau is not None and 'tau' not in already_processed:
            already_processed.add('tau')
            showIndent(outfile, level)
            outfile.write('tau="%s",\n' % (self.tau,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('midpoint', node)
        if value is not None and 'midpoint' not in already_processed:
            already_processed.add('midpoint')
            self.midpoint = value
            self.validate_Nml2Quantity_voltage(self.midpoint)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('rate', node)
        if value is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            self.rate = value
            self.validate_Nml2Quantity_time(self.rate)    # validate type Nml2Quantity_time
        value = find_attr_value_('scale', node)
        if value is not None and 'scale' not in already_processed:
            already_processed.add('scale')
            self.scale = value
            self.validate_Nml2Quantity_voltage(self.scale)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_NmlId(self.type)    # validate type NmlId
        value = find_attr_value_('tau', node)
        if value is not None and 'tau' not in already_processed:
            already_processed.add('tau')
            self.tau = value
            self.validate_Nml2Quantity_time(self.tau)    # validate type Nml2Quantity_time
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class HHTime


class BlockMechanism(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('blockConcentration', 'Nml2Quantity_concentration', 0),
        MemberSpec_('scalingConc', 'Nml2Quantity_concentration', 0),
        MemberSpec_('type', 'BlockTypes', 0),
        MemberSpec_('species', 'NmlId', 0),
        MemberSpec_('scalingVolt', 'Nml2Quantity_voltage', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, block_concentration=None, scaling_conc=None, type=None, species=None, scaling_volt=None):
        self.block_concentration = _cast(None, block_concentration)
        self.scaling_conc = _cast(None, scaling_conc)
        self.type = _cast(None, type)
        self.species = _cast(None, species)
        self.scaling_volt = _cast(None, scaling_volt)
        pass
    def factory(*args_, **kwargs_):
        if BlockMechanism.subclass:
            return BlockMechanism.subclass(*args_, **kwargs_)
        else:
            return BlockMechanism(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        pass
    def validate_BlockTypes(self, value):
        # Validate type BlockTypes, a restriction on xs:string.
        pass
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BlockMechanism', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BlockMechanism')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BlockMechanism'):
        if self.block_concentration is not None and 'block_concentration' not in already_processed:
            already_processed.add('block_concentration')
            outfile.write(' blockConcentration=%s' % (quote_attrib(self.block_concentration), ))
        if self.scaling_conc is not None and 'scaling_conc' not in already_processed:
            already_processed.add('scaling_conc')
            outfile.write(' scalingConc=%s' % (quote_attrib(self.scaling_conc), ))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.species is not None and 'species' not in already_processed:
            already_processed.add('species')
            outfile.write(' species=%s' % (quote_attrib(self.species), ))
        if self.scaling_volt is not None and 'scaling_volt' not in already_processed:
            already_processed.add('scaling_volt')
            outfile.write(' scalingVolt=%s' % (quote_attrib(self.scaling_volt), ))
    def exportChildren(self, outfile, level, namespace_='', name_='BlockMechanism', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='BlockMechanism'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.block_concentration is not None and 'block_concentration' not in already_processed:
            already_processed.add('block_concentration')
            showIndent(outfile, level)
            outfile.write('block_concentration="%s",\n' % (self.block_concentration,))
        if self.scaling_conc is not None and 'scaling_conc' not in already_processed:
            already_processed.add('scaling_conc')
            showIndent(outfile, level)
            outfile.write('scaling_conc="%s",\n' % (self.scaling_conc,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        if self.species is not None and 'species' not in already_processed:
            already_processed.add('species')
            showIndent(outfile, level)
            outfile.write('species="%s",\n' % (self.species,))
        if self.scaling_volt is not None and 'scaling_volt' not in already_processed:
            already_processed.add('scaling_volt')
            showIndent(outfile, level)
            outfile.write('scaling_volt="%s",\n' % (self.scaling_volt,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('blockConcentration', node)
        if value is not None and 'blockConcentration' not in already_processed:
            already_processed.add('blockConcentration')
            self.block_concentration = value
            self.validate_Nml2Quantity_concentration(self.block_concentration)    # validate type Nml2Quantity_concentration
        value = find_attr_value_('scalingConc', node)
        if value is not None and 'scalingConc' not in already_processed:
            already_processed.add('scalingConc')
            self.scaling_conc = value
            self.validate_Nml2Quantity_concentration(self.scaling_conc)    # validate type Nml2Quantity_concentration
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_BlockTypes(self.type)    # validate type BlockTypes
        value = find_attr_value_('species', node)
        if value is not None and 'species' not in already_processed:
            already_processed.add('species')
            self.species = value
            self.validate_NmlId(self.species)    # validate type NmlId
        value = find_attr_value_('scalingVolt', node)
        if value is not None and 'scalingVolt' not in already_processed:
            already_processed.add('scalingVolt')
            self.scaling_volt = value
            self.validate_Nml2Quantity_voltage(self.scaling_volt)    # validate type Nml2Quantity_voltage
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class BlockMechanism


class PlasticityMechanism(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('type', 'PlasticityTypes', 0),
        MemberSpec_('tauFac', 'Nml2Quantity_time', 0),
        MemberSpec_('tauRec', 'Nml2Quantity_time', 0),
        MemberSpec_('initReleaseProb', 'ZeroToOne', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, type=None, tau_fac=None, tau_rec=None, init_release_prob=None):
        self.type = _cast(None, type)
        self.tau_fac = _cast(None, tau_fac)
        self.tau_rec = _cast(None, tau_rec)
        self.init_release_prob = _cast(None, init_release_prob)
        pass
    def factory(*args_, **kwargs_):
        if PlasticityMechanism.subclass:
            return PlasticityMechanism.subclass(*args_, **kwargs_)
        else:
            return PlasticityMechanism(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_PlasticityTypes(self, value):
        # Validate type PlasticityTypes, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:double.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PlasticityMechanism', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PlasticityMechanism')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PlasticityMechanism'):
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.tau_fac is not None and 'tau_fac' not in already_processed:
            already_processed.add('tau_fac')
            outfile.write(' tauFac=%s' % (quote_attrib(self.tau_fac), ))
        if self.tau_rec is not None and 'tau_rec' not in already_processed:
            already_processed.add('tau_rec')
            outfile.write(' tauRec=%s' % (quote_attrib(self.tau_rec), ))
        if self.init_release_prob is not None and 'init_release_prob' not in already_processed:
            already_processed.add('init_release_prob')
            outfile.write(' initReleaseProb=%s' % (quote_attrib(self.init_release_prob), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PlasticityMechanism', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='PlasticityMechanism'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        if self.tau_fac is not None and 'tau_fac' not in already_processed:
            already_processed.add('tau_fac')
            showIndent(outfile, level)
            outfile.write('tau_fac="%s",\n' % (self.tau_fac,))
        if self.tau_rec is not None and 'tau_rec' not in already_processed:
            already_processed.add('tau_rec')
            showIndent(outfile, level)
            outfile.write('tau_rec="%s",\n' % (self.tau_rec,))
        if self.init_release_prob is not None and 'init_release_prob' not in already_processed:
            already_processed.add('init_release_prob')
            showIndent(outfile, level)
            outfile.write('init_release_prob=%e,\n' % (self.init_release_prob,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_PlasticityTypes(self.type)    # validate type PlasticityTypes
        value = find_attr_value_('tauFac', node)
        if value is not None and 'tauFac' not in already_processed:
            already_processed.add('tauFac')
            self.tau_fac = value
            self.validate_Nml2Quantity_time(self.tau_fac)    # validate type Nml2Quantity_time
        value = find_attr_value_('tauRec', node)
        if value is not None and 'tauRec' not in already_processed:
            already_processed.add('tauRec')
            self.tau_rec = value
            self.validate_Nml2Quantity_time(self.tau_rec)    # validate type Nml2Quantity_time
        value = find_attr_value_('initReleaseProb', node)
        if value is not None and 'initReleaseProb' not in already_processed:
            already_processed.add('initReleaseProb')
            try:
                self.init_release_prob = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (initReleaseProb): %s' % exp)
            self.validate_ZeroToOne(self.init_release_prob)    # validate type ZeroToOne
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class PlasticityMechanism


class SegmentParent(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('fractionAlong', 'ZeroToOne', 0),
        MemberSpec_('segment', 'SegmentId', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, fraction_along='1', segments=None):
        self.fraction_along = _cast(None, fraction_along)
        self.segments = _cast(None, segments)
        pass
    def factory(*args_, **kwargs_):
        if SegmentParent.subclass:
            return SegmentParent.subclass(*args_, **kwargs_)
        else:
            return SegmentParent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:double.
        pass
    def validate_SegmentId(self, value):
        # Validate type SegmentId, a restriction on xs:nonNegativeInteger.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SegmentParent', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SegmentParent')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SegmentParent'):
        if self.fraction_along is not None and 'fraction_along' not in already_processed:
            already_processed.add('fraction_along')
            outfile.write(' fractionAlong=%s' % (quote_attrib(self.fraction_along), ))
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SegmentParent', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='SegmentParent'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.fraction_along is not None and 'fraction_along' not in already_processed:
            already_processed.add('fraction_along')
            showIndent(outfile, level)
            outfile.write('fraction_along=%e,\n' % (self.fraction_along,))
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            showIndent(outfile, level)
            outfile.write('segments=%d,\n' % (self.segments,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('fractionAlong', node)
        if value is not None and 'fractionAlong' not in already_processed:
            already_processed.add('fractionAlong')
            try:
                self.fraction_along = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (fractionAlong): %s' % exp)
            self.validate_ZeroToOne(self.fraction_along)    # validate type ZeroToOne
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            try:
                self.segments = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.segments < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_SegmentId(self.segments)    # validate type SegmentId
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
    @property
    def length(self):
        prox_x = self.proximal.x
        prox_y = self.proximal.y
        prox_z = self.proximal.z

        dist_x = self.distal.x
        dist_y = self.distal.y
        dist_z = self.distal.z

        length = ((prox_x-dist_x)**2 + (prox_y-dist_y)**2 + (prox_z-dist_z)**2)**(0.5)

        return length
    @property
    def volume(self):
        from math import pi

        prox_diam = self.proximal.diameter
        dist_diam = self.distal.diameter

        length = self.length

        volume = (pi/3)*length*(prox_diam**2+dist_diam**2+prox_diam*dist_diam)

        return volume
    
    @property
    def area(self):
        from math import pi
        from math import sqrt

        prox_diam = self.proximal.diameter
        dist_diam = self.distal.diameter
        length = self.length

        area = pi*(prox_diam+dist_diam)*sqrt((prox_diam-dist_diam)**2+length**2)
        
        return area
    # end class SegmentParent


class Point3DWithDiam(GeneratedsSuper):
    """A 3D point with diameter."""
    member_data_items_ = [
        MemberSpec_('y', 'xs:double', 0),
        MemberSpec_('x', 'xs:double', 0),
        MemberSpec_('z', 'xs:double', 0),
        MemberSpec_('diameter', 'xs:double', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, y=None, x=None, z=None, diameter=None):
        self.y = _cast(float, y)
        self.x = _cast(float, x)
        self.z = _cast(float, z)
        self.diameter = _cast(float, diameter)
        pass
    def factory(*args_, **kwargs_):
        if Point3DWithDiam.subclass:
            return Point3DWithDiam.subclass(*args_, **kwargs_)
        else:
            return Point3DWithDiam(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Point3DWithDiam', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Point3DWithDiam')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Point3DWithDiam'):
        if self.y is not None and 'y' not in already_processed:
            already_processed.add('y')
            outfile.write(' y="%s"' % self.gds_format_double(self.y, input_name='y'))
        if self.x is not None and 'x' not in already_processed:
            already_processed.add('x')
            outfile.write(' x="%s"' % self.gds_format_double(self.x, input_name='x'))
        if self.z is not None and 'z' not in already_processed:
            already_processed.add('z')
            outfile.write(' z="%s"' % self.gds_format_double(self.z, input_name='z'))
        if self.diameter is not None and 'diameter' not in already_processed:
            already_processed.add('diameter')
            outfile.write(' diameter="%s"' % self.gds_format_double(self.diameter, input_name='diameter'))
    def exportChildren(self, outfile, level, namespace_='', name_='Point3DWithDiam', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Point3DWithDiam'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.y is not None and 'y' not in already_processed:
            already_processed.add('y')
            showIndent(outfile, level)
            outfile.write('y=%e,\n' % (self.y,))
        if self.x is not None and 'x' not in already_processed:
            already_processed.add('x')
            showIndent(outfile, level)
            outfile.write('x=%e,\n' % (self.x,))
        if self.z is not None and 'z' not in already_processed:
            already_processed.add('z')
            showIndent(outfile, level)
            outfile.write('z=%e,\n' % (self.z,))
        if self.diameter is not None and 'diameter' not in already_processed:
            already_processed.add('diameter')
            showIndent(outfile, level)
            outfile.write('diameter=%e,\n' % (self.diameter,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('y', node)
        if value is not None and 'y' not in already_processed:
            already_processed.add('y')
            try:
                self.y = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (y): %s' % exp)
        value = find_attr_value_('x', node)
        if value is not None and 'x' not in already_processed:
            already_processed.add('x')
            try:
                self.x = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (x): %s' % exp)
        value = find_attr_value_('z', node)
        if value is not None and 'z' not in already_processed:
            already_processed.add('z')
            try:
                self.z = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (z): %s' % exp)
        value = find_attr_value_('diameter', node)
        if value is not None and 'diameter' not in already_processed:
            already_processed.add('diameter')
            try:
                self.diameter = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (diameter): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Point3DWithDiam


class ProximalDetails(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('translationStart', 'xs:double', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, translation_start=None):
        self.translation_start = _cast(float, translation_start)
        pass
    def factory(*args_, **kwargs_):
        if ProximalDetails.subclass:
            return ProximalDetails.subclass(*args_, **kwargs_)
        else:
            return ProximalDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ProximalDetails', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProximalDetails')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ProximalDetails'):
        if self.translation_start is not None and 'translation_start' not in already_processed:
            already_processed.add('translation_start')
            outfile.write(' translationStart="%s"' % self.gds_format_double(self.translation_start, input_name='translationStart'))
    def exportChildren(self, outfile, level, namespace_='', name_='ProximalDetails', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='ProximalDetails'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.translation_start is not None and 'translation_start' not in already_processed:
            already_processed.add('translation_start')
            showIndent(outfile, level)
            outfile.write('translation_start=%e,\n' % (self.translation_start,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('translationStart', node)
        if value is not None and 'translationStart' not in already_processed:
            already_processed.add('translationStart')
            try:
                self.translation_start = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (translationStart): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ProximalDetails


class DistalDetails(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('normalizationEnd', 'xs:double', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, normalization_end=None):
        self.normalization_end = _cast(float, normalization_end)
        pass
    def factory(*args_, **kwargs_):
        if DistalDetails.subclass:
            return DistalDetails.subclass(*args_, **kwargs_)
        else:
            return DistalDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DistalDetails', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DistalDetails')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DistalDetails'):
        if self.normalization_end is not None and 'normalization_end' not in already_processed:
            already_processed.add('normalization_end')
            outfile.write(' normalizationEnd="%s"' % self.gds_format_double(self.normalization_end, input_name='normalizationEnd'))
    def exportChildren(self, outfile, level, namespace_='', name_='DistalDetails', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='DistalDetails'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.normalization_end is not None and 'normalization_end' not in already_processed:
            already_processed.add('normalization_end')
            showIndent(outfile, level)
            outfile.write('normalization_end=%e,\n' % (self.normalization_end,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('normalizationEnd', node)
        if value is not None and 'normalizationEnd' not in already_processed:
            already_processed.add('normalizationEnd')
            try:
                self.normalization_end = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (normalizationEnd): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DistalDetails


class Member(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('segment', 'SegmentId', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, segments=None):
        self.segments = _cast(None, segments)
        pass
    def factory(*args_, **kwargs_):
        if Member.subclass:
            return Member.subclass(*args_, **kwargs_)
        else:
            return Member(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_SegmentId(self, value):
        # Validate type SegmentId, a restriction on xs:nonNegativeInteger.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Member', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Member')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Member'):
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Member', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Member'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            showIndent(outfile, level)
            outfile.write('segments=%d,\n' % (self.segments,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            try:
                self.segments = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.segments < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_SegmentId(self.segments)    # validate type SegmentId
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Member


class Include(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('segmentGroup', 'NmlId', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, segment_groups=None):
        self.segment_groups = _cast(None, segment_groups)
        pass
    def factory(*args_, **kwargs_):
        if Include.subclass:
            return Include.subclass(*args_, **kwargs_)
        else:
            return Include(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Include', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Include')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Include'):
        if self.segment_groups is not None and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (quote_attrib(self.segment_groups), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Include', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Include'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.segment_groups is not None and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            showIndent(outfile, level)
            outfile.write('segment_groups="%s",\n' % (self.segment_groups,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)    # validate type NmlId
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Include


class Path(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('from_', 'SegmentEndPoint', 0),
        MemberSpec_('to', 'SegmentEndPoint', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, from_=None, to=None):
        self.from_ = from_
        self.to = to
    def factory(*args_, **kwargs_):
        if Path.subclass:
            return Path.subclass(*args_, **kwargs_)
        else:
            return Path(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.from_ is not None or
            self.to is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Path', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Path')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Path'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Path', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.from_ is not None:
            self.from_.export(outfile, level, namespace_, name_='from', pretty_print=pretty_print)
        if self.to is not None:
            self.to.export(outfile, level, namespace_, name_='to', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Path'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.from_ is not None:
            showIndent(outfile, level)
            outfile.write('from_=model_.SegmentEndPoint(\n')
            self.from_.exportLiteral(outfile, level, name_='from')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.to is not None:
            showIndent(outfile, level)
            outfile.write('to=model_.SegmentEndPoint(\n')
            self.to.exportLiteral(outfile, level, name_='to')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'from':
            obj_ = SegmentEndPoint.factory()
            obj_.build(child_)
            self.from_ = obj_
        elif nodeName_ == 'to':
            obj_ = SegmentEndPoint.factory()
            obj_.build(child_)
            self.to = obj_
# end class Path


class SubTree(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('from_', 'SegmentEndPoint', 0),
        MemberSpec_('to', 'SegmentEndPoint', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, from_=None, to=None):
        self.from_ = from_
        self.to = to
    def factory(*args_, **kwargs_):
        if SubTree.subclass:
            return SubTree.subclass(*args_, **kwargs_)
        else:
            return SubTree(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.from_ is not None or
            self.to is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SubTree', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SubTree')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SubTree'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SubTree', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.from_ is not None:
            self.from_.export(outfile, level, namespace_, name_='from', pretty_print=pretty_print)
        if self.to is not None:
            self.to.export(outfile, level, namespace_, name_='to', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SubTree'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.from_ is not None:
            showIndent(outfile, level)
            outfile.write('from_=model_.SegmentEndPoint(\n')
            self.from_.exportLiteral(outfile, level, name_='from')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.to is not None:
            showIndent(outfile, level)
            outfile.write('to=model_.SegmentEndPoint(\n')
            self.to.exportLiteral(outfile, level, name_='to')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'from':
            obj_ = SegmentEndPoint.factory()
            obj_.build(child_)
            self.from_ = obj_
        elif nodeName_ == 'to':
            obj_ = SegmentEndPoint.factory()
            obj_.build(child_)
            self.to = obj_
# end class SubTree


class SegmentEndPoint(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('segment', 'SegmentId', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, segments=None):
        self.segments = _cast(None, segments)
        pass
    def factory(*args_, **kwargs_):
        if SegmentEndPoint.subclass:
            return SegmentEndPoint.subclass(*args_, **kwargs_)
        else:
            return SegmentEndPoint(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_SegmentId(self, value):
        # Validate type SegmentId, a restriction on xs:nonNegativeInteger.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SegmentEndPoint', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SegmentEndPoint')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SegmentEndPoint'):
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SegmentEndPoint', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='SegmentEndPoint'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            showIndent(outfile, level)
            outfile.write('segments=%d,\n' % (self.segments,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            try:
                self.segments = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.segments < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_SegmentId(self.segments)    # validate type SegmentId
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
    @property
    def length(self):
        prox_x = self.proximal.x
        prox_y = self.proximal.y
        prox_z = self.proximal.z

        dist_x = self.distal.x
        dist_y = self.distal.y
        dist_z = self.distal.z

        length = ((prox_x-dist_x)**2 + (prox_y-dist_y)**2 + (prox_z-dist_z)**2)**(0.5)

        return length
    @property
    def volume(self):
        from math import pi

        prox_diam = self.proximal.diameter
        dist_diam = self.distal.diameter

        length = self.length

        volume = (pi/3)*length*(prox_diam**2+dist_diam**2+prox_diam*dist_diam)

        return volume
    
    @property
    def area(self):
        from math import pi
        from math import sqrt

        prox_diam = self.proximal.diameter
        dist_diam = self.distal.diameter
        length = self.length

        area = pi*(prox_diam+dist_diam)*sqrt((prox_diam-dist_diam)**2+length**2)
        
        return area
    # end class SegmentEndPoint


class MembraneProperties(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('channel_populations', 'ChannelPopulation', 1),
        MemberSpec_('channel_densities', 'ChannelDensity', 1),
        MemberSpec_('spike_threshes', 'ValueAcrossSegOrSegGroup', 1),
        MemberSpec_('specific_capacitances', 'ValueAcrossSegOrSegGroup', 1),
        MemberSpec_('init_memb_potentials', 'ValueAcrossSegOrSegGroup', 1),
        MemberSpec_('reversal_potentials', 'ReversalPotential', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, channel_populations=None, channel_densities=None, spike_threshes=None, specific_capacitances=None, init_memb_potentials=None, reversal_potentials=None):
        if channel_populations is None:
            self.channel_populations = []
        else:
            self.channel_populations = channel_populations
        if channel_densities is None:
            self.channel_densities = []
        else:
            self.channel_densities = channel_densities
        if spike_threshes is None:
            self.spike_threshes = []
        else:
            self.spike_threshes = spike_threshes
        if specific_capacitances is None:
            self.specific_capacitances = []
        else:
            self.specific_capacitances = specific_capacitances
        if init_memb_potentials is None:
            self.init_memb_potentials = []
        else:
            self.init_memb_potentials = init_memb_potentials
        if reversal_potentials is None:
            self.reversal_potentials = []
        else:
            self.reversal_potentials = reversal_potentials
    def factory(*args_, **kwargs_):
        if MembraneProperties.subclass:
            return MembraneProperties.subclass(*args_, **kwargs_)
        else:
            return MembraneProperties(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.channel_populations or
            self.channel_densities or
            self.spike_threshes or
            self.specific_capacitances or
            self.init_memb_potentials or
            self.reversal_potentials
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MembraneProperties', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MembraneProperties')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MembraneProperties'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='MembraneProperties', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for channelPopulation_ in self.channel_populations:
            channelPopulation_.export(outfile, level, namespace_, name_='channelPopulation', pretty_print=pretty_print)
        for channelDensity_ in self.channel_densities:
            channelDensity_.export(outfile, level, namespace_, name_='channelDensity', pretty_print=pretty_print)
        for spikeThresh_ in self.spike_threshes:
            spikeThresh_.export(outfile, level, namespace_, name_='spikeThresh', pretty_print=pretty_print)
        for specificCapacitance_ in self.specific_capacitances:
            specificCapacitance_.export(outfile, level, namespace_, name_='specificCapacitance', pretty_print=pretty_print)
        for initMembPotential_ in self.init_memb_potentials:
            initMembPotential_.export(outfile, level, namespace_, name_='initMembPotential', pretty_print=pretty_print)
        for reversalPotential_ in self.reversal_potentials:
            reversalPotential_.export(outfile, level, namespace_, name_='reversalPotential', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MembraneProperties'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('channel_populations=[\n')
        level += 1
        for channelPopulation_ in self.channel_populations:
            showIndent(outfile, level)
            outfile.write('model_.ChannelPopulation(\n')
            channelPopulation_.exportLiteral(outfile, level, name_='ChannelPopulation')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('channel_densities=[\n')
        level += 1
        for channelDensity_ in self.channel_densities:
            showIndent(outfile, level)
            outfile.write('model_.ChannelDensity(\n')
            channelDensity_.exportLiteral(outfile, level, name_='ChannelDensity')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('spike_threshes=[\n')
        level += 1
        for spikeThresh_ in self.spike_threshes:
            showIndent(outfile, level)
            outfile.write('model_.ValueAcrossSegOrSegGroup(\n')
            spikeThresh_.exportLiteral(outfile, level, name_='ValueAcrossSegOrSegGroup')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('specific_capacitances=[\n')
        level += 1
        for specificCapacitance_ in self.specific_capacitances:
            showIndent(outfile, level)
            outfile.write('model_.ValueAcrossSegOrSegGroup(\n')
            specificCapacitance_.exportLiteral(outfile, level, name_='ValueAcrossSegOrSegGroup')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('init_memb_potentials=[\n')
        level += 1
        for initMembPotential_ in self.init_memb_potentials:
            showIndent(outfile, level)
            outfile.write('model_.ValueAcrossSegOrSegGroup(\n')
            initMembPotential_.exportLiteral(outfile, level, name_='ValueAcrossSegOrSegGroup')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('reversal_potentials=[\n')
        level += 1
        for reversalPotential_ in self.reversal_potentials:
            showIndent(outfile, level)
            outfile.write('model_.ReversalPotential(\n')
            reversalPotential_.exportLiteral(outfile, level, name_='ReversalPotential')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'channelPopulation':
            obj_ = ChannelPopulation.factory()
            obj_.build(child_)
            self.channel_populations.append(obj_)
        elif nodeName_ == 'channelDensity':
            obj_ = ChannelDensity.factory()
            obj_.build(child_)
            self.channel_densities.append(obj_)
        elif nodeName_ == 'spikeThresh':
            class_obj_ = self.get_class_obj_(child_, ValueAcrossSegOrSegGroup)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.spike_threshes.append(obj_)
        elif nodeName_ == 'specificCapacitance':
            class_obj_ = self.get_class_obj_(child_, ValueAcrossSegOrSegGroup)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.specific_capacitances.append(obj_)
        elif nodeName_ == 'initMembPotential':
            class_obj_ = self.get_class_obj_(child_, ValueAcrossSegOrSegGroup)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.init_memb_potentials.append(obj_)
        elif nodeName_ == 'reversalPotential':
            obj_ = ReversalPotential.factory()
            obj_.build(child_)
            self.reversal_potentials.append(obj_)
# end class MembraneProperties


class ValueAcrossSegOrSegGroup(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('segment', 'NmlId', 0),
        MemberSpec_('segmentGroup', 'NmlId', 0),
        MemberSpec_('value', 'Nml2Quantity', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, segments=None, segment_groups='all', value=None, extensiontype_=None):
        self.segments = _cast(None, segments)
        self.segment_groups = _cast(None, segment_groups)
        self.value = _cast(None, value)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ValueAcrossSegOrSegGroup.subclass:
            return ValueAcrossSegOrSegGroup.subclass(*args_, **kwargs_)
        else:
            return ValueAcrossSegOrSegGroup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def validate_Nml2Quantity(self, value):
        # Validate type Nml2Quantity, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ValueAcrossSegOrSegGroup', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ValueAcrossSegOrSegGroup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ValueAcrossSegOrSegGroup'):
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
        if self.segment_groups is not None and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (quote_attrib(self.segment_groups), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ValueAcrossSegOrSegGroup', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='ValueAcrossSegOrSegGroup'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            showIndent(outfile, level)
            outfile.write('segments="%s",\n' % (self.segments,))
        if self.segment_groups is not None and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            showIndent(outfile, level)
            outfile.write('segment_groups="%s",\n' % (self.segment_groups,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            showIndent(outfile, level)
            outfile.write('value="%s",\n' % (self.value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            self.segments = value
            self.validate_NmlId(self.segments)    # validate type NmlId
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)    # validate type NmlId
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.validate_Nml2Quantity(self.value)    # validate type Nml2Quantity
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ValueAcrossSegOrSegGroup


class VariableParameter(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('segmentGroup', 'xs:string', 0),
        MemberSpec_('parameter', 'xs:string', 0),
        MemberSpec_('inhomogeneous_value', 'InhomogeneousValue', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, segment_groups=None, parameter=None, inhomogeneous_value=None):
        self.segment_groups = _cast(None, segment_groups)
        self.parameter = _cast(None, parameter)
        self.inhomogeneous_value = inhomogeneous_value
    def factory(*args_, **kwargs_):
        if VariableParameter.subclass:
            return VariableParameter.subclass(*args_, **kwargs_)
        else:
            return VariableParameter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.inhomogeneous_value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VariableParameter', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VariableParameter')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VariableParameter'):
        if self.segment_groups is not None and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (self.gds_format_string(quote_attrib(self.segment_groups).encode(ExternalEncoding), input_name='segmentGroup'), ))
        if self.parameter is not None and 'parameter' not in already_processed:
            already_processed.add('parameter')
            outfile.write(' parameter=%s' % (self.gds_format_string(quote_attrib(self.parameter).encode(ExternalEncoding), input_name='parameter'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VariableParameter', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.inhomogeneous_value is not None:
            self.inhomogeneous_value.export(outfile, level, namespace_, name_='inhomogeneousValue', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VariableParameter'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.segment_groups is not None and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            showIndent(outfile, level)
            outfile.write('segment_groups="%s",\n' % (self.segment_groups,))
        if self.parameter is not None and 'parameter' not in already_processed:
            already_processed.add('parameter')
            showIndent(outfile, level)
            outfile.write('parameter="%s",\n' % (self.parameter,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.inhomogeneous_value is not None:
            showIndent(outfile, level)
            outfile.write('inhomogeneous_value=model_.InhomogeneousValue(\n')
            self.inhomogeneous_value.exportLiteral(outfile, level, name_='inhomogeneousValue')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
        value = find_attr_value_('parameter', node)
        if value is not None and 'parameter' not in already_processed:
            already_processed.add('parameter')
            self.parameter = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'inhomogeneousValue':
            obj_ = InhomogeneousValue.factory()
            obj_.build(child_)
            self.inhomogeneous_value = obj_
# end class VariableParameter


class InhomogeneousValue(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('inhomogeneousParam', 'xs:string', 0),
        MemberSpec_('value', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, inhomogeneous_params=None, value=None):
        self.inhomogeneous_params = _cast(None, inhomogeneous_params)
        self.value = _cast(None, value)
        pass
    def factory(*args_, **kwargs_):
        if InhomogeneousValue.subclass:
            return InhomogeneousValue.subclass(*args_, **kwargs_)
        else:
            return InhomogeneousValue(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='InhomogeneousValue', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InhomogeneousValue')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='InhomogeneousValue'):
        if self.inhomogeneous_params is not None and 'inhomogeneous_params' not in already_processed:
            already_processed.add('inhomogeneous_params')
            outfile.write(' inhomogeneousParam=%s' % (self.gds_format_string(quote_attrib(self.inhomogeneous_params).encode(ExternalEncoding), input_name='inhomogeneousParam'), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='InhomogeneousValue', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='InhomogeneousValue'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.inhomogeneous_params is not None and 'inhomogeneous_params' not in already_processed:
            already_processed.add('inhomogeneous_params')
            showIndent(outfile, level)
            outfile.write('inhomogeneous_params="%s",\n' % (self.inhomogeneous_params,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            showIndent(outfile, level)
            outfile.write('value="%s",\n' % (self.value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('inhomogeneousParam', node)
        if value is not None and 'inhomogeneousParam' not in already_processed:
            already_processed.add('inhomogeneousParam')
            self.inhomogeneous_params = value
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class InhomogeneousValue


class ReversalPotential(ValueAcrossSegOrSegGroup):
    member_data_items_ = [
        MemberSpec_('species', 'NmlId', 0),
    ]
    subclass = None
    superclass = ValueAcrossSegOrSegGroup
    def __init__(self, segments=None, segment_groups='all', value=None, species=None):
        super(ReversalPotential, self).__init__(segments, segment_groups, value, )
        self.species = _cast(None, species)
        pass
    def factory(*args_, **kwargs_):
        if ReversalPotential.subclass:
            return ReversalPotential.subclass(*args_, **kwargs_)
        else:
            return ReversalPotential(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(ReversalPotential, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReversalPotential', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReversalPotential')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReversalPotential'):
        super(ReversalPotential, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ReversalPotential')
        if self.species is not None and 'species' not in already_processed:
            already_processed.add('species')
            outfile.write(' species=%s' % (quote_attrib(self.species), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ReversalPotential', fromsubclass_=False, pretty_print=True):
        super(ReversalPotential, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='ReversalPotential'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.species is not None and 'species' not in already_processed:
            already_processed.add('species')
            showIndent(outfile, level)
            outfile.write('species="%s",\n' % (self.species,))
        super(ReversalPotential, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ReversalPotential, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('species', node)
        if value is not None and 'species' not in already_processed:
            already_processed.add('species')
            self.species = value
            self.validate_NmlId(self.species)    # validate type NmlId
        super(ReversalPotential, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ReversalPotential, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ReversalPotential


class Species(ValueAcrossSegOrSegGroup):
    """Specifying the ion here again is redundant, the ion name should be
    the same as id. Kept for now until LEMS implementation can
    select by id. TODO: remove."""
    member_data_items_ = [
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('initialExtConcentration', 'Nml2Quantity_concentration', 0),
        MemberSpec_('concentrationModel', 'NmlId', 0),
        MemberSpec_('id', 'NmlId', 0),
        MemberSpec_('initialConcentration', 'Nml2Quantity_concentration', 0),
    ]
    subclass = None
    superclass = ValueAcrossSegOrSegGroup
    def __init__(self, segments=None, segment_groups='all', value=None, ion=None, initial_ext_concentration=None, concentration_model=None, id=None, initial_concentration=None):
        super(Species, self).__init__(segments, segment_groups, value, )
        self.ion = _cast(None, ion)
        self.initial_ext_concentration = _cast(None, initial_ext_concentration)
        self.concentration_model = _cast(None, concentration_model)
        self.id = _cast(None, id)
        self.initial_concentration = _cast(None, initial_concentration)
        pass
    def factory(*args_, **kwargs_):
        if Species.subclass:
            return Species.subclass(*args_, **kwargs_)
        else:
            return Species(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(Species, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Species', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Species')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Species'):
        super(Species, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Species')
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
        if self.initial_ext_concentration is not None and 'initial_ext_concentration' not in already_processed:
            already_processed.add('initial_ext_concentration')
            outfile.write(' initialExtConcentration=%s' % (quote_attrib(self.initial_ext_concentration), ))
        if self.concentration_model is not None and 'concentration_model' not in already_processed:
            already_processed.add('concentration_model')
            outfile.write(' concentrationModel=%s' % (quote_attrib(self.concentration_model), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.initial_concentration is not None and 'initial_concentration' not in already_processed:
            already_processed.add('initial_concentration')
            outfile.write(' initialConcentration=%s' % (quote_attrib(self.initial_concentration), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Species', fromsubclass_=False, pretty_print=True):
        super(Species, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='Species'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            showIndent(outfile, level)
            outfile.write('ion="%s",\n' % (self.ion,))
        if self.initial_ext_concentration is not None and 'initial_ext_concentration' not in already_processed:
            already_processed.add('initial_ext_concentration')
            showIndent(outfile, level)
            outfile.write('initial_ext_concentration="%s",\n' % (self.initial_ext_concentration,))
        if self.concentration_model is not None and 'concentration_model' not in already_processed:
            already_processed.add('concentration_model')
            showIndent(outfile, level)
            outfile.write('concentration_model="%s",\n' % (self.concentration_model,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        if self.initial_concentration is not None and 'initial_concentration' not in already_processed:
            already_processed.add('initial_concentration')
            showIndent(outfile, level)
            outfile.write('initial_concentration="%s",\n' % (self.initial_concentration,))
        super(Species, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Species, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        value = find_attr_value_('initialExtConcentration', node)
        if value is not None and 'initialExtConcentration' not in already_processed:
            already_processed.add('initialExtConcentration')
            self.initial_ext_concentration = value
            self.validate_Nml2Quantity_concentration(self.initial_ext_concentration)    # validate type Nml2Quantity_concentration
        value = find_attr_value_('concentrationModel', node)
        if value is not None and 'concentrationModel' not in already_processed:
            already_processed.add('concentrationModel')
            self.concentration_model = value
            self.validate_NmlId(self.concentration_model)    # validate type NmlId
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_NmlId(self.id)    # validate type NmlId
        value = find_attr_value_('initialConcentration', node)
        if value is not None and 'initialConcentration' not in already_processed:
            already_processed.add('initialConcentration')
            self.initial_concentration = value
            self.validate_Nml2Quantity_concentration(self.initial_concentration)    # validate type Nml2Quantity_concentration
        super(Species, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Species, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Species


class IntracellularProperties(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('species', 'Species', 1),
        MemberSpec_('resistivities', 'ValueAcrossSegOrSegGroup', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, species=None, resistivities=None):
        if species is None:
            self.species = []
        else:
            self.species = species
        if resistivities is None:
            self.resistivities = []
        else:
            self.resistivities = resistivities
    def factory(*args_, **kwargs_):
        if IntracellularProperties.subclass:
            return IntracellularProperties.subclass(*args_, **kwargs_)
        else:
            return IntracellularProperties(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.species or
            self.resistivities
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IntracellularProperties', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IntracellularProperties')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IntracellularProperties'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='IntracellularProperties', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for species_ in self.species:
            species_.export(outfile, level, namespace_, name_='species', pretty_print=pretty_print)
        for resistivity_ in self.resistivities:
            resistivity_.export(outfile, level, namespace_, name_='resistivity', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IntracellularProperties'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('species=[\n')
        level += 1
        for species_ in self.species:
            showIndent(outfile, level)
            outfile.write('model_.Species(\n')
            species_.exportLiteral(outfile, level, name_='Species')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('resistivities=[\n')
        level += 1
        for resistivity_ in self.resistivities:
            showIndent(outfile, level)
            outfile.write('model_.ValueAcrossSegOrSegGroup(\n')
            resistivity_.exportLiteral(outfile, level, name_='ValueAcrossSegOrSegGroup')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'species':
            obj_ = Species.factory()
            obj_.build(child_)
            self.species.append(obj_)
        elif nodeName_ == 'resistivity':
            class_obj_ = self.get_class_obj_(child_, ValueAcrossSegOrSegGroup)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.resistivities.append(obj_)
# end class IntracellularProperties


class ExtracellularPropertiesLocal(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('species', 'Species', 1),
    ]
    subclass = None
    superclass = None
    def __init__(self, species=None):
        if species is None:
            self.species = []
        else:
            self.species = species
    def factory(*args_, **kwargs_):
        if ExtracellularPropertiesLocal.subclass:
            return ExtracellularPropertiesLocal.subclass(*args_, **kwargs_)
        else:
            return ExtracellularPropertiesLocal(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.species
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ExtracellularPropertiesLocal', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExtracellularPropertiesLocal')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ExtracellularPropertiesLocal'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ExtracellularPropertiesLocal', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for species_ in self.species:
            species_.export(outfile, level, namespace_, name_='species', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ExtracellularPropertiesLocal'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('species=[\n')
        level += 1
        for species_ in self.species:
            showIndent(outfile, level)
            outfile.write('model_.Species(\n')
            species_.exportLiteral(outfile, level, name_='Species')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'species':
            obj_ = Species.factory()
            obj_.build(child_)
            self.species.append(obj_)
# end class ExtracellularPropertiesLocal


class SpaceStructure(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('ySpacing', 'xs:float', 0),
        MemberSpec_('zStart', 'xs:float', 0),
        MemberSpec_('yStart', 'xs:float', 0),
        MemberSpec_('zSpacing', 'xs:float', 0),
        MemberSpec_('xStart', 'xs:float', 0),
        MemberSpec_('xSpacing', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, y_spacing=None, z_start=0, y_start=0, z_spacing=None, x_start=0, x_spacing=None):
        self.y_spacing = _cast(float, y_spacing)
        self.z_start = _cast(float, z_start)
        self.y_start = _cast(float, y_start)
        self.z_spacing = _cast(float, z_spacing)
        self.x_start = _cast(float, x_start)
        self.x_spacing = _cast(float, x_spacing)
        pass
    def factory(*args_, **kwargs_):
        if SpaceStructure.subclass:
            return SpaceStructure.subclass(*args_, **kwargs_)
        else:
            return SpaceStructure(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpaceStructure', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpaceStructure')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpaceStructure'):
        if self.y_spacing is not None and 'y_spacing' not in already_processed:
            already_processed.add('y_spacing')
            outfile.write(' ySpacing="%s"' % self.gds_format_float(self.y_spacing, input_name='ySpacing'))
        if self.z_start is not None and 'z_start' not in already_processed:
            already_processed.add('z_start')
            outfile.write(' zStart="%s"' % self.gds_format_float(self.z_start, input_name='zStart'))
        if self.y_start is not None and 'y_start' not in already_processed:
            already_processed.add('y_start')
            outfile.write(' yStart="%s"' % self.gds_format_float(self.y_start, input_name='yStart'))
        if self.z_spacing is not None and 'z_spacing' not in already_processed:
            already_processed.add('z_spacing')
            outfile.write(' zSpacing="%s"' % self.gds_format_float(self.z_spacing, input_name='zSpacing'))
        if self.x_start is not None and 'x_start' not in already_processed:
            already_processed.add('x_start')
            outfile.write(' xStart="%s"' % self.gds_format_float(self.x_start, input_name='xStart'))
        if self.x_spacing is not None and 'x_spacing' not in already_processed:
            already_processed.add('x_spacing')
            outfile.write(' xSpacing="%s"' % self.gds_format_float(self.x_spacing, input_name='xSpacing'))
    def exportChildren(self, outfile, level, namespace_='', name_='SpaceStructure', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='SpaceStructure'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.y_spacing is not None and 'y_spacing' not in already_processed:
            already_processed.add('y_spacing')
            showIndent(outfile, level)
            outfile.write('y_spacing=%f,\n' % (self.y_spacing,))
        if self.z_start is not None and 'z_start' not in already_processed:
            already_processed.add('z_start')
            showIndent(outfile, level)
            outfile.write('z_start=%f,\n' % (self.z_start,))
        if self.y_start is not None and 'y_start' not in already_processed:
            already_processed.add('y_start')
            showIndent(outfile, level)
            outfile.write('y_start=%f,\n' % (self.y_start,))
        if self.z_spacing is not None and 'z_spacing' not in already_processed:
            already_processed.add('z_spacing')
            showIndent(outfile, level)
            outfile.write('z_spacing=%f,\n' % (self.z_spacing,))
        if self.x_start is not None and 'x_start' not in already_processed:
            already_processed.add('x_start')
            showIndent(outfile, level)
            outfile.write('x_start=%f,\n' % (self.x_start,))
        if self.x_spacing is not None and 'x_spacing' not in already_processed:
            already_processed.add('x_spacing')
            showIndent(outfile, level)
            outfile.write('x_spacing=%f,\n' % (self.x_spacing,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ySpacing', node)
        if value is not None and 'ySpacing' not in already_processed:
            already_processed.add('ySpacing')
            try:
                self.y_spacing = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (ySpacing): %s' % exp)
        value = find_attr_value_('zStart', node)
        if value is not None and 'zStart' not in already_processed:
            already_processed.add('zStart')
            try:
                self.z_start = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (zStart): %s' % exp)
        value = find_attr_value_('yStart', node)
        if value is not None and 'yStart' not in already_processed:
            already_processed.add('yStart')
            try:
                self.y_start = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (yStart): %s' % exp)
        value = find_attr_value_('zSpacing', node)
        if value is not None and 'zSpacing' not in already_processed:
            already_processed.add('zSpacing')
            try:
                self.z_spacing = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (zSpacing): %s' % exp)
        value = find_attr_value_('xStart', node)
        if value is not None and 'xStart' not in already_processed:
            already_processed.add('xStart')
            try:
                self.x_start = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (xStart): %s' % exp)
        value = find_attr_value_('xSpacing', node)
        if value is not None and 'xSpacing' not in already_processed:
            already_processed.add('xSpacing')
            try:
                self.x_spacing = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (xSpacing): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SpaceStructure


class Layout(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('space', 'NmlId', 0),
        MemberSpec_('random', 'RandomLayout', 0),
        MemberSpec_('grid', 'GridLayout', 0),
        MemberSpec_('unstructured', 'UnstructuredLayout', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, spaces=None, random=None, grid=None, unstructured=None):
        self.spaces = _cast(None, spaces)
        self.random = random
        self.grid = grid
        self.unstructured = unstructured
    def factory(*args_, **kwargs_):
        if Layout.subclass:
            return Layout.subclass(*args_, **kwargs_)
        else:
            return Layout(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.random is not None or
            self.grid is not None or
            self.unstructured is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Layout', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Layout')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Layout'):
        if self.spaces is not None and 'spaces' not in already_processed:
            already_processed.add('spaces')
            outfile.write(' space=%s' % (quote_attrib(self.spaces), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Layout', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.random is not None:
            self.random.export(outfile, level, namespace_, name_='random', pretty_print=pretty_print)
        if self.grid is not None:
            self.grid.export(outfile, level, namespace_, name_='grid', pretty_print=pretty_print)
        if self.unstructured is not None:
            self.unstructured.export(outfile, level, namespace_, name_='unstructured', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Layout'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.spaces is not None and 'spaces' not in already_processed:
            already_processed.add('spaces')
            showIndent(outfile, level)
            outfile.write('spaces="%s",\n' % (self.spaces,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.random is not None:
            showIndent(outfile, level)
            outfile.write('random=model_.RandomLayout(\n')
            self.random.exportLiteral(outfile, level, name_='random')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.grid is not None:
            showIndent(outfile, level)
            outfile.write('grid=model_.GridLayout(\n')
            self.grid.exportLiteral(outfile, level, name_='grid')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.unstructured is not None:
            showIndent(outfile, level)
            outfile.write('unstructured=model_.UnstructuredLayout(\n')
            self.unstructured.exportLiteral(outfile, level, name_='unstructured')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('space', node)
        if value is not None and 'space' not in already_processed:
            already_processed.add('space')
            self.spaces = value
            self.validate_NmlId(self.spaces)    # validate type NmlId
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'random':
            obj_ = RandomLayout.factory()
            obj_.build(child_)
            self.random = obj_
        elif nodeName_ == 'grid':
            obj_ = GridLayout.factory()
            obj_.build(child_)
            self.grid = obj_
        elif nodeName_ == 'unstructured':
            obj_ = UnstructuredLayout.factory()
            obj_.build(child_)
            self.unstructured = obj_
# end class Layout


class UnstructuredLayout(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('number', 'xs:nonNegativeInteger', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, number=None):
        self.number = _cast(int, number)
        pass
    def factory(*args_, **kwargs_):
        if UnstructuredLayout.subclass:
            return UnstructuredLayout.subclass(*args_, **kwargs_)
        else:
            return UnstructuredLayout(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='UnstructuredLayout', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UnstructuredLayout')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='UnstructuredLayout'):
        if self.number is not None and 'number' not in already_processed:
            already_processed.add('number')
            outfile.write(' number="%s"' % self.gds_format_integer(self.number, input_name='number'))
    def exportChildren(self, outfile, level, namespace_='', name_='UnstructuredLayout', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='UnstructuredLayout'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.number is not None and 'number' not in already_processed:
            already_processed.add('number')
            showIndent(outfile, level)
            outfile.write('number=%d,\n' % (self.number,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('number', node)
        if value is not None and 'number' not in already_processed:
            already_processed.add('number')
            try:
                self.number = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.number < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class UnstructuredLayout


class RandomLayout(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('region', 'NmlId', 0),
        MemberSpec_('number', 'xs:nonNegativeInteger', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, regions=None, number=None):
        self.regions = _cast(None, regions)
        self.number = _cast(int, number)
        pass
    def factory(*args_, **kwargs_):
        if RandomLayout.subclass:
            return RandomLayout.subclass(*args_, **kwargs_)
        else:
            return RandomLayout(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='RandomLayout', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RandomLayout')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RandomLayout'):
        if self.regions is not None and 'regions' not in already_processed:
            already_processed.add('regions')
            outfile.write(' region=%s' % (quote_attrib(self.regions), ))
        if self.number is not None and 'number' not in already_processed:
            already_processed.add('number')
            outfile.write(' number="%s"' % self.gds_format_integer(self.number, input_name='number'))
    def exportChildren(self, outfile, level, namespace_='', name_='RandomLayout', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='RandomLayout'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.regions is not None and 'regions' not in already_processed:
            already_processed.add('regions')
            showIndent(outfile, level)
            outfile.write('regions="%s",\n' % (self.regions,))
        if self.number is not None and 'number' not in already_processed:
            already_processed.add('number')
            showIndent(outfile, level)
            outfile.write('number=%d,\n' % (self.number,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('region', node)
        if value is not None and 'region' not in already_processed:
            already_processed.add('region')
            self.regions = value
            self.validate_NmlId(self.regions)    # validate type NmlId
        value = find_attr_value_('number', node)
        if value is not None and 'number' not in already_processed:
            already_processed.add('number')
            try:
                self.number = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.number < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class RandomLayout


class GridLayout(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('zSize', 'xs:nonNegativeInteger', 0),
        MemberSpec_('ySize', 'xs:nonNegativeInteger', 0),
        MemberSpec_('xSize', 'xs:nonNegativeInteger', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, z_size=None, y_size=None, x_size=None):
        self.z_size = _cast(int, z_size)
        self.y_size = _cast(int, y_size)
        self.x_size = _cast(int, x_size)
        pass
    def factory(*args_, **kwargs_):
        if GridLayout.subclass:
            return GridLayout.subclass(*args_, **kwargs_)
        else:
            return GridLayout(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GridLayout', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GridLayout')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GridLayout'):
        if self.z_size is not None and 'z_size' not in already_processed:
            already_processed.add('z_size')
            outfile.write(' zSize="%s"' % self.gds_format_integer(self.z_size, input_name='zSize'))
        if self.y_size is not None and 'y_size' not in already_processed:
            already_processed.add('y_size')
            outfile.write(' ySize="%s"' % self.gds_format_integer(self.y_size, input_name='ySize'))
        if self.x_size is not None and 'x_size' not in already_processed:
            already_processed.add('x_size')
            outfile.write(' xSize="%s"' % self.gds_format_integer(self.x_size, input_name='xSize'))
    def exportChildren(self, outfile, level, namespace_='', name_='GridLayout', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='GridLayout'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.z_size is not None and 'z_size' not in already_processed:
            already_processed.add('z_size')
            showIndent(outfile, level)
            outfile.write('z_size=%d,\n' % (self.z_size,))
        if self.y_size is not None and 'y_size' not in already_processed:
            already_processed.add('y_size')
            showIndent(outfile, level)
            outfile.write('y_size=%d,\n' % (self.y_size,))
        if self.x_size is not None and 'x_size' not in already_processed:
            already_processed.add('x_size')
            showIndent(outfile, level)
            outfile.write('x_size=%d,\n' % (self.x_size,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('zSize', node)
        if value is not None and 'zSize' not in already_processed:
            already_processed.add('zSize')
            try:
                self.z_size = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.z_size < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('ySize', node)
        if value is not None and 'ySize' not in already_processed:
            already_processed.add('ySize')
            try:
                self.y_size = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.y_size < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('xSize', node)
        if value is not None and 'xSize' not in already_processed:
            already_processed.add('xSize')
            try:
                self.x_size = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.x_size < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class GridLayout


class Instance(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('i', 'xs:nonNegativeInteger', 0),
        MemberSpec_('k', 'xs:nonNegativeInteger', 0),
        MemberSpec_('j', 'xs:nonNegativeInteger', 0),
        MemberSpec_('id', 'xs:nonNegativeInteger', 0),
        MemberSpec_('location', 'Location', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, i=None, k=None, j=None, id=None, location=None):
        self.i = _cast(int, i)
        self.k = _cast(int, k)
        self.j = _cast(int, j)
        self.id = _cast(int, id)
        self.location = location
    def factory(*args_, **kwargs_):
        if Instance.subclass:
            return Instance.subclass(*args_, **kwargs_)
        else:
            return Instance(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.location is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Instance', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Instance')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Instance'):
        if self.i is not None and 'i' not in already_processed:
            already_processed.add('i')
            outfile.write(' i="%s"' % self.gds_format_integer(self.i, input_name='i'))
        if self.k is not None and 'k' not in already_processed:
            already_processed.add('k')
            outfile.write(' k="%s"' % self.gds_format_integer(self.k, input_name='k'))
        if self.j is not None and 'j' not in already_processed:
            already_processed.add('j')
            outfile.write(' j="%s"' % self.gds_format_integer(self.j, input_name='j'))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='Instance', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.location is not None:
            self.location.export(outfile, level, namespace_, name_='location', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Instance'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.i is not None and 'i' not in already_processed:
            already_processed.add('i')
            showIndent(outfile, level)
            outfile.write('i=%d,\n' % (self.i,))
        if self.k is not None and 'k' not in already_processed:
            already_processed.add('k')
            showIndent(outfile, level)
            outfile.write('k=%d,\n' % (self.k,))
        if self.j is not None and 'j' not in already_processed:
            already_processed.add('j')
            showIndent(outfile, level)
            outfile.write('j=%d,\n' % (self.j,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id=%d,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.location is not None:
            showIndent(outfile, level)
            outfile.write('location=model_.Location(\n')
            self.location.exportLiteral(outfile, level, name_='location')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('i', node)
        if value is not None and 'i' not in already_processed:
            already_processed.add('i')
            try:
                self.i = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.i < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('k', node)
        if value is not None and 'k' not in already_processed:
            already_processed.add('k')
            try:
                self.k = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.k < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('j', node)
        if value is not None and 'j' not in already_processed:
            already_processed.add('j')
            try:
                self.j = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.j < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'location':
            obj_ = Location.factory()
            obj_.build(child_)
            self.location = obj_
# end class Instance


class Location(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('y', 'xs:float', 0),
        MemberSpec_('x', 'xs:float', 0),
        MemberSpec_('z', 'xs:float', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, y=None, x=None, z=None):
        self.y = _cast(float, y)
        self.x = _cast(float, x)
        self.z = _cast(float, z)
        pass
    def factory(*args_, **kwargs_):
        if Location.subclass:
            return Location.subclass(*args_, **kwargs_)
        else:
            return Location(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Location', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Location')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Location'):
        if self.y is not None and 'y' not in already_processed:
            already_processed.add('y')
            outfile.write(' y="%s"' % self.gds_format_float(self.y, input_name='y'))
        if self.x is not None and 'x' not in already_processed:
            already_processed.add('x')
            outfile.write(' x="%s"' % self.gds_format_float(self.x, input_name='x'))
        if self.z is not None and 'z' not in already_processed:
            already_processed.add('z')
            outfile.write(' z="%s"' % self.gds_format_float(self.z, input_name='z'))
    def exportChildren(self, outfile, level, namespace_='', name_='Location', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Location'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.y is not None and 'y' not in already_processed:
            already_processed.add('y')
            showIndent(outfile, level)
            outfile.write('y=%f,\n' % (self.y,))
        if self.x is not None and 'x' not in already_processed:
            already_processed.add('x')
            showIndent(outfile, level)
            outfile.write('x=%f,\n' % (self.x,))
        if self.z is not None and 'z' not in already_processed:
            already_processed.add('z')
            showIndent(outfile, level)
            outfile.write('z=%f,\n' % (self.z,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('y', node)
        if value is not None and 'y' not in already_processed:
            already_processed.add('y')
            try:
                self.y = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (y): %s' % exp)
        value = find_attr_value_('x', node)
        if value is not None and 'x' not in already_processed:
            already_processed.add('x')
            try:
                self.x = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (x): %s' % exp)
        value = find_attr_value_('z', node)
        if value is not None and 'z' not in already_processed:
            already_processed.add('z')
            try:
                self.z = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (z): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Location


class SynapticConnection(GeneratedsSuper):
    """Single explicit connection. Introduced to test connections in LEMS.
    Will probably be removed in favour of connections wrapped in
    projection element"""
    member_data_items_ = [
        MemberSpec_('to', 'xs:string', 0),
        MemberSpec_('synapse', 'xs:string', 0),
        MemberSpec_('from', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, to=None, synapse=None, from_=None):
        self.to = _cast(None, to)
        self.synapse = _cast(None, synapse)
        self.from_ = _cast(None, from_)
        pass
    def factory(*args_, **kwargs_):
        if SynapticConnection.subclass:
            return SynapticConnection.subclass(*args_, **kwargs_)
        else:
            return SynapticConnection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SynapticConnection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SynapticConnection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SynapticConnection'):
        if self.to is not None and 'to' not in already_processed:
            already_processed.add('to')
            outfile.write(' to=%s' % (self.gds_format_string(quote_attrib(self.to).encode(ExternalEncoding), input_name='to'), ))
        if self.synapse is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            outfile.write(' synapse=%s' % (self.gds_format_string(quote_attrib(self.synapse).encode(ExternalEncoding), input_name='synapse'), ))
        if self.from_ is not None and 'from_' not in already_processed:
            already_processed.add('from_')
            outfile.write(' from=%s' % (self.gds_format_string(quote_attrib(self.from_).encode(ExternalEncoding), input_name='from'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SynapticConnection', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='SynapticConnection'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.to is not None and 'to' not in already_processed:
            already_processed.add('to')
            showIndent(outfile, level)
            outfile.write('to="%s",\n' % (self.to,))
        if self.synapse is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            showIndent(outfile, level)
            outfile.write('synapse="%s",\n' % (self.synapse,))
        if self.from_ is not None and 'from_' not in already_processed:
            already_processed.add('from_')
            showIndent(outfile, level)
            outfile.write('from_="%s",\n' % (self.from_,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('to', node)
        if value is not None and 'to' not in already_processed:
            already_processed.add('to')
            self.to = value
        value = find_attr_value_('synapse', node)
        if value is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            self.synapse = value
        value = find_attr_value_('from', node)
        if value is not None and 'from' not in already_processed:
            already_processed.add('from')
            self.from_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SynapticConnection


class Connection(GeneratedsSuper):
    """Subject to change as it gets tested with LEMS!!"""
    member_data_items_ = [
        MemberSpec_('preFractionAlong', 'ZeroToOne', 0),
        MemberSpec_('preCellId', 'xs:string', 0),
        MemberSpec_('postFractionAlong', 'ZeroToOne', 0),
        MemberSpec_('postSegmentId', 'SegmentId', 0),
        MemberSpec_('postCellId', 'xs:string', 0),
        MemberSpec_('preSegmentId', 'SegmentId', 0),
        MemberSpec_('id', 'xs:nonNegativeInteger', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, pre_fraction_along=None, pre_cell_id=None, post_fraction_along=None, post_segment_id=None, post_cell_id=None, pre_segment_id=None, id=None):
        self.pre_fraction_along = _cast(None, pre_fraction_along)
        self.pre_cell_id = _cast(None, pre_cell_id)
        self.post_fraction_along = _cast(None, post_fraction_along)
        self.post_segment_id = _cast(None, post_segment_id)
        self.post_cell_id = _cast(None, post_cell_id)
        self.pre_segment_id = _cast(None, pre_segment_id)
        self.id = _cast(int, id)
        pass
    def factory(*args_, **kwargs_):
        if Connection.subclass:
            return Connection.subclass(*args_, **kwargs_)
        else:
            return Connection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:double.
        pass
    def validate_SegmentId(self, value):
        # Validate type SegmentId, a restriction on xs:nonNegativeInteger.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Connection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Connection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Connection'):
        if self.pre_fraction_along is not None and 'pre_fraction_along' not in already_processed:
            already_processed.add('pre_fraction_along')
            outfile.write(' preFractionAlong=%s' % (quote_attrib(self.pre_fraction_along), ))
        if self.pre_cell_id is not None and 'pre_cell_id' not in already_processed:
            already_processed.add('pre_cell_id')
            outfile.write(' preCellId=%s' % (self.gds_format_string(quote_attrib(self.pre_cell_id).encode(ExternalEncoding), input_name='preCellId'), ))
        if self.post_fraction_along is not None and 'post_fraction_along' not in already_processed:
            already_processed.add('post_fraction_along')
            outfile.write(' postFractionAlong=%s' % (quote_attrib(self.post_fraction_along), ))
        if self.post_segment_id is not None and 'post_segment_id' not in already_processed:
            already_processed.add('post_segment_id')
            outfile.write(' postSegmentId=%s' % (quote_attrib(self.post_segment_id), ))
        if self.post_cell_id is not None and 'post_cell_id' not in already_processed:
            already_processed.add('post_cell_id')
            outfile.write(' postCellId=%s' % (self.gds_format_string(quote_attrib(self.post_cell_id).encode(ExternalEncoding), input_name='postCellId'), ))
        if self.pre_segment_id is not None and 'pre_segment_id' not in already_processed:
            already_processed.add('pre_segment_id')
            outfile.write(' preSegmentId=%s' % (quote_attrib(self.pre_segment_id), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='Connection', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Connection'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.pre_fraction_along is not None and 'pre_fraction_along' not in already_processed:
            already_processed.add('pre_fraction_along')
            showIndent(outfile, level)
            outfile.write('pre_fraction_along=%e,\n' % (self.pre_fraction_along,))
        if self.pre_cell_id is not None and 'pre_cell_id' not in already_processed:
            already_processed.add('pre_cell_id')
            showIndent(outfile, level)
            outfile.write('pre_cell_id="%s",\n' % (self.pre_cell_id,))
        if self.post_fraction_along is not None and 'post_fraction_along' not in already_processed:
            already_processed.add('post_fraction_along')
            showIndent(outfile, level)
            outfile.write('post_fraction_along=%e,\n' % (self.post_fraction_along,))
        if self.post_segment_id is not None and 'post_segment_id' not in already_processed:
            already_processed.add('post_segment_id')
            showIndent(outfile, level)
            outfile.write('post_segment_id=%d,\n' % (self.post_segment_id,))
        if self.post_cell_id is not None and 'post_cell_id' not in already_processed:
            already_processed.add('post_cell_id')
            showIndent(outfile, level)
            outfile.write('post_cell_id="%s",\n' % (self.post_cell_id,))
        if self.pre_segment_id is not None and 'pre_segment_id' not in already_processed:
            already_processed.add('pre_segment_id')
            showIndent(outfile, level)
            outfile.write('pre_segment_id=%d,\n' % (self.pre_segment_id,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id=%d,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('preFractionAlong', node)
        if value is not None and 'preFractionAlong' not in already_processed:
            already_processed.add('preFractionAlong')
            try:
                self.pre_fraction_along = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (preFractionAlong): %s' % exp)
            self.validate_ZeroToOne(self.pre_fraction_along)    # validate type ZeroToOne
        value = find_attr_value_('preCellId', node)
        if value is not None and 'preCellId' not in already_processed:
            already_processed.add('preCellId')
            self.pre_cell_id = value
        value = find_attr_value_('postFractionAlong', node)
        if value is not None and 'postFractionAlong' not in already_processed:
            already_processed.add('postFractionAlong')
            try:
                self.post_fraction_along = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (postFractionAlong): %s' % exp)
            self.validate_ZeroToOne(self.post_fraction_along)    # validate type ZeroToOne
        value = find_attr_value_('postSegmentId', node)
        if value is not None and 'postSegmentId' not in already_processed:
            already_processed.add('postSegmentId')
            try:
                self.post_segment_id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.post_segment_id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_SegmentId(self.post_segment_id)    # validate type SegmentId
        value = find_attr_value_('postCellId', node)
        if value is not None and 'postCellId' not in already_processed:
            already_processed.add('postCellId')
            self.post_cell_id = value
        value = find_attr_value_('preSegmentId', node)
        if value is not None and 'preSegmentId' not in already_processed:
            already_processed.add('preSegmentId')
            try:
                self.pre_segment_id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.pre_segment_id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_SegmentId(self.pre_segment_id)    # validate type SegmentId
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Connection


class ExplicitInput(GeneratedsSuper):
    """Single explicit input. Introduced to test inputs in LEMS. Will
    probably be removed in favour of inputs wrapped in inputList
    element"""
    member_data_items_ = [
        MemberSpec_('input', 'xs:string', 0),
        MemberSpec_('destination', 'xs:string', 0),
        MemberSpec_('target', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, input=None, destination=None, target=None):
        self.input = _cast(None, input)
        self.destination = _cast(None, destination)
        self.target = _cast(None, target)
        pass
    def factory(*args_, **kwargs_):
        if ExplicitInput.subclass:
            return ExplicitInput.subclass(*args_, **kwargs_)
        else:
            return ExplicitInput(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ExplicitInput', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExplicitInput')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ExplicitInput'):
        if self.input is not None and 'input' not in already_processed:
            already_processed.add('input')
            outfile.write(' input=%s' % (self.gds_format_string(quote_attrib(self.input).encode(ExternalEncoding), input_name='input'), ))
        if self.destination is not None and 'destination' not in already_processed:
            already_processed.add('destination')
            outfile.write(' destination=%s' % (self.gds_format_string(quote_attrib(self.destination).encode(ExternalEncoding), input_name='destination'), ))
        if self.target is not None and 'target' not in already_processed:
            already_processed.add('target')
            outfile.write(' target=%s' % (self.gds_format_string(quote_attrib(self.target).encode(ExternalEncoding), input_name='target'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ExplicitInput', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='ExplicitInput'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.input is not None and 'input' not in already_processed:
            already_processed.add('input')
            showIndent(outfile, level)
            outfile.write('input="%s",\n' % (self.input,))
        if self.destination is not None and 'destination' not in already_processed:
            already_processed.add('destination')
            showIndent(outfile, level)
            outfile.write('destination="%s",\n' % (self.destination,))
        if self.target is not None and 'target' not in already_processed:
            already_processed.add('target')
            showIndent(outfile, level)
            outfile.write('target="%s",\n' % (self.target,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('input', node)
        if value is not None and 'input' not in already_processed:
            already_processed.add('input')
            self.input = value
        value = find_attr_value_('destination', node)
        if value is not None and 'destination' not in already_processed:
            already_processed.add('destination')
            self.destination = value
        value = find_attr_value_('target', node)
        if value is not None and 'target' not in already_processed:
            already_processed.add('target')
            self.target = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ExplicitInput


class Input(GeneratedsSuper):
    """Subject to change as it gets tested with LEMS"""
    member_data_items_ = [
        MemberSpec_('destination', 'NmlId', 0),
        MemberSpec_('id', 'xs:nonNegativeInteger', 0),
        MemberSpec_('target', 'xs:string', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, destination=None, id=None, target=None):
        self.destination = _cast(None, destination)
        self.id = _cast(int, id)
        self.target = _cast(None, target)
        pass
    def factory(*args_, **kwargs_):
        if Input.subclass:
            return Input.subclass(*args_, **kwargs_)
        else:
            return Input(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Input', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Input')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Input'):
        if self.destination is not None and 'destination' not in already_processed:
            already_processed.add('destination')
            outfile.write(' destination=%s' % (quote_attrib(self.destination), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
        if self.target is not None and 'target' not in already_processed:
            already_processed.add('target')
            outfile.write(' target=%s' % (self.gds_format_string(quote_attrib(self.target).encode(ExternalEncoding), input_name='target'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Input', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='Input'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.destination is not None and 'destination' not in already_processed:
            already_processed.add('destination')
            showIndent(outfile, level)
            outfile.write('destination="%s",\n' % (self.destination,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id=%d,\n' % (self.id,))
        if self.target is not None and 'target' not in already_processed:
            already_processed.add('target')
            showIndent(outfile, level)
            outfile.write('target="%s",\n' % (self.target,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('destination', node)
        if value is not None and 'destination' not in already_processed:
            already_processed.add('destination')
            self.destination = value
            self.validate_NmlId(self.destination)    # validate type NmlId
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('target', node)
        if value is not None and 'target' not in already_processed:
            already_processed.add('target')
            self.target = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Input


class BaseWithoutId(GeneratedsSuper):
    """Base element without ID specified *yet*, e.g. for an element with a
    particular requirement on its id which does not comply with
    NmlId (e.g. Segment needs nonNegativeInteger)."""
    member_data_items_ = [
        MemberSpec_('neuroLexId', 'NeuroLexId', 0),
    ]
    subclass = None
    superclass = None
    def __init__(self, neuro_lex_id=None, extensiontype_=None):
        self.neuro_lex_id = _cast(None, neuro_lex_id)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseWithoutId.subclass:
            return BaseWithoutId.subclass(*args_, **kwargs_)
        else:
            return BaseWithoutId(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NeuroLexId(self, value):
        # Validate type NeuroLexId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseWithoutId', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseWithoutId')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseWithoutId'):
        if self.neuro_lex_id is not None and 'neuro_lex_id' not in already_processed:
            already_processed.add('neuro_lex_id')
            outfile.write(' neuroLexId=%s' % (quote_attrib(self.neuro_lex_id), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseWithoutId', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='BaseWithoutId'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.neuro_lex_id is not None and 'neuro_lex_id' not in already_processed:
            already_processed.add('neuro_lex_id')
            showIndent(outfile, level)
            outfile.write('neuro_lex_id="%s",\n' % (self.neuro_lex_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('neuroLexId', node)
        if value is not None and 'neuroLexId' not in already_processed:
            already_processed.add('neuroLexId')
            self.neuro_lex_id = value
            self.validate_NeuroLexId(self.neuro_lex_id)    # validate type NeuroLexId
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class BaseWithoutId


class Base(BaseWithoutId):
    """Anything which can have a unique (within its parent) id of the form
    NmlId (spaceless combination of letters, numbers and
    underscore)."""
    member_data_items_ = [
        MemberSpec_('id', 'NmlId', 0),
    ]
    subclass = None
    superclass = BaseWithoutId
    def __init__(self, neuro_lex_id=None, id=None, extensiontype_=None):
        super(Base, self).__init__(neuro_lex_id, extensiontype_, )
        self.id = _cast(None, id)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if Base.subclass:
            return Base.subclass(*args_, **kwargs_)
        else:
            return Base(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(Base, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Base', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Base')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Base'):
        super(Base, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Base')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='Base', fromsubclass_=False, pretty_print=True):
        super(Base, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='Base'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id="%s",\n' % (self.id,))
        super(Base, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Base, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_NmlId(self.id)    # validate type NmlId
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(Base, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Base, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Base


class Standalone(Base):
    """Elements which can stand alone and be referenced by id, e.g. cell,
    morphology."""
    member_data_items_ = [
        MemberSpec_('metaid', 'MetaId', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('annotation', 'Annotation', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, extensiontype_=None):
        super(Standalone, self).__init__(neuro_lex_id, id, extensiontype_, )
        self.metaid = _cast(None, metaid)
        self.notes = notes
        self.annotation = annotation
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if Standalone.subclass:
            return Standalone.subclass(*args_, **kwargs_)
        else:
            return Standalone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        pass
    def validate_MetaId(self, value):
        # Validate type MetaId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.annotation is not None or
            super(Standalone, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Standalone', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Standalone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Standalone'):
        super(Standalone, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Standalone')
        if self.metaid is not None and 'metaid' not in already_processed:
            already_processed.add('metaid')
            outfile.write(' metaid=%s' % (quote_attrib(self.metaid), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='Standalone', fromsubclass_=False, pretty_print=True):
        super(Standalone, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_format_string(quote_xml(self.notes).encode(ExternalEncoding), input_name='notes'), namespace_, eol_))
        if self.annotation is not None:
            self.annotation.export(outfile, level, namespace_, name_='annotation', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Standalone'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.metaid is not None and 'metaid' not in already_processed:
            already_processed.add('metaid')
            showIndent(outfile, level)
            outfile.write('metaid="%s",\n' % (self.metaid,))
        super(Standalone, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Standalone, self).exportLiteralChildren(outfile, level, name_)
        if self.notes is not None:
            showIndent(outfile, level)
            outfile.write('notes=%s,\n' % quote_python(self.notes).encode(ExternalEncoding))
        if self.annotation is not None:
            showIndent(outfile, level)
            outfile.write('annotation=model_.Annotation(\n')
            self.annotation.exportLiteral(outfile, level, name_='annotation')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('metaid', node)
        if value is not None and 'metaid' not in already_processed:
            already_processed.add('metaid')
            self.metaid = value
            self.validate_MetaId(self.metaid)    # validate type MetaId
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(Standalone, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            self.validate_Notes(self.notes)    # validate type Notes
        elif nodeName_ == 'annotation':
            obj_ = Annotation.factory()
            obj_.build(child_)
            self.annotation = obj_
        super(Standalone, self).buildChildren(child_, node, nodeName_, True)
# end class Standalone


class SpikeSourcePoisson(Standalone):
    member_data_items_ = [
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('start', 'Nml2Quantity_time', 0),
        MemberSpec_('rate', 'Nml2Quantity_pertime', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, duration=None, start=None, rate=None):
        super(SpikeSourcePoisson, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.duration = _cast(None, duration)
        self.start = _cast(None, start)
        self.rate = _cast(None, rate)
        pass
    def factory(*args_, **kwargs_):
        if SpikeSourcePoisson.subclass:
            return SpikeSourcePoisson.subclass(*args_, **kwargs_)
        else:
            return SpikeSourcePoisson(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(SpikeSourcePoisson, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpikeSourcePoisson', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeSourcePoisson')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpikeSourcePoisson'):
        super(SpikeSourcePoisson, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeSourcePoisson')
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.start is not None and 'start' not in already_processed:
            already_processed.add('start')
            outfile.write(' start=%s' % (quote_attrib(self.start), ))
        if self.rate is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            outfile.write(' rate=%s' % (quote_attrib(self.rate), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SpikeSourcePoisson', fromsubclass_=False, pretty_print=True):
        super(SpikeSourcePoisson, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SpikeSourcePoisson'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            showIndent(outfile, level)
            outfile.write('duration="%s",\n' % (self.duration,))
        if self.start is not None and 'start' not in already_processed:
            already_processed.add('start')
            showIndent(outfile, level)
            outfile.write('start="%s",\n' % (self.start,))
        if self.rate is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            showIndent(outfile, level)
            outfile.write('rate="%s",\n' % (self.rate,))
        super(SpikeSourcePoisson, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SpikeSourcePoisson, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('start', node)
        if value is not None and 'start' not in already_processed:
            already_processed.add('start')
            self.start = value
            self.validate_Nml2Quantity_time(self.start)    # validate type Nml2Quantity_time
        value = find_attr_value_('rate', node)
        if value is not None and 'rate' not in already_processed:
            already_processed.add('rate')
            self.rate = value
            self.validate_Nml2Quantity_pertime(self.rate)    # validate type Nml2Quantity_pertime
        super(SpikeSourcePoisson, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeSourcePoisson, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SpikeSourcePoisson


class InputList(Base):
    """Subject to change as it gets tested with LEMS"""
    member_data_items_ = [
        MemberSpec_('component', 'NmlId', 0),
        MemberSpec_('population', 'NmlId', 0),
        MemberSpec_('input', 'Input', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, component=None, populations=None, input=None):
        super(InputList, self).__init__(neuro_lex_id, id, )
        self.component = _cast(None, component)
        self.populations = _cast(None, populations)
        if input is None:
            self.input = []
        else:
            self.input = input
    def factory(*args_, **kwargs_):
        if InputList.subclass:
            return InputList.subclass(*args_, **kwargs_)
        else:
            return InputList(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.input or
            super(InputList, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='InputList', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InputList')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='InputList'):
        super(InputList, self).exportAttributes(outfile, level, already_processed, namespace_, name_='InputList')
        if self.component is not None and 'component' not in already_processed:
            already_processed.add('component')
            outfile.write(' component=%s' % (quote_attrib(self.component), ))
        if self.populations is not None and 'populations' not in already_processed:
            already_processed.add('populations')
            outfile.write(' population=%s' % (quote_attrib(self.populations), ))
    def exportChildren(self, outfile, level, namespace_='', name_='InputList', fromsubclass_=False, pretty_print=True):
        super(InputList, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for input_ in self.input:
            input_.export(outfile, level, namespace_, name_='input', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='InputList'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.component is not None and 'component' not in already_processed:
            already_processed.add('component')
            showIndent(outfile, level)
            outfile.write('component="%s",\n' % (self.component,))
        if self.populations is not None and 'populations' not in already_processed:
            already_processed.add('populations')
            showIndent(outfile, level)
            outfile.write('populations="%s",\n' % (self.populations,))
        super(InputList, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(InputList, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('input=[\n')
        level += 1
        for input_ in self.input:
            showIndent(outfile, level)
            outfile.write('model_.Input(\n')
            input_.exportLiteral(outfile, level, name_='Input')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('component', node)
        if value is not None and 'component' not in already_processed:
            already_processed.add('component')
            self.component = value
            self.validate_NmlId(self.component)    # validate type NmlId
        value = find_attr_value_('population', node)
        if value is not None and 'population' not in already_processed:
            already_processed.add('population')
            self.populations = value
            self.validate_NmlId(self.populations)    # validate type NmlId
        super(InputList, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'input':
            obj_ = Input.factory()
            obj_.build(child_)
            self.input.append(obj_)
        super(InputList, self).buildChildren(child_, node, nodeName_, True)
# end class InputList


class Projection(Base):
    """Subject to change as it gets tested with LEMS"""
    member_data_items_ = [
        MemberSpec_('postsynapticPopulation', 'NmlId', 0),
        MemberSpec_('presynapticPopulation', 'NmlId', 0),
        MemberSpec_('synapse', 'NmlId', 0),
        MemberSpec_('connections', 'Connection', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, postsynaptic_population=None, presynaptic_population=None, synapse=None, connections=None):
        super(Projection, self).__init__(neuro_lex_id, id, )
        self.postsynaptic_population = _cast(None, postsynaptic_population)
        self.presynaptic_population = _cast(None, presynaptic_population)
        self.synapse = _cast(None, synapse)
        if connections is None:
            self.connections = []
        else:
            self.connections = connections
    def factory(*args_, **kwargs_):
        if Projection.subclass:
            return Projection.subclass(*args_, **kwargs_)
        else:
            return Projection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.connections or
            super(Projection, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Projection', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Projection')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Projection'):
        super(Projection, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Projection')
        if self.postsynaptic_population is not None and 'postsynaptic_population' not in already_processed:
            already_processed.add('postsynaptic_population')
            outfile.write(' postsynapticPopulation=%s' % (quote_attrib(self.postsynaptic_population), ))
        if self.presynaptic_population is not None and 'presynaptic_population' not in already_processed:
            already_processed.add('presynaptic_population')
            outfile.write(' presynapticPopulation=%s' % (quote_attrib(self.presynaptic_population), ))
        if self.synapse is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            outfile.write(' synapse=%s' % (quote_attrib(self.synapse), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Projection', fromsubclass_=False, pretty_print=True):
        super(Projection, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for connection_ in self.connections:
            connection_.export(outfile, level, namespace_, name_='connection', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Projection'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.postsynaptic_population is not None and 'postsynaptic_population' not in already_processed:
            already_processed.add('postsynaptic_population')
            showIndent(outfile, level)
            outfile.write('postsynaptic_population="%s",\n' % (self.postsynaptic_population,))
        if self.presynaptic_population is not None and 'presynaptic_population' not in already_processed:
            already_processed.add('presynaptic_population')
            showIndent(outfile, level)
            outfile.write('presynaptic_population="%s",\n' % (self.presynaptic_population,))
        if self.synapse is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            showIndent(outfile, level)
            outfile.write('synapse="%s",\n' % (self.synapse,))
        super(Projection, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Projection, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('connections=[\n')
        level += 1
        for connection_ in self.connections:
            showIndent(outfile, level)
            outfile.write('model_.Connection(\n')
            connection_.exportLiteral(outfile, level, name_='Connection')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('postsynapticPopulation', node)
        if value is not None and 'postsynapticPopulation' not in already_processed:
            already_processed.add('postsynapticPopulation')
            self.postsynaptic_population = value
            self.validate_NmlId(self.postsynaptic_population)    # validate type NmlId
        value = find_attr_value_('presynapticPopulation', node)
        if value is not None and 'presynapticPopulation' not in already_processed:
            already_processed.add('presynapticPopulation')
            self.presynaptic_population = value
            self.validate_NmlId(self.presynaptic_population)    # validate type NmlId
        value = find_attr_value_('synapse', node)
        if value is not None and 'synapse' not in already_processed:
            already_processed.add('synapse')
            self.synapse = value
            self.validate_NmlId(self.synapse)    # validate type NmlId
        super(Projection, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'connection':
            obj_ = Connection.factory()
            obj_.build(child_)
            self.connections.append(obj_)
        super(Projection, self).buildChildren(child_, node, nodeName_, True)
# end class Projection


class CellSet(Base):
    member_data_items_ = [
        MemberSpec_('select', 'xs:string', 0),
        MemberSpec_('', 'xs:string', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, select=None, anytypeobjs_=None):
        super(CellSet, self).__init__(neuro_lex_id, id, )
        self.select = _cast(None, select)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if CellSet.subclass:
            return CellSet.subclass(*args_, **kwargs_)
        else:
            return CellSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.anytypeobjs_ or
            super(CellSet, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CellSet', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CellSet')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CellSet'):
        super(CellSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CellSet')
        if self.select is not None and 'select' not in already_processed:
            already_processed.add('select')
            outfile.write(' select=%s' % (self.gds_format_string(quote_attrib(self.select).encode(ExternalEncoding), input_name='select'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='CellSet', fromsubclass_=False, pretty_print=True):
        super(CellSet, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='CellSet'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.select is not None and 'select' not in already_processed:
            already_processed.add('select')
            showIndent(outfile, level)
            outfile.write('select="%s",\n' % (self.select,))
        super(CellSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CellSet, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('select', node)
        if value is not None and 'select' not in already_processed:
            already_processed.add('select')
            self.select = value
        super(CellSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'CellSet')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(CellSet, self).buildChildren(child_, node, nodeName_, True)
# end class CellSet


class Population(Standalone):
    member_data_items_ = [
        MemberSpec_('extracellularProperties', 'NmlId', 0),
        MemberSpec_('network', 'NmlId', 0),
        MemberSpec_('component', 'NmlId', 0),
        MemberSpec_('cell', 'NmlId', 0),
        MemberSpec_('type', 'populationTypes', 0),
        MemberSpec_('size', 'xs:integer', 0),
        MemberSpec_('layout', 'Layout', 0),
        MemberSpec_('instances', 'Instance', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, extracellular_properties=None, networks=None, component=None, cells=None, type=None, size=None, layout=None, instances=None):
        super(Population, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.extracellular_properties = _cast(None, extracellular_properties)
        self.networks = _cast(None, networks)
        self.component = _cast(None, component)
        self.cells = _cast(None, cells)
        self.type = _cast(None, type)
        self.size = _cast(int, size)
        self.layout = layout
        if instances is None:
            self.instances = []
        else:
            self.instances = instances
    def factory(*args_, **kwargs_):
        if Population.subclass:
            return Population.subclass(*args_, **kwargs_)
        else:
            return Population(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def validate_populationTypes(self, value):
        # Validate type populationTypes, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.layout is not None or
            self.instances or
            super(Population, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Population', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Population')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Population'):
        super(Population, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Population')
        if self.extracellular_properties is not None and 'extracellular_properties' not in already_processed:
            already_processed.add('extracellular_properties')
            outfile.write(' extracellularProperties=%s' % (quote_attrib(self.extracellular_properties), ))
        if self.networks is not None and 'networks' not in already_processed:
            already_processed.add('networks')
            outfile.write(' network=%s' % (quote_attrib(self.networks), ))
        if self.component is not None and 'component' not in already_processed:
            already_processed.add('component')
            outfile.write(' component=%s' % (quote_attrib(self.component), ))
        if self.cells is not None and 'cells' not in already_processed:
            already_processed.add('cells')
            outfile.write(' cell=%s' % (quote_attrib(self.cells), ))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            outfile.write(' size="%s"' % self.gds_format_integer(self.size, input_name='size'))
    def exportChildren(self, outfile, level, namespace_='', name_='Population', fromsubclass_=False, pretty_print=True):
        super(Population, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.layout is not None:
            self.layout.export(outfile, level, namespace_, name_='layout', pretty_print=pretty_print)
        for instance_ in self.instances:
            instance_.export(outfile, level, namespace_, name_='instance', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Population'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.extracellular_properties is not None and 'extracellular_properties' not in already_processed:
            already_processed.add('extracellular_properties')
            showIndent(outfile, level)
            outfile.write('extracellular_properties="%s",\n' % (self.extracellular_properties,))
        if self.networks is not None and 'networks' not in already_processed:
            already_processed.add('networks')
            showIndent(outfile, level)
            outfile.write('networks="%s",\n' % (self.networks,))
        if self.component is not None and 'component' not in already_processed:
            already_processed.add('component')
            showIndent(outfile, level)
            outfile.write('component="%s",\n' % (self.component,))
        if self.cells is not None and 'cells' not in already_processed:
            already_processed.add('cells')
            showIndent(outfile, level)
            outfile.write('cells="%s",\n' % (self.cells,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        if self.size is not None and 'size' not in already_processed:
            already_processed.add('size')
            showIndent(outfile, level)
            outfile.write('size=%d,\n' % (self.size,))
        super(Population, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Population, self).exportLiteralChildren(outfile, level, name_)
        if self.layout is not None:
            showIndent(outfile, level)
            outfile.write('layout=model_.Layout(\n')
            self.layout.exportLiteral(outfile, level, name_='layout')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('instances=[\n')
        level += 1
        for instance_ in self.instances:
            showIndent(outfile, level)
            outfile.write('model_.Instance(\n')
            instance_.exportLiteral(outfile, level, name_='Instance')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('extracellularProperties', node)
        if value is not None and 'extracellularProperties' not in already_processed:
            already_processed.add('extracellularProperties')
            self.extracellular_properties = value
            self.validate_NmlId(self.extracellular_properties)    # validate type NmlId
        value = find_attr_value_('network', node)
        if value is not None and 'network' not in already_processed:
            already_processed.add('network')
            self.networks = value
            self.validate_NmlId(self.networks)    # validate type NmlId
        value = find_attr_value_('component', node)
        if value is not None and 'component' not in already_processed:
            already_processed.add('component')
            self.component = value
            self.validate_NmlId(self.component)    # validate type NmlId
        value = find_attr_value_('cell', node)
        if value is not None and 'cell' not in already_processed:
            already_processed.add('cell')
            self.cells = value
            self.validate_NmlId(self.cells)    # validate type NmlId
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_populationTypes(self.type)    # validate type populationTypes
        value = find_attr_value_('size', node)
        if value is not None and 'size' not in already_processed:
            already_processed.add('size')
            try:
                self.size = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(Population, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'layout':
            obj_ = Layout.factory()
            obj_.build(child_)
            self.layout = obj_
        elif nodeName_ == 'instance':
            obj_ = Instance.factory()
            obj_.build(child_)
            self.instances.append(obj_)
        super(Population, self).buildChildren(child_, node, nodeName_, True)
# end class Population


class Region(Base):
    member_data_items_ = [
        MemberSpec_('space', 'NmlId', 0),
        MemberSpec_('', 'xs:string', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, spaces=None, anytypeobjs_=None):
        super(Region, self).__init__(neuro_lex_id, id, )
        self.spaces = _cast(None, spaces)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if Region.subclass:
            return Region.subclass(*args_, **kwargs_)
        else:
            return Region(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.anytypeobjs_ or
            super(Region, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Region', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Region')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Region'):
        super(Region, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Region')
        if self.spaces is not None and 'spaces' not in already_processed:
            already_processed.add('spaces')
            outfile.write(' space=%s' % (quote_attrib(self.spaces), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Region', fromsubclass_=False, pretty_print=True):
        super(Region, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Region'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.spaces is not None and 'spaces' not in already_processed:
            already_processed.add('spaces')
            showIndent(outfile, level)
            outfile.write('spaces="%s",\n' % (self.spaces,))
        super(Region, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Region, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('space', node)
        if value is not None and 'space' not in already_processed:
            already_processed.add('space')
            self.spaces = value
            self.validate_NmlId(self.spaces)    # validate type NmlId
        super(Region, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'Region')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(Region, self).buildChildren(child_, node, nodeName_, True)
# end class Region


class Space(Base):
    member_data_items_ = [
        MemberSpec_('basedOn', 'allowedSpaces', 0),
        MemberSpec_('structure', 'SpaceStructure', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, based_on=None, structure=None):
        super(Space, self).__init__(neuro_lex_id, id, )
        self.based_on = _cast(None, based_on)
        self.structure = structure
    def factory(*args_, **kwargs_):
        if Space.subclass:
            return Space.subclass(*args_, **kwargs_)
        else:
            return Space(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_allowedSpaces(self, value):
        # Validate type allowedSpaces, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.structure is not None or
            super(Space, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Space', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Space')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Space'):
        super(Space, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Space')
        if self.based_on is not None and 'based_on' not in already_processed:
            already_processed.add('based_on')
            outfile.write(' basedOn=%s' % (quote_attrib(self.based_on), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Space', fromsubclass_=False, pretty_print=True):
        super(Space, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.structure is not None:
            self.structure.export(outfile, level, namespace_, name_='structure', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Space'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.based_on is not None and 'based_on' not in already_processed:
            already_processed.add('based_on')
            showIndent(outfile, level)
            outfile.write('based_on="%s",\n' % (self.based_on,))
        super(Space, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Space, self).exportLiteralChildren(outfile, level, name_)
        if self.structure is not None:
            showIndent(outfile, level)
            outfile.write('structure=model_.SpaceStructure(\n')
            self.structure.exportLiteral(outfile, level, name_='structure')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('basedOn', node)
        if value is not None and 'basedOn' not in already_processed:
            already_processed.add('basedOn')
            self.based_on = value
            self.validate_allowedSpaces(self.based_on)    # validate type allowedSpaces
        super(Space, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'structure':
            obj_ = SpaceStructure.factory()
            obj_.build(child_)
            self.structure = obj_
        super(Space, self).buildChildren(child_, node, nodeName_, True)
# end class Space


class Network(Standalone):
    member_data_items_ = [
        MemberSpec_('type', 'networkTypes', 0),
        MemberSpec_('temperature', 'Nml2Quantity_temperature', 0),
        MemberSpec_('spaces', 'Space', 1),
        MemberSpec_('regions', 'Region', 1),
        MemberSpec_('extracellular_properties', 'ExtracellularPropertiesLocal', 1),
        MemberSpec_('populations', 'Population', 1),
        MemberSpec_('cell_sets', 'CellSet', 1),
        MemberSpec_('synaptic_connections', 'SynapticConnection', 1),
        MemberSpec_('projections', 'Projection', 1),
        MemberSpec_('explicit_inputs', 'ExplicitInput', 1),
        MemberSpec_('input_lists', 'InputList', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, type=None, temperature=None, spaces=None, regions=None, extracellular_properties=None, populations=None, cell_sets=None, synaptic_connections=None, projections=None, explicit_inputs=None, input_lists=None):
        super(Network, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.type = _cast(None, type)
        self.temperature = _cast(None, temperature)
        if spaces is None:
            self.spaces = []
        else:
            self.spaces = spaces
        if regions is None:
            self.regions = []
        else:
            self.regions = regions
        if extracellular_properties is None:
            self.extracellular_properties = []
        else:
            self.extracellular_properties = extracellular_properties
        if populations is None:
            self.populations = []
        else:
            self.populations = populations
        if cell_sets is None:
            self.cell_sets = []
        else:
            self.cell_sets = cell_sets
        if synaptic_connections is None:
            self.synaptic_connections = []
        else:
            self.synaptic_connections = synaptic_connections
        if projections is None:
            self.projections = []
        else:
            self.projections = projections
        if explicit_inputs is None:
            self.explicit_inputs = []
        else:
            self.explicit_inputs = explicit_inputs
        if input_lists is None:
            self.input_lists = []
        else:
            self.input_lists = input_lists
    def factory(*args_, **kwargs_):
        if Network.subclass:
            return Network.subclass(*args_, **kwargs_)
        else:
            return Network(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_networkTypes(self, value):
        # Validate type networkTypes, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_temperature(self, value):
        # Validate type Nml2Quantity_temperature, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.spaces or
            self.regions or
            self.extracellular_properties or
            self.populations or
            self.cell_sets or
            self.synaptic_connections or
            self.projections or
            self.explicit_inputs or
            self.input_lists or
            super(Network, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Network', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Network')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Network'):
        super(Network, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Network')
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.temperature is not None and 'temperature' not in already_processed:
            already_processed.add('temperature')
            outfile.write(' temperature=%s' % (quote_attrib(self.temperature), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Network', fromsubclass_=False, pretty_print=True):
        super(Network, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for space_ in self.spaces:
            space_.export(outfile, level, namespace_, name_='space', pretty_print=pretty_print)
        for region_ in self.regions:
            region_.export(outfile, level, namespace_, name_='region', pretty_print=pretty_print)
        for extracellularProperties_ in self.extracellular_properties:
            extracellularProperties_.export(outfile, level, namespace_, name_='extracellularProperties', pretty_print=pretty_print)
        for population_ in self.populations:
            population_.export(outfile, level, namespace_, name_='population', pretty_print=pretty_print)
        for cellSet_ in self.cell_sets:
            cellSet_.export(outfile, level, namespace_, name_='cellSet', pretty_print=pretty_print)
        for synapticConnection_ in self.synaptic_connections:
            synapticConnection_.export(outfile, level, namespace_, name_='synapticConnection', pretty_print=pretty_print)
        for projection_ in self.projections:
            projection_.export(outfile, level, namespace_, name_='projection', pretty_print=pretty_print)
        for explicitInput_ in self.explicit_inputs:
            explicitInput_.export(outfile, level, namespace_, name_='explicitInput', pretty_print=pretty_print)
        for inputList_ in self.input_lists:
            inputList_.export(outfile, level, namespace_, name_='inputList', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Network'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        if self.temperature is not None and 'temperature' not in already_processed:
            already_processed.add('temperature')
            showIndent(outfile, level)
            outfile.write('temperature="%s",\n' % (self.temperature,))
        super(Network, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Network, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('spaces=[\n')
        level += 1
        for space_ in self.spaces:
            showIndent(outfile, level)
            outfile.write('model_.Space(\n')
            space_.exportLiteral(outfile, level, name_='Space')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('regions=[\n')
        level += 1
        for region_ in self.regions:
            showIndent(outfile, level)
            outfile.write('model_.Region(\n')
            region_.exportLiteral(outfile, level, name_='Region')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('extracellular_properties=[\n')
        level += 1
        for extracellularProperties_ in self.extracellular_properties:
            showIndent(outfile, level)
            outfile.write('model_.ExtracellularPropertiesLocal(\n')
            extracellularProperties_.exportLiteral(outfile, level, name_='ExtracellularPropertiesLocal')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('populations=[\n')
        level += 1
        for population_ in self.populations:
            showIndent(outfile, level)
            outfile.write('model_.Population(\n')
            population_.exportLiteral(outfile, level, name_='Population')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('cell_sets=[\n')
        level += 1
        for cellSet_ in self.cell_sets:
            showIndent(outfile, level)
            outfile.write('model_.CellSet(\n')
            cellSet_.exportLiteral(outfile, level, name_='CellSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('synaptic_connections=[\n')
        level += 1
        for synapticConnection_ in self.synaptic_connections:
            showIndent(outfile, level)
            outfile.write('model_.SynapticConnection(\n')
            synapticConnection_.exportLiteral(outfile, level, name_='SynapticConnection')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('projections=[\n')
        level += 1
        for projection_ in self.projections:
            showIndent(outfile, level)
            outfile.write('model_.Projection(\n')
            projection_.exportLiteral(outfile, level, name_='Projection')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('explicit_inputs=[\n')
        level += 1
        for explicitInput_ in self.explicit_inputs:
            showIndent(outfile, level)
            outfile.write('model_.ExplicitInput(\n')
            explicitInput_.exportLiteral(outfile, level, name_='ExplicitInput')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('input_lists=[\n')
        level += 1
        for inputList_ in self.input_lists:
            showIndent(outfile, level)
            outfile.write('model_.InputList(\n')
            inputList_.exportLiteral(outfile, level, name_='InputList')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_networkTypes(self.type)    # validate type networkTypes
        value = find_attr_value_('temperature', node)
        if value is not None and 'temperature' not in already_processed:
            already_processed.add('temperature')
            self.temperature = value
            self.validate_Nml2Quantity_temperature(self.temperature)    # validate type Nml2Quantity_temperature
        super(Network, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'space':
            obj_ = Space.factory()
            obj_.build(child_)
            self.spaces.append(obj_)
        elif nodeName_ == 'region':
            obj_ = Region.factory()
            obj_.build(child_)
            self.regions.append(obj_)
        elif nodeName_ == 'extracellularProperties':
            obj_ = ExtracellularPropertiesLocal.factory()
            obj_.build(child_)
            self.extracellular_properties.append(obj_)
        elif nodeName_ == 'population':
            obj_ = Population.factory()
            obj_.build(child_)
            self.populations.append(obj_)
        elif nodeName_ == 'cellSet':
            obj_ = CellSet.factory()
            obj_.build(child_)
            self.cell_sets.append(obj_)
        elif nodeName_ == 'synapticConnection':
            obj_ = SynapticConnection.factory()
            obj_.build(child_)
            self.synaptic_connections.append(obj_)
        elif nodeName_ == 'projection':
            obj_ = Projection.factory()
            obj_.build(child_)
            self.projections.append(obj_)
        elif nodeName_ == 'explicitInput':
            obj_ = ExplicitInput.factory()
            obj_.build(child_)
            self.explicit_inputs.append(obj_)
        elif nodeName_ == 'inputList':
            obj_ = InputList.factory()
            obj_.build(child_)
            self.input_lists.append(obj_)
        super(Network, self).buildChildren(child_, node, nodeName_, True)
# end class Network


class SpikeGeneratorPoisson(Standalone):
    member_data_items_ = [
        MemberSpec_('averageRate', 'Nml2Quantity_pertime', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, average_rate=None):
        super(SpikeGeneratorPoisson, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.average_rate = _cast(None, average_rate)
        pass
    def factory(*args_, **kwargs_):
        if SpikeGeneratorPoisson.subclass:
            return SpikeGeneratorPoisson.subclass(*args_, **kwargs_)
        else:
            return SpikeGeneratorPoisson(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(SpikeGeneratorPoisson, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpikeGeneratorPoisson', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeGeneratorPoisson')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpikeGeneratorPoisson'):
        super(SpikeGeneratorPoisson, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeGeneratorPoisson')
        if self.average_rate is not None and 'average_rate' not in already_processed:
            already_processed.add('average_rate')
            outfile.write(' averageRate=%s' % (quote_attrib(self.average_rate), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SpikeGeneratorPoisson', fromsubclass_=False, pretty_print=True):
        super(SpikeGeneratorPoisson, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SpikeGeneratorPoisson'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.average_rate is not None and 'average_rate' not in already_processed:
            already_processed.add('average_rate')
            showIndent(outfile, level)
            outfile.write('average_rate="%s",\n' % (self.average_rate,))
        super(SpikeGeneratorPoisson, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SpikeGeneratorPoisson, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('averageRate', node)
        if value is not None and 'averageRate' not in already_processed:
            already_processed.add('averageRate')
            self.average_rate = value
            self.validate_Nml2Quantity_pertime(self.average_rate)    # validate type Nml2Quantity_pertime
        super(SpikeGeneratorPoisson, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeGeneratorPoisson, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SpikeGeneratorPoisson


class SpikeGeneratorRandom(Standalone):
    member_data_items_ = [
        MemberSpec_('minISI', 'Nml2Quantity_time', 0),
        MemberSpec_('maxISI', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, min_isi=None, max_isi=None):
        super(SpikeGeneratorRandom, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.min_isi = _cast(None, min_isi)
        self.max_isi = _cast(None, max_isi)
        pass
    def factory(*args_, **kwargs_):
        if SpikeGeneratorRandom.subclass:
            return SpikeGeneratorRandom.subclass(*args_, **kwargs_)
        else:
            return SpikeGeneratorRandom(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(SpikeGeneratorRandom, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpikeGeneratorRandom', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeGeneratorRandom')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpikeGeneratorRandom'):
        super(SpikeGeneratorRandom, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeGeneratorRandom')
        if self.min_isi is not None and 'min_isi' not in already_processed:
            already_processed.add('min_isi')
            outfile.write(' minISI=%s' % (quote_attrib(self.min_isi), ))
        if self.max_isi is not None and 'max_isi' not in already_processed:
            already_processed.add('max_isi')
            outfile.write(' maxISI=%s' % (quote_attrib(self.max_isi), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SpikeGeneratorRandom', fromsubclass_=False, pretty_print=True):
        super(SpikeGeneratorRandom, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SpikeGeneratorRandom'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.min_isi is not None and 'min_isi' not in already_processed:
            already_processed.add('min_isi')
            showIndent(outfile, level)
            outfile.write('min_isi="%s",\n' % (self.min_isi,))
        if self.max_isi is not None and 'max_isi' not in already_processed:
            already_processed.add('max_isi')
            showIndent(outfile, level)
            outfile.write('max_isi="%s",\n' % (self.max_isi,))
        super(SpikeGeneratorRandom, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SpikeGeneratorRandom, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('minISI', node)
        if value is not None and 'minISI' not in already_processed:
            already_processed.add('minISI')
            self.min_isi = value
            self.validate_Nml2Quantity_time(self.min_isi)    # validate type Nml2Quantity_time
        value = find_attr_value_('maxISI', node)
        if value is not None and 'maxISI' not in already_processed:
            already_processed.add('maxISI')
            self.max_isi = value
            self.validate_Nml2Quantity_time(self.max_isi)    # validate type Nml2Quantity_time
        super(SpikeGeneratorRandom, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeGeneratorRandom, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SpikeGeneratorRandom


class SpikeGenerator(Standalone):
    member_data_items_ = [
        MemberSpec_('period', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, period=None):
        super(SpikeGenerator, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.period = _cast(None, period)
        pass
    def factory(*args_, **kwargs_):
        if SpikeGenerator.subclass:
            return SpikeGenerator.subclass(*args_, **kwargs_)
        else:
            return SpikeGenerator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(SpikeGenerator, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpikeGenerator', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeGenerator')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpikeGenerator'):
        super(SpikeGenerator, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeGenerator')
        if self.period is not None and 'period' not in already_processed:
            already_processed.add('period')
            outfile.write(' period=%s' % (quote_attrib(self.period), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SpikeGenerator', fromsubclass_=False, pretty_print=True):
        super(SpikeGenerator, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SpikeGenerator'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.period is not None and 'period' not in already_processed:
            already_processed.add('period')
            showIndent(outfile, level)
            outfile.write('period="%s",\n' % (self.period,))
        super(SpikeGenerator, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SpikeGenerator, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('period', node)
        if value is not None and 'period' not in already_processed:
            already_processed.add('period')
            self.period = value
            self.validate_Nml2Quantity_time(self.period)    # validate type Nml2Quantity_time
        super(SpikeGenerator, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SpikeGenerator, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SpikeGenerator


class SpikeArray(Standalone):
    member_data_items_ = [
        MemberSpec_('spikes', 'Spike', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, spikes=None):
        super(SpikeArray, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        if spikes is None:
            self.spikes = []
        else:
            self.spikes = spikes
    def factory(*args_, **kwargs_):
        if SpikeArray.subclass:
            return SpikeArray.subclass(*args_, **kwargs_)
        else:
            return SpikeArray(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.spikes or
            super(SpikeArray, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SpikeArray', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeArray')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SpikeArray'):
        super(SpikeArray, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SpikeArray')
    def exportChildren(self, outfile, level, namespace_='', name_='SpikeArray', fromsubclass_=False, pretty_print=True):
        super(SpikeArray, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for spike_ in self.spikes:
            spike_.export(outfile, level, namespace_, name_='spike', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SpikeArray'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(SpikeArray, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SpikeArray, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('spikes=[\n')
        level += 1
        for spike_ in self.spikes:
            showIndent(outfile, level)
            outfile.write('model_.Spike(\n')
            spike_.exportLiteral(outfile, level, name_='Spike')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(SpikeArray, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'spike':
            obj_ = Spike.factory()
            obj_.build(child_)
            self.spikes.append(obj_)
        super(SpikeArray, self).buildChildren(child_, node, nodeName_, True)
# end class SpikeArray


class Spike(Standalone):
    member_data_items_ = [
        MemberSpec_('time', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, time=None):
        super(Spike, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.time = _cast(None, time)
        pass
    def factory(*args_, **kwargs_):
        if Spike.subclass:
            return Spike.subclass(*args_, **kwargs_)
        else:
            return Spike(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(Spike, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Spike', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Spike')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Spike'):
        super(Spike, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Spike')
        if self.time is not None and 'time' not in already_processed:
            already_processed.add('time')
            outfile.write(' time=%s' % (quote_attrib(self.time), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Spike', fromsubclass_=False, pretty_print=True):
        super(Spike, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Spike'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.time is not None and 'time' not in already_processed:
            already_processed.add('time')
            showIndent(outfile, level)
            outfile.write('time="%s",\n' % (self.time,))
        super(Spike, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Spike, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('time', node)
        if value is not None and 'time' not in already_processed:
            already_processed.add('time')
            self.time = value
            self.validate_Nml2Quantity_time(self.time)    # validate type Nml2Quantity_time
        super(Spike, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Spike, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Spike


class VoltageClamp(Standalone):
    member_data_items_ = [
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('seriesResistance', 'Nml2Quantity_resistance', 0),
        MemberSpec_('targetVoltage', 'Nml2Quantity_voltage', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, delay=None, duration=None, series_resistance=None, target_voltage=None):
        super(VoltageClamp, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.series_resistance = _cast(None, series_resistance)
        self.target_voltage = _cast(None, target_voltage)
        pass
    def factory(*args_, **kwargs_):
        if VoltageClamp.subclass:
            return VoltageClamp.subclass(*args_, **kwargs_)
        else:
            return VoltageClamp(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_resistance(self, value):
        # Validate type Nml2Quantity_resistance, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(VoltageClamp, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VoltageClamp', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VoltageClamp')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VoltageClamp'):
        super(VoltageClamp, self).exportAttributes(outfile, level, already_processed, namespace_, name_='VoltageClamp')
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.series_resistance is not None and 'series_resistance' not in already_processed:
            already_processed.add('series_resistance')
            outfile.write(' seriesResistance=%s' % (quote_attrib(self.series_resistance), ))
        if self.target_voltage is not None and 'target_voltage' not in already_processed:
            already_processed.add('target_voltage')
            outfile.write(' targetVoltage=%s' % (quote_attrib(self.target_voltage), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VoltageClamp', fromsubclass_=False, pretty_print=True):
        super(VoltageClamp, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VoltageClamp'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            showIndent(outfile, level)
            outfile.write('delay="%s",\n' % (self.delay,))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            showIndent(outfile, level)
            outfile.write('duration="%s",\n' % (self.duration,))
        if self.series_resistance is not None and 'series_resistance' not in already_processed:
            already_processed.add('series_resistance')
            showIndent(outfile, level)
            outfile.write('series_resistance="%s",\n' % (self.series_resistance,))
        if self.target_voltage is not None and 'target_voltage' not in already_processed:
            already_processed.add('target_voltage')
            showIndent(outfile, level)
            outfile.write('target_voltage="%s",\n' % (self.target_voltage,))
        super(VoltageClamp, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(VoltageClamp, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('seriesResistance', node)
        if value is not None and 'seriesResistance' not in already_processed:
            already_processed.add('seriesResistance')
            self.series_resistance = value
            self.validate_Nml2Quantity_resistance(self.series_resistance)    # validate type Nml2Quantity_resistance
        value = find_attr_value_('targetVoltage', node)
        if value is not None and 'targetVoltage' not in already_processed:
            already_processed.add('targetVoltage')
            self.target_voltage = value
            self.validate_Nml2Quantity_voltage(self.target_voltage)    # validate type Nml2Quantity_voltage
        super(VoltageClamp, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(VoltageClamp, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class VoltageClamp


class RampGenerator(Standalone):
    member_data_items_ = [
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('baselineAmplitude', 'Nml2Quantity_current', 0),
        MemberSpec_('startAmplitude', 'Nml2Quantity_current', 0),
        MemberSpec_('finishAmplitude', 'Nml2Quantity_current', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, delay=None, duration=None, baseline_amplitude=None, start_amplitude=None, finish_amplitude=None):
        super(RampGenerator, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.baseline_amplitude = _cast(None, baseline_amplitude)
        self.start_amplitude = _cast(None, start_amplitude)
        self.finish_amplitude = _cast(None, finish_amplitude)
        pass
    def factory(*args_, **kwargs_):
        if RampGenerator.subclass:
            return RampGenerator.subclass(*args_, **kwargs_)
        else:
            return RampGenerator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(RampGenerator, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='RampGenerator', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RampGenerator')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RampGenerator'):
        super(RampGenerator, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RampGenerator')
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.baseline_amplitude is not None and 'baseline_amplitude' not in already_processed:
            already_processed.add('baseline_amplitude')
            outfile.write(' baselineAmplitude=%s' % (quote_attrib(self.baseline_amplitude), ))
        if self.start_amplitude is not None and 'start_amplitude' not in already_processed:
            already_processed.add('start_amplitude')
            outfile.write(' startAmplitude=%s' % (quote_attrib(self.start_amplitude), ))
        if self.finish_amplitude is not None and 'finish_amplitude' not in already_processed:
            already_processed.add('finish_amplitude')
            outfile.write(' finishAmplitude=%s' % (quote_attrib(self.finish_amplitude), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RampGenerator', fromsubclass_=False, pretty_print=True):
        super(RampGenerator, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='RampGenerator'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            showIndent(outfile, level)
            outfile.write('delay="%s",\n' % (self.delay,))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            showIndent(outfile, level)
            outfile.write('duration="%s",\n' % (self.duration,))
        if self.baseline_amplitude is not None and 'baseline_amplitude' not in already_processed:
            already_processed.add('baseline_amplitude')
            showIndent(outfile, level)
            outfile.write('baseline_amplitude="%s",\n' % (self.baseline_amplitude,))
        if self.start_amplitude is not None and 'start_amplitude' not in already_processed:
            already_processed.add('start_amplitude')
            showIndent(outfile, level)
            outfile.write('start_amplitude="%s",\n' % (self.start_amplitude,))
        if self.finish_amplitude is not None and 'finish_amplitude' not in already_processed:
            already_processed.add('finish_amplitude')
            showIndent(outfile, level)
            outfile.write('finish_amplitude="%s",\n' % (self.finish_amplitude,))
        super(RampGenerator, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RampGenerator, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('baselineAmplitude', node)
        if value is not None and 'baselineAmplitude' not in already_processed:
            already_processed.add('baselineAmplitude')
            self.baseline_amplitude = value
            self.validate_Nml2Quantity_current(self.baseline_amplitude)    # validate type Nml2Quantity_current
        value = find_attr_value_('startAmplitude', node)
        if value is not None and 'startAmplitude' not in already_processed:
            already_processed.add('startAmplitude')
            self.start_amplitude = value
            self.validate_Nml2Quantity_current(self.start_amplitude)    # validate type Nml2Quantity_current
        value = find_attr_value_('finishAmplitude', node)
        if value is not None and 'finishAmplitude' not in already_processed:
            already_processed.add('finishAmplitude')
            self.finish_amplitude = value
            self.validate_Nml2Quantity_current(self.finish_amplitude)    # validate type Nml2Quantity_current
        super(RampGenerator, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(RampGenerator, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class RampGenerator


class SineGenerator(Standalone):
    member_data_items_ = [
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
        MemberSpec_('phase', 'Nml2Quantity_none', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('period', 'Nml2Quantity_time', 0),
        MemberSpec_('amplitude', 'Nml2Quantity_current', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, delay=None, phase=None, duration=None, period=None, amplitude=None):
        super(SineGenerator, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.delay = _cast(None, delay)
        self.phase = _cast(None, phase)
        self.duration = _cast(None, duration)
        self.period = _cast(None, period)
        self.amplitude = _cast(None, amplitude)
        pass
    def factory(*args_, **kwargs_):
        if SineGenerator.subclass:
            return SineGenerator.subclass(*args_, **kwargs_)
        else:
            return SineGenerator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(SineGenerator, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SineGenerator', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SineGenerator')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SineGenerator'):
        super(SineGenerator, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SineGenerator')
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
        if self.phase is not None and 'phase' not in already_processed:
            already_processed.add('phase')
            outfile.write(' phase=%s' % (quote_attrib(self.phase), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.period is not None and 'period' not in already_processed:
            already_processed.add('period')
            outfile.write(' period=%s' % (quote_attrib(self.period), ))
        if self.amplitude is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            outfile.write(' amplitude=%s' % (quote_attrib(self.amplitude), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SineGenerator', fromsubclass_=False, pretty_print=True):
        super(SineGenerator, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SineGenerator'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            showIndent(outfile, level)
            outfile.write('delay="%s",\n' % (self.delay,))
        if self.phase is not None and 'phase' not in already_processed:
            already_processed.add('phase')
            showIndent(outfile, level)
            outfile.write('phase="%s",\n' % (self.phase,))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            showIndent(outfile, level)
            outfile.write('duration="%s",\n' % (self.duration,))
        if self.period is not None and 'period' not in already_processed:
            already_processed.add('period')
            showIndent(outfile, level)
            outfile.write('period="%s",\n' % (self.period,))
        if self.amplitude is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            showIndent(outfile, level)
            outfile.write('amplitude="%s",\n' % (self.amplitude,))
        super(SineGenerator, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SineGenerator, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        value = find_attr_value_('phase', node)
        if value is not None and 'phase' not in already_processed:
            already_processed.add('phase')
            self.phase = value
            self.validate_Nml2Quantity_none(self.phase)    # validate type Nml2Quantity_none
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('period', node)
        if value is not None and 'period' not in already_processed:
            already_processed.add('period')
            self.period = value
            self.validate_Nml2Quantity_time(self.period)    # validate type Nml2Quantity_time
        value = find_attr_value_('amplitude', node)
        if value is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            self.amplitude = value
            self.validate_Nml2Quantity_current(self.amplitude)    # validate type Nml2Quantity_current
        super(SineGenerator, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(SineGenerator, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class SineGenerator


class PulseGenerator(Standalone):
    member_data_items_ = [
        MemberSpec_('delay', 'Nml2Quantity_time', 0),
        MemberSpec_('duration', 'Nml2Quantity_time', 0),
        MemberSpec_('amplitude', 'Nml2Quantity_current', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, delay=None, duration=None, amplitude=None):
        super(PulseGenerator, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.delay = _cast(None, delay)
        self.duration = _cast(None, duration)
        self.amplitude = _cast(None, amplitude)
        pass
    def factory(*args_, **kwargs_):
        if PulseGenerator.subclass:
            return PulseGenerator.subclass(*args_, **kwargs_)
        else:
            return PulseGenerator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(PulseGenerator, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PulseGenerator', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PulseGenerator')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PulseGenerator'):
        super(PulseGenerator, self).exportAttributes(outfile, level, already_processed, namespace_, name_='PulseGenerator')
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            outfile.write(' delay=%s' % (quote_attrib(self.delay), ))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            outfile.write(' duration=%s' % (quote_attrib(self.duration), ))
        if self.amplitude is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            outfile.write(' amplitude=%s' % (quote_attrib(self.amplitude), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PulseGenerator', fromsubclass_=False, pretty_print=True):
        super(PulseGenerator, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PulseGenerator'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.delay is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            showIndent(outfile, level)
            outfile.write('delay="%s",\n' % (self.delay,))
        if self.duration is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            showIndent(outfile, level)
            outfile.write('duration="%s",\n' % (self.duration,))
        if self.amplitude is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            showIndent(outfile, level)
            outfile.write('amplitude="%s",\n' % (self.amplitude,))
        super(PulseGenerator, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(PulseGenerator, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('delay', node)
        if value is not None and 'delay' not in already_processed:
            already_processed.add('delay')
            self.delay = value
            self.validate_Nml2Quantity_time(self.delay)    # validate type Nml2Quantity_time
        value = find_attr_value_('duration', node)
        if value is not None and 'duration' not in already_processed:
            already_processed.add('duration')
            self.duration = value
            self.validate_Nml2Quantity_time(self.duration)    # validate type Nml2Quantity_time
        value = find_attr_value_('amplitude', node)
        if value is not None and 'amplitude' not in already_processed:
            already_processed.add('amplitude')
            self.amplitude = value
            self.validate_Nml2Quantity_current(self.amplitude)    # validate type Nml2Quantity_current
        super(PulseGenerator, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(PulseGenerator, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class PulseGenerator


class ReactionScheme(Base):
    member_data_items_ = [
        MemberSpec_('source', 'xs:string', 0),
        MemberSpec_('type', 'xs:string', 0),
        MemberSpec_('', 'xs:string', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, source=None, type=None, anytypeobjs_=None):
        super(ReactionScheme, self).__init__(neuro_lex_id, id, )
        self.source = _cast(None, source)
        self.type = _cast(None, type)
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_
    def factory(*args_, **kwargs_):
        if ReactionScheme.subclass:
            return ReactionScheme.subclass(*args_, **kwargs_)
        else:
            return ReactionScheme(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.anytypeobjs_ or
            super(ReactionScheme, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ReactionScheme', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ReactionScheme')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ReactionScheme'):
        super(ReactionScheme, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ReactionScheme')
        if self.source is not None and 'source' not in already_processed:
            already_processed.add('source')
            outfile.write(' source=%s' % (self.gds_format_string(quote_attrib(self.source).encode(ExternalEncoding), input_name='source'), ))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ReactionScheme', fromsubclass_=False, pretty_print=True):
        super(ReactionScheme, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for obj_ in self.anytypeobjs_:
            obj_.export(outfile, level, namespace_, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ReactionScheme'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.source is not None and 'source' not in already_processed:
            already_processed.add('source')
            showIndent(outfile, level)
            outfile.write('source="%s",\n' % (self.source,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        super(ReactionScheme, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ReactionScheme, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('anytypeobjs_=[\n')
        level += 1
        for anytypeobjs_ in self.anytypeobjs_:
            anytypeobjs_.exportLiteral(outfile, level)
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('source', node)
        if value is not None and 'source' not in already_processed:
            already_processed.add('source')
            self.source = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
        super(ReactionScheme, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        obj_ = self.gds_build_any(child_, 'ReactionScheme')
        if obj_ is not None:
            self.add_anytypeobjs_(obj_)
        super(ReactionScheme, self).buildChildren(child_, node, nodeName_, True)
# end class ReactionScheme


class ExtracellularProperties(Base):
    member_data_items_ = [
        MemberSpec_('species', 'Species', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, species=None):
        super(ExtracellularProperties, self).__init__(neuro_lex_id, id, )
        if species is None:
            self.species = []
        else:
            self.species = species
    def factory(*args_, **kwargs_):
        if ExtracellularProperties.subclass:
            return ExtracellularProperties.subclass(*args_, **kwargs_)
        else:
            return ExtracellularProperties(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.species or
            super(ExtracellularProperties, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ExtracellularProperties', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExtracellularProperties')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ExtracellularProperties'):
        super(ExtracellularProperties, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ExtracellularProperties')
    def exportChildren(self, outfile, level, namespace_='', name_='ExtracellularProperties', fromsubclass_=False, pretty_print=True):
        super(ExtracellularProperties, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for species_ in self.species:
            species_.export(outfile, level, namespace_, name_='species', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ExtracellularProperties'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ExtracellularProperties, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ExtracellularProperties, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('species=[\n')
        level += 1
        for species_ in self.species:
            showIndent(outfile, level)
            outfile.write('model_.Species(\n')
            species_.exportLiteral(outfile, level, name_='Species')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ExtracellularProperties, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'species':
            obj_ = Species.factory()
            obj_.build(child_)
            self.species.append(obj_)
        super(ExtracellularProperties, self).buildChildren(child_, node, nodeName_, True)
# end class ExtracellularProperties


class ChannelDensity(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel. It is added here TEMPORARILY as selecting all ca or
    na conducting channel populations/densities in a cell would be
    difficult otherwise. It should be removed in the longer term,
    due to possible inconsistencies in this value and that in the
    ionChannel element. TODO: remove."""
    member_data_items_ = [
        MemberSpec_('segmentGroup', 'NmlId', 0),
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('ionChannel', 'NmlId', 0),
        MemberSpec_('erev', 'Nml2Quantity_voltage', 0),
        MemberSpec_('condDensity', 'Nml2Quantity_conductanceDensity', 0),
        MemberSpec_('segment', 'NmlId', 0),
        MemberSpec_('variable_parameters', 'VariableParameter', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, segment_groups='all', ion=None, ion_channels=None, erev=None, cond_density=None, segments=None, variable_parameters=None):
        super(ChannelDensity, self).__init__(neuro_lex_id, id, )
        self.segment_groups = _cast(None, segment_groups)
        self.ion = _cast(None, ion)
        self.ion_channels = _cast(None, ion_channels)
        self.erev = _cast(None, erev)
        self.cond_density = _cast(None, cond_density)
        self.segments = _cast(None, segments)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
    def factory(*args_, **kwargs_):
        if ChannelDensity.subclass:
            return ChannelDensity.subclass(*args_, **kwargs_)
        else:
            return ChannelDensity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_conductanceDensity(self, value):
        # Validate type Nml2Quantity_conductanceDensity, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.variable_parameters or
            super(ChannelDensity, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ChannelDensity', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensity')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ChannelDensity'):
        super(ChannelDensity, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelDensity')
        if self.segment_groups is not None and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (quote_attrib(self.segment_groups), ))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
        if self.ion_channels is not None and 'ion_channels' not in already_processed:
            already_processed.add('ion_channels')
            outfile.write(' ionChannel=%s' % (quote_attrib(self.ion_channels), ))
        if self.erev is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            outfile.write(' erev=%s' % (quote_attrib(self.erev), ))
        if self.cond_density is not None and 'cond_density' not in already_processed:
            already_processed.add('cond_density')
            outfile.write(' condDensity=%s' % (quote_attrib(self.cond_density), ))
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ChannelDensity', fromsubclass_=False, pretty_print=True):
        super(ChannelDensity, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(outfile, level, namespace_, name_='variableParameter', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ChannelDensity'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.segment_groups is not None and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            showIndent(outfile, level)
            outfile.write('segment_groups="%s",\n' % (self.segment_groups,))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            showIndent(outfile, level)
            outfile.write('ion="%s",\n' % (self.ion,))
        if self.ion_channels is not None and 'ion_channels' not in already_processed:
            already_processed.add('ion_channels')
            showIndent(outfile, level)
            outfile.write('ion_channels="%s",\n' % (self.ion_channels,))
        if self.erev is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            showIndent(outfile, level)
            outfile.write('erev="%s",\n' % (self.erev,))
        if self.cond_density is not None and 'cond_density' not in already_processed:
            already_processed.add('cond_density')
            showIndent(outfile, level)
            outfile.write('cond_density="%s",\n' % (self.cond_density,))
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            showIndent(outfile, level)
            outfile.write('segments="%s",\n' % (self.segments,))
        super(ChannelDensity, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ChannelDensity, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('variable_parameters=[\n')
        level += 1
        for variableParameter_ in self.variable_parameters:
            showIndent(outfile, level)
            outfile.write('model_.VariableParameter(\n')
            variableParameter_.exportLiteral(outfile, level, name_='VariableParameter')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)    # validate type NmlId
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        value = find_attr_value_('ionChannel', node)
        if value is not None and 'ionChannel' not in already_processed:
            already_processed.add('ionChannel')
            self.ion_channels = value
            self.validate_NmlId(self.ion_channels)    # validate type NmlId
        value = find_attr_value_('erev', node)
        if value is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            self.erev = value
            self.validate_Nml2Quantity_voltage(self.erev)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('condDensity', node)
        if value is not None and 'condDensity' not in already_processed:
            already_processed.add('condDensity')
            self.cond_density = value
            self.validate_Nml2Quantity_conductanceDensity(self.cond_density)    # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            self.segments = value
            self.validate_NmlId(self.segments)    # validate type NmlId
        super(ChannelDensity, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'variableParameter':
            obj_ = VariableParameter.factory()
            obj_.build(child_)
            self.variable_parameters.append(obj_)
        super(ChannelDensity, self).buildChildren(child_, node, nodeName_, True)
# end class ChannelDensity


class ChannelPopulation(Base):
    """Specifying the ion here again is redundant, this will be set in
    ionChannel. It is added here TEMPORARILY as selecting all ca or
    na conducting channel populations/densities in a cell would be
    difficult otherwise. It should be removed in the longer term,
    due to possible inconsistencies in this value and that in the
    ionChannel element. TODO: remove."""
    member_data_items_ = [
        MemberSpec_('segmentGroup', 'NmlId', 0),
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('number', 'xs:nonNegativeInteger', 0),
        MemberSpec_('ionChannel', 'NmlId', 0),
        MemberSpec_('erev', 'Nml2Quantity_voltage', 0),
        MemberSpec_('segment', 'NmlId', 0),
        MemberSpec_('variable_parameters', 'VariableParameter', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, segment_groups='all', ion=None, number=None, ion_channels=None, erev=None, segments=None, variable_parameters=None):
        super(ChannelPopulation, self).__init__(neuro_lex_id, id, )
        self.segment_groups = _cast(None, segment_groups)
        self.ion = _cast(None, ion)
        self.number = _cast(int, number)
        self.ion_channels = _cast(None, ion_channels)
        self.erev = _cast(None, erev)
        self.segments = _cast(None, segments)
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
    def factory(*args_, **kwargs_):
        if ChannelPopulation.subclass:
            return ChannelPopulation.subclass(*args_, **kwargs_)
        else:
            return ChannelPopulation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.variable_parameters or
            super(ChannelPopulation, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ChannelPopulation', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelPopulation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ChannelPopulation'):
        super(ChannelPopulation, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ChannelPopulation')
        if self.segment_groups is not None and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            outfile.write(' segmentGroup=%s' % (quote_attrib(self.segment_groups), ))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
        if self.number is not None and 'number' not in already_processed:
            already_processed.add('number')
            outfile.write(' number="%s"' % self.gds_format_integer(self.number, input_name='number'))
        if self.ion_channels is not None and 'ion_channels' not in already_processed:
            already_processed.add('ion_channels')
            outfile.write(' ionChannel=%s' % (quote_attrib(self.ion_channels), ))
        if self.erev is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            outfile.write(' erev=%s' % (quote_attrib(self.erev), ))
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            outfile.write(' segment=%s' % (quote_attrib(self.segments), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ChannelPopulation', fromsubclass_=False, pretty_print=True):
        super(ChannelPopulation, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for variableParameter_ in self.variable_parameters:
            variableParameter_.export(outfile, level, namespace_, name_='variableParameter', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ChannelPopulation'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.segment_groups is not None and 'segment_groups' not in already_processed:
            already_processed.add('segment_groups')
            showIndent(outfile, level)
            outfile.write('segment_groups="%s",\n' % (self.segment_groups,))
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            showIndent(outfile, level)
            outfile.write('ion="%s",\n' % (self.ion,))
        if self.number is not None and 'number' not in already_processed:
            already_processed.add('number')
            showIndent(outfile, level)
            outfile.write('number=%d,\n' % (self.number,))
        if self.ion_channels is not None and 'ion_channels' not in already_processed:
            already_processed.add('ion_channels')
            showIndent(outfile, level)
            outfile.write('ion_channels="%s",\n' % (self.ion_channels,))
        if self.erev is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            showIndent(outfile, level)
            outfile.write('erev="%s",\n' % (self.erev,))
        if self.segments is not None and 'segments' not in already_processed:
            already_processed.add('segments')
            showIndent(outfile, level)
            outfile.write('segments="%s",\n' % (self.segments,))
        super(ChannelPopulation, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ChannelPopulation, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('variable_parameters=[\n')
        level += 1
        for variableParameter_ in self.variable_parameters:
            showIndent(outfile, level)
            outfile.write('model_.VariableParameter(\n')
            variableParameter_.exportLiteral(outfile, level, name_='VariableParameter')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('segmentGroup', node)
        if value is not None and 'segmentGroup' not in already_processed:
            already_processed.add('segmentGroup')
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)    # validate type NmlId
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        value = find_attr_value_('number', node)
        if value is not None and 'number' not in already_processed:
            already_processed.add('number')
            try:
                self.number = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.number < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('ionChannel', node)
        if value is not None and 'ionChannel' not in already_processed:
            already_processed.add('ionChannel')
            self.ion_channels = value
            self.validate_NmlId(self.ion_channels)    # validate type NmlId
        value = find_attr_value_('erev', node)
        if value is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            self.erev = value
            self.validate_Nml2Quantity_voltage(self.erev)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('segment', node)
        if value is not None and 'segment' not in already_processed:
            already_processed.add('segment')
            self.segments = value
            self.validate_NmlId(self.segments)    # validate type NmlId
        super(ChannelPopulation, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'variableParameter':
            obj_ = VariableParameter.factory()
            obj_.build(child_)
            self.variable_parameters.append(obj_)
        super(ChannelPopulation, self).buildChildren(child_, node, nodeName_, True)
# end class ChannelPopulation


class BiophysicalProperties(Standalone):
    """Standalone element which is usually inside a single cell, but could
    be outside and referenced by id."""
    member_data_items_ = [
        MemberSpec_('membrane_properties', 'MembraneProperties', 0),
        MemberSpec_('intracellular_properties', 'IntracellularProperties', 0),
        MemberSpec_('extracellular_properties', 'ExtracellularProperties', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, membrane_properties=None, intracellular_properties=None, extracellular_properties=None):
        super(BiophysicalProperties, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.membrane_properties = membrane_properties
        self.intracellular_properties = intracellular_properties
        self.extracellular_properties = extracellular_properties
    def factory(*args_, **kwargs_):
        if BiophysicalProperties.subclass:
            return BiophysicalProperties.subclass(*args_, **kwargs_)
        else:
            return BiophysicalProperties(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.membrane_properties is not None or
            self.intracellular_properties is not None or
            self.extracellular_properties is not None or
            super(BiophysicalProperties, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BiophysicalProperties', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BiophysicalProperties')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BiophysicalProperties'):
        super(BiophysicalProperties, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BiophysicalProperties')
    def exportChildren(self, outfile, level, namespace_='', name_='BiophysicalProperties', fromsubclass_=False, pretty_print=True):
        super(BiophysicalProperties, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.membrane_properties is not None:
            self.membrane_properties.export(outfile, level, namespace_, name_='membraneProperties', pretty_print=pretty_print)
        if self.intracellular_properties is not None:
            self.intracellular_properties.export(outfile, level, namespace_, name_='intracellularProperties', pretty_print=pretty_print)
        if self.extracellular_properties is not None:
            self.extracellular_properties.export(outfile, level, namespace_, name_='extracellularProperties', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BiophysicalProperties'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(BiophysicalProperties, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BiophysicalProperties, self).exportLiteralChildren(outfile, level, name_)
        if self.membrane_properties is not None:
            showIndent(outfile, level)
            outfile.write('membrane_properties=model_.MembraneProperties(\n')
            self.membrane_properties.exportLiteral(outfile, level, name_='membraneProperties')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.intracellular_properties is not None:
            showIndent(outfile, level)
            outfile.write('intracellular_properties=model_.IntracellularProperties(\n')
            self.intracellular_properties.exportLiteral(outfile, level, name_='intracellularProperties')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.extracellular_properties is not None:
            showIndent(outfile, level)
            outfile.write('extracellular_properties=model_.ExtracellularProperties(\n')
            self.extracellular_properties.exportLiteral(outfile, level, name_='extracellularProperties')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(BiophysicalProperties, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'membraneProperties':
            obj_ = MembraneProperties.factory()
            obj_.build(child_)
            self.membrane_properties = obj_
        elif nodeName_ == 'intracellularProperties':
            obj_ = IntracellularProperties.factory()
            obj_.build(child_)
            self.intracellular_properties = obj_
        elif nodeName_ == 'extracellularProperties':
            obj_ = ExtracellularProperties.factory()
            obj_.build(child_)
            self.extracellular_properties = obj_
        super(BiophysicalProperties, self).buildChildren(child_, node, nodeName_, True)
# end class BiophysicalProperties


class InhomogeneousParam(Base):
    member_data_items_ = [
        MemberSpec_('variable', 'xs:string', 0),
        MemberSpec_('metric', 'Metric', 0),
        MemberSpec_('proximal', 'ProximalDetails', 0),
        MemberSpec_('distal', 'DistalDetails', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, variable=None, metric=None, proximal=None, distal=None):
        super(InhomogeneousParam, self).__init__(neuro_lex_id, id, )
        self.variable = _cast(None, variable)
        self.metric = _cast(None, metric)
        self.proximal = proximal
        self.distal = distal
    def factory(*args_, **kwargs_):
        if InhomogeneousParam.subclass:
            return InhomogeneousParam.subclass(*args_, **kwargs_)
        else:
            return InhomogeneousParam(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Metric(self, value):
        # Validate type Metric, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.proximal is not None or
            self.distal is not None or
            super(InhomogeneousParam, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='InhomogeneousParam', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InhomogeneousParam')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='InhomogeneousParam'):
        super(InhomogeneousParam, self).exportAttributes(outfile, level, already_processed, namespace_, name_='InhomogeneousParam')
        if self.variable is not None and 'variable' not in already_processed:
            already_processed.add('variable')
            outfile.write(' variable=%s' % (self.gds_format_string(quote_attrib(self.variable).encode(ExternalEncoding), input_name='variable'), ))
        if self.metric is not None and 'metric' not in already_processed:
            already_processed.add('metric')
            outfile.write(' metric=%s' % (quote_attrib(self.metric), ))
    def exportChildren(self, outfile, level, namespace_='', name_='InhomogeneousParam', fromsubclass_=False, pretty_print=True):
        super(InhomogeneousParam, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.proximal is not None:
            self.proximal.export(outfile, level, namespace_, name_='proximal', pretty_print=pretty_print)
        if self.distal is not None:
            self.distal.export(outfile, level, namespace_, name_='distal', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='InhomogeneousParam'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.variable is not None and 'variable' not in already_processed:
            already_processed.add('variable')
            showIndent(outfile, level)
            outfile.write('variable="%s",\n' % (self.variable,))
        if self.metric is not None and 'metric' not in already_processed:
            already_processed.add('metric')
            showIndent(outfile, level)
            outfile.write('metric="%s",\n' % (self.metric,))
        super(InhomogeneousParam, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(InhomogeneousParam, self).exportLiteralChildren(outfile, level, name_)
        if self.proximal is not None:
            showIndent(outfile, level)
            outfile.write('proximal=model_.ProximalDetails(\n')
            self.proximal.exportLiteral(outfile, level, name_='proximal')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.distal is not None:
            showIndent(outfile, level)
            outfile.write('distal=model_.DistalDetails(\n')
            self.distal.exportLiteral(outfile, level, name_='distal')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('variable', node)
        if value is not None and 'variable' not in already_processed:
            already_processed.add('variable')
            self.variable = value
        value = find_attr_value_('metric', node)
        if value is not None and 'metric' not in already_processed:
            already_processed.add('metric')
            self.metric = value
            self.validate_Metric(self.metric)    # validate type Metric
        super(InhomogeneousParam, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'proximal':
            obj_ = ProximalDetails.factory()
            obj_.build(child_)
            self.proximal = obj_
        elif nodeName_ == 'distal':
            obj_ = DistalDetails.factory()
            obj_.build(child_)
            self.distal = obj_
        super(InhomogeneousParam, self).buildChildren(child_, node, nodeName_, True)
# end class InhomogeneousParam


class SegmentGroup(Base):
    member_data_items_ = [
        MemberSpec_('members', 'Member', 1),
        MemberSpec_('includes', 'Include', 1),
        MemberSpec_('paths', 'Path', 1),
        MemberSpec_('sub_trees', 'SubTree', 1),
        MemberSpec_('inhomogeneous_params', 'InhomogeneousParam', 1),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, members=None, includes=None, paths=None, sub_trees=None, inhomogeneous_params=None):
        super(SegmentGroup, self).__init__(neuro_lex_id, id, )
        if members is None:
            self.members = []
        else:
            self.members = members
        if includes is None:
            self.includes = []
        else:
            self.includes = includes
        if paths is None:
            self.paths = []
        else:
            self.paths = paths
        if sub_trees is None:
            self.sub_trees = []
        else:
            self.sub_trees = sub_trees
        if inhomogeneous_params is None:
            self.inhomogeneous_params = []
        else:
            self.inhomogeneous_params = inhomogeneous_params
    def factory(*args_, **kwargs_):
        if SegmentGroup.subclass:
            return SegmentGroup.subclass(*args_, **kwargs_)
        else:
            return SegmentGroup(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.members or
            self.includes or
            self.paths or
            self.sub_trees or
            self.inhomogeneous_params or
            super(SegmentGroup, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SegmentGroup', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SegmentGroup')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SegmentGroup'):
        super(SegmentGroup, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SegmentGroup')
    def exportChildren(self, outfile, level, namespace_='', name_='SegmentGroup', fromsubclass_=False, pretty_print=True):
        super(SegmentGroup, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for member_ in self.members:
            member_.export(outfile, level, namespace_, name_='member', pretty_print=pretty_print)
        for include_ in self.includes:
            include_.export(outfile, level, namespace_, name_='include', pretty_print=pretty_print)
        for path_ in self.paths:
            path_.export(outfile, level, namespace_, name_='path', pretty_print=pretty_print)
        for subTree_ in self.sub_trees:
            subTree_.export(outfile, level, namespace_, name_='subTree', pretty_print=pretty_print)
        for inhomogeneousParam_ in self.inhomogeneous_params:
            inhomogeneousParam_.export(outfile, level, namespace_, name_='inhomogeneousParam', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='SegmentGroup'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(SegmentGroup, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SegmentGroup, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('members=[\n')
        level += 1
        for member_ in self.members:
            showIndent(outfile, level)
            outfile.write('model_.Member(\n')
            member_.exportLiteral(outfile, level, name_='Member')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('includes=[\n')
        level += 1
        for include_ in self.includes:
            showIndent(outfile, level)
            outfile.write('model_.Include(\n')
            include_.exportLiteral(outfile, level, name_='Include')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('paths=[\n')
        level += 1
        for path_ in self.paths:
            showIndent(outfile, level)
            outfile.write('model_.Path(\n')
            path_.exportLiteral(outfile, level, name_='Path')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('sub_trees=[\n')
        level += 1
        for subTree_ in self.sub_trees:
            showIndent(outfile, level)
            outfile.write('model_.SubTree(\n')
            subTree_.exportLiteral(outfile, level, name_='SubTree')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('inhomogeneous_params=[\n')
        level += 1
        for inhomogeneousParam_ in self.inhomogeneous_params:
            showIndent(outfile, level)
            outfile.write('model_.InhomogeneousParam(\n')
            inhomogeneousParam_.exportLiteral(outfile, level, name_='InhomogeneousParam')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(SegmentGroup, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'member':
            obj_ = Member.factory()
            obj_.build(child_)
            self.members.append(obj_)
        elif nodeName_ == 'include':
            obj_ = Include.factory()
            obj_.build(child_)
            self.includes.append(obj_)
        elif nodeName_ == 'path':
            obj_ = Path.factory()
            obj_.build(child_)
            self.paths.append(obj_)
        elif nodeName_ == 'subTree':
            obj_ = SubTree.factory()
            obj_.build(child_)
            self.sub_trees.append(obj_)
        elif nodeName_ == 'inhomogeneousParam':
            obj_ = InhomogeneousParam.factory()
            obj_.build(child_)
            self.inhomogeneous_params.append(obj_)
        super(SegmentGroup, self).buildChildren(child_, node, nodeName_, True)
    @property
    def length(self):
        prox_x = self.proximal.x
        prox_y = self.proximal.y
        prox_z = self.proximal.z

        dist_x = self.distal.x
        dist_y = self.distal.y
        dist_z = self.distal.z

        length = ((prox_x-dist_x)**2 + (prox_y-dist_y)**2 + (prox_z-dist_z)**2)**(0.5)

        return length
    @property
    def volume(self):
        from math import pi

        prox_diam = self.proximal.diameter
        dist_diam = self.distal.diameter

        length = self.length

        volume = (pi/3)*length*(prox_diam**2+dist_diam**2+prox_diam*dist_diam)

        return volume
    
    @property
    def area(self):
        from math import pi
        from math import sqrt

        prox_diam = self.proximal.diameter
        dist_diam = self.distal.diameter
        length = self.length

        area = pi*(prox_diam+dist_diam)*sqrt((prox_diam-dist_diam)**2+length**2)
        
        return area
    # end class SegmentGroup


class Segment(BaseWithoutId):
    member_data_items_ = [
        MemberSpec_('id', 'SegmentId', 0),
        MemberSpec_('name', 'xs:string', 0),
        MemberSpec_('parent', 'SegmentParent', 0),
        MemberSpec_('proximal', 'Point3DWithDiam', 0),
        MemberSpec_('distal', 'Point3DWithDiam', 0),
    ]
    subclass = None
    superclass = BaseWithoutId
    def __init__(self, neuro_lex_id=None, id=None, name=None, parent=None, proximal=None, distal=None):
        super(Segment, self).__init__(neuro_lex_id, )
        self.id = _cast(None, id)
        self.name = _cast(None, name)
        self.parent = parent
        self.proximal = proximal
        self.distal = distal
    def factory(*args_, **kwargs_):
        if Segment.subclass:
            return Segment.subclass(*args_, **kwargs_)
        else:
            return Segment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_SegmentId(self, value):
        # Validate type SegmentId, a restriction on xs:nonNegativeInteger.
        pass
    def hasContent_(self):
        if (
            self.parent is not None or
            self.proximal is not None or
            self.distal is not None or
            super(Segment, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Segment', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Segment')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Segment'):
        super(Segment, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Segment')
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (quote_attrib(self.id), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Segment', fromsubclass_=False, pretty_print=True):
        super(Segment, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.parent is not None:
            self.parent.export(outfile, level, namespace_, name_='parent', pretty_print=pretty_print)
        if self.proximal is not None:
            self.proximal.export(outfile, level, namespace_, name_='proximal', pretty_print=pretty_print)
        if self.distal is not None:
            self.distal.export(outfile, level, namespace_, name_='distal', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Segment'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            showIndent(outfile, level)
            outfile.write('id=%d,\n' % (self.id,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            showIndent(outfile, level)
            outfile.write('name="%s",\n' % (self.name,))
        super(Segment, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Segment, self).exportLiteralChildren(outfile, level, name_)
        if self.parent is not None:
            showIndent(outfile, level)
            outfile.write('parent=model_.SegmentParent(\n')
            self.parent.exportLiteral(outfile, level, name_='parent')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.proximal is not None:
            showIndent(outfile, level)
            outfile.write('proximal=model_.Point3DWithDiam(\n')
            self.proximal.exportLiteral(outfile, level, name_='proximal')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.distal is not None:
            showIndent(outfile, level)
            outfile.write('distal=model_.Point3DWithDiam(\n')
            self.distal.exportLiteral(outfile, level, name_='distal')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_SegmentId(self.id)    # validate type SegmentId
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        super(Segment, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'parent':
            obj_ = SegmentParent.factory()
            obj_.build(child_)
            self.parent = obj_
        elif nodeName_ == 'proximal':
            obj_ = Point3DWithDiam.factory()
            obj_.build(child_)
            self.proximal = obj_
        elif nodeName_ == 'distal':
            obj_ = Point3DWithDiam.factory()
            obj_.build(child_)
            self.distal = obj_
        super(Segment, self).buildChildren(child_, node, nodeName_, True)
    @property
    def length(self):
        prox_x = self.proximal.x
        prox_y = self.proximal.y
        prox_z = self.proximal.z

        dist_x = self.distal.x
        dist_y = self.distal.y
        dist_z = self.distal.z

        length = ((prox_x-dist_x)**2 + (prox_y-dist_y)**2 + (prox_z-dist_z)**2)**(0.5)

        return length
    @property
    def volume(self):
        from math import pi

        prox_diam = self.proximal.diameter
        dist_diam = self.distal.diameter

        length = self.length

        volume = (pi/3)*length*(prox_diam**2+dist_diam**2+prox_diam*dist_diam)

        return volume
    
    @property
    def area(self):
        from math import pi
        from math import sqrt

        prox_diam = self.proximal.diameter
        dist_diam = self.distal.diameter
        length = self.length

        area = pi*(prox_diam+dist_diam)*sqrt((prox_diam-dist_diam)**2+length**2)
        
        return area
    # end class Segment


class Morphology(Standalone):
    """Standalone element which is usually inside a single cell, but could
    be outside and referenced by id."""
    member_data_items_ = [
        MemberSpec_('segments', 'Segment', 1),
        MemberSpec_('segment_groups', 'SegmentGroup', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, segments=None, segment_groups=None):
        super(Morphology, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        if segments is None:
            self.segments = []
        else:
            self.segments = segments
        if segment_groups is None:
            self.segment_groups = []
        else:
            self.segment_groups = segment_groups
    def factory(*args_, **kwargs_):
        if Morphology.subclass:
            return Morphology.subclass(*args_, **kwargs_)
        else:
            return Morphology(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.segments or
            self.segment_groups or
            super(Morphology, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Morphology', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Morphology')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Morphology'):
        super(Morphology, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Morphology')
    def exportChildren(self, outfile, level, namespace_='', name_='Morphology', fromsubclass_=False, pretty_print=True):
        super(Morphology, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for segment_ in self.segments:
            segment_.export(outfile, level, namespace_, name_='segment', pretty_print=pretty_print)
        for segmentGroup_ in self.segment_groups:
            segmentGroup_.export(outfile, level, namespace_, name_='segmentGroup', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Morphology'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Morphology, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Morphology, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('segments=[\n')
        level += 1
        for segment_ in self.segments:
            showIndent(outfile, level)
            outfile.write('model_.Segment(\n')
            segment_.exportLiteral(outfile, level, name_='Segment')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('segment_groups=[\n')
        level += 1
        for segmentGroup_ in self.segment_groups:
            showIndent(outfile, level)
            outfile.write('model_.SegmentGroup(\n')
            segmentGroup_.exportLiteral(outfile, level, name_='SegmentGroup')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Morphology, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'segment':
            obj_ = Segment.factory()
            obj_.build(child_)
            self.segments.append(obj_)
        elif nodeName_ == 'segmentGroup':
            obj_ = SegmentGroup.factory()
            obj_.build(child_)
            self.segment_groups.append(obj_)
        super(Morphology, self).buildChildren(child_, node, nodeName_, True)
    @property
    def num_segments(self):
        return len(self.segments)
# end class Morphology


class BaseCell(Standalone):
    member_data_items_ = [
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, extensiontype_=None):
        super(BaseCell, self).__init__(neuro_lex_id, id, metaid, notes, annotation, extensiontype_, )
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseCell.subclass:
            return BaseCell.subclass(*args_, **kwargs_)
        else:
            return BaseCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BaseCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseCell'):
        super(BaseCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseCell')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseCell', fromsubclass_=False, pretty_print=True):
        super(BaseCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BaseCell'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(BaseCell, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseCell, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseCell


class BaseSynapse(Standalone):
    member_data_items_ = [
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, extensiontype_=None):
        super(BaseSynapse, self).__init__(neuro_lex_id, id, metaid, notes, annotation, extensiontype_, )
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseSynapse.subclass:
            return BaseSynapse.subclass(*args_, **kwargs_)
        else:
            return BaseSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BaseSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseSynapse'):
        super(BaseSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseSynapse')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseSynapse', fromsubclass_=False, pretty_print=True):
        super(BaseSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BaseSynapse'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(BaseSynapse, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseSynapse, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseSynapse


class DecayingPoolConcentrationModel(Standalone):
    """Should not be required, as it's present on the species element!"""
    member_data_items_ = [
        MemberSpec_('ion', 'NmlId', 0),
        MemberSpec_('shellThickness', 'Nml2Quantity_length', 0),
        MemberSpec_('restingConc', 'Nml2Quantity_concentration', 0),
        MemberSpec_('decayConstant', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, ion=None, shell_thickness=None, resting_conc=None, decay_constant=None, extensiontype_=None):
        super(DecayingPoolConcentrationModel, self).__init__(neuro_lex_id, id, metaid, notes, annotation, extensiontype_, )
        self.ion = _cast(None, ion)
        self.shell_thickness = _cast(None, shell_thickness)
        self.resting_conc = _cast(None, resting_conc)
        self.decay_constant = _cast(None, decay_constant)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if DecayingPoolConcentrationModel.subclass:
            return DecayingPoolConcentrationModel.subclass(*args_, **kwargs_)
        else:
            return DecayingPoolConcentrationModel(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_length(self, value):
        # Validate type Nml2Quantity_length, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(DecayingPoolConcentrationModel, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DecayingPoolConcentrationModel', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DecayingPoolConcentrationModel')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DecayingPoolConcentrationModel'):
        super(DecayingPoolConcentrationModel, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DecayingPoolConcentrationModel')
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            outfile.write(' ion=%s' % (quote_attrib(self.ion), ))
        if self.shell_thickness is not None and 'shell_thickness' not in already_processed:
            already_processed.add('shell_thickness')
            outfile.write(' shellThickness=%s' % (quote_attrib(self.shell_thickness), ))
        if self.resting_conc is not None and 'resting_conc' not in already_processed:
            already_processed.add('resting_conc')
            outfile.write(' restingConc=%s' % (quote_attrib(self.resting_conc), ))
        if self.decay_constant is not None and 'decay_constant' not in already_processed:
            already_processed.add('decay_constant')
            outfile.write(' decayConstant=%s' % (quote_attrib(self.decay_constant), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='DecayingPoolConcentrationModel', fromsubclass_=False, pretty_print=True):
        super(DecayingPoolConcentrationModel, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='DecayingPoolConcentrationModel'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.ion is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            showIndent(outfile, level)
            outfile.write('ion="%s",\n' % (self.ion,))
        if self.shell_thickness is not None and 'shell_thickness' not in already_processed:
            already_processed.add('shell_thickness')
            showIndent(outfile, level)
            outfile.write('shell_thickness="%s",\n' % (self.shell_thickness,))
        if self.resting_conc is not None and 'resting_conc' not in already_processed:
            already_processed.add('resting_conc')
            showIndent(outfile, level)
            outfile.write('resting_conc="%s",\n' % (self.resting_conc,))
        if self.decay_constant is not None and 'decay_constant' not in already_processed:
            already_processed.add('decay_constant')
            showIndent(outfile, level)
            outfile.write('decay_constant="%s",\n' % (self.decay_constant,))
        super(DecayingPoolConcentrationModel, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DecayingPoolConcentrationModel, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ion', node)
        if value is not None and 'ion' not in already_processed:
            already_processed.add('ion')
            self.ion = value
            self.validate_NmlId(self.ion)    # validate type NmlId
        value = find_attr_value_('shellThickness', node)
        if value is not None and 'shellThickness' not in already_processed:
            already_processed.add('shellThickness')
            self.shell_thickness = value
            self.validate_Nml2Quantity_length(self.shell_thickness)    # validate type Nml2Quantity_length
        value = find_attr_value_('restingConc', node)
        if value is not None and 'restingConc' not in already_processed:
            already_processed.add('restingConc')
            self.resting_conc = value
            self.validate_Nml2Quantity_concentration(self.resting_conc)    # validate type Nml2Quantity_concentration
        value = find_attr_value_('decayConstant', node)
        if value is not None and 'decayConstant' not in already_processed:
            already_processed.add('decayConstant')
            self.decay_constant = value
            self.validate_Nml2Quantity_time(self.decay_constant)    # validate type Nml2Quantity_time
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(DecayingPoolConcentrationModel, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(DecayingPoolConcentrationModel, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class DecayingPoolConcentrationModel


class GateHHRatesInf(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'xs:integer', 0),
        MemberSpec_('type', 'gateTypes', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('forward_rate', 'HHRate', 0),
        MemberSpec_('reverse_rate', 'HHRate', 0),
        MemberSpec_('steady_state', 'HHVariable', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=1, type=None, notes=None, q10_settings=None, forward_rate=None, reverse_rate=None, steady_state=None):
        super(GateHHRatesInf, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(int, instances)
        self.type = _cast(None, type)
        self.notes = notes
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
        self.steady_state = steady_state
    def factory(*args_, **kwargs_):
        if GateHHRatesInf.subclass:
            return GateHHRatesInf.subclass(*args_, **kwargs_)
        else:
            return GateHHRatesInf(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        pass
    def validate_gateTypes(self, value):
        # Validate type gateTypes, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.forward_rate is not None or
            self.reverse_rate is not None or
            self.steady_state is not None or
            super(GateHHRatesInf, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateHHRatesInf', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRatesInf')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateHHRatesInf'):
        super(GateHHRatesInf, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRatesInf')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances="%s"' % self.gds_format_integer(self.instances, input_name='instances'))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateHHRatesInf', fromsubclass_=False, pretty_print=True):
        super(GateHHRatesInf, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_format_string(quote_xml(self.notes).encode(ExternalEncoding), input_name='notes'), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        if self.forward_rate is not None:
            self.forward_rate.export(outfile, level, namespace_, name_='forwardRate', pretty_print=pretty_print)
        if self.reverse_rate is not None:
            self.reverse_rate.export(outfile, level, namespace_, name_='reverseRate', pretty_print=pretty_print)
        if self.steady_state is not None:
            self.steady_state.export(outfile, level, namespace_, name_='steadyState', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='GateHHRatesInf'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            showIndent(outfile, level)
            outfile.write('instances=%d,\n' % (self.instances,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        super(GateHHRatesInf, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GateHHRatesInf, self).exportLiteralChildren(outfile, level, name_)
        if self.notes is not None:
            showIndent(outfile, level)
            outfile.write('notes=%s,\n' % quote_python(self.notes).encode(ExternalEncoding))
        if self.q10_settings is not None:
            showIndent(outfile, level)
            outfile.write('q10_settings=model_.Q10Settings(\n')
            self.q10_settings.exportLiteral(outfile, level, name_='q10Settings')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.forward_rate is not None:
            showIndent(outfile, level)
            outfile.write('forward_rate=model_.HHRate(\n')
            self.forward_rate.exportLiteral(outfile, level, name_='forwardRate')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.reverse_rate is not None:
            showIndent(outfile, level)
            outfile.write('reverse_rate=model_.HHRate(\n')
            self.reverse_rate.exportLiteral(outfile, level, name_='reverseRate')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.steady_state is not None:
            showIndent(outfile, level)
            outfile.write('steady_state=model_.HHVariable(\n')
            self.steady_state.exportLiteral(outfile, level, name_='steadyState')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_gateTypes(self.type)    # validate type gateTypes
        super(GateHHRatesInf, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            self.validate_Notes(self.notes)    # validate type Notes
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
        elif nodeName_ == 'forwardRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.forward_rate = obj_
        elif nodeName_ == 'reverseRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.reverse_rate = obj_
        elif nodeName_ == 'steadyState':
            obj_ = HHVariable.factory()
            obj_.build(child_)
            self.steady_state = obj_
        super(GateHHRatesInf, self).buildChildren(child_, node, nodeName_, True)
# end class GateHHRatesInf


class GateHHRatesTau(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'xs:integer', 0),
        MemberSpec_('type', 'gateTypes', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('forward_rate', 'HHRate', 0),
        MemberSpec_('reverse_rate', 'HHRate', 0),
        MemberSpec_('time_course', 'HHTime', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=1, type=None, notes=None, q10_settings=None, forward_rate=None, reverse_rate=None, time_course=None):
        super(GateHHRatesTau, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(int, instances)
        self.type = _cast(None, type)
        self.notes = notes
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
        self.time_course = time_course
    def factory(*args_, **kwargs_):
        if GateHHRatesTau.subclass:
            return GateHHRatesTau.subclass(*args_, **kwargs_)
        else:
            return GateHHRatesTau(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        pass
    def validate_gateTypes(self, value):
        # Validate type gateTypes, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.forward_rate is not None or
            self.reverse_rate is not None or
            self.time_course is not None or
            super(GateHHRatesTau, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateHHRatesTau', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRatesTau')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateHHRatesTau'):
        super(GateHHRatesTau, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRatesTau')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances="%s"' % self.gds_format_integer(self.instances, input_name='instances'))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateHHRatesTau', fromsubclass_=False, pretty_print=True):
        super(GateHHRatesTau, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_format_string(quote_xml(self.notes).encode(ExternalEncoding), input_name='notes'), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        if self.forward_rate is not None:
            self.forward_rate.export(outfile, level, namespace_, name_='forwardRate', pretty_print=pretty_print)
        if self.reverse_rate is not None:
            self.reverse_rate.export(outfile, level, namespace_, name_='reverseRate', pretty_print=pretty_print)
        if self.time_course is not None:
            self.time_course.export(outfile, level, namespace_, name_='timeCourse', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='GateHHRatesTau'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            showIndent(outfile, level)
            outfile.write('instances=%d,\n' % (self.instances,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        super(GateHHRatesTau, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GateHHRatesTau, self).exportLiteralChildren(outfile, level, name_)
        if self.notes is not None:
            showIndent(outfile, level)
            outfile.write('notes=%s,\n' % quote_python(self.notes).encode(ExternalEncoding))
        if self.q10_settings is not None:
            showIndent(outfile, level)
            outfile.write('q10_settings=model_.Q10Settings(\n')
            self.q10_settings.exportLiteral(outfile, level, name_='q10Settings')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.forward_rate is not None:
            showIndent(outfile, level)
            outfile.write('forward_rate=model_.HHRate(\n')
            self.forward_rate.exportLiteral(outfile, level, name_='forwardRate')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.reverse_rate is not None:
            showIndent(outfile, level)
            outfile.write('reverse_rate=model_.HHRate(\n')
            self.reverse_rate.exportLiteral(outfile, level, name_='reverseRate')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.time_course is not None:
            showIndent(outfile, level)
            outfile.write('time_course=model_.HHTime(\n')
            self.time_course.exportLiteral(outfile, level, name_='timeCourse')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_gateTypes(self.type)    # validate type gateTypes
        super(GateHHRatesTau, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            self.validate_Notes(self.notes)    # validate type Notes
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
        elif nodeName_ == 'forwardRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.forward_rate = obj_
        elif nodeName_ == 'reverseRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.reverse_rate = obj_
        elif nodeName_ == 'timeCourse':
            obj_ = HHTime.factory()
            obj_.build(child_)
            self.time_course = obj_
        super(GateHHRatesTau, self).buildChildren(child_, node, nodeName_, True)
# end class GateHHRatesTau


class GateHHTauInf(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'xs:integer', 0),
        MemberSpec_('type', 'gateTypes', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('time_course', 'HHTime', 0),
        MemberSpec_('steady_state', 'HHVariable', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=1, type=None, notes=None, q10_settings=None, time_course=None, steady_state=None):
        super(GateHHTauInf, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(int, instances)
        self.type = _cast(None, type)
        self.notes = notes
        self.q10_settings = q10_settings
        self.time_course = time_course
        self.steady_state = steady_state
    def factory(*args_, **kwargs_):
        if GateHHTauInf.subclass:
            return GateHHTauInf.subclass(*args_, **kwargs_)
        else:
            return GateHHTauInf(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        pass
    def validate_gateTypes(self, value):
        # Validate type gateTypes, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.time_course is not None or
            self.steady_state is not None or
            super(GateHHTauInf, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateHHTauInf', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHTauInf')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateHHTauInf'):
        super(GateHHTauInf, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHTauInf')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances="%s"' % self.gds_format_integer(self.instances, input_name='instances'))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateHHTauInf', fromsubclass_=False, pretty_print=True):
        super(GateHHTauInf, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_format_string(quote_xml(self.notes).encode(ExternalEncoding), input_name='notes'), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        if self.time_course is not None:
            self.time_course.export(outfile, level, namespace_, name_='timeCourse', pretty_print=pretty_print)
        if self.steady_state is not None:
            self.steady_state.export(outfile, level, namespace_, name_='steadyState', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='GateHHTauInf'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            showIndent(outfile, level)
            outfile.write('instances=%d,\n' % (self.instances,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        super(GateHHTauInf, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GateHHTauInf, self).exportLiteralChildren(outfile, level, name_)
        if self.notes is not None:
            showIndent(outfile, level)
            outfile.write('notes=%s,\n' % quote_python(self.notes).encode(ExternalEncoding))
        if self.q10_settings is not None:
            showIndent(outfile, level)
            outfile.write('q10_settings=model_.Q10Settings(\n')
            self.q10_settings.exportLiteral(outfile, level, name_='q10Settings')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.time_course is not None:
            showIndent(outfile, level)
            outfile.write('time_course=model_.HHTime(\n')
            self.time_course.exportLiteral(outfile, level, name_='timeCourse')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.steady_state is not None:
            showIndent(outfile, level)
            outfile.write('steady_state=model_.HHVariable(\n')
            self.steady_state.exportLiteral(outfile, level, name_='steadyState')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_gateTypes(self.type)    # validate type gateTypes
        super(GateHHTauInf, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            self.validate_Notes(self.notes)    # validate type Notes
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
        elif nodeName_ == 'timeCourse':
            obj_ = HHTime.factory()
            obj_.build(child_)
            self.time_course = obj_
        elif nodeName_ == 'steadyState':
            obj_ = HHVariable.factory()
            obj_.build(child_)
            self.steady_state = obj_
        super(GateHHTauInf, self).buildChildren(child_, node, nodeName_, True)
# end class GateHHTauInf


class GateHHRates(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'xs:integer', 0),
        MemberSpec_('type', 'gateTypes', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('forward_rate', 'HHRate', 0),
        MemberSpec_('reverse_rate', 'HHRate', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=1, type=None, notes=None, q10_settings=None, forward_rate=None, reverse_rate=None):
        super(GateHHRates, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(int, instances)
        self.type = _cast(None, type)
        self.notes = notes
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
    def factory(*args_, **kwargs_):
        if GateHHRates.subclass:
            return GateHHRates.subclass(*args_, **kwargs_)
        else:
            return GateHHRates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        pass
    def validate_gateTypes(self, value):
        # Validate type gateTypes, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.forward_rate is not None or
            self.reverse_rate is not None or
            super(GateHHRates, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateHHRates', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRates')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateHHRates'):
        super(GateHHRates, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHRates')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances="%s"' % self.gds_format_integer(self.instances, input_name='instances'))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateHHRates', fromsubclass_=False, pretty_print=True):
        super(GateHHRates, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_format_string(quote_xml(self.notes).encode(ExternalEncoding), input_name='notes'), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        if self.forward_rate is not None:
            self.forward_rate.export(outfile, level, namespace_, name_='forwardRate', pretty_print=pretty_print)
        if self.reverse_rate is not None:
            self.reverse_rate.export(outfile, level, namespace_, name_='reverseRate', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='GateHHRates'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            showIndent(outfile, level)
            outfile.write('instances=%d,\n' % (self.instances,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        super(GateHHRates, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GateHHRates, self).exportLiteralChildren(outfile, level, name_)
        if self.notes is not None:
            showIndent(outfile, level)
            outfile.write('notes=%s,\n' % quote_python(self.notes).encode(ExternalEncoding))
        if self.q10_settings is not None:
            showIndent(outfile, level)
            outfile.write('q10_settings=model_.Q10Settings(\n')
            self.q10_settings.exportLiteral(outfile, level, name_='q10Settings')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.forward_rate is not None:
            showIndent(outfile, level)
            outfile.write('forward_rate=model_.HHRate(\n')
            self.forward_rate.exportLiteral(outfile, level, name_='forwardRate')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.reverse_rate is not None:
            showIndent(outfile, level)
            outfile.write('reverse_rate=model_.HHRate(\n')
            self.reverse_rate.exportLiteral(outfile, level, name_='reverseRate')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_gateTypes(self.type)    # validate type gateTypes
        super(GateHHRates, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            self.validate_Notes(self.notes)    # validate type Notes
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
        elif nodeName_ == 'forwardRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.forward_rate = obj_
        elif nodeName_ == 'reverseRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.reverse_rate = obj_
        super(GateHHRates, self).buildChildren(child_, node, nodeName_, True)
# end class GateHHRates


class GateHHUndetermined(Base):
    member_data_items_ = [
        MemberSpec_('instances', 'xs:integer', 0),
        MemberSpec_('type', 'gateTypes', 0),
        MemberSpec_('notes', ['Notes', 'xs:string'], 0),
        MemberSpec_('q10_settings', 'Q10Settings', 0),
        MemberSpec_('forward_rate', 'HHRate', 0),
        MemberSpec_('reverse_rate', 'HHRate', 0),
        MemberSpec_('time_course', 'HHTime', 0),
        MemberSpec_('steady_state', 'HHVariable', 0),
    ]
    subclass = None
    superclass = Base
    def __init__(self, neuro_lex_id=None, id=None, instances=1, type=None, notes=None, q10_settings=None, forward_rate=None, reverse_rate=None, time_course=None, steady_state=None):
        super(GateHHUndetermined, self).__init__(neuro_lex_id, id, )
        self.instances = _cast(int, instances)
        self.type = _cast(None, type)
        self.notes = notes
        self.q10_settings = q10_settings
        self.forward_rate = forward_rate
        self.reverse_rate = reverse_rate
        self.time_course = time_course
        self.steady_state = steady_state
    def factory(*args_, **kwargs_):
        if GateHHUndetermined.subclass:
            return GateHHUndetermined.subclass(*args_, **kwargs_)
        else:
            return GateHHUndetermined(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Notes(self, value):
        # Validate type Notes, a restriction on xs:string.
        pass
    def validate_gateTypes(self, value):
        # Validate type gateTypes, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.notes is not None or
            self.q10_settings is not None or
            self.forward_rate is not None or
            self.reverse_rate is not None or
            self.time_course is not None or
            self.steady_state is not None or
            super(GateHHUndetermined, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GateHHUndetermined', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHUndetermined')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GateHHUndetermined'):
        super(GateHHUndetermined, self).exportAttributes(outfile, level, already_processed, namespace_, name_='GateHHUndetermined')
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            outfile.write(' instances="%s"' % self.gds_format_integer(self.instances, input_name='instances'))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
    def exportChildren(self, outfile, level, namespace_='', name_='GateHHUndetermined', fromsubclass_=False, pretty_print=True):
        super(GateHHUndetermined, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.notes is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snotes>%s</%snotes>%s' % (namespace_, self.gds_format_string(quote_xml(self.notes).encode(ExternalEncoding), input_name='notes'), namespace_, eol_))
        if self.q10_settings is not None:
            self.q10_settings.export(outfile, level, namespace_, name_='q10Settings', pretty_print=pretty_print)
        if self.forward_rate is not None:
            self.forward_rate.export(outfile, level, namespace_, name_='forwardRate', pretty_print=pretty_print)
        if self.reverse_rate is not None:
            self.reverse_rate.export(outfile, level, namespace_, name_='reverseRate', pretty_print=pretty_print)
        if self.time_course is not None:
            self.time_course.export(outfile, level, namespace_, name_='timeCourse', pretty_print=pretty_print)
        if self.steady_state is not None:
            self.steady_state.export(outfile, level, namespace_, name_='steadyState', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='GateHHUndetermined'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.instances is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            showIndent(outfile, level)
            outfile.write('instances=%d,\n' % (self.instances,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        super(GateHHUndetermined, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(GateHHUndetermined, self).exportLiteralChildren(outfile, level, name_)
        if self.notes is not None:
            showIndent(outfile, level)
            outfile.write('notes=%s,\n' % quote_python(self.notes).encode(ExternalEncoding))
        if self.q10_settings is not None:
            showIndent(outfile, level)
            outfile.write('q10_settings=model_.Q10Settings(\n')
            self.q10_settings.exportLiteral(outfile, level, name_='q10Settings')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.forward_rate is not None:
            showIndent(outfile, level)
            outfile.write('forward_rate=model_.HHRate(\n')
            self.forward_rate.exportLiteral(outfile, level, name_='forwardRate')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.reverse_rate is not None:
            showIndent(outfile, level)
            outfile.write('reverse_rate=model_.HHRate(\n')
            self.reverse_rate.exportLiteral(outfile, level, name_='reverseRate')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.time_course is not None:
            showIndent(outfile, level)
            outfile.write('time_course=model_.HHTime(\n')
            self.time_course.exportLiteral(outfile, level, name_='timeCourse')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.steady_state is not None:
            showIndent(outfile, level)
            outfile.write('steady_state=model_.HHVariable(\n')
            self.steady_state.exportLiteral(outfile, level, name_='steadyState')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('instances', node)
        if value is not None and 'instances' not in already_processed:
            already_processed.add('instances')
            try:
                self.instances = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_gateTypes(self.type)    # validate type gateTypes
        super(GateHHUndetermined, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'notes':
            notes_ = child_.text
            notes_ = self.gds_validate_string(notes_, node, 'notes')
            self.notes = notes_
            self.validate_Notes(self.notes)    # validate type Notes
        elif nodeName_ == 'q10Settings':
            obj_ = Q10Settings.factory()
            obj_.build(child_)
            self.q10_settings = obj_
        elif nodeName_ == 'forwardRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.forward_rate = obj_
        elif nodeName_ == 'reverseRate':
            obj_ = HHRate.factory()
            obj_.build(child_)
            self.reverse_rate = obj_
        elif nodeName_ == 'timeCourse':
            obj_ = HHTime.factory()
            obj_.build(child_)
            self.time_course = obj_
        elif nodeName_ == 'steadyState':
            obj_ = HHVariable.factory()
            obj_.build(child_)
            self.steady_state = obj_
        super(GateHHUndetermined, self).buildChildren(child_, node, nodeName_, True)
# end class GateHHUndetermined


class IonChannel(Standalone):
    member_data_items_ = [
        MemberSpec_('conductance', 'Nml2Quantity_conductance', 0),
        MemberSpec_('type', 'channelTypes', 0),
        MemberSpec_('species', 'NmlId', 0),
        MemberSpec_('gates', 'GateHHUndetermined', 1),
        MemberSpec_('gate_hh_rates', 'GateHHRates', 1),
        MemberSpec_('gate_h_hrates_taus', 'GateHHRatesTau', 1),
        MemberSpec_('gate_hh_tau_infs', 'GateHHTauInf', 1),
        MemberSpec_('gate_h_hrates_infs', 'GateHHRatesInf', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, conductance=None, type=None, species=None, gates=None, gate_hh_rates=None, gate_h_hrates_taus=None, gate_hh_tau_infs=None, gate_h_hrates_infs=None):
        super(IonChannel, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.conductance = _cast(None, conductance)
        self.type = _cast(None, type)
        self.species = _cast(None, species)
        if gates is None:
            self.gates = []
        else:
            self.gates = gates
        if gate_hh_rates is None:
            self.gate_hh_rates = []
        else:
            self.gate_hh_rates = gate_hh_rates
        if gate_h_hrates_taus is None:
            self.gate_h_hrates_taus = []
        else:
            self.gate_h_hrates_taus = gate_h_hrates_taus
        if gate_hh_tau_infs is None:
            self.gate_hh_tau_infs = []
        else:
            self.gate_hh_tau_infs = gate_hh_tau_infs
        if gate_h_hrates_infs is None:
            self.gate_h_hrates_infs = []
        else:
            self.gate_h_hrates_infs = gate_h_hrates_infs
    def factory(*args_, **kwargs_):
        if IonChannel.subclass:
            return IonChannel.subclass(*args_, **kwargs_)
        else:
            return IonChannel(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        pass
    def validate_channelTypes(self, value):
        # Validate type channelTypes, a restriction on xs:string.
        pass
    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.gates or
            self.gate_hh_rates or
            self.gate_h_hrates_taus or
            self.gate_hh_tau_infs or
            self.gate_h_hrates_infs or
            super(IonChannel, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IonChannel', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IonChannel')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IonChannel'):
        super(IonChannel, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IonChannel')
        if self.conductance is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            outfile.write(' conductance=%s' % (quote_attrib(self.conductance), ))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (quote_attrib(self.type), ))
        if self.species is not None and 'species' not in already_processed:
            already_processed.add('species')
            outfile.write(' species=%s' % (quote_attrib(self.species), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IonChannel', fromsubclass_=False, pretty_print=True):
        super(IonChannel, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for gate_ in self.gates:
            gate_.export(outfile, level, namespace_, name_='gate', pretty_print=pretty_print)
        for gateHHrates_ in self.gate_hh_rates:
            gateHHrates_.export(outfile, level, namespace_, name_='gateHHrates', pretty_print=pretty_print)
        for gateHHratesTau_ in self.gate_h_hrates_taus:
            gateHHratesTau_.export(outfile, level, namespace_, name_='gateHHratesTau', pretty_print=pretty_print)
        for gateHHtauInf_ in self.gate_hh_tau_infs:
            gateHHtauInf_.export(outfile, level, namespace_, name_='gateHHtauInf', pretty_print=pretty_print)
        for gateHHratesInf_ in self.gate_h_hrates_infs:
            gateHHratesInf_.export(outfile, level, namespace_, name_='gateHHratesInf', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IonChannel'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.conductance is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            showIndent(outfile, level)
            outfile.write('conductance="%s",\n' % (self.conductance,))
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        if self.species is not None and 'species' not in already_processed:
            already_processed.add('species')
            showIndent(outfile, level)
            outfile.write('species="%s",\n' % (self.species,))
        super(IonChannel, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IonChannel, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('gates=[\n')
        level += 1
        for gate_ in self.gates:
            showIndent(outfile, level)
            outfile.write('model_.GateHHUndetermined(\n')
            gate_.exportLiteral(outfile, level, name_='GateHHUndetermined')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('gate_hh_rates=[\n')
        level += 1
        for gateHHrates_ in self.gate_hh_rates:
            showIndent(outfile, level)
            outfile.write('model_.GateHHRates(\n')
            gateHHrates_.exportLiteral(outfile, level, name_='GateHHRates')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('gate_h_hrates_taus=[\n')
        level += 1
        for gateHHratesTau_ in self.gate_h_hrates_taus:
            showIndent(outfile, level)
            outfile.write('model_.GateHHRatesTau(\n')
            gateHHratesTau_.exportLiteral(outfile, level, name_='GateHHRatesTau')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('gate_hh_tau_infs=[\n')
        level += 1
        for gateHHtauInf_ in self.gate_hh_tau_infs:
            showIndent(outfile, level)
            outfile.write('model_.GateHHTauInf(\n')
            gateHHtauInf_.exportLiteral(outfile, level, name_='GateHHTauInf')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('gate_h_hrates_infs=[\n')
        level += 1
        for gateHHratesInf_ in self.gate_h_hrates_infs:
            showIndent(outfile, level)
            outfile.write('model_.GateHHRatesInf(\n')
            gateHHratesInf_.exportLiteral(outfile, level, name_='GateHHRatesInf')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('conductance', node)
        if value is not None and 'conductance' not in already_processed:
            already_processed.add('conductance')
            self.conductance = value
            self.validate_Nml2Quantity_conductance(self.conductance)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
            self.validate_channelTypes(self.type)    # validate type channelTypes
        value = find_attr_value_('species', node)
        if value is not None and 'species' not in already_processed:
            already_processed.add('species')
            self.species = value
            self.validate_NmlId(self.species)    # validate type NmlId
        super(IonChannel, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'gate':
            obj_ = GateHHUndetermined.factory()
            obj_.build(child_)
            self.gates.append(obj_)
        elif nodeName_ == 'gateHHrates':
            obj_ = GateHHRates.factory()
            obj_.build(child_)
            self.gate_hh_rates.append(obj_)
        elif nodeName_ == 'gateHHratesTau':
            obj_ = GateHHRatesTau.factory()
            obj_.build(child_)
            self.gate_h_hrates_taus.append(obj_)
        elif nodeName_ == 'gateHHtauInf':
            obj_ = GateHHTauInf.factory()
            obj_.build(child_)
            self.gate_hh_tau_infs.append(obj_)
        elif nodeName_ == 'gateHHratesInf':
            obj_ = GateHHRatesInf.factory()
            obj_.build(child_)
            self.gate_h_hrates_infs.append(obj_)
        super(IonChannel, self).buildChildren(child_, node, nodeName_, True)
# end class IonChannel


class NeuroMLDocument(Standalone):
    member_data_items_ = [
        MemberSpec_('includes', 'IncludeType', 1),
        MemberSpec_('extracellular_properties', 'ExtracellularProperties', 1),
        MemberSpec_('intracellular_properties', 'IntracellularProperties', 1),
        MemberSpec_('morphology', 'Morphology', 1),
        MemberSpec_('ion_channels', 'IonChannel', 1),
        MemberSpec_('decaying_pool_concentration_models', 'DecayingPoolConcentrationModel', 1),
        MemberSpec_('exp_one_synapses', 'ExpOneSynapse', 1),
        MemberSpec_('exp_two_synapses', 'ExpTwoSynapse', 1),
        MemberSpec_('blocking_plastic_synapses', 'BlockingPlasticSynapse', 1),
        MemberSpec_('biophysical_properties', 'BiophysicalProperties', 1),
        MemberSpec_('cells', 'Cell', 1),
        MemberSpec_('base_cells', 'BaseCell', 1),
        MemberSpec_('iaf_tau_cells', 'IaFTauCell', 1),
        MemberSpec_('iaf_tau_ref_cells', 'IaFTauRefCell', 1),
        MemberSpec_('iaf_cells', 'IaFCell', 1),
        MemberSpec_('iaf_ref_cells', 'IaFRefCell', 1),
        MemberSpec_('izhikevich_cells', 'IzhikevichCell', 1),
        MemberSpec_('ad_ex_ia_f_cells', 'AdExIaFCell', 1),
        MemberSpec_('pulse_generators', 'PulseGenerator', 1),
        MemberSpec_('sine_generators', 'SineGenerator', 1),
        MemberSpec_('ramp_generators', 'RampGenerator', 1),
        MemberSpec_('voltage_clamps', 'VoltageClamp', 1),
        MemberSpec_('spike_arrays', 'SpikeArray', 1),
        MemberSpec_('spike_generators', 'SpikeGenerator', 1),
        MemberSpec_('spike_generator_randoms', 'SpikeGeneratorRandom', 1),
        MemberSpec_('spike_generator_poissons', 'SpikeGeneratorPoisson', 1),
        MemberSpec_('IF_curr_alpha', 'IF_curr_alpha', 1),
        MemberSpec_('IF_curr_exp', 'IF_curr_exp', 1),
        MemberSpec_('IF_cond_alpha', 'IF_cond_alpha', 1),
        MemberSpec_('IF_cond_exp', 'IF_cond_exp', 1),
        MemberSpec_('EIF_cond_exp_isfa_ista', 'EIF_cond_exp_isfa_ista', 1),
        MemberSpec_('EIF_cond_alpha_isfa_ista', 'EIF_cond_alpha_isfa_ista', 1),
        MemberSpec_('HH_cond_exp', 'HH_cond_exp', 1),
        MemberSpec_('exp_cond_synapses', 'ExpCondSynapse', 1),
        MemberSpec_('alpha_cond_synapses', 'AlphaCondSynapse', 1),
        MemberSpec_('exp_curr_synapses', 'ExpCurrSynapse', 1),
        MemberSpec_('alpha_curr_synapses', 'AlphaCurrSynapse', 1),
        MemberSpec_('SpikeSourcePoisson', 'SpikeSourcePoisson', 1),
        MemberSpec_('networks', 'Network', 1),
        MemberSpec_('ComponentType', 'ComponentType', 1),
    ]
    subclass = None
    superclass = Standalone
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, includes=None, extracellular_properties=None, intracellular_properties=None, morphology=None, ion_channels=None, decaying_pool_concentration_models=None, exp_one_synapses=None, exp_two_synapses=None, blocking_plastic_synapses=None, biophysical_properties=None, cells=None, base_cells=None, iaf_tau_cells=None, iaf_tau_ref_cells=None, iaf_cells=None, iaf_ref_cells=None, izhikevich_cells=None, ad_ex_ia_f_cells=None, pulse_generators=None, sine_generators=None, ramp_generators=None, voltage_clamps=None, spike_arrays=None, spike_generators=None, spike_generator_randoms=None, spike_generator_poissons=None, IF_curr_alpha=None, IF_curr_exp=None, IF_cond_alpha=None, IF_cond_exp=None, EIF_cond_exp_isfa_ista=None, EIF_cond_alpha_isfa_ista=None, HH_cond_exp=None, exp_cond_synapses=None, alpha_cond_synapses=None, exp_curr_synapses=None, alpha_curr_synapses=None, SpikeSourcePoisson=None, networks=None, ComponentType=None):
        super(NeuroMLDocument, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        if includes is None:
            self.includes = []
        else:
            self.includes = includes
        if extracellular_properties is None:
            self.extracellular_properties = []
        else:
            self.extracellular_properties = extracellular_properties
        if intracellular_properties is None:
            self.intracellular_properties = []
        else:
            self.intracellular_properties = intracellular_properties
        if morphology is None:
            self.morphology = []
        else:
            self.morphology = morphology
        if ion_channels is None:
            self.ion_channels = []
        else:
            self.ion_channels = ion_channels
        if decaying_pool_concentration_models is None:
            self.decaying_pool_concentration_models = []
        else:
            self.decaying_pool_concentration_models = decaying_pool_concentration_models
        if exp_one_synapses is None:
            self.exp_one_synapses = []
        else:
            self.exp_one_synapses = exp_one_synapses
        if exp_two_synapses is None:
            self.exp_two_synapses = []
        else:
            self.exp_two_synapses = exp_two_synapses
        if blocking_plastic_synapses is None:
            self.blocking_plastic_synapses = []
        else:
            self.blocking_plastic_synapses = blocking_plastic_synapses
        if biophysical_properties is None:
            self.biophysical_properties = []
        else:
            self.biophysical_properties = biophysical_properties
        if cells is None:
            self.cells = []
        else:
            self.cells = cells
        if base_cells is None:
            self.base_cells = []
        else:
            self.base_cells = base_cells
        if iaf_tau_cells is None:
            self.iaf_tau_cells = []
        else:
            self.iaf_tau_cells = iaf_tau_cells
        if iaf_tau_ref_cells is None:
            self.iaf_tau_ref_cells = []
        else:
            self.iaf_tau_ref_cells = iaf_tau_ref_cells
        if iaf_cells is None:
            self.iaf_cells = []
        else:
            self.iaf_cells = iaf_cells
        if iaf_ref_cells is None:
            self.iaf_ref_cells = []
        else:
            self.iaf_ref_cells = iaf_ref_cells
        if izhikevich_cells is None:
            self.izhikevich_cells = []
        else:
            self.izhikevich_cells = izhikevich_cells
        if ad_ex_ia_f_cells is None:
            self.ad_ex_ia_f_cells = []
        else:
            self.ad_ex_ia_f_cells = ad_ex_ia_f_cells
        if pulse_generators is None:
            self.pulse_generators = []
        else:
            self.pulse_generators = pulse_generators
        if sine_generators is None:
            self.sine_generators = []
        else:
            self.sine_generators = sine_generators
        if ramp_generators is None:
            self.ramp_generators = []
        else:
            self.ramp_generators = ramp_generators
        if voltage_clamps is None:
            self.voltage_clamps = []
        else:
            self.voltage_clamps = voltage_clamps
        if spike_arrays is None:
            self.spike_arrays = []
        else:
            self.spike_arrays = spike_arrays
        if spike_generators is None:
            self.spike_generators = []
        else:
            self.spike_generators = spike_generators
        if spike_generator_randoms is None:
            self.spike_generator_randoms = []
        else:
            self.spike_generator_randoms = spike_generator_randoms
        if spike_generator_poissons is None:
            self.spike_generator_poissons = []
        else:
            self.spike_generator_poissons = spike_generator_poissons
        if IF_curr_alpha is None:
            self.IF_curr_alpha = []
        else:
            self.IF_curr_alpha = IF_curr_alpha
        if IF_curr_exp is None:
            self.IF_curr_exp = []
        else:
            self.IF_curr_exp = IF_curr_exp
        if IF_cond_alpha is None:
            self.IF_cond_alpha = []
        else:
            self.IF_cond_alpha = IF_cond_alpha
        if IF_cond_exp is None:
            self.IF_cond_exp = []
        else:
            self.IF_cond_exp = IF_cond_exp
        if EIF_cond_exp_isfa_ista is None:
            self.EIF_cond_exp_isfa_ista = []
        else:
            self.EIF_cond_exp_isfa_ista = EIF_cond_exp_isfa_ista
        if EIF_cond_alpha_isfa_ista is None:
            self.EIF_cond_alpha_isfa_ista = []
        else:
            self.EIF_cond_alpha_isfa_ista = EIF_cond_alpha_isfa_ista
        if HH_cond_exp is None:
            self.HH_cond_exp = []
        else:
            self.HH_cond_exp = HH_cond_exp
        if exp_cond_synapses is None:
            self.exp_cond_synapses = []
        else:
            self.exp_cond_synapses = exp_cond_synapses
        if alpha_cond_synapses is None:
            self.alpha_cond_synapses = []
        else:
            self.alpha_cond_synapses = alpha_cond_synapses
        if exp_curr_synapses is None:
            self.exp_curr_synapses = []
        else:
            self.exp_curr_synapses = exp_curr_synapses
        if alpha_curr_synapses is None:
            self.alpha_curr_synapses = []
        else:
            self.alpha_curr_synapses = alpha_curr_synapses
        if SpikeSourcePoisson is None:
            self.SpikeSourcePoisson = []
        else:
            self.SpikeSourcePoisson = SpikeSourcePoisson
        if networks is None:
            self.networks = []
        else:
            self.networks = networks
        if ComponentType is None:
            self.ComponentType = []
        else:
            self.ComponentType = ComponentType
    def factory(*args_, **kwargs_):
        if NeuroMLDocument.subclass:
            return NeuroMLDocument.subclass(*args_, **kwargs_)
        else:
            return NeuroMLDocument(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.includes or
            self.extracellular_properties or
            self.intracellular_properties or
            self.morphology or
            self.ion_channels or
            self.decaying_pool_concentration_models or
            self.exp_one_synapses or
            self.exp_two_synapses or
            self.blocking_plastic_synapses or
            self.biophysical_properties or
            self.cells or
            self.base_cells or
            self.iaf_tau_cells or
            self.iaf_tau_ref_cells or
            self.iaf_cells or
            self.iaf_ref_cells or
            self.izhikevich_cells or
            self.ad_ex_ia_f_cells or
            self.pulse_generators or
            self.sine_generators or
            self.ramp_generators or
            self.voltage_clamps or
            self.spike_arrays or
            self.spike_generators or
            self.spike_generator_randoms or
            self.spike_generator_poissons or
            self.IF_curr_alpha or
            self.IF_curr_exp or
            self.IF_cond_alpha or
            self.IF_cond_exp or
            self.EIF_cond_exp_isfa_ista or
            self.EIF_cond_alpha_isfa_ista or
            self.HH_cond_exp or
            self.exp_cond_synapses or
            self.alpha_cond_synapses or
            self.exp_curr_synapses or
            self.alpha_curr_synapses or
            self.SpikeSourcePoisson or
            self.networks or
            self.ComponentType or
            super(NeuroMLDocument, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NeuroMLDocument', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NeuroMLDocument')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NeuroMLDocument'):
        super(NeuroMLDocument, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NeuroMLDocument')
    def exportChildren(self, outfile, level, namespace_='', name_='NeuroMLDocument', fromsubclass_=False, pretty_print=True):
        super(NeuroMLDocument, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for include_ in self.includes:
            include_.export(outfile, level, namespace_, name_='include', pretty_print=pretty_print)
        for extracellularProperties_ in self.extracellular_properties:
            extracellularProperties_.export(outfile, level, namespace_, name_='extracellularProperties', pretty_print=pretty_print)
        for intracellularProperties_ in self.intracellular_properties:
            intracellularProperties_.export(outfile, level, namespace_, name_='intracellularProperties', pretty_print=pretty_print)
        for morphology_ in self.morphology:
            morphology_.export(outfile, level, namespace_, name_='morphology', pretty_print=pretty_print)
        for ionChannel_ in self.ion_channels:
            ionChannel_.export(outfile, level, namespace_, name_='ionChannel', pretty_print=pretty_print)
        for decayingPoolConcentrationModel_ in self.decaying_pool_concentration_models:
            decayingPoolConcentrationModel_.export(outfile, level, namespace_, name_='decayingPoolConcentrationModel', pretty_print=pretty_print)
        for expOneSynapse_ in self.exp_one_synapses:
            expOneSynapse_.export(outfile, level, namespace_, name_='expOneSynapse', pretty_print=pretty_print)
        for expTwoSynapse_ in self.exp_two_synapses:
            expTwoSynapse_.export(outfile, level, namespace_, name_='expTwoSynapse', pretty_print=pretty_print)
        for blockingPlasticSynapse_ in self.blocking_plastic_synapses:
            blockingPlasticSynapse_.export(outfile, level, namespace_, name_='blockingPlasticSynapse', pretty_print=pretty_print)
        for biophysicalProperties_ in self.biophysical_properties:
            biophysicalProperties_.export(outfile, level, namespace_, name_='biophysicalProperties', pretty_print=pretty_print)
        for cell_ in self.cells:
            cell_.export(outfile, level, namespace_, name_='cell', pretty_print=pretty_print)
        for baseCell_ in self.base_cells:
            baseCell_.export(outfile, level, namespace_, name_='baseCell', pretty_print=pretty_print)
        for iafTauCell_ in self.iaf_tau_cells:
            iafTauCell_.export(outfile, level, namespace_, name_='iafTauCell', pretty_print=pretty_print)
        for iafTauRefCell_ in self.iaf_tau_ref_cells:
            iafTauRefCell_.export(outfile, level, namespace_, name_='iafTauRefCell', pretty_print=pretty_print)
        for iafCell_ in self.iaf_cells:
            iafCell_.export(outfile, level, namespace_, name_='iafCell', pretty_print=pretty_print)
        for iafRefCell_ in self.iaf_ref_cells:
            iafRefCell_.export(outfile, level, namespace_, name_='iafRefCell', pretty_print=pretty_print)
        for izhikevichCell_ in self.izhikevich_cells:
            izhikevichCell_.export(outfile, level, namespace_, name_='izhikevichCell', pretty_print=pretty_print)
        for adExIaFCell_ in self.ad_ex_ia_f_cells:
            adExIaFCell_.export(outfile, level, namespace_, name_='adExIaFCell', pretty_print=pretty_print)
        for pulseGenerator_ in self.pulse_generators:
            pulseGenerator_.export(outfile, level, namespace_, name_='pulseGenerator', pretty_print=pretty_print)
        for sineGenerator_ in self.sine_generators:
            sineGenerator_.export(outfile, level, namespace_, name_='sineGenerator', pretty_print=pretty_print)
        for rampGenerator_ in self.ramp_generators:
            rampGenerator_.export(outfile, level, namespace_, name_='rampGenerator', pretty_print=pretty_print)
        for voltageClamp_ in self.voltage_clamps:
            voltageClamp_.export(outfile, level, namespace_, name_='voltageClamp', pretty_print=pretty_print)
        for spikeArray_ in self.spike_arrays:
            spikeArray_.export(outfile, level, namespace_, name_='spikeArray', pretty_print=pretty_print)
        for spikeGenerator_ in self.spike_generators:
            spikeGenerator_.export(outfile, level, namespace_, name_='spikeGenerator', pretty_print=pretty_print)
        for spikeGeneratorRandom_ in self.spike_generator_randoms:
            spikeGeneratorRandom_.export(outfile, level, namespace_, name_='spikeGeneratorRandom', pretty_print=pretty_print)
        for spikeGeneratorPoisson_ in self.spike_generator_poissons:
            spikeGeneratorPoisson_.export(outfile, level, namespace_, name_='spikeGeneratorPoisson', pretty_print=pretty_print)
        for IF_curr_alpha_ in self.IF_curr_alpha:
            IF_curr_alpha_.export(outfile, level, namespace_, name_='IF_curr_alpha', pretty_print=pretty_print)
        for IF_curr_exp_ in self.IF_curr_exp:
            IF_curr_exp_.export(outfile, level, namespace_, name_='IF_curr_exp', pretty_print=pretty_print)
        for IF_cond_alpha_ in self.IF_cond_alpha:
            IF_cond_alpha_.export(outfile, level, namespace_, name_='IF_cond_alpha', pretty_print=pretty_print)
        for IF_cond_exp_ in self.IF_cond_exp:
            IF_cond_exp_.export(outfile, level, namespace_, name_='IF_cond_exp', pretty_print=pretty_print)
        for EIF_cond_exp_isfa_ista_ in self.EIF_cond_exp_isfa_ista:
            EIF_cond_exp_isfa_ista_.export(outfile, level, namespace_, name_='EIF_cond_exp_isfa_ista', pretty_print=pretty_print)
        for EIF_cond_alpha_isfa_ista_ in self.EIF_cond_alpha_isfa_ista:
            EIF_cond_alpha_isfa_ista_.export(outfile, level, namespace_, name_='EIF_cond_alpha_isfa_ista', pretty_print=pretty_print)
        for HH_cond_exp_ in self.HH_cond_exp:
            HH_cond_exp_.export(outfile, level, namespace_, name_='HH_cond_exp', pretty_print=pretty_print)
        for expCondSynapse_ in self.exp_cond_synapses:
            expCondSynapse_.export(outfile, level, namespace_, name_='expCondSynapse', pretty_print=pretty_print)
        for alphaCondSynapse_ in self.alpha_cond_synapses:
            alphaCondSynapse_.export(outfile, level, namespace_, name_='alphaCondSynapse', pretty_print=pretty_print)
        for expCurrSynapse_ in self.exp_curr_synapses:
            expCurrSynapse_.export(outfile, level, namespace_, name_='expCurrSynapse', pretty_print=pretty_print)
        for alphaCurrSynapse_ in self.alpha_curr_synapses:
            alphaCurrSynapse_.export(outfile, level, namespace_, name_='alphaCurrSynapse', pretty_print=pretty_print)
        for SpikeSourcePoisson_ in self.SpikeSourcePoisson:
            SpikeSourcePoisson_.export(outfile, level, namespace_, name_='SpikeSourcePoisson', pretty_print=pretty_print)
        for network_ in self.networks:
            network_.export(outfile, level, namespace_, name_='network', pretty_print=pretty_print)
        for ComponentType_ in self.ComponentType:
            ComponentType_.export(outfile, level, namespace_, name_='ComponentType', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='NeuroMLDocument'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NeuroMLDocument, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NeuroMLDocument, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('includes=[\n')
        level += 1
        for include_ in self.includes:
            showIndent(outfile, level)
            outfile.write('model_.IncludeType(\n')
            include_.exportLiteral(outfile, level, name_='IncludeType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('extracellular_properties=[\n')
        level += 1
        for extracellularProperties_ in self.extracellular_properties:
            showIndent(outfile, level)
            outfile.write('model_.ExtracellularProperties(\n')
            extracellularProperties_.exportLiteral(outfile, level, name_='ExtracellularProperties')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('intracellular_properties=[\n')
        level += 1
        for intracellularProperties_ in self.intracellular_properties:
            showIndent(outfile, level)
            outfile.write('model_.IntracellularProperties(\n')
            intracellularProperties_.exportLiteral(outfile, level, name_='IntracellularProperties')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('morphology=[\n')
        level += 1
        for morphology_ in self.morphology:
            showIndent(outfile, level)
            outfile.write('model_.Morphology(\n')
            morphology_.exportLiteral(outfile, level, name_='Morphology')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('ion_channels=[\n')
        level += 1
        for ionChannel_ in self.ion_channels:
            showIndent(outfile, level)
            outfile.write('model_.IonChannel(\n')
            ionChannel_.exportLiteral(outfile, level, name_='IonChannel')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('decaying_pool_concentration_models=[\n')
        level += 1
        for decayingPoolConcentrationModel_ in self.decaying_pool_concentration_models:
            showIndent(outfile, level)
            outfile.write('model_.DecayingPoolConcentrationModel(\n')
            decayingPoolConcentrationModel_.exportLiteral(outfile, level, name_='DecayingPoolConcentrationModel')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('exp_one_synapses=[\n')
        level += 1
        for expOneSynapse_ in self.exp_one_synapses:
            showIndent(outfile, level)
            outfile.write('model_.ExpOneSynapse(\n')
            expOneSynapse_.exportLiteral(outfile, level, name_='ExpOneSynapse')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('exp_two_synapses=[\n')
        level += 1
        for expTwoSynapse_ in self.exp_two_synapses:
            showIndent(outfile, level)
            outfile.write('model_.ExpTwoSynapse(\n')
            expTwoSynapse_.exportLiteral(outfile, level, name_='ExpTwoSynapse')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('blocking_plastic_synapses=[\n')
        level += 1
        for blockingPlasticSynapse_ in self.blocking_plastic_synapses:
            showIndent(outfile, level)
            outfile.write('model_.BlockingPlasticSynapse(\n')
            blockingPlasticSynapse_.exportLiteral(outfile, level, name_='BlockingPlasticSynapse')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('biophysical_properties=[\n')
        level += 1
        for biophysicalProperties_ in self.biophysical_properties:
            showIndent(outfile, level)
            outfile.write('model_.BiophysicalProperties(\n')
            biophysicalProperties_.exportLiteral(outfile, level, name_='BiophysicalProperties')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('cells=[\n')
        level += 1
        for cell_ in self.cells:
            showIndent(outfile, level)
            outfile.write('model_.Cell(\n')
            cell_.exportLiteral(outfile, level, name_='Cell')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('base_cells=[\n')
        level += 1
        for baseCell_ in self.base_cells:
            showIndent(outfile, level)
            outfile.write('model_.BaseCell(\n')
            baseCell_.exportLiteral(outfile, level, name_='BaseCell')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('iaf_tau_cells=[\n')
        level += 1
        for iafTauCell_ in self.iaf_tau_cells:
            showIndent(outfile, level)
            outfile.write('model_.IaFTauCell(\n')
            iafTauCell_.exportLiteral(outfile, level, name_='IaFTauCell')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('iaf_tau_ref_cells=[\n')
        level += 1
        for iafTauRefCell_ in self.iaf_tau_ref_cells:
            showIndent(outfile, level)
            outfile.write('model_.IaFTauRefCell(\n')
            iafTauRefCell_.exportLiteral(outfile, level, name_='IaFTauRefCell')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('iaf_cells=[\n')
        level += 1
        for iafCell_ in self.iaf_cells:
            showIndent(outfile, level)
            outfile.write('model_.IaFCell(\n')
            iafCell_.exportLiteral(outfile, level, name_='IaFCell')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('iaf_ref_cells=[\n')
        level += 1
        for iafRefCell_ in self.iaf_ref_cells:
            showIndent(outfile, level)
            outfile.write('model_.IaFRefCell(\n')
            iafRefCell_.exportLiteral(outfile, level, name_='IaFRefCell')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('izhikevich_cells=[\n')
        level += 1
        for izhikevichCell_ in self.izhikevich_cells:
            showIndent(outfile, level)
            outfile.write('model_.IzhikevichCell(\n')
            izhikevichCell_.exportLiteral(outfile, level, name_='IzhikevichCell')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('ad_ex_ia_f_cells=[\n')
        level += 1
        for adExIaFCell_ in self.ad_ex_ia_f_cells:
            showIndent(outfile, level)
            outfile.write('model_.AdExIaFCell(\n')
            adExIaFCell_.exportLiteral(outfile, level, name_='AdExIaFCell')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('pulse_generators=[\n')
        level += 1
        for pulseGenerator_ in self.pulse_generators:
            showIndent(outfile, level)
            outfile.write('model_.PulseGenerator(\n')
            pulseGenerator_.exportLiteral(outfile, level, name_='PulseGenerator')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('sine_generators=[\n')
        level += 1
        for sineGenerator_ in self.sine_generators:
            showIndent(outfile, level)
            outfile.write('model_.SineGenerator(\n')
            sineGenerator_.exportLiteral(outfile, level, name_='SineGenerator')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('ramp_generators=[\n')
        level += 1
        for rampGenerator_ in self.ramp_generators:
            showIndent(outfile, level)
            outfile.write('model_.RampGenerator(\n')
            rampGenerator_.exportLiteral(outfile, level, name_='RampGenerator')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('voltage_clamps=[\n')
        level += 1
        for voltageClamp_ in self.voltage_clamps:
            showIndent(outfile, level)
            outfile.write('model_.VoltageClamp(\n')
            voltageClamp_.exportLiteral(outfile, level, name_='VoltageClamp')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('spike_arrays=[\n')
        level += 1
        for spikeArray_ in self.spike_arrays:
            showIndent(outfile, level)
            outfile.write('model_.SpikeArray(\n')
            spikeArray_.exportLiteral(outfile, level, name_='SpikeArray')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('spike_generators=[\n')
        level += 1
        for spikeGenerator_ in self.spike_generators:
            showIndent(outfile, level)
            outfile.write('model_.SpikeGenerator(\n')
            spikeGenerator_.exportLiteral(outfile, level, name_='SpikeGenerator')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('spike_generator_randoms=[\n')
        level += 1
        for spikeGeneratorRandom_ in self.spike_generator_randoms:
            showIndent(outfile, level)
            outfile.write('model_.SpikeGeneratorRandom(\n')
            spikeGeneratorRandom_.exportLiteral(outfile, level, name_='SpikeGeneratorRandom')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('spike_generator_poissons=[\n')
        level += 1
        for spikeGeneratorPoisson_ in self.spike_generator_poissons:
            showIndent(outfile, level)
            outfile.write('model_.SpikeGeneratorPoisson(\n')
            spikeGeneratorPoisson_.exportLiteral(outfile, level, name_='SpikeGeneratorPoisson')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('IF_curr_alpha=[\n')
        level += 1
        for IF_curr_alpha_ in self.IF_curr_alpha:
            showIndent(outfile, level)
            outfile.write('model_.IF_curr_alpha(\n')
            IF_curr_alpha_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('IF_curr_exp=[\n')
        level += 1
        for IF_curr_exp_ in self.IF_curr_exp:
            showIndent(outfile, level)
            outfile.write('model_.IF_curr_exp(\n')
            IF_curr_exp_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('IF_cond_alpha=[\n')
        level += 1
        for IF_cond_alpha_ in self.IF_cond_alpha:
            showIndent(outfile, level)
            outfile.write('model_.IF_cond_alpha(\n')
            IF_cond_alpha_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('IF_cond_exp=[\n')
        level += 1
        for IF_cond_exp_ in self.IF_cond_exp:
            showIndent(outfile, level)
            outfile.write('model_.IF_cond_exp(\n')
            IF_cond_exp_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('EIF_cond_exp_isfa_ista=[\n')
        level += 1
        for EIF_cond_exp_isfa_ista_ in self.EIF_cond_exp_isfa_ista:
            showIndent(outfile, level)
            outfile.write('model_.EIF_cond_exp_isfa_ista(\n')
            EIF_cond_exp_isfa_ista_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('EIF_cond_alpha_isfa_ista=[\n')
        level += 1
        for EIF_cond_alpha_isfa_ista_ in self.EIF_cond_alpha_isfa_ista:
            showIndent(outfile, level)
            outfile.write('model_.EIF_cond_alpha_isfa_ista(\n')
            EIF_cond_alpha_isfa_ista_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('HH_cond_exp=[\n')
        level += 1
        for HH_cond_exp_ in self.HH_cond_exp:
            showIndent(outfile, level)
            outfile.write('model_.HH_cond_exp(\n')
            HH_cond_exp_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('exp_cond_synapses=[\n')
        level += 1
        for expCondSynapse_ in self.exp_cond_synapses:
            showIndent(outfile, level)
            outfile.write('model_.ExpCondSynapse(\n')
            expCondSynapse_.exportLiteral(outfile, level, name_='ExpCondSynapse')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('alpha_cond_synapses=[\n')
        level += 1
        for alphaCondSynapse_ in self.alpha_cond_synapses:
            showIndent(outfile, level)
            outfile.write('model_.AlphaCondSynapse(\n')
            alphaCondSynapse_.exportLiteral(outfile, level, name_='AlphaCondSynapse')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('exp_curr_synapses=[\n')
        level += 1
        for expCurrSynapse_ in self.exp_curr_synapses:
            showIndent(outfile, level)
            outfile.write('model_.ExpCurrSynapse(\n')
            expCurrSynapse_.exportLiteral(outfile, level, name_='ExpCurrSynapse')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('alpha_curr_synapses=[\n')
        level += 1
        for alphaCurrSynapse_ in self.alpha_curr_synapses:
            showIndent(outfile, level)
            outfile.write('model_.AlphaCurrSynapse(\n')
            alphaCurrSynapse_.exportLiteral(outfile, level, name_='AlphaCurrSynapse')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('SpikeSourcePoisson=[\n')
        level += 1
        for SpikeSourcePoisson_ in self.SpikeSourcePoisson:
            showIndent(outfile, level)
            outfile.write('model_.SpikeSourcePoisson(\n')
            SpikeSourcePoisson_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('networks=[\n')
        level += 1
        for network_ in self.networks:
            showIndent(outfile, level)
            outfile.write('model_.Network(\n')
            network_.exportLiteral(outfile, level, name_='Network')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('ComponentType=[\n')
        level += 1
        for ComponentType_ in self.ComponentType:
            showIndent(outfile, level)
            outfile.write('model_.ComponentType(\n')
            ComponentType_.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(NeuroMLDocument, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'include':
            obj_ = IncludeType.factory()
            obj_.build(child_)
            self.includes.append(obj_)
        elif nodeName_ == 'extracellularProperties':
            obj_ = ExtracellularProperties.factory()
            obj_.build(child_)
            self.extracellular_properties.append(obj_)
        elif nodeName_ == 'intracellularProperties':
            obj_ = IntracellularProperties.factory()
            obj_.build(child_)
            self.intracellular_properties.append(obj_)
        elif nodeName_ == 'morphology':
            obj_ = Morphology.factory()
            obj_.build(child_)
            self.morphology.append(obj_)
        elif nodeName_ == 'ionChannel':
            obj_ = IonChannel.factory()
            obj_.build(child_)
            self.ion_channels.append(obj_)
        elif nodeName_ == 'decayingPoolConcentrationModel':
            class_obj_ = self.get_class_obj_(child_, DecayingPoolConcentrationModel)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.decaying_pool_concentration_models.append(obj_)
        elif nodeName_ == 'expOneSynapse':
            obj_ = ExpOneSynapse.factory()
            obj_.build(child_)
            self.exp_one_synapses.append(obj_)
        elif nodeName_ == 'expTwoSynapse':
            class_obj_ = self.get_class_obj_(child_, ExpTwoSynapse)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.exp_two_synapses.append(obj_)
        elif nodeName_ == 'blockingPlasticSynapse':
            obj_ = BlockingPlasticSynapse.factory()
            obj_.build(child_)
            self.blocking_plastic_synapses.append(obj_)
        elif nodeName_ == 'biophysicalProperties':
            obj_ = BiophysicalProperties.factory()
            obj_.build(child_)
            self.biophysical_properties.append(obj_)
        elif nodeName_ == 'cell':
            obj_ = Cell.factory()
            obj_.build(child_)
            self.cells.append(obj_)
        elif nodeName_ == 'baseCell':
            class_obj_ = self.get_class_obj_(child_, BaseCell)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.base_cells.append(obj_)
        elif nodeName_ == 'iafTauCell':
            class_obj_ = self.get_class_obj_(child_, IaFTauCell)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.iaf_tau_cells.append(obj_)
        elif nodeName_ == 'iafTauRefCell':
            obj_ = IaFTauRefCell.factory()
            obj_.build(child_)
            self.iaf_tau_ref_cells.append(obj_)
        elif nodeName_ == 'iafCell':
            class_obj_ = self.get_class_obj_(child_, IaFCell)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.iaf_cells.append(obj_)
        elif nodeName_ == 'iafRefCell':
            obj_ = IaFRefCell.factory()
            obj_.build(child_)
            self.iaf_ref_cells.append(obj_)
        elif nodeName_ == 'izhikevichCell':
            obj_ = IzhikevichCell.factory()
            obj_.build(child_)
            self.izhikevich_cells.append(obj_)
        elif nodeName_ == 'adExIaFCell':
            obj_ = AdExIaFCell.factory()
            obj_.build(child_)
            self.ad_ex_ia_f_cells.append(obj_)
        elif nodeName_ == 'pulseGenerator':
            obj_ = PulseGenerator.factory()
            obj_.build(child_)
            self.pulse_generators.append(obj_)
        elif nodeName_ == 'sineGenerator':
            obj_ = SineGenerator.factory()
            obj_.build(child_)
            self.sine_generators.append(obj_)
        elif nodeName_ == 'rampGenerator':
            obj_ = RampGenerator.factory()
            obj_.build(child_)
            self.ramp_generators.append(obj_)
        elif nodeName_ == 'voltageClamp':
            obj_ = VoltageClamp.factory()
            obj_.build(child_)
            self.voltage_clamps.append(obj_)
        elif nodeName_ == 'spikeArray':
            obj_ = SpikeArray.factory()
            obj_.build(child_)
            self.spike_arrays.append(obj_)
        elif nodeName_ == 'spikeGenerator':
            obj_ = SpikeGenerator.factory()
            obj_.build(child_)
            self.spike_generators.append(obj_)
        elif nodeName_ == 'spikeGeneratorRandom':
            obj_ = SpikeGeneratorRandom.factory()
            obj_.build(child_)
            self.spike_generator_randoms.append(obj_)
        elif nodeName_ == 'spikeGeneratorPoisson':
            obj_ = SpikeGeneratorPoisson.factory()
            obj_.build(child_)
            self.spike_generator_poissons.append(obj_)
        elif nodeName_ == 'IF_curr_alpha':
            obj_ = IF_curr_alpha.factory()
            obj_.build(child_)
            self.IF_curr_alpha.append(obj_)
        elif nodeName_ == 'IF_curr_exp':
            obj_ = IF_curr_exp.factory()
            obj_.build(child_)
            self.IF_curr_exp.append(obj_)
        elif nodeName_ == 'IF_cond_alpha':
            obj_ = IF_cond_alpha.factory()
            obj_.build(child_)
            self.IF_cond_alpha.append(obj_)
        elif nodeName_ == 'IF_cond_exp':
            obj_ = IF_cond_exp.factory()
            obj_.build(child_)
            self.IF_cond_exp.append(obj_)
        elif nodeName_ == 'EIF_cond_exp_isfa_ista':
            obj_ = EIF_cond_exp_isfa_ista.factory()
            obj_.build(child_)
            self.EIF_cond_exp_isfa_ista.append(obj_)
        elif nodeName_ == 'EIF_cond_alpha_isfa_ista':
            obj_ = EIF_cond_alpha_isfa_ista.factory()
            obj_.build(child_)
            self.EIF_cond_alpha_isfa_ista.append(obj_)
        elif nodeName_ == 'HH_cond_exp':
            obj_ = HH_cond_exp.factory()
            obj_.build(child_)
            self.HH_cond_exp.append(obj_)
        elif nodeName_ == 'expCondSynapse':
            obj_ = ExpCondSynapse.factory()
            obj_.build(child_)
            self.exp_cond_synapses.append(obj_)
        elif nodeName_ == 'alphaCondSynapse':
            obj_ = AlphaCondSynapse.factory()
            obj_.build(child_)
            self.alpha_cond_synapses.append(obj_)
        elif nodeName_ == 'expCurrSynapse':
            obj_ = ExpCurrSynapse.factory()
            obj_.build(child_)
            self.exp_curr_synapses.append(obj_)
        elif nodeName_ == 'alphaCurrSynapse':
            obj_ = AlphaCurrSynapse.factory()
            obj_.build(child_)
            self.alpha_curr_synapses.append(obj_)
        elif nodeName_ == 'SpikeSourcePoisson':
            obj_ = SpikeSourcePoisson.factory()
            obj_.build(child_)
            self.SpikeSourcePoisson.append(obj_)
        elif nodeName_ == 'network':
            obj_ = Network.factory()
            obj_.build(child_)
            self.networks.append(obj_)
        elif nodeName_ == 'ComponentType':
            obj_ = ComponentType.factory()
            obj_.build(child_)
            self.ComponentType.append(obj_)
        super(NeuroMLDocument, self).buildChildren(child_, node, nodeName_, True)
# end class NeuroMLDocument


class BasePynnSynapse(BaseSynapse):
    member_data_items_ = [
        MemberSpec_('tau_syn', 'xs:double', 0),
    ]
    subclass = None
    superclass = BaseSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn=None, extensiontype_=None):
        super(BasePynnSynapse, self).__init__(neuro_lex_id, id, metaid, notes, annotation, extensiontype_, )
        self.tau_syn = _cast(float, tau_syn)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BasePynnSynapse.subclass:
            return BasePynnSynapse.subclass(*args_, **kwargs_)
        else:
            return BasePynnSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(BasePynnSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BasePynnSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BasePynnSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BasePynnSynapse'):
        super(BasePynnSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BasePynnSynapse')
        if self.tau_syn is not None and 'tau_syn' not in already_processed:
            already_processed.add('tau_syn')
            outfile.write(' tau_syn="%s"' % self.gds_format_double(self.tau_syn, input_name='tau_syn'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BasePynnSynapse', fromsubclass_=False, pretty_print=True):
        super(BasePynnSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BasePynnSynapse'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tau_syn is not None and 'tau_syn' not in already_processed:
            already_processed.add('tau_syn')
            showIndent(outfile, level)
            outfile.write('tau_syn=%e,\n' % (self.tau_syn,))
        super(BasePynnSynapse, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BasePynnSynapse, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tau_syn', node)
        if value is not None and 'tau_syn' not in already_processed:
            already_processed.add('tau_syn')
            try:
                self.tau_syn = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (tau_syn): %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BasePynnSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BasePynnSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BasePynnSynapse


class basePyNNCell(BaseCell):
    member_data_items_ = [
        MemberSpec_('tau_syn_I', 'xs:double', 0),
        MemberSpec_('tau_syn_E', 'xs:double', 0),
        MemberSpec_('i_offset', 'xs:double', 0),
        MemberSpec_('cm', 'xs:double', 0),
        MemberSpec_('v_init', 'xs:double', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn_I=None, tau_syn_E=None, i_offset=None, cm=None, v_init=None, extensiontype_=None):
        super(basePyNNCell, self).__init__(neuro_lex_id, id, metaid, notes, annotation, extensiontype_, )
        self.tau_syn_I = _cast(float, tau_syn_I)
        self.tau_syn_E = _cast(float, tau_syn_E)
        self.i_offset = _cast(float, i_offset)
        self.cm = _cast(float, cm)
        self.v_init = _cast(float, v_init)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if basePyNNCell.subclass:
            return basePyNNCell.subclass(*args_, **kwargs_)
        else:
            return basePyNNCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(basePyNNCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='basePyNNCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='basePyNNCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='basePyNNCell'):
        super(basePyNNCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='basePyNNCell')
        if self.tau_syn_I is not None and 'tau_syn_I' not in already_processed:
            already_processed.add('tau_syn_I')
            outfile.write(' tau_syn_I="%s"' % self.gds_format_double(self.tau_syn_I, input_name='tau_syn_I'))
        if self.tau_syn_E is not None and 'tau_syn_E' not in already_processed:
            already_processed.add('tau_syn_E')
            outfile.write(' tau_syn_E="%s"' % self.gds_format_double(self.tau_syn_E, input_name='tau_syn_E'))
        if self.i_offset is not None and 'i_offset' not in already_processed:
            already_processed.add('i_offset')
            outfile.write(' i_offset="%s"' % self.gds_format_double(self.i_offset, input_name='i_offset'))
        if self.cm is not None and 'cm' not in already_processed:
            already_processed.add('cm')
            outfile.write(' cm="%s"' % self.gds_format_double(self.cm, input_name='cm'))
        if self.v_init is not None and 'v_init' not in already_processed:
            already_processed.add('v_init')
            outfile.write(' v_init="%s"' % self.gds_format_double(self.v_init, input_name='v_init'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='basePyNNCell', fromsubclass_=False, pretty_print=True):
        super(basePyNNCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='basePyNNCell'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tau_syn_I is not None and 'tau_syn_I' not in already_processed:
            already_processed.add('tau_syn_I')
            showIndent(outfile, level)
            outfile.write('tau_syn_I=%e,\n' % (self.tau_syn_I,))
        if self.tau_syn_E is not None and 'tau_syn_E' not in already_processed:
            already_processed.add('tau_syn_E')
            showIndent(outfile, level)
            outfile.write('tau_syn_E=%e,\n' % (self.tau_syn_E,))
        if self.i_offset is not None and 'i_offset' not in already_processed:
            already_processed.add('i_offset')
            showIndent(outfile, level)
            outfile.write('i_offset=%e,\n' % (self.i_offset,))
        if self.cm is not None and 'cm' not in already_processed:
            already_processed.add('cm')
            showIndent(outfile, level)
            outfile.write('cm=%e,\n' % (self.cm,))
        if self.v_init is not None and 'v_init' not in already_processed:
            already_processed.add('v_init')
            showIndent(outfile, level)
            outfile.write('v_init=%e,\n' % (self.v_init,))
        super(basePyNNCell, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(basePyNNCell, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tau_syn_I', node)
        if value is not None and 'tau_syn_I' not in already_processed:
            already_processed.add('tau_syn_I')
            try:
                self.tau_syn_I = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (tau_syn_I): %s' % exp)
        value = find_attr_value_('tau_syn_E', node)
        if value is not None and 'tau_syn_E' not in already_processed:
            already_processed.add('tau_syn_E')
            try:
                self.tau_syn_E = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (tau_syn_E): %s' % exp)
        value = find_attr_value_('i_offset', node)
        if value is not None and 'i_offset' not in already_processed:
            already_processed.add('i_offset')
            try:
                self.i_offset = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (i_offset): %s' % exp)
        value = find_attr_value_('cm', node)
        if value is not None and 'cm' not in already_processed:
            already_processed.add('cm')
            try:
                self.cm = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (cm): %s' % exp)
        value = find_attr_value_('v_init', node)
        if value is not None and 'v_init' not in already_processed:
            already_processed.add('v_init')
            try:
                self.v_init = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (v_init): %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(basePyNNCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(basePyNNCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class basePyNNCell


class ConcentrationModel_D(DecayingPoolConcentrationModel):
    member_data_items_ = [
        MemberSpec_('type', 'xs:string', 0),
    ]
    subclass = None
    superclass = DecayingPoolConcentrationModel
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, ion=None, shell_thickness=None, resting_conc=None, decay_constant=None, type=None):
        super(ConcentrationModel_D, self).__init__(neuro_lex_id, id, metaid, notes, annotation, ion, shell_thickness, resting_conc, decay_constant, )
        self.type = _cast(None, type)
        pass
    def factory(*args_, **kwargs_):
        if ConcentrationModel_D.subclass:
            return ConcentrationModel_D.subclass(*args_, **kwargs_)
        else:
            return ConcentrationModel_D(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ConcentrationModel_D, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ConcentrationModel_D', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConcentrationModel_D')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConcentrationModel_D'):
        super(ConcentrationModel_D, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ConcentrationModel_D')
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type).encode(ExternalEncoding), input_name='type'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ConcentrationModel_D', fromsubclass_=False, pretty_print=True):
        super(ConcentrationModel_D, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ConcentrationModel_D'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.type is not None and 'type' not in already_processed:
            already_processed.add('type')
            showIndent(outfile, level)
            outfile.write('type="%s",\n' % (self.type,))
        super(ConcentrationModel_D, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ConcentrationModel_D, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type = value
        super(ConcentrationModel_D, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ConcentrationModel_D, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ConcentrationModel_D


class Cell(BaseCell):
    """Should only be used if morphology element is outside the cell. This
    points to the id of the morphology Should only be used if
    biophysicalProperties element is outside the cell. This points
    to the id of the biophysicalProperties"""
    member_data_items_ = [
        MemberSpec_('biophysical_properties_attr', 'xs:string', 0),
        MemberSpec_('morphology_attr', 'xs:string', 0),
        MemberSpec_('morphology', 'Morphology', 0),
        MemberSpec_('biophysical_properties', 'BiophysicalProperties', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, biophysical_properties_attr=None, morphology_attr=None, morphology=None, biophysical_properties=None):
        super(Cell, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.biophysical_properties_attr = _cast(None, biophysical_properties_attr)
        self.morphology_attr = _cast(None, morphology_attr)
        self.morphology = morphology
        self.biophysical_properties = biophysical_properties
    def factory(*args_, **kwargs_):
        if Cell.subclass:
            return Cell.subclass(*args_, **kwargs_)
        else:
            return Cell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.morphology is not None or
            self.biophysical_properties is not None or
            super(Cell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='Cell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Cell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Cell'):
        super(Cell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Cell')
        if self.biophysical_properties_attr is not None and 'biophysical_properties_attr' not in already_processed:
            already_processed.add('biophysical_properties_attr')
            outfile.write(' biophysicalProperties=%s' % (self.gds_format_string(quote_attrib(self.biophysical_properties_attr).encode(ExternalEncoding), input_name='biophysical_properties_attr'), ))
        if self.morphology_attr is not None and 'morphology_attr' not in already_processed:
            already_processed.add('morphology_attr')
            outfile.write(' morphology=%s' % (self.gds_format_string(quote_attrib(self.morphology_attr).encode(ExternalEncoding), input_name='morphology_attr'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Cell', fromsubclass_=False, pretty_print=True):
        super(Cell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.morphology is not None:
            self.morphology.export(outfile, level, namespace_, name_='morphology', pretty_print=pretty_print)
        if self.biophysical_properties is not None:
            self.biophysical_properties.export(outfile, level, namespace_, name_='biophysicalProperties', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='Cell'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.biophysical_properties_attr is not None and 'biophysical_properties_attr' not in already_processed:
            already_processed.add('biophysical_properties_attr')
            showIndent(outfile, level)
            outfile.write('biophysical_properties_attr="%s",\n' % (self.biophysical_properties_attr,))
        if self.morphology_attr is not None and 'morphology_attr' not in already_processed:
            already_processed.add('morphology_attr')
            showIndent(outfile, level)
            outfile.write('morphology_attr="%s",\n' % (self.morphology_attr,))
        super(Cell, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Cell, self).exportLiteralChildren(outfile, level, name_)
        if self.morphology is not None:
            showIndent(outfile, level)
            outfile.write('morphology=model_.Morphology(\n')
            self.morphology.exportLiteral(outfile, level, name_='morphology')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.biophysical_properties is not None:
            showIndent(outfile, level)
            outfile.write('biophysical_properties=model_.BiophysicalProperties(\n')
            self.biophysical_properties.exportLiteral(outfile, level, name_='biophysicalProperties')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('biophysicalProperties', node)
        if value is not None and 'biophysical_properties_attr' not in already_processed:
            already_processed.add('biophysical_properties_attr')
            self.biophysical_properties_attr = value
        value = find_attr_value_('morphology', node)
        if value is not None and 'morphology_attr' not in already_processed:
            already_processed.add('morphology_attr')
            self.morphology_attr = value
        super(Cell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'morphology':
            obj_ = Morphology.factory()
            obj_.build(child_)
            self.morphology = obj_
        elif nodeName_ == 'biophysicalProperties':
            obj_ = BiophysicalProperties.factory()
            obj_.build(child_)
            self.biophysical_properties = obj_
        super(Cell, self).buildChildren(child_, node, nodeName_, True)
# end class Cell


class AdExIaFCell(BaseCell):
    member_data_items_ = [
        MemberSpec_('reset', 'Nml2Quantity_voltage', 0),
        MemberSpec_('EL', 'Nml2Quantity_voltage', 0),
        MemberSpec_('C', 'Nml2Quantity_capacitance', 0),
        MemberSpec_('b', 'Nml2Quantity_current', 0),
        MemberSpec_('refract', 'Nml2Quantity_time', 0),
        MemberSpec_('VT', 'Nml2Quantity_voltage', 0),
        MemberSpec_('delT', 'Nml2Quantity_voltage', 0),
        MemberSpec_('a', 'Nml2Quantity_conductance', 0),
        MemberSpec_('thresh', 'Nml2Quantity_voltage', 0),
        MemberSpec_('gL', 'Nml2Quantity_conductance', 0),
        MemberSpec_('tauw', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, reset=None, EL=None, C=None, b=None, refract=None, VT=None, del_t=None, a=None, thresh=None, g_l=None, tauw=None):
        super(AdExIaFCell, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.reset = _cast(None, reset)
        self.EL = _cast(None, EL)
        self.C = _cast(None, C)
        self.b = _cast(None, b)
        self.refract = _cast(None, refract)
        self.VT = _cast(None, VT)
        self.del_t = _cast(None, del_t)
        self.a = _cast(None, a)
        self.thresh = _cast(None, thresh)
        self.g_l = _cast(None, g_l)
        self.tauw = _cast(None, tauw)
        pass
    def factory(*args_, **kwargs_):
        if AdExIaFCell.subclass:
            return AdExIaFCell.subclass(*args_, **kwargs_)
        else:
            return AdExIaFCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_capacitance(self, value):
        # Validate type Nml2Quantity_capacitance, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(AdExIaFCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AdExIaFCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AdExIaFCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AdExIaFCell'):
        super(AdExIaFCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AdExIaFCell')
        if self.reset is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            outfile.write(' reset=%s' % (quote_attrib(self.reset), ))
        if self.EL is not None and 'EL' not in already_processed:
            already_processed.add('EL')
            outfile.write(' EL=%s' % (quote_attrib(self.EL), ))
        if self.C is not None and 'C' not in already_processed:
            already_processed.add('C')
            outfile.write(' C=%s' % (quote_attrib(self.C), ))
        if self.b is not None and 'b' not in already_processed:
            already_processed.add('b')
            outfile.write(' b=%s' % (quote_attrib(self.b), ))
        if self.refract is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            outfile.write(' refract=%s' % (quote_attrib(self.refract), ))
        if self.VT is not None and 'VT' not in already_processed:
            already_processed.add('VT')
            outfile.write(' VT=%s' % (quote_attrib(self.VT), ))
        if self.del_t is not None and 'del_t' not in already_processed:
            already_processed.add('del_t')
            outfile.write(' delT=%s' % (quote_attrib(self.del_t), ))
        if self.a is not None and 'a' not in already_processed:
            already_processed.add('a')
            outfile.write(' a=%s' % (quote_attrib(self.a), ))
        if self.thresh is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            outfile.write(' thresh=%s' % (quote_attrib(self.thresh), ))
        if self.g_l is not None and 'g_l' not in already_processed:
            already_processed.add('g_l')
            outfile.write(' gL=%s' % (quote_attrib(self.g_l), ))
        if self.tauw is not None and 'tauw' not in already_processed:
            already_processed.add('tauw')
            outfile.write(' tauw=%s' % (quote_attrib(self.tauw), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AdExIaFCell', fromsubclass_=False, pretty_print=True):
        super(AdExIaFCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AdExIaFCell'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.reset is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            showIndent(outfile, level)
            outfile.write('reset="%s",\n' % (self.reset,))
        if self.EL is not None and 'EL' not in already_processed:
            already_processed.add('EL')
            showIndent(outfile, level)
            outfile.write('EL="%s",\n' % (self.EL,))
        if self.C is not None and 'C' not in already_processed:
            already_processed.add('C')
            showIndent(outfile, level)
            outfile.write('C="%s",\n' % (self.C,))
        if self.b is not None and 'b' not in already_processed:
            already_processed.add('b')
            showIndent(outfile, level)
            outfile.write('b="%s",\n' % (self.b,))
        if self.refract is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            showIndent(outfile, level)
            outfile.write('refract="%s",\n' % (self.refract,))
        if self.VT is not None and 'VT' not in already_processed:
            already_processed.add('VT')
            showIndent(outfile, level)
            outfile.write('VT="%s",\n' % (self.VT,))
        if self.del_t is not None and 'del_t' not in already_processed:
            already_processed.add('del_t')
            showIndent(outfile, level)
            outfile.write('del_t="%s",\n' % (self.del_t,))
        if self.a is not None and 'a' not in already_processed:
            already_processed.add('a')
            showIndent(outfile, level)
            outfile.write('a="%s",\n' % (self.a,))
        if self.thresh is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            showIndent(outfile, level)
            outfile.write('thresh="%s",\n' % (self.thresh,))
        if self.g_l is not None and 'g_l' not in already_processed:
            already_processed.add('g_l')
            showIndent(outfile, level)
            outfile.write('g_l="%s",\n' % (self.g_l,))
        if self.tauw is not None and 'tauw' not in already_processed:
            already_processed.add('tauw')
            showIndent(outfile, level)
            outfile.write('tauw="%s",\n' % (self.tauw,))
        super(AdExIaFCell, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AdExIaFCell, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('reset', node)
        if value is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            self.reset = value
            self.validate_Nml2Quantity_voltage(self.reset)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('EL', node)
        if value is not None and 'EL' not in already_processed:
            already_processed.add('EL')
            self.EL = value
            self.validate_Nml2Quantity_voltage(self.EL)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('C', node)
        if value is not None and 'C' not in already_processed:
            already_processed.add('C')
            self.C = value
            self.validate_Nml2Quantity_capacitance(self.C)    # validate type Nml2Quantity_capacitance
        value = find_attr_value_('b', node)
        if value is not None and 'b' not in already_processed:
            already_processed.add('b')
            self.b = value
            self.validate_Nml2Quantity_current(self.b)    # validate type Nml2Quantity_current
        value = find_attr_value_('refract', node)
        if value is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            self.refract = value
            self.validate_Nml2Quantity_time(self.refract)    # validate type Nml2Quantity_time
        value = find_attr_value_('VT', node)
        if value is not None and 'VT' not in already_processed:
            already_processed.add('VT')
            self.VT = value
            self.validate_Nml2Quantity_voltage(self.VT)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('delT', node)
        if value is not None and 'delT' not in already_processed:
            already_processed.add('delT')
            self.del_t = value
            self.validate_Nml2Quantity_voltage(self.del_t)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('a', node)
        if value is not None and 'a' not in already_processed:
            already_processed.add('a')
            self.a = value
            self.validate_Nml2Quantity_conductance(self.a)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('thresh', node)
        if value is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            self.thresh = value
            self.validate_Nml2Quantity_voltage(self.thresh)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('gL', node)
        if value is not None and 'gL' not in already_processed:
            already_processed.add('gL')
            self.g_l = value
            self.validate_Nml2Quantity_conductance(self.g_l)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('tauw', node)
        if value is not None and 'tauw' not in already_processed:
            already_processed.add('tauw')
            self.tauw = value
            self.validate_Nml2Quantity_time(self.tauw)    # validate type Nml2Quantity_time
        super(AdExIaFCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AdExIaFCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AdExIaFCell


class IzhikevichCell(BaseCell):
    member_data_items_ = [
        MemberSpec_('a', 'Nml2Quantity_none', 0),
        MemberSpec_('c', 'Nml2Quantity_none', 0),
        MemberSpec_('b', 'Nml2Quantity_none', 0),
        MemberSpec_('d', 'Nml2Quantity_none', 0),
        MemberSpec_('v0', 'Nml2Quantity_voltage', 0),
        MemberSpec_('thresh', 'Nml2Quantity_voltage', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, a=None, c=None, b=None, d=None, v0=None, thresh=None):
        super(IzhikevichCell, self).__init__(neuro_lex_id, id, metaid, notes, annotation, )
        self.a = _cast(None, a)
        self.c = _cast(None, c)
        self.b = _cast(None, b)
        self.d = _cast(None, d)
        self.v0 = _cast(None, v0)
        self.thresh = _cast(None, thresh)
        pass
    def factory(*args_, **kwargs_):
        if IzhikevichCell.subclass:
            return IzhikevichCell.subclass(*args_, **kwargs_)
        else:
            return IzhikevichCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(IzhikevichCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IzhikevichCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IzhikevichCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IzhikevichCell'):
        super(IzhikevichCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IzhikevichCell')
        if self.a is not None and 'a' not in already_processed:
            already_processed.add('a')
            outfile.write(' a=%s' % (quote_attrib(self.a), ))
        if self.c is not None and 'c' not in already_processed:
            already_processed.add('c')
            outfile.write(' c=%s' % (quote_attrib(self.c), ))
        if self.b is not None and 'b' not in already_processed:
            already_processed.add('b')
            outfile.write(' b=%s' % (quote_attrib(self.b), ))
        if self.d is not None and 'd' not in already_processed:
            already_processed.add('d')
            outfile.write(' d=%s' % (quote_attrib(self.d), ))
        if self.v0 is not None and 'v0' not in already_processed:
            already_processed.add('v0')
            outfile.write(' v0=%s' % (quote_attrib(self.v0), ))
        if self.thresh is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            outfile.write(' thresh=%s' % (quote_attrib(self.thresh), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IzhikevichCell', fromsubclass_=False, pretty_print=True):
        super(IzhikevichCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IzhikevichCell'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.a is not None and 'a' not in already_processed:
            already_processed.add('a')
            showIndent(outfile, level)
            outfile.write('a="%s",\n' % (self.a,))
        if self.c is not None and 'c' not in already_processed:
            already_processed.add('c')
            showIndent(outfile, level)
            outfile.write('c="%s",\n' % (self.c,))
        if self.b is not None and 'b' not in already_processed:
            already_processed.add('b')
            showIndent(outfile, level)
            outfile.write('b="%s",\n' % (self.b,))
        if self.d is not None and 'd' not in already_processed:
            already_processed.add('d')
            showIndent(outfile, level)
            outfile.write('d="%s",\n' % (self.d,))
        if self.v0 is not None and 'v0' not in already_processed:
            already_processed.add('v0')
            showIndent(outfile, level)
            outfile.write('v0="%s",\n' % (self.v0,))
        if self.thresh is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            showIndent(outfile, level)
            outfile.write('thresh="%s",\n' % (self.thresh,))
        super(IzhikevichCell, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IzhikevichCell, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('a', node)
        if value is not None and 'a' not in already_processed:
            already_processed.add('a')
            self.a = value
            self.validate_Nml2Quantity_none(self.a)    # validate type Nml2Quantity_none
        value = find_attr_value_('c', node)
        if value is not None and 'c' not in already_processed:
            already_processed.add('c')
            self.c = value
            self.validate_Nml2Quantity_none(self.c)    # validate type Nml2Quantity_none
        value = find_attr_value_('b', node)
        if value is not None and 'b' not in already_processed:
            already_processed.add('b')
            self.b = value
            self.validate_Nml2Quantity_none(self.b)    # validate type Nml2Quantity_none
        value = find_attr_value_('d', node)
        if value is not None and 'd' not in already_processed:
            already_processed.add('d')
            self.d = value
            self.validate_Nml2Quantity_none(self.d)    # validate type Nml2Quantity_none
        value = find_attr_value_('v0', node)
        if value is not None and 'v0' not in already_processed:
            already_processed.add('v0')
            self.v0 = value
            self.validate_Nml2Quantity_voltage(self.v0)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('thresh', node)
        if value is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            self.thresh = value
            self.validate_Nml2Quantity_voltage(self.thresh)    # validate type Nml2Quantity_voltage
        super(IzhikevichCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IzhikevichCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IzhikevichCell


class IaFCell(BaseCell):
    member_data_items_ = [
        MemberSpec_('reset', 'Nml2Quantity_voltage', 0),
        MemberSpec_('C', 'Nml2Quantity_capacitance', 0),
        MemberSpec_('thresh', 'Nml2Quantity_voltage', 0),
        MemberSpec_('leakConductance', 'Nml2Quantity_conductance', 0),
        MemberSpec_('leakReversal', 'Nml2Quantity_voltage', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, reset=None, C=None, thresh=None, leak_conductance=None, leak_reversal=None, extensiontype_=None):
        super(IaFCell, self).__init__(neuro_lex_id, id, metaid, notes, annotation, extensiontype_, )
        self.reset = _cast(None, reset)
        self.C = _cast(None, C)
        self.thresh = _cast(None, thresh)
        self.leak_conductance = _cast(None, leak_conductance)
        self.leak_reversal = _cast(None, leak_reversal)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if IaFCell.subclass:
            return IaFCell.subclass(*args_, **kwargs_)
        else:
            return IaFCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_capacitance(self, value):
        # Validate type Nml2Quantity_capacitance, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(IaFCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IaFCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IaFCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IaFCell'):
        super(IaFCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IaFCell')
        if self.reset is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            outfile.write(' reset=%s' % (quote_attrib(self.reset), ))
        if self.C is not None and 'C' not in already_processed:
            already_processed.add('C')
            outfile.write(' C=%s' % (quote_attrib(self.C), ))
        if self.thresh is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            outfile.write(' thresh=%s' % (quote_attrib(self.thresh), ))
        if self.leak_conductance is not None and 'leak_conductance' not in already_processed:
            already_processed.add('leak_conductance')
            outfile.write(' leakConductance=%s' % (quote_attrib(self.leak_conductance), ))
        if self.leak_reversal is not None and 'leak_reversal' not in already_processed:
            already_processed.add('leak_reversal')
            outfile.write(' leakReversal=%s' % (quote_attrib(self.leak_reversal), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='IaFCell', fromsubclass_=False, pretty_print=True):
        super(IaFCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IaFCell'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.reset is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            showIndent(outfile, level)
            outfile.write('reset="%s",\n' % (self.reset,))
        if self.C is not None and 'C' not in already_processed:
            already_processed.add('C')
            showIndent(outfile, level)
            outfile.write('C="%s",\n' % (self.C,))
        if self.thresh is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            showIndent(outfile, level)
            outfile.write('thresh="%s",\n' % (self.thresh,))
        if self.leak_conductance is not None and 'leak_conductance' not in already_processed:
            already_processed.add('leak_conductance')
            showIndent(outfile, level)
            outfile.write('leak_conductance="%s",\n' % (self.leak_conductance,))
        if self.leak_reversal is not None and 'leak_reversal' not in already_processed:
            already_processed.add('leak_reversal')
            showIndent(outfile, level)
            outfile.write('leak_reversal="%s",\n' % (self.leak_reversal,))
        super(IaFCell, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IaFCell, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('reset', node)
        if value is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            self.reset = value
            self.validate_Nml2Quantity_voltage(self.reset)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('C', node)
        if value is not None and 'C' not in already_processed:
            already_processed.add('C')
            self.C = value
            self.validate_Nml2Quantity_capacitance(self.C)    # validate type Nml2Quantity_capacitance
        value = find_attr_value_('thresh', node)
        if value is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            self.thresh = value
            self.validate_Nml2Quantity_voltage(self.thresh)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('leakConductance', node)
        if value is not None and 'leakConductance' not in already_processed:
            already_processed.add('leakConductance')
            self.leak_conductance = value
            self.validate_Nml2Quantity_conductance(self.leak_conductance)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('leakReversal', node)
        if value is not None and 'leakReversal' not in already_processed:
            already_processed.add('leakReversal')
            self.leak_reversal = value
            self.validate_Nml2Quantity_voltage(self.leak_reversal)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(IaFCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IaFCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IaFCell


class IaFTauCell(BaseCell):
    member_data_items_ = [
        MemberSpec_('reset', 'Nml2Quantity_voltage', 0),
        MemberSpec_('tau', 'Nml2Quantity_time', 0),
        MemberSpec_('thresh', 'Nml2Quantity_voltage', 0),
        MemberSpec_('leakReversal', 'Nml2Quantity_voltage', 0),
    ]
    subclass = None
    superclass = BaseCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, reset=None, tau=None, thresh=None, leak_reversal=None, extensiontype_=None):
        super(IaFTauCell, self).__init__(neuro_lex_id, id, metaid, notes, annotation, extensiontype_, )
        self.reset = _cast(None, reset)
        self.tau = _cast(None, tau)
        self.thresh = _cast(None, thresh)
        self.leak_reversal = _cast(None, leak_reversal)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if IaFTauCell.subclass:
            return IaFTauCell.subclass(*args_, **kwargs_)
        else:
            return IaFTauCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(IaFTauCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IaFTauCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IaFTauCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IaFTauCell'):
        super(IaFTauCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IaFTauCell')
        if self.reset is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            outfile.write(' reset=%s' % (quote_attrib(self.reset), ))
        if self.tau is not None and 'tau' not in already_processed:
            already_processed.add('tau')
            outfile.write(' tau=%s' % (quote_attrib(self.tau), ))
        if self.thresh is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            outfile.write(' thresh=%s' % (quote_attrib(self.thresh), ))
        if self.leak_reversal is not None and 'leak_reversal' not in already_processed:
            already_processed.add('leak_reversal')
            outfile.write(' leakReversal=%s' % (quote_attrib(self.leak_reversal), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='IaFTauCell', fromsubclass_=False, pretty_print=True):
        super(IaFTauCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IaFTauCell'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.reset is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            showIndent(outfile, level)
            outfile.write('reset="%s",\n' % (self.reset,))
        if self.tau is not None and 'tau' not in already_processed:
            already_processed.add('tau')
            showIndent(outfile, level)
            outfile.write('tau="%s",\n' % (self.tau,))
        if self.thresh is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            showIndent(outfile, level)
            outfile.write('thresh="%s",\n' % (self.thresh,))
        if self.leak_reversal is not None and 'leak_reversal' not in already_processed:
            already_processed.add('leak_reversal')
            showIndent(outfile, level)
            outfile.write('leak_reversal="%s",\n' % (self.leak_reversal,))
        super(IaFTauCell, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IaFTauCell, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('reset', node)
        if value is not None and 'reset' not in already_processed:
            already_processed.add('reset')
            self.reset = value
            self.validate_Nml2Quantity_voltage(self.reset)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('tau', node)
        if value is not None and 'tau' not in already_processed:
            already_processed.add('tau')
            self.tau = value
            self.validate_Nml2Quantity_time(self.tau)    # validate type Nml2Quantity_time
        value = find_attr_value_('thresh', node)
        if value is not None and 'thresh' not in already_processed:
            already_processed.add('thresh')
            self.thresh = value
            self.validate_Nml2Quantity_voltage(self.thresh)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('leakReversal', node)
        if value is not None and 'leakReversal' not in already_processed:
            already_processed.add('leakReversal')
            self.leak_reversal = value
            self.validate_Nml2Quantity_voltage(self.leak_reversal)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(IaFTauCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IaFTauCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IaFTauCell


class BaseConductanceBasedSynapse(BaseSynapse):
    member_data_items_ = [
        MemberSpec_('erev', 'Nml2Quantity_voltage', 0),
        MemberSpec_('gbase', 'Nml2Quantity_conductance', 0),
    ]
    subclass = None
    superclass = BaseSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, erev=None, gbase=None, extensiontype_=None):
        super(BaseConductanceBasedSynapse, self).__init__(neuro_lex_id, id, metaid, notes, annotation, extensiontype_, )
        self.erev = _cast(None, erev)
        self.gbase = _cast(None, gbase)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if BaseConductanceBasedSynapse.subclass:
            return BaseConductanceBasedSynapse.subclass(*args_, **kwargs_)
        else:
            return BaseConductanceBasedSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        pass
    def validate_Nml2Quantity_conductance(self, value):
        # Validate type Nml2Quantity_conductance, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(BaseConductanceBasedSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BaseConductanceBasedSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BaseConductanceBasedSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BaseConductanceBasedSynapse'):
        super(BaseConductanceBasedSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BaseConductanceBasedSynapse')
        if self.erev is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            outfile.write(' erev=%s' % (quote_attrib(self.erev), ))
        if self.gbase is not None and 'gbase' not in already_processed:
            already_processed.add('gbase')
            outfile.write(' gbase=%s' % (quote_attrib(self.gbase), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='BaseConductanceBasedSynapse', fromsubclass_=False, pretty_print=True):
        super(BaseConductanceBasedSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BaseConductanceBasedSynapse'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.erev is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            showIndent(outfile, level)
            outfile.write('erev="%s",\n' % (self.erev,))
        if self.gbase is not None and 'gbase' not in already_processed:
            already_processed.add('gbase')
            showIndent(outfile, level)
            outfile.write('gbase="%s",\n' % (self.gbase,))
        super(BaseConductanceBasedSynapse, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BaseConductanceBasedSynapse, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('erev', node)
        if value is not None and 'erev' not in already_processed:
            already_processed.add('erev')
            self.erev = value
            self.validate_Nml2Quantity_voltage(self.erev)    # validate type Nml2Quantity_voltage
        value = find_attr_value_('gbase', node)
        if value is not None and 'gbase' not in already_processed:
            already_processed.add('gbase')
            self.gbase = value
            self.validate_Nml2Quantity_conductance(self.gbase)    # validate type Nml2Quantity_conductance
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(BaseConductanceBasedSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(BaseConductanceBasedSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class BaseConductanceBasedSynapse


class AlphaCurrSynapse(BasePynnSynapse):
    member_data_items_ = [
    ]
    subclass = None
    superclass = BasePynnSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn=None):
        super(AlphaCurrSynapse, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn, )
        pass
    def factory(*args_, **kwargs_):
        if AlphaCurrSynapse.subclass:
            return AlphaCurrSynapse.subclass(*args_, **kwargs_)
        else:
            return AlphaCurrSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(AlphaCurrSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AlphaCurrSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AlphaCurrSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AlphaCurrSynapse'):
        super(AlphaCurrSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AlphaCurrSynapse')
    def exportChildren(self, outfile, level, namespace_='', name_='AlphaCurrSynapse', fromsubclass_=False, pretty_print=True):
        super(AlphaCurrSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AlphaCurrSynapse'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AlphaCurrSynapse, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AlphaCurrSynapse, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AlphaCurrSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AlphaCurrSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AlphaCurrSynapse


class ExpCurrSynapse(BasePynnSynapse):
    member_data_items_ = [
    ]
    subclass = None
    superclass = BasePynnSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn=None):
        super(ExpCurrSynapse, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn, )
        pass
    def factory(*args_, **kwargs_):
        if ExpCurrSynapse.subclass:
            return ExpCurrSynapse.subclass(*args_, **kwargs_)
        else:
            return ExpCurrSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ExpCurrSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ExpCurrSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExpCurrSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ExpCurrSynapse'):
        super(ExpCurrSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ExpCurrSynapse')
    def exportChildren(self, outfile, level, namespace_='', name_='ExpCurrSynapse', fromsubclass_=False, pretty_print=True):
        super(ExpCurrSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ExpCurrSynapse'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ExpCurrSynapse, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ExpCurrSynapse, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ExpCurrSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ExpCurrSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ExpCurrSynapse


class AlphaCondSynapse(BasePynnSynapse):
    member_data_items_ = [
        MemberSpec_('e_rev', 'xs:double', 0),
    ]
    subclass = None
    superclass = BasePynnSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn=None, e_rev=None):
        super(AlphaCondSynapse, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn, )
        self.e_rev = _cast(float, e_rev)
        pass
    def factory(*args_, **kwargs_):
        if AlphaCondSynapse.subclass:
            return AlphaCondSynapse.subclass(*args_, **kwargs_)
        else:
            return AlphaCondSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(AlphaCondSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='AlphaCondSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AlphaCondSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AlphaCondSynapse'):
        super(AlphaCondSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AlphaCondSynapse')
        if self.e_rev is not None and 'e_rev' not in already_processed:
            already_processed.add('e_rev')
            outfile.write(' e_rev="%s"' % self.gds_format_double(self.e_rev, input_name='e_rev'))
    def exportChildren(self, outfile, level, namespace_='', name_='AlphaCondSynapse', fromsubclass_=False, pretty_print=True):
        super(AlphaCondSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AlphaCondSynapse'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.e_rev is not None and 'e_rev' not in already_processed:
            already_processed.add('e_rev')
            showIndent(outfile, level)
            outfile.write('e_rev=%e,\n' % (self.e_rev,))
        super(AlphaCondSynapse, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AlphaCondSynapse, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('e_rev', node)
        if value is not None and 'e_rev' not in already_processed:
            already_processed.add('e_rev')
            try:
                self.e_rev = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (e_rev): %s' % exp)
        super(AlphaCondSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AlphaCondSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AlphaCondSynapse


class ExpCondSynapse(BasePynnSynapse):
    member_data_items_ = [
        MemberSpec_('e_rev', 'xs:double', 0),
    ]
    subclass = None
    superclass = BasePynnSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn=None, e_rev=None):
        super(ExpCondSynapse, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn, )
        self.e_rev = _cast(float, e_rev)
        pass
    def factory(*args_, **kwargs_):
        if ExpCondSynapse.subclass:
            return ExpCondSynapse.subclass(*args_, **kwargs_)
        else:
            return ExpCondSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(ExpCondSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ExpCondSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExpCondSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ExpCondSynapse'):
        super(ExpCondSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ExpCondSynapse')
        if self.e_rev is not None and 'e_rev' not in already_processed:
            already_processed.add('e_rev')
            outfile.write(' e_rev="%s"' % self.gds_format_double(self.e_rev, input_name='e_rev'))
    def exportChildren(self, outfile, level, namespace_='', name_='ExpCondSynapse', fromsubclass_=False, pretty_print=True):
        super(ExpCondSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ExpCondSynapse'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.e_rev is not None and 'e_rev' not in already_processed:
            already_processed.add('e_rev')
            showIndent(outfile, level)
            outfile.write('e_rev=%e,\n' % (self.e_rev,))
        super(ExpCondSynapse, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ExpCondSynapse, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('e_rev', node)
        if value is not None and 'e_rev' not in already_processed:
            already_processed.add('e_rev')
            try:
                self.e_rev = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (e_rev): %s' % exp)
        super(ExpCondSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ExpCondSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ExpCondSynapse


class HH_cond_exp(basePyNNCell):
    member_data_items_ = [
        MemberSpec_('gbar_K', 'xs:double', 0),
        MemberSpec_('e_rev_E', 'xs:double', 0),
        MemberSpec_('g_leak', 'xs:double', 0),
        MemberSpec_('e_rev_Na', 'xs:double', 0),
        MemberSpec_('e_rev_I', 'xs:double', 0),
        MemberSpec_('e_rev_K', 'xs:double', 0),
        MemberSpec_('e_rev_leak', 'xs:double', 0),
        MemberSpec_('v_offset', 'xs:double', 0),
        MemberSpec_('gbar_Na', 'xs:double', 0),
    ]
    subclass = None
    superclass = basePyNNCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn_I=None, tau_syn_E=None, i_offset=None, cm=None, v_init=None, gbar_K=None, e_rev_E=None, g_leak=None, e_rev_Na=None, e_rev_I=None, e_rev_K=None, e_rev_leak=None, v_offset=None, gbar_Na=None):
        super(HH_cond_exp, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn_I, tau_syn_E, i_offset, cm, v_init, )
        self.gbar_K = _cast(float, gbar_K)
        self.e_rev_E = _cast(float, e_rev_E)
        self.g_leak = _cast(float, g_leak)
        self.e_rev_Na = _cast(float, e_rev_Na)
        self.e_rev_I = _cast(float, e_rev_I)
        self.e_rev_K = _cast(float, e_rev_K)
        self.e_rev_leak = _cast(float, e_rev_leak)
        self.v_offset = _cast(float, v_offset)
        self.gbar_Na = _cast(float, gbar_Na)
        pass
    def factory(*args_, **kwargs_):
        if HH_cond_exp.subclass:
            return HH_cond_exp.subclass(*args_, **kwargs_)
        else:
            return HH_cond_exp(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(HH_cond_exp, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='HH_cond_exp', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HH_cond_exp')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='HH_cond_exp'):
        super(HH_cond_exp, self).exportAttributes(outfile, level, already_processed, namespace_, name_='HH_cond_exp')
        if self.gbar_K is not None and 'gbar_K' not in already_processed:
            already_processed.add('gbar_K')
            outfile.write(' gbar_K="%s"' % self.gds_format_double(self.gbar_K, input_name='gbar_K'))
        if self.e_rev_E is not None and 'e_rev_E' not in already_processed:
            already_processed.add('e_rev_E')
            outfile.write(' e_rev_E="%s"' % self.gds_format_double(self.e_rev_E, input_name='e_rev_E'))
        if self.g_leak is not None and 'g_leak' not in already_processed:
            already_processed.add('g_leak')
            outfile.write(' g_leak="%s"' % self.gds_format_double(self.g_leak, input_name='g_leak'))
        if self.e_rev_Na is not None and 'e_rev_Na' not in already_processed:
            already_processed.add('e_rev_Na')
            outfile.write(' e_rev_Na="%s"' % self.gds_format_double(self.e_rev_Na, input_name='e_rev_Na'))
        if self.e_rev_I is not None and 'e_rev_I' not in already_processed:
            already_processed.add('e_rev_I')
            outfile.write(' e_rev_I="%s"' % self.gds_format_double(self.e_rev_I, input_name='e_rev_I'))
        if self.e_rev_K is not None and 'e_rev_K' not in already_processed:
            already_processed.add('e_rev_K')
            outfile.write(' e_rev_K="%s"' % self.gds_format_double(self.e_rev_K, input_name='e_rev_K'))
        if self.e_rev_leak is not None and 'e_rev_leak' not in already_processed:
            already_processed.add('e_rev_leak')
            outfile.write(' e_rev_leak="%s"' % self.gds_format_double(self.e_rev_leak, input_name='e_rev_leak'))
        if self.v_offset is not None and 'v_offset' not in already_processed:
            already_processed.add('v_offset')
            outfile.write(' v_offset="%s"' % self.gds_format_double(self.v_offset, input_name='v_offset'))
        if self.gbar_Na is not None and 'gbar_Na' not in already_processed:
            already_processed.add('gbar_Na')
            outfile.write(' gbar_Na="%s"' % self.gds_format_double(self.gbar_Na, input_name='gbar_Na'))
    def exportChildren(self, outfile, level, namespace_='', name_='HH_cond_exp', fromsubclass_=False, pretty_print=True):
        super(HH_cond_exp, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HH_cond_exp'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.gbar_K is not None and 'gbar_K' not in already_processed:
            already_processed.add('gbar_K')
            showIndent(outfile, level)
            outfile.write('gbar_K=%e,\n' % (self.gbar_K,))
        if self.e_rev_E is not None and 'e_rev_E' not in already_processed:
            already_processed.add('e_rev_E')
            showIndent(outfile, level)
            outfile.write('e_rev_E=%e,\n' % (self.e_rev_E,))
        if self.g_leak is not None and 'g_leak' not in already_processed:
            already_processed.add('g_leak')
            showIndent(outfile, level)
            outfile.write('g_leak=%e,\n' % (self.g_leak,))
        if self.e_rev_Na is not None and 'e_rev_Na' not in already_processed:
            already_processed.add('e_rev_Na')
            showIndent(outfile, level)
            outfile.write('e_rev_Na=%e,\n' % (self.e_rev_Na,))
        if self.e_rev_I is not None and 'e_rev_I' not in already_processed:
            already_processed.add('e_rev_I')
            showIndent(outfile, level)
            outfile.write('e_rev_I=%e,\n' % (self.e_rev_I,))
        if self.e_rev_K is not None and 'e_rev_K' not in already_processed:
            already_processed.add('e_rev_K')
            showIndent(outfile, level)
            outfile.write('e_rev_K=%e,\n' % (self.e_rev_K,))
        if self.e_rev_leak is not None and 'e_rev_leak' not in already_processed:
            already_processed.add('e_rev_leak')
            showIndent(outfile, level)
            outfile.write('e_rev_leak=%e,\n' % (self.e_rev_leak,))
        if self.v_offset is not None and 'v_offset' not in already_processed:
            already_processed.add('v_offset')
            showIndent(outfile, level)
            outfile.write('v_offset=%e,\n' % (self.v_offset,))
        if self.gbar_Na is not None and 'gbar_Na' not in already_processed:
            already_processed.add('gbar_Na')
            showIndent(outfile, level)
            outfile.write('gbar_Na=%e,\n' % (self.gbar_Na,))
        super(HH_cond_exp, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(HH_cond_exp, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('gbar_K', node)
        if value is not None and 'gbar_K' not in already_processed:
            already_processed.add('gbar_K')
            try:
                self.gbar_K = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (gbar_K): %s' % exp)
        value = find_attr_value_('e_rev_E', node)
        if value is not None and 'e_rev_E' not in already_processed:
            already_processed.add('e_rev_E')
            try:
                self.e_rev_E = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (e_rev_E): %s' % exp)
        value = find_attr_value_('g_leak', node)
        if value is not None and 'g_leak' not in already_processed:
            already_processed.add('g_leak')
            try:
                self.g_leak = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (g_leak): %s' % exp)
        value = find_attr_value_('e_rev_Na', node)
        if value is not None and 'e_rev_Na' not in already_processed:
            already_processed.add('e_rev_Na')
            try:
                self.e_rev_Na = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (e_rev_Na): %s' % exp)
        value = find_attr_value_('e_rev_I', node)
        if value is not None and 'e_rev_I' not in already_processed:
            already_processed.add('e_rev_I')
            try:
                self.e_rev_I = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (e_rev_I): %s' % exp)
        value = find_attr_value_('e_rev_K', node)
        if value is not None and 'e_rev_K' not in already_processed:
            already_processed.add('e_rev_K')
            try:
                self.e_rev_K = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (e_rev_K): %s' % exp)
        value = find_attr_value_('e_rev_leak', node)
        if value is not None and 'e_rev_leak' not in already_processed:
            already_processed.add('e_rev_leak')
            try:
                self.e_rev_leak = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (e_rev_leak): %s' % exp)
        value = find_attr_value_('v_offset', node)
        if value is not None and 'v_offset' not in already_processed:
            already_processed.add('v_offset')
            try:
                self.v_offset = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (v_offset): %s' % exp)
        value = find_attr_value_('gbar_Na', node)
        if value is not None and 'gbar_Na' not in already_processed:
            already_processed.add('gbar_Na')
            try:
                self.gbar_Na = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (gbar_Na): %s' % exp)
        super(HH_cond_exp, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(HH_cond_exp, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class HH_cond_exp


class basePyNNIaFCell(basePyNNCell):
    member_data_items_ = [
        MemberSpec_('tau_refrac', 'xs:double', 0),
        MemberSpec_('v_thresh', 'xs:double', 0),
        MemberSpec_('tau_m', 'xs:double', 0),
        MemberSpec_('v_reset', 'xs:double', 0),
        MemberSpec_('v_rest', 'xs:double', 0),
    ]
    subclass = None
    superclass = basePyNNCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn_I=None, tau_syn_E=None, i_offset=None, cm=None, v_init=None, tau_refrac=None, v_thresh=None, tau_m=None, v_reset=None, v_rest=None, extensiontype_=None):
        super(basePyNNIaFCell, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn_I, tau_syn_E, i_offset, cm, v_init, extensiontype_, )
        self.tau_refrac = _cast(float, tau_refrac)
        self.v_thresh = _cast(float, v_thresh)
        self.tau_m = _cast(float, tau_m)
        self.v_reset = _cast(float, v_reset)
        self.v_rest = _cast(float, v_rest)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if basePyNNIaFCell.subclass:
            return basePyNNIaFCell.subclass(*args_, **kwargs_)
        else:
            return basePyNNIaFCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(basePyNNIaFCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='basePyNNIaFCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='basePyNNIaFCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='basePyNNIaFCell'):
        super(basePyNNIaFCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='basePyNNIaFCell')
        if self.tau_refrac is not None and 'tau_refrac' not in already_processed:
            already_processed.add('tau_refrac')
            outfile.write(' tau_refrac="%s"' % self.gds_format_double(self.tau_refrac, input_name='tau_refrac'))
        if self.v_thresh is not None and 'v_thresh' not in already_processed:
            already_processed.add('v_thresh')
            outfile.write(' v_thresh="%s"' % self.gds_format_double(self.v_thresh, input_name='v_thresh'))
        if self.tau_m is not None and 'tau_m' not in already_processed:
            already_processed.add('tau_m')
            outfile.write(' tau_m="%s"' % self.gds_format_double(self.tau_m, input_name='tau_m'))
        if self.v_reset is not None and 'v_reset' not in already_processed:
            already_processed.add('v_reset')
            outfile.write(' v_reset="%s"' % self.gds_format_double(self.v_reset, input_name='v_reset'))
        if self.v_rest is not None and 'v_rest' not in already_processed:
            already_processed.add('v_rest')
            outfile.write(' v_rest="%s"' % self.gds_format_double(self.v_rest, input_name='v_rest'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='basePyNNIaFCell', fromsubclass_=False, pretty_print=True):
        super(basePyNNIaFCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='basePyNNIaFCell'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tau_refrac is not None and 'tau_refrac' not in already_processed:
            already_processed.add('tau_refrac')
            showIndent(outfile, level)
            outfile.write('tau_refrac=%e,\n' % (self.tau_refrac,))
        if self.v_thresh is not None and 'v_thresh' not in already_processed:
            already_processed.add('v_thresh')
            showIndent(outfile, level)
            outfile.write('v_thresh=%e,\n' % (self.v_thresh,))
        if self.tau_m is not None and 'tau_m' not in already_processed:
            already_processed.add('tau_m')
            showIndent(outfile, level)
            outfile.write('tau_m=%e,\n' % (self.tau_m,))
        if self.v_reset is not None and 'v_reset' not in already_processed:
            already_processed.add('v_reset')
            showIndent(outfile, level)
            outfile.write('v_reset=%e,\n' % (self.v_reset,))
        if self.v_rest is not None and 'v_rest' not in already_processed:
            already_processed.add('v_rest')
            showIndent(outfile, level)
            outfile.write('v_rest=%e,\n' % (self.v_rest,))
        super(basePyNNIaFCell, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(basePyNNIaFCell, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tau_refrac', node)
        if value is not None and 'tau_refrac' not in already_processed:
            already_processed.add('tau_refrac')
            try:
                self.tau_refrac = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (tau_refrac): %s' % exp)
        value = find_attr_value_('v_thresh', node)
        if value is not None and 'v_thresh' not in already_processed:
            already_processed.add('v_thresh')
            try:
                self.v_thresh = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (v_thresh): %s' % exp)
        value = find_attr_value_('tau_m', node)
        if value is not None and 'tau_m' not in already_processed:
            already_processed.add('tau_m')
            try:
                self.tau_m = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (tau_m): %s' % exp)
        value = find_attr_value_('v_reset', node)
        if value is not None and 'v_reset' not in already_processed:
            already_processed.add('v_reset')
            try:
                self.v_reset = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (v_reset): %s' % exp)
        value = find_attr_value_('v_rest', node)
        if value is not None and 'v_rest' not in already_processed:
            already_processed.add('v_rest')
            try:
                self.v_rest = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (v_rest): %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(basePyNNIaFCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(basePyNNIaFCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class basePyNNIaFCell


class IaFRefCell(IaFCell):
    member_data_items_ = [
        MemberSpec_('refract', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = IaFCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, reset=None, C=None, thresh=None, leak_conductance=None, leak_reversal=None, refract=None):
        super(IaFRefCell, self).__init__(neuro_lex_id, id, metaid, notes, annotation, reset, C, thresh, leak_conductance, leak_reversal, )
        self.refract = _cast(None, refract)
        pass
    def factory(*args_, **kwargs_):
        if IaFRefCell.subclass:
            return IaFRefCell.subclass(*args_, **kwargs_)
        else:
            return IaFRefCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(IaFRefCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IaFRefCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IaFRefCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IaFRefCell'):
        super(IaFRefCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IaFRefCell')
        if self.refract is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            outfile.write(' refract=%s' % (quote_attrib(self.refract), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IaFRefCell', fromsubclass_=False, pretty_print=True):
        super(IaFRefCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IaFRefCell'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.refract is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            showIndent(outfile, level)
            outfile.write('refract="%s",\n' % (self.refract,))
        super(IaFRefCell, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IaFRefCell, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refract', node)
        if value is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            self.refract = value
            self.validate_Nml2Quantity_time(self.refract)    # validate type Nml2Quantity_time
        super(IaFRefCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IaFRefCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IaFRefCell


class IaFTauRefCell(IaFTauCell):
    member_data_items_ = [
        MemberSpec_('refract', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = IaFTauCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, reset=None, tau=None, thresh=None, leak_reversal=None, refract=None):
        super(IaFTauRefCell, self).__init__(neuro_lex_id, id, metaid, notes, annotation, reset, tau, thresh, leak_reversal, )
        self.refract = _cast(None, refract)
        pass
    def factory(*args_, **kwargs_):
        if IaFTauRefCell.subclass:
            return IaFTauRefCell.subclass(*args_, **kwargs_)
        else:
            return IaFTauRefCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(IaFTauRefCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IaFTauRefCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IaFTauRefCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IaFTauRefCell'):
        super(IaFTauRefCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IaFTauRefCell')
        if self.refract is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            outfile.write(' refract=%s' % (quote_attrib(self.refract), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IaFTauRefCell', fromsubclass_=False, pretty_print=True):
        super(IaFTauRefCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IaFTauRefCell'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.refract is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            showIndent(outfile, level)
            outfile.write('refract="%s",\n' % (self.refract,))
        super(IaFTauRefCell, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IaFTauRefCell, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('refract', node)
        if value is not None and 'refract' not in already_processed:
            already_processed.add('refract')
            self.refract = value
            self.validate_Nml2Quantity_time(self.refract)    # validate type Nml2Quantity_time
        super(IaFTauRefCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IaFTauRefCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IaFTauRefCell


class ExpTwoSynapse(BaseConductanceBasedSynapse):
    member_data_items_ = [
        MemberSpec_('tauDecay', 'Nml2Quantity_time', 0),
        MemberSpec_('tauRise', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = BaseConductanceBasedSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, erev=None, gbase=None, tau_decay=None, tau_rise=None, extensiontype_=None):
        super(ExpTwoSynapse, self).__init__(neuro_lex_id, id, metaid, notes, annotation, erev, gbase, extensiontype_, )
        self.tau_decay = _cast(None, tau_decay)
        self.tau_rise = _cast(None, tau_rise)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if ExpTwoSynapse.subclass:
            return ExpTwoSynapse.subclass(*args_, **kwargs_)
        else:
            return ExpTwoSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(ExpTwoSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ExpTwoSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExpTwoSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ExpTwoSynapse'):
        super(ExpTwoSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ExpTwoSynapse')
        if self.tau_decay is not None and 'tau_decay' not in already_processed:
            already_processed.add('tau_decay')
            outfile.write(' tauDecay=%s' % (quote_attrib(self.tau_decay), ))
        if self.tau_rise is not None and 'tau_rise' not in already_processed:
            already_processed.add('tau_rise')
            outfile.write(' tauRise=%s' % (quote_attrib(self.tau_rise), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='ExpTwoSynapse', fromsubclass_=False, pretty_print=True):
        super(ExpTwoSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ExpTwoSynapse'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tau_decay is not None and 'tau_decay' not in already_processed:
            already_processed.add('tau_decay')
            showIndent(outfile, level)
            outfile.write('tau_decay="%s",\n' % (self.tau_decay,))
        if self.tau_rise is not None and 'tau_rise' not in already_processed:
            already_processed.add('tau_rise')
            showIndent(outfile, level)
            outfile.write('tau_rise="%s",\n' % (self.tau_rise,))
        super(ExpTwoSynapse, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ExpTwoSynapse, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tauDecay', node)
        if value is not None and 'tauDecay' not in already_processed:
            already_processed.add('tauDecay')
            self.tau_decay = value
            self.validate_Nml2Quantity_time(self.tau_decay)    # validate type Nml2Quantity_time
        value = find_attr_value_('tauRise', node)
        if value is not None and 'tauRise' not in already_processed:
            already_processed.add('tauRise')
            self.tau_rise = value
            self.validate_Nml2Quantity_time(self.tau_rise)    # validate type Nml2Quantity_time
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(ExpTwoSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ExpTwoSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ExpTwoSynapse


class ExpOneSynapse(BaseConductanceBasedSynapse):
    member_data_items_ = [
        MemberSpec_('tauDecay', 'Nml2Quantity_time', 0),
    ]
    subclass = None
    superclass = BaseConductanceBasedSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, erev=None, gbase=None, tau_decay=None):
        super(ExpOneSynapse, self).__init__(neuro_lex_id, id, metaid, notes, annotation, erev, gbase, )
        self.tau_decay = _cast(None, tau_decay)
        pass
    def factory(*args_, **kwargs_):
        if ExpOneSynapse.subclass:
            return ExpOneSynapse.subclass(*args_, **kwargs_)
        else:
            return ExpOneSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            super(ExpOneSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ExpOneSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExpOneSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ExpOneSynapse'):
        super(ExpOneSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ExpOneSynapse')
        if self.tau_decay is not None and 'tau_decay' not in already_processed:
            already_processed.add('tau_decay')
            outfile.write(' tauDecay=%s' % (quote_attrib(self.tau_decay), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ExpOneSynapse', fromsubclass_=False, pretty_print=True):
        super(ExpOneSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ExpOneSynapse'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tau_decay is not None and 'tau_decay' not in already_processed:
            already_processed.add('tau_decay')
            showIndent(outfile, level)
            outfile.write('tau_decay="%s",\n' % (self.tau_decay,))
        super(ExpOneSynapse, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ExpOneSynapse, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tauDecay', node)
        if value is not None and 'tauDecay' not in already_processed:
            already_processed.add('tauDecay')
            self.tau_decay = value
            self.validate_Nml2Quantity_time(self.tau_decay)    # validate type Nml2Quantity_time
        super(ExpOneSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(ExpOneSynapse, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class ExpOneSynapse


class IF_curr_exp(basePyNNIaFCell):
    member_data_items_ = [
    ]
    subclass = None
    superclass = basePyNNIaFCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn_I=None, tau_syn_E=None, i_offset=None, cm=None, v_init=None, tau_refrac=None, v_thresh=None, tau_m=None, v_reset=None, v_rest=None):
        super(IF_curr_exp, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn_I, tau_syn_E, i_offset, cm, v_init, tau_refrac, v_thresh, tau_m, v_reset, v_rest, )
        pass
    def factory(*args_, **kwargs_):
        if IF_curr_exp.subclass:
            return IF_curr_exp.subclass(*args_, **kwargs_)
        else:
            return IF_curr_exp(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(IF_curr_exp, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IF_curr_exp', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IF_curr_exp')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IF_curr_exp'):
        super(IF_curr_exp, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IF_curr_exp')
    def exportChildren(self, outfile, level, namespace_='', name_='IF_curr_exp', fromsubclass_=False, pretty_print=True):
        super(IF_curr_exp, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IF_curr_exp'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IF_curr_exp, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IF_curr_exp, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(IF_curr_exp, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IF_curr_exp, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IF_curr_exp


class IF_curr_alpha(basePyNNIaFCell):
    member_data_items_ = [
    ]
    subclass = None
    superclass = basePyNNIaFCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn_I=None, tau_syn_E=None, i_offset=None, cm=None, v_init=None, tau_refrac=None, v_thresh=None, tau_m=None, v_reset=None, v_rest=None):
        super(IF_curr_alpha, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn_I, tau_syn_E, i_offset, cm, v_init, tau_refrac, v_thresh, tau_m, v_reset, v_rest, )
        pass
    def factory(*args_, **kwargs_):
        if IF_curr_alpha.subclass:
            return IF_curr_alpha.subclass(*args_, **kwargs_)
        else:
            return IF_curr_alpha(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(IF_curr_alpha, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IF_curr_alpha', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IF_curr_alpha')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IF_curr_alpha'):
        super(IF_curr_alpha, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IF_curr_alpha')
    def exportChildren(self, outfile, level, namespace_='', name_='IF_curr_alpha', fromsubclass_=False, pretty_print=True):
        super(IF_curr_alpha, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IF_curr_alpha'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IF_curr_alpha, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IF_curr_alpha, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(IF_curr_alpha, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IF_curr_alpha, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IF_curr_alpha


class basePyNNIaFCondCell(basePyNNIaFCell):
    member_data_items_ = [
        MemberSpec_('e_rev_I', 'xs:double', 0),
        MemberSpec_('e_rev_E', 'xs:double', 0),
    ]
    subclass = None
    superclass = basePyNNIaFCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn_I=None, tau_syn_E=None, i_offset=None, cm=None, v_init=None, tau_refrac=None, v_thresh=None, tau_m=None, v_reset=None, v_rest=None, e_rev_I=None, e_rev_E=None, extensiontype_=None):
        super(basePyNNIaFCondCell, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn_I, tau_syn_E, i_offset, cm, v_init, tau_refrac, v_thresh, tau_m, v_reset, v_rest, extensiontype_, )
        self.e_rev_I = _cast(float, e_rev_I)
        self.e_rev_E = _cast(float, e_rev_E)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if basePyNNIaFCondCell.subclass:
            return basePyNNIaFCondCell.subclass(*args_, **kwargs_)
        else:
            return basePyNNIaFCondCell(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(basePyNNIaFCondCell, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='basePyNNIaFCondCell', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='basePyNNIaFCondCell')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='basePyNNIaFCondCell'):
        super(basePyNNIaFCondCell, self).exportAttributes(outfile, level, already_processed, namespace_, name_='basePyNNIaFCondCell')
        if self.e_rev_I is not None and 'e_rev_I' not in already_processed:
            already_processed.add('e_rev_I')
            outfile.write(' e_rev_I="%s"' % self.gds_format_double(self.e_rev_I, input_name='e_rev_I'))
        if self.e_rev_E is not None and 'e_rev_E' not in already_processed:
            already_processed.add('e_rev_E')
            outfile.write(' e_rev_E="%s"' % self.gds_format_double(self.e_rev_E, input_name='e_rev_E'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='basePyNNIaFCondCell', fromsubclass_=False, pretty_print=True):
        super(basePyNNIaFCondCell, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='basePyNNIaFCondCell'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.e_rev_I is not None and 'e_rev_I' not in already_processed:
            already_processed.add('e_rev_I')
            showIndent(outfile, level)
            outfile.write('e_rev_I=%e,\n' % (self.e_rev_I,))
        if self.e_rev_E is not None and 'e_rev_E' not in already_processed:
            already_processed.add('e_rev_E')
            showIndent(outfile, level)
            outfile.write('e_rev_E=%e,\n' % (self.e_rev_E,))
        super(basePyNNIaFCondCell, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(basePyNNIaFCondCell, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('e_rev_I', node)
        if value is not None and 'e_rev_I' not in already_processed:
            already_processed.add('e_rev_I')
            try:
                self.e_rev_I = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (e_rev_I): %s' % exp)
        value = find_attr_value_('e_rev_E', node)
        if value is not None and 'e_rev_E' not in already_processed:
            already_processed.add('e_rev_E')
            try:
                self.e_rev_E = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (e_rev_E): %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(basePyNNIaFCondCell, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(basePyNNIaFCondCell, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class basePyNNIaFCondCell


class BlockingPlasticSynapse(ExpTwoSynapse):
    member_data_items_ = [
        MemberSpec_('plasticity_mechanism', 'PlasticityMechanism', 0),
        MemberSpec_('block_mechanism', 'BlockMechanism', 0),
    ]
    subclass = None
    superclass = ExpTwoSynapse
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, erev=None, gbase=None, tau_decay=None, tau_rise=None, plasticity_mechanism=None, block_mechanism=None):
        super(BlockingPlasticSynapse, self).__init__(neuro_lex_id, id, metaid, notes, annotation, erev, gbase, tau_decay, tau_rise, )
        self.plasticity_mechanism = plasticity_mechanism
        self.block_mechanism = block_mechanism
    def factory(*args_, **kwargs_):
        if BlockingPlasticSynapse.subclass:
            return BlockingPlasticSynapse.subclass(*args_, **kwargs_)
        else:
            return BlockingPlasticSynapse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            self.plasticity_mechanism is not None or
            self.block_mechanism is not None or
            super(BlockingPlasticSynapse, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='BlockingPlasticSynapse', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BlockingPlasticSynapse')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='BlockingPlasticSynapse'):
        super(BlockingPlasticSynapse, self).exportAttributes(outfile, level, already_processed, namespace_, name_='BlockingPlasticSynapse')
    def exportChildren(self, outfile, level, namespace_='', name_='BlockingPlasticSynapse', fromsubclass_=False, pretty_print=True):
        super(BlockingPlasticSynapse, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.plasticity_mechanism is not None:
            self.plasticity_mechanism.export(outfile, level, namespace_, name_='plasticityMechanism', pretty_print=pretty_print)
        if self.block_mechanism is not None:
            self.block_mechanism.export(outfile, level, namespace_, name_='blockMechanism', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BlockingPlasticSynapse'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(BlockingPlasticSynapse, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(BlockingPlasticSynapse, self).exportLiteralChildren(outfile, level, name_)
        if self.plasticity_mechanism is not None:
            showIndent(outfile, level)
            outfile.write('plasticity_mechanism=model_.PlasticityMechanism(\n')
            self.plasticity_mechanism.exportLiteral(outfile, level, name_='plasticityMechanism')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.block_mechanism is not None:
            showIndent(outfile, level)
            outfile.write('block_mechanism=model_.BlockMechanism(\n')
            self.block_mechanism.exportLiteral(outfile, level, name_='blockMechanism')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(BlockingPlasticSynapse, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'plasticityMechanism':
            obj_ = PlasticityMechanism.factory()
            obj_.build(child_)
            self.plasticity_mechanism = obj_
        elif nodeName_ == 'blockMechanism':
            obj_ = BlockMechanism.factory()
            obj_.build(child_)
            self.block_mechanism = obj_
        super(BlockingPlasticSynapse, self).buildChildren(child_, node, nodeName_, True)
# end class BlockingPlasticSynapse


class EIF_cond_alpha_isfa_ista(basePyNNIaFCondCell):
    member_data_items_ = [
        MemberSpec_('a', 'xs:double', 0),
        MemberSpec_('delta_T', 'xs:double', 0),
        MemberSpec_('b', 'xs:double', 0),
        MemberSpec_('v_spike', 'xs:double', 0),
        MemberSpec_('tau_w', 'xs:double', 0),
    ]
    subclass = None
    superclass = basePyNNIaFCondCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn_I=None, tau_syn_E=None, i_offset=None, cm=None, v_init=None, tau_refrac=None, v_thresh=None, tau_m=None, v_reset=None, v_rest=None, e_rev_I=None, e_rev_E=None, a=None, delta_t=None, b=None, v_spike=None, tau_w=None):
        super(EIF_cond_alpha_isfa_ista, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn_I, tau_syn_E, i_offset, cm, v_init, tau_refrac, v_thresh, tau_m, v_reset, v_rest, e_rev_I, e_rev_E, )
        self.a = _cast(float, a)
        self.delta_t = _cast(float, delta_t)
        self.b = _cast(float, b)
        self.v_spike = _cast(float, v_spike)
        self.tau_w = _cast(float, tau_w)
        pass
    def factory(*args_, **kwargs_):
        if EIF_cond_alpha_isfa_ista.subclass:
            return EIF_cond_alpha_isfa_ista.subclass(*args_, **kwargs_)
        else:
            return EIF_cond_alpha_isfa_ista(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(EIF_cond_alpha_isfa_ista, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EIF_cond_alpha_isfa_ista', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EIF_cond_alpha_isfa_ista')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EIF_cond_alpha_isfa_ista'):
        super(EIF_cond_alpha_isfa_ista, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EIF_cond_alpha_isfa_ista')
        if self.a is not None and 'a' not in already_processed:
            already_processed.add('a')
            outfile.write(' a="%s"' % self.gds_format_double(self.a, input_name='a'))
        if self.delta_t is not None and 'delta_t' not in already_processed:
            already_processed.add('delta_t')
            outfile.write(' delta_T="%s"' % self.gds_format_double(self.delta_t, input_name='delta_T'))
        if self.b is not None and 'b' not in already_processed:
            already_processed.add('b')
            outfile.write(' b="%s"' % self.gds_format_double(self.b, input_name='b'))
        if self.v_spike is not None and 'v_spike' not in already_processed:
            already_processed.add('v_spike')
            outfile.write(' v_spike="%s"' % self.gds_format_double(self.v_spike, input_name='v_spike'))
        if self.tau_w is not None and 'tau_w' not in already_processed:
            already_processed.add('tau_w')
            outfile.write(' tau_w="%s"' % self.gds_format_double(self.tau_w, input_name='tau_w'))
    def exportChildren(self, outfile, level, namespace_='', name_='EIF_cond_alpha_isfa_ista', fromsubclass_=False, pretty_print=True):
        super(EIF_cond_alpha_isfa_ista, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EIF_cond_alpha_isfa_ista'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.a is not None and 'a' not in already_processed:
            already_processed.add('a')
            showIndent(outfile, level)
            outfile.write('a=%e,\n' % (self.a,))
        if self.delta_t is not None and 'delta_t' not in already_processed:
            already_processed.add('delta_t')
            showIndent(outfile, level)
            outfile.write('delta_t=%e,\n' % (self.delta_t,))
        if self.b is not None and 'b' not in already_processed:
            already_processed.add('b')
            showIndent(outfile, level)
            outfile.write('b=%e,\n' % (self.b,))
        if self.v_spike is not None and 'v_spike' not in already_processed:
            already_processed.add('v_spike')
            showIndent(outfile, level)
            outfile.write('v_spike=%e,\n' % (self.v_spike,))
        if self.tau_w is not None and 'tau_w' not in already_processed:
            already_processed.add('tau_w')
            showIndent(outfile, level)
            outfile.write('tau_w=%e,\n' % (self.tau_w,))
        super(EIF_cond_alpha_isfa_ista, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EIF_cond_alpha_isfa_ista, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('a', node)
        if value is not None and 'a' not in already_processed:
            already_processed.add('a')
            try:
                self.a = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (a): %s' % exp)
        value = find_attr_value_('delta_T', node)
        if value is not None and 'delta_T' not in already_processed:
            already_processed.add('delta_T')
            try:
                self.delta_t = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (delta_T): %s' % exp)
        value = find_attr_value_('b', node)
        if value is not None and 'b' not in already_processed:
            already_processed.add('b')
            try:
                self.b = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (b): %s' % exp)
        value = find_attr_value_('v_spike', node)
        if value is not None and 'v_spike' not in already_processed:
            already_processed.add('v_spike')
            try:
                self.v_spike = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (v_spike): %s' % exp)
        value = find_attr_value_('tau_w', node)
        if value is not None and 'tau_w' not in already_processed:
            already_processed.add('tau_w')
            try:
                self.tau_w = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (tau_w): %s' % exp)
        super(EIF_cond_alpha_isfa_ista, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(EIF_cond_alpha_isfa_ista, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class EIF_cond_alpha_isfa_ista


class EIF_cond_exp_isfa_ista(basePyNNIaFCondCell):
    member_data_items_ = [
        MemberSpec_('a', 'xs:double', 0),
        MemberSpec_('delta_T', 'xs:double', 0),
        MemberSpec_('b', 'xs:double', 0),
        MemberSpec_('v_spike', 'xs:double', 0),
        MemberSpec_('tau_w', 'xs:double', 0),
    ]
    subclass = None
    superclass = basePyNNIaFCondCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn_I=None, tau_syn_E=None, i_offset=None, cm=None, v_init=None, tau_refrac=None, v_thresh=None, tau_m=None, v_reset=None, v_rest=None, e_rev_I=None, e_rev_E=None, a=None, delta_t=None, b=None, v_spike=None, tau_w=None):
        super(EIF_cond_exp_isfa_ista, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn_I, tau_syn_E, i_offset, cm, v_init, tau_refrac, v_thresh, tau_m, v_reset, v_rest, e_rev_I, e_rev_E, )
        self.a = _cast(float, a)
        self.delta_t = _cast(float, delta_t)
        self.b = _cast(float, b)
        self.v_spike = _cast(float, v_spike)
        self.tau_w = _cast(float, tau_w)
        pass
    def factory(*args_, **kwargs_):
        if EIF_cond_exp_isfa_ista.subclass:
            return EIF_cond_exp_isfa_ista.subclass(*args_, **kwargs_)
        else:
            return EIF_cond_exp_isfa_ista(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(EIF_cond_exp_isfa_ista, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='EIF_cond_exp_isfa_ista', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EIF_cond_exp_isfa_ista')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='EIF_cond_exp_isfa_ista'):
        super(EIF_cond_exp_isfa_ista, self).exportAttributes(outfile, level, already_processed, namespace_, name_='EIF_cond_exp_isfa_ista')
        if self.a is not None and 'a' not in already_processed:
            already_processed.add('a')
            outfile.write(' a="%s"' % self.gds_format_double(self.a, input_name='a'))
        if self.delta_t is not None and 'delta_t' not in already_processed:
            already_processed.add('delta_t')
            outfile.write(' delta_T="%s"' % self.gds_format_double(self.delta_t, input_name='delta_T'))
        if self.b is not None and 'b' not in already_processed:
            already_processed.add('b')
            outfile.write(' b="%s"' % self.gds_format_double(self.b, input_name='b'))
        if self.v_spike is not None and 'v_spike' not in already_processed:
            already_processed.add('v_spike')
            outfile.write(' v_spike="%s"' % self.gds_format_double(self.v_spike, input_name='v_spike'))
        if self.tau_w is not None and 'tau_w' not in already_processed:
            already_processed.add('tau_w')
            outfile.write(' tau_w="%s"' % self.gds_format_double(self.tau_w, input_name='tau_w'))
    def exportChildren(self, outfile, level, namespace_='', name_='EIF_cond_exp_isfa_ista', fromsubclass_=False, pretty_print=True):
        super(EIF_cond_exp_isfa_ista, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='EIF_cond_exp_isfa_ista'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.a is not None and 'a' not in already_processed:
            already_processed.add('a')
            showIndent(outfile, level)
            outfile.write('a=%e,\n' % (self.a,))
        if self.delta_t is not None and 'delta_t' not in already_processed:
            already_processed.add('delta_t')
            showIndent(outfile, level)
            outfile.write('delta_t=%e,\n' % (self.delta_t,))
        if self.b is not None and 'b' not in already_processed:
            already_processed.add('b')
            showIndent(outfile, level)
            outfile.write('b=%e,\n' % (self.b,))
        if self.v_spike is not None and 'v_spike' not in already_processed:
            already_processed.add('v_spike')
            showIndent(outfile, level)
            outfile.write('v_spike=%e,\n' % (self.v_spike,))
        if self.tau_w is not None and 'tau_w' not in already_processed:
            already_processed.add('tau_w')
            showIndent(outfile, level)
            outfile.write('tau_w=%e,\n' % (self.tau_w,))
        super(EIF_cond_exp_isfa_ista, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(EIF_cond_exp_isfa_ista, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('a', node)
        if value is not None and 'a' not in already_processed:
            already_processed.add('a')
            try:
                self.a = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (a): %s' % exp)
        value = find_attr_value_('delta_T', node)
        if value is not None and 'delta_T' not in already_processed:
            already_processed.add('delta_T')
            try:
                self.delta_t = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (delta_T): %s' % exp)
        value = find_attr_value_('b', node)
        if value is not None and 'b' not in already_processed:
            already_processed.add('b')
            try:
                self.b = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (b): %s' % exp)
        value = find_attr_value_('v_spike', node)
        if value is not None and 'v_spike' not in already_processed:
            already_processed.add('v_spike')
            try:
                self.v_spike = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (v_spike): %s' % exp)
        value = find_attr_value_('tau_w', node)
        if value is not None and 'tau_w' not in already_processed:
            already_processed.add('tau_w')
            try:
                self.tau_w = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (tau_w): %s' % exp)
        super(EIF_cond_exp_isfa_ista, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(EIF_cond_exp_isfa_ista, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class EIF_cond_exp_isfa_ista


class IF_cond_exp(basePyNNIaFCondCell):
    member_data_items_ = [
    ]
    subclass = None
    superclass = basePyNNIaFCondCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn_I=None, tau_syn_E=None, i_offset=None, cm=None, v_init=None, tau_refrac=None, v_thresh=None, tau_m=None, v_reset=None, v_rest=None, e_rev_I=None, e_rev_E=None):
        super(IF_cond_exp, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn_I, tau_syn_E, i_offset, cm, v_init, tau_refrac, v_thresh, tau_m, v_reset, v_rest, e_rev_I, e_rev_E, )
        pass
    def factory(*args_, **kwargs_):
        if IF_cond_exp.subclass:
            return IF_cond_exp.subclass(*args_, **kwargs_)
        else:
            return IF_cond_exp(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(IF_cond_exp, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IF_cond_exp', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IF_cond_exp')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IF_cond_exp'):
        super(IF_cond_exp, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IF_cond_exp')
    def exportChildren(self, outfile, level, namespace_='', name_='IF_cond_exp', fromsubclass_=False, pretty_print=True):
        super(IF_cond_exp, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IF_cond_exp'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IF_cond_exp, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IF_cond_exp, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(IF_cond_exp, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IF_cond_exp, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IF_cond_exp


class IF_cond_alpha(basePyNNIaFCondCell):
    member_data_items_ = [
    ]
    subclass = None
    superclass = basePyNNIaFCondCell
    def __init__(self, neuro_lex_id=None, id=None, metaid=None, notes=None, annotation=None, tau_syn_I=None, tau_syn_E=None, i_offset=None, cm=None, v_init=None, tau_refrac=None, v_thresh=None, tau_m=None, v_reset=None, v_rest=None, e_rev_I=None, e_rev_E=None):
        super(IF_cond_alpha, self).__init__(neuro_lex_id, id, metaid, notes, annotation, tau_syn_I, tau_syn_E, i_offset, cm, v_init, tau_refrac, v_thresh, tau_m, v_reset, v_rest, e_rev_I, e_rev_E, )
        pass
    def factory(*args_, **kwargs_):
        if IF_cond_alpha.subclass:
            return IF_cond_alpha.subclass(*args_, **kwargs_)
        else:
            return IF_cond_alpha(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(IF_cond_alpha, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='IF_cond_alpha', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IF_cond_alpha')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IF_cond_alpha'):
        super(IF_cond_alpha, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IF_cond_alpha')
    def exportChildren(self, outfile, level, namespace_='', name_='IF_cond_alpha', fromsubclass_=False, pretty_print=True):
        super(IF_cond_alpha, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='IF_cond_alpha'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IF_cond_alpha, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IF_cond_alpha, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(IF_cond_alpha, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IF_cond_alpha, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IF_cond_alpha


GDSClassesMapping = {
    'intracellularProperties': IntracellularProperties,
    'inhomogeneousParam': InhomogeneousParam,
    'q10Settings': Q10Settings,
    'spikeGenerator': SpikeGenerator,
    'distal': DistalDetails,
    'random': RandomLayout,
    'variableParameter': VariableParameter,
    'subTree': SubTree,
    'gateHHtauInf': GateHHTauInf,
    'inputList': InputList,
    'specificCapacitance': ValueAcrossSegOrSegGroup,
    'ionChannel': IonChannel,
    'gateHHratesTau': GateHHRatesTau,
    'biophysicalProperties': BiophysicalProperties,
    'membraneProperties': MembraneProperties,
    'proximal': ProximalDetails,
    'path': Path,
    'morphology': Morphology,
    'iafCell': IaFCell,
    'iafTauRefCell': IaFTauRefCell,
    'species': Species,
    'resistivity': ValueAcrossSegOrSegGroup,
    'member': Member,
    'inhomogeneousValue': InhomogeneousValue,
    'spikeGeneratorRandom': SpikeGeneratorRandom,
    'sineGenerator': SineGenerator,
    'expCondSynapse': ExpCondSynapse,
    'network': Network,
    'reverseRate': HHRate,
    'decayingPoolConcentrationModel': DecayingPoolConcentrationModel,
    'segment': Segment,
    'rampGenerator': RampGenerator,
    'cellSet': CellSet,
    'gateHHrates': GateHHRates,
    'cell': Cell,
    'to': SegmentEndPoint,
    'voltageClamp': VoltageClamp,
    'initMembPotential': ValueAcrossSegOrSegGroup,
    'projection': Projection,
    'spike': Spike,
    'gate': GateHHUndetermined,
    'steadyState': HHVariable,
    'include': Include,
    'forwardRate': HHRate,
    'location': Location,
    'synapticConnection': SynapticConnection,
    'neuroml': NeuroMLDocument,
    'from': SegmentEndPoint,
    'blockMechanism': BlockMechanism,
    'gateHHratesInf': GateHHRatesInf,
    'parent': SegmentParent,
    'plasticityMechanism': PlasticityMechanism,
    'spikeThresh': ValueAcrossSegOrSegGroup,
    'annotation': Annotation,
    'instance': Instance,
    'adExIaFCell': AdExIaFCell,
    'grid': GridLayout,
    'alphaCondSynapse': AlphaCondSynapse,
    'izhikevichCell': IzhikevichCell,
    'input': Input,
    'iafTauCell': IaFTauCell,
    'segmentGroup': SegmentGroup,
    'expTwoSynapse': ExpTwoSynapse,
    'pulseGenerator': PulseGenerator,
    'iafRefCell': IaFRefCell,
    'structure': SpaceStructure,
    'spikeArray': SpikeArray,
    'unstructured': UnstructuredLayout,
    'blockingPlasticSynapse': BlockingPlasticSynapse,
    'reversalPotential': ReversalPotential,
    'channelPopulation': ChannelPopulation,
    'alphaCurrSynapse': AlphaCurrSynapse,
    'region': Region,
    'space': Space,
    'expCurrSynapse': ExpCurrSynapse,
    'population': Population,
    'timeCourse': HHTime,
    'explicitInput': ExplicitInput,
    'extracellularProperties': ExtracellularPropertiesLocal,
    'connection': Connection,
    'spikeGeneratorPoisson': SpikeGeneratorPoisson,
    'channelDensity': ChannelDensity,
    'expOneSynapse': ExpOneSynapse,
    'layout': Layout,
    'baseCell': BaseCell,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Annotation'
        rootClass = Annotation
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('<?xml version="1.0" ?>\n')
##     rootObj.export(
##         sys.stdout, 0, name_=rootTag,
##         namespacedef_='',
##         pretty_print=True)
    return rootObj


def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Annotation'
        rootClass = Annotation
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
##     content = etree_.tostring(
##         rootElement, pretty_print=True,
##         xml_declaration=True, encoding="utf-8")
##     sys.stdout.write(content)
##     sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    roots = get_root_tag(rootNode)
    rootClass = roots[1]
    if rootClass is None:
        rootClass = Annotation
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('<?xml version="1.0" ?>\n')
##     rootObj.export(
##         sys.stdout, 0, name_="Annotation",
##         namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Annotation'
        rootClass = Annotation
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('#from nml import *\n\n')
##     sys.stdout.write('import nml as model_\n\n')
##     sys.stdout.write('rootObj = model_.rootTag(\n')
##     rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
##     sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "AdExIaFCell",
    "AlphaCondSynapse",
    "AlphaCurrSynapse",
    "Annotation",
    "Base",
    "BaseCell",
    "BaseConductanceBasedSynapse",
    "BasePynnSynapse",
    "BaseSynapse",
    "BaseWithoutId",
    "BiophysicalProperties",
    "BlockMechanism",
    "BlockingPlasticSynapse",
    "Cell",
    "CellSet",
    "ChannelDensity",
    "ChannelPopulation",
    "ComponentType",
    "ConcentrationModel_D",
    "Connection",
    "DecayingPoolConcentrationModel",
    "DistalDetails",
    "EIF_cond_alpha_isfa_ista",
    "EIF_cond_exp_isfa_ista",
    "ExpCondSynapse",
    "ExpCurrSynapse",
    "ExpOneSynapse",
    "ExpTwoSynapse",
    "ExplicitInput",
    "ExtracellularProperties",
    "ExtracellularPropertiesLocal",
    "GateHHRates",
    "GateHHRatesInf",
    "GateHHRatesTau",
    "GateHHTauInf",
    "GateHHUndetermined",
    "GridLayout",
    "HHRate",
    "HHTime",
    "HHVariable",
    "HH_cond_exp",
    "IF_cond_alpha",
    "IF_cond_exp",
    "IF_curr_alpha",
    "IF_curr_exp",
    "IaFCell",
    "IaFRefCell",
    "IaFTauCell",
    "IaFTauRefCell",
    "Include",
    "IncludeType",
    "InhomogeneousParam",
    "InhomogeneousValue",
    "Input",
    "InputList",
    "Instance",
    "IntracellularProperties",
    "IonChannel",
    "IzhikevichCell",
    "Layout",
    "Location",
    "Member",
    "MembraneProperties",
    "Morphology",
    "Network",
    "NeuroMLDocument",
    "Path",
    "PlasticityMechanism",
    "Point3DWithDiam",
    "Population",
    "Projection",
    "ProximalDetails",
    "PulseGenerator",
    "Q10Settings",
    "RampGenerator",
    "RandomLayout",
    "ReactionScheme",
    "Region",
    "ReversalPotential",
    "Segment",
    "SegmentEndPoint",
    "SegmentGroup",
    "SegmentParent",
    "SineGenerator",
    "Space",
    "SpaceStructure",
    "Species",
    "Spike",
    "SpikeArray",
    "SpikeGenerator",
    "SpikeGeneratorPoisson",
    "SpikeGeneratorRandom",
    "SpikeSourcePoisson",
    "Standalone",
    "SubTree",
    "SynapticConnection",
    "UnstructuredLayout",
    "ValueAcrossSegOrSegGroup",
    "VariableParameter",
    "VoltageClamp",
    "basePyNNCell",
    "basePyNNIaFCell",
    "basePyNNIaFCondCell"
]

__all__ = [
    "AdExIaFCell",
    "AlphaCondSynapse",
    "AlphaCurrSynapse",
    "Annotation",
    "Base",
    "BaseCell",
    "BaseConductanceBasedSynapse",
    "BasePynnSynapse",
    "BaseSynapse",
    "BaseWithoutId",
    "BiophysicalProperties",
    "BlockMechanism",
    "BlockingPlasticSynapse",
    "Cell",
    "CellSet",
    "ChannelDensity",
    "ChannelPopulation",
    "ComponentType",
    "ConcentrationModel_D",
    "Connection",
    "DecayingPoolConcentrationModel",
    "DistalDetails",
    "EIF_cond_alpha_isfa_ista",
    "EIF_cond_exp_isfa_ista",
    "ExpCondSynapse",
    "ExpCurrSynapse",
    "ExpOneSynapse",
    "ExpTwoSynapse",
    "ExplicitInput",
    "ExtracellularProperties",
    "ExtracellularPropertiesLocal",
    "GateHHRates",
    "GateHHRatesInf",
    "GateHHRatesTau",
    "GateHHTauInf",
    "GateHHUndetermined",
    "GridLayout",
    "HHRate",
    "HHTime",
    "HHVariable",
    "HH_cond_exp",
    "IF_cond_alpha",
    "IF_cond_exp",
    "IF_curr_alpha",
    "IF_curr_exp",
    "IaFCell",
    "IaFRefCell",
    "IaFTauCell",
    "IaFTauRefCell",
    "Include",
    "IncludeType",
    "InhomogeneousParam",
    "InhomogeneousValue",
    "Input",
    "InputList",
    "Instance",
    "IntracellularProperties",
    "IonChannel",
    "IzhikevichCell",
    "Layout",
    "Location",
    "Member",
    "MembraneProperties",
    "Morphology",
    "Network",
    "NeuroMLDocument",
    "Path",
    "PlasticityMechanism",
    "Point3DWithDiam",
    "Population",
    "Projection",
    "ProximalDetails",
    "PulseGenerator",
    "Q10Settings",
    "RampGenerator",
    "RandomLayout",
    "ReactionScheme",
    "Region",
    "ReversalPotential",
    "Segment",
    "SegmentEndPoint",
    "SegmentGroup",
    "SegmentParent",
    "SineGenerator",
    "Space",
    "SpaceStructure",
    "Species",
    "Spike",
    "SpikeArray",
    "SpikeGenerator",
    "SpikeGeneratorPoisson",
    "SpikeGeneratorRandom",
    "SpikeSourcePoisson",
    "Standalone",
    "SubTree",
    "SynapticConnection",
    "UnstructuredLayout",
    "ValueAcrossSegOrSegGroup",
    "VariableParameter",
    "VoltageClamp",
    "basePyNNCell",
    "basePyNNIaFCell",
    "basePyNNIaFCondCell"
]

__all__ = [
    "AdExIaFCell",
    "AlphaCondSynapse",
    "AlphaCurrSynapse",
    "Annotation",
    "Base",
    "BaseCell",
    "BaseConductanceBasedSynapse",
    "BasePynnSynapse",
    "BaseSynapse",
    "BaseWithoutId",
    "BiophysicalProperties",
    "BlockMechanism",
    "BlockingPlasticSynapse",
    "Cell",
    "CellSet",
    "ChannelDensity",
    "ChannelPopulation",
    "ComponentType",
    "ConcentrationModel_D",
    "Connection",
    "DecayingPoolConcentrationModel",
    "DistalDetails",
    "EIF_cond_alpha_isfa_ista",
    "EIF_cond_exp_isfa_ista",
    "ExpCondSynapse",
    "ExpCurrSynapse",
    "ExpOneSynapse",
    "ExpTwoSynapse",
    "ExplicitInput",
    "ExtracellularProperties",
    "ExtracellularPropertiesLocal",
    "GateHHRates",
    "GateHHRatesInf",
    "GateHHRatesTau",
    "GateHHTauInf",
    "GateHHUndetermined",
    "GridLayout",
    "HHRate",
    "HHTime",
    "HHVariable",
    "HH_cond_exp",
    "IF_cond_alpha",
    "IF_cond_exp",
    "IF_curr_alpha",
    "IF_curr_exp",
    "IaFCell",
    "IaFRefCell",
    "IaFTauCell",
    "IaFTauRefCell",
    "Include",
    "IncludeType",
    "InhomogeneousParam",
    "InhomogeneousValue",
    "Input",
    "InputList",
    "Instance",
    "IntracellularProperties",
    "IonChannel",
    "IzhikevichCell",
    "Layout",
    "Location",
    "Member",
    "MembraneProperties",
    "Morphology",
    "Network",
    "NeuroMLDocument",
    "Path",
    "PlasticityMechanism",
    "Point3DWithDiam",
    "Population",
    "Projection",
    "ProximalDetails",
    "PulseGenerator",
    "Q10Settings",
    "RampGenerator",
    "RandomLayout",
    "ReactionScheme",
    "Region",
    "ReversalPotential",
    "Segment",
    "SegmentEndPoint",
    "SegmentGroup",
    "SegmentParent",
    "SineGenerator",
    "Space",
    "SpaceStructure",
    "Species",
    "Spike",
    "SpikeArray",
    "SpikeGenerator",
    "SpikeGeneratorPoisson",
    "SpikeGeneratorRandom",
    "SpikeSourcePoisson",
    "Standalone",
    "SubTree",
    "SynapticConnection",
    "UnstructuredLayout",
    "ValueAcrossSegOrSegGroup",
    "VariableParameter",
    "VoltageClamp",
    "basePyNNCell",
    "basePyNNIaFCell",
    "basePyNNIaFCondCell"
]

__all__ = [
    "AdExIaFCell",
    "AlphaCondSynapse",
    "AlphaCurrSynapse",
    "Annotation",
    "Base",
    "BaseCell",
    "BaseConductanceBasedSynapse",
    "BasePynnSynapse",
    "BaseSynapse",
    "BaseWithoutId",
    "BiophysicalProperties",
    "BlockMechanism",
    "BlockingPlasticSynapse",
    "Cell",
    "CellSet",
    "ChannelDensity",
    "ChannelPopulation",
    "ComponentType",
    "ConcentrationModel_D",
    "Connection",
    "DecayingPoolConcentrationModel",
    "DistalDetails",
    "EIF_cond_alpha_isfa_ista",
    "EIF_cond_exp_isfa_ista",
    "ExpCondSynapse",
    "ExpCurrSynapse",
    "ExpOneSynapse",
    "ExpTwoSynapse",
    "ExplicitInput",
    "ExtracellularProperties",
    "ExtracellularPropertiesLocal",
    "GateHHRates",
    "GateHHRatesInf",
    "GateHHRatesTau",
    "GateHHTauInf",
    "GateHHUndetermined",
    "GridLayout",
    "HHRate",
    "HHTime",
    "HHVariable",
    "HH_cond_exp",
    "IF_cond_alpha",
    "IF_cond_exp",
    "IF_curr_alpha",
    "IF_curr_exp",
    "IaFCell",
    "IaFRefCell",
    "IaFTauCell",
    "IaFTauRefCell",
    "Include",
    "IncludeType",
    "InhomogeneousParam",
    "InhomogeneousValue",
    "Input",
    "InputList",
    "Instance",
    "IntracellularProperties",
    "IonChannel",
    "IzhikevichCell",
    "Layout",
    "Location",
    "Member",
    "MembraneProperties",
    "Morphology",
    "Network",
    "NeuroMLDocument",
    "Path",
    "PlasticityMechanism",
    "Point3DWithDiam",
    "Population",
    "Projection",
    "ProximalDetails",
    "PulseGenerator",
    "Q10Settings",
    "RampGenerator",
    "RandomLayout",
    "ReactionScheme",
    "Region",
    "ReversalPotential",
    "Segment",
    "SegmentEndPoint",
    "SegmentGroup",
    "SegmentParent",
    "SineGenerator",
    "Space",
    "SpaceStructure",
    "Species",
    "Spike",
    "SpikeArray",
    "SpikeGenerator",
    "SpikeGeneratorPoisson",
    "SpikeGeneratorRandom",
    "SpikeSourcePoisson",
    "Standalone",
    "SubTree",
    "SynapticConnection",
    "UnstructuredLayout",
    "ValueAcrossSegOrSegGroup",
    "VariableParameter",
    "VoltageClamp",
    "basePyNNCell",
    "basePyNNIaFCell",
    "basePyNNIaFCondCell"
]
