from repoze.what import predicates

from tgext.admin.config import CrudRestControllerConfig
from tgext.admin.tgadminconfig import TGAdminConfig

from tw.forms import SingleSelectField, TextArea
from sprox.formbase import EditableForm, AddRecordForm
from sprox.widgets import PropertyMultipleSelectField
from sprox.dojo.tablebase import DojoTableBase as TableBase
from sprox.dojo.fillerbase import DojoTableFiller as TableFiller

from libacr.model.content import Slice, Page, Content, View, Tag
from libacr import acr_zones
from libacr.views.manager import ViewsManager
from libacr.lib import url
import tw.forms as widgets

def form_factory(template, form_parent):
    return type(template.__name__ + form_parent.__name__, (form_parent,), dict(template.__dict__))

order_values = [0]
order_values.extend(xrange(-10, 0))
order_values.extend(xrange(1, 11))

class EditSliceForm(EditableForm):
    __model__ = Slice
    __omit_fields__ = ['view_uid', 'content_uid', 'page_uid', 'view', 'slice_order', 'content']
    __hide_fields__ = ['uid']
    __dropdown_field_names__ = {'page' : 'title'}
    zone = SingleSelectField('zone', options=zip(acr_zones, acr_zones))

class EditPageForm(EditableForm):
    __model__ = Page
    __omit_fields__ = ['children', 'parent_uid', 'slices']
    __hide_fields__ = ['uid']
    __dropdown_field_names__ = {'page' : 'title'}
    __field_order__ = ['uid', 'parent', 'uri', 'title']
    __require_fields__ = ['uri', 'title']

class EditContentForm(EditableForm):
    __model__ = Content
    __base_widget_args__ = {'attrs':{'target':'_top'}}
    __require_fields__ = ['name']
    __omit_fields__ = ['uid', 'slices', 'all_data']
    data = TextArea('data')

class EditTagForm(EditableForm):
    __model__ = Tag
    __require_fields__ = ['name']
    __omit_fields__ = ['uid']

