libcredit test cases
====================

This directory contains common test cases for all the implementations.
Each test case consists of an input file and an expected output file.

Input files
-----------

The inputs are written in turtle, as that's a bit easier to write than
RDF/XML, and doesn't put a requirement on a full XML parser on the
test environment.

The syntax is described here: http://www.w3.org/TeamSubmission/turtle/


Expected output
---------------

The output is a series of lines representing the different credit
items in a format that can easily be generated by a formatter and
compared meaningfully by a test case (or even diff):

```
title "the title" <sourceURL>
attrib "attribution name" <attribURL>
license "license name" <licenseURL>
```

Only the items actually present will have lines, and if a URL is
missing the last part will be <>.

These lines are used for source works too, but with a prefix:

```
<sourceURL> title "title of the first source" <sourceURL>
<sourceURL> title "title of the second source" <sourceURL>
<sourceURL> <source2URL> title "title of the first source of the second source" <sourceURL>
```

This allows the input and the output to be sorted before they are
compared to avoid issues with the ordering of the items and sources.
