#!/usr/bin/python
# shm, sika hosting manager
# author: Ondrej Sika
#         http://ondrejsika.com
#         dev@ondrejsika.com

import os

from ..utils import name2key

import path
import mysql

def get_object(hosting_name):
    return {
        "domain": hosting_name,
        "sysuser": name2key(hosting_name),
        "base_dir": path.base_dir(hosting_name),
        "www_root": path.www(hosting_name),
        "mysql_user": mysql.username(hosting_name),
    }

def is_exists(hosting_name):
    if os.path.exists(path.base_dir(hosting_name)):
        return True
    return False